"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTestApi = void 0;
const lambda = require("@aws-cdk/aws-lambda");
const api = require("@aws-cdk/aws-apigateway");
const core_1 = require("@aws-solutions-constructs/core");
function CreateTestApi(stack, id) {
    const lamdaFunction = new lambda.Function(stack, `${id}Function`, {
        code: lambda.Code.fromAsset(`${__dirname}/lambda`),
        runtime: lambda.Runtime.NODEJS_14_X,
        handler: ".handler",
    });
    core_1.addCfnSuppressRules(lamdaFunction, [{ id: "W58", reason: "Test Resource" }]);
    core_1.addCfnSuppressRules(lamdaFunction, [{ id: "W89", reason: "Test Resource" }]);
    core_1.addCfnSuppressRules(lamdaFunction, [{ id: "W92", reason: "Test Resource" }]);
    const restApi = new api.LambdaRestApi(stack, `${id}Api`, {
        handler: lamdaFunction,
    });
    const newDeployment = restApi.latestDeployment;
    if (newDeployment) {
        core_1.addCfnSuppressRules(newDeployment, [
            { id: "W68", reason: "Test Resource" },
        ]);
    }
    const newMethod = restApi.methods[0];
    core_1.addCfnSuppressRules(newMethod, [{ id: "W59", reason: "Test Resource" }]);
    const newMethodTwo = restApi.methods[1];
    core_1.addCfnSuppressRules(newMethodTwo, [{ id: "W59", reason: "Test Resource" }]);
    const newStage = restApi.deploymentStage;
    core_1.addCfnSuppressRules(newStage, [{ id: "W64", reason: "Test Resource" }]);
    core_1.addCfnSuppressRules(newStage, [{ id: "W69", reason: "Test Resource" }]);
    return restApi;
}
exports.CreateTestApi = CreateTestApi;
//# sourceMappingURL=data:application/json;base64,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