# igeSdk
igeSdk is a compilation of all necessary third party SDKs in order to make your game ready to be published, which contains Analytics, Advertisement, InAppPurchase and CrossPromotion features.

The current implementation status is as below:
- [x] Analytics : Ready (v0.0.1)
- [x] Advertisement : Ready (v0.0.2)
- [ ] InAppPurchase : WIP (ETA v0.0.3)
- [ ] CrossPromotion : WIP

*The SDK supports **Android** and **iOS** platforms. On unsupported platforms (Windows, Linux, MacOS, ...), it the code still running with dummy functionalities.*

## Configuration and Initialization
To config the SDK, you need to create `igeSdk.config` which is a json file contains settings for different modules.

Configuration for Advertisement, InAppPurchase and CrossPromotion is WIP.

To initialize the SDK, just `import igeSdk` and call `init()` method in your main logic code, like below:
```py
import igeSdk

class GameManager(Script):

    def onStart(self):
        igeSdk.init()
        # Other initialization stuffs
```

The code above will inialize all the enabled modules which are configured in the configuration file.

*Notice, the SDK only initialize modules which have been configured. So, to disable unwanted modules, just remove their settings out of the configuration file.*

## Analytic

The Analytics module is used in order to send informations to the different analytics platforms. We are currently using Facebook, GameAnalytics and AppsFlyer.

To configure Analytics features, put those settings into `igeSdk.config`:
```json
  "android" : {
    "FacebookAppId": "",
    "FacebookClientToken": "",
    "AppsFlyerApiKey": "",
    "AppsFlyerAppId": "",
    "GameAnalyticsGameKey": "",
    "GameAnalyticsSecretKey": "",
  },
  "ios" : {
    "FacebookAppId": "",
    "FacebookClientToken": "",
    "AppsFlyerApiKey": "",
    "AppsFlyerAppId": "",
    "GameAnalyticsGameKey": "",
    "GameAnalyticsSecretKey": "",
  }
}
```

Trackers for Advertisement, InAppPurchase and CrossPromotion modules are sent automatically by the SDK. Game developers should only focus on Progression and Design events to boost their games' performance and revenues, using API below:
```py
import igeSdk
from igeSdk import Analytics

# Level started event: send when player start new level
Analytics.levelStarted(levelName: str)

# Level passed event: send when player successfully passed the level
Analytics.levelPassed(levelName: str, score: int)

# Level failed event: send when player failed the level
Analytics.levelFailed(levelName: str, score: int)

# Custom event: used to track other stuffs like game design events, game states, ...
Analytics.customEvent(eventName: str, eventValue_optional: float)

```

## Advertisement
Advertisement module handles all ad-related operations for you, by implementing AppLovin MAX solution. This module provides methods for Banner, Interstitial and Rewarded Video ads, accessible with `igeSdk.Advertisement` module.

### Configuration
To configure Advertisement features, put those settings into `igeSdk.config`:
```json
{
  "android" : {    
    "Mediation": "MAX",
    "MediationAppId" : "",
    "AdMobAppId" : "",
    "BannerId" : "",
    "InterstitialId" : "",
    "RewardedVideoId" : ""
  },
  "ios" : {
    "Mediation": "",
    "MediationAppId" : "",
    "AdMobAppId" : "",
    "BannerId" : "",
    "InterstitialId" : "",
    "RewardedVideoId" : ""
  }
}
```

### Showing/Hiding Banner Ads
To show/hide banner ads, use methods below:
```py
from igeSdk import Advertisement

Advertisement.showBanner(position: int, callback: Callable[[errCode: int, message: str], None])
Advertisement.hideBanner(callback: Callable[[errCode: int, message: str], None])
```

In which:
- `position`: one of values below:
  - `igeSdk.AdPosition_TopLeft`
  - `igeSdk.AdPosition_TopCenter`
  - `igeSdk.AdPosition_TopRight`
  - `igeSdk.AdPosition_CenterLeft`
  - `igeSdk.AdPosition_Centered`
  - `igeSdk.AdPosition_CenterRight`
  - `igeSdk.AdPosition_BottomLeft`
  - `igeSdk.AdPosition_BottomCenter`
  - `igeSdk.AdPosition_BottomRight`
- `callback`: [Optional] callback function.

### Showing Interstitial Ads
To show interstitial ads, use method below:
```py
from igeSdk import Advertisement

Advertisement.showInterstitial(placement: str, callback: Callable[[errCode: int, message: str], None])
```

In which:
- `placement`: [Optional] placement id as string, default is `'default'`.
- `callback`: [Optional] callback function.

You can also check if interstitial ads is available (to display a button for example), using `Advertisement.isInterstitialAvailable()`.

### Showing Rewarded Video Ads
To show rewarded video ads, use method below:
```py
from igeSdk import Advertisement

Advertisement.showRewardedVideo(placement: str, callback: Callable[[errCode: int, message: str, reward_type: str, reward_amount: float], None])
```

In which:
- `placement`: [Optional] placement id as string, default is `'default'`.
- `callback`: [Optional] callback function.

You can also check if rewarded video ads is available (to display a button for example), using `Advertisement.isRewardedVideoAvailable()`.

## InAppPurchase
WIP - ETA v0.0.3

## CrossPromotion
WIP
