from functools import lru_cache
import re

from tree_plus_src import debug_print

_isabelle_symbols = {
    "zero": "𝟬",
    "one": "𝟭",
    "two": "𝟮",
    "three": "𝟯",
    "four": "𝟰",
    "five": "𝟱",
    "six": "𝟲",
    "seven": "𝟳",
    "eight": "𝟴",
    "nine": "𝟵",
    "A": "𝒜",
    "B": "ℬ",
    "C": "𝒞",
    "D": "𝒟",
    "E": "ℰ",
    "F": "ℱ",
    "G": "𝒢",
    "H": "ℋ",
    "I": "ℐ",
    "J": "𝒥",
    "K": "𝒦",
    "L": "ℒ",
    "M": "ℳ",
    "N": "𝒩",
    "O": "𝒪",
    "P": "𝒫",
    "Q": "𝒬",
    "R": "ℛ",
    "S": "𝒮",
    "T": "𝒯",
    "U": "𝒰",
    "V": "𝒱",
    "W": "𝒲",
    "X": "𝒳",
    "Y": "𝒴",
    "Z": "𝒵",
    "a": "𝖺",
    "b": "𝖻",
    "c": "𝖼",
    "d": "𝖽",
    "e": "𝖾",
    "f": "𝖿",
    "g": "𝗀",
    "h": "𝗁",
    "i": "𝗂",
    "j": "𝗃",
    "k": "𝗄",
    "l": "𝗅",
    "m": "𝗆",
    "n": "𝗇",
    "o": "𝗈",
    "p": "𝗉",
    "q": "𝗊",
    "r": "𝗋",
    "s": "𝗌",
    "t": "𝗍",
    "u": "𝗎",
    "v": "𝗏",
    "w": "𝗐",
    "x": "𝗑",
    "y": "𝗒",
    "z": "𝗓",
    "AA": "𝔄",
    "BB": "𝔅",
    "CC": "ℭ",
    "DD": "𝔇",
    "EE": "𝔈",
    "FF": "𝔉",
    "GG": "𝔊",
    "HH": "ℌ",
    "II": "ℑ",
    "JJ": "𝔍",
    "KK": "𝔎",
    "LL": "𝔏",
    "MM": "𝔐",
    "NN": "𝔑",
    "OO": "𝔒",
    "PP": "𝔓",
    "QQ": "𝔔",
    "RR": "ℜ",
    "SS": "𝔖",
    "TT": "𝔗",
    "UU": "𝔘",
    "VV": "𝔙",
    "WW": "𝔚",
    "XX": "𝔛",
    "YY": "𝔜",
    "ZZ": "ℨ",
    "aa": "𝔞",
    "bb": "𝔟",
    "cc": "𝔠",
    "dd": "𝔡",
    "ee": "𝔢",
    "ff": "𝔣",
    "gg": "𝔤",
    "hh": "𝔥",
    "ii": "𝔦",
    "jj": "𝔧",
    "kk": "𝔨",
    "ll": "𝔩",
    "mm": "𝔪",
    "nn": "𝔫",
    "oo": "𝔬",
    "pp": "𝔭",
    "qq": "𝔮",
    "rr": "𝔯",
    "ss": "𝔰",
    "tt": "𝔱",
    "uu": "𝔲",
    "vv": "𝔳",
    "ww": "𝔴",
    "xx": "𝔵",
    "yy": "𝔶",
    "zz": "𝔷",
    "alpha": "α",
    "beta": "β",
    "gamma": "γ",
    "delta": "δ",
    "epsilon": "ε",
    "zeta": "ζ",
    "eta": "η",
    "theta": "θ",
    "iota": "ι",
    "kappa": "κ",
    "lambda": "λ",
    "mu": "μ",
    "nu": "ν",
    "xi": "ξ",
    "pi": "π",
    "rho": "ρ",
    "sigma": "σ",
    "tau": "τ",
    "upsilon": "υ",
    "phi": "φ",
    "chi": "χ",
    "psi": "ψ",
    "omega": "ω",
    "Gamma": "Γ",
    "Delta": "Δ",
    "Theta": "Θ",
    "Lambda": "Λ",
    "Xi": "Ξ",
    "Pi": "Π",
    "Sigma": "Σ",
    "Upsilon": "Υ",
    "Phi": "Φ",
    "Psi": "Ψ",
    "Omega": "Ω",
    "bbbA": "𝔸",
    "bool": "𝔹",
    "complex": "ℂ",
    "bbbD": "𝔻",
    "bbbE": "𝔼",
    "bbbF": "𝔽",
    "bbbG": "𝔾",
    "bbbH": "ℍ",
    "bbbI": "𝕀",
    "bbbJ": "𝕁",
    "bbbK": "𝕂",
    "bbbL": "𝕃",
    "bbbM": "𝕄",
    "nat": "ℕ",
    "bbbO": "𝕆",
    "bbbP": "ℙ",
    "rat": "ℚ",
    "real": "ℝ",
    "bbbS": "𝕊",
    "bbbT": "𝕋",
    "bbbU": "𝕌",
    "bbbV": "𝕍",
    "bbbW": "𝕎",
    "bbbX": "𝕏",
    "bbbY": "𝕐",
    "int": "ℤ",
    "leftarrow": "←",
    "longleftarrow": "⟵",
    "longlongleftarrow": "⤎",
    "longlonglongleftarrow": "⇠",
    "rightarrow": "→",
    "longrightarrow": "⟶ ",
    "longlongrightarrow": "⤏",
    "longlonglongrightarrow": "⇢",
    "Leftarrow": "⇐",
    "Longleftarrow": "⟸",
    "Lleftarrow": "⇚",
    "Rightarrow": "⇒",
    "Longrightarrow": "⟹ ",
    "Rrightarrow": "⇛",
    "leftrightarrow": "↔",
    "longleftrightarrow": "⟷",
    "Leftrightarrow": "⇔",
    "Longleftrightarrow": "⟺",
    "mapsto": "↦",
    "longmapsto": "⟼",
    "midarrow": "─",
    "Midarrow": "═",
    "hookleftarrow": "↩",
    "hookrightarrow": "↪",
    "leftharpoondown": "↽",
    "rightharpoondown": "⇁",
    "leftharpoonup": "↼",
    "rightharpoonup": "⇀",
    "rightleftharpoons": "⇌",
    "leadsto": "↝",
    "downharpoonleft": "⇃",
    "downharpoonright": "⇂",
    "upharpoonleft": "↿",
    "restriction": "↾",
    "Colon": "∷",
    "up": "↑",
    "Up": "⇑",
    "down": "↓",
    "Down": "⇓",
    "updown": "↕",
    "Updown": "⇕",
    "langle": "⟨",
    "rangle": "⟩",
    "llangle": "⟪",
    "rrangle": "⟫",
    "lceil": "⌈",
    "rceil": "⌉",
    "lfloor": "⌊",
    "rfloor": "⌋",
    "lparr": "⦇",
    "rparr": "⦈",
    "lbrakk": "⟦",
    "rbrakk": "⟧",
    "lbrace": "⦃",
    "rbrace": "⦄",
    "lblot": "⦉",
    "rblot": "⦊",
    "guillemotleft": "«",
    "guillemotright": "»",
    "bottom": "⊥",
    "top": "⊤",
    "and": "∧",
    "And": "⋀",
    "or": "∨",
    "Or": "⋁",
    "forall": "∀",
    "exists": "∃",
    "nexists": "∄",
    "not": "¬",
    "circle": "○",
    "box": "□",
    "diamond": "◇",
    "diamondop": "⋄",
    "turnstile": "⊢",
    "Turnstile": "⊨",
    "tturnstile": "⊩",
    "TTurnstile": "⊫",
    "stileturn": "⊣",
    "surd": "√",
    "le": "≤",
    "ge": "≥",
    "lless": "≪",
    "ggreater": "≫",
    "lesssim": "≲",
    "greatersim": "≳",
    "lessapprox": "⪅",
    "greaterapprox": "⪆",
    "in": "∈",
    "notin": "∉",
    "subset": "⊂",
    "supset": "⊃",
    "subseteq": "⊆",
    "supseteq": "⊇",
    "sqsubset": "⊏",
    "sqsupset": "⊐",
    "sqsubseteq": "⊑",
    "sqsupseteq": "⊒",
    "inter": "∩",
    "Inter": "⋂",
    "union": "∪",
    "Union": "⋃",
    "squnion": "⊔",
    "Squnion": "⨆",
    "sqinter": "⊓",
    "Sqinter": "⨅",
    "setminus": "∖",
    "propto": "∝",
    "uplus": "⊎",
    "Uplus": "⨄",
    "noteq": "≠",
    "sim": "∼",
    "doteq": "≐",
    "simeq": "≃",
    "approx": "≈",
    "asymp": "≍",
    "cong": "≅",
    "smile": "⌣",
    "equiv": "≡",
    "frown": "⌢",
    "Join": "⋈",
    "bowtie": "⨝",
    "prec": "≺",
    "succ": "≻",
    "preceq": "≼",
    "succeq": "≽",
    "parallel": "∥",
    "Parallel": "‖",
    "interleave": "⫴",
    "sslash": "⫽",
    "bar": "¦",
    "bbar": "⫿",
    "plusminus": "±",
    "minusplus": "∓",
    "times": "×",
    "div": "÷",
    "cdot": "⋅",
    "star": "⋆",
    "bullet": "∙",
    "circ": "∘",
    "dagger": "†",
    "ddagger": "‡",
    "lhd": "⊲",
    "rhd": "⊳",
    "unlhd": "⊴",
    "unrhd": "⊵",
    "triangleleft": "◃",
    "triangleright": "▹",
    "triangle": "△",
    "triangleq": "≜",
    "oplus": "⊕",
    "Oplus": "⨁",
    "otimes": "⊗",
    "Otimes": "⨂",
    "odot": "⊙",
    "Odot": "⨀",
    "ominus": "⊖",
    "oslash": "⊘",
    "dots": "…",
    "cdots": "⋯",
    "Sum": "∑",
    "Prod": "∏",
    "Coprod": "∐",
    "infinity": "∞",
    "integral": "∫",
    "ointegral": "∮",
    "clubsuit": "♣",
    "diamondsuit": "♢",
    "heartsuit": "♡",
    "spadesuit": "♠",
    "aleph": "ℵ",
    "emptyset": "∅",
    "nabla": "∇",
    "partial": "∂",
    "flat": "♭",
    "natural": "♮",
    "sharp": "♯",
    "angle": "∠",
    "copyright": "©",
    "registered": "®",
    "hyphen": "‐",
    "inverse": "¯",
    "sqdot": "·",
    "onequarter": "¼",
    "onehalf": "½",
    "threequarters": "¾",
    "ordfeminine": "ª",
    "ordmasculine": "º",
    "section": "§",
    "paragraph": "¶",
    "exclamdown": "¡",
    "questiondown": "¿",
    "euro": "€",
    "pounds": "£",
    "yen": "¥",
    "cent": "¢",
    "currency": "¤",
    "degree": "°",
    "amalg": "⨿",
    "mho": "℧",
    "lozenge": "◊",
    "wp": "℘",
    "wrong": "≀",
    "acute": "´",
    "index": "ı",
    "dieresis": "¨",
    "cedilla": "¸",
    "hungarumlaut": "˝",
    "bind": "⤜",
    "then": "⪢",
    "some": "ϵ",
    "Zcomp": "⨾",
    "Zinj": "↣",
    "Zpinj": "⤔",
    "Zfinj": "⤕",
    "Zsurj": "↠",
    "Zpsurj": "⤀",
    "Zbij": "⤖",
    "Zpfun": "⇸",
    "Zffun": "⇻",
    "Zdres": "◁",
    "Zndres": "⩤",
    "Zrres": "▷",
    "Znrres": "⩥",
    "Zspot": "⦁",
    "Zsemi": "⨟",
    "Zproject": "⨡",
    "Ztypecolon": "⦂",
    "Zhide": "⧹",
    "Zcat": "⁀",
    "Zinbag": "⋿",
    "Zprime": "′",
    "hole": "⌑",
    "newline": "⏎",
    "comment": "―",
    "^cancel": "⌦",
    "^marker": "✐",
    "checkmark": "✓",
    "crossmark": "✗",
    "open": "‹",
    "close": "›",
    "^here": "⌂",
    "^undefined": "❖",
    "^noindent": "⇤",
    "^smallskip": "┈",
    "^medskip": "┉",
    "^bigskip": "━",
    "^item": "▪",
    "^enum": "▸",
    "^descr": "➧",
    "^footnote": "⁋",
    "^verbatim": "▩",
    "^theory_text": "⬚",
    "^emph": "∗",
    "^bold": "❙",
    "^sub": "⇩",
    "^sup": "⇧",
    "^bsub": "⇘",
    "^esub": "⇙",
    "^bsup": "⇗",
    "^esup": "⇖",
    "^file": "🗏",
    "^dir": "🗀",
    "^url": "🌐",
    "^doc": "📓",
    "^action": "☛",
}

_pattern = re.compile(
    r"\\<(" + "|".join(re.escape(key) for key in _isabelle_symbols.keys()) + r")>"
)


@lru_cache
def _replace_symbol(match: re.Match) -> str:
    sense = match.group(1)
    referent = _isabelle_symbols.get(sense, match.group())
    debug_print(f"_replace_isabelle_symbol: '{sense}': '{referent}'")
    return referent


def replace_isabelle_symbols(content: str) -> str:
    return _pattern.sub(_replace_symbol, content)
