#!/usr/bin/env python
# -*- coding: utf-8 -*-
# File: dummylibrarylib.py
#
# Copyright 2021 Jona Vilders
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to
#  deal in the Software without restriction, including without limitation the
#  rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
#  sell copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
#  all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
#  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
#  DEALINGS IN THE SOFTWARE.
#

"""
Main code for dummylibrarylib.

.. _Google Python Style Guide:
   http://google.github.io/styleguide/pyguide.html

"""

import logging

__author__ = '''Jona Vilders <jonavilders@gmail.com>'''
__docformat__ = '''google'''
__date__ = '''27-10-2021'''
__copyright__ = '''Copyright 2021, Jona Vilders'''
__credits__ = ["Jona Vilders"]
__license__ = '''MIT'''
__maintainer__ = '''Jona Vilders'''
__email__ = '''<jonavilders@gmail.com>'''
__status__ = '''Development'''  # "Prototype", "Development", "Production".


# This is the main prefix used for logging
LOGGER_BASENAME = '''dummylibrarylib'''
LOGGER = logging.getLogger(LOGGER_BASENAME)
LOGGER.addHandler(logging.NullHandler())


class WhoAmI:  # pylint: disable=too-few-public-methods
    """Prints who I am."""

    def __init__(self):
        LOGGER.info(f"My name is {__maintainer__}")  # pylint: disable=logging-fstring-interpolation
        self.name = __maintainer__
