# Generated by Django 2.1.4 on 2019-02-06 00:39

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone

import konst.models.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [migrations.swappable_dependency(settings.AUTH_USER_MODEL)]

    operations = [
        migrations.CreateModel(
            name="Comment",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("zendesk_id", models.BigIntegerField(unique=True)),
                ("body", models.TextField(blank=True, null=True)),
                ("public", models.BooleanField()),
                ("created_at", models.DateTimeField()),
            ],
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("raw_data", models.TextField(max_length=1024)),
                (
                    "remote_ticket_id",
                    models.PositiveIntegerField(blank=True, null=True),
                ),
                ("error", models.TextField(blank=True, null=True)),
                ("created_at", models.DateTimeField(default=django.utils.timezone.now)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name="Ticket",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("zendesk_id", models.BigIntegerField(unique=True)),
                ("subject", models.TextField(blank=True, null=True)),
                ("url", models.URLField(blank=True, null=True)),
                (
                    "status",
                    konst.models.fields.ConstantChoiceCharField(
                        choices=[
                            ("new", "new"),
                            ("open", "open"),
                            ("pending", "pending"),
                            ("hold", "hold"),
                            ("solved", "solved"),
                            ("closed", "closed"),
                        ],
                        max_length=8,
                    ),
                ),
                ("custom_fields", models.TextField(blank=True, null=True)),
                ("tags", models.TextField(blank=True, null=True)),
                ("created_at", models.DateTimeField()),
                ("updated_at", models.DateTimeField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="ZendeskUser",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("zendesk_id", models.BigIntegerField(unique=True)),
                ("name", models.TextField(blank=True, null=True)),
                ("email", models.EmailField(blank=True, max_length=254, null=True)),
                ("active", models.BooleanField(default=True)),
                ("photos_json", models.TextField(blank=True, null=True)),
                (
                    "role",
                    konst.models.fields.ConstantChoiceCharField(
                        choices=[
                            ("end-user", "end_user"),
                            ("agent", "agent"),
                            ("admin", "admin"),
                        ],
                        max_length=8,
                    ),
                ),
                ("created_at", models.DateTimeField()),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="ticket",
            name="requester",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="zengo.ZendeskUser"
            ),
        ),
        migrations.AddField(
            model_name="event",
            name="ticket",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="events",
                to="zengo.Ticket",
            ),
        ),
        migrations.AddField(
            model_name="comment",
            name="author",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="zengo.ZendeskUser"
            ),
        ),
        migrations.AddField(
            model_name="comment",
            name="ticket",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="comments",
                to="zengo.Ticket",
            ),
        ),
    ]
