# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/views.ttest.ipynb (unless otherwise specified).

__all__ = ['TTestLandingView', 'TTestLanding', 'IndependentSamplesLanding', 'PairedSamplesLanding',
           'IndependentSamplesEstimates', 'IndependentSamples', 'PairedSamplesEstimates', 'PairedSamples',
           'TTestEstimates', 'TTest']

# Cell
from ..widgets import FloatText, IntText, Text, Grid, AlignedLabel, HTMLMath, Button, GridBox, BoundedFloatText
from ..widget_containers import Box, VBox, HBox
from ..mvc import Controller
from .error_bars import ErrorBars

# Cell
import ipywidgets as ipyw
from traitlets import observe

# Cell
class TTestLandingView(VBox):

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

        style= {'description_width': 'initial'}
        self.label1 = Text(description='Group 1', style=style, layout=ipyw.Layout(width='140px'))
        self.label2 = Text(description='Group 2', style=style, layout=ipyw.Layout(width='140px'))
        self.children = (self.label1, self.label2)

# Cell
class TTestLanding(TTestLandingView, Controller):

    def __init__(self, model, **kwargs):
        super().__init__(**kwargs)
        self.model = model
        self.setLanding()
        self.label1.observe(self.observe_label1, 'value')
        self.label2.observe(self.observe_label2, 'value')

    def setLanding(self):
        self.label1.value = self.model.label1
        self.label2.value = self.model.label2

    def observe_label1(self, change):
        self.model.label1 = change['new']
        return change['new']

    def observe_label2(self, change):
        self.model.label2 = change['new']
        return change['new']

# Cell
class IndependentSamplesLanding(TTestLanding):
    pass

class PairedSamplesLanding(TTestLanding):
    pass

# Cell
class IndependentSamplesEstimates(Box):

    def __init__(self, **kwargs):
        lo = {'justify_content': 'space-between', 'flex_flow': 'row wrap'}
        super().__init__(layout=ipyw.Layout(**lo), **kwargs)


        ''' self.grid '''
        style={'description_width': '35px'}
        self.m1 = FloatText(step=0.01, description=r'$$M_1$$', style=style, layout=ipyw.Layout(width='100px'))
        self.m2 = FloatText(step=0.01,description=r'$$M_2$$', style=style, layout=ipyw.Layout(width='100px'))
        self.sd1 = FloatText(step=0.01,description=r'$$SD_1$$', style=style, layout=ipyw.Layout(width='100px'))
        self.sd2 = FloatText(step=0.01,description=r'$$SD_2$$', style=style, layout=ipyw.Layout(width='100px'))
        self.ratio = FloatText(step=0.01,description=r'$$n_1 / n_2$$', style=style, layout=ipyw.Layout(width='100px'))
        self.m1_label = AlignedLabel(value='Mean', alignment='left')
        self.m2_label = AlignedLabel(value='Mean', alignment='left')
        self.sd1_label = AlignedLabel(value='Standard Deviation', alignment='left')
        self.sd2_label = AlignedLabel(value='Standard Deviation', alignment='left')
        self.ratio_label = AlignedLabel(value='Allocation Ratio', alignment='left')

        self.grid = Grid(6, 2, layout=ipyw.Layout(grid_template_columns='112px auto'))
        self.grid.layout.margin = '0 0 25px 0'
        self.grid[0, 0] = AlignedLabel(value='Estimate', alignment='left')
        self.grid[0, 1] = AlignedLabel(value='Parameter', alignment='left')
        self.grid[1,0] = self.m1
        self.grid[2,0] = self.m2
        self.grid[3,0] = self.sd1
        self.grid[4,0] = self.sd2
        self.grid[5,0] = self.ratio
        self.grid[1, 1] = self.m1_label
        self.grid[2, 1] = self.m2_label
        self.grid[3, 1] = self.sd1_label
        self.grid[4, 1] = self.sd2_label
        self.grid[5, 1] = self.ratio_label

        d_label = HTMLMath(value=r'$$\frac{M_1 - M_2}{\sqrt{\frac{ratio*SD_1^2 + SD_2^2}{ratio+1}}}=d=$$', layout=ipyw.Layout(margin='5'))
        self.d = Button(disabled=True, layout=ipyw.Layout(width='65px'))
        box_layout = {'justify_content': 'flex-end'}
        self.d_box = HBox(children=(d_label, self.d), layout=ipyw.Layout(**box_layout))

        self.N = IntText(description='N', style=style, layout=ipyw.Layout(width='100px'))
        self.N_box = HBox(children=(self.N, ), layout=ipyw.Layout(**box_layout))


        self.left = GridBox(children=(self.grid, self.d_box, self.N_box))
        #self.left.layout.grid_gap='5px 10px'
        self.children = (self.left, )

# Cell
class IndependentSamples(IndependentSamplesEstimates, Controller):

    def __init__(self, model, **kwargs):
        super().__init__(**kwargs)

        self.model = model
        self.setEstimates()

        self.errBars = ErrorBars(self.model.errBars)
        self.children += (self.errBars, )

        self.grid.layout.grid_template_columns = '114px auto'
        self.m1.observe(self.observe_m1, 'value')
        self.m2.observe(self.observe_m2, 'value')
        self.sd1.observe(self.observe_sd1, 'value')
        self.sd2.observe(self.observe_sd2, 'value')
        self.ratio.observe(self.observe_ratio, 'value')
        self.N.observe(self.observe_N, 'value')

    def setEstimates(self):
        self.m1.value = self.model.m1
        self.m2.value = self.model.m2
        self.sd1.value = self.model.sd1
        self.sd2.value = self.model.sd2
        self.ratio.value = self.model.ratio
        self.d.description = str(round(self.model.d, 2))
        self.m1_label.value = 'Mean (' + self.model.label1 + ')'
        self.m2_label.value = 'Mean (' + self.model.label2 + ')'
        self.sd1_label.value = 'Standard Deviation (' + self.model.label1 + ')'
        self.sd2_label.value = 'Standard Deviation (' + self.model.label2 + ')'
        self.set_ratio_label()
        self.N.value = self.model.N

    def observe_m1(self, change):
        self.model.m1 = change['new']
        self.d.description = str(round(self.model.d, 2))
        self.errBars.setHeight(0, change['new'])
        return change['new']

    def observe_m2(self, change):
        self.model.m2 = change['new']
        self.d.description = str(round(self.model.d, 2))
        self.errBars.setHeight(1 , change['new'])
        return change['new']

    def observe_sd1(self, change):
        self.model.sd1 = change['new']
        self.d.description = str(round(self.model.d, 2))
        self.errBars.setError(0 , change['new'])
        return change['new']

    def observe_sd2(self, change):
        self.model.sd2 = change['new']
        self.d.description = str(round(self.model.d, 2))
        self.errBars.setError(1 , change['new'])
        return change['new']

    def observe_ratio(self, change):
        self.model.ratio = change['new']
        self.d.description = str(round(self.model.d, 2))
        self.set_ratio_label()
        return change['new']

    def observe_N(self, change):
        self.model.N = change['new']
        return change['new']

    def set_ratio_label(self):
        self.ratio_label.value = 'Allocation Ratio\n (' + self.model.label1 + ': ' + str(self.model.n1) + ', ' \
            +  self.model.label2 + ': ' + str(self.model.n2) + ')'

# Cell
class PairedSamplesEstimates(Box):

    def __init__(self, **kwargs):
        lo = {'justify_content': 'space-between', 'flex_flow': 'row wrap'}
        super().__init__(layout=ipyw.Layout(**lo), **kwargs)


        ''' self.grid '''
        style={'description_width': '35px'}
        self.m1 = FloatText(step=0.01, description=r'$$M_1$$', style=style, layout=ipyw.Layout(width='100px'))
        self.m2 = FloatText(step=0.01,description=r'$$M_2$$', style=style, layout=ipyw.Layout(width='100px'))
        self.sd1 = FloatText(step=0.01,description=r'$$SD_1$$', style=style, layout=ipyw.Layout(width='100px'))
        self.sd2 = FloatText(step=0.01,description=r'$$SD_2$$', style=style, layout=ipyw.Layout(width='100px'))
        self.r = BoundedFloatText(min=-.99, max=.99, step=0.01,description=r'$$r$$', style=style, layout=ipyw.Layout(width='100px'))
        self.m1_label = AlignedLabel(value='Mean', alignment='left')
        self.m2_label = AlignedLabel(value='Mean', alignment='left')
        self.sd1_label = AlignedLabel(value='Standard Deviation', alignment='left')
        self.sd2_label = AlignedLabel(value='Standard Deviation', alignment='left')
        self.r_label = AlignedLabel(value='Correlation', alignment='left')

        self.grid = Grid(6, 2, layout=ipyw.Layout(grid_template_columns='112px auto'))
        self.grid.layout.margin = '0 0 25px 0'
        self.grid[0, 0] = AlignedLabel(value='Estimate', alignment='left')
        self.grid[0, 1] = AlignedLabel(value='Parameter', alignment='left')
        self.grid[1,0] = self.m1
        self.grid[2,0] = self.m2
        self.grid[3,0] = self.sd1
        self.grid[4,0] = self.sd2
        self.grid[5,0] = self.r
        self.grid[1, 1] = self.m1_label
        self.grid[2, 1] = self.m2_label
        self.grid[3, 1] = self.sd1_label
        self.grid[4, 1] = self.sd2_label
        self.grid[5, 1] = self.r_label

        d_label = HTMLMath(value=r'$$\frac{M_1 – M_2}{\sqrt{SD_1^2 +SD_2^2 – 2*SD_1*SD_2*r}}=d=$$', layout=ipyw.Layout(margin='5'))
        self.d = Button(disabled=True, layout=ipyw.Layout(width='65px', height='28px'))
        box_layout = {'justify_content': 'flex-end'}
        self.d_box = HBox(children=(d_label, self.d), layout=ipyw.Layout(**box_layout))

        self.N = IntText(description='N', style=style, layout=ipyw.Layout(width='100px'))
        self.N_box = HBox(children=(self.N, ), layout=ipyw.Layout(**box_layout))


        self.left = GridBox(children=(self.grid, self.d_box, self.N_box))
        self.children = (self.left, )

# Cell
class PairedSamples(PairedSamplesEstimates, Controller):

    def __init__(self, model, **kwargs):
        super().__init__(**kwargs)

        self.model = model
        self.setEstimates()

        self.errBars = ErrorBars(self.model.errBars)
        self.children += (self.errBars, )

        self.grid.layout.grid_template_columns = '114px auto'
        self.m1.observe(self.observe_m1, 'value')
        self.m2.observe(self.observe_m2, 'value')
        self.sd1.observe(self.observe_sd1, 'value')
        self.sd2.observe(self.observe_sd2, 'value')
        self.r.observe(self.observe_r, 'value')
        self.N.observe(self.observe_N, 'value')

    def setEstimates(self):
        self.m1.value = self.model.m1
        self.m2.value = self.model.m2
        self.sd1.value = self.model.sd1
        self.sd2.value = self.model.sd2
        self.r.value = self.model.r
        self.d.description = str(round(self.model.d, 2))
        self.m1_label.value = 'Mean (' + self.model.label1 + ')'
        self.m2_label.value = 'Mean (' + self.model.label2 + ')'
        self.sd1_label.value = 'Standard Deviation (' + self.model.label1 + ')'
        self.sd2_label.value = 'Standard Deviation (' + self.model.label2 + ')'
        self.N.value = self.model.N

    def observe_m1(self, change):
        self.model.m1 = change['new']
        self.d.description = str(round(self.model.d, 2))
        self.errBars.setHeight(0 , change['new'])
        return change['new']

    def observe_m2(self, change):
        self.model.m2 = change['new']
        self.d.description = str(round(self.model.d, 2))
        self.errBars.setHeight(1 , change['new'])
        return change['new']

    def observe_sd1(self, change):
        self.model.sd1 = change['new']
        self.d.description = str(round(self.model.d, 2))
        self.errBars.setError(0 , change['new'])
        return change['new']

    def observe_sd2(self, change):
        self.model.sd2 = change['new']
        self.d.description = str(round(self.model.d, 2))
        self.errBars.setError(1 , change['new'])
        return change['new']

    def observe_r(self, change):
        self.model.r = change['new']
        self.d.description = str(round(self.model.d, 2))
        return change['new']

    def observe_N(self, change):
        self.model.N = change['new']
        return change['new']

# Cell
class TTestEstimates(Box):

    def __init__(self, **kwargs):
        lo = {'justify_content': 'space-between', 'flex_flow': 'row wrap'}
        super().__init__(layout=ipyw.Layout(**lo), **kwargs)

        ''' self.grid '''
        style={'description_width': '35px'}
        self.m = FloatText(description=' ', step=0.01, style=style, layout=ipyw.Layout(width='100px'))
        self.sd = FloatText(description='$$SD$$', step=0.01, style=style, layout=ipyw.Layout(width='100px'))
        self.m_label = AlignedLabel(alignment='left')
        self.sd_label = AlignedLabel(value='Standard Deviation', alignment='left')

        self.grid = Grid(3, 2, layout=ipyw.Layout(grid_template_columns='112px auto'))
        self.grid.layout.margin = '0 0 25px 0'
        self.grid[0, 0] = AlignedLabel(value='Estimate', alignment='left')
        self.grid[0, 1] = AlignedLabel(value='Parameter', alignment='left')
        self.grid[1, 0] = self.m
        self.grid[1, 1] = self.m_label
        self.grid[2, 0] = self.sd
        self.grid[2, 1] = self.sd_label

        d_label = HTMLMath(value=r'$$\frac{M}{SD}=d=$$', layout=ipyw.Layout(margin='5'))
        self.d = Button(disabled=True, layout=ipyw.Layout(width='65px', height='28px'))
        box_layout = {'justify_content': 'flex-end'}
        self.d_box = HBox(children=(d_label, self.d), layout=ipyw.Layout(**box_layout))

        self.N = IntText(description='N', style=style, layout=ipyw.Layout(width='100px'))
        self.N_box = HBox(children=(self.N, ), layout=ipyw.Layout(**box_layout))

        self.left = GridBox(children=(self.grid, self.d_box, self.N_box))
        self.children = (self.left, )

# Cell
class TTest(TTestEstimates, Controller):

    def __init__(self, model, **kwargs):
        super().__init__(**kwargs)

        self.model = model

        self.errBars = ErrorBars(self.model.errBars)
        self.children += (self.errBars, )

        self.grid.layout.grid_template_columns = '114px auto'
        self.m.observe(self.observe_m, 'value')
        self.sd.observe(self.observe_sd, 'value')
        self.N.observe(self.observe_N, 'value')

        self.setEstimates()

    def setEstimates(self):
        self.m.value = self.model.m
        self.sd.value = self.model.sd
        self.d.description = str(round(self.model.d, 2))
        self.N.value = self.model.N

    def observe_m(self, change):
        self.model.m = change['new']
        self.d.description = str(round(self.model.d, 2))
        self.errBars.setHeight(0, change['new'])
        return change['new']

    def observe_sd(self, change):
        self.model.sd = change['new']
        self.d.description = str(round(self.model.d, 2))
        self.errBars.setError(0, change['new'])
        return change['new']

    def observe_N(self, change):
        self.model.N = change['new']
        return change['new']