/*
 * Decompiled with CFR 0.152.
 */
package viper.silicon.decider;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcZJ$sp;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.util.matching.Regex;
import viper.silicon.Config;
import viper.silicon.Config$AssertionMode$PushPop$;
import viper.silicon.Config$AssertionMode$SoftConstraints$;
import viper.silicon.common.config.package;
import viper.silicon.decider.TermToSMTLib2Converter;
import viper.silicon.interfaces.decider.Prover;
import viper.silicon.interfaces.decider.ProverLike;
import viper.silicon.interfaces.decider.Result;
import viper.silicon.interfaces.decider.Sat$;
import viper.silicon.interfaces.decider.Unknown$;
import viper.silicon.interfaces.decider.Unsat$;
import viper.silicon.package$;
import viper.silicon.reporting.ExternalToolError;
import viper.silicon.reporting.Z3InteractionFailed;
import viper.silicon.state.Identifier;
import viper.silicon.state.IdentifierFactory;
import viper.silicon.state.terms.Decl;
import viper.silicon.state.terms.Fun;
import viper.silicon.state.terms.Fun$;
import viper.silicon.state.terms.Function;
import viper.silicon.state.terms.FunctionDecl;
import viper.silicon.state.terms.Sort;
import viper.silicon.state.terms.Term;
import viper.silicon.state.terms.sorts$Bool$;
import viper.silicon.verifier.Verifier$;
import viper.silver.plugin.PluginAwareReporter;
import viper.silver.reporter.ConfigurationConfirmation;
import viper.silver.reporter.InternalWarningMessage;
import viper.silver.utility.Common$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\rua\u0001B\u0001\u0003\u0001%\u0011QBW\u001aQe>4XM]*uI&{%BA\u0002\u0005\u0003\u001d!WmY5eKJT!!\u0002\u0004\u0002\u000fMLG.[2p]*\tq!A\u0003wSB,'o\u0001\u0001\u0014\t\u0001Q\u0001c\u0006\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E)R\"\u0001\n\u000b\u0005\r\u0019\"B\u0001\u000b\u0005\u0003)Ig\u000e^3sM\u0006\u001cWm]\u0005\u0003-I\u0011a\u0001\u0015:pm\u0016\u0014\bC\u0001\r \u001b\u0005I\"B\u0001\u000e\u001c\u00031\u00198-\u00197bY><w-\u001b8h\u0015\taR$\u0001\u0005usB,7/\u00194f\u0015\u0005q\u0012aA2p[&\u0011\u0001%\u0007\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\r\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003!)h.[9vK&#\u0007C\u0001\u0013,\u001d\t)\u0013\u0006\u0005\u0002'\u00195\tqE\u0003\u0002)\u0011\u00051AH]8pizJ!A\u000b\u0007\u0002\rA\u0013X\rZ3g\u0013\taSF\u0001\u0004TiJLgn\u001a\u0006\u0003U1A\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\u000ei\u0016\u0014XnQ8om\u0016\u0014H/\u001a:\u0011\u0005E\u0012T\"\u0001\u0002\n\u0005M\u0012!A\u0006+fe6$vnU'U\u0019&\u0014'gQ8om\u0016\u0014H/\u001a:\t\u0011U\u0002!\u0011!Q\u0001\nY\n\u0011#\u001b3f]RLg-[3s\r\u0006\u001cGo\u001c:z!\t9$(D\u00019\u0015\tID!A\u0003ti\u0006$X-\u0003\u0002<q\t\t\u0012\nZ3oi&4\u0017.\u001a:GC\u000e$xN]=\t\u0011u\u0002!\u0011!Q\u0001\ny\n\u0001B]3q_J$XM\u001d\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000ba\u0001\u001d7vO&t'BA\"\u0007\u0003\u0019\u0019\u0018\u000e\u001c<fe&\u0011Q\t\u0011\u0002\u0014!2,x-\u001b8Bo\u0006\u0014XMU3q_J$XM\u001d\u0005\u0006\u000f\u0002!\t\u0001S\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b%S5\nT'\u0011\u0005E\u0002\u0001\"\u0002\u0012G\u0001\u0004\u0019\u0003\"B\u0018G\u0001\u0004\u0001\u0004\"B\u001bG\u0001\u00041\u0004\"B\u001fG\u0001\u0004q\u0004bB(\u0001\u0001\u0004%I\u0001U\u0001\u0012aV\u001c\b\u000eU8q'\u000e|\u0007/\u001a#faRDW#A)\u0011\u0005-\u0011\u0016BA*\r\u0005\rIe\u000e\u001e\u0005\b+\u0002\u0001\r\u0011\"\u0003W\u0003U\u0001Xo\u001d5Q_B\u001c6m\u001c9f\t\u0016\u0004H\u000f[0%KF$\"a\u0016.\u0011\u0005-A\u0016BA-\r\u0005\u0011)f.\u001b;\t\u000fm#\u0016\u0011!a\u0001#\u0006\u0019\u0001\u0010J\u0019\t\ru\u0003\u0001\u0015)\u0003R\u0003I\u0001Xo\u001d5Q_B\u001c6m\u001c9f\t\u0016\u0004H\u000f\u001b\u0011\t\u000f}\u0003\u0001\u0019!C\u0005!\u0006YA.Y:u)&lWm\\;u\u0011\u001d\t\u0007\u00011A\u0005\n\t\fq\u0002\\1tiRKW.Z8vi~#S-\u001d\u000b\u0003/\u000eDqa\u00171\u0002\u0002\u0003\u0007\u0011\u000b\u0003\u0004f\u0001\u0001\u0006K!U\u0001\rY\u0006\u001cH\u000fV5nK>,H\u000f\t\u0005\nO\u0002\u0001\r\u00111A\u0005\n!\fQ\u0002\\8hM&dWm\u0016:ji\u0016\u0014X#A5\u0011\u0005)|W\"A6\u000b\u00051l\u0017AA5p\u0015\u0005q\u0017\u0001\u00026bm\u0006L!\u0001]6\u0003\u0017A\u0013\u0018N\u001c;Xe&$XM\u001d\u0005\ne\u0002\u0001\r\u00111A\u0005\nM\f\u0011\u0003\\8hM&dWm\u0016:ji\u0016\u0014x\fJ3r)\t9F\u000fC\u0004\\c\u0006\u0005\t\u0019A5\t\u0013Y\u0004\u0001\u0019!A!B\u0013I\u0017A\u00047pO\u001aLG.Z,sSR,'\u000f\t\u0005\nq\u0002\u0001\r\u00111A\u0005\ne\f!A_\u001a\u0016\u0003i\u0004\"a\u001f@\u000e\u0003qT!!`7\u0002\t1\fgnZ\u0005\u0003\u007fr\u0014q\u0001\u0015:pG\u0016\u001c8\u000fC\u0006\u0002\u0004\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0011A\u0002>4?\u0012*\u0017\u000fF\u0002X\u0003\u000fA\u0001bWA\u0001\u0003\u0003\u0005\rA\u001f\u0005\u000b\u0003\u0017\u0001\u0001\u0019!A!B\u0013Q\u0018a\u0001>4A!Y\u0011q\u0002\u0001A\u0002\u0003\u0007I\u0011BA\t\u0003\u0015Ig\u000e];u+\t\t\u0019\u0002E\u0002k\u0003+I1!a\u0006l\u00059\u0011UO\u001a4fe\u0016$'+Z1eKJD1\"a\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001e\u0005I\u0011N\u001c9vi~#S-\u001d\u000b\u0004/\u0006}\u0001\"C.\u0002\u001a\u0005\u0005\t\u0019AA\n\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0005\u0002\r%t\u0007/\u001e;!\u0011)\t9\u0003\u0001a\u0001\u0002\u0004%I\u0001[\u0001\u0007_V$\b/\u001e;\t\u0017\u0005-\u0002\u00011AA\u0002\u0013%\u0011QF\u0001\u000b_V$\b/\u001e;`I\u0015\fHcA,\u00020!A1,!\u000b\u0002\u0002\u0003\u0007\u0011\u000e\u0003\u0006\u00024\u0001\u0001\r\u0011!Q!\n%\fqa\\;uaV$\b\u0005C\u0006\u00028\u0001\u0001\r\u00111A\u0005\u0002\u0005e\u0012A\u0002>4!\u0006$\b.\u0006\u0002\u0002<A!\u0011QHA$\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001\u00024jY\u0016T1!!\u0012n\u0003\rq\u0017n\\\u0005\u0005\u0003\u0013\nyD\u0001\u0003QCRD\u0007bCA'\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u001f\n!B_\u001aQCRDw\fJ3r)\r9\u0016\u0011\u000b\u0005\n7\u0006-\u0013\u0011!a\u0001\u0003wA1\"!\u0016\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002<\u00059!p\r)bi\"\u0004\u0003\"CA-\u0001\u0001\u0007I\u0011AA.\u0003%a\u0017m\u001d;N_\u0012,G.F\u0001$\u0011%\ty\u0006\u0001a\u0001\n\u0003\t\t'A\u0007mCN$Xj\u001c3fY~#S-\u001d\u000b\u0004/\u0006\r\u0004\u0002C.\u0002^\u0005\u0005\t\u0019A\u0012\t\u000f\u0005\u001d\u0004\u0001)Q\u0005G\u0005QA.Y:u\u001b>$W\r\u001c\u0011\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n\u0005I!p\r,feNLwN\u001c\u000b\u0003\u0003_\u0002B!!\u001d\u0002\u0010:!\u00111OAE\u001d\u0011\t)(a!\u000f\t\u0005]\u0014q\u0010\b\u0005\u0003s\niHD\u0002'\u0003wJ\u0011aB\u0005\u0003\u000b\u0019I1!!!\u0005\u0003\u0019\u0019w.\\7p]&!\u0011QQAD\u0003\u0019\u0019wN\u001c4jO*\u0019\u0011\u0011\u0011\u0003\n\t\u0005-\u0015QR\u0001\ba\u0006\u001c7.Y4f\u0015\u0011\t))a\"\n\t\u0005E\u00151\u0013\u0002\b-\u0016\u00148/[8o\u0015\u0011\tY)!$\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\u0006)1\u000f^1siR\tq\u000bC\u0004\u0002\u001e\u0002!I!a(\u0002!\r\u0014X-\u0019;f5NJen\u001d;b]\u000e,G#\u0001>\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002\u001a\u0006)!/Z:fi\"9\u0011q\u0015\u0001\u0005\u0002\u0005e\u0015\u0001B:u_BDq!a+\u0001\t\u0003\ti+\u0001\u0003qkNDGcA,\u00020\"I\u0011\u0011WAU!\u0003\u0005\r!U\u0001\u0002]\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0016a\u00019paR\u0019q+!/\t\u0013\u0005E\u00161\u0017I\u0001\u0002\u0004\t\u0006bBA_\u0001\u0011\u0005\u0011qX\u0001\u0005K6LG\u000fF\u0002X\u0003\u0003Dq!a1\u0002<\u0002\u00071%A\u0004d_:$XM\u001c;\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002J\u00061\u0011m]:v[\u0016$2aVAf\u0011!\ti-!2A\u0002\u0005=\u0017\u0001\u0002;fe6\u0004B!!5\u0002X6\u0011\u00111\u001b\u0006\u0004\u0003+D\u0014!\u0002;fe6\u001c\u0018\u0002BAm\u0003'\u0014A\u0001V3s[\"9\u0011q\u0019\u0001\u0005\u0002\u0005uGcA,\u0002`\"9\u0011QZAn\u0001\u0004\u0019\u0003bBAr\u0001\u0011\u0005\u0011Q]\u0001\u0007CN\u001cXM\u001d;\u0015\r\u0005\u001d\u0018Q^Ay!\rY\u0011\u0011^\u0005\u0004\u0003Wd!a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003_\f\t\u000f1\u0001\u0002P\u0006!qm\\1m\u0011)\t\u00190!9\u0011\u0002\u0003\u0007\u0011Q_\u0001\bi&lWm\\;u!\u0011Y\u0011q_)\n\u0007\u0005eHB\u0001\u0004PaRLwN\u001c\u0005\b\u0003G\u0004A\u0011AA\u007f)\u0019\t9/a@\u0003\u0002!9\u0011q^A~\u0001\u0004\u0019\u0003\u0002CAz\u0003w\u0004\r!!>\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b\u0005\u0011\u0012m]:feR,6/\u001b8h!V\u001c\b\u000eU8q)\u0011\u0011IA!\u0006\u0011\u000f-\u0011Y!a:\u0003\u0010%\u0019!Q\u0002\u0007\u0003\rQ+\b\u000f\\33!\rY!\u0011C\u0005\u0004\u0005'a!\u0001\u0002'p]\u001eDq!a<\u0003\u0004\u0001\u00071\u0005C\u0004\u0003\u001a\u0001!\tAa\u0007\u0002\u0011M\fG/\u001e:bi\u0016$2a\u0016B\u000f\u0011!\u0011yBa\u0006A\u0002\t\u0005\u0012\u0001\u00023bi\u0006\u0004RaCA|\u0005G\u0001BA!\n\u0003.9!!q\u0005B\u0015\u001b\u0005!\u0011b\u0001B\u0016\t\u000511i\u001c8gS\u001eLAAa\f\u00032\tA\"lM*uCR,7+\u0019;ve\u0006$\u0018n\u001c8US6,w.\u001e;\u000b\u0007\t-B\u0001C\u0004\u0003\u001a\u0001!\tA!\u000e\u0015\u000b]\u00139D!\u000f\t\u000f\u0005M(1\u0007a\u0001#\"9!1\bB\u001a\u0001\u0004\u0019\u0013aB2p[6,g\u000e\u001e\u0005\b\u0005\u007f\u0001A\u0011BAM\u0003!9W\r^'pI\u0016d\u0007b\u0002B\"\u0001\u0011%!QI\u0001\u001bCN\u001cXM\u001d;Vg&twmU8gi\u000e{gn\u001d;sC&tGo\u001d\u000b\u0005\u0005\u0013\u00119\u0005C\u0004\u0002p\n\u0005\u0003\u0019A\u0012\t\u000f\t-\u0003\u0001\"\u0001\u0003N\u0005)1\r[3dWR!!q\nB+!\r\t\"\u0011K\u0005\u0004\u0005'\u0012\"A\u0002*fgVdG\u000f\u0003\u0006\u0002t\n%\u0003\u0013!a\u0001\u0003kDqA!\u0017\u0001\t\u0013\u0011Y&\u0001\u0006tKR$\u0016.\\3pkR$2a\u0016B/\u0011!\t\u0019Pa\u0016A\u0002\u0005U\bb\u0002B1\u0001\u0011\u0005!1M\u0001\u000bgR\fG/[:uS\u000e\u001cHC\u0001B3!\u0019\u00119Ga\u001b$G9!\u0011q\u000fB5\u0013\r\tY\tB\u0005\u0005\u0005[\u0012yGA\u0002NCBT1!a#\u0005\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0005g\"2a\u0016B;\u0011\u001d\u00119H!\u001dA\u0002\r\n1a\u001d;s\u0011\u001d\u0011Y\b\u0001C\u0001\u0005{\nQA\u001a:fg\"$\u0002Ba \u0003\u0006\n%%1\u0015\t\u0005\u0003#\u0014\t)\u0003\u0003\u0003\u0004\u0006M'a\u0001$v]\"9!q\u0011B=\u0001\u0004\u0019\u0013\u0001\u00028b[\u0016D\u0001Ba#\u0003z\u0001\u0007!QR\u0001\tCJ<7k\u001c:ugB1!q\u0012BL\u0005;sAA!%\u0003\u0016:\u0019aEa%\n\u00035I1!a#\r\u0013\u0011\u0011IJa'\u0003\u0007M+\u0017OC\u0002\u0002\f2\u0001B!!5\u0003 &!!\u0011UAj\u0005\u0011\u0019vN\u001d;\t\u0011\t\u0015&\u0011\u0010a\u0001\u0005;\u000b!B]3tk2$8k\u001c:u\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005W\u000bq\u0001Z3dY\u0006\u0014X\rF\u0002X\u0005[C\u0001Ba,\u0003(\u0002\u0007!\u0011W\u0001\u0005I\u0016\u001cG\u000e\u0005\u0003\u0002R\nM\u0016\u0002\u0002B[\u0003'\u0014A\u0001R3dY\"9!\u0011\u0018\u0001\u0005\n\u0005e\u0015a\u0003:fC\u0012\u001cVoY2fgNDqA!0\u0001\t\u0013\u0011y,A\u0005sK\u0006$WK\\:biR\u0011\u0011q\u001d\u0005\b\u0005\u0007\u0004A\u0011\u0002Bc\u0003%\u0011X-\u00193N_\u0012,G\u000eF\u0002$\u0005\u000fD\u0011B!3\u0003BB\u0005\t\u0019A\u0012\u0002\u0013M,\u0007/\u0019:bi>\u0014\bb\u0002Bg\u0001\u0011%!qZ\u0001\te\u0016\fG\rT5oKR\t1\u0005C\u0004\u0003T\u0002!IA!6\u0002\u00131|w\rV8GS2,GcA,\u0003X\"9!q\u000fBi\u0001\u0004\u0019\u0003b\u0002Bn\u0001\u0011%!Q\\\u0001\noJLG/\u001a'j]\u0016$2a\u0016Bp\u0011\u001d\u0011\tO!7A\u0002\r\n1a\\;u\u0011\u001d\u0011)\u000f\u0001C!\u0005\u001f\fAbZ3u\u0019\u0006\u001cH/T8eK2DqA!;\u0001\t\u0003\nI*\u0001\bdY\u0016\f'\u000fT1ti6{G-\u001a7\t\u0013\t5\b!%A\u0005\u0002\t=\u0018A\u00049vg\"$C-\u001a4bk2$H%M\u000b\u0003\u0005cT3!\u0015BzW\t\u0011)\u0010\u0005\u0003\u0003x\u000e\u0005QB\u0001B}\u0015\u0011\u0011YP!@\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0000\u0019\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\r!\u0011 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CB\u0004\u0001E\u0005I\u0011\u0001Bx\u00035\u0001x\u000e\u001d\u0013eK\u001a\fW\u000f\u001c;%c!I11\u0002\u0001\u0012\u0002\u0013\u00053QB\u0001\u0011CN\u001cXM\u001d;%I\u00164\u0017-\u001e7uII*\"aa\u0004+\t\u0005U(1\u001f\u0005\n\u0007'\u0001\u0011\u0013!C\u0005\u0007+\t1C]3bI6{G-\u001a7%I\u00164\u0017-\u001e7uIE*\"aa\u0006+\u0007\r\u0012\u0019\u0010C\u0005\u0004\u001c\u0001\t\n\u0011\"\u0011\u0004\u000e\u0005y1\r[3dW\u0012\"WMZ1vYR$\u0013\u0007")
public class Z3ProverStdIO
implements Prover,
LazyLogging {
    private final String uniqueId;
    private final TermToSMTLib2Converter termConverter;
    private final IdentifierFactory identifierFactory;
    private final PluginAwareReporter reporter;
    private int pushPopScopeDepth;
    private int lastTimeout;
    private PrintWriter logfileWriter;
    private Process z3;
    private BufferedReader input;
    private PrintWriter output;
    private Path z3Path;
    private String lastModel;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void emit(Iterable<String> contents) {
        ProverLike.emit$(this, contents);
    }

    private Logger logger$lzycompute() {
        Z3ProverStdIO z3ProverStdIO = this;
        synchronized (z3ProverStdIO) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private int pushPopScopeDepth() {
        return this.pushPopScopeDepth;
    }

    private void pushPopScopeDepth_$eq(int x$1) {
        this.pushPopScopeDepth = x$1;
    }

    private int lastTimeout() {
        return this.lastTimeout;
    }

    private void lastTimeout_$eq(int x$1) {
        this.lastTimeout = x$1;
    }

    private PrintWriter logfileWriter() {
        return this.logfileWriter;
    }

    private void logfileWriter_$eq(PrintWriter x$1) {
        this.logfileWriter = x$1;
    }

    private Process z3() {
        return this.z3;
    }

    private void z3_$eq(Process x$1) {
        this.z3 = x$1;
    }

    private BufferedReader input() {
        return this.input;
    }

    private void input_$eq(BufferedReader x$1) {
        this.input = x$1;
    }

    private PrintWriter output() {
        return this.output;
    }

    private void output_$eq(PrintWriter x$1) {
        this.output = x$1;
    }

    public Path z3Path() {
        return this.z3Path;
    }

    public void z3Path_$eq(Path x$1) {
        this.z3Path = x$1;
    }

    public String lastModel() {
        return this.lastModel;
    }

    public void lastModel_$eq(String x$1) {
        this.lastModel = x$1;
    }

    public package.Version z3Version() {
        Regex versionPattern = new StringOps(Predef$.MODULE$.augmentString("\\(?\\s*:version\\s+\"(.*?)(?:\\s*-.*?)?\"\\)?")).r();
        String line = "";
        this.writeLine("(get-info :version)");
        line = this.input().readLine();
        this.comment(line);
        String string = line;
        Option<List<String>> option = versionPattern.unapplySeq(string);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
            throw new Z3InteractionFailed(this.uniqueId, new java.lang.StringBuilder(47).append("Unexpected output of Z3 while getting version: ").append(line).toString());
        }
        String v = (String)((LinearSeqOptimized)option.get()).apply(0);
        package.Version version = new package.Version(v);
        return version;
    }

    @Override
    public void start() {
        this.pushPopScopeDepth_$eq(0);
        this.lastTimeout_$eq(-1);
        this.logfileWriter_$eq(Common$.MODULE$.PrintWriter(Verifier$.MODULE$.config().z3LogFile(this.uniqueId).toFile(), Common$.MODULE$.PrintWriter$default$2(), Common$.MODULE$.PrintWriter$default$3()));
        this.z3Path_$eq(Paths.get(Verifier$.MODULE$.config().z3Exe(), new String[0]));
        this.z3_$eq(this.createZ3Instance());
        this.input_$eq(new BufferedReader(new InputStreamReader(this.z3().getInputStream())));
        this.output_$eq(new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.z3().getOutputStream())), true));
    }

    private Process createZ3Instance() {
        String[] stringArray;
        BoxedUnit boxedUnit;
        String msg = new java.lang.StringBuilder(26).append("Starting Z3 at location '").append(this.z3Path()).append("'").toString();
        this.reporter.report(new ConfigurationConfirmation(msg));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(msg);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        File z3File = this.z3Path().toFile();
        if (!z3File.isFile()) {
            throw new ExternalToolError("Z3", new java.lang.StringBuilder(41).append("Cannot run Z3 at location '").append(z3File).append("': not a file.").toString());
        }
        if (!z3File.canExecute()) {
            throw new ExternalToolError("Z3", new java.lang.StringBuilder(53).append("Cannot run Z3 at location '").append(z3File).append("': file is not executable.").toString());
        }
        Option<String> option = Verifier$.MODULE$.config().z3Args().toOption();
        if (None$.MODULE$.equals(option)) {
            stringArray = (String[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit2;
            Some some = (Some)option;
            String args = (String)some.value();
            String msg2 = new java.lang.StringBuilder(38).append("Additional command-line arguments are ").append(args).toString();
            this.reporter.report(new ConfigurationConfirmation(msg2));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(msg2);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            stringArray = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(args)).split(' '))).map((Function1<String, String> & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        } else {
            throw new MatchError(option);
        }
        String[] userProvidedZ3Args = stringArray;
        String string = this.z3Path().toFile().getPath();
        String string2 = "-smt2";
        String string3 = "-in";
        ProcessBuilder builder = new ProcessBuilder((String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])userProvidedZ3Args)).$plus$colon(string3, ClassTag$.MODULE$.apply(String.class)))).$plus$colon(string2, ClassTag$.MODULE$.apply(String.class)))).$plus$colon(string, ClassTag$.MODULE$.apply(String.class)));
        builder.redirectErrorStream(true);
        Process process2 = builder.start();
        Runtime.getRuntime().addShutdownHook(new Thread(null, process2){
            private final Process process$1;

            public void run() {
                this.process$1.destroy();
            }
            {
                this.process$1 = process$1;
            }
        });
        return process2;
    }

    @Override
    public void reset() {
        this.stop();
        this.start();
    }

    @Override
    public synchronized void stop() {
        block6: {
            Serializable serializable;
            if (this.logfileWriter() != null) {
                this.logfileWriter().flush();
            }
            if (this.output() != null) {
                this.output().flush();
            }
            if (this.z3() != null) {
                this.z3().destroyForcibly();
                serializable = BoxesRunTime.boxToBoolean(this.z3().waitFor(10L, TimeUnit.SECONDS));
            } else {
                serializable = BoxedUnit.UNIT;
            }
            if (this.logfileWriter() != null) {
                this.logfileWriter().close();
            }
            if (this.input() != null) {
                this.input().close();
            }
            if (this.output() == null) break block6;
            this.output().close();
        }
    }

    public void push(int n2) {
        this.pushPopScopeDepth_$eq(this.pushPopScopeDepth() + n2);
        String cmd = new java.lang.StringBuilder(3).append(n2 == 1 ? "(push)" : new java.lang.StringBuilder(7).append("(push ").append(n2).append(")").toString()).append(" ; ").append(this.pushPopScopeDepth()).toString();
        this.writeLine(cmd);
        this.readSuccess();
    }

    public int push$default$1() {
        return 1;
    }

    public void pop(int n2) {
        String cmd = new java.lang.StringBuilder(3).append(n2 == 1 ? "(pop)" : new java.lang.StringBuilder(6).append("(pop ").append(n2).append(")").toString()).append(" ; ").append(this.pushPopScopeDepth()).toString();
        this.pushPopScopeDepth_$eq(this.pushPopScopeDepth() - n2);
        this.writeLine(cmd);
        this.readSuccess();
    }

    public int pop$default$1() {
        return 1;
    }

    @Override
    public void emit(String content) {
        this.writeLine(content);
        this.readSuccess();
    }

    @Override
    public void assume(Term term) {
        this.assume(this.termConverter.convert(term));
    }

    public void assume(String term) {
        this.writeLine(new java.lang.StringBuilder(9).append("(assert ").append(term).append(")").toString());
        this.readSuccess();
    }

    @Override
    public boolean assert(Term goal, Option<Object> timeout) {
        return this.assert(this.termConverter.convert(goal), timeout);
    }

    public boolean assert(String goal, Option<Object> timeout) {
        Tuple2<Object, Object> tuple2;
        this.setTimeout(timeout);
        Config.AssertionMode assertionMode = Verifier$.MODULE$.config().assertionMode().apply();
        if (Config$AssertionMode$SoftConstraints$.MODULE$.equals(assertionMode)) {
            tuple2 = this.assertUsingSoftConstraints(goal);
        } else if (Config$AssertionMode$PushPop$.MODULE$.equals(assertionMode)) {
            tuple2 = this.assertUsingPushPop(goal);
        } else {
            throw new MatchError(assertionMode);
        }
        Tuple2<Object, Object> tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        boolean result2 = tuple22._1$mcZ$sp();
        long duration = tuple22._2$mcJ$sp();
        Tuple2$mcZJ$sp tuple2$mcZJ$sp = new Tuple2$mcZJ$sp(result2, duration);
        Tuple2$mcZJ$sp tuple2$mcZJ$sp2 = tuple2$mcZJ$sp;
        boolean result3 = ((Tuple2)tuple2$mcZJ$sp2)._1$mcZ$sp();
        long duration2 = ((Tuple2)tuple2$mcZJ$sp2)._2$mcJ$sp();
        this.comment(String.valueOf(viper.silver.reporter.format.package$.MODULE$.formatMillisReadably(duration2)));
        this.comment("(get-info :all-statistics)");
        return result3;
    }

    @Override
    public Option<Object> assert$default$2() {
        return None$.MODULE$;
    }

    private Tuple2<Object, Object> assertUsingPushPop(String goal) {
        this.push(this.push$default$1());
        this.writeLine(new java.lang.StringBuilder(15).append("(assert (not ").append(goal).append("))").toString());
        this.readSuccess();
        long startTime = System.currentTimeMillis();
        this.writeLine("(check-sat)");
        boolean result2 = this.readUnsat();
        long endTime = System.currentTimeMillis();
        if (!result2) {
            this.getModel();
        }
        this.pop(this.pop$default$1());
        return new Tuple2$mcZJ$sp(result2, endTime - startTime);
    }

    @Override
    public void saturate(Option<Config.Z3StateSaturationTimeout> data) {
        Some some;
        Config.Z3StateSaturationTimeout z3StateSaturationTimeout;
        Option<Config.Z3StateSaturationTimeout> option = data;
        if (option instanceof Some && (z3StateSaturationTimeout = (Config.Z3StateSaturationTimeout)(some = (Some)option).value()) != null) {
            int timeout = z3StateSaturationTimeout.timeout();
            String comment = z3StateSaturationTimeout.comment();
            this.saturate(timeout, comment);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    @Override
    public void saturate(int timeout, String comment) {
        this.comment(new java.lang.StringBuilder(18).append("State saturation: ").append(comment).toString());
        this.setTimeout(new Some<Object>(BoxesRunTime.boxToInteger(timeout)));
        this.writeLine("(check-sat)");
        this.readLine();
    }

    private void getModel() {
        block1: {
            if (!Verifier$.MODULE$.config().counterexample().toOption().isDefined()) break block1;
            this.writeLine("(get-model)");
            String model = this.readModel("\n").trim();
            if (model.startsWith("\"")) {
                model = model.replaceAll("\"", "");
            }
            this.lastModel_$eq(model);
        }
    }

    private Tuple2<Object, Object> assertUsingSoftConstraints(String goal) {
        Function guard = this.fresh("grd", (Seq)Nil$.MODULE$, (Sort)sorts$Bool$.MODULE$);
        this.writeLine(new java.lang.StringBuilder(26).append("(assert (implies ").append(guard).append(" (not ").append(goal).append(")))").toString());
        this.readSuccess();
        long startTime = System.currentTimeMillis();
        this.writeLine(new java.lang.StringBuilder(12).append("(check-sat ").append(guard).append(")").toString());
        boolean result2 = this.readUnsat();
        long endTime = System.currentTimeMillis();
        if (!result2) {
            this.getModel();
        }
        return new Tuple2$mcZJ$sp(result2, endTime - startTime);
    }

    @Override
    public Result check(Option<Object> timeout) {
        Result result2;
        this.setTimeout(timeout);
        this.writeLine("(check-sat)");
        String string = this.readLine();
        if ("sat".equals(string)) {
            result2 = Sat$.MODULE$;
        } else if ("unsat".equals(string)) {
            result2 = Unsat$.MODULE$;
        } else if ("unknown".equals(string)) {
            result2 = Unknown$.MODULE$;
        } else {
            throw new MatchError((Object)string);
        }
        return result2;
    }

    @Override
    public Option<Object> check$default$1() {
        return None$.MODULE$;
    }

    private void setTimeout(Option<Object> timeout) {
        block2: {
            int effectiveTimeout = BoxesRunTime.unboxToInt(timeout.getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> Verifier$.MODULE$.config().z3Timeout()));
            if (this.lastTimeout() == effectiveTimeout) break block2;
            this.lastTimeout_$eq(effectiveTimeout);
            if (BoxesRunTime.unboxToBoolean(Verifier$.MODULE$.config().z3EnableResourceBounds().apply())) {
                this.writeLine(new java.lang.StringBuilder(21).append("(set-option :rlimit ").append(effectiveTimeout * BoxesRunTime.unboxToInt(Verifier$.MODULE$.config().z3ResourcesPerMillisecond().apply())).append(")").toString());
            } else {
                this.writeLine(new java.lang.StringBuilder(22).append("(set-option :timeout ").append(effectiveTimeout).append(")").toString());
            }
            this.readSuccess();
        }
    }

    @Override
    public ListMap<String, String> statistics() {
        boolean repeat = true;
        String line = "";
        SortedMap<String, String> stats = (SortedMap<String, String>)SortedMap$.MODULE$.apply(Nil$.MODULE$, Ordering$String$.MODULE$);
        Regex entryPattern = new StringOps(Predef$.MODULE$.augmentString("\\(?\\s*:([A-za-z\\-]+)\\s+((?:\\d+\\.)?\\d+)\\)?")).r();
        this.writeLine("(get-info :all-statistics)");
        do {
            BoxedUnit boxedUnit;
            line = this.input().readLine();
            this.comment(line);
            if (line.isEmpty() && !line.startsWith("(:")) {
                throw new Z3InteractionFailed(this.uniqueId, new java.lang.StringBuilder(50).append("Unexpected output of Z3 while reading statistics: ").append(line).toString());
            }
            String string = line;
            Option<List<String>> option = entryPattern.unapplySeq(string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String entryName = (String)((LinearSeqOptimized)option.get()).apply(0);
                String entryNumber = (String)((LinearSeqOptimized)option.get()).apply(1);
                stats = stats.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entryName), entryNumber));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            boolean bl = repeat = !line.endsWith(")");
        } while (repeat);
        return package$.MODULE$.toMap(stats);
    }

    @Override
    public void comment(String str) {
        String sanitisedStr = str.replaceAll("\r", "").replaceAll("\n", "\n; ");
        this.logToFile(new java.lang.StringBuilder(2).append("; ").append(sanitisedStr).toString());
    }

    @Override
    public Fun fresh(String name, Seq<Sort> argSorts, Sort resultSort) {
        Identifier id = this.identifierFactory.fresh(name);
        Function fun = Fun$.MODULE$.apply(id, (Seq)argSorts, resultSort);
        FunctionDecl decl = new FunctionDecl(fun);
        this.emit(this.termConverter.convert(decl));
        return fun;
    }

    @Override
    public void declare(Decl decl) {
        String str = this.termConverter.convert(decl);
        this.emit(str);
    }

    private void readSuccess() {
        String answer;
        String string = answer = this.readLine();
        String string2 = "success";
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new Z3InteractionFailed(this.uniqueId, new java.lang.StringBuilder(55).append("Unexpected output of Z3. Expected 'success' but found: ").append(answer).toString());
        }
    }

    private boolean readUnsat() {
        boolean bl;
        String string = this.readLine();
        if ("unsat".equals(string)) {
            bl = true;
        } else if ("sat".equals(string)) {
            bl = false;
        } else if ("unknown".equals(string)) {
            bl = false;
        } else {
            throw new Z3InteractionFailed(this.uniqueId, new java.lang.StringBuilder(61).append("Unexpected output of Z3 while trying to refute an assertion: ").append(string).toString());
        }
        return bl;
    }

    private String readModel(String separator) {
        String string;
        try {
            boolean endFound = false;
            StringBuilder result2 = new StringBuilder();
            boolean firstTime = true;
            while (!endFound) {
                String nextLine = this.input().readLine();
                if (nextLine.trim().endsWith("\"") || firstTime && !nextLine.startsWith("\"")) {
                    endFound = true;
                }
                result2.append(separator).append(nextLine);
                firstTime = false;
            }
            string = result2.result();
        }
        catch (Exception e) {
            Predef$.MODULE$.println(new java.lang.StringBuilder(21).append("Error reading model: ").append(e).toString());
            string = "";
        }
        return string;
    }

    private String readModel$default$1() {
        return " ";
    }

    /*
     * WARNING - void declaration
     */
    private String readLine() {
        void var2_2;
        boolean repeat = true;
        String result2 = "";
        while (repeat) {
            BoxedUnit boxedUnit;
            boolean warning;
            result2 = this.input().readLine();
            String string = result2.toLowerCase();
            String string2 = "success";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.comment(result2);
            }
            if (warning = result2.startsWith("WARNING")) {
                String msg = new java.lang.StringBuilder(12).append("Z3 warning: ").append(result2).toString();
                this.reporter.report(new InternalWarningMessage(msg));
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            repeat = warning;
        }
        return var2_2;
    }

    private void logToFile(String str) {
        this.logfileWriter().println(str);
    }

    private void writeLine(String out) {
        this.logToFile(out);
        this.output().println(out);
    }

    @Override
    public String getLastModel() {
        return this.lastModel();
    }

    @Override
    public void clearLastModel() {
        this.lastModel_$eq(null);
    }

    public Z3ProverStdIO(String uniqueId, TermToSMTLib2Converter termConverter, IdentifierFactory identifierFactory, PluginAwareReporter reporter) {
        this.uniqueId = uniqueId;
        this.termConverter = termConverter;
        this.identifierFactory = identifierFactory;
        this.reporter = reporter;
        ProverLike.$init$(this);
        LazyLogging.$init$(this);
        this.pushPopScopeDepth = 0;
        this.lastTimeout = -1;
        this.lastModel = null;
    }
}

