/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.scalatest.DoNotDiscover;
import org.scalatest.Suite;
import org.scalatest.WrapWith;
import org.scalatest.tools.DiscoverySuite$;
import org.scalatest.tools.NestedSuiteParam;
import org.scalatest.tools.SuiteDiscoveryHelper;
import org.scalatest.tools.SuiteParam;
import org.scalatest.tools.TestSpec;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class SuiteDiscoveryHelper$ {
    public static SuiteDiscoveryHelper$ MODULE$;
    private final Class<?>[] emptyClassArray;

    static {
        new SuiteDiscoveryHelper$();
    }

    public List<SuiteParam> discoverTests(List<TestSpec> testSpecs, Set<String> accessibleSuites, ClassLoader loader) {
        ListBuffer buf;
        block0: {
            buf = new ListBuffer();
            if (testSpecs.isEmpty()) break block0;
            Set names = ((TraversableOnce)((List)testSpecs.filter((Function1<TestSpec, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(SuiteDiscoveryHelper$.$anonfun$discoverTests$1(x$1)))).map((Function1<TestSpec, String> & Serializable & scala.Serializable)x$2 -> x$2.spec(), List$.MODULE$.canBuildFrom())).toSet();
            Set substrings = ((TraversableOnce)((List)testSpecs.filter((Function1<TestSpec, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(SuiteDiscoveryHelper$.$anonfun$discoverTests$3(x$3)))).map((Function1<TestSpec, String> & Serializable & scala.Serializable)x$4 -> x$4.spec(), List$.MODULE$.canBuildFrom())).toSet();
            accessibleSuites.foreach((Function1<String, Object> & Serializable & scala.Serializable)suiteName -> {
                Suite suiteInstance = DiscoverySuite$.MODULE$.getSuiteInstance((String)suiteName, loader);
                Set nameMatches = (Set)names.intersect(suiteInstance.testNames());
                Set substringMatches = (Set)substrings.filter((Function1<String, Object> & Serializable & scala.Serializable)substring -> BoxesRunTime.boxToBoolean(SuiteDiscoveryHelper$.$anonfun$discoverTests$6(suiteInstance, substring)));
                return nameMatches.size() > 0 || substringMatches.size() > 0 ? buf.$plus$eq(new SuiteParam((String)suiteName, (String[])((TraversableOnce)nameMatches.toList().sortWith((Function2<String, String, Object> & Serializable & scala.Serializable)(x$6, x$7) -> BoxesRunTime.boxToBoolean(SuiteDiscoveryHelper$.$anonfun$discoverTests$8(x$6, x$7)))).toArray(ClassTag$.MODULE$.apply(String.class)), (String[])((TraversableOnce)substringMatches.toList().sortWith((Function2<String, String, Object> & Serializable & scala.Serializable)(x$8, x$9) -> BoxesRunTime.boxToBoolean(SuiteDiscoveryHelper$.$anonfun$discoverTests$9(x$8, x$9)))).toArray(ClassTag$.MODULE$.apply(String.class)), (NestedSuiteParam[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(NestedSuiteParam.class)))) : BoxedUnit.UNIT;
            });
        }
        return (List)buf.toList().sortWith((Function2<SuiteParam, SuiteParam, Object> & Serializable & scala.Serializable)(x$10, x$11) -> BoxesRunTime.boxToBoolean(SuiteDiscoveryHelper$.$anonfun$discoverTests$10(x$10, x$11)));
    }

    public Set<String> discoverSuiteNames(List<String> runpath, ClassLoader loader, Option<Pattern> suffixes) {
        String fileSeparatorString = System.getProperty("path.separator");
        char fileSeparator = !fileSeparatorString.isEmpty() ? (char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(fileSeparatorString), 0) : (char)':';
        List<?> listOfSets = runpath.map((Function1<String, Set> & Serializable & scala.Serializable)path -> {
            Set<String> set;
            Option option;
            try {
                option = new Some<URL>(new URL((String)path));
            }
            catch (MalformedURLException e) {
                option = None$.MODULE$;
            }
            Option urlOption = option;
            boolean endsWithDotJar = path.endsWith(".jar");
            if (endsWithDotJar) {
                Set<String> set2;
                Option jarFileOption;
                Option option2;
                Option option3 = urlOption;
                if (option3 instanceof Some) {
                    Option option4 = option3;
                    URL url = (URL)((Some)option4).value();
                    option2 = SuiteDiscoveryHelper$.getJarFileFromURL$1(url);
                } else if (None$.MODULE$.equals(option3)) {
                    option2 = SuiteDiscoveryHelper$.getJarFileFromFileSystem$1(path);
                } else {
                    throw new MatchError(option3);
                }
                Option option5 = jarFileOption = option2;
                if (option5 instanceof Some) {
                    Some some = (Some)option5;
                    JarFile jf = (JarFile)some.value();
                    set2 = MODULE$.processFileNames(MODULE$.getFileNamesIteratorFromJar(jf), '/', loader, suffixes);
                } else if (None$.MODULE$.equals(option5)) {
                    set2 = (Set<String>)Predef$.MODULE$.Set().apply(Nil$.MODULE$);
                } else {
                    throw new MatchError(option5);
                }
                set = set2;
            } else {
                set = MODULE$.processFileNames(MODULE$.getFileNamesSetFromFile(new File((String)path), fileSeparator).iterator(), fileSeparator, loader, suffixes);
            }
            return set;
        }, List$.MODULE$.canBuildFrom());
        return (Set)((SetLike)Predef$.MODULE$.Set().apply(Nil$.MODULE$)).$plus$plus(listOfSets.flatMap((Function1<Set, List> & Serializable & scala.Serializable)x$12 -> x$12.iterator().toList(), List$.MODULE$.canBuildFrom()));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Option<String> transformToClassName(String fileName, char fileSeparator) {
        Option option;
        String fn;
        String string = fn = !fileName.isEmpty() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(fileName), 0) == fileSeparator ? fileName.substring(1) : fileName;
        if (fn.endsWith(".class")) {
            String string2 = fn;
            String string3 = ".class";
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                option = new Some<String>(fn.substring(0, fn.length() - 6).replace(fileSeparator, '.'));
                return option;
            }
        }
        option = None$.MODULE$;
        return option;
    }

    private Class<?>[] emptyClassArray() {
        return this.emptyClassArray;
    }

    public boolean isAccessibleSuite(Class<?> clazz) {
        boolean bl;
        block4: {
            try {
                if (Suite.class.isAssignableFrom(clazz) && Modifier.isPublic(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers()) && Modifier.isPublic(clazz.getConstructor(this.emptyClassArray()).getModifiers())) {
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            catch (NoSuchMethodException nsme) {
                bl = false;
            }
            catch (SecurityException se) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isAccessibleSuite(String className, ClassLoader loader) {
        boolean bl;
        try {
            bl = this.isAccessibleSuite(loader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        catch (NoClassDefFoundError e) {
            bl = false;
        }
        return bl;
    }

    public boolean isDiscoverableSuite(Class<?> clazz) {
        return !clazz.isAnnotationPresent(DoNotDiscover.class);
    }

    private boolean isDiscoverableSuite(String className, ClassLoader loader) {
        boolean bl;
        try {
            bl = this.isDiscoverableSuite(loader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        catch (NoClassDefFoundError e) {
            bl = false;
        }
        return bl;
    }

    public boolean isRunnable(Class<?> clazz) {
        boolean bl;
        WrapWith wrapWithAnnotation = clazz.getAnnotation(WrapWith.class);
        if (wrapWithAnnotation != null) {
            Class<? extends Suite> wrapperSuiteClazz = wrapWithAnnotation.value();
            Constructor<?>[] constructorList = wrapperSuiteClazz.getDeclaredConstructors();
            bl = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])constructorList)).exists((Function1<Object, Object>)(Function1<Constructor, Object> & Serializable & scala.Serializable)c2 -> BoxesRunTime.boxToBoolean(SuiteDiscoveryHelper$.$anonfun$isRunnable$1(c2)));
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isRunnable(String className, ClassLoader loader) {
        boolean bl;
        try {
            bl = this.isRunnable(loader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        catch (NoClassDefFoundError e) {
            bl = false;
        }
        return bl;
    }

    private Option<String> processClassName(String className, ClassLoader loader, Option<Pattern> suffixes) {
        return this.classNameSuffixOkay(className, suffixes) && this.isDiscoverableSuite(className, loader) && (this.isAccessibleSuite(className, loader) || this.isRunnable(className, loader)) ? new Some<String>(className) : None$.MODULE$;
    }

    private boolean classNameSuffixOkay(String className, Option<Pattern> suffixes) {
        Option<Pattern> option = suffixes;
        None$ none$ = None$.MODULE$;
        return !(option == null ? none$ != null : !option.equals(none$)) || suffixes.get().matcher(className).matches();
    }

    private Set<String> processFileNames(Iterator<String> fileNames, char fileSeparator, ClassLoader loader, Option<Pattern> suffixes) {
        Iterator classNameOptions = this.extractClassNames(fileNames, fileSeparator).map((Function1<String, Option> & Serializable & scala.Serializable)className -> MODULE$.processClassName((String)className, loader, suffixes));
        Iterator classNames = classNameOptions.withFilter((Function1<Option, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(SuiteDiscoveryHelper$.$anonfun$processFileNames$2(check$ifrefutable$1))).map((Function1<Option, String> & Serializable & scala.Serializable)x$13 -> {
            String className;
            Option option = x$13;
            if (!(option instanceof Some)) {
                throw new MatchError(option);
            }
            Some some = (Some)option;
            String string = className = (String)some.value();
            return string;
        });
        return (Set)((SetLike)Predef$.MODULE$.Set().apply(Nil$.MODULE$)).$plus$plus(classNames);
    }

    private Set<String> getFileNamesSetFromFile(File file, char fileSeparator) {
        List allFiles = file.isDirectory() ? SuiteDiscoveryHelper$.listFilesInDir$1(file, "", fileSeparator) : List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{file.getName()}));
        return (Set)((SetLike)Predef$.MODULE$.Set().apply(Nil$.MODULE$)).$plus$plus(allFiles.map((Function1<String, String> & Serializable & scala.Serializable)fn -> !fn.isEmpty() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString((String)fn), 0) == fileSeparator ? fn.substring(1) : fn, List$.MODULE$.canBuildFrom()));
    }

    private Iterator<String> getFileNamesIteratorFromJar(JarFile file) {
        public class Org_scalatest_tools_SuiteDiscoveryHelper$EnumerationWrapper$1<T>
        implements Iterator<T> {
            private final Enumeration<T> e;

            public Iterator<T> seq() {
                return Iterator.seq$(this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$(this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$(this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$(this);
            }

            public Iterator<T> take(int n2) {
                return Iterator.take$(this, n2);
            }

            public Iterator<T> drop(int n2) {
                return Iterator.drop$(this, n2);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.slice$(this, from, until);
            }

            public Iterator<T> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$(this, from, until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.map$(this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$(this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$(this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.filter$(this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.corresponds$(this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.withFilter$(this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.filterNot$(this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.collect$(this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.scanLeft$(this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.scanRight$(this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.takeWhile$(this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.partition$(this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.span$(this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.dropWhile$(this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.zip$(this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$(this, len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$(this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$(this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.foreach$(this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.forall$(this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.exists$(this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$(this, elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.find$(this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.indexWhere$(this, p);
            }

            public int indexWhere(Function1<T, Object> p, int from) {
                return Iterator.indexWhere$(this, p, from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$(this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$(this, elem, from);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.buffered$(this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$(this, size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$(this, size, step);
            }

            public int length() {
                return Iterator.length$(this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.duplicate$(this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$(this, from, patchElems, replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$(this, xs, start, len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$(this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.toTraversable$(this);
            }

            public Iterator<T> toIterator() {
                return Iterator.toIterator$(this);
            }

            public Stream<T> toStream() {
                return Iterator.toStream$(this);
            }

            public String toString() {
                return Iterator.toString$(this);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$(this);
            }

            public List<T> reversed() {
                return TraversableOnce.reversed$(this);
            }

            public int size() {
                return TraversableOnce.size$(this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$(this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.count$(this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.collectFirst$(this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.$div$colon$(this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$(this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.foldLeft$(this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.foldRight$(this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.reduceLeft$(this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.reduceRight$(this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.reduceLeftOption$(this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.reduceRightOption$(this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$(this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$(this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$(this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$(this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$(this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$(this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return (T)TraversableOnce.min$(this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return (T)TraversableOnce.max$(this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.maxBy$(this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.minBy$(this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$(this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$(this, xs, start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$(this, xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$(this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.toList$(this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.toIterable$(this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.toSeq$(this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$(this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$(this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$(this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.toVector$(this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.to$(this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$(this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$(this, start, sep, end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$(this, sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$(this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$(this, b, start, sep, end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$(this, b, sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$(this, b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$(this);
            }

            public T next() {
                return this.e.nextElement();
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }

            public Org_scalatest_tools_SuiteDiscoveryHelper$EnumerationWrapper$1(Enumeration<T> e) {
                this.e = e;
                GenTraversableOnce.$init$(this);
                TraversableOnce.$init$(this);
                Iterator.$init$(this);
            }
        }
        return new Org_scalatest_tools_SuiteDiscoveryHelper$EnumerationWrapper$1<JarEntry>(file.entries()).map((Function1<JarEntry, String> & Serializable & scala.Serializable)x$15 -> x$15.getName());
    }

    private Iterator<String> extractClassNames(Iterator<String> fileNames, char fileSeparator) {
        Iterator options = fileNames.map((Function1<String, Option> & Serializable & scala.Serializable)fileName -> MODULE$.transformToClassName((String)fileName, fileSeparator));
        return options.withFilter((Function1<Option, Object> & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(SuiteDiscoveryHelper$.$anonfun$extractClassNames$2(check$ifrefutable$2))).map((Function1<Option, String> & Serializable & scala.Serializable)x$16 -> {
            String className;
            Option option = x$16;
            if (!(option instanceof Some)) {
                throw new MatchError(option);
            }
            Some some = (Some)option;
            String string = className = (String)some.value();
            return string;
        });
    }

    public static final /* synthetic */ boolean $anonfun$discoverTests$1(TestSpec x$1) {
        return !x$1.isSubstring();
    }

    public static final /* synthetic */ boolean $anonfun$discoverTests$3(TestSpec x$3) {
        return x$3.isSubstring();
    }

    public static final /* synthetic */ boolean $anonfun$discoverTests$6(Suite suiteInstance$1, String substring) {
        return suiteInstance$1.testNames().exists((Function1<String, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.contains(substring)));
    }

    public static final /* synthetic */ boolean $anonfun$discoverTests$8(String x$6, String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).$less(x$7);
    }

    public static final /* synthetic */ boolean $anonfun$discoverTests$9(String x$8, String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).$less(x$9);
    }

    public static final /* synthetic */ boolean $anonfun$discoverTests$10(SuiteParam x$10, SuiteParam x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10.className())).$less(x$11.className());
    }

    private static final Option getJarFileFromURL$1(URL url) {
        Option option;
        Object o = url.openConnection().getContent();
        if (o != null) {
            try {
                option = new Some<JarFile>((JarFile)o);
            }
            catch (ClassCastException e) {
                option = None$.MODULE$;
            }
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    private static final Option getJarFileFromFileSystem$1(String path) {
        Option option;
        try {
            option = new Some<JarFile>(new JarFile(path));
        }
        catch (IOException e) {
            option = None$.MODULE$;
        }
        return option;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isRunnable$1(Constructor c2) {
        Class<?>[] types = c2.getParameterTypes();
        if (types.length != 1) return false;
        Class<?> clazz = types[0];
        Class<Class> clazz2 = Class.class;
        if (clazz != null) {
            if (!clazz.equals(clazz2)) return false;
            return true;
        }
        if (clazz2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$processFileNames$2(Option check$ifrefutable$1) {
        Option option = check$ifrefutable$1;
        boolean bl = option instanceof Some;
        return bl;
    }

    private static final String prependPrevName$1(String prevName, String fileName, char fileSeparator$2) {
        return prevName + fileSeparator$2 + fileName;
    }

    public static final /* synthetic */ boolean $anonfun$getFileNamesSetFromFile$4(File entry) {
        return !entry.isDirectory();
    }

    private static final List listFilesInDir$1(File dir, String prevName, char fileSeparator$2) {
        List files2;
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        List<?> subDirs = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).toList().withFilter((Function1<Object, Object>)(Function1<File, Object> & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean(entry.isDirectory())).map((Function1<File, File> & Serializable & scala.Serializable)entry -> entry, List$.MODULE$.canBuildFrom());
        List<?> fileLists = subDirs.map((Function1<File, List> & Serializable & scala.Serializable)subDir -> SuiteDiscoveryHelper$.listFilesInDir$1(subDir, SuiteDiscoveryHelper$.prependPrevName$1(prevName, subDir.getName(), fileSeparator$2), fileSeparator$2), List$.MODULE$.canBuildFrom());
        List list = files2 = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).toList().withFilter((Function1<Object, Object>)(Function1<File, Object> & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean(SuiteDiscoveryHelper$.$anonfun$getFileNamesSetFromFile$4(entry))).map((Function1<File, String> & Serializable & scala.Serializable)entry -> SuiteDiscoveryHelper$.prependPrevName$1(prevName, entry.getName(), fileSeparator$2), List$.MODULE$.canBuildFrom());
        return fileLists.flatMap((Function1<List, List> & Serializable & scala.Serializable)e -> e, List$.MODULE$.canBuildFrom()).$colon$colon$colon(list);
    }

    public static final /* synthetic */ boolean $anonfun$extractClassNames$2(Option check$ifrefutable$2) {
        Option option = check$ifrefutable$2;
        boolean bl = option instanceof Some;
        return bl;
    }

    private SuiteDiscoveryHelper$() {
        MODULE$ = this;
        this.emptyClassArray = new Class[0];
    }
}

