/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.graph.GraphDelegator;

public class AsWeightedGraph<V, E>
extends GraphDelegator<V, E>
implements Serializable,
Graph<V, E> {
    private static final long serialVersionUID = 6408608293216853184L;
    private final Map<E, Double> weightMap;

    public AsWeightedGraph(Graph<V, E> g2, Map<E, Double> weightMap) {
        super(g2);
        this.weightMap = Objects.requireNonNull(weightMap, "Weight map cannot be null");
    }

    @Override
    public void setEdgeWeight(E e, double weight) {
        if (super.getType().isWeighted()) {
            super.setEdgeWeight(e, weight);
        }
        this.weightMap.put(e, weight);
    }

    @Override
    public double getEdgeWeight(E e) {
        double weight = this.weightMap.containsKey(e) ? this.weightMap.get(e).doubleValue() : super.getEdgeWeight(e);
        return weight;
    }

    @Override
    public GraphType getType() {
        return super.getType().asWeighted();
    }
}

