/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.tour;

import java.util.ArrayList;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.interfaces.HamiltonianCycleAlgorithm;
import org.jgrapht.graph.GraphWalk;

public class PalmerHamiltonianCycle<V, E>
implements HamiltonianCycleAlgorithm<V, E> {
    @Override
    public GraphPath<V, E> getTour(Graph<V, E> graph) {
        boolean changed;
        if (!GraphTests.hasOreProperty(graph)) {
            throw new IllegalArgumentException("Graph doesn't have Ore's property");
        }
        ArrayList<V> indexList = new ArrayList<V>(graph.vertexSet());
        int n2 = graph.vertexSet().size();
        int[] L = new int[n2];
        int[] R = new int[n2];
        for (int i = 0; i < n2; ++i) {
            L[i] = (i - 1 + n2) % n2;
            R[i] = (i + 1) % n2;
        }
        block1: do {
            changed = false;
            int x = 0;
            do {
                if (graph.containsEdge(indexList.get(x), indexList.get(R[x]))) continue;
                changed = true;
                int y = 0;
                do {
                    int u = x;
                    int v = R[x];
                    int p = y;
                    int q = R[y];
                    if (v == p || u == p || u == q || !graph.containsEdge(indexList.get(u), indexList.get(p)) || !graph.containsEdge(indexList.get(v), indexList.get(q))) continue;
                    R[u] = L[u];
                    L[u] = p;
                    R[v] = R[v];
                    L[v] = q;
                    L[p] = L[p];
                    R[p] = u;
                    L[q] = R[q];
                    R[q] = v;
                    int z = R[u];
                    while (z != q) {
                        int tmp = R[z];
                        R[z] = L[z];
                        L[z] = tmp;
                        z = R[z];
                    }
                    continue block1;
                } while ((y = R[y]) != 0);
            } while ((x = R[x]) != 0);
        } while (changed);
        ArrayList vertexList = new ArrayList(n2);
        ArrayList<E> edgeList = new ArrayList<E>(n2);
        int x = 0;
        do {
            vertexList.add(indexList.get(x));
            edgeList.add(graph.getEdge(indexList.get(x), indexList.get(R[x])));
        } while ((x = R[x]) != 0);
        vertexList.add(indexList.get(0));
        return new GraphWalk<V, E>(graph, indexList.get(0), indexList.get(0), vertexList, edgeList, edgeList.size());
    }
}

