/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.GraphTests;
import org.jgrapht.VertexFactory;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.BaseShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.BellmanFordShortestPath;
import org.jgrapht.alg.shortestpath.DijkstraClosestFirstIterator;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.alg.shortestpath.TreeSingleSourcePathsImpl;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.alg.util.ToleranceDoubleComparator;
import org.jgrapht.graph.AsGraphUnion;
import org.jgrapht.graph.AsWeightedGraph;
import org.jgrapht.graph.ClassBasedVertexFactory;
import org.jgrapht.graph.builder.GraphTypeBuilder;

public class JohnsonShortestPaths<V, E>
extends BaseShortestPathAlgorithm<V, E> {
    private Map<V, ShortestPathAlgorithm.SingleSourcePaths<V, E>> paths;
    private final Comparator<Double> comparator;
    @Deprecated
    private VertexFactory<V> vertexFactory;

    @Deprecated
    public JohnsonShortestPaths(Graph<V, E> graph, Class<? extends V> vertexClass) {
        this(graph, new ClassBasedVertexFactory<V>(vertexClass));
    }

    @Deprecated
    public JohnsonShortestPaths(Graph<V, E> graph, VertexFactory<V> vertexFactory) {
        this(graph, vertexFactory, 1.0E-9);
    }

    @Deprecated
    public JohnsonShortestPaths(Graph<V, E> graph, VertexFactory<V> vertexFactory, double epsilon) {
        super(graph);
        this.vertexFactory = Objects.requireNonNull(vertexFactory, "Vertex factory cannot be null");
        this.comparator = new ToleranceDoubleComparator(epsilon);
    }

    public JohnsonShortestPaths(Graph<V, E> graph) {
        this(graph, 1.0E-9);
    }

    public JohnsonShortestPaths(Graph<V, E> graph, double epsilon) {
        super(graph);
        this.comparator = new ToleranceDoubleComparator(epsilon);
    }

    @Override
    public GraphPath<V, E> getPath(V source, V sink) {
        if (!this.graph.containsVertex(source)) {
            throw new IllegalArgumentException("Graph must contain the source vertex!");
        }
        if (!this.graph.containsVertex(sink)) {
            throw new IllegalArgumentException("Graph must contain the sink vertex!");
        }
        this.run();
        return this.paths.get(source).getPath(sink);
    }

    @Override
    public double getPathWeight(V source, V sink) {
        if (!this.graph.containsVertex(source)) {
            throw new IllegalArgumentException("Graph must contain the source vertex!");
        }
        if (!this.graph.containsVertex(sink)) {
            throw new IllegalArgumentException("Graph must contain the sink vertex!");
        }
        this.run();
        return this.paths.get(source).getWeight(sink);
    }

    @Override
    public ShortestPathAlgorithm.SingleSourcePaths<V, E> getPaths(V source) {
        this.run();
        return this.paths.get(source);
    }

    private void run() {
        if (this.paths != null) {
            return;
        }
        GraphTests.requireDirectedOrUndirected(this.graph);
        boolean graphHasNegativeEdgeWeights = false;
        for (Object e : this.graph.edgeSet()) {
            if (this.comparator.compare(this.graph.getEdgeWeight(e), 0.0) >= 0) continue;
            graphHasNegativeEdgeWeights = true;
            break;
        }
        if (graphHasNegativeEdgeWeights) {
            if (this.graph.getType().isUndirected()) {
                throw new RuntimeException("Graph contains a negative-weight cycle");
            }
            this.runWithNegativeEdgeWeights(this.graph);
        } else {
            this.runWithPositiveEdgeWeights(this.graph);
        }
    }

    private void runWithPositiveEdgeWeights(Graph<V, E> g2) {
        this.paths = new HashMap<V, ShortestPathAlgorithm.SingleSourcePaths<V, E>>();
        DijkstraShortestPath<V, E> dijkstraAlg = new DijkstraShortestPath<V, E>(g2);
        for (V v : g2.vertexSet()) {
            this.paths.put((ShortestPathAlgorithm.SingleSourcePaths<V, E>)v, (ShortestPathAlgorithm.SingleSourcePaths<ShortestPathAlgorithm.SingleSourcePaths<V, E>, E>)dijkstraAlg.getPaths(v));
        }
    }

    private void runWithNegativeEdgeWeights(Graph<V, E> g2) {
        Map<V, Double> vertexWeights = this.computeVertexWeights(g2);
        HashMap<E, Double> newEdgeWeights = new HashMap<E, Double>();
        for (E e : g2.edgeSet()) {
            V u = g2.getEdgeSource(e);
            V v = g2.getEdgeTarget(e);
            double weight = g2.getEdgeWeight(e);
            newEdgeWeights.put(e, weight + vertexWeights.get(u) - vertexWeights.get(v));
        }
        AsWeightedGraph<V, E> newEdgeWeightsGraph = new AsWeightedGraph<V, E>(g2, newEdgeWeights);
        this.paths = new HashMap<V, ShortestPathAlgorithm.SingleSourcePaths<V, E>>();
        for (V v : g2.vertexSet()) {
            DijkstraClosestFirstIterator<V, E> it = new DijkstraClosestFirstIterator<V, E>(newEdgeWeightsGraph, v, Double.POSITIVE_INFINITY);
            while (it.hasNext()) {
                it.next();
            }
            Map<V, Pair<Double, E>> distanceAndPredecessorMap = it.getDistanceAndPredecessorMap();
            HashMap<V, Pair<Double, E>> newDistanceAndPredecessorMap = new HashMap<V, Pair<Double, E>>();
            for (V u : g2.vertexSet()) {
                Pair<Double, E> oldPair = distanceAndPredecessorMap.get(u);
                if (oldPair == null) continue;
                Pair<Double, E> newPair = Pair.of(oldPair.getFirst() - vertexWeights.get(v) + vertexWeights.get(u), oldPair.getSecond());
                newDistanceAndPredecessorMap.put(u, newPair);
            }
            this.paths.put((TreeSingleSourcePathsImpl<V, E>)v, (ShortestPathAlgorithm.SingleSourcePaths<TreeSingleSourcePathsImpl<V, E>, E>)new TreeSingleSourcePathsImpl<V, E>(g2, v, newDistanceAndPredecessorMap));
        }
    }

    private Map<V, Double> computeVertexWeights(Graph<V, E> g2) {
        assert (g2.getType().isDirected());
        Graph extraGraph = GraphTypeBuilder.directed().allowingMultipleEdges(true).allowingSelfLoops(true).edgeSupplier(this.graph.getEdgeSupplier()).vertexSupplier(this.graph.getVertexSupplier()).buildGraph();
        Object s2 = null;
        if (this.vertexFactory != null) {
            s2 = this.vertexFactory.createVertex();
            if (!extraGraph.addVertex(s2)) {
                throw new IllegalArgumentException("Invalid vertex factory");
            }
        } else {
            s2 = extraGraph.addVertex();
            if (s2 == null) {
                throw new IllegalArgumentException("Invalid vertex supplier (does not return unique vertices on each call).");
            }
        }
        HashMap zeroWeightFunction = new HashMap();
        for (V v : g2.vertexSet()) {
            extraGraph.addVertex(v);
            zeroWeightFunction.put(extraGraph.addEdge(s2, v), 0.0);
        }
        AsGraphUnion unionGraph = new AsGraphUnion(new AsWeightedGraph(extraGraph, zeroWeightFunction), g2);
        ShortestPathAlgorithm.SingleSourcePaths paths = new BellmanFordShortestPath(unionGraph).getPaths(s2);
        HashMap<V, Double> weights = new HashMap<V, Double>();
        for (V v : g2.vertexSet()) {
            weights.put(v, paths.getWeight(v));
        }
        return weights;
    }
}

