/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;

public class NaiveLcaFinder<V, E> {
    private Graph<V, E> graph;

    public NaiveLcaFinder(Graph<V, E> graph) {
        this.graph = GraphTests.requireDirected(graph, "Graph must be directed");
    }

    public V findLca(V a, V b) {
        return this.findLca(Collections.singleton(a), Collections.singleton(b), new LinkedHashSet(), new LinkedHashSet());
    }

    public Set<V> findLcas(V a, V b) {
        Set intersection;
        Set[] visitedSets = new Set[]{new LinkedHashSet(), new LinkedHashSet()};
        this.doubleBfs(a, b, visitedSets);
        if (visitedSets[0].size() < visitedSets[1].size()) {
            visitedSets[0].retainAll(visitedSets[1]);
            intersection = visitedSets[0];
        } else {
            visitedSets[1].retainAll(visitedSets[0]);
            intersection = visitedSets[1];
        }
        LinkedHashSet<V> nonLeaves = new LinkedHashSet<V>();
        for (Object node : intersection) {
            for (E edge : this.graph.incomingEdgesOf(node)) {
                V source;
                if (!this.graph.getEdgeTarget(edge).equals(node) || !intersection.contains(source = this.graph.getEdgeSource(edge))) continue;
                nonLeaves.add(source);
            }
        }
        intersection.removeAll(nonLeaves);
        return intersection;
    }

    private void doubleBfs(V a, V b, Set<V>[] visitedSets) {
        Queue[] queues = new Queue[]{new ArrayDeque(), new ArrayDeque()};
        queues[0].add(a);
        queues[1].add(b);
        visitedSets[0].add(a);
        visitedSets[1].add(b);
        int ind = 0;
        while (!queues[0].isEmpty() || !queues[1].isEmpty()) {
            Object node;
            if (!(queues[ind].isEmpty() || visitedSets[0].contains(node = queues[ind].poll()) && visitedSets[1].contains(node))) {
                for (E edge : this.graph.incomingEdgesOf(node)) {
                    V source;
                    if (!this.graph.getEdgeTarget(edge).equals(node) || visitedSets[ind].contains(source = this.graph.getEdgeSource(edge))) continue;
                    queues[ind].add(source);
                    visitedSets[ind].add(source);
                }
            }
            ind ^= 1;
        }
    }

    private V findLca(Set<V> aSet, Set<V> bSet, LinkedHashSet<V> aSeenSet, LinkedHashSet<V> bSeenSet) {
        while (aSet.size() != 0 || bSet.size() != 0) {
            if (!Collections.disjoint(aSet, bSeenSet)) {
                return this.overlappingMember(aSet, bSeenSet);
            }
            if (!Collections.disjoint(bSet, aSeenSet)) {
                return this.overlappingMember(bSet, aSeenSet);
            }
            if (!Collections.disjoint(aSet, bSet)) {
                return this.overlappingMember(aSet, bSet);
            }
            aSeenSet.addAll(aSet);
            bSeenSet.addAll(bSet);
            aSet = this.allParents(aSet);
            aSet.removeAll(aSeenSet);
            bSet = this.allParents(bSet);
            bSet.removeAll(bSeenSet);
        }
        return null;
    }

    private Set<V> allParents(Set<V> vertexSet) {
        HashSet<V> result2 = new HashSet<V>();
        for (V e : vertexSet) {
            for (E edge : this.graph.incomingEdgesOf(e)) {
                if (!this.graph.getEdgeTarget(edge).equals(e)) continue;
                result2.add(this.graph.getEdgeSource(edge));
            }
        }
        return result2;
    }

    private V overlappingMember(Set<V> x, Set<V> y) {
        y.retainAll(x);
        return y.iterator().next();
    }
}

