/*
 * Decompiled with CFR 0.152.
 */
package viper.silver.cfg.utility;

import java.io.Serializable;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcIZ$sp;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;
import viper.silver.cfg.Block;
import viper.silver.cfg.Cfg;
import viper.silver.cfg.ConditionalEdge;
import viper.silver.cfg.ConstrainingBlock;
import viper.silver.cfg.ConstrainingBlock$;
import viper.silver.cfg.Edge;
import viper.silver.cfg.Kind$;
import viper.silver.cfg.LoopHeadBlock;
import viper.silver.cfg.LoopHeadBlock$;
import viper.silver.cfg.StatementBlock;
import viper.silver.cfg.StatementBlock$;
import viper.silver.cfg.UnconditionalEdge;
import viper.silver.cfg.utility.Dominators;
import viper.silver.cfg.utility.Dominators$;

public final class LoopDetector$ {
    public static LoopDetector$ MODULE$;

    static {
        new LoopDetector$();
    }

    public <C extends Cfg<S, E>, S, E> C detect(C cfg, Map<Block<S, E>, scala.collection.immutable.Set<Block<S, E>>> loops) {
        scala.collection.mutable.Map allLoops = ((scala.collection.mutable.Map)Map$.MODULE$.apply(loops.toSeq())).withDefault((Function1<Block, scala.collection.immutable.Set> & Serializable & scala.Serializable)x$1 -> (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$));
        Dominators dominators = new Dominators(cfg);
        if (!this.isReducible(cfg, dominators)) {
            throw new IllegalArgumentException("Control flow graph is not reducible.");
        }
        cfg.edges().withFilter((Function1<Edge, Object> & Serializable & scala.Serializable)edge -> BoxesRunTime.boxToBoolean(dominators.isBackedge(edge))).foreach((Function1<Edge, Object> & Serializable & scala.Serializable)edge -> {
            LoopDetector$.$anonfun$detect$3(cfg, allLoops, edge);
            return BoxedUnit.UNIT;
        });
        Queue queue = (Queue)Queue$.MODULE$.apply(Nil$.MODULE$);
        scala.collection.mutable.Map heads = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        LinkedHashSet blocks = (LinkedHashSet)LinkedHashSet$.MODULE$.apply(Nil$.MODULE$);
        LinkedHashSet edges = (LinkedHashSet)LinkedHashSet$.MODULE$.apply(Nil$.MODULE$);
        Block<S, E> entry = cfg.entry();
        Option<Block<S, E>> exit = cfg.exit();
        queue.enqueue(Predef$.MODULE$.wrapRefArray((Object[])new Block[]{entry}));
        blocks.add(entry);
        while (queue.nonEmpty()) {
            Block block = (Block)queue.dequeue();
            cfg.outEdges(block).foreach((Function1<Edge, Object> & Serializable & scala.Serializable)edge -> {
                Serializable serializable;
                Serializable serializable2;
                Block last;
                Block block;
                scala.collection.immutable.Set before = (scala.collection.immutable.Set)allLoops.apply(edge.source());
                scala.collection.immutable.Set after = (scala.collection.immutable.Set)allLoops.apply(edge.target());
                int out = ((TraversableOnce)before.$minus$minus(after)).size();
                int in = ((TraversableOnce)after.$minus$minus(before)).size();
                int mid = Math.max(out + in - 1, 0);
                Block first = (Block)heads.getOrElse(edge.source(), (Function0<Block> & Serializable & scala.Serializable)() -> edge.source());
                if (0 < in && out == 0) {
                    StatementBlock statementBlock;
                    Option option;
                    LoopHeadBlock loopHeadBlock;
                    LoopHeadBlock loopHeadBlock2;
                    Option option2;
                    Block block2 = edge.target();
                    if (block2 instanceof LoopHeadBlock && !(option2 = LoopHeadBlock$.MODULE$.unapply(loopHeadBlock2 = (LoopHeadBlock)block2)).isEmpty()) {
                        loopHeadBlock = loopHeadBlock2;
                    } else if (block2 instanceof StatementBlock && !(option = StatementBlock$.MODULE$.unapply(statementBlock = (StatementBlock)block2)).isEmpty()) {
                        Seq stmts;
                        Seq x$4 = stmts = option.get();
                        Nil$ x$5 = LoopHeadBlock$.MODULE$.apply$default$1();
                        LoopHeadBlock head = LoopHeadBlock$.MODULE$.apply(x$5, x$4);
                        heads.put(statementBlock, head);
                        loopHeadBlock = head;
                    } else {
                        ConstrainingBlock constrainingBlock;
                        Option option3;
                        if (block2 instanceof ConstrainingBlock && !(option3 = ConstrainingBlock$.MODULE$.unapply(constrainingBlock = (ConstrainingBlock)block2)).isEmpty()) {
                            throw Predef$.MODULE$.$qmark$qmark$qmark();
                        }
                        throw Predef$.MODULE$.$qmark$qmark$qmark();
                    }
                    block = loopHeadBlock;
                } else {
                    block = last = (Block)heads.getOrElse(edge.target(), (Function0<Block> & Serializable & scala.Serializable)() -> edge.target());
                }
                if (mid == 0) {
                    scala.Serializable serializable3;
                    Enumeration.Value kind = out > 0 ? Kind$.MODULE$.Out() : (in > 0 ? Kind$.MODULE$.In() : Kind$.MODULE$.Normal());
                    Edge edge2 = edge;
                    if (edge2 instanceof UnconditionalEdge) {
                        serializable3 = new UnconditionalEdge(first, last, kind);
                    } else if (edge2 instanceof ConditionalEdge) {
                        ConditionalEdge conditionalEdge = (ConditionalEdge)edge2;
                        Object condition = conditionalEdge.condition();
                        serializable3 = new ConditionalEdge(condition, first, last, kind);
                    } else {
                        throw new MatchError(edge2);
                    }
                    UnconditionalEdge updated = serializable3;
                    serializable2 = BoxesRunTime.boxToBoolean(edges.add(updated));
                } else {
                    Option option;
                    ObjectRef<Block> source = ObjectRef.create(first);
                    Edge edge3 = edge;
                    if (edge3 instanceof ConditionalEdge) {
                        ConditionalEdge conditionalEdge = (ConditionalEdge)edge3;
                        Object c2 = conditionalEdge.condition();
                        option = new Some(c2);
                    } else {
                        option = None$.MODULE$;
                    }
                    ObjectRef<None$> condition = ObjectRef.create(option);
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), mid).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)index -> {
                        scala.Serializable serializable;
                        StatementBlock target;
                        StatementBlock statementBlock;
                        if (index == mid) {
                            statementBlock = last;
                        } else {
                            StatementBlock intermediate = index < in ? LoopHeadBlock$.MODULE$.apply(LoopHeadBlock$.MODULE$.apply$default$1(), LoopHeadBlock$.MODULE$.apply$default$2()) : StatementBlock$.MODULE$.apply(StatementBlock$.MODULE$.apply$default$1());
                            blocks.add(intermediate);
                            statementBlock = target = intermediate;
                        }
                        if (index >= out) {
                            throw (Nothing$)((Object)Kind$.MODULE$);
                        }
                        Enumeration.Value kind = Kind$.MODULE$.Out();
                        Option option = (Option)condition$1.elem;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Object c2 = some.value();
                            serializable = new ConditionalEdge(c2, (Block)source$1.elem, target, kind);
                        } else if (None$.MODULE$.equals(option)) {
                            serializable = new UnconditionalEdge((Block)source$1.elem, target, kind);
                        } else {
                            throw new MatchError(option);
                        }
                        scala.Serializable current = serializable;
                        edges.add(current);
                        source$1.elem = target;
                        condition$1.elem = None$.MODULE$;
                    });
                    serializable2 = BoxedUnit.UNIT;
                }
                if (!blocks.contains(last)) {
                    queue.enqueue(Predef$.MODULE$.wrapRefArray((Object[])new Block[]{edge.target()}));
                    serializable = BoxesRunTime.boxToBoolean(blocks.add(last));
                } else {
                    serializable = BoxedUnit.UNIT;
                }
                return serializable;
            });
        }
        return (C)cfg.copy(blocks.toList(), edges.toList(), entry, exit);
    }

    public <C extends Cfg<S, E>, S, E> Map<Block<S, E>, scala.collection.immutable.Set<Block<S, E>>> detect$default$2() {
        return (Map)Predef$.MODULE$.Map().apply(Nil$.MODULE$);
    }

    public <S, E> boolean isReducible(Cfg<S, E> cfg) {
        return this.isReducible(cfg, Dominators$.MODULE$.apply(cfg));
    }

    public <S, E> boolean isReducible(Cfg<S, E> cfg, Dominators<S, E> dominators) {
        boolean reducible;
        int n2 = cfg.blocks().size();
        scala.collection.mutable.Map indices = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        int[] low = Array$.MODULE$.range(0, n2);
        Tuple2 tuple2 = LoopDetector$.dfs$1(cfg.entry(), LoopDetector$.dfs$default$2$1(), cfg, dominators, indices, low);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean bl = reducible = tuple2._2$mcZ$sp();
        boolean reducible2 = bl;
        return reducible2;
    }

    public <S, E> scala.collection.immutable.Set<Block<S, E>> collectBlocks(Cfg<S, E> cfg, Edge<S, E> backedge) {
        Set result2 = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
        Stack stack = (Stack)Stack$.MODULE$.apply(Nil$.MODULE$);
        Block<S, E> head = backedge.target();
        Block<S, E> first = backedge.source();
        stack.push(first);
        result2.add(first);
        while (stack.nonEmpty()) {
            Block current;
            Block block = current = (Block)stack.pop();
            Block<S, E> block2 = head;
            if (!(block == null ? block2 != null : !block.equals(block2))) continue;
            cfg.predecessors(current).withFilter((Function1<Block, Object> & Serializable & scala.Serializable)predecessor -> BoxesRunTime.boxToBoolean(LoopDetector$.$anonfun$collectBlocks$1(result2, predecessor))).foreach((Function1<Block, Object> & Serializable & scala.Serializable)predecessor -> BoxesRunTime.boxToBoolean(LoopDetector$.$anonfun$collectBlocks$2(result2, stack, predecessor)));
        }
        return result2.toSet();
    }

    public static final /* synthetic */ void $anonfun$detect$3(Cfg cfg$1, scala.collection.mutable.Map allLoops$1, Edge edge) {
        Block head = edge.target();
        scala.collection.immutable.Set blocks = MODULE$.collectBlocks(cfg$1, edge);
        blocks.foreach((Function1<Block, Option> & Serializable & scala.Serializable)block -> {
            scala.collection.immutable.Set updated = (scala.collection.immutable.Set)((SetLike)allLoops$1.apply(block)).$plus(head);
            return allLoops$1.put(block, updated);
        });
    }

    private static final Tuple2 dfs$1(Block block, int index, Cfg cfg$2, Dominators dominators$2, scala.collection.mutable.Map indices$1, int[] low$1) {
        indices$1.put(block, BoxesRunTime.boxToInteger(index));
        Seq edges = cfg$2.outEdges(block);
        Tuple3<Integer, Integer, Boolean> tuple3 = edges.foldLeft(new Tuple3<Integer, Integer, Boolean>(BoxesRunTime.boxToInteger(index), BoxesRunTime.boxToInteger(index), BoxesRunTime.boxToBoolean(true)), (Function2<Tuple3, Edge, Tuple3> & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple3<Integer, Integer, Boolean> tuple3;
            Tuple2<Tuple3, Edge> tuple2 = new Tuple2<Tuple3, Edge>((Tuple3)x0$1, (Edge)x1$1);
            if (tuple2 == null) throw new MatchError(tuple2);
            Tuple3 tuple32 = tuple2._1();
            Edge edge = tuple2._2();
            if (tuple32 == null) throw new MatchError(tuple2);
            int currentIndex = BoxesRunTime.unboxToInt(tuple32._1());
            int currentLow = BoxesRunTime.unboxToInt(tuple32._2());
            boolean currentReducible = BoxesRunTime.unboxToBoolean(tuple32._3());
            Block successor = edge.target();
            if (!currentReducible || dominators$2.isBackedge(edge)) {
                tuple3 = new Tuple3<Integer, Integer, Boolean>(BoxesRunTime.boxToInteger(currentIndex), BoxesRunTime.boxToInteger(currentLow), BoxesRunTime.boxToBoolean(currentReducible));
                return tuple3;
            } else if (indices$1.contains(successor)) {
                int successorIndex = BoxesRunTime.unboxToInt(indices$1.apply(successor));
                int successorLow = low$1[successorIndex];
                int nextLow = Math.min(currentLow, successorLow);
                tuple3 = new Tuple3<Integer, Integer, Boolean>(BoxesRunTime.boxToInteger(currentIndex), BoxesRunTime.boxToInteger(nextLow), BoxesRunTime.boxToBoolean(currentReducible));
                return tuple3;
            } else {
                int successorIndex = currentIndex + 1;
                Tuple2 tuple22 = LoopDetector$.dfs$1(successor, successorIndex, cfg$2, dominators$2, indices$1, low$1);
                if (tuple22 == null) throw new MatchError(tuple22);
                int nextIndex = tuple22._1$mcI$sp();
                boolean successorReducible = tuple22._2$mcZ$sp();
                Tuple2$mcIZ$sp tuple2$mcIZ$sp = new Tuple2$mcIZ$sp(nextIndex, successorReducible);
                Tuple2$mcIZ$sp tuple2$mcIZ$sp2 = tuple2$mcIZ$sp;
                int nextIndex2 = ((Tuple2)tuple2$mcIZ$sp2)._1$mcI$sp();
                boolean successorReducible2 = ((Tuple2)tuple2$mcIZ$sp2)._2$mcZ$sp();
                int nextLow = Math.min(currentLow, low$1[successorIndex]);
                boolean nextReducible = currentReducible && successorReducible2;
                low$1[successorIndex] = Integer.MAX_VALUE;
                tuple3 = new Tuple3<Integer, Integer, Boolean>(BoxesRunTime.boxToInteger(nextIndex2), BoxesRunTime.boxToInteger(nextLow), BoxesRunTime.boxToBoolean(nextReducible));
            }
            return tuple3;
        });
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        int lastIndex = BoxesRunTime.unboxToInt(tuple3._1());
        int lastLow = BoxesRunTime.unboxToInt(tuple3._2());
        boolean lastReducible = BoxesRunTime.unboxToBoolean(tuple3._3());
        Tuple3<Integer, Integer, Boolean> tuple32 = new Tuple3<Integer, Integer, Boolean>(BoxesRunTime.boxToInteger(lastIndex), BoxesRunTime.boxToInteger(lastLow), BoxesRunTime.boxToBoolean(lastReducible));
        Tuple3<Integer, Integer, Boolean> tuple33 = tuple32;
        int lastIndex2 = BoxesRunTime.unboxToInt(tuple33._1());
        int lastLow2 = BoxesRunTime.unboxToInt(tuple33._2());
        boolean lastReducible2 = BoxesRunTime.unboxToBoolean(tuple33._3());
        boolean reducible = index <= lastLow2;
        return new Tuple2$mcIZ$sp(lastIndex2, lastReducible2 && reducible);
    }

    private static final int dfs$default$2$1() {
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$collectBlocks$1(Set result$1, Block predecessor) {
        return !result$1.contains(predecessor);
    }

    public static final /* synthetic */ boolean $anonfun$collectBlocks$2(Set result$1, Stack stack$1, Block predecessor) {
        stack$1.push(predecessor);
        return result$1.add(predecessor);
    }

    private LoopDetector$() {
        MODULE$ = this;
    }
}

