/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.Collections;
import java.util.Iterator;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.util.FibonacciHeap;
import org.jgrapht.util.FibonacciHeapNode;

public class ClosestFirstIterator<V, E>
extends CrossComponentIterator<V, E, FibonacciHeapNode<QueueEntry<V, E>>> {
    private FibonacciHeap<QueueEntry<V, E>> heap = new FibonacciHeap();
    private double radius = Double.POSITIVE_INFINITY;
    private boolean initialized = false;

    @Deprecated
    public ClosestFirstIterator(Graph<V, E> g2) {
        this((Graph<Object, E>)g2, null);
    }

    public ClosestFirstIterator(Graph<V, E> g2, V startVertex) {
        this(g2, startVertex, Double.POSITIVE_INFINITY);
    }

    public ClosestFirstIterator(Graph<V, E> g2, Iterable<V> startVertices) {
        this(g2, startVertices, Double.POSITIVE_INFINITY);
    }

    public ClosestFirstIterator(Graph<V, E> g2, V startVertex, double radius) {
        this(g2, (Iterable<V>)(startVertex == null ? null : Collections.singletonList(startVertex)), radius);
    }

    public ClosestFirstIterator(Graph<V, E> g2, Iterable<V> startVertices, double radius) {
        super(g2, startVertices);
        this.radius = radius;
        this.checkRadiusTraversal(this.isCrossComponentTraversal());
        this.initialized = true;
        if (!this.crossComponentTraversal) {
            this.hasNext();
            Iterator<V> iter = startVertices.iterator();
            if (iter.hasNext()) {
                iter.next();
                while (iter.hasNext()) {
                    V v = iter.next();
                    this.encounterVertex(v, null);
                }
            }
        }
    }

    @Override
    public void setCrossComponentTraversal(boolean crossComponentTraversal) {
        if (this.initialized) {
            this.checkRadiusTraversal(crossComponentTraversal);
        }
        super.setCrossComponentTraversal(crossComponentTraversal);
    }

    public double getShortestPathLength(V vertex) {
        FibonacciHeapNode node = (FibonacciHeapNode)this.getSeenData(vertex);
        if (node == null) {
            return Double.POSITIVE_INFINITY;
        }
        return node.getKey();
    }

    public E getSpanningTreeEdge(V vertex) {
        FibonacciHeapNode node = (FibonacciHeapNode)this.getSeenData(vertex);
        if (node == null) {
            return null;
        }
        return ((QueueEntry)node.getData()).spanningTreeEdge;
    }

    @Override
    protected boolean isConnectedComponentExhausted() {
        if (this.heap.size() == 0) {
            return true;
        }
        if (this.heap.min().getKey() > this.radius) {
            this.heap.clear();
            return true;
        }
        return false;
    }

    @Override
    protected void encounterVertex(V vertex, E edge) {
        double shortestPathLength = edge == null ? 0.0 : this.calculatePathLength(vertex, edge);
        FibonacciHeapNode<QueueEntry<V, E>> node = this.createSeenData(vertex, edge);
        this.putSeenData(vertex, node);
        this.heap.insert(node, shortestPathLength);
    }

    @Override
    protected void encounterVertexAgain(V vertex, E edge) {
        FibonacciHeapNode node = (FibonacciHeapNode)this.getSeenData(vertex);
        if (((QueueEntry)node.getData()).frozen) {
            return;
        }
        double candidatePathLength = this.calculatePathLength(vertex, edge);
        if (candidatePathLength < node.getKey()) {
            ((QueueEntry)node.getData()).spanningTreeEdge = edge;
            this.heap.decreaseKey(node, candidatePathLength);
        }
    }

    @Override
    protected V provideNextVertex() {
        FibonacciHeapNode<QueueEntry<V, E>> node = this.heap.removeMin();
        node.getData().frozen = true;
        return node.getData().vertex;
    }

    private void assertNonNegativeEdge(E edge) {
        if (this.getGraph().getEdgeWeight(edge) < 0.0) {
            throw new IllegalArgumentException("negative edge weights not allowed");
        }
    }

    private double calculatePathLength(V vertex, E edge) {
        this.assertNonNegativeEdge(edge);
        Object otherVertex = Graphs.getOppositeVertex(this.getGraph(), edge, vertex);
        FibonacciHeapNode otherEntry = (FibonacciHeapNode)this.getSeenData(otherVertex);
        return otherEntry.getKey() + this.getGraph().getEdgeWeight(edge);
    }

    private void checkRadiusTraversal(boolean crossComponentTraversal) {
        if (crossComponentTraversal && this.radius != Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("radius may not be specified for cross-component traversal");
        }
    }

    private FibonacciHeapNode<QueueEntry<V, E>> createSeenData(V vertex, E edge) {
        QueueEntry entry = new QueueEntry();
        entry.vertex = vertex;
        entry.spanningTreeEdge = edge;
        return new FibonacciHeapNode(entry);
    }

    static class QueueEntry<V, E> {
        E spanningTreeEdge;
        V vertex;
        boolean frozen;

        QueueEntry() {
        }
    }
}

