/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.KShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.KShortestSimplePathsIterator;
import org.jgrapht.alg.shortestpath.PathValidator;
import org.jgrapht.alg.shortestpath.RankingPathElement;
import org.jgrapht.alg.shortestpath.RankingPathElementList;
import org.jgrapht.graph.GraphWalk;

@Deprecated
public class KShortestPaths<V, E>
implements KShortestPathAlgorithm<V, E> {
    private Graph<V, E> graph;
    private int nMaxHops;
    private int nPaths;
    private PathValidator<V, E> pathValidator;

    public KShortestPaths(Graph<V, E> graph, int k) {
        this(graph, k, null);
    }

    public KShortestPaths(Graph<V, E> graph, int k, PathValidator<V, E> pathValidator) {
        this(graph, k, graph.vertexSet().size() - 1, pathValidator);
    }

    public KShortestPaths(Graph<V, E> graph, int k, int nMaxHops) {
        this(graph, k, nMaxHops, null);
    }

    public KShortestPaths(Graph<V, E> graph, int k, int nMaxHops, PathValidator<V, E> pathValidator) {
        this.graph = Objects.requireNonNull(graph, "graph is null");
        if (k <= 0) {
            throw new IllegalArgumentException("Number of paths must be positive");
        }
        this.nMaxHops = nMaxHops;
        if (nMaxHops <= 0) {
            throw new IllegalArgumentException("Max number of hops must be positive");
        }
        this.nPaths = k;
        this.pathValidator = pathValidator;
    }

    @Override
    public List<GraphPath<V, E>> getPaths(V startVertex, V endVertex) {
        Objects.requireNonNull(startVertex, "Start vertex cannot be null");
        Objects.requireNonNull(endVertex, "End vertex cannot be null");
        if (endVertex.equals(startVertex)) {
            throw new IllegalArgumentException("The end vertex is the same as the start vertex!");
        }
        if (!this.graph.containsVertex(startVertex)) {
            throw new IllegalArgumentException("Graph must contain the start vertex!");
        }
        if (!this.graph.containsVertex(endVertex)) {
            throw new IllegalArgumentException("Graph must contain the end vertex!");
        }
        KShortestSimplePathsIterator<V, E> iter = new KShortestSimplePathsIterator<V, E>(this.graph, startVertex, endVertex, this.nPaths, this.pathValidator);
        for (int passNumber = 1; passNumber <= this.nMaxHops && iter.hasNext(); ++passNumber) {
            iter.next();
        }
        RankingPathElementList<V, E> list = iter.getPathElements(endVertex);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<GraphPath<V, GraphWalk<V, E>>> pathList = new ArrayList<GraphPath<V, GraphWalk<V, E>>>();
        for (RankingPathElement rankingPathElement : list) {
            pathList.add(new GraphWalk<V, E>(this.graph, startVertex, rankingPathElement.getVertex(), null, rankingPathElement.createEdgeListPath(), rankingPathElement.getWeight()));
        }
        return pathList;
    }

    @Override
    public List<GraphPath<V, E>> getPaths(V source, V sink, int k) {
        this.nPaths = k;
        return this.getPaths(source, sink);
    }
}

