/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.KShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.BellmanFordShortestPath;
import org.jgrapht.graph.AsWeightedGraph;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.GraphWalk;

public class BhandariKDisjointShortestPaths<V, E>
implements KShortestPathAlgorithm<V, E> {
    private final Graph<V, E> workingGraph;
    private List<List<E>> pathList;
    private Set<E> overlappingEdges;

    public BhandariKDisjointShortestPaths(Graph<V, E> graph) {
        GraphTests.requireDirected(graph);
        if (!GraphTests.isSimple(graph)) {
            throw new IllegalArgumentException("Graph must be simple");
        }
        this.workingGraph = graph.getType().isWeighted() ? new DefaultDirectedWeightedGraph<V, E>(graph.getVertexSupplier(), graph.getEdgeSupplier()) : new AsWeightedGraph<V, E>(graph, new HashMap());
        Graphs.addGraph(this.workingGraph, graph);
    }

    @Override
    public List<GraphPath<V, E>> getPaths(V startVertex, V endVertex, int k) {
        if (k <= 0) {
            throw new IllegalArgumentException("Number of paths must be positive");
        }
        if (endVertex == null) {
            throw new IllegalArgumentException("endVertex is null");
        }
        if (startVertex == null) {
            throw new IllegalArgumentException("startVertex is null");
        }
        if (endVertex.equals(startVertex)) {
            throw new IllegalArgumentException("The end vertex is the same as the start vertex!");
        }
        if (!this.workingGraph.vertexSet().contains(startVertex)) {
            throw new IllegalArgumentException("graph must contain the start vertex!");
        }
        if (!this.workingGraph.vertexSet().contains(endVertex)) {
            throw new IllegalArgumentException("graph must contain the end vertex!");
        }
        this.pathList = new ArrayList<List<E>>();
        for (int cPath = 1; cPath <= k; ++cPath) {
            BellmanFordShortestPath<V, E> bellmanFordShortestPath;
            GraphPath<V, E> currentPath;
            if (cPath > 1) {
                this.prepare(this.pathList.get(cPath - 2));
            }
            if ((currentPath = (bellmanFordShortestPath = new BellmanFordShortestPath<V, E>(this.workingGraph)).getPath(startVertex, endVertex)) == null) break;
            this.pathList.add(currentPath.getEdgeList());
        }
        return this.pathList.size() > 0 ? this.resolvePaths(startVertex, endVertex) : Collections.emptyList();
    }

    private void prepare(List<E> previousPath) {
        for (E originalEdge : previousPath) {
            V source = this.workingGraph.getEdgeSource(originalEdge);
            V target = this.workingGraph.getEdgeTarget(originalEdge);
            this.workingGraph.removeEdge(originalEdge);
            E reversedEdge = this.workingGraph.addEdge(target, source);
            if (reversedEdge == null) continue;
            this.workingGraph.setEdgeWeight(reversedEdge, -this.workingGraph.getEdgeWeight(originalEdge));
        }
    }

    private List<GraphPath<V, E>> resolvePaths(V startVertex, V endVertex) {
        this.findOverlappingEdges();
        List<GraphPath<V, E>> paths = this.buildPaths(startVertex, endVertex);
        Collections.sort(paths, Comparator.comparingDouble(GraphPath::getWeight));
        return paths;
    }

    private List<GraphPath<V, E>> buildPaths(V startVertex, V endVertex) {
        ArrayList paths = new ArrayList();
        HashMap sourceToEdgeLookup = new HashMap();
        Set nonOverlappingEdges = this.pathList.stream().flatMap(Collection::stream).filter(e -> !this.overlappingEdges.contains(e)).collect(Collectors.toSet());
        for (Object t : nonOverlappingEdges) {
            V u = this.workingGraph.getEdgeSource(t);
            if (u.equals(startVertex)) {
                ArrayList path2 = new ArrayList();
                path2.add(t);
                paths.add(path2);
                continue;
            }
            if (!sourceToEdgeLookup.containsKey(u)) {
                sourceToEdgeLookup.put(u, new ArrayDeque());
            } else {
                System.out.println("non empty queue");
            }
            ((ArrayDeque)sourceToEdgeLookup.get(u)).add(t);
        }
        for (List list : paths) {
            V v = this.workingGraph.getEdgeTarget(list.get(0));
            while (!v.equals(endVertex)) {
                Object e3 = ((ArrayDeque)sourceToEdgeLookup.get(v)).poll();
                list.add(e3);
                v = this.workingGraph.getEdgeTarget(e3);
            }
        }
        return paths.stream().map(path -> this.createGraphPath(new ArrayList(path), startVertex, endVertex)).collect(Collectors.toList());
    }

    private void findOverlappingEdges() {
        this.overlappingEdges = new HashSet();
        for (int i = 0; i < this.pathList.size() - 1; ++i) {
            for (E e1 : this.pathList.get(i)) {
                V sourceE1 = this.workingGraph.getEdgeSource(e1);
                V targetE1 = this.workingGraph.getEdgeTarget(e1);
                boolean found = false;
                for (int j = i + 1; j < this.pathList.size(); ++j) {
                    for (E e2 : this.pathList.get(j)) {
                        V sourceE2 = this.workingGraph.getEdgeSource(e2);
                        V targetE2 = this.workingGraph.getEdgeTarget(e2);
                        if ((!sourceE1.equals(sourceE2) || !targetE1.equals(targetE2)) && (!sourceE1.equals(targetE2) || !targetE1.equals(sourceE2))) continue;
                        found = true;
                        this.overlappingEdges.add(e2);
                    }
                }
                if (!found) continue;
                this.overlappingEdges.add(e1);
            }
        }
    }

    private GraphPath<V, E> createGraphPath(List<E> edgeList, V startVertex, V endVertex) {
        double weight = 0.0;
        for (E edge : edgeList) {
            weight += this.workingGraph.getEdgeWeight(edge);
        }
        return new GraphWalk<V, E>(this.workingGraph, startVertex, endVertex, edgeList, weight);
    }
}

