/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.UnionFind;

public class TarjanLowestCommonAncestor<V, E> {
    private Graph<V, E> g;

    public TarjanLowestCommonAncestor(Graph<V, E> g2) {
        this.g = g2;
    }

    public V calculate(V start, V a, V b) {
        LinkedList<LcaRequestResponse<V>> list = new LinkedList<LcaRequestResponse<V>>();
        list.add(new LcaRequestResponse<V>(a, b));
        return this.calculate(start, list).get(0);
    }

    public List<V> calculate(V start, List<LcaRequestResponse<V>> lrr) {
        return new Worker(lrr).calculate(start);
    }

    private static final class MultiMap<V>
    extends HashMap<V, Set<LcaRequestResponse<V>>> {
        private MultiMap() {
        }

        public Set<LcaRequestResponse<V>> getOrCreate(V key) {
            if (!this.containsKey(key)) {
                this.put(key, new HashSet());
            }
            return (Set)this.get(key);
        }
    }

    public static class LcaRequestResponse<V> {
        private V a;
        private V b;
        private V lca;

        public LcaRequestResponse(V a, V b) {
            this.a = a;
            this.b = b;
        }

        public V getA() {
            return this.a;
        }

        public V getB() {
            return this.b;
        }

        public V getLca() {
            return this.lca;
        }

        void setLca(V lca) {
            this.lca = lca;
        }
    }

    private class Worker {
        private UnionFind<V> uf = new UnionFind(Collections.emptySet());
        private Map<V, V> ancestors = new HashMap();
        private Set<V> black = new HashSet();
        private List<LcaRequestResponse<V>> lrr;
        private MultiMap<V> lrrMap;

        private Worker(List<LcaRequestResponse<V>> lrr) {
            this.lrr = lrr;
            this.lrrMap = new MultiMap();
            for (LcaRequestResponse r : lrr) {
                this.lrrMap.getOrCreate(r.getA()).add(r);
                this.lrrMap.getOrCreate(r.getB()).add(r);
            }
        }

        private List<V> calculate(V u) {
            this.uf.addElement(u);
            this.ancestors.put(u, u);
            for (Object vEdge : TarjanLowestCommonAncestor.this.g.edgesOf(u)) {
                if (!TarjanLowestCommonAncestor.this.g.getEdgeSource(vEdge).equals(u)) continue;
                Object v = TarjanLowestCommonAncestor.this.g.getEdgeTarget(vEdge);
                this.calculate(v);
                this.uf.union(u, v);
                this.ancestors.put(this.uf.find(u), u);
            }
            this.black.add(u);
            Set requestsForNodeU = (Set)this.lrrMap.get(u);
            if (requestsForNodeU != null) {
                for (LcaRequestResponse rr : requestsForNodeU) {
                    if (this.black.contains(rr.getB()) && rr.getA().equals(u)) {
                        rr.setLca(this.ancestors.get(this.uf.find(rr.getB())));
                    }
                    if (!this.black.contains(rr.getA()) || !rr.getB().equals(u)) continue;
                    rr.setLca(this.ancestors.get(this.uf.find(rr.getA())));
                }
                this.lrrMap.remove(u);
            }
            LinkedList result2 = new LinkedList();
            for (LcaRequestResponse current : this.lrr) {
                result2.add(current.getLca());
            }
            return result2;
        }
    }
}

