"""Constants for pyhaversion."""

BOARDS = {
    "default": "ova",
    "intel-nuc": "intel-nuc",
    "odroid-c2": "odroid-c2",
    "odroid-n2": "odroid-n2",
    "odroid-xu": "odroid-c2",
    "raspberrypi": "rpi",
    "raspberrypi2": "rpi2",
    "raspberrypi3-64": "rpi3-64",
    "raspberrypi3": "rpi3",
    "tinker": "tinker",
}

IMAGES = {
    "default": {"docker": "home-assistant", "hassio": "default"},
    "intel-nuc": {"docker": "intel-nuc-homeassistant", "hassio": "intel-nuc"},
    "odroid-c2": {"docker": "odroid-c2-homeassistant", "hassio": "odroid-c2"},
    "odroid-n2": {"docker": "odroid-n2-homeassistant", "hassio": "odroid-n2"},
    "odroid-xu": {"docker": "odroid-xu-homeassistant", "hassio": "odroid-xu"},
    "qemuarm-64": {"docker": "qemuarm-64-homeassistant", "hassio": "qemuarm-64"},
    "qemuarm": {"docker": "qemuarm-homeassistant", "hassio": "qemuarm"},
    "qemux86-64": {"docker": "qemux86-64-homeassistant", "hassio": "qemux86-64"},
    "qemux86": {"docker": "qemux86-homeassistant", "hassio": "qemux86"},
    "raspberrypi": {"docker": "raspberrypi-homeassistant", "hassio": "raspberrypi"},
    "raspberrypi2": {"docker": "raspberrypi2-homeassistant", "hassio": "raspberrypi2"},
    "raspberrypi3-64": {
        "docker": "raspberrypi3-64-homeassistant",
        "hassio": "raspberrypi3-64",
    },
    "raspberrypi3": {"docker": "raspberrypi3-homeassistant", "hassio": "raspberrypi3"},
    "raspberrypi4-64": {
        "docker": "raspberrypi4-64-homeassistant",
        "hassio": "raspberrypi4-64",
    },
    "raspberrypi4": {"docker": "raspberrypi4-homeassistant", "hassio": "raspberrypi4"},
    "tinker": {"docker": "tinker-homeassistant", "hassio": "tinker"},
}

URL = {
    "docker": "https://registry.hub.docker.com/v2/repositories/homeassistant/{}/tags",
    "hassio": {
        "stable": "https://version.home-assistant.io/stable.json",
        "beta": "https://version.home-assistant.io/beta.json",
    },
    "pypi": "https://pypi.org/pypi/homeassistant/json",
    "haio": "https://www.home-assistant.io/version.json",
}
