# app - демонстрационное приложение для фреймфорка lightweb4py

# Общая информация

Данное приложение реализовано в рамках курса по паттернам проектирования 
в объектно-ориентированных языках программирования для демонстрации применения таких паттернов 
при реализации приложений на базе фреймворка lightweb4py, также реализованного в рамках данного курса.

При разработке приложения не ставилось задачи 
запрограммировать исчерпывающую реализацию какой-либо функциональности. 
Напротив, в условиях ограниченного времени акцент ставился на реализации MVP (минимального жизнеспособного продукта),
с одной стороны, демонстрирующего требуемый по ТЗ функционал приложения на базе фреймворка lightweb4py, 
а с другой - показывающего эффективное применение паттернов проектирования для написания
расширяемого по функциональности кода приложения, удовлетворяющего принципам DRY и прочим принятым в отрасли критериям 
"хорошего" кода.

## Фреймворк

Фреймворк lightweb4py позволяет с минимальными затратами разработать приложение для работы с HTTP-запросами от 
WSGI-сервера и реализует:
- функциональность маршрутизации запросов в классы-обработчики CBV (Class-Based Views)
с использованием шаблонизатора Jinja2, 
- механизм ORM (Object-Relational Mapping, объектно-реляционное отображение данных) с интерфейсом к JSON и SQLite, 
а также
- логгер с отображением логов на консоль и сохранением их в текстовый файл CSV. 

Детальное описание фреймфорка приведено в его документации.

## Основное приложение

Основное приложение реализует минимальную функциональность административного интерфейса учебного портала:
создание/редактирование/удаление категорий учебных курсов, 
самих курсов с присвоением им категорий и студентов с регистрацией их на курс. 
Также доступна функциональность посылки пользователем сообщений обратной связи и просмотра таких сообщений.

## Микросервисное приложение

Микросервисное приложение предназначено для демонстрации концепции разделения монолитного приложения на микросервисы, 
способные к ограниченному самостоятельному функционированию в условиях отключения (сбоя) других (микро-)сервисов
системы. Оно реализует функциональность посылки пользователем сообщений обратной связи с сохранением их локально и
отправки их в основное приложение в случае его доступности. 

Данное приложение демонстрирует минимизацию фреймворком усилий программиста для разработки простейших web-приложений.

# Информация по использованию приложений

Перед запуском приложения установите необходимые библиотеки:
```
pip install gunicorn, requests
```    
## Основное приложение

Чтобы запустить приложение, наберите (в квадратных скобках - необязательный параметр): 
```        
gunicorn [-b 127.0.0.1:8000] app:app 
```
Для тестирования приложения в браузере на локальном компьютере наберите:
```
http://127.0.0.1:8000
```    
В левой боковой панели приложения реализовано меню навигации, 
где доступны ссылки на страницы с требуемой по ТЗ и дополнительной функциональностью:
- Главная страница (/) - (view Index) список категорий, курсов и студентов; 
при нажатии на названии категории/курса/имени студента или ссылке "Создать ..." в соответствующем столбце
осуществляется переход на страницу создания/редактирования/копирования/удаления 
категории (view ElementEditView)/курса (view CourseEditView)/студента (view StudentEditView).
- Обратная связь (/contact) - (view FeedbackView) страница обратной связи, 
где можно оставить сообщение и контактные данные.
- Блог (/feedback) - (view FeedbackListView) страница сообщений обратной связи, 
отсортированных в порядке от новых обращений к старым.
- Административный интерфейс (/admin) - (view Admin) административный интерфейс из фреймворка lightweb4py, 
демонстрирует детали объекта WSGI request и дает возможность тестирования запросов GET и POST 
с произвольными параметрами. 

## Демонстрационный микросервис

Чтобы запустить микросервисное мини-приложение, наберите:
```
gunicorn -b 127.0.0.1:8001 app_student:app
```
Для тестирования приложения в браузере на локальном компьютере наберите:
```
http://127.0.0.1:8001
```
### Примерный сценарий тестирования совместного функционирования основного и микросервисного приложения

1. Запустите основное и микросервисное приложение, как это описано выше. 
Откройте интерфейсы приложений в браузере.
2. Создайте сообщение обратной связи с микросервисном приложении. 
В папке приложения app/contact_messages проверьте наличие и содержание нового сообщения.
3. В основном приложении в разделе "Блог" проверьте наличие и содержание нового сообщения,
которое было размещено там микросервисом.
4. В основном приложении в разделе "Обратная связь" создайте сообщение обратной связи 
и убедитесь, что оно появилось в разделе "Блог", но не появилось в папке app/contact_messages ,
куда пишет дубликат сообщения микросервисное приложение.

# Общая техническая информация

## Фреймворк

Детальная техническая информация по фреймворку lightweb4py доступна в его описании.

## Основное приложение

Состав приложения (папка demo/ фреймворка):
- contact_messages/ - папка с сообщениями обратной связи, сохраненными микросервисным приложением;
- database/ - папка с файлами данных приложения - JSON или SQLite, в зависимости от настроек в файле settings.py;
- docs/ - папка с описанием приложения;
- docs/_README.md_ - этот файл - описание приложения;
- logs/ - папка с логами;
- templates/ - папка с шаблонами страниц приложения;
- _app.py_ - основной файл, где создается объект app класса Framework, который используется для запуска приложения;
- _category.py_ - класс Category для категорий учебных курсов;
- _course.py_ - класс Course и класс CourseEditView - обработчик для редактирования учебных курсов;
- _element_edit.py_ - класс ElementEditView - обработчик для редактирования произвольных записей данных;
- _feedback.py_ - классы Feedback, FeedbackView и FeedbackListView - функционал приема сообщений обратной связи;
- _logs.py_ - конфигурация логгера;
- _miscellaneous.py_ - функции общего назначения, используемые в приложении; 
- _settings.py_ - некоторые константы общего пользования;
- _student.py_ - класс Student и класс StudentEditView - обработчик для редактирования записей студентов;
- _urls.py_ - объект app_urls с url приложения;
- _views.py_ - некоторые вью приложения:
    - Index - вью главной страницы
    
Все классы-обработчики типового приложения используют систему иерархических темплейтов, 
реализованных классом BaseView фреймворка lightweb4py.
Все классы-обработчики, редактирующие записи базы данных - категории курсов, курсы, студенты - используют класс 
ElementEditView как базовый.

## Демонстрационный микровервис

- _app_student.py_ - основной файл, где создается объект app класса Framework, который используется для запуска 
микросервисного приложения:
    - Contact - класс-обработчик для сообщений пользователя; файлы сообщений сохраняются в папке app/contact_messages.
