# Images

Don't use the constructor directly. Instead use 
```python
from python_on_whales import docker

my_docker_image = docker.image.inspect("my-image-name")

# or

my_docker_image = docker.pull("my-image-name")
```
For type hints, use this

```python
from python_on_whales import docker, Image

def print_dodo(image: Image):
    print(docker.run(image, ["echo", "dodo"]))
```


## Attributes

It attributes are the same that you get with the command line:
`docker image inspect ...`

An example is worth many lines of descriptions.

```
In [1]: from python_on_whales import docker

In [2]: image = docker.pull("ubuntu:20.04")
20.04: Pulling from library/ubuntu
6a5697faee43: Pull complete
ba13d3bc422b: Pull complete
a254829d9e55: Pull complete
Digest: sha256:fff16eea1a8ae92867721d90c59a75652ea66d29c05294e6e2f898704bdb8cf1
Status: Downloaded newer image for ubuntu:20.04
docker.io/library/ubuntu:20.04

In [3]: def super_print(obj):
   ...:     print(f"type={type(obj)}, value={obj}")
   ...:

In [4]: super_print(image.id)
type=<class 'str'>, value=sha256:d70eaf7277eada08fca944de400e7e4dd97b1262c06ed2b1011500caa4decaf1

In [5]: super_print(image.repo_tags)
type=<class 'list'>, value=['ubuntu:20.04']

In [4]: super_print(image.repo_digests)
type=<class 'list'>, value=['ubuntu@sha256:fff16eea1a8ae92867721d90c59a75652ea66d29c05294e6e2f898704bdb8cf1']

In [4]: super_print(image.parent)
type=<class 'str'>, value=

In [5]: super_print(image.comment)
type=<class 'str'>, value=

In [6]: super_print(image.created)
type=<class 'datetime.datetime'>, value=2020-10-23 17:32:36.438324+00:00

In [7]: super_print(image.container)
type=<class 'str'>, value=917be43da4a1ceb52416d44076c5f99b0d20ceca3f5f9a2918a020e05ec3616a

In [8]: super_print(image.docker_version)
type=<class 'str'>, value=18.09.7

In [9]: super_print(image.author)
type=<class 'str'>, value=

In [10]: super_print(image.architecture)
type=<class 'str'>, value=amd64

In [11]: super_print(image.os)
type=<class 'str'>, value=linux

In [12]: super_print(image.size)
type=<class 'int'>, value=72879481

In [13]: super_print(image.virtual_size)
type=<class 'int'>, value=72879481

In [14]: super_print(image.graph_driver)
type=<class 'dict'>, value={'Data': {'LowerDir': '/var/lib/docker/overlay2/901c51ceb48f616058b68ca8a607c260f28574b4f076b94cd08e593d42027098/diff:/var/lib/docker/overlay2/13ca8ace18d7e11d345a421f771eeac7ac498198cc60860e76afcda640f52632/diff', 'MergedDir': '/var/lib/docker/overlay2/0d53f61d2c53b7030882c06d3eb243674d2ad9cddfa285a71f3719d90f3e9fbc/merged', 'UpperDir': '/var/lib/docker/overlay2/0d53f61d2c53b7030882c06d3eb243674d2ad9cddfa285a71f3719d90f3e9fbc/diff', 'WorkDir': '/var/lib/docker/overlay2/0d53f61d2c53b7030882c06d3eb243674d2ad9cddfa285a71f3719d90f3e9fbc/work'}, 'Name': 'overlay2'}

In [15]: super_print(image.metadata)
type=<class 'dict'>, value={'LastTagTime': '0001-01-01T00:00:00Z'}
```

## copy_from


```python
Image.copy_from(path_in_image, destination)
```


Copy a file from a docker image in the local filesystem.

See the `docker.image.copy_from` command for information about the arguments.


----

## copy_to


```python
Image.copy_to(local_path, path_in_image, new_tag=None)
```


Copy a file from the local filesystem in a docker image to create a new
docker image.

As if you did a dockerfile with a COPY instruction.

See the `docker.image.copy_to` command for information about the arguments.


----

## reload


```python
Image.reload()
```


----

## remove


```python
Image.remove(force=False, prune=True)
```


Remove this Docker image.

See the [`docker.image.remove`](../sub-commands/container.md#remove) command for
information about the arguments.


----

## save


```python
Image.save(output=None)
```


Saves this Docker image in a tar.

See the [`docker.image.save`](../sub-commands/container.md#save) command for
information about the arguments.


----

## tag


```python
Image.tag(new_tag)
```


Add a tag to a Docker image.

See the [`docker.image.tag`](../sub-commands/container.md#tag) command for
information about the arguments.


----




