# Refuel Python API

<p align="center"><img height="250" src="https://user-images.githubusercontent.com/1568137/172486199-f4eddb09-7c58-4841-8f3c-60f647079073.png"></p>

This is the [Refuel.ai](https://www.refuel.ai/) Python client library. The primary use for this library is to log your machine learning datasets to the Refuel platform. More features coming soon!

# Installation
You can install this library using `pip`:

```bash
pip install refuel
```

# Usage

Make sure you have a valid API key from Refuel (shared with your team during onboarding). Contact us at support@refuel.ai if you need help. 

## Initialization:

Initialize the Refuel client with your API key. This can be done in one of two ways:

```python
import refuel

# Assuming you've set `REFUEL_API_KEY` in your env,
# init() will pick it up automatically
refuel_client = refuel.init()
```

Alternatively, specify it as an explicit option:
```python
import refuel

options = {
    "api_key": "<YOUR_API_KEY>"
}

logger = refuel.init(**options)
```

## Logging data

### Log a single prediction event (no ground truth)

```python
refuel_client.log(
    model_name='my-model-name',
    x={'id': 'id1', 'image_url': 's3://<bucket>/<path>', 'embedding': [0.42, -0.13, ...]},
    y_pred={'scores': {'cat': 0.92, 'dog': 0.08}, 'label': 'cat'},
    metadata={'camera_id': 'camera1'}
)
```

### Log a single prediction event (with ground truth)

```python
refuel_client.log(
    model_name='my-model-name',
    x={'id': 'id2', 'image_url': 's3://<bucket>/<path>', 'embedding': [0.35, -0.27, ...]},
    y_pred={'scores': {'cat': 0.12, 'dog': 0.88}, 'label': 'dog'},
    y_true={'label': 'cat'},
    metadata={'camera_id': 'camera1'}
)
```

### Log a single prediction event (ground truth becomes available at a later point)

```python
# This will be joined with the rest of the event logged previously
refuel_client.log(
    model_name='my-model-name',
    x={'id': 'id1'},
    y_true={'label': 'cat'},
    metadata={'camera_id': 'camera1'}
)
```

### Log a batch of prediction events

```python
# List of events to be logged. 
events = [{'x': ..., 'y': ..., 'y_true': ..., 'metadata': ...}]

refuel_client.log_batch(
    model_name='my-model-name',
    events=events
)
```
# Questions?

Reach out to us at support@refuel.ai with any questions!
