import logging
from typing import Optional, Tuple, List

from configalchemy import BaseConfig


class DefaultConfig(BaseConfig):

    #: Directory of proto files and py files, support related path. e.g: protos/v1
    #: generated by the protocol buffer compiler
    PROTO_TEMPLATE_ROOT = ""
    PROTO_TEMPLATE_PATH = "protos"

    #: Max workers in service thread pool
    GPRC_SERVER_MAX_WORKERS = 10
    #: An optional list of key-value pairs (channel args in gRPC runtime)
    #: to configure the channel.
    GRPC_SERVER_OPTIONS: List[Tuple[str, str]] = []

    #: The maximum number of concurrent RPCs this server
    #: will service before returning RESOURCE_EXHAUSTED status, or None to
    #: indicate no limit.
    GRPC_SERVER_MAXIMUM_CONCURRENT_RPCS: Optional[int] = None

    #: If set `True` the server will be blocked after run
    GRPC_SERVER_RUN_WITH_BLOCK = True
    #: The host/domain name that this server can serve
    GRPC_SERVER_HOST = "127.0.0.1"
    #: The port this server listen.
    GRPC_SERVER_PORT = 50051

    #: logger level
    GRPC_ALCHEMY_LOGGER_LEVEL = logging.INFO
