import sys
import typing


class bpy_prop_collection:
    '''built-in class used for all collections. '''

    def find(self, key: str) -> int:
        '''Returns the index of a key in a collection or -1 when not found (matches Python’s string find function of the same name). 

        :param key: The identifier for the collection member. 
        :type key: str
        :rtype: int
        :return:  index of the key. 
        '''
        pass

    def foreach_get(self, attr, seq):
        '''Only works for ‘basic type’ properties (bool, int and float)! Multi-dimensional arrays (like array of vectors) will be flattened into seq. 

        '''
        pass

    def foreach_set(self, attr, seq):
        '''Only works for ‘basic type’ properties (bool, int and float)! seq must be uni-dimensional, multi-dimensional arrays (like array of vectors) will be re-created from it. 

        '''
        pass

    def get(self, key: str, default=None):
        '''Returns the value of the item assigned to key or default when not found (matches Python’s dictionary function of the same name). 

        :param key: The identifier for the collection member. 
        :type key: str
        :param default: Optional argument for the value to return if key is not found. 
        :type default: 
        '''
        pass

    def items(self, ) -> list:
        '''Return the identifiers of collection members (matching Python’s dict.items() functionality). 

        :rtype: list
        :return:  (key, value) pairs for each member of this collection. 
        '''
        pass

    def keys(self, ) -> list:
        '''Return the identifiers of collection members (matching Python’s dict.keys() functionality). 

        :rtype: list
        :return:  the identifiers for each member of this collection. 
        '''
        pass

    def values(self, ) -> list:
        '''Return the values of collection (matching Python’s dict.values() functionality). 

        :rtype: list
        :return:  the members of this collection. 
        '''
        pass


class bpy_struct:
    '''built-in base class for all classes in bpy.types. '''

    id_data = None
    '''The bpy.types.ID object this datablock is from or None, (not available for all data types) '''

    def as_pointer(self, ) -> int:
        '''Returns the memory address which holds a pointer to Blender’s internal data 

        :rtype: int
        :return:  int (memory address). 
        '''
        pass

    def driver_add(self, path: str, index: int = -1) -> typing.List['FCurve']:
        '''Adds driver(s) to the given property 

        :param path: path to the property to drive, analogous to the fcurve’s data path. 
        :type path: str
        :param index: array index of the property drive. Defaults to -1 for all indices or a single channel if the property is not an array. 
        :type index: int
        :rtype: typing.List['FCurve']
        :return:  The driver(s) added. 
        '''
        pass

    def driver_remove(self, path: str, index: int = -1) -> bool:
        '''Remove driver(s) from the given property 

        :param path: path to the property to drive, analogous to the fcurve’s data path. 
        :type path: str
        :param index: array index of the property drive. Defaults to -1 for all indices or a single channel if the property is not an array. 
        :type index: int
        :rtype: bool
        :return:  Success of driver removal. 
        '''
        pass

    def get(self, key: str, default=None):
        '''Returns the value of the custom property assigned to key or default when not found (matches Python’s dictionary function of the same name). 

        :param key: The key associated with the custom property. 
        :type key: str
        :param default: Optional argument for the value to return if key is not found. 
        :type default: 
        '''
        pass

    def is_property_hidden(self, property) -> bool:
        '''Check if a property is hidden. 

        :rtype: bool
        :return:  True when the property is hidden. 
        '''
        pass

    def is_property_overridable_library(self, property) -> bool:
        '''Check if a property is overridable. 

        :rtype: bool
        :return:  True when the property is overridable. 
        '''
        pass

    def is_property_readonly(self, property) -> bool:
        '''Check if a property is readonly. 

        :rtype: bool
        :return:  True when the property is readonly (not writable). 
        '''
        pass

    def is_property_set(self, property) -> bool:
        '''Check if a property is set, use for testing operator properties. 

        :rtype: bool
        :return:  True when the property has been set. 
        '''
        pass

    def items(self, ) -> list:
        '''Returns the items of this objects custom properties (matches Python’s dictionary function of the same name). 

        :rtype: list
        :return:  custom property key, value pairs. 
        '''
        pass

    def keyframe_delete(self,
                        data_path: str,
                        index: int = -1,
                        frame: float = None,
                        group: str = "") -> bool:
        '''Remove a keyframe from this properties fcurve. 

        :param data_path: path to the property to remove a key, analogous to the fcurve’s data path. 
        :type data_path: str
        :param index: array index of the property to remove a key. Defaults to -1 removing all indices or a single channel if the property is not an array. 
        :type index: int
        :param frame: The frame on which the keyframe is deleted, defaulting to the current frame. 
        :type frame: float
        :param group: The name of the group the F-Curve should be added to if it doesn’t exist yet. 
        :type group: str
        :rtype: bool
        :return:  Success of keyframe deleation. 
        '''
        pass

    def keyframe_insert(self,
                        data_path: str,
                        index: int = -1,
                        frame: float = None,
                        group: str = "",
                        options=set()) -> bool:
        '''Note that when keying data paths which contain nested properties this must be done from the ID subclass, in this case the Armature rather than the bone. 

        :param data_path: path to the property to key, analogous to the fcurve’s data path. 
        :type data_path: str
        :param index: array index of the property to key. Defaults to -1 which will key all indices or a single channel if the property is not an array. 
        :type index: int
        :param frame: The frame on which the keyframe is inserted, defaulting to the current frame. 
        :type frame: float
        :param group: The name of the group the F-Curve should be added to if it doesn’t exist yet. 
        :type group: str
        :param options: Optional set of flags:INSERTKEY_NEEDED Only insert keyframes where they’re needed in the relevant F-Curves.INSERTKEY_VISUAL Insert keyframes based on ‘visual transforms’.INSERTKEY_XYZ_TO_RGB Color for newly added transformation F-Curves (Location, Rotation, Scale) is based on the transform axis.INSERTKEY_REPLACE Only replace already existing keyframes.INSERTKEY_AVAILABLE Only insert into already existing F-Curves.INSERTKEY_CYCLE_AWARE Take cyclic extrapolation into account (Cycle-Aware Keying option). 
        :type options: 
        :rtype: bool
        :return:  Success of keyframe insertion. 
        '''
        pass

    def keys(self, ) -> list:
        '''Returns the keys of this objects custom properties (matches Python’s dictionary function of the same name). 

        :rtype: list
        :return:  custom property keys. 
        '''
        pass

    def path_from_id(self, property: str = "") -> str:
        '''Returns the data path from the ID to this object (string). 

        :param property: Optional property name which can be used if the path is to a property of this object. 
        :type property: str
        :rtype: str
        :return:  The path from bpy.types.bpy_struct.id_data to this struct and property (when given). 
        '''
        pass

    def path_resolve(self, path: str, coerce: bool = True):
        '''Returns the property from the path, raise an exception when not found. 

        :param path: path which this property resolves. 
        :type path: str
        :param coerce: optional argument, when True, the property will be converted into its Python representation. 
        :type coerce: bool
        '''
        pass

    def pop(self, key: str, default=None):
        '''Remove and return the value of the custom property assigned to key or default when not found (matches Python’s dictionary function of the same name). 

        :param key: The key associated with the custom property. 
        :type key: str
        :param default: Optional argument for the value to return if key is not found. 
        :type default: 
        '''
        pass

    def property_overridable_library_set(self, property, overridable) -> bool:
        '''Define a property as overridable or not (only for custom properties!). 

        :rtype: bool
        :return:  True when the overridable status of the property was successfully set. 
        '''
        pass

    def property_unset(self, property):
        '''Unset a property, will use default value afterward. 

        '''
        pass

    def type_recast(self, ) -> 'bpy_struct':
        '''Return a new instance, this is needed because types such as textures can be changed at runtime. 

        :rtype: 'bpy_struct'
        :return:  a new instance of this object with the type initialized again. 
        '''
        pass

    def values(self, ) -> list:
        '''Returns the values of this objects custom properties (matches Python’s dictionary function of the same name). 

        :rtype: list
        :return:  custom property values. 
        '''
        pass


class ActionFCurves(bpy_struct):
    '''Collection of action F-Curves '''

    def new(self, data_path: str, index: int = 0,
            action_group: str = "") -> 'FCurve':
        '''Add an F-Curve to the action 

        :param data_path: Data Path, F-Curve data path to use 
        :type data_path: str
        :param index: Index, Array index 
        :type index: int
        :param action_group: Action Group, Acton group to add this F-Curve into 
        :type action_group: str
        :rtype: 'FCurve'
        :return:  Newly created F-Curve 
        '''
        pass

    def find(self, data_path: str, index: int = 0) -> 'FCurve':
        '''Find an F-Curve. Note that this function performs a linear scan of all F-Curves in the action. 

        :param data_path: Data Path, F-Curve data path 
        :type data_path: str
        :param index: Index, Array index 
        :type index: int
        :rtype: 'FCurve'
        :return:  The found F-Curve, or None if it doesn’t exist 
        '''
        pass

    def remove(self, fcurve: 'FCurve'):
        '''Remove action group 

        :param fcurve: F-Curve to remove 
        :type fcurve: 'FCurve'
        '''
        pass


class ActionGroup(bpy_struct):
    '''Groups of F-Curves '''

    channels: typing.Union[typing.List['FCurve'], 'bpy_prop_collection'] = None
    '''F-Curves in this group 

    :type: typing.Union[typing.List['FCurve'], 'bpy_prop_collection']
    '''

    color_set: typing.Union[str, int] = None
    '''Custom color set to use 

    :type: typing.Union[str, int]
    '''

    colors: 'ThemeBoneColorSet' = None
    '''Copy of the colors associated with the group’s color set 

    :type: 'ThemeBoneColorSet'
    '''

    is_custom_color_set: bool = None
    '''Color set is user-defined instead of a fixed theme color set 

    :type: bool
    '''

    lock: bool = None
    '''Action group is locked 

    :type: bool
    '''

    name: str = None
    '''

    :type: str
    '''

    select: bool = None
    '''Action group is selected 

    :type: bool
    '''

    show_expanded: bool = None
    '''Action group is expanded except in graph editor 

    :type: bool
    '''

    show_expanded_graph: bool = None
    '''Action group is expanded in graph editor 

    :type: bool
    '''


class ActionGroups(bpy_struct):
    '''Collection of action groups '''

    def new(self, name: str) -> 'ActionGroup':
        '''Create a new action group and add it to the action 

        :param name: New name for the action group 
        :type name: str
        :rtype: 'ActionGroup'
        :return:  Newly created action group 
        '''
        pass

    def remove(self, action_group: 'ActionGroup'):
        '''Remove action group 

        :param action_group: Action group to remove 
        :type action_group: 'ActionGroup'
        '''
        pass


class ActionPoseMarkers(bpy_struct):
    '''Collection of timeline markers '''

    active: 'TimelineMarker' = None
    '''Active pose marker for this action 

    :type: 'TimelineMarker'
    '''

    active_index: int = None
    '''Index of active pose marker 

    :type: int
    '''

    def new(self, name: str) -> 'TimelineMarker':
        '''Add a pose marker to the action 

        :param name: New name for the marker (not unique) 
        :type name: str
        :rtype: 'TimelineMarker'
        :return:  Newly created marker 
        '''
        pass

    def remove(self, marker: 'TimelineMarker'):
        '''Remove a timeline marker 

        :param marker: Timeline marker to remove 
        :type marker: 'TimelineMarker'
        '''
        pass


class Addon(bpy_struct):
    '''Python add-ons to be loaded automatically '''

    module: str = None
    '''Module name 

    :type: str
    '''

    preferences: 'AddonPreferences' = None
    '''

    :type: 'AddonPreferences'
    '''


class AddonPreferences(bpy_struct):
    bl_idname: str = None
    '''

    :type: str
    '''


class Addons(bpy_struct):
    '''Collection of add-ons '''

    pass


class AlembicObjectPath(bpy_struct):
    '''Path of an object inside of an Alembic archive '''

    path: str = None
    '''Object path 

    :type: str
    '''


class AlembicObjectPaths(bpy_struct):
    '''Collection of object paths '''

    pass


class AnimData(bpy_struct):
    '''Animation data for data-block '''

    action: 'Action' = None
    '''Active Action for this data-block 

    :type: 'Action'
    '''

    action_blend_type: typing.Union[str, int] = None
    '''Method used for combining Active Action’s result with result of NLA stack 

    :type: typing.Union[str, int]
    '''

    action_extrapolation: typing.Union[str, int] = None
    '''Action to take for gaps past the Active Action’s range (when evaluating with NLA) 

    :type: typing.Union[str, int]
    '''

    action_influence: float = None
    '''Amount the Active Action contributes to the result of the NLA stack 

    :type: float
    '''

    drivers: typing.Union[typing.List['FCurve'], 'bpy_prop_collection',
                          'AnimDataDrivers'] = None
    '''The Drivers/Expressions for this data-block 

    :type: typing.Union[typing.List['FCurve'], 'bpy_prop_collection', 'AnimDataDrivers']
    '''

    nla_tracks: typing.Union[typing.List['NlaTrack'], 'bpy_prop_collection',
                             'NlaTracks'] = None
    '''NLA Tracks (i.e. Animation Layers) 

    :type: typing.Union[typing.List['NlaTrack'], 'bpy_prop_collection', 'NlaTracks']
    '''

    use_nla: bool = None
    '''NLA stack is evaluated when evaluating this block 

    :type: bool
    '''

    use_tweak_mode: bool = None
    '''Whether to enable or disable tweak mode in NLA 

    :type: bool
    '''

    def nla_tweak_strip_time_to_scene(self, frame: float,
                                      invert: bool = False) -> float:
        '''Convert a time value from the local time of the tweaked strip to scene time, exactly as done by built-in key editing tools. Returns the input time unchanged if not tweaking. 

        :param frame: Input time 
        :type frame: float
        :param invert: Invert, Convert scene time to action time 
        :type invert: bool
        :rtype: float
        :return:  Converted time 
        '''
        pass


class AnimDataDrivers(bpy_struct):
    '''Collection of Driver F-Curves '''

    def new(self, data_path: str, index: int = 0) -> 'FCurve':
        '''new 

        :param data_path: Data Path, F-Curve data path to use 
        :type data_path: str
        :param index: Index, Array index 
        :type index: int
        :rtype: 'FCurve'
        :return:  Newly Driver F-Curve 
        '''
        pass

    def remove(self, driver):
        '''remove 

        '''
        pass

    def from_existing(self, src_driver: 'FCurve' = None) -> 'FCurve':
        '''Add a new driver given an existing one 

        :param src_driver: Existing Driver F-Curve to use as template for a new one 
        :type src_driver: 'FCurve'
        :rtype: 'FCurve'
        :return:  New Driver F-Curve 
        '''
        pass

    def find(self, data_path: str, index: int = 0) -> 'FCurve':
        '''Find a driver F-Curve. Note that this function performs a linear scan of all driver F-Curves. 

        :param data_path: Data Path, F-Curve data path 
        :type data_path: str
        :param index: Index, Array index 
        :type index: int
        :rtype: 'FCurve'
        :return:  The found F-Curve, or None if it doesn’t exist 
        '''
        pass


class AnimViz(bpy_struct):
    '''Settings for the visualization of motion '''

    motion_path: 'AnimVizMotionPaths' = None
    '''Motion Path settings for visualization 

    :type: 'AnimVizMotionPaths'
    '''


class AnimVizMotionPaths(bpy_struct):
    '''Motion Path settings for animation visualization '''

    bake_location: typing.Union[str, int] = None
    '''When calculating Bone Paths, use Head or Tips 

    :type: typing.Union[str, int]
    '''

    frame_after: int = None
    '''Number of frames to show after the current frame (only for ‘Around Current Frame’ Onion-skinning method) 

    :type: int
    '''

    frame_before: int = None
    '''Number of frames to show before the current frame (only for ‘Around Current Frame’ Onion-skinning method) 

    :type: int
    '''

    frame_end: int = None
    '''End frame of range of paths to display/calculate (not for ‘Around Current Frame’ Onion-skinning method) 

    :type: int
    '''

    frame_start: int = None
    '''Starting frame of range of paths to display/calculate (not for ‘Around Current Frame’ Onion-skinning method) 

    :type: int
    '''

    frame_step: int = None
    '''Number of frames between paths shown (not for ‘On Keyframes’ Onion-skinning method) 

    :type: int
    '''

    has_motion_paths: bool = None
    '''Are there any bone paths that will need updating (read-only) 

    :type: bool
    '''

    show_frame_numbers: bool = None
    '''Show frame numbers on Motion Paths 

    :type: bool
    '''

    show_keyframe_action_all: bool = None
    '''For bone motion paths, search whole Action for keyframes instead of in group with matching name only (is slower) 

    :type: bool
    '''

    show_keyframe_highlight: bool = None
    '''Emphasize position of keyframes on Motion Paths 

    :type: bool
    '''

    show_keyframe_numbers: bool = None
    '''Show frame numbers of Keyframes on Motion Paths 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''Type of range to show for Motion Paths 

    :type: typing.Union[str, int]
    '''


class AnyType(bpy_struct):
    '''RNA type used for pointers to any possible data '''

    pass


class Area(bpy_struct):
    '''Area in a subdivided screen, containing an editor '''

    height: int = None
    '''Area height 

    :type: int
    '''

    regions: typing.Union[typing.List['Region'], 'bpy_prop_collection'] = None
    '''Regions this area is subdivided in 

    :type: typing.Union[typing.List['Region'], 'bpy_prop_collection']
    '''

    show_menus: bool = None
    '''Show menus in the header 

    :type: bool
    '''

    spaces: typing.Union[typing.List['Space'], 'bpy_prop_collection',
                         'AreaSpaces'] = None
    '''Spaces contained in this area, the first being the active space (NOTE: Useful for example to restore a previously used 3D view space in a certain area to get the old view orientation) 

    :type: typing.Union[typing.List['Space'], 'bpy_prop_collection', 'AreaSpaces']
    '''

    type: typing.Union[str, int] = None
    '''Current editor type for this area 

    :type: typing.Union[str, int]
    '''

    ui_type: typing.Union[str, int] = None
    '''Current editor type for this area 

    :type: typing.Union[str, int]
    '''

    width: int = None
    '''Area width 

    :type: int
    '''

    x: int = None
    '''The window relative vertical location of the area 

    :type: int
    '''

    y: int = None
    '''The window relative horizontal location of the area 

    :type: int
    '''

    def tag_redraw(self, ):
        '''tag_redraw 

        '''
        pass

    def header_text_set(self, text: str):
        '''Set the header status text 

        :param text: Text, New string for the header, None clears the text 
        :type text: str
        '''
        pass


class AreaSpaces(bpy_struct):
    '''Collection of spaces '''

    active: 'Space' = None
    '''Space currently being displayed in this area 

    :type: 'Space'
    '''


class ArmatureBones(bpy_struct):
    '''Collection of armature bones '''

    active: 'Bone' = None
    '''Armature’s active bone 

    :type: 'Bone'
    '''


class ArmatureConstraintTargets(bpy_struct):
    '''Collection of target bones and weights '''

    def new(self, ) -> 'ConstraintTargetBone':
        '''Add a new target to the constraint 

        :rtype: 'ConstraintTargetBone'
        :return:  New target bone 
        '''
        pass

    def remove(self, target: 'ConstraintTargetBone'):
        '''Delete target from the constraint 

        :param target: Target to remove 
        :type target: 'ConstraintTargetBone'
        '''
        pass

    def clear(self, ):
        '''Delete all targets from object 

        '''
        pass


class ArmatureEditBones(bpy_struct):
    '''Collection of armature edit bones '''

    active: 'EditBone' = None
    '''Armatures active edit bone 

    :type: 'EditBone'
    '''

    def new(self, name: str) -> 'EditBone':
        '''Add a new bone 

        :param name: New name for the bone 
        :type name: str
        :rtype: 'EditBone'
        :return:  Newly created edit bone 
        '''
        pass

    def remove(self, bone: 'EditBone'):
        '''Remove an existing bone from the armature 

        :param bone: EditBone to remove 
        :type bone: 'EditBone'
        '''
        pass


class BakePixel(bpy_struct):
    du_dx: float = None
    '''

    :type: float
    '''

    du_dy: float = None
    '''

    :type: float
    '''

    dv_dx: float = None
    '''

    :type: float
    '''

    dv_dy: float = None
    '''

    :type: float
    '''

    next: 'BakePixel' = None
    '''

    :type: 'BakePixel'
    '''

    object_id: int = None
    '''

    :type: int
    '''

    primitive_id: int = None
    '''

    :type: int
    '''

    uv: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class BakeSettings(bpy_struct):
    '''Bake data for a Scene data-block '''

    cage_extrusion: float = None
    '''Distance to use for the inward ray cast when using selected to active 

    :type: float
    '''

    cage_object: 'Object' = None
    '''Object to use as cage instead of calculating the cage from the active object with cage extrusion 

    :type: 'Object'
    '''

    filepath: str = None
    '''Image filepath to use when saving externally 

    :type: str
    '''

    height: int = None
    '''Vertical dimension of the baking map 

    :type: int
    '''

    image_settings: 'ImageFormatSettings' = None
    '''

    :type: 'ImageFormatSettings'
    '''

    margin: int = None
    '''Extends the baked result as a post process filter 

    :type: int
    '''

    normal_b: typing.Union[str, int] = None
    '''Axis to bake in blue channel 

    :type: typing.Union[str, int]
    '''

    normal_g: typing.Union[str, int] = None
    '''Axis to bake in green channel 

    :type: typing.Union[str, int]
    '''

    normal_r: typing.Union[str, int] = None
    '''Axis to bake in red channel 

    :type: typing.Union[str, int]
    '''

    normal_space: typing.Union[str, int] = None
    '''Choose normal space for baking 

    :type: typing.Union[str, int]
    '''

    pass_filter: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Passes to include in the active baking pass 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    save_mode: typing.Union[str, int] = None
    '''Choose how to save the baking map 

    :type: typing.Union[str, int]
    '''

    use_automatic_name: bool = None
    '''Automatically name the output file with the pass type (external only) 

    :type: bool
    '''

    use_cage: bool = None
    '''Cast rays to active object from a cage 

    :type: bool
    '''

    use_clear: bool = None
    '''Clear Images before baking (internal only) 

    :type: bool
    '''

    use_pass_ambient_occlusion: bool = None
    '''Add ambient occlusion contribution 

    :type: bool
    '''

    use_pass_color: bool = None
    '''Color the pass 

    :type: bool
    '''

    use_pass_diffuse: bool = None
    '''Add diffuse contribution 

    :type: bool
    '''

    use_pass_direct: bool = None
    '''Add direct lighting contribution 

    :type: bool
    '''

    use_pass_emit: bool = None
    '''Add emission contribution 

    :type: bool
    '''

    use_pass_glossy: bool = None
    '''Add glossy contribution 

    :type: bool
    '''

    use_pass_indirect: bool = None
    '''Add indirect lighting contribution 

    :type: bool
    '''

    use_pass_subsurface: bool = None
    '''Add subsurface contribution 

    :type: bool
    '''

    use_pass_transmission: bool = None
    '''Add transmission contribution 

    :type: bool
    '''

    use_selected_to_active: bool = None
    '''Bake shading on the surface of selected objects to the active object 

    :type: bool
    '''

    use_split_materials: bool = None
    '''Split external images per material (external only) 

    :type: bool
    '''

    width: int = None
    '''Horizontal dimension of the baking map 

    :type: int
    '''


class BezierSplinePoint(bpy_struct):
    '''Bezier curve point with two handles '''

    co: typing.List[float] = None
    '''Coordinates of the control point 

    :type: typing.List[float]
    '''

    handle_left: typing.List[float] = None
    '''Coordinates of the first handle 

    :type: typing.List[float]
    '''

    handle_left_type: typing.Union[str, int] = None
    '''Handle types 

    :type: typing.Union[str, int]
    '''

    handle_right: typing.List[float] = None
    '''Coordinates of the second handle 

    :type: typing.List[float]
    '''

    handle_right_type: typing.Union[str, int] = None
    '''Handle types 

    :type: typing.Union[str, int]
    '''

    hide: bool = None
    '''Visibility status 

    :type: bool
    '''

    radius: float = None
    '''Radius for beveling 

    :type: float
    '''

    select_control_point: bool = None
    '''Control point selection status 

    :type: bool
    '''

    select_left_handle: bool = None
    '''Handle 1 selection status 

    :type: bool
    '''

    select_right_handle: bool = None
    '''Handle 2 selection status 

    :type: bool
    '''

    tilt: float = None
    '''Tilt in 3D View 

    :type: float
    '''

    weight_softbody: float = None
    '''Softbody goal weight 

    :type: float
    '''


class BlendData(bpy_struct):
    '''Main data structure representing a .blend file and all its data-blocks '''

    actions: typing.Union[typing.List['Action'], 'bpy_prop_collection',
                          'BlendDataActions'] = None
    '''Action data-blocks 

    :type: typing.Union[typing.List['Action'], 'bpy_prop_collection', 'BlendDataActions']
    '''

    armatures: typing.Union[typing.List['Armature'], 'bpy_prop_collection',
                            'BlendDataArmatures'] = None
    '''Armature data-blocks 

    :type: typing.Union[typing.List['Armature'], 'bpy_prop_collection', 'BlendDataArmatures']
    '''

    brushes: typing.Union[typing.List['Brush'], 'bpy_prop_collection',
                          'BlendDataBrushes'] = None
    '''Brush data-blocks 

    :type: typing.Union[typing.List['Brush'], 'bpy_prop_collection', 'BlendDataBrushes']
    '''

    cache_files: typing.Union[typing.List['CacheFile'], 'bpy_prop_collection',
                              'BlendDataCacheFiles'] = None
    '''Cache Files data-blocks 

    :type: typing.Union[typing.List['CacheFile'], 'bpy_prop_collection', 'BlendDataCacheFiles']
    '''

    cameras: typing.Union[typing.List['Camera'], 'bpy_prop_collection',
                          'BlendDataCameras'] = None
    '''Camera data-blocks 

    :type: typing.Union[typing.List['Camera'], 'bpy_prop_collection', 'BlendDataCameras']
    '''

    collections: typing.Union[typing.List['Collection'], 'bpy_prop_collection',
                              'BlendDataCollections'] = None
    '''Collection data-blocks 

    :type: typing.Union[typing.List['Collection'], 'bpy_prop_collection', 'BlendDataCollections']
    '''

    curves: typing.Union[typing.List['Curve'], 'bpy_prop_collection',
                         'BlendDataCurves'] = None
    '''Curve data-blocks 

    :type: typing.Union[typing.List['Curve'], 'bpy_prop_collection', 'BlendDataCurves']
    '''

    filepath: str = None
    '''Path to the .blend file 

    :type: str
    '''

    fonts: typing.Union[typing.List['VectorFont'], 'bpy_prop_collection',
                        'BlendDataFonts'] = None
    '''Vector font data-blocks 

    :type: typing.Union[typing.List['VectorFont'], 'bpy_prop_collection', 'BlendDataFonts']
    '''

    grease_pencils: typing.Union[typing.
                                 List['GreasePencil'], 'bpy_prop_collection',
                                 'BlendDataGreasePencils'] = None
    '''Grease Pencil data-blocks 

    :type: typing.Union[typing.List['GreasePencil'], 'bpy_prop_collection', 'BlendDataGreasePencils']
    '''

    images: typing.Union[typing.List['Image'], 'bpy_prop_collection',
                         'BlendDataImages'] = None
    '''Image data-blocks 

    :type: typing.Union[typing.List['Image'], 'bpy_prop_collection', 'BlendDataImages']
    '''

    is_dirty: bool = None
    '''Have recent edits been saved to disk 

    :type: bool
    '''

    is_saved: bool = None
    '''Has the current session been saved to disk as a .blend file 

    :type: bool
    '''

    lattices: typing.Union[typing.List['Lattice'], 'bpy_prop_collection',
                           'BlendDataLattices'] = None
    '''Lattice data-blocks 

    :type: typing.Union[typing.List['Lattice'], 'bpy_prop_collection', 'BlendDataLattices']
    '''

    libraries: typing.Union[typing.List['Library'], 'bpy_prop_collection',
                            'BlendDataLibraries'] = None
    '''Library data-blocks 

    :type: typing.Union[typing.List['Library'], 'bpy_prop_collection', 'BlendDataLibraries']
    '''

    lightprobes: typing.Union[typing.List['LightProbe'], 'bpy_prop_collection',
                              'BlendDataProbes'] = None
    '''LightProbe data-blocks 

    :type: typing.Union[typing.List['LightProbe'], 'bpy_prop_collection', 'BlendDataProbes']
    '''

    lights: typing.Union[typing.List['Light'], 'bpy_prop_collection',
                         'BlendDataLights'] = None
    '''Light data-blocks 

    :type: typing.Union[typing.List['Light'], 'bpy_prop_collection', 'BlendDataLights']
    '''

    linestyles: typing.Union[typing.
                             List['FreestyleLineStyle'], 'bpy_prop_collection',
                             'BlendDataLineStyles'] = None
    '''Line Style data-blocks 

    :type: typing.Union[typing.List['FreestyleLineStyle'], 'bpy_prop_collection', 'BlendDataLineStyles']
    '''

    masks: typing.Union[typing.List['Mask'], 'bpy_prop_collection',
                        'BlendDataMasks'] = None
    '''Masks data-blocks 

    :type: typing.Union[typing.List['Mask'], 'bpy_prop_collection', 'BlendDataMasks']
    '''

    materials: typing.Union[typing.List['Material'], 'bpy_prop_collection',
                            'BlendDataMaterials'] = None
    '''Material data-blocks 

    :type: typing.Union[typing.List['Material'], 'bpy_prop_collection', 'BlendDataMaterials']
    '''

    meshes: typing.Union[typing.List['Mesh'], 'bpy_prop_collection',
                         'BlendDataMeshes'] = None
    '''Mesh data-blocks 

    :type: typing.Union[typing.List['Mesh'], 'bpy_prop_collection', 'BlendDataMeshes']
    '''

    metaballs: typing.Union[typing.List['MetaBall'], 'bpy_prop_collection',
                            'BlendDataMetaBalls'] = None
    '''Metaball data-blocks 

    :type: typing.Union[typing.List['MetaBall'], 'bpy_prop_collection', 'BlendDataMetaBalls']
    '''

    movieclips: typing.Union[typing.List['MovieClip'], 'bpy_prop_collection',
                             'BlendDataMovieClips'] = None
    '''Movie Clip data-blocks 

    :type: typing.Union[typing.List['MovieClip'], 'bpy_prop_collection', 'BlendDataMovieClips']
    '''

    node_groups: typing.Union[typing.List['NodeTree'], 'bpy_prop_collection',
                              'BlendDataNodeTrees'] = None
    '''Node group data-blocks 

    :type: typing.Union[typing.List['NodeTree'], 'bpy_prop_collection', 'BlendDataNodeTrees']
    '''

    objects: typing.Union[typing.List['Object'], 'bpy_prop_collection',
                          'BlendDataObjects'] = None
    '''Object data-blocks 

    :type: typing.Union[typing.List['Object'], 'bpy_prop_collection', 'BlendDataObjects']
    '''

    paint_curves: typing.Union[typing.
                               List['PaintCurve'], 'bpy_prop_collection',
                               'BlendDataPaintCurves'] = None
    '''Paint Curves data-blocks 

    :type: typing.Union[typing.List['PaintCurve'], 'bpy_prop_collection', 'BlendDataPaintCurves']
    '''

    palettes: typing.Union[typing.List['Palette'], 'bpy_prop_collection',
                           'BlendDataPalettes'] = None
    '''Palette data-blocks 

    :type: typing.Union[typing.List['Palette'], 'bpy_prop_collection', 'BlendDataPalettes']
    '''

    particles: typing.Union[typing.List['ParticleSettings'],
                            'bpy_prop_collection', 'BlendDataParticles'] = None
    '''Particle data-blocks 

    :type: typing.Union[typing.List['ParticleSettings'], 'bpy_prop_collection', 'BlendDataParticles']
    '''

    scenes: typing.Union[typing.List['Scene'], 'bpy_prop_collection',
                         'BlendDataScenes'] = None
    '''Scene data-blocks 

    :type: typing.Union[typing.List['Scene'], 'bpy_prop_collection', 'BlendDataScenes']
    '''

    screens: typing.Union[typing.List['Screen'], 'bpy_prop_collection',
                          'BlendDataScreens'] = None
    '''Screen data-blocks 

    :type: typing.Union[typing.List['Screen'], 'bpy_prop_collection', 'BlendDataScreens']
    '''

    shape_keys: typing.Union[typing.List['Key'], 'bpy_prop_collection'] = None
    '''Shape Key data-blocks 

    :type: typing.Union[typing.List['Key'], 'bpy_prop_collection']
    '''

    sounds: typing.Union[typing.List['Sound'], 'bpy_prop_collection',
                         'BlendDataSounds'] = None
    '''Sound data-blocks 

    :type: typing.Union[typing.List['Sound'], 'bpy_prop_collection', 'BlendDataSounds']
    '''

    speakers: typing.Union[typing.List['Speaker'], 'bpy_prop_collection',
                           'BlendDataSpeakers'] = None
    '''Speaker data-blocks 

    :type: typing.Union[typing.List['Speaker'], 'bpy_prop_collection', 'BlendDataSpeakers']
    '''

    texts: typing.Union[typing.List['Text'], 'bpy_prop_collection',
                        'BlendDataTexts'] = None
    '''Text data-blocks 

    :type: typing.Union[typing.List['Text'], 'bpy_prop_collection', 'BlendDataTexts']
    '''

    textures: typing.Union[typing.List['Texture'], 'bpy_prop_collection',
                           'BlendDataTextures'] = None
    '''Texture data-blocks 

    :type: typing.Union[typing.List['Texture'], 'bpy_prop_collection', 'BlendDataTextures']
    '''

    use_autopack: bool = None
    '''Automatically pack all external data into .blend file 

    :type: bool
    '''

    version: typing.List[int] = None
    '''Version of Blender the .blend was saved with 

    :type: typing.List[int]
    '''

    window_managers: typing.Union[typing.
                                  List['WindowManager'], 'bpy_prop_collection',
                                  'BlendDataWindowManagers'] = None
    '''Window manager data-blocks 

    :type: typing.Union[typing.List['WindowManager'], 'bpy_prop_collection', 'BlendDataWindowManagers']
    '''

    workspaces: typing.Union[typing.List['WorkSpace'], 'bpy_prop_collection',
                             'BlendDataWorkSpaces'] = None
    '''Workspace data-blocks 

    :type: typing.Union[typing.List['WorkSpace'], 'bpy_prop_collection', 'BlendDataWorkSpaces']
    '''

    worlds: typing.Union[typing.List['World'], 'bpy_prop_collection',
                         'BlendDataWorlds'] = None
    '''World data-blocks 

    :type: typing.Union[typing.List['World'], 'bpy_prop_collection', 'BlendDataWorlds']
    '''

    def batch_remove(self, ids=()):
        '''Note that this function is quicker than individual calls to remove() (from bpy.types.BlendData ID collections), but less safe/versatile (it can break Blender, e.g. by removing all scenes…). 

        :param ids: Iterables of IDs (types can be mixed). 
        :type ids: 
        '''
        pass

    def user_map(self, key_types: set, value_types: set) -> dict:
        '''For list of valid set members for key_types & value_types, see: bpy.types.KeyingSetPath.id_type. 

        :param subset: When passed, only these data-blocks and their users will be included as keys/values in the map. 
        :type subset: list
        :param key_types: Filter the keys mapped by ID types. 
        :type key_types: set
        :param value_types: Filter the values in the set by ID types. 
        :type value_types: set
        :rtype: dict
        :return:  dictionary of bpy.types.ID instances, with sets of ID’s as their values. 
        '''
        pass


class BlendDataActions(bpy_struct):
    '''Collection of actions '''

    def new(self, name: str) -> 'Action':
        '''Add a new action to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'Action'
        :return:  New action data-block 
        '''
        pass

    def remove(self,
               action: 'Action',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a action from the current blendfile 

        :param action: Action to remove 
        :type action: 'Action'
        :param do_unlink: Unlink all usages of this action before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this action 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this action 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataArmatures(bpy_struct):
    '''Collection of armatures '''

    def new(self, name: str) -> 'Armature':
        '''Add a new armature to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'Armature'
        :return:  New armature data-block 
        '''
        pass

    def remove(self,
               armature: 'Armature',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a armature from the current blendfile 

        :param armature: Armature to remove 
        :type armature: 'Armature'
        :param do_unlink: Unlink all usages of this armature before deleting it (WARNING: will also delete objects instancing that armature data) 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this armature data 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this armature data 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataBrushes(bpy_struct):
    '''Collection of brushes '''

    def new(self, name: str,
            mode: typing.Union[str, int] = 'TEXTURE_PAINT') -> 'Brush':
        '''Add a new brush to the main database 

        :param name: New name for the data-block 
        :type name: str
        :param mode: Paint Mode for the new brushOBJECT Object Mode.EDIT Edit Mode.POSE Pose Mode.SCULPT Sculpt Mode.VERTEX_PAINT Vertex Paint.WEIGHT_PAINT Weight Paint.TEXTURE_PAINT Texture Paint.PARTICLE_EDIT Particle Edit.EDIT_GPENCIL Edit Mode, Edit Grease Pencil Strokes.SCULPT_GPENCIL Sculpt Mode, Sculpt Grease Pencil Strokes.PAINT_GPENCIL Draw, Paint Grease Pencil Strokes.WEIGHT_GPENCIL Weight Paint, Grease Pencil Weight Paint Strokes. 
        :type mode: typing.Union[str, int]
        :rtype: 'Brush'
        :return:  New brush data-block 
        '''
        pass

    def remove(self,
               brush: 'Brush',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a brush from the current blendfile 

        :param brush: Brush to remove 
        :type brush: 'Brush'
        :param do_unlink: Unlink all usages of this brush before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this brush 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this brush 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass

    def create_gpencil_data(self, brush: 'Brush'):
        '''Add grease pencil brush settings 

        :param brush: Brush 
        :type brush: 'Brush'
        '''
        pass


class BlendDataCacheFiles(bpy_struct):
    '''Collection of cache files '''

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataCameras(bpy_struct):
    '''Collection of cameras '''

    def new(self, name: str) -> 'Camera':
        '''Add a new camera to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'Camera'
        :return:  New camera data-block 
        '''
        pass

    def remove(self,
               camera: 'Camera',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a camera from the current blendfile 

        :param camera: Camera to remove 
        :type camera: 'Camera'
        :param do_unlink: Unlink all usages of this camera before deleting it (WARNING: will also delete objects instancing that camera data) 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this camera 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this camera 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataCollections(bpy_struct):
    '''Collection of collections '''

    def new(self, name: str) -> 'Collection':
        '''Add a new collection to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'Collection'
        :return:  New collection data-block 
        '''
        pass

    def remove(self,
               collection: 'Collection',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a collection from the current blendfile 

        :param collection: Collection to remove 
        :type collection: 'Collection'
        :param do_unlink: Unlink all usages of this collection before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this collection 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this collection 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataCurves(bpy_struct):
    '''Collection of curves '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'Curve':
        '''Add a new curve to the main database 

        :param name: New name for the data-block 
        :type name: str
        :param type: Type, The type of curve to add 
        :type type: typing.Union[str, int]
        :rtype: 'Curve'
        :return:  New curve data-block 
        '''
        pass

    def remove(self,
               curve: 'Curve',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a curve from the current blendfile 

        :param curve: Curve to remove 
        :type curve: 'Curve'
        :param do_unlink: Unlink all usages of this curve before deleting it (WARNING: will also delete objects instancing that curve data) 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this curve data 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this curve data 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataFonts(bpy_struct):
    '''Collection of fonts '''

    def load(self, filepath: str,
             check_existing: bool = False) -> 'VectorFont':
        '''Load a new font into the main database 

        :param filepath: path of the font to load 
        :type filepath: str
        :param check_existing: Using existing data-block if this file is already loaded 
        :type check_existing: bool
        :rtype: 'VectorFont'
        :return:  New font data-block 
        '''
        pass

    def remove(self,
               vfont: 'VectorFont',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a font from the current blendfile 

        :param vfont: Font to remove 
        :type vfont: 'VectorFont'
        :param do_unlink: Unlink all usages of this font before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this font 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this font 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataGreasePencils(bpy_struct):
    '''Collection of grease pencils '''

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass

    def new(self, name: str) -> 'GreasePencil':
        '''Add a new grease pencil datablock to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'GreasePencil'
        :return:  New grease pencil data-block 
        '''
        pass

    def remove(self,
               grease_pencil: 'GreasePencil',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a grease pencil instance from the current blendfile 

        :param grease_pencil: Grease Pencil to remove 
        :type grease_pencil: 'GreasePencil'
        :param do_unlink: Unlink all usages of this grease pencil before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this grease pencil 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this grease pencil 
        :type do_ui_user: bool
        '''
        pass


class BlendDataImages(bpy_struct):
    '''Collection of images '''

    def new(self,
            name: str,
            width: int,
            height: int,
            alpha: bool = False,
            float_buffer: bool = False,
            stereo3d: bool = False,
            is_data: bool = False,
            tiled: bool = False) -> 'Image':
        '''Add a new image to the main database 

        :param name: New name for the data-block 
        :type name: str
        :param width: Width of the image 
        :type width: int
        :param height: Height of the image 
        :type height: int
        :param alpha: Alpha, Use alpha channel 
        :type alpha: bool
        :param float_buffer: Float Buffer, Create an image with floating point color 
        :type float_buffer: bool
        :param stereo3d: Stereo 3D, Create left and right views 
        :type stereo3d: bool
        :param is_data: Is Data, Create image with non-color data color space 
        :type is_data: bool
        :param tiled: Tiled, Create a tiled image 
        :type tiled: bool
        :rtype: 'Image'
        :return:  New image data-block 
        '''
        pass

    def load(self, filepath: str, check_existing: bool = False) -> 'Image':
        '''Load a new image into the main database 

        :param filepath: path of the file to load 
        :type filepath: str
        :param check_existing: Using existing data-block if this file is already loaded 
        :type check_existing: bool
        :rtype: 'Image'
        :return:  New image data-block 
        '''
        pass

    def remove(self,
               image: 'Image',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove an image from the current blendfile 

        :param image: Image to remove 
        :type image: 'Image'
        :param do_unlink: Unlink all usages of this image before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this image 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this image 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataLattices(bpy_struct):
    '''Collection of lattices '''

    def new(self, name: str) -> 'Lattice':
        '''Add a new lattice to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'Lattice'
        :return:  New lattices data-block 
        '''
        pass

    def remove(self,
               lattice: 'Lattice',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a lattice from the current blendfile 

        :param lattice: Lattice to remove 
        :type lattice: 'Lattice'
        :param do_unlink: Unlink all usages of this lattice before deleting it (WARNING: will also delete objects instancing that lattice data) 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this lattice data 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this lattice data 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataLibraries(bpy_struct):
    '''Collection of libraries '''

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass

    def load(self, filepath: str, link: bool = False, relative: bool = False):
        '''Returns a context manager which exposes 2 library objects on entering. Each object has attributes matching bpy.data which are lists of strings to be linked. 

        :param filepath: The path to a blend file. 
        :type filepath: str
        :param link: When False reference to the original file is lost. 
        :type link: bool
        :param relative: When True the path is stored relative to the open blend file. 
        :type relative: bool
        '''
        pass

    def write(self,
              filepath: str,
              datablocks: set,
              relative_remap: bool = False,
              fake_user: bool = False,
              compress: bool = False):
        '''Write data-blocks into a blend file. 

        :param filepath: The path to write the blend-file. 
        :type filepath: str
        :param datablocks: set of data-blocks (bpy.types.ID instances). 
        :type datablocks: set
        :param relative_remap: When True, make paths relative to the current blend-file. 
        :type relative_remap: bool
        :param fake_user: When True, data-blocks will be written with fake-user flag enabled. 
        :type fake_user: bool
        :param compress: When True, write a compressed blend file. 
        :type compress: bool
        '''
        pass


class BlendDataLights(bpy_struct):
    '''Collection of lights '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'Light':
        '''Add a new light to the main database 

        :param name: New name for the data-block 
        :type name: str
        :param type: Type, The type of texture to addPOINT Point, Omnidirectional point light source.SUN Sun, Constant direction parallel ray light source.SPOT Spot, Directional cone light source.AREA Area, Directional area light source. 
        :type type: typing.Union[str, int]
        :rtype: 'Light'
        :return:  New light data-block 
        '''
        pass

    def remove(self,
               light: 'Light',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a light from the current blendfile 

        :param light: Light to remove 
        :type light: 'Light'
        :param do_unlink: Unlink all usages of this Light before deleting it (WARNING: will also delete objects instancing that light data) 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this light data 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this light data 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataLineStyles(bpy_struct):
    '''Collection of line styles '''

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass

    def new(self, name: str) -> 'FreestyleLineStyle':
        '''Add a new line style instance to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'FreestyleLineStyle'
        :return:  New line style data-block 
        '''
        pass

    def remove(self,
               linestyle: 'FreestyleLineStyle',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a line style instance from the current blendfile 

        :param linestyle: Line style to remove 
        :type linestyle: 'FreestyleLineStyle'
        :param do_unlink: Unlink all usages of this line style before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this line style 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this line style 
        :type do_ui_user: bool
        '''
        pass


class BlendDataMasks(bpy_struct):
    '''Collection of masks '''

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass

    def new(self, name: str) -> 'Mask':
        '''Add a new mask with a given name to the main database 

        :param name: Mask, Name of new mask data-block 
        :type name: str
        :rtype: 'Mask'
        :return:  New mask data-block 
        '''
        pass

    def remove(self,
               mask: 'Mask',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a masks from the current blendfile. 

        :param mask: Mask to remove 
        :type mask: 'Mask'
        :param do_unlink: Unlink all usages of this mask before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this mask 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this mask 
        :type do_ui_user: bool
        '''
        pass


class BlendDataMaterials(bpy_struct):
    '''Collection of materials '''

    def new(self, name: str) -> 'Material':
        '''Add a new material to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'Material'
        :return:  New material data-block 
        '''
        pass

    def create_gpencil_data(self, material: 'Material'):
        '''Add grease pencil material settings 

        :param material: Material 
        :type material: 'Material'
        '''
        pass

    def remove_gpencil_data(self, material: 'Material'):
        '''Remove grease pencil material settings 

        :param material: Material 
        :type material: 'Material'
        '''
        pass

    def remove(self,
               material: 'Material',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a material from the current blendfile 

        :param material: Material to remove 
        :type material: 'Material'
        :param do_unlink: Unlink all usages of this material before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this material 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this material 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataMeshes(bpy_struct):
    '''Collection of meshes '''

    def new(self, name: str) -> 'Mesh':
        '''Add a new mesh to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'Mesh'
        :return:  New mesh data-block 
        '''
        pass

    def new_from_object(self,
                        object: 'Object',
                        preserve_all_data_layers: bool = False,
                        depsgraph: 'Depsgraph' = None) -> 'Mesh':
        '''Add a new mesh created from given object (undeformed geometry if object is original, and final evaluated geometry, with all modifiers etc., if object is evaluated) 

        :param object: Object to create mesh from 
        :type object: 'Object'
        :param preserve_all_data_layers: Preserve all data layers in the mesh, like UV maps and vertex groups. By default Blender only computes the subset of data layers needed for viewport display and rendering, for better performance 
        :type preserve_all_data_layers: bool
        :param depsgraph: Dependency Graph, Evaluated dependency graph which is required when preserve_all_data_layers is true 
        :type depsgraph: 'Depsgraph'
        :rtype: 'Mesh'
        :return:  Mesh created from object, remove it if it is only used for export 
        '''
        pass

    def remove(self,
               mesh: 'Mesh',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a mesh from the current blendfile 

        :param mesh: Mesh to remove 
        :type mesh: 'Mesh'
        :param do_unlink: Unlink all usages of this mesh before deleting it (WARNING: will also delete objects instancing that mesh data) 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this mesh data 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this mesh data 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataMetaBalls(bpy_struct):
    '''Collection of metaballs '''

    def new(self, name: str) -> 'MetaBall':
        '''Add a new metaball to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'MetaBall'
        :return:  New metaball data-block 
        '''
        pass

    def remove(self,
               metaball: 'MetaBall',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a metaball from the current blendfile 

        :param metaball: Metaball to remove 
        :type metaball: 'MetaBall'
        :param do_unlink: Unlink all usages of this metaball before deleting it (WARNING: will also delete objects instancing that metaball data) 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this metaball data 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this metaball data 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataMovieClips(bpy_struct):
    '''Collection of movie clips '''

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass

    def remove(self,
               clip: 'MovieClip',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a movie clip from the current blendfile. 

        :param clip: Movie clip to remove 
        :type clip: 'MovieClip'
        :param do_unlink: Unlink all usages of this movie clip before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this movie clip 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this movie clip 
        :type do_ui_user: bool
        '''
        pass

    def load(self, filepath: str, check_existing: bool = False) -> 'MovieClip':
        '''Add a new movie clip to the main database from a file (while check_existing is disabled for consistency with other load functions, behavior with multiple movie-clips using the same file may incorrectly generate proxies) 

        :param filepath: path for the data-block 
        :type filepath: str
        :param check_existing: Using existing data-block if this file is already loaded 
        :type check_existing: bool
        :rtype: 'MovieClip'
        :return:  New movie clip data-block 
        '''
        pass


class BlendDataNodeTrees(bpy_struct):
    '''Collection of node trees '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'NodeTree':
        '''Add a new node tree to the main database 

        :param name: New name for the data-block 
        :type name: str
        :param type: Type, The type of node_group to add 
        :type type: typing.Union[str, int]
        :rtype: 'NodeTree'
        :return:  New node tree data-block 
        '''
        pass

    def remove(self,
               tree: 'NodeTree',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a node tree from the current blendfile 

        :param tree: Node tree to remove 
        :type tree: 'NodeTree'
        :param do_unlink: Unlink all usages of this node tree before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this node tree 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this node tree 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataObjects(bpy_struct):
    '''Collection of objects '''

    def new(self, name: str, object_data: 'ID') -> 'Object':
        '''Add a new object to the main database 

        :param name: New name for the data-block 
        :type name: str
        :param object_data: Object data or None for an empty object 
        :type object_data: 'ID'
        :rtype: 'Object'
        :return:  New object data-block 
        '''
        pass

    def remove(self,
               object: 'Object',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a object from the current blendfile 

        :param object: Object to remove 
        :type object: 'Object'
        :param do_unlink: Unlink all usages of this object before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this object 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this object 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataPaintCurves(bpy_struct):
    '''Collection of paint curves '''

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataPalettes(bpy_struct):
    '''Collection of palettes '''

    def new(self, name: str) -> 'Palette':
        '''Add a new palette to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'Palette'
        :return:  New palette data-block 
        '''
        pass

    def remove(self,
               palette: 'Palette',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a palette from the current blendfile 

        :param palette: Palette to remove 
        :type palette: 'Palette'
        :param do_unlink: Unlink all usages of this palette before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this palette 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this palette 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataParticles(bpy_struct):
    '''Collection of particle settings '''

    def new(self, name: str) -> 'ParticleSettings':
        '''Add a new particle settings instance to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'ParticleSettings'
        :return:  New particle settings data-block 
        '''
        pass

    def remove(self,
               particle: 'ParticleSettings',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a particle settings instance from the current blendfile 

        :param particle: Particle Settings to remove 
        :type particle: 'ParticleSettings'
        :param do_unlink: Unlink all usages of those particle settings before deleting them 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this particle settings 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this particle settings 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataProbes(bpy_struct):
    '''Collection of light probes '''

    def new(self, name: str) -> 'LightProbe':
        '''Add a new probe to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'LightProbe'
        :return:  New light probe data-block 
        '''
        pass

    def remove(self,
               lightprobe: 'LightProbe',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a probe from the current blendfile 

        :param lightprobe: Probe to remove 
        :type lightprobe: 'LightProbe'
        :param do_unlink: Unlink all usages of this probe before deleting it (WARNING: will also delete objects instancing that light probe data) 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this light probe 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this light probe 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataScenes(bpy_struct):
    '''Collection of scenes '''

    def new(self, name: str) -> 'Scene':
        '''Add a new scene to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'Scene'
        :return:  New scene data-block 
        '''
        pass

    def remove(self, scene: 'Scene', do_unlink: bool = True):
        '''Remove a scene from the current blendfile 

        :param scene: Scene to remove 
        :type scene: 'Scene'
        :param do_unlink: Unlink all usages of this scene before deleting it 
        :type do_unlink: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataScreens(bpy_struct):
    '''Collection of screens '''

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataSounds(bpy_struct):
    '''Collection of sounds '''

    def load(self, filepath: str, check_existing: bool = False) -> 'Sound':
        '''Add a new sound to the main database from a file 

        :param filepath: path for the data-block 
        :type filepath: str
        :param check_existing: Using existing data-block if this file is already loaded 
        :type check_existing: bool
        :rtype: 'Sound'
        :return:  New text data-block 
        '''
        pass

    def remove(self,
               sound: 'Sound',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a sound from the current blendfile 

        :param sound: Sound to remove 
        :type sound: 'Sound'
        :param do_unlink: Unlink all usages of this sound before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this sound 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this sound 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataSpeakers(bpy_struct):
    '''Collection of speakers '''

    def new(self, name: str) -> 'Speaker':
        '''Add a new speaker to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'Speaker'
        :return:  New speaker data-block 
        '''
        pass

    def remove(self,
               speaker: 'Speaker',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a speaker from the current blendfile 

        :param speaker: Speaker to remove 
        :type speaker: 'Speaker'
        :param do_unlink: Unlink all usages of this speaker before deleting it (WARNING: will also delete objects instancing that speaker data) 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this speaker data 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this speaker data 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataTexts(bpy_struct):
    '''Collection of texts '''

    def new(self, name: str) -> 'Text':
        '''Add a new text to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'Text'
        :return:  New text data-block 
        '''
        pass

    def remove(self,
               text: 'Text',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a text from the current blendfile 

        :param text: Text to remove 
        :type text: 'Text'
        :param do_unlink: Unlink all usages of this text before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this text 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this text 
        :type do_ui_user: bool
        '''
        pass

    def load(self, filepath: str, internal: bool = False) -> 'Text':
        '''Add a new text to the main database from a file 

        :param filepath: path for the data-block 
        :type filepath: str
        :param internal: Make internal, Make text file internal after loading 
        :type internal: bool
        :rtype: 'Text'
        :return:  New text data-block 
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataTextures(bpy_struct):
    '''Collection of textures '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'Texture':
        '''Add a new texture to the main database 

        :param name: New name for the data-block 
        :type name: str
        :param type: Type, The type of texture to addNONE None.BLEND Blend, Procedural - create a ramp texture.CLOUDS Clouds, Procedural - create a cloud-like fractal noise texture.DISTORTED_NOISE Distorted Noise, Procedural - noise texture distorted by two noise algorithms.IMAGE Image or Movie, Allow for images or movies to be used as textures.MAGIC Magic, Procedural - color texture based on trigonometric functions.MARBLE Marble, Procedural - marble-like noise texture with wave generated bands.MUSGRAVE Musgrave, Procedural - highly flexible fractal noise texture.NOISE Noise, Procedural - random noise, gives a different result every time, for every frame, for every pixel.STUCCI Stucci, Procedural - create a fractal noise texture.VORONOI Voronoi, Procedural - create cell-like patterns based on Worley noise.WOOD Wood, Procedural - wave generated bands or rings, with optional noise. 
        :type type: typing.Union[str, int]
        :rtype: 'Texture'
        :return:  New texture data-block 
        '''
        pass

    def remove(self,
               texture: 'Texture',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a texture from the current blendfile 

        :param texture: Texture to remove 
        :type texture: 'Texture'
        :param do_unlink: Unlink all usages of this texture before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this texture 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this texture 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataWindowManagers(bpy_struct):
    '''Collection of window managers '''

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataWorkSpaces(bpy_struct):
    '''Collection of workspaces '''

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlendDataWorlds(bpy_struct):
    '''Collection of worlds '''

    def new(self, name: str) -> 'World':
        '''Add a new world to the main database 

        :param name: New name for the data-block 
        :type name: str
        :rtype: 'World'
        :return:  New world data-block 
        '''
        pass

    def remove(self,
               world: 'World',
               do_unlink: bool = True,
               do_id_user: bool = True,
               do_ui_user: bool = True):
        '''Remove a world from the current blendfile 

        :param world: World to remove 
        :type world: 'World'
        :param do_unlink: Unlink all usages of this world before deleting it 
        :type do_unlink: bool
        :param do_id_user: Decrement user counter of all datablocks used by this world 
        :type do_id_user: bool
        :param do_ui_user: Make sure interface does not reference this world 
        :type do_ui_user: bool
        '''
        pass

    def tag(self, value: bool):
        '''tag 

        :param value: Value 
        :type value: bool
        '''
        pass


class BlenderRNA(bpy_struct):
    '''Blender RNA structure definitions '''

    structs: typing.Union[typing.List['Struct'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['Struct'], 'bpy_prop_collection']
    '''


class BoidRule(bpy_struct):
    name: str = None
    '''Boid rule name 

    :type: str
    '''

    type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    use_in_air: bool = None
    '''Use rule when boid is flying 

    :type: bool
    '''

    use_on_land: bool = None
    '''Use rule when boid is on land 

    :type: bool
    '''


class BoidSettings(bpy_struct):
    '''Settings for boid physics '''

    accuracy: float = None
    '''Accuracy of attack 

    :type: float
    '''

    active_boid_state: 'BoidRule' = None
    '''

    :type: 'BoidRule'
    '''

    active_boid_state_index: int = None
    '''

    :type: int
    '''

    aggression: float = None
    '''Boid will fight this times stronger enemy 

    :type: float
    '''

    air_acc_max: float = None
    '''Maximum acceleration in air (relative to maximum speed) 

    :type: float
    '''

    air_ave_max: float = None
    '''Maximum angular velocity in air (relative to 180 degrees) 

    :type: float
    '''

    air_personal_space: float = None
    '''Radius of boids personal space in air (% of particle size) 

    :type: float
    '''

    air_speed_max: float = None
    '''Maximum speed in air 

    :type: float
    '''

    air_speed_min: float = None
    '''Minimum speed in air (relative to maximum speed) 

    :type: float
    '''

    bank: float = None
    '''Amount of rotation around velocity vector on turns 

    :type: float
    '''

    health: float = None
    '''Initial boid health when born 

    :type: float
    '''

    height: float = None
    '''Boid height relative to particle size 

    :type: float
    '''

    land_acc_max: float = None
    '''Maximum acceleration on land (relative to maximum speed) 

    :type: float
    '''

    land_ave_max: float = None
    '''Maximum angular velocity on land (relative to 180 degrees) 

    :type: float
    '''

    land_jump_speed: float = None
    '''Maximum speed for jumping 

    :type: float
    '''

    land_personal_space: float = None
    '''Radius of boids personal space on land (% of particle size) 

    :type: float
    '''

    land_smooth: float = None
    '''How smoothly the boids land 

    :type: float
    '''

    land_speed_max: float = None
    '''Maximum speed on land 

    :type: float
    '''

    land_stick_force: float = None
    '''How strong a force must be to start effecting a boid on land 

    :type: float
    '''

    pitch: float = None
    '''Amount of rotation around side vector 

    :type: float
    '''

    range: float = None
    '''Maximum distance from which a boid can attack 

    :type: float
    '''

    states: typing.Union[typing.
                         List['BoidState'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['BoidState'], 'bpy_prop_collection']
    '''

    strength: float = None
    '''Maximum caused damage on attack per second 

    :type: float
    '''

    use_climb: bool = None
    '''Allow boids to climb goal objects 

    :type: bool
    '''

    use_flight: bool = None
    '''Allow boids to move in air 

    :type: bool
    '''

    use_land: bool = None
    '''Allow boids to move on land 

    :type: bool
    '''


class BoidState(bpy_struct):
    '''Boid state for boid physics '''

    active_boid_rule: 'BoidRule' = None
    '''

    :type: 'BoidRule'
    '''

    active_boid_rule_index: int = None
    '''

    :type: int
    '''

    falloff: float = None
    '''

    :type: float
    '''

    name: str = None
    '''Boid state name 

    :type: str
    '''

    rule_fuzzy: float = None
    '''

    :type: float
    '''

    rules: typing.Union[typing.List['BoidRule'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['BoidRule'], 'bpy_prop_collection']
    '''

    ruleset_type: typing.Union[str, int] = None
    '''How the rules in the list are evaluated 

    :type: typing.Union[str, int]
    '''

    volume: float = None
    '''

    :type: float
    '''


class Bone(bpy_struct):
    '''Bone in an Armature data-block '''

    bbone_curveinx: float = None
    '''X-axis handle offset for start of the B-Bone’s curve, adjusts curvature 

    :type: float
    '''

    bbone_curveiny: float = None
    '''Y-axis handle offset for start of the B-Bone’s curve, adjusts curvature 

    :type: float
    '''

    bbone_curveoutx: float = None
    '''X-axis handle offset for end of the B-Bone’s curve, adjusts curvature 

    :type: float
    '''

    bbone_curveouty: float = None
    '''Y-axis handle offset for end of the B-Bone’s curve, adjusts curvature 

    :type: float
    '''

    bbone_custom_handle_end: 'Bone' = None
    '''Bone that serves as the end handle for the B-Bone curve 

    :type: 'Bone'
    '''

    bbone_custom_handle_start: 'Bone' = None
    '''Bone that serves as the start handle for the B-Bone curve 

    :type: 'Bone'
    '''

    bbone_easein: float = None
    '''Length of first Bezier Handle (for B-Bones only) 

    :type: float
    '''

    bbone_easeout: float = None
    '''Length of second Bezier Handle (for B-Bones only) 

    :type: float
    '''

    bbone_handle_type_end: typing.Union[str, int] = None
    '''Selects how the end handle of the B-Bone is computed 

    :type: typing.Union[str, int]
    '''

    bbone_handle_type_start: typing.Union[str, int] = None
    '''Selects how the start handle of the B-Bone is computed 

    :type: typing.Union[str, int]
    '''

    bbone_rollin: float = None
    '''Roll offset for the start of the B-Bone, adjusts twist 

    :type: float
    '''

    bbone_rollout: float = None
    '''Roll offset for the end of the B-Bone, adjusts twist 

    :type: float
    '''

    bbone_scaleinx: float = None
    '''X-axis scale factor for start of the B-Bone, adjusts thickness (for tapering effects) 

    :type: float
    '''

    bbone_scaleiny: float = None
    '''Y-axis scale factor for start of the B-Bone, adjusts thickness (for tapering effects) 

    :type: float
    '''

    bbone_scaleoutx: float = None
    '''X-axis scale factor for end of the B-Bone, adjusts thickness (for tapering effects) 

    :type: float
    '''

    bbone_scaleouty: float = None
    '''Y-axis scale factor for end of the B-Bone, adjusts thickness (for tapering effects) 

    :type: float
    '''

    bbone_segments: int = None
    '''Number of subdivisions of bone (for B-Bones only) 

    :type: int
    '''

    bbone_x: float = None
    '''B-Bone X size 

    :type: float
    '''

    bbone_z: float = None
    '''B-Bone Z size 

    :type: float
    '''

    children: typing.Union[typing.List['Bone'], 'bpy_prop_collection'] = None
    '''Bones which are children of this bone 

    :type: typing.Union[typing.List['Bone'], 'bpy_prop_collection']
    '''

    envelope_distance: float = None
    '''Bone deformation distance (for Envelope deform only) 

    :type: float
    '''

    envelope_weight: float = None
    '''Bone deformation weight (for Envelope deform only) 

    :type: float
    '''

    head: typing.List[float] = None
    '''Location of head end of the bone relative to its parent 

    :type: typing.List[float]
    '''

    head_local: typing.List[float] = None
    '''Location of head end of the bone relative to armature 

    :type: typing.List[float]
    '''

    head_radius: float = None
    '''Radius of head of bone (for Envelope deform only) 

    :type: float
    '''

    hide: bool = None
    '''Bone is not visible when it is not in Edit Mode (i.e. in Object or Pose Modes) 

    :type: bool
    '''

    hide_select: bool = None
    '''Bone is able to be selected 

    :type: bool
    '''

    inherit_scale: typing.Union[str, int] = None
    '''Specifies how the bone inherits scaling from the parent bone 

    :type: typing.Union[str, int]
    '''

    layers: typing.List[bool] = None
    '''Layers bone exists in 

    :type: typing.List[bool]
    '''

    length: float = None
    '''Length of the bone 

    :type: float
    '''

    matrix: typing.List[float] = None
    '''3x3 bone matrix 

    :type: typing.List[float]
    '''

    matrix_local: typing.List[float] = None
    '''4x4 bone matrix relative to armature 

    :type: typing.List[float]
    '''

    name: str = None
    '''

    :type: str
    '''

    parent: 'Bone' = None
    '''Parent bone (in same Armature) 

    :type: 'Bone'
    '''

    select: bool = None
    '''

    :type: bool
    '''

    select_head: bool = None
    '''

    :type: bool
    '''

    select_tail: bool = None
    '''

    :type: bool
    '''

    show_wire: bool = None
    '''Bone is always drawn as Wireframe regardless of viewport draw mode (useful for non-obstructive custom bone shapes) 

    :type: bool
    '''

    tail: typing.List[float] = None
    '''Location of tail end of the bone relative to its parent 

    :type: typing.List[float]
    '''

    tail_local: typing.List[float] = None
    '''Location of tail end of the bone relative to armature 

    :type: typing.List[float]
    '''

    tail_radius: float = None
    '''Radius of tail of bone (for Envelope deform only) 

    :type: float
    '''

    use_connect: bool = None
    '''When bone has a parent, bone’s head is stuck to the parent’s tail 

    :type: bool
    '''

    use_cyclic_offset: bool = None
    '''When bone doesn’t have a parent, it receives cyclic offset effects (Deprecated) 

    :type: bool
    '''

    use_deform: bool = None
    '''Enable Bone to deform geometry 

    :type: bool
    '''

    use_endroll_as_inroll: bool = None
    '''Add Roll Out of the Start Handle bone to the Roll In value 

    :type: bool
    '''

    use_envelope_multiply: bool = None
    '''When deforming bone, multiply effects of Vertex Group weights with Envelope influence 

    :type: bool
    '''

    use_inherit_rotation: bool = None
    '''Bone inherits rotation or scale from parent bone 

    :type: bool
    '''

    use_inherit_scale: bool = None
    '''DEPRECATED: Bone inherits scaling from parent bone 

    :type: bool
    '''

    use_local_location: bool = None
    '''Bone location is set in local space 

    :type: bool
    '''

    use_relative_parent: bool = None
    '''Object children will use relative transform, like deform 

    :type: bool
    '''

    basename = None
    '''The name of this bone before any ‘.’ character (readonly) '''

    center = None
    '''The midpoint between the head and the tail. (readonly) '''

    children_recursive = None
    '''A list of all children from this bone. Warning: takes O(len(bones)**2) time. (readonly) '''

    children_recursive_basename = None
    '''Returns a chain of children with the same base name as this bone. Only direct chains are supported, forks caused by multiple children with matching base names will terminate the function and not be returned. Warning: takes O(len(bones)**2) time. (readonly) '''

    parent_recursive = None
    '''A list of parents, starting with the immediate parent (readonly) '''

    vector = None
    '''The direction this bone is pointing. Utility function for (tail - head) (readonly) '''

    x_axis = None
    '''Vector pointing down the x-axis of the bone. (readonly) '''

    y_axis = None
    '''Vector pointing down the y-axis of the bone. (readonly) '''

    z_axis = None
    '''Vector pointing down the z-axis of the bone. (readonly) '''

    def evaluate_envelope(self, point: typing.List[float]) -> float:
        '''Calculate bone envelope at given point 

        :param point: Point, Position in 3d space to evaluate 
        :type point: typing.List[float]
        :rtype: float
        :return:  Factor, Envelope factor 
        '''
        pass

    def convert_local_to_pose(
            self,
            matrix: typing.List[float],
            matrix_local: typing.List[float],
            parent_matrix: typing.List[float] = ((0.0, 0.0, 0.0,
                                                  0.0), (0.0, 0.0, 0.0, 0.0),
                                                 (0.0, 0.0, 0.0,
                                                  0.0), (0.0, 0.0, 0.0, 0.0)),
            parent_matrix_local: typing.List[float] = ((0.0, 0.0, 0.0, 0.0),
                                                       (0.0, 0.0, 0.0, 0.0),
                                                       (0.0, 0.0, 0.0,
                                                        0.0), (0.0, 0.0, 0.0,
                                                               0.0)),
            invert: bool = False) -> typing.List[float]:
        '''Transform a matrix from Local to Pose space (or back), taking into account options like Inherit Scale and Local Location. Unlike Object.convert_space, this uses custom rest and pose matrices provided by the caller. If the parent matrices are omitted, the bone is assumed to have no parent. 

        :param matrix: The matrix to transform 
        :type matrix: typing.List[float]
        :param matrix_local: The custom rest matrix of this bone (Bone.matrix_local) 
        :type matrix_local: typing.List[float]
        :param parent_matrix: The custom pose matrix of the parent bone (PoseBone.matrix) 
        :type parent_matrix: typing.List[float]
        :param parent_matrix_local: The custom rest matrix of the parent bone (Bone.matrix_local) 
        :type parent_matrix_local: typing.List[float]
        :param invert: Convert from Pose to Local space 
        :type invert: bool
        :rtype: typing.List[float]
        :return:  The transformed matrix 
        '''
        pass

    def parent_index(self, parent_test):
        '''The same as ‘bone in other_bone.parent_recursive’ but saved generating a list. 

        '''
        pass

    def translate(self, vec):
        '''Utility function to add vec to the head and tail of this bone 

        '''
        pass


class BoneGroup(bpy_struct):
    '''Groups of Pose Channels (Bones) '''

    color_set: typing.Union[str, int] = None
    '''Custom color set to use 

    :type: typing.Union[str, int]
    '''

    colors: 'ThemeBoneColorSet' = None
    '''Copy of the colors associated with the group’s color set 

    :type: 'ThemeBoneColorSet'
    '''

    is_custom_color_set: bool = None
    '''Color set is user-defined instead of a fixed theme color set 

    :type: bool
    '''

    name: str = None
    '''

    :type: str
    '''


class BoneGroups(bpy_struct):
    '''Collection of bone groups '''

    active: 'BoneGroup' = None
    '''Active bone group for this pose 

    :type: 'BoneGroup'
    '''

    active_index: int = None
    '''Active index in bone groups array 

    :type: int
    '''

    def new(self, name: str = "Group") -> 'BoneGroup':
        '''Add a new bone group to the object 

        :param name: Name of the new group 
        :type name: str
        :rtype: 'BoneGroup'
        :return:  New bone group 
        '''
        pass

    def remove(self, group: 'BoneGroup'):
        '''Remove a bone group from this object 

        :param group: Removed bone group 
        :type group: 'BoneGroup'
        '''
        pass


class BrushCapabilities(bpy_struct):
    '''Read-only indications of supported operations '''

    has_overlay: bool = None
    '''

    :type: bool
    '''

    has_random_texture_angle: bool = None
    '''

    :type: bool
    '''

    has_smooth_stroke: bool = None
    '''

    :type: bool
    '''

    has_spacing: bool = None
    '''

    :type: bool
    '''


class BrushCapabilitiesImagePaint(bpy_struct):
    '''Read-only indications of supported operations '''

    has_accumulate: bool = None
    '''

    :type: bool
    '''

    has_color: bool = None
    '''

    :type: bool
    '''

    has_radius: bool = None
    '''

    :type: bool
    '''

    has_space_attenuation: bool = None
    '''

    :type: bool
    '''


class BrushCapabilitiesSculpt(bpy_struct):
    '''Read-only indications of which brush operations are supported by the current sculpt tool '''

    has_accumulate: bool = None
    '''

    :type: bool
    '''

    has_auto_smooth: bool = None
    '''

    :type: bool
    '''

    has_direction: bool = None
    '''

    :type: bool
    '''

    has_gravity: bool = None
    '''

    :type: bool
    '''

    has_height: bool = None
    '''

    :type: bool
    '''

    has_jitter: bool = None
    '''

    :type: bool
    '''

    has_normal_weight: bool = None
    '''

    :type: bool
    '''

    has_persistence: bool = None
    '''

    :type: bool
    '''

    has_pinch_factor: bool = None
    '''

    :type: bool
    '''

    has_plane_offset: bool = None
    '''

    :type: bool
    '''

    has_rake_factor: bool = None
    '''

    :type: bool
    '''

    has_random_texture_angle: bool = None
    '''

    :type: bool
    '''

    has_sculpt_plane: bool = None
    '''

    :type: bool
    '''

    has_secondary_color: bool = None
    '''

    :type: bool
    '''

    has_smooth_stroke: bool = None
    '''

    :type: bool
    '''

    has_space_attenuation: bool = None
    '''

    :type: bool
    '''

    has_strength_pressure: bool = None
    '''

    :type: bool
    '''

    has_topology_rake: bool = None
    '''

    :type: bool
    '''


class BrushCapabilitiesVertexPaint(bpy_struct):
    '''Read-only indications of supported operations '''

    has_color: bool = None
    '''

    :type: bool
    '''


class BrushCapabilitiesWeightPaint(bpy_struct):
    '''Read-only indications of supported operations '''

    has_weight: bool = None
    '''

    :type: bool
    '''


class BrushGpencilSettings(bpy_struct):
    '''Settings for grease pencil brush '''

    active_smooth_factor: float = None
    '''Amount of smoothing while drawing 

    :type: float
    '''

    angle: float = None
    '''Direction of the stroke at which brush gives maximal thickness (0° for horizontal) 

    :type: float
    '''

    angle_factor: float = None
    '''Reduce brush thickness by this factor when stroke is perpendicular to ‘Angle’ direction 

    :type: float
    '''

    curve_jitter: 'CurveMapping' = None
    '''Curve used for the jitter effect 

    :type: 'CurveMapping'
    '''

    curve_sensitivity: 'CurveMapping' = None
    '''Curve used for the sensitivity 

    :type: 'CurveMapping'
    '''

    curve_strength: 'CurveMapping' = None
    '''Curve used for the strength 

    :type: 'CurveMapping'
    '''

    eraser_mode: typing.Union[str, int] = None
    '''Eraser Mode 

    :type: typing.Union[str, int]
    '''

    eraser_strength_factor: float = None
    '''Amount of erasing for strength 

    :type: float
    '''

    eraser_thickness_factor: float = None
    '''Amount of erasing for thickness 

    :type: float
    '''

    fill_draw_mode: typing.Union[str, int] = None
    '''Mode to draw boundary limits 

    :type: typing.Union[str, int]
    '''

    fill_factor: int = None
    '''Multiplier for fill resolution, higher resolution is more accurate but slower 

    :type: int
    '''

    fill_leak: int = None
    '''Size in pixels to consider the leak closed 

    :type: int
    '''

    fill_simplify_level: int = None
    '''Number of simplify steps (large values reduce fill accuracy) 

    :type: int
    '''

    fill_threshold: float = None
    '''Threshold to consider color transparent for filling 

    :type: float
    '''

    gp_icon: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    gradient_factor: float = None
    '''Amount of gradient for Dot and Box strokes (set to 1 for full solid) 

    :type: float
    '''

    gradient_shape: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    input_samples: int = None
    '''Generate intermediate points for very fast mouse movements. Set to 0 to disable 

    :type: int
    '''

    material: 'Material' = None
    '''Material used for strokes drawn using this brush 

    :type: 'Material'
    '''

    pen_jitter: float = None
    '''Jitter factor for new strokes 

    :type: float
    '''

    pen_sensitivity_factor: float = None
    '''Pressure sensitivity factor for new strokes 

    :type: float
    '''

    pen_smooth_factor: float = None
    '''Amount of smoothing to apply after finish newly created strokes, to reduce jitter/noise 

    :type: float
    '''

    pen_smooth_steps: int = None
    '''Number of times to smooth newly created strokes 

    :type: int
    '''

    pen_strength: float = None
    '''Color strength for new strokes (affect alpha factor of color) 

    :type: float
    '''

    pen_subdivision_steps: int = None
    '''Number of times to subdivide newly created strokes, for less jagged strokes 

    :type: int
    '''

    pen_thick_smooth_factor: float = None
    '''Amount of thickness smoothing to apply after finish newly created strokes, to reduce jitter/noise 

    :type: float
    '''

    pen_thick_smooth_steps: int = None
    '''Number of times to smooth thickness for newly created strokes 

    :type: int
    '''

    random_pressure: float = None
    '''Randomness factor for pressure in new strokes 

    :type: float
    '''

    random_strength: float = None
    '''Randomness factor strength in new strokes 

    :type: float
    '''

    random_subdiv: float = None
    '''Randomness factor for new strokes after subdivision 

    :type: float
    '''

    show_fill: bool = None
    '''Show transparent lines to use as boundary for filling 

    :type: bool
    '''

    show_fill_boundary: bool = None
    '''Show help lines for filling to see boundaries 

    :type: bool
    '''

    show_lasso: bool = None
    '''Do not draw fill color while drawing the stroke 

    :type: bool
    '''

    simplify_factor: float = None
    '''Factor of Simplify using adaptive algorithm 

    :type: float
    '''

    trim: bool = None
    '''Trim intersecting stroke ends 

    :type: bool
    '''

    use_cursor: bool = None
    '''Enable cursor on screen 

    :type: bool
    '''

    use_default_eraser: bool = None
    '''Use this brush when enable eraser with fast switch key 

    :type: bool
    '''

    use_jitter_pressure: bool = None
    '''Use tablet pressure for jitter 

    :type: bool
    '''

    use_material_pin: bool = None
    '''Keep material assigned to brush 

    :type: bool
    '''

    use_occlude_eraser: bool = None
    '''Erase only strokes visible and not occluded 

    :type: bool
    '''

    use_pressure: bool = None
    '''Use tablet pressure 

    :type: bool
    '''

    use_settings_postprocess: bool = None
    '''Additional post processing options for new strokes 

    :type: bool
    '''

    use_settings_random: bool = None
    '''Random brush settings 

    :type: bool
    '''

    use_settings_stabilizer: bool = None
    '''Draw lines with a delay to allow smooth strokes. Press Shift key to override while drawing 

    :type: bool
    '''

    use_strength_pressure: bool = None
    '''Use tablet pressure for color strength 

    :type: bool
    '''

    uv_random: float = None
    '''Random factor for autogenerated UV rotation 

    :type: float
    '''


class CameraBackgroundImage(bpy_struct):
    '''Image and settings for display in the 3D View background '''

    alpha: float = None
    '''Image opacity to blend the image against the background color 

    :type: float
    '''

    clip: 'MovieClip' = None
    '''Movie clip displayed and edited in this space 

    :type: 'MovieClip'
    '''

    clip_user: 'MovieClipUser' = None
    '''Parameters defining which frame of the movie clip is displayed 

    :type: 'MovieClipUser'
    '''

    display_depth: typing.Union[str, int] = None
    '''Display under or over everything 

    :type: typing.Union[str, int]
    '''

    frame_method: typing.Union[str, int] = None
    '''How the image fits in the camera frame 

    :type: typing.Union[str, int]
    '''

    image: 'Image' = None
    '''Image displayed and edited in this space 

    :type: 'Image'
    '''

    image_user: 'ImageUser' = None
    '''Parameters defining which layer, pass and frame of the image is displayed 

    :type: 'ImageUser'
    '''

    offset: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    rotation: float = None
    '''Rotation for the background image (ortho view only) 

    :type: float
    '''

    scale: float = None
    '''Scale the background image 

    :type: float
    '''

    show_background_image: bool = None
    '''Show this image as background 

    :type: bool
    '''

    show_expanded: bool = None
    '''Show the expanded in the user interface 

    :type: bool
    '''

    show_on_foreground: bool = None
    '''Show this image in front of objects in viewport 

    :type: bool
    '''

    source: typing.Union[str, int] = None
    '''Data source used for background 

    :type: typing.Union[str, int]
    '''

    use_camera_clip: bool = None
    '''Use movie clip from active scene camera 

    :type: bool
    '''

    use_flip_x: bool = None
    '''Flip the background image horizontally 

    :type: bool
    '''

    use_flip_y: bool = None
    '''Flip the background image vertically 

    :type: bool
    '''


class CameraBackgroundImages(bpy_struct):
    '''Collection of background images '''

    def new(self, ) -> 'CameraBackgroundImage':
        '''Add new background image 

        :rtype: 'CameraBackgroundImage'
        :return:  Image displayed as viewport background 
        '''
        pass

    def remove(self, image: 'CameraBackgroundImage'):
        '''Remove background image 

        :param image: Image displayed as viewport background 
        :type image: 'CameraBackgroundImage'
        '''
        pass

    def clear(self, ):
        '''Remove all background images 

        '''
        pass


class CameraDOFSettings(bpy_struct):
    '''Depth of Field settings '''

    aperture_blades: int = None
    '''Number of blades in aperture for polygonal bokeh (at least 3) 

    :type: int
    '''

    aperture_fstop: float = None
    '''F-Stop ratio (lower numbers give more defocus, higher numbers give a sharper image) 

    :type: float
    '''

    aperture_ratio: float = None
    '''Distortion to simulate anamorphic lens bokeh 

    :type: float
    '''

    aperture_rotation: float = None
    '''Rotation of blades in aperture 

    :type: float
    '''

    focus_distance: float = None
    '''Distance to the focus point for depth of field 

    :type: float
    '''

    focus_object: 'Object' = None
    '''Use this object to define the depth of field focal point 

    :type: 'Object'
    '''

    use_dof: bool = None
    '''Use Depth of Field 

    :type: bool
    '''


class CameraStereoData(bpy_struct):
    '''Stereoscopy settings for a Camera data-block '''

    convergence_distance: float = None
    '''The converge point for the stereo cameras (often the distance between a projector and the projection screen) 

    :type: float
    '''

    convergence_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    interocular_distance: float = None
    '''Set the distance between the eyes - the stereo plane distance / 30 should be fine 

    :type: float
    '''

    pivot: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    pole_merge_angle_from: float = None
    '''Angle at which interocular distance starts to fade to 0 

    :type: float
    '''

    pole_merge_angle_to: float = None
    '''Angle at which interocular distance is 0 

    :type: float
    '''

    use_pole_merge: bool = None
    '''Fade interocular distance to 0 after the given cutoff angle 

    :type: bool
    '''

    use_spherical_stereo: bool = None
    '''Render every pixel rotating the camera around the middle of the interocular distance 

    :type: bool
    '''


class ChannelDriverVariables(bpy_struct):
    '''Collection of channel driver Variables '''

    def new(self, ) -> 'DriverVariable':
        '''Add a new variable for the driver 

        :rtype: 'DriverVariable'
        :return:  Newly created Driver Variable 
        '''
        pass

    def remove(self, variable: 'DriverVariable'):
        '''Remove an existing variable from the driver 

        :param variable: Variable to remove from the driver 
        :type variable: 'DriverVariable'
        '''
        pass


class ChildParticle(bpy_struct):
    '''Child particle interpolated from simulated or edited particles '''

    pass


class ClothCollisionSettings(bpy_struct):
    '''Cloth simulation settings for self collision and collision with other objects '''

    collection: 'Collection' = None
    '''Limit colliders to this Collection 

    :type: 'Collection'
    '''

    collision_quality: int = None
    '''How many collision iterations should be done. (higher is better quality but slower) 

    :type: int
    '''

    damping: float = None
    '''Amount of velocity lost on collision 

    :type: float
    '''

    distance_min: float = None
    '''Minimum distance between collision objects before collision response takes effect 

    :type: float
    '''

    friction: float = None
    '''Friction force if a collision happened (higher = less movement) 

    :type: float
    '''

    impulse_clamp: float = None
    '''Clamp collision impulses to avoid instability (0.0 to disable clamping) 

    :type: float
    '''

    self_distance_min: float = None
    '''Minimum distance between cloth faces before collision response takes effect 

    :type: float
    '''

    self_friction: float = None
    '''Friction with self contact 

    :type: float
    '''

    self_impulse_clamp: float = None
    '''Clamp collision impulses to avoid instability (0.0 to disable clamping) 

    :type: float
    '''

    use_collision: bool = None
    '''Enable collisions with other objects 

    :type: bool
    '''

    use_self_collision: bool = None
    '''Enable self collisions 

    :type: bool
    '''

    vertex_group_self_collisions: str = None
    '''Vertex group to define vertices which are not used during self collisions 

    :type: str
    '''


class ClothSettings(bpy_struct):
    '''Cloth simulation settings for an object '''

    air_damping: float = None
    '''Air has normally some thickness which slows falling things down 

    :type: float
    '''

    bending_damping: float = None
    '''Amount of damping in bending behavior 

    :type: float
    '''

    bending_model: typing.Union[str, int] = None
    '''Physical model for simulating bending forces 

    :type: typing.Union[str, int]
    '''

    bending_stiffness: float = None
    '''How much the material resists bending 

    :type: float
    '''

    bending_stiffness_max: float = None
    '''Maximum bending stiffness value 

    :type: float
    '''

    collider_friction: float = None
    '''

    :type: float
    '''

    compression_damping: float = None
    '''Amount of damping in compression behavior 

    :type: float
    '''

    compression_stiffness: float = None
    '''How much the material resists compression 

    :type: float
    '''

    compression_stiffness_max: float = None
    '''Maximum compression stiffness value 

    :type: float
    '''

    density_strength: float = None
    '''Influence of target density on the simulation 

    :type: float
    '''

    density_target: float = None
    '''Maximum density of hair 

    :type: float
    '''

    effector_weights: 'EffectorWeights' = None
    '''

    :type: 'EffectorWeights'
    '''

    goal_default: float = None
    '''Default Goal (vertex target position) value, when no Vertex Group used 

    :type: float
    '''

    goal_friction: float = None
    '''Goal (vertex target position) friction 

    :type: float
    '''

    goal_max: float = None
    '''Goal maximum, vertex group weights are scaled to match this range 

    :type: float
    '''

    goal_min: float = None
    '''Goal minimum, vertex group weights are scaled to match this range 

    :type: float
    '''

    goal_spring: float = None
    '''Goal (vertex target position) spring stiffness 

    :type: float
    '''

    gravity: typing.List[float] = None
    '''Gravity or external force vector 

    :type: typing.List[float]
    '''

    internal_compression_stiffness: float = None
    '''How much the material resists compression 

    :type: float
    '''

    internal_compression_stiffness_max: float = None
    '''Maximum compression stiffness value 

    :type: float
    '''

    internal_friction: float = None
    '''

    :type: float
    '''

    internal_spring_max_diversion: float = None
    '''How much the rays used to connect the internal points can diverge from the vertex normal 

    :type: float
    '''

    internal_spring_max_length: float = None
    '''The maximum length an internal spring can have during creation. If the distance between internal points is greater than this, no internal spring will be created between these points. A length of zero means that there is no length limit 

    :type: float
    '''

    internal_spring_normal_check: bool = None
    '''Require the points the internal springs connect to have opposite normal directions 

    :type: bool
    '''

    internal_tension_stiffness: float = None
    '''How much the material resists stretching 

    :type: float
    '''

    internal_tension_stiffness_max: float = None
    '''Maximum tension stiffness value 

    :type: float
    '''

    mass: float = None
    '''The mass of each vertex on the cloth material 

    :type: float
    '''

    pin_stiffness: float = None
    '''Pin (vertex target position) spring stiffness 

    :type: float
    '''

    pressure_factor: float = None
    '''Air pressure scaling factor 

    :type: float
    '''

    quality: int = None
    '''Quality of the simulation in steps per frame (higher is better quality but slower) 

    :type: int
    '''

    rest_shape_key: 'ShapeKey' = None
    '''Shape key to use the rest spring lengths from 

    :type: 'ShapeKey'
    '''

    sewing_force_max: float = None
    '''Maximum sewing force 

    :type: float
    '''

    shear_damping: float = None
    '''Amount of damping in shearing behavior 

    :type: float
    '''

    shear_stiffness: float = None
    '''How much the material resists shearing 

    :type: float
    '''

    shear_stiffness_max: float = None
    '''Maximum shear scaling value 

    :type: float
    '''

    shrink_max: float = None
    '''Max amount to shrink cloth by 

    :type: float
    '''

    shrink_min: float = None
    '''Factor by which to shrink cloth 

    :type: float
    '''

    target_volume: float = None
    '''The mesh volume where the inner/outer pressure will be the same. If set to zero the volume will not contribute to the total pressure 

    :type: float
    '''

    tension_damping: float = None
    '''Amount of damping in stretching behavior 

    :type: float
    '''

    tension_stiffness: float = None
    '''How much the material resists stretching 

    :type: float
    '''

    tension_stiffness_max: float = None
    '''Maximum tension stiffness value 

    :type: float
    '''

    time_scale: float = None
    '''Cloth speed is multiplied by this value 

    :type: float
    '''

    uniform_pressure_force: float = None
    '''The uniform pressure that is constantly applied to the mesh. Can be negative 

    :type: float
    '''

    use_dynamic_mesh: bool = None
    '''Make simulation respect deformations in the base mesh 

    :type: bool
    '''

    use_internal_springs: bool = None
    '''Simulate an internal volume structure by creating springs connecting the opposite sides of the mesh 

    :type: bool
    '''

    use_pressure: bool = None
    '''Simulate pressure inside a closed cloth mesh 

    :type: bool
    '''

    use_pressure_volume: bool = None
    '''Use the Volume parameter as the initial volume 

    :type: bool
    '''

    use_sewing_springs: bool = None
    '''Pulls loose edges together 

    :type: bool
    '''

    vertex_group_bending: str = None
    '''Vertex group for fine control over bending stiffness 

    :type: str
    '''

    vertex_group_intern: str = None
    '''Vertex group for fine control over the internal spring stiffness 

    :type: str
    '''

    vertex_group_mass: str = None
    '''Vertex Group for pinning of vertices 

    :type: str
    '''

    vertex_group_pressure: str = None
    '''Vertex Group for where to apply pressure. Zero weight means no pressure while a weight of one means full pressure. Faces with a vertex that has zero weight will be excluded from the volume calculation 

    :type: str
    '''

    vertex_group_shear_stiffness: str = None
    '''Vertex group for fine control over shear stiffness 

    :type: str
    '''

    vertex_group_shrink: str = None
    '''Vertex Group for shrinking cloth 

    :type: str
    '''

    vertex_group_structural_stiffness: str = None
    '''Vertex group for fine control over structural stiffness 

    :type: str
    '''

    voxel_cell_size: float = None
    '''Size of the voxel grid cells for interaction effects 

    :type: float
    '''


class ClothSolverResult(bpy_struct):
    '''Result of cloth solver iteration '''

    avg_error: float = None
    '''Average error during substeps 

    :type: float
    '''

    avg_iterations: float = None
    '''Average iterations during substeps 

    :type: float
    '''

    max_error: float = None
    '''Maximum error during substeps 

    :type: float
    '''

    max_iterations: int = None
    '''Maximum iterations during substeps 

    :type: int
    '''

    min_error: float = None
    '''Minimum error during substeps 

    :type: float
    '''

    min_iterations: int = None
    '''Minimum iterations during substeps 

    :type: int
    '''

    status: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Status of the solver iteration 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''


class CollectionChildren(bpy_struct):
    '''Collection of child collections '''

    def link(self, child: 'Collection'):
        '''Add this collection as child of this collection 

        :param child: Collection to add 
        :type child: 'Collection'
        '''
        pass

    def unlink(self, child: 'Collection'):
        '''Remove this child collection from a collection 

        :param child: Collection to remove 
        :type child: 'Collection'
        '''
        pass


class CollectionObjects(bpy_struct):
    '''Collection of collection objects '''

    def link(self, object: 'Object'):
        '''Add this object to a collection 

        :param object: Object to add 
        :type object: 'Object'
        '''
        pass

    def unlink(self, object: 'Object'):
        '''Remove this object from a collection 

        :param object: Object to remove 
        :type object: 'Object'
        '''
        pass


class CollisionSettings(bpy_struct):
    '''Collision settings for object in physics simulation '''

    absorption: float = None
    '''How much of effector force gets lost during collision with this object (in percent) 

    :type: float
    '''

    cloth_friction: float = None
    '''Friction for cloth collisions 

    :type: float
    '''

    damping: float = None
    '''Amount of damping during collision 

    :type: float
    '''

    damping_factor: float = None
    '''Amount of damping during particle collision 

    :type: float
    '''

    damping_random: float = None
    '''Random variation of damping 

    :type: float
    '''

    friction_factor: float = None
    '''Amount of friction during particle collision 

    :type: float
    '''

    friction_random: float = None
    '''Random variation of friction 

    :type: float
    '''

    permeability: float = None
    '''Chance that the particle will pass through the mesh 

    :type: float
    '''

    stickiness: float = None
    '''Amount of stickiness to surface collision 

    :type: float
    '''

    thickness_inner: float = None
    '''Inner face thickness (only used by softbodies) 

    :type: float
    '''

    thickness_outer: float = None
    '''Outer face thickness 

    :type: float
    '''

    use: bool = None
    '''Enable this objects as a collider for physics systems 

    :type: bool
    '''

    use_culling: bool = None
    '''Cloth collision acts with respect to the collider normals (improves penetration recovery) 

    :type: bool
    '''

    use_normal: bool = None
    '''Cloth collision impulses act in the direction of the collider normals (more reliable in some cases) 

    :type: bool
    '''

    use_particle_kill: bool = None
    '''Kill collided particles 

    :type: bool
    '''


class ColorManagedDisplaySettings(bpy_struct):
    '''Color management specific to display device '''

    display_device: typing.Union[str, int] = None
    '''Display device name 

    :type: typing.Union[str, int]
    '''


class ColorManagedInputColorspaceSettings(bpy_struct):
    '''Input color space settings '''

    is_data: bool = None
    '''Treat image as non-color data without color management, like normal or displacement maps 

    :type: bool
    '''

    name: typing.Union[str, int] = None
    '''Color space in the image file, to convert to and from when saving and loading the image 

    :type: typing.Union[str, int]
    '''


class ColorManagedSequencerColorspaceSettings(bpy_struct):
    '''Input color space settings '''

    name: typing.Union[str, int] = None
    '''Color space that the sequencer operates in 

    :type: typing.Union[str, int]
    '''


class ColorManagedViewSettings(bpy_struct):
    '''Color management settings used for displaying images on the display '''

    curve_mapping: 'CurveMapping' = None
    '''Color curve mapping applied before display transform 

    :type: 'CurveMapping'
    '''

    exposure: float = None
    '''Exposure (stops) applied before display transform 

    :type: float
    '''

    gamma: float = None
    '''Amount of gamma modification applied after display transform 

    :type: float
    '''

    look: typing.Union[str, int] = None
    '''Additional transform applied before view transform for an artistic needs 

    :type: typing.Union[str, int]
    '''

    use_curve_mapping: bool = None
    '''Use RGB curved for pre-display transformation 

    :type: bool
    '''

    view_transform: typing.Union[str, int] = None
    '''View used when converting image to a display space 

    :type: typing.Union[str, int]
    '''


class ColorMapping(bpy_struct):
    '''Color mapping settings '''

    blend_color: typing.List[float] = None
    '''Blend color to mix with texture output color 

    :type: typing.List[float]
    '''

    blend_factor: float = None
    '''

    :type: float
    '''

    blend_type: typing.Union[str, int] = None
    '''Mode used to mix with texture output color 

    :type: typing.Union[str, int]
    '''

    brightness: float = None
    '''Adjust the brightness of the texture 

    :type: float
    '''

    color_ramp: 'ColorRamp' = None
    '''

    :type: 'ColorRamp'
    '''

    contrast: float = None
    '''Adjust the contrast of the texture 

    :type: float
    '''

    saturation: float = None
    '''Adjust the saturation of colors in the texture 

    :type: float
    '''

    use_color_ramp: bool = None
    '''Toggle color ramp operations 

    :type: bool
    '''


class ColorRamp(bpy_struct):
    '''Color ramp mapping a scalar value to a color '''

    color_mode: typing.Union[str, int] = None
    '''Set color mode to use for interpolation 

    :type: typing.Union[str, int]
    '''

    elements: typing.Union[typing.List['ColorRampElement'],
                           'bpy_prop_collection', 'ColorRampElements'] = None
    '''

    :type: typing.Union[typing.List['ColorRampElement'], 'bpy_prop_collection', 'ColorRampElements']
    '''

    hue_interpolation: typing.Union[str, int] = None
    '''Set color interpolation 

    :type: typing.Union[str, int]
    '''

    interpolation: typing.Union[str, int] = None
    '''Set interpolation between color stops 

    :type: typing.Union[str, int]
    '''

    def evaluate(self, position: float) -> typing.List[float]:
        '''Evaluate ColorRamp 

        :param position: Position, Evaluate ColorRamp at position 
        :type position: float
        :rtype: typing.List[float]
        :return:  Color, Color at given position 
        '''
        pass


class ColorRampElement(bpy_struct):
    '''Element defining a color at a position in the color ramp '''

    alpha: float = None
    '''Set alpha of selected color stop 

    :type: float
    '''

    color: typing.List[float] = None
    '''Set color of selected color stop 

    :type: typing.List[float]
    '''

    position: float = None
    '''Set position of selected color stop 

    :type: float
    '''


class ColorRampElements(bpy_struct):
    '''Collection of Color Ramp Elements '''

    def new(self, position: float) -> 'ColorRampElement':
        '''Add element to ColorRamp 

        :param position: Position, Position to add element 
        :type position: float
        :rtype: 'ColorRampElement'
        :return:  New element 
        '''
        pass

    def remove(self, element: 'ColorRampElement'):
        '''Delete element from ColorRamp 

        :param element: Element to remove 
        :type element: 'ColorRampElement'
        '''
        pass


class CompositorNodeOutputFileFileSlots(bpy_struct):
    '''Collection of File Output node slots '''

    def new(self, name: str) -> 'NodeSocket':
        '''Add a file slot to this node 

        :param name: Name 
        :type name: str
        :rtype: 'NodeSocket'
        :return:  New socket 
        '''
        pass

    def remove(self, socket: 'NodeSocket'):
        '''Remove a file slot from this node 

        :param socket: The socket to remove 
        :type socket: 'NodeSocket'
        '''
        pass

    def clear(self, ):
        '''Remove all file slots from this node 

        '''
        pass

    def move(self, from_index: int, to_index: int):
        '''Move a file slot to another position 

        :param from_index: From Index, Index of the socket to move 
        :type from_index: int
        :param to_index: To Index, Target index for the socket 
        :type to_index: int
        '''
        pass


class CompositorNodeOutputFileLayerSlots(bpy_struct):
    '''Collection of File Output node slots '''

    def new(self, name: str) -> 'NodeSocket':
        '''Add a file slot to this node 

        :param name: Name 
        :type name: str
        :rtype: 'NodeSocket'
        :return:  New socket 
        '''
        pass

    def remove(self, socket: 'NodeSocket'):
        '''Remove a file slot from this node 

        :param socket: The socket to remove 
        :type socket: 'NodeSocket'
        '''
        pass

    def clear(self, ):
        '''Remove all file slots from this node 

        '''
        pass

    def move(self, from_index: int, to_index: int):
        '''Move a file slot to another position 

        :param from_index: From Index, Index of the socket to move 
        :type from_index: int
        :param to_index: To Index, Target index for the socket 
        :type to_index: int
        '''
        pass


class ConsoleLine(bpy_struct):
    '''Input line for the interactive console '''

    body: str = None
    '''Text in the line 

    :type: str
    '''

    current_character: int = None
    '''

    :type: int
    '''

    type: typing.Union[str, int] = None
    '''Console line type when used in scrollback 

    :type: typing.Union[str, int]
    '''


class Constraint(bpy_struct):
    '''Constraint modifying the transformation of objects and bones '''

    active: bool = None
    '''Constraint is the one being edited 

    :type: bool
    '''

    error_location: float = None
    '''Amount of residual error in Blender space unit for constraints that work on position 

    :type: float
    '''

    error_rotation: float = None
    '''Amount of residual error in radians for constraints that work on orientation 

    :type: float
    '''

    influence: float = None
    '''Amount of influence constraint will have on the final solution 

    :type: float
    '''

    is_proxy_local: bool = None
    '''Constraint was added in this proxy instance (i.e. did not belong to source Armature) 

    :type: bool
    '''

    is_valid: bool = None
    '''Constraint has valid settings and can be evaluated 

    :type: bool
    '''

    mute: bool = None
    '''Enable/Disable Constraint 

    :type: bool
    '''

    name: str = None
    '''Constraint name 

    :type: str
    '''

    owner_space: typing.Union[str, int] = None
    '''Space that owner is evaluated in 

    :type: typing.Union[str, int]
    '''

    show_expanded: bool = None
    '''Constraint’s panel is expanded in UI 

    :type: bool
    '''

    target_space: typing.Union[str, int] = None
    '''Space that target is evaluated in 

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''


class ConstraintTarget(bpy_struct):
    '''Target object for multi-target constraints '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''


class ConstraintTargetBone(bpy_struct):
    '''Target bone for multi-target constraints '''

    subtarget: str = None
    '''Target armature bone 

    :type: str
    '''

    target: 'Object' = None
    '''Target armature 

    :type: 'Object'
    '''

    weight: float = None
    '''Blending weight of this bone 

    :type: float
    '''


class Context(bpy_struct):
    '''Current windowmanager and data context '''

    area: 'Area' = None
    '''

    :type: 'Area'
    '''

    blend_data: 'BlendData' = None
    '''

    :type: 'BlendData'
    '''

    collection: 'Collection' = None
    '''

    :type: 'Collection'
    '''

    engine: str = None
    '''

    :type: str
    '''

    gizmo_group: 'GizmoGroup' = None
    '''

    :type: 'GizmoGroup'
    '''

    layer_collection: 'LayerCollection' = None
    '''

    :type: 'LayerCollection'
    '''

    mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    preferences: 'Preferences' = None
    '''

    :type: 'Preferences'
    '''

    region: 'Region' = None
    '''

    :type: 'Region'
    '''

    region_data: 'RegionView3D' = None
    '''

    :type: 'RegionView3D'
    '''

    scene: 'Scene' = None
    '''

    :type: 'Scene'
    '''

    screen: 'Screen' = None
    '''

    :type: 'Screen'
    '''

    space_data: 'Space' = None
    '''

    :type: 'Space'
    '''

    tool_settings: 'ToolSettings' = None
    '''

    :type: 'ToolSettings'
    '''

    view_layer: 'ViewLayer' = None
    '''

    :type: 'ViewLayer'
    '''

    window: 'Window' = None
    '''

    :type: 'Window'
    '''

    window_manager: 'WindowManager' = None
    '''

    :type: 'WindowManager'
    '''

    workspace: 'WorkSpace' = None
    '''

    :type: 'WorkSpace'
    '''

    active_object: 'Object' = None
    '''

    :type: 'Object'
    '''

    visible_objects: typing.List['Object'] = None
    '''

    :type: typing.List['Object']
    '''

    selectable_objects: typing.List['Object'] = None
    '''

    :type: typing.List['Object']
    '''

    selected_objects: typing.List['Object'] = None
    '''

    :type: typing.List['Object']
    '''

    editable_objects: typing.List['Object'] = None
    '''

    :type: typing.List['Object']
    '''

    selected_editable_objects: typing.List['Object'] = None
    '''

    :type: typing.List['Object']
    '''

    objects_in_mode: typing.List['Object'] = None
    '''

    :type: typing.List['Object']
    '''

    objects_in_mode_unique_data: typing.List['Object'] = None
    '''

    :type: typing.List['Object']
    '''

    visible_bones: typing.List['EditBone'] = None
    '''

    :type: typing.List['EditBone']
    '''

    editable_bones: typing.List['EditBone'] = None
    '''

    :type: typing.List['EditBone']
    '''

    selected_bones: typing.List['EditBone'] = None
    '''

    :type: typing.List['EditBone']
    '''

    selected_editable_bones: typing.List['EditBone'] = None
    '''

    :type: typing.List['EditBone']
    '''

    visible_pose_bones: typing.List['EditBone'] = None
    '''

    :type: typing.List['EditBone']
    '''

    selected_pose_bones: typing.List['EditBone'] = None
    '''

    :type: typing.List['EditBone']
    '''

    selected_pose_bones_from_active_object: typing.List['EditBone'] = None
    '''

    :type: typing.List['EditBone']
    '''

    active_bone: 'EditBone' = None
    '''

    :type: 'EditBone'
    '''

    active_pose_bone: 'PoseBone' = None
    '''

    :type: 'PoseBone'
    '''

    object: 'Object' = None
    '''

    :type: 'Object'
    '''

    edit_object: 'Object' = None
    '''

    :type: 'Object'
    '''

    sculpt_object: 'Object' = None
    '''

    :type: 'Object'
    '''

    vertex_paint_object: 'Object' = None
    '''

    :type: 'Object'
    '''

    weight_paint_object: 'Object' = None
    '''

    :type: 'Object'
    '''

    image_paint_object: 'Object' = None
    '''

    :type: 'Object'
    '''

    particle_edit_object: 'Object' = None
    '''

    :type: 'Object'
    '''

    pose_object: 'Object' = None
    '''

    :type: 'Object'
    '''

    sequences: typing.List['Sequence'] = None
    '''

    :type: typing.List['Sequence']
    '''

    selected_sequences: typing.List['Sequence'] = None
    '''

    :type: typing.List['Sequence']
    '''

    selected_editable_sequences: typing.List['Sequence'] = None
    '''

    :type: typing.List['Sequence']
    '''

    gpencil_data: 'GreasePencil' = None
    '''

    :type: 'GreasePencil'
    '''

    gpencil_data_owner: 'ID' = None
    '''

    :type: 'ID'
    '''

    visible_gpencil_layers: typing.List['GPencilLayer'] = None
    '''

    :type: typing.List['GPencilLayer']
    '''

    editable_gpencil_layers: typing.List['GPencilLayer'] = None
    '''

    :type: typing.List['GPencilLayer']
    '''

    editable_gpencil_strokes: typing.List['GPencilStroke'] = None
    '''

    :type: typing.List['GPencilStroke']
    '''

    active_gpencil_layer: typing.List['GPencilLayer'] = None
    '''

    :type: typing.List['GPencilLayer']
    '''

    active_gpencil_frame: list = None
    '''

    :type: list
    '''

    active_operator: 'Operator' = None
    '''

    :type: 'Operator'
    '''

    selected_editable_fcurves: typing.List['FCurve'] = None
    '''

    :type: typing.List['FCurve']
    '''

    active_base: 'ObjectBase' = None
    '''

    :type: 'ObjectBase'
    '''

    texture_slot = None
    ''''''

    world: 'World' = None
    '''

    :type: 'World'
    '''

    mesh: 'Mesh' = None
    '''

    :type: 'Mesh'
    '''

    armature: 'Armature' = None
    '''

    :type: 'Armature'
    '''

    lattice: 'Lattice' = None
    '''

    :type: 'Lattice'
    '''

    curve: 'Curve' = None
    '''

    :type: 'Curve'
    '''

    meta_ball: 'MetaBall' = None
    '''

    :type: 'MetaBall'
    '''

    light: 'Light' = None
    '''

    :type: 'Light'
    '''

    speaker: 'Speaker' = None
    '''

    :type: 'Speaker'
    '''

    lightprobe: 'LightProbe' = None
    '''

    :type: 'LightProbe'
    '''

    camera: 'Camera' = None
    '''

    :type: 'Camera'
    '''

    material: 'Material' = None
    '''

    :type: 'Material'
    '''

    material_slot: 'MaterialSlot' = None
    '''

    :type: 'MaterialSlot'
    '''

    texture: 'Texture' = None
    '''

    :type: 'Texture'
    '''

    texture_user: 'ID' = None
    '''

    :type: 'ID'
    '''

    texture_user_property: 'Property' = None
    '''

    :type: 'Property'
    '''

    bone: 'Bone' = None
    '''

    :type: 'Bone'
    '''

    edit_bone: 'EditBone' = None
    '''

    :type: 'EditBone'
    '''

    pose_bone: 'PoseBone' = None
    '''

    :type: 'PoseBone'
    '''

    particle_system: 'ParticleSystem' = None
    '''

    :type: 'ParticleSystem'
    '''

    particle_system_editable: 'ParticleSystem' = None
    '''

    :type: 'ParticleSystem'
    '''

    particle_settings: 'ParticleSettings' = None
    '''

    :type: 'ParticleSettings'
    '''

    cloth: 'ClothModifier' = None
    '''

    :type: 'ClothModifier'
    '''

    soft_body: 'SoftBodyModifier' = None
    '''

    :type: 'SoftBodyModifier'
    '''

    fluid = None
    ''''''

    smoke = None
    ''''''

    collision: 'CollisionModifier' = None
    '''

    :type: 'CollisionModifier'
    '''

    brush: 'Brush' = None
    '''

    :type: 'Brush'
    '''

    dynamic_paint: 'DynamicPaintModifier' = None
    '''

    :type: 'DynamicPaintModifier'
    '''

    line_style: 'FreestyleLineStyle' = None
    '''

    :type: 'FreestyleLineStyle'
    '''

    gpencil: 'GreasePencil' = None
    '''

    :type: 'GreasePencil'
    '''

    edit_image: 'Image' = None
    '''

    :type: 'Image'
    '''

    edit_mask: 'Mask' = None
    '''

    :type: 'Mask'
    '''

    selected_nodes: typing.List['Node'] = None
    '''

    :type: typing.List['Node']
    '''

    active_node: 'Node' = None
    '''

    :type: 'Node'
    '''

    edit_text: 'Text' = None
    '''

    :type: 'Text'
    '''

    edit_movieclip: 'MovieClip' = None
    '''

    :type: 'MovieClip'
    '''

    def evaluated_depsgraph_get(self, ) -> 'Depsgraph':
        '''Get the dependency graph for the current scene and view layer, to access to data-blocks with animation and modifiers applied. If any data-blocks have been edited, the dependency graph will be updated. This invalidates all references to evaluated data-blocks from the dependency graph. 

        :rtype: 'Depsgraph'
        :return:  Evaluated dependency graph 
        '''
        pass

    def copy(self, ):
        '''

        '''
        pass


class CurveMap(bpy_struct):
    '''Curve in a curve mapping '''

    points: typing.Union[typing.List['CurveMapPoint'], 'bpy_prop_collection',
                         'CurveMapPoints'] = None
    '''

    :type: typing.Union[typing.List['CurveMapPoint'], 'bpy_prop_collection', 'CurveMapPoints']
    '''


class CurveMapPoint(bpy_struct):
    '''Point of a curve used for a curve mapping '''

    handle_type: typing.Union[str, int] = None
    '''Curve interpolation at this point: Bezier or vector 

    :type: typing.Union[str, int]
    '''

    location: typing.List[float] = None
    '''X/Y coordinates of the curve point 

    :type: typing.List[float]
    '''

    select: bool = None
    '''Selection state of the curve point 

    :type: bool
    '''


class CurveMapPoints(bpy_struct):
    '''Collection of Curve Map Points '''

    def new(self, position: float, value: float) -> 'CurveMapPoint':
        '''Add point to CurveMap 

        :param position: Position, Position to add point 
        :type position: float
        :param value: Value, Value of point 
        :type value: float
        :rtype: 'CurveMapPoint'
        :return:  New point 
        '''
        pass

    def remove(self, point: 'CurveMapPoint'):
        '''Delete point from CurveMap 

        :param point: PointElement to remove 
        :type point: 'CurveMapPoint'
        '''
        pass


class CurveMapping(bpy_struct):
    '''Curve mapping to map color, vector and scalar values to other values using a user defined curve '''

    black_level: typing.List[float] = None
    '''For RGB curves, the color that black is mapped to 

    :type: typing.List[float]
    '''

    clip_max_x: float = None
    '''

    :type: float
    '''

    clip_max_y: float = None
    '''

    :type: float
    '''

    clip_min_x: float = None
    '''

    :type: float
    '''

    clip_min_y: float = None
    '''

    :type: float
    '''

    curves: typing.Union[typing.List['CurveMap'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['CurveMap'], 'bpy_prop_collection']
    '''

    extend: typing.Union[str, int] = None
    '''Extrapolate the curve or extend it horizontally 

    :type: typing.Union[str, int]
    '''

    tone: typing.Union[str, int] = None
    '''Tone of the curve 

    :type: typing.Union[str, int]
    '''

    use_clip: bool = None
    '''Force the curve view to fit a defined boundary 

    :type: bool
    '''

    white_level: typing.List[float] = None
    '''For RGB curves, the color that white is mapped to 

    :type: typing.List[float]
    '''

    def update(self, ):
        '''Update curve mapping after making changes 

        '''
        pass

    def initialize(self, ):
        '''Initialize curve 

        '''
        pass

    def evaluate(self, curve: 'CurveMap', position: float) -> float:
        '''Evaluate curve at given location 

        :param curve: curve, Curve to evaluate 
        :type curve: 'CurveMap'
        :param position: Position, Position to evaluate curve at 
        :type position: float
        :rtype: float
        :return:  Value, Value of curve at given location 
        '''
        pass


class CurvePaintSettings(bpy_struct):
    corner_angle: float = None
    '''Angles above this are considered corners 

    :type: float
    '''

    curve_type: typing.Union[str, int] = None
    '''Type of curve to use for new strokes 

    :type: typing.Union[str, int]
    '''

    depth_mode: typing.Union[str, int] = None
    '''Method of projecting depth 

    :type: typing.Union[str, int]
    '''

    error_threshold: int = None
    '''Allow deviation for a smoother, less precise line 

    :type: int
    '''

    fit_method: typing.Union[str, int] = None
    '''Curve fitting method 

    :type: typing.Union[str, int]
    '''

    radius_max: float = None
    '''Radius to use when the maximum pressure is applied (or when a tablet isn’t used) 

    :type: float
    '''

    radius_min: float = None
    '''Minimum radius when the minimum pressure is applied (also the minimum when tapering) 

    :type: float
    '''

    radius_taper_end: float = None
    '''Taper factor for the radius of each point along the curve 

    :type: float
    '''

    radius_taper_start: float = None
    '''Taper factor for the radius of each point along the curve 

    :type: float
    '''

    surface_offset: float = None
    '''Offset the stroke from the surface 

    :type: float
    '''

    surface_plane: typing.Union[str, int] = None
    '''Plane for projected stroke 

    :type: typing.Union[str, int]
    '''

    use_corners_detect: bool = None
    '''Detect corners and use non-aligned handles 

    :type: bool
    '''

    use_offset_absolute: bool = None
    '''Apply a fixed offset (don’t scale by the radius) 

    :type: bool
    '''

    use_pressure_radius: bool = None
    '''Map tablet pressure to curve radius 

    :type: bool
    '''

    use_stroke_endpoints: bool = None
    '''Use the start of the stroke for the depth 

    :type: bool
    '''


class CurveProfile(bpy_struct):
    '''Profile Path editor used to build a profile path '''

    points: typing.Union[typing.List['CurveProfilePoint'],
                         'bpy_prop_collection', 'CurveProfilePoints'] = None
    '''Profile control points 

    :type: typing.Union[typing.List['CurveProfilePoint'], 'bpy_prop_collection', 'CurveProfilePoints']
    '''

    preset: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    segments: typing.Union[typing.List['CurveProfilePoint'],
                           'bpy_prop_collection'] = None
    '''Segments sampled from control points 

    :type: typing.Union[typing.List['CurveProfilePoint'], 'bpy_prop_collection']
    '''

    use_clip: bool = None
    '''Force the path view to fit a defined boundary 

    :type: bool
    '''

    use_sample_even_lengths: bool = None
    '''Sample edges with even lengths 

    :type: bool
    '''

    use_sample_straight_edges: bool = None
    '''Sample edges with vector handles 

    :type: bool
    '''

    def update(self, ):
        '''Update the profile 

        '''
        pass

    def initialize(self, totsegments: int):
        '''Set the number of display segments and fill tables 

        :param totsegments: The number of segment values to initialize the segments table with 
        :type totsegments: int
        '''
        pass

    def evaluate(self, length_portion: float) -> typing.List[float]:
        '''Evaluate the at the given portion of the path length 

        :param length_portion: Length Portion, Portion of the path length to travel before evaluation 
        :type length_portion: float
        :rtype: typing.List[float]
        :return:  Location, The location at the given portion of the profile 
        '''
        pass


class CurveProfilePoint(bpy_struct):
    '''Point of a path used to define a profile '''

    handle_type_1: typing.Union[str, int] = None
    '''Path interpolation at this point: Bezier or vector 

    :type: typing.Union[str, int]
    '''

    handle_type_2: typing.Union[str, int] = None
    '''Path interpolation at this point: Bezier or vector 

    :type: typing.Union[str, int]
    '''

    location: typing.List[float] = None
    '''X/Y coordinates of the path point 

    :type: typing.List[float]
    '''

    select: bool = None
    '''Selection state of the path point 

    :type: bool
    '''


class CurveProfilePoints(bpy_struct):
    '''Collection of Profile Points '''

    def add(self, x: float, y: float) -> 'CurveProfilePoint':
        '''Add point to the profile 

        :param x: X Position, X Position for new point 
        :type x: float
        :param y: Y Position, Y Position for new point 
        :type y: float
        :rtype: 'CurveProfilePoint'
        :return:  New point 
        '''
        pass

    def remove(self, point: 'CurveProfilePoint'):
        '''Delete point from the profile 

        :param point: Point to remove 
        :type point: 'CurveProfilePoint'
        '''
        pass


class CurveSplines(bpy_struct):
    '''Collection of curve splines '''

    active: 'Spline' = None
    '''Active curve spline 

    :type: 'Spline'
    '''

    def new(self, type: typing.Union[str, int]) -> 'Spline':
        '''Add a new spline to the curve 

        :param type: type for the new spline 
        :type type: typing.Union[str, int]
        :rtype: 'Spline'
        :return:  The newly created spline 
        '''
        pass

    def remove(self, spline: 'Spline'):
        '''Remove a spline from a curve 

        :param spline: The spline to remove 
        :type spline: 'Spline'
        '''
        pass

    def clear(self, ):
        '''Remove all splines from a curve 

        '''
        pass


class Depsgraph(bpy_struct):
    ids: typing.Union[typing.List['ID'], 'bpy_prop_collection'] = None
    '''All evaluated datablocks 

    :type: typing.Union[typing.List['ID'], 'bpy_prop_collection']
    '''

    mode: typing.Union[str, int] = None
    '''Evaluation mode 

    :type: typing.Union[str, int]
    '''

    object_instances: typing.Union[typing.List['DepsgraphObjectInstance'],
                                   'bpy_prop_collection'] = None
    '''All object instances to display or render (WARNING: only use this as an iterator, never as a sequence, and do not keep any references to its items) 

    :type: typing.Union[typing.List['DepsgraphObjectInstance'], 'bpy_prop_collection']
    '''

    objects: typing.Union[typing.List['Object'], 'bpy_prop_collection'] = None
    '''Evaluated objects in the dependency graph 

    :type: typing.Union[typing.List['Object'], 'bpy_prop_collection']
    '''

    scene: 'Scene' = None
    '''Original scene dependency graph is built for 

    :type: 'Scene'
    '''

    scene_eval: 'Scene' = None
    '''Original scene dependency graph is built for 

    :type: 'Scene'
    '''

    updates: typing.Union[typing.List['DepsgraphUpdate'],
                          'bpy_prop_collection'] = None
    '''Updates to datablocks 

    :type: typing.Union[typing.List['DepsgraphUpdate'], 'bpy_prop_collection']
    '''

    view_layer: 'ViewLayer' = None
    '''Original view layer dependency graph is built for 

    :type: 'ViewLayer'
    '''

    view_layer_eval: 'ViewLayer' = None
    '''Original view layer dependency graph is built for 

    :type: 'ViewLayer'
    '''

    def debug_relations_graphviz(self, filename: str):
        '''debug_relations_graphviz 

        :param filename: File Name, Output path for the graphviz debug file 
        :type filename: str
        '''
        pass

    def debug_stats_gnuplot(self, filename: str, output_filename: str):
        '''debug_stats_gnuplot 

        :param filename: File Name, Output path for the gnuplot debug file 
        :type filename: str
        :param output_filename: Output File Name, File name where gnuplot script will save the result 
        :type output_filename: str
        '''
        pass

    def debug_tag_update(self, ):
        '''debug_tag_update 

        '''
        pass

    def debug_stats(self, ) -> str:
        '''Report the number of elements in the Dependency Graph 

        :rtype: str
        :return:  result 
        '''
        pass

    def update(self, ):
        '''Re-evaluate any modified data-blocks, for example for animation or modifiers. This invalidates all references to evaluated data-blocks from this dependency graph. 

        '''
        pass

    def id_eval_get(self, id: 'ID') -> 'ID':
        '''id_eval_get 

        :param id: Original ID to get evaluated complementary part for 
        :type id: 'ID'
        :rtype: 'ID'
        :return:  Evaluated ID for the given original one 
        '''
        pass

    def id_type_updated(self, id_type: typing.Union[str, int]) -> bool:
        '''id_type_updated 

        :param id_type: ID Type 
        :type id_type: typing.Union[str, int]
        :rtype: bool
        :return:  Updated, True if any datablock with this type was added, updated or removed 
        '''
        pass


class DepsgraphObjectInstance(bpy_struct):
    '''Extended information about dependency graph object iterator (WARNING: all data here is evaluated one, not original .blend IDs…) '''

    instance_object: 'Object' = None
    '''Evaluated object which is being instanced by this iterator 

    :type: 'Object'
    '''

    is_instance: bool = None
    '''Denotes if the object is generated by another object 

    :type: bool
    '''

    matrix_world: typing.List[float] = None
    '''Generated transform matrix in world space 

    :type: typing.List[float]
    '''

    object: 'Object' = None
    '''Evaluated object the iterator points to 

    :type: 'Object'
    '''

    orco: typing.List[float] = None
    '''Generated coordinates in parent object space 

    :type: typing.List[float]
    '''

    parent: 'Object' = None
    '''If the object is an instance, the parent object that generated it 

    :type: 'Object'
    '''

    particle_system: 'ParticleSystem' = None
    '''Evaluated particle system that this object was instanced from 

    :type: 'ParticleSystem'
    '''

    persistent_id: typing.List[int] = None
    '''Persistent identifier for inter-frame matching of objects with motion blur 

    :type: typing.List[int]
    '''

    random_id: int = None
    '''Random id for this instance, typically for randomized shading 

    :type: int
    '''

    show_particles: bool = None
    '''Particles part of the object should be visible in the render 

    :type: bool
    '''

    show_self: bool = None
    '''The object geometry itself should be visible in the render 

    :type: bool
    '''

    uv: typing.List[float] = None
    '''UV coordinates in parent object space 

    :type: typing.List[float]
    '''


class DepsgraphUpdate(bpy_struct):
    '''Information about ID that was updated '''

    id: 'ID' = None
    '''Updated datablock 

    :type: 'ID'
    '''

    is_updated_geometry: bool = None
    '''Object geometry is updated 

    :type: bool
    '''

    is_updated_transform: bool = None
    '''Object transformation is updated 

    :type: bool
    '''


class DisplaySafeAreas(bpy_struct):
    '''Safe areas used in 3D view and the sequencer '''

    action: typing.List[float] = None
    '''Safe area for general elements 

    :type: typing.List[float]
    '''

    action_center: typing.List[float] = None
    '''Safe area for general elements in a different aspect ratio 

    :type: typing.List[float]
    '''

    title: typing.List[float] = None
    '''Safe area for text and graphics 

    :type: typing.List[float]
    '''

    title_center: typing.List[float] = None
    '''Safe area for text and graphics in a different aspect ratio 

    :type: typing.List[float]
    '''


class DopeSheet(bpy_struct):
    '''Settings for filtering the channels shown in animation editors '''

    filter_collection: 'Collection' = None
    '''Collection that included object should be a member of 

    :type: 'Collection'
    '''

    filter_fcurve_name: str = None
    '''F-Curve live filtering string 

    :type: str
    '''

    filter_text: str = None
    '''Live filtering string 

    :type: str
    '''

    show_armatures: bool = None
    '''Include visualization of armature related animation data 

    :type: bool
    '''

    show_cache_files: bool = None
    '''Include visualization of cache file related animation data 

    :type: bool
    '''

    show_cameras: bool = None
    '''Include visualization of camera related animation data 

    :type: bool
    '''

    show_curves: bool = None
    '''Include visualization of curve related animation data 

    :type: bool
    '''

    show_datablock_filters: bool = None
    '''Show options for whether channels related to certain types of data are included 

    :type: bool
    '''

    show_expanded_summary: bool = None
    '''Collapse summary when shown, so all other channels get hidden (Dope Sheet editors only) 

    :type: bool
    '''

    show_gpencil: bool = None
    '''Include visualization of Grease Pencil related animation data and frames 

    :type: bool
    '''

    show_gpencil_3d_only: bool = None
    '''Only show Grease Pencil data-blocks used as part of the active scene 

    :type: bool
    '''

    show_hidden: bool = None
    '''Include channels from objects/bone that are not visible 

    :type: bool
    '''

    show_lattices: bool = None
    '''Include visualization of lattice related animation data 

    :type: bool
    '''

    show_lights: bool = None
    '''Include visualization of light related animation data 

    :type: bool
    '''

    show_linestyles: bool = None
    '''Include visualization of Line Style related Animation data 

    :type: bool
    '''

    show_materials: bool = None
    '''Include visualization of material related animation data 

    :type: bool
    '''

    show_meshes: bool = None
    '''Include visualization of mesh related animation data 

    :type: bool
    '''

    show_metaballs: bool = None
    '''Include visualization of metaball related animation data 

    :type: bool
    '''

    show_missing_nla: bool = None
    '''Include animation data-blocks with no NLA data (NLA editor only) 

    :type: bool
    '''

    show_modifiers: bool = None
    '''Include visualization of animation data related to data-blocks linked to modifiers 

    :type: bool
    '''

    show_movieclips: bool = None
    '''Include visualization of movie clip related animation data 

    :type: bool
    '''

    show_nodes: bool = None
    '''Include visualization of node related animation data 

    :type: bool
    '''

    show_only_errors: bool = None
    '''Only include F-Curves and drivers that are disabled or have errors 

    :type: bool
    '''

    show_only_selected: bool = None
    '''Only include channels relating to selected objects and data 

    :type: bool
    '''

    show_particles: bool = None
    '''Include visualization of particle related animation data 

    :type: bool
    '''

    show_scenes: bool = None
    '''Include visualization of scene related animation data 

    :type: bool
    '''

    show_shapekeys: bool = None
    '''Include visualization of shape key related animation data 

    :type: bool
    '''

    show_speakers: bool = None
    '''Include visualization of speaker related animation data 

    :type: bool
    '''

    show_summary: bool = None
    '''Display an additional ‘summary’ line (Dope Sheet editors only) 

    :type: bool
    '''

    show_textures: bool = None
    '''Include visualization of texture related animation data 

    :type: bool
    '''

    show_transforms: bool = None
    '''Include visualization of object-level animation data (mostly transforms) 

    :type: bool
    '''

    show_worlds: bool = None
    '''Include visualization of world related animation data 

    :type: bool
    '''

    source: 'ID' = None
    '''ID-Block representing source data, usually ID_SCE (i.e. Scene) 

    :type: 'ID'
    '''

    use_datablock_sort: bool = None
    '''Alphabetically sorts data-blocks - mainly objects in the scene (disable to increase viewport speed) 

    :type: bool
    '''

    use_multi_word_filter: bool = None
    '''Perform fuzzy/multi-word matching (WARNING: May be slow) 

    :type: bool
    '''


class Driver(bpy_struct):
    '''Driver for the value of a setting based on an external value '''

    expression: str = None
    '''Expression to use for Scripted Expression 

    :type: str
    '''

    is_simple_expression: bool = None
    '''The scripted expression can be evaluated without using the full python interpreter 

    :type: bool
    '''

    is_valid: bool = None
    '''Driver could not be evaluated in past, so should be skipped 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''Driver type 

    :type: typing.Union[str, int]
    '''

    use_self: bool = None
    '''Include a ‘self’ variable in the name-space, so drivers can easily reference the data being modified (object, bone, etc…) 

    :type: bool
    '''

    variables: typing.Union[typing.
                            List['DriverVariable'], 'bpy_prop_collection',
                            'ChannelDriverVariables'] = None
    '''Properties acting as inputs for this driver 

    :type: typing.Union[typing.List['DriverVariable'], 'bpy_prop_collection', 'ChannelDriverVariables']
    '''


class DriverTarget(bpy_struct):
    '''Source of input values for driver variables '''

    bone_target: str = None
    '''Name of PoseBone to use as target 

    :type: str
    '''

    data_path: str = None
    '''RNA Path (from ID-block) to property used 

    :type: str
    '''

    id: 'ID' = None
    '''ID-block that the specific property used can be found from (id_type property must be set first) 

    :type: 'ID'
    '''

    id_type: typing.Union[str, int] = None
    '''Type of ID-block that can be used 

    :type: typing.Union[str, int]
    '''

    rotation_mode: typing.Union[str, int] = None
    '''Mode for calculating rotation channel values 

    :type: typing.Union[str, int]
    '''

    transform_space: typing.Union[str, int] = None
    '''Space in which transforms are used 

    :type: typing.Union[str, int]
    '''

    transform_type: typing.Union[str, int] = None
    '''Driver variable type 

    :type: typing.Union[str, int]
    '''


class DriverVariable(bpy_struct):
    '''Variable from some source/target for driver relationship '''

    is_name_valid: bool = None
    '''Is this a valid name for a driver variable 

    :type: bool
    '''

    name: str = None
    '''Name to use in scripted expressions/functions (no spaces or dots are allowed, and must start with a letter) 

    :type: str
    '''

    targets: typing.Union[typing.
                          List['DriverTarget'], 'bpy_prop_collection'] = None
    '''Sources of input data for evaluating this variable 

    :type: typing.Union[typing.List['DriverTarget'], 'bpy_prop_collection']
    '''

    type: typing.Union[str, int] = None
    '''Driver variable type 

    :type: typing.Union[str, int]
    '''


class DynamicPaintBrushSettings(bpy_struct):
    '''Brush settings '''

    invert_proximity: bool = None
    '''Proximity falloff is applied inside the volume 

    :type: bool
    '''

    paint_alpha: float = None
    '''Paint alpha 

    :type: float
    '''

    paint_color: typing.List[float] = None
    '''Color of the paint 

    :type: typing.List[float]
    '''

    paint_distance: float = None
    '''Maximum distance from brush to mesh surface to affect paint 

    :type: float
    '''

    paint_ramp: 'ColorRamp' = None
    '''Color ramp used to define proximity falloff 

    :type: 'ColorRamp'
    '''

    paint_source: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    paint_wetness: float = None
    '''Paint wetness, visible in wetmap (some effects only affect wet paint) 

    :type: float
    '''

    particle_system: 'ParticleSystem' = None
    '''The particle system to paint with 

    :type: 'ParticleSystem'
    '''

    proximity_falloff: typing.Union[str, int] = None
    '''Proximity falloff type 

    :type: typing.Union[str, int]
    '''

    ray_direction: typing.Union[str, int] = None
    '''Ray direction to use for projection (if brush object is located in that direction it’s painted) 

    :type: typing.Union[str, int]
    '''

    smooth_radius: float = None
    '''Smooth falloff added after solid radius 

    :type: float
    '''

    smudge_strength: float = None
    '''Smudge effect strength 

    :type: float
    '''

    solid_radius: float = None
    '''Radius that will be painted solid 

    :type: float
    '''

    use_absolute_alpha: bool = None
    '''Only increase alpha value if paint alpha is higher than existing 

    :type: bool
    '''

    use_negative_volume: bool = None
    '''Negate influence inside the volume 

    :type: bool
    '''

    use_paint_erase: bool = None
    '''Erase / remove paint instead of adding it 

    :type: bool
    '''

    use_particle_radius: bool = None
    '''Use radius from particle settings 

    :type: bool
    '''

    use_proximity_project: bool = None
    '''Brush is projected to canvas from defined direction within brush proximity 

    :type: bool
    '''

    use_proximity_ramp_alpha: bool = None
    '''Only read color ramp alpha 

    :type: bool
    '''

    use_smudge: bool = None
    '''Make this brush to smudge existing paint as it moves 

    :type: bool
    '''

    use_velocity_alpha: bool = None
    '''Multiply brush influence by velocity color ramp alpha 

    :type: bool
    '''

    use_velocity_color: bool = None
    '''Replace brush color by velocity color ramp 

    :type: bool
    '''

    use_velocity_depth: bool = None
    '''Multiply brush intersection depth (displace, waves) by velocity ramp alpha 

    :type: bool
    '''

    velocity_max: float = None
    '''Velocity considered as maximum influence (Blender units per frame) 

    :type: float
    '''

    velocity_ramp: 'ColorRamp' = None
    '''Color ramp used to define brush velocity effect 

    :type: 'ColorRamp'
    '''

    wave_clamp: float = None
    '''Maximum level of surface intersection used to influence waves (use 0.0 to disable) 

    :type: float
    '''

    wave_factor: float = None
    '''Multiplier for wave influence of this brush 

    :type: float
    '''

    wave_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''


class DynamicPaintCanvasSettings(bpy_struct):
    '''Dynamic Paint canvas settings '''

    canvas_surfaces: typing.Union[typing.List['DynamicPaintSurface'],
                                  'bpy_prop_collection',
                                  'DynamicPaintSurfaces'] = None
    '''Paint surface list 

    :type: typing.Union[typing.List['DynamicPaintSurface'], 'bpy_prop_collection', 'DynamicPaintSurfaces']
    '''


class DynamicPaintSurface(bpy_struct):
    '''A canvas surface layer '''

    brush_collection: 'Collection' = None
    '''Only use brush objects from this collection 

    :type: 'Collection'
    '''

    brush_influence_scale: float = None
    '''Adjust influence brush objects have on this surface 

    :type: float
    '''

    brush_radius_scale: float = None
    '''Adjust radius of proximity brushes or particles for this surface 

    :type: float
    '''

    color_dry_threshold: float = None
    '''The wetness level when colors start to shift to the background 

    :type: float
    '''

    color_spread_speed: float = None
    '''How fast colors get mixed within wet paint 

    :type: float
    '''

    depth_clamp: float = None
    '''Maximum level of depth intersection in object space (use 0.0 to disable) 

    :type: float
    '''

    displace_factor: float = None
    '''Strength of displace when applied to the mesh 

    :type: float
    '''

    displace_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    dissolve_speed: int = None
    '''Approximately in how many frames should dissolve happen 

    :type: int
    '''

    drip_acceleration: float = None
    '''How much surface acceleration affects dripping 

    :type: float
    '''

    drip_velocity: float = None
    '''How much surface velocity affects dripping 

    :type: float
    '''

    dry_speed: int = None
    '''Approximately in how many frames should drying happen 

    :type: int
    '''

    effect_ui: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    effector_weights: 'EffectorWeights' = None
    '''

    :type: 'EffectorWeights'
    '''

    frame_end: int = None
    '''Simulation end frame 

    :type: int
    '''

    frame_start: int = None
    '''Simulation start frame 

    :type: int
    '''

    frame_substeps: int = None
    '''Do extra frames between scene frames to ensure smooth motion 

    :type: int
    '''

    image_fileformat: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    image_output_path: str = None
    '''Directory to save the textures 

    :type: str
    '''

    image_resolution: int = None
    '''Output image resolution 

    :type: int
    '''

    init_color: typing.List[float] = None
    '''Initial color of the surface 

    :type: typing.List[float]
    '''

    init_color_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    init_layername: str = None
    '''

    :type: str
    '''

    init_texture: 'Texture' = None
    '''

    :type: 'Texture'
    '''

    is_active: bool = None
    '''Toggle whether surface is processed or ignored 

    :type: bool
    '''

    is_cache_user: bool = None
    '''

    :type: bool
    '''

    name: str = None
    '''Surface name 

    :type: str
    '''

    output_name_a: str = None
    '''Name used to save output from this surface 

    :type: str
    '''

    output_name_b: str = None
    '''Name used to save output from this surface 

    :type: str
    '''

    point_cache: 'PointCache' = None
    '''

    :type: 'PointCache'
    '''

    shrink_speed: float = None
    '''How fast shrink effect moves on the canvas surface 

    :type: float
    '''

    spread_speed: float = None
    '''How fast spread effect moves on the canvas surface 

    :type: float
    '''

    surface_format: typing.Union[str, int] = None
    '''Surface Format 

    :type: typing.Union[str, int]
    '''

    surface_type: typing.Union[str, int] = None
    '''Surface Type 

    :type: typing.Union[str, int]
    '''

    use_antialiasing: bool = None
    '''Use 5x multisampling to smooth paint edges 

    :type: bool
    '''

    use_dissolve: bool = None
    '''Enable to make surface changes disappear over time 

    :type: bool
    '''

    use_dissolve_log: bool = None
    '''Use logarithmic dissolve (makes high values to fade faster than low values) 

    :type: bool
    '''

    use_drip: bool = None
    '''Process drip effect (drip wet paint to gravity direction) 

    :type: bool
    '''

    use_dry_log: bool = None
    '''Use logarithmic drying (makes high values to dry faster than low values) 

    :type: bool
    '''

    use_drying: bool = None
    '''Enable to make surface wetness dry over time 

    :type: bool
    '''

    use_incremental_displace: bool = None
    '''New displace is added cumulatively on top of existing 

    :type: bool
    '''

    use_output_a: bool = None
    '''Save this output layer 

    :type: bool
    '''

    use_output_b: bool = None
    '''Save this output layer 

    :type: bool
    '''

    use_premultiply: bool = None
    '''Multiply color by alpha (recommended for Blender input) 

    :type: bool
    '''

    use_shrink: bool = None
    '''Process shrink effect (shrink paint areas) 

    :type: bool
    '''

    use_spread: bool = None
    '''Process spread effect (spread wet paint around surface) 

    :type: bool
    '''

    use_wave_open_border: bool = None
    '''Pass waves through mesh edges 

    :type: bool
    '''

    uv_layer: str = None
    '''UV map name 

    :type: str
    '''

    wave_damping: float = None
    '''Wave damping factor 

    :type: float
    '''

    wave_smoothness: float = None
    '''Limit maximum steepness of wave slope between simulation points (use higher values for smoother waves at expense of reduced detail) 

    :type: float
    '''

    wave_speed: float = None
    '''Wave propagation speed 

    :type: float
    '''

    wave_spring: float = None
    '''Spring force that pulls water level back to zero 

    :type: float
    '''

    wave_timescale: float = None
    '''Wave time scaling factor 

    :type: float
    '''

    def output_exists(self, object, index: int) -> bool:
        '''Checks if surface output layer of given name exists 

        :param index: Index 
        :type index: int
        :rtype: bool
        '''
        pass


class DynamicPaintSurfaces(bpy_struct):
    '''Collection of Dynamic Paint Canvas surfaces '''

    active: 'DynamicPaintSurface' = None
    '''Active Dynamic Paint surface being displayed 

    :type: 'DynamicPaintSurface'
    '''

    active_index: int = None
    '''

    :type: int
    '''


class EditBone(bpy_struct):
    '''Editmode bone in an Armature data-block '''

    bbone_curveinx: float = None
    '''X-axis handle offset for start of the B-Bone’s curve, adjusts curvature 

    :type: float
    '''

    bbone_curveiny: float = None
    '''Y-axis handle offset for start of the B-Bone’s curve, adjusts curvature 

    :type: float
    '''

    bbone_curveoutx: float = None
    '''X-axis handle offset for end of the B-Bone’s curve, adjusts curvature 

    :type: float
    '''

    bbone_curveouty: float = None
    '''Y-axis handle offset for end of the B-Bone’s curve, adjusts curvature 

    :type: float
    '''

    bbone_custom_handle_end: 'EditBone' = None
    '''Bone that serves as the end handle for the B-Bone curve 

    :type: 'EditBone'
    '''

    bbone_custom_handle_start: 'EditBone' = None
    '''Bone that serves as the start handle for the B-Bone curve 

    :type: 'EditBone'
    '''

    bbone_easein: float = None
    '''Length of first Bezier Handle (for B-Bones only) 

    :type: float
    '''

    bbone_easeout: float = None
    '''Length of second Bezier Handle (for B-Bones only) 

    :type: float
    '''

    bbone_handle_type_end: typing.Union[str, int] = None
    '''Selects how the end handle of the B-Bone is computed 

    :type: typing.Union[str, int]
    '''

    bbone_handle_type_start: typing.Union[str, int] = None
    '''Selects how the start handle of the B-Bone is computed 

    :type: typing.Union[str, int]
    '''

    bbone_rollin: float = None
    '''Roll offset for the start of the B-Bone, adjusts twist 

    :type: float
    '''

    bbone_rollout: float = None
    '''Roll offset for the end of the B-Bone, adjusts twist 

    :type: float
    '''

    bbone_scaleinx: float = None
    '''X-axis scale factor for start of the B-Bone, adjusts thickness (for tapering effects) 

    :type: float
    '''

    bbone_scaleiny: float = None
    '''Y-axis scale factor for start of the B-Bone, adjusts thickness (for tapering effects) 

    :type: float
    '''

    bbone_scaleoutx: float = None
    '''X-axis scale factor for end of the B-Bone, adjusts thickness (for tapering effects) 

    :type: float
    '''

    bbone_scaleouty: float = None
    '''Y-axis scale factor for end of the B-Bone, adjusts thickness (for tapering effects) 

    :type: float
    '''

    bbone_segments: int = None
    '''Number of subdivisions of bone (for B-Bones only) 

    :type: int
    '''

    bbone_x: float = None
    '''B-Bone X size 

    :type: float
    '''

    bbone_z: float = None
    '''B-Bone Z size 

    :type: float
    '''

    envelope_distance: float = None
    '''Bone deformation distance (for Envelope deform only) 

    :type: float
    '''

    envelope_weight: float = None
    '''Bone deformation weight (for Envelope deform only) 

    :type: float
    '''

    head: typing.List[float] = None
    '''Location of head end of the bone 

    :type: typing.List[float]
    '''

    head_radius: float = None
    '''Radius of head of bone (for Envelope deform only) 

    :type: float
    '''

    hide: bool = None
    '''Bone is not visible when in Edit Mode 

    :type: bool
    '''

    hide_select: bool = None
    '''Bone is able to be selected 

    :type: bool
    '''

    inherit_scale: typing.Union[str, int] = None
    '''Specifies how the bone inherits scaling from the parent bone 

    :type: typing.Union[str, int]
    '''

    layers: typing.List[bool] = None
    '''Layers bone exists in 

    :type: typing.List[bool]
    '''

    length: float = None
    '''Length of the bone. Changing moves the tail end 

    :type: float
    '''

    lock: bool = None
    '''Bone is not able to be transformed when in Edit Mode 

    :type: bool
    '''

    matrix: typing.List[float] = None
    '''Matrix combining loc/rot of the bone (head position, direction and roll), in armature space (WARNING: does not include/support bone’s length/size) 

    :type: typing.List[float]
    '''

    name: str = None
    '''

    :type: str
    '''

    parent: 'EditBone' = None
    '''Parent edit bone (in same Armature) 

    :type: 'EditBone'
    '''

    roll: float = None
    '''Bone rotation around head-tail axis 

    :type: float
    '''

    select: bool = None
    '''

    :type: bool
    '''

    select_head: bool = None
    '''

    :type: bool
    '''

    select_tail: bool = None
    '''

    :type: bool
    '''

    show_wire: bool = None
    '''Bone is always drawn as Wireframe regardless of viewport draw mode (useful for non-obstructive custom bone shapes) 

    :type: bool
    '''

    tail: typing.List[float] = None
    '''Location of tail end of the bone 

    :type: typing.List[float]
    '''

    tail_radius: float = None
    '''Radius of tail of bone (for Envelope deform only) 

    :type: float
    '''

    use_connect: bool = None
    '''When bone has a parent, bone’s head is stuck to the parent’s tail 

    :type: bool
    '''

    use_cyclic_offset: bool = None
    '''When bone doesn’t have a parent, it receives cyclic offset effects (Deprecated) 

    :type: bool
    '''

    use_deform: bool = None
    '''Enable Bone to deform geometry 

    :type: bool
    '''

    use_endroll_as_inroll: bool = None
    '''Add Roll Out of the Start Handle bone to the Roll In value 

    :type: bool
    '''

    use_envelope_multiply: bool = None
    '''When deforming bone, multiply effects of Vertex Group weights with Envelope influence 

    :type: bool
    '''

    use_inherit_rotation: bool = None
    '''Bone inherits rotation or scale from parent bone 

    :type: bool
    '''

    use_inherit_scale: bool = None
    '''DEPRECATED: Bone inherits scaling from parent bone 

    :type: bool
    '''

    use_local_location: bool = None
    '''Bone location is set in local space 

    :type: bool
    '''

    use_relative_parent: bool = None
    '''Object children will use relative transform, like deform 

    :type: bool
    '''

    basename = None
    '''The name of this bone before any ‘.’ character (readonly) '''

    center = None
    '''The midpoint between the head and the tail. (readonly) '''

    children = None
    '''A list of all the bones children. Warning: takes O(len(bones)) time. (readonly) '''

    children_recursive = None
    '''A list of all children from this bone. Warning: takes O(len(bones)**2) time. (readonly) '''

    children_recursive_basename = None
    '''Returns a chain of children with the same base name as this bone. Only direct chains are supported, forks caused by multiple children with matching base names will terminate the function and not be returned. Warning: takes O(len(bones)**2) time. (readonly) '''

    parent_recursive = None
    '''A list of parents, starting with the immediate parent (readonly) '''

    vector = None
    '''The direction this bone is pointing. Utility function for (tail - head) (readonly) '''

    x_axis = None
    '''Vector pointing down the x-axis of the bone. (readonly) '''

    y_axis = None
    '''Vector pointing down the y-axis of the bone. (readonly) '''

    z_axis = None
    '''Vector pointing down the z-axis of the bone. (readonly) '''

    def align_roll(self, vector: typing.List[float]):
        '''Align the bone to a localspace roll so the Z axis points in the direction of the vector given 

        :param vector: Vector 
        :type vector: typing.List[float]
        '''
        pass

    def align_orientation(self, other):
        '''Align this bone to another by moving its tail and settings its roll the length of the other bone is not used. 

        '''
        pass

    def parent_index(self, parent_test):
        '''The same as ‘bone in other_bone.parent_recursive’ but saved generating a list. 

        '''
        pass

    def transform(self,
                  matrix: 'mathutils.Matrix',
                  scale: bool = True,
                  roll: bool = True):
        '''Transform the the bones head, tail, roll and envelope (when the matrix has a scale component). 

        :param matrix: 3x3 or 4x4 transformation matrix. 
        :type matrix: 'mathutils.Matrix'
        :param scale: Scale the bone envelope by the matrix. 
        :type scale: bool
        :param roll: Correct the roll to point in the same relative direction to the head and tail. 
        :type roll: bool
        '''
        pass

    def translate(self, vec):
        '''Utility function to add vec to the head and tail of this bone 

        '''
        pass


class EffectorWeights(bpy_struct):
    '''Effector weights for physics simulation '''

    all: float = None
    '''All effector’s weight 

    :type: float
    '''

    apply_to_hair_growing: bool = None
    '''Use force fields when growing hair 

    :type: bool
    '''

    boid: float = None
    '''Boid effector weight 

    :type: float
    '''

    charge: float = None
    '''Charge effector weight 

    :type: float
    '''

    collection: 'Collection' = None
    '''Limit effectors to this collection 

    :type: 'Collection'
    '''

    curve_guide: float = None
    '''Curve guide effector weight 

    :type: float
    '''

    drag: float = None
    '''Drag effector weight 

    :type: float
    '''

    force: float = None
    '''Force effector weight 

    :type: float
    '''

    gravity: float = None
    '''Global gravity weight 

    :type: float
    '''

    harmonic: float = None
    '''Harmonic effector weight 

    :type: float
    '''

    lennardjones: float = None
    '''Lennard-Jones effector weight 

    :type: float
    '''

    magnetic: float = None
    '''Magnetic effector weight 

    :type: float
    '''

    smokeflow: float = None
    '''Smoke Flow effector weight 

    :type: float
    '''

    texture: float = None
    '''Texture effector weight 

    :type: float
    '''

    turbulence: float = None
    '''Turbulence effector weight 

    :type: float
    '''

    vortex: float = None
    '''Vortex effector weight 

    :type: float
    '''

    wind: float = None
    '''Wind effector weight 

    :type: float
    '''


class EnumPropertyItem(bpy_struct):
    '''Definition of a choice in an RNA enum property '''

    description: str = None
    '''Description of the item’s purpose 

    :type: str
    '''

    icon: typing.Union[str, int] = None
    '''Icon of the item 

    :type: typing.Union[str, int]
    '''

    identifier: str = None
    '''Unique name used in the code and scripting 

    :type: str
    '''

    name: str = None
    '''Human readable name 

    :type: str
    '''

    value: int = None
    '''Value of the item 

    :type: int
    '''


class Event(bpy_struct):
    '''Window Manager Event '''

    alt: bool = None
    '''True when the Alt/Option key is held 

    :type: bool
    '''

    ascii: str = None
    '''Single ASCII character for this event 

    :type: str
    '''

    ctrl: bool = None
    '''True when the Ctrl key is held 

    :type: bool
    '''

    is_mouse_absolute: bool = None
    '''The last motion event was an absolute input 

    :type: bool
    '''

    is_tablet: bool = None
    '''The event has tablet data 

    :type: bool
    '''

    mouse_prev_x: int = None
    '''The window relative horizontal location of the mouse 

    :type: int
    '''

    mouse_prev_y: int = None
    '''The window relative vertical location of the mouse 

    :type: int
    '''

    mouse_region_x: int = None
    '''The region relative horizontal location of the mouse 

    :type: int
    '''

    mouse_region_y: int = None
    '''The region relative vertical location of the mouse 

    :type: int
    '''

    mouse_x: int = None
    '''The window relative horizontal location of the mouse 

    :type: int
    '''

    mouse_y: int = None
    '''The window relative vertical location of the mouse 

    :type: int
    '''

    oskey: bool = None
    '''True when the Cmd key is held 

    :type: bool
    '''

    pressure: float = None
    '''The pressure of the tablet or 1.0 if no tablet present 

    :type: float
    '''

    shift: bool = None
    '''True when the Shift key is held 

    :type: bool
    '''

    tilt: typing.List[float] = None
    '''The pressure of the tablet or zeroes if no tablet present 

    :type: typing.List[float]
    '''

    type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    unicode: str = None
    '''Single unicode character for this event 

    :type: str
    '''

    value: typing.Union[str, int] = None
    '''The type of event, only applies to some 

    :type: typing.Union[str, int]
    '''


class FCurve(bpy_struct):
    '''F-Curve defining values of a period of time '''

    array_index: int = None
    '''Index to the specific property affected by F-Curve if applicable 

    :type: int
    '''

    auto_smoothing: typing.Union[str, int] = None
    '''Algorithm used to compute automatic handles 

    :type: typing.Union[str, int]
    '''

    color: typing.List[float] = None
    '''Color of the F-Curve in the Graph Editor 

    :type: typing.List[float]
    '''

    color_mode: typing.Union[str, int] = None
    '''Method used to determine color of F-Curve in Graph Editor 

    :type: typing.Union[str, int]
    '''

    data_path: str = None
    '''RNA Path to property affected by F-Curve 

    :type: str
    '''

    driver: 'Driver' = None
    '''Channel Driver (only set for Driver F-Curves) 

    :type: 'Driver'
    '''

    extrapolation: typing.Union[str, int] = None
    '''Method used for evaluating value of F-Curve outside first and last keyframes 

    :type: typing.Union[str, int]
    '''

    group: 'ActionGroup' = None
    '''Action Group that this F-Curve belongs to 

    :type: 'ActionGroup'
    '''

    hide: bool = None
    '''F-Curve and its keyframes are hidden in the Graph Editor graphs 

    :type: bool
    '''

    is_empty: bool = None
    '''True if the curve contributes no animation due to lack of keyframes or useful modifiers, and should be deleted 

    :type: bool
    '''

    is_valid: bool = None
    '''False when F-Curve could not be evaluated in past, so should be skipped when evaluating 

    :type: bool
    '''

    keyframe_points: typing.Union[typing.
                                  List['Keyframe'], 'bpy_prop_collection',
                                  'FCurveKeyframePoints'] = None
    '''User-editable keyframes 

    :type: typing.Union[typing.List['Keyframe'], 'bpy_prop_collection', 'FCurveKeyframePoints']
    '''

    lock: bool = None
    '''F-Curve’s settings cannot be edited 

    :type: bool
    '''

    modifiers: typing.Union[typing.List['FModifier'], 'bpy_prop_collection',
                            'FCurveModifiers'] = None
    '''Modifiers affecting the shape of the F-Curve 

    :type: typing.Union[typing.List['FModifier'], 'bpy_prop_collection', 'FCurveModifiers']
    '''

    mute: bool = None
    '''Disable F-Curve Modifier evaluation 

    :type: bool
    '''

    sampled_points: typing.Union[typing.List['FCurveSample'],
                                 'bpy_prop_collection'] = None
    '''Sampled animation data 

    :type: typing.Union[typing.List['FCurveSample'], 'bpy_prop_collection']
    '''

    select: bool = None
    '''F-Curve is selected for editing 

    :type: bool
    '''

    def evaluate(self, frame: float) -> float:
        '''Evaluate F-Curve 

        :param frame: Frame, Evaluate F-Curve at given frame 
        :type frame: float
        :rtype: float
        :return:  Value, Value of F-Curve specific frame 
        '''
        pass

    def update(self, ):
        '''Ensure keyframes are sorted in chronological order and handles are set correctly 

        '''
        pass

    def range(self, ) -> typing.List[float]:
        '''Get the time extents for F-Curve 

        :rtype: typing.List[float]
        :return:  Range, Min/Max values 
        '''
        pass

    def update_autoflags(self, data: 'AnyType'):
        '''Update FCurve flags set automatically from affected property (currently, integer/discrete flags set when the property is not a float) 

        :param data: Data, Data containing the property controlled by given FCurve 
        :type data: 'AnyType'
        '''
        pass

    def convert_to_samples(self, start: int, end: int):
        '''Convert current FCurve from keyframes to sample points, if necessary 

        :param start: Start Frame 
        :type start: int
        :param end: End Frame 
        :type end: int
        '''
        pass

    def convert_to_keyframes(self, start: int, end: int):
        '''Convert current FCurve from sample points to keyframes (linear interpolation), if necessary 

        :param start: Start Frame 
        :type start: int
        :param end: End Frame 
        :type end: int
        '''
        pass


class FCurveKeyframePoints(bpy_struct):
    '''Collection of keyframe points '''

    def insert(
            self,
            frame: float,
            value: float,
            options: typing.Union[typing.Set[str], typing.Set[int]] = {},
            keyframe_type: typing.Union[str, int] = 'KEYFRAME') -> 'Keyframe':
        '''Add a keyframe point to a F-Curve 

        :param frame: X Value of this keyframe point 
        :type frame: float
        :param value: Y Value of this keyframe point 
        :type value: float
        :param options: Keyframe optionsREPLACE Replace, Don’t add any new keyframes, but just replace existing ones.NEEDED Needed, Only adds keyframes that are needed.FAST Fast, Fast keyframe insertion to avoid recalculating the curve each time. 
        :type options: typing.Union[typing.Set[str], typing.Set[int]]
        :param keyframe_type: Type of keyframe to insertKEYFRAME Keyframe, Normal keyframe - e.g. for key poses.BREAKDOWN Breakdown, A breakdown pose - e.g. for transitions between key poses.MOVING_HOLD Moving Hold, A keyframe that is part of a moving hold.EXTREME Extreme, An ‘extreme’ pose, or some other purpose as needed.JITTER Jitter, A filler or baked keyframe for keying on ones, or some other purpose as needed. 
        :type keyframe_type: typing.Union[str, int]
        :rtype: 'Keyframe'
        :return:  Newly created keyframe 
        '''
        pass

    def add(self, count: int):
        '''Add a keyframe point to a F-Curve 

        :param count: Number, Number of points to add to the spline 
        :type count: int
        '''
        pass

    def remove(self, keyframe: 'Keyframe', fast: bool = False):
        '''Remove keyframe from an F-Curve 

        :param keyframe: Keyframe to remove 
        :type keyframe: 'Keyframe'
        :param fast: Fast, Fast keyframe removal to avoid recalculating the curve each time 
        :type fast: bool
        '''
        pass


class FCurveModifiers(bpy_struct):
    '''Collection of F-Curve Modifiers '''

    active: 'FModifier' = None
    '''Active F-Curve Modifier 

    :type: 'FModifier'
    '''

    def new(self, type: typing.Union[str, int]) -> 'FModifier':
        '''Add a constraint to this object 

        :param type: Constraint type to addNULL Invalid.GENERATOR Generator, Generate a curve using a factorized or expanded polynomial.FNGENERATOR Built-In Function, Generate a curve using standard math functions such as sin and cos.ENVELOPE Envelope, Reshape F-Curve values - e.g. change amplitude of movements.CYCLES Cycles, Cyclic extend/repeat keyframe sequence.NOISE Noise, Add pseudo-random noise on top of F-Curves.LIMITS Limits, Restrict maximum and minimum values of F-Curve.STEPPED Stepped Interpolation, Snap values to nearest grid-step - e.g. for a stop-motion look. 
        :type type: typing.Union[str, int]
        :rtype: 'FModifier'
        :return:  New fmodifier 
        '''
        pass

    def remove(self, modifier: 'FModifier'):
        '''Remove a modifier from this F-Curve 

        :param modifier: Removed modifier 
        :type modifier: 'FModifier'
        '''
        pass


class FCurveSample(bpy_struct):
    '''Sample point for F-Curve '''

    co: typing.List[float] = None
    '''Point coordinates 

    :type: typing.List[float]
    '''

    select: bool = None
    '''Selection status 

    :type: bool
    '''


class FFmpegSettings(bpy_struct):
    '''FFmpeg related settings for the scene '''

    audio_bitrate: int = None
    '''Audio bitrate (kb/s) 

    :type: int
    '''

    audio_channels: typing.Union[str, int] = None
    '''Audio channel count 

    :type: typing.Union[str, int]
    '''

    audio_codec: typing.Union[str, int] = None
    '''FFmpeg audio codec to use 

    :type: typing.Union[str, int]
    '''

    audio_mixrate: int = None
    '''Audio samplerate(samples/s) 

    :type: int
    '''

    audio_volume: float = None
    '''Audio volume 

    :type: float
    '''

    buffersize: int = None
    '''Rate control: buffer size (kb) 

    :type: int
    '''

    codec: typing.Union[str, int] = None
    '''FFmpeg codec to use for video output 

    :type: typing.Union[str, int]
    '''

    constant_rate_factor: typing.Union[str, int] = None
    '''Constant Rate Factor (CRF); tradeoff between video quality and file size 

    :type: typing.Union[str, int]
    '''

    ffmpeg_preset: typing.Union[str, int] = None
    '''Tradeoff between encoding speed and compression ratio 

    :type: typing.Union[str, int]
    '''

    format: typing.Union[str, int] = None
    '''Output file container 

    :type: typing.Union[str, int]
    '''

    gopsize: int = None
    '''Distance between key frames, also known as GOP size; influences file size and seekability 

    :type: int
    '''

    max_b_frames: int = None
    '''Maximum number of B-frames between non-B-frames; influences file size and seekability 

    :type: int
    '''

    maxrate: int = None
    '''Rate control: max rate (kb/s) 

    :type: int
    '''

    minrate: int = None
    '''Rate control: min rate (kb/s) 

    :type: int
    '''

    muxrate: int = None
    '''Mux rate (bits/s(!)) 

    :type: int
    '''

    packetsize: int = None
    '''Mux packet size (byte) 

    :type: int
    '''

    use_autosplit: bool = None
    '''Autosplit output at 2GB boundary 

    :type: bool
    '''

    use_lossless_output: bool = None
    '''Use lossless output for video streams 

    :type: bool
    '''

    use_max_b_frames: bool = None
    '''Set a maximum number of B-frames 

    :type: bool
    '''

    video_bitrate: int = None
    '''Video bitrate (kb/s) 

    :type: int
    '''


class FModifier(bpy_struct):
    '''Modifier for values of F-Curve '''

    active: bool = None
    '''F-Curve Modifier is the one being edited 

    :type: bool
    '''

    blend_in: float = None
    '''Number of frames from start frame for influence to take effect 

    :type: float
    '''

    blend_out: float = None
    '''Number of frames from end frame for influence to fade out 

    :type: float
    '''

    frame_end: float = None
    '''Frame that modifier’s influence ends (if Restrict Frame Range is in use) 

    :type: float
    '''

    frame_start: float = None
    '''Frame that modifier’s influence starts (if Restrict Frame Range is in use) 

    :type: float
    '''

    influence: float = None
    '''Amount of influence F-Curve Modifier will have when not fading in/out 

    :type: float
    '''

    is_valid: bool = None
    '''F-Curve Modifier has invalid settings and will not be evaluated 

    :type: bool
    '''

    mute: bool = None
    '''Disable F-Curve Modifier evaluation 

    :type: bool
    '''

    show_expanded: bool = None
    '''F-Curve Modifier’s panel is expanded in UI 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''F-Curve Modifier Type 

    :type: typing.Union[str, int]
    '''

    use_influence: bool = None
    '''F-Curve Modifier’s effects will be tempered by a default factor 

    :type: bool
    '''

    use_restricted_range: bool = None
    '''F-Curve Modifier is only applied for the specified frame range to help mask off effects in order to chain them 

    :type: bool
    '''


class FModifierEnvelopeControlPoint(bpy_struct):
    '''Control point for envelope F-Modifier '''

    frame: float = None
    '''Frame this control-point occurs on 

    :type: float
    '''

    max: float = None
    '''Upper bound of envelope at this control-point 

    :type: float
    '''

    min: float = None
    '''Lower bound of envelope at this control-point 

    :type: float
    '''


class FModifierEnvelopeControlPoints(bpy_struct):
    '''Control points defining the shape of the envelope '''

    def add(self, frame: float) -> 'FModifierEnvelopeControlPoint':
        '''Add a control point to a FModifierEnvelope 

        :param frame: Frame to add this control-point 
        :type frame: float
        :rtype: 'FModifierEnvelopeControlPoint'
        :return:  Newly created control-point 
        '''
        pass

    def remove(self, point: 'FModifierEnvelopeControlPoint'):
        '''Remove a control-point from an FModifierEnvelope 

        :param point: Control-point to remove 
        :type point: 'FModifierEnvelopeControlPoint'
        '''
        pass


class FaceMap(bpy_struct):
    '''Group of faces, each face can only be part of one map '''

    index: int = None
    '''Index number of the face map 

    :type: int
    '''

    name: str = None
    '''Face map name 

    :type: str
    '''

    select: bool = None
    '''Face-map selection state (for tools to use) 

    :type: bool
    '''

    def add(self, index: typing.List[int]):
        '''Add vertices to the group 

        :param index: Index List 
        :type index: typing.List[int]
        '''
        pass

    def remove(self, index: typing.List[int]):
        '''Remove a vertex from the group 

        :param index: Index List 
        :type index: typing.List[int]
        '''
        pass


class FaceMaps(bpy_struct):
    '''Collection of face maps '''

    active: 'FaceMap' = None
    '''Face maps of the object 

    :type: 'FaceMap'
    '''

    active_index: int = None
    '''Active index in face map array 

    :type: int
    '''

    def new(self, name: str = "Map") -> 'FaceMap':
        '''Add face map to object 

        :param name: face map name 
        :type name: str
        :rtype: 'FaceMap'
        :return:  New face map 
        '''
        pass

    def remove(self, group: 'FaceMap'):
        '''Delete vertex group from object 

        :param group: Face map to remove 
        :type group: 'FaceMap'
        '''
        pass

    def clear(self, ):
        '''Delete all vertex groups from object 

        '''
        pass


class FieldSettings(bpy_struct):
    '''Field settings for an object in physics simulation '''

    apply_to_location: bool = None
    '''Affect particle’s location 

    :type: bool
    '''

    apply_to_rotation: bool = None
    '''Affect particle’s dynamic rotation 

    :type: bool
    '''

    distance_max: float = None
    '''Maximum distance for the field to work 

    :type: float
    '''

    distance_min: float = None
    '''Minimum distance for the field’s fall-off 

    :type: float
    '''

    falloff_power: float = None
    '''How quickly strength falls off with distance from the force field 

    :type: float
    '''

    falloff_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    flow: float = None
    '''Convert effector force into air flow velocity 

    :type: float
    '''

    guide_clump_amount: float = None
    '''Amount of clumping 

    :type: float
    '''

    guide_clump_shape: float = None
    '''Shape of clumping 

    :type: float
    '''

    guide_free: float = None
    '''Guide-free time from particle life’s end 

    :type: float
    '''

    guide_kink_amplitude: float = None
    '''The amplitude of the offset 

    :type: float
    '''

    guide_kink_axis: typing.Union[str, int] = None
    '''Which axis to use for offset 

    :type: typing.Union[str, int]
    '''

    guide_kink_frequency: float = None
    '''The frequency of the offset (1/total length) 

    :type: float
    '''

    guide_kink_shape: float = None
    '''Adjust the offset to the beginning/end 

    :type: float
    '''

    guide_kink_type: typing.Union[str, int] = None
    '''Type of periodic offset on the curve 

    :type: typing.Union[str, int]
    '''

    guide_minimum: float = None
    '''The distance from which particles are affected fully 

    :type: float
    '''

    harmonic_damping: float = None
    '''Damping of the harmonic force 

    :type: float
    '''

    inflow: float = None
    '''Inwards component of the vortex force 

    :type: float
    '''

    linear_drag: float = None
    '''Drag component proportional to velocity 

    :type: float
    '''

    noise: float = None
    '''Amount of noise for the force strength 

    :type: float
    '''

    quadratic_drag: float = None
    '''Drag component proportional to the square of velocity 

    :type: float
    '''

    radial_falloff: float = None
    '''Radial falloff power (real gravitational falloff = 2) 

    :type: float
    '''

    radial_max: float = None
    '''Maximum radial distance for the field to work 

    :type: float
    '''

    radial_min: float = None
    '''Minimum radial distance for the field’s fall-off 

    :type: float
    '''

    rest_length: float = None
    '''Rest length of the harmonic force 

    :type: float
    '''

    seed: int = None
    '''Seed of the noise 

    :type: int
    '''

    shape: typing.Union[str, int] = None
    '''Which direction is used to calculate the effector force 

    :type: typing.Union[str, int]
    '''

    size: float = None
    '''Size of the turbulence 

    :type: float
    '''

    source_object: 'Object' = None
    '''Select domain object of the smoke simulation 

    :type: 'Object'
    '''

    strength: float = None
    '''Strength of force field 

    :type: float
    '''

    texture: 'Texture' = None
    '''Texture to use as force 

    :type: 'Texture'
    '''

    texture_mode: typing.Union[str, int] = None
    '''How the texture effect is calculated (RGB & Curl need a RGB texture, else Gradient will be used instead) 

    :type: typing.Union[str, int]
    '''

    texture_nabla: float = None
    '''Defines size of derivative offset used for calculating gradient and curl 

    :type: float
    '''

    type: typing.Union[str, int] = None
    '''Type of field 

    :type: typing.Union[str, int]
    '''

    use_2d_force: bool = None
    '''Apply force only in 2D 

    :type: bool
    '''

    use_absorption: bool = None
    '''Force gets absorbed by collision objects 

    :type: bool
    '''

    use_global_coords: bool = None
    '''Use effector/global coordinates for turbulence 

    :type: bool
    '''

    use_gravity_falloff: bool = None
    '''Multiply force by 1/distance² 

    :type: bool
    '''

    use_guide_path_add: bool = None
    '''Based on distance/falloff it adds a portion of the entire path 

    :type: bool
    '''

    use_guide_path_weight: bool = None
    '''Use curve weights to influence the particle influence along the curve 

    :type: bool
    '''

    use_max_distance: bool = None
    '''Use a maximum distance for the field to work 

    :type: bool
    '''

    use_min_distance: bool = None
    '''Use a minimum distance for the field’s fall-off 

    :type: bool
    '''

    use_multiple_springs: bool = None
    '''Every point is effected by multiple springs 

    :type: bool
    '''

    use_object_coords: bool = None
    '''Use object/global coordinates for texture 

    :type: bool
    '''

    use_radial_max: bool = None
    '''Use a maximum radial distance for the field to work 

    :type: bool
    '''

    use_radial_min: bool = None
    '''Use a minimum radial distance for the field’s fall-off 

    :type: bool
    '''

    use_root_coords: bool = None
    '''Texture coordinates from root particle locations 

    :type: bool
    '''

    use_smoke_density: bool = None
    '''Adjust force strength based on smoke density 

    :type: bool
    '''

    z_direction: typing.Union[str, int] = None
    '''Effect in full or only positive/negative Z direction 

    :type: typing.Union[str, int]
    '''


class FileBrowserFSMenuEntry(bpy_struct):
    '''File Select Parameters '''

    icon: int = None
    '''

    :type: int
    '''

    is_valid: bool = None
    '''Whether this path is currently reachable 

    :type: bool
    '''

    name: str = None
    '''

    :type: str
    '''

    path: str = None
    '''

    :type: str
    '''

    use_save: bool = None
    '''Whether this path is saved in bookmarks, or generated from OS 

    :type: bool
    '''


class FileSelectParams(bpy_struct):
    '''File Select Parameters '''

    directory: str = None
    '''Directory displayed in the file browser 

    :type: str
    '''

    display_size: typing.Union[str, int] = None
    '''Change the size of the display (width of columns or thumbnails size) 

    :type: typing.Union[str, int]
    '''

    display_type: typing.Union[str, int] = None
    '''Display mode for the file list 

    :type: typing.Union[str, int]
    '''

    filename: str = None
    '''Active file in the file browser 

    :type: str
    '''

    filter_glob: str = None
    '''UNIX shell-like filename patterns matching, supports wildcards (‘*’) and list of patterns separated by ‘;’ 

    :type: str
    '''

    filter_id: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Which ID types to show/hide, when browsing a library 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    filter_id_category: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Which ID categories to show/hide, when browsing a library 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    filter_search: str = None
    '''Filter by name, supports ‘*’ wildcard 

    :type: str
    '''

    recursion_level: typing.Union[str, int] = None
    '''Numbers of dirtree levels to show simultaneously 

    :type: typing.Union[str, int]
    '''

    show_details_datetime: bool = None
    '''Draw a column listing the date and time of modification for each file 

    :type: bool
    '''

    show_details_size: bool = None
    '''Draw a column listing the size of each file 

    :type: bool
    '''

    show_hidden: bool = None
    '''Show hidden dot files 

    :type: bool
    '''

    sort_method: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    title: str = None
    '''Title for the file browser 

    :type: str
    '''

    use_filter: bool = None
    '''Enable filtering of files 

    :type: bool
    '''

    use_filter_backup: bool = None
    '''Show .blend1, .blend2, etc. files 

    :type: bool
    '''

    use_filter_blender: bool = None
    '''Show .blend files 

    :type: bool
    '''

    use_filter_blendid: bool = None
    '''Show .blend files items (objects, materials, etc.) 

    :type: bool
    '''

    use_filter_folder: bool = None
    '''Show folders 

    :type: bool
    '''

    use_filter_font: bool = None
    '''Show font files 

    :type: bool
    '''

    use_filter_image: bool = None
    '''Show image files 

    :type: bool
    '''

    use_filter_movie: bool = None
    '''Show movie files 

    :type: bool
    '''

    use_filter_script: bool = None
    '''Show script files 

    :type: bool
    '''

    use_filter_sound: bool = None
    '''Show sound files 

    :type: bool
    '''

    use_filter_text: bool = None
    '''Show text files 

    :type: bool
    '''

    use_library_browsing: bool = None
    '''Whether we may browse blender files’ content or not 

    :type: bool
    '''

    use_sort_invert: bool = None
    '''Sort items descending, from highest value to lowest 

    :type: bool
    '''


class FluidDomainSettings(bpy_struct):
    '''Fluid domain settings '''

    adapt_margin: int = None
    '''Margin added around fluid to minimize boundary interference 

    :type: int
    '''

    adapt_threshold: float = None
    '''Maximum amount of fluid cell can contain before it is considered empty 

    :type: float
    '''

    additional_res: int = None
    '''Maximum number of additional cells 

    :type: int
    '''

    alpha: float = None
    '''Buoyant force based on smoke density (higher value results in faster rising smoke) 

    :type: float
    '''

    axis_slice_method: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    beta: float = None
    '''Buoyant force based on smoke heat (higher value results in faster rising smoke) 

    :type: float
    '''

    burning_rate: float = None
    '''Speed of the burning reaction (higher value results in smaller flames) 

    :type: float
    '''

    cache_data_format: typing.Union[str, int] = None
    '''Select the file format to be used for caching volumetric data 

    :type: typing.Union[str, int]
    '''

    cache_directory: str = None
    '''Directory that contains fluid cache files 

    :type: str
    '''

    cache_frame_end: int = None
    '''Frame on which the simulation stops 

    :type: int
    '''

    cache_frame_pause_data: int = None
    '''

    :type: int
    '''

    cache_frame_pause_guide: int = None
    '''

    :type: int
    '''

    cache_frame_pause_mesh: int = None
    '''

    :type: int
    '''

    cache_frame_pause_noise: int = None
    '''

    :type: int
    '''

    cache_frame_pause_particles: int = None
    '''

    :type: int
    '''

    cache_frame_start: int = None
    '''Frame on which the simulation starts 

    :type: int
    '''

    cache_mesh_format: typing.Union[str, int] = None
    '''Select the file format to be used for caching surface data 

    :type: typing.Union[str, int]
    '''

    cache_noise_format: typing.Union[str, int] = None
    '''Select the file format to be used for caching noise data 

    :type: typing.Union[str, int]
    '''

    cache_particle_format: typing.Union[str, int] = None
    '''Select the file format to be used for caching particle data 

    :type: typing.Union[str, int]
    '''

    cache_type: typing.Union[str, int] = None
    '''Change the cache type of the simulation 

    :type: typing.Union[str, int]
    '''

    cell_size: typing.List[float] = None
    '''Cell Size 

    :type: typing.List[float]
    '''

    cfl_condition: float = None
    '''Maximal velocity per cell (higher value results in greater timesteps) 

    :type: float
    '''

    clipping: float = None
    '''Value under which voxels are considered empty space to optimize caching and rendering 

    :type: float
    '''

    coba_field: typing.Union[str, int] = None
    '''Simulation field to color map 

    :type: typing.Union[str, int]
    '''

    color_grid: typing.List[float] = None
    '''Smoke color grid 

    :type: typing.List[float]
    '''

    color_ramp: 'ColorRamp' = None
    '''

    :type: 'ColorRamp'
    '''

    data_depth: typing.Union[str, int] = None
    '''Bit depth for writing all scalar (including vector) lower values reduce file size 

    :type: typing.Union[str, int]
    '''

    density_grid: typing.List[float] = None
    '''Smoke density grid 

    :type: typing.List[float]
    '''

    display_interpolation: typing.Union[str, int] = None
    '''Interpolation method to use for smoke/fire volumes in solid mode 

    :type: typing.Union[str, int]
    '''

    display_thickness: float = None
    '''Thickness of smoke drawing in the viewport 

    :type: float
    '''

    dissolve_speed: int = None
    '''Determine how quickly the smoke dissolves (higher value makes smoke disappear faster) 

    :type: int
    '''

    domain_resolution: typing.List[int] = None
    '''Smoke Grid Resolution 

    :type: typing.List[int]
    '''

    domain_size: float = None
    '''Domain size in meters (longest domain side) 

    :type: float
    '''

    domain_type: typing.Union[str, int] = None
    '''Change domain type of the simulation 

    :type: typing.Union[str, int]
    '''

    effector_group: 'Collection' = None
    '''Limit effectors to this collection 

    :type: 'Collection'
    '''

    effector_weights: 'EffectorWeights' = None
    '''

    :type: 'EffectorWeights'
    '''

    export_manta_script: bool = None
    '''Generate and export Fluidflow script from current domain settings during bake. This is only needed if you plan to analyse the cache (e.g. view grids, velocity vectors, particles) in Fluidflow directly (outside of Blender) after baking the simulation 

    :type: bool
    '''

    flame_grid: typing.List[float] = None
    '''Smoke flame grid 

    :type: typing.List[float]
    '''

    flame_ignition: float = None
    '''Minimum temperature of the flames (higher value results in faster rising flames) 

    :type: float
    '''

    flame_max_temp: float = None
    '''Maximum temperature of the flames (higher value results in faster rising flames) 

    :type: float
    '''

    flame_smoke: float = None
    '''Amount of smoke created by burning fuel 

    :type: float
    '''

    flame_smoke_color: typing.List[float] = None
    '''Color of smoke emitted from burning fuel 

    :type: typing.List[float]
    '''

    flame_vorticity: float = None
    '''Additional vorticity for the flames 

    :type: float
    '''

    flip_ratio: float = None
    '''PIC/FLIP Ratio. A value of 1.0 will result in a completely FLIP based simulation. Use a lower value for simulations which should produce smaller splashes 

    :type: float
    '''

    fluid_group: 'Collection' = None
    '''Limit fluid objects to this collection 

    :type: 'Collection'
    '''

    force_collection: 'Collection' = None
    '''Limit forces to this collection 

    :type: 'Collection'
    '''

    fractions_threshold: float = None
    '''Determines how much fluid is allowed in an obstacle cell (higher values will tag a boundary cell as an obstacle easier and reduce the boundary smoothening effect) 

    :type: float
    '''

    gravity: typing.List[float] = None
    '''Gravity in X, Y and Z direction 

    :type: typing.List[float]
    '''

    guide_alpha: float = None
    '''Guiding weight (higher value results in greater lag) 

    :type: float
    '''

    guide_beta: int = None
    '''Guiding size (higher value results in larger vortices) 

    :type: int
    '''

    guide_parent: 'Object' = None
    '''Use velocities from this object for the guiding effect (object needs to have fluid modifier and be of type domain)) 

    :type: 'Object'
    '''

    guide_source: typing.Union[str, int] = None
    '''Choose where to get guiding velocities from 

    :type: typing.Union[str, int]
    '''

    guide_vel_factor: float = None
    '''Guiding velocity factor (higher value results in greater guiding velocities) 

    :type: float
    '''

    has_cache_baked_any: bool = None
    '''

    :type: bool
    '''

    has_cache_baked_data: bool = None
    '''

    :type: bool
    '''

    has_cache_baked_guide: bool = None
    '''

    :type: bool
    '''

    has_cache_baked_mesh: bool = None
    '''

    :type: bool
    '''

    has_cache_baked_noise: bool = None
    '''

    :type: bool
    '''

    has_cache_baked_particles: bool = None
    '''

    :type: bool
    '''

    heat_grid: typing.List[float] = None
    '''Smoke heat grid 

    :type: typing.List[float]
    '''

    highres_sampling: typing.Union[str, int] = None
    '''Method for sampling the high resolution flow 

    :type: typing.Union[str, int]
    '''

    is_cache_baking_any: bool = None
    '''

    :type: bool
    '''

    is_cache_baking_data: bool = None
    '''

    :type: bool
    '''

    is_cache_baking_guide: bool = None
    '''

    :type: bool
    '''

    is_cache_baking_mesh: bool = None
    '''

    :type: bool
    '''

    is_cache_baking_noise: bool = None
    '''

    :type: bool
    '''

    is_cache_baking_particles: bool = None
    '''

    :type: bool
    '''

    mesh_concave_lower: float = None
    '''Lower mesh concavity bound (high values tend to smoothen and fill out concave regions) 

    :type: float
    '''

    mesh_concave_upper: float = None
    '''Upper mesh concavity bound (high values tend to smoothen and fill out concave regions) 

    :type: float
    '''

    mesh_generator: typing.Union[str, int] = None
    '''Which particle levelset generator to use 

    :type: typing.Union[str, int]
    '''

    mesh_particle_radius: float = None
    '''Particle radius factor (higher value results in larger (meshed) particles). Needs to be adjusted after changing the mesh scale 

    :type: float
    '''

    mesh_scale: int = None
    '''The mesh simulation is scaled up by this factor (compared to the base resolution of the domain). For best meshing, it is recommended to adjust the mesh particle radius alongside this value 

    :type: int
    '''

    mesh_smoothen_neg: int = None
    '''Negative mesh smoothening 

    :type: int
    '''

    mesh_smoothen_pos: int = None
    '''Positive mesh smoothening 

    :type: int
    '''

    mesh_vertices: typing.Union[typing.List['FluidDomainVertexVelocity'],
                                'bpy_prop_collection'] = None
    '''Vertices of the fluid mesh generated by simulation 

    :type: typing.Union[typing.List['FluidDomainVertexVelocity'], 'bpy_prop_collection']
    '''

    noise_pos_scale: float = None
    '''Scale of noise (higher value results in larger vortices) 

    :type: float
    '''

    noise_scale: int = None
    '''The noise simulation is scaled up by this factor (compared to the base resolution of the domain) 

    :type: int
    '''

    noise_strength: float = None
    '''Strength of noise 

    :type: float
    '''

    noise_time_anim: float = None
    '''Animation time of noise 

    :type: float
    '''

    noise_type: typing.Union[str, int] = None
    '''Noise method which is used during the high-res simulation 

    :type: typing.Union[str, int]
    '''

    openvdb_cache_compress_type: typing.Union[str, int] = None
    '''Compression method to be used 

    :type: typing.Union[str, int]
    '''

    particle_band_width: float = None
    '''Particle (narrow) band width (higher value results in thicker band and more particles) 

    :type: float
    '''

    particle_max: int = None
    '''Maximum number of particles per cell (ensures that each cell has at most this amount of particles) 

    :type: int
    '''

    particle_min: int = None
    '''Minimum number of particles per cell (ensures that each cell has at least this amount of particles) 

    :type: int
    '''

    particle_number: int = None
    '''Particle number factor (higher value results in more particles) 

    :type: int
    '''

    particle_radius: float = None
    '''Particle radius factor. Increase this value if the simulation appears to leak volume, decrease it if the simulation seems to gain volume 

    :type: float
    '''

    particle_randomness: float = None
    '''Randomness factor for particle sampling 

    :type: float
    '''

    particle_scale: int = None
    '''The particle simulation is scaled up by this factor (compared to the base resolution of the domain) 

    :type: int
    '''

    point_cache: 'PointCache' = None
    '''

    :type: 'PointCache'
    '''

    point_cache_compress_type: typing.Union[str, int] = None
    '''Compression method to be used 

    :type: typing.Union[str, int]
    '''

    resolution_max: int = None
    '''Resolution used for the fluid domain. Value corresponds to the longest domain side (resolution for other domain sides is calculated automatically) 

    :type: int
    '''

    show_velocity: bool = None
    '''Toggle visualization of the velocity field as needles 

    :type: bool
    '''

    simulation_method: typing.Union[str, int] = None
    '''Change the underlying simulation method 

    :type: typing.Union[str, int]
    '''

    slice_axis: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    slice_depth: float = None
    '''Position of the slice 

    :type: float
    '''

    slice_method: typing.Union[str, int] = None
    '''How to slice the volume for viewport rendering 

    :type: typing.Union[str, int]
    '''

    slice_per_voxel: float = None
    '''How many slices per voxel should be generated 

    :type: float
    '''

    sndparticle_boundary: typing.Union[str, int] = None
    '''How particles that left the domain are treated 

    :type: typing.Union[str, int]
    '''

    sndparticle_combined_export: typing.Union[str, int] = None
    '''Determines which particle systems are created from secondary particles 

    :type: typing.Union[str, int]
    '''

    sndparticle_k_b: float = None
    '''Amount of buoyancy force that rises bubbles (high value results in bubble movement mainly upwards) 

    :type: float
    '''

    sndparticle_k_d: float = None
    '''Amount of drag force that moves bubbles along with the fluid (high value results in bubble movement mainly along with the fluid) 

    :type: float
    '''

    sndparticle_k_ta: int = None
    '''Maximum number of particles generated per trapped air cell per frame 

    :type: int
    '''

    sndparticle_k_wc: int = None
    '''Maximum number of particles generated per wave crest cell per frame 

    :type: int
    '''

    sndparticle_l_max: float = None
    '''Highest possible particle lifetime 

    :type: float
    '''

    sndparticle_l_min: float = None
    '''Lowest possible particle lifetime 

    :type: float
    '''

    sndparticle_potential_radius: int = None
    '''Radius to compute potential for each cell (higher values are slower but create smoother potential grids) 

    :type: int
    '''

    sndparticle_tau_max_k: float = None
    '''Upper clamping threshold that indicates the fluid speed where cells no longer emit more particles (higher value results in generally less particles) 

    :type: float
    '''

    sndparticle_tau_max_ta: float = None
    '''Upper clamping threshold for marking fluid cells where air is trapped (highe value results in less marked cells) 

    :type: float
    '''

    sndparticle_tau_max_wc: float = None
    '''Upper clamping threshold for marking fluid cells as wave crests (higher value results in less marked cells) 

    :type: float
    '''

    sndparticle_tau_min_k: float = None
    '''Lower clamping threshold that indicates the fluid speed where cells start to emit particles (lower values result in generally more particles) 

    :type: float
    '''

    sndparticle_tau_min_ta: float = None
    '''Lower clamping threshold for marking fluid cells where air is trapped (lower value results in more marked cells) 

    :type: float
    '''

    sndparticle_tau_min_wc: float = None
    '''Lower clamping threshold for marking fluid cells as wave crests (lower value results in more marked cells) 

    :type: float
    '''

    sndparticle_update_radius: int = None
    '''Radius to compute position update for each particle (higher values are slower but particles move less chaotic) 

    :type: int
    '''

    start_point: typing.List[float] = None
    '''Start point 

    :type: typing.List[float]
    '''

    surface_tension: float = None
    '''Surface tension of liquid (higher value results in greater hydrophobic behaviour) 

    :type: float
    '''

    temperature_grid: typing.List[float] = None
    '''Smoke temperature grid, range 0..1 represents 0..1000K 

    :type: typing.List[float]
    '''

    time_scale: float = None
    '''Adjust simulation speed 

    :type: float
    '''

    timesteps_max: int = None
    '''Maximum number of simulation steps to perform for one frame 

    :type: int
    '''

    timesteps_min: int = None
    '''Minimum number of simulation steps to perform for one frame 

    :type: int
    '''

    use_adaptive_domain: bool = None
    '''Adapt simulation resolution and size to fluid 

    :type: bool
    '''

    use_adaptive_timesteps: bool = None
    '''

    :type: bool
    '''

    use_bubble_particles: bool = None
    '''Create bubble particle system 

    :type: bool
    '''

    use_collision_border_back: bool = None
    '''Enable collisons with back domain border 

    :type: bool
    '''

    use_collision_border_bottom: bool = None
    '''Enable collisons with bottom domain border 

    :type: bool
    '''

    use_collision_border_front: bool = None
    '''Enable collisons with front domain border 

    :type: bool
    '''

    use_collision_border_left: bool = None
    '''Enable collisons with left domain border 

    :type: bool
    '''

    use_collision_border_right: bool = None
    '''Enable collisons with right domain border 

    :type: bool
    '''

    use_collision_border_top: bool = None
    '''Enable collisons with top domain border 

    :type: bool
    '''

    use_color_ramp: bool = None
    '''Render a simulation field while mapping its voxels values to the colors of a ramp 

    :type: bool
    '''

    use_dissolve_smoke: bool = None
    '''Let smoke disappear over time 

    :type: bool
    '''

    use_dissolve_smoke_log: bool = None
    '''Dissolve smoke in a logarithmic fashion. Dissolves quickly at first, but lingers longer 

    :type: bool
    '''

    use_flip_particles: bool = None
    '''Create liquid particle system 

    :type: bool
    '''

    use_foam_particles: bool = None
    '''Create foam particle system 

    :type: bool
    '''

    use_fractions: bool = None
    '''Fractional obstacles improve and smoothen the fluid-obstacle boundary 

    :type: bool
    '''

    use_guide: bool = None
    '''Enable fluid guiding 

    :type: bool
    '''

    use_mesh: bool = None
    '''Enable fluid mesh (using amplification) 

    :type: bool
    '''

    use_noise: bool = None
    '''Enable fluid noise (using amplification) 

    :type: bool
    '''

    use_speed_vectors: bool = None
    '''Caches velocities of mesh vertices. These will be used (automatically) when rendering with motion blur enabled 

    :type: bool
    '''

    use_spray_particles: bool = None
    '''Create spray particle system 

    :type: bool
    '''

    use_tracer_particles: bool = None
    '''Create tracer particle system 

    :type: bool
    '''

    vector_display_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    vector_scale: float = None
    '''Multiplier for scaling the vectors 

    :type: float
    '''

    velocity_grid: typing.List[float] = None
    '''Smoke velocity grid 

    :type: typing.List[float]
    '''

    viscosity_base: float = None
    '''Viscosity setting: value that is multiplied by 10 to the power of (exponent*-1) 

    :type: float
    '''

    viscosity_exponent: int = None
    '''Negative exponent for the viscosity value (to simplify entering small values e.g. 5*10^-6) 

    :type: int
    '''

    vorticity: float = None
    '''Amount of turbulence and rotation in smoke 

    :type: float
    '''


class FluidDomainVertexVelocity(bpy_struct):
    '''Velocity of a simulated fluid mesh '''

    velocity: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class FluidEffectorSettings(bpy_struct):
    '''Smoke collision settings '''

    effector_type: typing.Union[str, int] = None
    '''Change type of effector in the simulation 

    :type: typing.Union[str, int]
    '''

    guide_mode: typing.Union[str, int] = None
    '''How to create guiding velocities 

    :type: typing.Union[str, int]
    '''

    surface_distance: float = None
    '''Distance around mesh surface to consider as effector 

    :type: float
    '''

    use_plane_init: bool = None
    '''Treat this object as a planar, unclosed mesh 

    :type: bool
    '''

    velocity_factor: float = None
    '''Multiplier of obstacle velocity 

    :type: float
    '''


class FluidFlowSettings(bpy_struct):
    '''Fluid flow settings '''

    density: float = None
    '''

    :type: float
    '''

    density_vertex_group: str = None
    '''Name of vertex group which determines surface emission rate 

    :type: str
    '''

    flow_behavior: typing.Union[str, int] = None
    '''Change flow behavior in the simulation 

    :type: typing.Union[str, int]
    '''

    flow_source: typing.Union[str, int] = None
    '''Change how fluid is emitted 

    :type: typing.Union[str, int]
    '''

    flow_type: typing.Union[str, int] = None
    '''Change type of fluid in the simulation 

    :type: typing.Union[str, int]
    '''

    fuel_amount: float = None
    '''

    :type: float
    '''

    noise_texture: 'Texture' = None
    '''Texture that controls emission strength 

    :type: 'Texture'
    '''

    particle_size: float = None
    '''Particle size in simulation cells 

    :type: float
    '''

    particle_system: 'ParticleSystem' = None
    '''Particle systems emitted from the object 

    :type: 'ParticleSystem'
    '''

    smoke_color: typing.List[float] = None
    '''Color of smoke 

    :type: typing.List[float]
    '''

    subframes: int = None
    '''Number of additional samples to take between frames to improve quality of fast moving flows 

    :type: int
    '''

    surface_distance: float = None
    '''Controls fluid emission from the mesh surface (higher value results in emission further away from the mesh surface 

    :type: float
    '''

    temperature: float = None
    '''Temperature difference to ambient temperature 

    :type: float
    '''

    texture_map_type: typing.Union[str, int] = None
    '''Texture mapping type 

    :type: typing.Union[str, int]
    '''

    texture_offset: float = None
    '''Z-offset of texture mapping 

    :type: float
    '''

    texture_size: float = None
    '''Size of texture mapping 

    :type: float
    '''

    use_absolute: bool = None
    '''Only allow given density value in emitter area and will not add up 

    :type: bool
    '''

    use_inflow: bool = None
    '''Control when to apply inflow 

    :type: bool
    '''

    use_initial_velocity: bool = None
    '''Fluid has some initial velocity when it is emitted 

    :type: bool
    '''

    use_particle_size: bool = None
    '''Set particle size in simulation cells or use nearest cell 

    :type: bool
    '''

    use_plane_init: bool = None
    '''Treat this object as a planar and unclosed mesh. Fluid will only be emitted from the mesh surface and based on the surface emission value 

    :type: bool
    '''

    use_texture: bool = None
    '''Use a texture to control emission strength 

    :type: bool
    '''

    uv_layer: str = None
    '''UV map name 

    :type: str
    '''

    velocity_coord: typing.List[float] = None
    '''Initial velocity in X, Y and Z direction 

    :type: typing.List[float]
    '''

    velocity_factor: float = None
    '''Multiplier of source velocity passed to fluid (source velocity is non-zero only if object is moving) 

    :type: float
    '''

    velocity_normal: float = None
    '''Amount of normal directional velocity 

    :type: float
    '''

    velocity_random: float = None
    '''Amount of random velocity 

    :type: float
    '''

    volume_density: float = None
    '''Controls fluid emission from within the mesh (higher value results in greater emissions from inside the mesh) 

    :type: float
    '''


class FreestyleLineSet(bpy_struct):
    '''Line set for associating lines and style parameters '''

    collection: 'Collection' = None
    '''A collection of objects based on which feature edges are selected 

    :type: 'Collection'
    '''

    collection_negation: typing.Union[str, int] = None
    '''Specify either inclusion or exclusion of feature edges belonging to a collection of objects 

    :type: typing.Union[str, int]
    '''

    edge_type_combination: typing.Union[str, int] = None
    '''Specify a logical combination of selection conditions on feature edge types 

    :type: typing.Union[str, int]
    '''

    edge_type_negation: typing.Union[str, int] = None
    '''Specify either inclusion or exclusion of feature edges selected by edge types 

    :type: typing.Union[str, int]
    '''

    exclude_border: bool = None
    '''Exclude border edges 

    :type: bool
    '''

    exclude_contour: bool = None
    '''Exclude contours 

    :type: bool
    '''

    exclude_crease: bool = None
    '''Exclude crease edges 

    :type: bool
    '''

    exclude_edge_mark: bool = None
    '''Exclude edge marks 

    :type: bool
    '''

    exclude_external_contour: bool = None
    '''Exclude external contours 

    :type: bool
    '''

    exclude_material_boundary: bool = None
    '''Exclude edges at material boundaries 

    :type: bool
    '''

    exclude_ridge_valley: bool = None
    '''Exclude ridges and valleys 

    :type: bool
    '''

    exclude_silhouette: bool = None
    '''Exclude silhouette edges 

    :type: bool
    '''

    exclude_suggestive_contour: bool = None
    '''Exclude suggestive contours 

    :type: bool
    '''

    face_mark_condition: typing.Union[str, int] = None
    '''Specify a feature edge selection condition based on face marks 

    :type: typing.Union[str, int]
    '''

    face_mark_negation: typing.Union[str, int] = None
    '''Specify either inclusion or exclusion of feature edges selected by face marks 

    :type: typing.Union[str, int]
    '''

    linestyle: 'FreestyleLineStyle' = None
    '''Line style settings 

    :type: 'FreestyleLineStyle'
    '''

    name: str = None
    '''Line set name 

    :type: str
    '''

    qi_end: int = None
    '''Last QI value of the QI range 

    :type: int
    '''

    qi_start: int = None
    '''First QI value of the QI range 

    :type: int
    '''

    select_border: bool = None
    '''Select border edges (open mesh edges) 

    :type: bool
    '''

    select_by_collection: bool = None
    '''Select feature edges based on a collection of objects 

    :type: bool
    '''

    select_by_edge_types: bool = None
    '''Select feature edges based on edge types 

    :type: bool
    '''

    select_by_face_marks: bool = None
    '''Select feature edges by face marks 

    :type: bool
    '''

    select_by_image_border: bool = None
    '''Select feature edges by image border (less memory consumption) 

    :type: bool
    '''

    select_by_visibility: bool = None
    '''Select feature edges based on visibility 

    :type: bool
    '''

    select_contour: bool = None
    '''Select contours (outer silhouettes of each object) 

    :type: bool
    '''

    select_crease: bool = None
    '''Select crease edges (those between two faces making an angle smaller than the Crease Angle) 

    :type: bool
    '''

    select_edge_mark: bool = None
    '''Select edge marks (edges annotated by Freestyle edge marks) 

    :type: bool
    '''

    select_external_contour: bool = None
    '''Select external contours (outer silhouettes of occluding and occluded objects) 

    :type: bool
    '''

    select_material_boundary: bool = None
    '''Select edges at material boundaries 

    :type: bool
    '''

    select_ridge_valley: bool = None
    '''Select ridges and valleys (boundary lines between convex and concave areas of surface) 

    :type: bool
    '''

    select_silhouette: bool = None
    '''Select silhouettes (edges at the boundary of visible and hidden faces) 

    :type: bool
    '''

    select_suggestive_contour: bool = None
    '''Select suggestive contours (almost silhouette/contour edges) 

    :type: bool
    '''

    show_render: bool = None
    '''Enable or disable this line set during stroke rendering 

    :type: bool
    '''

    visibility: typing.Union[str, int] = None
    '''Determine how to use visibility for feature edge selection 

    :type: typing.Union[str, int]
    '''


class FreestyleModuleSettings(bpy_struct):
    '''Style module configuration for specifying a style module '''

    script: 'Text' = None
    '''Python script to define a style module 

    :type: 'Text'
    '''

    use: bool = None
    '''Enable or disable this style module during stroke rendering 

    :type: bool
    '''


class FreestyleModules(bpy_struct):
    '''A list of style modules (to be applied from top to bottom) '''

    def new(self, ) -> 'FreestyleModuleSettings':
        '''Add a style module to scene render layer Freestyle settings 

        :rtype: 'FreestyleModuleSettings'
        :return:  Newly created style module 
        '''
        pass

    def remove(self, module: 'FreestyleModuleSettings'):
        '''Remove a style module from scene render layer Freestyle settings 

        :param module: Style module to remove 
        :type module: 'FreestyleModuleSettings'
        '''
        pass


class FreestyleSettings(bpy_struct):
    '''Freestyle settings for a ViewLayer data-block '''

    crease_angle: float = None
    '''Angular threshold for detecting crease edges 

    :type: float
    '''

    kr_derivative_epsilon: float = None
    '''Kr derivative epsilon for computing suggestive contours 

    :type: float
    '''

    linesets: typing.Union[typing.List['FreestyleLineSet'],
                           'bpy_prop_collection', 'Linesets'] = None
    '''

    :type: typing.Union[typing.List['FreestyleLineSet'], 'bpy_prop_collection', 'Linesets']
    '''

    mode: typing.Union[str, int] = None
    '''Select the Freestyle control mode 

    :type: typing.Union[str, int]
    '''

    modules: typing.Union[typing.List['FreestyleModuleSettings'],
                          'bpy_prop_collection', 'FreestyleModules'] = None
    '''A list of style modules (to be applied from top to bottom) 

    :type: typing.Union[typing.List['FreestyleModuleSettings'], 'bpy_prop_collection', 'FreestyleModules']
    '''

    sphere_radius: float = None
    '''Sphere radius for computing curvatures 

    :type: float
    '''

    use_advanced_options: bool = None
    '''Enable advanced edge detection options (sphere radius and Kr derivative epsilon) 

    :type: bool
    '''

    use_culling: bool = None
    '''If enabled, out-of-view edges are ignored 

    :type: bool
    '''

    use_material_boundaries: bool = None
    '''Enable material boundaries 

    :type: bool
    '''

    use_ridges_and_valleys: bool = None
    '''Enable ridges and valleys 

    :type: bool
    '''

    use_smoothness: bool = None
    '''Take face smoothness into account in view map calculation 

    :type: bool
    '''

    use_suggestive_contours: bool = None
    '''Enable suggestive contours 

    :type: bool
    '''

    use_view_map_cache: bool = None
    '''Keep the computed view map and avoid re-calculating it if mesh geometry is unchanged 

    :type: bool
    '''


class Function(bpy_struct):
    '''RNA function definition '''

    description: str = None
    '''Description of the Function’s purpose 

    :type: str
    '''

    identifier: str = None
    '''Unique name used in the code and scripting 

    :type: str
    '''

    is_registered: bool = None
    '''Function is registered as callback as part of type registration 

    :type: bool
    '''

    is_registered_optional: bool = None
    '''Function is optionally registered as callback part of type registration 

    :type: bool
    '''

    parameters: typing.Union[typing.
                             List['Property'], 'bpy_prop_collection'] = None
    '''Parameters for the function 

    :type: typing.Union[typing.List['Property'], 'bpy_prop_collection']
    '''

    use_self: bool = None
    '''Function does not pass its self as an argument (becomes a static method in python) 

    :type: bool
    '''

    use_self_type: bool = None
    '''Function passes its self type as an argument (becomes a class method in python if use_self is false) 

    :type: bool
    '''


class GPencilFrame(bpy_struct):
    '''Collection of related sketches on a particular frame '''

    frame_number: int = None
    '''The frame on which this sketch appears 

    :type: int
    '''

    is_edited: bool = None
    '''Frame is being edited (painted on) 

    :type: bool
    '''

    select: bool = None
    '''Frame is selected for editing in the Dope Sheet 

    :type: bool
    '''

    strokes: typing.Union[typing.List['GPencilStroke'], 'bpy_prop_collection',
                          'GPencilStrokes'] = None
    '''Freehand curves defining the sketch on this frame 

    :type: typing.Union[typing.List['GPencilStroke'], 'bpy_prop_collection', 'GPencilStrokes']
    '''

    def clear(self, ):
        '''Remove all the grease pencil frame data 

        '''
        pass


class GPencilFrames(bpy_struct):
    '''Collection of grease pencil frames '''

    def new(self, frame_number: int, active: bool = False) -> 'GPencilFrame':
        '''Add a new grease pencil frame 

        :param frame_number: Frame Number, The frame on which this sketch appears 
        :type frame_number: int
        :param active: Active 
        :type active: bool
        :rtype: 'GPencilFrame'
        :return:  The newly created frame 
        '''
        pass

    def remove(self, frame: 'GPencilFrame'):
        '''Remove a grease pencil frame 

        :param frame: Frame, The frame to remove 
        :type frame: 'GPencilFrame'
        '''
        pass

    def copy(self, source: 'GPencilFrame') -> 'GPencilFrame':
        '''Copy a grease pencil frame 

        :param source: Source, The source frame 
        :type source: 'GPencilFrame'
        :rtype: 'GPencilFrame'
        :return:  The newly copied frame 
        '''
        pass


class GPencilInterpolateSettings(bpy_struct):
    '''Settings for Grease Pencil interpolation tools '''

    amplitude: float = None
    '''Amount to boost elastic bounces for ‘elastic’ easing 

    :type: float
    '''

    back: float = None
    '''Amount of overshoot for ‘back’ easing 

    :type: float
    '''

    easing: typing.Union[str, int] = None
    '''Which ends of the segment between the preceding and following grease pencil frames easing interpolation is applied to 

    :type: typing.Union[str, int]
    '''

    interpolate_all_layers: bool = None
    '''Interpolate all layers, not only active 

    :type: bool
    '''

    interpolate_selected_only: bool = None
    '''Interpolate only selected strokes in the original frame 

    :type: bool
    '''

    interpolation_curve: 'CurveMapping' = None
    '''Custom curve to control ‘sequence’ interpolation between Grease Pencil frames 

    :type: 'CurveMapping'
    '''

    period: float = None
    '''Time between bounces for elastic easing 

    :type: float
    '''

    type: typing.Union[str, int] = None
    '''Interpolation method to use the next time ‘Interpolate Sequence’ is run 

    :type: typing.Union[str, int]
    '''


class GPencilLayer(bpy_struct):
    '''Collection of related sketches '''

    active_frame: 'GPencilFrame' = None
    '''Frame currently being displayed for this layer 

    :type: 'GPencilFrame'
    '''

    annotation_hide: bool = None
    '''Set annotation Visibility 

    :type: bool
    '''

    annotation_onion_after_color: typing.List[float] = None
    '''Base color for ghosts after the active frame 

    :type: typing.List[float]
    '''

    annotation_onion_after_range: int = None
    '''Maximum number of frames to show after current frame 

    :type: int
    '''

    annotation_onion_before_color: typing.List[float] = None
    '''Base color for ghosts before the active frame 

    :type: typing.List[float]
    '''

    annotation_onion_before_range: int = None
    '''Maximum number of frames to show before current frame 

    :type: int
    '''

    blend_mode: typing.Union[str, int] = None
    '''Blend mode 

    :type: typing.Union[str, int]
    '''

    channel_color: typing.List[float] = None
    '''Custom color for animation channel in Dopesheet 

    :type: typing.List[float]
    '''

    color: typing.List[float] = None
    '''Color for all strokes in this layer 

    :type: typing.List[float]
    '''

    frames: typing.Union[typing.List['GPencilFrame'], 'bpy_prop_collection',
                         'GPencilFrames'] = None
    '''Sketches for this layer on different frames 

    :type: typing.Union[typing.List['GPencilFrame'], 'bpy_prop_collection', 'GPencilFrames']
    '''

    hide: bool = None
    '''Set layer Visibility 

    :type: bool
    '''

    info: str = None
    '''Layer name 

    :type: str
    '''

    is_parented: bool = None
    '''True when the layer parent object is set 

    :type: bool
    '''

    is_ruler: bool = None
    '''This is a special ruler layer 

    :type: bool
    '''

    line_change: int = None
    '''Thickness change to apply to current strokes (in pixels) 

    :type: int
    '''

    lock: bool = None
    '''Protect layer from further editing and/or frame changes 

    :type: bool
    '''

    lock_frame: bool = None
    '''Lock current frame displayed by layer 

    :type: bool
    '''

    lock_material: bool = None
    '''Avoids editing locked materials in the layer 

    :type: bool
    '''

    mask_layer: bool = None
    '''Remove any pixel outside underlying layers drawing 

    :type: bool
    '''

    matrix_inverse: typing.List[float] = None
    '''Parent inverse transformation matrix 

    :type: typing.List[float]
    '''

    opacity: float = None
    '''Layer Opacity 

    :type: float
    '''

    parent: 'Object' = None
    '''Parent Object 

    :type: 'Object'
    '''

    parent_bone: str = None
    '''Name of parent bone in case of a bone parenting relation 

    :type: str
    '''

    parent_type: typing.Union[str, int] = None
    '''Type of parent relation 

    :type: typing.Union[str, int]
    '''

    pass_index: int = None
    '''Index number for the “Layer Index” pass 

    :type: int
    '''

    select: bool = None
    '''Layer is selected for editing in the Dope Sheet 

    :type: bool
    '''

    show_in_front: bool = None
    '''Make the layer draw in front of objects 

    :type: bool
    '''

    show_points: bool = None
    '''Draw the points which make up the strokes (for debugging purposes) 

    :type: bool
    '''

    thickness: int = None
    '''Thickness of annotation strokes 

    :type: int
    '''

    tint_color: typing.List[float] = None
    '''Color for tinting stroke colors 

    :type: typing.List[float]
    '''

    tint_factor: float = None
    '''Factor of tinting color 

    :type: float
    '''

    use_annotation_onion_skinning: bool = None
    '''Display annotation onion skins before and after the current frame 

    :type: bool
    '''

    use_onion_skinning: bool = None
    '''Display onion skins before and after the current frame 

    :type: bool
    '''

    use_solo_mode: bool = None
    '''In Paint mode display only layers with keyframe in current frame 

    :type: bool
    '''

    viewlayer_render: str = None
    '''Only include Layer in this View Layer render output (leave blank to include always) 

    :type: str
    '''

    def clear(self, ):
        '''Remove all the grease pencil layer data 

        '''
        pass


class GPencilSculptBrush(bpy_struct):
    '''Stroke editing brush '''

    cursor_color_add: typing.List[float] = None
    '''Color for the cursor for addition 

    :type: typing.List[float]
    '''

    cursor_color_sub: typing.List[float] = None
    '''Color for the cursor for subtraction 

    :type: typing.List[float]
    '''

    direction: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    size: int = None
    '''Radius of the brush in pixels 

    :type: int
    '''

    strength: float = None
    '''Brush strength 

    :type: float
    '''

    use_cursor: bool = None
    '''Enable cursor on screen 

    :type: bool
    '''

    use_edit_pressure: bool = None
    '''Affect pressure values as well when smoothing strokes 

    :type: bool
    '''

    use_falloff: bool = None
    '''Strength of brush decays with distance from cursor 

    :type: bool
    '''

    use_pressure_radius: bool = None
    '''Enable tablet pressure sensitivity for radius 

    :type: bool
    '''

    use_pressure_strength: bool = None
    '''Enable tablet pressure sensitivity for strength 

    :type: bool
    '''

    weight: float = None
    '''Target weight (define a maximum range limit for the weight. Any value above will be clamped) 

    :type: float
    '''


class GPencilSculptGuide(bpy_struct):
    '''Guides for drawing '''

    angle: float = None
    '''Direction of lines 

    :type: float
    '''

    angle_snap: float = None
    '''Angle snapping 

    :type: float
    '''

    location: typing.List[float] = None
    '''Custom reference point for guides 

    :type: typing.List[float]
    '''

    reference_object: 'Object' = None
    '''Object used for reference point 

    :type: 'Object'
    '''

    reference_point: typing.Union[str, int] = None
    '''Type of speed guide 

    :type: typing.Union[str, int]
    '''

    spacing: float = None
    '''Guide spacing 

    :type: float
    '''

    type: typing.Union[str, int] = None
    '''Type of speed guide 

    :type: typing.Union[str, int]
    '''

    use_guide: bool = None
    '''Enable speed guides 

    :type: bool
    '''

    use_snapping: bool = None
    '''Enable snapping to guides angle or spacing options 

    :type: bool
    '''


class GPencilSculptSettings(bpy_struct):
    '''Properties for Grease Pencil stroke sculpting tool '''

    brush: 'GPencilSculptBrush' = None
    '''

    :type: 'GPencilSculptBrush'
    '''

    guide: 'GPencilSculptGuide' = None
    '''

    :type: 'GPencilSculptGuide'
    '''

    intersection_threshold: float = None
    '''Threshold for stroke intersections 

    :type: float
    '''

    lock_axis: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    multiframe_falloff_curve: 'CurveMapping' = None
    '''Custom curve to control falloff of brush effect by Grease Pencil frames 

    :type: 'CurveMapping'
    '''

    sculpt_tool: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    thickness_primitive_curve: 'CurveMapping' = None
    '''Custom curve to control primitive thickness 

    :type: 'CurveMapping'
    '''

    use_edit_position: bool = None
    '''The brush affects the position of the point 

    :type: bool
    '''

    use_edit_strength: bool = None
    '''The brush affects the color strength of the point 

    :type: bool
    '''

    use_edit_thickness: bool = None
    '''The brush affects the thickness of the point 

    :type: bool
    '''

    use_edit_uv: bool = None
    '''The brush affects the UV rotation of the point 

    :type: bool
    '''

    use_multiframe_falloff: bool = None
    '''Use falloff effect when edit in multiframe mode to compute brush effect by frame 

    :type: bool
    '''

    use_thickness_curve: bool = None
    '''Use curve to define primitive stroke thickness 

    :type: bool
    '''

    weight_tool: typing.Union[str, int] = None
    '''Tool for weight painting 

    :type: typing.Union[str, int]
    '''


class GPencilStroke(bpy_struct):
    '''Freehand curve defining part of a sketch '''

    display_mode: typing.Union[str, int] = None
    '''Coordinate space that stroke is in 

    :type: typing.Union[str, int]
    '''

    draw_cyclic: bool = None
    '''Enable cyclic drawing, closing the stroke 

    :type: bool
    '''

    end_cap_mode: typing.Union[str, int] = None
    '''Stroke end extreme cap style 

    :type: typing.Union[str, int]
    '''

    gradient_factor: float = None
    '''Amount of gradient along section of stroke 

    :type: float
    '''

    gradient_shape: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    groups: typing.Union[typing.List['GpencilVertexGroupElement'],
                         'bpy_prop_collection'] = None
    '''Weights for the vertex groups this vertex is member of 

    :type: typing.Union[typing.List['GpencilVertexGroupElement'], 'bpy_prop_collection']
    '''

    is_nofill_stroke: bool = None
    '''Special stroke to use as boundary for filling areas 

    :type: bool
    '''

    line_width: int = None
    '''Thickness of stroke (in pixels) 

    :type: int
    '''

    material_index: int = None
    '''Index of material used in this stroke 

    :type: int
    '''

    points: typing.Union[typing.List['GPencilStrokePoint'],
                         'bpy_prop_collection', 'GPencilStrokePoints'] = None
    '''Stroke data points 

    :type: typing.Union[typing.List['GPencilStrokePoint'], 'bpy_prop_collection', 'GPencilStrokePoints']
    '''

    select: bool = None
    '''Stroke is selected for viewport editing 

    :type: bool
    '''

    start_cap_mode: typing.Union[str, int] = None
    '''Stroke start extreme cap style 

    :type: typing.Union[str, int]
    '''

    triangles: typing.Union[typing.List['GPencilTriangle'],
                            'bpy_prop_collection'] = None
    '''Triangulation data for HQ fill 

    :type: typing.Union[typing.List['GPencilTriangle'], 'bpy_prop_collection']
    '''


class GPencilStrokePoint(bpy_struct):
    '''Data point for freehand stroke curve '''

    co: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    pressure: float = None
    '''Pressure of tablet at point when drawing it 

    :type: float
    '''

    select: bool = None
    '''Point is selected for viewport editing 

    :type: bool
    '''

    strength: float = None
    '''Color intensity (alpha factor) 

    :type: float
    '''

    uv_factor: float = None
    '''Internal UV factor 

    :type: float
    '''

    uv_rotation: float = None
    '''Internal UV factor for dot mode 

    :type: float
    '''


class GPencilStrokePoints(bpy_struct):
    '''Collection of grease pencil stroke points '''

    def add(self, count: int, pressure: float = 1.0, strength: float = 1.0):
        '''Add a new grease pencil stroke point 

        :param count: Number, Number of points to add to the stroke 
        :type count: int
        :param pressure: Pressure, Pressure for newly created points 
        :type pressure: float
        :param strength: Strength, Color intensity (alpha factor) for newly created points 
        :type strength: float
        '''
        pass

    def pop(self, index: int = -1):
        '''Remove a grease pencil stroke point 

        :param index: Index, point index 
        :type index: int
        '''
        pass


class GPencilStrokes(bpy_struct):
    '''Collection of grease pencil stroke '''

    def new(self, ) -> 'GPencilStroke':
        '''Add a new grease pencil stroke 

        :rtype: 'GPencilStroke'
        :return:  The newly created stroke 
        '''
        pass

    def remove(self, stroke: 'GPencilStroke'):
        '''Remove a grease pencil stroke 

        :param stroke: Stroke, The stroke to remove 
        :type stroke: 'GPencilStroke'
        '''
        pass

    def close(self, stroke: 'GPencilStroke'):
        '''Close a grease pencil stroke adding geometry 

        :param stroke: Stroke, The stroke to close 
        :type stroke: 'GPencilStroke'
        '''
        pass


class GPencilTriangle(bpy_struct):
    '''Triangulation data for Grease Pencil fills '''

    uv1: typing.List[float] = None
    '''First triangle vertex texture coordinates 

    :type: typing.List[float]
    '''

    uv2: typing.List[float] = None
    '''Second triangle vertex texture coordinates 

    :type: typing.List[float]
    '''

    uv3: typing.List[float] = None
    '''Third triangle vertex texture coordinates 

    :type: typing.List[float]
    '''

    v1: int = None
    '''First triangle vertex index 

    :type: int
    '''

    v2: int = None
    '''Second triangle vertex index 

    :type: int
    '''

    v3: int = None
    '''Third triangle vertex index 

    :type: int
    '''


class Gizmo(bpy_struct):
    '''Collection of gizmos '''

    alpha: float = None
    '''

    :type: float
    '''

    alpha_highlight: float = None
    '''

    :type: float
    '''

    bl_idname: str = None
    '''

    :type: str
    '''

    color: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    color_highlight: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    group: 'GizmoGroup' = None
    '''Gizmo group this gizmo is a member of 

    :type: 'GizmoGroup'
    '''

    hide: bool = None
    '''

    :type: bool
    '''

    hide_select: bool = None
    '''

    :type: bool
    '''

    is_highlight: bool = None
    '''

    :type: bool
    '''

    is_modal: bool = None
    '''

    :type: bool
    '''

    line_width: float = None
    '''

    :type: float
    '''

    matrix_basis: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    matrix_offset: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    matrix_space: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    matrix_world: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    properties: 'GizmoProperties' = None
    '''

    :type: 'GizmoProperties'
    '''

    scale_basis: float = None
    '''

    :type: float
    '''

    select: bool = None
    '''

    :type: bool
    '''

    select_bias: float = None
    '''Depth bias used for selection 

    :type: float
    '''

    use_draw_hover: bool = None
    '''

    :type: bool
    '''

    use_draw_modal: bool = None
    '''Draw while dragging 

    :type: bool
    '''

    use_draw_offset_scale: bool = None
    '''Scale the offset matrix (use to apply screen-space offset) 

    :type: bool
    '''

    use_draw_scale: bool = None
    '''Use scale when calculating the matrix 

    :type: bool
    '''

    use_draw_value: bool = None
    '''Show an indicator for the current value while dragging 

    :type: bool
    '''

    use_event_handle_all: bool = None
    '''When highlighted, do not pass events through to be handled by other keymaps 

    :type: bool
    '''

    use_grab_cursor: bool = None
    '''

    :type: bool
    '''

    use_operator_tool_properties: bool = None
    '''Merge active tool properties on activation (does not overwrite existing) 

    :type: bool
    '''

    use_select_background: bool = None
    '''Don’t write into the depth buffer 

    :type: bool
    '''

    def draw(self, context):
        '''

        '''
        pass

    def draw_select(self, context, select_id=0):
        '''

        '''
        pass

    def test_select(self, context, location: typing.List[int]) -> int:
        '''

        :param location: Location, Region coordinates 
        :type location: typing.List[int]
        :rtype: int
        :return:  Use -1 to skip this gizmo 
        '''
        pass

    def modal(self, context, event,
              tweak: typing.Union[typing.Set[str], typing.Set[int]]
              ) -> typing.Union[typing.Set[str], typing.Set[int]]:
        '''

        :param tweak: Tweak 
        :type tweak: typing.Union[typing.Set[str], typing.Set[int]]
        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return:  resultRUNNING_MODAL Running Modal, Keep the operator running with blender.CANCELLED Cancelled, The operator exited without doing anything, so no undo entry should be pushed.FINISHED Finished, The operator exited after completing its action.PASS_THROUGH Pass Through, Do nothing and pass the event on.INTERFACE Interface, Handled but not executed (popup menus). 
        '''
        pass

    def setup(self, ):
        '''

        '''
        pass

    def invoke(self, context,
               event) -> typing.Union[typing.Set[str], typing.Set[int]]:
        '''

        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return:  resultRUNNING_MODAL Running Modal, Keep the operator running with blender.CANCELLED Cancelled, The operator exited without doing anything, so no undo entry should be pushed.FINISHED Finished, The operator exited after completing its action.PASS_THROUGH Pass Through, Do nothing and pass the event on.INTERFACE Interface, Handled but not executed (popup menus). 
        '''
        pass

    def exit(self, context, cancel: bool):
        '''

        :param cancel: Cancel, otherwise confirm 
        :type cancel: bool
        '''
        pass

    def select_refresh(self, ):
        '''

        '''
        pass

    def draw_preset_box(self, matrix: typing.List[float], select_id: int = -1):
        '''Draw a box 

        :param matrix: The matrix to transform 
        :type matrix: typing.List[float]
        :param select_id: Zero when not selecting 
        :type select_id: int
        '''
        pass

    def draw_preset_arrow(self,
                          matrix: typing.List[float],
                          axis: typing.Union[str, int] = 'POS_Z',
                          select_id: int = -1):
        '''Draw a box 

        :param matrix: The matrix to transform 
        :type matrix: typing.List[float]
        :param axis: Arrow Orientation 
        :type axis: typing.Union[str, int]
        :param select_id: Zero when not selecting 
        :type select_id: int
        '''
        pass

    def draw_preset_circle(self,
                           matrix: typing.List[float],
                           axis: typing.Union[str, int] = 'POS_Z',
                           select_id: int = -1):
        '''Draw a box 

        :param matrix: The matrix to transform 
        :type matrix: typing.List[float]
        :param axis: Arrow Orientation 
        :type axis: typing.Union[str, int]
        :param select_id: Zero when not selecting 
        :type select_id: int
        '''
        pass

    def draw_preset_facemap(self,
                            object: 'Object',
                            face_map: int,
                            select_id: int = -1):
        '''Draw the face-map of a mesh object 

        :param object: Object 
        :type object: 'Object'
        :param face_map: Face map index 
        :type face_map: int
        :param select_id: Zero when not selecting 
        :type select_id: int
        '''
        pass

    def target_set_prop(self,
                        target: str,
                        data: 'AnyType',
                        property: str,
                        index=-1):
        '''

        :param target: Target property 
        :type target: str
        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        '''
        pass

    def target_set_operator(self, operator: str,
                            index: int = 0) -> 'OperatorProperties':
        '''Operator to run when activating the gizmo (overrides property targets) 

        :param operator: Target operator 
        :type operator: str
        :param index: Part index 
        :type index: int
        :rtype: 'OperatorProperties'
        :return:  Operator properties to fill in 
        '''
        pass

    def target_is_valid(self, property: str) -> bool:
        '''

        :param property: Property identifier 
        :type property: str
        :rtype: bool
        '''
        pass

    def draw_custom_shape(self,
                          shape,
                          *,
                          matrix: 'mathutils.Matrix' = None,
                          select_id=None):
        '''Draw a shape created form bpy.types.Gizmo.draw_custom_shape. 

        :param shape: The cached shape to draw. 
        :type shape: 
        :param matrix: 4x4 matrix, when not given bpy.types.Gizmo.matrix_world is used. 
        :type matrix: 'mathutils.Matrix'
        :param select_id: The selection id. Only use when drawing within bpy.types.Gizmo.draw_select. 
        :type select_id: 
        '''
        pass

    def target_get_range(self, target) -> tuple:
        '''Get the range for this target property. 

        :param target: Target property name. 
        :type target: 
        :rtype: tuple
        :return:  The range of this property (min, max). 
        '''
        pass

    def target_get_value(self, target: str) -> list:
        '''Get the value of this target property. 

        :param target: Target property name. 
        :type target: str
        :rtype: list
        :return:  The value of the target property. 
        '''
        pass

    def target_set_handler(self, target, get, set, range=None):
        '''Assigns callbacks to a gizmos property. 

        :param get: Function that returns the value for this property (single value or sequence). 
        :type get: 
        :param set: Function that takes a single value argument and applies it. 
        :type set: 
        :param range: Function that returns a (min, max) tuple for gizmos that use a range. 
        :type range: 
        '''
        pass

    def target_set_value(self, target: str):
        '''Set the value of this target property. 

        :param target: Target property name. 
        :type target: str
        '''
        pass


class GizmoGroup(bpy_struct):
    '''Storage of an operator being executed, or registered after execution '''

    bl_idname: str = None
    '''

    :type: str
    '''

    bl_label: str = None
    '''

    :type: str
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Options for this operator type 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_owner_id: str = None
    '''

    :type: str
    '''

    bl_region_type: typing.Union[str, int] = None
    '''The region where the panel is going to be used in 

    :type: typing.Union[str, int]
    '''

    bl_space_type: typing.Union[str, int] = None
    '''The space where the panel is going to be used in 

    :type: typing.Union[str, int]
    '''

    gizmos: typing.Union[typing.
                         List['Gizmo'], 'bpy_prop_collection', 'Gizmos'] = None
    '''List of gizmos in the Gizmo Map 

    :type: typing.Union[typing.List['Gizmo'], 'bpy_prop_collection', 'Gizmos']
    '''

    has_reports: bool = None
    '''GizmoGroup has a set of reports (warnings and errors) from last execution 

    :type: bool
    '''

    name: str = None
    '''

    :type: str
    '''

    def setup(self, context):
        '''Create gizmos function for the gizmo group 

        '''
        pass

    def refresh(self, context):
        '''Refresh data (called on common state changes such as selection) 

        '''
        pass

    def draw_prepare(self, context):
        '''Run before each redraw 

        '''
        pass

    def invoke_prepare(self, context, gizmo):
        '''Run before invoke 

        '''
        pass


class GizmoGroupProperties(bpy_struct):
    '''Input properties of a Gizmo Group '''

    pass


class GizmoProperties(bpy_struct):
    '''Input properties of an Gizmo '''

    pass


class Gizmos(bpy_struct):
    '''Collection of gizmos '''

    def new(self, type: str) -> 'Gizmo':
        '''Add gizmo 

        :param type: Gizmo identifier 
        :type type: str
        :rtype: 'Gizmo'
        :return:  New gizmo 
        '''
        pass

    def remove(self, gizmo: 'Gizmo'):
        '''Delete gizmo 

        :param gizmo: New gizmo 
        :type gizmo: 'Gizmo'
        '''
        pass

    def clear(self, ):
        '''Delete all gizmos 

        '''
        pass


class GpencilModifier(bpy_struct):
    '''Modifier affecting the grease pencil object '''

    name: str = None
    '''Modifier name 

    :type: str
    '''

    show_expanded: bool = None
    '''Set modifier expanded in the user interface 

    :type: bool
    '''

    show_in_editmode: bool = None
    '''Display modifier in Edit mode 

    :type: bool
    '''

    show_render: bool = None
    '''Use modifier during render 

    :type: bool
    '''

    show_viewport: bool = None
    '''Display modifier in viewport 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''


class GpencilVertexGroupElement(bpy_struct):
    '''Weight value of a vertex in a vertex group '''

    group: int = None
    '''

    :type: int
    '''

    weight: float = None
    '''Vertex Weight 

    :type: float
    '''


class GreasePencilGrid(bpy_struct):
    '''Settings for grid and canvas in 3D viewport '''

    color: typing.List[float] = None
    '''Color for grid lines 

    :type: typing.List[float]
    '''

    lines: int = None
    '''Number of subdivisions in each side of symmetry line 

    :type: int
    '''

    offset: typing.List[float] = None
    '''Offset of the canvas 

    :type: typing.List[float]
    '''

    scale: typing.List[float] = None
    '''Grid scale 

    :type: typing.List[float]
    '''


class GreasePencilLayers(bpy_struct):
    '''Collection of grease pencil layers '''

    active: 'GPencilLayer' = None
    '''Active grease pencil layer 

    :type: 'GPencilLayer'
    '''

    active_index: int = None
    '''Index of active grease pencil layer 

    :type: int
    '''

    active_note: typing.Union[str, int] = None
    '''Note/Layer to add annotation strokes to 

    :type: typing.Union[str, int]
    '''

    def new(self, name: str, set_active: bool = True) -> 'GPencilLayer':
        '''Add a new grease pencil layer 

        :param name: Name, Name of the layer 
        :type name: str
        :param set_active: Set Active, Set the newly created layer to the active layer 
        :type set_active: bool
        :rtype: 'GPencilLayer'
        :return:  The newly created layer 
        '''
        pass

    def remove(self, layer: 'GPencilLayer'):
        '''Remove a grease pencil layer 

        :param layer: The layer to remove 
        :type layer: 'GPencilLayer'
        '''
        pass

    def move(self, layer: 'GPencilLayer', type: typing.Union[str, int]):
        '''Move a grease pencil layer in the layer stack 

        :param layer: The layer to move 
        :type layer: 'GPencilLayer'
        :param type: Direction of movement 
        :type type: typing.Union[str, int]
        '''
        pass


class Header(bpy_struct):
    '''Editor header containing UI elements '''

    bl_idname: str = None
    '''If this is set, the header gets a custom ID, otherwise it takes the name of the class used to define the panel; for example, if the class name is “OBJECT_HT_hello”, and bl_idname is not set by the script, then bl_idname = “OBJECT_HT_hello” 

    :type: str
    '''

    bl_region_type: typing.Union[str, int] = None
    '''The region where the header is going to be used in (defaults to header region) 

    :type: typing.Union[str, int]
    '''

    bl_space_type: typing.Union[str, int] = None
    '''The space where the header is going to be used in 

    :type: typing.Union[str, int]
    '''

    layout: 'UILayout' = None
    '''Structure of the header in the UI 

    :type: 'UILayout'
    '''

    def draw(self, context):
        '''Draw UI elements into the header UI layout 

        '''
        pass


class Histogram(bpy_struct):
    '''Statistical view of the levels of color in an image '''

    mode: typing.Union[str, int] = None
    '''Channels to display when drawing the histogram 

    :type: typing.Union[str, int]
    '''

    show_line: bool = None
    '''Display lines rather than filled shapes 

    :type: bool
    '''


class ID(bpy_struct):
    '''Base type for data-blocks, defining a unique name, linking from other libraries and garbage collection '''

    is_evaluated: bool = None
    '''Whether this ID is runtime-only, evaluated data-block, or actual data from .blend file 

    :type: bool
    '''

    is_library_indirect: bool = None
    '''Is this ID block linked indirectly 

    :type: bool
    '''

    library: 'Library' = None
    '''Library file the data-block is linked from 

    :type: 'Library'
    '''

    name: str = None
    '''Unique data-block ID name 

    :type: str
    '''

    name_full: str = None
    '''Unique data-block ID name, including library one is any 

    :type: str
    '''

    original: 'ID' = None
    '''Actual data-block from .blend file (Main database) that generated that evaluated one 

    :type: 'ID'
    '''

    override_library: 'IDOverrideLibrary' = None
    '''Library override data 

    :type: 'IDOverrideLibrary'
    '''

    preview: 'ImagePreview' = None
    '''Preview image and icon of this data-block (None if not supported for this type of data) 

    :type: 'ImagePreview'
    '''

    tag: bool = None
    '''Tools can use this to tag data for their own purposes (initial state is undefined) 

    :type: bool
    '''

    use_fake_user: bool = None
    '''Save this data-block even if it has no users 

    :type: bool
    '''

    users: int = None
    '''Number of times this data-block is referenced 

    :type: int
    '''

    def evaluated_get(self, depsgraph: 'Depsgraph') -> 'ID':
        '''Get corresponding evaluated ID from the given dependency graph 

        :param depsgraph: Dependency graph to perform lookup in 
        :type depsgraph: 'Depsgraph'
        :rtype: 'ID'
        :return:  New copy of the ID 
        '''
        pass

    def copy(self, ) -> 'ID':
        '''Create a copy of this data-block (not supported for all data-blocks) 

        :rtype: 'ID'
        :return:  New copy of the ID 
        '''
        pass

    def override_create(self, remap_local_usages: bool = False) -> 'ID':
        '''Create an overridden local copy of this linked data-block (not supported for all data-blocks) 

        :param remap_local_usages: Whether local usages of the linked ID should be remapped to the new library override of it 
        :type remap_local_usages: bool
        :rtype: 'ID'
        :return:  New overridden local copy of the ID 
        '''
        pass

    def user_clear(self, ):
        '''This function is for advanced use only, misuse can crash blender since the user count is used to prevent data being removed when it is used. 

        '''
        pass

    def user_remap(self, new_id: 'ID'):
        '''Replace all usage in the .blend file of this ID by new given one 

        :param new_id: New ID to use 
        :type new_id: 'ID'
        '''
        pass

    def make_local(self, clear_proxy: bool = True) -> 'ID':
        '''Make this datablock local, return local one (may be a copy of the original, in case it is also indirectly used) 

        :param clear_proxy: Whether to clear proxies (the default behavior, note that if object has to be duplicated to be made local, proxies are always cleared) 
        :type clear_proxy: bool
        :rtype: 'ID'
        :return:  This ID, or the new ID if it was copied 
        '''
        pass

    def user_of_id(self, id: 'ID') -> int:
        '''Count the number of times that ID uses/references given one 

        :param id: ID to count usages 
        :type id: 'ID'
        :rtype: int
        :return:  Number of usages/references of given id by current data-block 
        '''
        pass

    def animation_data_create(self, ) -> 'AnimData':
        '''Create animation data to this ID, note that not all ID types support this 

        :rtype: 'AnimData'
        :return:  New animation data or NULL 
        '''
        pass

    def animation_data_clear(self, ):
        '''Clear animation on this this ID 

        '''
        pass

    def update_tag(
            self,
            refresh: typing.Union[typing.Set[str], typing.Set[int]] = {}):
        '''Tag the ID to update its display data, e.g. when calling bpy.types.Scene.update 

        :param refresh: Type of updates to perform 
        :type refresh: typing.Union[typing.Set[str], typing.Set[int]]
        '''
        pass


class IDMaterials(bpy_struct):
    '''Collection of materials '''

    def append(self, material: 'Material'):
        '''Add a new material to the data-block 

        :param material: Material to add 
        :type material: 'Material'
        '''
        pass

    def pop(self, index: int = -1) -> 'Material':
        '''Remove a material from the data-block 

        :param index: Index of material to remove 
        :type index: int
        :rtype: 'Material'
        :return:  Material to remove 
        '''
        pass

    def clear(self, ):
        '''Remove all materials from the data-block 

        '''
        pass


class IDOverrideLibrary(bpy_struct):
    '''Struct gathering all data needed by overridden linked IDs '''

    auto_generate: bool = None
    '''Automatically generate overriding operations by detecting changes in properties 

    :type: bool
    '''

    properties: typing.Union[typing.List['IDOverrideLibraryProperty'],
                             'bpy_prop_collection'] = None
    '''List of overridden properties 

    :type: typing.Union[typing.List['IDOverrideLibraryProperty'], 'bpy_prop_collection']
    '''

    reference: 'ID' = None
    '''Linked ID used as reference by this override 

    :type: 'ID'
    '''


class IDOverrideLibraryProperty(bpy_struct):
    '''Description of an overridden property '''

    operations: typing.Union[typing.List['IDOverrideLibraryPropertyOperation'],
                             'bpy_prop_collection'] = None
    '''List of overriding operations for a property 

    :type: typing.Union[typing.List['IDOverrideLibraryPropertyOperation'], 'bpy_prop_collection']
    '''

    rna_path: str = None
    '''RNA path leading to that property, from owning ID 

    :type: str
    '''


class IDOverrideLibraryPropertyOperation(bpy_struct):
    '''Description of an override operation over an overridden property '''

    flag: typing.Union[str, int] = None
    '''Optional flags (NOT USED) 

    :type: typing.Union[str, int]
    '''

    operation: typing.Union[str, int] = None
    '''What override operation is performed 

    :type: typing.Union[str, int]
    '''

    subitem_local_index: int = None
    '''Used to handle insertions into collection 

    :type: int
    '''

    subitem_local_name: str = None
    '''Used to handle insertions into collection 

    :type: str
    '''

    subitem_reference_index: int = None
    '''Used to handle insertions into collection 

    :type: int
    '''

    subitem_reference_name: str = None
    '''Used to handle insertions into collection 

    :type: str
    '''


class IDPropertyWrapPtr(bpy_struct):
    pass


class IKParam(bpy_struct):
    '''Base type for IK solver parameters '''

    ik_solver: typing.Union[str, int] = None
    '''IK solver for which these parameters are defined 

    :type: typing.Union[str, int]
    '''


class ImageFormatSettings(bpy_struct):
    '''Settings for image formats '''

    cineon_black: int = None
    '''Log conversion reference blackpoint 

    :type: int
    '''

    cineon_gamma: float = None
    '''Log conversion gamma 

    :type: float
    '''

    cineon_white: int = None
    '''Log conversion reference whitepoint 

    :type: int
    '''

    color_depth: typing.Union[str, int] = None
    '''Bit depth per channel 

    :type: typing.Union[str, int]
    '''

    color_mode: typing.Union[str, int] = None
    '''Choose BW for saving grayscale images, RGB for saving red, green and blue channels, and RGBA for saving red, green, blue and alpha channels 

    :type: typing.Union[str, int]
    '''

    compression: int = None
    '''Amount of time to determine best compression: 0 = no compression with fast file output, 100 = maximum lossless compression with slow file output 

    :type: int
    '''

    display_settings: 'ColorManagedDisplaySettings' = None
    '''Settings of device saved image would be displayed on 

    :type: 'ColorManagedDisplaySettings'
    '''

    exr_codec: typing.Union[str, int] = None
    '''Codec settings for OpenEXR 

    :type: typing.Union[str, int]
    '''

    file_format: typing.Union[str, int] = None
    '''File format to save the rendered images as 

    :type: typing.Union[str, int]
    '''

    jpeg2k_codec: typing.Union[str, int] = None
    '''Codec settings for Jpeg2000 

    :type: typing.Union[str, int]
    '''

    quality: int = None
    '''Quality for image formats that support lossy compression 

    :type: int
    '''

    stereo_3d_format: 'Stereo3dFormat' = None
    '''Settings for stereo 3d 

    :type: 'Stereo3dFormat'
    '''

    tiff_codec: typing.Union[str, int] = None
    '''Compression mode for TIFF 

    :type: typing.Union[str, int]
    '''

    use_cineon_log: bool = None
    '''Convert to logarithmic color space 

    :type: bool
    '''

    use_jpeg2k_cinema_48: bool = None
    '''Use Openjpeg Cinema Preset (48fps) 

    :type: bool
    '''

    use_jpeg2k_cinema_preset: bool = None
    '''Use Openjpeg Cinema Preset 

    :type: bool
    '''

    use_jpeg2k_ycc: bool = None
    '''Save luminance-chrominance-chrominance channels instead of RGB colors 

    :type: bool
    '''

    use_preview: bool = None
    '''When rendering animations, save JPG preview images in same directory 

    :type: bool
    '''

    use_zbuffer: bool = None
    '''Save the z-depth per pixel (32 bit unsigned int z-buffer) 

    :type: bool
    '''

    view_settings: 'ColorManagedViewSettings' = None
    '''Color management settings applied on image before saving 

    :type: 'ColorManagedViewSettings'
    '''

    views_format: typing.Union[str, int] = None
    '''Format of multiview media 

    :type: typing.Union[str, int]
    '''


class ImagePackedFile(bpy_struct):
    filepath: str = None
    '''

    :type: str
    '''

    packed_file: 'PackedFile' = None
    '''

    :type: 'PackedFile'
    '''

    def save(self, ):
        '''Save the packed file to its filepath 

        '''
        pass


class ImagePreview(bpy_struct):
    '''Preview image and icon '''

    icon_id: int = None
    '''Unique integer identifying this preview as an icon (zero means invalid) 

    :type: int
    '''

    icon_pixels: int = None
    '''Icon pixels, as bytes (always RGBA 32bits) 

    :type: int
    '''

    icon_pixels_float: float = None
    '''Icon pixels components, as floats (RGBA concatenated values) 

    :type: float
    '''

    icon_size: typing.List[int] = None
    '''Width and height in pixels 

    :type: typing.List[int]
    '''

    image_pixels: int = None
    '''Image pixels, as bytes (always RGBA 32bits) 

    :type: int
    '''

    image_pixels_float: float = None
    '''Image pixels components, as floats (RGBA concatenated values) 

    :type: float
    '''

    image_size: typing.List[int] = None
    '''Width and height in pixels 

    :type: typing.List[int]
    '''

    is_icon_custom: bool = None
    '''True if this preview icon has been modified by py script,and is no more auto-generated by Blender 

    :type: bool
    '''

    is_image_custom: bool = None
    '''True if this preview image has been modified by py script,and is no more auto-generated by Blender 

    :type: bool
    '''

    def reload(self, ):
        '''Reload the preview from its source path 

        '''
        pass


class ImageUser(bpy_struct):
    '''Parameters defining how an Image data-block is used by another data-block '''

    frame_current: int = None
    '''Current frame number in image sequence or movie 

    :type: int
    '''

    frame_duration: int = None
    '''Number of images of a movie to use 

    :type: int
    '''

    frame_offset: int = None
    '''Offset the number of the frame to use in the animation 

    :type: int
    '''

    frame_start: int = None
    '''Global starting frame of the movie/sequence, assuming first picture has a #1 

    :type: int
    '''

    multilayer_layer: int = None
    '''Layer in multilayer image 

    :type: int
    '''

    multilayer_pass: int = None
    '''Pass in multilayer image 

    :type: int
    '''

    multilayer_view: int = None
    '''View in multilayer image 

    :type: int
    '''

    tile: int = None
    '''Tile in tiled image 

    :type: int
    '''

    use_auto_refresh: bool = None
    '''Always refresh image on frame changes 

    :type: bool
    '''

    use_cyclic: bool = None
    '''Cycle the images in the movie 

    :type: bool
    '''


class KeyConfig(bpy_struct):
    '''Input configuration, including keymaps '''

    is_user_defined: bool = None
    '''Indicates that a keyconfig was defined by the user 

    :type: bool
    '''

    keymaps: typing.Union[typing.List['KeyMap'], 'bpy_prop_collection',
                          'KeyMaps'] = None
    '''Key maps configured as part of this configuration 

    :type: typing.Union[typing.List['KeyMap'], 'bpy_prop_collection', 'KeyMaps']
    '''

    name: str = None
    '''Name of the key configuration 

    :type: str
    '''

    preferences: 'KeyConfigPreferences' = None
    '''

    :type: 'KeyConfigPreferences'
    '''


class KeyConfigPreferences(bpy_struct):
    bl_idname: str = None
    '''

    :type: str
    '''


class KeyConfigurations(bpy_struct):
    '''Collection of KeyConfigs '''

    active: 'KeyConfig' = None
    '''Active key configuration (preset) 

    :type: 'KeyConfig'
    '''

    addon: 'KeyConfig' = None
    '''Key configuration that can be extended by add-ons, and is added to the active configuration when handling events 

    :type: 'KeyConfig'
    '''

    default: 'KeyConfig' = None
    '''Default builtin key configuration 

    :type: 'KeyConfig'
    '''

    user: 'KeyConfig' = None
    '''Final key configuration that combines keymaps from the active and add-on configurations, and can be edited by the user 

    :type: 'KeyConfig'
    '''

    def new(self, name: str) -> 'KeyConfig':
        '''new 

        :param name: Name 
        :type name: str
        :rtype: 'KeyConfig'
        :return:  Key Configuration, Added key configuration 
        '''
        pass

    def remove(self, keyconfig: 'KeyConfig'):
        '''remove 

        :param keyconfig: Key Configuration, Removed key configuration 
        :type keyconfig: 'KeyConfig'
        '''
        pass

    def find_item_from_operator(
            self,
            idname: str,
            context: typing.Union[str, int] = 'INVOKE_DEFAULT',
            properties=None,
            include: typing.Union[typing.Set[str], typing.Set[int]] = {
                'ACTIONZONE', 'KEYBOARD', 'MOUSE', 'NDOF', 'TWEAK'
            },
            exclude: typing.Union[typing.Set[str], typing.Set[int]] = {}):
        '''find_item_from_operator 

        :param idname: Operator Identifier 
        :type idname: str
        :param context: context 
        :type context: typing.Union[str, int]
        :param include: Include 
        :type include: typing.Union[typing.Set[str], typing.Set[int]]
        :param exclude: Exclude 
        :type exclude: typing.Union[typing.Set[str], typing.Set[int]]
        '''
        pass

    def update(self, ):
        '''update 

        '''
        pass


class KeyMap(bpy_struct):
    '''Input configuration, including keymaps '''

    bl_owner_id: str = None
    '''Internal owner 

    :type: str
    '''

    is_modal: bool = None
    '''Indicates that a keymap is used for translate modal events for an operator 

    :type: bool
    '''

    is_user_modified: bool = None
    '''Keymap is defined by the user 

    :type: bool
    '''

    keymap_items: typing.Union[typing.List['KeyMapItem'],
                               'bpy_prop_collection', 'KeyMapItems'] = None
    '''Items in the keymap, linking an operator to an input event 

    :type: typing.Union[typing.List['KeyMapItem'], 'bpy_prop_collection', 'KeyMapItems']
    '''

    name: str = None
    '''Name of the key map 

    :type: str
    '''

    region_type: typing.Union[str, int] = None
    '''Optional region type keymap is associated with 

    :type: typing.Union[str, int]
    '''

    show_expanded_children: bool = None
    '''Children expanded in the user interface 

    :type: bool
    '''

    show_expanded_items: bool = None
    '''Expanded in the user interface 

    :type: bool
    '''

    space_type: typing.Union[str, int] = None
    '''Optional space type keymap is associated with 

    :type: typing.Union[str, int]
    '''

    def active(self, ) -> 'KeyMap':
        '''active 

        :rtype: 'KeyMap'
        :return:  Key Map, Active key map 
        '''
        pass

    def restore_to_default(self, ):
        '''restore_to_default 

        '''
        pass

    def restore_item_to_default(self, item: 'KeyMapItem'):
        '''restore_item_to_default 

        :param item: Item 
        :type item: 'KeyMapItem'
        '''
        pass


class KeyMapItem(bpy_struct):
    '''Item in a Key Map '''

    active: bool = None
    '''Activate or deactivate item 

    :type: bool
    '''

    alt: bool = None
    '''Alt key pressed 

    :type: bool
    '''

    any: bool = None
    '''Any modifier keys pressed 

    :type: bool
    '''

    ctrl: bool = None
    '''Control key pressed 

    :type: bool
    '''

    id: int = None
    '''ID of the item 

    :type: int
    '''

    idname: str = None
    '''Identifier of operator to call on input event 

    :type: str
    '''

    is_user_defined: bool = None
    '''Is this keymap item user defined (doesn’t just replace a builtin item) 

    :type: bool
    '''

    is_user_modified: bool = None
    '''Is this keymap item modified by the user 

    :type: bool
    '''

    key_modifier: typing.Union[str, int] = None
    '''Regular key pressed as a modifier 

    :type: typing.Union[str, int]
    '''

    map_type: typing.Union[str, int] = None
    '''Type of event mapping 

    :type: typing.Union[str, int]
    '''

    name: str = None
    '''Name of operator (translated) to call on input event 

    :type: str
    '''

    oskey: bool = None
    '''Operating system key pressed 

    :type: bool
    '''

    properties: 'OperatorProperties' = None
    '''Properties to set when the operator is called 

    :type: 'OperatorProperties'
    '''

    propvalue: typing.Union[str, int] = None
    '''The value this event translates to in a modal keymap 

    :type: typing.Union[str, int]
    '''

    shift: bool = None
    '''Shift key pressed 

    :type: bool
    '''

    show_expanded: bool = None
    '''Show key map event and property details in the user interface 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''Type of event 

    :type: typing.Union[str, int]
    '''

    value: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    def compare(self, item: 'KeyMapItem') -> bool:
        '''compare 

        :param item: Item 
        :type item: 'KeyMapItem'
        :rtype: bool
        :return:  Comparison result 
        '''
        pass

    def to_string(self, compact: bool = False) -> str:
        '''to_string 

        :param compact: Compact 
        :type compact: bool
        :rtype: str
        :return:  result 
        '''
        pass


class KeyMapItems(bpy_struct):
    '''Collection of keymap items '''

    def new(self,
            idname: str,
            type: typing.Union[str, int],
            value: typing.Union[str, int],
            any: bool = False,
            shift: bool = False,
            ctrl: bool = False,
            alt: bool = False,
            oskey: bool = False,
            key_modifier: typing.Union[str, int] = 'NONE',
            head: bool = False) -> 'KeyMapItem':
        '''new 

        :param idname: Operator Identifier 
        :type idname: str
        :param type: TypeNONE .LEFTMOUSE Left Mouse, LMB.MIDDLEMOUSE Middle Mouse, MMB.RIGHTMOUSE Right Mouse, RMB.BUTTON4MOUSE Button4 Mouse, MB4.BUTTON5MOUSE Button5 Mouse, MB5.BUTTON6MOUSE Button6 Mouse, MB6.BUTTON7MOUSE Button7 Mouse, MB7.PEN Pen.ERASER Eraser.MOUSEMOVE Mouse Move, MsMov.INBETWEEN_MOUSEMOVE In-between Move, MsSubMov.TRACKPADPAN Mouse/Trackpad Pan, MsPan.TRACKPADZOOM Mouse/Trackpad Zoom, MsZoom.MOUSEROTATE Mouse/Trackpad Rotate, MsRot.WHEELUPMOUSE Wheel Up, WhUp.WHEELDOWNMOUSE Wheel Down, WhDown.WHEELINMOUSE Wheel In, WhIn.WHEELOUTMOUSE Wheel Out, WhOut.EVT_TWEAK_L Tweak Left, TwkL.EVT_TWEAK_M Tweak Middle, TwkM.EVT_TWEAK_R Tweak Right, TwkR.A A.B B.C C.D D.E E.F F.G G.H H.I I.J J.K K.L L.M M.N N.O O.P P.Q Q.R R.S S.T T.U U.V V.W W.X X.Y Y.Z Z.ZERO 0.ONE 1.TWO 2.THREE 3.FOUR 4.FIVE 5.SIX 6.SEVEN 7.EIGHT 8.NINE 9.LEFT_CTRL Left Ctrl, CtrlL.LEFT_ALT Left Alt, AltL.LEFT_SHIFT Left Shift, ShiftL.RIGHT_ALT Right Alt, AltR.RIGHT_CTRL Right Ctrl, CtrlR.RIGHT_SHIFT Right Shift, ShiftR.OSKEY OS Key, Cmd.APP Application, App.GRLESS Grless.ESC Esc.TAB Tab.RET Return, Enter.SPACE Spacebar, Space.LINE_FEED Line Feed.BACK_SPACE Back Space, BkSpace.DEL Delete, Del.SEMI_COLON ;.PERIOD ..COMMA ,.QUOTE “.ACCENT_GRAVE `.MINUS -.PLUS +.SLASH /.BACK_SLASH .EQUAL =.LEFT_BRACKET [.RIGHT_BRACKET ].LEFT_ARROW Left Arrow, ←.DOWN_ARROW Down Arrow, ↓.RIGHT_ARROW Right Arrow, →.UP_ARROW Up Arrow, ↑.NUMPAD_2 Numpad 2, Pad2.NUMPAD_4 Numpad 4, Pad4.NUMPAD_6 Numpad 6, Pad6.NUMPAD_8 Numpad 8, Pad8.NUMPAD_1 Numpad 1, Pad1.NUMPAD_3 Numpad 3, Pad3.NUMPAD_5 Numpad 5, Pad5.NUMPAD_7 Numpad 7, Pad7.NUMPAD_9 Numpad 9, Pad9.NUMPAD_PERIOD Numpad ., Pad..NUMPAD_SLASH Numpad /, Pad/.NUMPAD_ASTERIX Numpad *, Pad*.NUMPAD_0 Numpad 0, Pad0.NUMPAD_MINUS Numpad -, Pad-.NUMPAD_ENTER Numpad Enter, PadEnter.NUMPAD_PLUS Numpad +, Pad+.F1 F1.F2 F2.F3 F3.F4 F4.F5 F5.F6 F6.F7 F7.F8 F8.F9 F9.F10 F10.F11 F11.F12 F12.F13 F13.F14 F14.F15 F15.F16 F16.F17 F17.F18 F18.F19 F19.F20 F20.F21 F21.F22 F22.F23 F23.F24 F24.PAUSE Pause.INSERT Insert, Ins.HOME Home.PAGE_UP Page Up, PgUp.PAGE_DOWN Page Down, PgDown.END End.MEDIA_PLAY Media Play/Pause, >/||.MEDIA_STOP Media Stop, Stop.MEDIA_FIRST Media First, |<<.MEDIA_LAST Media Last, >>|.TEXTINPUT Text Input, TxtIn.WINDOW_DEACTIVATE Window Deactivate.TIMER Timer, Tmr.TIMER0 Timer 0, Tmr0.TIMER1 Timer 1, Tmr1.TIMER2 Timer 2, Tmr2.TIMER_JOBS Timer Jobs, TmrJob.TIMER_AUTOSAVE Timer Autosave, TmrSave.TIMER_REPORT Timer Report, TmrReport.TIMERREGION Timer Region, TmrReg.NDOF_MOTION NDOF Motion, NdofMov.NDOF_BUTTON_MENU NDOF Menu, NdofMenu.NDOF_BUTTON_FIT NDOF Fit, NdofFit.NDOF_BUTTON_TOP NDOF Top, Ndof↑.NDOF_BUTTON_BOTTOM NDOF Bottom, Ndof↓.NDOF_BUTTON_LEFT NDOF Left, Ndof←.NDOF_BUTTON_RIGHT NDOF Right, Ndof→.NDOF_BUTTON_FRONT NDOF Front, NdofFront.NDOF_BUTTON_BACK NDOF Back, NdofBack.NDOF_BUTTON_ISO1 NDOF Isometric 1, NdofIso1.NDOF_BUTTON_ISO2 NDOF Isometric 2, NdofIso2.NDOF_BUTTON_ROLL_CW NDOF Roll CW, NdofRCW.NDOF_BUTTON_ROLL_CCW NDOF Roll CCW, NdofRCCW.NDOF_BUTTON_SPIN_CW NDOF Spin CW, NdofSCW.NDOF_BUTTON_SPIN_CCW NDOF Spin CCW, NdofSCCW.NDOF_BUTTON_TILT_CW NDOF Tilt CW, NdofTCW.NDOF_BUTTON_TILT_CCW NDOF Tilt CCW, NdofTCCW.NDOF_BUTTON_ROTATE NDOF Rotate, NdofRot.NDOF_BUTTON_PANZOOM NDOF Pan/Zoom, NdofPanZoom.NDOF_BUTTON_DOMINANT NDOF Dominant, NdofDom.NDOF_BUTTON_PLUS NDOF Plus, Ndof+.NDOF_BUTTON_MINUS NDOF Minus, Ndof-.NDOF_BUTTON_ESC NDOF Esc, NdofEsc.NDOF_BUTTON_ALT NDOF Alt, NdofAlt.NDOF_BUTTON_SHIFT NDOF Shift, NdofShift.NDOF_BUTTON_CTRL NDOF Ctrl, NdofCtrl.NDOF_BUTTON_1 NDOF Button 1, NdofB1.NDOF_BUTTON_2 NDOF Button 2, NdofB2.NDOF_BUTTON_3 NDOF Button 3, NdofB3.NDOF_BUTTON_4 NDOF Button 4, NdofB4.NDOF_BUTTON_5 NDOF Button 5, NdofB5.NDOF_BUTTON_6 NDOF Button 6, NdofB6.NDOF_BUTTON_7 NDOF Button 7, NdofB7.NDOF_BUTTON_8 NDOF Button 8, NdofB8.NDOF_BUTTON_9 NDOF Button 9, NdofB9.NDOF_BUTTON_10 NDOF Button 10, NdofB10.NDOF_BUTTON_A NDOF Button A, NdofBA.NDOF_BUTTON_B NDOF Button B, NdofBB.NDOF_BUTTON_C NDOF Button C, NdofBC.ACTIONZONE_AREA ActionZone Area, AZone Area.ACTIONZONE_REGION ActionZone Region, AZone Region.ACTIONZONE_FULLSCREEN ActionZone Fullscreen, AZone FullScr. 
        :type type: typing.Union[str, int]
        :param value: Value 
        :type value: typing.Union[str, int]
        :param any: Any 
        :type any: bool
        :param shift: Shift 
        :type shift: bool
        :param ctrl: Ctrl 
        :type ctrl: bool
        :param alt: Alt 
        :type alt: bool
        :param oskey: OS Key 
        :type oskey: bool
        :param key_modifier: Key ModifierNONE .LEFTMOUSE Left Mouse, LMB.MIDDLEMOUSE Middle Mouse, MMB.RIGHTMOUSE Right Mouse, RMB.BUTTON4MOUSE Button4 Mouse, MB4.BUTTON5MOUSE Button5 Mouse, MB5.BUTTON6MOUSE Button6 Mouse, MB6.BUTTON7MOUSE Button7 Mouse, MB7.PEN Pen.ERASER Eraser.MOUSEMOVE Mouse Move, MsMov.INBETWEEN_MOUSEMOVE In-between Move, MsSubMov.TRACKPADPAN Mouse/Trackpad Pan, MsPan.TRACKPADZOOM Mouse/Trackpad Zoom, MsZoom.MOUSEROTATE Mouse/Trackpad Rotate, MsRot.WHEELUPMOUSE Wheel Up, WhUp.WHEELDOWNMOUSE Wheel Down, WhDown.WHEELINMOUSE Wheel In, WhIn.WHEELOUTMOUSE Wheel Out, WhOut.EVT_TWEAK_L Tweak Left, TwkL.EVT_TWEAK_M Tweak Middle, TwkM.EVT_TWEAK_R Tweak Right, TwkR.A A.B B.C C.D D.E E.F F.G G.H H.I I.J J.K K.L L.M M.N N.O O.P P.Q Q.R R.S S.T T.U U.V V.W W.X X.Y Y.Z Z.ZERO 0.ONE 1.TWO 2.THREE 3.FOUR 4.FIVE 5.SIX 6.SEVEN 7.EIGHT 8.NINE 9.LEFT_CTRL Left Ctrl, CtrlL.LEFT_ALT Left Alt, AltL.LEFT_SHIFT Left Shift, ShiftL.RIGHT_ALT Right Alt, AltR.RIGHT_CTRL Right Ctrl, CtrlR.RIGHT_SHIFT Right Shift, ShiftR.OSKEY OS Key, Cmd.APP Application, App.GRLESS Grless.ESC Esc.TAB Tab.RET Return, Enter.SPACE Spacebar, Space.LINE_FEED Line Feed.BACK_SPACE Back Space, BkSpace.DEL Delete, Del.SEMI_COLON ;.PERIOD ..COMMA ,.QUOTE “.ACCENT_GRAVE `.MINUS -.PLUS +.SLASH /.BACK_SLASH .EQUAL =.LEFT_BRACKET [.RIGHT_BRACKET ].LEFT_ARROW Left Arrow, ←.DOWN_ARROW Down Arrow, ↓.RIGHT_ARROW Right Arrow, →.UP_ARROW Up Arrow, ↑.NUMPAD_2 Numpad 2, Pad2.NUMPAD_4 Numpad 4, Pad4.NUMPAD_6 Numpad 6, Pad6.NUMPAD_8 Numpad 8, Pad8.NUMPAD_1 Numpad 1, Pad1.NUMPAD_3 Numpad 3, Pad3.NUMPAD_5 Numpad 5, Pad5.NUMPAD_7 Numpad 7, Pad7.NUMPAD_9 Numpad 9, Pad9.NUMPAD_PERIOD Numpad ., Pad..NUMPAD_SLASH Numpad /, Pad/.NUMPAD_ASTERIX Numpad *, Pad*.NUMPAD_0 Numpad 0, Pad0.NUMPAD_MINUS Numpad -, Pad-.NUMPAD_ENTER Numpad Enter, PadEnter.NUMPAD_PLUS Numpad +, Pad+.F1 F1.F2 F2.F3 F3.F4 F4.F5 F5.F6 F6.F7 F7.F8 F8.F9 F9.F10 F10.F11 F11.F12 F12.F13 F13.F14 F14.F15 F15.F16 F16.F17 F17.F18 F18.F19 F19.F20 F20.F21 F21.F22 F22.F23 F23.F24 F24.PAUSE Pause.INSERT Insert, Ins.HOME Home.PAGE_UP Page Up, PgUp.PAGE_DOWN Page Down, PgDown.END End.MEDIA_PLAY Media Play/Pause, >/||.MEDIA_STOP Media Stop, Stop.MEDIA_FIRST Media First, |<<.MEDIA_LAST Media Last, >>|.TEXTINPUT Text Input, TxtIn.WINDOW_DEACTIVATE Window Deactivate.TIMER Timer, Tmr.TIMER0 Timer 0, Tmr0.TIMER1 Timer 1, Tmr1.TIMER2 Timer 2, Tmr2.TIMER_JOBS Timer Jobs, TmrJob.TIMER_AUTOSAVE Timer Autosave, TmrSave.TIMER_REPORT Timer Report, TmrReport.TIMERREGION Timer Region, TmrReg.NDOF_MOTION NDOF Motion, NdofMov.NDOF_BUTTON_MENU NDOF Menu, NdofMenu.NDOF_BUTTON_FIT NDOF Fit, NdofFit.NDOF_BUTTON_TOP NDOF Top, Ndof↑.NDOF_BUTTON_BOTTOM NDOF Bottom, Ndof↓.NDOF_BUTTON_LEFT NDOF Left, Ndof←.NDOF_BUTTON_RIGHT NDOF Right, Ndof→.NDOF_BUTTON_FRONT NDOF Front, NdofFront.NDOF_BUTTON_BACK NDOF Back, NdofBack.NDOF_BUTTON_ISO1 NDOF Isometric 1, NdofIso1.NDOF_BUTTON_ISO2 NDOF Isometric 2, NdofIso2.NDOF_BUTTON_ROLL_CW NDOF Roll CW, NdofRCW.NDOF_BUTTON_ROLL_CCW NDOF Roll CCW, NdofRCCW.NDOF_BUTTON_SPIN_CW NDOF Spin CW, NdofSCW.NDOF_BUTTON_SPIN_CCW NDOF Spin CCW, NdofSCCW.NDOF_BUTTON_TILT_CW NDOF Tilt CW, NdofTCW.NDOF_BUTTON_TILT_CCW NDOF Tilt CCW, NdofTCCW.NDOF_BUTTON_ROTATE NDOF Rotate, NdofRot.NDOF_BUTTON_PANZOOM NDOF Pan/Zoom, NdofPanZoom.NDOF_BUTTON_DOMINANT NDOF Dominant, NdofDom.NDOF_BUTTON_PLUS NDOF Plus, Ndof+.NDOF_BUTTON_MINUS NDOF Minus, Ndof-.NDOF_BUTTON_ESC NDOF Esc, NdofEsc.NDOF_BUTTON_ALT NDOF Alt, NdofAlt.NDOF_BUTTON_SHIFT NDOF Shift, NdofShift.NDOF_BUTTON_CTRL NDOF Ctrl, NdofCtrl.NDOF_BUTTON_1 NDOF Button 1, NdofB1.NDOF_BUTTON_2 NDOF Button 2, NdofB2.NDOF_BUTTON_3 NDOF Button 3, NdofB3.NDOF_BUTTON_4 NDOF Button 4, NdofB4.NDOF_BUTTON_5 NDOF Button 5, NdofB5.NDOF_BUTTON_6 NDOF Button 6, NdofB6.NDOF_BUTTON_7 NDOF Button 7, NdofB7.NDOF_BUTTON_8 NDOF Button 8, NdofB8.NDOF_BUTTON_9 NDOF Button 9, NdofB9.NDOF_BUTTON_10 NDOF Button 10, NdofB10.NDOF_BUTTON_A NDOF Button A, NdofBA.NDOF_BUTTON_B NDOF Button B, NdofBB.NDOF_BUTTON_C NDOF Button C, NdofBC.ACTIONZONE_AREA ActionZone Area, AZone Area.ACTIONZONE_REGION ActionZone Region, AZone Region.ACTIONZONE_FULLSCREEN ActionZone Fullscreen, AZone FullScr. 
        :type key_modifier: typing.Union[str, int]
        :param head: At Head, Force item to be added at start (not end) of key map so that it doesn’t get blocked by an existing key map item 
        :type head: bool
        :rtype: 'KeyMapItem'
        :return:  Item, Added key map item 
        '''
        pass

    def new_modal(
            self,
            propvalue: str,
            type: typing.Union[str, int],
            value: typing.Union[str, int],
            any: bool = False,
            shift: bool = False,
            ctrl: bool = False,
            alt: bool = False,
            oskey: bool = False,
            key_modifier: typing.Union[str, int] = 'NONE') -> 'KeyMapItem':
        '''new_modal 

        :param propvalue: Property Value 
        :type propvalue: str
        :param type: TypeNONE .LEFTMOUSE Left Mouse, LMB.MIDDLEMOUSE Middle Mouse, MMB.RIGHTMOUSE Right Mouse, RMB.BUTTON4MOUSE Button4 Mouse, MB4.BUTTON5MOUSE Button5 Mouse, MB5.BUTTON6MOUSE Button6 Mouse, MB6.BUTTON7MOUSE Button7 Mouse, MB7.PEN Pen.ERASER Eraser.MOUSEMOVE Mouse Move, MsMov.INBETWEEN_MOUSEMOVE In-between Move, MsSubMov.TRACKPADPAN Mouse/Trackpad Pan, MsPan.TRACKPADZOOM Mouse/Trackpad Zoom, MsZoom.MOUSEROTATE Mouse/Trackpad Rotate, MsRot.WHEELUPMOUSE Wheel Up, WhUp.WHEELDOWNMOUSE Wheel Down, WhDown.WHEELINMOUSE Wheel In, WhIn.WHEELOUTMOUSE Wheel Out, WhOut.EVT_TWEAK_L Tweak Left, TwkL.EVT_TWEAK_M Tweak Middle, TwkM.EVT_TWEAK_R Tweak Right, TwkR.A A.B B.C C.D D.E E.F F.G G.H H.I I.J J.K K.L L.M M.N N.O O.P P.Q Q.R R.S S.T T.U U.V V.W W.X X.Y Y.Z Z.ZERO 0.ONE 1.TWO 2.THREE 3.FOUR 4.FIVE 5.SIX 6.SEVEN 7.EIGHT 8.NINE 9.LEFT_CTRL Left Ctrl, CtrlL.LEFT_ALT Left Alt, AltL.LEFT_SHIFT Left Shift, ShiftL.RIGHT_ALT Right Alt, AltR.RIGHT_CTRL Right Ctrl, CtrlR.RIGHT_SHIFT Right Shift, ShiftR.OSKEY OS Key, Cmd.APP Application, App.GRLESS Grless.ESC Esc.TAB Tab.RET Return, Enter.SPACE Spacebar, Space.LINE_FEED Line Feed.BACK_SPACE Back Space, BkSpace.DEL Delete, Del.SEMI_COLON ;.PERIOD ..COMMA ,.QUOTE “.ACCENT_GRAVE `.MINUS -.PLUS +.SLASH /.BACK_SLASH .EQUAL =.LEFT_BRACKET [.RIGHT_BRACKET ].LEFT_ARROW Left Arrow, ←.DOWN_ARROW Down Arrow, ↓.RIGHT_ARROW Right Arrow, →.UP_ARROW Up Arrow, ↑.NUMPAD_2 Numpad 2, Pad2.NUMPAD_4 Numpad 4, Pad4.NUMPAD_6 Numpad 6, Pad6.NUMPAD_8 Numpad 8, Pad8.NUMPAD_1 Numpad 1, Pad1.NUMPAD_3 Numpad 3, Pad3.NUMPAD_5 Numpad 5, Pad5.NUMPAD_7 Numpad 7, Pad7.NUMPAD_9 Numpad 9, Pad9.NUMPAD_PERIOD Numpad ., Pad..NUMPAD_SLASH Numpad /, Pad/.NUMPAD_ASTERIX Numpad *, Pad*.NUMPAD_0 Numpad 0, Pad0.NUMPAD_MINUS Numpad -, Pad-.NUMPAD_ENTER Numpad Enter, PadEnter.NUMPAD_PLUS Numpad +, Pad+.F1 F1.F2 F2.F3 F3.F4 F4.F5 F5.F6 F6.F7 F7.F8 F8.F9 F9.F10 F10.F11 F11.F12 F12.F13 F13.F14 F14.F15 F15.F16 F16.F17 F17.F18 F18.F19 F19.F20 F20.F21 F21.F22 F22.F23 F23.F24 F24.PAUSE Pause.INSERT Insert, Ins.HOME Home.PAGE_UP Page Up, PgUp.PAGE_DOWN Page Down, PgDown.END End.MEDIA_PLAY Media Play/Pause, >/||.MEDIA_STOP Media Stop, Stop.MEDIA_FIRST Media First, |<<.MEDIA_LAST Media Last, >>|.TEXTINPUT Text Input, TxtIn.WINDOW_DEACTIVATE Window Deactivate.TIMER Timer, Tmr.TIMER0 Timer 0, Tmr0.TIMER1 Timer 1, Tmr1.TIMER2 Timer 2, Tmr2.TIMER_JOBS Timer Jobs, TmrJob.TIMER_AUTOSAVE Timer Autosave, TmrSave.TIMER_REPORT Timer Report, TmrReport.TIMERREGION Timer Region, TmrReg.NDOF_MOTION NDOF Motion, NdofMov.NDOF_BUTTON_MENU NDOF Menu, NdofMenu.NDOF_BUTTON_FIT NDOF Fit, NdofFit.NDOF_BUTTON_TOP NDOF Top, Ndof↑.NDOF_BUTTON_BOTTOM NDOF Bottom, Ndof↓.NDOF_BUTTON_LEFT NDOF Left, Ndof←.NDOF_BUTTON_RIGHT NDOF Right, Ndof→.NDOF_BUTTON_FRONT NDOF Front, NdofFront.NDOF_BUTTON_BACK NDOF Back, NdofBack.NDOF_BUTTON_ISO1 NDOF Isometric 1, NdofIso1.NDOF_BUTTON_ISO2 NDOF Isometric 2, NdofIso2.NDOF_BUTTON_ROLL_CW NDOF Roll CW, NdofRCW.NDOF_BUTTON_ROLL_CCW NDOF Roll CCW, NdofRCCW.NDOF_BUTTON_SPIN_CW NDOF Spin CW, NdofSCW.NDOF_BUTTON_SPIN_CCW NDOF Spin CCW, NdofSCCW.NDOF_BUTTON_TILT_CW NDOF Tilt CW, NdofTCW.NDOF_BUTTON_TILT_CCW NDOF Tilt CCW, NdofTCCW.NDOF_BUTTON_ROTATE NDOF Rotate, NdofRot.NDOF_BUTTON_PANZOOM NDOF Pan/Zoom, NdofPanZoom.NDOF_BUTTON_DOMINANT NDOF Dominant, NdofDom.NDOF_BUTTON_PLUS NDOF Plus, Ndof+.NDOF_BUTTON_MINUS NDOF Minus, Ndof-.NDOF_BUTTON_ESC NDOF Esc, NdofEsc.NDOF_BUTTON_ALT NDOF Alt, NdofAlt.NDOF_BUTTON_SHIFT NDOF Shift, NdofShift.NDOF_BUTTON_CTRL NDOF Ctrl, NdofCtrl.NDOF_BUTTON_1 NDOF Button 1, NdofB1.NDOF_BUTTON_2 NDOF Button 2, NdofB2.NDOF_BUTTON_3 NDOF Button 3, NdofB3.NDOF_BUTTON_4 NDOF Button 4, NdofB4.NDOF_BUTTON_5 NDOF Button 5, NdofB5.NDOF_BUTTON_6 NDOF Button 6, NdofB6.NDOF_BUTTON_7 NDOF Button 7, NdofB7.NDOF_BUTTON_8 NDOF Button 8, NdofB8.NDOF_BUTTON_9 NDOF Button 9, NdofB9.NDOF_BUTTON_10 NDOF Button 10, NdofB10.NDOF_BUTTON_A NDOF Button A, NdofBA.NDOF_BUTTON_B NDOF Button B, NdofBB.NDOF_BUTTON_C NDOF Button C, NdofBC.ACTIONZONE_AREA ActionZone Area, AZone Area.ACTIONZONE_REGION ActionZone Region, AZone Region.ACTIONZONE_FULLSCREEN ActionZone Fullscreen, AZone FullScr. 
        :type type: typing.Union[str, int]
        :param value: Value 
        :type value: typing.Union[str, int]
        :param any: Any 
        :type any: bool
        :param shift: Shift 
        :type shift: bool
        :param ctrl: Ctrl 
        :type ctrl: bool
        :param alt: Alt 
        :type alt: bool
        :param oskey: OS Key 
        :type oskey: bool
        :param key_modifier: Key ModifierNONE .LEFTMOUSE Left Mouse, LMB.MIDDLEMOUSE Middle Mouse, MMB.RIGHTMOUSE Right Mouse, RMB.BUTTON4MOUSE Button4 Mouse, MB4.BUTTON5MOUSE Button5 Mouse, MB5.BUTTON6MOUSE Button6 Mouse, MB6.BUTTON7MOUSE Button7 Mouse, MB7.PEN Pen.ERASER Eraser.MOUSEMOVE Mouse Move, MsMov.INBETWEEN_MOUSEMOVE In-between Move, MsSubMov.TRACKPADPAN Mouse/Trackpad Pan, MsPan.TRACKPADZOOM Mouse/Trackpad Zoom, MsZoom.MOUSEROTATE Mouse/Trackpad Rotate, MsRot.WHEELUPMOUSE Wheel Up, WhUp.WHEELDOWNMOUSE Wheel Down, WhDown.WHEELINMOUSE Wheel In, WhIn.WHEELOUTMOUSE Wheel Out, WhOut.EVT_TWEAK_L Tweak Left, TwkL.EVT_TWEAK_M Tweak Middle, TwkM.EVT_TWEAK_R Tweak Right, TwkR.A A.B B.C C.D D.E E.F F.G G.H H.I I.J J.K K.L L.M M.N N.O O.P P.Q Q.R R.S S.T T.U U.V V.W W.X X.Y Y.Z Z.ZERO 0.ONE 1.TWO 2.THREE 3.FOUR 4.FIVE 5.SIX 6.SEVEN 7.EIGHT 8.NINE 9.LEFT_CTRL Left Ctrl, CtrlL.LEFT_ALT Left Alt, AltL.LEFT_SHIFT Left Shift, ShiftL.RIGHT_ALT Right Alt, AltR.RIGHT_CTRL Right Ctrl, CtrlR.RIGHT_SHIFT Right Shift, ShiftR.OSKEY OS Key, Cmd.APP Application, App.GRLESS Grless.ESC Esc.TAB Tab.RET Return, Enter.SPACE Spacebar, Space.LINE_FEED Line Feed.BACK_SPACE Back Space, BkSpace.DEL Delete, Del.SEMI_COLON ;.PERIOD ..COMMA ,.QUOTE “.ACCENT_GRAVE `.MINUS -.PLUS +.SLASH /.BACK_SLASH .EQUAL =.LEFT_BRACKET [.RIGHT_BRACKET ].LEFT_ARROW Left Arrow, ←.DOWN_ARROW Down Arrow, ↓.RIGHT_ARROW Right Arrow, →.UP_ARROW Up Arrow, ↑.NUMPAD_2 Numpad 2, Pad2.NUMPAD_4 Numpad 4, Pad4.NUMPAD_6 Numpad 6, Pad6.NUMPAD_8 Numpad 8, Pad8.NUMPAD_1 Numpad 1, Pad1.NUMPAD_3 Numpad 3, Pad3.NUMPAD_5 Numpad 5, Pad5.NUMPAD_7 Numpad 7, Pad7.NUMPAD_9 Numpad 9, Pad9.NUMPAD_PERIOD Numpad ., Pad..NUMPAD_SLASH Numpad /, Pad/.NUMPAD_ASTERIX Numpad *, Pad*.NUMPAD_0 Numpad 0, Pad0.NUMPAD_MINUS Numpad -, Pad-.NUMPAD_ENTER Numpad Enter, PadEnter.NUMPAD_PLUS Numpad +, Pad+.F1 F1.F2 F2.F3 F3.F4 F4.F5 F5.F6 F6.F7 F7.F8 F8.F9 F9.F10 F10.F11 F11.F12 F12.F13 F13.F14 F14.F15 F15.F16 F16.F17 F17.F18 F18.F19 F19.F20 F20.F21 F21.F22 F22.F23 F23.F24 F24.PAUSE Pause.INSERT Insert, Ins.HOME Home.PAGE_UP Page Up, PgUp.PAGE_DOWN Page Down, PgDown.END End.MEDIA_PLAY Media Play/Pause, >/||.MEDIA_STOP Media Stop, Stop.MEDIA_FIRST Media First, |<<.MEDIA_LAST Media Last, >>|.TEXTINPUT Text Input, TxtIn.WINDOW_DEACTIVATE Window Deactivate.TIMER Timer, Tmr.TIMER0 Timer 0, Tmr0.TIMER1 Timer 1, Tmr1.TIMER2 Timer 2, Tmr2.TIMER_JOBS Timer Jobs, TmrJob.TIMER_AUTOSAVE Timer Autosave, TmrSave.TIMER_REPORT Timer Report, TmrReport.TIMERREGION Timer Region, TmrReg.NDOF_MOTION NDOF Motion, NdofMov.NDOF_BUTTON_MENU NDOF Menu, NdofMenu.NDOF_BUTTON_FIT NDOF Fit, NdofFit.NDOF_BUTTON_TOP NDOF Top, Ndof↑.NDOF_BUTTON_BOTTOM NDOF Bottom, Ndof↓.NDOF_BUTTON_LEFT NDOF Left, Ndof←.NDOF_BUTTON_RIGHT NDOF Right, Ndof→.NDOF_BUTTON_FRONT NDOF Front, NdofFront.NDOF_BUTTON_BACK NDOF Back, NdofBack.NDOF_BUTTON_ISO1 NDOF Isometric 1, NdofIso1.NDOF_BUTTON_ISO2 NDOF Isometric 2, NdofIso2.NDOF_BUTTON_ROLL_CW NDOF Roll CW, NdofRCW.NDOF_BUTTON_ROLL_CCW NDOF Roll CCW, NdofRCCW.NDOF_BUTTON_SPIN_CW NDOF Spin CW, NdofSCW.NDOF_BUTTON_SPIN_CCW NDOF Spin CCW, NdofSCCW.NDOF_BUTTON_TILT_CW NDOF Tilt CW, NdofTCW.NDOF_BUTTON_TILT_CCW NDOF Tilt CCW, NdofTCCW.NDOF_BUTTON_ROTATE NDOF Rotate, NdofRot.NDOF_BUTTON_PANZOOM NDOF Pan/Zoom, NdofPanZoom.NDOF_BUTTON_DOMINANT NDOF Dominant, NdofDom.NDOF_BUTTON_PLUS NDOF Plus, Ndof+.NDOF_BUTTON_MINUS NDOF Minus, Ndof-.NDOF_BUTTON_ESC NDOF Esc, NdofEsc.NDOF_BUTTON_ALT NDOF Alt, NdofAlt.NDOF_BUTTON_SHIFT NDOF Shift, NdofShift.NDOF_BUTTON_CTRL NDOF Ctrl, NdofCtrl.NDOF_BUTTON_1 NDOF Button 1, NdofB1.NDOF_BUTTON_2 NDOF Button 2, NdofB2.NDOF_BUTTON_3 NDOF Button 3, NdofB3.NDOF_BUTTON_4 NDOF Button 4, NdofB4.NDOF_BUTTON_5 NDOF Button 5, NdofB5.NDOF_BUTTON_6 NDOF Button 6, NdofB6.NDOF_BUTTON_7 NDOF Button 7, NdofB7.NDOF_BUTTON_8 NDOF Button 8, NdofB8.NDOF_BUTTON_9 NDOF Button 9, NdofB9.NDOF_BUTTON_10 NDOF Button 10, NdofB10.NDOF_BUTTON_A NDOF Button A, NdofBA.NDOF_BUTTON_B NDOF Button B, NdofBB.NDOF_BUTTON_C NDOF Button C, NdofBC.ACTIONZONE_AREA ActionZone Area, AZone Area.ACTIONZONE_REGION ActionZone Region, AZone Region.ACTIONZONE_FULLSCREEN ActionZone Fullscreen, AZone FullScr. 
        :type key_modifier: typing.Union[str, int]
        :rtype: 'KeyMapItem'
        :return:  Item, Added key map item 
        '''
        pass

    def new_from_item(self, item: 'KeyMapItem',
                      head: bool = False) -> 'KeyMapItem':
        '''new_from_item 

        :param item: Item, Item to use as a reference 
        :type item: 'KeyMapItem'
        :param head: At Head 
        :type head: bool
        :rtype: 'KeyMapItem'
        :return:  Item, Added key map item 
        '''
        pass

    def remove(self, item: 'KeyMapItem'):
        '''remove 

        :param item: Item 
        :type item: 'KeyMapItem'
        '''
        pass

    def from_id(self, id: int) -> 'KeyMapItem':
        '''from_id 

        :param id: id, ID of the item 
        :type id: int
        :rtype: 'KeyMapItem'
        :return:  Item 
        '''
        pass

    def find_from_operator(
            self,
            idname: str,
            properties=None,
            include: typing.Union[typing.Set[str], typing.Set[int]] = {
                'ACTIONZONE', 'KEYBOARD', 'MOUSE', 'NDOF', 'TWEAK'
            },
            exclude: typing.Union[typing.Set[str], typing.Set[int]] = {}
    ) -> 'KeyMapItem':
        '''find_from_operator 

        :param idname: Operator Identifier 
        :type idname: str
        :param include: Include 
        :type include: typing.Union[typing.Set[str], typing.Set[int]]
        :param exclude: Exclude 
        :type exclude: typing.Union[typing.Set[str], typing.Set[int]]
        :rtype: 'KeyMapItem'
        '''
        pass

    def match_event(self, event) -> 'KeyMapItem':
        '''match_event 

        :rtype: 'KeyMapItem'
        '''
        pass


class KeyMaps(bpy_struct):
    '''Collection of keymaps '''

    def new(self,
            name: str,
            space_type: typing.Union[str, int] = 'EMPTY',
            region_type: typing.Union[str, int] = 'WINDOW',
            modal: bool = False,
            tool: bool = False) -> 'KeyMap':
        '''new 

        :param name: Name 
        :type name: str
        :param space_type: Space TypeEMPTY Empty.VIEW_3D 3D Viewport, Manipulate objects in a 3D environment.IMAGE_EDITOR UV/Image Editor, View and edit images and UV Maps.NODE_EDITOR Node Editor, Editor for node-based shading and compositing tools.SEQUENCE_EDITOR Video Sequencer, Video editing tools.CLIP_EDITOR Movie Clip Editor, Motion tracking tools.DOPESHEET_EDITOR Dope Sheet, Adjust timing of keyframes.GRAPH_EDITOR Graph Editor, Edit drivers and keyframe interpolation.NLA_EDITOR Nonlinear Animation, Combine and layer Actions.TEXT_EDITOR Text Editor, Edit scripts and in-file documentation.CONSOLE Python Console, Interactive programmatic console for advanced editing and script development.INFO Info, Log of operations, warnings and error messages.TOPBAR Top Bar, Global bar at the top of the screen for global per-window settings.STATUSBAR Status Bar, Global bar at the bottom of the screen for general status information.OUTLINER Outliner, Overview of scene graph and all available data-blocks.PROPERTIES Properties, Edit properties of active object and related data-blocks.FILE_BROWSER File Browser, Browse for files and assets.PREFERENCES Preferences, Edit persistent configuration settings. 
        :type space_type: typing.Union[str, int]
        :param region_type: Region Type 
        :type region_type: typing.Union[str, int]
        :param modal: Modal, Keymap for modal operators 
        :type modal: bool
        :param tool: Tool, Keymap for active tools 
        :type tool: bool
        :rtype: 'KeyMap'
        :return:  Key Map, Added key map 
        '''
        pass

    def remove(self, keymap: 'KeyMap'):
        '''remove 

        :param keymap: Key Map, Removed key map 
        :type keymap: 'KeyMap'
        '''
        pass

    def find(self,
             name: str,
             space_type: typing.Union[str, int] = 'EMPTY',
             region_type: typing.Union[str, int] = 'WINDOW') -> 'KeyMap':
        '''find 

        :param name: Name 
        :type name: str
        :param space_type: Space TypeEMPTY Empty.VIEW_3D 3D Viewport, Manipulate objects in a 3D environment.IMAGE_EDITOR UV/Image Editor, View and edit images and UV Maps.NODE_EDITOR Node Editor, Editor for node-based shading and compositing tools.SEQUENCE_EDITOR Video Sequencer, Video editing tools.CLIP_EDITOR Movie Clip Editor, Motion tracking tools.DOPESHEET_EDITOR Dope Sheet, Adjust timing of keyframes.GRAPH_EDITOR Graph Editor, Edit drivers and keyframe interpolation.NLA_EDITOR Nonlinear Animation, Combine and layer Actions.TEXT_EDITOR Text Editor, Edit scripts and in-file documentation.CONSOLE Python Console, Interactive programmatic console for advanced editing and script development.INFO Info, Log of operations, warnings and error messages.TOPBAR Top Bar, Global bar at the top of the screen for global per-window settings.STATUSBAR Status Bar, Global bar at the bottom of the screen for general status information.OUTLINER Outliner, Overview of scene graph and all available data-blocks.PROPERTIES Properties, Edit properties of active object and related data-blocks.FILE_BROWSER File Browser, Browse for files and assets.PREFERENCES Preferences, Edit persistent configuration settings. 
        :type space_type: typing.Union[str, int]
        :param region_type: Region Type 
        :type region_type: typing.Union[str, int]
        :rtype: 'KeyMap'
        :return:  Key Map, Corresponding key map 
        '''
        pass

    def find_modal(self, name: str) -> 'KeyMap':
        '''find_modal 

        :param name: Operator Name 
        :type name: str
        :rtype: 'KeyMap'
        :return:  Key Map, Corresponding key map 
        '''
        pass


class Keyframe(bpy_struct):
    '''Bezier curve point with two handles defining a Keyframe on an F-Curve '''

    amplitude: float = None
    '''Amount to boost elastic bounces for ‘elastic’ easing 

    :type: float
    '''

    back: float = None
    '''Amount of overshoot for ‘back’ easing 

    :type: float
    '''

    co: typing.List[float] = None
    '''Coordinates of the control point 

    :type: typing.List[float]
    '''

    easing: typing.Union[str, int] = None
    '''Which ends of the segment between this and the next keyframe easing interpolation is applied to 

    :type: typing.Union[str, int]
    '''

    handle_left: typing.List[float] = None
    '''Coordinates of the left handle (before the control point) 

    :type: typing.List[float]
    '''

    handle_left_type: typing.Union[str, int] = None
    '''Handle types 

    :type: typing.Union[str, int]
    '''

    handle_right: typing.List[float] = None
    '''Coordinates of the right handle (after the control point) 

    :type: typing.List[float]
    '''

    handle_right_type: typing.Union[str, int] = None
    '''Handle types 

    :type: typing.Union[str, int]
    '''

    interpolation: typing.Union[str, int] = None
    '''Interpolation method to use for segment of the F-Curve from this Keyframe until the next Keyframe 

    :type: typing.Union[str, int]
    '''

    period: float = None
    '''Time between bounces for elastic easing 

    :type: float
    '''

    select_control_point: bool = None
    '''Control point selection status 

    :type: bool
    '''

    select_left_handle: bool = None
    '''Left handle selection status 

    :type: bool
    '''

    select_right_handle: bool = None
    '''Right handle selection status 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''Type of keyframe (for visual purposes only) 

    :type: typing.Union[str, int]
    '''


class KeyingSet(bpy_struct):
    '''Settings that should be keyframed together '''

    bl_description: str = None
    '''A short description of the keying set 

    :type: str
    '''

    bl_idname: str = None
    '''If this is set, the Keying Set gets a custom ID, otherwise it takes the name of the class used to define the Keying Set (for example, if the class name is “BUILTIN_KSI_location”, and bl_idname is not set by the script, then bl_idname = “BUILTIN_KSI_location”) 

    :type: str
    '''

    bl_label: str = None
    '''

    :type: str
    '''

    is_path_absolute: bool = None
    '''Keying Set defines specific paths/settings to be keyframed (i.e. is not reliant on context info) 

    :type: bool
    '''

    paths: typing.Union[typing.List['KeyingSetPath'], 'bpy_prop_collection',
                        'KeyingSetPaths'] = None
    '''Keying Set Paths to define settings that get keyframed together 

    :type: typing.Union[typing.List['KeyingSetPath'], 'bpy_prop_collection', 'KeyingSetPaths']
    '''

    type_info: 'KeyingSetInfo' = None
    '''Callback function defines for built-in Keying Sets 

    :type: 'KeyingSetInfo'
    '''

    use_insertkey_needed: bool = None
    '''Only insert keyframes where they’re needed in the relevant F-Curves 

    :type: bool
    '''

    use_insertkey_override_needed: bool = None
    '''Override default setting to only insert keyframes where they’re needed in the relevant F-Curves 

    :type: bool
    '''

    use_insertkey_override_visual: bool = None
    '''Override default setting to insert keyframes based on ‘visual transforms’ 

    :type: bool
    '''

    use_insertkey_override_xyz_to_rgb: bool = None
    '''Override default setting to set color for newly added transformation F-Curves (Location, Rotation, Scale) to be based on the transform axis 

    :type: bool
    '''

    use_insertkey_visual: bool = None
    '''Insert keyframes based on ‘visual transforms’ 

    :type: bool
    '''

    use_insertkey_xyz_to_rgb: bool = None
    '''Color for newly added transformation F-Curves (Location, Rotation, Scale) is based on the transform axis 

    :type: bool
    '''

    def refresh(self, ):
        '''Refresh Keying Set to ensure that it is valid for the current context (call before each use of one) 

        '''
        pass


class KeyingSetInfo(bpy_struct):
    '''Callback function defines for builtin Keying Sets '''

    bl_description: str = None
    '''A short description of the keying set 

    :type: str
    '''

    bl_idname: str = None
    '''If this is set, the Keying Set gets a custom ID, otherwise it takes the name of the class used to define the Keying Set (for example, if the class name is “BUILTIN_KSI_location”, and bl_idname is not set by the script, then bl_idname = “BUILTIN_KSI_location”) 

    :type: str
    '''

    bl_label: str = None
    '''

    :type: str
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Keying Set options to use when inserting keyframes 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    def poll(self, context) -> bool:
        '''Test if Keying Set can be used or not 

        :rtype: bool
        '''
        pass

    def iterator(self, context, ks):
        '''Call generate() on the structs which have properties to be keyframed 

        '''
        pass

    def generate(self, context, ks, data):
        '''Add Paths to the Keying Set to keyframe the properties of the given data 

        '''
        pass


class KeyingSetPath(bpy_struct):
    '''Path to a setting for use in a Keying Set '''

    array_index: int = None
    '''Index to the specific setting if applicable 

    :type: int
    '''

    data_path: str = None
    '''Path to property setting 

    :type: str
    '''

    group: str = None
    '''Name of Action Group to assign setting(s) for this path to 

    :type: str
    '''

    group_method: typing.Union[str, int] = None
    '''Method used to define which Group-name to use 

    :type: typing.Union[str, int]
    '''

    id: 'ID' = None
    '''ID-Block that keyframes for Keying Set should be added to (for Absolute Keying Sets only) 

    :type: 'ID'
    '''

    id_type: typing.Union[str, int] = None
    '''Type of ID-block that can be used 

    :type: typing.Union[str, int]
    '''

    use_entire_array: bool = None
    '''When an ‘array/vector’ type is chosen (Location, Rotation, Color, etc.), entire array is to be used 

    :type: bool
    '''

    use_insertkey_needed: bool = None
    '''Only insert keyframes where they’re needed in the relevant F-Curves 

    :type: bool
    '''

    use_insertkey_override_needed: bool = None
    '''Override default setting to only insert keyframes where they’re needed in the relevant F-Curves 

    :type: bool
    '''

    use_insertkey_override_visual: bool = None
    '''Override default setting to insert keyframes based on ‘visual transforms’ 

    :type: bool
    '''

    use_insertkey_override_xyz_to_rgb: bool = None
    '''Override default setting to set color for newly added transformation F-Curves (Location, Rotation, Scale) to be based on the transform axis 

    :type: bool
    '''

    use_insertkey_visual: bool = None
    '''Insert keyframes based on ‘visual transforms’ 

    :type: bool
    '''

    use_insertkey_xyz_to_rgb: bool = None
    '''Color for newly added transformation F-Curves (Location, Rotation, Scale) is based on the transform axis 

    :type: bool
    '''


class KeyingSetPaths(bpy_struct):
    '''Collection of keying set paths '''

    active: 'KeyingSetPath' = None
    '''Active Keying Set used to insert/delete keyframes 

    :type: 'KeyingSetPath'
    '''

    active_index: int = None
    '''Current Keying Set index 

    :type: int
    '''

    def add(self,
            target_id: 'ID',
            data_path: str,
            index: int = -1,
            group_method: typing.Union[str, int] = 'KEYINGSET',
            group_name: str = "") -> 'KeyingSetPath':
        '''Add a new path for the Keying Set 

        :param target_id: Target ID, ID data-block for the destination 
        :type target_id: 'ID'
        :param data_path: Data-Path, RNA-Path to destination property 
        :type data_path: str
        :param index: Index, The index of the destination property (i.e. axis of Location/Rotation/etc.), or -1 for the entire array 
        :type index: int
        :param group_method: Grouping Method, Method used to define which Group-name to use 
        :type group_method: typing.Union[str, int]
        :param group_name: Group Name, Name of Action Group to assign destination to (only if grouping mode is to use this name) 
        :type group_name: str
        :rtype: 'KeyingSetPath'
        :return:  New Path, Path created and added to the Keying Set 
        '''
        pass

    def remove(self, path: 'KeyingSetPath'):
        '''Remove the given path from the Keying Set 

        :param path: Path 
        :type path: 'KeyingSetPath'
        '''
        pass

    def clear(self, ):
        '''Remove all the paths from the Keying Set 

        '''
        pass


class KeyingSets(bpy_struct):
    '''Scene keying sets '''

    active: 'KeyingSet' = None
    '''Active Keying Set used to insert/delete keyframes 

    :type: 'KeyingSet'
    '''

    active_index: int = None
    '''Current Keying Set index (negative for ‘builtin’ and positive for ‘absolute’) 

    :type: int
    '''

    def new(self, idname: str = "KeyingSet",
            name: str = "KeyingSet") -> 'KeyingSet':
        '''Add a new Keying Set to Scene 

        :param idname: IDName, Internal identifier of Keying Set 
        :type idname: str
        :param name: Name, User visible name of Keying Set 
        :type name: str
        :rtype: 'KeyingSet'
        :return:  Newly created Keying Set 
        '''
        pass


class KeyingSetsAll(bpy_struct):
    '''All available keying sets '''

    active: 'KeyingSet' = None
    '''Active Keying Set used to insert/delete keyframes 

    :type: 'KeyingSet'
    '''

    active_index: int = None
    '''Current Keying Set index (negative for ‘builtin’ and positive for ‘absolute’) 

    :type: int
    '''


class LatticePoint(bpy_struct):
    '''Point in the lattice grid '''

    co: typing.List[float] = None
    '''Original undeformed location used to calculate the strength of the deform effect (edit/animate the Deformed Location instead) 

    :type: typing.List[float]
    '''

    co_deform: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    groups: typing.Union[typing.List['VertexGroupElement'],
                         'bpy_prop_collection'] = None
    '''Weights for the vertex groups this point is member of 

    :type: typing.Union[typing.List['VertexGroupElement'], 'bpy_prop_collection']
    '''

    select: bool = None
    '''Selection status 

    :type: bool
    '''

    weight_softbody: float = None
    '''Softbody goal weight 

    :type: float
    '''


class LayerCollection(bpy_struct):
    '''Layer collection '''

    children: typing.Union[typing.List['LayerCollection'],
                           'bpy_prop_collection'] = None
    '''Child layer collections 

    :type: typing.Union[typing.List['LayerCollection'], 'bpy_prop_collection']
    '''

    collection: 'Collection' = None
    '''Collection this layer collection is wrapping 

    :type: 'Collection'
    '''

    exclude: bool = None
    '''Exclude from view layer 

    :type: bool
    '''

    hide_viewport: bool = None
    '''Temporarily hide in viewport 

    :type: bool
    '''

    holdout: bool = None
    '''Mask out objects in collection from view layer 

    :type: bool
    '''

    indirect_only: bool = None
    '''Objects in collection only contribute indirectly (through shadows and reflections) in the view layer 

    :type: bool
    '''

    is_visible: bool = None
    '''Whether this collection is visible for the viewlayer, take into account the collection parent 

    :type: bool
    '''

    name: str = None
    '''Name of this view layer (same as its collection one) 

    :type: str
    '''

    def visible_get(self, ) -> bool:
        '''Whether this collection is visible, take into account the collection parent and the viewport 

        :rtype: bool
        '''
        pass

    def has_objects(self, ) -> bool:
        '''

        :rtype: bool
        '''
        pass

    def has_selected_objects(self, view_layer: 'ViewLayer') -> bool:
        '''

        :param view_layer: ViewLayer the layer collection belongs to 
        :type view_layer: 'ViewLayer'
        :rtype: bool
        '''
        pass


class LayerObjects(bpy_struct):
    '''Collections of objects '''

    active: 'Object' = None
    '''Active object for this layer 

    :type: 'Object'
    '''

    selected: typing.Union[typing.List['Object'], 'bpy_prop_collection'] = None
    '''All the selected objects of this layer 

    :type: typing.Union[typing.List['Object'], 'bpy_prop_collection']
    '''


class LineStyleAlphaModifiers(bpy_struct):
    '''Alpha modifiers for changing line alphas '''

    def new(self, name: str,
            type: typing.Union[str, int]) -> 'LineStyleAlphaModifier':
        '''Add a alpha modifier to line style 

        :param name: New name for the alpha modifier (not unique) 
        :type name: str
        :param type: Alpha modifier type to add 
        :type type: typing.Union[str, int]
        :rtype: 'LineStyleAlphaModifier'
        :return:  Newly added alpha modifier 
        '''
        pass

    def remove(self, modifier: 'LineStyleAlphaModifier'):
        '''Remove a alpha modifier from line style 

        :param modifier: Alpha modifier to remove 
        :type modifier: 'LineStyleAlphaModifier'
        '''
        pass


class LineStyleColorModifiers(bpy_struct):
    '''Color modifiers for changing line colors '''

    def new(self, name: str,
            type: typing.Union[str, int]) -> 'LineStyleColorModifier':
        '''Add a color modifier to line style 

        :param name: New name for the color modifier (not unique) 
        :type name: str
        :param type: Color modifier type to add 
        :type type: typing.Union[str, int]
        :rtype: 'LineStyleColorModifier'
        :return:  Newly added color modifier 
        '''
        pass

    def remove(self, modifier: 'LineStyleColorModifier'):
        '''Remove a color modifier from line style 

        :param modifier: Color modifier to remove 
        :type modifier: 'LineStyleColorModifier'
        '''
        pass


class LineStyleGeometryModifiers(bpy_struct):
    '''Geometry modifiers for changing line geometries '''

    def new(self, name: str,
            type: typing.Union[str, int]) -> 'LineStyleGeometryModifier':
        '''Add a geometry modifier to line style 

        :param name: New name for the geometry modifier (not unique) 
        :type name: str
        :param type: Geometry modifier type to add 
        :type type: typing.Union[str, int]
        :rtype: 'LineStyleGeometryModifier'
        :return:  Newly added geometry modifier 
        '''
        pass

    def remove(self, modifier: 'LineStyleGeometryModifier'):
        '''Remove a geometry modifier from line style 

        :param modifier: Geometry modifier to remove 
        :type modifier: 'LineStyleGeometryModifier'
        '''
        pass


class LineStyleModifier(bpy_struct):
    '''Base type to define modifiers '''

    pass


class LineStyleTextureSlots(bpy_struct):
    '''Collection of texture slots '''

    pass


class LineStyleThicknessModifiers(bpy_struct):
    '''Thickness modifiers for changing line thickness '''

    def new(self, name: str,
            type: typing.Union[str, int]) -> 'LineStyleThicknessModifier':
        '''Add a thickness modifier to line style 

        :param name: New name for the thickness modifier (not unique) 
        :type name: str
        :param type: Thickness modifier type to add 
        :type type: typing.Union[str, int]
        :rtype: 'LineStyleThicknessModifier'
        :return:  Newly added thickness modifier 
        '''
        pass

    def remove(self, modifier: 'LineStyleThicknessModifier'):
        '''Remove a thickness modifier from line style 

        :param modifier: Thickness modifier to remove 
        :type modifier: 'LineStyleThicknessModifier'
        '''
        pass


class Linesets(bpy_struct):
    '''Line sets for associating lines and style parameters '''

    active: 'FreestyleLineSet' = None
    '''Active line set being displayed 

    :type: 'FreestyleLineSet'
    '''

    active_index: int = None
    '''Index of active line set slot 

    :type: int
    '''

    def new(self, name: str) -> 'FreestyleLineSet':
        '''Add a line set to scene render layer Freestyle settings 

        :param name: New name for the line set (not unique) 
        :type name: str
        :rtype: 'FreestyleLineSet'
        :return:  Newly created line set 
        '''
        pass

    def remove(self, lineset: 'FreestyleLineSet'):
        '''Remove a line set from scene render layer Freestyle settings 

        :param lineset: Line set to remove 
        :type lineset: 'FreestyleLineSet'
        '''
        pass


class LoopColors(bpy_struct):
    '''Collection of vertex colors '''

    active: 'MeshLoopColorLayer' = None
    '''Active vertex color layer 

    :type: 'MeshLoopColorLayer'
    '''

    active_index: int = None
    '''Active vertex color index 

    :type: int
    '''

    def new(self, name: str = "Col",
            do_init: bool = True) -> 'MeshLoopColorLayer':
        '''Add a vertex color layer to Mesh 

        :param name: Vertex color name 
        :type name: str
        :param do_init: Whether new layer’s data should be initialized by copying current active one 
        :type do_init: bool
        :rtype: 'MeshLoopColorLayer'
        :return:  The newly created layer 
        '''
        pass

    def remove(self, layer: 'MeshLoopColorLayer'):
        '''Remove a vertex color layer 

        :param layer: The layer to remove 
        :type layer: 'MeshLoopColorLayer'
        '''
        pass


class Macro(bpy_struct):
    '''Storage of a macro operator being executed, or registered after execution '''

    bl_description: str = None
    '''

    :type: str
    '''

    bl_idname: str = None
    '''

    :type: str
    '''

    bl_label: str = None
    '''

    :type: str
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Options for this operator type 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_translation_context: str = None
    '''

    :type: str
    '''

    bl_undo_group: str = None
    '''

    :type: str
    '''

    name: str = None
    '''

    :type: str
    '''

    properties: 'OperatorProperties' = None
    '''

    :type: 'OperatorProperties'
    '''

    def report(self, type: typing.Union[typing.Set[str], typing.Set[int]],
               message: str):
        '''report 

        :param type: Type 
        :type type: typing.Union[typing.Set[str], typing.Set[int]]
        :param message: Report Message 
        :type message: str
        '''
        pass

    def draw(self, context):
        '''Draw function for the operator 

        '''
        pass


class MaskLayer(bpy_struct):
    '''Single layer used for masking pixels '''

    alpha: float = None
    '''Render Opacity 

    :type: float
    '''

    blend: typing.Union[str, int] = None
    '''Method of blending mask layers 

    :type: typing.Union[str, int]
    '''

    falloff: typing.Union[str, int] = None
    '''Falloff type the feather 

    :type: typing.Union[str, int]
    '''

    hide: bool = None
    '''Restrict visibility in the viewport 

    :type: bool
    '''

    hide_render: bool = None
    '''Restrict renderability 

    :type: bool
    '''

    hide_select: bool = None
    '''Restrict selection in the viewport 

    :type: bool
    '''

    invert: bool = None
    '''Invert the mask black/white 

    :type: bool
    '''

    name: str = None
    '''Unique name of layer 

    :type: str
    '''

    select: bool = None
    '''Layer is selected for editing in the Dope Sheet 

    :type: bool
    '''

    splines: typing.Union[typing.List['MaskSpline'], 'bpy_prop_collection',
                          'MaskSplines'] = None
    '''Collection of splines which defines this layer 

    :type: typing.Union[typing.List['MaskSpline'], 'bpy_prop_collection', 'MaskSplines']
    '''

    use_fill_holes: bool = None
    '''Calculate holes when filling overlapping curves 

    :type: bool
    '''

    use_fill_overlap: bool = None
    '''Calculate self intersections and overlap before filling 

    :type: bool
    '''


class MaskLayers(bpy_struct):
    '''Collection of layers used by mask '''

    active: 'MaskLayer' = None
    '''Active layer in this mask 

    :type: 'MaskLayer'
    '''

    def new(self, name: str = "") -> 'MaskLayer':
        '''Add layer to this mask 

        :param name: Name, Name of new layer 
        :type name: str
        :rtype: 'MaskLayer'
        :return:  New mask layer 
        '''
        pass

    def remove(self, layer: 'MaskLayer'):
        '''Remove layer from this mask 

        :param layer: Shape to be removed 
        :type layer: 'MaskLayer'
        '''
        pass

    def clear(self, ):
        '''Remove all mask layers 

        '''
        pass


class MaskParent(bpy_struct):
    '''Parenting settings for masking element '''

    id: 'ID' = None
    '''ID-block to which masking element would be parented to or to it’s property 

    :type: 'ID'
    '''

    id_type: typing.Union[str, int] = None
    '''Type of ID-block that can be used 

    :type: typing.Union[str, int]
    '''

    parent: str = None
    '''Name of parent object in specified data-block to which parenting happens 

    :type: str
    '''

    sub_parent: str = None
    '''Name of parent sub-object in specified data-block to which parenting happens 

    :type: str
    '''

    type: typing.Union[str, int] = None
    '''Parent Type 

    :type: typing.Union[str, int]
    '''


class MaskSpline(bpy_struct):
    '''Single spline used for defining mask shape '''

    offset_mode: typing.Union[str, int] = None
    '''The method used for calculating the feather offset 

    :type: typing.Union[str, int]
    '''

    points: typing.Union[typing.List['MaskSplinePoint'], 'bpy_prop_collection',
                         'MaskSplinePoints'] = None
    '''Collection of points 

    :type: typing.Union[typing.List['MaskSplinePoint'], 'bpy_prop_collection', 'MaskSplinePoints']
    '''

    use_cyclic: bool = None
    '''Make this spline a closed loop 

    :type: bool
    '''

    use_fill: bool = None
    '''Make this spline filled 

    :type: bool
    '''

    use_self_intersection_check: bool = None
    '''Prevent feather from self-intersections 

    :type: bool
    '''

    weight_interpolation: typing.Union[str, int] = None
    '''The type of weight interpolation for spline 

    :type: typing.Union[str, int]
    '''


class MaskSplinePoint(bpy_struct):
    '''Single point in spline used for defining mask '''

    co: typing.List[float] = None
    '''Coordinates of the control point 

    :type: typing.List[float]
    '''

    feather_points: typing.Union[typing.List['MaskSplinePointUW'],
                                 'bpy_prop_collection'] = None
    '''Points defining feather 

    :type: typing.Union[typing.List['MaskSplinePointUW'], 'bpy_prop_collection']
    '''

    handle_left: typing.List[float] = None
    '''Coordinates of the first handle 

    :type: typing.List[float]
    '''

    handle_left_type: typing.Union[str, int] = None
    '''Handle type 

    :type: typing.Union[str, int]
    '''

    handle_right: typing.List[float] = None
    '''Coordinates of the second handle 

    :type: typing.List[float]
    '''

    handle_right_type: typing.Union[str, int] = None
    '''Handle type 

    :type: typing.Union[str, int]
    '''

    handle_type: typing.Union[str, int] = None
    '''Handle type 

    :type: typing.Union[str, int]
    '''

    parent: 'MaskParent' = None
    '''

    :type: 'MaskParent'
    '''

    select: bool = None
    '''Selection status 

    :type: bool
    '''

    weight: float = None
    '''Weight of the point 

    :type: float
    '''


class MaskSplinePointUW(bpy_struct):
    '''Single point in spline segment defining feather '''

    select: bool = None
    '''Selection status 

    :type: bool
    '''

    u: float = None
    '''U coordinate of point along spline segment 

    :type: float
    '''

    weight: float = None
    '''Weight of feather point 

    :type: float
    '''


class MaskSplinePoints(bpy_struct):
    '''Collection of masking spline points '''

    def add(self, count: int):
        '''Add a number of point to this spline 

        :param count: Number, Number of points to add to the spline 
        :type count: int
        '''
        pass

    def remove(self, point: 'MaskSplinePoint'):
        '''Remove a point from a spline 

        :param point: The point to remove 
        :type point: 'MaskSplinePoint'
        '''
        pass


class MaskSplines(bpy_struct):
    '''Collection of masking splines '''

    active: 'MaskSpline' = None
    '''Active spline of masking layer 

    :type: 'MaskSpline'
    '''

    active_point: 'MaskSplinePoint' = None
    '''Active spline of masking layer 

    :type: 'MaskSplinePoint'
    '''

    def new(self, ) -> 'MaskSpline':
        '''Add a new spline to the layer 

        :rtype: 'MaskSpline'
        :return:  The newly created spline 
        '''
        pass

    def remove(self, spline: 'MaskSpline'):
        '''Remove a spline from a layer 

        :param spline: The spline to remove 
        :type spline: 'MaskSpline'
        '''
        pass


class MaterialGPencilStyle(bpy_struct):
    alignment_mode: typing.Union[str, int] = None
    '''Defines how align Dots and Boxes with drawing path and object rotation 

    :type: typing.Union[str, int]
    '''

    color: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    fill_color: typing.List[float] = None
    '''Color for filling region bounded by each stroke 

    :type: typing.List[float]
    '''

    fill_image: 'Image' = None
    '''

    :type: 'Image'
    '''

    fill_style: typing.Union[str, int] = None
    '''Select style used to fill strokes 

    :type: typing.Union[str, int]
    '''

    flip: bool = None
    '''Flip filling colors 

    :type: bool
    '''

    ghost: bool = None
    '''Display strokes using this color when showing onion skins 

    :type: bool
    '''

    gradient_type: typing.Union[str, int] = None
    '''Select type of gradient used to fill strokes 

    :type: typing.Union[str, int]
    '''

    hide: bool = None
    '''Set color Visibility 

    :type: bool
    '''

    is_fill_visible: bool = None
    '''True when opacity of fill is set high enough to be visible 

    :type: bool
    '''

    is_stroke_visible: bool = None
    '''True when opacity of stroke is set high enough to be visible 

    :type: bool
    '''

    lock: bool = None
    '''Protect color from further editing and/or frame changes 

    :type: bool
    '''

    mix_color: typing.List[float] = None
    '''Color for mixing with primary filling color 

    :type: typing.List[float]
    '''

    mix_factor: float = None
    '''Mix Adjustment Factor 

    :type: float
    '''

    mix_stroke_factor: float = None
    '''Mix Stroke Color 

    :type: float
    '''

    mode: typing.Union[str, int] = None
    '''Select draw mode for stroke 

    :type: typing.Union[str, int]
    '''

    pass_index: int = None
    '''Index number for the “Color Index” pass 

    :type: int
    '''

    pattern_angle: float = None
    '''Pattern Orientation Angle 

    :type: float
    '''

    pattern_gridsize: float = None
    '''Box Size 

    :type: float
    '''

    pattern_radius: float = None
    '''Pattern Radius 

    :type: float
    '''

    pattern_scale: typing.List[float] = None
    '''Scale Factor for UV coordinates 

    :type: typing.List[float]
    '''

    pattern_shift: typing.List[float] = None
    '''Shift filling pattern in 2d space 

    :type: typing.List[float]
    '''

    pixel_size: float = None
    '''Texture Pixel Size factor along the stroke 

    :type: float
    '''

    show_fill: bool = None
    '''Show stroke fills of this material 

    :type: bool
    '''

    show_stroke: bool = None
    '''Show stroke lines of this material 

    :type: bool
    '''

    stroke_image: 'Image' = None
    '''

    :type: 'Image'
    '''

    stroke_style: typing.Union[str, int] = None
    '''Select style used to draw strokes 

    :type: typing.Union[str, int]
    '''

    texture_angle: float = None
    '''Texture Orientation Angle 

    :type: float
    '''

    texture_clamp: bool = None
    '''Do not repeat texture and clamp to one instance only 

    :type: bool
    '''

    texture_offset: typing.List[float] = None
    '''Shift Texture in 2d Space 

    :type: typing.List[float]
    '''

    texture_opacity: float = None
    '''Texture Opacity 

    :type: float
    '''

    texture_scale: typing.List[float] = None
    '''Scale Factor for Texture 

    :type: typing.List[float]
    '''

    use_fill_pattern: bool = None
    '''Use Fill Texture as a pattern to apply color 

    :type: bool
    '''

    use_fill_texture_mix: bool = None
    '''Mix texture image with filling color 

    :type: bool
    '''

    use_overlap_strokes: bool = None
    '''Disable stencil and overlap self intersections with alpha materials 

    :type: bool
    '''

    use_stroke_pattern: bool = None
    '''Use Stroke Texture as a pattern to apply color 

    :type: bool
    '''

    use_stroke_texture_mix: bool = None
    '''Mix texture image with stroke color 

    :type: bool
    '''


class MaterialSlot(bpy_struct):
    '''Material slot in an object '''

    link: typing.Union[str, int] = None
    '''Link material to object or the object’s data 

    :type: typing.Union[str, int]
    '''

    material: 'Material' = None
    '''Material data-block used by this material slot 

    :type: 'Material'
    '''

    name: str = None
    '''Material slot name 

    :type: str
    '''


class Menu(bpy_struct):
    '''Editor menu containing buttons '''

    bl_description: str = None
    '''

    :type: str
    '''

    bl_idname: str = None
    '''If this is set, the menu gets a custom ID, otherwise it takes the name of the class used to define the menu (for example, if the class name is “OBJECT_MT_hello”, and bl_idname is not set by the script, then bl_idname = “OBJECT_MT_hello”) 

    :type: str
    '''

    bl_label: str = None
    '''The menu label 

    :type: str
    '''

    bl_owner_id: str = None
    '''

    :type: str
    '''

    bl_translation_context: str = None
    '''

    :type: str
    '''

    layout: 'UILayout' = None
    '''Defines the structure of the menu in the UI 

    :type: 'UILayout'
    '''

    def draw(self, context):
        '''Draw UI elements into the menu UI layout 

        '''
        pass

    def draw_preset(self, _context):
        '''Optionally: - preset_add_operator (string) - preset_extensions (set of strings) - preset_operator_defaults (dict of keyword args) 

        '''
        pass

    def path_menu(self,
                  searchpaths: list,
                  operator: str,
                  *,
                  props_default: dict = None,
                  prop_filepath: str = 'filepath',
                  filter_ext: str = None,
                  filter_path=None,
                  display_name: str = None,
                  add_operator=None):
        '''Populate a menu from a list of paths. 

        :param searchpaths: Paths to scan. 
        :type searchpaths: list
        :param operator: The operator id to use with each file. 
        :type operator: str
        :param prop_filepath: Optional operator filepath property (defaults to “filepath”). 
        :type prop_filepath: str
        :param props_default: Properties to assign to each operator. 
        :type props_default: dict
        :param filter_ext: Optional callback that takes the file extensions.Returning false excludes the file from the list. 
        :type filter_ext: str
        :param display_name: Optional callback that takes the full path, returns the name to display. 
        :type display_name: str
        '''
        pass


class MeshEdge(bpy_struct):
    '''Edge in a Mesh data-block '''

    bevel_weight: float = None
    '''Weight used by the Bevel modifier 

    :type: float
    '''

    crease: float = None
    '''Weight used by the Subdivision Surface modifier for creasing 

    :type: float
    '''

    hide: bool = None
    '''

    :type: bool
    '''

    index: int = None
    '''Index of this edge 

    :type: int
    '''

    is_loose: bool = None
    '''Loose edge 

    :type: bool
    '''

    select: bool = None
    '''

    :type: bool
    '''

    use_edge_sharp: bool = None
    '''Sharp edge for the Edge Split modifier 

    :type: bool
    '''

    use_freestyle_mark: bool = None
    '''Edge mark for Freestyle line rendering 

    :type: bool
    '''

    use_seam: bool = None
    '''Seam edge for UV unwrapping 

    :type: bool
    '''

    vertices: typing.List[int] = None
    '''Vertex indices 

    :type: typing.List[int]
    '''

    key = None
    '''(readonly) '''


class MeshEdges(bpy_struct):
    '''Collection of mesh edges '''

    def add(self, count: int):
        '''add 

        :param count: Count, Number of edges to add 
        :type count: int
        '''
        pass


class MeshFaceMap(bpy_struct):
    value: int = None
    '''

    :type: int
    '''


class MeshFaceMapLayer(bpy_struct):
    '''Per-face map index '''

    data: typing.Union[typing.
                       List['MeshFaceMap'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['MeshFaceMap'], 'bpy_prop_collection']
    '''

    name: str = None
    '''Name of face-map layer 

    :type: str
    '''


class MeshFaceMapLayers(bpy_struct):
    '''Collection of mesh face-maps '''

    active: 'MeshFaceMapLayer' = None
    '''

    :type: 'MeshFaceMapLayer'
    '''

    def new(self, name: str = "FaceMap") -> 'MeshFaceMapLayer':
        '''Add a float property layer to Mesh 

        :param name: Face map name 
        :type name: str
        :rtype: 'MeshFaceMapLayer'
        :return:  The newly created layer 
        '''
        pass

    def remove(self, layer: 'MeshFaceMapLayer'):
        '''Remove a face map layer 

        :param layer: The layer to remove 
        :type layer: 'MeshFaceMapLayer'
        '''
        pass


class MeshLoop(bpy_struct):
    '''Loop in a Mesh data-block '''

    bitangent: typing.List[float] = None
    '''Bitangent vector of this vertex for this polygon (must be computed beforehand using calc_tangents, use it only if really needed, slower access than bitangent_sign) 

    :type: typing.List[float]
    '''

    bitangent_sign: float = None
    '''Sign of the bitangent vector of this vertex for this polygon (must be computed beforehand using calc_tangents, bitangent = bitangent_sign * cross(normal, tangent)) 

    :type: float
    '''

    edge_index: int = None
    '''Edge index 

    :type: int
    '''

    index: int = None
    '''Index of this loop 

    :type: int
    '''

    normal: typing.List[float] = None
    '''Local space unit length split normal vector of this vertex for this polygon (must be computed beforehand using calc_normals_split or calc_tangents) 

    :type: typing.List[float]
    '''

    tangent: typing.List[float] = None
    '''Local space unit length tangent vector of this vertex for this polygon (must be computed beforehand using calc_tangents) 

    :type: typing.List[float]
    '''

    vertex_index: int = None
    '''Vertex index 

    :type: int
    '''


class MeshLoopColor(bpy_struct):
    '''Vertex loop colors in a Mesh '''

    color: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class MeshLoopColorLayer(bpy_struct):
    '''Layer of vertex colors in a Mesh data-block '''

    active: bool = None
    '''Sets the layer as active for display and editing 

    :type: bool
    '''

    active_render: bool = None
    '''Sets the layer as active for rendering 

    :type: bool
    '''

    data: typing.Union[typing.
                       List['MeshLoopColor'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['MeshLoopColor'], 'bpy_prop_collection']
    '''

    name: str = None
    '''Name of Vertex color layer 

    :type: str
    '''


class MeshLoopTriangle(bpy_struct):
    '''Tessellated triangle in a Mesh data-block '''

    area: float = None
    '''Area of this triangle 

    :type: float
    '''

    index: int = None
    '''Index of this loop triangle 

    :type: int
    '''

    loops: typing.List[int] = None
    '''Indices of mesh loops that make up the triangle 

    :type: typing.List[int]
    '''

    material_index: int = None
    '''

    :type: int
    '''

    normal: typing.List[float] = None
    '''Local space unit length normal vector for this triangle 

    :type: typing.List[float]
    '''

    polygon_index: int = None
    '''Index of mesh polygon that the triangle is a part of 

    :type: int
    '''

    split_normals: typing.List[float] = None
    '''Local space unit length split normals vectors of the vertices of this triangle (must be computed beforehand using calc_normals_split or calc_tangents) 

    :type: typing.List[float]
    '''

    use_smooth: bool = None
    '''

    :type: bool
    '''

    vertices: typing.List[int] = None
    '''Indices of triangle vertices 

    :type: typing.List[int]
    '''

    center = None
    '''The midpoint of the face. (readonly) '''

    edge_keys = None
    '''(readonly) '''


class MeshLoopTriangles(bpy_struct):
    '''Tessellation of mesh polygons into triangles '''

    pass


class MeshLoops(bpy_struct):
    '''Collection of mesh loops '''

    def add(self, count: int):
        '''add 

        :param count: Count, Number of loops to add 
        :type count: int
        '''
        pass


class MeshPaintMaskLayer(bpy_struct):
    '''Per-vertex paint mask data '''

    data: typing.Union[typing.List['MeshPaintMaskProperty'],
                       'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['MeshPaintMaskProperty'], 'bpy_prop_collection']
    '''


class MeshPaintMaskProperty(bpy_struct):
    '''Floating point paint mask value '''

    value: float = None
    '''

    :type: float
    '''


class MeshPolygon(bpy_struct):
    '''Polygon in a Mesh data-block '''

    area: float = None
    '''Read only area of this polygon 

    :type: float
    '''

    center: typing.List[float] = None
    '''Center of this polygon 

    :type: typing.List[float]
    '''

    hide: bool = None
    '''

    :type: bool
    '''

    index: int = None
    '''Index of this polygon 

    :type: int
    '''

    loop_start: int = None
    '''Index of the first loop of this polygon 

    :type: int
    '''

    loop_total: int = None
    '''Number of loops used by this polygon 

    :type: int
    '''

    material_index: int = None
    '''

    :type: int
    '''

    normal: typing.List[float] = None
    '''Local space unit length normal vector for this polygon 

    :type: typing.List[float]
    '''

    select: bool = None
    '''

    :type: bool
    '''

    use_freestyle_mark: bool = None
    '''Face mark for Freestyle line rendering 

    :type: bool
    '''

    use_smooth: bool = None
    '''

    :type: bool
    '''

    vertices: typing.List[int] = None
    '''Vertex indices 

    :type: typing.List[int]
    '''

    edge_keys = None
    '''(readonly) '''

    loop_indices = None
    '''(readonly) '''

    def flip(self, ):
        '''Invert winding of this polygon (flip its normal) 

        '''
        pass


class MeshPolygonFloatProperty(bpy_struct):
    '''User defined floating point number value in a float properties layer '''

    value: float = None
    '''

    :type: float
    '''


class MeshPolygonFloatPropertyLayer(bpy_struct):
    '''User defined layer of floating point number values '''

    data: typing.Union[typing.List['MeshPolygonFloatProperty'],
                       'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['MeshPolygonFloatProperty'], 'bpy_prop_collection']
    '''

    name: str = None
    '''

    :type: str
    '''


class MeshPolygonIntProperty(bpy_struct):
    '''User defined integer number value in an integer properties layer '''

    value: int = None
    '''

    :type: int
    '''


class MeshPolygonIntPropertyLayer(bpy_struct):
    '''User defined layer of integer number values '''

    data: typing.Union[typing.List['MeshPolygonIntProperty'],
                       'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['MeshPolygonIntProperty'], 'bpy_prop_collection']
    '''

    name: str = None
    '''

    :type: str
    '''


class MeshPolygonStringProperty(bpy_struct):
    '''User defined string text value in a string properties layer '''

    value: str = None
    '''

    :type: str
    '''


class MeshPolygonStringPropertyLayer(bpy_struct):
    '''User defined layer of string text values '''

    data: typing.Union[typing.List['MeshPolygonStringProperty'],
                       'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['MeshPolygonStringProperty'], 'bpy_prop_collection']
    '''

    name: str = None
    '''

    :type: str
    '''


class MeshPolygons(bpy_struct):
    '''Collection of mesh polygons '''

    active: int = None
    '''The active polygon for this mesh 

    :type: int
    '''

    def add(self, count: int):
        '''add 

        :param count: Count, Number of polygons to add 
        :type count: int
        '''
        pass


class MeshSkinVertex(bpy_struct):
    '''Per-vertex skin data for use with the Skin modifier '''

    radius: typing.List[float] = None
    '''Radius of the skin 

    :type: typing.List[float]
    '''

    use_loose: bool = None
    '''If vertex has multiple adjacent edges, it is hulled to them directly 

    :type: bool
    '''

    use_root: bool = None
    '''Vertex is a root for rotation calculations and armature generation, setting this flag does not clear other roots in the same mesh island 

    :type: bool
    '''


class MeshSkinVertexLayer(bpy_struct):
    '''Per-vertex skin data for use with the Skin modifier '''

    data: typing.Union[typing.
                       List['MeshSkinVertex'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['MeshSkinVertex'], 'bpy_prop_collection']
    '''

    name: str = None
    '''Name of skin layer 

    :type: str
    '''


class MeshStatVis(bpy_struct):
    distort_max: float = None
    '''Maximum angle to display 

    :type: float
    '''

    distort_min: float = None
    '''Minimum angle to display 

    :type: float
    '''

    overhang_axis: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    overhang_max: float = None
    '''Maximum angle to display 

    :type: float
    '''

    overhang_min: float = None
    '''Minimum angle to display 

    :type: float
    '''

    sharp_max: float = None
    '''Maximum angle to display 

    :type: float
    '''

    sharp_min: float = None
    '''Minimum angle to display 

    :type: float
    '''

    thickness_max: float = None
    '''Maximum for measuring thickness 

    :type: float
    '''

    thickness_min: float = None
    '''Minimum for measuring thickness 

    :type: float
    '''

    thickness_samples: int = None
    '''Number of samples to test per face 

    :type: int
    '''

    type: typing.Union[str, int] = None
    '''Type of data to visualize/check 

    :type: typing.Union[str, int]
    '''


class MeshUVLoop(bpy_struct):
    pin_uv: bool = None
    '''

    :type: bool
    '''

    select: bool = None
    '''

    :type: bool
    '''

    select_edge: bool = None
    '''

    :type: bool
    '''

    uv: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class MeshUVLoopLayer(bpy_struct):
    active: bool = None
    '''Set the map as active for display and editing 

    :type: bool
    '''

    active_clone: bool = None
    '''Set the map as active for cloning 

    :type: bool
    '''

    active_render: bool = None
    '''Set the map as active for rendering 

    :type: bool
    '''

    data: typing.Union[typing.List['MeshUVLoop'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['MeshUVLoop'], 'bpy_prop_collection']
    '''

    name: str = None
    '''Name of UV map 

    :type: str
    '''


class MeshVertex(bpy_struct):
    '''Vertex in a Mesh data-block '''

    bevel_weight: float = None
    '''Weight used by the Bevel modifier ‘Only Vertices’ option 

    :type: float
    '''

    co: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    groups: typing.Union[typing.List['VertexGroupElement'],
                         'bpy_prop_collection'] = None
    '''Weights for the vertex groups this vertex is member of 

    :type: typing.Union[typing.List['VertexGroupElement'], 'bpy_prop_collection']
    '''

    hide: bool = None
    '''

    :type: bool
    '''

    index: int = None
    '''Index of this vertex 

    :type: int
    '''

    normal: typing.List[float] = None
    '''Vertex Normal 

    :type: typing.List[float]
    '''

    select: bool = None
    '''

    :type: bool
    '''

    undeformed_co: typing.List[float] = None
    '''For meshes with modifiers applied, the coordinate of the vertex with no deforming modifiers applied, as used for generated texture coordinates 

    :type: typing.List[float]
    '''


class MeshVertexFloatProperty(bpy_struct):
    '''User defined floating point number value in a float properties layer '''

    value: float = None
    '''

    :type: float
    '''


class MeshVertexFloatPropertyLayer(bpy_struct):
    '''User defined layer of floating point number values '''

    data: typing.Union[typing.List['MeshVertexFloatProperty'],
                       'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['MeshVertexFloatProperty'], 'bpy_prop_collection']
    '''

    name: str = None
    '''

    :type: str
    '''


class MeshVertexIntProperty(bpy_struct):
    '''User defined integer number value in an integer properties layer '''

    value: int = None
    '''

    :type: int
    '''


class MeshVertexIntPropertyLayer(bpy_struct):
    '''User defined layer of integer number values '''

    data: typing.Union[typing.List['MeshVertexIntProperty'],
                       'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['MeshVertexIntProperty'], 'bpy_prop_collection']
    '''

    name: str = None
    '''

    :type: str
    '''


class MeshVertexStringProperty(bpy_struct):
    '''User defined string text value in a string properties layer '''

    value: str = None
    '''

    :type: str
    '''


class MeshVertexStringPropertyLayer(bpy_struct):
    '''User defined layer of string text values '''

    data: typing.Union[typing.List['MeshVertexStringProperty'],
                       'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['MeshVertexStringProperty'], 'bpy_prop_collection']
    '''

    name: str = None
    '''

    :type: str
    '''


class MeshVertices(bpy_struct):
    '''Collection of mesh vertices '''

    def add(self, count: int):
        '''add 

        :param count: Count, Number of vertices to add 
        :type count: int
        '''
        pass


class MetaBallElements(bpy_struct):
    '''Collection of metaball elements '''

    active: 'MetaElement' = None
    '''Last selected element 

    :type: 'MetaElement'
    '''

    def new(self, type: typing.Union[str, int] = 'BALL') -> 'MetaElement':
        '''Add a new element to the metaball 

        :param type: type for the new meta-element 
        :type type: typing.Union[str, int]
        :rtype: 'MetaElement'
        :return:  The newly created meta-element 
        '''
        pass

    def remove(self, element: 'MetaElement'):
        '''Remove an element from the metaball 

        :param element: The element to remove 
        :type element: 'MetaElement'
        '''
        pass

    def clear(self, ):
        '''Remove all elements from the metaball 

        '''
        pass


class MetaElement(bpy_struct):
    '''Blobby element in a Metaball data-block '''

    co: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    hide: bool = None
    '''Hide element 

    :type: bool
    '''

    radius: float = None
    '''

    :type: float
    '''

    rotation: typing.List[float] = None
    '''Normalized quaternion rotation 

    :type: typing.List[float]
    '''

    size_x: float = None
    '''Size of element, use of components depends on element type 

    :type: float
    '''

    size_y: float = None
    '''Size of element, use of components depends on element type 

    :type: float
    '''

    size_z: float = None
    '''Size of element, use of components depends on element type 

    :type: float
    '''

    stiffness: float = None
    '''Stiffness defines how much of the element to fill 

    :type: float
    '''

    type: typing.Union[str, int] = None
    '''Metaball types 

    :type: typing.Union[str, int]
    '''

    use_negative: bool = None
    '''Set metaball as negative one 

    :type: bool
    '''


class Modifier(bpy_struct):
    '''Modifier affecting the geometry data of an object '''

    name: str = None
    '''Modifier name 

    :type: str
    '''

    show_expanded: bool = None
    '''Set modifier expanded in the user interface 

    :type: bool
    '''

    show_in_editmode: bool = None
    '''Display modifier in Edit mode 

    :type: bool
    '''

    show_on_cage: bool = None
    '''Adjust edit cage to modifier result 

    :type: bool
    '''

    show_render: bool = None
    '''Use modifier during render 

    :type: bool
    '''

    show_viewport: bool = None
    '''Display modifier in viewport 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    use_apply_on_spline: bool = None
    '''Apply this and all preceding deformation modifiers on splines’ points rather than on filled curve/surface 

    :type: bool
    '''


class MotionPath(bpy_struct):
    '''Cache of the worldspace positions of an element over a frame range '''

    color: typing.List[float] = None
    '''Custom color for motion path 

    :type: typing.List[float]
    '''

    frame_end: int = None
    '''End frame of the stored range 

    :type: int
    '''

    frame_start: int = None
    '''Starting frame of the stored range 

    :type: int
    '''

    is_modified: bool = None
    '''Path is being edited 

    :type: bool
    '''

    length: int = None
    '''Number of frames cached 

    :type: int
    '''

    line_thickness: int = None
    '''Line thickness for drawing path 

    :type: int
    '''

    lines: bool = None
    '''Draw straight lines between keyframe points 

    :type: bool
    '''

    points: typing.Union[typing.
                         List['MotionPathVert'], 'bpy_prop_collection'] = None
    '''Cached positions per frame 

    :type: typing.Union[typing.List['MotionPathVert'], 'bpy_prop_collection']
    '''

    use_bone_head: bool = None
    '''For PoseBone paths, use the bone head location when calculating this path 

    :type: bool
    '''

    use_custom_color: bool = None
    '''Use custom color for this motion path 

    :type: bool
    '''


class MotionPathVert(bpy_struct):
    '''Cached location on path '''

    co: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    select: bool = None
    '''Path point is selected for editing 

    :type: bool
    '''


class MovieClipProxy(bpy_struct):
    '''Proxy parameters for a movie clip '''

    build_100: bool = None
    '''Build proxy resolution 100% of the original footage dimension 

    :type: bool
    '''

    build_25: bool = None
    '''Build proxy resolution 25% of the original footage dimension 

    :type: bool
    '''

    build_50: bool = None
    '''Build proxy resolution 50% of the original footage dimension 

    :type: bool
    '''

    build_75: bool = None
    '''Build proxy resolution 75% of the original footage dimension 

    :type: bool
    '''

    build_free_run: bool = None
    '''Build free run time code index 

    :type: bool
    '''

    build_free_run_rec_date: bool = None
    '''Build free run time code index using Record Date/Time 

    :type: bool
    '''

    build_record_run: bool = None
    '''Build record run time code index 

    :type: bool
    '''

    build_undistorted_100: bool = None
    '''Build proxy resolution 100% of the original undistorted footage dimension 

    :type: bool
    '''

    build_undistorted_25: bool = None
    '''Build proxy resolution 25% of the original undistorted footage dimension 

    :type: bool
    '''

    build_undistorted_50: bool = None
    '''Build proxy resolution 50% of the original undistorted footage dimension 

    :type: bool
    '''

    build_undistorted_75: bool = None
    '''Build proxy resolution 75% of the original undistorted footage dimension 

    :type: bool
    '''

    directory: str = None
    '''Location to store the proxy files 

    :type: str
    '''

    quality: int = None
    '''JPEG quality of proxy images 

    :type: int
    '''

    timecode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''


class MovieClipScopes(bpy_struct):
    '''Scopes for statistical view of a movie clip '''

    pass


class MovieClipUser(bpy_struct):
    '''Parameters defining how a MovieClip data-block is used by another data-block '''

    frame_current: int = None
    '''Current frame number in movie or image sequence 

    :type: int
    '''

    proxy_render_size: typing.Union[str, int] = None
    '''Draw preview using full resolution or different proxy resolutions 

    :type: typing.Union[str, int]
    '''

    use_render_undistorted: bool = None
    '''Render preview using undistorted proxy 

    :type: bool
    '''


class MovieReconstructedCamera(bpy_struct):
    '''Match-moving reconstructed camera data from tracker '''

    average_error: float = None
    '''Average error of reconstruction 

    :type: float
    '''

    frame: int = None
    '''Frame number marker is keyframed on 

    :type: int
    '''

    matrix: typing.List[float] = None
    '''Worldspace transformation matrix 

    :type: typing.List[float]
    '''


class MovieTracking(bpy_struct):
    '''Match-moving data for tracking '''

    active_object_index: int = None
    '''Index of active object 

    :type: int
    '''

    camera: 'MovieTrackingCamera' = None
    '''

    :type: 'MovieTrackingCamera'
    '''

    dopesheet: 'MovieTrackingDopesheet' = None
    '''

    :type: 'MovieTrackingDopesheet'
    '''

    objects: typing.Union[typing.List['MovieTrackingObject'],
                          'bpy_prop_collection', 'MovieTrackingObjects'] = None
    '''Collection of objects in this tracking data object 

    :type: typing.Union[typing.List['MovieTrackingObject'], 'bpy_prop_collection', 'MovieTrackingObjects']
    '''

    plane_tracks: typing.Union[typing.List['MovieTrackingPlaneTrack'],
                               'bpy_prop_collection',
                               'MovieTrackingPlaneTracks'] = None
    '''Collection of plane tracks in this tracking data object 

    :type: typing.Union[typing.List['MovieTrackingPlaneTrack'], 'bpy_prop_collection', 'MovieTrackingPlaneTracks']
    '''

    reconstruction: 'MovieTrackingReconstruction' = None
    '''

    :type: 'MovieTrackingReconstruction'
    '''

    settings: 'MovieTrackingSettings' = None
    '''

    :type: 'MovieTrackingSettings'
    '''

    stabilization: 'MovieTrackingStabilization' = None
    '''

    :type: 'MovieTrackingStabilization'
    '''

    tracks: typing.Union[typing.List['MovieTrackingTrack'],
                         'bpy_prop_collection', 'MovieTrackingTracks'] = None
    '''Collection of tracks in this tracking data object 

    :type: typing.Union[typing.List['MovieTrackingTrack'], 'bpy_prop_collection', 'MovieTrackingTracks']
    '''


class MovieTrackingCamera(bpy_struct):
    '''Match-moving camera data for tracking '''

    distortion_model: typing.Union[str, int] = None
    '''Distortion model used for camera lenses 

    :type: typing.Union[str, int]
    '''

    division_k1: float = None
    '''First coefficient of second order division distortion 

    :type: float
    '''

    division_k2: float = None
    '''First coefficient of second order division distortion 

    :type: float
    '''

    focal_length: float = None
    '''Camera’s focal length 

    :type: float
    '''

    focal_length_pixels: float = None
    '''Camera’s focal length 

    :type: float
    '''

    k1: float = None
    '''First coefficient of third order polynomial radial distortion 

    :type: float
    '''

    k2: float = None
    '''Second coefficient of third order polynomial radial distortion 

    :type: float
    '''

    k3: float = None
    '''Third coefficient of third order polynomial radial distortion 

    :type: float
    '''

    pixel_aspect: float = None
    '''Pixel aspect ratio 

    :type: float
    '''

    principal: typing.List[float] = None
    '''Optical center of lens 

    :type: typing.List[float]
    '''

    sensor_width: float = None
    '''Width of CCD sensor in millimeters 

    :type: float
    '''

    units: typing.Union[str, int] = None
    '''Units used for camera focal length 

    :type: typing.Union[str, int]
    '''


class MovieTrackingDopesheet(bpy_struct):
    '''Match-moving dopesheet data '''

    show_hidden: bool = None
    '''Include channels from objects/bone that aren’t visible 

    :type: bool
    '''

    show_only_selected: bool = None
    '''Only include channels relating to selected objects and data 

    :type: bool
    '''

    sort_method: typing.Union[str, int] = None
    '''Method to be used to sort channels in dopesheet view 

    :type: typing.Union[str, int]
    '''

    use_invert_sort: bool = None
    '''Invert sort order of dopesheet channels 

    :type: bool
    '''


class MovieTrackingMarker(bpy_struct):
    '''Match-moving marker data for tracking '''

    co: typing.List[float] = None
    '''Marker position at frame in normalized coordinates 

    :type: typing.List[float]
    '''

    frame: int = None
    '''Frame number marker is keyframed on 

    :type: int
    '''

    is_keyed: bool = None
    '''Whether the position of the marker is keyframed or tracked 

    :type: bool
    '''

    mute: bool = None
    '''Is marker muted for current frame 

    :type: bool
    '''

    pattern_bound_box: typing.List[float] = None
    '''Pattern area bounding box in normalized coordinates 

    :type: typing.List[float]
    '''

    pattern_corners: typing.List[float] = None
    '''Array of coordinates which represents pattern’s corners in normalized coordinates relative to marker position 

    :type: typing.List[float]
    '''

    search_max: typing.List[float] = None
    '''Right-bottom corner of search area in normalized coordinates relative to marker position 

    :type: typing.List[float]
    '''

    search_min: typing.List[float] = None
    '''Left-bottom corner of search area in normalized coordinates relative to marker position 

    :type: typing.List[float]
    '''


class MovieTrackingMarkers(bpy_struct):
    '''Collection of markers for movie tracking track '''

    def find_frame(self, frame: int,
                   exact: bool = True) -> 'MovieTrackingMarker':
        '''Get marker for specified frame 

        :param frame: Frame, Frame number to find marker for 
        :type frame: int
        :param exact: Exact, Get marker at exact frame number rather than get estimated marker 
        :type exact: bool
        :rtype: 'MovieTrackingMarker'
        :return:  Marker for specified frame 
        '''
        pass

    def insert_frame(self, frame: int,
                     co: typing.List[float] = (0.0,
                                               0.0)) -> 'MovieTrackingMarker':
        '''Insert a new marker at the specified frame 

        :param frame: Frame, Frame number to insert marker to 
        :type frame: int
        :param co: Coordinate, Place new marker at the given frame using specified in normalized space coordinates 
        :type co: typing.List[float]
        :rtype: 'MovieTrackingMarker'
        :return:  Newly created marker 
        '''
        pass

    def delete_frame(self, frame: int):
        '''Delete marker at specified frame 

        :param frame: Frame, Frame number to delete marker from 
        :type frame: int
        '''
        pass


class MovieTrackingObject(bpy_struct):
    '''Match-moving object tracking and reconstruction data '''

    is_camera: bool = None
    '''Object is used for camera tracking 

    :type: bool
    '''

    keyframe_a: int = None
    '''First keyframe used for reconstruction initialization 

    :type: int
    '''

    keyframe_b: int = None
    '''Second keyframe used for reconstruction initialization 

    :type: int
    '''

    name: str = None
    '''Unique name of object 

    :type: str
    '''

    plane_tracks: typing.Union[typing.List['MovieTrackingPlaneTrack'],
                               'bpy_prop_collection',
                               'MovieTrackingObjectPlaneTracks'] = None
    '''Collection of plane tracks in this tracking data object 

    :type: typing.Union[typing.List['MovieTrackingPlaneTrack'], 'bpy_prop_collection', 'MovieTrackingObjectPlaneTracks']
    '''

    reconstruction: 'MovieTrackingReconstruction' = None
    '''

    :type: 'MovieTrackingReconstruction'
    '''

    scale: float = None
    '''Scale of object solution in camera space 

    :type: float
    '''

    tracks: typing.Union[typing.
                         List['MovieTrackingTrack'], 'bpy_prop_collection',
                         'MovieTrackingObjectTracks'] = None
    '''Collection of tracks in this tracking data object 

    :type: typing.Union[typing.List['MovieTrackingTrack'], 'bpy_prop_collection', 'MovieTrackingObjectTracks']
    '''


class MovieTrackingObjectPlaneTracks(bpy_struct):
    '''Collection of tracking plane tracks '''

    active: 'MovieTrackingTrack' = None
    '''Active track in this tracking data object 

    :type: 'MovieTrackingTrack'
    '''


class MovieTrackingObjectTracks(bpy_struct):
    '''Collection of movie tracking tracks '''

    active: 'MovieTrackingTrack' = None
    '''Active track in this tracking data object 

    :type: 'MovieTrackingTrack'
    '''

    def new(self, name: str = "", frame: int = 1) -> 'MovieTrackingTrack':
        '''create new motion track in this movie clip 

        :param name: Name of new track 
        :type name: str
        :param frame: Frame, Frame number to add tracks on 
        :type frame: int
        :rtype: 'MovieTrackingTrack'
        :return:  Newly created track 
        '''
        pass


class MovieTrackingObjects(bpy_struct):
    '''Collection of movie tracking objects '''

    active: 'MovieTrackingObject' = None
    '''Active object in this tracking data object 

    :type: 'MovieTrackingObject'
    '''

    def new(self, name: str) -> 'MovieTrackingObject':
        '''Add tracking object to this movie clip 

        :param name: Name of new object 
        :type name: str
        :rtype: 'MovieTrackingObject'
        :return:  New motion tracking object 
        '''
        pass

    def remove(self, object: 'MovieTrackingObject'):
        '''Remove tracking object from this movie clip 

        :param object: Motion tracking object to be removed 
        :type object: 'MovieTrackingObject'
        '''
        pass


class MovieTrackingPlaneMarker(bpy_struct):
    '''Match-moving plane marker data for tracking '''

    corners: typing.List[float] = None
    '''Array of coordinates which represents UI rectangle corners in frame normalized coordinates 

    :type: typing.List[float]
    '''

    frame: int = None
    '''Frame number marker is keyframed on 

    :type: int
    '''

    mute: bool = None
    '''Is marker muted for current frame 

    :type: bool
    '''


class MovieTrackingPlaneMarkers(bpy_struct):
    '''Collection of markers for movie tracking plane track '''

    def find_frame(self, frame: int,
                   exact: bool = True) -> 'MovieTrackingPlaneMarker':
        '''Get plane marker for specified frame 

        :param frame: Frame, Frame number to find marker for 
        :type frame: int
        :param exact: Exact, Get plane marker at exact frame number rather than get estimated marker 
        :type exact: bool
        :rtype: 'MovieTrackingPlaneMarker'
        :return:  Plane marker for specified frame 
        '''
        pass

    def insert_frame(self, frame: int) -> 'MovieTrackingPlaneMarker':
        '''Insert a new plane marker at the specified frame 

        :param frame: Frame, Frame number to insert marker to 
        :type frame: int
        :rtype: 'MovieTrackingPlaneMarker'
        :return:  Newly created plane marker 
        '''
        pass

    def delete_frame(self, frame: int):
        '''Delete plane marker at specified frame 

        :param frame: Frame, Frame number to delete plane marker from 
        :type frame: int
        '''
        pass


class MovieTrackingPlaneTrack(bpy_struct):
    '''Match-moving plane track data for tracking '''

    image: 'Image' = None
    '''Image displayed in the track during editing in clip editor 

    :type: 'Image'
    '''

    image_opacity: float = None
    '''Opacity of the image 

    :type: float
    '''

    markers: typing.Union[typing.List['MovieTrackingPlaneMarker'],
                          'bpy_prop_collection',
                          'MovieTrackingPlaneMarkers'] = None
    '''Collection of markers in track 

    :type: typing.Union[typing.List['MovieTrackingPlaneMarker'], 'bpy_prop_collection', 'MovieTrackingPlaneMarkers']
    '''

    name: str = None
    '''Unique name of track 

    :type: str
    '''

    select: bool = None
    '''Plane track is selected 

    :type: bool
    '''

    use_auto_keying: bool = None
    '''Automatic keyframe insertion when moving plane corners 

    :type: bool
    '''


class MovieTrackingPlaneTracks(bpy_struct):
    '''Collection of movie tracking plane tracks '''

    active: 'MovieTrackingPlaneTrack' = None
    '''Active plane track in this tracking data object 

    :type: 'MovieTrackingPlaneTrack'
    '''


class MovieTrackingReconstructedCameras(bpy_struct):
    '''Collection of solved cameras '''

    def find_frame(self, frame: int = 1) -> 'MovieReconstructedCamera':
        '''Find a reconstructed camera for a give frame number 

        :param frame: Frame, Frame number to find camera for 
        :type frame: int
        :rtype: 'MovieReconstructedCamera'
        :return:  Camera for a given frame 
        '''
        pass

    def matrix_from_frame(self, frame: int = 1) -> typing.List[float]:
        '''Return interpolated camera matrix for a given frame 

        :param frame: Frame, Frame number to find camera for 
        :type frame: int
        :rtype: typing.List[float]
        :return:  Matrix, Interpolated camera matrix for a given frame 
        '''
        pass


class MovieTrackingReconstruction(bpy_struct):
    '''Match-moving reconstruction data from tracker '''

    average_error: float = None
    '''Average error of reconstruction 

    :type: float
    '''

    cameras: typing.Union[typing.List['MovieReconstructedCamera'],
                          'bpy_prop_collection',
                          'MovieTrackingReconstructedCameras'] = None
    '''Collection of solved cameras 

    :type: typing.Union[typing.List['MovieReconstructedCamera'], 'bpy_prop_collection', 'MovieTrackingReconstructedCameras']
    '''

    is_valid: bool = None
    '''Is tracking data contains valid reconstruction information 

    :type: bool
    '''


class MovieTrackingSettings(bpy_struct):
    '''Match moving settings '''

    clean_action: typing.Union[str, int] = None
    '''Cleanup action to execute 

    :type: typing.Union[str, int]
    '''

    clean_error: float = None
    '''Effect on tracks which have a larger re-projection error 

    :type: float
    '''

    clean_frames: int = None
    '''Effect on tracks which are tracked less than the specified amount of frames 

    :type: int
    '''

    default_correlation_min: float = None
    '''Default minimum value of correlation between matched pattern and reference that is still treated as successful tracking 

    :type: float
    '''

    default_frames_limit: int = None
    '''Every tracking cycle, this number of frames are tracked 

    :type: int
    '''

    default_margin: int = None
    '''Default distance from image boundary at which marker stops tracking 

    :type: int
    '''

    default_motion_model: typing.Union[str, int] = None
    '''Default motion model to use for tracking 

    :type: typing.Union[str, int]
    '''

    default_pattern_match: typing.Union[str, int] = None
    '''Track pattern from given frame when tracking marker to next frame 

    :type: typing.Union[str, int]
    '''

    default_pattern_size: int = None
    '''Size of pattern area for newly created tracks 

    :type: int
    '''

    default_search_size: int = None
    '''Size of search area for newly created tracks 

    :type: int
    '''

    default_weight: float = None
    '''Influence of newly created track on a final solution 

    :type: float
    '''

    distance: float = None
    '''Distance between two bundles used for scene scaling 

    :type: float
    '''

    object_distance: float = None
    '''Distance between two bundles used for object scaling 

    :type: float
    '''

    refine_intrinsics: typing.Union[str, int] = None
    '''Refine intrinsics during camera solving 

    :type: typing.Union[str, int]
    '''

    show_default_expanded: bool = None
    '''Show default options expanded in the user interface 

    :type: bool
    '''

    show_extra_expanded: bool = None
    '''Show extra options expanded in the user interface 

    :type: bool
    '''

    speed: typing.Union[str, int] = None
    '''Limit speed of tracking to make visual feedback easier (this does not affect the tracking quality) 

    :type: typing.Union[str, int]
    '''

    use_default_blue_channel: bool = None
    '''Use blue channel from footage for tracking 

    :type: bool
    '''

    use_default_brute: bool = None
    '''Use a brute-force translation-only initialization when tracking 

    :type: bool
    '''

    use_default_green_channel: bool = None
    '''Use green channel from footage for tracking 

    :type: bool
    '''

    use_default_mask: bool = None
    '''Use a grease pencil data-block as a mask to use only specified areas of pattern when tracking 

    :type: bool
    '''

    use_default_normalization: bool = None
    '''Normalize light intensities while tracking (slower) 

    :type: bool
    '''

    use_default_red_channel: bool = None
    '''Use red channel from footage for tracking 

    :type: bool
    '''

    use_keyframe_selection: bool = None
    '''Automatically select keyframes when solving camera/object motion 

    :type: bool
    '''

    use_tripod_solver: bool = None
    '''Use special solver to track a stable camera position, such as a tripod 

    :type: bool
    '''


class MovieTrackingStabilization(bpy_struct):
    '''2D stabilization based on tracking markers '''

    active_rotation_track_index: int = None
    '''Index of active track in rotation stabilization tracks list 

    :type: int
    '''

    active_track_index: int = None
    '''Index of active track in translation stabilization tracks list 

    :type: int
    '''

    anchor_frame: int = None
    '''Reference point to anchor stabilization (other frames will be adjusted relative to this frame’s position) 

    :type: int
    '''

    filter_type: typing.Union[str, int] = None
    '''Interpolation to use for sub-pixel shifts and rotations due to stabilization 

    :type: typing.Union[str, int]
    '''

    influence_location: float = None
    '''Influence of stabilization algorithm on footage location 

    :type: float
    '''

    influence_rotation: float = None
    '''Influence of stabilization algorithm on footage rotation 

    :type: float
    '''

    influence_scale: float = None
    '''Influence of stabilization algorithm on footage scale 

    :type: float
    '''

    rotation_tracks: typing.Union[typing.List['MovieTrackingTrack'],
                                  'bpy_prop_collection'] = None
    '''Collection of tracks used for 2D stabilization (translation) 

    :type: typing.Union[typing.List['MovieTrackingTrack'], 'bpy_prop_collection']
    '''

    scale_max: float = None
    '''Limit the amount of automatic scaling 

    :type: float
    '''

    show_tracks_expanded: bool = None
    '''Show UI list of tracks participating in stabilization 

    :type: bool
    '''

    target_position: typing.List[float] = None
    '''Known relative offset of original shot, will be subtracted (e.g. for panning shot, can be animated) 

    :type: typing.List[float]
    '''

    target_rotation: float = None
    '''Rotation present on original shot, will be compensated (e.g. for deliberate tilting) 

    :type: float
    '''

    target_scale: float = None
    '''Explicitly scale resulting frame to compensate zoom of original shot 

    :type: float
    '''

    tracks: typing.Union[typing.List['MovieTrackingTrack'],
                         'bpy_prop_collection'] = None
    '''Collection of tracks used for 2D stabilization (translation) 

    :type: typing.Union[typing.List['MovieTrackingTrack'], 'bpy_prop_collection']
    '''

    use_2d_stabilization: bool = None
    '''Use 2D stabilization for footage 

    :type: bool
    '''

    use_autoscale: bool = None
    '''Automatically scale footage to cover unfilled areas when stabilizing 

    :type: bool
    '''

    use_stabilize_rotation: bool = None
    '''Stabilize detected rotation around center of frame 

    :type: bool
    '''

    use_stabilize_scale: bool = None
    '''Compensate any scale changes relative to center of rotation 

    :type: bool
    '''


class MovieTrackingTrack(bpy_struct):
    '''Match-moving track data for tracking '''

    average_error: float = None
    '''Average error of re-projection 

    :type: float
    '''

    bundle: typing.List[float] = None
    '''Position of bundle reconstructed from this track 

    :type: typing.List[float]
    '''

    color: typing.List[float] = None
    '''Color of the track in the Movie Clip Editor and the 3D viewport after a solve 

    :type: typing.List[float]
    '''

    correlation_min: float = None
    '''Minimal value of correlation between matched pattern and reference that is still treated as successful tracking 

    :type: float
    '''

    frames_limit: int = None
    '''Every tracking cycle, this number of frames are tracked 

    :type: int
    '''

    grease_pencil: 'GreasePencil' = None
    '''Grease pencil data for this track 

    :type: 'GreasePencil'
    '''

    has_bundle: bool = None
    '''True if track has a valid bundle 

    :type: bool
    '''

    hide: bool = None
    '''Track is hidden 

    :type: bool
    '''

    lock: bool = None
    '''Track is locked and all changes to it are disabled 

    :type: bool
    '''

    margin: int = None
    '''Distance from image boundary at which marker stops tracking 

    :type: int
    '''

    markers: typing.Union[typing.List['MovieTrackingMarker'],
                          'bpy_prop_collection', 'MovieTrackingMarkers'] = None
    '''Collection of markers in track 

    :type: typing.Union[typing.List['MovieTrackingMarker'], 'bpy_prop_collection', 'MovieTrackingMarkers']
    '''

    motion_model: typing.Union[str, int] = None
    '''Default motion model to use for tracking 

    :type: typing.Union[str, int]
    '''

    name: str = None
    '''Unique name of track 

    :type: str
    '''

    offset: typing.List[float] = None
    '''Offset of track from the parenting point 

    :type: typing.List[float]
    '''

    pattern_match: typing.Union[str, int] = None
    '''Track pattern from given frame when tracking marker to next frame 

    :type: typing.Union[str, int]
    '''

    select: bool = None
    '''Track is selected 

    :type: bool
    '''

    select_anchor: bool = None
    '''Track’s anchor point is selected 

    :type: bool
    '''

    select_pattern: bool = None
    '''Track’s pattern area is selected 

    :type: bool
    '''

    select_search: bool = None
    '''Track’s search area is selected 

    :type: bool
    '''

    use_alpha_preview: bool = None
    '''Apply track’s mask on displaying preview 

    :type: bool
    '''

    use_blue_channel: bool = None
    '''Use blue channel from footage for tracking 

    :type: bool
    '''

    use_brute: bool = None
    '''Use a brute-force translation only pre-track before refinement 

    :type: bool
    '''

    use_custom_color: bool = None
    '''Use custom color instead of theme-defined 

    :type: bool
    '''

    use_grayscale_preview: bool = None
    '''Display what the tracking algorithm sees in the preview 

    :type: bool
    '''

    use_green_channel: bool = None
    '''Use green channel from footage for tracking 

    :type: bool
    '''

    use_mask: bool = None
    '''Use a grease pencil data-block as a mask to use only specified areas of pattern when tracking 

    :type: bool
    '''

    use_normalization: bool = None
    '''Normalize light intensities while tracking. Slower 

    :type: bool
    '''

    use_red_channel: bool = None
    '''Use red channel from footage for tracking 

    :type: bool
    '''

    weight: float = None
    '''Influence of this track on a final solution 

    :type: float
    '''

    weight_stab: float = None
    '''Influence of this track on 2D stabilization 

    :type: float
    '''


class MovieTrackingTracks(bpy_struct):
    '''Collection of movie tracking tracks '''

    active: 'MovieTrackingTrack' = None
    '''Active track in this tracking data object 

    :type: 'MovieTrackingTrack'
    '''

    def new(self, name: str = "", frame: int = 1) -> 'MovieTrackingTrack':
        '''Create new motion track in this movie clip 

        :param name: Name of new track 
        :type name: str
        :param frame: Frame, Frame number to add track on 
        :type frame: int
        :rtype: 'MovieTrackingTrack'
        :return:  Newly created track 
        '''
        pass


class NlaStrip(bpy_struct):
    '''A container referencing an existing Action '''

    action: 'Action' = None
    '''Action referenced by this strip 

    :type: 'Action'
    '''

    action_frame_end: float = None
    '''Last frame from action to use 

    :type: float
    '''

    action_frame_start: float = None
    '''First frame from action to use 

    :type: float
    '''

    active: bool = None
    '''NLA Strip is active 

    :type: bool
    '''

    blend_in: float = None
    '''Number of frames at start of strip to fade in influence 

    :type: float
    '''

    blend_out: float = None
    '''

    :type: float
    '''

    blend_type: typing.Union[str, int] = None
    '''Method used for combining strip’s result with accumulated result 

    :type: typing.Union[str, int]
    '''

    extrapolation: typing.Union[str, int] = None
    '''Action to take for gaps past the strip extents 

    :type: typing.Union[str, int]
    '''

    fcurves: typing.Union[typing.List['FCurve'], 'bpy_prop_collection',
                          'NlaStripFCurves'] = None
    '''F-Curves for controlling the strip’s influence and timing 

    :type: typing.Union[typing.List['FCurve'], 'bpy_prop_collection', 'NlaStripFCurves']
    '''

    frame_end: float = None
    '''

    :type: float
    '''

    frame_start: float = None
    '''

    :type: float
    '''

    influence: float = None
    '''Amount the strip contributes to the current result 

    :type: float
    '''

    modifiers: typing.Union[typing.
                            List['FModifier'], 'bpy_prop_collection'] = None
    '''Modifiers affecting all the F-Curves in the referenced Action 

    :type: typing.Union[typing.List['FModifier'], 'bpy_prop_collection']
    '''

    mute: bool = None
    '''Disable NLA Strip evaluation 

    :type: bool
    '''

    name: str = None
    '''

    :type: str
    '''

    repeat: float = None
    '''Number of times to repeat the action range 

    :type: float
    '''

    scale: float = None
    '''Scaling factor for action 

    :type: float
    '''

    select: bool = None
    '''NLA Strip is selected 

    :type: bool
    '''

    strip_time: float = None
    '''Frame of referenced Action to evaluate 

    :type: float
    '''

    strips: typing.Union[typing.List['NlaStrip'], 'bpy_prop_collection'] = None
    '''NLA Strips that this strip acts as a container for (if it is of type Meta) 

    :type: typing.Union[typing.List['NlaStrip'], 'bpy_prop_collection']
    '''

    type: typing.Union[str, int] = None
    '''Type of NLA Strip 

    :type: typing.Union[str, int]
    '''

    use_animated_influence: bool = None
    '''Influence setting is controlled by an F-Curve rather than automatically determined 

    :type: bool
    '''

    use_animated_time: bool = None
    '''Strip time is controlled by an F-Curve rather than automatically determined 

    :type: bool
    '''

    use_animated_time_cyclic: bool = None
    '''Cycle the animated time within the action start & end 

    :type: bool
    '''

    use_auto_blend: bool = None
    '''Number of frames for Blending In/Out is automatically determined from overlapping strips 

    :type: bool
    '''

    use_reverse: bool = None
    '''NLA Strip is played back in reverse order (only when timing is automatically determined) 

    :type: bool
    '''

    use_sync_length: bool = None
    '''Update range of frames referenced from action after tweaking strip and its keyframes 

    :type: bool
    '''


class NlaStripFCurves(bpy_struct):
    '''Collection of NLA strip F-Curves '''

    def find(self, data_path: str, index: int = 0) -> 'FCurve':
        '''Find an F-Curve. Note that this function performs a linear scan of all F-Curves in the NLA strip. 

        :param data_path: Data Path, F-Curve data path 
        :type data_path: str
        :param index: Index, Array index 
        :type index: int
        :rtype: 'FCurve'
        :return:  The found F-Curve, or None if it doesn’t exist 
        '''
        pass


class NlaStrips(bpy_struct):
    '''Collection of Nla Strips '''

    def new(self, name: str, start: int, action: 'Action') -> 'NlaStrip':
        '''Add a new Action-Clip strip to the track 

        :param name: Name for the NLA Strips 
        :type name: str
        :param start: Start Frame, Start frame for this strip 
        :type start: int
        :param action: Action to assign to this strip 
        :type action: 'Action'
        :rtype: 'NlaStrip'
        :return:  New NLA Strip 
        '''
        pass

    def remove(self, strip: 'NlaStrip'):
        '''Remove a NLA Strip 

        :param strip: NLA Strip to remove 
        :type strip: 'NlaStrip'
        '''
        pass


class NlaTrack(bpy_struct):
    '''A animation layer containing Actions referenced as NLA strips '''

    active: bool = None
    '''NLA Track is active 

    :type: bool
    '''

    is_solo: bool = None
    '''NLA Track is evaluated itself (i.e. active Action and all other NLA Tracks in the same AnimData block are disabled) 

    :type: bool
    '''

    lock: bool = None
    '''NLA Track is locked 

    :type: bool
    '''

    mute: bool = None
    '''Disable NLA Track evaluation 

    :type: bool
    '''

    name: str = None
    '''

    :type: str
    '''

    select: bool = None
    '''NLA Track is selected 

    :type: bool
    '''

    strips: typing.Union[typing.List['NlaStrip'], 'bpy_prop_collection',
                         'NlaStrips'] = None
    '''NLA Strips on this NLA-track 

    :type: typing.Union[typing.List['NlaStrip'], 'bpy_prop_collection', 'NlaStrips']
    '''


class NlaTracks(bpy_struct):
    '''Collection of NLA Tracks '''

    active: 'NlaTrack' = None
    '''Active Object constraint 

    :type: 'NlaTrack'
    '''

    def new(self, prev: 'NlaTrack' = None) -> 'NlaTrack':
        '''Add a new NLA Track 

        :param prev: NLA Track to add the new one after 
        :type prev: 'NlaTrack'
        :rtype: 'NlaTrack'
        :return:  New NLA Track 
        '''
        pass

    def remove(self, track: 'NlaTrack'):
        '''Remove a NLA Track 

        :param track: NLA Track to remove 
        :type track: 'NlaTrack'
        '''
        pass


class Node(bpy_struct):
    '''Node in a node tree '''

    bl_description: str = None
    '''

    :type: str
    '''

    bl_height_default: float = None
    '''

    :type: float
    '''

    bl_height_max: float = None
    '''

    :type: float
    '''

    bl_height_min: float = None
    '''

    :type: float
    '''

    bl_icon: typing.Union[str, int] = None
    '''The node icon 

    :type: typing.Union[str, int]
    '''

    bl_idname: str = None
    '''

    :type: str
    '''

    bl_label: str = None
    '''The node label 

    :type: str
    '''

    bl_static_type: typing.Union[str, int] = None
    '''Node type (deprecated, use with care) 

    :type: typing.Union[str, int]
    '''

    bl_width_default: float = None
    '''

    :type: float
    '''

    bl_width_max: float = None
    '''

    :type: float
    '''

    bl_width_min: float = None
    '''

    :type: float
    '''

    color: typing.List[float] = None
    '''Custom color of the node body 

    :type: typing.List[float]
    '''

    dimensions: typing.List[float] = None
    '''Absolute bounding box dimensions of the node 

    :type: typing.List[float]
    '''

    height: float = None
    '''Height of the node 

    :type: float
    '''

    hide: bool = None
    '''

    :type: bool
    '''

    inputs: typing.Union[typing.List['NodeSocket'], 'bpy_prop_collection',
                         'NodeInputs'] = None
    '''

    :type: typing.Union[typing.List['NodeSocket'], 'bpy_prop_collection', 'NodeInputs']
    '''

    internal_links: typing.Union[typing.List['NodeLink'],
                                 'bpy_prop_collection'] = None
    '''Internal input-to-output connections for muting 

    :type: typing.Union[typing.List['NodeLink'], 'bpy_prop_collection']
    '''

    label: str = None
    '''Optional custom node label 

    :type: str
    '''

    location: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    mute: bool = None
    '''

    :type: bool
    '''

    name: str = None
    '''Unique node identifier 

    :type: str
    '''

    outputs: typing.Union[typing.List['NodeSocket'], 'bpy_prop_collection',
                          'NodeOutputs'] = None
    '''

    :type: typing.Union[typing.List['NodeSocket'], 'bpy_prop_collection', 'NodeOutputs']
    '''

    parent: 'Node' = None
    '''Parent this node is attached to 

    :type: 'Node'
    '''

    select: bool = None
    '''Node selection state 

    :type: bool
    '''

    show_options: bool = None
    '''

    :type: bool
    '''

    show_preview: bool = None
    '''

    :type: bool
    '''

    show_texture: bool = None
    '''Draw node in viewport textured draw mode 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''Node type (deprecated, use bl_static_type or bl_idname for the actual identifier string) 

    :type: typing.Union[str, int]
    '''

    use_custom_color: bool = None
    '''Use custom color for the node 

    :type: bool
    '''

    width: float = None
    '''Width of the node 

    :type: float
    '''

    width_hidden: float = None
    '''Width of the node in hidden state 

    :type: float
    '''

    def socket_value_update(self, context):
        '''Update after property changes 

        '''
        pass

    def poll_instance(self, node_tree: 'NodeTree') -> bool:
        '''If non-null output is returned, the node can be added to the tree 

        :param node_tree: Node Tree 
        :type node_tree: 'NodeTree'
        :rtype: bool
        '''
        pass

    def update(self, ):
        '''Update on editor changes 

        '''
        pass

    def insert_link(self, link: 'NodeLink'):
        '''Handle creation of a link to or from the node 

        :param link: Link, Node link that will be inserted 
        :type link: 'NodeLink'
        '''
        pass

    def init(self, context):
        '''Initialize a new instance of this node 

        '''
        pass

    def copy(self, node: 'Node'):
        '''Initialize a new instance of this node from an existing node 

        :param node: Node, Existing node to copy 
        :type node: 'Node'
        '''
        pass

    def free(self, ):
        '''Clean up node on removal 

        '''
        pass

    def draw_buttons(self, context, layout: 'UILayout'):
        '''Draw node buttons 

        :param layout: Layout, Layout in the UI 
        :type layout: 'UILayout'
        '''
        pass

    def draw_buttons_ext(self, context, layout: 'UILayout'):
        '''Draw node buttons in the sidebar 

        :param layout: Layout, Layout in the UI 
        :type layout: 'UILayout'
        '''
        pass

    def draw_label(self, ) -> str:
        '''Returns a dynamic label string 

        :rtype: str
        :return:  Label 
        '''
        pass


class NodeInputs(bpy_struct):
    '''Collection of Node Sockets '''

    def new(self, type: str, name: str, identifier: str = "") -> 'NodeSocket':
        '''Add a socket to this node 

        :param type: Type, Data type 
        :type type: str
        :param name: Name 
        :type name: str
        :param identifier: Identifier, Unique socket identifier 
        :type identifier: str
        :rtype: 'NodeSocket'
        :return:  New socket 
        '''
        pass

    def remove(self, socket: 'NodeSocket'):
        '''Remove a socket from this node 

        :param socket: The socket to remove 
        :type socket: 'NodeSocket'
        '''
        pass

    def clear(self, ):
        '''Remove all sockets from this node 

        '''
        pass

    def move(self, from_index: int, to_index: int):
        '''Move a socket to another position 

        :param from_index: From Index, Index of the socket to move 
        :type from_index: int
        :param to_index: To Index, Target index for the socket 
        :type to_index: int
        '''
        pass


class NodeInstanceHash(bpy_struct):
    '''Hash table containing node instance data '''

    pass


class NodeInternalSocketTemplate(bpy_struct):
    '''Type and default value of a node socket '''

    identifier: str = None
    '''Identifier of the socket 

    :type: str
    '''

    name: str = None
    '''Name of the socket 

    :type: str
    '''

    type: typing.Union[str, int] = None
    '''Data type of the socket 

    :type: typing.Union[str, int]
    '''


class NodeLink(bpy_struct):
    '''Link is valid '''

    from_node: 'Node' = None
    '''

    :type: 'Node'
    '''

    from_socket: 'NodeSocket' = None
    '''

    :type: 'NodeSocket'
    '''

    is_hidden: bool = None
    '''Link is hidden due to invisible sockets 

    :type: bool
    '''

    is_valid: bool = None
    '''

    :type: bool
    '''

    to_node: 'Node' = None
    '''

    :type: 'Node'
    '''

    to_socket: 'NodeSocket' = None
    '''

    :type: 'NodeSocket'
    '''


class NodeLinks(bpy_struct):
    '''Collection of Node Links '''

    def new(self,
            input: 'NodeSocket',
            output: 'NodeSocket',
            verify_limits: bool = True) -> 'NodeLink':
        '''Add a node link to this node tree 

        :param input: The input socket 
        :type input: 'NodeSocket'
        :param output: The output socket 
        :type output: 'NodeSocket'
        :param verify_limits: Verify Limits, Remove existing links if connection limit is exceeded 
        :type verify_limits: bool
        :rtype: 'NodeLink'
        :return:  New node link 
        '''
        pass

    def remove(self, link: 'NodeLink'):
        '''remove a node link from the node tree 

        :param link: The node link to remove 
        :type link: 'NodeLink'
        '''
        pass

    def clear(self, ):
        '''remove all node links from the node tree 

        '''
        pass


class NodeOutputFileSlotFile(bpy_struct):
    '''Single layer file slot of the file output node '''

    format: 'ImageFormatSettings' = None
    '''

    :type: 'ImageFormatSettings'
    '''

    path: str = None
    '''Subpath used for this slot 

    :type: str
    '''

    use_node_format: bool = None
    '''

    :type: bool
    '''


class NodeOutputFileSlotLayer(bpy_struct):
    '''Multilayer slot of the file output node '''

    name: str = None
    '''OpenEXR layer name used for this slot 

    :type: str
    '''


class NodeOutputs(bpy_struct):
    '''Collection of Node Sockets '''

    def new(self, type: str, name: str, identifier: str = "") -> 'NodeSocket':
        '''Add a socket to this node 

        :param type: Type, Data type 
        :type type: str
        :param name: Name 
        :type name: str
        :param identifier: Identifier, Unique socket identifier 
        :type identifier: str
        :rtype: 'NodeSocket'
        :return:  New socket 
        '''
        pass

    def remove(self, socket: 'NodeSocket'):
        '''Remove a socket from this node 

        :param socket: The socket to remove 
        :type socket: 'NodeSocket'
        '''
        pass

    def clear(self, ):
        '''Remove all sockets from this node 

        '''
        pass

    def move(self, from_index: int, to_index: int):
        '''Move a socket to another position 

        :param from_index: From Index, Index of the socket to move 
        :type from_index: int
        :param to_index: To Index, Target index for the socket 
        :type to_index: int
        '''
        pass


class NodeSocket(bpy_struct):
    '''Input or output socket of a node '''

    bl_idname: str = None
    '''

    :type: str
    '''

    display_shape: typing.Union[str, int] = None
    '''Socket shape 

    :type: typing.Union[str, int]
    '''

    enabled: bool = None
    '''Enable the socket 

    :type: bool
    '''

    hide: bool = None
    '''Hide the socket 

    :type: bool
    '''

    hide_value: bool = None
    '''Hide the socket input value 

    :type: bool
    '''

    identifier: str = None
    '''Unique identifier for mapping sockets 

    :type: str
    '''

    is_linked: bool = None
    '''True if the socket is connected 

    :type: bool
    '''

    is_output: bool = None
    '''True if the socket is an output, otherwise input 

    :type: bool
    '''

    link_limit: int = None
    '''Max number of links allowed for this socket 

    :type: int
    '''

    name: str = None
    '''Socket name 

    :type: str
    '''

    node: 'Node' = None
    '''Node owning this socket 

    :type: 'Node'
    '''

    show_expanded: bool = None
    '''Socket links are expanded in the user interface 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''Data type 

    :type: typing.Union[str, int]
    '''

    links = None
    '''List of node links from or to this socket. Warning: takes O(len(nodetree.links)) time. (readonly) '''

    def draw(self, context, layout: 'UILayout', node: 'Node', text: str):
        '''Draw socket 

        :param layout: Layout, Layout in the UI 
        :type layout: 'UILayout'
        :param node: Node, Node the socket belongs to 
        :type node: 'Node'
        :param text: Text, Text label to draw alongside properties 
        :type text: str
        '''
        pass

    def draw_color(self, context, node: 'Node') -> typing.List[float]:
        '''Color of the socket icon 

        :param node: Node, Node the socket belongs to 
        :type node: 'Node'
        :rtype: typing.List[float]
        :return:  Color 
        '''
        pass


class NodeSocketInterface(bpy_struct):
    '''Parameters to define node sockets '''

    bl_socket_idname: str = None
    '''

    :type: str
    '''

    identifier: str = None
    '''Unique identifier for mapping sockets 

    :type: str
    '''

    is_output: bool = None
    '''True if the socket is an output, otherwise input 

    :type: bool
    '''

    name: str = None
    '''Socket name 

    :type: str
    '''

    def draw(self, context, layout: 'UILayout'):
        '''Draw template settings 

        :param layout: Layout, Layout in the UI 
        :type layout: 'UILayout'
        '''
        pass

    def draw_color(self, context) -> typing.List[float]:
        '''Color of the socket icon 

        :rtype: typing.List[float]
        :return:  Color 
        '''
        pass

    def register_properties(self, data_rna_type: 'Struct'):
        '''Define RNA properties of a socket 

        :param data_rna_type: Data RNA Type, RNA type for special socket properties 
        :type data_rna_type: 'Struct'
        '''
        pass

    def init_socket(self, node: 'Node', socket: 'NodeSocket', data_path: str):
        '''Initialize a node socket instance 

        :param node: Node, Node of the socket to initialize 
        :type node: 'Node'
        :param socket: Socket, Socket to initialize 
        :type socket: 'NodeSocket'
        :param data_path: Data Path, Path to specialized socket data 
        :type data_path: str
        '''
        pass

    def from_socket(self, node: 'Node', socket: 'NodeSocket'):
        '''Setup template parameters from an existing socket 

        :param node: Node, Node of the original socket 
        :type node: 'Node'
        :param socket: Socket, Original socket 
        :type socket: 'NodeSocket'
        '''
        pass


class NodeTreeInputs(bpy_struct):
    '''Collection of Node Tree Sockets '''

    def new(self, type: str, name: str) -> 'NodeSocketInterface':
        '''Add a socket to this node tree 

        :param type: Type, Data type 
        :type type: str
        :param name: Name 
        :type name: str
        :rtype: 'NodeSocketInterface'
        :return:  New socket 
        '''
        pass

    def remove(self, socket: 'NodeSocketInterface'):
        '''Remove a socket from this node tree 

        :param socket: The socket to remove 
        :type socket: 'NodeSocketInterface'
        '''
        pass

    def clear(self, ):
        '''Remove all sockets from this node tree 

        '''
        pass

    def move(self, from_index: int, to_index: int):
        '''Move a socket to another position 

        :param from_index: From Index, Index of the socket to move 
        :type from_index: int
        :param to_index: To Index, Target index for the socket 
        :type to_index: int
        '''
        pass


class NodeTreeOutputs(bpy_struct):
    '''Collection of Node Tree Sockets '''

    def new(self, type: str, name: str) -> 'NodeSocketInterface':
        '''Add a socket to this node tree 

        :param type: Type, Data type 
        :type type: str
        :param name: Name 
        :type name: str
        :rtype: 'NodeSocketInterface'
        :return:  New socket 
        '''
        pass

    def remove(self, socket: 'NodeSocketInterface'):
        '''Remove a socket from this node tree 

        :param socket: The socket to remove 
        :type socket: 'NodeSocketInterface'
        '''
        pass

    def clear(self, ):
        '''Remove all sockets from this node tree 

        '''
        pass

    def move(self, from_index: int, to_index: int):
        '''Move a socket to another position 

        :param from_index: From Index, Index of the socket to move 
        :type from_index: int
        :param to_index: To Index, Target index for the socket 
        :type to_index: int
        '''
        pass


class NodeTreePath(bpy_struct):
    '''Element of the node space tree path '''

    node_tree: 'NodeTree' = None
    '''Base node tree from context 

    :type: 'NodeTree'
    '''


class Nodes(bpy_struct):
    '''Collection of Nodes '''

    active: 'Node' = None
    '''Active node in this tree 

    :type: 'Node'
    '''

    def new(self, type: str) -> 'Node':
        '''Add a node to this node tree 

        :param type: Type, Type of node to add (Warning: should be same as node.bl_idname, not node.type!) 
        :type type: str
        :rtype: 'Node'
        :return:  New node 
        '''
        pass

    def remove(self, node: 'Node'):
        '''Remove a node from this node tree 

        :param node: The node to remove 
        :type node: 'Node'
        '''
        pass

    def clear(self, ):
        '''Remove all nodes from this node tree 

        '''
        pass


class ObjectBase(bpy_struct):
    '''An object instance in a render layer '''

    hide_viewport: bool = None
    '''Temporarily hide in viewport 

    :type: bool
    '''

    object: 'Object' = None
    '''Object this base links to 

    :type: 'Object'
    '''

    select: bool = None
    '''Object base selection state 

    :type: bool
    '''


class ObjectConstraints(bpy_struct):
    '''Collection of object constraints '''

    active: 'Constraint' = None
    '''Active Object constraint 

    :type: 'Constraint'
    '''

    def new(self, type: typing.Union[str, int]) -> 'Constraint':
        '''Add a new constraint to this object 

        :param type: Constraint type to addCAMERA_SOLVER Camera Solver.FOLLOW_TRACK Follow Track.OBJECT_SOLVER Object Solver.COPY_LOCATION Copy Location, Copy the location of a target (with an optional offset), so that they move together.COPY_ROTATION Copy Rotation, Copy the rotation of a target (with an optional offset), so that they rotate together.COPY_SCALE Copy Scale, Copy the scale factors of a target (with an optional offset), so that they are scaled by the same amount.COPY_TRANSFORMS Copy Transforms, Copy all the transformations of a target, so that they move together.LIMIT_DISTANCE Limit Distance, Restrict movements to within a certain distance of a target (at the time of constraint evaluation only).LIMIT_LOCATION Limit Location, Restrict movement along each axis within given ranges.LIMIT_ROTATION Limit Rotation, Restrict rotation along each axis within given ranges.LIMIT_SCALE Limit Scale, Restrict scaling along each axis with given ranges.MAINTAIN_VOLUME Maintain Volume, Compensate for scaling one axis by applying suitable scaling to the other two axes.TRANSFORM Transformation, Use one transform property from target to control another (or same) property on owner.TRANSFORM_CACHE Transform Cache, Look up the transformation matrix from an external file.CLAMP_TO Clamp To, Restrict movements to lie along a curve by remapping location along curve’s longest axis.DAMPED_TRACK Damped Track, Point towards a target by performing the smallest rotation necessary.IK Inverse Kinematics, Control a chain of bones by specifying the endpoint target (Bones only).LOCKED_TRACK Locked Track, Rotate around the specified (‘locked’) axis to point towards a target.SPLINE_IK Spline IK, Align chain of bones along a curve (Bones only).STRETCH_TO Stretch To, Stretch along Y-Axis to point towards a target.TRACK_TO Track To, Legacy tracking constraint prone to twisting artifacts.ACTION Action, Use transform property of target to look up pose for owner from an Action.ARMATURE Armature, Apply weight-blended transformation from multiple bones like the Armature modifier.CHILD_OF Child Of, Make target the ‘detachable’ parent of owner.FLOOR Floor, Use position (and optionally rotation) of target to define a ‘wall’ or ‘floor’ that the owner can not cross.FOLLOW_PATH Follow Path, Use to animate an object/bone following a path.PIVOT Pivot, Change pivot point for transforms (buggy).SHRINKWRAP Shrinkwrap, Restrict movements to surface of target mesh. 
        :type type: typing.Union[str, int]
        :rtype: 'Constraint'
        :return:  New constraint 
        '''
        pass

    def remove(self, constraint: 'Constraint'):
        '''Remove a constraint from this object 

        :param constraint: Removed constraint 
        :type constraint: 'Constraint'
        '''
        pass

    def clear(self, ):
        '''Remove all constraint from this object 

        '''
        pass

    def move(self, from_index: int, to_index: int):
        '''Move a constraint to a different position 

        :param from_index: From Index, Index to move 
        :type from_index: int
        :param to_index: To Index, Target index 
        :type to_index: int
        '''
        pass


class ObjectDisplay(bpy_struct):
    '''Object display settings for 3d viewport '''

    show_shadows: bool = None
    '''Object cast shadows in the 3d viewport 

    :type: bool
    '''


class ObjectGpencilModifiers(bpy_struct):
    '''Collection of object grease pencil modifiers '''

    def new(self, name: str,
            type: typing.Union[str, int]) -> 'GpencilModifier':
        '''Add a new greasepencil_modifier 

        :param name: New name for the greasepencil_modifier 
        :type name: str
        :param type: Modifier type to addGP_ARRAY Array, Create array of duplicate instances.GP_BUILD Build, Create duplication of strokes.GP_MIRROR Mirror, Duplicate strokes like a mirror.GP_SIMPLIFY Simplify, Simplify stroke reducing number of points.GP_SUBDIV Subdivide, Subdivide stroke adding more control points.GP_MULTIPLY Multiple Strokes, Produce multiple strokes along one stroke.GP_ARMATURE Armature, Deform stroke points using armature object.GP_HOOK Hook, Deform stroke points using objects.GP_LATTICE Lattice, Deform strokes using lattice.GP_NOISE Noise, Add noise to strokes.GP_OFFSET Offset, Change stroke location, rotation or scale.GP_SMOOTH Smooth, Smooth stroke.GP_THICK Thickness, Change stroke thickness.GP_TIME Time Offset, Offset keyframes.GP_COLOR Hue/Saturation, Apply changes to stroke colors.GP_OPACITY Opacity, Opacity of the strokes.GP_TINT Tint, Tint strokes with new color. 
        :type type: typing.Union[str, int]
        :rtype: 'GpencilModifier'
        :return:  Newly created modifier 
        '''
        pass

    def remove(self, greasepencil_modifier: 'GpencilModifier'):
        '''Remove an existing greasepencil_modifier from the object 

        :param greasepencil_modifier: Modifier to remove 
        :type greasepencil_modifier: 'GpencilModifier'
        '''
        pass

    def clear(self, ):
        '''Remove all grease pencil modifiers from the object 

        '''
        pass


class ObjectModifiers(bpy_struct):
    '''Collection of object modifiers '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'Modifier':
        '''Add a new modifier 

        :param name: New name for the modifier 
        :type name: str
        :param type: Modifier type to addDATA_TRANSFER Data Transfer, Transfer several types of data (vertex groups, UV maps, vertex colors, custom normals) from one mesh to another.MESH_CACHE Mesh Cache, Deform the mesh using an external frame-by-frame vertex transform cache.MESH_SEQUENCE_CACHE Mesh Sequence Cache, Deform the mesh or curve using an external mesh cache in Alembic format.NORMAL_EDIT Normal Edit, Modify the direction of the surface normals.WEIGHTED_NORMAL Weighted Normal, Modify the direction of the surface normals using a weighting method.UV_PROJECT UV Project, Project the UV map coordinates from the negative Z axis of another object.UV_WARP UV Warp, Transform the UV map using the the difference between two objects.VERTEX_WEIGHT_EDIT Vertex Weight Edit, Modify of the weights of a vertex group.VERTEX_WEIGHT_MIX Vertex Weight Mix, Mix the weights of two vertex groups.VERTEX_WEIGHT_PROXIMITY Vertex Weight Proximity, Set the vertex group weights based on the distance to another target object.ARRAY Array, Create copies of the shape with offsets.BEVEL Bevel, Generate sloped corners by adding geometry to the mesh’s edges or vertices.BOOLEAN Boolean, Use another shape to cut, combine or perform a difference operation.BUILD Build, Cause the faces of the mesh object to appear or disappear one after the other over time.DECIMATE Decimate, Reduce the geometry density.EDGE_SPLIT Edge Split, Split away joined faces at the edges.MASK Mask, Dynamically hide vertices based on a vertex group or armature.MIRROR Mirror, Mirror along the local X, Y and/or Z axes, over the object origin.MULTIRES Multiresolution, Subdivide the mesh in a way that allows editing the higher subdivision levels.REMESH Remesh, Generate new mesh topology based on the current shape.SCREW Screw, Lathe around an axis, treating the inout mesh as a profile.SKIN Skin, Create a solid shape from vertices and edges, using the vertex radius to define the thickness.SOLIDIFY Solidify, Make the surface thick.SUBSURF Subdivision Surface, Split the faces into smaller parts, giving it a smoother appearance.TRIANGULATE Triangulate, Convert all polygons to triangles.WIREFRAME Wireframe, Convert faces into thickened edges.WELD Weld, Find groups of vertices closer then dist and merges them together.ARMATURE Armature, Deform the shape using an armature object.CAST Cast, Shift the shape towards a predefined primitive.CURVE Curve, Bend the mesh using a curve object.DISPLACE Displace, Offset vertices based on a texture.HOOK Hook, Deform specific points using another object.LAPLACIANDEFORM Laplacian Deform, Deform based a series of anchor points.LATTICE Lattice, Deform using the shape of a lattice object.MESH_DEFORM Mesh Deform, Deform using a different mesh, which acts as a deformation cage.SHRINKWRAP Shrinkwrap, Project the shape onto another object.SIMPLE_DEFORM Simple Deform, Deform the shape by twisting, bending, tapering or stretching.SMOOTH Smooth, Smooth the mesh by flattening the angles between adjacent faces.CORRECTIVE_SMOOTH Smooth Corrective, Smooth the mesh while still preserving the volume.LAPLACIANSMOOTH Smooth Laplacian, Reduce the noise on a mesh surface with minimal changes to its shape.SURFACE_DEFORM Surface Deform, Transfer motion from another mesh.WARP Warp, Warp parts of a mesh to a new location in a very flexible way thanks to 2 specified objects.WAVE Wave, Adds a ripple-like motion to an object’s geometry.CLOTH Cloth.COLLISION Collision.DYNAMIC_PAINT Dynamic Paint.EXPLODE Explode, Break apart the mesh faces and let them follow particles.OCEAN Ocean, Generate a moving ocean surface.PARTICLE_INSTANCE Particle Instance.PARTICLE_SYSTEM Particle System, Spawn particles from the shape.FLUID Fluid Simulation.SOFT_BODY Soft Body.SURFACE Surface. 
        :type type: typing.Union[str, int]
        :rtype: 'Modifier'
        :return:  Newly created modifier 
        '''
        pass

    def remove(self, modifier: 'Modifier'):
        '''Remove an existing modifier from the object 

        :param modifier: Modifier to remove 
        :type modifier: 'Modifier'
        '''
        pass

    def clear(self, ):
        '''Remove all modifiers from the object 

        '''
        pass


class ObjectShaderFx(bpy_struct):
    '''Collection of object effects '''

    def new(self, name: str, type: typing.Union[str, int]) -> 'ShaderFx':
        '''Add a new shader fx 

        :param name: New name for the effect 
        :type name: str
        :param type: Effect type to addFX_BLUR Blur, Apply Gaussian Blur to object.FX_COLORIZE Colorize, Apply different tint effects.FX_FLIP Flip, Flip image.FX_GLOW Glow, Create a glow effect.FX_LIGHT Light, Simulate illumination.FX_PIXEL Pixelate, Pixelate image.FX_RIM Rim, Add a rim to the image.FX_SHADOW Shadow, Create a shadow effect.FX_SWIRL Swirl, Create a rotation distortion.FX_WAVE Wave Distortion, Apply sinusoidal deformation. 
        :type type: typing.Union[str, int]
        :rtype: 'ShaderFx'
        :return:  Newly created effect 
        '''
        pass

    def remove(self, shader_fx: 'ShaderFx'):
        '''Remove an existing effect from the object 

        :param shader_fx: Effect to remove 
        :type shader_fx: 'ShaderFx'
        '''
        pass

    def clear(self, ):
        '''Remove all effects from the object 

        '''
        pass


class Operator(bpy_struct):
    '''Storage of an operator being executed, or registered after execution '''

    bl_description: str = None
    '''

    :type: str
    '''

    bl_idname: str = None
    '''

    :type: str
    '''

    bl_label: str = None
    '''

    :type: str
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Options for this operator type 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_translation_context: str = None
    '''

    :type: str
    '''

    bl_undo_group: str = None
    '''

    :type: str
    '''

    has_reports: bool = None
    '''Operator has a set of reports (warnings and errors) from last execution 

    :type: bool
    '''

    layout: 'UILayout' = None
    '''

    :type: 'UILayout'
    '''

    macros: typing.Union[typing.List['Macro'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['Macro'], 'bpy_prop_collection']
    '''

    name: str = None
    '''

    :type: str
    '''

    options: 'OperatorOptions' = None
    '''Runtime options 

    :type: 'OperatorOptions'
    '''

    properties: 'OperatorProperties' = None
    '''

    :type: 'OperatorProperties'
    '''

    bl_property = None
    '''The name of a property to use as this operators primary property. Currently this is only used to select the default property when expanding an operator into a menu. :type: string '''

    def report(self, type: typing.Union[typing.Set[str], typing.Set[int]],
               message: str):
        '''report 

        :param type: Type 
        :type type: typing.Union[typing.Set[str], typing.Set[int]]
        :param message: Report Message 
        :type message: str
        '''
        pass

    def is_repeat(self, ) -> bool:
        '''is_repeat 

        :rtype: bool
        :return:  result 
        '''
        pass

    def execute(self,
                context) -> typing.Union[typing.Set[str], typing.Set[int]]:
        '''Execute the operator 

        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return:  resultRUNNING_MODAL Running Modal, Keep the operator running with blender.CANCELLED Cancelled, The operator exited without doing anything, so no undo entry should be pushed.FINISHED Finished, The operator exited after completing its action.PASS_THROUGH Pass Through, Do nothing and pass the event on.INTERFACE Interface, Handled but not executed (popup menus). 
        '''
        pass

    def check(self, context) -> bool:
        '''Check the operator settings, return True to signal a change to redraw 

        :rtype: bool
        :return:  result 
        '''
        pass

    def invoke(self, context,
               event) -> typing.Union[typing.Set[str], typing.Set[int]]:
        '''Invoke the operator 

        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return:  resultRUNNING_MODAL Running Modal, Keep the operator running with blender.CANCELLED Cancelled, The operator exited without doing anything, so no undo entry should be pushed.FINISHED Finished, The operator exited after completing its action.PASS_THROUGH Pass Through, Do nothing and pass the event on.INTERFACE Interface, Handled but not executed (popup menus). 
        '''
        pass

    def modal(self, context,
              event) -> typing.Union[typing.Set[str], typing.Set[int]]:
        '''Modal operator function 

        :rtype: typing.Union[typing.Set[str], typing.Set[int]]
        :return:  resultRUNNING_MODAL Running Modal, Keep the operator running with blender.CANCELLED Cancelled, The operator exited without doing anything, so no undo entry should be pushed.FINISHED Finished, The operator exited after completing its action.PASS_THROUGH Pass Through, Do nothing and pass the event on.INTERFACE Interface, Handled but not executed (popup menus). 
        '''
        pass

    def draw(self, context):
        '''Draw function for the operator 

        '''
        pass

    def cancel(self, context):
        '''Called when the operator is canceled 

        '''
        pass

    def as_keywords(self, ignore=()):
        '''Return a copy of the properties as a dictionary 

        '''
        pass


class OperatorMacro(bpy_struct):
    '''Storage of a sub operator in a macro after it has been added '''

    properties: 'OperatorProperties' = None
    '''

    :type: 'OperatorProperties'
    '''


class OperatorOptions(bpy_struct):
    '''Runtime options '''

    is_grab_cursor: bool = None
    '''True when the cursor is grabbed 

    :type: bool
    '''

    is_invoke: bool = None
    '''True when invoked (even if only the execute callbacks available) 

    :type: bool
    '''

    is_repeat: bool = None
    '''True when run from the ‘Adjust Last Operation’ panel 

    :type: bool
    '''

    is_repeat_last: bool = None
    '''True when run from the operator ‘Repeat Last’ 

    :type: bool
    '''

    use_cursor_region: bool = None
    '''Enable to use the region under the cursor for modal execution 

    :type: bool
    '''


class OperatorProperties(bpy_struct):
    '''Input properties of an Operator '''

    pass


class PackedFile(bpy_struct):
    '''External file packed into the .blend file '''

    data: str = None
    '''Raw data (bytes, exact content of the embedded file) 

    :type: str
    '''

    size: int = None
    '''Size of packed file in bytes 

    :type: int
    '''


class Paint(bpy_struct):
    brush: 'Brush' = None
    '''Active Brush 

    :type: 'Brush'
    '''

    cavity_curve: 'CurveMapping' = None
    '''Editable cavity curve 

    :type: 'CurveMapping'
    '''

    input_samples: int = None
    '''Average multiple input samples together to smooth the brush stroke 

    :type: int
    '''

    palette: 'Palette' = None
    '''Active Palette 

    :type: 'Palette'
    '''

    show_brush: bool = None
    '''

    :type: bool
    '''

    show_brush_on_surface: bool = None
    '''

    :type: bool
    '''

    show_low_resolution: bool = None
    '''For multires, show low resolution while navigating the view 

    :type: bool
    '''

    tile_offset: typing.List[float] = None
    '''Stride at which tiled strokes are copied 

    :type: typing.List[float]
    '''

    tile_x: bool = None
    '''Tile along X axis 

    :type: bool
    '''

    tile_y: bool = None
    '''Tile along Y axis 

    :type: bool
    '''

    tile_z: bool = None
    '''Tile along Z axis 

    :type: bool
    '''

    tool_slots: typing.Union[typing.List['PaintToolSlot'],
                             'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['PaintToolSlot'], 'bpy_prop_collection']
    '''

    use_cavity: bool = None
    '''Mask painting according to mesh geometry cavity 

    :type: bool
    '''

    use_symmetry_feather: bool = None
    '''Reduce the strength of the brush where it overlaps symmetrical daubs 

    :type: bool
    '''

    use_symmetry_x: bool = None
    '''Mirror brush across the X axis 

    :type: bool
    '''

    use_symmetry_y: bool = None
    '''Mirror brush across the Y axis 

    :type: bool
    '''

    use_symmetry_z: bool = None
    '''Mirror brush across the Z axis 

    :type: bool
    '''


class PaintToolSlot(bpy_struct):
    brush: 'Brush' = None
    '''

    :type: 'Brush'
    '''


class PaletteColor(bpy_struct):
    color: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    strength: float = None
    '''

    :type: float
    '''

    weight: float = None
    '''

    :type: float
    '''


class PaletteColors(bpy_struct):
    '''Collection of palette colors '''

    active: 'PaletteColor' = None
    '''

    :type: 'PaletteColor'
    '''

    def new(self, ) -> 'PaletteColor':
        '''Add a new color to the palette 

        :rtype: 'PaletteColor'
        :return:  The newly created color 
        '''
        pass

    def remove(self, color: 'PaletteColor'):
        '''Remove a color from the palette 

        :param color: The color to remove 
        :type color: 'PaletteColor'
        '''
        pass

    def clear(self, ):
        '''Remove all colors from the palette 

        '''
        pass


class Panel(bpy_struct):
    '''Panel containing UI elements '''

    bl_category: str = None
    '''

    :type: str
    '''

    bl_context: str = None
    '''The context in which the panel belongs to. (TODO: explain the possible combinations bl_context/bl_region_type/bl_space_type) 

    :type: str
    '''

    bl_idname: str = None
    '''If this is set, the panel gets a custom ID, otherwise it takes the name of the class used to define the panel. For example, if the class name is “OBJECT_PT_hello”, and bl_idname is not set by the script, then bl_idname = “OBJECT_PT_hello” 

    :type: str
    '''

    bl_label: str = None
    '''The panel label, shows up in the panel header at the right of the triangle used to collapse the panel 

    :type: str
    '''

    bl_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Options for this panel type 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    bl_order: int = None
    '''Panels with lower numbers are default ordered before panels with higher numbers 

    :type: int
    '''

    bl_owner_id: str = None
    '''

    :type: str
    '''

    bl_parent_id: str = None
    '''If this is set, the panel becomes a sub-panel 

    :type: str
    '''

    bl_region_type: typing.Union[str, int] = None
    '''The region where the panel is going to be used in 

    :type: typing.Union[str, int]
    '''

    bl_space_type: typing.Union[str, int] = None
    '''The space where the panel is going to be used in 

    :type: typing.Union[str, int]
    '''

    bl_translation_context: str = None
    '''

    :type: str
    '''

    bl_ui_units_x: int = None
    '''When set, defines popup panel width 

    :type: int
    '''

    is_popover: bool = None
    '''

    :type: bool
    '''

    layout: 'UILayout' = None
    '''Defines the structure of the panel in the UI 

    :type: 'UILayout'
    '''

    text: str = None
    '''XXX todo 

    :type: str
    '''

    use_pin: bool = None
    '''Show the panel on all tabs 

    :type: bool
    '''

    def draw(self, context):
        '''Draw UI elements into the panel UI layout 

        '''
        pass

    def draw_header(self, context):
        '''Draw UI elements into the panel’s header UI layout 

        '''
        pass

    def draw_header_preset(self, context):
        '''Draw UI elements for presets in the panel’s header 

        '''
        pass


class Particle(bpy_struct):
    '''Particle in a particle system '''

    alive_state: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    angular_velocity: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    birth_time: float = None
    '''

    :type: float
    '''

    die_time: float = None
    '''

    :type: float
    '''

    hair_keys: typing.Union[typing.List['ParticleHairKey'],
                            'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['ParticleHairKey'], 'bpy_prop_collection']
    '''

    is_exist: bool = None
    '''

    :type: bool
    '''

    is_visible: bool = None
    '''

    :type: bool
    '''

    lifetime: float = None
    '''

    :type: float
    '''

    location: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    particle_keys: typing.Union[typing.List['ParticleKey'],
                                'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['ParticleKey'], 'bpy_prop_collection']
    '''

    prev_angular_velocity: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    prev_location: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    prev_rotation: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    prev_velocity: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    rotation: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    size: float = None
    '''

    :type: float
    '''

    velocity: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    def uv_on_emitter(
            self, modifier: 'ParticleSystemModifier') -> typing.List[float]:
        '''Obtain UV coordinates for a particle on an evaluated mesh. 

        :param modifier: Particle modifier from an evaluated object 
        :type modifier: 'ParticleSystemModifier'
        :rtype: typing.List[float]
        :return:  uv 
        '''
        pass


class ParticleBrush(bpy_struct):
    '''Particle editing brush '''

    count: int = None
    '''Particle count 

    :type: int
    '''

    curve: 'CurveMapping' = None
    '''

    :type: 'CurveMapping'
    '''

    length_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    puff_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    size: int = None
    '''Radius of the brush in pixels 

    :type: int
    '''

    steps: int = None
    '''Brush steps 

    :type: int
    '''

    strength: float = None
    '''Brush strength 

    :type: float
    '''

    use_puff_volume: bool = None
    '''Apply puff to unselected end-points (helps maintain hair volume when puffing root) 

    :type: bool
    '''


class ParticleDupliWeight(bpy_struct):
    '''Weight of a particle dupliobject in a collection '''

    count: int = None
    '''The number of times this object is repeated with respect to other objects 

    :type: int
    '''

    name: str = None
    '''Particle dupliobject name 

    :type: str
    '''


class ParticleEdit(bpy_struct):
    '''Properties of particle editing mode '''

    brush: 'ParticleBrush' = None
    '''

    :type: 'ParticleBrush'
    '''

    default_key_count: int = None
    '''How many keys to make new particles with 

    :type: int
    '''

    display_step: int = None
    '''How many steps to display the path with 

    :type: int
    '''

    emitter_distance: float = None
    '''Distance to keep particles away from the emitter 

    :type: float
    '''

    fade_frames: int = None
    '''How many frames to fade 

    :type: int
    '''

    is_editable: bool = None
    '''A valid edit mode exists 

    :type: bool
    '''

    is_hair: bool = None
    '''Editing hair 

    :type: bool
    '''

    object: 'Object' = None
    '''The edited object 

    :type: 'Object'
    '''

    select_mode: typing.Union[str, int] = None
    '''Particle select and display mode 

    :type: typing.Union[str, int]
    '''

    shape_object: 'Object' = None
    '''Outer shape to use for tools 

    :type: 'Object'
    '''

    show_particles: bool = None
    '''Display actual particles 

    :type: bool
    '''

    tool: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    use_auto_velocity: bool = None
    '''Calculate point velocities automatically 

    :type: bool
    '''

    use_default_interpolate: bool = None
    '''Interpolate new particles from the existing ones 

    :type: bool
    '''

    use_emitter_deflect: bool = None
    '''Keep paths from intersecting the emitter 

    :type: bool
    '''

    use_fade_time: bool = None
    '''Fade paths and keys further away from current frame 

    :type: bool
    '''

    use_preserve_length: bool = None
    '''Keep path lengths constant 

    :type: bool
    '''

    use_preserve_root: bool = None
    '''Keep root keys unmodified 

    :type: bool
    '''


class ParticleHairKey(bpy_struct):
    '''Particle key for hair particle system '''

    co: typing.List[float] = None
    '''Location of the hair key in object space 

    :type: typing.List[float]
    '''

    co_local: typing.List[float] = None
    '''Location of the hair key in its local coordinate system, relative to the emitting face 

    :type: typing.List[float]
    '''

    time: float = None
    '''Relative time of key over hair length 

    :type: float
    '''

    weight: float = None
    '''Weight for cloth simulation 

    :type: float
    '''

    def co_object(self, object: 'Object', modifier: 'ParticleSystemModifier',
                  particle: 'Particle') -> typing.List[float]:
        '''Obtain hairkey location with particle and modifier data 

        :param object: Object 
        :type object: 'Object'
        :param modifier: Particle modifier 
        :type modifier: 'ParticleSystemModifier'
        :param particle: hair particle 
        :type particle: 'Particle'
        :rtype: typing.List[float]
        :return:  Co, Exported hairkey location 
        '''
        pass


class ParticleKey(bpy_struct):
    '''Key location for a particle over time '''

    angular_velocity: typing.List[float] = None
    '''Key angular velocity 

    :type: typing.List[float]
    '''

    location: typing.List[float] = None
    '''Key location 

    :type: typing.List[float]
    '''

    rotation: typing.List[float] = None
    '''Key rotation quaternion 

    :type: typing.List[float]
    '''

    time: float = None
    '''Time of key over the simulation 

    :type: float
    '''

    velocity: typing.List[float] = None
    '''Key velocity 

    :type: typing.List[float]
    '''


class ParticleSettingsTextureSlots(bpy_struct):
    '''Collection of texture slots '''

    pass


class ParticleSystem(bpy_struct):
    '''Particle system in an object '''

    active_particle_target: 'ParticleTarget' = None
    '''

    :type: 'ParticleTarget'
    '''

    active_particle_target_index: int = None
    '''

    :type: int
    '''

    child_particles: typing.Union[typing.List['ChildParticle'],
                                  'bpy_prop_collection'] = None
    '''Child particles generated by the particle system 

    :type: typing.Union[typing.List['ChildParticle'], 'bpy_prop_collection']
    '''

    child_seed: int = None
    '''Offset in the random number table for child particles, to get a different randomized result 

    :type: int
    '''

    cloth: 'ClothModifier' = None
    '''Cloth dynamics for hair 

    :type: 'ClothModifier'
    '''

    dt_frac: float = None
    '''The current simulation time step size, as a fraction of a frame 

    :type: float
    '''

    has_multiple_caches: bool = None
    '''Particle system has multiple point caches 

    :type: bool
    '''

    invert_vertex_group_clump: bool = None
    '''Negate the effect of the clump vertex group 

    :type: bool
    '''

    invert_vertex_group_density: bool = None
    '''Negate the effect of the density vertex group 

    :type: bool
    '''

    invert_vertex_group_field: bool = None
    '''Negate the effect of the field vertex group 

    :type: bool
    '''

    invert_vertex_group_kink: bool = None
    '''Negate the effect of the kink vertex group 

    :type: bool
    '''

    invert_vertex_group_length: bool = None
    '''Negate the effect of the length vertex group 

    :type: bool
    '''

    invert_vertex_group_rotation: bool = None
    '''Negate the effect of the rotation vertex group 

    :type: bool
    '''

    invert_vertex_group_roughness_1: bool = None
    '''Negate the effect of the roughness 1 vertex group 

    :type: bool
    '''

    invert_vertex_group_roughness_2: bool = None
    '''Negate the effect of the roughness 2 vertex group 

    :type: bool
    '''

    invert_vertex_group_roughness_end: bool = None
    '''Negate the effect of the roughness end vertex group 

    :type: bool
    '''

    invert_vertex_group_size: bool = None
    '''Negate the effect of the size vertex group 

    :type: bool
    '''

    invert_vertex_group_tangent: bool = None
    '''Negate the effect of the tangent vertex group 

    :type: bool
    '''

    invert_vertex_group_twist: bool = None
    '''Negate the effect of the twist vertex group 

    :type: bool
    '''

    invert_vertex_group_velocity: bool = None
    '''Negate the effect of the velocity vertex group 

    :type: bool
    '''

    is_editable: bool = None
    '''Particle system can be edited in particle mode 

    :type: bool
    '''

    is_edited: bool = None
    '''Particle system has been edited in particle mode 

    :type: bool
    '''

    is_global_hair: bool = None
    '''Hair keys are in global coordinate space 

    :type: bool
    '''

    name: str = None
    '''Particle system name 

    :type: str
    '''

    parent: 'Object' = None
    '''Use this object’s coordinate system instead of global coordinate system 

    :type: 'Object'
    '''

    particles: typing.Union[typing.
                            List['Particle'], 'bpy_prop_collection'] = None
    '''Particles generated by the particle system 

    :type: typing.Union[typing.List['Particle'], 'bpy_prop_collection']
    '''

    point_cache: 'PointCache' = None
    '''

    :type: 'PointCache'
    '''

    reactor_target_object: 'Object' = None
    '''For reactor systems, the object that has the target particle system (empty if same object) 

    :type: 'Object'
    '''

    reactor_target_particle_system: int = None
    '''For reactor systems, index of particle system on the target object 

    :type: int
    '''

    seed: int = None
    '''Offset in the random number table, to get a different randomized result 

    :type: int
    '''

    settings: 'ParticleSettings' = None
    '''Particle system settings 

    :type: 'ParticleSettings'
    '''

    targets: typing.Union[typing.
                          List['ParticleTarget'], 'bpy_prop_collection'] = None
    '''Target particle systems 

    :type: typing.Union[typing.List['ParticleTarget'], 'bpy_prop_collection']
    '''

    use_hair_dynamics: bool = None
    '''Enable hair dynamics using cloth simulation 

    :type: bool
    '''

    use_keyed_timing: bool = None
    '''Use key times 

    :type: bool
    '''

    vertex_group_clump: str = None
    '''Vertex group to control clump 

    :type: str
    '''

    vertex_group_density: str = None
    '''Vertex group to control density 

    :type: str
    '''

    vertex_group_field: str = None
    '''Vertex group to control field 

    :type: str
    '''

    vertex_group_kink: str = None
    '''Vertex group to control kink 

    :type: str
    '''

    vertex_group_length: str = None
    '''Vertex group to control length 

    :type: str
    '''

    vertex_group_rotation: str = None
    '''Vertex group to control rotation 

    :type: str
    '''

    vertex_group_roughness_1: str = None
    '''Vertex group to control roughness 1 

    :type: str
    '''

    vertex_group_roughness_2: str = None
    '''Vertex group to control roughness 2 

    :type: str
    '''

    vertex_group_roughness_end: str = None
    '''Vertex group to control roughness end 

    :type: str
    '''

    vertex_group_size: str = None
    '''Vertex group to control size 

    :type: str
    '''

    vertex_group_tangent: str = None
    '''Vertex group to control tangent 

    :type: str
    '''

    vertex_group_twist: str = None
    '''Vertex group to control twist 

    :type: str
    '''

    vertex_group_velocity: str = None
    '''Vertex group to control velocity 

    :type: str
    '''

    def co_hair(self, object: 'Object', particle_no: int = 0,
                step: int = 0) -> typing.List[float]:
        '''Obtain cache hair data 

        :param object: Object 
        :type object: 'Object'
        :param particle_no: Particle no 
        :type particle_no: int
        :param step: step no 
        :type step: int
        :rtype: typing.List[float]
        :return:  Co, Exported hairkey location 
        '''
        pass

    def uv_on_emitter(self,
                      modifier: 'ParticleSystemModifier',
                      particle: 'Particle' = None,
                      particle_no: int = 0,
                      uv_no: int = 0) -> typing.List[float]:
        '''Obtain uv for all particles 

        :param modifier: Particle modifier 
        :type modifier: 'ParticleSystemModifier'
        :param particle: Particle 
        :type particle: 'Particle'
        :param particle_no: Particle no 
        :type particle_no: int
        :param uv_no: UV no 
        :type uv_no: int
        :rtype: typing.List[float]
        :return:  uv 
        '''
        pass

    def mcol_on_emitter(self,
                        modifier: 'ParticleSystemModifier',
                        particle: 'Particle',
                        particle_no: int = 0,
                        vcol_no: int = 0) -> typing.List[float]:
        '''Obtain mcol for all particles 

        :param modifier: Particle modifier 
        :type modifier: 'ParticleSystemModifier'
        :param particle: Particle 
        :type particle: 'Particle'
        :param particle_no: Particle no 
        :type particle_no: int
        :param vcol_no: vcol no 
        :type vcol_no: int
        :rtype: typing.List[float]
        :return:  mcol 
        '''
        pass


class ParticleSystems(bpy_struct):
    '''Collection of particle systems '''

    active: 'ParticleSystem' = None
    '''Active particle system being displayed 

    :type: 'ParticleSystem'
    '''

    active_index: int = None
    '''Index of active particle system slot 

    :type: int
    '''


class ParticleTarget(bpy_struct):
    '''Target particle system '''

    alliance: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    duration: float = None
    '''

    :type: float
    '''

    is_valid: bool = None
    '''Keyed particles target is valid 

    :type: bool
    '''

    name: str = None
    '''Particle target name 

    :type: str
    '''

    object: 'Object' = None
    '''The object that has the target particle system (empty if same object) 

    :type: 'Object'
    '''

    system: int = None
    '''The index of particle system on the target object 

    :type: int
    '''

    time: float = None
    '''

    :type: float
    '''


class PathCompare(bpy_struct):
    '''Match paths against this value '''

    path: str = None
    '''

    :type: str
    '''

    use_glob: bool = None
    '''Enable wildcard globbing 

    :type: bool
    '''


class PathCompareCollection(bpy_struct):
    '''Collection of paths '''

    pass


class PointCache(bpy_struct):
    '''Active point cache for physics simulations '''

    compression: typing.Union[str, int] = None
    '''Compression method to be used 

    :type: typing.Union[str, int]
    '''

    filepath: str = None
    '''Cache file path 

    :type: str
    '''

    frame_end: int = None
    '''Frame on which the simulation stops 

    :type: int
    '''

    frame_start: int = None
    '''Frame on which the simulation starts 

    :type: int
    '''

    frame_step: int = None
    '''Number of frames between cached frames 

    :type: int
    '''

    index: int = None
    '''Index number of cache files 

    :type: int
    '''

    info: str = None
    '''Info on current cache status 

    :type: str
    '''

    is_baked: bool = None
    '''

    :type: bool
    '''

    is_baking: bool = None
    '''

    :type: bool
    '''

    is_frame_skip: bool = None
    '''

    :type: bool
    '''

    is_outdated: bool = None
    '''

    :type: bool
    '''

    name: str = None
    '''Cache name 

    :type: str
    '''

    point_caches: typing.Union[typing.List['PointCacheItem'],
                               'bpy_prop_collection', 'PointCaches'] = None
    '''

    :type: typing.Union[typing.List['PointCacheItem'], 'bpy_prop_collection', 'PointCaches']
    '''

    use_disk_cache: bool = None
    '''Save cache files to disk (.blend file must be saved first) 

    :type: bool
    '''

    use_external: bool = None
    '''Read cache from an external location 

    :type: bool
    '''

    use_library_path: bool = None
    '''Use this file’s path for the disk cache when library linked into another file (for local bakes per scene file, disable this option) 

    :type: bool
    '''


class PointCacheItem(bpy_struct):
    '''Point cache for physics simulations '''

    compression: typing.Union[str, int] = None
    '''Compression method to be used 

    :type: typing.Union[str, int]
    '''

    filepath: str = None
    '''Cache file path 

    :type: str
    '''

    frame_end: int = None
    '''Frame on which the simulation stops 

    :type: int
    '''

    frame_start: int = None
    '''Frame on which the simulation starts 

    :type: int
    '''

    frame_step: int = None
    '''Number of frames between cached frames 

    :type: int
    '''

    index: int = None
    '''Index number of cache files 

    :type: int
    '''

    info: str = None
    '''Info on current cache status 

    :type: str
    '''

    is_baked: bool = None
    '''

    :type: bool
    '''

    is_baking: bool = None
    '''

    :type: bool
    '''

    is_frame_skip: bool = None
    '''

    :type: bool
    '''

    is_outdated: bool = None
    '''

    :type: bool
    '''

    name: str = None
    '''Cache name 

    :type: str
    '''

    use_disk_cache: bool = None
    '''Save cache files to disk (.blend file must be saved first) 

    :type: bool
    '''

    use_external: bool = None
    '''Read cache from an external location 

    :type: bool
    '''

    use_library_path: bool = None
    '''Use this file’s path for the disk cache when library linked into another file (for local bakes per scene file, disable this option) 

    :type: bool
    '''


class PointCaches(bpy_struct):
    '''Collection of point caches '''

    active_index: int = None
    '''

    :type: int
    '''


class PolygonFloatProperties(bpy_struct):
    '''Collection of float properties '''

    def new(self, name: str = "FloatProp") -> 'MeshPolygonFloatPropertyLayer':
        '''Add a float property layer to Mesh 

        :param name: Float property name 
        :type name: str
        :rtype: 'MeshPolygonFloatPropertyLayer'
        :return:  The newly created layer 
        '''
        pass


class PolygonIntProperties(bpy_struct):
    '''Collection of int properties '''

    def new(self, name: str = "IntProp") -> 'MeshPolygonIntPropertyLayer':
        '''Add a integer property layer to Mesh 

        :param name: Int property name 
        :type name: str
        :rtype: 'MeshPolygonIntPropertyLayer'
        :return:  The newly created layer 
        '''
        pass


class PolygonStringProperties(bpy_struct):
    '''Collection of string properties '''

    def new(self,
            name: str = "StringProp") -> 'MeshPolygonStringPropertyLayer':
        '''Add a string property layer to Mesh 

        :param name: String property name 
        :type name: str
        :rtype: 'MeshPolygonStringPropertyLayer'
        :return:  The newly created layer 
        '''
        pass


class Pose(bpy_struct):
    '''A collection of pose channels, including settings for animating bones '''

    animation_visualization: 'AnimViz' = None
    '''Animation data for this data-block 

    :type: 'AnimViz'
    '''

    bone_groups: typing.Union[typing.List['BoneGroup'], 'bpy_prop_collection',
                              'BoneGroups'] = None
    '''Groups of the bones 

    :type: typing.Union[typing.List['BoneGroup'], 'bpy_prop_collection', 'BoneGroups']
    '''

    bones: typing.Union[typing.List['PoseBone'], 'bpy_prop_collection'] = None
    '''Individual pose bones for the armature 

    :type: typing.Union[typing.List['PoseBone'], 'bpy_prop_collection']
    '''

    ik_param: 'IKParam' = None
    '''Parameters for IK solver 

    :type: 'IKParam'
    '''

    ik_solver: typing.Union[str, int] = None
    '''Selection of IK solver for IK chain 

    :type: typing.Union[str, int]
    '''

    use_auto_ik: bool = None
    '''Add temporary IK constraints while grabbing bones in Pose Mode 

    :type: bool
    '''

    use_mirror_relative: bool = None
    '''Apply relative transformations in X-mirror mode (not supported with Auto IK) 

    :type: bool
    '''

    use_mirror_x: bool = None
    '''Apply changes to matching bone on opposite side of X-Axis 

    :type: bool
    '''


class PoseBone(bpy_struct):
    '''Channel defining pose data for a bone in a Pose '''

    bbone_curveinx: float = None
    '''X-axis handle offset for start of the B-Bone’s curve, adjusts curvature 

    :type: float
    '''

    bbone_curveiny: float = None
    '''Y-axis handle offset for start of the B-Bone’s curve, adjusts curvature 

    :type: float
    '''

    bbone_curveoutx: float = None
    '''X-axis handle offset for end of the B-Bone’s curve, adjusts curvature 

    :type: float
    '''

    bbone_curveouty: float = None
    '''Y-axis handle offset for end of the B-Bone’s curve, adjusts curvature 

    :type: float
    '''

    bbone_custom_handle_end: 'PoseBone' = None
    '''Bone that serves as the end handle for the B-Bone curve 

    :type: 'PoseBone'
    '''

    bbone_custom_handle_start: 'PoseBone' = None
    '''Bone that serves as the start handle for the B-Bone curve 

    :type: 'PoseBone'
    '''

    bbone_easein: float = None
    '''Length of first Bezier Handle (for B-Bones only) 

    :type: float
    '''

    bbone_easeout: float = None
    '''Length of second Bezier Handle (for B-Bones only) 

    :type: float
    '''

    bbone_rollin: float = None
    '''Roll offset for the start of the B-Bone, adjusts twist 

    :type: float
    '''

    bbone_rollout: float = None
    '''Roll offset for the end of the B-Bone, adjusts twist 

    :type: float
    '''

    bbone_scaleinx: float = None
    '''X-axis scale factor for start of the B-Bone, adjusts thickness (for tapering effects) 

    :type: float
    '''

    bbone_scaleiny: float = None
    '''Y-axis scale factor for start of the B-Bone, adjusts thickness (for tapering effects) 

    :type: float
    '''

    bbone_scaleoutx: float = None
    '''X-axis scale factor for end of the B-Bone, adjusts thickness (for tapering effects) 

    :type: float
    '''

    bbone_scaleouty: float = None
    '''Y-axis scale factor for end of the B-Bone, adjusts thickness (for tapering effects) 

    :type: float
    '''

    bone: 'Bone' = None
    '''Bone associated with this PoseBone 

    :type: 'Bone'
    '''

    bone_group: 'BoneGroup' = None
    '''Bone Group this pose channel belongs to 

    :type: 'BoneGroup'
    '''

    bone_group_index: int = None
    '''Bone Group this pose channel belongs to (0=no group) 

    :type: int
    '''

    child: 'PoseBone' = None
    '''Child of this pose bone 

    :type: 'PoseBone'
    '''

    constraints: typing.Union[typing.List['Constraint'], 'bpy_prop_collection',
                              'PoseBoneConstraints'] = None
    '''Constraints that act on this PoseChannel 

    :type: typing.Union[typing.List['Constraint'], 'bpy_prop_collection', 'PoseBoneConstraints']
    '''

    custom_shape: 'Object' = None
    '''Object that defines custom draw type for this bone 

    :type: 'Object'
    '''

    custom_shape_scale: float = None
    '''Adjust the size of the custom shape 

    :type: float
    '''

    custom_shape_transform: 'PoseBone' = None
    '''Bone that defines the display transform of this custom shape 

    :type: 'PoseBone'
    '''

    head: typing.List[float] = None
    '''Location of head of the channel’s bone 

    :type: typing.List[float]
    '''

    ik_linear_weight: float = None
    '''Weight of scale constraint for IK 

    :type: float
    '''

    ik_max_x: float = None
    '''Maximum angles for IK Limit 

    :type: float
    '''

    ik_max_y: float = None
    '''Maximum angles for IK Limit 

    :type: float
    '''

    ik_max_z: float = None
    '''Maximum angles for IK Limit 

    :type: float
    '''

    ik_min_x: float = None
    '''Minimum angles for IK Limit 

    :type: float
    '''

    ik_min_y: float = None
    '''Minimum angles for IK Limit 

    :type: float
    '''

    ik_min_z: float = None
    '''Minimum angles for IK Limit 

    :type: float
    '''

    ik_rotation_weight: float = None
    '''Weight of rotation constraint for IK 

    :type: float
    '''

    ik_stiffness_x: float = None
    '''IK stiffness around the X axis 

    :type: float
    '''

    ik_stiffness_y: float = None
    '''IK stiffness around the Y axis 

    :type: float
    '''

    ik_stiffness_z: float = None
    '''IK stiffness around the Z axis 

    :type: float
    '''

    ik_stretch: float = None
    '''Allow scaling of the bone for IK 

    :type: float
    '''

    is_in_ik_chain: bool = None
    '''Is part of an IK chain 

    :type: bool
    '''

    length: float = None
    '''Length of the bone 

    :type: float
    '''

    location: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    lock_ik_x: bool = None
    '''Disallow movement around the X axis 

    :type: bool
    '''

    lock_ik_y: bool = None
    '''Disallow movement around the Y axis 

    :type: bool
    '''

    lock_ik_z: bool = None
    '''Disallow movement around the Z axis 

    :type: bool
    '''

    lock_location: typing.List[bool] = None
    '''Lock editing of location when transforming 

    :type: typing.List[bool]
    '''

    lock_rotation: typing.List[bool] = None
    '''Lock editing of rotation when transforming 

    :type: typing.List[bool]
    '''

    lock_rotation_w: bool = None
    '''Lock editing of ‘angle’ component of four-component rotations when transforming 

    :type: bool
    '''

    lock_rotations_4d: bool = None
    '''Lock editing of four component rotations by components (instead of as Eulers) 

    :type: bool
    '''

    lock_scale: typing.List[bool] = None
    '''Lock editing of scale when transforming 

    :type: typing.List[bool]
    '''

    matrix: typing.List[float] = None
    '''Final 4x4 matrix after constraints and drivers are applied (object space) 

    :type: typing.List[float]
    '''

    matrix_basis: typing.List[float] = None
    '''Alternative access to location/scale/rotation relative to the parent and own rest bone 

    :type: typing.List[float]
    '''

    matrix_channel: typing.List[float] = None
    '''4x4 matrix, before constraints 

    :type: typing.List[float]
    '''

    motion_path: 'MotionPath' = None
    '''Motion Path for this element 

    :type: 'MotionPath'
    '''

    name: str = None
    '''

    :type: str
    '''

    parent: 'PoseBone' = None
    '''Parent of this pose bone 

    :type: 'PoseBone'
    '''

    rotation_axis_angle: typing.List[float] = None
    '''Angle of Rotation for Axis-Angle rotation representation 

    :type: typing.List[float]
    '''

    rotation_euler: typing.List[float] = None
    '''Rotation in Eulers 

    :type: typing.List[float]
    '''

    rotation_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    rotation_quaternion: typing.List[float] = None
    '''Rotation in Quaternions 

    :type: typing.List[float]
    '''

    scale: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    tail: typing.List[float] = None
    '''Location of tail of the channel’s bone 

    :type: typing.List[float]
    '''

    use_custom_shape_bone_size: bool = None
    '''Scale the custom object by the bone length 

    :type: bool
    '''

    use_ik_limit_x: bool = None
    '''Limit movement around the X axis 

    :type: bool
    '''

    use_ik_limit_y: bool = None
    '''Limit movement around the Y axis 

    :type: bool
    '''

    use_ik_limit_z: bool = None
    '''Limit movement around the Z axis 

    :type: bool
    '''

    use_ik_linear_control: bool = None
    '''Apply channel size as IK constraint if stretching is enabled 

    :type: bool
    '''

    use_ik_rotation_control: bool = None
    '''Apply channel rotation as IK constraint 

    :type: bool
    '''

    basename = None
    '''The name of this bone before any ‘.’ character (readonly) '''

    center = None
    '''The midpoint between the head and the tail. (readonly) '''

    children = None
    '''(readonly) '''

    children_recursive = None
    '''A list of all children from this bone. Warning: takes O(len(bones)**2) time. (readonly) '''

    children_recursive_basename = None
    '''Returns a chain of children with the same base name as this bone. Only direct chains are supported, forks caused by multiple children with matching base names will terminate the function and not be returned. Warning: takes O(len(bones)**2) time. (readonly) '''

    parent_recursive = None
    '''A list of parents, starting with the immediate parent (readonly) '''

    vector = None
    '''The direction this bone is pointing. Utility function for (tail - head) (readonly) '''

    x_axis = None
    '''Vector pointing down the x-axis of the bone. (readonly) '''

    y_axis = None
    '''Vector pointing down the y-axis of the bone. (readonly) '''

    z_axis = None
    '''Vector pointing down the z-axis of the bone. (readonly) '''

    def evaluate_envelope(self, point: typing.List[float]) -> float:
        '''Calculate bone envelope at given point 

        :param point: Point, Position in 3d space to evaluate 
        :type point: typing.List[float]
        :rtype: float
        :return:  Factor, Envelope factor 
        '''
        pass

    def bbone_segment_matrix(self, index: int,
                             rest: bool = False) -> typing.List[float]:
        '''Retrieve the matrix of the joint between B-Bone segments if available 

        :param index: Index of the segment endpoint 
        :type index: int
        :param rest: Return the rest pose matrix 
        :type rest: bool
        :rtype: typing.List[float]
        :return:  The resulting matrix in bone local space 
        '''
        pass

    def compute_bbone_handles(self,
                              rest: bool = False,
                              ease: bool = False,
                              offsets: bool = False):
        '''Retrieve the vectors and rolls coming from B-Bone custom handles 

        :param rest: Return the rest pose state 
        :type rest: bool
        :param ease: Apply scale from ease values 
        :type ease: bool
        :param offsets: Apply roll and curve offsets from bone properties 
        :type offsets: bool
        '''
        pass

    def parent_index(self, parent_test):
        '''The same as ‘bone in other_bone.parent_recursive’ but saved generating a list. 

        '''
        pass

    def translate(self, vec):
        '''Utility function to add vec to the head and tail of this bone 

        '''
        pass


class PoseBoneConstraints(bpy_struct):
    '''Collection of pose bone constraints '''

    active: 'Constraint' = None
    '''Active PoseChannel constraint 

    :type: 'Constraint'
    '''

    def new(self, type: typing.Union[str, int]) -> 'Constraint':
        '''Add a constraint to this object 

        :param type: Constraint type to addCAMERA_SOLVER Camera Solver.FOLLOW_TRACK Follow Track.OBJECT_SOLVER Object Solver.COPY_LOCATION Copy Location, Copy the location of a target (with an optional offset), so that they move together.COPY_ROTATION Copy Rotation, Copy the rotation of a target (with an optional offset), so that they rotate together.COPY_SCALE Copy Scale, Copy the scale factors of a target (with an optional offset), so that they are scaled by the same amount.COPY_TRANSFORMS Copy Transforms, Copy all the transformations of a target, so that they move together.LIMIT_DISTANCE Limit Distance, Restrict movements to within a certain distance of a target (at the time of constraint evaluation only).LIMIT_LOCATION Limit Location, Restrict movement along each axis within given ranges.LIMIT_ROTATION Limit Rotation, Restrict rotation along each axis within given ranges.LIMIT_SCALE Limit Scale, Restrict scaling along each axis with given ranges.MAINTAIN_VOLUME Maintain Volume, Compensate for scaling one axis by applying suitable scaling to the other two axes.TRANSFORM Transformation, Use one transform property from target to control another (or same) property on owner.TRANSFORM_CACHE Transform Cache, Look up the transformation matrix from an external file.CLAMP_TO Clamp To, Restrict movements to lie along a curve by remapping location along curve’s longest axis.DAMPED_TRACK Damped Track, Point towards a target by performing the smallest rotation necessary.IK Inverse Kinematics, Control a chain of bones by specifying the endpoint target (Bones only).LOCKED_TRACK Locked Track, Rotate around the specified (‘locked’) axis to point towards a target.SPLINE_IK Spline IK, Align chain of bones along a curve (Bones only).STRETCH_TO Stretch To, Stretch along Y-Axis to point towards a target.TRACK_TO Track To, Legacy tracking constraint prone to twisting artifacts.ACTION Action, Use transform property of target to look up pose for owner from an Action.ARMATURE Armature, Apply weight-blended transformation from multiple bones like the Armature modifier.CHILD_OF Child Of, Make target the ‘detachable’ parent of owner.FLOOR Floor, Use position (and optionally rotation) of target to define a ‘wall’ or ‘floor’ that the owner can not cross.FOLLOW_PATH Follow Path, Use to animate an object/bone following a path.PIVOT Pivot, Change pivot point for transforms (buggy).SHRINKWRAP Shrinkwrap, Restrict movements to surface of target mesh. 
        :type type: typing.Union[str, int]
        :rtype: 'Constraint'
        :return:  New constraint 
        '''
        pass

    def remove(self, constraint: 'Constraint'):
        '''Remove a constraint from this object 

        :param constraint: Removed constraint 
        :type constraint: 'Constraint'
        '''
        pass

    def move(self, from_index: int, to_index: int):
        '''Move a constraint to a different position 

        :param from_index: From Index, Index to move 
        :type from_index: int
        :param to_index: To Index, Target index 
        :type to_index: int
        '''
        pass


class Preferences(bpy_struct):
    '''Global preferences '''

    active_section: typing.Union[str, int] = None
    '''Active section of the preferences shown in the user interface 

    :type: typing.Union[str, int]
    '''

    addons: typing.Union[typing.
                         List['Addon'], 'bpy_prop_collection', 'Addons'] = None
    '''

    :type: typing.Union[typing.List['Addon'], 'bpy_prop_collection', 'Addons']
    '''

    app_template: str = None
    '''

    :type: str
    '''

    autoexec_paths: typing.Union[typing.
                                 List['PathCompare'], 'bpy_prop_collection',
                                 'PathCompareCollection'] = None
    '''

    :type: typing.Union[typing.List['PathCompare'], 'bpy_prop_collection', 'PathCompareCollection']
    '''

    edit: 'PreferencesEdit' = None
    '''Settings for interacting with Blender data 

    :type: 'PreferencesEdit'
    '''

    experimental: 'PreferencesExperimental' = None
    '''Settings for features that are still early in their development stage 

    :type: 'PreferencesExperimental'
    '''

    filepaths: 'PreferencesFilePaths' = None
    '''Default paths for external files 

    :type: 'PreferencesFilePaths'
    '''

    inputs: 'PreferencesInput' = None
    '''Settings for input devices 

    :type: 'PreferencesInput'
    '''

    is_dirty: bool = None
    '''Preferences have changed 

    :type: bool
    '''

    keymap: 'PreferencesKeymap' = None
    '''Shortcut setup for keyboards and other input devices 

    :type: 'PreferencesKeymap'
    '''

    studio_lights: typing.Union[typing.List['StudioLight'],
                                'bpy_prop_collection', 'StudioLights'] = None
    '''

    :type: typing.Union[typing.List['StudioLight'], 'bpy_prop_collection', 'StudioLights']
    '''

    system: 'PreferencesSystem' = None
    '''Graphics driver and operating system settings 

    :type: 'PreferencesSystem'
    '''

    themes: typing.Union[typing.List['Theme'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['Theme'], 'bpy_prop_collection']
    '''

    ui_styles: typing.Union[typing.
                            List['ThemeStyle'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['ThemeStyle'], 'bpy_prop_collection']
    '''

    use_preferences_save: bool = None
    '''Save preferences on exit when modified (unless factory settings have been loaded) 

    :type: bool
    '''

    version: typing.List[int] = None
    '''Version of Blender the userpref.blend was saved with 

    :type: typing.List[int]
    '''

    view: 'PreferencesView' = None
    '''Preferences related to viewing data 

    :type: 'PreferencesView'
    '''


class PreferencesEdit(bpy_struct):
    '''Settings for interacting with Blender data '''

    auto_keying_mode: typing.Union[str, int] = None
    '''Mode of automatic keyframe insertion for Objects and Bones (default setting used for new Scenes) 

    :type: typing.Union[str, int]
    '''

    fcurve_new_auto_smoothing: typing.Union[str, int] = None
    '''Auto Handle Smoothing mode used for newly added F-Curves 

    :type: typing.Union[str, int]
    '''

    fcurve_unselected_alpha: float = None
    '''Amount that unselected F-Curves stand out from the background (Graph Editor) 

    :type: float
    '''

    grease_pencil_default_color: typing.List[float] = None
    '''Color of new annotation layers 

    :type: typing.List[float]
    '''

    grease_pencil_eraser_radius: int = None
    '''Radius of eraser ‘brush’ 

    :type: int
    '''

    grease_pencil_euclidean_distance: int = None
    '''Distance moved by mouse when drawing stroke to include 

    :type: int
    '''

    grease_pencil_manhattan_distance: int = None
    '''Pixels moved by mouse per axis when drawing stroke 

    :type: int
    '''

    keyframe_new_handle_type: typing.Union[str, int] = None
    '''Handle type for handles of new keyframes 

    :type: typing.Union[str, int]
    '''

    keyframe_new_interpolation_type: typing.Union[str, int] = None
    '''Interpolation mode used for first keyframe on newly added F-Curves (subsequent keyframes take interpolation from preceding keyframe) 

    :type: typing.Union[str, int]
    '''

    material_link: typing.Union[str, int] = None
    '''Toggle whether the material is linked to object data or the object block 

    :type: typing.Union[str, int]
    '''

    node_margin: int = None
    '''Minimum distance between nodes for Auto-offsetting nodes 

    :type: int
    '''

    object_align: typing.Union[str, int] = None
    '''When adding objects from a 3D View menu, either align them with that view or with the world 

    :type: typing.Union[str, int]
    '''

    sculpt_paint_overlay_color: typing.List[float] = None
    '''Color of texture overlay 

    :type: typing.List[float]
    '''

    undo_memory_limit: int = None
    '''Maximum memory usage in megabytes (0 means unlimited) 

    :type: int
    '''

    undo_steps: int = None
    '''Number of undo steps available (smaller values conserve memory) 

    :type: int
    '''

    use_auto_keying: bool = None
    '''Automatic keyframe insertion for Objects and Bones (default setting used for new Scenes) 

    :type: bool
    '''

    use_auto_keying_warning: bool = None
    '''Show warning indicators when transforming objects and bones if auto keying is enabled 

    :type: bool
    '''

    use_cursor_lock_adjust: bool = None
    '''Place the cursor without ‘jumping’ to the new location (when lock-to-cursor is used) 

    :type: bool
    '''

    use_duplicate_action: bool = None
    '''Causes actions to be duplicated with the object 

    :type: bool
    '''

    use_duplicate_armature: bool = None
    '''Causes armature data to be duplicated with the object 

    :type: bool
    '''

    use_duplicate_curve: bool = None
    '''Causes curve data to be duplicated with the object 

    :type: bool
    '''

    use_duplicate_grease_pencil: bool = None
    '''Causes grease pencil data to be duplicated with the object 

    :type: bool
    '''

    use_duplicate_light: bool = None
    '''Causes light data to be duplicated with the object 

    :type: bool
    '''

    use_duplicate_lightprobe: bool = None
    '''Causes light probe data to be duplicated with the object 

    :type: bool
    '''

    use_duplicate_material: bool = None
    '''Causes material data to be duplicated with the object 

    :type: bool
    '''

    use_duplicate_mesh: bool = None
    '''Causes mesh data to be duplicated with the object 

    :type: bool
    '''

    use_duplicate_metaball: bool = None
    '''Causes metaball data to be duplicated with the object 

    :type: bool
    '''

    use_duplicate_particle: bool = None
    '''Causes particle systems to be duplicated with the object 

    :type: bool
    '''

    use_duplicate_surface: bool = None
    '''Causes surface data to be duplicated with the object 

    :type: bool
    '''

    use_duplicate_text: bool = None
    '''Causes text data to be duplicated with the object 

    :type: bool
    '''

    use_enter_edit_mode: bool = None
    '''Enter Edit Mode automatically after adding a new object 

    :type: bool
    '''

    use_global_undo: bool = None
    '''Global undo works by keeping a full copy of the file itself in memory, so takes extra memory 

    :type: bool
    '''

    use_insertkey_xyz_to_rgb: bool = None
    '''Color for newly added transformation F-Curves (Location, Rotation, Scale) and also Color is based on the transform axis 

    :type: bool
    '''

    use_keyframe_insert_available: bool = None
    '''Automatic keyframe insertion in available F-Curves 

    :type: bool
    '''

    use_keyframe_insert_needed: bool = None
    '''Keyframe insertion only when keyframe needed 

    :type: bool
    '''

    use_mouse_depth_cursor: bool = None
    '''Use the surface depth for cursor placement 

    :type: bool
    '''

    use_negative_frames: bool = None
    '''Current frame number can be manually set to a negative value 

    :type: bool
    '''

    use_visual_keying: bool = None
    '''Use Visual keying automatically for constrained objects 

    :type: bool
    '''


class PreferencesExperimental(bpy_struct):
    '''Experimental features '''

    pass


class PreferencesFilePaths(bpy_struct):
    '''Default paths for external files '''

    animation_player: str = None
    '''Path to a custom animation/frame sequence player 

    :type: str
    '''

    animation_player_preset: typing.Union[str, int] = None
    '''Preset configs for external animation players 

    :type: typing.Union[str, int]
    '''

    auto_save_time: int = None
    '''The time (in minutes) to wait between automatic temporary saves 

    :type: int
    '''

    font_directory: str = None
    '''The default directory to search for loading fonts 

    :type: str
    '''

    hide_recent_locations: bool = None
    '''Hide recent locations in the file selector 

    :type: bool
    '''

    hide_system_bookmarks: bool = None
    '''Hide system bookmarks in the file selector 

    :type: bool
    '''

    i18n_branches_directory: str = None
    '''The path to the ‘/branches’ directory of your local svn-translation copy, to allow translating from the UI 

    :type: str
    '''

    image_editor: str = None
    '''Path to an image editor 

    :type: str
    '''

    recent_files: int = None
    '''Maximum number of recently opened files to remember 

    :type: int
    '''

    render_cache_directory: str = None
    '''Where to cache raw render results 

    :type: str
    '''

    render_output_directory: str = None
    '''The default directory for rendering output, for new scenes 

    :type: str
    '''

    save_version: int = None
    '''The number of old versions to maintain in the current directory, when manually saving 

    :type: int
    '''

    script_directory: str = None
    '''Alternate script path, matching the default layout with subdirs: startup, add-ons & modules (requires restart) 

    :type: str
    '''

    show_hidden_files_datablocks: bool = None
    '''Hide files and data-blocks if their name start with a dot (.*) 

    :type: bool
    '''

    sound_directory: str = None
    '''The default directory to search for sounds 

    :type: str
    '''

    temporary_directory: str = None
    '''The directory for storing temporary save files 

    :type: str
    '''

    texture_directory: str = None
    '''The default directory to search for textures 

    :type: str
    '''

    use_auto_save_temporary_files: bool = None
    '''Automatic saving of temporary files in temp directory, uses process ID (sculpt & edit-mode data won’t be saved!) 

    :type: bool
    '''

    use_file_compression: bool = None
    '''Enable file compression when saving .blend files 

    :type: bool
    '''

    use_filter_files: bool = None
    '''Display only files with extensions in the image select window 

    :type: bool
    '''

    use_load_ui: bool = None
    '''Load user interface setup when loading .blend files 

    :type: bool
    '''

    use_relative_paths: bool = None
    '''Default relative path option for the file selector 

    :type: bool
    '''

    use_save_preview_images: bool = None
    '''Enables automatic saving of preview images in the .blend file 

    :type: bool
    '''

    use_scripts_auto_execute: bool = None
    '''Allow any .blend file to run scripts automatically (unsafe with blend files from an untrusted source) 

    :type: bool
    '''

    use_tabs_as_spaces: bool = None
    '''Automatically convert all new tabs into spaces for new and loaded text files 

    :type: bool
    '''


class PreferencesInput(bpy_struct):
    '''Settings for input devices '''

    drag_threshold: int = None
    '''Number of pixels to drag before a drag event is triggered for keyboard and other non mouse/tablet input (otherwise click events are detected) 

    :type: int
    '''

    drag_threshold_mouse: int = None
    '''Number of pixels to drag before a tweak/drag event is triggered for mouse/track-pad input (otherwise click events are detected) 

    :type: int
    '''

    drag_threshold_tablet: int = None
    '''Number of pixels to drag before a tweak/drag event is triggered for tablet input (otherwise click events are detected) 

    :type: int
    '''

    invert_mouse_zoom: bool = None
    '''Invert the axis of mouse movement for zooming 

    :type: bool
    '''

    invert_zoom_wheel: bool = None
    '''Swap the Mouse Wheel zoom direction 

    :type: bool
    '''

    mouse_double_click_time: int = None
    '''Time/delay (in ms) for a double click 

    :type: int
    '''

    mouse_emulate_3_button_modifier: typing.Union[str, int] = None
    '''Hold this modifier to emulate the middle mouse button 

    :type: typing.Union[str, int]
    '''

    move_threshold: int = None
    '''Number of pixels to before the cursor is considered to have moved (used for cycling selected items on successive clicks) 

    :type: int
    '''

    navigation_mode: typing.Union[str, int] = None
    '''Which method to use for viewport navigation 

    :type: typing.Union[str, int]
    '''

    ndof_deadzone: float = None
    '''Threshold of initial movement needed from the device’s rest position 

    :type: float
    '''

    ndof_fly_helicopter: bool = None
    '''Device up/down directly controls your Z position 

    :type: bool
    '''

    ndof_lock_horizon: bool = None
    '''Keep horizon level while flying with 3D Mouse 

    :type: bool
    '''

    ndof_orbit_sensitivity: float = None
    '''Overall sensitivity of the 3D Mouse for orbiting 

    :type: float
    '''

    ndof_pan_yz_swap_axis: bool = None
    '''Pan using up/down on the device (otherwise forward/backward) 

    :type: bool
    '''

    ndof_panx_invert_axis: bool = None
    '''

    :type: bool
    '''

    ndof_pany_invert_axis: bool = None
    '''

    :type: bool
    '''

    ndof_panz_invert_axis: bool = None
    '''

    :type: bool
    '''

    ndof_rotx_invert_axis: bool = None
    '''

    :type: bool
    '''

    ndof_roty_invert_axis: bool = None
    '''

    :type: bool
    '''

    ndof_rotz_invert_axis: bool = None
    '''

    :type: bool
    '''

    ndof_sensitivity: float = None
    '''Overall sensitivity of the 3D Mouse for panning 

    :type: float
    '''

    ndof_show_guide: bool = None
    '''Display the center and axis during rotation 

    :type: bool
    '''

    ndof_view_navigate_method: typing.Union[str, int] = None
    '''Navigation style in the viewport 

    :type: typing.Union[str, int]
    '''

    ndof_view_rotate_method: typing.Union[str, int] = None
    '''Rotation style in the viewport 

    :type: typing.Union[str, int]
    '''

    ndof_zoom_invert: bool = None
    '''Zoom using opposite direction 

    :type: bool
    '''

    pressure_softness: float = None
    '''Adjusts softness of the low pressure response onset using a gamma curve 

    :type: float
    '''

    pressure_threshold_max: float = None
    '''Raw input pressure value that is interpreted as 100% by Blender 

    :type: float
    '''

    tablet_api: typing.Union[str, int] = None
    '''Select the tablet API to use for pressure sensitivity 

    :type: typing.Union[str, int]
    '''

    use_auto_perspective: bool = None
    '''Automatically switch between orthographic and perspective when changing from top/front/side views 

    :type: bool
    '''

    use_camera_lock_parent: bool = None
    '''When the camera is locked to the view and in fly mode, transform the parent rather than the camera 

    :type: bool
    '''

    use_drag_immediately: bool = None
    '''Moving things with a mouse drag confirms when releasing the button 

    :type: bool
    '''

    use_emulate_numpad: bool = None
    '''Main 1 to 0 keys act as the numpad ones (useful for laptops) 

    :type: bool
    '''

    use_mouse_continuous: bool = None
    '''Allow moving the mouse outside the view on some manipulations (transform, ui control drag) 

    :type: bool
    '''

    use_mouse_depth_navigate: bool = None
    '''Use the depth under the mouse to improve view pan/rotate/zoom functionality 

    :type: bool
    '''

    use_mouse_emulate_3_button: bool = None
    '''Emulate Middle Mouse with Alt+Left Mouse 

    :type: bool
    '''

    use_ndof: bool = None
    '''

    :type: bool
    '''

    use_numeric_input_advanced: bool = None
    '''When entering numbers while transforming, default to advanced mode for full math expression evaluation 

    :type: bool
    '''

    use_rotate_around_active: bool = None
    '''Use selection as the pivot point 

    :type: bool
    '''

    use_trackpad_natural: bool = None
    '''If your system uses ‘natural’ scrolling, this option keeps consistent trackpad usage throughout the UI 

    :type: bool
    '''

    use_zoom_to_mouse: bool = None
    '''Zoom in towards the mouse pointer’s position in the 3D view, rather than the 2D window center 

    :type: bool
    '''

    view_rotate_method: typing.Union[str, int] = None
    '''Orbit method in the viewport 

    :type: typing.Union[str, int]
    '''

    view_rotate_sensitivity_trackball: float = None
    '''Scale trackball orbit sensitivity 

    :type: float
    '''

    view_rotate_sensitivity_turntable: float = None
    '''Rotation amount per-pixel to control how fast the viewport orbits 

    :type: float
    '''

    view_zoom_axis: typing.Union[str, int] = None
    '''Axis of mouse movement to zoom in or out on 

    :type: typing.Union[str, int]
    '''

    view_zoom_method: typing.Union[str, int] = None
    '''Which style to use for viewport scaling 

    :type: typing.Union[str, int]
    '''

    walk_navigation: 'WalkNavigation' = None
    '''Settings for walk navigation mode 

    :type: 'WalkNavigation'
    '''

    wheel_scroll_lines: int = None
    '''Number of lines scrolled at a time with the mouse wheel 

    :type: int
    '''


class PreferencesKeymap(bpy_struct):
    '''Shortcut setup for keyboards and other input devices '''

    active_keyconfig: str = None
    '''The name of the active key configuration 

    :type: str
    '''

    show_ui_keyconfig: bool = None
    '''

    :type: bool
    '''


class PreferencesSystem(bpy_struct):
    '''Graphics driver and operating system settings '''

    anisotropic_filter: typing.Union[str, int] = None
    '''Quality of the anisotropic filtering (values greater than 1.0 enable anisotropic filtering) 

    :type: typing.Union[str, int]
    '''

    audio_channels: typing.Union[str, int] = None
    '''Audio channel count 

    :type: typing.Union[str, int]
    '''

    audio_device: typing.Union[str, int] = None
    '''Audio output device 

    :type: typing.Union[str, int]
    '''

    audio_mixing_buffer: typing.Union[str, int] = None
    '''Number of samples used by the audio mixing buffer 

    :type: typing.Union[str, int]
    '''

    audio_sample_format: typing.Union[str, int] = None
    '''Audio sample format 

    :type: typing.Union[str, int]
    '''

    audio_sample_rate: typing.Union[str, int] = None
    '''Audio sample rate 

    :type: typing.Union[str, int]
    '''

    dpi: int = None
    '''

    :type: int
    '''

    gl_clip_alpha: float = None
    '''Clip alpha below this threshold in the 3D textured view 

    :type: float
    '''

    gl_texture_limit: typing.Union[str, int] = None
    '''Limit the texture size to save graphics memory 

    :type: typing.Union[str, int]
    '''

    gpencil_multi_sample: typing.Union[str, int] = None
    '''Enable Grease Pencil OpenGL multi-sampling, only for systems that support it 

    :type: typing.Union[str, int]
    '''

    image_draw_method: typing.Union[str, int] = None
    '''Method used for displaying images on the screen 

    :type: typing.Union[str, int]
    '''

    legacy_compute_device_type: int = None
    '''For backwards compatibility only 

    :type: int
    '''

    light_ambient: typing.List[float] = None
    '''Color of the ambient light that uniformly lit the scene 

    :type: typing.List[float]
    '''

    memory_cache_limit: int = None
    '''Memory cache limit (in megabytes) 

    :type: int
    '''

    opensubdiv_compute_type: typing.Union[str, int] = None
    '''Type of computer back-end used with OpenSubdiv 

    :type: typing.Union[str, int]
    '''

    pixel_size: float = None
    '''

    :type: float
    '''

    prefetch_frames: int = None
    '''Number of frames to render ahead during playback (sequencer only) 

    :type: int
    '''

    scrollback: int = None
    '''Maximum number of lines to store for the console buffer 

    :type: int
    '''

    solid_lights: typing.Union[typing.List['UserSolidLight'],
                               'bpy_prop_collection'] = None
    '''Lights user to display objects in solid draw mode 

    :type: typing.Union[typing.List['UserSolidLight'], 'bpy_prop_collection']
    '''

    texture_collection_rate: int = None
    '''Number of seconds between each run of the GL texture garbage collector 

    :type: int
    '''

    texture_time_out: int = None
    '''Time since last access of a GL texture in seconds after which it is freed (set to 0 to keep textures allocated) 

    :type: int
    '''

    ui_line_width: float = None
    '''Suggested line thickness and point size in pixels, for add-ons drawing custom user interface elements, based on operating system settings and Blender UI scale 

    :type: float
    '''

    ui_scale: float = None
    '''Size multiplier to use when drawing custom user interface elements, so that they are scaled correctly on screens with different DPI. This value is based on operating system DPI settings and Blender display scale 

    :type: float
    '''

    use_edit_mode_smooth_wire: bool = None
    '''Enable Edit-Mode edge smoothing, reducing aliasing, requires restart 

    :type: bool
    '''

    use_overlay_smooth_wire: bool = None
    '''Enable overlay smooth wires, reducing aliasing 

    :type: bool
    '''

    use_region_overlap: bool = None
    '''Draw tool/property regions over the main region 

    :type: bool
    '''

    use_select_pick_depth: bool = None
    '''Use the depth buffer for picking 3D View selection (without this the front most object may not be selected first) 

    :type: bool
    '''

    use_studio_light_edit: bool = None
    '''View the result of the studio light editor in the viewport 

    :type: bool
    '''

    vbo_collection_rate: int = None
    '''Number of seconds between each run of the GL Vertex buffer object garbage collector 

    :type: int
    '''

    vbo_time_out: int = None
    '''Time since last access of a GL Vertex buffer object in seconds after which it is freed (set to 0 to keep vbo allocated) 

    :type: int
    '''

    viewport_aa: typing.Union[str, int] = None
    '''Method of anti-aliasing in 3d viewport 

    :type: typing.Union[str, int]
    '''


class PreferencesView(bpy_struct):
    '''Preferences related to viewing data '''

    color_picker_type: typing.Union[str, int] = None
    '''Different styles of displaying the color picker widget 

    :type: typing.Union[str, int]
    '''

    factor_display_type: typing.Union[str, int] = None
    '''How factor values are displayed 

    :type: typing.Union[str, int]
    '''

    filebrowser_display_type: typing.Union[str, int] = None
    '''Default location where the File Editor will be displayed in 

    :type: typing.Union[str, int]
    '''

    font_path_ui: str = None
    '''Path to interface font 

    :type: str
    '''

    font_path_ui_mono: str = None
    '''Path to interface mono-space Font 

    :type: str
    '''

    gizmo_size: int = None
    '''Diameter of the gizmo 

    :type: int
    '''

    header_align: typing.Union[str, int] = None
    '''Default header position for new space-types 

    :type: typing.Union[str, int]
    '''

    language: typing.Union[str, int] = None
    '''Language used for translation 

    :type: typing.Union[str, int]
    '''

    lookdev_sphere_size: int = None
    '''Diameter of the HDRI preview spheres 

    :type: int
    '''

    mini_axis_brightness: int = None
    '''Brightness of the icon 

    :type: int
    '''

    mini_axis_size: int = None
    '''The axes icon’s size 

    :type: int
    '''

    mini_axis_type: typing.Union[str, int] = None
    '''Show a small rotating 3D axes in the top right corner of the 3D View 

    :type: typing.Union[str, int]
    '''

    open_sublevel_delay: int = None
    '''Time delay in 1/10 seconds before automatically opening sub level menus 

    :type: int
    '''

    open_toplevel_delay: int = None
    '''Time delay in 1/10 seconds before automatically opening top level menus 

    :type: int
    '''

    pie_animation_timeout: int = None
    '''Time needed to fully animate the pie to unfolded state (in 1/100ths of sec) 

    :type: int
    '''

    pie_initial_timeout: int = None
    '''Pie menus will use the initial mouse position as center for this amount of time (in 1/100ths of sec) 

    :type: int
    '''

    pie_menu_confirm: int = None
    '''Distance threshold after which selection is made (zero to disable) 

    :type: int
    '''

    pie_menu_radius: int = None
    '''Pie menu size in pixels 

    :type: int
    '''

    pie_menu_threshold: int = None
    '''Distance from center needed before a selection can be made 

    :type: int
    '''

    pie_tap_timeout: int = None
    '''Pie menu button held longer than this will dismiss menu on release.(in 1/100ths of sec) 

    :type: int
    '''

    render_display_type: typing.Union[str, int] = None
    '''Default location where rendered images will be displayed in 

    :type: typing.Union[str, int]
    '''

    rotation_angle: float = None
    '''Rotation step for numerical pad keys (2 4 6 8) 

    :type: float
    '''

    show_addons_enabled_only: bool = None
    '''Only show enabled add-ons. Un-check to see all installed add-ons 

    :type: bool
    '''

    show_column_layout: bool = None
    '''Use a column layout for toolbox 

    :type: bool
    '''

    show_developer_ui: bool = None
    '''Show options for developers (edit source in context menu, geometry indices) 

    :type: bool
    '''

    show_gizmo: bool = None
    '''Use transform gizmos by default 

    :type: bool
    '''

    show_large_cursors: bool = None
    '''Use large mouse cursors when available 

    :type: bool
    '''

    show_layout_ui: bool = None
    '''Split and join editors by dragging from corners 

    :type: bool
    '''

    show_navigate_ui: bool = None
    '''Show navigation controls in 2D & 3D views which do not have scroll bars 

    :type: bool
    '''

    show_object_info: bool = None
    '''Display objects name and frame number in 3D view 

    :type: bool
    '''

    show_playback_fps: bool = None
    '''Show the frames per second screen refresh rate, while animation is played back 

    :type: bool
    '''

    show_splash: bool = None
    '''Display splash screen on startup 

    :type: bool
    '''

    show_tooltips: bool = None
    '''Display tooltips (when off hold Alt to force display) 

    :type: bool
    '''

    show_tooltips_python: bool = None
    '''Show Python references in tooltips 

    :type: bool
    '''

    show_view_name: bool = None
    '''Show the name of the view’s direction in each 3D View 

    :type: bool
    '''

    smooth_view: int = None
    '''Time to animate the view in milliseconds, zero to disable 

    :type: int
    '''

    text_hinting: typing.Union[str, int] = None
    '''Method for making user interface text render sharp 

    :type: typing.Union[str, int]
    '''

    timecode_style: typing.Union[str, int] = None
    '''Format of Time Codes displayed when not displaying timing in terms of frames 

    :type: typing.Union[str, int]
    '''

    ui_line_width: typing.Union[str, int] = None
    '''Changes the thickness of widget outlines, lines and points in the interface, for high DPI displays 

    :type: typing.Union[str, int]
    '''

    ui_scale: float = None
    '''Changes the size of the fonts and widgets in the interface 

    :type: float
    '''

    use_directional_menus: bool = None
    '''Otherwise menus, etc will always be top to bottom, left to right, no matter opening direction 

    :type: bool
    '''

    use_international_fonts: bool = None
    '''Enable UI translation and use international fonts 

    :type: bool
    '''

    use_mouse_over_open: bool = None
    '''Open menu buttons and pulldowns automatically when the mouse is hovering 

    :type: bool
    '''

    use_save_prompt: bool = None
    '''Ask for confirmation when quitting with unsaved changes 

    :type: bool
    '''

    use_text_antialiasing: bool = None
    '''Draw user interface text anti-aliased 

    :type: bool
    '''

    use_translate_interface: bool = None
    '''Translate all labels in menus, buttons and panels (note that this might make it hard to follow tutorials or the manual) 

    :type: bool
    '''

    use_translate_new_dataname: bool = None
    '''Translate the names of new data-blocks (objects, materials…) 

    :type: bool
    '''

    use_translate_tooltips: bool = None
    '''Translate the descriptions when hovering UI elements (recommended) 

    :type: bool
    '''

    use_weight_color_range: bool = None
    '''Enable color range used for weight visualization in weight painting mode 

    :type: bool
    '''

    view2d_grid_spacing_min: int = None
    '''Minimum number of pixels between each gridline in 2D Viewports 

    :type: int
    '''

    view_frame_keyframes: int = None
    '''Keyframes around cursor that we zoom around 

    :type: int
    '''

    view_frame_seconds: float = None
    '''Seconds around cursor that we zoom around 

    :type: float
    '''

    view_frame_type: typing.Union[str, int] = None
    '''How zooming to frame focuses around current frame 

    :type: typing.Union[str, int]
    '''

    weight_color_range: 'ColorRamp' = None
    '''Color range used for weight visualization in weight painting mode 

    :type: 'ColorRamp'
    '''


class Property(bpy_struct):
    '''RNA property definition '''

    description: str = None
    '''Description of the property for tooltips 

    :type: str
    '''

    icon: typing.Union[str, int] = None
    '''Icon of the item 

    :type: typing.Union[str, int]
    '''

    identifier: str = None
    '''Unique name used in the code and scripting 

    :type: str
    '''

    is_animatable: bool = None
    '''Property is animatable through RNA 

    :type: bool
    '''

    is_argument_optional: bool = None
    '''True when the property is optional in a Python function implementing an RNA function 

    :type: bool
    '''

    is_enum_flag: bool = None
    '''True when multiple enums 

    :type: bool
    '''

    is_hidden: bool = None
    '''True when the property is hidden 

    :type: bool
    '''

    is_library_editable: bool = None
    '''Property is editable from linked instances (changes not saved) 

    :type: bool
    '''

    is_never_none: bool = None
    '''True when this value can’t be set to None 

    :type: bool
    '''

    is_output: bool = None
    '''True when this property is an output value from an RNA function 

    :type: bool
    '''

    is_overridable: bool = None
    '''Property is overridable through RNA 

    :type: bool
    '''

    is_readonly: bool = None
    '''Property is editable through RNA 

    :type: bool
    '''

    is_registered: bool = None
    '''Property is registered as part of type registration 

    :type: bool
    '''

    is_registered_optional: bool = None
    '''Property is optionally registered as part of type registration 

    :type: bool
    '''

    is_required: bool = None
    '''False when this property is an optional argument in an RNA function 

    :type: bool
    '''

    is_runtime: bool = None
    '''Property has been dynamically created at runtime 

    :type: bool
    '''

    is_skip_save: bool = None
    '''True when the property is not saved in presets 

    :type: bool
    '''

    name: str = None
    '''Human readable name 

    :type: str
    '''

    srna: 'Struct' = None
    '''Struct definition used for properties assigned to this item 

    :type: 'Struct'
    '''

    subtype: typing.Union[str, int] = None
    '''Semantic interpretation of the property 

    :type: typing.Union[str, int]
    '''

    tags: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Subset of tags (defined in parent struct) that are set for this property 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    translation_context: str = None
    '''Translation context of the property’s name 

    :type: str
    '''

    type: typing.Union[str, int] = None
    '''Data type of the property 

    :type: typing.Union[str, int]
    '''

    unit: typing.Union[str, int] = None
    '''Type of units for this property 

    :type: typing.Union[str, int]
    '''


class PropertyGroup(bpy_struct):
    '''Group of ID properties '''

    name: str = None
    '''Unique name used in the code and scripting 

    :type: str
    '''


class PropertyGroupItem(bpy_struct):
    '''Property that stores arbitrary, user defined properties '''

    collection: typing.Union[typing.List['PropertyGroup'],
                             'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['PropertyGroup'], 'bpy_prop_collection']
    '''

    double: float = None
    '''

    :type: float
    '''

    double_array: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    float: float = None
    '''

    :type: float
    '''

    float_array: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    group: 'PropertyGroup' = None
    '''

    :type: 'PropertyGroup'
    '''

    id: 'ID' = None
    '''

    :type: 'ID'
    '''

    idp_array: typing.Union[typing.List['PropertyGroup'],
                            'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['PropertyGroup'], 'bpy_prop_collection']
    '''

    int: int = None
    '''

    :type: int
    '''

    int_array: typing.List[int] = None
    '''

    :type: typing.List[int]
    '''

    string: str = None
    '''

    :type: str
    '''


class Region(bpy_struct):
    '''Region in a subdivided screen area '''

    alignment: typing.Union[str, int] = None
    '''Alignment of the region within the area 

    :type: typing.Union[str, int]
    '''

    height: int = None
    '''Region height 

    :type: int
    '''

    type: typing.Union[str, int] = None
    '''Type of this region 

    :type: typing.Union[str, int]
    '''

    view2d: 'View2D' = None
    '''2D view of the region 

    :type: 'View2D'
    '''

    width: int = None
    '''Region width 

    :type: int
    '''

    x: int = None
    '''The window relative vertical location of the region 

    :type: int
    '''

    y: int = None
    '''The window relative horizontal location of the region 

    :type: int
    '''

    def tag_redraw(self, ):
        '''tag_redraw 

        '''
        pass


class RegionView3D(bpy_struct):
    '''3D View region data '''

    clip_planes: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    is_orthographic_side_view: bool = None
    '''Is current view an orthographic side view 

    :type: bool
    '''

    is_perspective: bool = None
    '''

    :type: bool
    '''

    lock_rotation: bool = None
    '''Lock view rotation in side views 

    :type: bool
    '''

    perspective_matrix: typing.List[float] = None
    '''Current perspective matrix (window_matrix * view_matrix) 

    :type: typing.List[float]
    '''

    show_sync_view: bool = None
    '''Sync view position between side views 

    :type: bool
    '''

    use_box_clip: bool = None
    '''Clip objects based on what’s visible in other side views 

    :type: bool
    '''

    use_clip_planes: bool = None
    '''

    :type: bool
    '''

    view_camera_offset: typing.List[float] = None
    '''View shift in camera view 

    :type: typing.List[float]
    '''

    view_camera_zoom: float = None
    '''Zoom factor in camera view 

    :type: float
    '''

    view_distance: float = None
    '''Distance to the view location 

    :type: float
    '''

    view_location: typing.List[float] = None
    '''View pivot location 

    :type: typing.List[float]
    '''

    view_matrix: typing.List[float] = None
    '''Current view matrix 

    :type: typing.List[float]
    '''

    view_perspective: typing.Union[str, int] = None
    '''View Perspective 

    :type: typing.Union[str, int]
    '''

    view_rotation: typing.List[float] = None
    '''Rotation in quaternions (keep normalized) 

    :type: typing.List[float]
    '''

    window_matrix: typing.List[float] = None
    '''Current window matrix 

    :type: typing.List[float]
    '''

    def update(self, ):
        '''Recalculate the view matrices 

        '''
        pass


class RenderEngine(bpy_struct):
    '''Render engine '''

    bl_idname: str = None
    '''

    :type: str
    '''

    bl_label: str = None
    '''

    :type: str
    '''

    bl_use_eevee_viewport: bool = None
    '''Uses Eevee for viewport shading in LookDev shading mode 

    :type: bool
    '''

    bl_use_postprocess: bool = None
    '''Apply compositing on render results 

    :type: bool
    '''

    bl_use_preview: bool = None
    '''Render engine supports being used for rendering previews of materials, lights and worlds 

    :type: bool
    '''

    bl_use_save_buffers: bool = None
    '''Support render to an on disk buffer during rendering 

    :type: bool
    '''

    bl_use_shading_nodes_custom: bool = None
    '''Don’t expose Cycles and Eevee shading nodes in the node editor user interface, so own nodes can be used instead 

    :type: bool
    '''

    bl_use_spherical_stereo: bool = None
    '''Support spherical stereo camera models 

    :type: bool
    '''

    camera_override: 'Object' = None
    '''

    :type: 'Object'
    '''

    is_animation: bool = None
    '''

    :type: bool
    '''

    is_preview: bool = None
    '''

    :type: bool
    '''

    layer_override: typing.List[bool] = None
    '''

    :type: typing.List[bool]
    '''

    render: 'RenderSettings' = None
    '''

    :type: 'RenderSettings'
    '''

    resolution_x: int = None
    '''

    :type: int
    '''

    resolution_y: int = None
    '''

    :type: int
    '''

    tile_x: int = None
    '''

    :type: int
    '''

    tile_y: int = None
    '''

    :type: int
    '''

    use_highlight_tiles: bool = None
    '''

    :type: bool
    '''

    def update(self, data=None, depsgraph=None):
        '''Export scene data for render 

        '''
        pass

    def render(self, depsgraph):
        '''Render scene into an image 

        '''
        pass

    def bake(self, depsgraph, object, pass_type: typing.Union[str, int],
             pass_filter: int, object_id: int, pixel_array, num_pixels: int,
             depth: int, result):
        '''Bake passes 

        :param pass_type: Pass, Pass to bake 
        :type pass_type: typing.Union[str, int]
        :param pass_filter: Pass Filter, Filter to combined, diffuse, glossy, transmission and subsurface passes 
        :type pass_filter: int
        :param object_id: Object Id, Id of the current object being baked in relation to the others 
        :type object_id: int
        :param num_pixels: Number of Pixels, Size of the baking batch 
        :type num_pixels: int
        :param depth: Pixels depth, Number of channels 
        :type depth: int
        '''
        pass

    def view_update(self, context, depsgraph):
        '''Update on data changes for viewport render 

        '''
        pass

    def view_draw(self, context, depsgraph):
        '''Draw viewport render 

        '''
        pass

    def update_script_node(self, node=None):
        '''Compile shader script node 

        '''
        pass

    def update_render_passes(self, scene=None, renderlayer=None):
        '''Update the render passes that will be generated 

        '''
        pass

    def tag_redraw(self, ):
        '''Request redraw for viewport rendering 

        '''
        pass

    def tag_update(self, ):
        '''Request update call for viewport rendering 

        '''
        pass

    def begin_result(self,
                     x: int,
                     y: int,
                     w: int,
                     h: int,
                     layer: str = "",
                     view: str = "") -> 'RenderResult':
        '''Create render result to write linear floating point render layers and passes 

        :param x: X 
        :type x: int
        :param y: Y 
        :type y: int
        :param w: Width 
        :type w: int
        :param h: Height 
        :type h: int
        :param layer: Layer, Single layer to get render result for 
        :type layer: str
        :param view: View, Single view to get render result for 
        :type view: str
        :rtype: 'RenderResult'
        :return:  Result 
        '''
        pass

    def update_result(self, result: 'RenderResult'):
        '''Signal that pixels have been updated and can be redrawn in the user interface 

        :param result: Result 
        :type result: 'RenderResult'
        '''
        pass

    def end_result(self,
                   result: 'RenderResult',
                   cancel: bool = False,
                   highlight: bool = False,
                   do_merge_results: bool = False):
        '''All pixels in the render result have been set and are final 

        :param result: Result 
        :type result: 'RenderResult'
        :param cancel: Cancel, Don’t mark tile as done, don’t merge results unless forced 
        :type cancel: bool
        :param highlight: Highlight, Don’t mark tile as done yet 
        :type highlight: bool
        :param do_merge_results: Merge Results, Merge results even if cancel=true 
        :type do_merge_results: bool
        '''
        pass

    def add_pass(self, name: str, channels: int, chan_id: str,
                 layer: str = ""):
        '''Add a pass to the render layer 

        :param name: Name, Name of the Pass, without view or channel tag 
        :type name: str
        :param channels: Channels 
        :type channels: int
        :param chan_id: Channel IDs, Channel names, one character per channel 
        :type chan_id: str
        :param layer: Layer, Single layer to add render pass to 
        :type layer: str
        '''
        pass

    def get_result(self, ) -> 'RenderResult':
        '''Get final result for non-pixel operations 

        :rtype: 'RenderResult'
        :return:  Result 
        '''
        pass

    def test_break(self, ) -> bool:
        '''Test if the render operation should been canceled, this is a fast call that should be used regularly for responsiveness 

        :rtype: bool
        :return:  Break 
        '''
        pass

    def active_view_get(self, ) -> str:
        '''active_view_get 

        :rtype: str
        :return:  View, Single view active 
        '''
        pass

    def active_view_set(self, view: str):
        '''active_view_set 

        :param view: View, Single view to set as active 
        :type view: str
        '''
        pass

    def camera_shift_x(self, camera,
                       use_spherical_stereo: bool = False) -> float:
        '''camera_shift_x 

        :param use_spherical_stereo: Spherical Stereo 
        :type use_spherical_stereo: bool
        :rtype: float
        :return:  Shift X 
        '''
        pass

    def camera_model_matrix(self,
                            camera,
                            use_spherical_stereo: bool = False,
                            r_model_matrix=0.0) -> typing.List[float]:
        '''camera_model_matrix 

        :param use_spherical_stereo: Spherical Stereo 
        :type use_spherical_stereo: bool
        :rtype: typing.List[float]
        :return:  Model Matrix, Normalized camera model matrix 
        '''
        pass

    def use_spherical_stereo(self, camera) -> bool:
        '''use_spherical_stereo 

        :rtype: bool
        :return:  Spherical Stereo 
        '''
        pass

    def update_stats(self, stats: str, info: str):
        '''Update and signal to redraw render status text 

        :param stats: Stats 
        :type stats: str
        :param info: Info 
        :type info: str
        '''
        pass

    def frame_set(self, frame: int, subframe: float):
        '''Evaluate scene at a different frame (for motion blur) 

        :param frame: Frame 
        :type frame: int
        :param subframe: Subframe 
        :type subframe: float
        '''
        pass

    def update_progress(self, progress: float):
        '''Update progress percentage of render 

        :param progress: Percentage of render that’s done 
        :type progress: float
        '''
        pass

    def update_memory_stats(self,
                            memory_used: float = 0.0,
                            memory_peak: float = 0.0):
        '''Update memory usage statistics 

        :param memory_used: Current memory usage in megabytes 
        :type memory_used: float
        :param memory_peak: Peak memory usage in megabytes 
        :type memory_peak: float
        '''
        pass

    def report(self, type: typing.Union[typing.Set[str], typing.Set[int]],
               message: str):
        '''Report info, warning or error messages 

        :param type: Type 
        :type type: typing.Union[typing.Set[str], typing.Set[int]]
        :param message: Report Message 
        :type message: str
        '''
        pass

    def error_set(self, message: str):
        '''Set error message displaying after the render is finished 

        :param message: Report Message 
        :type message: str
        '''
        pass

    def bind_display_space_shader(self, scene):
        '''Bind GLSL fragment shader that converts linear colors to display space colors using scene color management settings 

        '''
        pass

    def unbind_display_space_shader(self, ):
        '''Unbind GLSL display space shader, must always be called after binding the shader 

        '''
        pass

    def support_display_space_shader(self, scene) -> bool:
        '''Test if GLSL display space shader is supported for the combination of graphics card and scene settings 

        :rtype: bool
        :return:  Supported 
        '''
        pass

    def get_preview_pixel_size(self, scene) -> int:
        '''Free Blender side memory of render engine 

        :rtype: int
        :return:  Pixel Size 
        '''
        pass

    def free_blender_memory(self, ):
        '''free_blender_memory 

        '''
        pass

    def register_pass(self, scene, view_layer, name: str, channels: int,
                      chanid: str, type: typing.Union[str, int]):
        '''Register a render pass that will be part of the render with the current settings 

        :param name: Name 
        :type name: str
        :param channels: Channels 
        :type channels: int
        :param chanid: Channel IDs 
        :type chanid: str
        :param type: Type 
        :type type: typing.Union[str, int]
        '''
        pass


class RenderLayer(bpy_struct):
    invert_zmask: bool = None
    '''For Zmask, only render what is behind solid z values instead of in front 

    :type: bool
    '''

    name: str = None
    '''View layer name 

    :type: str
    '''

    passes: typing.Union[typing.List['RenderPass'], 'bpy_prop_collection',
                         'RenderPasses'] = None
    '''

    :type: typing.Union[typing.List['RenderPass'], 'bpy_prop_collection', 'RenderPasses']
    '''

    use_all_z: bool = None
    '''Fill in Z values for solid faces in invisible layers, for masking 

    :type: bool
    '''

    use_ao: bool = None
    '''Render Ambient Occlusion in this Layer 

    :type: bool
    '''

    use_edge_enhance: bool = None
    '''Render Edge-enhance in this Layer (only works for Solid faces) 

    :type: bool
    '''

    use_halo: bool = None
    '''Render Halos in this Layer (on top of Solid) 

    :type: bool
    '''

    use_pass_ambient_occlusion: bool = None
    '''Deliver Ambient Occlusion pass 

    :type: bool
    '''

    use_pass_combined: bool = None
    '''Deliver full combined RGBA buffer 

    :type: bool
    '''

    use_pass_diffuse_color: bool = None
    '''Deliver diffuse color pass 

    :type: bool
    '''

    use_pass_diffuse_direct: bool = None
    '''Deliver diffuse direct pass 

    :type: bool
    '''

    use_pass_diffuse_indirect: bool = None
    '''Deliver diffuse indirect pass 

    :type: bool
    '''

    use_pass_emit: bool = None
    '''Deliver emission pass 

    :type: bool
    '''

    use_pass_environment: bool = None
    '''Deliver environment lighting pass 

    :type: bool
    '''

    use_pass_glossy_color: bool = None
    '''Deliver glossy color pass 

    :type: bool
    '''

    use_pass_glossy_direct: bool = None
    '''Deliver glossy direct pass 

    :type: bool
    '''

    use_pass_glossy_indirect: bool = None
    '''Deliver glossy indirect pass 

    :type: bool
    '''

    use_pass_material_index: bool = None
    '''Deliver material index pass 

    :type: bool
    '''

    use_pass_mist: bool = None
    '''Deliver mist factor pass (0.0-1.0) 

    :type: bool
    '''

    use_pass_normal: bool = None
    '''Deliver normal pass 

    :type: bool
    '''

    use_pass_object_index: bool = None
    '''Deliver object index pass 

    :type: bool
    '''

    use_pass_shadow: bool = None
    '''Deliver shadow pass 

    :type: bool
    '''

    use_pass_subsurface_color: bool = None
    '''Deliver subsurface color pass 

    :type: bool
    '''

    use_pass_subsurface_direct: bool = None
    '''Deliver subsurface direct pass 

    :type: bool
    '''

    use_pass_subsurface_indirect: bool = None
    '''Deliver subsurface indirect pass 

    :type: bool
    '''

    use_pass_transmission_color: bool = None
    '''Deliver transmission color pass 

    :type: bool
    '''

    use_pass_transmission_direct: bool = None
    '''Deliver transmission direct pass 

    :type: bool
    '''

    use_pass_transmission_indirect: bool = None
    '''Deliver transmission indirect pass 

    :type: bool
    '''

    use_pass_uv: bool = None
    '''Deliver texture UV pass 

    :type: bool
    '''

    use_pass_vector: bool = None
    '''Deliver speed vector pass 

    :type: bool
    '''

    use_pass_z: bool = None
    '''Deliver Z values pass 

    :type: bool
    '''

    use_sky: bool = None
    '''Render Sky in this Layer 

    :type: bool
    '''

    use_solid: bool = None
    '''Render Solid faces in this Layer 

    :type: bool
    '''

    use_strand: bool = None
    '''Render Strands in this Layer 

    :type: bool
    '''

    use_zmask: bool = None
    '''Only render what’s in front of the solid z values 

    :type: bool
    '''

    use_ztransp: bool = None
    '''Render Z-Transparent faces in this Layer (on top of Solid and Halos) 

    :type: bool
    '''

    def load_from_file(self, filename: str, x: int = 0, y: int = 0):
        '''Copies the pixels of this renderlayer from an image file 

        :param filename: Filename, Filename to load into this render tile, must be no smaller than the renderlayer 
        :type filename: str
        :param x: Offset X, Offset the position to copy from if the image is larger than the render layer 
        :type x: int
        :param y: Offset Y, Offset the position to copy from if the image is larger than the render layer 
        :type y: int
        '''
        pass


class RenderPass(bpy_struct):
    channel_id: str = None
    '''

    :type: str
    '''

    channels: int = None
    '''

    :type: int
    '''

    fullname: str = None
    '''

    :type: str
    '''

    name: str = None
    '''

    :type: str
    '''

    rect: float = None
    '''

    :type: float
    '''

    view_id: int = None
    '''

    :type: int
    '''


class RenderPasses(bpy_struct):
    '''Collection of render passes '''

    def find_by_type(self, pass_type: typing.Union[str, int],
                     view: str) -> 'RenderPass':
        '''Get the render pass for a given type and view 

        :param pass_type: Pass 
        :type pass_type: typing.Union[str, int]
        :param view: View, Render view to get pass from 
        :type view: str
        :rtype: 'RenderPass'
        :return:  The matching render pass 
        '''
        pass

    def find_by_name(self, name: str, view: str) -> 'RenderPass':
        '''Get the render pass for a given name and view 

        :param name: Pass 
        :type name: str
        :param view: View, Render view to get pass from 
        :type view: str
        :rtype: 'RenderPass'
        :return:  The matching render pass 
        '''
        pass


class RenderResult(bpy_struct):
    '''Result of rendering, including all layers and passes '''

    layers: typing.Union[typing.
                         List['RenderLayer'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['RenderLayer'], 'bpy_prop_collection']
    '''

    resolution_x: int = None
    '''

    :type: int
    '''

    resolution_y: int = None
    '''

    :type: int
    '''

    views: typing.Union[typing.
                        List['RenderView'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['RenderView'], 'bpy_prop_collection']
    '''

    def load_from_file(self, filename: str):
        '''Copies the pixels of this render result from an image file 

        :param filename: File Name, Filename to load into this render tile, must be no smaller than the render result 
        :type filename: str
        '''
        pass

    def stamp_data_add_field(self, field: str, value: str):
        '''Add engine-specific stamp data to the result 

        :param field: Field, Name of the stamp field to add 
        :type field: str
        :param value: Value, Value of the stamp data 
        :type value: str
        '''
        pass


class RenderSettings(bpy_struct):
    '''Rendering settings for a Scene data-block '''

    bake: 'BakeSettings' = None
    '''

    :type: 'BakeSettings'
    '''

    bake_bias: float = None
    '''Bias towards faces further away from the object (in blender units) 

    :type: float
    '''

    bake_margin: int = None
    '''Extends the baked result as a post process filter 

    :type: int
    '''

    bake_samples: int = None
    '''Number of samples used for ambient occlusion baking from multires 

    :type: int
    '''

    bake_type: typing.Union[str, int] = None
    '''Choose shading information to bake into the image 

    :type: typing.Union[str, int]
    '''

    bake_user_scale: float = None
    '''Instead of automatically normalizing to 0..1, apply a user scale to the derivative map 

    :type: float
    '''

    border_max_x: float = None
    '''Maximum X value for the render region 

    :type: float
    '''

    border_max_y: float = None
    '''Maximum Y value for the render region 

    :type: float
    '''

    border_min_x: float = None
    '''Minimum X value for the render region 

    :type: float
    '''

    border_min_y: float = None
    '''Minimum Y value for the render region 

    :type: float
    '''

    dither_intensity: float = None
    '''Amount of dithering noise added to the rendered image to break up banding 

    :type: float
    '''

    engine: typing.Union[str, int] = None
    '''Engine to use for rendering 

    :type: typing.Union[str, int]
    '''

    ffmpeg: 'FFmpegSettings' = None
    '''FFmpeg related settings for the scene 

    :type: 'FFmpegSettings'
    '''

    file_extension: str = None
    '''The file extension used for saving renders 

    :type: str
    '''

    filepath: str = None
    '''Directory/name to save animations, # characters defines the position and length of frame numbers 

    :type: str
    '''

    film_transparent: bool = None
    '''World background is transparent, for compositing the render over another background 

    :type: bool
    '''

    filter_size: float = None
    '''Width over which the reconstruction filter combines samples 

    :type: float
    '''

    fps: int = None
    '''Framerate, expressed in frames per second 

    :type: int
    '''

    fps_base: float = None
    '''Framerate base 

    :type: float
    '''

    frame_map_new: int = None
    '''How many frames the Map Old will last 

    :type: int
    '''

    frame_map_old: int = None
    '''Old mapping value in frames 

    :type: int
    '''

    hair_subdiv: int = None
    '''Additional subdivision along the hair 

    :type: int
    '''

    hair_type: typing.Union[str, int] = None
    '''Hair shape type 

    :type: typing.Union[str, int]
    '''

    has_multiple_engines: bool = None
    '''More than one rendering engine is available 

    :type: bool
    '''

    image_settings: 'ImageFormatSettings' = None
    '''

    :type: 'ImageFormatSettings'
    '''

    is_movie_format: bool = None
    '''When true the format is a movie 

    :type: bool
    '''

    line_thickness: float = None
    '''Line thickness in pixels 

    :type: float
    '''

    line_thickness_mode: typing.Union[str, int] = None
    '''Line thickness mode for Freestyle line drawing 

    :type: typing.Union[str, int]
    '''

    motion_blur_shutter: float = None
    '''Time taken in frames between shutter open and close 

    :type: float
    '''

    motion_blur_shutter_curve: 'CurveMapping' = None
    '''Curve defining the shutter’s openness over time 

    :type: 'CurveMapping'
    '''

    pixel_aspect_x: float = None
    '''Horizontal aspect ratio - for anamorphic or non-square pixel output 

    :type: float
    '''

    pixel_aspect_y: float = None
    '''Vertical aspect ratio - for anamorphic or non-square pixel output 

    :type: float
    '''

    preview_pixel_size: typing.Union[str, int] = None
    '''Pixel size for viewport rendering 

    :type: typing.Union[str, int]
    '''

    preview_start_resolution: int = None
    '''Resolution to start rendering preview at, progressively increasing it to the full viewport size 

    :type: int
    '''

    resolution_percentage: int = None
    '''Percentage scale for render resolution 

    :type: int
    '''

    resolution_x: int = None
    '''Number of horizontal pixels in the rendered image 

    :type: int
    '''

    resolution_y: int = None
    '''Number of vertical pixels in the rendered image 

    :type: int
    '''

    sequencer_gl_preview: typing.Union[str, int] = None
    '''Method to draw in the sequencer view 

    :type: typing.Union[str, int]
    '''

    simplify_child_particles: float = None
    '''Global child particles percentage 

    :type: float
    '''

    simplify_child_particles_render: float = None
    '''Global child particles percentage during rendering 

    :type: float
    '''

    simplify_gpencil: bool = None
    '''Simplify Grease Pencil drawing 

    :type: bool
    '''

    simplify_gpencil_blend: bool = None
    '''Display blend layers 

    :type: bool
    '''

    simplify_gpencil_onplay: bool = None
    '''Simplify Grease Pencil only during animation playback 

    :type: bool
    '''

    simplify_gpencil_remove_lines: bool = None
    '''Display external lines of fill strokes 

    :type: bool
    '''

    simplify_gpencil_shader_fx: bool = None
    '''Display Shader FX 

    :type: bool
    '''

    simplify_gpencil_tint: bool = None
    '''Display layer tint 

    :type: bool
    '''

    simplify_gpencil_view_fill: bool = None
    '''Display fill strokes in the viewport 

    :type: bool
    '''

    simplify_gpencil_view_modifier: bool = None
    '''Display modifiers in the viewport 

    :type: bool
    '''

    simplify_subdivision: int = None
    '''Global maximum subdivision level 

    :type: int
    '''

    simplify_subdivision_render: int = None
    '''Global maximum subdivision level during rendering 

    :type: int
    '''

    stamp_background: typing.List[float] = None
    '''Color to use behind stamp text 

    :type: typing.List[float]
    '''

    stamp_font_size: int = None
    '''Size of the font used when rendering stamp text 

    :type: int
    '''

    stamp_foreground: typing.List[float] = None
    '''Color to use for stamp text 

    :type: typing.List[float]
    '''

    stamp_note_text: str = None
    '''Custom text to appear in the stamp note 

    :type: str
    '''

    stereo_views: typing.Union[typing.List['SceneRenderView'],
                               'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['SceneRenderView'], 'bpy_prop_collection']
    '''

    threads: int = None
    '''Number of CPU threads to use simultaneously while rendering (for multi-core/CPU systems) 

    :type: int
    '''

    threads_mode: typing.Union[str, int] = None
    '''Determine the amount of render threads used 

    :type: typing.Union[str, int]
    '''

    tile_x: int = None
    '''Horizontal tile size to use while rendering 

    :type: int
    '''

    tile_y: int = None
    '''Vertical tile size to use while rendering 

    :type: int
    '''

    use_bake_clear: bool = None
    '''Clear Images before baking 

    :type: bool
    '''

    use_bake_lores_mesh: bool = None
    '''Calculate heights against unsubdivided low resolution mesh 

    :type: bool
    '''

    use_bake_multires: bool = None
    '''Bake directly from multires object 

    :type: bool
    '''

    use_bake_selected_to_active: bool = None
    '''Bake shading on the surface of selected objects to the active object 

    :type: bool
    '''

    use_bake_user_scale: bool = None
    '''Use a user scale for the derivative map 

    :type: bool
    '''

    use_border: bool = None
    '''Render a user-defined render region, within the frame size 

    :type: bool
    '''

    use_compositing: bool = None
    '''Process the render result through the compositing pipeline, if compositing nodes are enabled 

    :type: bool
    '''

    use_crop_to_border: bool = None
    '''Crop the rendered frame to the defined render region size 

    :type: bool
    '''

    use_file_extension: bool = None
    '''Add the file format extensions to the rendered file name (eg: filename + .jpg) 

    :type: bool
    '''

    use_freestyle: bool = None
    '''Draw stylized strokes using Freestyle 

    :type: bool
    '''

    use_full_sample: bool = None
    '''Save for every anti-aliasing sample the entire RenderLayer results (this solves anti-aliasing issues with compositing) 

    :type: bool
    '''

    use_lock_interface: bool = None
    '''Lock interface during rendering in favor of giving more memory to the renderer 

    :type: bool
    '''

    use_motion_blur: bool = None
    '''Use multi-sampled 3D scene motion blur 

    :type: bool
    '''

    use_multiview: bool = None
    '''Use multiple views in the scene 

    :type: bool
    '''

    use_overwrite: bool = None
    '''Overwrite existing files while rendering 

    :type: bool
    '''

    use_persistent_data: bool = None
    '''Keep render data around for faster re-renders 

    :type: bool
    '''

    use_placeholder: bool = None
    '''Create empty placeholder files while rendering frames (similar to Unix ‘touch’) 

    :type: bool
    '''

    use_render_cache: bool = None
    '''Save render cache to EXR files (useful for heavy compositing, Note: affects indirectly rendered scenes) 

    :type: bool
    '''

    use_save_buffers: bool = None
    '''Save tiles for all RenderLayers and SceneNodes to files in the temp directory (saves memory, required for Full Sample) 

    :type: bool
    '''

    use_sequencer: bool = None
    '''Process the render (and composited) result through the video sequence editor pipeline, if sequencer strips exist 

    :type: bool
    '''

    use_sequencer_override_scene_strip: bool = None
    '''Use workbench render settings from the sequencer scene, instead of each individual scene used in the strip 

    :type: bool
    '''

    use_simplify: bool = None
    '''Enable simplification of scene for quicker preview renders 

    :type: bool
    '''

    use_simplify_smoke_highres: bool = None
    '''Display high-resolution smoke in the viewport 

    :type: bool
    '''

    use_single_layer: bool = None
    '''Only render the active layer. Only affects rendering from the interface, ignored for rendering from command line 

    :type: bool
    '''

    use_spherical_stereo: bool = None
    '''Active render engine supports spherical stereo rendering 

    :type: bool
    '''

    use_stamp: bool = None
    '''Render the stamp info text in the rendered image 

    :type: bool
    '''

    use_stamp_camera: bool = None
    '''Include the name of the active camera in image metadata 

    :type: bool
    '''

    use_stamp_date: bool = None
    '''Include the current date in image/video metadata 

    :type: bool
    '''

    use_stamp_filename: bool = None
    '''Include the .blend filename in image/video metadata 

    :type: bool
    '''

    use_stamp_frame: bool = None
    '''Include the frame number in image metadata 

    :type: bool
    '''

    use_stamp_frame_range: bool = None
    '''Include the rendered frame range in image/video metadata 

    :type: bool
    '''

    use_stamp_hostname: bool = None
    '''Include the hostname of the machine that rendered the frame 

    :type: bool
    '''

    use_stamp_labels: bool = None
    '''Display stamp labels (“Camera” in front of camera name, etc.) 

    :type: bool
    '''

    use_stamp_lens: bool = None
    '''Include the active camera’s lens in image metadata 

    :type: bool
    '''

    use_stamp_marker: bool = None
    '''Include the name of the last marker in image metadata 

    :type: bool
    '''

    use_stamp_memory: bool = None
    '''Include the peak memory usage in image metadata 

    :type: bool
    '''

    use_stamp_note: bool = None
    '''Include a custom note in image/video metadata 

    :type: bool
    '''

    use_stamp_render_time: bool = None
    '''Include the render time in image metadata 

    :type: bool
    '''

    use_stamp_scene: bool = None
    '''Include the name of the active scene in image/video metadata 

    :type: bool
    '''

    use_stamp_sequencer_strip: bool = None
    '''Include the name of the foreground sequence strip in image metadata 

    :type: bool
    '''

    use_stamp_strip_meta: bool = None
    '''Use metadata from the strips in the sequencer 

    :type: bool
    '''

    use_stamp_time: bool = None
    '''Include the rendered frame timecode as HH:MM:SS.FF in image metadata 

    :type: bool
    '''

    views: typing.Union[typing.List['SceneRenderView'], 'bpy_prop_collection',
                        'RenderViews'] = None
    '''

    :type: typing.Union[typing.List['SceneRenderView'], 'bpy_prop_collection', 'RenderViews']
    '''

    views_format: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    def frame_path(self,
                   frame: int = -2147483648,
                   preview: bool = False,
                   view: str = "") -> str:
        '''Return the absolute path to the filename to be written for a given frame 

        :param frame: Frame number to use, if unset the current frame will be used 
        :type frame: int
        :param preview: Preview, Use preview range 
        :type preview: bool
        :param view: View, The name of the view to use to replace the “%” chars 
        :type view: str
        :rtype: str
        :return:  File Path, The resulting filepath from the scenes render settings 
        '''
        pass


class RenderSlot(bpy_struct):
    '''Parameters defining the render slot '''

    name: str = None
    '''Render slot name 

    :type: str
    '''

    def clear(self, iuser: 'ImageUser'):
        '''Clear the render slot 

        :param iuser: ImageUser 
        :type iuser: 'ImageUser'
        '''
        pass


class RenderSlots(bpy_struct):
    '''Collection of render layers '''

    active: 'RenderSlot' = None
    '''Active render slot of the image 

    :type: 'RenderSlot'
    '''

    active_index: int = None
    '''Active render slot of the image 

    :type: int
    '''

    def new(self, name: str = "") -> 'RenderSlot':
        '''Add a render slot to the image 

        :param name: Name, New name for the render slot 
        :type name: str
        :rtype: 'RenderSlot'
        :return:  Newly created render layer 
        '''
        pass


class RenderView(bpy_struct):
    name: str = None
    '''

    :type: str
    '''


class RenderViews(bpy_struct):
    '''Collection of render views '''

    active: 'SceneRenderView' = None
    '''Active Render View 

    :type: 'SceneRenderView'
    '''

    active_index: int = None
    '''Active index in render view array 

    :type: int
    '''

    def new(self, name: str) -> 'SceneRenderView':
        '''Add a render view to scene 

        :param name: New name for the marker (not unique) 
        :type name: str
        :rtype: 'SceneRenderView'
        :return:  Newly created render view 
        '''
        pass

    def remove(self, view: 'SceneRenderView'):
        '''Remove a render view 

        :param view: Render view to remove 
        :type view: 'SceneRenderView'
        '''
        pass


class RigidBodyConstraint(bpy_struct):
    '''Constraint influencing Objects inside Rigid Body Simulation '''

    breaking_threshold: float = None
    '''Impulse threshold that must be reached for the constraint to break 

    :type: float
    '''

    disable_collisions: bool = None
    '''Disable collisions between constrained rigid bodies 

    :type: bool
    '''

    enabled: bool = None
    '''Enable this constraint 

    :type: bool
    '''

    limit_ang_x_lower: float = None
    '''Lower limit of X axis rotation 

    :type: float
    '''

    limit_ang_x_upper: float = None
    '''Upper limit of X axis rotation 

    :type: float
    '''

    limit_ang_y_lower: float = None
    '''Lower limit of Y axis rotation 

    :type: float
    '''

    limit_ang_y_upper: float = None
    '''Upper limit of Y axis rotation 

    :type: float
    '''

    limit_ang_z_lower: float = None
    '''Lower limit of Z axis rotation 

    :type: float
    '''

    limit_ang_z_upper: float = None
    '''Upper limit of Z axis rotation 

    :type: float
    '''

    limit_lin_x_lower: float = None
    '''Lower limit of X axis translation 

    :type: float
    '''

    limit_lin_x_upper: float = None
    '''Upper limit of X axis translation 

    :type: float
    '''

    limit_lin_y_lower: float = None
    '''Lower limit of Y axis translation 

    :type: float
    '''

    limit_lin_y_upper: float = None
    '''Upper limit of Y axis translation 

    :type: float
    '''

    limit_lin_z_lower: float = None
    '''Lower limit of Z axis translation 

    :type: float
    '''

    limit_lin_z_upper: float = None
    '''Upper limit of Z axis translation 

    :type: float
    '''

    motor_ang_max_impulse: float = None
    '''Maximum angular motor impulse 

    :type: float
    '''

    motor_ang_target_velocity: float = None
    '''Target angular motor velocity 

    :type: float
    '''

    motor_lin_max_impulse: float = None
    '''Maximum linear motor impulse 

    :type: float
    '''

    motor_lin_target_velocity: float = None
    '''Target linear motor velocity 

    :type: float
    '''

    object1: 'Object' = None
    '''First Rigid Body Object to be constrained 

    :type: 'Object'
    '''

    object2: 'Object' = None
    '''Second Rigid Body Object to be constrained 

    :type: 'Object'
    '''

    solver_iterations: int = None
    '''Number of constraint solver iterations made per simulation step (higher values are more accurate but slower) 

    :type: int
    '''

    spring_damping_ang_x: float = None
    '''Damping on the X rotational axis 

    :type: float
    '''

    spring_damping_ang_y: float = None
    '''Damping on the Y rotational axis 

    :type: float
    '''

    spring_damping_ang_z: float = None
    '''Damping on the Z rotational axis 

    :type: float
    '''

    spring_damping_x: float = None
    '''Damping on the X axis 

    :type: float
    '''

    spring_damping_y: float = None
    '''Damping on the Y axis 

    :type: float
    '''

    spring_damping_z: float = None
    '''Damping on the Z axis 

    :type: float
    '''

    spring_stiffness_ang_x: float = None
    '''Stiffness on the X rotational axis 

    :type: float
    '''

    spring_stiffness_ang_y: float = None
    '''Stiffness on the Y rotational axis 

    :type: float
    '''

    spring_stiffness_ang_z: float = None
    '''Stiffness on the Z rotational axis 

    :type: float
    '''

    spring_stiffness_x: float = None
    '''Stiffness on the X axis 

    :type: float
    '''

    spring_stiffness_y: float = None
    '''Stiffness on the Y axis 

    :type: float
    '''

    spring_stiffness_z: float = None
    '''Stiffness on the Z axis 

    :type: float
    '''

    spring_type: typing.Union[str, int] = None
    '''Which implementation of spring to use 

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    '''Type of Rigid Body Constraint 

    :type: typing.Union[str, int]
    '''

    use_breaking: bool = None
    '''Constraint can be broken if it receives an impulse above the threshold 

    :type: bool
    '''

    use_limit_ang_x: bool = None
    '''Limit rotation around X axis 

    :type: bool
    '''

    use_limit_ang_y: bool = None
    '''Limit rotation around Y axis 

    :type: bool
    '''

    use_limit_ang_z: bool = None
    '''Limit rotation around Z axis 

    :type: bool
    '''

    use_limit_lin_x: bool = None
    '''Limit translation on X axis 

    :type: bool
    '''

    use_limit_lin_y: bool = None
    '''Limit translation on Y axis 

    :type: bool
    '''

    use_limit_lin_z: bool = None
    '''Limit translation on Z axis 

    :type: bool
    '''

    use_motor_ang: bool = None
    '''Enable angular motor 

    :type: bool
    '''

    use_motor_lin: bool = None
    '''Enable linear motor 

    :type: bool
    '''

    use_override_solver_iterations: bool = None
    '''Override the number of solver iterations for this constraint 

    :type: bool
    '''

    use_spring_ang_x: bool = None
    '''Enable spring on X rotational axis 

    :type: bool
    '''

    use_spring_ang_y: bool = None
    '''Enable spring on Y rotational axis 

    :type: bool
    '''

    use_spring_ang_z: bool = None
    '''Enable spring on Z rotational axis 

    :type: bool
    '''

    use_spring_x: bool = None
    '''Enable spring on X axis 

    :type: bool
    '''

    use_spring_y: bool = None
    '''Enable spring on Y axis 

    :type: bool
    '''

    use_spring_z: bool = None
    '''Enable spring on Z axis 

    :type: bool
    '''


class RigidBodyObject(bpy_struct):
    '''Settings for object participating in Rigid Body Simulation '''

    angular_damping: float = None
    '''Amount of angular velocity that is lost over time 

    :type: float
    '''

    collision_collections: typing.List[bool] = None
    '''Collision collections rigid body belongs to 

    :type: typing.List[bool]
    '''

    collision_margin: float = None
    '''Threshold of distance near surface where collisions are still considered (best results when non-zero) 

    :type: float
    '''

    collision_shape: typing.Union[str, int] = None
    '''Collision Shape of object in Rigid Body Simulations 

    :type: typing.Union[str, int]
    '''

    deactivate_angular_velocity: float = None
    '''Angular Velocity below which simulation stops simulating object 

    :type: float
    '''

    deactivate_linear_velocity: float = None
    '''Linear Velocity below which simulation stops simulating object 

    :type: float
    '''

    enabled: bool = None
    '''Rigid Body actively participates to the simulation 

    :type: bool
    '''

    friction: float = None
    '''Resistance of object to movement 

    :type: float
    '''

    kinematic: bool = None
    '''Allow rigid body to be controlled by the animation system 

    :type: bool
    '''

    linear_damping: float = None
    '''Amount of linear velocity that is lost over time 

    :type: float
    '''

    mass: float = None
    '''How much the object ‘weighs’ irrespective of gravity 

    :type: float
    '''

    mesh_source: typing.Union[str, int] = None
    '''Source of the mesh used to create collision shape 

    :type: typing.Union[str, int]
    '''

    restitution: float = None
    '''Tendency of object to bounce after colliding with another (0 = stays still, 1 = perfectly elastic) 

    :type: float
    '''

    type: typing.Union[str, int] = None
    '''Role of object in Rigid Body Simulations 

    :type: typing.Union[str, int]
    '''

    use_deactivation: bool = None
    '''Enable deactivation of resting rigid bodies (increases performance and stability but can cause glitches) 

    :type: bool
    '''

    use_deform: bool = None
    '''Rigid body deforms during simulation 

    :type: bool
    '''

    use_margin: bool = None
    '''Use custom collision margin (some shapes will have a visible gap around them) 

    :type: bool
    '''

    use_start_deactivated: bool = None
    '''Deactivate rigid body at the start of the simulation 

    :type: bool
    '''


class RigidBodyWorld(bpy_struct):
    '''Self-contained rigid body simulation environment and settings '''

    collection: 'Collection' = None
    '''Collection containing objects participating in this simulation 

    :type: 'Collection'
    '''

    constraints: 'Collection' = None
    '''Collection containing rigid body constraint objects 

    :type: 'Collection'
    '''

    effector_weights: 'EffectorWeights' = None
    '''

    :type: 'EffectorWeights'
    '''

    enabled: bool = None
    '''Simulation will be evaluated 

    :type: bool
    '''

    point_cache: 'PointCache' = None
    '''

    :type: 'PointCache'
    '''

    solver_iterations: int = None
    '''Number of constraint solver iterations made per simulation step (higher values are more accurate but slower) 

    :type: int
    '''

    steps_per_second: int = None
    '''Number of simulation steps taken per second (higher values are more accurate but slower) 

    :type: int
    '''

    time_scale: float = None
    '''Change the speed of the simulation 

    :type: float
    '''

    use_split_impulse: bool = None
    '''Reduce extra velocity that can build up when objects collide (lowers simulation stability a little so use only when necessary) 

    :type: bool
    '''

    def convex_sweep_test(self, object: 'Object', start, end):
        '''Sweep test convex rigidbody against the current rigidbody world 

        :param object: Rigidbody object with a convex collision shape 
        :type object: 'Object'
        '''
        pass


class SPHFluidSettings(bpy_struct):
    '''Settings for particle fluids physics '''

    buoyancy: float = None
    '''Artificial buoyancy force in negative gravity direction based on pressure differences inside the fluid 

    :type: float
    '''

    fluid_radius: float = None
    '''Fluid interaction radius 

    :type: float
    '''

    linear_viscosity: float = None
    '''Linear viscosity 

    :type: float
    '''

    plasticity: float = None
    '''How much the spring rest length can change after the elastic limit is crossed 

    :type: float
    '''

    repulsion: float = None
    '''How strongly the fluid tries to keep from clustering (factor of stiffness) 

    :type: float
    '''

    rest_density: float = None
    '''Fluid rest density 

    :type: float
    '''

    rest_length: float = None
    '''Spring rest length (factor of particle radius) 

    :type: float
    '''

    solver: typing.Union[str, int] = None
    '''The code used to calculate internal forces on particles 

    :type: typing.Union[str, int]
    '''

    spring_force: float = None
    '''Spring force 

    :type: float
    '''

    spring_frames: int = None
    '''Create springs for this number of frames since particles birth (0 is always) 

    :type: int
    '''

    stiff_viscosity: float = None
    '''Creates viscosity for expanding fluid 

    :type: float
    '''

    stiffness: float = None
    '''How incompressible the fluid is (speed of sound) 

    :type: float
    '''

    use_factor_density: bool = None
    '''Density is calculated as a factor of default density (depends on particle size) 

    :type: bool
    '''

    use_factor_radius: bool = None
    '''Interaction radius is a factor of 4 * particle size 

    :type: bool
    '''

    use_factor_repulsion: bool = None
    '''Repulsion is a factor of stiffness 

    :type: bool
    '''

    use_factor_rest_length: bool = None
    '''Spring rest length is a factor of 2 * particle size 

    :type: bool
    '''

    use_factor_stiff_viscosity: bool = None
    '''Stiff viscosity is a factor of normal viscosity 

    :type: bool
    '''

    use_initial_rest_length: bool = None
    '''Use the initial length as spring rest length instead of 2 * particle size 

    :type: bool
    '''

    use_viscoelastic_springs: bool = None
    '''Use viscoelastic springs instead of Hooke’s springs 

    :type: bool
    '''

    yield_ratio: float = None
    '''How much the spring has to be stretched/compressed in order to change it’s rest length 

    :type: float
    '''


class SceneDisplay(bpy_struct):
    '''Scene display settings for 3d viewport '''

    light_direction: typing.List[float] = None
    '''Direction of the light for shadows and highlights 

    :type: typing.List[float]
    '''

    matcap_ssao_attenuation: float = None
    '''Attenuation constant 

    :type: float
    '''

    matcap_ssao_distance: float = None
    '''Distance of object that contribute to the Cavity/Edge effect 

    :type: float
    '''

    matcap_ssao_samples: int = None
    '''Number of samples 

    :type: int
    '''

    render_aa: typing.Union[str, int] = None
    '''Method of anti-aliasing when rendering final image 

    :type: typing.Union[str, int]
    '''

    shading: 'View3DShading' = None
    '''Shading settings for OpenGL render engine 

    :type: 'View3DShading'
    '''

    shadow_focus: float = None
    '''Shadow factor hardness 

    :type: float
    '''

    shadow_shift: float = None
    '''Shadow termination angle 

    :type: float
    '''

    viewport_aa: typing.Union[str, int] = None
    '''Method of anti-aliasing when rendering 3d viewport 

    :type: typing.Union[str, int]
    '''


class SceneEEVEE(bpy_struct):
    '''Scene display settings for 3d viewport '''

    bloom_clamp: float = None
    '''Maximum intensity a bloom pixel can have (0 to disabled) 

    :type: float
    '''

    bloom_color: typing.List[float] = None
    '''Color applied to the bloom effect 

    :type: typing.List[float]
    '''

    bloom_intensity: float = None
    '''Blend factor 

    :type: float
    '''

    bloom_knee: float = None
    '''Makes transition between under/over-threshold gradual 

    :type: float
    '''

    bloom_radius: float = None
    '''Bloom spread distance 

    :type: float
    '''

    bloom_threshold: float = None
    '''Filters out pixels under this level of brightness 

    :type: float
    '''

    bokeh_max_size: float = None
    '''Max size of the bokeh shape for the depth of field (lower is faster) 

    :type: float
    '''

    bokeh_threshold: float = None
    '''Brightness threshold for using sprite base depth of field 

    :type: float
    '''

    gi_auto_bake: bool = None
    '''Auto bake indirect lighting when editing probes 

    :type: bool
    '''

    gi_cache_info: str = None
    '''Info on current cache status 

    :type: str
    '''

    gi_cubemap_display_size: float = None
    '''Size of the cubemap spheres to debug captured light 

    :type: float
    '''

    gi_cubemap_resolution: typing.Union[str, int] = None
    '''Size of every cubemaps 

    :type: typing.Union[str, int]
    '''

    gi_diffuse_bounces: int = None
    '''Number of time the light is reinjected inside light grids, 0 disable indirect diffuse light 

    :type: int
    '''

    gi_filter_quality: float = None
    '''Take more samples during cubemap filtering to remove artifacts 

    :type: float
    '''

    gi_glossy_clamp: float = None
    '''Clamp pixel intensity to reduce noise inside glossy reflections from reflection cubemaps (0 to disabled) 

    :type: float
    '''

    gi_irradiance_display_size: float = None
    '''Size of the irradiance sample spheres to debug captured light 

    :type: float
    '''

    gi_irradiance_smoothing: float = None
    '''Smoother irradiance interpolation but introduce light bleeding 

    :type: float
    '''

    gi_show_cubemaps: bool = None
    '''Display captured cubemaps in the viewport 

    :type: bool
    '''

    gi_show_irradiance: bool = None
    '''Display irradiance samples in the viewport 

    :type: bool
    '''

    gi_visibility_resolution: typing.Union[str, int] = None
    '''Size of the shadow map applied to each irradiance sample 

    :type: typing.Union[str, int]
    '''

    gtao_distance: float = None
    '''Distance of object that contribute to the ambient occlusion effect 

    :type: float
    '''

    gtao_factor: float = None
    '''Factor for ambient occlusion blending 

    :type: float
    '''

    gtao_quality: float = None
    '''Precision of the horizon search 

    :type: float
    '''

    light_threshold: float = None
    '''Minimum light intensity for a light to contribute to the lighting 

    :type: float
    '''

    motion_blur_samples: int = None
    '''Number of samples to take with motion blur 

    :type: int
    '''

    motion_blur_shutter: float = None
    '''Time taken in frames between shutter open and close 

    :type: float
    '''

    overscan_size: float = None
    '''Percentage of render size to add as overscan to the internal render buffers 

    :type: float
    '''

    shadow_cascade_size: typing.Union[str, int] = None
    '''Size of sun light shadow maps 

    :type: typing.Union[str, int]
    '''

    shadow_cube_size: typing.Union[str, int] = None
    '''Size of point and area light shadow maps 

    :type: typing.Union[str, int]
    '''

    ssr_border_fade: float = None
    '''Screen percentage used to fade the SSR 

    :type: float
    '''

    ssr_firefly_fac: float = None
    '''Clamp pixel intensity to remove noise (0 to disabled) 

    :type: float
    '''

    ssr_max_roughness: float = None
    '''Do not raytrace reflections for roughness above this value 

    :type: float
    '''

    ssr_quality: float = None
    '''Precision of the screen space raytracing 

    :type: float
    '''

    ssr_thickness: float = None
    '''Pixel thickness used to detect intersection 

    :type: float
    '''

    sss_jitter_threshold: float = None
    '''Rotate samples that are below this threshold 

    :type: float
    '''

    sss_samples: int = None
    '''Number of samples to compute the scattering effect 

    :type: int
    '''

    taa_render_samples: int = None
    '''Number of samples per pixels for rendering 

    :type: int
    '''

    taa_samples: int = None
    '''Number of samples, unlimited if 0 

    :type: int
    '''

    use_bloom: bool = None
    '''High brightness pixels generate a glowing effect 

    :type: bool
    '''

    use_gtao: bool = None
    '''Enable ambient occlusion to simulate medium scale indirect shadowing 

    :type: bool
    '''

    use_gtao_bent_normals: bool = None
    '''Compute main non occluded direction to sample the environment 

    :type: bool
    '''

    use_gtao_bounce: bool = None
    '''An approximation to simulate light bounces giving less occlusion on brighter objects 

    :type: bool
    '''

    use_motion_blur: bool = None
    '''Enable motion blur effect (only in camera view) 

    :type: bool
    '''

    use_overscan: bool = None
    '''Internally render past the image border to avoid screen-space effects disappearing 

    :type: bool
    '''

    use_shadow_high_bitdepth: bool = None
    '''Use 32bit shadows 

    :type: bool
    '''

    use_soft_shadows: bool = None
    '''Randomize shadowmaps origin to create soft shadows 

    :type: bool
    '''

    use_ssr: bool = None
    '''Enable screen space reflection 

    :type: bool
    '''

    use_ssr_halfres: bool = None
    '''Raytrace at a lower resolution 

    :type: bool
    '''

    use_ssr_refraction: bool = None
    '''Enable screen space Refractions 

    :type: bool
    '''

    use_taa_reprojection: bool = None
    '''Denoise image using temporal reprojection (can leave some ghosting) 

    :type: bool
    '''

    use_volumetric_lights: bool = None
    '''Enable scene light interactions with volumetrics 

    :type: bool
    '''

    use_volumetric_shadows: bool = None
    '''Generate shadows from volumetric material (Very expensive) 

    :type: bool
    '''

    volumetric_end: float = None
    '''End distance of the volumetric effect 

    :type: float
    '''

    volumetric_light_clamp: float = None
    '''Maximum light contribution, reducing noise 

    :type: float
    '''

    volumetric_sample_distribution: float = None
    '''Distribute more samples closer to the camera 

    :type: float
    '''

    volumetric_samples: int = None
    '''Number of samples to compute volumetric effects 

    :type: int
    '''

    volumetric_shadow_samples: int = None
    '''Number of samples to compute volumetric shadowing 

    :type: int
    '''

    volumetric_start: float = None
    '''Start distance of the volumetric effect 

    :type: float
    '''

    volumetric_tile_size: typing.Union[str, int] = None
    '''Control the quality of the volumetric effects (lower size increase vram usage and quality) 

    :type: typing.Union[str, int]
    '''


class SceneObjects(bpy_struct):
    '''All of the scene objects '''

    pass


class SceneRenderView(bpy_struct):
    '''Render viewpoint for 3D stereo and multiview rendering '''

    camera_suffix: str = None
    '''Suffix to identify the cameras to use, and added to the render images for this view 

    :type: str
    '''

    file_suffix: str = None
    '''Suffix added to the render images for this view 

    :type: str
    '''

    name: str = None
    '''Render view name 

    :type: str
    '''

    use: bool = None
    '''Disable or enable the render view 

    :type: bool
    '''


class Scopes(bpy_struct):
    '''Scopes for statistical view of an image '''

    accuracy: float = None
    '''Proportion of original image source pixel lines to sample 

    :type: float
    '''

    histogram: 'Histogram' = None
    '''Histogram for viewing image statistics 

    :type: 'Histogram'
    '''

    use_full_resolution: bool = None
    '''Sample every pixel of the image 

    :type: bool
    '''

    vectorscope_alpha: float = None
    '''Opacity of the points 

    :type: float
    '''

    waveform_alpha: float = None
    '''Opacity of the points 

    :type: float
    '''

    waveform_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''


class Sequence(bpy_struct):
    '''Sequence strip in the sequence editor '''

    blend_alpha: float = None
    '''Percentage of how much the strip’s colors affect other strips 

    :type: float
    '''

    blend_type: typing.Union[str, int] = None
    '''Method for controlling how the strip combines with other strips 

    :type: typing.Union[str, int]
    '''

    channel: int = None
    '''Y position of the sequence strip 

    :type: int
    '''

    effect_fader: float = None
    '''Custom fade value 

    :type: float
    '''

    frame_duration: int = None
    '''The length of the contents of this strip before the handles are applied 

    :type: int
    '''

    frame_final_duration: int = None
    '''The length of the contents of this strip after the handles are applied 

    :type: int
    '''

    frame_final_end: int = None
    '''End frame displayed in the sequence editor after offsets are applied 

    :type: int
    '''

    frame_final_start: int = None
    '''Start frame displayed in the sequence editor after offsets are applied, setting this is equivalent to moving the handle, not the actual start frame 

    :type: int
    '''

    frame_offset_end: int = None
    '''

    :type: int
    '''

    frame_offset_start: int = None
    '''

    :type: int
    '''

    frame_start: int = None
    '''X position where the strip begins 

    :type: int
    '''

    frame_still_end: int = None
    '''

    :type: int
    '''

    frame_still_start: int = None
    '''

    :type: int
    '''

    lock: bool = None
    '''Lock strip so that it cannot be transformed 

    :type: bool
    '''

    modifiers: typing.Union[typing.List['SequenceModifier'],
                            'bpy_prop_collection', 'SequenceModifiers'] = None
    '''Modifiers affecting this strip 

    :type: typing.Union[typing.List['SequenceModifier'], 'bpy_prop_collection', 'SequenceModifiers']
    '''

    mute: bool = None
    '''Disable strip so that it cannot be viewed in the output 

    :type: bool
    '''

    name: str = None
    '''

    :type: str
    '''

    override_cache_settings: bool = None
    '''Override global cache settings 

    :type: bool
    '''

    select: bool = None
    '''

    :type: bool
    '''

    select_left_handle: bool = None
    '''

    :type: bool
    '''

    select_right_handle: bool = None
    '''

    :type: bool
    '''

    speed_factor: float = None
    '''Multiply the current speed of the sequence with this number or remap current frame to this frame 

    :type: float
    '''

    type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    use_cache_composite: bool = None
    '''Cache intermediate composited images, for faster tweaking of stacked strips at the cost of memory usage 

    :type: bool
    '''

    use_cache_preprocessed: bool = None
    '''Cache preprocessed images, for faster tweaking of effects at the cost of memory usage 

    :type: bool
    '''

    use_cache_raw: bool = None
    '''Cache raw images read from disk, for faster tweaking of strip parameters at the cost of memory usage 

    :type: bool
    '''

    use_default_fade: bool = None
    '''Fade effect using the built-in default (usually make transition as long as effect strip) 

    :type: bool
    '''

    use_linear_modifiers: bool = None
    '''Calculate modifiers in linear space instead of sequencer’s space 

    :type: bool
    '''

    def update(self, data: bool = False):
        '''Update the strip dimensions 

        :param data: Data, Update strip data 
        :type data: bool
        '''
        pass

    def strip_elem_from_frame(self, frame: int) -> 'SequenceElement':
        '''Return the strip element from a given frame or None 

        :param frame: Frame, The frame to get the strip element from 
        :type frame: int
        :rtype: 'SequenceElement'
        :return:  strip element of the current frame 
        '''
        pass

    def swap(self, other: 'Sequence'):
        '''swap 

        :param other: Other 
        :type other: 'Sequence'
        '''
        pass


class SequenceColorBalanceData(bpy_struct):
    '''Color balance parameters for a sequence strip and it’s modifiers '''

    gain: typing.List[float] = None
    '''Color balance gain (highlights) 

    :type: typing.List[float]
    '''

    gamma: typing.List[float] = None
    '''Color balance gamma (midtones) 

    :type: typing.List[float]
    '''

    invert_gain: bool = None
    '''Invert the gain color` 

    :type: bool
    '''

    invert_gamma: bool = None
    '''Invert the gamma color 

    :type: bool
    '''

    invert_lift: bool = None
    '''Invert the lift color 

    :type: bool
    '''

    lift: typing.List[float] = None
    '''Color balance lift (shadows) 

    :type: typing.List[float]
    '''


class SequenceCrop(bpy_struct):
    '''Cropping parameters for a sequence strip '''

    max_x: int = None
    '''Number of pixels to crop from the right side 

    :type: int
    '''

    max_y: int = None
    '''Number of pixels to crop from the top 

    :type: int
    '''

    min_x: int = None
    '''Number of pixels to crop from the left side 

    :type: int
    '''

    min_y: int = None
    '''Number of pixels to crop from the bottom 

    :type: int
    '''


class SequenceEditor(bpy_struct):
    '''Sequence editing data for a Scene data-block '''

    active_strip: 'Sequence' = None
    '''Sequencer’s active strip 

    :type: 'Sequence'
    '''

    meta_stack: typing.Union[typing.
                             List['Sequence'], 'bpy_prop_collection'] = None
    '''Meta strip stack, last is currently edited meta strip 

    :type: typing.Union[typing.List['Sequence'], 'bpy_prop_collection']
    '''

    overlay_frame: int = None
    '''Number of frames to offset 

    :type: int
    '''

    proxy_dir: str = None
    '''

    :type: str
    '''

    proxy_storage: typing.Union[str, int] = None
    '''How to store proxies for this project 

    :type: typing.Union[str, int]
    '''

    recycle_max_cost: float = None
    '''Only frames with cost lower than this value will be recycled 

    :type: float
    '''

    sequences: typing.Union[typing.List['Sequence'], 'bpy_prop_collection',
                            'Sequences'] = None
    '''Top-level strips only 

    :type: typing.Union[typing.List['Sequence'], 'bpy_prop_collection', 'Sequences']
    '''

    sequences_all: typing.Union[typing.
                                List['Sequence'], 'bpy_prop_collection'] = None
    '''All strips, recursively including those inside metastrips 

    :type: typing.Union[typing.List['Sequence'], 'bpy_prop_collection']
    '''

    show_cache: bool = None
    '''Visualize cached images on the timeline 

    :type: bool
    '''

    show_cache_composite: bool = None
    '''Visualize cached composite images 

    :type: bool
    '''

    show_cache_final_out: bool = None
    '''Visualize cached complete frames 

    :type: bool
    '''

    show_cache_preprocessed: bool = None
    '''Visualize cached preprocessed images 

    :type: bool
    '''

    show_cache_raw: bool = None
    '''Visualize cached raw images 

    :type: bool
    '''

    show_overlay: bool = None
    '''Partial overlay on top of the sequencer with a frame offset 

    :type: bool
    '''

    use_cache_composite: bool = None
    '''Cache intermediate composited images, for faster tweaking of stacked strips at the cost of memory usage 

    :type: bool
    '''

    use_cache_final: bool = None
    '''Cache final image for each frame 

    :type: bool
    '''

    use_cache_preprocessed: bool = None
    '''Cache preprocessed images, for faster tweaking of effects at the cost of memory usage 

    :type: bool
    '''

    use_cache_raw: bool = None
    '''Cache raw images read from disk, for faster tweaking of strip parameters at the cost of memory usage 

    :type: bool
    '''

    use_overlay_lock: bool = None
    '''

    :type: bool
    '''

    use_prefetch: bool = None
    '''Render frames ahead of playhead in background for faster playback 

    :type: bool
    '''


class SequenceElement(bpy_struct):
    '''Sequence strip data for a single frame '''

    filename: str = None
    '''Name of the source file 

    :type: str
    '''

    orig_height: int = None
    '''Original image height 

    :type: int
    '''

    orig_width: int = None
    '''Original image width 

    :type: int
    '''


class SequenceElements(bpy_struct):
    '''Collection of SequenceElement '''

    def append(self, filename: str) -> 'SequenceElement':
        '''Push an image from ImageSequence.directory 

        :param filename: Filepath to image 
        :type filename: str
        :rtype: 'SequenceElement'
        :return:  New SequenceElement 
        '''
        pass

    def pop(self, index: int):
        '''Pop an image off the collection 

        :param index: Index of image to remove 
        :type index: int
        '''
        pass


class SequenceModifier(bpy_struct):
    '''Modifier for sequence strip '''

    input_mask_id: 'Mask' = None
    '''Mask ID used as mask input for the modifier 

    :type: 'Mask'
    '''

    input_mask_strip: 'Sequence' = None
    '''Strip used as mask input for the modifier 

    :type: 'Sequence'
    '''

    input_mask_type: typing.Union[str, int] = None
    '''Type of input data used for mask 

    :type: typing.Union[str, int]
    '''

    mask_time: typing.Union[str, int] = None
    '''Time to use for the Mask animation 

    :type: typing.Union[str, int]
    '''

    mute: bool = None
    '''Mute this modifier 

    :type: bool
    '''

    name: str = None
    '''

    :type: str
    '''

    show_expanded: bool = None
    '''Mute expanded settings for the modifier 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''


class SequenceModifiers(bpy_struct):
    '''Collection of strip modifiers '''

    def new(self, name: str,
            type: typing.Union[str, int]) -> 'SequenceModifier':
        '''Add a new modifier 

        :param name: New name for the modifier 
        :type name: str
        :param type: Modifier type to add 
        :type type: typing.Union[str, int]
        :rtype: 'SequenceModifier'
        :return:  Newly created modifier 
        '''
        pass

    def remove(self, modifier: 'SequenceModifier'):
        '''Remove an existing modifier from the sequence 

        :param modifier: Modifier to remove 
        :type modifier: 'SequenceModifier'
        '''
        pass

    def clear(self, ):
        '''Remove all modifiers from the sequence 

        '''
        pass


class SequenceProxy(bpy_struct):
    '''Proxy parameters for a sequence strip '''

    build_100: bool = None
    '''Build 100% proxy resolution 

    :type: bool
    '''

    build_25: bool = None
    '''Build 25% proxy resolution 

    :type: bool
    '''

    build_50: bool = None
    '''Build 50% proxy resolution 

    :type: bool
    '''

    build_75: bool = None
    '''Build 75% proxy resolution 

    :type: bool
    '''

    build_free_run: bool = None
    '''Build free run time code index 

    :type: bool
    '''

    build_free_run_rec_date: bool = None
    '''Build free run time code index using Record Date/Time 

    :type: bool
    '''

    build_record_run: bool = None
    '''Build record run time code index 

    :type: bool
    '''

    directory: str = None
    '''Location to store the proxy files 

    :type: str
    '''

    filepath: str = None
    '''Location of custom proxy file 

    :type: str
    '''

    quality: int = None
    '''JPEG Quality of proxies to build 

    :type: int
    '''

    timecode: typing.Union[str, int] = None
    '''Method for reading the inputs timecode 

    :type: typing.Union[str, int]
    '''

    use_overwrite: bool = None
    '''Overwrite existing proxy files when building 

    :type: bool
    '''

    use_proxy_custom_directory: bool = None
    '''Use a custom directory to store data 

    :type: bool
    '''

    use_proxy_custom_file: bool = None
    '''Use a custom file to read proxy data from 

    :type: bool
    '''


class SequenceTransform(bpy_struct):
    '''Transform parameters for a sequence strip '''

    offset_x: int = None
    '''Amount to move the input on the X axis within its boundaries 

    :type: int
    '''

    offset_y: int = None
    '''Amount to move the input on the Y axis within its boundaries 

    :type: int
    '''


class Sequences(bpy_struct):
    '''Collection of Sequences '''

    def new_clip(self, name: str, clip: 'MovieClip', channel: int,
                 frame_start: int) -> 'Sequence':
        '''Add a new movie clip sequence 

        :param name: Name for the new sequence 
        :type name: str
        :param clip: Movie clip to add 
        :type clip: 'MovieClip'
        :param channel: Channel, The channel for the new sequence 
        :type channel: int
        :param frame_start: The start frame for the new sequence 
        :type frame_start: int
        :rtype: 'Sequence'
        :return:  New Sequence 
        '''
        pass

    def new_mask(self, name: str, mask: 'Mask', channel: int,
                 frame_start: int) -> 'Sequence':
        '''Add a new mask sequence 

        :param name: Name for the new sequence 
        :type name: str
        :param mask: Mask to add 
        :type mask: 'Mask'
        :param channel: Channel, The channel for the new sequence 
        :type channel: int
        :param frame_start: The start frame for the new sequence 
        :type frame_start: int
        :rtype: 'Sequence'
        :return:  New Sequence 
        '''
        pass

    def new_scene(self, name: str, scene: 'Scene', channel: int,
                  frame_start: int) -> 'Sequence':
        '''Add a new scene sequence 

        :param name: Name for the new sequence 
        :type name: str
        :param scene: Scene to add 
        :type scene: 'Scene'
        :param channel: Channel, The channel for the new sequence 
        :type channel: int
        :param frame_start: The start frame for the new sequence 
        :type frame_start: int
        :rtype: 'Sequence'
        :return:  New Sequence 
        '''
        pass

    def new_image(self, name: str, filepath: str, channel: int,
                  frame_start: int) -> 'Sequence':
        '''Add a new image sequence 

        :param name: Name for the new sequence 
        :type name: str
        :param filepath: Filepath to image 
        :type filepath: str
        :param channel: Channel, The channel for the new sequence 
        :type channel: int
        :param frame_start: The start frame for the new sequence 
        :type frame_start: int
        :rtype: 'Sequence'
        :return:  New Sequence 
        '''
        pass

    def new_movie(self, name: str, filepath: str, channel: int,
                  frame_start: int) -> 'Sequence':
        '''Add a new movie sequence 

        :param name: Name for the new sequence 
        :type name: str
        :param filepath: Filepath to movie 
        :type filepath: str
        :param channel: Channel, The channel for the new sequence 
        :type channel: int
        :param frame_start: The start frame for the new sequence 
        :type frame_start: int
        :rtype: 'Sequence'
        :return:  New Sequence 
        '''
        pass

    def new_sound(self, name: str, filepath: str, channel: int,
                  frame_start: int) -> 'Sequence':
        '''Add a new sound sequence 

        :param name: Name for the new sequence 
        :type name: str
        :param filepath: Filepath to movie 
        :type filepath: str
        :param channel: Channel, The channel for the new sequence 
        :type channel: int
        :param frame_start: The start frame for the new sequence 
        :type frame_start: int
        :rtype: 'Sequence'
        :return:  New Sequence 
        '''
        pass

    def new_effect(self,
                   name: str,
                   type: typing.Union[str, int],
                   channel: int,
                   frame_start: int,
                   frame_end: int = 0,
                   seq1: 'Sequence' = None,
                   seq2: 'Sequence' = None,
                   seq3: 'Sequence' = None) -> 'Sequence':
        '''Add a new effect sequence 

        :param name: Name for the new sequence 
        :type name: str
        :param type: Type, type for the new sequence 
        :type type: typing.Union[str, int]
        :param channel: Channel, The channel for the new sequence 
        :type channel: int
        :param frame_start: The start frame for the new sequence 
        :type frame_start: int
        :param frame_end: The end frame for the new sequence 
        :type frame_end: int
        :param seq1: Sequence 1 for effect 
        :type seq1: 'Sequence'
        :param seq2: Sequence 2 for effect 
        :type seq2: 'Sequence'
        :param seq3: Sequence 3 for effect 
        :type seq3: 'Sequence'
        :rtype: 'Sequence'
        :return:  New Sequence 
        '''
        pass

    def remove(self, sequence: 'Sequence'):
        '''Remove a Sequence 

        :param sequence: Sequence to remove 
        :type sequence: 'Sequence'
        '''
        pass


class ShaderFx(bpy_struct):
    '''Effect affecting the grease pencil object '''

    name: str = None
    '''Effect name 

    :type: str
    '''

    show_expanded: bool = None
    '''Set effect expanded in the user interface 

    :type: bool
    '''

    show_in_editmode: bool = None
    '''Display effect in Edit mode 

    :type: bool
    '''

    show_render: bool = None
    '''Use effect during render 

    :type: bool
    '''

    show_viewport: bool = None
    '''Display effect in viewport 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''


class ShapeKey(bpy_struct):
    '''Shape key in a shape keys data-block '''

    data: typing.Union[typing.
                       List['UnknownType'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['UnknownType'], 'bpy_prop_collection']
    '''

    frame: float = None
    '''Frame for absolute keys 

    :type: float
    '''

    interpolation: typing.Union[str, int] = None
    '''Interpolation type for absolute shape keys 

    :type: typing.Union[str, int]
    '''

    mute: bool = None
    '''Toggle this shape key 

    :type: bool
    '''

    name: str = None
    '''Name of Shape Key 

    :type: str
    '''

    relative_key: 'ShapeKey' = None
    '''Shape used as a relative key 

    :type: 'ShapeKey'
    '''

    slider_max: float = None
    '''Maximum for slider 

    :type: float
    '''

    slider_min: float = None
    '''Minimum for slider 

    :type: float
    '''

    value: float = None
    '''Value of shape key at the current frame 

    :type: float
    '''

    vertex_group: str = None
    '''Vertex weight group, to blend with basis shape 

    :type: str
    '''

    def normals_vertex_get(self, ) -> float:
        '''Compute local space vertices’ normals for this shape key 

        :rtype: float
        :return:  normals 
        '''
        pass

    def normals_polygon_get(self, ) -> float:
        '''Compute local space faces’ normals for this shape key 

        :rtype: float
        :return:  normals 
        '''
        pass

    def normals_split_get(self, ) -> float:
        '''Compute local space face corners’ normals for this shape key 

        :rtype: float
        :return:  normals 
        '''
        pass


class ShapeKeyBezierPoint(bpy_struct):
    '''Point in a shape key for Bezier curves '''

    co: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_left: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_right: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    radius: float = None
    '''Radius for beveling 

    :type: float
    '''

    tilt: float = None
    '''Tilt in 3D View 

    :type: float
    '''


class ShapeKeyCurvePoint(bpy_struct):
    '''Point in a shape key for curves '''

    co: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    radius: float = None
    '''Radius for beveling 

    :type: float
    '''

    tilt: float = None
    '''Tilt in 3D View 

    :type: float
    '''


class ShapeKeyPoint(bpy_struct):
    '''Point in a shape key '''

    co: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class SoftBodySettings(bpy_struct):
    '''Soft body simulation settings for an object '''

    aero: int = None
    '''Make edges ‘sail’ 

    :type: int
    '''

    aerodynamics_type: typing.Union[str, int] = None
    '''Method of calculating aerodynamic interaction 

    :type: typing.Union[str, int]
    '''

    ball_damp: float = None
    '''Blending to inelastic collision 

    :type: float
    '''

    ball_size: float = None
    '''Absolute ball size or factor if not manually adjusted 

    :type: float
    '''

    ball_stiff: float = None
    '''Ball inflating pressure 

    :type: float
    '''

    bend: float = None
    '''Bending Stiffness 

    :type: float
    '''

    choke: int = None
    '''‘Viscosity’ inside collision target 

    :type: int
    '''

    collision_collection: 'Collection' = None
    '''Limit colliders to this collection 

    :type: 'Collection'
    '''

    collision_type: typing.Union[str, int] = None
    '''Choose Collision Type 

    :type: typing.Union[str, int]
    '''

    damping: float = None
    '''Edge spring friction 

    :type: float
    '''

    effector_weights: 'EffectorWeights' = None
    '''

    :type: 'EffectorWeights'
    '''

    error_threshold: float = None
    '''The Runge-Kutta ODE solver error limit, low value gives more precision, high values speed 

    :type: float
    '''

    friction: float = None
    '''General media friction for point movements 

    :type: float
    '''

    fuzzy: int = None
    '''Fuzziness while on collision, high values make collision handling faster but less stable 

    :type: int
    '''

    goal_default: float = None
    '''Default Goal (vertex target position) value 

    :type: float
    '''

    goal_friction: float = None
    '''Goal (vertex target position) friction 

    :type: float
    '''

    goal_max: float = None
    '''Goal maximum, vertex weights are scaled to match this range 

    :type: float
    '''

    goal_min: float = None
    '''Goal minimum, vertex weights are scaled to match this range 

    :type: float
    '''

    goal_spring: float = None
    '''Goal (vertex target position) spring stiffness 

    :type: float
    '''

    gravity: float = None
    '''Apply gravitation to point movement 

    :type: float
    '''

    location_mass_center: typing.List[float] = None
    '''Location of center of mass 

    :type: typing.List[float]
    '''

    mass: float = None
    '''General Mass value 

    :type: float
    '''

    plastic: int = None
    '''Permanent deform 

    :type: int
    '''

    pull: float = None
    '''Edge spring stiffness when longer than rest length 

    :type: float
    '''

    push: float = None
    '''Edge spring stiffness when shorter than rest length 

    :type: float
    '''

    rotation_estimate: typing.List[float] = None
    '''Estimated rotation matrix 

    :type: typing.List[float]
    '''

    scale_estimate: typing.List[float] = None
    '''Estimated scale matrix 

    :type: typing.List[float]
    '''

    shear: float = None
    '''Shear Stiffness 

    :type: float
    '''

    speed: float = None
    '''Tweak timing for physics to control frequency and speed 

    :type: float
    '''

    spring_length: int = None
    '''Alter spring length to shrink/blow up (unit %) 0 to disable 

    :type: int
    '''

    step_max: int = None
    '''Maximal # solver steps/frame 

    :type: int
    '''

    step_min: int = None
    '''Minimal # solver steps/frame 

    :type: int
    '''

    use_auto_step: bool = None
    '''Use velocities for automagic step sizes 

    :type: bool
    '''

    use_diagnose: bool = None
    '''Turn on SB diagnose console prints 

    :type: bool
    '''

    use_edge_collision: bool = None
    '''Edges collide too 

    :type: bool
    '''

    use_edges: bool = None
    '''Use Edges as springs 

    :type: bool
    '''

    use_estimate_matrix: bool = None
    '''Estimate matrix… split to COM, ROT, SCALE 

    :type: bool
    '''

    use_face_collision: bool = None
    '''Faces collide too, can be very slow 

    :type: bool
    '''

    use_goal: bool = None
    '''Define forces for vertices to stick to animated position 

    :type: bool
    '''

    use_self_collision: bool = None
    '''Enable naive vertex ball self collision 

    :type: bool
    '''

    use_stiff_quads: bool = None
    '''Add diagonal springs on 4-gons 

    :type: bool
    '''

    vertex_group_goal: str = None
    '''Control point weight values 

    :type: str
    '''

    vertex_group_mass: str = None
    '''Control point mass values 

    :type: str
    '''

    vertex_group_spring: str = None
    '''Control point spring strength values 

    :type: str
    '''


class Space(bpy_struct):
    '''Space data for a screen area '''

    show_locked_time: bool = None
    '''

    :type: bool
    '''

    show_region_header: bool = None
    '''

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''Space data type 

    :type: typing.Union[str, int]
    '''

    def draw_handler_add(self, callback, args: tuple, region_type: str,
                         draw_type: str) -> 'bpy.context.object':
        '''Add a new draw handler to this space type. It will be called every time the specified region in the space type will be drawn. Note: All arguments are positional only for now. 

        :param callback: A function that will be called when the region is drawn. It gets the specified arguments as input. 
        :type callback: 
        :param args: Arguments that will be passed to the callback. 
        :type args: tuple
        :param region_type: The region type the callback draws in; usually WINDOW. (bpy.types.Region.type) 
        :type region_type: str
        :param draw_type: Usually POST_PIXEL for 2D drawing and POST_VIEW for 3D drawing. In some cases PRE_VIEW can be used. BACKDROP can be used for backdrops in the node editor. 
        :type draw_type: str
        :rtype: 'bpy.context.object'
        :return:  Handler that can be removed later on. 
        '''
        pass

    def draw_handler_remove(self, handler: 'bpy.context.object',
                            region_type: str):
        '''Remove a draw handler that was added previously. 

        :param handler: The draw handler that should be removed. 
        :type handler: 'bpy.context.object'
        :param region_type: Region type the callback was added to. 
        :type region_type: str
        '''
        pass


class SpaceNodeEditorPath(bpy_struct):
    '''Get the node tree path as a string '''

    to_string: str = None
    '''

    :type: str
    '''

    def clear(self, ):
        '''Reset the node tree path 

        '''
        pass

    def start(self, node_tree: 'NodeTree'):
        '''Set the root node tree 

        :param node_tree: Node Tree 
        :type node_tree: 'NodeTree'
        '''
        pass

    def append(self, node_tree: 'NodeTree', node: 'Node' = None):
        '''Append a node group tree to the path 

        :param node_tree: Node Tree, Node tree to append to the node editor path 
        :type node_tree: 'NodeTree'
        :param node: Node, Group node linking to this node tree 
        :type node: 'Node'
        '''
        pass

    def pop(self, ):
        '''Remove the last node tree from the path 

        '''
        pass


class SpaceUVEditor(bpy_struct):
    '''UV editor data for the image editor space '''

    display_stretch_type: typing.Union[str, int] = None
    '''Type of stretch to draw 

    :type: typing.Union[str, int]
    '''

    edge_display_type: typing.Union[str, int] = None
    '''Display style for UV edges 

    :type: typing.Union[str, int]
    '''

    lock_bounds: bool = None
    '''Constraint to stay within the image bounds while editing 

    :type: bool
    '''

    pixel_snap_mode: typing.Union[str, int] = None
    '''Snap UVs to pixels while editing 

    :type: typing.Union[str, int]
    '''

    show_faces: bool = None
    '''Display faces over the image 

    :type: bool
    '''

    show_metadata: bool = None
    '''Display metadata properties of the image 

    :type: bool
    '''

    show_modified_edges: bool = None
    '''Display edges after modifiers are applied 

    :type: bool
    '''

    show_pixel_coords: bool = None
    '''Display UV coordinates in pixels rather than from 0.0 to 1.0 

    :type: bool
    '''

    show_smooth_edges: bool = None
    '''Display UV edges anti-aliased 

    :type: bool
    '''

    show_stretch: bool = None
    '''Display faces colored according to the difference in shape between UVs and their 3D coordinates (blue for low distortion, red for high distortion) 

    :type: bool
    '''

    show_texpaint: bool = None
    '''Display overlay of texture paint uv layer 

    :type: bool
    '''

    sticky_select_mode: typing.Union[str, int] = None
    '''Automatically select also UVs sharing the same vertex as the ones being selected 

    :type: typing.Union[str, int]
    '''

    tile_grid_shape: typing.List[int] = None
    '''How many tiles will be shown in the background 

    :type: typing.List[int]
    '''

    use_live_unwrap: bool = None
    '''Continuously unwrap the selected UV island while transforming pinned vertices 

    :type: bool
    '''


class Spline(bpy_struct):
    '''Element of a curve, either NURBS, Bezier or Polyline or a character with text objects '''

    bezier_points: typing.Union[typing.List['BezierSplinePoint'],
                                'bpy_prop_collection',
                                'SplineBezierPoints'] = None
    '''Collection of points for Bezier curves only 

    :type: typing.Union[typing.List['BezierSplinePoint'], 'bpy_prop_collection', 'SplineBezierPoints']
    '''

    character_index: int = None
    '''Location of this character in the text data (only for text curves) 

    :type: int
    '''

    hide: bool = None
    '''Hide this curve in Edit mode 

    :type: bool
    '''

    material_index: int = None
    '''

    :type: int
    '''

    order_u: int = None
    '''NURBS order in the U direction (for splines and surfaces, higher values let points influence a greater area) 

    :type: int
    '''

    order_v: int = None
    '''NURBS order in the V direction (for surfaces only, higher values let points influence a greater area) 

    :type: int
    '''

    point_count_u: int = None
    '''Total number points for the curve or surface in the U direction 

    :type: int
    '''

    point_count_v: int = None
    '''Total number points for the surface on the V direction 

    :type: int
    '''

    points: typing.Union[typing.List['SplinePoint'], 'bpy_prop_collection',
                         'SplinePoints'] = None
    '''Collection of points that make up this poly or nurbs spline 

    :type: typing.Union[typing.List['SplinePoint'], 'bpy_prop_collection', 'SplinePoints']
    '''

    radius_interpolation: typing.Union[str, int] = None
    '''The type of radius interpolation for Bezier curves 

    :type: typing.Union[str, int]
    '''

    resolution_u: int = None
    '''Curve or Surface subdivisions per segment 

    :type: int
    '''

    resolution_v: int = None
    '''Surface subdivisions per segment 

    :type: int
    '''

    tilt_interpolation: typing.Union[str, int] = None
    '''The type of tilt interpolation for 3D, Bezier curves 

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    '''The interpolation type for this curve element 

    :type: typing.Union[str, int]
    '''

    use_bezier_u: bool = None
    '''Make this nurbs curve or surface act like a Bezier spline in the U direction (Order U must be 3 or 4, Cyclic U must be disabled) 

    :type: bool
    '''

    use_bezier_v: bool = None
    '''Make this nurbs surface act like a Bezier spline in the V direction (Order V must be 3 or 4, Cyclic V must be disabled) 

    :type: bool
    '''

    use_cyclic_u: bool = None
    '''Make this curve or surface a closed loop in the U direction 

    :type: bool
    '''

    use_cyclic_v: bool = None
    '''Make this surface a closed loop in the V direction 

    :type: bool
    '''

    use_endpoint_u: bool = None
    '''Make this nurbs curve or surface meet the endpoints in the U direction (Cyclic U must be disabled) 

    :type: bool
    '''

    use_endpoint_v: bool = None
    '''Make this nurbs surface meet the endpoints in the V direction (Cyclic V must be disabled) 

    :type: bool
    '''

    use_smooth: bool = None
    '''Smooth the normals of the surface or beveled curve 

    :type: bool
    '''

    def calc_length(self, resolution: int = 0) -> float:
        '''Calculate spline length 

        :param resolution: Resolution, Spline resolution to be used, 0 defaults to the resolution_u 
        :type resolution: int
        :rtype: float
        :return:  Length, Length of the polygonaly approximated spline 
        '''
        pass


class SplineBezierPoints(bpy_struct):
    '''Collection of spline Bezier points '''

    def add(self, count: int):
        '''Add a number of points to this spline 

        :param count: Number, Number of points to add to the spline 
        :type count: int
        '''
        pass


class SplinePoint(bpy_struct):
    '''Spline point without handles '''

    co: typing.List[float] = None
    '''Point coordinates 

    :type: typing.List[float]
    '''

    hide: bool = None
    '''Visibility status 

    :type: bool
    '''

    radius: float = None
    '''Radius for beveling 

    :type: float
    '''

    select: bool = None
    '''Selection status 

    :type: bool
    '''

    tilt: float = None
    '''Tilt in 3D View 

    :type: float
    '''

    weight: float = None
    '''NURBS weight 

    :type: float
    '''

    weight_softbody: float = None
    '''Softbody goal weight 

    :type: float
    '''


class SplinePoints(bpy_struct):
    '''Collection of spline points '''

    def add(self, count: int):
        '''Add a number of points to this spline 

        :param count: Number, Number of points to add to the spline 
        :type count: int
        '''
        pass


class Stereo3dDisplay(bpy_struct):
    '''Settings for stereo 3D display '''

    anaglyph_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    display_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    interlace_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    use_interlace_swap: bool = None
    '''Swap left and right stereo channels 

    :type: bool
    '''

    use_sidebyside_crosseyed: bool = None
    '''Right eye should see left image and vice-versa 

    :type: bool
    '''


class Stereo3dFormat(bpy_struct):
    '''Settings for stereo output '''

    anaglyph_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    display_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    interlace_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    use_interlace_swap: bool = None
    '''Swap left and right stereo channels 

    :type: bool
    '''

    use_sidebyside_crosseyed: bool = None
    '''Right eye should see left image and vice-versa 

    :type: bool
    '''

    use_squeezed_frame: bool = None
    '''Combine both views in a squeezed image 

    :type: bool
    '''


class Struct(bpy_struct):
    '''RNA structure definition '''

    base: 'Struct' = None
    '''Struct definition this is derived from 

    :type: 'Struct'
    '''

    description: str = None
    '''Description of the Struct’s purpose 

    :type: str
    '''

    functions: typing.Union[typing.
                            List['Function'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['Function'], 'bpy_prop_collection']
    '''

    identifier: str = None
    '''Unique name used in the code and scripting 

    :type: str
    '''

    name: str = None
    '''Human readable name 

    :type: str
    '''

    name_property: 'StringProperty' = None
    '''Property that gives the name of the struct 

    :type: 'StringProperty'
    '''

    nested: 'Struct' = None
    '''Struct in which this struct is always nested, and to which it logically belongs 

    :type: 'Struct'
    '''

    properties: typing.Union[typing.
                             List['Property'], 'bpy_prop_collection'] = None
    '''Properties in the struct 

    :type: typing.Union[typing.List['Property'], 'bpy_prop_collection']
    '''

    property_tags: typing.Union[typing.List['EnumPropertyItem'],
                                'bpy_prop_collection'] = None
    '''Tags that properties can use to influence behavior 

    :type: typing.Union[typing.List['EnumPropertyItem'], 'bpy_prop_collection']
    '''

    translation_context: str = None
    '''Translation context of the struct’s name 

    :type: str
    '''


class StudioLight(bpy_struct):
    '''Studio light '''

    has_specular_highlight_pass: bool = None
    '''Studio light image file has separate “diffuse” and “specular” passes 

    :type: bool
    '''

    index: int = None
    '''

    :type: int
    '''

    is_user_defined: bool = None
    '''

    :type: bool
    '''

    light_ambient: typing.List[float] = None
    '''Color of the ambient light that uniformly lit the scene 

    :type: typing.List[float]
    '''

    name: str = None
    '''

    :type: str
    '''

    path: str = None
    '''

    :type: str
    '''

    path_irr_cache: str = None
    '''Path where the irradiance cache is stored 

    :type: str
    '''

    path_sh_cache: str = None
    '''Path where the spherical harmonics cache is stored 

    :type: str
    '''

    solid_lights: typing.Union[typing.List['UserSolidLight'],
                               'bpy_prop_collection'] = None
    '''Lights user to display objects in solid draw mode 

    :type: typing.Union[typing.List['UserSolidLight'], 'bpy_prop_collection']
    '''

    spherical_harmonics_coefficients: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''


class StudioLights(bpy_struct):
    '''Collection of studio lights '''

    def load(self, path: str, type: typing.Union[str, int]) -> 'StudioLight':
        '''Load studiolight from file 

        :param path: File Path, File path where the studio light file can be found 
        :type path: str
        :param type: Type, The type for the new studio light 
        :type type: typing.Union[str, int]
        :rtype: 'StudioLight'
        :return:  Newly created StudioLight 
        '''
        pass

    def new(self, path: str) -> 'StudioLight':
        '''Create studiolight from default lighting 

        :param path: Path, Path to the file that will contain the lighing info (without extension) 
        :type path: str
        :rtype: 'StudioLight'
        :return:  Newly created StudioLight 
        '''
        pass

    def remove(self, studio_light: 'StudioLight'):
        '''Remove a studio light 

        :param studio_light: The studio light to remove 
        :type studio_light: 'StudioLight'
        '''
        pass

    def refresh(self, ):
        '''Refresh Studio Lights from disk 

        '''
        pass


class TexMapping(bpy_struct):
    '''Texture coordinate mapping settings '''

    mapping: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    mapping_x: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    mapping_y: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    mapping_z: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    max: typing.List[float] = None
    '''Maximum value for clipping 

    :type: typing.List[float]
    '''

    min: typing.List[float] = None
    '''Minimum value for clipping 

    :type: typing.List[float]
    '''

    rotation: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    scale: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    translation: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    use_max: bool = None
    '''Whether to use maximum clipping value 

    :type: bool
    '''

    use_min: bool = None
    '''Whether to use minimum clipping value 

    :type: bool
    '''

    vector_type: typing.Union[str, int] = None
    '''Type of vector that the mapping transforms 

    :type: typing.Union[str, int]
    '''


class TexPaintSlot(bpy_struct):
    '''Slot that contains information about texture painting '''

    is_valid: bool = None
    '''Slot has a valid image and UV map 

    :type: bool
    '''

    uv_layer: str = None
    '''Name of UV map 

    :type: str
    '''


class TextBox(bpy_struct):
    '''Text bounding box for layout '''

    height: float = None
    '''

    :type: float
    '''

    width: float = None
    '''

    :type: float
    '''

    x: float = None
    '''

    :type: float
    '''

    y: float = None
    '''

    :type: float
    '''


class TextCharacterFormat(bpy_struct):
    '''Text character formatting settings '''

    kerning: int = None
    '''Spacing between characters 

    :type: int
    '''

    material_index: int = None
    '''

    :type: int
    '''

    use_bold: bool = None
    '''

    :type: bool
    '''

    use_italic: bool = None
    '''

    :type: bool
    '''

    use_small_caps: bool = None
    '''

    :type: bool
    '''

    use_underline: bool = None
    '''

    :type: bool
    '''


class TextLine(bpy_struct):
    '''Line of text in a Text data-block '''

    body: str = None
    '''Text in the line 

    :type: str
    '''


class TextureSlot(bpy_struct):
    '''Texture slot defining the mapping and influence of a texture '''

    blend_type: typing.Union[str, int] = None
    '''Mode used to apply the texture 

    :type: typing.Union[str, int]
    '''

    color: typing.List[float] = None
    '''Default color for textures that don’t return RGB or when RGB to intensity is enabled 

    :type: typing.List[float]
    '''

    default_value: float = None
    '''Value to use for Ref, Spec, Amb, Emit, Alpha, RayMir, TransLu and Hard 

    :type: float
    '''

    name: str = None
    '''Texture slot name 

    :type: str
    '''

    offset: typing.List[float] = None
    '''Fine tune of the texture mapping X, Y and Z locations 

    :type: typing.List[float]
    '''

    output_node: typing.Union[str, int] = None
    '''Which output node to use, for node-based textures 

    :type: typing.Union[str, int]
    '''

    scale: typing.List[float] = None
    '''Set scaling for the texture’s X, Y and Z sizes 

    :type: typing.List[float]
    '''

    texture: 'Texture' = None
    '''Texture data-block used by this texture slot 

    :type: 'Texture'
    '''


class Theme(bpy_struct):
    '''Theme settings defining draw style and colors in the user interface '''

    bone_color_sets: typing.Union[typing.List['ThemeBoneColorSet'],
                                  'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['ThemeBoneColorSet'], 'bpy_prop_collection']
    '''

    clip_editor: 'ThemeClipEditor' = None
    '''

    :type: 'ThemeClipEditor'
    '''

    console: 'ThemeConsole' = None
    '''

    :type: 'ThemeConsole'
    '''

    dopesheet_editor: 'ThemeDopeSheet' = None
    '''

    :type: 'ThemeDopeSheet'
    '''

    file_browser: 'ThemeFileBrowser' = None
    '''

    :type: 'ThemeFileBrowser'
    '''

    graph_editor: 'ThemeGraphEditor' = None
    '''

    :type: 'ThemeGraphEditor'
    '''

    image_editor: 'ThemeImageEditor' = None
    '''

    :type: 'ThemeImageEditor'
    '''

    info: 'ThemeInfo' = None
    '''

    :type: 'ThemeInfo'
    '''

    name: str = None
    '''Name of the theme 

    :type: str
    '''

    nla_editor: 'ThemeNLAEditor' = None
    '''

    :type: 'ThemeNLAEditor'
    '''

    node_editor: 'ThemeNodeEditor' = None
    '''

    :type: 'ThemeNodeEditor'
    '''

    outliner: 'ThemeOutliner' = None
    '''

    :type: 'ThemeOutliner'
    '''

    preferences: 'ThemePreferences' = None
    '''

    :type: 'ThemePreferences'
    '''

    properties: 'ThemeProperties' = None
    '''

    :type: 'ThemeProperties'
    '''

    sequence_editor: 'ThemeSequenceEditor' = None
    '''

    :type: 'ThemeSequenceEditor'
    '''

    statusbar: 'ThemeStatusBar' = None
    '''

    :type: 'ThemeStatusBar'
    '''

    text_editor: 'ThemeTextEditor' = None
    '''

    :type: 'ThemeTextEditor'
    '''

    theme_area: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    topbar: 'ThemeTopBar' = None
    '''

    :type: 'ThemeTopBar'
    '''

    user_interface: 'ThemeUserInterface' = None
    '''

    :type: 'ThemeUserInterface'
    '''

    view_3d: 'ThemeView3D' = None
    '''

    :type: 'ThemeView3D'
    '''


class ThemeBoneColorSet(bpy_struct):
    '''Theme settings for bone color sets '''

    active: typing.List[float] = None
    '''Color used for active bones 

    :type: typing.List[float]
    '''

    normal: typing.List[float] = None
    '''Color used for the surface of bones 

    :type: typing.List[float]
    '''

    select: typing.List[float] = None
    '''Color used for selected bones 

    :type: typing.List[float]
    '''

    show_colored_constraints: bool = None
    '''Allow the use of colors indicating constraints/keyed status 

    :type: bool
    '''


class ThemeClipEditor(bpy_struct):
    '''Theme settings for the Movie Clip Editor '''

    active_marker: typing.List[float] = None
    '''Color of active marker 

    :type: typing.List[float]
    '''

    disabled_marker: typing.List[float] = None
    '''Color of disabled marker 

    :type: typing.List[float]
    '''

    frame_current: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_align: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_auto: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_auto_clamped: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_free: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_align: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_auto: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_auto_clamped: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_free: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_vertex: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_vertex_select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_vertex_size: int = None
    '''

    :type: int
    '''

    locked_marker: typing.List[float] = None
    '''Color of locked marker 

    :type: typing.List[float]
    '''

    marker: typing.List[float] = None
    '''Color of marker 

    :type: typing.List[float]
    '''

    marker_outline: typing.List[float] = None
    '''Color of marker’s outline 

    :type: typing.List[float]
    '''

    metadatabg: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    metadatatext: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    path_after: typing.List[float] = None
    '''Color of path after current frame 

    :type: typing.List[float]
    '''

    path_before: typing.List[float] = None
    '''Color of path before current frame 

    :type: typing.List[float]
    '''

    path_keyframe_after: typing.List[float] = None
    '''Color of path after current frame 

    :type: typing.List[float]
    '''

    path_keyframe_before: typing.List[float] = None
    '''Color of path before current frame 

    :type: typing.List[float]
    '''

    selected_marker: typing.List[float] = None
    '''Color of selected marker 

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    '''Settings for space list 

    :type: 'ThemeSpaceListGeneric'
    '''

    strips: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    strips_selected: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    time_scrub_background: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemeConsole(bpy_struct):
    '''Theme settings for the Console '''

    cursor: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    line_error: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    line_info: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    line_input: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    line_output: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeDopeSheet(bpy_struct):
    '''Theme settings for the Dope Sheet '''

    active_channels_group: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    channel_group: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    channels: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    channels_selected: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    dopesheet_channel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    dopesheet_subchannel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    frame_current: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    grid: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    interpolation_line: typing.List[float] = None
    '''Color of lines showing non-bezier interpolation modes 

    :type: typing.List[float]
    '''

    keyframe: typing.List[float] = None
    '''Color of Keyframe 

    :type: typing.List[float]
    '''

    keyframe_border: typing.List[float] = None
    '''Color of keyframe border 

    :type: typing.List[float]
    '''

    keyframe_border_selected: typing.List[float] = None
    '''Color of selected keyframe border 

    :type: typing.List[float]
    '''

    keyframe_breakdown: typing.List[float] = None
    '''Color of breakdown keyframe 

    :type: typing.List[float]
    '''

    keyframe_breakdown_selected: typing.List[float] = None
    '''Color of selected breakdown keyframe 

    :type: typing.List[float]
    '''

    keyframe_extreme: typing.List[float] = None
    '''Color of extreme keyframe 

    :type: typing.List[float]
    '''

    keyframe_extreme_selected: typing.List[float] = None
    '''Color of selected extreme keyframe 

    :type: typing.List[float]
    '''

    keyframe_jitter: typing.List[float] = None
    '''Color of jitter keyframe 

    :type: typing.List[float]
    '''

    keyframe_jitter_selected: typing.List[float] = None
    '''Color of selected jitter keyframe 

    :type: typing.List[float]
    '''

    keyframe_movehold: typing.List[float] = None
    '''Color of moving hold keyframe 

    :type: typing.List[float]
    '''

    keyframe_movehold_selected: typing.List[float] = None
    '''Color of selected moving hold keyframe 

    :type: typing.List[float]
    '''

    keyframe_scale_factor: float = None
    '''Scale factor for adjusting the height of keyframes 

    :type: float
    '''

    keyframe_selected: typing.List[float] = None
    '''Color of selected keyframe 

    :type: typing.List[float]
    '''

    long_key: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    long_key_selected: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    preview_range: typing.List[float] = None
    '''Color of preview range overlay 

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    '''Settings for space list 

    :type: 'ThemeSpaceListGeneric'
    '''

    summary: typing.List[float] = None
    '''Color of summary channel 

    :type: typing.List[float]
    '''

    time_scrub_background: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    value_sliders: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    view_sliders: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemeFileBrowser(bpy_struct):
    '''Theme settings for the File Browser '''

    selected_file: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeFontStyle(bpy_struct):
    '''Theme settings for Font '''

    font_kerning_style: typing.Union[str, int] = None
    '''Which style to use for font kerning 

    :type: typing.Union[str, int]
    '''

    points: int = None
    '''

    :type: int
    '''

    shadow: int = None
    '''Shadow size (0, 3 and 5 supported) 

    :type: int
    '''

    shadow_alpha: float = None
    '''

    :type: float
    '''

    shadow_offset_x: int = None
    '''Shadow offset in pixels 

    :type: int
    '''

    shadow_offset_y: int = None
    '''Shadow offset in pixels 

    :type: int
    '''

    shadow_value: float = None
    '''Shadow color in gray value 

    :type: float
    '''


class ThemeGradientColors(bpy_struct):
    '''Theme settings for background colors and gradient '''

    gradient: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    high_gradient: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    show_grad: bool = None
    '''Do a gradient for the background of the viewport working area 

    :type: bool
    '''


class ThemeGraphEditor(bpy_struct):
    '''Theme settings for the graph editor '''

    active_channels_group: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    channel_group: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    channels_region: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    dopesheet_channel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    dopesheet_subchannel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    frame_current: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    grid: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_align: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_auto: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_auto_clamped: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_free: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_align: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_auto: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_auto_clamped: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_free: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_vect: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_vect: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_vertex: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_vertex_select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_vertex_size: int = None
    '''

    :type: int
    '''

    lastsel_point: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    preview_range: typing.List[float] = None
    '''Color of preview range overlay 

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    '''Settings for space list 

    :type: 'ThemeSpaceListGeneric'
    '''

    time_scrub_background: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex_bevel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex_select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex_size: int = None
    '''

    :type: int
    '''

    vertex_unreferenced: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    window_sliders: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemeImageEditor(bpy_struct):
    '''Theme settings for the Image Editor '''

    edge_select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    editmesh_active: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    face: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    face_back: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    face_dot: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    face_front: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    face_select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    facedot_size: int = None
    '''

    :type: int
    '''

    frame_current: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    freestyle_face_mark: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_align: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_auto: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_auto_clamped: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_free: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_align: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_auto: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_auto_clamped: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_free: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_vertex: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_vertex_select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_vertex_size: int = None
    '''

    :type: int
    '''

    metadatabg: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    metadatatext: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    paint_curve_handle: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    paint_curve_pivot: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    preview_stitch_active: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    preview_stitch_edge: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    preview_stitch_face: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    preview_stitch_stitchable: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    preview_stitch_unstitchable: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    preview_stitch_vert: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    scope_back: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''

    uv_others: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    uv_shadow: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex_bevel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex_select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex_size: int = None
    '''

    :type: int
    '''

    vertex_unreferenced: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    wire_edit: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemeInfo(bpy_struct):
    '''Theme settings for Info '''

    info_debug: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    info_debug_text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    info_error: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    info_error_text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    info_info: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    info_info_text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    info_selected: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    info_selected_text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    info_warning: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    info_warning_text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeNLAEditor(bpy_struct):
    '''Theme settings for the NLA Editor '''

    active_action: typing.List[float] = None
    '''Animation data-block has active action 

    :type: typing.List[float]
    '''

    active_action_unset: typing.List[float] = None
    '''Animation data-block doesn’t have active action 

    :type: typing.List[float]
    '''

    dopesheet_channel: typing.List[float] = None
    '''Nonlinear Animation Channel 

    :type: typing.List[float]
    '''

    frame_current: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    grid: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    keyframe_border: typing.List[float] = None
    '''Color of keyframe border 

    :type: typing.List[float]
    '''

    keyframe_border_selected: typing.List[float] = None
    '''Color of selected keyframe border 

    :type: typing.List[float]
    '''

    meta_strips: typing.List[float] = None
    '''Meta Strip - Unselected (for grouping related strips) 

    :type: typing.List[float]
    '''

    meta_strips_selected: typing.List[float] = None
    '''Meta Strip - Selected (for grouping related strips) 

    :type: typing.List[float]
    '''

    nla_track: typing.List[float] = None
    '''Nonlinear Animation Track 

    :type: typing.List[float]
    '''

    preview_range: typing.List[float] = None
    '''Color of preview range overlay 

    :type: typing.List[float]
    '''

    sound_strips: typing.List[float] = None
    '''Sound Strip - Unselected (for timing speaker sounds) 

    :type: typing.List[float]
    '''

    sound_strips_selected: typing.List[float] = None
    '''Sound Strip - Selected (for timing speaker sounds) 

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    '''Settings for space list 

    :type: 'ThemeSpaceListGeneric'
    '''

    strips: typing.List[float] = None
    '''Action-Clip Strip - Unselected 

    :type: typing.List[float]
    '''

    strips_selected: typing.List[float] = None
    '''Action-Clip Strip - Selected 

    :type: typing.List[float]
    '''

    time_scrub_background: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    transition_strips: typing.List[float] = None
    '''Transition Strip - Unselected 

    :type: typing.List[float]
    '''

    transition_strips_selected: typing.List[float] = None
    '''Transition Strip - Selected 

    :type: typing.List[float]
    '''

    tweak: typing.List[float] = None
    '''Color for strip/action being ‘tweaked’ or edited 

    :type: typing.List[float]
    '''

    tweak_duplicate: typing.List[float] = None
    '''Warning/error indicator color for strips referencing the strip being tweaked 

    :type: typing.List[float]
    '''

    view_sliders: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemeNodeEditor(bpy_struct):
    '''Theme settings for the Node Editor '''

    color_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    converter_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    distor_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    filter_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    frame_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    group_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    group_socket_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    input_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    layout_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    matte_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    node_active: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    node_backdrop: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    node_selected: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    noodle_curving: int = None
    '''Curving of the noodle 

    :type: int
    '''

    output_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    pattern_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    script_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    selected_text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    shader_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''

    space_list: 'ThemeSpaceListGeneric' = None
    '''Settings for space list 

    :type: 'ThemeSpaceListGeneric'
    '''

    texture_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vector_node: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    wire: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    wire_inner: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    wire_select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemeOutliner(bpy_struct):
    '''Theme settings for the Outliner '''

    active: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    active_object: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    edited_object: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    match: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    row_alternate: typing.List[float] = None
    '''Overlay color on every other row 

    :type: typing.List[float]
    '''

    selected_highlight: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    selected_object: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''


class ThemePanelColors(bpy_struct):
    '''Theme settings for panel colors '''

    back: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    header: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    sub_back: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemePreferences(bpy_struct):
    '''Theme settings for the Blender Preferences '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeProperties(bpy_struct):
    '''Theme settings for the Properties '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeSequenceEditor(bpy_struct):
    '''Theme settings for the Sequence Editor '''

    audio_strip: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    draw_action: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    effect_strip: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    frame_current: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    grid: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    image_strip: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    keyframe: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    meta_strip: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    metadatabg: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    metadatatext: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    movie_strip: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    movieclip_strip: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    preview_back: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    preview_range: typing.List[float] = None
    '''Color of preview range overlay 

    :type: typing.List[float]
    '''

    scene_strip: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''

    text_strip: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    time_scrub_background: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    transition_strip: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    window_sliders: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemeSpaceGeneric(bpy_struct):
    back: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    button: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    button_text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    button_text_hi: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    button_title: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    execution_buts: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    header: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    header_text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    header_text_hi: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    navigation_bar: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    panelcolors: 'ThemePanelColors' = None
    '''

    :type: 'ThemePanelColors'
    '''

    tab_active: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    tab_back: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    tab_inactive: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    tab_outline: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    text_hi: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    title: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemeSpaceGradient(bpy_struct):
    button: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    button_text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    button_text_hi: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    button_title: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    execution_buts: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    gradients: 'ThemeGradientColors' = None
    '''

    :type: 'ThemeGradientColors'
    '''

    header: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    header_text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    header_text_hi: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    navigation_bar: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    panelcolors: 'ThemePanelColors' = None
    '''

    :type: 'ThemePanelColors'
    '''

    tab_active: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    tab_back: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    tab_inactive: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    tab_outline: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    text_hi: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    title: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemeSpaceListGeneric(bpy_struct):
    list: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    list_text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    list_text_hi: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    list_title: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemeStatusBar(bpy_struct):
    '''Theme settings for the Status Bar '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeStyle(bpy_struct):
    '''Theme settings for style sets '''

    panel_title: 'ThemeFontStyle' = None
    '''

    :type: 'ThemeFontStyle'
    '''

    widget: 'ThemeFontStyle' = None
    '''

    :type: 'ThemeFontStyle'
    '''

    widget_label: 'ThemeFontStyle' = None
    '''

    :type: 'ThemeFontStyle'
    '''


class ThemeTextEditor(bpy_struct):
    '''Theme settings for the Text Editor '''

    cursor: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    line_numbers: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    line_numbers_background: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    selected_text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''

    syntax_builtin: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    syntax_comment: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    syntax_numbers: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    syntax_preprocessor: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    syntax_reserved: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    syntax_special: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    syntax_string: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    syntax_symbols: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemeTopBar(bpy_struct):
    '''Theme settings for the Top Bar '''

    space: 'ThemeSpaceGeneric' = None
    '''Settings for space 

    :type: 'ThemeSpaceGeneric'
    '''


class ThemeUserInterface(bpy_struct):
    '''Theme settings for user interface elements '''

    axis_x: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    axis_y: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    axis_z: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    editor_outline: typing.List[float] = None
    '''Color of the outline of the editors and their round corners 

    :type: typing.List[float]
    '''

    gizmo_a: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    gizmo_b: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    gizmo_hi: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    gizmo_primary: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    gizmo_secondary: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    icon_alpha: float = None
    '''Transparency of icons in the interface, to reduce contrast 

    :type: float
    '''

    icon_border_intensity: float = None
    '''Control the intensity of the border around themes icons 

    :type: float
    '''

    icon_collection: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    icon_folder: typing.List[float] = None
    '''Color of folders in the file browser 

    :type: typing.List[float]
    '''

    icon_modifier: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    icon_object: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    icon_object_data: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    icon_saturation: float = None
    '''Saturation of icons in the interface 

    :type: float
    '''

    icon_scene: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    icon_shading: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    menu_shadow_fac: float = None
    '''Blending factor for menu shadows 

    :type: float
    '''

    menu_shadow_width: int = None
    '''Width of menu shadows, set to zero to disable 

    :type: int
    '''

    wcol_box: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_list_item: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_menu: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_menu_back: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_menu_item: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_num: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_numslider: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_option: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_pie_menu: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_progress: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_pulldown: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_radio: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_regular: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_scroll: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_state: 'ThemeWidgetStateColors' = None
    '''

    :type: 'ThemeWidgetStateColors'
    '''

    wcol_tab: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_text: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_toggle: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_tool: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_toolbar_item: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    wcol_tooltip: 'ThemeWidgetColors' = None
    '''

    :type: 'ThemeWidgetColors'
    '''

    widget_emboss: typing.List[float] = None
    '''Color of the 1px shadow line underlying widgets 

    :type: typing.List[float]
    '''

    widget_text_cursor: typing.List[float] = None
    '''Color of the interface widgets text insertion cursor (caret) 

    :type: typing.List[float]
    '''


class ThemeView3D(bpy_struct):
    '''Theme settings for the 3D View '''

    act_spline: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    bone_pose: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    bone_pose_active: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    bone_solid: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    bundle_solid: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    camera: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    camera_path: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    clipping_border_3d: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    edge_bevel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    edge_crease: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    edge_facesel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    edge_seam: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    edge_select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    edge_sharp: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    editmesh_active: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    empty: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    extra_edge_angle: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    extra_edge_len: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    extra_face_angle: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    extra_face_area: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    face: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    face_back: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    face_dot: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    face_front: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    face_select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    facedot_size: int = None
    '''

    :type: int
    '''

    frame_current: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    freestyle_edge_mark: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    freestyle_face_mark: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    gp_vertex: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    gp_vertex_select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    gp_vertex_size: int = None
    '''

    :type: int
    '''

    grid: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_align: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_auto: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_free: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_align: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_auto: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_free: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_sel_vect: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    handle_vect: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    lastsel_point: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    light: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    normal: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    nurb_sel_uline: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    nurb_sel_vline: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    nurb_uline: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    nurb_vline: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    object_active: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    object_origin_size: int = None
    '''Diameter in Pixels for Object/Light origin display 

    :type: int
    '''

    object_selected: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    outline_width: int = None
    '''

    :type: int
    '''

    paint_curve_handle: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    paint_curve_pivot: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    skin_root: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    space: 'ThemeSpaceGradient' = None
    '''Settings for space 

    :type: 'ThemeSpaceGradient'
    '''

    speaker: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    split_normal: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    text_grease_pencil: typing.List[float] = None
    '''Color for indicating Grease Pencil keyframes 

    :type: typing.List[float]
    '''

    text_keyframe: typing.List[float] = None
    '''Color for indicating Object keyframes 

    :type: typing.List[float]
    '''

    transform: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex_bevel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex_normal: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex_select: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    vertex_size: int = None
    '''

    :type: int
    '''

    vertex_unreferenced: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    view_overlay: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    wire: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    wire_edit: typing.List[float] = None
    '''Color for wireframe when in edit mode, but edge selection is active 

    :type: typing.List[float]
    '''


class ThemeWidgetColors(bpy_struct):
    '''Theme settings for widget color sets '''

    inner: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    inner_sel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    item: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    outline: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    roundness: float = None
    '''Amount of edge rounding 

    :type: float
    '''

    shadedown: int = None
    '''

    :type: int
    '''

    shadetop: int = None
    '''

    :type: int
    '''

    show_shaded: bool = None
    '''

    :type: bool
    '''

    text: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    text_sel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class ThemeWidgetStateColors(bpy_struct):
    '''Theme settings for widget state colors '''

    blend: float = None
    '''

    :type: float
    '''

    inner_anim: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    inner_anim_sel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    inner_changed: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    inner_changed_sel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    inner_driven: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    inner_driven_sel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    inner_key: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    inner_key_sel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    inner_overridden: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    inner_overridden_sel: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''


class TimelineMarker(bpy_struct):
    '''Marker for noting points in the timeline '''

    camera: 'Object' = None
    '''Camera that becomes active on this frame 

    :type: 'Object'
    '''

    frame: int = None
    '''The frame on which the timeline marker appears 

    :type: int
    '''

    name: str = None
    '''

    :type: str
    '''

    select: bool = None
    '''Marker selection state 

    :type: bool
    '''


class TimelineMarkers(bpy_struct):
    '''Collection of timeline markers '''

    def new(self, name: str, frame: int = 1) -> 'TimelineMarker':
        '''Add a keyframe to the curve 

        :param name: New name for the marker (not unique) 
        :type name: str
        :param frame: The frame for the new marker 
        :type frame: int
        :rtype: 'TimelineMarker'
        :return:  Newly created timeline marker 
        '''
        pass

    def remove(self, marker: 'TimelineMarker'):
        '''Remove a timeline marker 

        :param marker: Timeline marker to remove 
        :type marker: 'TimelineMarker'
        '''
        pass

    def clear(self, ):
        '''Remove all timeline markers 

        '''
        pass


class Timer(bpy_struct):
    '''Window event timer '''

    time_delta: float = None
    '''Time since last step in seconds 

    :type: float
    '''

    time_duration: float = None
    '''Time since last step in seconds 

    :type: float
    '''

    time_step: float = None
    '''

    :type: float
    '''


class ToolSettings(bpy_struct):
    annotation_stroke_placement_image_editor: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    annotation_stroke_placement_sequencer_preview: typing.Union[str,
                                                                int] = None
    '''

    :type: typing.Union[str, int]
    '''

    annotation_stroke_placement_view2d: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    annotation_stroke_placement_view3d: typing.Union[str, int] = None
    '''How annotation strokes are orientated in 3D space 

    :type: typing.Union[str, int]
    '''

    annotation_thickness: int = None
    '''Thickness of annotation strokes 

    :type: int
    '''

    auto_keying_mode: typing.Union[str, int] = None
    '''Mode of automatic keyframe insertion for Objects and Bones 

    :type: typing.Union[str, int]
    '''

    curve_paint_settings: 'CurvePaintSettings' = None
    '''

    :type: 'CurvePaintSettings'
    '''

    custom_bevel_profile_preset: 'CurveProfile' = None
    '''Used for defining a profile’s path 

    :type: 'CurveProfile'
    '''

    double_threshold: float = None
    '''Threshold distance for Auto Merge 

    :type: float
    '''

    gpencil_interpolate: 'GPencilInterpolateSettings' = None
    '''Settings for Grease Pencil Interpolation tools 

    :type: 'GPencilInterpolateSettings'
    '''

    gpencil_paint: 'GpPaint' = None
    '''

    :type: 'GpPaint'
    '''

    gpencil_sculpt: 'GPencilSculptSettings' = None
    '''Settings for stroke sculpting tools and brushes 

    :type: 'GPencilSculptSettings'
    '''

    gpencil_selectmode_edit: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    gpencil_stroke_placement_view3d: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    gpencil_stroke_snap_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    image_paint: 'ImagePaint' = None
    '''

    :type: 'ImagePaint'
    '''

    keyframe_type: typing.Union[str, int] = None
    '''Type of keyframes to create when inserting keyframes 

    :type: typing.Union[str, int]
    '''

    lock_markers: bool = None
    '''Prevent marker editing 

    :type: bool
    '''

    lock_object_mode: bool = None
    '''Restrict select to the current mode 

    :type: bool
    '''

    mesh_select_mode: typing.List[bool] = None
    '''Which mesh elements selection works on 

    :type: typing.List[bool]
    '''

    normal_vector: typing.List[float] = None
    '''Normal Vector used to copy, add or multiply 

    :type: typing.List[float]
    '''

    particle_edit: 'ParticleEdit' = None
    '''

    :type: 'ParticleEdit'
    '''

    proportional_edit_falloff: typing.Union[str, int] = None
    '''Falloff type for proportional editing mode 

    :type: typing.Union[str, int]
    '''

    proportional_size: float = None
    '''Display size for proportional editing circle 

    :type: float
    '''

    sculpt: 'Sculpt' = None
    '''

    :type: 'Sculpt'
    '''

    show_uv_local_view: bool = None
    '''Display only faces with the currently displayed image assigned 

    :type: bool
    '''

    snap_elements: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Type of element to snap to 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    snap_node_element: typing.Union[str, int] = None
    '''Type of element to snap to 

    :type: typing.Union[str, int]
    '''

    snap_target: typing.Union[str, int] = None
    '''Which part to snap onto the target 

    :type: typing.Union[str, int]
    '''

    snap_uv_element: typing.Union[str, int] = None
    '''Type of element to snap to 

    :type: typing.Union[str, int]
    '''

    statvis: 'MeshStatVis' = None
    '''

    :type: 'MeshStatVis'
    '''

    transform_pivot_point: typing.Union[str, int] = None
    '''Pivot center for rotation/scaling 

    :type: typing.Union[str, int]
    '''

    unified_paint_settings: 'UnifiedPaintSettings' = None
    '''

    :type: 'UnifiedPaintSettings'
    '''

    use_auto_normalize: bool = None
    '''Ensure all bone-deforming vertex groups add up to 1.0 while weight painting 

    :type: bool
    '''

    use_edge_path_live_unwrap: bool = None
    '''Changing edges seam re-calculates UV unwrap 

    :type: bool
    '''

    use_gpencil_draw_additive: bool = None
    '''When creating new frames, the strokes from the previous/active frame are included as the basis for the new one 

    :type: bool
    '''

    use_gpencil_draw_onback: bool = None
    '''When draw new strokes, the new stroke is drawn below of all strokes in the layer 

    :type: bool
    '''

    use_gpencil_select_mask_point: bool = None
    '''Only sculpt selected stroke points 

    :type: bool
    '''

    use_gpencil_select_mask_segment: bool = None
    '''Only sculpt selected stroke points between other strokes 

    :type: bool
    '''

    use_gpencil_select_mask_stroke: bool = None
    '''Only sculpt selected stroke 

    :type: bool
    '''

    use_gpencil_stroke_endpoints: bool = None
    '''Only use the first and last parts of the stroke for snapping 

    :type: bool
    '''

    use_gpencil_thumbnail_list: bool = None
    '''Show compact list of color instead of thumbnails 

    :type: bool
    '''

    use_gpencil_weight_data_add: bool = None
    '''When creating new strokes, the weight data is added according to the current vertex group and weight, if no vertex group selected, weight is not added 

    :type: bool
    '''

    use_keyframe_cycle_aware: bool = None
    '''For channels with cyclic extrapolation, keyframe insertion is automatically remapped inside the cycle time range, and keeps ends in sync 

    :type: bool
    '''

    use_keyframe_insert_auto: bool = None
    '''Automatic keyframe insertion for Objects and Bones 

    :type: bool
    '''

    use_keyframe_insert_keyingset: bool = None
    '''Automatic keyframe insertion using active Keying Set only 

    :type: bool
    '''

    use_mesh_automerge: bool = None
    '''Automatically merge vertices moved to the same location 

    :type: bool
    '''

    use_mesh_automerge_and_split: bool = None
    '''Automatically split edges and faces 

    :type: bool
    '''

    use_multipaint: bool = None
    '''Paint across the weights of all selected bones, maintaining their relative influence 

    :type: bool
    '''

    use_proportional_action: bool = None
    '''Proportional editing in action editor 

    :type: bool
    '''

    use_proportional_connected: bool = None
    '''Proportional Editing using connected geometry only 

    :type: bool
    '''

    use_proportional_edit: bool = None
    '''Proportional edit mode 

    :type: bool
    '''

    use_proportional_edit_mask: bool = None
    '''Proportional editing mask mode 

    :type: bool
    '''

    use_proportional_edit_objects: bool = None
    '''Proportional editing object mode 

    :type: bool
    '''

    use_proportional_fcurve: bool = None
    '''Proportional editing in FCurve editor 

    :type: bool
    '''

    use_proportional_projected: bool = None
    '''Proportional Editing using screen space locations 

    :type: bool
    '''

    use_record_with_nla: bool = None
    '''Add a new NLA Track + Strip for every loop/pass made over the animation to allow non-destructive tweaking 

    :type: bool
    '''

    use_snap: bool = None
    '''Snap during transform 

    :type: bool
    '''

    use_snap_align_rotation: bool = None
    '''Align rotation with the snapping target 

    :type: bool
    '''

    use_snap_backface_culling: bool = None
    '''Exclude back facing geometry from snapping 

    :type: bool
    '''

    use_snap_grid_absolute: bool = None
    '''Absolute grid alignment while translating (based on the pivot center) 

    :type: bool
    '''

    use_snap_peel_object: bool = None
    '''Consider objects as whole when finding volume center 

    :type: bool
    '''

    use_snap_project: bool = None
    '''Project individual elements on the surface of other objects 

    :type: bool
    '''

    use_snap_rotate: bool = None
    '''Rotate is affected by the snapping settings 

    :type: bool
    '''

    use_snap_scale: bool = None
    '''Scale is affected by snapping settings 

    :type: bool
    '''

    use_snap_self: bool = None
    '''Snap onto itself (Edit Mode Only) 

    :type: bool
    '''

    use_snap_translate: bool = None
    '''Move is affected by snapping settings 

    :type: bool
    '''

    use_transform_data_origin: bool = None
    '''Manipulate object data 

    :type: bool
    '''

    use_transform_pivot_point_align: bool = None
    '''Manipulate origins (object, pose and weight paint mode only) 

    :type: bool
    '''

    use_transform_skip_children: bool = None
    '''Don’t transform children 

    :type: bool
    '''

    use_uv_select_sync: bool = None
    '''Keep UV and edit mode mesh selection in sync 

    :type: bool
    '''

    uv_relax_method: typing.Union[str, int] = None
    '''Algorithm used for UV relaxation 

    :type: typing.Union[str, int]
    '''

    uv_sculpt: 'UvSculpt' = None
    '''

    :type: 'UvSculpt'
    '''

    uv_sculpt_all_islands: bool = None
    '''Brush operates on all islands 

    :type: bool
    '''

    uv_sculpt_lock_borders: bool = None
    '''Disable editing of boundary edges 

    :type: bool
    '''

    uv_select_mode: typing.Union[str, int] = None
    '''UV selection and display mode 

    :type: typing.Union[str, int]
    '''

    vertex_group_subset: typing.Union[str, int] = None
    '''Filter Vertex groups for Display 

    :type: typing.Union[str, int]
    '''

    vertex_group_user: typing.Union[str, int] = None
    '''Display unweighted vertices 

    :type: typing.Union[str, int]
    '''

    vertex_group_weight: float = None
    '''Weight to assign in vertex groups 

    :type: float
    '''

    vertex_paint: 'VertexPaint' = None
    '''

    :type: 'VertexPaint'
    '''

    weight_paint: 'VertexPaint' = None
    '''

    :type: 'VertexPaint'
    '''

    workspace_tool_type: typing.Union[str, int] = None
    '''Action when dragging in the viewport 

    :type: typing.Union[str, int]
    '''


class TransformOrientation(bpy_struct):
    matrix: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    name: str = None
    '''Name of the custom transform orientation 

    :type: str
    '''


class TransformOrientationSlot(bpy_struct):
    custom_orientation: 'TransformOrientation' = None
    '''

    :type: 'TransformOrientation'
    '''

    type: typing.Union[str, int] = None
    '''Transformation orientation 

    :type: typing.Union[str, int]
    '''

    use: bool = None
    '''Use scene orientation instead of a custom setting 

    :type: bool
    '''


class UDIMTile(bpy_struct):
    '''Properties of the UDIM tile '''

    label: str = None
    '''Tile label 

    :type: str
    '''

    number: int = None
    '''Number of the position that this tile covers 

    :type: int
    '''


class UDIMTiles(bpy_struct):
    '''Collection of UDIM tiles '''

    active: 'UDIMTile' = None
    '''Active Image Tile 

    :type: 'UDIMTile'
    '''

    active_index: int = None
    '''Active index in tiles array 

    :type: int
    '''

    def new(self, tile_number: int, label: str = "") -> 'UDIMTile':
        '''Add a tile to the image 

        :param tile_number: Number of the newly created tile 
        :type tile_number: int
        :param label: Optional label for the tile 
        :type label: str
        :rtype: 'UDIMTile'
        :return:  Newly created image tile 
        '''
        pass

    def get(self, tile_number: int) -> 'UDIMTile':
        '''Get a tile based on its tile number 

        :param tile_number: Number of the tile 
        :type tile_number: int
        :rtype: 'UDIMTile'
        :return:  The tile 
        '''
        pass

    def remove(self, tile: 'UDIMTile'):
        '''Remove an image tile 

        :param tile: Image tile to remove 
        :type tile: 'UDIMTile'
        '''
        pass


class UILayout(bpy_struct):
    '''User interface layout in a panel or header '''

    activate_init: bool = None
    '''When true, buttons defined in popups will be activated on first display (use so you can type into a field without having to click on it first) 

    :type: bool
    '''

    active: bool = None
    '''

    :type: bool
    '''

    active_default: bool = None
    '''When true, an operator button defined after this will be activated when pressing return(use with popup dialogs) 

    :type: bool
    '''

    alert: bool = None
    '''

    :type: bool
    '''

    alignment: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    direction: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    emboss: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    enabled: bool = None
    '''When false, this (sub)layout is grayed out 

    :type: bool
    '''

    operator_context: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    scale_x: float = None
    '''Scale factor along the X for items in this (sub)layout 

    :type: float
    '''

    scale_y: float = None
    '''Scale factor along the Y for items in this (sub)layout 

    :type: float
    '''

    ui_units_x: float = None
    '''Fixed Size along the X for items in this (sub)layout 

    :type: float
    '''

    ui_units_y: float = None
    '''Fixed Size along the Y for items in this (sub)layout 

    :type: float
    '''

    use_property_decorate: bool = None
    '''

    :type: bool
    '''

    use_property_split: bool = None
    '''

    :type: bool
    '''

    def row(self, align: bool = False) -> 'UILayout':
        '''Sub-layout. Items placed in this sublayout are placed next to each other in a row 

        :param align: Align buttons to each other 
        :type align: bool
        :rtype: 'UILayout'
        :return:  Sub-layout to put items in 
        '''
        pass

    def column(self, align: bool = False) -> 'UILayout':
        '''Sub-layout. Items placed in this sublayout are placed under each other in a column 

        :param align: Align buttons to each other 
        :type align: bool
        :rtype: 'UILayout'
        :return:  Sub-layout to put items in 
        '''
        pass

    def column_flow(self, columns: int = 0, align: bool = False) -> 'UILayout':
        '''column_flow 

        :param columns: Number of columns, 0 is automatic 
        :type columns: int
        :param align: Align buttons to each other 
        :type align: bool
        :rtype: 'UILayout'
        :return:  Sub-layout to put items in 
        '''
        pass

    def grid_flow(self,
                  row_major: bool = False,
                  columns: int = 0,
                  even_columns: bool = False,
                  even_rows: bool = False,
                  align: bool = False) -> 'UILayout':
        '''grid_flow 

        :param row_major: Fill row by row, instead of column by column 
        :type row_major: bool
        :param columns: Number of columns, positive are absolute fixed numbers, 0 is automatic, negative are automatic multiple numbers along major axis (e.g. -2 will only produce 2, 4, 6 etc. columns for row major layout, and 2, 4, 6 etc. rows for column major layout) 
        :type columns: int
        :param even_columns: All columns will have the same width 
        :type even_columns: bool
        :param even_rows: All rows will have the same height 
        :type even_rows: bool
        :param align: Align buttons to each other 
        :type align: bool
        :rtype: 'UILayout'
        :return:  Sub-layout to put items in 
        '''
        pass

    def box(self, ) -> 'UILayout':
        '''Sublayout (items placed in this sublayout are placed under each other in a column and are surrounded by a box) 

        :rtype: 'UILayout'
        :return:  Sub-layout to put items in 
        '''
        pass

    def split(self, factor: float = 0.0, align: bool = False) -> 'UILayout':
        '''split 

        :param factor: Percentage, Percentage of width to split at (leave unset for automatic calculation) 
        :type factor: float
        :param align: Align buttons to each other 
        :type align: bool
        :rtype: 'UILayout'
        :return:  Sub-layout to put items in 
        '''
        pass

    def menu_pie(self, ) -> 'UILayout':
        '''Sublayout. Items placed in this sublayout are placed in a radial fashion around the menu center) 

        :rtype: 'UILayout'
        :return:  Sub-layout to put items in 
        '''
        pass

    def prop(self,
             data: 'AnyType',
             property: str,
             text: str = "",
             text_ctxt: str = "",
             translate: bool = True,
             icon: typing.Union[str, int] = 'NONE',
             expand: bool = False,
             slider: bool = False,
             toggle: int = -1,
             icon_only: bool = False,
             event: bool = False,
             full_event: bool = False,
             emboss: bool = True,
             index: int = -1,
             icon_value: int = 0,
             invert_checkbox: bool = False):
        '''Item. Exposes an RNA item and places it into the layout 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        :param icon: Icon, Override automatic icon of the item 
        :type icon: typing.Union[str, int]
        :param expand: Expand button to show more detail 
        :type expand: bool
        :param slider: Use slider widget for numeric values 
        :type slider: bool
        :param toggle: Use toggle widget for boolean values, or a checkbox when disabled (the default is -1 which uses toggle only when an icon is displayed) 
        :type toggle: int
        :param icon_only: Draw only icons in buttons, no text 
        :type icon_only: bool
        :param event: Use button to input key events 
        :type event: bool
        :param full_event: Use button to input full events including modifiers 
        :type full_event: bool
        :param emboss: Draw the button itself, not just the icon/text 
        :type emboss: bool
        :param index: The index of this button, when set a single member of an array can be accessed, when set to -1 all array members are used 
        :type index: int
        :param icon_value: Icon Value, Override automatic icon of the item 
        :type icon_value: int
        :param invert_checkbox: Draw checkbox value inverted 
        :type invert_checkbox: bool
        '''
        pass

    def props_enum(self, data: 'AnyType', property: str):
        '''props_enum 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        '''
        pass

    def prop_menu_enum(self,
                       data: 'AnyType',
                       property: str,
                       text: str = "",
                       text_ctxt: str = "",
                       translate: bool = True,
                       icon: typing.Union[str, int] = 'NONE'):
        '''prop_menu_enum 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        :param icon: Icon, Override automatic icon of the item 
        :type icon: typing.Union[str, int]
        '''
        pass

    def prop_with_popover(self,
                          data: 'AnyType',
                          property: str,
                          text: str = "",
                          text_ctxt: str = "",
                          translate: bool = True,
                          icon: typing.Union[str, int] = 0,
                          icon_only: bool = False,
                          panel: str = ""):
        '''prop_with_popover 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        :param icon: Icon, Override automatic icon of the item 
        :type icon: typing.Union[str, int]
        :param icon_only: Draw only icons in tabs, no text 
        :type icon_only: bool
        :param panel: Identifier of the panel 
        :type panel: str
        '''
        pass

    def prop_with_menu(self,
                       data: 'AnyType',
                       property: str,
                       text: str = "",
                       text_ctxt: str = "",
                       translate: bool = True,
                       icon: typing.Union[str, int] = 0,
                       icon_only: bool = False,
                       menu: str = ""):
        '''prop_with_menu 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        :param icon: Icon, Override automatic icon of the item 
        :type icon: typing.Union[str, int]
        :param icon_only: Draw only icons in tabs, no text 
        :type icon_only: bool
        :param menu: Identifier of the menu 
        :type menu: str
        '''
        pass

    def prop_tabs_enum(self,
                       data: 'AnyType',
                       property: str,
                       icon_only: bool = False):
        '''prop_tabs_enum 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param icon_only: Draw only icons in tabs, no text 
        :type icon_only: bool
        '''
        pass

    def prop_enum(self,
                  data: 'AnyType',
                  property: str,
                  value: str,
                  text: str = "",
                  text_ctxt: str = "",
                  translate: bool = True,
                  icon: typing.Union[str, int] = 'NONE'):
        '''prop_enum 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param value: Enum property value 
        :type value: str
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        :param icon: Icon, Override automatic icon of the item 
        :type icon: typing.Union[str, int]
        '''
        pass

    def prop_search(self,
                    data: 'AnyType',
                    property: str,
                    search_data: 'AnyType',
                    search_property: str,
                    text: str = "",
                    text_ctxt: str = "",
                    translate: bool = True,
                    icon: typing.Union[str, int] = 'NONE'):
        '''prop_search 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param search_data: Data from which to take collection to search in 
        :type search_data: 'AnyType'
        :param search_property: Identifier of search collection property 
        :type search_property: str
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        :param icon: Icon, Override automatic icon of the item 
        :type icon: typing.Union[str, int]
        '''
        pass

    def operator(self,
                 operator: str,
                 text: str = "",
                 text_ctxt: str = "",
                 translate: bool = True,
                 icon: typing.Union[str, int] = 'NONE',
                 emboss: bool = True,
                 depress: bool = False,
                 icon_value: int = 0) -> 'OperatorProperties':
        '''Item. Places a button into the layout to call an Operator 

        :param operator: Identifier of the operator 
        :type operator: str
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        :param icon: Icon, Override automatic icon of the item 
        :type icon: typing.Union[str, int]
        :param emboss: Draw the button itself, not just the icon/text 
        :type emboss: bool
        :param depress: Draw pressed in 
        :type depress: bool
        :param icon_value: Icon Value, Override automatic icon of the item 
        :type icon_value: int
        :rtype: 'OperatorProperties'
        :return:  Operator properties to fill in 
        '''
        pass

    def operator_menu_hold(self,
                           operator: str,
                           text: str = "",
                           text_ctxt: str = "",
                           translate: bool = True,
                           icon: typing.Union[str, int] = 0,
                           emboss: bool = True,
                           depress: bool = False,
                           icon_value: int = 0,
                           menu: str = "") -> 'OperatorProperties':
        '''Item. Places a button into the layout to call an Operator 

        :param operator: Identifier of the operator 
        :type operator: str
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        :param icon: Icon, Override automatic icon of the item 
        :type icon: typing.Union[str, int]
        :param emboss: Draw the button itself, not just the icon/text 
        :type emboss: bool
        :param depress: Draw pressed in 
        :type depress: bool
        :param icon_value: Icon Value, Override automatic icon of the item 
        :type icon_value: int
        :param menu: Identifier of the menu 
        :type menu: str
        :rtype: 'OperatorProperties'
        :return:  Operator properties to fill in 
        '''
        pass

    def operator_enum(self, operator: str, property: str):
        '''operator_enum 

        :param operator: Identifier of the operator 
        :type operator: str
        :param property: Identifier of property in operator 
        :type property: str
        '''
        pass

    def operator_menu_enum(self,
                           operator: str,
                           property: str,
                           text: str = "",
                           text_ctxt: str = "",
                           translate: bool = True,
                           icon: typing.Union[str, int] = 'NONE'):
        '''operator_menu_enum 

        :param operator: Identifier of the operator 
        :type operator: str
        :param property: Identifier of property in operator 
        :type property: str
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        :param icon: Icon, Override automatic icon of the item 
        :type icon: typing.Union[str, int]
        '''
        pass

    def label(self,
              text: str = "",
              text_ctxt: str = "",
              translate: bool = True,
              icon: typing.Union[str, int] = 'NONE',
              icon_value: int = 0):
        '''Item. Displays text and/or icon in the layout 

        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        :param icon: Icon, Override automatic icon of the item 
        :type icon: typing.Union[str, int]
        :param icon_value: Icon Value, Override automatic icon of the item 
        :type icon_value: int
        '''
        pass

    def menu(self,
             menu: str,
             text: str = "",
             text_ctxt: str = "",
             translate: bool = True,
             icon: typing.Union[str, int] = 'NONE',
             icon_value: int = 0):
        '''menu 

        :param menu: Identifier of the menu 
        :type menu: str
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        :param icon: Icon, Override automatic icon of the item 
        :type icon: typing.Union[str, int]
        :param icon_value: Icon Value, Override automatic icon of the item 
        :type icon_value: int
        '''
        pass

    def menu_contents(self, menu: str):
        '''menu_contents 

        :param menu: Identifier of the menu 
        :type menu: str
        '''
        pass

    def popover(self,
                panel: str,
                text: str = "",
                text_ctxt: str = "",
                translate: bool = True,
                icon: typing.Union[str, int] = 'NONE',
                icon_value: int = 0):
        '''popover 

        :param panel: Identifier of the panel 
        :type panel: str
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        :param icon: Icon, Override automatic icon of the item 
        :type icon: typing.Union[str, int]
        :param icon_value: Icon Value, Override automatic icon of the item 
        :type icon_value: int
        '''
        pass

    def popover_group(self, space_type: typing.Union[str, int],
                      region_type: typing.Union[str, int], context: str,
                      category: str):
        '''popover_group 

        :param space_type: Space TypeEMPTY Empty.VIEW_3D 3D Viewport, Manipulate objects in a 3D environment.IMAGE_EDITOR UV/Image Editor, View and edit images and UV Maps.NODE_EDITOR Node Editor, Editor for node-based shading and compositing tools.SEQUENCE_EDITOR Video Sequencer, Video editing tools.CLIP_EDITOR Movie Clip Editor, Motion tracking tools.DOPESHEET_EDITOR Dope Sheet, Adjust timing of keyframes.GRAPH_EDITOR Graph Editor, Edit drivers and keyframe interpolation.NLA_EDITOR Nonlinear Animation, Combine and layer Actions.TEXT_EDITOR Text Editor, Edit scripts and in-file documentation.CONSOLE Python Console, Interactive programmatic console for advanced editing and script development.INFO Info, Log of operations, warnings and error messages.TOPBAR Top Bar, Global bar at the top of the screen for global per-window settings.STATUSBAR Status Bar, Global bar at the bottom of the screen for general status information.OUTLINER Outliner, Overview of scene graph and all available data-blocks.PROPERTIES Properties, Edit properties of active object and related data-blocks.FILE_BROWSER File Browser, Browse for files and assets.PREFERENCES Preferences, Edit persistent configuration settings. 
        :type space_type: typing.Union[str, int]
        :param region_type: Region Type 
        :type region_type: typing.Union[str, int]
        :param context: panel type context 
        :type context: str
        :param category: panel type category 
        :type category: str
        '''
        pass

    def separator(self, factor: float = 1.0):
        '''Item. Inserts empty space into the layout between items 

        :param factor: Percentage, Percentage of width to space (leave unset for default space) 
        :type factor: float
        '''
        pass

    def separator_spacer(self, ):
        '''Item. Inserts horizontal spacing empty space into the layout between items 

        '''
        pass

    def context_pointer_set(self, name: str, data: 'AnyType'):
        '''context_pointer_set 

        :param name: Name, Name of entry in the context 
        :type name: str
        :param data: Pointer to put in context 
        :type data: 'AnyType'
        '''
        pass

    def template_header(self, ):
        '''Inserts common Space header UI (editor type selector) 

        '''
        pass

    def template_ID(self,
                    data: 'AnyType',
                    property: str,
                    new: str = "",
                    open: str = "",
                    unlink: str = "",
                    filter: typing.Union[str, int] = 'ALL',
                    live_icon: bool = False,
                    text: str = "",
                    text_ctxt: str = "",
                    translate: bool = True):
        '''template_ID 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param new: Operator identifier to create a new ID block 
        :type new: str
        :param open: Operator identifier to open a file for creating a new ID block 
        :type open: str
        :param unlink: Operator identifier to unlink the ID block 
        :type unlink: str
        :param filter: Optionally limit the items which can be selected 
        :type filter: typing.Union[str, int]
        :param live_icon: Show preview instead of fixed icon 
        :type live_icon: bool
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        '''
        pass

    def template_ID_preview(self,
                            data: 'AnyType',
                            property: str,
                            new: str = "",
                            open: str = "",
                            unlink: str = "",
                            rows: int = 0,
                            cols: int = 0,
                            filter: typing.Union[str, int] = 'ALL',
                            hide_buttons: bool = False):
        '''template_ID_preview 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param new: Operator identifier to create a new ID block 
        :type new: str
        :param open: Operator identifier to open a file for creating a new ID block 
        :type open: str
        :param unlink: Operator identifier to unlink the ID block 
        :type unlink: str
        :param rows: Number of thumbnail preview rows to display 
        :type rows: int
        :param cols: Number of thumbnail preview columns to display 
        :type cols: int
        :param filter: Optionally limit the items which can be selected 
        :type filter: typing.Union[str, int]
        :param hide_buttons: Show only list, no buttons 
        :type hide_buttons: bool
        '''
        pass

    def template_any_ID(self,
                        data: 'AnyType',
                        property: str,
                        type_property: str,
                        text: str = "",
                        text_ctxt: str = "",
                        translate: bool = True):
        '''template_any_ID 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param type_property: Identifier of property in data giving the type of the ID-blocks to use 
        :type type_property: str
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        '''
        pass

    def template_ID_tabs(self,
                         data: 'AnyType',
                         property: str,
                         new: str = "",
                         menu: str = "",
                         filter: typing.Union[str, int] = 'ALL'):
        '''template_ID_tabs 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param new: Operator identifier to create a new ID block 
        :type new: str
        :param menu: Context menu identifier 
        :type menu: str
        :param filter: Optionally limit the items which can be selected 
        :type filter: typing.Union[str, int]
        '''
        pass

    def template_search(self,
                        data: 'AnyType',
                        property: str,
                        search_data: 'AnyType',
                        search_property: str,
                        new: str = "",
                        unlink: str = ""):
        '''template_search 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param search_data: Data from which to take collection to search in 
        :type search_data: 'AnyType'
        :param search_property: Identifier of search collection property 
        :type search_property: str
        :param new: Operator identifier to create a new item for the collection 
        :type new: str
        :param unlink: Operator identifier to unlink or delete the active item from the collection 
        :type unlink: str
        '''
        pass

    def template_search_preview(self,
                                data: 'AnyType',
                                property: str,
                                search_data: 'AnyType',
                                search_property: str,
                                new: str = "",
                                unlink: str = "",
                                rows: int = 0,
                                cols: int = 0):
        '''template_search_preview 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param search_data: Data from which to take collection to search in 
        :type search_data: 'AnyType'
        :param search_property: Identifier of search collection property 
        :type search_property: str
        :param new: Operator identifier to create a new item for the collection 
        :type new: str
        :param unlink: Operator identifier to unlink or delete the active item from the collection 
        :type unlink: str
        :param rows: Number of thumbnail preview rows to display 
        :type rows: int
        :param cols: Number of thumbnail preview columns to display 
        :type cols: int
        '''
        pass

    def template_path_builder(self,
                              data: 'AnyType',
                              property: str,
                              root: 'ID',
                              text: str = "",
                              text_ctxt: str = "",
                              translate: bool = True):
        '''template_path_builder 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param root: ID-block from which path is evaluated from 
        :type root: 'ID'
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        '''
        pass

    def template_modifier(self, data: 'Modifier') -> 'UILayout':
        '''Generates the UI layout for modifiers 

        :param data: Modifier data 
        :type data: 'Modifier'
        :rtype: 'UILayout'
        :return:  Sub-layout to put items in 
        '''
        pass

    def template_greasepencil_modifier(self,
                                       data: 'GpencilModifier') -> 'UILayout':
        '''Generates the UI layout for grease pencil modifiers 

        :param data: Modifier data 
        :type data: 'GpencilModifier'
        :rtype: 'UILayout'
        :return:  Sub-layout to put items in 
        '''
        pass

    def template_shaderfx(self, data: 'ShaderFx') -> 'UILayout':
        '''Generates the UI layout for shader effect 

        :param data: Shader data 
        :type data: 'ShaderFx'
        :rtype: 'UILayout'
        :return:  Sub-layout to put items in 
        '''
        pass

    def template_greasepencil_color(self,
                                    data: 'AnyType',
                                    property: str,
                                    rows: int = 0,
                                    cols: int = 0,
                                    scale: float = 1.0,
                                    filter: typing.Union[str, int] = 'ALL'):
        '''template_greasepencil_color 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param rows: Number of thumbnail preview rows to display 
        :type rows: int
        :param cols: Number of thumbnail preview columns to display 
        :type cols: int
        :param scale: Scale of the image thumbnails 
        :type scale: float
        :param filter: Optionally limit the items which can be selected 
        :type filter: typing.Union[str, int]
        '''
        pass

    def template_constraint(self, data: 'Constraint') -> 'UILayout':
        '''Generates the UI layout for constraints 

        :param data: Constraint data 
        :type data: 'Constraint'
        :rtype: 'UILayout'
        :return:  Sub-layout to put items in 
        '''
        pass

    def template_preview(self,
                         id: 'ID',
                         show_buttons: bool = True,
                         parent: 'ID' = None,
                         slot: 'TextureSlot' = None,
                         preview_id: str = ""):
        '''Item. A preview window for materials, textures, lights or worlds 

        :param id: ID data-block 
        :type id: 'ID'
        :param show_buttons: Show preview buttons? 
        :type show_buttons: bool
        :param parent: ID data-block 
        :type parent: 'ID'
        :param slot: Texture slot 
        :type slot: 'TextureSlot'
        :param preview_id: Identifier of this preview widget, if not set the ID type will be used (i.e. all previews of materials without explicit ID will have the same size…) 
        :type preview_id: str
        '''
        pass

    def template_curve_mapping(self,
                               data: 'AnyType',
                               property: str,
                               type: typing.Union[str, int] = 'NONE',
                               levels: bool = False,
                               brush: bool = False,
                               use_negative_slope: bool = False,
                               show_tone: bool = False):
        '''Item. A curve mapping widget used for e.g falloff curves for lights 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param type: Type, Type of curves to display 
        :type type: typing.Union[str, int]
        :param levels: Show black/white levels 
        :type levels: bool
        :param brush: Show brush options 
        :type brush: bool
        :param use_negative_slope: Use a negative slope by default 
        :type use_negative_slope: bool
        :param show_tone: Show tone options 
        :type show_tone: bool
        '''
        pass

    def template_curveprofile(self, data: 'AnyType', property: str):
        '''A profile path editor used for custom profiles 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        '''
        pass

    def template_color_ramp(self,
                            data: 'AnyType',
                            property: str,
                            expand: bool = False):
        '''Item. A color ramp widget 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param expand: Expand button to show more detail 
        :type expand: bool
        '''
        pass

    def template_icon(self, icon_value: int, scale: float = 1.0):
        '''Display a large icon 

        :param icon_value: Icon to display 
        :type icon_value: int
        :param scale: Scale, Scale the icon size (by the button size) 
        :type scale: float
        '''
        pass

    def template_icon_view(self,
                           data: 'AnyType',
                           property: str,
                           show_labels: bool = False,
                           scale: float = 6.0,
                           scale_popup: float = 5.0):
        '''Enum. Large widget showing Icon previews 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param show_labels: Show enum label in preview buttons 
        :type show_labels: bool
        :param scale: UI Units, Scale the button icon size (by the button size) 
        :type scale: float
        :param scale_popup: Scale, Scale the popup icon size (by the button size) 
        :type scale_popup: float
        '''
        pass

    def template_histogram(self, data: 'AnyType', property: str):
        '''Item. A histogramm widget to analyze imaga data 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        '''
        pass

    def template_waveform(self, data: 'AnyType', property: str):
        '''Item. A waveform widget to analyze imaga data 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        '''
        pass

    def template_vectorscope(self, data: 'AnyType', property: str):
        '''Item. A vectorscope widget to analyze imaga data 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        '''
        pass

    def template_layers(self, data: 'AnyType', property: str,
                        used_layers_data: 'AnyType', used_layers_property: str,
                        active_layer: int):
        '''template_layers 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param used_layers_data: Data from which to take property 
        :type used_layers_data: 'AnyType'
        :param used_layers_property: Identifier of property in data 
        :type used_layers_property: str
        :param active_layer: Active Layer 
        :type active_layer: int
        '''
        pass

    def template_color_picker(self,
                              data: 'AnyType',
                              property: str,
                              value_slider: bool = False,
                              lock: bool = False,
                              lock_luminosity: bool = False,
                              cubic: bool = False):
        '''Item. A color wheel widget to pick colors 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param value_slider: Display the value slider to the right of the color wheel 
        :type value_slider: bool
        :param lock: Lock the color wheel display to value 1.0 regardless of actual color 
        :type lock: bool
        :param lock_luminosity: Keep the color at its original vector length 
        :type lock_luminosity: bool
        :param cubic: Cubic saturation for picking values close to white 
        :type cubic: bool
        '''
        pass

    def template_palette(self,
                         data: 'AnyType',
                         property: str,
                         color: bool = False):
        '''Item. A palette used to pick colors 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param color: Display the colors as colors or values 
        :type color: bool
        '''
        pass

    def template_image_layers(self, image, image_user):
        '''template_image_layers 

        '''
        pass

    def template_image(self,
                       data: 'AnyType',
                       property: str,
                       image_user,
                       compact: bool = False,
                       multiview: bool = False):
        '''Item(s). User interface for selecting images and their source paths 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param compact: Use more compact layout 
        :type compact: bool
        :param multiview: Expose Multi-View options 
        :type multiview: bool
        '''
        pass

    def template_image_settings(self,
                                image_settings,
                                color_management: bool = False):
        '''User interface for setting image format options 

        :param color_management: Show color management settings 
        :type color_management: bool
        '''
        pass

    def template_image_stereo_3d(self, stereo_3d_format):
        '''User interface for setting image stereo 3d options 

        '''
        pass

    def template_image_views(self, image_settings):
        '''User interface for setting image views output options 

        '''
        pass

    def template_movieclip(self,
                           data: 'AnyType',
                           property: str,
                           compact: bool = False):
        '''Item(s). User interface for selecting movie clips and their source paths 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param compact: Use more compact layout 
        :type compact: bool
        '''
        pass

    def template_track(self, data: 'AnyType', property: str):
        '''Item. A movie-track widget to preview tracking image. 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        '''
        pass

    def template_marker(self,
                        data: 'AnyType',
                        property: str,
                        clip_user,
                        track,
                        compact: bool = False):
        '''Item. A widget to control single marker settings. 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        :param compact: Use more compact layout 
        :type compact: bool
        '''
        pass

    def template_movieclip_information(self, data: 'AnyType', property: str,
                                       clip_user):
        '''Item. Movie clip information data. 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        '''
        pass

    def template_list(self,
                      listtype_name: str,
                      list_id: str = "",
                      dataptr: 'AnyType' = "",
                      propname: str = "",
                      active_dataptr: 'AnyType' = "",
                      active_propname: str = 0,
                      item_dyntip_propname: str = "",
                      rows: int = 5,
                      maxrows: int = 5,
                      type: typing.Union[str, int] = 'DEFAULT',
                      columns: int = 9):
        '''Item. A list widget to display data, e.g. vertexgroups. 

        :param listtype_name: Identifier of the list type to use 
        :type listtype_name: str
        :param list_id: Identifier of this list widget (mandatory when using default “UI_UL_list” class). If this not an empty string, the uilist gets a custom ID, otherwise it takes the name of the class used to define the uilist (for example, if the class name is “OBJECT_UL_vgroups”, and list_id is not set by the script, then bl_idname = “OBJECT_UL_vgroups”) 
        :type list_id: str
        :param dataptr: Data from which to take the Collection property 
        :type dataptr: 'AnyType'
        :param propname: Identifier of the Collection property in data 
        :type propname: str
        :param active_dataptr: Data from which to take the integer property, index of the active item 
        :type active_dataptr: 'AnyType'
        :param active_propname: Identifier of the integer property in active_data, index of the active item 
        :type active_propname: str
        :param item_dyntip_propname: Identifier of a string property in items, to use as tooltip content 
        :type item_dyntip_propname: str
        :param rows: Default and minimum number of rows to display 
        :type rows: int
        :param maxrows: Default maximum number of rows to display 
        :type maxrows: int
        :param type: Type, Type of layout to useDEFAULT Default Layout, Use the default, multi-rows layout.COMPACT Compact Layout, Use the compact, single-row layout.GRID Grid Layout, Use the grid-based layout. 
        :type type: typing.Union[str, int]
        :param columns: Number of items to display per row, for GRID layout 
        :type columns: int
        :param sort_reverse: Display items in reverse order by default 
        :type sort_reverse: bool
        :param sort_lock: Lock display order to default value 
        :type sort_lock: bool
        '''
        pass

    def template_running_jobs(self, ):
        '''template_running_jobs 

        '''
        pass

    def template_operator_search(self, ):
        '''template_operator_search 

        '''
        pass

    def template_header_3D_mode(self, ):
        '''

        '''
        pass

    def template_edit_mode_selection(self, ):
        '''Inserts common 3DView Edit modes header UI (selector for selection mode) 

        '''
        pass

    def template_reports_banner(self, ):
        '''template_reports_banner 

        '''
        pass

    def template_input_status(self, ):
        '''template_input_status 

        '''
        pass

    def template_node_link(self, ntree, node, socket):
        '''template_node_link 

        '''
        pass

    def template_node_view(self, ntree, node, socket):
        '''template_node_view 

        '''
        pass

    def template_texture_user(self, ):
        '''template_texture_user 

        '''
        pass

    def template_keymap_item_properties(self, item):
        '''template_keymap_item_properties 

        '''
        pass

    def template_component_menu(self, data: 'AnyType', property: str, name=""):
        '''Item. Display expanded property in a popup menu 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        '''
        pass

    def template_colorspace_settings(self, data: 'AnyType', property: str):
        '''Item. A widget to control input color space settings. 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        '''
        pass

    def template_colormanaged_view_settings(self, data: 'AnyType',
                                            property: str):
        '''Item. A widget to control color managed view settings settings. 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        '''
        pass

    def template_node_socket(self,
                             color: typing.List[float] = (0.0, 0.0, 0.0, 1.0)):
        '''Node Socket Icon 

        :param color: Color 
        :type color: typing.List[float]
        '''
        pass

    def template_cache_file(self, data: 'AnyType', property: str):
        '''Item(s). User interface for selecting cache files and their source paths 

        :param data: Data from which to take property 
        :type data: 'AnyType'
        :param property: Identifier of property in data 
        :type property: str
        '''
        pass

    def template_recent_files(self, rows: int = 5) -> int:
        '''Show list of recently saved .blend files 

        :param rows: Maximum number of items to show 
        :type rows: int
        :rtype: int
        :return:  Number of items drawn 
        '''
        pass

    def template_file_select_path(self, params):
        '''Item. A text button to set the active file browser path. 

        '''
        pass

    def template_event_from_keymap_item(self,
                                        item: 'KeyMapItem',
                                        text: str = "",
                                        text_ctxt: str = "",
                                        translate: bool = True):
        '''Display keymap item as icons/text 

        :param item: Item 
        :type item: 'KeyMapItem'
        :param text: Override automatic text of the item 
        :type text: str
        :param text_ctxt: Override automatic translation context of the given text 
        :type text_ctxt: str
        :param translate: Translate the given text, when UI translation is enabled 
        :type translate: bool
        '''
        pass


class UIList(bpy_struct):
    '''UI list containing the elements of a collection '''

    bitflag_filter_item: int = None
    '''The value of the reserved bitflag ‘FILTER_ITEM’ (in filter_flags values) 

    :type: int
    '''

    bl_idname: str = None
    '''If this is set, the uilist gets a custom ID, otherwise it takes the name of the class used to define the uilist (for example, if the class name is “OBJECT_UL_vgroups”, and bl_idname is not set by the script, then bl_idname = “OBJECT_UL_vgroups”) 

    :type: str
    '''

    filter_name: str = None
    '''Only show items matching this name (use ‘*’ as wildcard) 

    :type: str
    '''

    layout_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    use_filter_invert: bool = None
    '''Invert filtering (show hidden items, and vice-versa) 

    :type: bool
    '''

    use_filter_show: bool = None
    '''Show filtering options 

    :type: bool
    '''

    use_filter_sort_alpha: bool = None
    '''Sort items by their name 

    :type: bool
    '''

    use_filter_sort_lock: bool = None
    '''Lock the order of shown items (user cannot change it) 

    :type: bool
    '''

    use_filter_sort_reverse: bool = None
    '''Reverse the order of shown items 

    :type: bool
    '''

    def draw_item(self,
                  context,
                  layout: 'UILayout',
                  data: 'AnyType',
                  item: 'AnyType',
                  icon: int,
                  active_data: 'AnyType',
                  active_property: str,
                  index: int = 0,
                  flt_flag: int = 0):
        '''Draw an item in the list (NOTE: when you define your own draw_item function, you may want to check given ‘item’ is of the right type…) 

        :param layout: Layout to draw the item 
        :type layout: 'UILayout'
        :param data: Data from which to take Collection property 
        :type data: 'AnyType'
        :param item: Item of the collection property 
        :type item: 'AnyType'
        :param icon: Icon of the item in the collection 
        :type icon: int
        :param active_data: Data from which to take property for the active element 
        :type active_data: 'AnyType'
        :param active_property: Identifier of property in active_data, for the active element 
        :type active_property: str
        :param index: Index of the item in the collection 
        :type index: int
        :param flt_flag: The filter-flag result for this item 
        :type flt_flag: int
        '''
        pass

    def draw_filter(self, context, layout: 'UILayout'):
        '''Draw filtering options 

        :param layout: Layout to draw the item 
        :type layout: 'UILayout'
        '''
        pass

    def filter_items(self, context, data: 'AnyType', property: str):
        '''Filter and/or re-order items of the collection (output filter results in filter_flags, and reorder results in filter_neworder arrays) 

        :param data: Data from which to take Collection property 
        :type data: 'AnyType'
        :param property: Identifier of property in data, for the collection 
        :type property: str
        '''
        pass


class UIPieMenu(bpy_struct):
    layout: 'UILayout' = None
    '''

    :type: 'UILayout'
    '''


class UIPopover(bpy_struct):
    layout: 'UILayout' = None
    '''

    :type: 'UILayout'
    '''


class UIPopupMenu(bpy_struct):
    layout: 'UILayout' = None
    '''

    :type: 'UILayout'
    '''


class UVLoopLayers(bpy_struct):
    '''Collection of uv loop layers '''

    active: 'MeshUVLoopLayer' = None
    '''Active UV loop layer 

    :type: 'MeshUVLoopLayer'
    '''

    active_index: int = None
    '''Active UV loop layer index 

    :type: int
    '''

    def new(self, name: str = "UVMap",
            do_init: bool = True) -> 'MeshUVLoopLayer':
        '''Add a UV map layer to Mesh 

        :param name: UV map name 
        :type name: str
        :param do_init: Whether new layer’s data should be initialized by copying current active one, or if none is active, with a default UVmap 
        :type do_init: bool
        :rtype: 'MeshUVLoopLayer'
        :return:  The newly created layer 
        '''
        pass

    def remove(self, layer: 'MeshUVLoopLayer'):
        '''Remove a vertex color layer 

        :param layer: The layer to remove 
        :type layer: 'MeshUVLoopLayer'
        '''
        pass


class UVProjector(bpy_struct):
    '''UV projector used by the UV project modifier '''

    object: 'Object' = None
    '''Object to use as projector transform 

    :type: 'Object'
    '''


class UnifiedPaintSettings(bpy_struct):
    '''Overrides for some of the active brush’s settings '''

    color: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    secondary_color: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    size: int = None
    '''Radius of the brush 

    :type: int
    '''

    strength: float = None
    '''How powerful the effect of the brush is when applied 

    :type: float
    '''

    unprojected_radius: float = None
    '''Radius of brush in Blender units 

    :type: float
    '''

    use_locked_size: typing.Union[str, int] = None
    '''Measure brush size relative to the view or the scene 

    :type: typing.Union[str, int]
    '''

    use_unified_color: bool = None
    '''Instead of per-brush color, the color is shared across brushes 

    :type: bool
    '''

    use_unified_size: bool = None
    '''Instead of per-brush radius, the radius is shared across brushes 

    :type: bool
    '''

    use_unified_strength: bool = None
    '''Instead of per-brush strength, the strength is shared across brushes 

    :type: bool
    '''

    use_unified_weight: bool = None
    '''Instead of per-brush weight, the weight is shared across brushes 

    :type: bool
    '''

    weight: float = None
    '''Weight to assign in vertex groups 

    :type: float
    '''


class UnitSettings(bpy_struct):
    length_unit: typing.Union[str, int] = None
    '''Unit that will be used to display length values 

    :type: typing.Union[str, int]
    '''

    mass_unit: typing.Union[str, int] = None
    '''Unit that will be used to display mass values 

    :type: typing.Union[str, int]
    '''

    scale_length: float = None
    '''Scale to use when converting between blender units and dimensions. When working at microscopic or astronomical scale, a small or large unit scale respectively can be used to avoid numerical precision problems 

    :type: float
    '''

    system: typing.Union[str, int] = None
    '''The unit system to use for user interface controls 

    :type: typing.Union[str, int]
    '''

    system_rotation: typing.Union[str, int] = None
    '''Unit to use for displaying/editing rotation values 

    :type: typing.Union[str, int]
    '''

    time_unit: typing.Union[str, int] = None
    '''Unit that will be used to display time values 

    :type: typing.Union[str, int]
    '''

    use_separate: bool = None
    '''Display units in pairs (e.g. 1m 0cm) 

    :type: bool
    '''


class UnknownType(bpy_struct):
    '''Stub RNA type used for pointers to unknown or internal data '''

    pass


class UserSolidLight(bpy_struct):
    '''Light used for Studio lighting in solid draw mode '''

    diffuse_color: typing.List[float] = None
    '''Color of the light’s diffuse highlight 

    :type: typing.List[float]
    '''

    direction: typing.List[float] = None
    '''Direction that the light is shining 

    :type: typing.List[float]
    '''

    smooth: float = None
    '''Smooth the lighting from this light 

    :type: float
    '''

    specular_color: typing.List[float] = None
    '''Color of the light’s specular highlight 

    :type: typing.List[float]
    '''

    use: bool = None
    '''Enable this light in solid draw mode 

    :type: bool
    '''


class VertexFloatProperties(bpy_struct):
    '''Collection of float properties '''

    def new(self, name: str = "FloatProp") -> 'MeshVertexFloatPropertyLayer':
        '''Add a float property layer to Mesh 

        :param name: Float property name 
        :type name: str
        :rtype: 'MeshVertexFloatPropertyLayer'
        :return:  The newly created layer 
        '''
        pass


class VertexGroup(bpy_struct):
    '''Group of vertices, used for armature deform and other purposes '''

    index: int = None
    '''Index number of the vertex group 

    :type: int
    '''

    lock_weight: bool = None
    '''Maintain the relative weights for the group 

    :type: bool
    '''

    name: str = None
    '''Vertex group name 

    :type: str
    '''

    def add(self, index: typing.List[int], weight: float,
            type: typing.Union[str, int]):
        '''Add vertices to the group 

        :param index: Index List 
        :type index: typing.List[int]
        :param weight: Vertex weight 
        :type weight: float
        :param type: Vertex assign modeREPLACE Replace, Replace.ADD Add, Add.SUBTRACT Subtract, Subtract. 
        :type type: typing.Union[str, int]
        '''
        pass

    def remove(self, index: typing.List[int]):
        '''Remove a vertex from the group 

        :param index: Index List 
        :type index: typing.List[int]
        '''
        pass

    def weight(self, index: int) -> float:
        '''Get a vertex weight from the group 

        :param index: Index, The index of the vertex 
        :type index: int
        :rtype: float
        :return:  Vertex weight 
        '''
        pass


class VertexGroupElement(bpy_struct):
    '''Weight value of a vertex in a vertex group '''

    group: int = None
    '''

    :type: int
    '''

    weight: float = None
    '''Vertex Weight 

    :type: float
    '''


class VertexGroups(bpy_struct):
    '''Collection of vertex groups '''

    active: 'VertexGroup' = None
    '''Vertex groups of the object 

    :type: 'VertexGroup'
    '''

    active_index: int = None
    '''Active index in vertex group array 

    :type: int
    '''

    def new(self, name: str = "Group") -> 'VertexGroup':
        '''Add vertex group to object 

        :param name: Vertex group name 
        :type name: str
        :rtype: 'VertexGroup'
        :return:  New vertex group 
        '''
        pass

    def remove(self, group: 'VertexGroup'):
        '''Delete vertex group from object 

        :param group: Vertex group to remove 
        :type group: 'VertexGroup'
        '''
        pass

    def clear(self, ):
        '''Delete all vertex groups from object 

        '''
        pass


class VertexIntProperties(bpy_struct):
    '''Collection of int properties '''

    def new(self, name: str = "IntProp") -> 'MeshVertexIntPropertyLayer':
        '''Add a integer property layer to Mesh 

        :param name: Int property name 
        :type name: str
        :rtype: 'MeshVertexIntPropertyLayer'
        :return:  The newly created layer 
        '''
        pass


class VertexStringProperties(bpy_struct):
    '''Collection of string properties '''

    def new(self, name: str = "StringProp") -> 'MeshVertexStringPropertyLayer':
        '''Add a string property layer to Mesh 

        :param name: String property name 
        :type name: str
        :rtype: 'MeshVertexStringPropertyLayer'
        :return:  The newly created layer 
        '''
        pass


class View2D(bpy_struct):
    '''Scroll and zoom for a 2D region '''

    def region_to_view(self, x: float, y: float) -> typing.List[float]:
        '''Transform region coordinates to 2D view 

        :param x: x, Region x coordinate 
        :type x: float
        :param y: y, Region y coordinate 
        :type y: float
        :rtype: typing.List[float]
        :return:  Result, View coordinates 
        '''
        pass

    def view_to_region(self, x: float, y: float,
                       clip: bool = True) -> typing.List[int]:
        '''Transform 2D view coordinates to region 

        :param x: x, 2D View x coordinate 
        :type x: float
        :param y: y, 2D View y coordinate 
        :type y: float
        :param clip: Clip, Clip coordinates to the visible region 
        :type clip: bool
        :rtype: typing.List[int]
        :return:  Result, Region coordinates 
        '''
        pass


class View3DCursor(bpy_struct):
    location: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    matrix: typing.List[float] = None
    '''Matrix combining loc/rot of the cursor 

    :type: typing.List[float]
    '''

    rotation_axis_angle: typing.List[float] = None
    '''Angle of Rotation for Axis-Angle rotation representation 

    :type: typing.List[float]
    '''

    rotation_euler: typing.List[float] = None
    '''3D rotation 

    :type: typing.List[float]
    '''

    rotation_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    rotation_quaternion: typing.List[float] = None
    '''Rotation in quaternions (keep normalized) 

    :type: typing.List[float]
    '''


class View3DOverlay(bpy_struct):
    '''Settings for display of overlays in the 3D viewport '''

    backwire_opacity: float = None
    '''Opacity when rendering transparent wires 

    :type: float
    '''

    gpencil_fade_layer: float = None
    '''Fade layer opacity for Grease Pencil layers except the active one 

    :type: float
    '''

    gpencil_grid_opacity: float = None
    '''Canvas grid opacity 

    :type: float
    '''

    gpencil_paper_opacity: float = None
    '''Fade factor 

    :type: float
    '''

    grid_lines: int = None
    '''Number of grid lines to display in perspective view 

    :type: int
    '''

    grid_scale: float = None
    '''Distance between 3D View grid lines 

    :type: float
    '''

    grid_scale_unit: float = None
    '''Grid cell size scaled by scene unit system settings 

    :type: float
    '''

    grid_subdivisions: int = None
    '''Number of subdivisions between grid lines 

    :type: int
    '''

    normals_length: float = None
    '''Display size for normals in the 3D view 

    :type: float
    '''

    sculpt_mode_mask_opacity: float = None
    '''

    :type: float
    '''

    show_annotation: bool = None
    '''Show annotations for this view 

    :type: bool
    '''

    show_axis_x: bool = None
    '''Show the X axis line 

    :type: bool
    '''

    show_axis_y: bool = None
    '''Show the Y axis line 

    :type: bool
    '''

    show_axis_z: bool = None
    '''Show the Z axis line 

    :type: bool
    '''

    show_bones: bool = None
    '''Display bones (disable to show motion paths only) 

    :type: bool
    '''

    show_cursor: bool = None
    '''Display 3D Cursor Overlay 

    :type: bool
    '''

    show_curve_handles: bool = None
    '''Display Bezier handles in editmode 

    :type: bool
    '''

    show_curve_normals: bool = None
    '''Display 3D curve normals in editmode 

    :type: bool
    '''

    show_edge_bevel_weight: bool = None
    '''Display weights created for the Bevel modifier 

    :type: bool
    '''

    show_edge_crease: bool = None
    '''Display creases created for Subdivision Surface modifier 

    :type: bool
    '''

    show_edge_seams: bool = None
    '''Display UV unwrapping seams 

    :type: bool
    '''

    show_edge_sharp: bool = None
    '''Display sharp edges, used with the Edge Split modifier 

    :type: bool
    '''

    show_edges: bool = None
    '''Highlight selected edges 

    :type: bool
    '''

    show_extra_edge_angle: bool = None
    '''Display selected edge angle, using global values when set in the transform panel 

    :type: bool
    '''

    show_extra_edge_length: bool = None
    '''Display selected edge lengths, using global values when set in the transform panel 

    :type: bool
    '''

    show_extra_face_angle: bool = None
    '''Display the angles in the selected edges, using global values when set in the transform panel 

    :type: bool
    '''

    show_extra_face_area: bool = None
    '''Display the area of selected faces, using global values when set in the transform panel 

    :type: bool
    '''

    show_extra_indices: bool = None
    '''Display the index numbers of selected vertices, edges, and faces 

    :type: bool
    '''

    show_extras: bool = None
    '''Object details, including empty wire, cameras and other visual guides 

    :type: bool
    '''

    show_face_center: bool = None
    '''Display face center 

    :type: bool
    '''

    show_face_normals: bool = None
    '''Display face normals as lines 

    :type: bool
    '''

    show_face_orientation: bool = None
    '''Show the Face Orientation Overlay 

    :type: bool
    '''

    show_faces: bool = None
    '''Highlight selected faces 

    :type: bool
    '''

    show_floor: bool = None
    '''Show the ground plane grid 

    :type: bool
    '''

    show_freestyle_edge_marks: bool = None
    '''Display Freestyle edge marks, used with the Freestyle renderer 

    :type: bool
    '''

    show_freestyle_face_marks: bool = None
    '''Display Freestyle face marks, used with the Freestyle renderer 

    :type: bool
    '''

    show_look_dev: bool = None
    '''Show HDRI preview spheres 

    :type: bool
    '''

    show_motion_paths: bool = None
    '''Show the Motion Paths Overlay 

    :type: bool
    '''

    show_object_origins: bool = None
    '''Show object center dots 

    :type: bool
    '''

    show_object_origins_all: bool = None
    '''Show the object origin center dot for all (selected and unselected) objects 

    :type: bool
    '''

    show_occlude_wire: bool = None
    '''Use hidden wireframe display 

    :type: bool
    '''

    show_onion_skins: bool = None
    '''Show the Onion Skinning Overlay 

    :type: bool
    '''

    show_ortho_grid: bool = None
    '''Show grid in othographic side view 

    :type: bool
    '''

    show_outline_selected: bool = None
    '''Show an outline highlight around selected objects 

    :type: bool
    '''

    show_overlays: bool = None
    '''Display overlays like gizmos and outlines 

    :type: bool
    '''

    show_paint_wire: bool = None
    '''Use wireframe display in painting modes 

    :type: bool
    '''

    show_relationship_lines: bool = None
    '''Show dashed lines indicating parent or constraint relationships 

    :type: bool
    '''

    show_split_normals: bool = None
    '''Display vertex-per-face normals as lines 

    :type: bool
    '''

    show_statvis: bool = None
    '''Display statistical information about the mesh 

    :type: bool
    '''

    show_text: bool = None
    '''Display overlay text 

    :type: bool
    '''

    show_vertex_normals: bool = None
    '''Display vertex normals as lines 

    :type: bool
    '''

    show_weight: bool = None
    '''Display weights in editmode 

    :type: bool
    '''

    show_wireframes: bool = None
    '''Show face edges wires 

    :type: bool
    '''

    show_wpaint_contours: bool = None
    '''Show contour lines formed by points with the same interpolated weight 

    :type: bool
    '''

    show_xray_bone: bool = None
    '''Show the bone selection overlay 

    :type: bool
    '''

    texture_paint_mode_opacity: float = None
    '''Opacity of the texture paint mode stencil mask overlay 

    :type: float
    '''

    use_gpencil_edit_lines: bool = None
    '''Show edit lines when editing strokes 

    :type: bool
    '''

    use_gpencil_fade_layers: bool = None
    '''Toggle fading of Grease Pencil layers except the active one 

    :type: bool
    '''

    use_gpencil_fade_objects: bool = None
    '''Fade Grease Pencil Objects, except the active one 

    :type: bool
    '''

    use_gpencil_grid: bool = None
    '''Display a grid over grease pencil paper 

    :type: bool
    '''

    use_gpencil_multiedit_line_only: bool = None
    '''Only show edit lines for additional frames 

    :type: bool
    '''

    use_gpencil_onion_skin: bool = None
    '''Show ghosts of the keyframes before and after the current frame 

    :type: bool
    '''

    use_gpencil_paper: bool = None
    '''Fade all viewport objects with a full color layer to improve visibility 

    :type: bool
    '''

    vertex_opacity: float = None
    '''Opacity for edit vertices 

    :type: float
    '''

    vertex_paint_mode_opacity: float = None
    '''Opacity of the texture paint mode stencil mask overlay 

    :type: float
    '''

    weight_paint_mode_opacity: float = None
    '''Opacity of the weight paint mode overlay 

    :type: float
    '''

    wireframe_threshold: float = None
    '''Adjust the angle threshold for displaying edges (1.0 for all) 

    :type: float
    '''

    xray_alpha_bone: float = None
    '''Opacity to use for bone selection 

    :type: float
    '''


class View3DShading(bpy_struct):
    '''Settings for shading in the 3D viewport '''

    background_color: typing.List[float] = None
    '''Color for custom background color 

    :type: typing.List[float]
    '''

    background_type: typing.Union[str, int] = None
    '''Way to draw the background 

    :type: typing.Union[str, int]
    '''

    cavity_ridge_factor: float = None
    '''Factor for the cavity ridges 

    :type: float
    '''

    cavity_type: typing.Union[str, int] = None
    '''Way to draw the cavity shading 

    :type: typing.Union[str, int]
    '''

    cavity_valley_factor: float = None
    '''Factor for the cavity valleys 

    :type: float
    '''

    color_type: typing.Union[str, int] = None
    '''Color Type 

    :type: typing.Union[str, int]
    '''

    curvature_ridge_factor: float = None
    '''Factor for the curvature ridges 

    :type: float
    '''

    curvature_valley_factor: float = None
    '''Factor for the curvature valleys 

    :type: float
    '''

    cycles = None
    ''''''

    light: typing.Union[str, int] = None
    '''Lighting Method for Solid/Texture Viewport Shading 

    :type: typing.Union[str, int]
    '''

    object_outline_color: typing.List[float] = None
    '''Color for object outline 

    :type: typing.List[float]
    '''

    render_pass: typing.Union[str, int] = None
    '''Render Pass to show in the viewport 

    :type: typing.Union[str, int]
    '''

    selected_studio_light: 'StudioLight' = None
    '''Selected StudioLight 

    :type: 'StudioLight'
    '''

    shadow_intensity: float = None
    '''Darkness of shadows 

    :type: float
    '''

    show_backface_culling: bool = None
    '''Use back face culling to hide the back side of faces 

    :type: bool
    '''

    show_cavity: bool = None
    '''Show Cavity 

    :type: bool
    '''

    show_object_outline: bool = None
    '''Show Object Outline 

    :type: bool
    '''

    show_shadows: bool = None
    '''Show Shadow 

    :type: bool
    '''

    show_specular_highlight: bool = None
    '''Render specular highlights 

    :type: bool
    '''

    show_xray: bool = None
    '''Show whole scene transparent 

    :type: bool
    '''

    show_xray_wireframe: bool = None
    '''Show whole scene transparent 

    :type: bool
    '''

    single_color: typing.List[float] = None
    '''Color for single color mode 

    :type: typing.List[float]
    '''

    studio_light: typing.Union[str, int] = None
    '''Studio lighting setup 

    :type: typing.Union[str, int]
    '''

    studiolight_background_alpha: float = None
    '''Show the studiolight in the background 

    :type: float
    '''

    studiolight_intensity: float = None
    '''Strength of the studiolight 

    :type: float
    '''

    studiolight_rotate_z: float = None
    '''Rotation of the studiolight around the Z-Axis 

    :type: float
    '''

    type: typing.Union[str, int] = None
    '''Method to display/shade objects in the 3D View 

    :type: typing.Union[str, int]
    '''

    use_dof: bool = None
    '''Use depth of field on viewport using the values from the active camera 

    :type: bool
    '''

    use_scene_lights: bool = None
    '''Render lights and light probes of the scene 

    :type: bool
    '''

    use_scene_lights_render: bool = None
    '''Render lights and light probes of the scene 

    :type: bool
    '''

    use_scene_world: bool = None
    '''Use scene world for lighting 

    :type: bool
    '''

    use_scene_world_render: bool = None
    '''Use scene world for lighting 

    :type: bool
    '''

    use_world_space_lighting: bool = None
    '''Make the lighting fixed and not follow the camera 

    :type: bool
    '''

    wireframe_color_type: typing.Union[str, int] = None
    '''Color Type 

    :type: typing.Union[str, int]
    '''

    xray_alpha: float = None
    '''Amount of alpha to use 

    :type: float
    '''

    xray_alpha_wireframe: float = None
    '''Amount of alpha to use 

    :type: float
    '''


class ViewLayer(bpy_struct):
    '''View layer '''

    active_layer_collection: 'LayerCollection' = None
    '''Active layer collection in this view layer’s hierarchy 

    :type: 'LayerCollection'
    '''

    cycles = None
    '''Cycles ViewLayer Settings '''

    depsgraph: 'Depsgraph' = None
    '''Dependencies in the scene data 

    :type: 'Depsgraph'
    '''

    freestyle_settings: 'FreestyleSettings' = None
    '''

    :type: 'FreestyleSettings'
    '''

    invert_zmask: bool = None
    '''For Zmask, only render what is behind solid z values instead of in front 

    :type: bool
    '''

    layer_collection: 'LayerCollection' = None
    '''Root of collections hierarchy of this view layer,its ‘collection’ pointer property is the same as the scene’s master collection 

    :type: 'LayerCollection'
    '''

    material_override: 'Material' = None
    '''Material to override all other materials in this view layer 

    :type: 'Material'
    '''

    name: str = None
    '''View layer name 

    :type: str
    '''

    objects: typing.Union[typing.List['Object'], 'bpy_prop_collection',
                          'LayerObjects'] = None
    '''All the objects in this layer 

    :type: typing.Union[typing.List['Object'], 'bpy_prop_collection', 'LayerObjects']
    '''

    pass_alpha_threshold: float = None
    '''Z, Index, normal, UV and vector passes are only affected by surfaces with alpha transparency equal to or higher than this threshold 

    :type: float
    '''

    samples: int = None
    '''Override number of render samples for this view layer, 0 will use the scene setting 

    :type: int
    '''

    use: bool = None
    '''Enable or disable rendering of this View Layer 

    :type: bool
    '''

    use_all_z: bool = None
    '''Fill in Z values for solid faces in invisible layers, for masking 

    :type: bool
    '''

    use_ao: bool = None
    '''Render Ambient Occlusion in this Layer 

    :type: bool
    '''

    use_edge_enhance: bool = None
    '''Render Edge-enhance in this Layer (only works for Solid faces) 

    :type: bool
    '''

    use_freestyle: bool = None
    '''Render stylized strokes in this Layer 

    :type: bool
    '''

    use_halo: bool = None
    '''Render Halos in this Layer (on top of Solid) 

    :type: bool
    '''

    use_pass_ambient_occlusion: bool = None
    '''Deliver Ambient Occlusion pass 

    :type: bool
    '''

    use_pass_combined: bool = None
    '''Deliver full combined RGBA buffer 

    :type: bool
    '''

    use_pass_diffuse_color: bool = None
    '''Deliver diffuse color pass 

    :type: bool
    '''

    use_pass_diffuse_direct: bool = None
    '''Deliver diffuse direct pass 

    :type: bool
    '''

    use_pass_diffuse_indirect: bool = None
    '''Deliver diffuse indirect pass 

    :type: bool
    '''

    use_pass_emit: bool = None
    '''Deliver emission pass 

    :type: bool
    '''

    use_pass_environment: bool = None
    '''Deliver environment lighting pass 

    :type: bool
    '''

    use_pass_glossy_color: bool = None
    '''Deliver glossy color pass 

    :type: bool
    '''

    use_pass_glossy_direct: bool = None
    '''Deliver glossy direct pass 

    :type: bool
    '''

    use_pass_glossy_indirect: bool = None
    '''Deliver glossy indirect pass 

    :type: bool
    '''

    use_pass_material_index: bool = None
    '''Deliver material index pass 

    :type: bool
    '''

    use_pass_mist: bool = None
    '''Deliver mist factor pass (0.0-1.0) 

    :type: bool
    '''

    use_pass_normal: bool = None
    '''Deliver normal pass 

    :type: bool
    '''

    use_pass_object_index: bool = None
    '''Deliver object index pass 

    :type: bool
    '''

    use_pass_shadow: bool = None
    '''Deliver shadow pass 

    :type: bool
    '''

    use_pass_subsurface_color: bool = None
    '''Deliver subsurface color pass 

    :type: bool
    '''

    use_pass_subsurface_direct: bool = None
    '''Deliver subsurface direct pass 

    :type: bool
    '''

    use_pass_subsurface_indirect: bool = None
    '''Deliver subsurface indirect pass 

    :type: bool
    '''

    use_pass_transmission_color: bool = None
    '''Deliver transmission color pass 

    :type: bool
    '''

    use_pass_transmission_direct: bool = None
    '''Deliver transmission direct pass 

    :type: bool
    '''

    use_pass_transmission_indirect: bool = None
    '''Deliver transmission indirect pass 

    :type: bool
    '''

    use_pass_uv: bool = None
    '''Deliver texture UV pass 

    :type: bool
    '''

    use_pass_vector: bool = None
    '''Deliver speed vector pass 

    :type: bool
    '''

    use_pass_z: bool = None
    '''Deliver Z values pass 

    :type: bool
    '''

    use_sky: bool = None
    '''Render Sky in this Layer 

    :type: bool
    '''

    use_solid: bool = None
    '''Render Solid faces in this Layer 

    :type: bool
    '''

    use_strand: bool = None
    '''Render Strands in this Layer 

    :type: bool
    '''

    use_zmask: bool = None
    '''Only render what’s in front of the solid z values 

    :type: bool
    '''

    use_ztransp: bool = None
    '''Render Z-Transparent faces in this Layer (on top of Solid and Halos) 

    :type: bool
    '''

    def update(self, ):
        '''Update data tagged to be updated from previous access to data or operators 

        '''
        pass


class ViewLayers(bpy_struct):
    '''Collection of render layers '''

    def new(self, name: str) -> 'ViewLayer':
        '''Add a view layer to scene 

        :param name: New name for the view layer (not unique) 
        :type name: str
        :rtype: 'ViewLayer'
        :return:  Newly created view layer 
        '''
        pass

    def remove(self, layer: 'ViewLayer'):
        '''Remove a view layer 

        :param layer: View layer to remove 
        :type layer: 'ViewLayer'
        '''
        pass


class WalkNavigation(bpy_struct):
    '''Walk navigation settings '''

    jump_height: float = None
    '''Maximum height of a jump 

    :type: float
    '''

    mouse_speed: float = None
    '''Speed factor for when looking around, high values mean faster mouse movement 

    :type: float
    '''

    teleport_time: float = None
    '''Interval of time warp when teleporting in navigation mode 

    :type: float
    '''

    use_gravity: bool = None
    '''Walk with gravity, or free navigate 

    :type: bool
    '''

    use_mouse_reverse: bool = None
    '''Reverse the vertical movement of the mouse 

    :type: bool
    '''

    view_height: float = None
    '''View distance from the floor when walking 

    :type: float
    '''

    walk_speed: float = None
    '''Base speed for walking and flying 

    :type: float
    '''

    walk_speed_factor: float = None
    '''Multiplication factor when using the fast or slow modifiers 

    :type: float
    '''


class Window(bpy_struct):
    '''Open window '''

    height: int = None
    '''Window height 

    :type: int
    '''

    parent: 'Window' = None
    '''Active workspace and scene follow this window 

    :type: 'Window'
    '''

    scene: 'Scene' = None
    '''Active scene to be edited in the window 

    :type: 'Scene'
    '''

    screen: 'Screen' = None
    '''Active workspace screen showing in the window 

    :type: 'Screen'
    '''

    stereo_3d_display: 'Stereo3dDisplay' = None
    '''Settings for stereo 3d display 

    :type: 'Stereo3dDisplay'
    '''

    view_layer: 'ViewLayer' = None
    '''The active workspace view layer showing in the window 

    :type: 'ViewLayer'
    '''

    width: int = None
    '''Window width 

    :type: int
    '''

    workspace: 'WorkSpace' = None
    '''Active workspace showing in the window 

    :type: 'WorkSpace'
    '''

    x: int = None
    '''Horizontal location of the window 

    :type: int
    '''

    y: int = None
    '''Vertical location of the window 

    :type: int
    '''

    def cursor_warp(self, x, y):
        '''Set the cursor position 

        '''
        pass

    def cursor_set(self, cursor: typing.Union[str, int]):
        '''Set the cursor 

        :param cursor: cursor 
        :type cursor: typing.Union[str, int]
        '''
        pass

    def cursor_modal_set(self, cursor: typing.Union[str, int]):
        '''Restore the previous cursor after calling cursor_modal_set 

        :param cursor: cursor 
        :type cursor: typing.Union[str, int]
        '''
        pass

    def cursor_modal_restore(self, ):
        '''cursor_modal_restore 

        '''
        pass

    def event_simulate(self,
                       type: typing.Union[str, int],
                       value: typing.Union[str, int],
                       unicode="",
                       x=0,
                       y=0,
                       shift: bool = False,
                       ctrl: bool = False,
                       alt: bool = False,
                       oskey: bool = False) -> 'Event':
        '''event_simulate 

        :param type: TypeNONE .LEFTMOUSE Left Mouse, LMB.MIDDLEMOUSE Middle Mouse, MMB.RIGHTMOUSE Right Mouse, RMB.BUTTON4MOUSE Button4 Mouse, MB4.BUTTON5MOUSE Button5 Mouse, MB5.BUTTON6MOUSE Button6 Mouse, MB6.BUTTON7MOUSE Button7 Mouse, MB7.PEN Pen.ERASER Eraser.MOUSEMOVE Mouse Move, MsMov.INBETWEEN_MOUSEMOVE In-between Move, MsSubMov.TRACKPADPAN Mouse/Trackpad Pan, MsPan.TRACKPADZOOM Mouse/Trackpad Zoom, MsZoom.MOUSEROTATE Mouse/Trackpad Rotate, MsRot.WHEELUPMOUSE Wheel Up, WhUp.WHEELDOWNMOUSE Wheel Down, WhDown.WHEELINMOUSE Wheel In, WhIn.WHEELOUTMOUSE Wheel Out, WhOut.EVT_TWEAK_L Tweak Left, TwkL.EVT_TWEAK_M Tweak Middle, TwkM.EVT_TWEAK_R Tweak Right, TwkR.A A.B B.C C.D D.E E.F F.G G.H H.I I.J J.K K.L L.M M.N N.O O.P P.Q Q.R R.S S.T T.U U.V V.W W.X X.Y Y.Z Z.ZERO 0.ONE 1.TWO 2.THREE 3.FOUR 4.FIVE 5.SIX 6.SEVEN 7.EIGHT 8.NINE 9.LEFT_CTRL Left Ctrl, CtrlL.LEFT_ALT Left Alt, AltL.LEFT_SHIFT Left Shift, ShiftL.RIGHT_ALT Right Alt, AltR.RIGHT_CTRL Right Ctrl, CtrlR.RIGHT_SHIFT Right Shift, ShiftR.OSKEY OS Key, Cmd.APP Application, App.GRLESS Grless.ESC Esc.TAB Tab.RET Return, Enter.SPACE Spacebar, Space.LINE_FEED Line Feed.BACK_SPACE Back Space, BkSpace.DEL Delete, Del.SEMI_COLON ;.PERIOD ..COMMA ,.QUOTE “.ACCENT_GRAVE `.MINUS -.PLUS +.SLASH /.BACK_SLASH .EQUAL =.LEFT_BRACKET [.RIGHT_BRACKET ].LEFT_ARROW Left Arrow, ←.DOWN_ARROW Down Arrow, ↓.RIGHT_ARROW Right Arrow, →.UP_ARROW Up Arrow, ↑.NUMPAD_2 Numpad 2, Pad2.NUMPAD_4 Numpad 4, Pad4.NUMPAD_6 Numpad 6, Pad6.NUMPAD_8 Numpad 8, Pad8.NUMPAD_1 Numpad 1, Pad1.NUMPAD_3 Numpad 3, Pad3.NUMPAD_5 Numpad 5, Pad5.NUMPAD_7 Numpad 7, Pad7.NUMPAD_9 Numpad 9, Pad9.NUMPAD_PERIOD Numpad ., Pad..NUMPAD_SLASH Numpad /, Pad/.NUMPAD_ASTERIX Numpad *, Pad*.NUMPAD_0 Numpad 0, Pad0.NUMPAD_MINUS Numpad -, Pad-.NUMPAD_ENTER Numpad Enter, PadEnter.NUMPAD_PLUS Numpad +, Pad+.F1 F1.F2 F2.F3 F3.F4 F4.F5 F5.F6 F6.F7 F7.F8 F8.F9 F9.F10 F10.F11 F11.F12 F12.F13 F13.F14 F14.F15 F15.F16 F16.F17 F17.F18 F18.F19 F19.F20 F20.F21 F21.F22 F22.F23 F23.F24 F24.PAUSE Pause.INSERT Insert, Ins.HOME Home.PAGE_UP Page Up, PgUp.PAGE_DOWN Page Down, PgDown.END End.MEDIA_PLAY Media Play/Pause, >/||.MEDIA_STOP Media Stop, Stop.MEDIA_FIRST Media First, |<<.MEDIA_LAST Media Last, >>|.TEXTINPUT Text Input, TxtIn.WINDOW_DEACTIVATE Window Deactivate.TIMER Timer, Tmr.TIMER0 Timer 0, Tmr0.TIMER1 Timer 1, Tmr1.TIMER2 Timer 2, Tmr2.TIMER_JOBS Timer Jobs, TmrJob.TIMER_AUTOSAVE Timer Autosave, TmrSave.TIMER_REPORT Timer Report, TmrReport.TIMERREGION Timer Region, TmrReg.NDOF_MOTION NDOF Motion, NdofMov.NDOF_BUTTON_MENU NDOF Menu, NdofMenu.NDOF_BUTTON_FIT NDOF Fit, NdofFit.NDOF_BUTTON_TOP NDOF Top, Ndof↑.NDOF_BUTTON_BOTTOM NDOF Bottom, Ndof↓.NDOF_BUTTON_LEFT NDOF Left, Ndof←.NDOF_BUTTON_RIGHT NDOF Right, Ndof→.NDOF_BUTTON_FRONT NDOF Front, NdofFront.NDOF_BUTTON_BACK NDOF Back, NdofBack.NDOF_BUTTON_ISO1 NDOF Isometric 1, NdofIso1.NDOF_BUTTON_ISO2 NDOF Isometric 2, NdofIso2.NDOF_BUTTON_ROLL_CW NDOF Roll CW, NdofRCW.NDOF_BUTTON_ROLL_CCW NDOF Roll CCW, NdofRCCW.NDOF_BUTTON_SPIN_CW NDOF Spin CW, NdofSCW.NDOF_BUTTON_SPIN_CCW NDOF Spin CCW, NdofSCCW.NDOF_BUTTON_TILT_CW NDOF Tilt CW, NdofTCW.NDOF_BUTTON_TILT_CCW NDOF Tilt CCW, NdofTCCW.NDOF_BUTTON_ROTATE NDOF Rotate, NdofRot.NDOF_BUTTON_PANZOOM NDOF Pan/Zoom, NdofPanZoom.NDOF_BUTTON_DOMINANT NDOF Dominant, NdofDom.NDOF_BUTTON_PLUS NDOF Plus, Ndof+.NDOF_BUTTON_MINUS NDOF Minus, Ndof-.NDOF_BUTTON_ESC NDOF Esc, NdofEsc.NDOF_BUTTON_ALT NDOF Alt, NdofAlt.NDOF_BUTTON_SHIFT NDOF Shift, NdofShift.NDOF_BUTTON_CTRL NDOF Ctrl, NdofCtrl.NDOF_BUTTON_1 NDOF Button 1, NdofB1.NDOF_BUTTON_2 NDOF Button 2, NdofB2.NDOF_BUTTON_3 NDOF Button 3, NdofB3.NDOF_BUTTON_4 NDOF Button 4, NdofB4.NDOF_BUTTON_5 NDOF Button 5, NdofB5.NDOF_BUTTON_6 NDOF Button 6, NdofB6.NDOF_BUTTON_7 NDOF Button 7, NdofB7.NDOF_BUTTON_8 NDOF Button 8, NdofB8.NDOF_BUTTON_9 NDOF Button 9, NdofB9.NDOF_BUTTON_10 NDOF Button 10, NdofB10.NDOF_BUTTON_A NDOF Button A, NdofBA.NDOF_BUTTON_B NDOF Button B, NdofBB.NDOF_BUTTON_C NDOF Button C, NdofBC.ACTIONZONE_AREA ActionZone Area, AZone Area.ACTIONZONE_REGION ActionZone Region, AZone Region.ACTIONZONE_FULLSCREEN ActionZone Fullscreen, AZone FullScr. 
        :type type: typing.Union[str, int]
        :param value: Value 
        :type value: typing.Union[str, int]
        :param shift: Shift 
        :type shift: bool
        :param ctrl: Ctrl 
        :type ctrl: bool
        :param alt: Alt 
        :type alt: bool
        :param oskey: OS Key 
        :type oskey: bool
        :rtype: 'Event'
        :return:  Item, Added key map item 
        '''
        pass


class WorkSpaceTool(bpy_struct):
    has_datablock: bool = None
    '''

    :type: bool
    '''

    idname: str = None
    '''

    :type: str
    '''

    idname_fallback: str = None
    '''

    :type: str
    '''

    index: int = None
    '''

    :type: int
    '''

    mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    space_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    widget: str = None
    '''

    :type: str
    '''

    def setup(self,
              idname: str,
              cursor: typing.Union[str, int] = 'DEFAULT',
              keymap: str = "",
              gizmo_group: str = "",
              data_block: str = "",
              operator: str = "",
              index: int = 0,
              idname_fallback: str = "",
              keymap_fallback: str = ""):
        '''Set the tool settings 

        :param idname: Identifier 
        :type idname: str
        :param cursor: cursor 
        :type cursor: typing.Union[str, int]
        :param keymap: Key Map 
        :type keymap: str
        :param gizmo_group: Gizmo Group 
        :type gizmo_group: str
        :param data_block: Data Block 
        :type data_block: str
        :param operator: Operator 
        :type operator: str
        :param index: Index 
        :type index: int
        :param idname_fallback: Fallback Identifier 
        :type idname_fallback: str
        :param keymap_fallback: Fallback Key Map 
        :type keymap_fallback: str
        '''
        pass

    def operator_properties(self, operator) -> 'OperatorProperties':
        '''operator_properties 

        :rtype: 'OperatorProperties'
        '''
        pass

    def gizmo_group_properties(self, group) -> 'GizmoGroupProperties':
        '''gizmo_group_properties 

        :rtype: 'GizmoGroupProperties'
        '''
        pass

    def refresh_from_context(self, ):
        '''refresh_from_context 

        '''
        pass


class WorldLighting(bpy_struct):
    '''Lighting for a World data-block '''

    ao_factor: float = None
    '''Factor for ambient occlusion blending 

    :type: float
    '''

    distance: float = None
    '''Length of rays, defines how far away other faces give occlusion effect 

    :type: float
    '''

    use_ambient_occlusion: bool = None
    '''Use Ambient Occlusion to add shadowing based on distance between objects 

    :type: bool
    '''


class WorldMistSettings(bpy_struct):
    '''Mist settings for a World data-block '''

    depth: float = None
    '''Distance over which the mist effect fades in 

    :type: float
    '''

    falloff: typing.Union[str, int] = None
    '''Type of transition used to fade mist 

    :type: typing.Union[str, int]
    '''

    height: float = None
    '''Control how much mist density decreases with height 

    :type: float
    '''

    intensity: float = None
    '''Overall minimum intensity of the mist effect 

    :type: float
    '''

    start: float = None
    '''Starting distance of the mist, measured from the camera 

    :type: float
    '''

    use_mist: bool = None
    '''Occlude objects with the environment color as they are further away 

    :type: bool
    '''


class wmOwnerID(bpy_struct):
    name: str = None
    '''

    :type: str
    '''


class wmOwnerIDs(bpy_struct):
    def new(self, name: str) -> 'wmOwnerID':
        '''Add ui tag 

        :param name: New name for the tag 
        :type name: str
        :rtype: 'wmOwnerID'
        '''
        pass

    def remove(self, owner_id: 'wmOwnerID'):
        '''Remove ui tag 

        :param owner_id: Tag to remove 
        :type owner_id: 'wmOwnerID'
        '''
        pass

    def clear(self, ):
        '''Remove all tags 

        '''
        pass


class wmTools(bpy_struct):
    def from_space_view3d_mode(self, mode,
                               create: bool = False) -> 'WorkSpaceTool':
        '''

        :param create: Create 
        :type create: bool
        :rtype: 'WorkSpaceTool'
        '''
        pass

    def from_space_image_mode(self,
                              mode: typing.Union[str, int],
                              create: bool = False) -> 'WorkSpaceTool':
        '''

        :param mode: VIEW View, View the image.UV UV Editor, UV edit in mesh editmode.PAINT Paint, 2D image painting mode.MASK Mask, Mask editing. 
        :type mode: typing.Union[str, int]
        :param create: Create 
        :type create: bool
        :rtype: 'WorkSpaceTool'
        '''
        pass

    def from_space_node(self, create: bool = False) -> 'WorkSpaceTool':
        '''

        :param create: Create 
        :type create: bool
        :rtype: 'WorkSpaceTool'
        '''
        pass


class BoidRuleAverageSpeed(BoidRule, bpy_struct):
    level: float = None
    '''How much velocity’s z-component is kept constant 

    :type: float
    '''

    speed: float = None
    '''Percentage of maximum speed 

    :type: float
    '''

    wander: float = None
    '''How fast velocity’s direction is randomized 

    :type: float
    '''


class BoidRuleAvoid(BoidRule, bpy_struct):
    fear_factor: float = None
    '''Avoid object if danger from it is above this threshold 

    :type: float
    '''

    object: 'Object' = None
    '''Object to avoid 

    :type: 'Object'
    '''

    use_predict: bool = None
    '''Predict target movement 

    :type: bool
    '''


class BoidRuleAvoidCollision(BoidRule, bpy_struct):
    look_ahead: float = None
    '''Time to look ahead in seconds 

    :type: float
    '''

    use_avoid: bool = None
    '''Avoid collision with other boids 

    :type: bool
    '''

    use_avoid_collision: bool = None
    '''Avoid collision with deflector objects 

    :type: bool
    '''


class BoidRuleFight(BoidRule, bpy_struct):
    distance: float = None
    '''Attack boids at max this distance 

    :type: float
    '''

    flee_distance: float = None
    '''Flee to this distance 

    :type: float
    '''


class BoidRuleFollowLeader(BoidRule, bpy_struct):
    distance: float = None
    '''Distance behind leader to follow 

    :type: float
    '''

    object: 'Object' = None
    '''Follow this object instead of a boid 

    :type: 'Object'
    '''

    queue_count: int = None
    '''How many boids in a line 

    :type: int
    '''

    use_line: bool = None
    '''Follow leader in a line 

    :type: bool
    '''


class BoidRuleGoal(BoidRule, bpy_struct):
    object: 'Object' = None
    '''Goal object 

    :type: 'Object'
    '''

    use_predict: bool = None
    '''Predict target movement 

    :type: bool
    '''


class ActionConstraint(Constraint, bpy_struct):
    '''Map an action to the transform axes of a bone '''

    action: 'Action' = None
    '''The constraining action 

    :type: 'Action'
    '''

    frame_end: int = None
    '''Last frame of the Action to use 

    :type: int
    '''

    frame_start: int = None
    '''First frame of the Action to use 

    :type: int
    '''

    max: float = None
    '''Maximum value for target channel range 

    :type: float
    '''

    min: float = None
    '''Minimum value for target channel range 

    :type: float
    '''

    mix_mode: typing.Union[str, int] = None
    '''Specify how existing transformations and the action channels are combined 

    :type: typing.Union[str, int]
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    transform_channel: typing.Union[str, int] = None
    '''Transformation channel from the target that is used to key the Action 

    :type: typing.Union[str, int]
    '''

    use_bone_object_action: bool = None
    '''Bones only: apply the object’s transformation channels of the action to the constrained bone, instead of bone’s channels 

    :type: bool
    '''


class ArmatureConstraint(Constraint, bpy_struct):
    '''Applies transformations done by the Armature modifier '''

    targets: typing.Union[typing.
                          List['ConstraintTargetBone'], 'bpy_prop_collection',
                          'ArmatureConstraintTargets'] = None
    '''Target Bones 

    :type: typing.Union[typing.List['ConstraintTargetBone'], 'bpy_prop_collection', 'ArmatureConstraintTargets']
    '''

    use_bone_envelopes: bool = None
    '''Multiply weights by envelope for all bones, instead of acting like Vertex Group based blending. The specified weights are still used, and only the listed bones are considered 

    :type: bool
    '''

    use_current_location: bool = None
    '''Use the current bone location for envelopes and choosing B-Bone segments instead of rest position 

    :type: bool
    '''

    use_deform_preserve_volume: bool = None
    '''Deform rotation interpolation with quaternions 

    :type: bool
    '''


class CameraSolverConstraint(Constraint, bpy_struct):
    '''Lock motion to the reconstructed camera movement '''

    clip: 'MovieClip' = None
    '''Movie Clip to get tracking data from 

    :type: 'MovieClip'
    '''

    use_active_clip: bool = None
    '''Use active clip defined in scene 

    :type: bool
    '''


class ChildOfConstraint(Constraint, bpy_struct):
    '''Create constraint-based parent-child relationship '''

    inverse_matrix: typing.List[float] = None
    '''Transformation matrix to apply before 

    :type: typing.List[float]
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    use_location_x: bool = None
    '''Use X Location of Parent 

    :type: bool
    '''

    use_location_y: bool = None
    '''Use Y Location of Parent 

    :type: bool
    '''

    use_location_z: bool = None
    '''Use Z Location of Parent 

    :type: bool
    '''

    use_rotation_x: bool = None
    '''Use X Rotation of Parent 

    :type: bool
    '''

    use_rotation_y: bool = None
    '''Use Y Rotation of Parent 

    :type: bool
    '''

    use_rotation_z: bool = None
    '''Use Z Rotation of Parent 

    :type: bool
    '''

    use_scale_x: bool = None
    '''Use X Scale of Parent 

    :type: bool
    '''

    use_scale_y: bool = None
    '''Use Y Scale of Parent 

    :type: bool
    '''

    use_scale_z: bool = None
    '''Use Z Scale of Parent 

    :type: bool
    '''


class ClampToConstraint(Constraint, bpy_struct):
    '''Constrain an object’s location to the nearest point along the target path '''

    main_axis: typing.Union[str, int] = None
    '''Main axis of movement 

    :type: typing.Union[str, int]
    '''

    target: 'Object' = None
    '''Target Object (Curves only) 

    :type: 'Object'
    '''

    use_cyclic: bool = None
    '''Treat curve as cyclic curve (no clamping to curve bounding box) 

    :type: bool
    '''


class CopyLocationConstraint(Constraint, bpy_struct):
    '''Copy the location of the target '''

    head_tail: float = None
    '''Target along length of bone: Head=0, Tail=1 

    :type: float
    '''

    invert_x: bool = None
    '''Invert the X location 

    :type: bool
    '''

    invert_y: bool = None
    '''Invert the Y location 

    :type: bool
    '''

    invert_z: bool = None
    '''Invert the Z location 

    :type: bool
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    use_bbone_shape: bool = None
    '''Follow shape of B-Bone segments when calculating Head/Tail position 

    :type: bool
    '''

    use_offset: bool = None
    '''Add original location into copied location 

    :type: bool
    '''

    use_x: bool = None
    '''Copy the target’s X location 

    :type: bool
    '''

    use_y: bool = None
    '''Copy the target’s Y location 

    :type: bool
    '''

    use_z: bool = None
    '''Copy the target’s Z location 

    :type: bool
    '''


class CopyRotationConstraint(Constraint, bpy_struct):
    '''Copy the rotation of the target '''

    euler_order: typing.Union[str, int] = None
    '''Explicitly specify the euler rotation order 

    :type: typing.Union[str, int]
    '''

    invert_x: bool = None
    '''Invert the X rotation 

    :type: bool
    '''

    invert_y: bool = None
    '''Invert the Y rotation 

    :type: bool
    '''

    invert_z: bool = None
    '''Invert the Z rotation 

    :type: bool
    '''

    mix_mode: typing.Union[str, int] = None
    '''Specify how the copied and existing rotations are combined 

    :type: typing.Union[str, int]
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    use_offset: bool = None
    '''DEPRECATED: Add original rotation into copied rotation 

    :type: bool
    '''

    use_x: bool = None
    '''Copy the target’s X rotation 

    :type: bool
    '''

    use_y: bool = None
    '''Copy the target’s Y rotation 

    :type: bool
    '''

    use_z: bool = None
    '''Copy the target’s Z rotation 

    :type: bool
    '''


class CopyScaleConstraint(Constraint, bpy_struct):
    '''Copy the scale of the target '''

    power: float = None
    '''Raise the target’s scale to the specified power 

    :type: float
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    use_add: bool = None
    '''Use addition instead of multiplication to combine scale (2.7 compatibility) 

    :type: bool
    '''

    use_make_uniform: bool = None
    '''Redistribute the copied change in volume equally between the three axes of the owner 

    :type: bool
    '''

    use_offset: bool = None
    '''Combine original scale with copied scale 

    :type: bool
    '''

    use_x: bool = None
    '''Copy the target’s X scale 

    :type: bool
    '''

    use_y: bool = None
    '''Copy the target’s Y scale 

    :type: bool
    '''

    use_z: bool = None
    '''Copy the target’s Z scale 

    :type: bool
    '''


class CopyTransformsConstraint(Constraint, bpy_struct):
    '''Copy all the transforms of the target '''

    head_tail: float = None
    '''Target along length of bone: Head=0, Tail=1 

    :type: float
    '''

    mix_mode: typing.Union[str, int] = None
    '''Specify how the copied and existing transformations are combined 

    :type: typing.Union[str, int]
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    use_bbone_shape: bool = None
    '''Follow shape of B-Bone segments when calculating Head/Tail position 

    :type: bool
    '''


class DampedTrackConstraint(Constraint, bpy_struct):
    '''Point toward target by taking the shortest rotation path '''

    head_tail: float = None
    '''Target along length of bone: Head=0, Tail=1 

    :type: float
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    track_axis: typing.Union[str, int] = None
    '''Axis that points to the target object 

    :type: typing.Union[str, int]
    '''

    use_bbone_shape: bool = None
    '''Follow shape of B-Bone segments when calculating Head/Tail position 

    :type: bool
    '''


class FloorConstraint(Constraint, bpy_struct):
    '''Use the target object for location limitation '''

    floor_location: typing.Union[str, int] = None
    '''Location of target that object will not pass through 

    :type: typing.Union[str, int]
    '''

    offset: float = None
    '''Offset of floor from object origin 

    :type: float
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    use_rotation: bool = None
    '''Use the target’s rotation to determine floor 

    :type: bool
    '''


class FollowPathConstraint(Constraint, bpy_struct):
    '''Lock motion to the target path '''

    forward_axis: typing.Union[str, int] = None
    '''Axis that points forward along the path 

    :type: typing.Union[str, int]
    '''

    offset: float = None
    '''Offset from the position corresponding to the time frame 

    :type: float
    '''

    offset_factor: float = None
    '''Percentage value defining target position along length of curve 

    :type: float
    '''

    target: 'Object' = None
    '''Target Curve object 

    :type: 'Object'
    '''

    up_axis: typing.Union[str, int] = None
    '''Axis that points upward 

    :type: typing.Union[str, int]
    '''

    use_curve_follow: bool = None
    '''Object will follow the heading and banking of the curve 

    :type: bool
    '''

    use_curve_radius: bool = None
    '''Object is scaled by the curve radius 

    :type: bool
    '''

    use_fixed_location: bool = None
    '''Object will stay locked to a single point somewhere along the length of the curve regardless of time 

    :type: bool
    '''


class FollowTrackConstraint(Constraint, bpy_struct):
    '''Lock motion to the target motion track '''

    camera: 'Object' = None
    '''Camera to which motion is parented (if empty active scene camera is used) 

    :type: 'Object'
    '''

    clip: 'MovieClip' = None
    '''Movie Clip to get tracking data from 

    :type: 'MovieClip'
    '''

    depth_object: 'Object' = None
    '''Object used to define depth in camera space by projecting onto surface of this object 

    :type: 'Object'
    '''

    frame_method: typing.Union[str, int] = None
    '''How the footage fits in the camera frame 

    :type: typing.Union[str, int]
    '''

    object: str = None
    '''Movie tracking object to follow (if empty, camera object is used) 

    :type: str
    '''

    track: str = None
    '''Movie tracking track to follow 

    :type: str
    '''

    use_3d_position: bool = None
    '''Use 3D position of track to parent to 

    :type: bool
    '''

    use_active_clip: bool = None
    '''Use active clip defined in scene 

    :type: bool
    '''

    use_undistorted_position: bool = None
    '''Parent to undistorted position of 2D track 

    :type: bool
    '''


class KinematicConstraint(Constraint, bpy_struct):
    '''Inverse Kinematics '''

    chain_count: int = None
    '''How many bones are included in the IK effect - 0 uses all bones 

    :type: int
    '''

    distance: float = None
    '''Radius of limiting sphere 

    :type: float
    '''

    ik_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    iterations: int = None
    '''Maximum number of solving iterations 

    :type: int
    '''

    limit_mode: typing.Union[str, int] = None
    '''Distances in relation to sphere of influence to allow 

    :type: typing.Union[str, int]
    '''

    lock_location_x: bool = None
    '''Constraint position along X axis 

    :type: bool
    '''

    lock_location_y: bool = None
    '''Constraint position along Y axis 

    :type: bool
    '''

    lock_location_z: bool = None
    '''Constraint position along Z axis 

    :type: bool
    '''

    lock_rotation_x: bool = None
    '''Constraint rotation along X axis 

    :type: bool
    '''

    lock_rotation_y: bool = None
    '''Constraint rotation along Y axis 

    :type: bool
    '''

    lock_rotation_z: bool = None
    '''Constraint rotation along Z axis 

    :type: bool
    '''

    orient_weight: float = None
    '''For Tree-IK: Weight of orientation control for this target 

    :type: float
    '''

    pole_angle: float = None
    '''Pole rotation offset 

    :type: float
    '''

    pole_subtarget: str = None
    '''

    :type: str
    '''

    pole_target: 'Object' = None
    '''Object for pole rotation 

    :type: 'Object'
    '''

    reference_axis: typing.Union[str, int] = None
    '''Constraint axis Lock options relative to Bone or Target reference 

    :type: typing.Union[str, int]
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    use_location: bool = None
    '''Chain follows position of target 

    :type: bool
    '''

    use_rotation: bool = None
    '''Chain follows rotation of target 

    :type: bool
    '''

    use_stretch: bool = None
    '''Enable IK Stretching 

    :type: bool
    '''

    use_tail: bool = None
    '''Include bone’s tail as last element in chain 

    :type: bool
    '''

    weight: float = None
    '''For Tree-IK: Weight of position control for this target 

    :type: float
    '''


class LimitDistanceConstraint(Constraint, bpy_struct):
    '''Limit the distance from target object '''

    distance: float = None
    '''Radius of limiting sphere 

    :type: float
    '''

    head_tail: float = None
    '''Target along length of bone: Head=0, Tail=1 

    :type: float
    '''

    limit_mode: typing.Union[str, int] = None
    '''Distances in relation to sphere of influence to allow 

    :type: typing.Union[str, int]
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    use_bbone_shape: bool = None
    '''Follow shape of B-Bone segments when calculating Head/Tail position 

    :type: bool
    '''

    use_transform_limit: bool = None
    '''Transforms are affected by this constraint as well 

    :type: bool
    '''


class LimitLocationConstraint(Constraint, bpy_struct):
    '''Limit the location of the constrained object '''

    max_x: float = None
    '''Highest X value to allow 

    :type: float
    '''

    max_y: float = None
    '''Highest Y value to allow 

    :type: float
    '''

    max_z: float = None
    '''Highest Z value to allow 

    :type: float
    '''

    min_x: float = None
    '''Lowest X value to allow 

    :type: float
    '''

    min_y: float = None
    '''Lowest Y value to allow 

    :type: float
    '''

    min_z: float = None
    '''Lowest Z value to allow 

    :type: float
    '''

    use_max_x: bool = None
    '''Use the maximum X value 

    :type: bool
    '''

    use_max_y: bool = None
    '''Use the maximum Y value 

    :type: bool
    '''

    use_max_z: bool = None
    '''Use the maximum Z value 

    :type: bool
    '''

    use_min_x: bool = None
    '''Use the minimum X value 

    :type: bool
    '''

    use_min_y: bool = None
    '''Use the minimum Y value 

    :type: bool
    '''

    use_min_z: bool = None
    '''Use the minimum Z value 

    :type: bool
    '''

    use_transform_limit: bool = None
    '''Transforms are affected by this constraint as well 

    :type: bool
    '''


class LimitRotationConstraint(Constraint, bpy_struct):
    '''Limit the rotation of the constrained object '''

    max_x: float = None
    '''Highest X value to allow 

    :type: float
    '''

    max_y: float = None
    '''Highest Y value to allow 

    :type: float
    '''

    max_z: float = None
    '''Highest Z value to allow 

    :type: float
    '''

    min_x: float = None
    '''Lowest X value to allow 

    :type: float
    '''

    min_y: float = None
    '''Lowest Y value to allow 

    :type: float
    '''

    min_z: float = None
    '''Lowest Z value to allow 

    :type: float
    '''

    use_limit_x: bool = None
    '''Use the minimum X value 

    :type: bool
    '''

    use_limit_y: bool = None
    '''Use the minimum Y value 

    :type: bool
    '''

    use_limit_z: bool = None
    '''Use the minimum Z value 

    :type: bool
    '''

    use_transform_limit: bool = None
    '''Transforms are affected by this constraint as well 

    :type: bool
    '''


class LimitScaleConstraint(Constraint, bpy_struct):
    '''Limit the scaling of the constrained object '''

    max_x: float = None
    '''Highest X value to allow 

    :type: float
    '''

    max_y: float = None
    '''Highest Y value to allow 

    :type: float
    '''

    max_z: float = None
    '''Highest Z value to allow 

    :type: float
    '''

    min_x: float = None
    '''Lowest X value to allow 

    :type: float
    '''

    min_y: float = None
    '''Lowest Y value to allow 

    :type: float
    '''

    min_z: float = None
    '''Lowest Z value to allow 

    :type: float
    '''

    use_max_x: bool = None
    '''Use the maximum X value 

    :type: bool
    '''

    use_max_y: bool = None
    '''Use the maximum Y value 

    :type: bool
    '''

    use_max_z: bool = None
    '''Use the maximum Z value 

    :type: bool
    '''

    use_min_x: bool = None
    '''Use the minimum X value 

    :type: bool
    '''

    use_min_y: bool = None
    '''Use the minimum Y value 

    :type: bool
    '''

    use_min_z: bool = None
    '''Use the minimum Z value 

    :type: bool
    '''

    use_transform_limit: bool = None
    '''Transforms are affected by this constraint as well 

    :type: bool
    '''


class LockedTrackConstraint(Constraint, bpy_struct):
    '''Point toward the target along the track axis, while locking the other axis '''

    head_tail: float = None
    '''Target along length of bone: Head=0, Tail=1 

    :type: float
    '''

    lock_axis: typing.Union[str, int] = None
    '''Axis that points upward 

    :type: typing.Union[str, int]
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    track_axis: typing.Union[str, int] = None
    '''Axis that points to the target object 

    :type: typing.Union[str, int]
    '''

    use_bbone_shape: bool = None
    '''Follow shape of B-Bone segments when calculating Head/Tail position 

    :type: bool
    '''


class MaintainVolumeConstraint(Constraint, bpy_struct):
    '''Maintain a constant volume along a single scaling axis '''

    free_axis: typing.Union[str, int] = None
    '''The free scaling axis of the object 

    :type: typing.Union[str, int]
    '''

    mode: typing.Union[str, int] = None
    '''The way the constraint treats original non-free axis scaling 

    :type: typing.Union[str, int]
    '''

    volume: float = None
    '''Volume of the bone at rest 

    :type: float
    '''


class ObjectSolverConstraint(Constraint, bpy_struct):
    '''Lock motion to the reconstructed object movement '''

    camera: 'Object' = None
    '''Camera to which motion is parented (if empty active scene camera is used) 

    :type: 'Object'
    '''

    clip: 'MovieClip' = None
    '''Movie Clip to get tracking data from 

    :type: 'MovieClip'
    '''

    object: str = None
    '''Movie tracking object to follow 

    :type: str
    '''

    use_active_clip: bool = None
    '''Use active clip defined in scene 

    :type: bool
    '''


class PivotConstraint(Constraint, bpy_struct):
    '''Rotate around a different point '''

    head_tail: float = None
    '''Target along length of bone: Head=0, Tail=1 

    :type: float
    '''

    offset: typing.List[float] = None
    '''Offset of pivot from target (when set), or from owner’s location (when Fixed Position is off), or the absolute pivot point 

    :type: typing.List[float]
    '''

    rotation_range: typing.Union[str, int] = None
    '''Rotation range on which pivoting should occur 

    :type: typing.Union[str, int]
    '''

    subtarget: str = None
    '''

    :type: str
    '''

    target: 'Object' = None
    '''Target Object, defining the position of the pivot when defined 

    :type: 'Object'
    '''

    use_bbone_shape: bool = None
    '''Follow shape of B-Bone segments when calculating Head/Tail position 

    :type: bool
    '''

    use_relative_location: bool = None
    '''Offset will be an absolute point in space instead of relative to the target 

    :type: bool
    '''


class PythonConstraint(Constraint, bpy_struct):
    '''Use Python script for constraint evaluation '''

    has_script_error: bool = None
    '''The linked Python script has thrown an error 

    :type: bool
    '''

    target_count: int = None
    '''Usually only 1-3 are needed 

    :type: int
    '''

    targets: typing.Union[typing.List['ConstraintTarget'],
                          'bpy_prop_collection'] = None
    '''Target Objects 

    :type: typing.Union[typing.List['ConstraintTarget'], 'bpy_prop_collection']
    '''

    text: 'Text' = None
    '''The text object that contains the Python script 

    :type: 'Text'
    '''

    use_targets: bool = None
    '''Use the targets indicated in the constraint panel 

    :type: bool
    '''


class ShrinkwrapConstraint(Constraint, bpy_struct):
    '''Create constraint-based shrinkwrap relationship '''

    cull_face: typing.Union[str, int] = None
    '''Stop vertices from projecting to a face on the target when facing towards/away 

    :type: typing.Union[str, int]
    '''

    distance: float = None
    '''Distance to Target 

    :type: float
    '''

    project_axis: typing.Union[str, int] = None
    '''Axis constrain to 

    :type: typing.Union[str, int]
    '''

    project_axis_space: typing.Union[str, int] = None
    '''Space for the projection axis 

    :type: typing.Union[str, int]
    '''

    project_limit: float = None
    '''Limit the distance used for projection (zero disables) 

    :type: float
    '''

    shrinkwrap_type: typing.Union[str, int] = None
    '''Select type of shrinkwrap algorithm for target position 

    :type: typing.Union[str, int]
    '''

    target: 'Object' = None
    '''Target Mesh object 

    :type: 'Object'
    '''

    track_axis: typing.Union[str, int] = None
    '''Axis that is aligned to the normal 

    :type: typing.Union[str, int]
    '''

    use_invert_cull: bool = None
    '''When projecting in the opposite direction invert the face cull mode 

    :type: bool
    '''

    use_project_opposite: bool = None
    '''Project in both specified and opposite directions 

    :type: bool
    '''

    use_track_normal: bool = None
    '''Align the specified axis to the surface normal 

    :type: bool
    '''

    wrap_mode: typing.Union[str, int] = None
    '''Select how to constrain the object to the target surface 

    :type: typing.Union[str, int]
    '''


class SplineIKConstraint(Constraint, bpy_struct):
    '''Align ‘n’ bones along a curve '''

    bulge: float = None
    '''Factor between volume variation and stretching 

    :type: float
    '''

    bulge_max: float = None
    '''Maximum volume stretching factor 

    :type: float
    '''

    bulge_min: float = None
    '''Minimum volume stretching factor 

    :type: float
    '''

    bulge_smooth: float = None
    '''Strength of volume stretching clamping 

    :type: float
    '''

    chain_count: int = None
    '''How many bones are included in the chain 

    :type: int
    '''

    joint_bindings: typing.List[float] = None
    '''(EXPERIENCED USERS ONLY) The relative positions of the joints along the chain, as percentages 

    :type: typing.List[float]
    '''

    target: 'Object' = None
    '''Curve that controls this relationship 

    :type: 'Object'
    '''

    use_bulge_max: bool = None
    '''Use upper limit for volume variation 

    :type: bool
    '''

    use_bulge_min: bool = None
    '''Use lower limit for volume variation 

    :type: bool
    '''

    use_chain_offset: bool = None
    '''Offset the entire chain relative to the root joint 

    :type: bool
    '''

    use_curve_radius: bool = None
    '''Average radius of the endpoints is used to tweak the X and Z Scaling of the bones, on top of XZ Scale mode 

    :type: bool
    '''

    use_even_divisions: bool = None
    '''Ignore the relative lengths of the bones when fitting to the curve 

    :type: bool
    '''

    use_original_scale: bool = None
    '''Apply volume preservation over the original scaling 

    :type: bool
    '''

    xz_scale_mode: typing.Union[str, int] = None
    '''Method used for determining the scaling of the X and Z axes of the bones 

    :type: typing.Union[str, int]
    '''

    y_scale_mode: typing.Union[str, int] = None
    '''Method used for determining the scaling of the Y axis of the bones, on top of the shape and scaling of the curve itself 

    :type: typing.Union[str, int]
    '''


class StretchToConstraint(Constraint, bpy_struct):
    '''Stretch to meet the target object '''

    bulge: float = None
    '''Factor between volume variation and stretching 

    :type: float
    '''

    bulge_max: float = None
    '''Maximum volume stretching factor 

    :type: float
    '''

    bulge_min: float = None
    '''Minimum volume stretching factor 

    :type: float
    '''

    bulge_smooth: float = None
    '''Strength of volume stretching clamping 

    :type: float
    '''

    head_tail: float = None
    '''Target along length of bone: Head=0, Tail=1 

    :type: float
    '''

    keep_axis: typing.Union[str, int] = None
    '''The rotation type and axis order to use 

    :type: typing.Union[str, int]
    '''

    rest_length: float = None
    '''Length at rest position 

    :type: float
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    use_bbone_shape: bool = None
    '''Follow shape of B-Bone segments when calculating Head/Tail position 

    :type: bool
    '''

    use_bulge_max: bool = None
    '''Use upper limit for volume variation 

    :type: bool
    '''

    use_bulge_min: bool = None
    '''Use lower limit for volume variation 

    :type: bool
    '''

    volume: typing.Union[str, int] = None
    '''Maintain the object’s volume as it stretches 

    :type: typing.Union[str, int]
    '''


class TrackToConstraint(Constraint, bpy_struct):
    '''Aim the constrained object toward the target '''

    head_tail: float = None
    '''Target along length of bone: Head=0, Tail=1 

    :type: float
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    track_axis: typing.Union[str, int] = None
    '''Axis that points to the target object 

    :type: typing.Union[str, int]
    '''

    up_axis: typing.Union[str, int] = None
    '''Axis that points upward 

    :type: typing.Union[str, int]
    '''

    use_bbone_shape: bool = None
    '''Follow shape of B-Bone segments when calculating Head/Tail position 

    :type: bool
    '''

    use_target_z: bool = None
    '''Target’s Z axis, not World Z axis, will constraint the Up direction 

    :type: bool
    '''


class TransformCacheConstraint(Constraint, bpy_struct):
    '''Look up transformation from an external file '''

    cache_file: 'CacheFile' = None
    '''

    :type: 'CacheFile'
    '''

    object_path: str = None
    '''Path to the object in the Alembic archive used to lookup the transform matrix 

    :type: str
    '''


class TransformConstraint(Constraint, bpy_struct):
    '''Map transformations of the target to the object '''

    from_max_x: float = None
    '''Top range of X axis source motion 

    :type: float
    '''

    from_max_x_rot: float = None
    '''Top range of X axis source motion 

    :type: float
    '''

    from_max_x_scale: float = None
    '''Top range of X axis source motion 

    :type: float
    '''

    from_max_y: float = None
    '''Top range of Y axis source motion 

    :type: float
    '''

    from_max_y_rot: float = None
    '''Top range of Y axis source motion 

    :type: float
    '''

    from_max_y_scale: float = None
    '''Top range of Y axis source motion 

    :type: float
    '''

    from_max_z: float = None
    '''Top range of Z axis source motion 

    :type: float
    '''

    from_max_z_rot: float = None
    '''Top range of Z axis source motion 

    :type: float
    '''

    from_max_z_scale: float = None
    '''Top range of Z axis source motion 

    :type: float
    '''

    from_min_x: float = None
    '''Bottom range of X axis source motion 

    :type: float
    '''

    from_min_x_rot: float = None
    '''Bottom range of X axis source motion 

    :type: float
    '''

    from_min_x_scale: float = None
    '''Bottom range of X axis source motion 

    :type: float
    '''

    from_min_y: float = None
    '''Bottom range of Y axis source motion 

    :type: float
    '''

    from_min_y_rot: float = None
    '''Bottom range of Y axis source motion 

    :type: float
    '''

    from_min_y_scale: float = None
    '''Bottom range of Y axis source motion 

    :type: float
    '''

    from_min_z: float = None
    '''Bottom range of Z axis source motion 

    :type: float
    '''

    from_min_z_rot: float = None
    '''Bottom range of Z axis source motion 

    :type: float
    '''

    from_min_z_scale: float = None
    '''Bottom range of Z axis source motion 

    :type: float
    '''

    from_rotation_mode: typing.Union[str, int] = None
    '''Specify the type of rotation channels to use 

    :type: typing.Union[str, int]
    '''

    map_from: typing.Union[str, int] = None
    '''The transformation type to use from the target 

    :type: typing.Union[str, int]
    '''

    map_to: typing.Union[str, int] = None
    '''The transformation type to affect of the constrained object 

    :type: typing.Union[str, int]
    '''

    map_to_x_from: typing.Union[str, int] = None
    '''The source axis constrained object’s X axis uses 

    :type: typing.Union[str, int]
    '''

    map_to_y_from: typing.Union[str, int] = None
    '''The source axis constrained object’s Y axis uses 

    :type: typing.Union[str, int]
    '''

    map_to_z_from: typing.Union[str, int] = None
    '''The source axis constrained object’s Z axis uses 

    :type: typing.Union[str, int]
    '''

    mix_mode: typing.Union[str, int] = None
    '''Specify how to combine the new location with original 

    :type: typing.Union[str, int]
    '''

    mix_mode_rot: typing.Union[str, int] = None
    '''Specify how to combine the new rotation with original 

    :type: typing.Union[str, int]
    '''

    mix_mode_scale: typing.Union[str, int] = None
    '''Specify how to combine the new scale with original 

    :type: typing.Union[str, int]
    '''

    subtarget: str = None
    '''Armature bone, mesh or lattice vertex group, … 

    :type: str
    '''

    target: 'Object' = None
    '''Target object 

    :type: 'Object'
    '''

    to_euler_order: typing.Union[str, int] = None
    '''Explicitly specify the output euler rotation order 

    :type: typing.Union[str, int]
    '''

    to_max_x: float = None
    '''Top range of X axis destination motion 

    :type: float
    '''

    to_max_x_rot: float = None
    '''Top range of X axis destination motion 

    :type: float
    '''

    to_max_x_scale: float = None
    '''Top range of X axis destination motion 

    :type: float
    '''

    to_max_y: float = None
    '''Top range of Y axis destination motion 

    :type: float
    '''

    to_max_y_rot: float = None
    '''Top range of Y axis destination motion 

    :type: float
    '''

    to_max_y_scale: float = None
    '''Top range of Y axis destination motion 

    :type: float
    '''

    to_max_z: float = None
    '''Top range of Z axis destination motion 

    :type: float
    '''

    to_max_z_rot: float = None
    '''Top range of Z axis destination motion 

    :type: float
    '''

    to_max_z_scale: float = None
    '''Top range of Z axis destination motion 

    :type: float
    '''

    to_min_x: float = None
    '''Bottom range of X axis destination motion 

    :type: float
    '''

    to_min_x_rot: float = None
    '''Bottom range of X axis destination motion 

    :type: float
    '''

    to_min_x_scale: float = None
    '''Bottom range of X axis destination motion 

    :type: float
    '''

    to_min_y: float = None
    '''Bottom range of Y axis destination motion 

    :type: float
    '''

    to_min_y_rot: float = None
    '''Bottom range of Y axis destination motion 

    :type: float
    '''

    to_min_y_scale: float = None
    '''Bottom range of Y axis destination motion 

    :type: float
    '''

    to_min_z: float = None
    '''Bottom range of Z axis destination motion 

    :type: float
    '''

    to_min_z_rot: float = None
    '''Bottom range of Z axis destination motion 

    :type: float
    '''

    to_min_z_scale: float = None
    '''Bottom range of Z axis destination motion 

    :type: float
    '''

    use_motion_extrapolate: bool = None
    '''Extrapolate ranges 

    :type: bool
    '''


class FModifierCycles(FModifier, bpy_struct):
    '''Repeat the values of the modified F-Curve '''

    cycles_after: int = None
    '''Maximum number of cycles to allow after last keyframe (0 = infinite) 

    :type: int
    '''

    cycles_before: int = None
    '''Maximum number of cycles to allow before first keyframe (0 = infinite) 

    :type: int
    '''

    mode_after: typing.Union[str, int] = None
    '''Cycling mode to use after last keyframe 

    :type: typing.Union[str, int]
    '''

    mode_before: typing.Union[str, int] = None
    '''Cycling mode to use before first keyframe 

    :type: typing.Union[str, int]
    '''


class FModifierEnvelope(FModifier, bpy_struct):
    '''Scale the values of the modified F-Curve '''

    control_points: typing.Union[typing.List['FModifierEnvelopeControlPoint'],
                                 'bpy_prop_collection',
                                 'FModifierEnvelopeControlPoints'] = None
    '''Control points defining the shape of the envelope 

    :type: typing.Union[typing.List['FModifierEnvelopeControlPoint'], 'bpy_prop_collection', 'FModifierEnvelopeControlPoints']
    '''

    default_max: float = None
    '''Upper distance from Reference Value for 1:1 default influence 

    :type: float
    '''

    default_min: float = None
    '''Lower distance from Reference Value for 1:1 default influence 

    :type: float
    '''

    reference_value: float = None
    '''Value that envelope’s influence is centered around / based on 

    :type: float
    '''


class FModifierFunctionGenerator(FModifier, bpy_struct):
    '''Generate values using a Built-In Function '''

    amplitude: float = None
    '''Scale factor determining the maximum/minimum values 

    :type: float
    '''

    function_type: typing.Union[str, int] = None
    '''Type of built-in function to use 

    :type: typing.Union[str, int]
    '''

    phase_multiplier: float = None
    '''Scale factor determining the ‘speed’ of the function 

    :type: float
    '''

    phase_offset: float = None
    '''Constant factor to offset time by for function 

    :type: float
    '''

    use_additive: bool = None
    '''Values generated by this modifier are applied on top of the existing values instead of overwriting them 

    :type: bool
    '''

    value_offset: float = None
    '''Constant factor to offset values by 

    :type: float
    '''


class FModifierGenerator(FModifier, bpy_struct):
    '''Deterministically generate values for the modified F-Curve '''

    coefficients: typing.List[float] = None
    '''Coefficients for ‘x’ (starting from lowest power of x^0) 

    :type: typing.List[float]
    '''

    mode: typing.Union[str, int] = None
    '''Type of generator to use 

    :type: typing.Union[str, int]
    '''

    poly_order: int = None
    '''The highest power of ‘x’ for this polynomial (number of coefficients - 1) 

    :type: int
    '''

    use_additive: bool = None
    '''Values generated by this modifier are applied on top of the existing values instead of overwriting them 

    :type: bool
    '''


class FModifierLimits(FModifier, bpy_struct):
    '''Limit the time/value ranges of the modified F-Curve '''

    max_x: float = None
    '''Highest X value to allow 

    :type: float
    '''

    max_y: float = None
    '''Highest Y value to allow 

    :type: float
    '''

    min_x: float = None
    '''Lowest X value to allow 

    :type: float
    '''

    min_y: float = None
    '''Lowest Y value to allow 

    :type: float
    '''

    use_max_x: bool = None
    '''Use the maximum X value 

    :type: bool
    '''

    use_max_y: bool = None
    '''Use the maximum Y value 

    :type: bool
    '''

    use_min_x: bool = None
    '''Use the minimum X value 

    :type: bool
    '''

    use_min_y: bool = None
    '''Use the minimum Y value 

    :type: bool
    '''


class FModifierNoise(FModifier, bpy_struct):
    '''Give randomness to the modified F-Curve '''

    blend_type: typing.Union[str, int] = None
    '''Method of modifying the existing F-Curve 

    :type: typing.Union[str, int]
    '''

    depth: int = None
    '''Amount of fine level detail present in the noise 

    :type: int
    '''

    offset: float = None
    '''Time offset for the noise effect 

    :type: float
    '''

    phase: float = None
    '''A random seed for the noise effect 

    :type: float
    '''

    scale: float = None
    '''Scaling (in time) of the noise 

    :type: float
    '''

    strength: float = None
    '''Amplitude of the noise - the amount that it modifies the underlying curve 

    :type: float
    '''


class FModifierPython(FModifier, bpy_struct):
    '''Perform user-defined operation on the modified F-Curve '''

    pass


class FModifierStepped(FModifier, bpy_struct):
    '''Hold each interpolated value from the F-Curve for several frames without changing the timing '''

    frame_end: float = None
    '''Frame that modifier’s influence ends (if applicable) 

    :type: float
    '''

    frame_offset: float = None
    '''Reference number of frames before frames get held (use to get hold for ‘1-3’ vs ‘5-7’ holding patterns) 

    :type: float
    '''

    frame_start: float = None
    '''Frame that modifier’s influence starts (if applicable) 

    :type: float
    '''

    frame_step: float = None
    '''Number of frames to hold each value 

    :type: float
    '''

    use_frame_end: bool = None
    '''Restrict modifier to only act before its ‘end’ frame 

    :type: bool
    '''

    use_frame_start: bool = None
    '''Restrict modifier to only act after its ‘start’ frame 

    :type: bool
    '''


class ArmatureGpencilModifier(GpencilModifier, bpy_struct):
    '''Change stroke using armature to deform modifier '''

    invert_vertex_group: bool = None
    '''Invert vertex group influence 

    :type: bool
    '''

    object: 'Object' = None
    '''Armature object to deform with 

    :type: 'Object'
    '''

    use_bone_envelopes: bool = None
    '''Bind Bone envelopes to armature modifier 

    :type: bool
    '''

    use_deform_preserve_volume: bool = None
    '''Deform rotation interpolation with quaternions 

    :type: bool
    '''

    use_vertex_groups: bool = None
    '''Bind vertex groups to armature modifier 

    :type: bool
    '''

    vertex_group: str = None
    '''Name of Vertex Group which determines influence of modifier per point 

    :type: str
    '''


class ArrayGpencilModifier(GpencilModifier, bpy_struct):
    '''Create grid of duplicate instances '''

    count: int = None
    '''Number of items 

    :type: int
    '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    keep_on_top: bool = None
    '''Keep the original stroke in front of new instances (only affect by layer) 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    offset: typing.List[float] = None
    '''Value for the distance between items 

    :type: typing.List[float]
    '''

    offset_object: 'Object' = None
    '''Use the location and rotation of another object to determine the distance and rotational change between arrayed items 

    :type: 'Object'
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    random_rot: bool = None
    '''Use random factors for rotation 

    :type: bool
    '''

    random_scale: bool = None
    '''Use random factors for scale 

    :type: bool
    '''

    replace_material: int = None
    '''Index of the material used for generated strokes (0 keep original material) 

    :type: int
    '''

    rot_factor: float = None
    '''Random factor for rotation 

    :type: float
    '''

    rotation: typing.List[float] = None
    '''Value for changes in rotation 

    :type: typing.List[float]
    '''

    scale: typing.List[float] = None
    '''Value for changes in scale 

    :type: typing.List[float]
    '''

    scale_factor: float = None
    '''Random factor for scale 

    :type: float
    '''

    shift: typing.List[float] = None
    '''Shiftiness value 

    :type: typing.List[float]
    '''


class BuildGpencilModifier(GpencilModifier, bpy_struct):
    '''Animate strokes appearing and disappearing '''

    concurrent_time_alignment: typing.Union[str, int] = None
    '''When should strokes start to appear/disappear 

    :type: typing.Union[str, int]
    '''

    frame_end: float = None
    '''End Frame (when Restrict Frame Range is enabled) 

    :type: float
    '''

    frame_start: float = None
    '''Start Frame (when Restrict Frame Range is enabled) 

    :type: float
    '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    length: float = None
    '''Maximum number of frames that the build effect can run for (unless another GP keyframe occurs before this time has elapsed) 

    :type: float
    '''

    mode: typing.Union[str, int] = None
    '''How many strokes are being animated at a time 

    :type: typing.Union[str, int]
    '''

    start_delay: float = None
    '''Number of frames after each GP keyframe before the modifier has any effect 

    :type: float
    '''

    transition: typing.Union[str, int] = None
    '''How are strokes animated (i.e. are they appearing or disappearing) 

    :type: typing.Union[str, int]
    '''

    use_restrict_frame_range: bool = None
    '''Only modify strokes during the specified frame range 

    :type: bool
    '''


class ColorGpencilModifier(GpencilModifier, bpy_struct):
    '''Change Hue/Saturation modifier '''

    create_materials: bool = None
    '''When apply modifier, create new material 

    :type: bool
    '''

    hue: float = None
    '''Color Hue 

    :type: float
    '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    modify_color: typing.Union[str, int] = None
    '''Set what colors of the stroke are affected 

    :type: typing.Union[str, int]
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    saturation: float = None
    '''Color Saturation 

    :type: float
    '''

    value: float = None
    '''Color Value 

    :type: float
    '''


class HookGpencilModifier(GpencilModifier, bpy_struct):
    '''Hook modifier to modify the location of stroke points '''

    center: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    falloff_curve: 'CurveMapping' = None
    '''Custom light falloff curve 

    :type: 'CurveMapping'
    '''

    falloff_radius: float = None
    '''If not zero, the distance from the hook where influence ends 

    :type: float
    '''

    falloff_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_vertex: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    matrix_inverse: typing.List[float] = None
    '''Reverse the transformation between this object and its target 

    :type: typing.List[float]
    '''

    object: 'Object' = None
    '''Parent Object for hook, also recalculates and clears offset 

    :type: 'Object'
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    strength: float = None
    '''Relative force of the hook 

    :type: float
    '''

    subtarget: str = None
    '''Name of Parent Bone for hook (if applicable), also recalculates and clears offset 

    :type: str
    '''

    use_falloff_uniform: bool = None
    '''Compensate for non-uniform object scale 

    :type: bool
    '''

    vertex_group: str = None
    '''Vertex group name for modulating the deform 

    :type: str
    '''


class LatticeGpencilModifier(GpencilModifier, bpy_struct):
    '''Change stroke using lattice to deform modifier '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_vertex: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    object: 'Object' = None
    '''Lattice object to deform with 

    :type: 'Object'
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    strength: float = None
    '''Strength of modifier effect 

    :type: float
    '''

    vertex_group: str = None
    '''Vertex group name for modulating the deform 

    :type: str
    '''


class MirrorGpencilModifier(GpencilModifier, bpy_struct):
    '''Change stroke using lattice to deform modifier '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    object: 'Object' = None
    '''Object used as center 

    :type: 'Object'
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    use_clip: bool = None
    '''Clip points 

    :type: bool
    '''

    x_axis: bool = None
    '''Mirror this axis 

    :type: bool
    '''

    y_axis: bool = None
    '''Mirror this axis 

    :type: bool
    '''

    z_axis: bool = None
    '''Mirror this axis 

    :type: bool
    '''


class MultiplyGpencilModifier(GpencilModifier, bpy_struct):
    '''Generate multiple strokes from one stroke '''

    distance: float = None
    '''Distance of duplications 

    :type: float
    '''

    duplications: int = None
    '''How many copies of strokes be displayed 

    :type: int
    '''

    enable_angle_splitting: bool = None
    '''Enable angle splitting 

    :type: bool
    '''

    enable_fading: bool = None
    '''Enable fading 

    :type: bool
    '''

    fading_center: float = None
    '''Fade center 

    :type: float
    '''

    fading_opacity: float = None
    '''Fade influence of stroke’s opacity 

    :type: float
    '''

    fading_thickness: float = None
    '''Fade influence of stroke’s thickness 

    :type: float
    '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    offset: float = None
    '''Offset of duplications. -1 to 1: inner to outer 

    :type: float
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    split_angle: float = None
    '''Split angle for segments 

    :type: float
    '''


class NoiseGpencilModifier(GpencilModifier, bpy_struct):
    '''Noise effect modifier '''

    factor: float = None
    '''Amount of noise to apply 

    :type: float
    '''

    full_stroke: bool = None
    '''The noise moves the stroke as a whole, not point by point 

    :type: bool
    '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_vertex: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    move_extreme: bool = None
    '''The noise moves the stroke extreme points 

    :type: bool
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    random: bool = None
    '''Use random values 

    :type: bool
    '''

    seed: int = None
    '''Random seed 

    :type: int
    '''

    step: int = None
    '''Number of frames before recalculate random values again 

    :type: int
    '''

    use_edit_position: bool = None
    '''The modifier affects the position of the point 

    :type: bool
    '''

    use_edit_strength: bool = None
    '''The modifier affects the color strength of the point 

    :type: bool
    '''

    use_edit_thickness: bool = None
    '''The modifier affects the thickness of the point 

    :type: bool
    '''

    use_edit_uv: bool = None
    '''The modifier affects the UV rotation factor of the point 

    :type: bool
    '''

    vertex_group: str = None
    '''Vertex group name for modulating the deform 

    :type: str
    '''


class OffsetGpencilModifier(GpencilModifier, bpy_struct):
    '''Offset Stroke modifier '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_vertex: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    location: typing.List[float] = None
    '''Values for change location 

    :type: typing.List[float]
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    rotation: typing.List[float] = None
    '''Values for changes in rotation 

    :type: typing.List[float]
    '''

    scale: typing.List[float] = None
    '''Values for changes in scale 

    :type: typing.List[float]
    '''

    vertex_group: str = None
    '''Vertex group name for modulating the deform 

    :type: str
    '''


class OpacityGpencilModifier(GpencilModifier, bpy_struct):
    '''Opacity of Strokes modifier '''

    create_materials: bool = None
    '''When apply modifier, create new material 

    :type: bool
    '''

    factor: float = None
    '''Factor of Opacity 

    :type: float
    '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_vertex: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    modify_color: typing.Union[str, int] = None
    '''Set what colors of the stroke are affected 

    :type: typing.Union[str, int]
    '''

    opacity_mode: typing.Union[str, int] = None
    '''Set what mode used to define opacity 

    :type: typing.Union[str, int]
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    vertex_group: str = None
    '''Vertex group name for modulating the deform 

    :type: str
    '''


class SimplifyGpencilModifier(GpencilModifier, bpy_struct):
    '''Simplify Stroke modifier '''

    distance: float = None
    '''Distance between points 

    :type: float
    '''

    factor: float = None
    '''Factor of Simplify 

    :type: float
    '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    length: float = None
    '''Length of each segment 

    :type: float
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    mode: typing.Union[str, int] = None
    '''How to simplify the stroke 

    :type: typing.Union[str, int]
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    step: int = None
    '''Number of times to apply simplify 

    :type: int
    '''


class SmoothGpencilModifier(GpencilModifier, bpy_struct):
    '''Smooth effect modifier '''

    factor: float = None
    '''Amount of smooth to apply 

    :type: float
    '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_vertex: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    step: int = None
    '''Number of times to apply smooth (high numbers can reduce fps) 

    :type: int
    '''

    use_edit_position: bool = None
    '''The modifier affects the position of the point 

    :type: bool
    '''

    use_edit_strength: bool = None
    '''The modifier affects the color strength of the point 

    :type: bool
    '''

    use_edit_thickness: bool = None
    '''The modifier affects the thickness of the point 

    :type: bool
    '''

    use_edit_uv: bool = None
    '''The modifier affects the UV rotation factor of the point 

    :type: bool
    '''

    vertex_group: str = None
    '''Vertex group name for modulating the deform 

    :type: str
    '''


class SubdivGpencilModifier(GpencilModifier, bpy_struct):
    '''Subdivide Stroke modifier '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    level: int = None
    '''Number of subdivisions 

    :type: int
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    simple: bool = None
    '''The modifier only add control points 

    :type: bool
    '''


class ThickGpencilModifier(GpencilModifier, bpy_struct):
    '''Subdivide and Smooth Stroke modifier '''

    curve: 'CurveMapping' = None
    '''Custom Thickness Curve 

    :type: 'CurveMapping'
    '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_vertex: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    normalize_thickness: bool = None
    '''Normalize the full stroke to modifier thickness 

    :type: bool
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''

    thickness: int = None
    '''Factor of thickness change 

    :type: int
    '''

    use_custom_curve: bool = None
    '''Use a custom curve to define thickness changes 

    :type: bool
    '''

    vertex_group: str = None
    '''Vertex group name for modulating the deform 

    :type: str
    '''


class TimeGpencilModifier(GpencilModifier, bpy_struct):
    '''Time offset modifier '''

    frame_end: int = None
    '''Final frame of the range 

    :type: int
    '''

    frame_scale: float = None
    '''Evaluation time in seconds 

    :type: float
    '''

    frame_start: int = None
    '''First frame of the range 

    :type: int
    '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    offset: int = None
    '''Number of frames to offset original keyframe number or frame to fix 

    :type: int
    '''

    use_custom_frame_range: bool = None
    '''Define a custom range of frames to use in modifier 

    :type: bool
    '''

    use_keep_loop: bool = None
    '''Retiming end frames and move to start of animation to keep loop 

    :type: bool
    '''


class TintGpencilModifier(GpencilModifier, bpy_struct):
    '''Tint Stroke Color modifier '''

    color: typing.List[float] = None
    '''Color used for tinting 

    :type: typing.List[float]
    '''

    create_materials: bool = None
    '''When apply modifier, create new material 

    :type: bool
    '''

    factor: float = None
    '''Factor for mixing color 

    :type: float
    '''

    invert_layer_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_layers: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_material_pass: bool = None
    '''Inverse filter 

    :type: bool
    '''

    invert_materials: bool = None
    '''Inverse filter 

    :type: bool
    '''

    layer: str = None
    '''Layer name 

    :type: str
    '''

    layer_pass: int = None
    '''Layer pass index 

    :type: int
    '''

    material: str = None
    '''Material name 

    :type: str
    '''

    modify_color: typing.Union[str, int] = None
    '''Set what colors of the stroke are affected 

    :type: typing.Union[str, int]
    '''

    pass_index: int = None
    '''Pass index 

    :type: int
    '''


class Action(ID, bpy_struct):
    '''A collection of F-Curves for animation '''

    fcurves: typing.Union[typing.List['FCurve'], 'bpy_prop_collection',
                          'ActionFCurves'] = None
    '''The individual F-Curves that make up the action 

    :type: typing.Union[typing.List['FCurve'], 'bpy_prop_collection', 'ActionFCurves']
    '''

    frame_range: typing.List[float] = None
    '''The final frame range of all F-Curves within this action 

    :type: typing.List[float]
    '''

    groups: typing.Union[typing.List['ActionGroup'], 'bpy_prop_collection',
                         'ActionGroups'] = None
    '''Convenient groupings of F-Curves 

    :type: typing.Union[typing.List['ActionGroup'], 'bpy_prop_collection', 'ActionGroups']
    '''

    id_root: typing.Union[str, int] = None
    '''Type of ID block that action can be used on - DO NOT CHANGE UNLESS YOU KNOW WHAT YOU ARE DOING 

    :type: typing.Union[str, int]
    '''

    pose_markers: typing.Union[typing.
                               List['TimelineMarker'], 'bpy_prop_collection',
                               'ActionPoseMarkers'] = None
    '''Markers specific to this action, for labeling poses 

    :type: typing.Union[typing.List['TimelineMarker'], 'bpy_prop_collection', 'ActionPoseMarkers']
    '''


class Armature(ID, bpy_struct):
    '''Armature data-block containing a hierarchy of bones, usually used for rigging characters '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    bones: typing.Union[typing.List['Bone'], 'bpy_prop_collection',
                        'ArmatureBones'] = None
    '''

    :type: typing.Union[typing.List['Bone'], 'bpy_prop_collection', 'ArmatureBones']
    '''

    display_type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    edit_bones: typing.Union[typing.List['EditBone'], 'bpy_prop_collection',
                             'ArmatureEditBones'] = None
    '''

    :type: typing.Union[typing.List['EditBone'], 'bpy_prop_collection', 'ArmatureEditBones']
    '''

    is_editmode: bool = None
    '''True when used in editmode 

    :type: bool
    '''

    layers: typing.List[bool] = None
    '''Armature layer visibility 

    :type: typing.List[bool]
    '''

    layers_protected: typing.List[bool] = None
    '''Protected layers in Proxy Instances are restored to Proxy settings on file reload and undo 

    :type: typing.List[bool]
    '''

    pose_position: typing.Union[str, int] = None
    '''Show armature in binding pose or final posed state 

    :type: typing.Union[str, int]
    '''

    show_axes: bool = None
    '''Display bone axes 

    :type: bool
    '''

    show_bone_custom_shapes: bool = None
    '''Display bones with their custom shapes 

    :type: bool
    '''

    show_group_colors: bool = None
    '''Display bone group colors 

    :type: bool
    '''

    show_names: bool = None
    '''Display bone names 

    :type: bool
    '''

    use_mirror_x: bool = None
    '''Apply changes to matching bone on opposite side of X-Axis 

    :type: bool
    '''

    def transform(self, matrix: typing.List[float]):
        '''Transform armature bones by a matrix 

        :param matrix: Matrix 
        :type matrix: typing.List[float]
        '''
        pass


class Brush(ID, bpy_struct):
    '''Brush data-block for storing brush settings for painting and sculpting '''

    auto_smooth_factor: float = None
    '''Amount of smoothing to automatically apply to each stroke 

    :type: float
    '''

    blend: typing.Union[str, int] = None
    '''Brush blending mode 

    :type: typing.Union[str, int]
    '''

    blur_kernel_radius: int = None
    '''Radius of kernel used for soften and sharpen in pixels 

    :type: int
    '''

    blur_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    brush_capabilities: 'BrushCapabilities' = None
    '''Brush’s capabilities 

    :type: 'BrushCapabilities'
    '''

    clone_alpha: float = None
    '''Opacity of clone image display 

    :type: float
    '''

    clone_image: 'Image' = None
    '''Image for clone tool 

    :type: 'Image'
    '''

    clone_offset: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    color: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    color_type: typing.Union[str, int] = None
    '''Use single color or gradient when painting 

    :type: typing.Union[str, int]
    '''

    crease_pinch_factor: float = None
    '''How much the crease brush pinches 

    :type: float
    '''

    cursor_color_add: typing.List[float] = None
    '''Color of cursor when adding 

    :type: typing.List[float]
    '''

    cursor_color_subtract: typing.List[float] = None
    '''Color of cursor when subtracting 

    :type: typing.List[float]
    '''

    cursor_overlay_alpha: int = None
    '''

    :type: int
    '''

    curve: 'CurveMapping' = None
    '''Editable falloff curve 

    :type: 'CurveMapping'
    '''

    curve_preset: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    dash_ratio: float = None
    '''Ratio of samples in a cycle that the brush is enabled 

    :type: float
    '''

    dash_samples: int = None
    '''Length of a dash cycle measured in stroke samples 

    :type: int
    '''

    direction: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    elastic_deform_type: typing.Union[str, int] = None
    '''Deformation type that is used in the brush 

    :type: typing.Union[str, int]
    '''

    elastic_deform_volume_preservation: float = None
    '''Poisson ratio for elastic deformation. Higher values preserve volume more, but also lead to more bulging 

    :type: float
    '''

    falloff_angle: float = None
    '''Paint most on faces pointing towards the view according to this angle 

    :type: float
    '''

    falloff_shape: typing.Union[str, int] = None
    '''Use projected or spherical falloff 

    :type: typing.Union[str, int]
    '''

    fill_threshold: float = None
    '''Threshold above which filling is not propagated 

    :type: float
    '''

    gpencil_settings: 'BrushGpencilSettings' = None
    '''

    :type: 'BrushGpencilSettings'
    '''

    gpencil_tool: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    grad_spacing: int = None
    '''Spacing before brush gradient goes full circle 

    :type: int
    '''

    gradient: 'ColorRamp' = None
    '''

    :type: 'ColorRamp'
    '''

    gradient_fill_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    gradient_stroke_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    height: float = None
    '''Affectable height of brush (layer height for layer tool, i.e.) 

    :type: float
    '''

    icon_filepath: str = None
    '''File path to brush icon 

    :type: str
    '''

    image_paint_capabilities: 'BrushCapabilitiesImagePaint' = None
    '''

    :type: 'BrushCapabilitiesImagePaint'
    '''

    image_tool: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    invert_to_scrape_fill: bool = None
    '''Use Scrape or Fill tool when inverting this brush instead of inverting its displacement direction 

    :type: bool
    '''

    jitter: float = None
    '''Jitter the position of the brush while painting 

    :type: float
    '''

    jitter_absolute: int = None
    '''Jitter the position of the brush in pixels while painting 

    :type: int
    '''

    jitter_unit: typing.Union[str, int] = None
    '''Jitter in screen space or relative to brush size 

    :type: typing.Union[str, int]
    '''

    mask_overlay_alpha: int = None
    '''

    :type: int
    '''

    mask_stencil_dimension: typing.List[float] = None
    '''Dimensions of mask stencil in viewport 

    :type: typing.List[float]
    '''

    mask_stencil_pos: typing.List[float] = None
    '''Position of mask stencil in viewport 

    :type: typing.List[float]
    '''

    mask_texture: 'Texture' = None
    '''

    :type: 'Texture'
    '''

    mask_texture_slot: 'BrushTextureSlot' = None
    '''

    :type: 'BrushTextureSlot'
    '''

    mask_tool: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    multiplane_scrape_angle: float = None
    '''Angle between the planes of the crease 

    :type: float
    '''

    normal_radius_factor: float = None
    '''Ratio between the brush radius and the radius that is going to be used to sample the normal 

    :type: float
    '''

    normal_weight: float = None
    '''How much grab will pull vertexes out of surface during a grab 

    :type: float
    '''

    paint_curve: 'PaintCurve' = None
    '''Active Paint Curve 

    :type: 'PaintCurve'
    '''

    plane_offset: float = None
    '''Adjust plane on which the brush acts towards or away from the object surface 

    :type: float
    '''

    plane_trim: float = None
    '''If a vertex is further away from offset plane than this, then it is not affected 

    :type: float
    '''

    pose_ik_segments: int = None
    '''Number of segments of the inverse kinematics chain that will deform the mesh 

    :type: int
    '''

    pose_offset: float = None
    '''Offset of the pose origin in relation to the brush radius 

    :type: float
    '''

    pose_smooth_iterations: int = None
    '''Smooth iterations applied after calculating the pose factor of each vertex 

    :type: int
    '''

    rake_factor: float = None
    '''How much grab will follow cursor rotation 

    :type: float
    '''

    rate: float = None
    '''Interval between paints for Airbrush 

    :type: float
    '''

    sculpt_capabilities: 'BrushCapabilitiesSculpt' = None
    '''

    :type: 'BrushCapabilitiesSculpt'
    '''

    sculpt_plane: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    sculpt_tool: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    secondary_color: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    sharp_threshold: float = None
    '''Threshold below which, no sharpening is done 

    :type: float
    '''

    show_multiplane_scrape_planes_preview: bool = None
    '''Preview the scrape planes in the cursor during the stroke 

    :type: bool
    '''

    size: int = None
    '''Radius of the brush in pixels 

    :type: int
    '''

    smooth_stroke_factor: float = None
    '''Higher values give a smoother stroke 

    :type: float
    '''

    smooth_stroke_radius: int = None
    '''Minimum distance from last point before stroke continues 

    :type: int
    '''

    spacing: int = None
    '''Spacing between brush daubs as a percentage of brush diameter 

    :type: int
    '''

    stencil_dimension: typing.List[float] = None
    '''Dimensions of stencil in viewport 

    :type: typing.List[float]
    '''

    stencil_pos: typing.List[float] = None
    '''Position of stencil in viewport 

    :type: typing.List[float]
    '''

    strength: float = None
    '''How powerful the effect of the brush is when applied 

    :type: float
    '''

    stroke_method: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    texture: 'Texture' = None
    '''

    :type: 'Texture'
    '''

    texture_overlay_alpha: int = None
    '''

    :type: int
    '''

    texture_sample_bias: float = None
    '''Value added to texture samples 

    :type: float
    '''

    texture_slot: 'BrushTextureSlot' = None
    '''

    :type: 'BrushTextureSlot'
    '''

    topology_rake_factor: float = None
    '''Automatically align edges to the brush direction to generate cleaner topology and define sharp features. Best used on low-poly meshes as it has a performance impact 

    :type: float
    '''

    unprojected_radius: float = None
    '''Radius of brush in Blender units 

    :type: float
    '''

    use_accumulate: bool = None
    '''Accumulate stroke daubs on top of each other 

    :type: bool
    '''

    use_adaptive_space: bool = None
    '''Space daubs according to surface orientation instead of screen space 

    :type: bool
    '''

    use_airbrush: bool = None
    '''Keep applying paint effect while holding mouse (spray) 

    :type: bool
    '''

    use_alpha: bool = None
    '''When this is disabled, lock alpha while painting 

    :type: bool
    '''

    use_anchor: bool = None
    '''Keep the brush anchored to the initial location 

    :type: bool
    '''

    use_automasking_topology: bool = None
    '''Affect only vertices connected to the active vertex under the brush 

    :type: bool
    '''

    use_cursor_overlay: bool = None
    '''Show cursor in viewport 

    :type: bool
    '''

    use_cursor_overlay_override: bool = None
    '''Don’t show overlay during a stroke 

    :type: bool
    '''

    use_curve: bool = None
    '''Define the stroke curve with a bezier curve. Dabs are separated according to spacing 

    :type: bool
    '''

    use_custom_icon: bool = None
    '''Set the brush icon from an image file 

    :type: bool
    '''

    use_edge_to_edge: bool = None
    '''Drag anchor brush from edge-to-edge 

    :type: bool
    '''

    use_frontface: bool = None
    '''Brush only affects vertexes that face the viewer 

    :type: bool
    '''

    use_frontface_falloff: bool = None
    '''Blend brush influence by how much they face the front 

    :type: bool
    '''

    use_grab_active_vertex: bool = None
    '''Apply the maximum grab strength to the active vertex instead of the cursor location 

    :type: bool
    '''

    use_inverse_smooth_pressure: bool = None
    '''Lighter pressure causes more smoothing to be applied 

    :type: bool
    '''

    use_line: bool = None
    '''Draw a line with dabs separated according to spacing 

    :type: bool
    '''

    use_locked_size: typing.Union[str, int] = None
    '''Measure brush size relative to the view or the scene 

    :type: typing.Union[str, int]
    '''

    use_multiplane_scrape_dynamic: bool = None
    '''The angle between the planes changes during the stroke to fit the surface under the cursor 

    :type: bool
    '''

    use_offset_pressure: bool = None
    '''Enable tablet pressure sensitivity for offset 

    :type: bool
    '''

    use_original_normal: bool = None
    '''When locked keep using normal of surface where stroke was initiated 

    :type: bool
    '''

    use_original_plane: bool = None
    '''When locked keep using the plane origin of surface where stroke was initiated 

    :type: bool
    '''

    use_paint_antialiasing: bool = None
    '''Smooths the edges of the strokes 

    :type: bool
    '''

    use_paint_grease_pencil: bool = None
    '''Use this brush in grease pencil drawing mode 

    :type: bool
    '''

    use_paint_image: bool = None
    '''Use this brush in texture paint mode 

    :type: bool
    '''

    use_paint_sculpt: bool = None
    '''Use this brush in sculpt mode 

    :type: bool
    '''

    use_paint_uv_sculpt: bool = None
    '''Use this brush in UV sculpt mode 

    :type: bool
    '''

    use_paint_vertex: bool = None
    '''Use this brush in vertex paint mode 

    :type: bool
    '''

    use_paint_weight: bool = None
    '''Use this brush in weight paint mode 

    :type: bool
    '''

    use_persistent: bool = None
    '''Sculpt on a persistent layer of the mesh 

    :type: bool
    '''

    use_plane_trim: bool = None
    '''Enable Plane Trim 

    :type: bool
    '''

    use_pressure_jitter: bool = None
    '''Enable tablet pressure sensitivity for jitter 

    :type: bool
    '''

    use_pressure_masking: typing.Union[str, int] = None
    '''Pen pressure makes texture influence smaller 

    :type: typing.Union[str, int]
    '''

    use_pressure_size: bool = None
    '''Enable tablet pressure sensitivity for size 

    :type: bool
    '''

    use_pressure_spacing: bool = None
    '''Enable tablet pressure sensitivity for spacing 

    :type: bool
    '''

    use_pressure_strength: bool = None
    '''Enable tablet pressure sensitivity for strength 

    :type: bool
    '''

    use_primary_overlay: bool = None
    '''Show texture in viewport 

    :type: bool
    '''

    use_primary_overlay_override: bool = None
    '''Don’t show overlay during a stroke 

    :type: bool
    '''

    use_restore_mesh: bool = None
    '''Allow a single dot to be carefully positioned 

    :type: bool
    '''

    use_scene_spacing: typing.Union[str, int] = None
    '''Calculate the brush spacing using view or scene distance 

    :type: typing.Union[str, int]
    '''

    use_secondary_overlay: bool = None
    '''Show texture in viewport 

    :type: bool
    '''

    use_secondary_overlay_override: bool = None
    '''Don’t show overlay during a stroke 

    :type: bool
    '''

    use_smooth_stroke: bool = None
    '''Brush lags behind mouse and follows a smoother path 

    :type: bool
    '''

    use_space: bool = None
    '''Limit brush application to the distance specified by spacing 

    :type: bool
    '''

    use_space_attenuation: bool = None
    '''Automatically adjust strength to give consistent results for different spacings 

    :type: bool
    '''

    uv_sculpt_tool: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    vertex_paint_capabilities: 'BrushCapabilitiesVertexPaint' = None
    '''

    :type: 'BrushCapabilitiesVertexPaint'
    '''

    vertex_tool: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    weight: float = None
    '''Vertex weight when brush is applied 

    :type: float
    '''

    weight_paint_capabilities: 'BrushCapabilitiesWeightPaint' = None
    '''

    :type: 'BrushCapabilitiesWeightPaint'
    '''

    weight_tool: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''


class CacheFile(ID, bpy_struct):
    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    filepath: str = None
    '''Path to external displacements file 

    :type: str
    '''

    forward_axis: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    frame: float = None
    '''The time to use for looking up the data in the cache file, or to determine which file to use in a file sequence 

    :type: float
    '''

    frame_offset: float = None
    '''Subtracted from the current frame to use for looking up the data in the cache file, or to determine which file to use in a file sequence 

    :type: float
    '''

    is_sequence: bool = None
    '''Whether the cache is separated in a series of files 

    :type: bool
    '''

    object_paths: typing.Union[typing.List['AlembicObjectPath'],
                               'bpy_prop_collection',
                               'AlembicObjectPaths'] = None
    '''Paths of the objects inside the Alembic archive 

    :type: typing.Union[typing.List['AlembicObjectPath'], 'bpy_prop_collection', 'AlembicObjectPaths']
    '''

    override_frame: bool = None
    '''Whether to use a custom frame for looking up data in the cache file, instead of using the current scene frame 

    :type: bool
    '''

    scale: float = None
    '''Value by which to enlarge or shrink the object with respect to the world’s origin (only applicable through a Transform Cache constraint) 

    :type: float
    '''

    up_axis: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''


class Camera(ID, bpy_struct):
    '''Camera data-block for storing camera settings '''

    angle: float = None
    '''Camera lens field of view 

    :type: float
    '''

    angle_x: float = None
    '''Camera lens horizontal field of view 

    :type: float
    '''

    angle_y: float = None
    '''Camera lens vertical field of view 

    :type: float
    '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    background_images: typing.Union[typing.List['CameraBackgroundImage'],
                                    'bpy_prop_collection',
                                    'CameraBackgroundImages'] = None
    '''List of background images 

    :type: typing.Union[typing.List['CameraBackgroundImage'], 'bpy_prop_collection', 'CameraBackgroundImages']
    '''

    clip_end: float = None
    '''Camera far clipping distance 

    :type: float
    '''

    clip_start: float = None
    '''Camera near clipping distance 

    :type: float
    '''

    cycles = None
    '''Cycles camera settings '''

    display_size: float = None
    '''Apparent size of the Camera object in the 3D View 

    :type: float
    '''

    dof: 'CameraDOFSettings' = None
    '''

    :type: 'CameraDOFSettings'
    '''

    lens: float = None
    '''Perspective Camera lens value in millimeters 

    :type: float
    '''

    lens_unit: typing.Union[str, int] = None
    '''Unit to edit lens in for the user interface 

    :type: typing.Union[str, int]
    '''

    ortho_scale: float = None
    '''Orthographic Camera scale (similar to zoom) 

    :type: float
    '''

    passepartout_alpha: float = None
    '''Opacity (alpha) of the darkened overlay in Camera view 

    :type: float
    '''

    sensor_fit: typing.Union[str, int] = None
    '''Method to fit image and field of view angle inside the sensor 

    :type: typing.Union[str, int]
    '''

    sensor_height: float = None
    '''Vertical size of the image sensor area in millimeters 

    :type: float
    '''

    sensor_width: float = None
    '''Horizontal size of the image sensor area in millimeters 

    :type: float
    '''

    shift_x: float = None
    '''Camera horizontal shift 

    :type: float
    '''

    shift_y: float = None
    '''Camera vertical shift 

    :type: float
    '''

    show_background_images: bool = None
    '''Display reference images behind objects in the 3D View 

    :type: bool
    '''

    show_composition_center: bool = None
    '''Display center composition guide inside the camera view 

    :type: bool
    '''

    show_composition_center_diagonal: bool = None
    '''Display diagonal center composition guide inside the camera view 

    :type: bool
    '''

    show_composition_golden: bool = None
    '''Display golden ratio composition guide inside the camera view 

    :type: bool
    '''

    show_composition_golden_tria_a: bool = None
    '''Display golden triangle A composition guide inside the camera view 

    :type: bool
    '''

    show_composition_golden_tria_b: bool = None
    '''Display golden triangle B composition guide inside the camera view 

    :type: bool
    '''

    show_composition_harmony_tri_a: bool = None
    '''Display harmony A composition guide inside the camera view 

    :type: bool
    '''

    show_composition_harmony_tri_b: bool = None
    '''Display harmony B composition guide inside the camera view 

    :type: bool
    '''

    show_composition_thirds: bool = None
    '''Display rule of thirds composition guide inside the camera view 

    :type: bool
    '''

    show_limits: bool = None
    '''Display the clipping range and focus point on the camera 

    :type: bool
    '''

    show_mist: bool = None
    '''Display a line from the Camera to indicate the mist area 

    :type: bool
    '''

    show_name: bool = None
    '''Show the active Camera’s name in Camera view 

    :type: bool
    '''

    show_passepartout: bool = None
    '''Show a darkened overlay outside the image area in Camera view 

    :type: bool
    '''

    show_safe_areas: bool = None
    '''Show TV title safe and action safe areas in Camera view 

    :type: bool
    '''

    show_safe_center: bool = None
    '''Show safe areas to fit content in a different aspect ratio 

    :type: bool
    '''

    show_sensor: bool = None
    '''Show sensor size (film gate) in Camera view 

    :type: bool
    '''

    stereo: 'CameraStereoData' = None
    '''

    :type: 'CameraStereoData'
    '''

    type: typing.Union[str, int] = None
    '''Camera types 

    :type: typing.Union[str, int]
    '''

    def view_frame(self, scene: 'Scene' = None):
        '''Return 4 points for the cameras frame (before object transformation) 

        :param scene: Scene to use for aspect calculation, when omitted 1:1 aspect is used 
        :type scene: 'Scene'
        '''
        pass


class Collection(ID, bpy_struct):
    '''Collection of Object data-blocks '''

    all_objects: typing.Union[typing.
                              List['Object'], 'bpy_prop_collection'] = None
    '''Objects that are in this collection and its child collections 

    :type: typing.Union[typing.List['Object'], 'bpy_prop_collection']
    '''

    children: typing.Union[typing.List['Collection'], 'bpy_prop_collection',
                           'CollectionChildren'] = None
    '''Collections that are immediate children of this collection 

    :type: typing.Union[typing.List['Collection'], 'bpy_prop_collection', 'CollectionChildren']
    '''

    hide_render: bool = None
    '''Globally disable in renders 

    :type: bool
    '''

    hide_select: bool = None
    '''Disable selection in viewport 

    :type: bool
    '''

    hide_viewport: bool = None
    '''Globally disable in viewports 

    :type: bool
    '''

    instance_offset: typing.List[float] = None
    '''Offset from the origin to use when instancing 

    :type: typing.List[float]
    '''

    objects: typing.Union[typing.List['Object'], 'bpy_prop_collection',
                          'CollectionObjects'] = None
    '''Objects that are directly in this collection 

    :type: typing.Union[typing.List['Object'], 'bpy_prop_collection', 'CollectionObjects']
    '''

    users_dupli_group = None
    '''The collection instance objects this collection is used in (readonly) '''


class Curve(ID, bpy_struct):
    '''Curve data-block storing curves, splines and NURBS '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    bevel_depth: float = None
    '''Bevel depth when not using a bevel object 

    :type: float
    '''

    bevel_factor_end: float = None
    '''Factor that defines to where beveling of spline happens (0=to the very beginning, 1=to the very end) 

    :type: float
    '''

    bevel_factor_mapping_end: typing.Union[str, int] = None
    '''Determines how the end bevel factor is mapped to a spline 

    :type: typing.Union[str, int]
    '''

    bevel_factor_mapping_start: typing.Union[str, int] = None
    '''Determines how the start bevel factor is mapped to a spline 

    :type: typing.Union[str, int]
    '''

    bevel_factor_start: float = None
    '''Factor that defines from where beveling of spline happens (0=from the very beginning, 1=from the very end) 

    :type: float
    '''

    bevel_object: 'Object' = None
    '''Curve object name that defines the bevel shape 

    :type: 'Object'
    '''

    bevel_resolution: int = None
    '''Bevel resolution when depth is non-zero and no specific bevel object has been defined 

    :type: int
    '''

    cycles = None
    '''Cycles mesh settings '''

    dimensions: typing.Union[str, int] = None
    '''Select 2D or 3D curve type 

    :type: typing.Union[str, int]
    '''

    eval_time: float = None
    '''Parametric position along the length of the curve that Objects ‘following’ it should be at (position is evaluated by dividing by the ‘Path Length’ value) 

    :type: float
    '''

    extrude: float = None
    '''Amount of curve extrusion when not using a bevel object 

    :type: float
    '''

    fill_mode: typing.Union[str, int] = None
    '''Mode of filling curve 

    :type: typing.Union[str, int]
    '''

    is_editmode: bool = None
    '''True when used in editmode 

    :type: bool
    '''

    materials: typing.Union[typing.List['Material'], 'bpy_prop_collection',
                            'IDMaterials'] = None
    '''

    :type: typing.Union[typing.List['Material'], 'bpy_prop_collection', 'IDMaterials']
    '''

    offset: float = None
    '''Offset the curve to adjust the width of a text 

    :type: float
    '''

    path_duration: int = None
    '''The number of frames that are needed to traverse the path, defining the maximum value for the ‘Evaluation Time’ setting 

    :type: int
    '''

    render_resolution_u: int = None
    '''Surface resolution in U direction used while rendering (zero uses preview resolution) 

    :type: int
    '''

    render_resolution_v: int = None
    '''Surface resolution in V direction used while rendering (zero uses preview resolution) 

    :type: int
    '''

    resolution_u: int = None
    '''Surface resolution in U direction 

    :type: int
    '''

    resolution_v: int = None
    '''Surface resolution in V direction 

    :type: int
    '''

    shape_keys: 'Key' = None
    '''

    :type: 'Key'
    '''

    splines: typing.Union[typing.List['Spline'], 'bpy_prop_collection',
                          'CurveSplines'] = None
    '''Collection of splines in this curve data object 

    :type: typing.Union[typing.List['Spline'], 'bpy_prop_collection', 'CurveSplines']
    '''

    taper_object: 'Object' = None
    '''Curve object name that defines the taper (width) 

    :type: 'Object'
    '''

    texspace_location: typing.List[float] = None
    '''Texture space location 

    :type: typing.List[float]
    '''

    texspace_size: typing.List[float] = None
    '''Texture space size 

    :type: typing.List[float]
    '''

    twist_mode: typing.Union[str, int] = None
    '''The type of tilt calculation for 3D Curves 

    :type: typing.Union[str, int]
    '''

    twist_smooth: float = None
    '''Smoothing iteration for tangents 

    :type: float
    '''

    use_auto_texspace: bool = None
    '''Adjust active object’s texture space automatically when transforming object 

    :type: bool
    '''

    use_deform_bounds: bool = None
    '''Option for curve-deform: Use the mesh bounds to clamp the deformation 

    :type: bool
    '''

    use_fill_caps: bool = None
    '''Fill caps for beveled curves 

    :type: bool
    '''

    use_fill_deform: bool = None
    '''Fill curve after applying shape keys and all modifiers 

    :type: bool
    '''

    use_map_taper: bool = None
    '''Map effect of the taper object to the beveled part of the curve 

    :type: bool
    '''

    use_path: bool = None
    '''Enable the curve to become a translation path 

    :type: bool
    '''

    use_path_follow: bool = None
    '''Make curve path children to rotate along the path 

    :type: bool
    '''

    use_radius: bool = None
    '''Option for paths and curve-deform: apply the curve radius with path following it and deforming 

    :type: bool
    '''

    use_stretch: bool = None
    '''Option for curve-deform: make deformed child to stretch along entire path 

    :type: bool
    '''

    def transform(self, matrix: typing.List[float], shape_keys: bool = False):
        '''Transform curve by a matrix 

        :param matrix: Matrix 
        :type matrix: typing.List[float]
        :param shape_keys: Transform Shape Keys 
        :type shape_keys: bool
        '''
        pass

    def validate_material_indices(self, ) -> bool:
        '''Validate material indices of splines or letters, return True when the curve has had invalid indices corrected (to default 0) 

        :rtype: bool
        :return:  Result 
        '''
        pass

    def update_gpu_tag(self, ):
        '''update_gpu_tag 

        '''
        pass


class FreestyleLineStyle(ID, bpy_struct):
    '''Freestyle line style, reusable by multiple line sets '''

    active_texture: 'Texture' = None
    '''Active texture slot being displayed 

    :type: 'Texture'
    '''

    active_texture_index: int = None
    '''Index of active texture slot 

    :type: int
    '''

    alpha: float = None
    '''Base alpha transparency, possibly modified by alpha transparency modifiers 

    :type: float
    '''

    alpha_modifiers: typing.Union[typing.List['LineStyleAlphaModifier'],
                                  'bpy_prop_collection',
                                  'LineStyleAlphaModifiers'] = None
    '''List of alpha transparency modifiers 

    :type: typing.Union[typing.List['LineStyleAlphaModifier'], 'bpy_prop_collection', 'LineStyleAlphaModifiers']
    '''

    angle_max: float = None
    '''Maximum 2D angle for splitting chains 

    :type: float
    '''

    angle_min: float = None
    '''Minimum 2D angle for splitting chains 

    :type: float
    '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    caps: typing.Union[str, int] = None
    '''Select the shape of both ends of strokes 

    :type: typing.Union[str, int]
    '''

    chain_count: int = None
    '''Chain count for the selection of first N chains 

    :type: int
    '''

    chaining: typing.Union[str, int] = None
    '''Select the way how feature edges are jointed to form chains 

    :type: typing.Union[str, int]
    '''

    color: typing.List[float] = None
    '''Base line color, possibly modified by line color modifiers 

    :type: typing.List[float]
    '''

    color_modifiers: typing.Union[typing.List['LineStyleColorModifier'],
                                  'bpy_prop_collection',
                                  'LineStyleColorModifiers'] = None
    '''List of line color modifiers 

    :type: typing.Union[typing.List['LineStyleColorModifier'], 'bpy_prop_collection', 'LineStyleColorModifiers']
    '''

    dash1: int = None
    '''Length of the 1st dash for dashed lines 

    :type: int
    '''

    dash2: int = None
    '''Length of the 2nd dash for dashed lines 

    :type: int
    '''

    dash3: int = None
    '''Length of the 3rd dash for dashed lines 

    :type: int
    '''

    gap1: int = None
    '''Length of the 1st gap for dashed lines 

    :type: int
    '''

    gap2: int = None
    '''Length of the 2nd gap for dashed lines 

    :type: int
    '''

    gap3: int = None
    '''Length of the 3rd gap for dashed lines 

    :type: int
    '''

    geometry_modifiers: typing.Union[typing.List['LineStyleGeometryModifier'],
                                     'bpy_prop_collection',
                                     'LineStyleGeometryModifiers'] = None
    '''List of stroke geometry modifiers 

    :type: typing.Union[typing.List['LineStyleGeometryModifier'], 'bpy_prop_collection', 'LineStyleGeometryModifiers']
    '''

    integration_type: typing.Union[str, int] = None
    '''Select the way how the sort key is computed for each chain 

    :type: typing.Union[str, int]
    '''

    length_max: float = None
    '''Maximum curvilinear 2D length for the selection of chains 

    :type: float
    '''

    length_min: float = None
    '''Minimum curvilinear 2D length for the selection of chains 

    :type: float
    '''

    material_boundary: bool = None
    '''If true, chains of feature edges are split at material boundaries 

    :type: bool
    '''

    node_tree: 'NodeTree' = None
    '''Node tree for node-based shaders 

    :type: 'NodeTree'
    '''

    panel: typing.Union[str, int] = None
    '''Select the property panel to be shown 

    :type: typing.Union[str, int]
    '''

    rounds: int = None
    '''Number of rounds in a sketchy multiple touch 

    :type: int
    '''

    sort_key: typing.Union[str, int] = None
    '''Select the sort key to determine the stacking order of chains 

    :type: typing.Union[str, int]
    '''

    sort_order: typing.Union[str, int] = None
    '''Select the sort order 

    :type: typing.Union[str, int]
    '''

    split_dash1: int = None
    '''Length of the 1st dash for splitting 

    :type: int
    '''

    split_dash2: int = None
    '''Length of the 2nd dash for splitting 

    :type: int
    '''

    split_dash3: int = None
    '''Length of the 3rd dash for splitting 

    :type: int
    '''

    split_gap1: int = None
    '''Length of the 1st gap for splitting 

    :type: int
    '''

    split_gap2: int = None
    '''Length of the 2nd gap for splitting 

    :type: int
    '''

    split_gap3: int = None
    '''Length of the 3rd gap for splitting 

    :type: int
    '''

    split_length: float = None
    '''Curvilinear 2D length for chain splitting 

    :type: float
    '''

    texture_slots: typing.Union[typing.List['LineStyleTextureSlot'],
                                'bpy_prop_collection',
                                'LineStyleTextureSlots'] = None
    '''Texture slots defining the mapping and influence of textures 

    :type: typing.Union[typing.List['LineStyleTextureSlot'], 'bpy_prop_collection', 'LineStyleTextureSlots']
    '''

    texture_spacing: float = None
    '''Spacing for textures along stroke length 

    :type: float
    '''

    thickness: float = None
    '''Base line thickness, possibly modified by line thickness modifiers 

    :type: float
    '''

    thickness_modifiers: typing.Union[
        typing.List['LineStyleThicknessModifier'], 'bpy_prop_collection',
        'LineStyleThicknessModifiers'] = None
    '''List of line thickness modifiers 

    :type: typing.Union[typing.List['LineStyleThicknessModifier'], 'bpy_prop_collection', 'LineStyleThicknessModifiers']
    '''

    thickness_position: typing.Union[str, int] = None
    '''Thickness position of silhouettes and border edges (applicable when plain chaining is used with the Same Object option) 

    :type: typing.Union[str, int]
    '''

    thickness_ratio: float = None
    '''A number between 0 (inside) and 1 (outside) specifying the relative position of stroke thickness 

    :type: float
    '''

    use_angle_max: bool = None
    '''Split chains at points with angles larger than the maximum 2D angle 

    :type: bool
    '''

    use_angle_min: bool = None
    '''Split chains at points with angles smaller than the minimum 2D angle 

    :type: bool
    '''

    use_chain_count: bool = None
    '''Enable the selection of first N chains 

    :type: bool
    '''

    use_chaining: bool = None
    '''Enable chaining of feature edges 

    :type: bool
    '''

    use_dashed_line: bool = None
    '''Enable or disable dashed line 

    :type: bool
    '''

    use_length_max: bool = None
    '''Enable the selection of chains by a maximum 2D length 

    :type: bool
    '''

    use_length_min: bool = None
    '''Enable the selection of chains by a minimum 2D length 

    :type: bool
    '''

    use_nodes: bool = None
    '''Use shader nodes for the line style 

    :type: bool
    '''

    use_same_object: bool = None
    '''If true, only feature edges of the same object are joined 

    :type: bool
    '''

    use_sorting: bool = None
    '''Arrange the stacking order of strokes 

    :type: bool
    '''

    use_split_length: bool = None
    '''Enable chain splitting by curvilinear 2D length 

    :type: bool
    '''

    use_split_pattern: bool = None
    '''Enable chain splitting by dashed line patterns 

    :type: bool
    '''

    use_texture: bool = None
    '''Enable or disable textured strokes 

    :type: bool
    '''


class GreasePencil(ID, bpy_struct):
    '''Freehand annotation sketchbook '''

    after_color: typing.List[float] = None
    '''Base color for ghosts after the active frame 

    :type: typing.List[float]
    '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    before_color: typing.List[float] = None
    '''Base color for ghosts before the active frame 

    :type: typing.List[float]
    '''

    edit_line_color: typing.List[float] = None
    '''Color for editing line 

    :type: typing.List[float]
    '''

    ghost_after_range: int = None
    '''Maximum number of frames to show after current frame (0 = don’t show any frames after current) 

    :type: int
    '''

    ghost_before_range: int = None
    '''Maximum number of frames to show before current frame (0 = don’t show any frames before current) 

    :type: int
    '''

    grid: 'GreasePencilGrid' = None
    '''Settings for grid and canvas in the 3D viewport 

    :type: 'GreasePencilGrid'
    '''

    is_annotation: bool = None
    '''Current datablock is an annotation 

    :type: bool
    '''

    is_stroke_paint_mode: bool = None
    '''Draw Grease Pencil strokes on click/drag 

    :type: bool
    '''

    is_stroke_sculpt_mode: bool = None
    '''Sculpt Grease Pencil strokes instead of viewport data 

    :type: bool
    '''

    is_stroke_weight_mode: bool = None
    '''Grease Pencil weight paint 

    :type: bool
    '''

    layers: typing.Union[typing.List['GPencilLayer'], 'bpy_prop_collection',
                         'GreasePencilLayers'] = None
    '''

    :type: typing.Union[typing.List['GPencilLayer'], 'bpy_prop_collection', 'GreasePencilLayers']
    '''

    materials: typing.Union[typing.List['Material'], 'bpy_prop_collection',
                            'IDMaterials'] = None
    '''

    :type: typing.Union[typing.List['Material'], 'bpy_prop_collection', 'IDMaterials']
    '''

    onion_factor: float = None
    '''Change fade opacity of displayed onion frames 

    :type: float
    '''

    onion_keyframe_type: typing.Union[str, int] = None
    '''Type of keyframe (for filtering) 

    :type: typing.Union[str, int]
    '''

    onion_mode: typing.Union[str, int] = None
    '''Mode to display frames 

    :type: typing.Union[str, int]
    '''

    pixel_factor: float = None
    '''Scale conversion factor for pixel size (use larger values for thicker lines) 

    :type: float
    '''

    show_stroke_direction: bool = None
    '''Show stroke drawing direction with a bigger green dot (start) and smaller red dot (end) points 

    :type: bool
    '''

    stroke_depth_order: typing.Union[str, int] = None
    '''Defines how the strokes are ordered in 3D space 

    :type: typing.Union[str, int]
    '''

    stroke_thickness_space: typing.Union[str, int] = None
    '''Set stroke thickness in screen space or world space 

    :type: typing.Union[str, int]
    '''

    use_adaptive_uv: bool = None
    '''Automatic UVs are calculated depending of the stroke size 

    :type: bool
    '''

    use_autolock_layers: bool = None
    '''Lock automatically all layers except active one to avoid accidental changes 

    :type: bool
    '''

    use_force_fill_recalc: bool = None
    '''Force recalc of fill data after use deformation modifiers (reduce FPS) 

    :type: bool
    '''

    use_ghost_custom_colors: bool = None
    '''Use custom colors for ghost frames 

    :type: bool
    '''

    use_ghosts_always: bool = None
    '''Ghosts are shown in renders and animation playback. Useful for special effects (e.g. motion blur) 

    :type: bool
    '''

    use_multiedit: bool = None
    '''Edit strokes from multiple grease pencil keyframes at the same time (keyframes must be selected to be included) 

    :type: bool
    '''

    use_onion_fade: bool = None
    '''Display onion keyframes with a fade in color transparency 

    :type: bool
    '''

    use_onion_loop: bool = None
    '''Display first onion keyframes using next frame color to show indication of loop start frame 

    :type: bool
    '''

    use_onion_skinning: bool = None
    '''Show ghosts of the keyframes before and after the current frame 

    :type: bool
    '''

    use_stroke_edit_mode: bool = None
    '''Edit Grease Pencil strokes instead of viewport data 

    :type: bool
    '''

    zdepth_offset: float = None
    '''Offset amount when drawing in surface mode 

    :type: float
    '''

    def clear(self, ):
        '''Remove all the Grease Pencil data 

        '''
        pass


class Image(ID, bpy_struct):
    '''Image data-block referencing an external or packed image '''

    alpha_mode: typing.Union[str, int] = None
    '''Representation of alpha in the image file, to convert to and from when saving and loading the image 

    :type: typing.Union[str, int]
    '''

    bindcode: int = None
    '''OpenGL bindcode 

    :type: int
    '''

    channels: int = None
    '''Number of channels in pixels buffer 

    :type: int
    '''

    colorspace_settings: 'ColorManagedInputColorspaceSettings' = None
    '''Input color space settings 

    :type: 'ColorManagedInputColorspaceSettings'
    '''

    depth: int = None
    '''Image bit depth 

    :type: int
    '''

    display_aspect: typing.List[float] = None
    '''Display Aspect for this image, does not affect rendering 

    :type: typing.List[float]
    '''

    file_format: typing.Union[str, int] = None
    '''Format used for re-saving this file 

    :type: typing.Union[str, int]
    '''

    filepath: str = None
    '''Image/Movie file name 

    :type: str
    '''

    filepath_raw: str = None
    '''Image/Movie file name (without data refreshing) 

    :type: str
    '''

    frame_duration: int = None
    '''Duration (in frames) of the image (1 when not a video/sequence) 

    :type: int
    '''

    generated_color: typing.List[float] = None
    '''Fill color for the generated image 

    :type: typing.List[float]
    '''

    generated_height: int = None
    '''Generated image height 

    :type: int
    '''

    generated_type: typing.Union[str, int] = None
    '''Generated image type 

    :type: typing.Union[str, int]
    '''

    generated_width: int = None
    '''Generated image width 

    :type: int
    '''

    has_data: bool = None
    '''True if the image data is loaded into memory 

    :type: bool
    '''

    is_dirty: bool = None
    '''Image has changed and is not saved 

    :type: bool
    '''

    is_float: bool = None
    '''True if this image is stored in float buffer 

    :type: bool
    '''

    is_multiview: bool = None
    '''Image has more than one view 

    :type: bool
    '''

    is_stereo_3d: bool = None
    '''Image has left and right views 

    :type: bool
    '''

    packed_file: 'PackedFile' = None
    '''First packed file of the image 

    :type: 'PackedFile'
    '''

    packed_files: typing.Union[typing.List['ImagePackedFile'],
                               'bpy_prop_collection'] = None
    '''Collection of packed images 

    :type: typing.Union[typing.List['ImagePackedFile'], 'bpy_prop_collection']
    '''

    pixels: float = None
    '''Image pixels in floating point values 

    :type: float
    '''

    render_slots: typing.Union[typing.List['RenderSlot'],
                               'bpy_prop_collection', 'RenderSlots'] = None
    '''Render slots of the image 

    :type: typing.Union[typing.List['RenderSlot'], 'bpy_prop_collection', 'RenderSlots']
    '''

    resolution: typing.List[float] = None
    '''X/Y pixels per meter 

    :type: typing.List[float]
    '''

    size: typing.List[int] = None
    '''Width and height in pixels, zero when image data cant be loaded 

    :type: typing.List[int]
    '''

    source: typing.Union[str, int] = None
    '''Where the image comes from 

    :type: typing.Union[str, int]
    '''

    stereo_3d_format: 'Stereo3dFormat' = None
    '''Settings for stereo 3d 

    :type: 'Stereo3dFormat'
    '''

    tiles: typing.Union[typing.List['UDIMTile'], 'bpy_prop_collection',
                        'UDIMTiles'] = None
    '''Tiles of the image 

    :type: typing.Union[typing.List['UDIMTile'], 'bpy_prop_collection', 'UDIMTiles']
    '''

    type: typing.Union[str, int] = None
    '''How to generate the image 

    :type: typing.Union[str, int]
    '''

    use_deinterlace: bool = None
    '''Deinterlace movie file on load 

    :type: bool
    '''

    use_generated_float: bool = None
    '''Generate floating point buffer 

    :type: bool
    '''

    use_multiview: bool = None
    '''Use Multiple Views (when available) 

    :type: bool
    '''

    use_view_as_render: bool = None
    '''Apply render part of display transformation when displaying this image on the screen 

    :type: bool
    '''

    views_format: typing.Union[str, int] = None
    '''Mode to load image views 

    :type: typing.Union[str, int]
    '''

    def save_render(self, filepath: str, scene: 'Scene' = None):
        '''Save image to a specific path using a scenes render settings 

        :param filepath: Save path 
        :type filepath: str
        :param scene: Scene to take image parameters from 
        :type scene: 'Scene'
        '''
        pass

    def save(self, ):
        '''Save image to its source path 

        '''
        pass

    def pack(self, data: str = "", data_len: int = 0):
        '''Pack an image as embedded data into the .blend file 

        :param data: data, Raw data (bytes, exact content of the embedded file) 
        :type data: str
        :param data_len: data_len, length of given data (mandatory if data is provided) 
        :type data_len: int
        '''
        pass

    def unpack(self, method: typing.Union[str, int] = 'USE_LOCAL'):
        '''Save an image packed in the .blend file to disk 

        :param method: method, How to unpack 
        :type method: typing.Union[str, int]
        '''
        pass

    def reload(self, ):
        '''Reload the image from its source path 

        '''
        pass

    def update(self, ):
        '''Update the display image from the floating point buffer 

        '''
        pass

    def scale(self, width: int, height: int):
        '''Scale the image in pixels 

        :param width: Width 
        :type width: int
        :param height: Height 
        :type height: int
        '''
        pass

    def gl_touch(self, frame: int = 0) -> int:
        '''Delay the image from being cleaned from the cache due inactivity 

        :param frame: Frame, Frame of image sequence or movie 
        :type frame: int
        :rtype: int
        :return:  Error, OpenGL error value 
        '''
        pass

    def gl_load(self, frame: int = 0) -> int:
        '''Load the image into an OpenGL texture. On success, image.bindcode will contain the OpenGL texture bindcode. Colors read from the texture will be in scene linear color space and have premultiplied or straight alpha matching the image alpha mode 

        :param frame: Frame, Frame of image sequence or movie 
        :type frame: int
        :rtype: int
        :return:  Error, OpenGL error value 
        '''
        pass

    def gl_free(self, ):
        '''Free the image from OpenGL graphics memory 

        '''
        pass

    def filepath_from_user(self, image_user: 'ImageUser' = None) -> str:
        '''Return the absolute path to the filepath of an image frame specified by the image user 

        :param image_user: Image user of the image to get filepath for 
        :type image_user: 'ImageUser'
        :rtype: str
        :return:  File Path, The resulting filepath from the image and it’s user 
        '''
        pass

    def buffers_free(self, ):
        '''Free the image buffers from memory 

        '''
        pass


class Key(ID, bpy_struct):
    '''Shape keys data-block containing different shapes of geometric data-blocks '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    eval_time: float = None
    '''Evaluation time for absolute shape keys 

    :type: float
    '''

    key_blocks: typing.Union[typing.
                             List['ShapeKey'], 'bpy_prop_collection'] = None
    '''Shape keys 

    :type: typing.Union[typing.List['ShapeKey'], 'bpy_prop_collection']
    '''

    reference_key: 'ShapeKey' = None
    '''

    :type: 'ShapeKey'
    '''

    use_relative: bool = None
    '''Make shape keys relative, otherwise play through shapes as a sequence using the evaluation time 

    :type: bool
    '''

    user: 'ID' = None
    '''Data-block using these shape keys 

    :type: 'ID'
    '''


class Lattice(ID, bpy_struct):
    '''Lattice data-block defining a grid for deforming other objects '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    interpolation_type_u: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    interpolation_type_v: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    interpolation_type_w: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    is_editmode: bool = None
    '''True when used in editmode 

    :type: bool
    '''

    points: typing.Union[typing.
                         List['LatticePoint'], 'bpy_prop_collection'] = None
    '''Points of the lattice 

    :type: typing.Union[typing.List['LatticePoint'], 'bpy_prop_collection']
    '''

    points_u: int = None
    '''Point in U direction (can’t be changed when there are shape keys) 

    :type: int
    '''

    points_v: int = None
    '''Point in V direction (can’t be changed when there are shape keys) 

    :type: int
    '''

    points_w: int = None
    '''Point in W direction (can’t be changed when there are shape keys) 

    :type: int
    '''

    shape_keys: 'Key' = None
    '''

    :type: 'Key'
    '''

    use_outside: bool = None
    '''Only draw, and take into account, the outer vertices 

    :type: bool
    '''

    vertex_group: str = None
    '''Vertex group to apply the influence of the lattice 

    :type: str
    '''

    def transform(self, matrix: typing.List[float], shape_keys: bool = False):
        '''Transform lattice by a matrix 

        :param matrix: Matrix 
        :type matrix: typing.List[float]
        :param shape_keys: Transform Shape Keys 
        :type shape_keys: bool
        '''
        pass

    def update_gpu_tag(self, ):
        '''update_gpu_tag 

        '''
        pass


class Library(ID, bpy_struct):
    '''External .blend file from which data is linked '''

    filepath: str = None
    '''Path to the library .blend file 

    :type: str
    '''

    packed_file: 'PackedFile' = None
    '''

    :type: 'PackedFile'
    '''

    parent: 'Library' = None
    '''

    :type: 'Library'
    '''

    version: typing.List[int] = None
    '''Version of Blender the library .blend was saved with 

    :type: typing.List[int]
    '''

    users_id = None
    '''ID data blocks which use this library (readonly) '''

    def reload(self, ):
        '''Reload this library and all its linked data-blocks 

        '''
        pass


class Light(ID, bpy_struct):
    '''Light data-block for lighting a scene '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    color: typing.List[float] = None
    '''Light color 

    :type: typing.List[float]
    '''

    cutoff_distance: float = None
    '''Distance at which the light influence will be set to 0 

    :type: float
    '''

    cycles = None
    '''Cycles light settings '''

    distance: float = None
    '''Falloff distance - the light is at half the original intensity at this point 

    :type: float
    '''

    node_tree: 'NodeTree' = None
    '''Node tree for node based lights 

    :type: 'NodeTree'
    '''

    specular_factor: float = None
    '''Specular reflection multiplier 

    :type: float
    '''

    type: typing.Union[str, int] = None
    '''Type of Light 

    :type: typing.Union[str, int]
    '''

    use_custom_distance: bool = None
    '''Use custom attenuation distance instead of global light threshold 

    :type: bool
    '''

    use_nodes: bool = None
    '''Use shader nodes to render the light 

    :type: bool
    '''


class LightProbe(ID, bpy_struct):
    '''Light Probe data-block for lighting capture objects '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    clip_end: float = None
    '''Probe clip end, beyond which objects will not appear in reflections 

    :type: float
    '''

    clip_start: float = None
    '''Probe clip start, below which objects will not appear in reflections 

    :type: float
    '''

    falloff: float = None
    '''Control how fast the probe influence decreases 

    :type: float
    '''

    grid_resolution_x: int = None
    '''Number of sample along the x axis of the volume 

    :type: int
    '''

    grid_resolution_y: int = None
    '''Number of sample along the y axis of the volume 

    :type: int
    '''

    grid_resolution_z: int = None
    '''Number of sample along the z axis of the volume 

    :type: int
    '''

    influence_distance: float = None
    '''Influence distance of the probe 

    :type: float
    '''

    influence_type: typing.Union[str, int] = None
    '''Type of influence volume 

    :type: typing.Union[str, int]
    '''

    intensity: float = None
    '''Modify the intensity of the lighting captured by this probe 

    :type: float
    '''

    invert_visibility_collection: bool = None
    '''Invert visibility collection 

    :type: bool
    '''

    parallax_distance: float = None
    '''Lowest corner of the parallax bounding box 

    :type: float
    '''

    parallax_type: typing.Union[str, int] = None
    '''Type of parallax volume 

    :type: typing.Union[str, int]
    '''

    show_clip: bool = None
    '''Show the clipping distances in the 3D view 

    :type: bool
    '''

    show_data: bool = None
    '''Show captured lighting data into the 3D view for debugging purpose 

    :type: bool
    '''

    show_influence: bool = None
    '''Show the influence volume in the 3D view 

    :type: bool
    '''

    show_parallax: bool = None
    '''Show the parallax correction volume in the 3D view 

    :type: bool
    '''

    type: typing.Union[str, int] = None
    '''Type of light probe 

    :type: typing.Union[str, int]
    '''

    use_custom_parallax: bool = None
    '''Enable custom settings for the parallax correction volume 

    :type: bool
    '''

    visibility_bleed_bias: float = None
    '''Bias for reducing light-bleed on variance shadow maps 

    :type: float
    '''

    visibility_blur: float = None
    '''Filter size of the visibility blur 

    :type: float
    '''

    visibility_buffer_bias: float = None
    '''Bias for reducing self shadowing 

    :type: float
    '''

    visibility_collection: 'Collection' = None
    '''Restrict objects visible for this probe 

    :type: 'Collection'
    '''


class Mask(ID, bpy_struct):
    '''Mask data-block defining mask for compositing '''

    active_layer_index: int = None
    '''Index of active layer in list of all mask’s layers 

    :type: int
    '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    frame_end: int = None
    '''Final frame of the mask (used for sequencer) 

    :type: int
    '''

    frame_start: int = None
    '''First frame of the mask (used for sequencer) 

    :type: int
    '''

    layers: typing.Union[typing.List['MaskLayer'], 'bpy_prop_collection',
                         'MaskLayers'] = None
    '''Collection of layers which defines this mask 

    :type: typing.Union[typing.List['MaskLayer'], 'bpy_prop_collection', 'MaskLayers']
    '''


class Material(ID, bpy_struct):
    '''Material data-block to define the appearance of geometric objects for rendering '''

    alpha_threshold: float = None
    '''A pixel is rendered only if its alpha value is above this threshold 

    :type: float
    '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    blend_method: typing.Union[str, int] = None
    '''Blend Mode for Transparent Faces 

    :type: typing.Union[str, int]
    '''

    cycles = None
    '''Cycles material settings '''

    diffuse_color: typing.List[float] = None
    '''Diffuse color of the material 

    :type: typing.List[float]
    '''

    grease_pencil: 'MaterialGPencilStyle' = None
    '''Grease pencil color settings for material 

    :type: 'MaterialGPencilStyle'
    '''

    is_grease_pencil: bool = None
    '''True if this material has grease pencil data 

    :type: bool
    '''

    line_color: typing.List[float] = None
    '''Line color used for Freestyle line rendering 

    :type: typing.List[float]
    '''

    line_priority: int = None
    '''The line color of a higher priority is used at material boundaries 

    :type: int
    '''

    metallic: float = None
    '''Amount of mirror reflection for raytrace 

    :type: float
    '''

    node_tree: 'NodeTree' = None
    '''Node tree for node based materials 

    :type: 'NodeTree'
    '''

    paint_active_slot: int = None
    '''Index of active texture paint slot 

    :type: int
    '''

    paint_clone_slot: int = None
    '''Index of clone texture paint slot 

    :type: int
    '''

    pass_index: int = None
    '''Index number for the “Material Index” render pass 

    :type: int
    '''

    preview_render_type: typing.Union[str, int] = None
    '''Type of preview render 

    :type: typing.Union[str, int]
    '''

    refraction_depth: float = None
    '''Approximate the thickness of the object to compute two refraction event (0 is disabled) 

    :type: float
    '''

    roughness: float = None
    '''Roughness of the material 

    :type: float
    '''

    shadow_method: typing.Union[str, int] = None
    '''Shadow mapping method 

    :type: typing.Union[str, int]
    '''

    show_transparent_back: bool = None
    '''Limit transparency to a single layer (avoids transparency sorting problems) 

    :type: bool
    '''

    specular_color: typing.List[float] = None
    '''Specular color of the material 

    :type: typing.List[float]
    '''

    specular_intensity: float = None
    '''How intense (bright) the specular reflection is 

    :type: float
    '''

    texture_paint_images: typing.Union[typing.List['Image'],
                                       'bpy_prop_collection'] = None
    '''Texture images used for texture painting 

    :type: typing.Union[typing.List['Image'], 'bpy_prop_collection']
    '''

    texture_paint_slots: typing.Union[typing.List['TexPaintSlot'],
                                      'bpy_prop_collection'] = None
    '''Texture slots defining the mapping and influence of textures 

    :type: typing.Union[typing.List['TexPaintSlot'], 'bpy_prop_collection']
    '''

    use_backface_culling: bool = None
    '''Use back face culling to hide the back side of faces 

    :type: bool
    '''

    use_nodes: bool = None
    '''Use shader nodes to render the material 

    :type: bool
    '''

    use_preview_world: bool = None
    '''Use the current world background to light the preview render 

    :type: bool
    '''

    use_screen_refraction: bool = None
    '''Use raytraced screen space refractions 

    :type: bool
    '''

    use_sss_translucency: bool = None
    '''Add translucency effect to subsurface 

    :type: bool
    '''


class Mesh(ID, bpy_struct):
    '''Mesh data-block defining geometric surfaces '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    auto_smooth_angle: float = None
    '''Maximum angle between face normals that will be considered as smooth (unused if custom split normals data are available) 

    :type: float
    '''

    auto_texspace: bool = None
    '''Adjust active object’s texture space automatically when transforming object 

    :type: bool
    '''

    cycles = None
    '''Cycles mesh settings '''

    edges: typing.Union[typing.List['MeshEdge'], 'bpy_prop_collection',
                        'MeshEdges'] = None
    '''Edges of the mesh 

    :type: typing.Union[typing.List['MeshEdge'], 'bpy_prop_collection', 'MeshEdges']
    '''

    face_maps: typing.Union[typing.List['MeshFaceMapLayer'],
                            'bpy_prop_collection', 'MeshFaceMapLayers'] = None
    '''

    :type: typing.Union[typing.List['MeshFaceMapLayer'], 'bpy_prop_collection', 'MeshFaceMapLayers']
    '''

    has_custom_normals: bool = None
    '''True if there are custom split normals data in this mesh 

    :type: bool
    '''

    is_editmode: bool = None
    '''True when used in editmode 

    :type: bool
    '''

    loop_triangles: typing.Union[typing.List[
        'MeshLoopTriangle'], 'bpy_prop_collection', 'MeshLoopTriangle'] = None
    '''Tessellation of mesh polygons into triangles 

    :type: typing.Union[typing.List['MeshLoopTriangle'], 'bpy_prop_collection', 'MeshLoopTriangle']
    '''

    loops: typing.Union[typing.List['MeshLoop'], 'bpy_prop_collection',
                        'MeshLoops'] = None
    '''Loops of the mesh (polygon corners) 

    :type: typing.Union[typing.List['MeshLoop'], 'bpy_prop_collection', 'MeshLoops']
    '''

    materials: typing.Union[typing.List['Material'], 'bpy_prop_collection',
                            'IDMaterials'] = None
    '''

    :type: typing.Union[typing.List['Material'], 'bpy_prop_collection', 'IDMaterials']
    '''

    polygon_layers_float: typing.Union[
        typing.List['MeshPolygonFloatPropertyLayer'], 'bpy_prop_collection',
        'PolygonFloatProperties'] = None
    '''

    :type: typing.Union[typing.List['MeshPolygonFloatPropertyLayer'], 'bpy_prop_collection', 'PolygonFloatProperties']
    '''

    polygon_layers_int: typing.Union[
        typing.List['MeshPolygonIntPropertyLayer'], 'bpy_prop_collection',
        'PolygonIntProperties'] = None
    '''

    :type: typing.Union[typing.List['MeshPolygonIntPropertyLayer'], 'bpy_prop_collection', 'PolygonIntProperties']
    '''

    polygon_layers_string: typing.Union[
        typing.List['MeshPolygonStringPropertyLayer'], 'bpy_prop_collection',
        'PolygonStringProperties'] = None
    '''

    :type: typing.Union[typing.List['MeshPolygonStringPropertyLayer'], 'bpy_prop_collection', 'PolygonStringProperties']
    '''

    polygons: typing.Union[typing.List['MeshPolygon'], 'bpy_prop_collection',
                           'MeshPolygons'] = None
    '''Polygons of the mesh 

    :type: typing.Union[typing.List['MeshPolygon'], 'bpy_prop_collection', 'MeshPolygons']
    '''

    remesh_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    remesh_voxel_adaptivity: float = None
    '''Reduces the final face count by simplifying geometry where detail is not needed, generating triangles. A value greater than 0 disables Fix Poles 

    :type: float
    '''

    remesh_voxel_size: float = None
    '''Size of the voxel in object space used for volume evaluation. Lower values preserve finer details 

    :type: float
    '''

    shape_keys: 'Key' = None
    '''

    :type: 'Key'
    '''

    skin_vertices: typing.Union[typing.List['MeshSkinVertexLayer'],
                                'bpy_prop_collection'] = None
    '''All skin vertices 

    :type: typing.Union[typing.List['MeshSkinVertexLayer'], 'bpy_prop_collection']
    '''

    texco_mesh: 'Mesh' = None
    '''Derive texture coordinates from another mesh 

    :type: 'Mesh'
    '''

    texspace_location: typing.List[float] = None
    '''Texture space location 

    :type: typing.List[float]
    '''

    texspace_size: typing.List[float] = None
    '''Texture space size 

    :type: typing.List[float]
    '''

    texture_mesh: 'Mesh' = None
    '''Use another mesh for texture indices (vertex indices must be aligned) 

    :type: 'Mesh'
    '''

    total_edge_sel: int = None
    '''Selected edge count in editmode 

    :type: int
    '''

    total_face_sel: int = None
    '''Selected face count in editmode 

    :type: int
    '''

    total_vert_sel: int = None
    '''Selected vertex count in editmode 

    :type: int
    '''

    use_auto_smooth: bool = None
    '''Auto smooth (based on smooth/sharp faces/edges and angle between faces), or use custom split normals data if available 

    :type: bool
    '''

    use_auto_texspace: bool = None
    '''Adjust active object’s texture space automatically when transforming object 

    :type: bool
    '''

    use_customdata_edge_bevel: bool = None
    '''

    :type: bool
    '''

    use_customdata_edge_crease: bool = None
    '''

    :type: bool
    '''

    use_customdata_vertex_bevel: bool = None
    '''

    :type: bool
    '''

    use_mirror_topology: bool = None
    '''Use topology based mirroring (for when both sides of mesh have matching, unique topology) 

    :type: bool
    '''

    use_mirror_x: bool = None
    '''X Axis mirror editing 

    :type: bool
    '''

    use_mirror_y: bool = None
    '''Y Axis mirror editing 

    :type: bool
    '''

    use_mirror_z: bool = None
    '''Z Axis mirror editing 

    :type: bool
    '''

    use_paint_mask: bool = None
    '''Face selection masking for painting 

    :type: bool
    '''

    use_paint_mask_vertex: bool = None
    '''Vertex selection masking for painting 

    :type: bool
    '''

    use_remesh_fix_poles: bool = None
    '''Produces less poles and a better topology flow 

    :type: bool
    '''

    use_remesh_preserve_paint_mask: bool = None
    '''Keep the current mask on the new mesh 

    :type: bool
    '''

    use_remesh_preserve_volume: bool = None
    '''Projects the mesh to preserve the volume and details of the original mesh 

    :type: bool
    '''

    use_remesh_smooth_normals: bool = None
    '''Smooth the normals of the remesher result 

    :type: bool
    '''

    uv_layer_clone: 'MeshUVLoopLayer' = None
    '''UV loop layer to be used as cloning source 

    :type: 'MeshUVLoopLayer'
    '''

    uv_layer_clone_index: int = None
    '''Clone UV loop layer index 

    :type: int
    '''

    uv_layer_stencil: 'MeshUVLoopLayer' = None
    '''UV loop layer to mask the painted area 

    :type: 'MeshUVLoopLayer'
    '''

    uv_layer_stencil_index: int = None
    '''Mask UV loop layer index 

    :type: int
    '''

    uv_layers: typing.Union[typing.List['MeshUVLoopLayer'],
                            'bpy_prop_collection', 'UVLoopLayers'] = None
    '''All UV loop layers 

    :type: typing.Union[typing.List['MeshUVLoopLayer'], 'bpy_prop_collection', 'UVLoopLayers']
    '''

    vertex_colors: typing.Union[typing.List['MeshLoopColorLayer'],
                                'bpy_prop_collection', 'LoopColors'] = None
    '''All vertex colors 

    :type: typing.Union[typing.List['MeshLoopColorLayer'], 'bpy_prop_collection', 'LoopColors']
    '''

    vertex_layers_float: typing.Union[
        typing.List['MeshVertexFloatPropertyLayer'], 'bpy_prop_collection',
        'VertexFloatProperties'] = None
    '''

    :type: typing.Union[typing.List['MeshVertexFloatPropertyLayer'], 'bpy_prop_collection', 'VertexFloatProperties']
    '''

    vertex_layers_int: typing.Union[typing.List['MeshVertexIntPropertyLayer'],
                                    'bpy_prop_collection',
                                    'VertexIntProperties'] = None
    '''

    :type: typing.Union[typing.List['MeshVertexIntPropertyLayer'], 'bpy_prop_collection', 'VertexIntProperties']
    '''

    vertex_layers_string: typing.Union[
        typing.List['MeshVertexStringPropertyLayer'], 'bpy_prop_collection',
        'VertexStringProperties'] = None
    '''

    :type: typing.Union[typing.List['MeshVertexStringPropertyLayer'], 'bpy_prop_collection', 'VertexStringProperties']
    '''

    vertex_paint_masks: typing.Union[typing.List['MeshPaintMaskLayer'],
                                     'bpy_prop_collection'] = None
    '''Vertex paint mask 

    :type: typing.Union[typing.List['MeshPaintMaskLayer'], 'bpy_prop_collection']
    '''

    vertices: typing.Union[typing.List['MeshVertex'], 'bpy_prop_collection',
                           'MeshVertices'] = None
    '''Vertices of the mesh 

    :type: typing.Union[typing.List['MeshVertex'], 'bpy_prop_collection', 'MeshVertices']
    '''

    edge_keys = None
    '''(readonly) '''

    def transform(self, matrix: typing.List[float], shape_keys: bool = False):
        '''Transform mesh vertices by a matrix (Warning: inverts normals if matrix is negative) 

        :param matrix: Matrix 
        :type matrix: typing.List[float]
        :param shape_keys: Transform Shape Keys 
        :type shape_keys: bool
        '''
        pass

    def flip_normals(self, ):
        '''Invert winding of all polygons (clears tessellation, does not handle custom normals) 

        '''
        pass

    def calc_normals(self, ):
        '''Calculate vertex normals 

        '''
        pass

    def create_normals_split(self, ):
        '''Empty split vertex normals 

        '''
        pass

    def calc_normals_split(self, ):
        '''Calculate split vertex normals, which preserve sharp edges 

        '''
        pass

    def free_normals_split(self, ):
        '''Free split vertex normals 

        '''
        pass

    def split_faces(self, free_loop_normals: bool = True):
        '''Split faces based on the edge angle 

        :param free_loop_normals: Free Loop Notmals, Free loop normals custom data layer 
        :type free_loop_normals: bool
        '''
        pass

    def calc_tangents(self, uvmap: str = ""):
        '''Compute tangents and bitangent signs, to be used together with the split normals to get a complete tangent space for normal mapping (split normals are also computed if not yet present) 

        :param uvmap: Name of the UV map to use for tangent space computation 
        :type uvmap: str
        '''
        pass

    def free_tangents(self, ):
        '''Free tangents 

        '''
        pass

    def calc_loop_triangles(self, ):
        '''Calculate loop triangle tessellation (supports editmode too) 

        '''
        pass

    def calc_smooth_groups(self, use_bitflags: bool = False):
        '''Calculate smooth groups from sharp edges 

        :param use_bitflags: Produce bitflags groups instead of simple numeric values 
        :type use_bitflags: bool
        '''
        pass

    def normals_split_custom_set(self, normals: typing.List[float]):
        '''Define custom split normals of this mesh (use zero-vectors to keep auto ones) 

        :param normals: Normals 
        :type normals: typing.List[float]
        '''
        pass

    def normals_split_custom_set_from_vertices(self,
                                               normals: typing.List[float]):
        '''Define custom split normals of this mesh, from vertices’ normals (use zero-vectors to keep auto ones) 

        :param normals: Normals 
        :type normals: typing.List[float]
        '''
        pass

    def update(self, calc_edges: bool = False, calc_edges_loose: bool = False):
        '''update 

        :param calc_edges: Calculate Edges, Force recalculation of edges 
        :type calc_edges: bool
        :param calc_edges_loose: Calculate Loose Edges, Calculate the loose state of each edge 
        :type calc_edges_loose: bool
        '''
        pass

    def update_gpu_tag(self, ):
        '''update_gpu_tag 

        '''
        pass

    def unit_test_compare(self, mesh: 'Mesh' = None) -> str:
        '''unit_test_compare 

        :param mesh: Mesh to compare to 
        :type mesh: 'Mesh'
        :rtype: str
        :return:  Return value, String description of result of comparison 
        '''
        pass

    def clear_geometry(self, ):
        '''Remove all geometry from the mesh. Note that this does not free shape keys or materials 

        '''
        pass

    def validate(self, verbose: bool = False,
                 clean_customdata: bool = True) -> bool:
        '''Validate geometry, return True when the mesh has had invalid geometry corrected/removed 

        :param verbose: Verbose, Output information about the errors found 
        :type verbose: bool
        :param clean_customdata: Clean Custom Data, Remove temp/cached custom-data layers, like e.g. normals… 
        :type clean_customdata: bool
        :rtype: bool
        :return:  Result 
        '''
        pass

    def validate_material_indices(self, ) -> bool:
        '''Validate material indices of polygons, return True when the mesh has had invalid indices corrected (to default 0) 

        :rtype: bool
        :return:  Result 
        '''
        pass

    def count_selected_items(self, ) -> typing.List[int]:
        '''Return the number of selected items (vert, edge, face) 

        :rtype: typing.List[int]
        :return:  Result 
        '''
        pass

    def from_pydata(self, vertices: 'bpy.context.object',
                    edges: 'bpy.context.object', faces: 'bpy.context.object'):
        '''Make a mesh from a list of vertices/edges/faces Until we have a nicer way to make geometry, use this. 

        :param vertices: float triplets each representing (X, Y, Z) eg: [(0.0, 1.0, 0.5), …]. 
        :type vertices: 'bpy.context.object'
        :param edges: int pairs, each pair contains two indices to the vertices argument. eg: [(1, 2), …]When an empty iterable is passed in, the edges are inferred from the polygons. 
        :type edges: 'bpy.context.object'
        :param faces: iterator of faces, each faces contains three or more indices to the vertices argument. eg: [(5, 6, 8, 9), (1, 2, 3), …] 
        :type faces: 'bpy.context.object'
        '''
        pass


class MetaBall(ID, bpy_struct):
    '''Metaball data-block to defined blobby surfaces '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    cycles = None
    '''Cycles mesh settings '''

    elements: typing.Union[typing.List['MetaElement'], 'bpy_prop_collection',
                           'MetaBallElements'] = None
    '''Meta elements 

    :type: typing.Union[typing.List['MetaElement'], 'bpy_prop_collection', 'MetaBallElements']
    '''

    is_editmode: bool = None
    '''True when used in editmode 

    :type: bool
    '''

    materials: typing.Union[typing.List['Material'], 'bpy_prop_collection',
                            'IDMaterials'] = None
    '''

    :type: typing.Union[typing.List['Material'], 'bpy_prop_collection', 'IDMaterials']
    '''

    render_resolution: float = None
    '''Polygonization resolution in rendering 

    :type: float
    '''

    resolution: float = None
    '''Polygonization resolution in the 3D viewport 

    :type: float
    '''

    texspace_location: typing.List[float] = None
    '''Texture space location 

    :type: typing.List[float]
    '''

    texspace_size: typing.List[float] = None
    '''Texture space size 

    :type: typing.List[float]
    '''

    threshold: float = None
    '''Influence of meta elements 

    :type: float
    '''

    update_method: typing.Union[str, int] = None
    '''Metaball edit update behavior 

    :type: typing.Union[str, int]
    '''

    use_auto_texspace: bool = None
    '''Adjust active object’s texture space automatically when transforming object 

    :type: bool
    '''

    def transform(self, matrix: typing.List[float]):
        '''Transform meta elements by a matrix 

        :param matrix: Matrix 
        :type matrix: typing.List[float]
        '''
        pass

    def update_gpu_tag(self, ):
        '''update_gpu_tag 

        '''
        pass


class MovieClip(ID, bpy_struct):
    '''MovieClip data-block referencing an external movie file '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    colorspace_settings: 'ColorManagedInputColorspaceSettings' = None
    '''Input color space settings 

    :type: 'ColorManagedInputColorspaceSettings'
    '''

    display_aspect: typing.List[float] = None
    '''Display Aspect for this clip, does not affect rendering 

    :type: typing.List[float]
    '''

    filepath: str = None
    '''Filename of the movie or sequence file 

    :type: str
    '''

    fps: float = None
    '''Detected frame rate of the movie clip in frames per second 

    :type: float
    '''

    frame_duration: int = None
    '''Detected duration of movie clip in frames 

    :type: int
    '''

    frame_offset: int = None
    '''Offset of footage first frame relative to it’s file name (affects only how footage is loading, does not change data associated with a clip) 

    :type: int
    '''

    frame_start: int = None
    '''Global scene frame number at which this movie starts playing (affects all data associated with a clip) 

    :type: int
    '''

    grease_pencil: 'GreasePencil' = None
    '''Grease pencil data for this movie clip 

    :type: 'GreasePencil'
    '''

    proxy: 'MovieClipProxy' = None
    '''

    :type: 'MovieClipProxy'
    '''

    size: typing.List[int] = None
    '''Width and height in pixels, zero when image data cant be loaded 

    :type: typing.List[int]
    '''

    source: typing.Union[str, int] = None
    '''Where the clip comes from 

    :type: typing.Union[str, int]
    '''

    tracking: 'MovieTracking' = None
    '''

    :type: 'MovieTracking'
    '''

    use_proxy: bool = None
    '''Use a preview proxy and/or timecode index for this clip 

    :type: bool
    '''

    use_proxy_custom_directory: bool = None
    '''Create proxy images in a custom directory (default is movie location) 

    :type: bool
    '''

    def metadata(self, ) -> 'IDPropertyWrapPtr':
        '''Retrieve metadata of the movie file 

        :rtype: 'IDPropertyWrapPtr'
        :return:  Dict-like object containing the metadata 
        '''
        pass


class NodeTree(ID, bpy_struct):
    '''Node tree consisting of linked nodes used for shading, textures and compositing '''

    active_input: int = None
    '''Index of the active input 

    :type: int
    '''

    active_output: int = None
    '''Index of the active output 

    :type: int
    '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    bl_description: str = None
    '''

    :type: str
    '''

    bl_icon: typing.Union[str, int] = None
    '''The node tree icon 

    :type: typing.Union[str, int]
    '''

    bl_idname: str = None
    '''

    :type: str
    '''

    bl_label: str = None
    '''The node tree label 

    :type: str
    '''

    grease_pencil: 'GreasePencil' = None
    '''Grease Pencil data-block 

    :type: 'GreasePencil'
    '''

    inputs: typing.Union[typing.List['NodeSocketInterface'],
                         'bpy_prop_collection', 'NodeTreeInputs'] = None
    '''Node tree inputs 

    :type: typing.Union[typing.List['NodeSocketInterface'], 'bpy_prop_collection', 'NodeTreeInputs']
    '''

    links: typing.Union[typing.List['NodeLink'], 'bpy_prop_collection',
                        'NodeLinks'] = None
    '''

    :type: typing.Union[typing.List['NodeLink'], 'bpy_prop_collection', 'NodeLinks']
    '''

    nodes: typing.Union[typing.
                        List['Node'], 'bpy_prop_collection', 'Nodes'] = None
    '''

    :type: typing.Union[typing.List['Node'], 'bpy_prop_collection', 'Nodes']
    '''

    outputs: typing.Union[typing.List['NodeSocketInterface'],
                          'bpy_prop_collection', 'NodeTreeOutputs'] = None
    '''Node tree outputs 

    :type: typing.Union[typing.List['NodeSocketInterface'], 'bpy_prop_collection', 'NodeTreeOutputs']
    '''

    type: typing.Union[str, int] = None
    '''Node Tree type (deprecated, bl_idname is the actual node tree type identifier) 

    :type: typing.Union[str, int]
    '''

    view_center: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    def interface_update(self, context):
        '''Updated node group interface 

        '''
        pass

    def update(self, ):
        '''Update on editor changes 

        '''
        pass


class Object(ID, bpy_struct):
    '''Object data-block defining an object in a scene '''

    active_material: 'Material' = None
    '''Active material being displayed 

    :type: 'Material'
    '''

    active_material_index: int = None
    '''Index of active material slot 

    :type: int
    '''

    active_shape_key: 'ShapeKey' = None
    '''Current shape key 

    :type: 'ShapeKey'
    '''

    active_shape_key_index: int = None
    '''Current shape key index 

    :type: int
    '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    animation_visualization: 'AnimViz' = None
    '''Animation data for this data-block 

    :type: 'AnimViz'
    '''

    bound_box: typing.List[float] = None
    '''Object’s bounding box in object-space coordinates, all values are -1.0 when not available 

    :type: typing.List[float]
    '''

    collision: 'CollisionSettings' = None
    '''Settings for using the object as a collider in physics simulation 

    :type: 'CollisionSettings'
    '''

    color: typing.List[float] = None
    '''Object color and alpha, used when faces have the ObColor mode enabled 

    :type: typing.List[float]
    '''

    constraints: typing.Union[typing.List['Constraint'], 'bpy_prop_collection',
                              'ObjectConstraints'] = None
    '''Constraints affecting the transformation of the object 

    :type: typing.Union[typing.List['Constraint'], 'bpy_prop_collection', 'ObjectConstraints']
    '''

    cycles = None
    '''Cycles object settings '''

    cycles_visibility = None
    '''Cycles visibility settings '''

    data: 'ID' = None
    '''Object data 

    :type: 'ID'
    '''

    delta_location: typing.List[float] = None
    '''Extra translation added to the location of the object 

    :type: typing.List[float]
    '''

    delta_rotation_euler: typing.List[float] = None
    '''Extra rotation added to the rotation of the object (when using Euler rotations) 

    :type: typing.List[float]
    '''

    delta_rotation_quaternion: typing.List[float] = None
    '''Extra rotation added to the rotation of the object (when using Quaternion rotations) 

    :type: typing.List[float]
    '''

    delta_scale: typing.List[float] = None
    '''Extra scaling added to the scale of the object 

    :type: typing.List[float]
    '''

    dimensions: typing.List[float] = None
    '''Absolute bounding box dimensions of the object (WARNING: assigning to it or its members multiple consecutive times will not work correctly, as this needs up-to-date evaluated data) 

    :type: typing.List[float]
    '''

    display: 'ObjectDisplay' = None
    '''Object display settings for 3d viewport 

    :type: 'ObjectDisplay'
    '''

    display_bounds_type: typing.Union[str, int] = None
    '''Object boundary display type 

    :type: typing.Union[str, int]
    '''

    display_type: typing.Union[str, int] = None
    '''How to display object in viewport 

    :type: typing.Union[str, int]
    '''

    empty_display_size: float = None
    '''Size of display for empties in the viewport 

    :type: float
    '''

    empty_display_type: typing.Union[str, int] = None
    '''Viewport display style for empties 

    :type: typing.Union[str, int]
    '''

    empty_image_depth: typing.Union[str, int] = None
    '''Determine which other objects will occlude the image 

    :type: typing.Union[str, int]
    '''

    empty_image_offset: typing.List[float] = None
    '''Origin offset distance 

    :type: typing.List[float]
    '''

    empty_image_side: typing.Union[str, int] = None
    '''Show front/back side 

    :type: typing.Union[str, int]
    '''

    face_maps: typing.Union[typing.List['FaceMap'], 'bpy_prop_collection',
                            'FaceMaps'] = None
    '''Maps of faces of the object 

    :type: typing.Union[typing.List['FaceMap'], 'bpy_prop_collection', 'FaceMaps']
    '''

    field: 'FieldSettings' = None
    '''Settings for using the object as a field in physics simulation 

    :type: 'FieldSettings'
    '''

    grease_pencil_modifiers: typing.Union[typing.List['GpencilModifier'],
                                          'bpy_prop_collection',
                                          'ObjectGpencilModifiers'] = None
    '''Modifiers affecting the data of the grease pencil object 

    :type: typing.Union[typing.List['GpencilModifier'], 'bpy_prop_collection', 'ObjectGpencilModifiers']
    '''

    hide_render: bool = None
    '''Globally disable in renders 

    :type: bool
    '''

    hide_select: bool = None
    '''Disable selection in viewport 

    :type: bool
    '''

    hide_viewport: bool = None
    '''Globally disable in viewports 

    :type: bool
    '''

    image_user: 'ImageUser' = None
    '''Parameters defining which layer, pass and frame of the image is displayed 

    :type: 'ImageUser'
    '''

    instance_collection: 'Collection' = None
    '''Instance an existing collection 

    :type: 'Collection'
    '''

    instance_faces_scale: float = None
    '''Scale the face instance objects 

    :type: float
    '''

    instance_type: typing.Union[str, int] = None
    '''If not None, object instancing method to use 

    :type: typing.Union[str, int]
    '''

    is_from_instancer: bool = None
    '''Object comes from a instancer 

    :type: bool
    '''

    is_from_set: bool = None
    '''Object comes from a background set 

    :type: bool
    '''

    is_instancer: bool = None
    '''

    :type: bool
    '''

    location: typing.List[float] = None
    '''Location of the object 

    :type: typing.List[float]
    '''

    lock_location: typing.List[bool] = None
    '''Lock editing of location when transforming 

    :type: typing.List[bool]
    '''

    lock_rotation: typing.List[bool] = None
    '''Lock editing of rotation when transforming 

    :type: typing.List[bool]
    '''

    lock_rotation_w: bool = None
    '''Lock editing of ‘angle’ component of four-component rotations when transforming 

    :type: bool
    '''

    lock_rotations_4d: bool = None
    '''Lock editing of four component rotations by components (instead of as Eulers) 

    :type: bool
    '''

    lock_scale: typing.List[bool] = None
    '''Lock editing of scale when transforming 

    :type: typing.List[bool]
    '''

    material_slots: typing.Union[typing.List['MaterialSlot'],
                                 'bpy_prop_collection'] = None
    '''Material slots in the object 

    :type: typing.Union[typing.List['MaterialSlot'], 'bpy_prop_collection']
    '''

    matrix_basis: typing.List[float] = None
    '''Matrix access to location, rotation and scale (including deltas), before constraints and parenting are applied 

    :type: typing.List[float]
    '''

    matrix_local: typing.List[float] = None
    '''Parent relative transformation matrix - WARNING: Only takes into account ‘Object’ parenting, so e.g. in case of bone parenting you get a matrix relative to the Armature object, not to the actual parent bone 

    :type: typing.List[float]
    '''

    matrix_parent_inverse: typing.List[float] = None
    '''Inverse of object’s parent matrix at time of parenting 

    :type: typing.List[float]
    '''

    matrix_world: typing.List[float] = None
    '''Worldspace transformation matrix 

    :type: typing.List[float]
    '''

    mode: typing.Union[str, int] = None
    '''Object interaction mode 

    :type: typing.Union[str, int]
    '''

    modifiers: typing.Union[typing.List['Modifier'], 'bpy_prop_collection',
                            'ObjectModifiers'] = None
    '''Modifiers affecting the geometric data of the object 

    :type: typing.Union[typing.List['Modifier'], 'bpy_prop_collection', 'ObjectModifiers']
    '''

    motion_path: 'MotionPath' = None
    '''Motion Path for this element 

    :type: 'MotionPath'
    '''

    parent: 'Object' = None
    '''Parent Object 

    :type: 'Object'
    '''

    parent_bone: str = None
    '''Name of parent bone in case of a bone parenting relation 

    :type: str
    '''

    parent_type: typing.Union[str, int] = None
    '''Type of parent relation 

    :type: typing.Union[str, int]
    '''

    parent_vertices: typing.List[int] = None
    '''Indices of vertices in case of a vertex parenting relation 

    :type: typing.List[int]
    '''

    particle_systems: typing.Union[typing.List[
        'ParticleSystem'], 'bpy_prop_collection', 'ParticleSystems'] = None
    '''Particle systems emitted from the object 

    :type: typing.Union[typing.List['ParticleSystem'], 'bpy_prop_collection', 'ParticleSystems']
    '''

    pass_index: int = None
    '''Index number for the “Object Index” render pass 

    :type: int
    '''

    pose: 'Pose' = None
    '''Current pose for armatures 

    :type: 'Pose'
    '''

    pose_library: 'Action' = None
    '''Action used as a pose library for armatures 

    :type: 'Action'
    '''

    proxy: 'Object' = None
    '''Library object this proxy object controls 

    :type: 'Object'
    '''

    proxy_collection: 'Object' = None
    '''Library collection duplicator object this proxy object controls 

    :type: 'Object'
    '''

    rigid_body: 'RigidBodyObject' = None
    '''Settings for rigid body simulation 

    :type: 'RigidBodyObject'
    '''

    rigid_body_constraint: 'RigidBodyConstraint' = None
    '''Constraint constraining rigid bodies 

    :type: 'RigidBodyConstraint'
    '''

    rotation_axis_angle: typing.List[float] = None
    '''Angle of Rotation for Axis-Angle rotation representation 

    :type: typing.List[float]
    '''

    rotation_euler: typing.List[float] = None
    '''Rotation in Eulers 

    :type: typing.List[float]
    '''

    rotation_mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    rotation_quaternion: typing.List[float] = None
    '''Rotation in Quaternions 

    :type: typing.List[float]
    '''

    scale: typing.List[float] = None
    '''Scaling of the object 

    :type: typing.List[float]
    '''

    shader_effects: typing.Union[typing.
                                 List['ShaderFx'], 'bpy_prop_collection',
                                 'ObjectShaderFx'] = None
    '''Effects affecting display of object 

    :type: typing.Union[typing.List['ShaderFx'], 'bpy_prop_collection', 'ObjectShaderFx']
    '''

    show_all_edges: bool = None
    '''Display all edges for mesh objects 

    :type: bool
    '''

    show_axis: bool = None
    '''Display the object’s origin and axes 

    :type: bool
    '''

    show_bounds: bool = None
    '''Display the object’s bounds 

    :type: bool
    '''

    show_empty_image_only_axis_aligned: bool = None
    '''Only display the image when it is aligned with the view axis 

    :type: bool
    '''

    show_empty_image_orthographic: bool = None
    '''Display image in orthographic mode 

    :type: bool
    '''

    show_empty_image_perspective: bool = None
    '''Display image in perspective mode 

    :type: bool
    '''

    show_in_front: bool = None
    '''Make the object draw in front of others 

    :type: bool
    '''

    show_instancer_for_render: bool = None
    '''Make instancer visible when rendering 

    :type: bool
    '''

    show_instancer_for_viewport: bool = None
    '''Make instancer visible in the viewport 

    :type: bool
    '''

    show_name: bool = None
    '''Display the object’s name 

    :type: bool
    '''

    show_only_shape_key: bool = None
    '''Always show the current Shape for this Object 

    :type: bool
    '''

    show_texture_space: bool = None
    '''Display the object’s texture space 

    :type: bool
    '''

    show_transparent: bool = None
    '''Display material transparency in the object 

    :type: bool
    '''

    show_wire: bool = None
    '''Add the object’s wireframe over solid drawing 

    :type: bool
    '''

    soft_body: 'SoftBodySettings' = None
    '''Settings for soft body simulation 

    :type: 'SoftBodySettings'
    '''

    track_axis: typing.Union[str, int] = None
    '''Axis that points in ‘forward’ direction (applies to InstanceFrame when parent ‘Follow’ is enabled) 

    :type: typing.Union[str, int]
    '''

    type: typing.Union[str, int] = None
    '''Type of Object 

    :type: typing.Union[str, int]
    '''

    up_axis: typing.Union[str, int] = None
    '''Axis that points in the upward direction (applies to InstanceFrame when parent ‘Follow’ is enabled) 

    :type: typing.Union[str, int]
    '''

    use_dynamic_topology_sculpting: bool = None
    '''

    :type: bool
    '''

    use_empty_image_alpha: bool = None
    '''Use alpha blending instead of alpha test (can produce sorting artifacts) 

    :type: bool
    '''

    use_instance_faces_scale: bool = None
    '''Scale instance based on face size 

    :type: bool
    '''

    use_instance_vertices_rotation: bool = None
    '''Rotate instance according to vertex normal 

    :type: bool
    '''

    use_shape_key_edit_mode: bool = None
    '''Apply shape keys in edit mode (for Meshes only) 

    :type: bool
    '''

    vertex_groups: typing.Union[typing.List['VertexGroup'],
                                'bpy_prop_collection', 'VertexGroups'] = None
    '''Vertex groups of the object 

    :type: typing.Union[typing.List['VertexGroup'], 'bpy_prop_collection', 'VertexGroups']
    '''

    children = None
    '''All the children of this object. Warning: takes O(len(bpy.data.objects)) time. (readonly) '''

    users_collection = None
    '''The collections this object is in. Warning: takes O(len(bpy.data.collections) + len(bpy.data.scenes)) time. (readonly) '''

    users_scene = None
    '''The scenes this object is in. Warning: takes O(len(bpy.data.scenes) * len(bpy.data.objects)) time. (readonly) '''

    def select_get(self, view_layer: 'ViewLayer' = None) -> bool:
        '''Test if the object is selected. The selection state is per view layer 

        :param view_layer: Use this instead of the active view layer 
        :type view_layer: 'ViewLayer'
        :rtype: bool
        :return:  Object selected 
        '''
        pass

    def select_set(self, state: bool, view_layer: 'ViewLayer' = None):
        '''Select or deselect the object. The selection state is per view layer 

        :param state: Selection state to define 
        :type state: bool
        :param view_layer: Use this instead of the active view layer 
        :type view_layer: 'ViewLayer'
        '''
        pass

    def hide_get(self, view_layer: 'ViewLayer' = None) -> bool:
        '''Test if the object is hidden for viewport editing. This hiding state is per view layer 

        :param view_layer: Use this instead of the active view layer 
        :type view_layer: 'ViewLayer'
        :rtype: bool
        :return:  Object hidden 
        '''
        pass

    def hide_set(self, state: bool, view_layer: 'ViewLayer' = None):
        '''Hide the object for viewport editing. This hiding state is per view layer 

        :param state: Hide state to define 
        :type state: bool
        :param view_layer: Use this instead of the active view layer 
        :type view_layer: 'ViewLayer'
        '''
        pass

    def visible_get(self,
                    view_layer: 'ViewLayer' = None,
                    viewport: 'SpaceView3D' = None) -> bool:
        '''Test if the object is visible in the 3D viewport, taking into account all visibility settings 

        :param view_layer: Use this instead of the active view layer 
        :type view_layer: 'ViewLayer'
        :param viewport: Use this instead of the active 3D viewport 
        :type viewport: 'SpaceView3D'
        :rtype: bool
        :return:  Object visible 
        '''
        pass

    def holdout_get(self, view_layer: 'ViewLayer' = None) -> bool:
        '''Test if object is masked in the view layer 

        :param view_layer: Use this instead of the active view layer 
        :type view_layer: 'ViewLayer'
        :rtype: bool
        :return:  Object holdout 
        '''
        pass

    def indirect_only_get(self, view_layer: 'ViewLayer' = None) -> bool:
        '''Test if object is set to contribute only indirectly (through shadows and reflections) in the view layer 

        :param view_layer: Use this instead of the active view layer 
        :type view_layer: 'ViewLayer'
        :rtype: bool
        :return:  Object indirect only 
        '''
        pass

    def local_view_get(self, viewport: 'SpaceView3D') -> bool:
        '''Get the local view state for this object 

        :param viewport: Viewport in local view 
        :type viewport: 'SpaceView3D'
        :rtype: bool
        :return:  Object local view state 
        '''
        pass

    def local_view_set(self, viewport: 'SpaceView3D', state: bool):
        '''Set the local view state for this object 

        :param viewport: Viewport in local view 
        :type viewport: 'SpaceView3D'
        :param state: Local view state to define 
        :type state: bool
        '''
        pass

    def visible_in_viewport_get(self, viewport: 'SpaceView3D') -> bool:
        '''Check for local view and local collections for this viewport and object 

        :param viewport: Viewport in local collections 
        :type viewport: 'SpaceView3D'
        :rtype: bool
        :return:  Object viewport visibility 
        '''
        pass

    def convert_space(
            self,
            pose_bone: 'PoseBone' = None,
            matrix: typing.List[float] = ((0.0, 0.0, 0.0, 0.0), (0.0, 0.0, 0.0,
                                                                 0.0),
                                          (0.0, 0.0, 0.0, 0.0), (0.0, 0.0, 0.0,
                                                                 0.0)),
            from_space: typing.Union[str, int] = 'WORLD',
            to_space: typing.Union[str, int] = 'WORLD') -> typing.List[float]:
        '''Convert (transform) the given matrix from one space to another 

        :param pose_bone: Bone to use to define spaces (may be None, in which case only the two ‘WORLD’ and ‘LOCAL’ spaces are usable) 
        :type pose_bone: 'PoseBone'
        :param matrix: The matrix to transform 
        :type matrix: typing.List[float]
        :param from_space: The space in which ‘matrix’ is currentlyWORLD World Space, The most global space in Blender.POSE Pose Space, The pose space of a bone (its armature’s object space).LOCAL_WITH_PARENT Local With Parent, The rest pose local space of a bone (thus matrix includes parent transforms).LOCAL Local Space, The local space of an object/bone. 
        :type from_space: typing.Union[str, int]
        :param to_space: The space to which you want to transform ‘matrix’WORLD World Space, The most global space in Blender.POSE Pose Space, The pose space of a bone (its armature’s object space).LOCAL_WITH_PARENT Local With Parent, The rest pose local space of a bone (thus matrix includes parent transforms).LOCAL Local Space, The local space of an object/bone. 
        :type to_space: typing.Union[str, int]
        :rtype: typing.List[float]
        :return:  The transformed matrix 
        '''
        pass

    def calc_matrix_camera(self,
                           depsgraph: 'Depsgraph',
                           x: int = 1,
                           y: int = 1,
                           scale_x: float = 1.0,
                           scale_y: float = 1.0) -> typing.List[float]:
        '''Generate the camera projection matrix of this object (mostly useful for Camera and Light types) 

        :param depsgraph: Depsgraph to get evaluated data from 
        :type depsgraph: 'Depsgraph'
        :param x: Width of the render area 
        :type x: int
        :param y: Height of the render area 
        :type y: int
        :param scale_x: Width scaling factor 
        :type scale_x: float
        :param scale_y: Height scaling factor 
        :type scale_y: float
        :rtype: typing.List[float]
        :return:  The camera projection matrix 
        '''
        pass

    def camera_fit_coords(self, depsgraph: 'Depsgraph',
                          coordinates: typing.List[float]):
        '''Compute the coordinate (and scale for ortho cameras) given object should be to ‘see’ all given coordinates 

        :param depsgraph: Depsgraph to get evaluated data from 
        :type depsgraph: 'Depsgraph'
        :param coordinates: Coordinates to fit in 
        :type coordinates: typing.List[float]
        '''
        pass

    def to_mesh(self,
                preserve_all_data_layers: bool = False,
                depsgraph: 'Depsgraph' = None) -> 'Mesh':
        '''Create a Mesh data-block from the current state of the object. The object owns the data-block. To force free it use to_mesh_clear(). The result is temporary and can not be used by objects from the main database 

        :param preserve_all_data_layers: Preserve all data layers in the mesh, like UV maps and vertex groups. By default Blender only computes the subset of data layers needed for viewport display and rendering, for better performance 
        :type preserve_all_data_layers: bool
        :param depsgraph: Dependency Graph, Evaluated dependency graph which is required when preserve_all_data_layers is true 
        :type depsgraph: 'Depsgraph'
        :rtype: 'Mesh'
        :return:  Mesh created from object 
        '''
        pass

    def to_mesh_clear(self, ):
        '''Clears mesh data-block created by to_mesh() 

        '''
        pass

    def find_armature(self, ) -> 'Object':
        '''Find armature influencing this object as a parent or via a modifier 

        :rtype: 'Object'
        :return:  Armature object influencing this object or NULL 
        '''
        pass

    def shape_key_add(self, name: str = "Key",
                      from_mix: bool = True) -> 'ShapeKey':
        '''Add shape key to this object 

        :param name: Unique name for the new keyblock 
        :type name: str
        :param from_mix: Create new shape from existing mix of shapes 
        :type from_mix: bool
        :rtype: 'ShapeKey'
        :return:  New shape keyblock 
        '''
        pass

    def shape_key_remove(self, key: 'ShapeKey'):
        '''Remove a Shape Key from this object 

        :param key: Keyblock to be removed 
        :type key: 'ShapeKey'
        '''
        pass

    def shape_key_clear(self, ):
        '''Remove all Shape Keys from this object 

        '''
        pass

    def ray_cast(self,
                 origin: typing.List[float],
                 direction: typing.List[float],
                 distance: float = 1.70141e+38,
                 depsgraph: 'Depsgraph' = None):
        '''Cast a ray onto evaluated geometry, in object space (using context’s or provided depsgraph to get evaluated mesh if needed) 

        :param origin: Origin of the ray, in object space 
        :type origin: typing.List[float]
        :param direction: Direction of the ray, in object space 
        :type direction: typing.List[float]
        :param distance: Maximum distance 
        :type distance: float
        :param depsgraph: Depsgraph to use to get evaluated data, when called from original object (only needed if current Context’s depsgraph is not suitable) 
        :type depsgraph: 'Depsgraph'
        '''
        pass

    def closest_point_on_mesh(self,
                              origin: typing.List[float],
                              distance: float = 1.84467e+19,
                              depsgraph: 'Depsgraph' = None):
        '''Find the nearest point on evaluated geometry, in object space (using context’s or provided depsgraph to get evaluated mesh if needed) 

        :param origin: Point to find closest geometry from (in object space) 
        :type origin: typing.List[float]
        :param distance: Maximum distance 
        :type distance: float
        :param depsgraph: Depsgraph to use to get evaluated data, when called from original object (only needed if current Context’s depsgraph is not suitable) 
        :type depsgraph: 'Depsgraph'
        '''
        pass

    def is_modified(self, scene: 'Scene',
                    settings: typing.Union[str, int]) -> bool:
        '''Determine if this object is modified from the base mesh data 

        :param scene: Scene in which to check the object 
        :type scene: 'Scene'
        :param settings: Modifier settings to applyPREVIEW Preview, Apply modifier preview settings.RENDER Render, Apply modifier render settings. 
        :type settings: typing.Union[str, int]
        :rtype: bool
        :return:  Whether the object is modified 
        '''
        pass

    def is_deform_modified(self, scene: 'Scene',
                           settings: typing.Union[str, int]) -> bool:
        '''Determine if this object is modified by a deformation from the base mesh data 

        :param scene: Scene in which to check the object 
        :type scene: 'Scene'
        :param settings: Modifier settings to applyPREVIEW Preview, Apply modifier preview settings.RENDER Render, Apply modifier render settings. 
        :type settings: typing.Union[str, int]
        :rtype: bool
        :return:  Whether the object is deform-modified 
        '''
        pass

    def update_from_editmode(self, ) -> bool:
        '''Load the objects edit-mode data into the object data 

        :rtype: bool
        :return:  Success 
        '''
        pass

    def cache_release(self, ):
        '''Release memory used by caches associated with this object. Intended to be used by render engines only 

        '''
        pass

    def generate_gpencil_strokes(self,
                                 ob_gpencil: 'Object',
                                 gpencil_lines: bool = False,
                                 use_collections: bool = True) -> bool:
        '''Convert a curve object to grease pencil strokes. 

        :param ob_gpencil: Grease Pencil object used to create new strokes 
        :type ob_gpencil: 'Object'
        :param gpencil_lines: Create Lines 
        :type gpencil_lines: bool
        :param use_collections: Use Collections 
        :type use_collections: bool
        :rtype: bool
        :return:  Result 
        '''
        pass


class PaintCurve(ID, bpy_struct):
    pass


class Palette(ID, bpy_struct):
    colors: typing.Union[typing.List['PaletteColor'], 'bpy_prop_collection',
                         'PaletteColors'] = None
    '''

    :type: typing.Union[typing.List['PaletteColor'], 'bpy_prop_collection', 'PaletteColors']
    '''


class ParticleSettings(ID, bpy_struct):
    '''Particle settings, reusable by multiple particle systems '''

    active_instanceweight: 'ParticleDupliWeight' = None
    '''

    :type: 'ParticleDupliWeight'
    '''

    active_instanceweight_index: int = None
    '''

    :type: int
    '''

    active_texture: 'Texture' = None
    '''Active texture slot being displayed 

    :type: 'Texture'
    '''

    active_texture_index: int = None
    '''Index of active texture slot 

    :type: int
    '''

    adaptive_angle: int = None
    '''How many degrees path has to curve to make another render segment 

    :type: int
    '''

    adaptive_pixel: int = None
    '''How many pixels path has to cover to make another render segment 

    :type: int
    '''

    angular_velocity_factor: float = None
    '''Angular velocity amount (in radians per second) 

    :type: float
    '''

    angular_velocity_mode: typing.Union[str, int] = None
    '''What axis is used to change particle rotation with time 

    :type: typing.Union[str, int]
    '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    apply_effector_to_children: bool = None
    '''Apply effectors to children 

    :type: bool
    '''

    apply_guide_to_children: bool = None
    '''

    :type: bool
    '''

    bending_random: float = None
    '''Random stiffness of hairs 

    :type: float
    '''

    boids: 'BoidSettings' = None
    '''

    :type: 'BoidSettings'
    '''

    branch_threshold: float = None
    '''Threshold of branching 

    :type: float
    '''

    brownian_factor: float = None
    '''Amount of random, erratic particle movement 

    :type: float
    '''

    child_length: float = None
    '''Length of child paths 

    :type: float
    '''

    child_length_threshold: float = None
    '''Amount of particles left untouched by child path length 

    :type: float
    '''

    child_nbr: int = None
    '''Number of children/parent 

    :type: int
    '''

    child_parting_factor: float = None
    '''Create parting in the children based on parent strands 

    :type: float
    '''

    child_parting_max: float = None
    '''Maximum root to tip angle (tip distance/root distance for long hair) 

    :type: float
    '''

    child_parting_min: float = None
    '''Minimum root to tip angle (tip distance/root distance for long hair) 

    :type: float
    '''

    child_radius: float = None
    '''Radius of children around parent 

    :type: float
    '''

    child_roundness: float = None
    '''Roundness of children around parent 

    :type: float
    '''

    child_size: float = None
    '''A multiplier for the child particle size 

    :type: float
    '''

    child_size_random: float = None
    '''Random variation to the size of the child particles 

    :type: float
    '''

    child_type: typing.Union[str, int] = None
    '''Create child particles 

    :type: typing.Union[str, int]
    '''

    clump_curve: 'CurveMapping' = None
    '''Curve defining clump tapering 

    :type: 'CurveMapping'
    '''

    clump_factor: float = None
    '''Amount of clumping 

    :type: float
    '''

    clump_noise_size: float = None
    '''Size of clump noise 

    :type: float
    '''

    clump_shape: float = None
    '''Shape of clumping 

    :type: float
    '''

    collision_collection: 'Collection' = None
    '''Limit colliders to this collection 

    :type: 'Collection'
    '''

    color_maximum: float = None
    '''Maximum length of the particle color vector 

    :type: float
    '''

    count: int = None
    '''Total number of particles 

    :type: int
    '''

    courant_target: float = None
    '''The relative distance a particle can move before requiring more subframes (target Courant number); 0.01-0.3 is the recommended range 

    :type: float
    '''

    create_long_hair_children: bool = None
    '''Calculate children that suit long hair well 

    :type: bool
    '''

    damping: float = None
    '''Amount of damping 

    :type: float
    '''

    display_color: typing.Union[str, int] = None
    '''Draw additional particle data as a color 

    :type: typing.Union[str, int]
    '''

    display_method: typing.Union[str, int] = None
    '''How particles are drawn in viewport 

    :type: typing.Union[str, int]
    '''

    display_percentage: int = None
    '''Percentage of particles to display in 3D view 

    :type: int
    '''

    display_size: float = None
    '''Size of particles on viewport in BU 

    :type: float
    '''

    display_step: int = None
    '''How many steps paths are drawn with (power of 2) 

    :type: int
    '''

    distribution: typing.Union[str, int] = None
    '''How to distribute particles on selected element 

    :type: typing.Union[str, int]
    '''

    drag_factor: float = None
    '''Amount of air-drag 

    :type: float
    '''

    effect_hair: float = None
    '''Hair stiffness for effectors 

    :type: float
    '''

    effector_amount: int = None
    '''How many particles are effectors (0 is all particles) 

    :type: int
    '''

    effector_weights: 'EffectorWeights' = None
    '''

    :type: 'EffectorWeights'
    '''

    emit_from: typing.Union[str, int] = None
    '''Where to emit particles from 

    :type: typing.Union[str, int]
    '''

    factor_random: float = None
    '''Give the starting velocity a random variation 

    :type: float
    '''

    fluid: 'SPHFluidSettings' = None
    '''

    :type: 'SPHFluidSettings'
    '''

    force_field_1: 'FieldSettings' = None
    '''

    :type: 'FieldSettings'
    '''

    force_field_2: 'FieldSettings' = None
    '''

    :type: 'FieldSettings'
    '''

    frame_end: float = None
    '''Frame number to stop emitting particles 

    :type: float
    '''

    frame_start: float = None
    '''Frame number to start emitting particles 

    :type: float
    '''

    grid_random: float = None
    '''Add random offset to the grid locations 

    :type: float
    '''

    grid_resolution: int = None
    '''The resolution of the particle grid 

    :type: int
    '''

    hair_length: float = None
    '''Length of the hair 

    :type: float
    '''

    hair_step: int = None
    '''Number of hair segments 

    :type: int
    '''

    hexagonal_grid: bool = None
    '''Create the grid in a hexagonal pattern 

    :type: bool
    '''

    instance_collection: 'Collection' = None
    '''Show Objects in this collection in place of particles 

    :type: 'Collection'
    '''

    instance_object: 'Object' = None
    '''Show this Object in place of particles 

    :type: 'Object'
    '''

    instance_weights: typing.Union[typing.List['ParticleDupliWeight'],
                                   'bpy_prop_collection'] = None
    '''Weights for all of the objects in the dupli collection 

    :type: typing.Union[typing.List['ParticleDupliWeight'], 'bpy_prop_collection']
    '''

    integrator: typing.Union[str, int] = None
    '''Algorithm used to calculate physics, from the fastest to the most stable/accurate: Midpoint, Euler, Verlet, RK4 (Old) 

    :type: typing.Union[str, int]
    '''

    invert_grid: bool = None
    '''Invert what is considered object and what is not 

    :type: bool
    '''

    is_fluid: bool = None
    '''Particles were created by a fluid simulation 

    :type: bool
    '''

    jitter_factor: float = None
    '''Amount of jitter applied to the sampling 

    :type: float
    '''

    keyed_loops: int = None
    '''Number of times the keys are looped 

    :type: int
    '''

    keys_step: int = None
    '''

    :type: int
    '''

    kink: typing.Union[str, int] = None
    '''Type of periodic offset on the path 

    :type: typing.Union[str, int]
    '''

    kink_amplitude: float = None
    '''The amplitude of the offset 

    :type: float
    '''

    kink_amplitude_clump: float = None
    '''How much clump affects kink amplitude 

    :type: float
    '''

    kink_amplitude_random: float = None
    '''Random variation of the amplitude 

    :type: float
    '''

    kink_axis: typing.Union[str, int] = None
    '''Which axis to use for offset 

    :type: typing.Union[str, int]
    '''

    kink_axis_random: float = None
    '''Random variation of the orientation 

    :type: float
    '''

    kink_extra_steps: int = None
    '''Extra steps for resolution of special kink features 

    :type: int
    '''

    kink_flat: float = None
    '''How flat the hairs are 

    :type: float
    '''

    kink_frequency: float = None
    '''The frequency of the offset (1/total length) 

    :type: float
    '''

    kink_shape: float = None
    '''Adjust the offset to the beginning/end 

    :type: float
    '''

    length_random: float = None
    '''Give path length a random variation 

    :type: float
    '''

    lifetime: float = None
    '''Life span of the particles 

    :type: float
    '''

    lifetime_random: float = None
    '''Give the particle life a random variation 

    :type: float
    '''

    line_length_head: float = None
    '''Length of the line’s head 

    :type: float
    '''

    line_length_tail: float = None
    '''Length of the line’s tail 

    :type: float
    '''

    lock_boids_to_surface: bool = None
    '''Constrain boids to a surface 

    :type: bool
    '''

    mass: float = None
    '''Mass of the particles 

    :type: float
    '''

    material: int = None
    '''Index of material slot used for rendering particles 

    :type: int
    '''

    material_slot: typing.Union[str, int] = None
    '''Material slot used for rendering particles 

    :type: typing.Union[str, int]
    '''

    normal_factor: float = None
    '''Let the surface normal give the particle a starting velocity 

    :type: float
    '''

    object_align_factor: typing.List[float] = None
    '''Let the emitter object orientation give the particle a starting velocity 

    :type: typing.List[float]
    '''

    object_factor: float = None
    '''Let the object give the particle a starting velocity 

    :type: float
    '''

    particle_factor: float = None
    '''Let the target particle give the particle a starting velocity 

    :type: float
    '''

    particle_size: float = None
    '''The size of the particles 

    :type: float
    '''

    path_end: float = None
    '''End time of drawn path 

    :type: float
    '''

    path_start: float = None
    '''Starting time of drawn path 

    :type: float
    '''

    phase_factor: float = None
    '''Rotation around the chosen orientation axis 

    :type: float
    '''

    phase_factor_random: float = None
    '''Randomize rotation around the chosen orientation axis 

    :type: float
    '''

    physics_type: typing.Union[str, int] = None
    '''Particle physics type 

    :type: typing.Union[str, int]
    '''

    radius_scale: float = None
    '''Multiplier of radius properties 

    :type: float
    '''

    react_event: typing.Union[str, int] = None
    '''The event of target particles to react on 

    :type: typing.Union[str, int]
    '''

    reactor_factor: float = None
    '''Let the vector away from the target particle’s location give the particle a starting velocity 

    :type: float
    '''

    render_step: int = None
    '''How many steps paths are rendered with (power of 2) 

    :type: int
    '''

    render_type: typing.Union[str, int] = None
    '''How particles are rendered 

    :type: typing.Union[str, int]
    '''

    rendered_child_count: int = None
    '''Number of children/parent for rendering 

    :type: int
    '''

    root_radius: float = None
    '''Strand diameter width at the root 

    :type: float
    '''

    rotation_factor_random: float = None
    '''Randomize particle orientation 

    :type: float
    '''

    rotation_mode: typing.Union[str, int] = None
    '''Particle orientation axis (does not affect Explode modifier’s results) 

    :type: typing.Union[str, int]
    '''

    roughness_1: float = None
    '''Amount of location dependent rough 

    :type: float
    '''

    roughness_1_size: float = None
    '''Size of location dependent rough 

    :type: float
    '''

    roughness_2: float = None
    '''Amount of random rough 

    :type: float
    '''

    roughness_2_size: float = None
    '''Size of random rough 

    :type: float
    '''

    roughness_2_threshold: float = None
    '''Amount of particles left untouched by random rough 

    :type: float
    '''

    roughness_curve: 'CurveMapping' = None
    '''Curve defining roughness 

    :type: 'CurveMapping'
    '''

    roughness_end_shape: float = None
    '''Shape of end point rough 

    :type: float
    '''

    roughness_endpoint: float = None
    '''Amount of end point rough 

    :type: float
    '''

    shape: float = None
    '''Strand shape parameter 

    :type: float
    '''

    show_guide_hairs: bool = None
    '''Show guide hairs 

    :type: bool
    '''

    show_hair_grid: bool = None
    '''Show hair simulation grid 

    :type: bool
    '''

    show_health: bool = None
    '''Draw boid health 

    :type: bool
    '''

    show_number: bool = None
    '''Show particle number 

    :type: bool
    '''

    show_size: bool = None
    '''Show particle size 

    :type: bool
    '''

    show_unborn: bool = None
    '''Show particles before they are emitted 

    :type: bool
    '''

    show_velocity: bool = None
    '''Show particle velocity 

    :type: bool
    '''

    size_random: float = None
    '''Give the particle size a random variation 

    :type: float
    '''

    subframes: int = None
    '''Subframes to simulate for improved stability and finer granularity simulations (dt = timestep / (subframes + 1)) 

    :type: int
    '''

    tangent_factor: float = None
    '''Let the surface tangent give the particle a starting velocity 

    :type: float
    '''

    tangent_phase: float = None
    '''Rotate the surface tangent 

    :type: float
    '''

    texture_slots: typing.Union[typing.List['ParticleSettingsTextureSlot'],
                                'bpy_prop_collection',
                                'ParticleSettingsTextureSlots'] = None
    '''Texture slots defining the mapping and influence of textures 

    :type: typing.Union[typing.List['ParticleSettingsTextureSlot'], 'bpy_prop_collection', 'ParticleSettingsTextureSlots']
    '''

    time_tweak: float = None
    '''A multiplier for physics timestep (1.0 means one frame = 1/25 seconds) 

    :type: float
    '''

    timestep: float = None
    '''The simulation timestep per frame (seconds per frame) 

    :type: float
    '''

    tip_radius: float = None
    '''Strand diameter width at the tip 

    :type: float
    '''

    trail_count: int = None
    '''Number of trail particles 

    :type: int
    '''

    twist: float = None
    '''Number of turns around parent along the strand 

    :type: float
    '''

    twist_curve: 'CurveMapping' = None
    '''Curve defining twist 

    :type: 'CurveMapping'
    '''

    type: typing.Union[str, int] = None
    '''Particle Type 

    :type: typing.Union[str, int]
    '''

    use_absolute_path_time: bool = None
    '''Path timing is in absolute frames 

    :type: bool
    '''

    use_adaptive_subframes: bool = None
    '''Automatically set the number of subframes 

    :type: bool
    '''

    use_advanced_hair: bool = None
    '''Use full physics calculations for growing hair 

    :type: bool
    '''

    use_close_tip: bool = None
    '''Set tip radius to zero 

    :type: bool
    '''

    use_clump_curve: bool = None
    '''Use a curve to define clump tapering 

    :type: bool
    '''

    use_clump_noise: bool = None
    '''Create random clumps around the parent 

    :type: bool
    '''

    use_collection_count: bool = None
    '''Use object multiple times in the same collection 

    :type: bool
    '''

    use_collection_pick_random: bool = None
    '''Pick objects from collection randomly 

    :type: bool
    '''

    use_dead: bool = None
    '''Show particles after they have died 

    :type: bool
    '''

    use_die_on_collision: bool = None
    '''Particles die when they collide with a deflector object 

    :type: bool
    '''

    use_dynamic_rotation: bool = None
    '''Particle rotations are affected by collisions and effectors 

    :type: bool
    '''

    use_emit_random: bool = None
    '''Emit in random order of elements 

    :type: bool
    '''

    use_even_distribution: bool = None
    '''Use even distribution from faces based on face areas or edge lengths 

    :type: bool
    '''

    use_global_instance: bool = None
    '''Use object’s global coordinates for duplication 

    :type: bool
    '''

    use_hair_bspline: bool = None
    '''Interpolate hair using B-Splines 

    :type: bool
    '''

    use_modifier_stack: bool = None
    '''Emit particles from mesh with modifiers applied (must use same subsurf level for viewport and render for correct results) 

    :type: bool
    '''

    use_multiply_size_mass: bool = None
    '''Multiply mass by particle size 

    :type: bool
    '''

    use_parent_particles: bool = None
    '''Render parent particles 

    :type: bool
    '''

    use_react_multiple: bool = None
    '''React multiple times 

    :type: bool
    '''

    use_react_start_end: bool = None
    '''Give birth to unreacted particles eventually 

    :type: bool
    '''

    use_regrow_hair: bool = None
    '''Regrow hair for each frame 

    :type: bool
    '''

    use_render_adaptive: bool = None
    '''Draw steps of the particle path 

    :type: bool
    '''

    use_rotation_instance: bool = None
    '''Use object’s rotation for duplication (global x-axis is aligned particle rotation axis) 

    :type: bool
    '''

    use_rotations: bool = None
    '''Calculate particle rotations 

    :type: bool
    '''

    use_roughness_curve: bool = None
    '''Use a curve to define roughness 

    :type: bool
    '''

    use_scale_instance: bool = None
    '''Use object’s scale for duplication 

    :type: bool
    '''

    use_self_effect: bool = None
    '''Particle effectors affect themselves 

    :type: bool
    '''

    use_size_deflect: bool = None
    '''Use particle’s size in deflection 

    :type: bool
    '''

    use_strand_primitive: bool = None
    '''Use the strand primitive for rendering 

    :type: bool
    '''

    use_twist_curve: bool = None
    '''Use a curve to define twist 

    :type: bool
    '''

    use_velocity_length: bool = None
    '''Multiply line length by particle speed 

    :type: bool
    '''

    use_whole_collection: bool = None
    '''Use whole collection at once 

    :type: bool
    '''

    userjit: int = None
    '''Emission locations / face (0 = automatic) 

    :type: int
    '''

    virtual_parents: float = None
    '''Relative amount of virtual parents 

    :type: float
    '''


class Scene(ID, bpy_struct):
    '''Scene data-block, consisting in objects and defining time and render related settings '''

    active_clip: 'MovieClip' = None
    '''Active movie clip used for constraints and viewport drawing 

    :type: 'MovieClip'
    '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    audio_distance_model: typing.Union[str, int] = None
    '''Distance model for distance attenuation calculation 

    :type: typing.Union[str, int]
    '''

    audio_doppler_factor: float = None
    '''Pitch factor for Doppler effect calculation 

    :type: float
    '''

    audio_doppler_speed: float = None
    '''Speed of sound for Doppler effect calculation 

    :type: float
    '''

    audio_volume: float = None
    '''Audio volume 

    :type: float
    '''

    background_set: 'Scene' = None
    '''Background set scene 

    :type: 'Scene'
    '''

    camera: 'Object' = None
    '''Active camera, used for rendering the scene 

    :type: 'Object'
    '''

    collection: 'Collection' = None
    '''Scene master collection that objects and other collections in the scene 

    :type: 'Collection'
    '''

    cursor: 'View3DCursor' = None
    '''

    :type: 'View3DCursor'
    '''

    cycles = None
    '''Cycles render settings '''

    cycles_curves = None
    '''Cycles hair rendering settings '''

    display: 'SceneDisplay' = None
    '''Scene display settings for 3d viewport 

    :type: 'SceneDisplay'
    '''

    display_settings: 'ColorManagedDisplaySettings' = None
    '''Settings of device saved image would be displayed on 

    :type: 'ColorManagedDisplaySettings'
    '''

    eevee: 'SceneEEVEE' = None
    '''EEVEE settings for the scene 

    :type: 'SceneEEVEE'
    '''

    frame_current: int = None
    '''Current Frame, to update animation data from python frame_set() instead 

    :type: int
    '''

    frame_current_final: float = None
    '''Current frame with subframe and time remapping applied 

    :type: float
    '''

    frame_end: int = None
    '''Final frame of the playback/rendering range 

    :type: int
    '''

    frame_float: float = None
    '''

    :type: float
    '''

    frame_preview_end: int = None
    '''Alternative end frame for UI playback 

    :type: int
    '''

    frame_preview_start: int = None
    '''Alternative start frame for UI playback 

    :type: int
    '''

    frame_start: int = None
    '''First frame of the playback/rendering range 

    :type: int
    '''

    frame_step: int = None
    '''Number of frames to skip forward while rendering/playing back each frame 

    :type: int
    '''

    frame_subframe: float = None
    '''

    :type: float
    '''

    gravity: typing.List[float] = None
    '''Constant acceleration in a given direction 

    :type: typing.List[float]
    '''

    grease_pencil: 'GreasePencil' = None
    '''Grease Pencil data-block used for annotations in the 3D view 

    :type: 'GreasePencil'
    '''

    is_nla_tweakmode: bool = None
    '''Whether there is any action referenced by NLA being edited (strictly read-only) 

    :type: bool
    '''

    keying_sets: typing.Union[typing.List['KeyingSet'], 'bpy_prop_collection',
                              'KeyingSets'] = None
    '''Absolute Keying Sets for this Scene 

    :type: typing.Union[typing.List['KeyingSet'], 'bpy_prop_collection', 'KeyingSets']
    '''

    keying_sets_all: typing.Union[typing.
                                  List['KeyingSet'], 'bpy_prop_collection',
                                  'KeyingSetsAll'] = None
    '''All Keying Sets available for use (Builtins and Absolute Keying Sets for this Scene) 

    :type: typing.Union[typing.List['KeyingSet'], 'bpy_prop_collection', 'KeyingSetsAll']
    '''

    lock_frame_selection_to_range: bool = None
    '''Don’t allow frame to be selected with mouse outside of frame range 

    :type: bool
    '''

    node_tree: 'NodeTree' = None
    '''Compositing node tree 

    :type: 'NodeTree'
    '''

    objects: typing.Union[typing.List['Object'], 'bpy_prop_collection',
                          'SceneObjects'] = None
    '''

    :type: typing.Union[typing.List['Object'], 'bpy_prop_collection', 'SceneObjects']
    '''

    render: 'RenderSettings' = None
    '''

    :type: 'RenderSettings'
    '''

    rigidbody_world: 'RigidBodyWorld' = None
    '''

    :type: 'RigidBodyWorld'
    '''

    safe_areas: 'DisplaySafeAreas' = None
    '''

    :type: 'DisplaySafeAreas'
    '''

    sequence_editor: 'SequenceEditor' = None
    '''

    :type: 'SequenceEditor'
    '''

    sequencer_colorspace_settings: 'ColorManagedSequencerColorspaceSettings' = None
    '''Settings of color space sequencer is working in 

    :type: 'ColorManagedSequencerColorspaceSettings'
    '''

    show_keys_from_selected_only: bool = None
    '''Consider keyframes for active Object and/or its selected bones only (in timeline and when jumping between keyframes) 

    :type: bool
    '''

    show_subframe: bool = None
    '''Show current scene subframe and allow set it using interface tools 

    :type: bool
    '''

    sync_mode: typing.Union[str, int] = None
    '''How to sync playback 

    :type: typing.Union[str, int]
    '''

    timeline_markers: typing.Union[typing.List[
        'TimelineMarker'], 'bpy_prop_collection', 'TimelineMarkers'] = None
    '''Markers used in all timelines for the current scene 

    :type: typing.Union[typing.List['TimelineMarker'], 'bpy_prop_collection', 'TimelineMarkers']
    '''

    tool_settings: 'ToolSettings' = None
    '''

    :type: 'ToolSettings'
    '''

    transform_orientation_slots: typing.Union[
        typing.List['TransformOrientationSlot'], 'bpy_prop_collection'] = None
    '''

    :type: typing.Union[typing.List['TransformOrientationSlot'], 'bpy_prop_collection']
    '''

    unit_settings: 'UnitSettings' = None
    '''Unit editing settings 

    :type: 'UnitSettings'
    '''

    use_audio: bool = None
    '''Play back of audio from Sequence Editor will be muted 

    :type: bool
    '''

    use_audio_scrub: bool = None
    '''Play audio from Sequence Editor while scrubbing 

    :type: bool
    '''

    use_gravity: bool = None
    '''Use global gravity for all dynamics 

    :type: bool
    '''

    use_nodes: bool = None
    '''Enable the compositing node tree 

    :type: bool
    '''

    use_preview_range: bool = None
    '''Use an alternative start/end frame range for animation playback and view renders 

    :type: bool
    '''

    use_stamp_note: str = None
    '''User defined note for the render stamping 

    :type: str
    '''

    view_layers: typing.Union[typing.List['ViewLayer'], 'bpy_prop_collection',
                              'ViewLayers'] = None
    '''

    :type: typing.Union[typing.List['ViewLayer'], 'bpy_prop_collection', 'ViewLayers']
    '''

    view_settings: 'ColorManagedViewSettings' = None
    '''Color management settings applied on image before saving 

    :type: 'ColorManagedViewSettings'
    '''

    world: 'World' = None
    '''World used for rendering the scene 

    :type: 'World'
    '''

    def statistics(self, view_layer: 'ViewLayer') -> str:
        '''statistics 

        :param view_layer: Active layer 
        :type view_layer: 'ViewLayer'
        :rtype: str
        :return:  Statistics 
        '''
        pass

    def frame_set(self, frame: int, subframe: float = 0.0):
        '''Set scene frame updating all objects immediately 

        :param frame: Frame number to set 
        :type frame: int
        :param subframe: Sub-frame time, between 0.0 and 1.0 
        :type subframe: float
        '''
        pass

    def uvedit_aspect(self, object: 'Object') -> typing.List[float]:
        '''Get uv aspect for current object 

        :param object: Object 
        :type object: 'Object'
        :rtype: typing.List[float]
        :return:  aspect 
        '''
        pass

    def ray_cast(self,
                 view_layer: 'ViewLayer',
                 origin,
                 direction,
                 distance: float = 1.70141e+38):
        '''Cast a ray onto in object space 

        :param view_layer: Scene Layer 
        :type view_layer: 'ViewLayer'
        :param distance: Maximum distance 
        :type distance: float
        '''
        pass

    def sequence_editor_create(self, ) -> 'SequenceEditor':
        '''Ensure sequence editor is valid in this scene 

        :rtype: 'SequenceEditor'
        :return:  New sequence editor data or NULL 
        '''
        pass

    def sequence_editor_clear(self, ):
        '''Clear sequence editor in this scene 

        '''
        pass

    def alembic_export(self,
                       filepath: str,
                       frame_start: int = 1,
                       frame_end: int = 1,
                       xform_samples: int = 1,
                       geom_samples: int = 1,
                       shutter_open: float = 0.0,
                       shutter_close: float = 1.0,
                       selected_only: bool = False,
                       uvs: bool = True,
                       normals: bool = True,
                       vcolors: bool = False,
                       apply_subdiv: bool = True,
                       flatten: bool = False,
                       visible_objects_only: bool = False,
                       renderable_only: bool = False,
                       face_sets: bool = False,
                       subdiv_schema: bool = False,
                       export_hair: bool = True,
                       export_particles: bool = True,
                       compression_type: typing.Union[str, int] = 'OGAWA',
                       packuv: bool = False,
                       scale: float = 1.0,
                       triangulate: bool = False,
                       quad_method: typing.Union[str, int] = 'BEAUTY',
                       ngon_method: typing.Union[str, int] = 'BEAUTY'):
        '''Export to Alembic file (deprecated, use the Alembic export operator) 

        :param filepath: File Path, File path to write Alembic file 
        :type filepath: str
        :param frame_start: Start, Start Frame 
        :type frame_start: int
        :param frame_end: End, End Frame 
        :type frame_end: int
        :param xform_samples: Xform samples, Transform samples per frame 
        :type xform_samples: int
        :param geom_samples: Geom samples, Geometry samples per frame 
        :type geom_samples: int
        :param shutter_open: Shutter open 
        :type shutter_open: float
        :param shutter_close: Shutter close 
        :type shutter_close: float
        :param selected_only: Selected only, Export only selected objects 
        :type selected_only: bool
        :param uvs: UVs, Export UVs 
        :type uvs: bool
        :param normals: Normals, Export normals 
        :type normals: bool
        :param vcolors: Vertex colors, Export vertex colors 
        :type vcolors: bool
        :param apply_subdiv: Subsurfs as meshes, Export subdivision surfaces as meshes 
        :type apply_subdiv: bool
        :param flatten: Flatten hierarchy, Flatten hierarchy 
        :type flatten: bool
        :param visible_objects_only: Visible layers only, Export only objects in visible layers 
        :type visible_objects_only: bool
        :param renderable_only: Renderable objects only, Export only objects marked renderable in the outliner 
        :type renderable_only: bool
        :param face_sets: Facesets, Export face sets 
        :type face_sets: bool
        :param subdiv_schema: Use Alembic subdivision Schema, Use Alembic subdivision Schema 
        :type subdiv_schema: bool
        :param export_hair: Export Hair, Exports hair particle systems as animated curves 
        :type export_hair: bool
        :param export_particles: Export Particles, Exports non-hair particle systems 
        :type export_particles: bool
        :param compression_type: Compression 
        :type compression_type: typing.Union[str, int]
        :param packuv: Export with packed UV islands, Export with packed UV islands 
        :type packuv: bool
        :param scale: Scale, Value by which to enlarge or shrink the objects with respect to the world’s origin 
        :type scale: float
        :param triangulate: Triangulate, Export Polygons (Quads & NGons) as Triangles 
        :type triangulate: bool
        :param quad_method: Quad Method, Method for splitting the quads into trianglesBEAUTY Beauty , Split the quads in nice triangles, slower method.FIXED Fixed, Split the quads on the first and third vertices.FIXED_ALTERNATE Fixed Alternate, Split the quads on the 2nd and 4th vertices.SHORTEST_DIAGONAL Shortest Diagonal, Split the quads based on the distance between the vertices. 
        :type quad_method: typing.Union[str, int]
        :param ngon_method: Polygon Method, Method for splitting the polygons into trianglesBEAUTY Beauty , Split the quads in nice triangles, slower method.FIXED Fixed, Split the quads on the first and third vertices.FIXED_ALTERNATE Fixed Alternate, Split the quads on the 2nd and 4th vertices.SHORTEST_DIAGONAL Shortest Diagonal, Split the quads based on the distance between the vertices. 
        :type ngon_method: typing.Union[str, int]
        '''
        pass


class Screen(ID, bpy_struct):
    '''Screen data-block, defining the layout of areas in a window '''

    areas: typing.Union[typing.List['Area'], 'bpy_prop_collection'] = None
    '''Areas the screen is subdivided into 

    :type: typing.Union[typing.List['Area'], 'bpy_prop_collection']
    '''

    is_animation_playing: bool = None
    '''Animation playback is active 

    :type: bool
    '''

    is_temporary: bool = None
    '''

    :type: bool
    '''

    show_fullscreen: bool = None
    '''An area is maximized, filling this screen 

    :type: bool
    '''

    show_statusbar: bool = None
    '''Show status bar 

    :type: bool
    '''

    use_follow: bool = None
    '''Follow current frame in editors 

    :type: bool
    '''

    use_play_3d_editors: bool = None
    '''

    :type: bool
    '''

    use_play_animation_editors: bool = None
    '''

    :type: bool
    '''

    use_play_clip_editors: bool = None
    '''

    :type: bool
    '''

    use_play_image_editors: bool = None
    '''

    :type: bool
    '''

    use_play_node_editors: bool = None
    '''

    :type: bool
    '''

    use_play_properties_editors: bool = None
    '''

    :type: bool
    '''

    use_play_sequence_editors: bool = None
    '''

    :type: bool
    '''

    use_play_top_left_3d_editor: bool = None
    '''

    :type: bool
    '''


class Sound(ID, bpy_struct):
    '''Sound data-block referencing an external or packed sound file '''

    filepath: str = None
    '''Sound sample file used by this Sound data-block 

    :type: str
    '''

    packed_file: 'PackedFile' = None
    '''

    :type: 'PackedFile'
    '''

    use_memory_cache: bool = None
    '''The sound file is decoded and loaded into RAM 

    :type: bool
    '''

    use_mono: bool = None
    '''If the file contains multiple audio channels they are rendered to a single one 

    :type: bool
    '''

    factory = None
    '''The aud.Factory object of the sound. (readonly) '''

    def pack(self, ):
        '''Pack the sound into the current blend file 

        '''
        pass

    def unpack(self, method: typing.Union[str, int] = 'USE_LOCAL'):
        '''Unpack the sound to the samples filename 

        :param method: method, How to unpack 
        :type method: typing.Union[str, int]
        '''
        pass


class Speaker(ID, bpy_struct):
    '''Speaker data-block for 3D audio speaker objects '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    attenuation: float = None
    '''How strong the distance affects volume, depending on distance model 

    :type: float
    '''

    cone_angle_inner: float = None
    '''Angle of the inner cone, in degrees, inside the cone the volume is 100 % 

    :type: float
    '''

    cone_angle_outer: float = None
    '''Angle of the outer cone, in degrees, outside this cone the volume is the outer cone volume, between inner and outer cone the volume is interpolated 

    :type: float
    '''

    cone_volume_outer: float = None
    '''Volume outside the outer cone 

    :type: float
    '''

    distance_max: float = None
    '''Maximum distance for volume calculation, no matter how far away the object is 

    :type: float
    '''

    distance_reference: float = None
    '''Reference distance at which volume is 100 % 

    :type: float
    '''

    muted: bool = None
    '''Mute the speaker 

    :type: bool
    '''

    pitch: float = None
    '''Playback pitch of the sound 

    :type: float
    '''

    sound: 'Sound' = None
    '''Sound data-block used by this speaker 

    :type: 'Sound'
    '''

    volume: float = None
    '''How loud the sound is 

    :type: float
    '''

    volume_max: float = None
    '''Maximum volume, no matter how near the object is 

    :type: float
    '''

    volume_min: float = None
    '''Minimum volume, no matter how far away the object is 

    :type: float
    '''


class Text(ID, bpy_struct):
    '''Text data-block referencing an external or packed text file '''

    current_character: int = None
    '''Index of current character in current line, and also start index of character in selection if one exists 

    :type: int
    '''

    current_line: 'TextLine' = None
    '''Current line, and start line of selection if one exists 

    :type: 'TextLine'
    '''

    current_line_index: int = None
    '''Index of current TextLine in TextLine collection 

    :type: int
    '''

    filepath: str = None
    '''Filename of the text file 

    :type: str
    '''

    indentation: typing.Union[str, int] = None
    '''Use tabs or spaces for indentation 

    :type: typing.Union[str, int]
    '''

    is_dirty: bool = None
    '''Text file has been edited since last save 

    :type: bool
    '''

    is_in_memory: bool = None
    '''Text file is in memory, without a corresponding file on disk 

    :type: bool
    '''

    is_modified: bool = None
    '''Text file on disk is different than the one in memory 

    :type: bool
    '''

    lines: typing.Union[typing.List['TextLine'], 'bpy_prop_collection'] = None
    '''Lines of text 

    :type: typing.Union[typing.List['TextLine'], 'bpy_prop_collection']
    '''

    select_end_character: int = None
    '''Index of character after end of selection in the selection end line 

    :type: int
    '''

    select_end_line: 'TextLine' = None
    '''End line of selection 

    :type: 'TextLine'
    '''

    select_end_line_index: int = None
    '''Index of last TextLine in selection 

    :type: int
    '''

    use_module: bool = None
    '''Run this text as a script on loading, Text name must end with “.py” 

    :type: bool
    '''

    def clear(self, ):
        '''clear the text block 

        '''
        pass

    def write(self, text: str):
        '''write text at the cursor location and advance to the end of the text block 

        :param text: New text for this data-block 
        :type text: str
        '''
        pass

    def is_syntax_highlight_supported(self, ) -> bool:
        '''Returns True if the editor supports syntax highlighting for the current text datablock 

        :rtype: bool
        '''
        pass

    def select_set(self, line_start: int, char_start: int, line_end: int,
                   char_end: int):
        '''Set selection range by line and character index 

        :param line_start: Start Line 
        :type line_start: int
        :param char_start: Start Character 
        :type char_start: int
        :param line_end: End Line 
        :type line_end: int
        :param char_end: End Character 
        :type char_end: int
        '''
        pass

    def cursor_set(self, line: int, character: int = 0, select: bool = False):
        '''Set cursor by line and (optionally) character index 

        :param line: Line 
        :type line: int
        :param character: Character 
        :type character: int
        :param select: Select when moving the cursor 
        :type select: bool
        '''
        pass

    def as_module(self, ):
        '''

        '''
        pass

    def as_string(self, ):
        '''Return the text as a string. 

        '''
        pass

    def from_string(self, string):
        '''Replace text with this string. 

        '''
        pass


class Texture(ID, bpy_struct):
    '''Texture data-block used by materials, lights, worlds and brushes '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    color_ramp: 'ColorRamp' = None
    '''

    :type: 'ColorRamp'
    '''

    contrast: float = None
    '''Adjust the contrast of the texture 

    :type: float
    '''

    factor_blue: float = None
    '''

    :type: float
    '''

    factor_green: float = None
    '''

    :type: float
    '''

    factor_red: float = None
    '''

    :type: float
    '''

    intensity: float = None
    '''Adjust the brightness of the texture 

    :type: float
    '''

    node_tree: 'NodeTree' = None
    '''Node tree for node-based textures 

    :type: 'NodeTree'
    '''

    saturation: float = None
    '''Adjust the saturation of colors in the texture 

    :type: float
    '''

    type: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    use_clamp: bool = None
    '''Set negative texture RGB and intensity values to zero, for some uses like displacement this option can be disabled to get the full range 

    :type: bool
    '''

    use_color_ramp: bool = None
    '''Toggle color ramp operations 

    :type: bool
    '''

    use_nodes: bool = None
    '''Make this a node-based texture 

    :type: bool
    '''

    use_preview_alpha: bool = None
    '''Show Alpha in Preview Render 

    :type: bool
    '''

    users_material = None
    '''Materials that use this texture (readonly) '''

    users_object_modifier = None
    '''Object modifiers that use this texture (readonly) '''

    def evaluate(self, value) -> typing.List[float]:
        '''Evaluate the texture at the coordinates given 

        :rtype: typing.List[float]
        :return:  Result 
        '''
        pass


class VectorFont(ID, bpy_struct):
    '''Vector font for Text objects '''

    filepath: str = None
    '''

    :type: str
    '''

    packed_file: 'PackedFile' = None
    '''

    :type: 'PackedFile'
    '''

    def pack(self, ):
        '''Pack the font into the current blend file 

        '''
        pass

    def unpack(self, method: typing.Union[str, int] = 'USE_LOCAL'):
        '''Unpack the font to the samples filename 

        :param method: method, How to unpack 
        :type method: typing.Union[str, int]
        '''
        pass


class WindowManager(ID, bpy_struct):
    '''Window manager data-block defining open windows and other user interface data '''

    addon_filter: typing.Union[str, int] = None
    '''Filter add-ons by category 

    :type: typing.Union[str, int]
    '''

    addon_search: str = None
    '''Search within the selected filter 

    :type: str
    '''

    addon_support: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Display support level 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    clipboard: str = None
    '''

    :type: str
    '''

    keyconfigs: typing.Union[typing.List['KeyConfig'], 'bpy_prop_collection',
                             'KeyConfigurations'] = None
    '''Registered key configurations 

    :type: typing.Union[typing.List['KeyConfig'], 'bpy_prop_collection', 'KeyConfigurations']
    '''

    operators: typing.Union[typing.
                            List['Operator'], 'bpy_prop_collection'] = None
    '''Operator registry 

    :type: typing.Union[typing.List['Operator'], 'bpy_prop_collection']
    '''

    preset_name: str = None
    '''Name for new preset 

    :type: str
    '''

    windows: typing.Union[typing.List['Window'], 'bpy_prop_collection'] = None
    '''Open windows 

    :type: typing.Union[typing.List['Window'], 'bpy_prop_collection']
    '''

    def event_timer_add(self, time_step: float,
                        window: 'Window' = None) -> 'Timer':
        '''Add a timer to the given window, to generate periodic ‘TIMER’ events 

        :param time_step: Time Step, Interval in seconds between timer events 
        :type time_step: float
        :param window: Window to attach the timer to, or None 
        :type window: 'Window'
        :rtype: 'Timer'
        '''
        pass

    def event_timer_remove(self, timer):
        '''event_timer_remove 

        '''
        pass

    def progress_begin(self, min: float, max: float):
        '''Start progress report 

        :param min: min, any value in range [0,9999] 
        :type min: float
        :param max: max, any value in range [min+1,9998] 
        :type max: float
        '''
        pass

    def progress_update(self, value: float):
        '''Update the progress feedback 

        :param value: value, Any value between min and max as set in progress_begin() 
        :type value: float
        '''
        pass

    def progress_end(self, ):
        '''Terminate progress report 

        '''
        pass

    def print_undo_steps(self, ):
        '''print_undo_steps 

        '''
        pass

    def popover(self,
                draw_func,
                *,
                ui_units_x=0,
                keymap=None,
                from_active_button=False):
        '''

        '''
        pass

    def popup_menu(self, draw_func, title='', icon='NONE'):
        '''Note that they will not block the scripts execution, so the caller can’t wait for user input. 

        '''
        pass

    def popup_menu_pie(self, event, draw_func, title='', icon='NONE'):
        '''

        '''
        pass

    def draw_cursor_add(self, ):
        '''Undocumented contribute <https://developer.blender.org/T51061> 

        '''
        pass

    def draw_cursor_remove(self, ):
        '''Undocumented contribute <https://developer.blender.org/T51061> 

        '''
        pass


class WorkSpace(ID, bpy_struct):
    '''Workspace data-block, defining the working environment for the user '''

    object_mode: typing.Union[str, int] = None
    '''Switch to this object mode when activating the workspace 

    :type: typing.Union[str, int]
    '''

    owner_ids: typing.Union[typing.List['wmOwnerID'], 'bpy_prop_collection',
                            'wmOwnerIDs'] = None
    '''

    :type: typing.Union[typing.List['wmOwnerID'], 'bpy_prop_collection', 'wmOwnerIDs']
    '''

    screens: typing.Union[typing.List['Screen'], 'bpy_prop_collection'] = None
    '''Screen layouts of a workspace 

    :type: typing.Union[typing.List['Screen'], 'bpy_prop_collection']
    '''

    tools: typing.Union[typing.List['WorkSpaceTool'], 'bpy_prop_collection',
                        'wmTools'] = None
    '''

    :type: typing.Union[typing.List['WorkSpaceTool'], 'bpy_prop_collection', 'wmTools']
    '''

    use_filter_by_owner: bool = None
    '''Filter the UI by tags 

    :type: bool
    '''

    def status_text_set(self, text):
        '''Set the status text or None to clear, When text is a function, this will be called with the (header, context) arguments. 

        '''
        pass


class World(ID, bpy_struct):
    '''World data-block describing the environment and ambient lighting of a scene '''

    animation_data: 'AnimData' = None
    '''Animation data for this data-block 

    :type: 'AnimData'
    '''

    color: typing.List[float] = None
    '''Color of the background 

    :type: typing.List[float]
    '''

    cycles = None
    '''Cycles world settings '''

    cycles_visibility = None
    '''Cycles visibility settings '''

    light_settings: 'WorldLighting' = None
    '''World lighting settings 

    :type: 'WorldLighting'
    '''

    mist_settings: 'WorldMistSettings' = None
    '''World mist settings 

    :type: 'WorldMistSettings'
    '''

    node_tree: 'NodeTree' = None
    '''Node tree for node based worlds 

    :type: 'NodeTree'
    '''

    use_nodes: bool = None
    '''Use shader nodes to render the world 

    :type: bool
    '''


class Itasc(IKParam, bpy_struct):
    '''Parameters for the iTaSC IK solver '''

    damping_epsilon: float = None
    '''Singular value under which damping is progressively applied (higher values=more stability, less reactivity - default=0.1) 

    :type: float
    '''

    damping_max: float = None
    '''Maximum damping coefficient when singular value is nearly 0 (higher values=more stability, less reactivity - default=0.5) 

    :type: float
    '''

    feedback: float = None
    '''Feedback coefficient for error correction, average response time is 1/feedback (default=20) 

    :type: float
    '''

    iterations: int = None
    '''Maximum number of iterations for convergence in case of reiteration 

    :type: int
    '''

    mode: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    precision: float = None
    '''Precision of convergence in case of reiteration 

    :type: float
    '''

    reiteration_method: typing.Union[str, int] = None
    '''Defines if the solver is allowed to reiterate (converge until precision is met) on none, first or all frames 

    :type: typing.Union[str, int]
    '''

    solver: typing.Union[str, int] = None
    '''Solving method selection: automatic damping or manual damping 

    :type: typing.Union[str, int]
    '''

    step_count: int = None
    '''Divide the frame interval into this many steps 

    :type: int
    '''

    step_max: float = None
    '''Higher bound for timestep in second in case of automatic substeps 

    :type: float
    '''

    step_min: float = None
    '''Lower bound for timestep in second in case of automatic substeps 

    :type: float
    '''

    use_auto_step: bool = None
    '''Automatically determine the optimal number of steps for best performance/accuracy trade off 

    :type: bool
    '''

    velocity_max: float = None
    '''Maximum joint velocity in rad/s (default=50) 

    :type: float
    '''


class LineStyleAlphaModifier(LineStyleModifier, bpy_struct):
    '''Base type to define alpha transparency modifiers '''

    pass


class LineStyleColorModifier(LineStyleModifier, bpy_struct):
    '''Base type to define line color modifiers '''

    pass


class LineStyleGeometryModifier(LineStyleModifier, bpy_struct):
    '''Base type to define stroke geometry modifiers '''

    pass


class LineStyleThicknessModifier(LineStyleModifier, bpy_struct):
    '''Base type to define line thickness modifiers '''

    pass


class ArmatureModifier(Modifier, bpy_struct):
    '''Armature deformation modifier '''

    invert_vertex_group: bool = None
    '''Invert vertex group influence 

    :type: bool
    '''

    object: 'Object' = None
    '''Armature object to deform with 

    :type: 'Object'
    '''

    use_bone_envelopes: bool = None
    '''Bind Bone envelopes to armature modifier 

    :type: bool
    '''

    use_deform_preserve_volume: bool = None
    '''Deform rotation interpolation with quaternions 

    :type: bool
    '''

    use_multi_modifier: bool = None
    '''Use same input as previous modifier, and mix results using overall vgroup 

    :type: bool
    '''

    use_vertex_groups: bool = None
    '''Bind vertex groups to armature modifier 

    :type: bool
    '''

    vertex_group: str = None
    '''Name of Vertex Group which determines influence of modifier per point 

    :type: str
    '''


class ArrayModifier(Modifier, bpy_struct):
    '''Array duplication modifier '''

    constant_offset_displace: typing.List[float] = None
    '''Value for the distance between arrayed items 

    :type: typing.List[float]
    '''

    count: int = None
    '''Number of duplicates to make 

    :type: int
    '''

    curve: 'Object' = None
    '''Curve object to fit array length to 

    :type: 'Object'
    '''

    end_cap: 'Object' = None
    '''Mesh object to use as an end cap 

    :type: 'Object'
    '''

    fit_length: float = None
    '''Length to fit array within 

    :type: float
    '''

    fit_type: typing.Union[str, int] = None
    '''Array length calculation method 

    :type: typing.Union[str, int]
    '''

    merge_threshold: float = None
    '''Limit below which to merge vertices 

    :type: float
    '''

    offset_object: 'Object' = None
    '''Use the location and rotation of another object to determine the distance and rotational change between arrayed items 

    :type: 'Object'
    '''

    offset_u: float = None
    '''Amount to offset array UVs on the U axis 

    :type: float
    '''

    offset_v: float = None
    '''Amount to offset array UVs on the V axis 

    :type: float
    '''

    relative_offset_displace: typing.List[float] = None
    '''The size of the geometry will determine the distance between arrayed items 

    :type: typing.List[float]
    '''

    start_cap: 'Object' = None
    '''Mesh object to use as a start cap 

    :type: 'Object'
    '''

    use_constant_offset: bool = None
    '''Add a constant offset 

    :type: bool
    '''

    use_merge_vertices: bool = None
    '''Merge vertices in adjacent duplicates 

    :type: bool
    '''

    use_merge_vertices_cap: bool = None
    '''Merge vertices in first and last duplicates 

    :type: bool
    '''

    use_object_offset: bool = None
    '''Add another object’s transformation to the total offset 

    :type: bool
    '''

    use_relative_offset: bool = None
    '''Add an offset relative to the object’s bounding box 

    :type: bool
    '''


class BevelModifier(Modifier, bpy_struct):
    '''Bevel modifier to make edges and vertices more rounded '''

    angle_limit: float = None
    '''Angle above which to bevel edges 

    :type: float
    '''

    custom_profile: 'CurveProfile' = None
    '''The path for the custom profile 

    :type: 'CurveProfile'
    '''

    face_strength_mode: typing.Union[str, int] = None
    '''Whether to set face strength, and which faces to set it on 

    :type: typing.Union[str, int]
    '''

    harden_normals: bool = None
    '''Match normals of new faces to adjacent faces 

    :type: bool
    '''

    limit_method: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''

    loop_slide: bool = None
    '''Prefer sliding along edges to having even widths 

    :type: bool
    '''

    mark_seam: bool = None
    '''Mark Seams along beveled edges 

    :type: bool
    '''

    mark_sharp: bool = None
    '''Mark beveled edges as sharp 

    :type: bool
    '''

    material: int = None
    '''Material index of generated faces, -1 for automatic 

    :type: int
    '''

    miter_inner: typing.Union[str, int] = None
    '''Pattern to use for inside of miters 

    :type: typing.Union[str, int]
    '''

    miter_outer: typing.Union[str, int] = None
    '''Pattern to use for outside of miters 

    :type: typing.Union[str, int]
    '''

    offset_type: typing.Union[str, int] = None
    '''What distance Width measures 

    :type: typing.Union[str, int]
    '''

    profile: float = None
    '''The profile shape (0.5 = round) 

    :type: float
    '''

    segments: int = None
    '''Number of segments for round edges/verts 

    :type: int
    '''

    spread: float = None
    '''Spread distance for inner miter arcs 

    :type: float
    '''

    use_clamp_overlap: bool = None
    '''Clamp the width to avoid overlap 

    :type: bool
    '''

    use_custom_profile: bool = None
    '''Whether to use a user inputed curve for the bevel’s profile 

    :type: bool
    '''

    use_only_vertices: bool = None
    '''Bevel verts/corners, not edges 

    :type: bool
    '''

    vertex_group: str = None
    '''Vertex group name 

    :type: str
    '''

    vmesh_method: typing.Union[str, int] = None
    '''The method to use to create the mesh at intersections 

    :type: typing.Union[str, int]
    '''

    width: float = None
    '''Bevel amount 

    :type: float
    '''

    width_pct: float = None
    '''Bevel amount for percentage method 

    :type: float
    '''


class BooleanModifier(Modifier, bpy_struct):
    '''Boolean operations modifier '''

    debug_options: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Debugging options, only when started with ‘-d’ 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    double_threshold: float = None
    '''Threshold for checking overlapping geometry 

    :type: float
    '''

    object: 'Object' = None
    '''Mesh object to use for Boolean operation 

    :type: 'Object'
    '''

    operation: typing.Union[str, int] = None
    '''

    :type: typing.Union[str, int]
    '''


class BuildModifier(Modifier, bpy_struct):
    '''Build effect modifier '''

    frame_duration: float = None
    '''Total time the build effect requires 

    :type: float
    '''

    frame_start: float = None
    '''Start frame of the effect 

    :type: float
    '''

    seed: int = None
    '''Seed for random if used 

    :type: int
    '''

    use_random_order: bool = None
    '''Randomize the faces or edges during build 

    :type: bool
    '''

    use_reverse: bool = None
    '''Deconstruct the mesh instead of building it 

    :type: bool
    '''


class CastModifier(Modifier, bpy_struct):
    '''Modifier to cast to other shapes '''

    cast_type: typing.Union[str, int] = None
    '''Target object shape 

    :type: typing.Union[str, int]
    '''

    factor: float = None
    '''

    :type: float
    '''

    object: 'Object' = None
    '''Control object: if available, its location determines the center of the effect 

    :type: 'Object'
    '''

    radius: float = None
    '''Only deform vertices within this distance from the center of the effect (leave as 0 for infinite.) 

    :type: float
    '''

    size: float = None
    '''Size of projection shape (leave as 0 for auto) 

    :type: float
    '''

    use_radius_as_size: bool = None
    '''Use radius as size of projection shape (0 = auto) 

    :type: bool
    '''

    use_transform: bool = None
    '''Use object transform to control projection shape 

    :type: bool
    '''

    use_x: bool = None
    '''

    :type: bool
    '''

    use_y: bool = None
    '''

    :type: bool
    '''

    use_z: bool = None
    '''

    :type: bool
    '''

    vertex_group: str = None
    '''Vertex group name 

    :type: str
    '''


class ClothModifier(Modifier, bpy_struct):
    '''Cloth simulation modifier '''

    collision_settings: 'ClothCollisionSettings' = None
    '''

    :type: 'ClothCollisionSettings'
    '''

    hair_grid_max: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    hair_grid_min: typing.List[float] = None
    '''

    :type: typing.List[float]
    '''

    hair_grid_resolution: typing.List[int] = None
    '''

    :type: typing.List[int]
    '''

    point_cache: 'PointCache' = None
    '''

    :type: 'PointCache'
    '''

    settings: 'ClothSettings' = None
    '''

    :type: 'ClothSettings'
    '''

    solver_result: 'ClothSolverResult' = None
    '''

    :type: 'ClothSolverResult'
    '''


class CollisionModifier(Modifier, bpy_struct):
    '''Collision modifier defining modifier stack position used for collision '''

    settings: 'CollisionSettings' = None
    '''

    :type: 'CollisionSettings'
    '''


class CorrectiveSmoothModifier(Modifier, bpy_struct):
    '''Correct distortion caused by deformation '''

    factor: float = None
    '''Smooth factor effect 

    :type: float
    '''

    invert_vertex_group: bool = None
    '''Invert vertex group influence 

    :type: bool
    '''

    is_bind: bool = None
    '''

    :type: bool
    '''

    iterations: int = None
    '''

    :type: int
    '''

    rest_source: typing.Union[str, int] = None
    '''Select the source of rest positions 

    :type: typing.Union[str, int]
    '''

    smooth_type: typing.Union[str, int] = None
    '''Method used for smoothing 

    :type: typing.Union[str, int]
    '''

    use_only_smooth: bool = None
    '''Apply smoothing without reconstructing the surface 

    :type: bool
    '''

    use_pin_boundary: bool = None
    '''Excludes boundary vertices from being smoothed 

    :type: bool
    '''

    vertex_group: str = None
    '''Name of Vertex Group which determines influence of modifier per point 

    :type: str
    '''


class CurveModifier(Modifier, bpy_struct):
    '''Curve deformation modifier '''

    deform_axis: typing.Union[str, int] = None
    '''The axis that the curve deforms along 

    :type: typing.Union[str, int]
    '''

    object: 'Object' = None
    '''Curve object to deform with 

    :type: 'Object'
    '''

    vertex_group: str = None
    '''Name of Vertex Group which determines influence of modifier per point 

    :type: str
    '''


class DataTransferModifier(Modifier, bpy_struct):
    '''Modifier transferring some data from a source mesh '''

    data_types_edges: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Which edge data layers to transfer 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    data_types_loops: typing.Union[typing.Set[str], typing.Set[int]] = None
    '''Which face corner data layers to transfer 

    :type: typing.Union[typing.Set[str], typing.Set[int]]
    '''

    data_types_polys: typing.Union