import filecmp
import os
import sys
import unittest
import sbol3
from sbol_utilities.graph_sbol import graph_sbol

# Path to load sbol files from
TESTFILE_DIR = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'test_files')


class GraphSbol(unittest.TestCase):

    # Graphviz generates a different file on non-linux platforms, and we
    # think that is ok. For now, skip this test on non-linux platforms.
    @unittest.skipUnless(sys.platform == 'linux',
                         'Skip graphviz on non-linux platforms')
    def test_dotfile_generation(self):
        """
        Tests by creating and comparing dot file generated by graphviz with an existing proper file
        """
        # Open and create sbol file
        sbol_file: str = os.path.join(TESTFILE_DIR, 'BBa_J23101.nt')
        doc = sbol3.Document()
        doc.read(sbol_file)
        file_format: str = "dot"
        view_now: bool = False
        outfile: str = sbol_file.split(".")[0] + "_test"
        graph_sbol(doc, file_format, view_now, outfile)

        # compare generated file and file expected
        generated_file: str = outfile + "." + file_format
        proper_file: str = os.path.join(TESTFILE_DIR, 'BBa_J23101.dot')
        self.assertTrue(filecmp.cmp(generated_file, proper_file, shallow=False))

        # remove generated and intermediate digraph files
        # TODO: switch to using automatically GC'ed tempdir
        os.remove(generated_file)
        os.remove(outfile)


if __name__ == '__main__':
    unittest.main()
