#!/usr/bin/env node
//  This file is a standalone bundle encapsulating https://github.com/sboltools/sbolgraph v0.45.0
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/main.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node_modules/@rdfoo/n3/N3.js":
/*!**************************************!*\
  !*** ./node_modules/@rdfoo/n3/N3.js ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var require;// Replace local require by a lazy loader
var globalRequire = require;
//require = function () {};

// Expose submodules
var exports = module.exports = {
  Lexer:        __webpack_require__(/*! ./lib/N3Lexer */ "./node_modules/@rdfoo/n3/lib/N3Lexer.js"),
  Parser:       __webpack_require__(/*! ./lib/N3Parser */ "./node_modules/@rdfoo/n3/lib/N3Parser.js"),
  Writer:       __webpack_require__(/*! ./lib/N3Writer */ "./node_modules/@rdfoo/n3/lib/N3Writer.js"),
  Store:        __webpack_require__(/*! ./lib/N3Store */ "./node_modules/@rdfoo/n3/lib/N3Store.js"),
  StreamParser: __webpack_require__(/*! ./lib/N3StreamParser */ "./node_modules/@rdfoo/n3/lib/N3StreamParser.js"),
  StreamWriter: __webpack_require__(/*! ./lib/N3StreamWriter */ "./node_modules/@rdfoo/n3/lib/N3StreamWriter.js"),
  Util:         __webpack_require__(/*! ./lib/N3Util */ "./node_modules/@rdfoo/n3/lib/N3Util.js"),
};

// Load submodules on first access
Object.keys(exports).forEach(function (submodule) {
  Object.defineProperty(exports, submodule, {
    configurable: true,
    enumerable: true,
    get: function () {
      delete exports[submodule];
      return exports[submodule] = __webpack_require__("./node_modules/@rdfoo/n3/lib sync recursive ^\\.\\/N3.*$")("./N3" + submodule);
    },
  });
});


/***/ }),

/***/ "./node_modules/@rdfoo/n3/lib sync recursive ^\\.\\/N3.*$":
/*!****************************************************!*\
  !*** ./node_modules/@rdfoo/n3/lib sync ^\.\/N3.*$ ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./N3Lexer": "./node_modules/@rdfoo/n3/lib/N3Lexer.js",
	"./N3Lexer.js": "./node_modules/@rdfoo/n3/lib/N3Lexer.js",
	"./N3Parser": "./node_modules/@rdfoo/n3/lib/N3Parser.js",
	"./N3Parser.js": "./node_modules/@rdfoo/n3/lib/N3Parser.js",
	"./N3Store": "./node_modules/@rdfoo/n3/lib/N3Store.js",
	"./N3Store.js": "./node_modules/@rdfoo/n3/lib/N3Store.js",
	"./N3StreamParser": "./node_modules/@rdfoo/n3/lib/N3StreamParser.js",
	"./N3StreamParser.js": "./node_modules/@rdfoo/n3/lib/N3StreamParser.js",
	"./N3StreamWriter": "./node_modules/@rdfoo/n3/lib/N3StreamWriter.js",
	"./N3StreamWriter.js": "./node_modules/@rdfoo/n3/lib/N3StreamWriter.js",
	"./N3Util": "./node_modules/@rdfoo/n3/lib/N3Util.js",
	"./N3Util.js": "./node_modules/@rdfoo/n3/lib/N3Util.js",
	"./N3Writer": "./node_modules/@rdfoo/n3/lib/N3Writer.js",
	"./N3Writer.js": "./node_modules/@rdfoo/n3/lib/N3Writer.js"
};


function webpackContext(req) {
	var id = webpackContextResolve(req);
	return __webpack_require__(id);
}
function webpackContextResolve(req) {
	if(!__webpack_require__.o(map, req)) {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	}
	return map[req];
}
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = "./node_modules/@rdfoo/n3/lib sync recursive ^\\.\\/N3.*$";

/***/ }),

/***/ "./node_modules/@rdfoo/n3/lib/N3Lexer.js":
/*!***********************************************!*\
  !*** ./node_modules/@rdfoo/n3/lib/N3Lexer.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

// **N3Lexer** tokenizes N3 documents.
var fromCharCode = String.fromCharCode;
var immediately = typeof setImmediate === 'function' ? setImmediate :
                  function setImmediate(func) { setTimeout(func, 0); };

// Regular expression and replacement string to escape N3 strings.
// Note how we catch invalid unicode sequences separately (they will trigger an error).
var escapeSequence = /\\u([a-fA-F0-9]{4})|\\U([a-fA-F0-9]{8})|\\[uU]|\\(.)/g;
var escapeReplacements = { '\\': '\\', "'": "'", '"': '"',
                           'n': '\n', 'r': '\r', 't': '\t', 'f': '\f', 'b': '\b',
                           '_': '_', '~': '~', '.': '.', '-': '-', '!': '!', '$': '$', '&': '&',
                           '(': '(', ')': ')', '*': '*', '+': '+', ',': ',', ';': ';', '=': '=',
                           '/': '/', '?': '?', '#': '#', '@': '@', '%': '%' };
var illegalIriChars = /[\x00-\x20<>\\"\{\}\|\^\`]/;

// ## Constructor
function N3Lexer(options) {
  if (!(this instanceof N3Lexer))
    return new N3Lexer(options);

  // In line mode (N-Triples or N-Quads), only simple features may be parsed
  if (options && options.lineMode) {
    // Don't tokenize special literals
    this._tripleQuotedString = this._number = this._boolean = /$0^/;
    // Swap the tokenize method for a restricted version
    var self = this;
    this._tokenize = this.tokenize;
    this.tokenize = function (input, callback) {
      this._tokenize(input, function (error, token) {
        if (!error && /^(?:IRI|prefixed|literal|langcode|type|\.|eof)$/.test(token.type))
          callback && callback(error, token);
        else
          callback && callback(error || self._syntaxError(token.type, callback = null));
      });
    };
  }
}

N3Lexer.prototype = {
  // ## Regular expressions
  // It's slightly faster to have these as properties than as in-scope variables.

  _iri: /^<((?:[^>\\]|\\[uU])+)>/, // IRI with escape sequences; needs sanity check after unescaping
  _unescapedIri: /^<([^\x00-\x20<>\\"\{\}\|\^\`]*)>/, // IRI without escape sequences; no unescaping
  _unescapedString: /^"[^"\\]+"(?=[^"\\])/, // non-empty string without escape sequences
  _singleQuotedString: /^"[^"\\]*(?:\\.[^"\\]*)*"(?=[^"\\])|^'[^'\\]*(?:\\.[^'\\]*)*'(?=[^'\\])/,
  _tripleQuotedString: /^""("[^"\\]*(?:(?:\\.|"(?!""))[^"\\]*)*")""|^''('[^'\\]*(?:(?:\\.|'(?!''))[^'\\]*)*')''/,
  _langcode: /^@([a-z]+(?:-[a-z0-9]+)*)(?=[^a-z0-9\-])/i,
  _prefix: /^((?:[A-Za-z\xc0-\xd6\xd8-\xf6\xf8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]|[\ud800-\udb7f][\udc00-\udfff])(?:\.?[\-0-9A-Z_a-z\xb7\xc0-\xd6\xd8-\xf6\xf8-\u037d\u037f-\u1fff\u200c\u200d\u203f\u2040\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]|[\ud800-\udb7f][\udc00-\udfff])*)?:(?=[#\s<])/,
  _prefixed: /^((?:[A-Za-z\xc0-\xd6\xd8-\xf6\xf8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]|[\ud800-\udb7f][\udc00-\udfff])(?:\.?[\-0-9A-Z_a-z\xb7\xc0-\xd6\xd8-\xf6\xf8-\u037d\u037f-\u1fff\u200c\u200d\u203f\u2040\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]|[\ud800-\udb7f][\udc00-\udfff])*)?:((?:(?:[0-:A-Z_a-z\xc0-\xd6\xd8-\xf6\xf8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]|[\ud800-\udb7f][\udc00-\udfff]|%[0-9a-fA-F]{2}|\\[!#-\/;=?\-@_~])(?:(?:[\.\-0-:A-Z_a-z\xb7\xc0-\xd6\xd8-\xf6\xf8-\u037d\u037f-\u1fff\u200c\u200d\u203f\u2040\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]|[\ud800-\udb7f][\udc00-\udfff]|%[0-9a-fA-F]{2}|\\[!#-\/;=?\-@_~])*(?:[\-0-:A-Z_a-z\xb7\xc0-\xd6\xd8-\xf6\xf8-\u037d\u037f-\u1fff\u200c\u200d\u203f\u2040\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]|[\ud800-\udb7f][\udc00-\udfff]|%[0-9a-fA-F]{2}|\\[!#-\/;=?\-@_~]))?)?)(?=\.?[,;\s#()\[\]\{\}"'<])/,
  _blank: /^_:((?:[0-9A-Z_a-z\xc0-\xd6\xd8-\xf6\xf8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]|[\ud800-\udb7f][\udc00-\udfff])(?:\.?[\-0-9A-Z_a-z\xb7\xc0-\xd6\xd8-\xf6\xf8-\u037d\u037f-\u1fff\u200c\u200d\u203f\u2040\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]|[\ud800-\udb7f][\udc00-\udfff])*)(?=\.?[,;:\s#()\[\]\{\}"'<])/,
  _number: /^[\-+]?(?:\d+\.?\d*([eE](?:[\-\+])?\d+)|\d*\.?\d+)(?=[.,;:\s#()\[\]\{\}"'<])/,
  _boolean: /^(?:true|false)(?=[.,;:\s#()\[\]\{\}"'<])/,
  _keyword: /^@[a-z]+(?=[\s#<:])/,
  _sparqlKeyword: /^(?:PREFIX|BASE|GRAPH)(?=[\s#<:])/i,
  _shortPredicates: /^a(?=\s+|<)/,
  _newline: /^[ \t]*(?:#[^\n\r]*)?(?:\r\n|\n|\r)[ \t]*/,
  _whitespace: /^[ \t]+/,
  _endOfFile: /^(?:#[^\n\r]*)?$/,

  // ## Private methods

  // ### `_tokenizeToEnd` tokenizes as for as possible, emitting tokens through the callback.
  _tokenizeToEnd: function (callback, inputFinished) {
    // Continue parsing as far as possible; the loop will return eventually.
    var input = this._input;
    while (true) {
      // Count and skip whitespace lines.
      var whiteSpaceMatch;
      while (whiteSpaceMatch = this._newline.exec(input))
        input = input.substr(whiteSpaceMatch[0].length, input.length), this._line++;
      // Skip whitespace on current line.
      if (whiteSpaceMatch = this._whitespace.exec(input))
        input = input.substr(whiteSpaceMatch[0].length, input.length);

      // Stop for now if we're at the end.
      if (this._endOfFile.test(input)) {
        // If the input is finished, emit EOF.
        if (inputFinished)
          callback(input = null, { line: this._line, type: 'eof', value: '', prefix: '' });
        return this._input = input;
      }

      // Look for specific token types based on the first character.
      var line = this._line, type = '', value = '', prefix = '',
          firstChar = input[0], match = null, matchLength = 0, unescaped, inconclusive = false;
      switch (firstChar) {
      case '^':
        // Try to match a type.
        if (input.length === 1) break;
        else if (input[1] !== '^') return reportSyntaxError(this);
        this._prevTokenType = '^';
        // Move to type IRI or prefixed name.
        input = input.substr(2);
        if (input[0] !== '<') {
          inconclusive = true;
          break;
        }
        // Fall through in case the type is an IRI.

      case '<':
        // Try to find a full IRI without escape sequences.
        if (match = this._unescapedIri.exec(input))
          type = 'IRI', value = match[1];
        // Try to find a full IRI with escape sequences.
        else if (match = this._iri.exec(input)) {
          unescaped = this._unescape(match[1]);
          if (unescaped === null || illegalIriChars.test(unescaped))
            return reportSyntaxError(this);
          type = 'IRI', value = unescaped;
        }
        break;

      case '_':
        // Try to find a blank node. Since it can contain (but not end with) a dot,
        // we always need a non-dot character before deciding it is a prefixed name.
        // Therefore, try inserting a space if we're at the end of the input.
        if ((match = this._blank.exec(input)) ||
            inputFinished && (match = this._blank.exec(input + ' ')))
          type = 'prefixed', prefix = '_', value = match[1];
        break;

      case '"':
      case "'":
        // Try to find a non-empty double-quoted literal without escape sequences.
        if (match = this._unescapedString.exec(input))
          type = 'literal', value = match[0];
        // Try to find any other literal wrapped in a pair of single or double quotes.
        else if (match = this._singleQuotedString.exec(input)) {
          unescaped = this._unescape(match[0]);
          if (unescaped === null)
            return reportSyntaxError(this);
          type = 'literal', value = unescaped.replace(/^'|'$/g, '"');
        }
        // Try to find a literal wrapped in three pairs of single or double quotes.
        else if (match = this._tripleQuotedString.exec(input)) {
          unescaped = match[1] || match[2];
          // Count the newlines and advance line counter.
          this._line += unescaped.split(/\r\n|\r|\n/).length - 1;
          unescaped = this._unescape(unescaped);
          if (unescaped === null)
            return reportSyntaxError(this);
          type = 'literal', value = unescaped.replace(/^'|'$/g, '"');
        }
        break;

      case '@':
        // Try to find a language code.
        if (this._prevTokenType === 'literal' && (match = this._langcode.exec(input)))
          type = 'langcode', value = match[1];
        // Try to find a keyword.
        else if (match = this._keyword.exec(input))
          type = match[0];
        break;

      case '.':
        // Try to find a dot as punctuation.
        if (input.length === 1 ? inputFinished : (input[1] < '0' || input[1] > '9')) {
          type = '.';
          matchLength = 1;
          break;
        }
        // Fall through to numerical case (could be a decimal dot).

      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
      case '+':
      case '-':
        // Try to find a number.
        if (match = this._number.exec(input)) {
          type = 'literal';
          value = '"' + match[0] + '"^^http://www.w3.org/2001/XMLSchema#' +
                  (match[1] ? 'double' : (/^[+\-]?\d+$/.test(match[0]) ? 'integer' : 'decimal'));
        }
        break;

      case 'B':
      case 'b':
      case 'p':
      case 'P':
      case 'G':
      case 'g':
        // Try to find a SPARQL-style keyword.
        if (match = this._sparqlKeyword.exec(input))
          type = match[0].toUpperCase();
        else
          inconclusive = true;
        break;

      case 'f':
      case 't':
        // Try to match a boolean.
        if (match = this._boolean.exec(input))
          type = 'literal', value = '"' + match[0] + '"^^http://www.w3.org/2001/XMLSchema#boolean';
        else
          inconclusive = true;
        break;

      case 'a':
        // Try to find an abbreviated predicate.
        if (match = this._shortPredicates.exec(input))
          type = 'abbreviation', value = 'http://www.w3.org/1999/02/22-rdf-syntax-ns#type';
        else
          inconclusive = true;
        break;

      case ',':
      case ';':
      case '[':
      case ']':
      case '(':
      case ')':
      case '{':
      case '}':
        // The next token is punctuation
        matchLength = 1;
        type = firstChar;
        break;

      default:
        inconclusive = true;
      }

      // Some first characters do not allow an immediate decision, so inspect more.
      if (inconclusive) {
        // Try to find a prefix.
        if ((this._prevTokenType === '@prefix' || this._prevTokenType === 'PREFIX') &&
            (match = this._prefix.exec(input)))
          type = 'prefix', value = match[1] || '';
        // Try to find a prefixed name. Since it can contain (but not end with) a dot,
        // we always need a non-dot character before deciding it is a prefixed name.
        // Therefore, try inserting a space if we're at the end of the input.
        else if ((match = this._prefixed.exec(input)) ||
                 inputFinished && (match = this._prefixed.exec(input + ' ')))
          type = 'prefixed', prefix = match[1] || '', value = this._unescape(match[2]);
      }

      // A type token is special: it can only be emitted after an IRI or prefixed name is read.
      if (this._prevTokenType === '^')
        type = (type === 'IRI' || type === 'prefixed') ? 'type' : '';

      // What if nothing of the above was found?
      if (!type) {
        // We could be in streaming mode, and then we just wait for more input to arrive.
        // Otherwise, a syntax error has occurred in the input.
        // One exception: error on an unaccounted linebreak (= not inside a triple-quoted literal).
        if (inputFinished || (!/^'''|^"""/.test(input) && /\n|\r/.test(input)))
          return reportSyntaxError(this);
        else
          return this._input = input;
      }

      // Emit the parsed token.
      callback(null, { line: line, type: type, value: value, prefix: prefix });
      this._prevTokenType = type;

      // Advance to next part to tokenize.
      input = input.substr(matchLength || match[0].length, input.length);
    }

    // Signals the syntax error through the callback
    function reportSyntaxError(self) { callback(self._syntaxError(/^\S*/.exec(input)[0])); }
  },

  // ### `_unescape` replaces N3 escape codes by their corresponding characters.
  _unescape: function (item) {
    try {
      return item.replace(escapeSequence, function (sequence, unicode4, unicode8, escapedChar) {
        var charCode;
        if (unicode4) {
          charCode = parseInt(unicode4, 16);
          if (isNaN(charCode)) throw new Error(); // can never happen (regex), but helps performance
          return fromCharCode(charCode);
        }
        else if (unicode8) {
          charCode = parseInt(unicode8, 16);
          if (isNaN(charCode)) throw new Error(); // can never happen (regex), but helps performance
          if (charCode <= 0xFFFF) return fromCharCode(charCode);
          return fromCharCode(0xD800 + ((charCode -= 0x10000) / 0x400), 0xDC00 + (charCode & 0x3FF));
        }
        else {
          var replacement = escapeReplacements[escapedChar];
          if (!replacement)
            throw new Error();
          return replacement;
        }
      });
    }
    catch (error) { return null; }
  },

  // ### `_syntaxError` creates a syntax error for the given issue
  _syntaxError: function (issue) {
    this._input = null;
    return new Error('Syntax error: unexpected "' + issue + '" on line ' + this._line + '.');
  },


  // ## Public methods

  // ### `tokenize` starts the transformation of an N3 document into an array of tokens.
  // The input can be a string or a stream.
  tokenize: function (input, callback) {
    var self = this;
    this._line = 1;

    // If the input is a string, continuously emit tokens through the callback until the end.
    if (typeof input === 'string') {
      this._input = input;
      immediately(function () { self._tokenizeToEnd(callback, true); });
    }
    // Otherwise, the input will be streamed.
    else {
      this._input = '';

      // If no input was given, it will be streamed through `addChunk` and ended with `end`
      if (!input || typeof input === 'function') {
        this.addChunk = addChunk;
        this.end = end;
        if (!callback)
          callback = input;
      }
      // Otherwise, the input itself must be a stream
      else {
        if (typeof input.setEncoding === 'function')
          input.setEncoding('utf8');
        input.on('data', addChunk);
        input.on('end', end);
      }
    }

    // Adds the data chunk to the buffer and parses as far as possible
    function addChunk(data) {
      if (self._input !== null) {
        self._input += data;
        self._tokenizeToEnd(callback, false);
      }
    }

    // Parses until the end
    function end() {
      if (self._input !== null)
        self._tokenizeToEnd(callback, true);
    }
  },
};

// ## Exports

// Export the `N3Lexer` class as a whole.
module.exports = N3Lexer;


/***/ }),

/***/ "./node_modules/@rdfoo/n3/lib/N3Parser.js":
/*!************************************************!*\
  !*** ./node_modules/@rdfoo/n3/lib/N3Parser.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// **N3Parser** parses N3 documents.
var N3Lexer = __webpack_require__(/*! ./N3Lexer */ "./node_modules/@rdfoo/n3/lib/N3Lexer.js");

var RDF_PREFIX = 'http://www.w3.org/1999/02/22-rdf-syntax-ns#',
    RDF_NIL    = RDF_PREFIX + 'nil',
    RDF_FIRST  = RDF_PREFIX + 'first',
    RDF_REST   = RDF_PREFIX + 'rest';

var absoluteIRI = /^[a-z][a-z0-9+.-]*:/i,
    schemeAuthority = /^(?:([a-z][a-z0-9+.-]*:))?(?:\/\/[^\/]*)?/i,
    dotSegments = /(?:^|\/)\.\.?(?:$|[\/#?])/;

// The next ID for new blank nodes
var blankNodePrefix = 0, blankNodeCount = 0;

// ## Constructor
function N3Parser(options) {
  if (!(this instanceof N3Parser))
    return new N3Parser(options);
  this._tripleStack = [];
  this._graph = null;

  // Set the document IRI.
  options = options || {};
  this._setBase(options.documentIRI);

  // Set supported features depending on the format.
  var format = (typeof options.format === 'string') && options.format.match(/\w*$/)[0].toLowerCase(),
      isTurtle = format === 'turtle', isTriG = format === 'trig',
      isNTriples = /triple/.test(format), isNQuads = /quad/.test(format),
      isLineMode = isNTriples || isNQuads;
  if (!(this._supportsNamedGraphs = !isTurtle))
    this._readPredicateOrNamedGraph = this._readPredicate;
  this._supportsQuads = !(isTurtle || isTriG || isNTriples);
  // Disable relative IRIs in N-Triples or N-Quads mode
  if (isLineMode) {
    this._base = '';
    this._resolveIRI = function (token) {
      this._error('Disallowed relative IRI', token);
      return this._callback = noop, this._subject = null;
    };
  }
  this._blankNodePrefix = typeof options.blankNodePrefix !== 'string' ? '' :
                            '_:' + options.blankNodePrefix.replace(/^_:/, '');
  this._lexer = options.lexer || new N3Lexer({ lineMode: isLineMode });
}

// ## Private class methods

// ### `_resetBlankNodeIds` restarts blank node identification.
N3Parser._resetBlankNodeIds = function () {
  blankNodePrefix = blankNodeCount = 0;
};

N3Parser.prototype = {
  // ## Private methods

  // ### `_setBase` sets the base IRI to resolve relative IRIs.
  _setBase: function (baseIRI) {
    if (!baseIRI)
      baseIRI = null;
    else if (baseIRI.indexOf('#') >= 0)
      throw new Error('Invalid base IRI ' + baseIRI);
    // Set base IRI and its components
    if (this._base = baseIRI) {
      this._basePath   = baseIRI.replace(/[^\/?]*(?:\?.*)?$/, '');
      baseIRI = baseIRI.match(schemeAuthority);
      this._baseRoot   = baseIRI[0];
      this._baseScheme = baseIRI[1];
    }
  },

  // ### `_readInTopContext` reads a token when in the top context.
  _readInTopContext: function (token) {
    switch (token.type) {
    // If an EOF token arrives in the top context, signal that we're done.
    case 'eof':
      if (this._graph !== null)
        return this._error('Unclosed graph', token);
      delete this._prefixes._;
      return this._callback(null, null, this._prefixes);
    // It could be a prefix declaration.
    case '@prefix':
      this._sparqlStyle = false;
      return this._readPrefix;
    case 'PREFIX':
      this._sparqlStyle = true;
      return this._readPrefix;
    // It could be a base declaration.
    case '@base':
      this._sparqlStyle = false;
      return this._readBaseIRI;
    case 'BASE':
      this._sparqlStyle = true;
      return this._readBaseIRI;
    // It could be a graph.
    case '{':
      if (this._supportsNamedGraphs) {
        this._graph = '';
        this._subject = null;
        return this._readSubject;
      }
    case 'GRAPH':
      if (this._supportsNamedGraphs)
        return this._readNamedGraphLabel;
    // Otherwise, the next token must be a subject.
    default:
      return this._readSubject(token);
    }
  },

  // ### `_readSubject` reads a triple's subject.
  _readSubject: function (token) {
    this._predicate = null;
    switch (token.type) {
    case 'IRI':
      if (this._base === null || absoluteIRI.test(token.value))
        this._subject = token.value;
      else
        this._subject = this._resolveIRI(token);
      break;
    case 'prefixed':
      var prefix = this._prefixes[token.prefix];
      if (prefix === undefined)
        return this._error('Undefined prefix "' + token.prefix + ':"', token);
      this._subject = prefix + token.value;
      break;
    case '[':
      // Start a new triple with a new blank node as subject.
      this._subject = '_:b' + blankNodeCount++;
      this._tripleStack.push({ subject: this._subject, predicate: null, object: null, type: 'blank' });
      return this._readBlankNodeHead;
    case '(':
      // Start a new list
      this._tripleStack.push({ subject: RDF_NIL, predicate: null, object: null, type: 'list' });
      this._subject = null;
      return this._readListItem;
    case '}':
      return this._readPunctuation(token);
    default:
      return this._error('Expected subject but got ' + token.type, token);
    }
    // The next token must be a predicate,
    // or, if the subject was actually a graph IRI, a named graph.
    return this._readPredicateOrNamedGraph;
  },

  // ### `_readPredicate` reads a triple's predicate.
  _readPredicate: function (token) {
    var type = token.type;
    switch (type) {
    case 'IRI':
    case 'abbreviation':
      if (this._base === null || absoluteIRI.test(token.value))
        this._predicate = token.value;
      else
        this._predicate = this._resolveIRI(token);
      break;
    case 'prefixed':
      if (token.prefix === '_')
        return this._error('Disallowed blank node as predicate', token);
      var prefix = this._prefixes[token.prefix];
      if (prefix === undefined)
        return this._error('Undefined prefix "' + token.prefix + ':"', token);
      this._predicate = prefix + token.value;
      break;
    case '.':
    case ']':
    case '}':
      // Expected predicate didn't come, must have been trailing semicolon.
      if (this._predicate === null)
        return this._error('Unexpected ' + type, token);
      this._subject = null;
      return type === ']' ? this._readBlankNodeTail(token) : this._readPunctuation(token);
    case ';':
      // Extra semicolons can be safely ignored
      return this._readPredicate;
    default:
      return this._error('Expected predicate to follow "' + this._subject + '"', token);
    }
    // The next token must be an object.
    return this._readObject;
  },

  // ### `_readObject` reads a triple's object.
  _readObject: function (token) {
    switch (token.type) {
    case 'IRI':
      if (this._base === null || absoluteIRI.test(token.value))
        this._object = token.value;
      else
        this._object = this._resolveIRI(token);
      break;
    case 'prefixed':
      var prefix = this._prefixes[token.prefix];
      if (prefix === undefined)
        return this._error('Undefined prefix "' + token.prefix + ':"', token);
      this._object = prefix + token.value;
      break;
    case 'literal':
      this._object = token.value;
      return this._readDataTypeOrLang;
    case '[':
      // Start a new triple with a new blank node as subject.
      var blank = '_:b' + blankNodeCount++;
      this._tripleStack.push({ subject: this._subject, predicate: this._predicate, object: blank, type: 'blank' });
      this._subject = blank;
      return this._readBlankNodeHead;
    case '(':
      // Start a new list
      this._tripleStack.push({ subject: this._subject, predicate: this._predicate, object: RDF_NIL, type: 'list' });
      this._subject = null;
      return this._readListItem;
    default:
      return this._error('Expected object to follow "' + this._predicate + '"', token);
    }
    return this._getTripleEndReader();
  },

  // ### `_readPredicateOrNamedGraph` reads a triple's predicate, or a named graph.
  _readPredicateOrNamedGraph: function (token) {
    return token.type === '{' ? this._readGraph(token) : this._readPredicate(token);
  },

  // ### `_readGraph` reads a graph.
  _readGraph: function (token) {
    if (token.type !== '{')
      return this._error('Expected graph but got ' + token.type, token);
    // The "subject" we read is actually the GRAPH's label
    this._graph = this._subject, this._subject = null;
    return this._readSubject;
  },

  // ### `_readBlankNodeHead` reads the head of a blank node.
  _readBlankNodeHead: function (token) {
    if (token.type === ']') {
      this._subject = null;
      return this._readBlankNodeTail(token);
    }
    else {
      this._predicate = null;
      return this._readPredicate(token);
    }
  },

  // ### `_readBlankNodeTail` reads the end of a blank node.
  _readBlankNodeTail: function (token) {
    if (token.type !== ']')
      return this._readBlankNodePunctuation(token);

    // Store blank node triple.
    if (this._subject !== null)
      this._callback(null, { subject:   this._subject,
                             predicate: this._predicate,
                             object:    this._object,
                             graph:     this._graph || '' });

    // Restore parent triple that contains the blank node.
    var triple = this._tripleStack.pop();
    this._subject = triple.subject;
    // Was the blank node the object?
    if (triple.object !== null) {
      // Restore predicate and object as well, and continue by reading punctuation.
      this._predicate = triple.predicate;
      this._object = triple.object;
      return this._getTripleEndReader();
    }
    // The blank node was the subject, so continue reading the predicate.
    // If the blank node didn't contain any predicates, it could also be the label of a named graph.
    return this._predicate !== null ? this._readPredicate : this._readPredicateOrNamedGraph;
  },

  // ### `_readDataTypeOrLang` reads an _optional_ data type or language.
  _readDataTypeOrLang: function (token) {
    switch (token.type) {
    case 'type':
      var value;
      if (token.prefix === '') {
        if (this._base === null || absoluteIRI.test(token.value))
          value = token.value;
        else
          value = this._resolveIRI(token);
      }
      else {
        var prefix = this._prefixes[token.prefix];
        if (prefix === undefined)
          return this._error('Undefined prefix "' + token.prefix + ':"', token);
        value = prefix + token.value;
      }
      this._object += '^^' + value;
      return this._getTripleEndReader();
    case 'langcode':
      this._object += '@' + token.value.toLowerCase();
      return this._getTripleEndReader();
    default:
      return this._getTripleEndReader().call(this, token);
    }
  },

  // ### `_readListItem` reads items from a list.
  _readListItem: function (token) {
    var item = null,                  // The actual list item.
        itemHead = null,              // The head of the rdf:first predicate.
        prevItemHead = this._subject, // The head of the previous rdf:first predicate.
        stack = this._tripleStack,    // The stack of triples part of recursion (lists, blanks, etc.).
        parentTriple = stack[stack.length - 1], // The triple containing the current list.
        next = this._readListItem;    // The next function to execute.

    switch (token.type) {
    case 'IRI':
      if (this._base === null || absoluteIRI.test(token.value))
        item = token.value;
      else
        item = this._resolveIRI(token);
      break;
    case 'prefixed':
      var prefix = this._prefixes[token.prefix];
      if (prefix === undefined)
        return this._error('Undefined prefix "' + token.prefix + ':"', token);
      item = prefix + token.value;
      break;
    case 'literal':
      item = token.value;
      next = this._readDataTypeOrLang;
      break;
    case '[':
      // Stack the current list triple and start a new triple with a blank node as subject.
      itemHead = '_:b' + blankNodeCount++;
      item     = '_:b' + blankNodeCount++;
      stack.push({ subject: itemHead, predicate: RDF_FIRST, object: item, type: 'blank' });
      this._subject = item;
      next = this._readBlankNodeHead;
      break;
    case '(':
      // Stack the current list triple and start a new list
      itemHead = '_:b' + blankNodeCount++;
      stack.push({ subject: itemHead, predicate: RDF_FIRST, object: RDF_NIL, type: 'list' });
      this._subject = null;
      next = this._readListItem;
      break;
    case ')':
      // Restore the parent triple.
      stack.pop();
      // If this list is contained within a parent list, return the membership triple here.
      // This will be `<parent list element> rdf:first <this list>.`.
      if (stack.length !== 0 && stack[stack.length - 1].type === 'list')
        this._callback(null, { subject:   parentTriple.subject,
                               predicate: parentTriple.predicate,
                               object:    parentTriple.object,
                               graph:     this._graph || '' });
      // Restore the parent triple's subject.
      this._subject = parentTriple.subject;
      // Was this list in the parent triple's subject?
      if (parentTriple.predicate === null) {
        // The next token is the predicate.
        next = this._readPredicate;
        // Skip writing the list tail if this was an empty list.
        if (parentTriple.subject === RDF_NIL)
          return next;
      }
      // The list was in the parent triple's object.
      else {
        // Restore the parent triple's predicate and object as well.
        this._predicate = parentTriple.predicate;
        this._object = parentTriple.object;
        next = this._getTripleEndReader();
        // Skip writing the list tail if this was an empty list.
        if (parentTriple.object === RDF_NIL)
          return next;
      }
      // Close the list by making the item head nil.
      itemHead = RDF_NIL;
      break;
    default:
      return this._error('Expected list item instead of "' + token.type + '"', token);
    }

     // Create a new blank node if no item head was assigned yet.
    if (itemHead === null)
      this._subject = itemHead = '_:b' + blankNodeCount++;

    // Is this the first element of the list?
    if (prevItemHead === null) {
      // This list is either the object or the subject.
      if (parentTriple.object === RDF_NIL)
        parentTriple.object = itemHead;
      else
        parentTriple.subject = itemHead;
    }
    else {
      // The rest of the list is in the current head.
      this._callback(null, { subject:   prevItemHead,
                             predicate: RDF_REST,
                             object:    itemHead,
                             graph:     this._graph || '' });
    }
    // Add the item's value.
    if (item !== null)
      this._callback(null, { subject:   itemHead,
                             predicate: RDF_FIRST,
                             object:    item,
                             graph:     this._graph || '' });
    return next;
  },

  // ### `_readPunctuation` reads punctuation between triples or triple parts.
  _readPunctuation: function (token) {
    var next, subject = this._subject, graph = this._graph;
    switch (token.type) {
    // A closing brace ends a graph
    case '}':
      if (this._graph === null)
        return this._error('Unexpected graph closing', token);
      this._graph = null;
    // A dot just ends the statement, without sharing anything with the next.
    case '.':
      this._subject = null;
      next = this._readInTopContext;
      break;
    // Semicolon means the subject is shared; predicate and object are different.
    case ';':
      next = this._readPredicate;
      break;
    // Comma means both the subject and predicate are shared; the object is different.
    case ',':
      next = this._readObject;
      break;
    // An IRI means this is a quad (only allowed if not already inside a graph).
    case 'IRI':
      if (this._supportsQuads && this._graph === null) {
        if (this._base === null || absoluteIRI.test(token.value))
          graph = token.value;
        else
          graph = this._resolveIRI(token);
        subject = this._subject;
        next = this._readQuadPunctuation;
        break;
      }
    // An prefixed name means this is a quad (only allowed if not already inside a graph).
    case 'prefixed':
      if (this._supportsQuads && this._graph === null) {
        var prefix = this._prefixes[token.prefix];
        if (prefix === undefined)
          return this._error('Undefined prefix "' + token.prefix + ':"', token);
        graph = prefix + token.value;
        next = this._readQuadPunctuation;
        break;
      }
    default:
      return this._error('Expected punctuation to follow "' + this._object + '"', token);
    }
    // A triple has been completed now, so return it.
    if (subject !== null)
      this._callback(null, { subject:   subject,
                             predicate: this._predicate,
                             object:    this._object,
                             graph:     graph || '' });
    return next;
  },

    // ### `_readBlankNodePunctuation` reads punctuation in a blank node
  _readBlankNodePunctuation: function (token) {
    var next;
    switch (token.type) {
    // Semicolon means the subject is shared; predicate and object are different.
    case ';':
      next = this._readPredicate;
      break;
    // Comma means both the subject and predicate are shared; the object is different.
    case ',':
      next = this._readObject;
      break;
    default:
      return this._error('Expected punctuation to follow "' + this._object + '"', token);
    }
    // A triple has been completed now, so return it.
    this._callback(null, { subject:   this._subject,
                           predicate: this._predicate,
                           object:    this._object,
                           graph:     this._graph || '' });
    return next;
  },

  // ### `_readQuadPunctuation` reads punctuation after a quad.
  _readQuadPunctuation: function (token) {
    if (token.type !== '.')
      return this._error('Expected dot to follow quad', token);
    return this._readInTopContext;
  },

  // ### `_readPrefix` reads the prefix of a prefix declaration.
  _readPrefix: function (token) {
    if (token.type !== 'prefix')
      return this._error('Expected prefix to follow @prefix', token);
    this._prefix = token.value;
    return this._readPrefixIRI;
  },

  // ### `_readPrefixIRI` reads the IRI of a prefix declaration.
  _readPrefixIRI: function (token) {
    if (token.type !== 'IRI')
      return this._error('Expected IRI to follow prefix "' + this._prefix + ':"', token);
    var prefixIRI;
    if (this._base === null || absoluteIRI.test(token.value))
      prefixIRI = token.value;
    else
      prefixIRI = this._resolveIRI(token);
    this._prefixes[this._prefix] = prefixIRI;
    this._prefixCallback(this._prefix, prefixIRI);
    return this._readDeclarationPunctuation;
  },

  // ### `_readBaseIRI` reads the IRI of a base declaration.
  _readBaseIRI: function (token) {
    if (token.type !== 'IRI')
      return this._error('Expected IRI to follow base declaration', token);
    try {
      this._setBase(this._base === null ||
                    absoluteIRI.test(token.value) ? token.value : this._resolveIRI(token));
    }
    catch (error) { this._error(error.message, token); }
    return this._readDeclarationPunctuation;
  },

  // ### `_readNamedGraphLabel` reads the label of a named graph.
  _readNamedGraphLabel: function (token) {
    switch (token.type) {
    case 'IRI':
    case 'prefixed':
      return this._readSubject(token), this._readGraph;
    case '[':
      return this._readNamedGraphBlankLabel;
    default:
      return this._error('Invalid graph label', token);
    }
  },

  // ### `_readNamedGraphLabel` reads a blank node label of a named graph.
  _readNamedGraphBlankLabel: function (token) {
    if (token.type !== ']')
      return this._error('Invalid graph label', token);
    this._subject = '_:b' + blankNodeCount++;
    return this._readGraph;
  },

  // ### `_readDeclarationPunctuation` reads the punctuation of a declaration.
  _readDeclarationPunctuation: function (token) {
    // SPARQL-style declarations don't have punctuation.
    if (this._sparqlStyle)
      return this._readInTopContext(token);

    if (token.type !== '.')
      return this._error('Expected declaration to end with a dot', token);
    return this._readInTopContext;
  },

  // ### `_getTripleEndReader` gets the next reader function at the end of a triple.
  _getTripleEndReader: function () {
    var stack = this._tripleStack;
    if (stack.length === 0)
      return this._readPunctuation;

    switch (stack[stack.length - 1].type) {
    case 'blank':
      return this._readBlankNodeTail;
    case 'list':
      return this._readListItem;
    }
  },

  // ### `_error` emits an error message through the callback.
  _error: function (message, token) {
    this._callback(new Error(message + ' at line ' + token.line + '.'));
  },

  // ### `_resolveIRI` resolves a relative IRI token against the base path,
  // assuming that a base path has been set and that the IRI is indeed relative.
  _resolveIRI: function (token) {
    var iri = token.value;
    switch (iri[0]) {
    // An empty relative IRI indicates the base IRI
    case undefined: return this._base;
    // Resolve relative fragment IRIs against the base IRI
    case '#': return this._base + iri;
    // Resolve relative query string IRIs by replacing the query string
    case '?': return this._base.replace(/(?:\?.*)?$/, iri);
    // Resolve root-relative IRIs at the root of the base IRI
    case '/':
      // Resolve scheme-relative IRIs to the scheme
      return (iri[1] === '/' ? this._baseScheme : this._baseRoot) + this._removeDotSegments(iri);
    // Resolve all other IRIs at the base IRI's path
    default:
      return this._removeDotSegments(this._basePath + iri);
    }
  },

  // ### `_removeDotSegments` resolves './' and '../' path segments in an IRI as per RFC3986.
  _removeDotSegments: function (iri) {
    // Don't modify the IRI if it does not contain any dot segments
    if (!dotSegments.test(iri))
      return iri;

    // Start with an imaginary slash before the IRI in order to resolve trailing './' and '../'
    var result = '', length = iri.length, i = -1, pathStart = -1, segmentStart = 0, next = '/';

    while (i < length) {
      switch (next) {
      // The path starts with the first slash after the authority
      case ':':
        if (pathStart < 0) {
          // Skip two slashes before the authority
          if (iri[++i] === '/' && iri[++i] === '/')
            // Skip to slash after the authority
            while ((pathStart = i + 1) < length && iri[pathStart] !== '/')
              i = pathStart;
        }
        break;
      // Don't modify a query string or fragment
      case '?':
      case '#':
        i = length;
        break;
      // Handle '/.' or '/..' path segments
      case '/':
        if (iri[i + 1] === '.') {
          next = iri[++i + 1];
          switch (next) {
          // Remove a '/.' segment
          case '/':
            result += iri.substring(segmentStart, i - 1);
            segmentStart = i + 1;
            break;
          // Remove a trailing '/.' segment
          case undefined:
          case '?':
          case '#':
            return result + iri.substring(segmentStart, i) + iri.substr(i + 1);
          // Remove a '/..' segment
          case '.':
            next = iri[++i + 1];
            if (next === undefined || next === '/' || next === '?' || next === '#') {
              result += iri.substring(segmentStart, i - 2);
              // Try to remove the parent path from result
              if ((segmentStart = result.lastIndexOf('/')) >= pathStart)
                result = result.substr(0, segmentStart);
              // Remove a trailing '/..' segment
              if (next !== '/')
                return result + '/' + iri.substr(i + 1);
              segmentStart = i + 1;
            }
          }
        }
      }
      next = iri[++i];
    }
    return result + iri.substring(segmentStart);
  },

  // ## Public methods

  // ### `parse` parses the N3 input and emits each parsed triple through the callback.
  parse: function (input, tripleCallback, prefixCallback) {
    // The read callback is the next function to be executed when a token arrives.
    // We start reading in the top context.
    this._readCallback = this._readInTopContext;
    this._prefixes = Object.create(null);
    this._prefixes._ = this._blankNodePrefix || '_:b' + blankNodePrefix++ + '_';

    // If the input argument is not given, shift parameters
    if (typeof input === 'function')
      prefixCallback = tripleCallback, tripleCallback = input, input = null;

    // Set the triple and prefix callbacks.
    this._callback = tripleCallback || noop;
    this._prefixCallback = prefixCallback || noop;

    // Execute the read callback when a token arrives.
    var self = this;
    this._lexer.tokenize(input, function (error, token) {
      if (error !== null)
        self._callback(error), self._callback = noop;
      else if (self._readCallback !== undefined)
        self._readCallback = self._readCallback(token);
    });

    // If no input was given, it can be added with `addChunk` and ended with `end`
    if (!input) {
      this.addChunk = this._lexer.addChunk;
      this.end = this._lexer.end;
    }
  },
};

// The empty function
function noop() {}

// ## Exports

// Export the `N3Parser` class as a whole.
module.exports = N3Parser;


/***/ }),

/***/ "./node_modules/@rdfoo/n3/lib/N3Store.js":
/*!***********************************************!*\
  !*** ./node_modules/@rdfoo/n3/lib/N3Store.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// **N3Store** objects store N3 triples by graph in memory.

var expandPrefixedName = __webpack_require__(/*! ./N3Util */ "./node_modules/@rdfoo/n3/lib/N3Util.js").expandPrefixedName;

// ## Constructor
function N3Store(triples, options) {
  if (!(this instanceof N3Store))
    return new N3Store(triples, options);

  // The number of triples is initially zero.
  this._size = 0;
  // `_graphs` contains subject, predicate, and object indexes per graph.
  this._graphs = Object.create(null);
  // `_entities` maps entities such as `http://xmlns.com/foaf/0.1/name` to numbers.
  // This saves memory, since only the numbers have to be stored in `_graphs`.
  this._entities = Object.create(null);
  this._entities['><'] = 0; // Dummy entry, so the first actual key is non-zero
  this._entityCount = 0;
  // `_blankNodeIndex` is the index of the last created blank node that was automatically named
  this._blankNodeIndex = 0;

  // Shift parameters if `triples` is not given
  if (!options && triples && !triples[0])
    options = triples, triples = null;

  // Add triples and prefixes if passed
  this._prefixes = Object.create(null);
  if (options && options.prefixes)
    this.addPrefixes(options.prefixes);
  if (triples)
    this.addTriples(triples);
}

N3Store.prototype = {
  // ## Public properties

  // ### `size` returns the number of triples in the store.
  get size() {
    // Return the triple count if if was cached.
    var size = this._size;
    if (size !== null)
      return size;

    // Calculate the number of triples by counting to the deepest level.
    var graphs = this._graphs, subjects, subject;
    for (var graphKey in graphs)
      for (var subjectKey in (subjects = graphs[graphKey].subjects))
        for (var predicateKey in (subject = subjects[subjectKey]))
          size += Object.keys(subject[predicateKey]).length;
    return this._size = size;
  },

  // ## Private methods

  // ### `_addToIndex` adds a triple to a three-layered index.
  _addToIndex: function (index0, key0, key1, key2) {
    // Create layers as necessary.
    var index1 = index0[key0] || (index0[key0] = {});
    var index2 = index1[key1] || (index1[key1] = {});
    // Setting the key to _any_ value signalizes the presence of the triple.
    index2[key2] = null;
  },

  // ### `_removeFromIndex` removes a triple from a three-layered index.
  _removeFromIndex: function (index0, key0, key1, key2) {
    // Remove the triple from the index.
    var index1 = index0[key0], index2 = index1[key1], key;
    delete index2[key2];

    // Remove intermediary index layers if they are empty.
    for (key in index2) return;
    delete index1[key1];
    for (key in index1) return;
    delete index0[key0];
  },

  // ### `_findInIndex` finds a set of triples in a three-layered index.
  // The index base is `index0` and the keys at each level are `key0`, `key1`, and `key2`.
  // Any of these keys can be `null`, which is interpreted as a wildcard.
  // `name0`, `name1`, and `name2` are the names of the keys at each level,
  // used when reconstructing the resulting triple
  // (for instance: _subject_, _predicate_, and _object_).
  // Finally, `graph` will be the graph of the created triples.
  _findInIndex: function (index0, key0, key1, key2, name0, name1, name2, graph) {
    var results = [], entityKeys = Object.keys(this._entities), tmp, index1, index2;

    // If a key is specified, use only that part of index 0.
    if (key0) (tmp = index0, index0 = {})[key0] = tmp[key0];
    for (var value0 in index0) {
      var entity0 = entityKeys[value0];

      if (index1 = index0[value0]) {
        // If a key is specified, use only that part of index 1.
        if (key1) (tmp = index1, index1 = {})[key1] = tmp[key1];
        for (var value1 in index1) {
          var entity1 = entityKeys[value1];

          if (index2 = index1[value1]) {
            // If a key is specified, use only that part of index 2, if it exists.
            var values = key2 ? (key2 in index2 ? [key2] : []) : Object.keys(index2);
            // Create triples for all items found in index 2.
            for (var l = values.length - 1; l >= 0; l--) {
              var result = { subject: '', predicate: '', object: '', graph: graph };
              result[name0] = entity0;
              result[name1] = entity1;
              result[name2] = entityKeys[values[l]];
              results.push(result);
            }
          }
        }
      }
    }
    return results;
  },

  // ### `_countInIndex` counts matching triples in a three-layered index.
  // The index base is `index0` and the keys at each level are `key0`, `key1`, and `key2`.
  // Any of these keys can be `null`, which is interpreted as a wildcard.
  _countInIndex: function (index0, key0, key1, key2) {
    var count = 0, tmp, index1, index2;

    // If a key is specified, count only that part of index 0.
    if (key0) (tmp = index0, index0 = {})[key0] = tmp[key0];
    for (var value0 in index0) {
      if (index1 = index0[value0]) {
        // If a key is specified, count only that part of index 1.
        if (key1) (tmp = index1, index1 = {})[key1] = tmp[key1];
        for (var value1 in index1) {
          if (index2 = index1[value1]) {
            // If a key is specified, count the triple if it exists.
            if (key2) (key2 in index2) && count++;
            // Otherwise, count all triples.
            else count += Object.keys(index2).length;
          }
        }
      }
    }
    return count;
  },

  // ## Public methods

  // ### `addTriple` adds a new N3 triple to the store.
  addTriple: function (subject, predicate, object, graph) {
    // Shift arguments if a triple object is given instead of components
    if (!predicate)
      graph = subject.graph, object = subject.object,
        predicate = subject.predicate, subject = subject.subject;

    // Find the graph that will contain the triple.
    graph = graph || '';
    var graphItem = this._graphs[graph];
    // Create the graph if it doesn't exist yet.
    if (!graphItem) {
      graphItem = this._graphs[graph] = { subjects: {}, predicates: {}, objects: {} };
      // Freezing a graph helps subsequent `add` performance,
      // and properties will never be modified anyway.
      Object.freeze(graphItem);
    }

    // Since entities can often be long IRIs, we avoid storing them in every index.
    // Instead, we have a separate index that maps entities to numbers,
    // which are then used as keys in the other indexes.
    var entities = this._entities;
    subject   = entities[subject]   || (entities[subject]   = ++this._entityCount);
    predicate = entities[predicate] || (entities[predicate] = ++this._entityCount);
    object    = entities[object]    || (entities[object]    = ++this._entityCount);

    this._addToIndex(graphItem.subjects,   subject,   predicate, object);
    this._addToIndex(graphItem.predicates, predicate, object,    subject);
    this._addToIndex(graphItem.objects,    object,    subject,   predicate);

    // The cached triple count is now invalid.
    this._size = null;
  },

  // ### `addTriples` adds multiple N3 triples to the store.
  addTriples: function (triples) {
    for (var i = triples.length - 1; i >= 0; i--)
      this.addTriple(triples[i]);
  },

  // ### `addPrefix` adds support for querying with the given prefix
  addPrefix: function (prefix, iri) {
    this._prefixes[prefix] = iri;
  },

  // ### `addPrefixes` adds support for querying with the given prefixes
  addPrefixes: function (prefixes) {
    for (var prefix in prefixes)
      this.addPrefix(prefix, prefixes[prefix]);
  },

  // ### `removeTriple` removes an N3 triple from the store if it exists.
  removeTriple: function (subject, predicate, object, graph) {
    // Shift arguments if a triple object is given instead of components.
    if (!predicate)
      graph = subject.graph, object = subject.object,
        predicate = subject.predicate, subject = subject.subject;
    graph = graph || '';

    // Find internal identifiers for all components.
    var graphItem, entities = this._entities, graphs = this._graphs;
    if (!(subject     = entities[subject]))   return;
    if (!(predicate   = entities[predicate])) return;
    if (!(object      = entities[object]))    return;
    if (!(graphItem   = graphs[graph]))       return;

    // Verify that the triple exists.
    var subjects, predicates;
    if (!(subjects   = graphItem.subjects[subject])) return;
    if (!(predicates = subjects[predicate])) return;
    if (!(object in predicates)) return;

    // Remove it from all indexes.
    this._removeFromIndex(graphItem.subjects,   subject,   predicate, object);
    this._removeFromIndex(graphItem.predicates, predicate, object,    subject);
    this._removeFromIndex(graphItem.objects,    object,    subject,   predicate);
    if (this._size !== null) this._size--;

    // Remove the graph if it is empty.
    for (subject in graphItem.subjects) return;
    delete graphs[graph];
  },

  // ### `removeTriples` removes multiple N3 triples from the store.
  removeTriples: function (triples) {
    for (var i = triples.length - 1; i >= 0; i--)
      this.removeTriple(triples[i]);
  },

  // ### `find` finds a set of triples matching a pattern, expanding prefixes as necessary.
  // Setting `subject`, `predicate`, or `object` to `null` means an _anything_ wildcard.
  // Setting `graph` to `null` means the default graph.
  find: function (subject, predicate, object, graph) {
    var prefixes = this._prefixes;
    return this.findByIRI(
      expandPrefixedName(subject,   prefixes),
      expandPrefixedName(predicate, prefixes),
      expandPrefixedName(object,    prefixes),
      expandPrefixedName(graph,     prefixes)
    );
  },

  // ### `findByIRI` finds a set of triples matching a pattern.
  // Setting `subject`, `predicate`, or `object` to a falsy value means an _anything_ wildcard.
  // Setting `graph` to a falsy value means the default graph.
  findByIRI: function (subject, predicate, object, graph) {
    graph = graph || '';
    var graphItem = this._graphs[graph], entities = this._entities;

    // If the specified graph contain no triples, there are no results.
    if (!graphItem) return [];

    // Translate IRIs to internal index keys.
    // Optimization: if the entity doesn't exist, no triples with it exist.
    if (subject   && !(subject   = entities[subject]))   return [];
    if (predicate && !(predicate = entities[predicate])) return [];
    if (object    && !(object    = entities[object]))    return [];

    // Choose the optimal index, based on what fields are present
    if (subject) {
      if (object)
        // If subject and object are given, the object index will be the fastest.
        return this._findInIndex(graphItem.objects, object, subject, predicate,
                                 'object', 'subject', 'predicate', graph);
      else
        // If only subject and possibly predicate are given, the subject index will be the fastest.
        return this._findInIndex(graphItem.subjects, subject, predicate, null,
                                 'subject', 'predicate', 'object', graph);
    }
    else if (predicate)
      // If only predicate and possibly object are given, the predicate index will be the fastest.
      return this._findInIndex(graphItem.predicates, predicate, object, null,
                               'predicate', 'object', 'subject', graph);
    else if (object)
      // If only object is given, the object index will be the fastest.
      return this._findInIndex(graphItem.objects, object, null, null,
                               'object', 'subject', 'predicate', graph);
    else
      // If nothing is given, iterate subjects and predicates first
      return this._findInIndex(graphItem.subjects, null, null, null,
                               'subject', 'predicate', 'object', graph);
  },

  // ### `count` returns the number of triples matching a pattern, expanding prefixes as necessary.
  // Setting `subject`, `predicate`, or `object` to `null` means an _anything_ wildcard.
  // Setting `graph` to `null` means the default graph.
  count: function (subject, predicate, object, graph) {
    var prefixes = this._prefixes;
    return this.countByIRI(
      expandPrefixedName(subject,   prefixes),
      expandPrefixedName(predicate, prefixes),
      expandPrefixedName(object,    prefixes),
      expandPrefixedName(graph,     prefixes)
    );
  },

  // ### `countByIRI` returns the number of triples matching a pattern.
  // Setting `subject`, `predicate`, or `object` to `null` means an _anything_ wildcard.
  // Setting `graph` to `null` means the default graph.
  countByIRI: function (subject, predicate, object, graph) {
    graph = graph || '';
    var graphItem = this._graphs[graph], entities = this._entities;

    // If the specified graph contain no triples, there are no results.
    if (!graphItem) return 0;

    // Translate IRIs to internal index keys.
    // Optimization: if the entity doesn't exist, no triples with it exist.
    if (subject   && !(subject   = entities[subject]))   return 0;
    if (predicate && !(predicate = entities[predicate])) return 0;
    if (object    && !(object    = entities[object]))    return 0;

    // Choose the optimal index, based on what fields are present
    if (subject) {
      if (object)
        // If subject and object are given, the object index will be the fastest.
        return this._countInIndex(graphItem.objects, object, subject, predicate);
      else
        // If only subject and possibly predicate are given, the subject index will be the fastest.
        return this._countInIndex(graphItem.subjects, subject, predicate, object);
    }
    else if (predicate) {
      // If only predicate and possibly object are given, the predicate index will be the fastest.
      return this._countInIndex(graphItem.predicates, predicate, object, subject);
    }
    else {
      // If only object is possibly given, the object index will be the fastest.
      return this._countInIndex(graphItem.objects, object, subject, predicate);
    }
  },

  // ### `createBlankNode` creates a new blank node, returning its name.
  createBlankNode: function (suggestedName) {
    var name, index;
    // Generate a name based on the suggested name
    if (suggestedName) {
      name = suggestedName = '_:' + suggestedName, index = 1;
      while (this._entities[name])
        name = suggestedName + index++;
    }
    // Generate a generic blank node name
    else {
      do { name = '_:b' + this._blankNodeIndex++; }
      while (this._entities[name]);
    }
    // Add the blank node to the entities, avoiding the generation of duplicates
    this._entities[name] = ++this._entityCount;
    return name;
  },
};

// ## Exports

// Export the `N3Store` class as a whole.
module.exports = N3Store;


/***/ }),

/***/ "./node_modules/@rdfoo/n3/lib/N3StreamParser.js":
/*!******************************************************!*\
  !*** ./node_modules/@rdfoo/n3/lib/N3StreamParser.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// **N3StreamParser** parses an N3 stream into a triple stream
var Transform = __webpack_require__(/*! stream */ "stream").Transform,
    util = __webpack_require__(/*! util */ "util"),
    N3Parser = __webpack_require__(/*! ./N3Parser.js */ "./node_modules/@rdfoo/n3/lib/N3Parser.js");

// ## Constructor
function N3StreamParser(options) {
  if (!(this instanceof N3StreamParser))
    return new N3StreamParser(options);

  // Initialize Transform base class
  Transform.call(this, { decodeStrings: true });
  this._readableState.objectMode = true;

  // Set up parser
  var self = this, parser = new N3Parser(options);
  parser.parse(
    // Handle triples by pushing them down the pipeline
    function (error, triple) {
      triple && self.push(triple) ||
      error  && self.emit('error', error);
    },
    // Emit prefixes through the `prefix` event
    this.emit.bind(this, 'prefix'));

  // Implement Transform methods on top of parser
  this._transform = function (chunk, encoding, done) { parser.addChunk(chunk); done(); };
  this._flush = function (done) { parser.end(); done(); };
}
util.inherits(N3StreamParser, Transform);

// ## Exports
// Export the `N3StreamParser` class as a whole.
module.exports = N3StreamParser;


/***/ }),

/***/ "./node_modules/@rdfoo/n3/lib/N3StreamWriter.js":
/*!******************************************************!*\
  !*** ./node_modules/@rdfoo/n3/lib/N3StreamWriter.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// **N3StreamWriter** serializes a triple stream into an N3 stream
var Transform = __webpack_require__(/*! stream */ "stream").Transform,
    util = __webpack_require__(/*! util */ "util"),
    N3Writer = __webpack_require__(/*! ./N3Writer.js */ "./node_modules/@rdfoo/n3/lib/N3Writer.js");

// ## Constructor
function N3StreamWriter(options) {
  if (!(this instanceof N3StreamWriter))
    return new N3StreamWriter(options);

  // Initialize Transform base class
  Transform.call(this, { encoding: 'utf8' });
  this._writableState.objectMode = true;

  // Set up writer with a dummy stream object
  var self = this;
  var writer = new N3Writer({
    write: function (chunk, encoding, callback) { self.push(chunk); callback && callback(); },
    end: function (callback) { self.push(null); callback && callback(); },
  }, options);

  // Implement Transform methods on top of writer
  this._transform = function (triple, encoding, done) { writer.addTriple(triple, done); };
  this._flush = function (done) { writer.end(done); };
}
util.inherits(N3StreamWriter, Transform);

// ## Exports
// Export the `N3StreamWriter` class as a whole.
module.exports = N3StreamWriter;


/***/ }),

/***/ "./node_modules/@rdfoo/n3/lib/N3Util.js":
/*!**********************************************!*\
  !*** ./node_modules/@rdfoo/n3/lib/N3Util.js ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

// **N3Util** provides N3 utility functions

var Xsd = 'http://www.w3.org/2001/XMLSchema#';
var XsdString  = Xsd + 'string';
var XsdInteger = Xsd + 'integer';
var XsdDecimal = Xsd + 'decimal';
var XsdBoolean = Xsd + 'boolean';
var RdfLangString = 'http://www.w3.org/1999/02/22-rdf-syntax-ns#langString';

var N3Util = {
  // Tests whether the given entity (triple object) represents an IRI in the N3 library
  isIRI: function (entity) {
    if (!entity)
      return entity;
    var firstChar = entity[0];
    return firstChar !== '"' && firstChar !== '_';
  },

  // Tests whether the given entity (triple object) represents a literal in the N3 library
  isLiteral: function (entity) {
    return entity && entity[0] === '"';
  },

  // Tests whether the given entity (triple object) represents a blank node in the N3 library
  isBlank: function (entity) {
    return entity && entity.substr(0, 2) === '_:';
  },

  // Gets the string value of a literal in the N3 library
  getLiteralValue: function (literal) {
    var match = /^"([^]*)"/.exec(literal);
    if (!match)
      throw new Error(literal + ' is not a literal');
    return match[1];
  },

  // Gets the type of a literal in the N3 library
  getLiteralType: function (literal) {
    var match = /^"[^]*"(?:\^\^([^"]+)|(@)[^@"]+)?$/.exec(literal);
    if (!match)
      throw new Error(literal + ' is not a literal');
    return match[1] || (match[2] ? RdfLangString : XsdString);
  },

  // Gets the language of a literal in the N3 library
  getLiteralLanguage: function (literal) {
    var match = /^"[^]*"(?:@([^@"]+)|\^\^[^"]+)?$/.exec(literal);
    if (!match)
      throw new Error(literal + ' is not a literal');
    return match[1] ? match[1].toLowerCase() : '';
  },

  // Tests whether the given entity (triple object) represents a prefixed name
  isPrefixedName: function (entity) {
    return entity && /^[^:\/"']*:[^:\/"']+$/.test(entity);
  },

  // Expands the prefixed name to a full IRI (also when it occurs as a literal's type)
  expandPrefixedName: function (prefixedName, prefixes) {
    var match = /(?:^|"\^\^)([^:\/#"'\^_]*):[^\/]*$/.exec(prefixedName), prefix, base, index;
    if (match)
      prefix = match[1], base = prefixes[prefix], index = match.index;
    if (base === undefined)
      return prefixedName;

    // The match index is non-zero when expanding a literal's type.
    return index === 0 ? base + prefixedName.substr(prefix.length + 1)
                       : prefixedName.substr(0, index + 3) +
                         base + prefixedName.substr(index + prefix.length + 4);
  },

  // Creates an IRI in N3.js representation
  createIRI: function (iri) {
    return iri && iri[0] === '"' ? N3Util.getLiteralValue(iri) : iri;
  },

  // Creates a literal in N3.js representation
  createLiteral: function (value, modifier) {
    if (!modifier) {
      switch (typeof value) {
      case 'boolean':
        modifier = XsdBoolean;
        break;
      case 'number':
        if (isFinite(value)) {
          modifier = value % 1 === 0 ? XsdInteger : XsdDecimal;
          break;
        }
      default:
        return '"' + value + '"';
      }
    }
    return '"' + value +
           (/^[a-z]+(-[a-z0-9]+)*$/i.test(modifier) ? '"@'  + modifier.toLowerCase()
                                                    : '"^^' + modifier);
  },
};

// Add the N3Util functions to the given object or its prototype
function addN3Util(parent, toPrototype) {
  for (var name in N3Util)
    if (!toPrototype)
      parent[name] = N3Util[name];
    else
      parent.prototype[name] = applyToThis(N3Util[name]);

  return parent;
}

// Returns a function that applies `f` to the `this` object
function applyToThis(f) {
  return function (a) { return f(this, a); };
}

// Expose N3Util, attaching all functions to it
module.exports = addN3Util(addN3Util);


/***/ }),

/***/ "./node_modules/@rdfoo/n3/lib/N3Writer.js":
/*!************************************************!*\
  !*** ./node_modules/@rdfoo/n3/lib/N3Writer.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

// **N3Writer** writes N3 documents.

// Matches a literal as represented in memory by the N3 library
var N3LiteralMatcher = /^"([^]*)"(?:\^\^(.+)|@([\-a-z]+))?$/i;

// rdf:type predicate (for 'a' abbreviation)
var RDF_PREFIX = 'http://www.w3.org/1999/02/22-rdf-syntax-ns#',
    RDF_TYPE   = RDF_PREFIX + 'type';

// Characters in literals that require escaping
var escape    = /["\\\t\n\r\b\f\u0000-\u0019\ud800-\udbff]/,
    escapeAll = /["\\\t\n\r\b\f\u0000-\u0019]|[\ud800-\udbff][\udc00-\udfff]/g,
    escapeReplacements = { '\\': '\\\\', '"': '\\"', '\t': '\\t',
                           '\n': '\\n', '\r': '\\r', '\b': '\\b', '\f': '\\f' };

// ## Constructor
function N3Writer(outputStream, options) {
  if (!(this instanceof N3Writer))
    return new N3Writer(outputStream, options);

  // Shift arguments if the first argument is not a stream
  if (outputStream && typeof outputStream.write !== 'function')
    options = outputStream, outputStream = null;
  options = options || {};

  // If no output stream given, send the output as string through the end callback
  if (!outputStream) {
    var output = '';
    this._outputStream = {
      write: function (chunk, encoding, done) { output += chunk; done && done(); },
      end:   function (done) { done && done(null, output); },
    };
    this._endStream = true;
  }
  else {
    this._outputStream = outputStream;
    this._endStream = options.end === undefined ? true : !!options.end;
  }

  // Initialize writer, depending on the format
  this._subject = null;
  if (!(/triple|quad/i).test(options.format)) {
    this._graph = '';
    this._prefixIRIs = Object.create(null);
    options.prefixes && this.addPrefixes(options.prefixes);
  }
  else {
    this._writeTriple = this._writeTripleLine;
  }
}

N3Writer.prototype = {
  // ## Private methods

  // ### `_write` writes the argument to the output stream
  _write: function (string, callback) {
    this._outputStream.write(string, 'utf8', callback);
  },

    // ### `_writeTriple` writes the triple to the output stream
  _writeTriple: function (subject, predicate, object, graph, done) {
    try {
      // Write the graph's label if it has changed
      if (this._graph !== graph) {
        // Close the previous graph and start the new one
        this._write((this._subject === null ? '' : (this._graph ? '\n}\n' : '.\n')) +
                    (graph ? this._encodeIriOrBlankNode(graph) + ' {\n' : ''));
        this._subject = null;
        // Don't treat identical blank nodes as repeating graphs
        this._graph = graph[0] !== '[' ? graph : ']';
      }
      // Don't repeat the subject if it's the same
      if (this._subject === subject) {
        // Don't repeat the predicate if it's the same
        if (this._predicate === predicate)
          this._write(', ' + this._encodeObject(object), done);
        // Same subject, different predicate
        else
          this._write(';\n    ' +
                      this._encodePredicate(this._predicate = predicate) + ' ' +
                      this._encodeObject(object), done);
      }
      // Different subject; write the whole triple
      else
        this._write((this._subject === null ? '' : '.\n') +
                    this._encodeSubject(this._subject = subject) + ' ' +
                    this._encodePredicate(this._predicate = predicate) + ' ' +
                    this._encodeObject(object), done);
    }
    catch (error) { done && done(error); }
  },

  // ### `_writeTripleLine` writes the triple or quad to the output stream as a single line
  _writeTripleLine: function (subject, predicate, object, graph, done) {
    // Don't use prefixes
    delete this._prefixMatch;
    // Write the triple
    try {
      this._write(this._encodeIriOrBlankNode(subject) + ' ' +
                  this._encodeIriOrBlankNode(predicate) + ' ' +
                  this._encodeObject(object) +
                  (graph ? ' ' + this._encodeIriOrBlankNode(graph) + '.\n' : '.\n'), done);
    }
    catch (error) { done && done(error); }
  },

  // ### `_encodeIriOrBlankNode` represents an IRI or blank node
  _encodeIriOrBlankNode: function (entity) {
    // A blank node or list is represented as-is
    var firstChar = entity[0];
    if (firstChar === '[' || firstChar === '(' || firstChar === '_' && entity[1] === ':')
      return entity;
    // Escape special characters
    if (escape.test(entity))
      entity = entity.replace(escapeAll, characterReplacer);
    // Try to represent the IRI as prefixed name
    var prefixMatch = this._prefixRegex.exec(entity);
    return !prefixMatch ? '<' + entity + '>' :
           (!prefixMatch[1] ? entity : this._prefixIRIs[prefixMatch[1]] + prefixMatch[2]);
  },

  // ### `_encodeLiteral` represents a literal
  _encodeLiteral: function (value, type, language) {
    // Escape special characters
    if (escape.test(value))
      value = value.replace(escapeAll, characterReplacer);
    // Write the literal, possibly with type or language
    if (language)
      return '"' + value + '"@' + language;
    else if (type)
      return '"' + value + '"^^' + this._encodeIriOrBlankNode(type);
    else
      return '"' + value + '"';
  },

  // ### `_encodeSubject` represents a subject
  _encodeSubject: function (subject) {
    if (subject[0] === '"')
      throw new Error('A literal as subject is not allowed: ' + subject);
    // Don't treat identical blank nodes as repeating subjects
    if (subject[0] === '[')
      this._subject = ']';
    return this._encodeIriOrBlankNode(subject);
  },

  // ### `_encodePredicate` represents a predicate
  _encodePredicate: function (predicate) {
    if (predicate[0] === '"')
      throw new Error('A literal as predicate is not allowed: ' + predicate);
    return predicate === RDF_TYPE ? 'a' : this._encodeIriOrBlankNode(predicate);
  },

  // ### `_encodeObject` represents an object
  _encodeObject: function (object) {
    // Represent an IRI or blank node
    if (object[0] !== '"')
      return this._encodeIriOrBlankNode(object);
    // Represent a literal
    var match = N3LiteralMatcher.exec(object);
    if (!match) throw new Error('Invalid literal: ' + object);
    return this._encodeLiteral(match[1], match[2], match[3]);
  },

  // ### `_blockedWrite` replaces `_write` after the writer has been closed
  _blockedWrite: function () {
    throw new Error('Cannot write because the writer has been closed.');
  },

  // ### `addTriple` adds the triple to the output stream
  addTriple: function (subject, predicate, object, graph, done) {
    // The triple was given as a triple object, so shift parameters
    if (object === undefined)
      this._writeTriple(subject.subject, subject.predicate, subject.object,
                        subject.graph || '', predicate);
    // The optional `graph` parameter was not provided
    else if (typeof graph !== 'string')
      this._writeTriple(subject, predicate, object, '', graph);
    // The `graph` parameter was provided
    else
      this._writeTriple(subject, predicate, object, graph, done);
  },

  // ### `addTriples` adds the triples to the output stream
  addTriples: function (triples) {
    for (var i = 0; i < triples.length; i++)
      this.addTriple(triples[i]);
  },

  // ### `addPrefix` adds the prefix to the output stream
  addPrefix: function (prefix, iri, done) {
    var prefixes = {};
    prefixes[prefix] = iri;
    this.addPrefixes(prefixes, done);
  },

  // ### `addPrefixes` adds the prefixes to the output stream
  addPrefixes: function (prefixes, done) {
    // Add all useful prefixes
    var prefixIRIs = this._prefixIRIs, hasPrefixes = false;
    for (var prefix in prefixes) {
      // Verify whether the prefix can be used and does not exist yet
      var iri = prefixes[prefix];
      if (/[#\/]$/.test(iri) && prefixIRIs[iri] !== (prefix += ':')) {
        hasPrefixes = true;
        prefixIRIs[iri] = prefix;
        // Finish a possible pending triple
        if (this._subject !== null) {
          this._write(this._graph ? '\n}\n' : '.\n');
          this._subject = null, this._graph = '';
        }
        // Write prefix
        this._write('@prefix ' + prefix + ' <' + iri + '>.\n');
      }
    }
    // Recreate the prefix matcher
    if (hasPrefixes) {
      var IRIlist = '', prefixList = '';
      for (var prefixIRI in prefixIRIs) {
        IRIlist += IRIlist ? '|' + prefixIRI : prefixIRI;
        prefixList += (prefixList ? '|' : '') + prefixIRIs[prefixIRI];
      }
      IRIlist = IRIlist.replace(/[\]\/\(\)\*\+\?\.\\\$]/g, '\\$&');
      this._prefixRegex = new RegExp('^(?:' + prefixList + ')[^\/]*$|' +
                                     '^(' + IRIlist + ')([a-zA-Z][\\-_a-zA-Z0-9]*)$');
    }
    // End a prefix block with a newline
    this._write(hasPrefixes ? '\n' : '', done);
  },

  // ### `blank` creates a blank node with the given content
  blank: function (predicate, object) {
    var children = predicate, child, length;
    // Empty blank node
    if (predicate === undefined)
      children = [];
    // Blank node passed as blank("predicate", "object")
    else if (typeof predicate === 'string')
      children = [{ predicate: predicate, object: object }];
    // Blank node passed as blank({ predicate: predicate, object: object })
    else if (!('length' in predicate))
      children = [predicate];

    switch (length = children.length) {
    // Generate an empty blank node
    case 0:
      return '[]';
    // Generate a non-nested one-triple blank node
    case 1:
      child = children[0];
      if (child.object[0] !== '[')
        return '[ ' + this._encodePredicate(child.predicate) + ' ' +
                      this._encodeObject(child.object) + ' ]';
    // Generate a multi-triple or nested blank node
    default:
      var contents = '[';
      // Write all triples in order
      for (var i = 0; i < length; i++) {
        child = children[i];
        // Write only the object is the predicate is the same as the previous
        if (child.predicate === predicate)
          contents += ', ' + this._encodeObject(child.object);
        // Otherwise, write the predicate and the object
        else {
          contents += (i ? ';\n  ' : '\n  ') +
                      this._encodePredicate(child.predicate) + ' ' +
                      this._encodeObject(child.object);
          predicate = child.predicate;
        }
      }
      return contents + '\n]';
    }
  },

  // ### `list` creates a list node with the given content
  list: function (elements) {
    var length = elements && elements.length || 0, contents = new Array(length);
    for (var i = 0; i < length; i++)
      contents[i] = this._encodeObject(elements[i]);
    return '(' + contents.join(' ') + ')';
  },

  // ### `_prefixRegex` matches a prefixed name or IRI that begins with one of the added prefixes
  _prefixRegex: /$0^/,

  // ### `end` signals the end of the output stream
  end: function (done) {
    // Finish a possible pending triple
    if (this._subject !== null) {
      this._write(this._graph ? '\n}\n' : '.\n');
      this._subject = null;
    }
    // Disallow further writing
    this._write = this._blockedWrite;

    // Try to end the underlying stream, ensuring done is called exactly one time
    var singleDone = done && function (error, result) { singleDone = null, done(error, result); };
    if (this._endStream) {
      try { return this._outputStream.end(singleDone); }
      catch (error) { /* error closing stream */ }
    }
    singleDone && singleDone();
  },
};

// Replaces a character by its escaped version
function characterReplacer(character) {
  // Replace a single character by its escaped version
  var result = escapeReplacements[character];
  if (result === undefined) {
    // Replace a single character with its 4-bit unicode escape sequence
    if (character.length === 1) {
      result = character.charCodeAt(0).toString(16);
      result = '\\u0000'.substr(0, 6 - result.length) + result;
    }
    // Replace a surrogate pair with its 8-bit unicode escape sequence
    else {
      result = ((character.charCodeAt(0) - 0xD800) * 0x400 +
                 character.charCodeAt(1) + 0x2400).toString(16);
      result = '\\U00000000'.substr(0, 10 - result.length) + result;
    }
  }
  return result;
}

// ## Exports

// Export the `N3Writer` class as a whole.
module.exports = N3Writer;


/***/ }),

/***/ "./node_modules/@rdfoo/rdf-parser-n3/index.js":
/*!****************************************************!*\
  !*** ./node_modules/@rdfoo/rdf-parser-n3/index.js ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var rdf = __webpack_require__(/*! rdf-ext */ "./node_modules/rdf-ext/rdf-ext.js")
var util = __webpack_require__(/*! util */ "util")
var AbstractParser = __webpack_require__(/*! rdf-parser-abstract */ "./node_modules/rdf-parser-abstract/index.js")
var N3 = __webpack_require__(/*! @rdfoo/n3 */ "./node_modules/@rdfoo/n3/N3.js")

function N3Parser (options) {
  AbstractParser.call(this, rdf)

  this.options = options || {}

  if (!('importPrefixMap' in this.options)) {
    this.options.importPrefixMap = true
  }
}

util.inherits(N3Parser, AbstractParser)

N3Parser.prototype.process = function (data, callback, base, filter, done) {
  var self = this

  return new Promise(function (resolve, reject) {
    filter = filter || function () { return true }

    var parser = N3.Parser({documentIRI: base})
    var blankNodes = {}

    parser.parse(data, function (error, n3Triple, n3Prefixes) {
      if (error) {
        if (done) {
          done(error)
        }

        return reject(error)
      }

      if (self.options.importPrefixMap && n3Prefixes) {
        for (var prefix in n3Prefixes) {
          self.rdf.prefixes[prefix] = n3Prefixes[prefix]
        }
      }

      if (!n3Triple) {
        if (done) {
          done()
        }

        return resolve()
      }

      var toRdfNode = function (n3Node) {
        if (N3.Util.isIRI(n3Node)) {
          return self.rdf.createNamedNode(n3Node)
        } else if (N3.Util.isBlank(n3Node)) {
          if (n3Node in blankNodes) {
            return blankNodes[n3Node]
          } else {
            return (blankNodes[n3Node] = self.rdf.createBlankNode())
          }
        } else {
          var lang = N3.Util.getLiteralLanguage(n3Node)
          var type = N3.Util.getLiteralType(n3Node)

          if (lang === '') {
            lang = null
          }

          if (type === 'http://www.w3.org/2001/XMLSchema#string') {
            type = null
          }

          return self.rdf.createLiteral(
            N3.Util.getLiteralValue(n3Node),
            lang,
            type ? self.rdf.createNamedNode(type) : null)
        }
      }

      var pushTriple = function (n3Triple) {
        var triple = self.rdf.createTriple(
          toRdfNode(n3Triple.subject),
          toRdfNode(n3Triple.predicate),
          toRdfNode(n3Triple.object))

        if (filter(triple)) {
          callback(triple)
        }
      }

      pushTriple(n3Triple)
    })
  })
}

// add singleton methods to class
var instance = new N3Parser()

for (var property in instance) {
  N3Parser[property] = instance[property]
}

module.exports = N3Parser


/***/ }),

/***/ "./node_modules/acorn-es7-plugin/acorn-es7-plugin.js":
/*!***********************************************************!*\
  !*** ./node_modules/acorn-es7-plugin/acorn-es7-plugin.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = function(acorn) {
    switch (parseInt(acorn.version)) {
    case 2:
    case 3:
        acorn.plugins.asyncawait = __webpack_require__(/*! ./acorn-v3 */ "./node_modules/acorn-es7-plugin/acorn-v3.js") ;
        break ;
    case 4:
        acorn.plugins.asyncawait = __webpack_require__(/*! ./acorn-v4 */ "./node_modules/acorn-es7-plugin/acorn-v4.js") ;
        break ;
    case 5:
        acorn.plugins.asyncawait = __webpack_require__(/*! ./acorn-v4 */ "./node_modules/acorn-es7-plugin/acorn-v4.js") ;
        break ;
    default:
        throw new Error("acorn-es7-plugin requires Acorn v2, 3, 4 or 5") ;
    }
    return acorn
}


/***/ }),

/***/ "./node_modules/acorn-es7-plugin/acorn-v3.js":
/*!***************************************************!*\
  !*** ./node_modules/acorn-es7-plugin/acorn-v3.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var NotAsync = {} ;
var asyncExit = /^async[\t ]+(return|throw)/ ;
var asyncFunction = /^async[\t ]+function/ ;
var atomOrPropertyOrLabel = /^\s*[():;]/ ;
var removeComments = /([^\n])\/\*(\*(?!\/)|[^\n*])*\*\/([^\n])/g ;
var matchAsyncGet = /\s*(get|set)\s*\(/ ;

function hasLineTerminatorBeforeNext(st, since) {
    return st.lineStart >= since;
}

function test(regex,st,noComment) {
    var src = st.input.slice(st.start) ;
    if (noComment) {
        src = src.replace(removeComments,"$1 $3") ;
  }
    return regex.test(src);
}

/* Create a new parser derived from the specified parser, so that in the
 * event of an error we can back out and try again */
function subParse(parser, pos, extensions,parens) {
    var p = new parser.constructor(parser.options, parser.input, pos);
    if (extensions)
        for (var k in extensions)
            p[k] = extensions[k] ;

    var src = parser ;
    var dest = p ;
    ['inFunction','inAsyncFunction','inAsync','inGenerator','inModule'].forEach(function(k){
        if (k in src)
            dest[k] = src[k] ;
    }) ;
    if (parens)
        p.options.preserveParens = true ;
    p.nextToken();
    return p;
}

//TODO: Implement option noAsyncGetters

function asyncAwaitPlugin (parser,options){
    var es7check = function(){} ;

    parser.extend("initialContext",function(base){
        return function(){
            if (this.options.ecmaVersion < 7) {
                es7check = function(node) {
                    parser.raise(node.start,"async/await keywords only available when ecmaVersion>=7") ;
                } ;
            }
            this.reservedWords = new RegExp(this.reservedWords.toString().replace(/await|async/g,"").replace("|/","/").replace("/|","/").replace("||","|")) ;
            this.reservedWordsStrict = new RegExp(this.reservedWordsStrict.toString().replace(/await|async/g,"").replace("|/","/").replace("/|","/").replace("||","|")) ;
            this.reservedWordsStrictBind = new RegExp(this.reservedWordsStrictBind.toString().replace(/await|async/g,"").replace("|/","/").replace("/|","/").replace("||","|")) ;
            this.inAsyncFunction = options.inAsyncFunction ;
            if (options.awaitAnywhere && options.inAsyncFunction)
                parser.raise(node.start,"The options awaitAnywhere and inAsyncFunction are mutually exclusive") ;

            return base.apply(this,arguments);
        }
    }) ;

    parser.extend("shouldParseExportStatement",function(base){
        return function(){
            if (this.type.label==='name' && this.value==='async' && test(asyncFunction,this)) {
                return true ;
            }
            return base.apply(this,arguments) ;
        }
    }) ;

    parser.extend("parseStatement",function(base){
        return function (declaration, topLevel) {
            var start = this.start;
            var startLoc = this.startLoc;
            if (this.type.label==='name') {
                if (test(asyncFunction,this,true)) {
                    var wasAsync = this.inAsyncFunction ;
                    try {
                        this.inAsyncFunction = true ;
                        this.next() ;
                        var r = this.parseStatement(declaration, topLevel) ;
                        r.async = true ;
                        r.start = start;
                        r.loc && (r.loc.start = startLoc);
                        r.range && (r.range[0] = start);
                        return r ;
                    } finally {
                        this.inAsyncFunction = wasAsync ;
                    }
                } else if ((typeof options==="object" && options.asyncExits) && test(asyncExit,this)) {
                    // NON-STANDARD EXTENSION iff. options.asyncExits is set, the
                    // extensions 'async return <expr>?' and 'async throw <expr>?'
                    // are enabled. In each case they are the standard ESTree nodes
                    // with the flag 'async:true'
                    this.next() ;
                    var r = this.parseStatement(declaration, topLevel) ;
                    r.async = true ;
                    r.start = start;
                    r.loc && (r.loc.start = startLoc);
                    r.range && (r.range[0] = start);
                   return r ;
                }
            }
            return base.apply(this,arguments);
        }
    }) ;

  parser.extend("parseIdent",function(base){
        return function(liberal){
                var id = base.apply(this,arguments);
                if (this.inAsyncFunction && id.name==='await') {
                    if (arguments.length===0) {
                        this.raise(id.start,"'await' is reserved within async functions") ;
                    }
                }
                return id ;
        }
    }) ;

  parser.extend("parseExprAtom",function(base){
        return function(refShorthandDefaultPos){
            var start = this.start ;
            var startLoc = this.startLoc;
            var rhs,r = base.apply(this,arguments);
            if (r.type==='Identifier') {
                if (r.name==='async' && !hasLineTerminatorBeforeNext(this, r.end)) {
                    // Is this really an async function?
                    var isAsync = this.inAsyncFunction ;
                    try {
                        this.inAsyncFunction = true ;
                        var pp = this ;
                        var inBody = false ;

                        var parseHooks = {
                            parseFunctionBody:function(node,isArrowFunction){
                                try {
                                    var wasInBody = inBody ;
                                    inBody = true ;
                                    return pp.parseFunctionBody.apply(this,arguments) ;
                                } finally {
                                    inBody = wasInBody ;
                                }
                            },
                            raise:function(){
                                try {
                                    return pp.raise.apply(this,arguments) ;
                                } catch(ex) {
                                    throw inBody?ex:NotAsync ;
                                }
                            }
                        } ;

                        rhs = subParse(this,this.start,parseHooks,true).parseExpression() ;
                        if (rhs.type==='SequenceExpression')
                            rhs = rhs.expressions[0] ;
                        if (rhs.type === 'CallExpression')
                            rhs = rhs.callee ;
                        if (rhs.type==='FunctionExpression' || rhs.type==='FunctionDeclaration' || rhs.type==='ArrowFunctionExpression') {
                            // Because we don't know if the top level parser supprts preserveParens, we have to re-parse
                            // without it set
                            rhs = subParse(this,this.start,parseHooks).parseExpression() ;
                            if (rhs.type==='SequenceExpression')
                                rhs = rhs.expressions[0] ;
                            if (rhs.type === 'CallExpression')
                                rhs = rhs.callee ;
                            
                            rhs.async = true ;
                            rhs.start = start;
                            rhs.loc && (rhs.loc.start = startLoc);
                            rhs.range && (rhs.range[0] = start);
                            this.pos = rhs.end;
                            this.end = rhs.end ;
                            this.endLoc = rhs.endLoc ;
                            this.next();
                            es7check(rhs) ;
                            return rhs ;
                        }
                    } catch (ex) {
                        if (ex!==NotAsync)
                            throw ex ;
                    }
                    finally {
                        this.inAsyncFunction = isAsync ;
                    }
                }
                else if (r.name==='await') {
                    var n = this.startNodeAt(r.start, r.loc && r.loc.start);
                    if (this.inAsyncFunction) {
                        rhs = this.parseExprSubscripts() ;
                        n.operator = 'await' ;
                        n.argument = rhs ;
                        n = this.finishNodeAt(n,'AwaitExpression', rhs.end, rhs.loc && rhs.loc.end) ;
                        es7check(n) ;
                        return n ;
                    }
                    // NON-STANDARD EXTENSION iff. options.awaitAnywhere is true,
                    // an 'AwaitExpression' is allowed anywhere the token 'await'
                    // could not be an identifier with the name 'await'.

                    // Look-ahead to see if this is really a property or label called async or await
                    if (this.input.slice(r.end).match(atomOrPropertyOrLabel)) {
                        if (!options.awaitAnywhere && this.options.sourceType === 'module')
                            return this.raise(r.start,"'await' is reserved within modules") ;
                        return r ; // This is a valid property name or label
                    }

                    if (typeof options==="object" && options.awaitAnywhere) {
                        start = this.start ;
                        rhs = subParse(this,start-4).parseExprSubscripts() ;
                        if (rhs.end<=start) {
                            rhs = subParse(this,start).parseExprSubscripts() ;
                            n.operator = 'await' ;
                            n.argument = rhs ;
                            n = this.finishNodeAt(n,'AwaitExpression', rhs.end, rhs.loc && rhs.loc.end) ;
                            this.pos = rhs.end;
                            this.end = rhs.end ;
                            this.endLoc = rhs.endLoc ;
                            this.next();
                            es7check(n) ;
                            return n ;
                        }
                    }

                    if (!options.awaitAnywhere && this.options.sourceType === 'module')
                        return this.raise(r.start,"'await' is reserved within modules") ;
                }
            }
            return r ;
        }
    }) ;

    parser.extend('finishNodeAt',function(base){
            return function(node,type,pos,loc) {
                if (node.__asyncValue) {
                    delete node.__asyncValue ;
                    node.value.async = true ;
                }
                return base.apply(this,arguments) ;
            }
    }) ;

    parser.extend('finishNode',function(base){
            return function(node,type) {
                if (node.__asyncValue) {
                    delete node.__asyncValue ;
                    node.value.async = true ;
                }
                return base.apply(this,arguments) ;
            }
    }) ;

    var allowedPropSpecifiers = {
        get:true,
        set:true,
        async:true
    };
    
    parser.extend("parsePropertyName",function(base){
        return function (prop) {
            var prevName = prop.key && prop.key.name ;
            var key = base.apply(this,arguments) ;
            if (key.type === "Identifier" && (key.name === "async") && !hasLineTerminatorBeforeNext(this, key.end)) {
                // Look-ahead to see if this is really a property or label called async or await
                if (!this.input.slice(key.end).match(atomOrPropertyOrLabel)){
                    // Cheese - eliminate the cases 'async get(){}' and async set(){}'
                    if (matchAsyncGet.test(this.input.slice(key.end))) {
                        key = base.apply(this,arguments) ;
                        prop.__asyncValue = true ;
                    } else {
                        es7check(prop) ;
                        if (prop.kind === 'set') 
                            this.raise(key.start,"'set <member>(value)' cannot be be async") ;
                        
                        key = base.apply(this,arguments) ;
                        if (key.type==='Identifier') {
                            if (key.name==='set')
                                this.raise(key.start,"'set <member>(value)' cannot be be async") ;
                        }
                        prop.__asyncValue = true ;
                    }
                }
            }
            return key;
        };
    }) ;

    parser.extend("parseClassMethod",function(base){
        return function (classBody, method, isGenerator) {
            var wasAsync ;
            if (method.__asyncValue) {
                if (method.kind==='constructor')
                    this.raise(method.start,"class constructor() cannot be be async") ;
                wasAsync = this.inAsyncFunction ;
                this.inAsyncFunction = true ;
            }
            var r = base.apply(this,arguments) ;
            this.inAsyncFunction = wasAsync ;
            return r ;
        }
    }) ;

    parser.extend("parseMethod",function(base){
        return function (isGenerator) {
            var wasAsync ;
            if (this.__currentProperty && this.__currentProperty.__asyncValue) {
                wasAsync = this.inAsyncFunction ;
                this.inAsyncFunction = true ;
            }
            var r = base.apply(this,arguments) ;
            this.inAsyncFunction = wasAsync ;
            return r ;
        }
    }) ;

    parser.extend("parsePropertyValue",function(base){
        return function (prop, isPattern, isGenerator, startPos, startLoc, refDestructuringErrors) {
            var prevProp = this.__currentProperty ; 
            this.__currentProperty = prop ;
            var wasAsync ;
            if (prop.__asyncValue) {
                wasAsync = this.inAsyncFunction ;
                this.inAsyncFunction = true ;
            }
            var r = base.apply(this,arguments) ;
            this.inAsyncFunction = wasAsync ;
            this.__currentProperty = prevProp ;
            return r ;
        }
    }) ;
}

module.exports = asyncAwaitPlugin ;


/***/ }),

/***/ "./node_modules/acorn-es7-plugin/acorn-v4.js":
/*!***************************************************!*\
  !*** ./node_modules/acorn-es7-plugin/acorn-v4.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var asyncExit = /^async[\t ]+(return|throw)/ ;
var atomOrPropertyOrLabel = /^\s*[):;]/ ;
var removeComments = /([^\n])\/\*(\*(?!\/)|[^\n*])*\*\/([^\n])/g ;

function hasLineTerminatorBeforeNext(st, since) {
    return st.lineStart >= since;
}

function test(regex,st,noComment) {
    var src = st.input.slice(st.start) ;
    if (noComment) {
        src = src.replace(removeComments,"$1 $3") ;
    }
    return regex.test(src);
}

/* Create a new parser derived from the specified parser, so that in the
 * event of an error we can back out and try again */
function subParse(parser, pos, extensions) {
    var p = new parser.constructor(parser.options, parser.input, pos);
    if (extensions)
        for (var k in extensions)
            p[k] = extensions[k] ;

    var src = parser ;
    var dest = p ;
    ['inFunction','inAsync','inGenerator','inModule'].forEach(function(k){
        if (k in src)
            dest[k] = src[k] ;
    }) ;
    p.nextToken();
    return p;
}

function asyncAwaitPlugin (parser,options){
    if (!options || typeof options !== "object")
        options = {} ;

    parser.extend("parse",function(base){
        return function(){
            this.inAsync = options.inAsyncFunction ;
            if (options.awaitAnywhere && options.inAsyncFunction)
                parser.raise(node.start,"The options awaitAnywhere and inAsyncFunction are mutually exclusive") ;

            return base.apply(this,arguments);
        }
    }) ;

    parser.extend("parseStatement",function(base){
        return function (declaration, topLevel) {
            var start = this.start;
            var startLoc = this.startLoc;
            if (this.type.label==='name') {
                if ((options.asyncExits) && test(asyncExit,this)) {
                    // TODO: Ensure this function is itself nested in an async function or Method
                    this.next() ;

                    var r = this.parseStatement(declaration, topLevel) ;
                    r.async = true ;
                    r.start = start;
                    r.loc && (r.loc.start = startLoc);
                    r.range && (r.range[0] = start);
                    return r ;
                }
            }
            return base.apply(this,arguments);
        }
    }) ;

    parser.extend("parseIdent",function(base){
        return function(liberal) {
            if (this.options.sourceType==='module' && this.options.ecmaVersion >= 8 && options.awaitAnywhere)
                return base.call(this,true) ; // Force liberal mode if awaitAnywhere is set
            return base.apply(this,arguments) ;
        }
    }) ;

    parser.extend("parseExprAtom",function(base){
        var NotAsync = {};
        return function(refShorthandDefaultPos){
            var start = this.start ;
            var startLoc = this.startLoc;

            var rhs,r = base.apply(this,arguments);

            if (r.type==='Identifier') {
                if (r.name==='await' && !this.inAsync) {
                    if (options.awaitAnywhere) {
                        var n = this.startNodeAt(r.start, r.loc && r.loc.start);

                        start = this.start ;

                        var parseHooks = {
                            raise:function(){
                                try {
                                    return pp.raise.apply(this,arguments) ;
                                } catch(ex) {
                                    throw /*inBody?ex:*/NotAsync ;
                                }
                            }
                        } ;

                        try {
                            rhs = subParse(this,start-4,parseHooks).parseExprSubscripts() ;
                            if (rhs.end<=start) {
                                rhs = subParse(this,start,parseHooks).parseExprSubscripts() ;
                                n.argument = rhs ;
                                n = this.finishNodeAt(n,'AwaitExpression', rhs.end, rhs.loc && rhs.loc.end) ;
                                this.pos = rhs.end;
                                this.end = rhs.end ;
                                this.endLoc = rhs.endLoc ;
                                this.next();
                                return n ;
                            }
                        } catch (ex) {
                            if (ex===NotAsync)
                                return r ;
                            throw ex ;
                        }
                    }
                }
            }
            return r ;
        }
    }) ;

    var allowedPropValues = {
        undefined:true,
        get:true,
        set:true,
        static:true,
        async:true,
        constructor:true
    };
    parser.extend("parsePropertyName",function(base){
        return function (prop) {
            var prevName = prop.key && prop.key.name ;
            var key = base.apply(this,arguments) ;
            if (this.value==='get') {
                prop.__maybeStaticAsyncGetter = true ;
            }
            var next ;
            if (allowedPropValues[this.value])
                return key ;

            if (key.type === "Identifier" && (key.name === "async" || prevName === "async") && !hasLineTerminatorBeforeNext(this, key.end) 
                // Look-ahead to see if this is really a property or label called async or await
                && !this.input.slice(key.end).match(atomOrPropertyOrLabel)) {
                if (prop.kind === 'set' || key.name === 'set') 
                    this.raise(key.start,"'set <member>(value)' cannot be be async") ;
                else {
                    this.__isAsyncProp = true ;
                    key = base.apply(this,arguments) ;
                    if (key.type==='Identifier') {
                        if (key.name==='set')
                            this.raise(key.start,"'set <member>(value)' cannot be be async") ;
                    }
                }
            } else {
                delete prop.__maybeStaticAsyncGetter ;
            }
            return key;
        };
    }) ;

    parser.extend("parseClassMethod",function(base){
        return function (classBody, method, isGenerator) {
            var r = base.apply(this,arguments) ;
            if (method.__maybeStaticAsyncGetter) {
                delete method.__maybeStaticAsyncGetter ;
                if (method.key.name!=='get')
                    method.kind = "get" ;
            }
            return r ;
        }
    }) ;


    parser.extend("parseFunctionBody",function(base){
        return function (node, isArrowFunction) {
            var wasAsync = this.inAsync ;
            if (this.__isAsyncProp) {
                node.async = true ;
                this.inAsync = true ;
                delete this.__isAsyncProp ;
            }
            var r = base.apply(this,arguments) ;
            this.inAsync = wasAsync ;
            return r ;
        }
    }) ;
}

module.exports = asyncAwaitPlugin ;


/***/ }),

/***/ "./node_modules/acorn/dist/acorn.es.js":
/*!*********************************************!*\
  !*** ./node_modules/acorn/dist/acorn.es.js ***!
  \*********************************************/
/*! exports provided: version, parse, parseExpressionAt, tokenizer, parse_dammit, LooseParser, pluginsLoose, addLooseExports, Parser, plugins, defaultOptions, Position, SourceLocation, getLineInfo, Node, TokenType, tokTypes, keywordTypes, TokContext, tokContexts, isIdentifierChar, isIdentifierStart, Token, isNewLine, lineBreak, lineBreakG, nonASCIIwhitespace */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "version", function() { return version; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parse", function() { return parse; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parseExpressionAt", function() { return parseExpressionAt; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "tokenizer", function() { return tokenizer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parse_dammit", function() { return parse_dammit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LooseParser", function() { return LooseParser; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "pluginsLoose", function() { return pluginsLoose; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addLooseExports", function() { return addLooseExports; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Parser", function() { return Parser; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "plugins", function() { return plugins; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultOptions", function() { return defaultOptions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Position", function() { return Position; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SourceLocation", function() { return SourceLocation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLineInfo", function() { return getLineInfo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Node", function() { return Node; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TokenType", function() { return TokenType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "tokTypes", function() { return types; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "keywordTypes", function() { return keywords$1; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TokContext", function() { return TokContext; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "tokContexts", function() { return types$1; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isIdentifierChar", function() { return isIdentifierChar; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isIdentifierStart", function() { return isIdentifierStart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Token", function() { return Token; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isNewLine", function() { return isNewLine; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "lineBreak", function() { return lineBreak; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "lineBreakG", function() { return lineBreakG; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "nonASCIIwhitespace", function() { return nonASCIIwhitespace; });
// Reserved word lists for various dialects of the language

var reservedWords = {
  3: "abstract boolean byte char class double enum export extends final float goto implements import int interface long native package private protected public short static super synchronized throws transient volatile",
  5: "class enum extends super const export import",
  6: "enum",
  strict: "implements interface let package private protected public static yield",
  strictBind: "eval arguments"
};

// And the keywords

var ecma5AndLessKeywords = "break case catch continue debugger default do else finally for function if return switch throw try var while with null true false instanceof typeof void delete new in this";

var keywords = {
  5: ecma5AndLessKeywords,
  6: ecma5AndLessKeywords + " const class extends export import super"
};

var keywordRelationalOperator = /^in(stanceof)?$/;

// ## Character categories

// Big ugly regular expressions that match characters in the
// whitespace, identifier, and identifier-start categories. These
// are only applied when a character is found to actually have a
// code point above 128.
// Generated by `bin/generate-identifier-regex.js`.

var nonASCIIidentifierStartChars = "\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u037f\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u052f\u0531-\u0556\u0559\u0560-\u0588\u05d0-\u05ea\u05ef-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u0860-\u086a\u08a0-\u08b4\u08b6-\u08bd\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u09fc\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0af9\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c39\u0c3d\u0c58-\u0c5a\u0c60\u0c61\u0c80\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d54-\u0d56\u0d5f-\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e87\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa\u0eab\u0ead-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f5\u13f8-\u13fd\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f8\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1878\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191e\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4b\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1c80-\u1c88\u1c90-\u1cba\u1cbd-\u1cbf\u1ce9-\u1cec\u1cee-\u1cf1\u1cf5\u1cf6\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2118-\u211d\u2124\u2126\u2128\u212a-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309b-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312f\u3131-\u318e\u31a0-\u31ba\u31f0-\u31ff\u3400-\u4db5\u4e00-\u9fef\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua69d\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua7b9\ua7f7-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua8fd\ua8fe\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\ua9e0-\ua9e4\ua9e6-\ua9ef\ua9fa-\ua9fe\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa7e-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uab30-\uab5a\uab5c-\uab65\uab70-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc";
var nonASCIIidentifierChars = "\u200c\u200d\xb7\u0300-\u036f\u0387\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u0669\u0670\u06d6-\u06dc\u06df-\u06e4\u06e7\u06e8\u06ea-\u06ed\u06f0-\u06f9\u0711\u0730-\u074a\u07a6-\u07b0\u07c0-\u07c9\u07eb-\u07f3\u07fd\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0859-\u085b\u08d3-\u08e1\u08e3-\u0903\u093a-\u093c\u093e-\u094f\u0951-\u0957\u0962\u0963\u0966-\u096f\u0981-\u0983\u09bc\u09be-\u09c4\u09c7\u09c8\u09cb-\u09cd\u09d7\u09e2\u09e3\u09e6-\u09ef\u09fe\u0a01-\u0a03\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a66-\u0a71\u0a75\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae2\u0ae3\u0ae6-\u0aef\u0afa-\u0aff\u0b01-\u0b03\u0b3c\u0b3e-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b56\u0b57\u0b62\u0b63\u0b66-\u0b6f\u0b82\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c00-\u0c04\u0c3e-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0c66-\u0c6f\u0c81-\u0c83\u0cbc\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0ce6-\u0cef\u0d00-\u0d03\u0d3b\u0d3c\u0d3e-\u0d44\u0d46-\u0d48\u0d4a-\u0d4d\u0d57\u0d62\u0d63\u0d66-\u0d6f\u0d82\u0d83\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0de6-\u0def\u0df2\u0df3\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0e50-\u0e59\u0eb1\u0eb4-\u0eb9\u0ebb\u0ebc\u0ec8-\u0ecd\u0ed0-\u0ed9\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f3e\u0f3f\u0f71-\u0f84\u0f86\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102b-\u103e\u1040-\u1049\u1056-\u1059\u105e-\u1060\u1062-\u1064\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u109d\u135d-\u135f\u1369-\u1371\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17b4-\u17d3\u17dd\u17e0-\u17e9\u180b-\u180d\u1810-\u1819\u18a9\u1920-\u192b\u1930-\u193b\u1946-\u194f\u19d0-\u19da\u1a17-\u1a1b\u1a55-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1ab0-\u1abd\u1b00-\u1b04\u1b34-\u1b44\u1b50-\u1b59\u1b6b-\u1b73\u1b80-\u1b82\u1ba1-\u1bad\u1bb0-\u1bb9\u1be6-\u1bf3\u1c24-\u1c37\u1c40-\u1c49\u1c50-\u1c59\u1cd0-\u1cd2\u1cd4-\u1ce8\u1ced\u1cf2-\u1cf4\u1cf7-\u1cf9\u1dc0-\u1df9\u1dfb-\u1dff\u203f\u2040\u2054\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302f\u3099\u309a\ua620-\ua629\ua66f\ua674-\ua67d\ua69e\ua69f\ua6f0\ua6f1\ua802\ua806\ua80b\ua823-\ua827\ua880\ua881\ua8b4-\ua8c5\ua8d0-\ua8d9\ua8e0-\ua8f1\ua8ff-\ua909\ua926-\ua92d\ua947-\ua953\ua980-\ua983\ua9b3-\ua9c0\ua9d0-\ua9d9\ua9e5\ua9f0-\ua9f9\uaa29-\uaa36\uaa43\uaa4c\uaa4d\uaa50-\uaa59\uaa7b-\uaa7d\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uaaeb-\uaaef\uaaf5\uaaf6\uabe3-\uabea\uabec\uabed\uabf0-\uabf9\ufb1e\ufe00-\ufe0f\ufe20-\ufe2f\ufe33\ufe34\ufe4d-\ufe4f\uff10-\uff19\uff3f";

var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");

nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;

// These are a run-length and offset encoded representation of the
// >0xffff code points that are a valid part of identifiers. The
// offset starts at 0x10000, and each pair of numbers represents an
// offset to the next range, and then a size of the range. They were
// generated by bin/generate-identifier-regex.js

// eslint-disable-next-line comma-spacing
var astralIdentifierStartCodes = [0,11,2,25,2,18,2,1,2,14,3,13,35,122,70,52,268,28,4,48,48,31,14,29,6,37,11,29,3,35,5,7,2,4,43,157,19,35,5,35,5,39,9,51,157,310,10,21,11,7,153,5,3,0,2,43,2,1,4,0,3,22,11,22,10,30,66,18,2,1,11,21,11,25,71,55,7,1,65,0,16,3,2,2,2,28,43,28,4,28,36,7,2,27,28,53,11,21,11,18,14,17,111,72,56,50,14,50,14,35,477,28,11,0,9,21,190,52,76,44,33,24,27,35,30,0,12,34,4,0,13,47,15,3,22,0,2,0,36,17,2,24,85,6,2,0,2,3,2,14,2,9,8,46,39,7,3,1,3,21,2,6,2,1,2,4,4,0,19,0,13,4,159,52,19,3,54,47,21,1,2,0,185,46,42,3,37,47,21,0,60,42,86,26,230,43,117,63,32,0,257,0,11,39,8,0,22,0,12,39,3,3,20,0,35,56,264,8,2,36,18,0,50,29,113,6,2,1,2,37,22,0,26,5,2,1,2,31,15,0,328,18,270,921,103,110,18,195,2749,1070,4050,582,8634,568,8,30,114,29,19,47,17,3,32,20,6,18,689,63,129,68,12,0,67,12,65,1,31,6129,15,754,9486,286,82,395,2309,106,6,12,4,8,8,9,5991,84,2,70,2,1,3,0,3,1,3,3,2,11,2,0,2,6,2,64,2,3,3,7,2,6,2,27,2,3,2,4,2,0,4,6,2,339,3,24,2,24,2,30,2,24,2,30,2,24,2,30,2,24,2,30,2,24,2,7,4149,196,60,67,1213,3,2,26,2,1,2,0,3,0,2,9,2,3,2,0,2,0,7,0,5,0,2,0,2,0,2,2,2,1,2,0,3,0,2,0,2,0,2,0,2,0,2,1,2,0,3,3,2,6,2,3,2,3,2,0,2,9,2,16,6,2,2,4,2,16,4421,42710,42,4148,12,221,3,5761,15,7472,3104,541];

// eslint-disable-next-line comma-spacing
var astralIdentifierCodes = [509,0,227,0,150,4,294,9,1368,2,2,1,6,3,41,2,5,0,166,1,574,3,9,9,525,10,176,2,54,14,32,9,16,3,46,10,54,9,7,2,37,13,2,9,6,1,45,0,13,2,49,13,9,3,4,9,83,11,7,0,161,11,6,9,7,3,56,1,2,6,3,1,3,2,10,0,11,1,3,6,4,4,193,17,10,9,5,0,82,19,13,9,214,6,3,8,28,1,83,16,16,9,82,12,9,9,84,14,5,9,243,14,166,9,280,9,41,6,2,3,9,0,10,10,47,15,406,7,2,7,17,9,57,21,2,13,123,5,4,0,2,1,2,6,2,0,9,9,49,4,2,1,2,4,9,9,330,3,19306,9,135,4,60,6,26,9,1016,45,17,3,19723,1,5319,4,4,5,9,7,3,6,31,3,149,2,1418,49,513,54,5,49,9,0,15,0,23,4,2,14,1361,6,2,16,3,6,2,1,2,4,2214,6,110,6,6,9,792487,239];

// This has a complexity linear to the value of the code. The
// assumption is that looking up astral identifier characters is
// rare.
function isInAstralSet(code, set) {
  var pos = 0x10000;
  for (var i = 0; i < set.length; i += 2) {
    pos += set[i];
    if (pos > code) { return false }
    pos += set[i + 1];
    if (pos >= code) { return true }
  }
}

// Test whether a given character code starts an identifier.

function isIdentifierStart(code, astral) {
  if (code < 65) { return code === 36 }
  if (code < 91) { return true }
  if (code < 97) { return code === 95 }
  if (code < 123) { return true }
  if (code <= 0xffff) { return code >= 0xaa && nonASCIIidentifierStart.test(String.fromCharCode(code)) }
  if (astral === false) { return false }
  return isInAstralSet(code, astralIdentifierStartCodes)
}

// Test whether a given character is part of an identifier.

function isIdentifierChar(code, astral) {
  if (code < 48) { return code === 36 }
  if (code < 58) { return true }
  if (code < 65) { return false }
  if (code < 91) { return true }
  if (code < 97) { return code === 95 }
  if (code < 123) { return true }
  if (code <= 0xffff) { return code >= 0xaa && nonASCIIidentifier.test(String.fromCharCode(code)) }
  if (astral === false) { return false }
  return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes)
}

// ## Token types

// The assignment of fine-grained, information-carrying type objects
// allows the tokenizer to store the information it has about a
// token in a way that is very cheap for the parser to look up.

// All token type variables start with an underscore, to make them
// easy to recognize.

// The `beforeExpr` property is used to disambiguate between regular
// expressions and divisions. It is set on all token types that can
// be followed by an expression (thus, a slash after them would be a
// regular expression).
//
// The `startsExpr` property is used to check if the token ends a
// `yield` expression. It is set on all token types that either can
// directly start an expression (like a quotation mark) or can
// continue an expression (like the body of a string).
//
// `isLoop` marks a keyword as starting a loop, which is important
// to know when parsing a label, in order to allow or disallow
// continue jumps to that label.

var TokenType = function TokenType(label, conf) {
  if ( conf === void 0 ) conf = {};

  this.label = label;
  this.keyword = conf.keyword;
  this.beforeExpr = !!conf.beforeExpr;
  this.startsExpr = !!conf.startsExpr;
  this.isLoop = !!conf.isLoop;
  this.isAssign = !!conf.isAssign;
  this.prefix = !!conf.prefix;
  this.postfix = !!conf.postfix;
  this.binop = conf.binop || null;
  this.updateContext = null;
};

function binop(name, prec) {
  return new TokenType(name, {beforeExpr: true, binop: prec})
}
var beforeExpr = {beforeExpr: true};
var startsExpr = {startsExpr: true};

// Map keyword names to token types.

var keywords$1 = {};

// Succinct definitions of keyword token types
function kw(name, options) {
  if ( options === void 0 ) options = {};

  options.keyword = name;
  return keywords$1[name] = new TokenType(name, options)
}

var types = {
  num: new TokenType("num", startsExpr),
  regexp: new TokenType("regexp", startsExpr),
  string: new TokenType("string", startsExpr),
  name: new TokenType("name", startsExpr),
  eof: new TokenType("eof"),

  // Punctuation token types.
  bracketL: new TokenType("[", {beforeExpr: true, startsExpr: true}),
  bracketR: new TokenType("]"),
  braceL: new TokenType("{", {beforeExpr: true, startsExpr: true}),
  braceR: new TokenType("}"),
  parenL: new TokenType("(", {beforeExpr: true, startsExpr: true}),
  parenR: new TokenType(")"),
  comma: new TokenType(",", beforeExpr),
  semi: new TokenType(";", beforeExpr),
  colon: new TokenType(":", beforeExpr),
  dot: new TokenType("."),
  question: new TokenType("?", beforeExpr),
  arrow: new TokenType("=>", beforeExpr),
  template: new TokenType("template"),
  invalidTemplate: new TokenType("invalidTemplate"),
  ellipsis: new TokenType("...", beforeExpr),
  backQuote: new TokenType("`", startsExpr),
  dollarBraceL: new TokenType("${", {beforeExpr: true, startsExpr: true}),

  // Operators. These carry several kinds of properties to help the
  // parser use them properly (the presence of these properties is
  // what categorizes them as operators).
  //
  // `binop`, when present, specifies that this operator is a binary
  // operator, and will refer to its precedence.
  //
  // `prefix` and `postfix` mark the operator as a prefix or postfix
  // unary operator.
  //
  // `isAssign` marks all of `=`, `+=`, `-=` etcetera, which act as
  // binary operators with a very low precedence, that should result
  // in AssignmentExpression nodes.

  eq: new TokenType("=", {beforeExpr: true, isAssign: true}),
  assign: new TokenType("_=", {beforeExpr: true, isAssign: true}),
  incDec: new TokenType("++/--", {prefix: true, postfix: true, startsExpr: true}),
  prefix: new TokenType("!/~", {beforeExpr: true, prefix: true, startsExpr: true}),
  logicalOR: binop("||", 1),
  logicalAND: binop("&&", 2),
  bitwiseOR: binop("|", 3),
  bitwiseXOR: binop("^", 4),
  bitwiseAND: binop("&", 5),
  equality: binop("==/!=/===/!==", 6),
  relational: binop("</>/<=/>=", 7),
  bitShift: binop("<</>>/>>>", 8),
  plusMin: new TokenType("+/-", {beforeExpr: true, binop: 9, prefix: true, startsExpr: true}),
  modulo: binop("%", 10),
  star: binop("*", 10),
  slash: binop("/", 10),
  starstar: new TokenType("**", {beforeExpr: true}),

  // Keyword token types.
  _break: kw("break"),
  _case: kw("case", beforeExpr),
  _catch: kw("catch"),
  _continue: kw("continue"),
  _debugger: kw("debugger"),
  _default: kw("default", beforeExpr),
  _do: kw("do", {isLoop: true, beforeExpr: true}),
  _else: kw("else", beforeExpr),
  _finally: kw("finally"),
  _for: kw("for", {isLoop: true}),
  _function: kw("function", startsExpr),
  _if: kw("if"),
  _return: kw("return", beforeExpr),
  _switch: kw("switch"),
  _throw: kw("throw", beforeExpr),
  _try: kw("try"),
  _var: kw("var"),
  _const: kw("const"),
  _while: kw("while", {isLoop: true}),
  _with: kw("with"),
  _new: kw("new", {beforeExpr: true, startsExpr: true}),
  _this: kw("this", startsExpr),
  _super: kw("super", startsExpr),
  _class: kw("class", startsExpr),
  _extends: kw("extends", beforeExpr),
  _export: kw("export"),
  _import: kw("import"),
  _null: kw("null", startsExpr),
  _true: kw("true", startsExpr),
  _false: kw("false", startsExpr),
  _in: kw("in", {beforeExpr: true, binop: 7}),
  _instanceof: kw("instanceof", {beforeExpr: true, binop: 7}),
  _typeof: kw("typeof", {beforeExpr: true, prefix: true, startsExpr: true}),
  _void: kw("void", {beforeExpr: true, prefix: true, startsExpr: true}),
  _delete: kw("delete", {beforeExpr: true, prefix: true, startsExpr: true})
};

// Matches a whole line break (where CRLF is considered a single
// line break). Used to count lines.

var lineBreak = /\r\n?|\n|\u2028|\u2029/;
var lineBreakG = new RegExp(lineBreak.source, "g");

function isNewLine(code, ecma2019String) {
  return code === 10 || code === 13 || (!ecma2019String && (code === 0x2028 || code === 0x2029))
}

var nonASCIIwhitespace = /[\u1680\u180e\u2000-\u200a\u202f\u205f\u3000\ufeff]/;

var skipWhiteSpace = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g;

var ref = Object.prototype;
var hasOwnProperty = ref.hasOwnProperty;
var toString = ref.toString;

// Checks if an object has a property.

function has(obj, propName) {
  return hasOwnProperty.call(obj, propName)
}

var isArray = Array.isArray || (function (obj) { return (
  toString.call(obj) === "[object Array]"
); });

// These are used when `options.locations` is on, for the
// `startLoc` and `endLoc` properties.

var Position = function Position(line, col) {
  this.line = line;
  this.column = col;
};

Position.prototype.offset = function offset (n) {
  return new Position(this.line, this.column + n)
};

var SourceLocation = function SourceLocation(p, start, end) {
  this.start = start;
  this.end = end;
  if (p.sourceFile !== null) { this.source = p.sourceFile; }
};

// The `getLineInfo` function is mostly useful when the
// `locations` option is off (for performance reasons) and you
// want to find the line/column position for a given character
// offset. `input` should be the code string that the offset refers
// into.

function getLineInfo(input, offset) {
  for (var line = 1, cur = 0;;) {
    lineBreakG.lastIndex = cur;
    var match = lineBreakG.exec(input);
    if (match && match.index < offset) {
      ++line;
      cur = match.index + match[0].length;
    } else {
      return new Position(line, offset - cur)
    }
  }
}

// A second optional argument can be given to further configure
// the parser process. These options are recognized:

var defaultOptions = {
  // `ecmaVersion` indicates the ECMAScript version to parse. Must
  // be either 3, 5, 6 (2015), 7 (2016), or 8 (2017). This influences support
  // for strict mode, the set of reserved words, and support for
  // new syntax features. The default is 7.
  ecmaVersion: 7,
  // `sourceType` indicates the mode the code should be parsed in.
  // Can be either `"script"` or `"module"`. This influences global
  // strict mode and parsing of `import` and `export` declarations.
  sourceType: "script",
  // `onInsertedSemicolon` can be a callback that will be called
  // when a semicolon is automatically inserted. It will be passed
  // th position of the comma as an offset, and if `locations` is
  // enabled, it is given the location as a `{line, column}` object
  // as second argument.
  onInsertedSemicolon: null,
  // `onTrailingComma` is similar to `onInsertedSemicolon`, but for
  // trailing commas.
  onTrailingComma: null,
  // By default, reserved words are only enforced if ecmaVersion >= 5.
  // Set `allowReserved` to a boolean value to explicitly turn this on
  // an off. When this option has the value "never", reserved words
  // and keywords can also not be used as property names.
  allowReserved: null,
  // When enabled, a return at the top level is not considered an
  // error.
  allowReturnOutsideFunction: false,
  // When enabled, import/export statements are not constrained to
  // appearing at the top of the program.
  allowImportExportEverywhere: false,
  // When enabled, await identifiers are allowed to appear at the top-level scope,
  // but they are still not allowed in non-async functions.
  allowAwaitOutsideFunction: false,
  // When enabled, hashbang directive in the beginning of file
  // is allowed and treated as a line comment.
  allowHashBang: false,
  // When `locations` is on, `loc` properties holding objects with
  // `start` and `end` properties in `{line, column}` form (with
  // line being 1-based and column 0-based) will be attached to the
  // nodes.
  locations: false,
  // A function can be passed as `onToken` option, which will
  // cause Acorn to call that function with object in the same
  // format as tokens returned from `tokenizer().getToken()`. Note
  // that you are not allowed to call the parser from the
  // callback—that will corrupt its internal state.
  onToken: null,
  // A function can be passed as `onComment` option, which will
  // cause Acorn to call that function with `(block, text, start,
  // end)` parameters whenever a comment is skipped. `block` is a
  // boolean indicating whether this is a block (`/* */`) comment,
  // `text` is the content of the comment, and `start` and `end` are
  // character offsets that denote the start and end of the comment.
  // When the `locations` option is on, two more parameters are
  // passed, the full `{line, column}` locations of the start and
  // end of the comments. Note that you are not allowed to call the
  // parser from the callback—that will corrupt its internal state.
  onComment: null,
  // Nodes have their start and end characters offsets recorded in
  // `start` and `end` properties (directly on the node, rather than
  // the `loc` object, which holds line/column data. To also add a
  // [semi-standardized][range] `range` property holding a `[start,
  // end]` array with the same numbers, set the `ranges` option to
  // `true`.
  //
  // [range]: https://bugzilla.mozilla.org/show_bug.cgi?id=745678
  ranges: false,
  // It is possible to parse multiple files into a single AST by
  // passing the tree produced by parsing the first file as
  // `program` option in subsequent parses. This will add the
  // toplevel forms of the parsed file to the `Program` (top) node
  // of an existing parse tree.
  program: null,
  // When `locations` is on, you can pass this to record the source
  // file in every node's `loc` object.
  sourceFile: null,
  // This value, if given, is stored in every node, whether
  // `locations` is on or off.
  directSourceFile: null,
  // When enabled, parenthesized expressions are represented by
  // (non-standard) ParenthesizedExpression nodes
  preserveParens: false,
  plugins: {}
};

// Interpret and default an options object

function getOptions(opts) {
  var options = {};

  for (var opt in defaultOptions)
    { options[opt] = opts && has(opts, opt) ? opts[opt] : defaultOptions[opt]; }

  if (options.ecmaVersion >= 2015)
    { options.ecmaVersion -= 2009; }

  if (options.allowReserved == null)
    { options.allowReserved = options.ecmaVersion < 5; }

  if (isArray(options.onToken)) {
    var tokens = options.onToken;
    options.onToken = function (token) { return tokens.push(token); };
  }
  if (isArray(options.onComment))
    { options.onComment = pushComment(options, options.onComment); }

  return options
}

function pushComment(options, array) {
  return function(block, text, start, end, startLoc, endLoc) {
    var comment = {
      type: block ? "Block" : "Line",
      value: text,
      start: start,
      end: end
    };
    if (options.locations)
      { comment.loc = new SourceLocation(this, startLoc, endLoc); }
    if (options.ranges)
      { comment.range = [start, end]; }
    array.push(comment);
  }
}

// Registered plugins
var plugins = {};

function keywordRegexp(words) {
  return new RegExp("^(?:" + words.replace(/ /g, "|") + ")$")
}

var Parser = function Parser(options, input, startPos) {
  this.options = options = getOptions(options);
  this.sourceFile = options.sourceFile;
  this.keywords = keywordRegexp(keywords[options.ecmaVersion >= 6 ? 6 : 5]);
  var reserved = "";
  if (!options.allowReserved) {
    for (var v = options.ecmaVersion;; v--)
      { if (reserved = reservedWords[v]) { break } }
    if (options.sourceType === "module") { reserved += " await"; }
  }
  this.reservedWords = keywordRegexp(reserved);
  var reservedStrict = (reserved ? reserved + " " : "") + reservedWords.strict;
  this.reservedWordsStrict = keywordRegexp(reservedStrict);
  this.reservedWordsStrictBind = keywordRegexp(reservedStrict + " " + reservedWords.strictBind);
  this.input = String(input);

  // Used to signal to callers of `readWord1` whether the word
  // contained any escape sequences. This is needed because words with
  // escape sequences must not be interpreted as keywords.
  this.containsEsc = false;

  // Load plugins
  this.loadPlugins(options.plugins);

  // Set up token state

  // The current position of the tokenizer in the input.
  if (startPos) {
    this.pos = startPos;
    this.lineStart = this.input.lastIndexOf("\n", startPos - 1) + 1;
    this.curLine = this.input.slice(0, this.lineStart).split(lineBreak).length;
  } else {
    this.pos = this.lineStart = 0;
    this.curLine = 1;
  }

  // Properties of the current token:
  // Its type
  this.type = types.eof;
  // For tokens that include more information than their type, the value
  this.value = null;
  // Its start and end offset
  this.start = this.end = this.pos;
  // And, if locations are used, the {line, column} object
  // corresponding to those offsets
  this.startLoc = this.endLoc = this.curPosition();

  // Position information for the previous token
  this.lastTokEndLoc = this.lastTokStartLoc = null;
  this.lastTokStart = this.lastTokEnd = this.pos;

  // The context stack is used to superficially track syntactic
  // context to predict whether a regular expression is allowed in a
  // given position.
  this.context = this.initialContext();
  this.exprAllowed = true;

  // Figure out if it's a module code.
  this.inModule = options.sourceType === "module";
  this.strict = this.inModule || this.strictDirective(this.pos);

  // Used to signify the start of a potential arrow function
  this.potentialArrowAt = -1;

  // Flags to track whether we are in a function, a generator, an async function.
  this.inFunction = this.inGenerator = this.inAsync = false;
  // Positions to delayed-check that yield/await does not exist in default parameters.
  this.yieldPos = this.awaitPos = 0;
  // Labels in scope.
  this.labels = [];

  // If enabled, skip leading hashbang line.
  if (this.pos === 0 && options.allowHashBang && this.input.slice(0, 2) === "#!")
    { this.skipLineComment(2); }

  // Scope tracking for duplicate variable names (see scope.js)
  this.scopeStack = [];
  this.enterFunctionScope();

  // For RegExp validation
  this.regexpState = null;
};

// DEPRECATED Kept for backwards compatibility until 3.0 in case a plugin uses them
Parser.prototype.isKeyword = function isKeyword (word) { return this.keywords.test(word) };
Parser.prototype.isReservedWord = function isReservedWord (word) { return this.reservedWords.test(word) };

Parser.prototype.extend = function extend (name, f) {
  this[name] = f(this[name]);
};

Parser.prototype.loadPlugins = function loadPlugins (pluginConfigs) {
    var this$1 = this;

  for (var name in pluginConfigs) {
    var plugin = plugins[name];
    if (!plugin) { throw new Error("Plugin '" + name + "' not found") }
    plugin(this$1, pluginConfigs[name]);
  }
};

Parser.prototype.parse = function parse () {
  var node = this.options.program || this.startNode();
  this.nextToken();
  return this.parseTopLevel(node)
};

var pp = Parser.prototype;

// ## Parser utilities

var literal = /^(?:'((?:\\.|[^'])*?)'|"((?:\\.|[^"])*?)"|;)/;
pp.strictDirective = function(start) {
  var this$1 = this;

  for (;;) {
    skipWhiteSpace.lastIndex = start;
    start += skipWhiteSpace.exec(this$1.input)[0].length;
    var match = literal.exec(this$1.input.slice(start));
    if (!match) { return false }
    if ((match[1] || match[2]) === "use strict") { return true }
    start += match[0].length;
  }
};

// Predicate that tests whether the next token is of the given
// type, and if yes, consumes it as a side effect.

pp.eat = function(type) {
  if (this.type === type) {
    this.next();
    return true
  } else {
    return false
  }
};

// Tests whether parsed token is a contextual keyword.

pp.isContextual = function(name) {
  return this.type === types.name && this.value === name && !this.containsEsc
};

// Consumes contextual keyword if possible.

pp.eatContextual = function(name) {
  if (!this.isContextual(name)) { return false }
  this.next();
  return true
};

// Asserts that following token is given contextual keyword.

pp.expectContextual = function(name) {
  if (!this.eatContextual(name)) { this.unexpected(); }
};

// Test whether a semicolon can be inserted at the current position.

pp.canInsertSemicolon = function() {
  return this.type === types.eof ||
    this.type === types.braceR ||
    lineBreak.test(this.input.slice(this.lastTokEnd, this.start))
};

pp.insertSemicolon = function() {
  if (this.canInsertSemicolon()) {
    if (this.options.onInsertedSemicolon)
      { this.options.onInsertedSemicolon(this.lastTokEnd, this.lastTokEndLoc); }
    return true
  }
};

// Consume a semicolon, or, failing that, see if we are allowed to
// pretend that there is a semicolon at this position.

pp.semicolon = function() {
  if (!this.eat(types.semi) && !this.insertSemicolon()) { this.unexpected(); }
};

pp.afterTrailingComma = function(tokType, notNext) {
  if (this.type === tokType) {
    if (this.options.onTrailingComma)
      { this.options.onTrailingComma(this.lastTokStart, this.lastTokStartLoc); }
    if (!notNext)
      { this.next(); }
    return true
  }
};

// Expect a token of a given type. If found, consume it, otherwise,
// raise an unexpected token error.

pp.expect = function(type) {
  this.eat(type) || this.unexpected();
};

// Raise an unexpected token error.

pp.unexpected = function(pos) {
  this.raise(pos != null ? pos : this.start, "Unexpected token");
};

function DestructuringErrors() {
  this.shorthandAssign =
  this.trailingComma =
  this.parenthesizedAssign =
  this.parenthesizedBind =
  this.doubleProto =
    -1;
}

pp.checkPatternErrors = function(refDestructuringErrors, isAssign) {
  if (!refDestructuringErrors) { return }
  if (refDestructuringErrors.trailingComma > -1)
    { this.raiseRecoverable(refDestructuringErrors.trailingComma, "Comma is not permitted after the rest element"); }
  var parens = isAssign ? refDestructuringErrors.parenthesizedAssign : refDestructuringErrors.parenthesizedBind;
  if (parens > -1) { this.raiseRecoverable(parens, "Parenthesized pattern"); }
};

pp.checkExpressionErrors = function(refDestructuringErrors, andThrow) {
  if (!refDestructuringErrors) { return false }
  var shorthandAssign = refDestructuringErrors.shorthandAssign;
  var doubleProto = refDestructuringErrors.doubleProto;
  if (!andThrow) { return shorthandAssign >= 0 || doubleProto >= 0 }
  if (shorthandAssign >= 0)
    { this.raise(shorthandAssign, "Shorthand property assignments are valid only in destructuring patterns"); }
  if (doubleProto >= 0)
    { this.raiseRecoverable(doubleProto, "Redefinition of __proto__ property"); }
};

pp.checkYieldAwaitInDefaultParams = function() {
  if (this.yieldPos && (!this.awaitPos || this.yieldPos < this.awaitPos))
    { this.raise(this.yieldPos, "Yield expression cannot be a default value"); }
  if (this.awaitPos)
    { this.raise(this.awaitPos, "Await expression cannot be a default value"); }
};

pp.isSimpleAssignTarget = function(expr) {
  if (expr.type === "ParenthesizedExpression")
    { return this.isSimpleAssignTarget(expr.expression) }
  return expr.type === "Identifier" || expr.type === "MemberExpression"
};

var pp$1 = Parser.prototype;

// ### Statement parsing

// Parse a program. Initializes the parser, reads any number of
// statements, and wraps them in a Program node.  Optionally takes a
// `program` argument.  If present, the statements will be appended
// to its body instead of creating a new node.

pp$1.parseTopLevel = function(node) {
  var this$1 = this;

  var exports = {};
  if (!node.body) { node.body = []; }
  while (this.type !== types.eof) {
    var stmt = this$1.parseStatement(true, true, exports);
    node.body.push(stmt);
  }
  this.adaptDirectivePrologue(node.body);
  this.next();
  if (this.options.ecmaVersion >= 6) {
    node.sourceType = this.options.sourceType;
  }
  return this.finishNode(node, "Program")
};

var loopLabel = {kind: "loop"};
var switchLabel = {kind: "switch"};

pp$1.isLet = function() {
  if (this.options.ecmaVersion < 6 || !this.isContextual("let")) { return false }
  skipWhiteSpace.lastIndex = this.pos;
  var skip = skipWhiteSpace.exec(this.input);
  var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
  if (nextCh === 91 || nextCh === 123) { return true } // '{' and '['
  if (isIdentifierStart(nextCh, true)) {
    var pos = next + 1;
    while (isIdentifierChar(this.input.charCodeAt(pos), true)) { ++pos; }
    var ident = this.input.slice(next, pos);
    if (!keywordRelationalOperator.test(ident)) { return true }
  }
  return false
};

// check 'async [no LineTerminator here] function'
// - 'async /*foo*/ function' is OK.
// - 'async /*\n*/ function' is invalid.
pp$1.isAsyncFunction = function() {
  if (this.options.ecmaVersion < 8 || !this.isContextual("async"))
    { return false }

  skipWhiteSpace.lastIndex = this.pos;
  var skip = skipWhiteSpace.exec(this.input);
  var next = this.pos + skip[0].length;
  return !lineBreak.test(this.input.slice(this.pos, next)) &&
    this.input.slice(next, next + 8) === "function" &&
    (next + 8 === this.input.length || !isIdentifierChar(this.input.charAt(next + 8)))
};

// Parse a single statement.
//
// If expecting a statement and finding a slash operator, parse a
// regular expression literal. This is to handle cases like
// `if (foo) /blah/.exec(foo)`, where looking at the previous token
// does not help.

pp$1.parseStatement = function(declaration, topLevel, exports) {
  var starttype = this.type, node = this.startNode(), kind;

  if (this.isLet()) {
    starttype = types._var;
    kind = "let";
  }

  // Most types of statements are recognized by the keyword they
  // start with. Many are trivial to parse, some require a bit of
  // complexity.

  switch (starttype) {
  case types._break: case types._continue: return this.parseBreakContinueStatement(node, starttype.keyword)
  case types._debugger: return this.parseDebuggerStatement(node)
  case types._do: return this.parseDoStatement(node)
  case types._for: return this.parseForStatement(node)
  case types._function:
    if (!declaration && this.options.ecmaVersion >= 6) { this.unexpected(); }
    return this.parseFunctionStatement(node, false)
  case types._class:
    if (!declaration) { this.unexpected(); }
    return this.parseClass(node, true)
  case types._if: return this.parseIfStatement(node)
  case types._return: return this.parseReturnStatement(node)
  case types._switch: return this.parseSwitchStatement(node)
  case types._throw: return this.parseThrowStatement(node)
  case types._try: return this.parseTryStatement(node)
  case types._const: case types._var:
    kind = kind || this.value;
    if (!declaration && kind !== "var") { this.unexpected(); }
    return this.parseVarStatement(node, kind)
  case types._while: return this.parseWhileStatement(node)
  case types._with: return this.parseWithStatement(node)
  case types.braceL: return this.parseBlock()
  case types.semi: return this.parseEmptyStatement(node)
  case types._export:
  case types._import:
    if (!this.options.allowImportExportEverywhere) {
      if (!topLevel)
        { this.raise(this.start, "'import' and 'export' may only appear at the top level"); }
      if (!this.inModule)
        { this.raise(this.start, "'import' and 'export' may appear only with 'sourceType: module'"); }
    }
    return starttype === types._import ? this.parseImport(node) : this.parseExport(node, exports)

    // If the statement does not start with a statement keyword or a
    // brace, it's an ExpressionStatement or LabeledStatement. We
    // simply start parsing an expression, and afterwards, if the
    // next token is a colon and the expression was a simple
    // Identifier node, we switch to interpreting it as a label.
  default:
    if (this.isAsyncFunction()) {
      if (!declaration) { this.unexpected(); }
      this.next();
      return this.parseFunctionStatement(node, true)
    }

    var maybeName = this.value, expr = this.parseExpression();
    if (starttype === types.name && expr.type === "Identifier" && this.eat(types.colon))
      { return this.parseLabeledStatement(node, maybeName, expr) }
    else { return this.parseExpressionStatement(node, expr) }
  }
};

pp$1.parseBreakContinueStatement = function(node, keyword) {
  var this$1 = this;

  var isBreak = keyword === "break";
  this.next();
  if (this.eat(types.semi) || this.insertSemicolon()) { node.label = null; }
  else if (this.type !== types.name) { this.unexpected(); }
  else {
    node.label = this.parseIdent();
    this.semicolon();
  }

  // Verify that there is an actual destination to break or
  // continue to.
  var i = 0;
  for (; i < this.labels.length; ++i) {
    var lab = this$1.labels[i];
    if (node.label == null || lab.name === node.label.name) {
      if (lab.kind != null && (isBreak || lab.kind === "loop")) { break }
      if (node.label && isBreak) { break }
    }
  }
  if (i === this.labels.length) { this.raise(node.start, "Unsyntactic " + keyword); }
  return this.finishNode(node, isBreak ? "BreakStatement" : "ContinueStatement")
};

pp$1.parseDebuggerStatement = function(node) {
  this.next();
  this.semicolon();
  return this.finishNode(node, "DebuggerStatement")
};

pp$1.parseDoStatement = function(node) {
  this.next();
  this.labels.push(loopLabel);
  node.body = this.parseStatement(false);
  this.labels.pop();
  this.expect(types._while);
  node.test = this.parseParenExpression();
  if (this.options.ecmaVersion >= 6)
    { this.eat(types.semi); }
  else
    { this.semicolon(); }
  return this.finishNode(node, "DoWhileStatement")
};

// Disambiguating between a `for` and a `for`/`in` or `for`/`of`
// loop is non-trivial. Basically, we have to parse the init `var`
// statement or expression, disallowing the `in` operator (see
// the second parameter to `parseExpression`), and then check
// whether the next token is `in` or `of`. When there is no init
// part (semicolon immediately after the opening parenthesis), it
// is a regular `for` loop.

pp$1.parseForStatement = function(node) {
  this.next();
  var awaitAt = (this.options.ecmaVersion >= 9 && (this.inAsync || (!this.inFunction && this.options.allowAwaitOutsideFunction)) && this.eatContextual("await")) ? this.lastTokStart : -1;
  this.labels.push(loopLabel);
  this.enterLexicalScope();
  this.expect(types.parenL);
  if (this.type === types.semi) {
    if (awaitAt > -1) { this.unexpected(awaitAt); }
    return this.parseFor(node, null)
  }
  var isLet = this.isLet();
  if (this.type === types._var || this.type === types._const || isLet) {
    var init$1 = this.startNode(), kind = isLet ? "let" : this.value;
    this.next();
    this.parseVar(init$1, true, kind);
    this.finishNode(init$1, "VariableDeclaration");
    if ((this.type === types._in || (this.options.ecmaVersion >= 6 && this.isContextual("of"))) && init$1.declarations.length === 1 &&
        !(kind !== "var" && init$1.declarations[0].init)) {
      if (this.options.ecmaVersion >= 9) {
        if (this.type === types._in) {
          if (awaitAt > -1) { this.unexpected(awaitAt); }
        } else { node.await = awaitAt > -1; }
      }
      return this.parseForIn(node, init$1)
    }
    if (awaitAt > -1) { this.unexpected(awaitAt); }
    return this.parseFor(node, init$1)
  }
  var refDestructuringErrors = new DestructuringErrors;
  var init = this.parseExpression(true, refDestructuringErrors);
  if (this.type === types._in || (this.options.ecmaVersion >= 6 && this.isContextual("of"))) {
    if (this.options.ecmaVersion >= 9) {
      if (this.type === types._in) {
        if (awaitAt > -1) { this.unexpected(awaitAt); }
      } else { node.await = awaitAt > -1; }
    }
    this.toAssignable(init, false, refDestructuringErrors);
    this.checkLVal(init);
    return this.parseForIn(node, init)
  } else {
    this.checkExpressionErrors(refDestructuringErrors, true);
  }
  if (awaitAt > -1) { this.unexpected(awaitAt); }
  return this.parseFor(node, init)
};

pp$1.parseFunctionStatement = function(node, isAsync) {
  this.next();
  return this.parseFunction(node, true, false, isAsync)
};

pp$1.parseIfStatement = function(node) {
  this.next();
  node.test = this.parseParenExpression();
  // allow function declarations in branches, but only in non-strict mode
  node.consequent = this.parseStatement(!this.strict && this.type === types._function);
  node.alternate = this.eat(types._else) ? this.parseStatement(!this.strict && this.type === types._function) : null;
  return this.finishNode(node, "IfStatement")
};

pp$1.parseReturnStatement = function(node) {
  if (!this.inFunction && !this.options.allowReturnOutsideFunction)
    { this.raise(this.start, "'return' outside of function"); }
  this.next();

  // In `return` (and `break`/`continue`), the keywords with
  // optional arguments, we eagerly look for a semicolon or the
  // possibility to insert one.

  if (this.eat(types.semi) || this.insertSemicolon()) { node.argument = null; }
  else { node.argument = this.parseExpression(); this.semicolon(); }
  return this.finishNode(node, "ReturnStatement")
};

pp$1.parseSwitchStatement = function(node) {
  var this$1 = this;

  this.next();
  node.discriminant = this.parseParenExpression();
  node.cases = [];
  this.expect(types.braceL);
  this.labels.push(switchLabel);
  this.enterLexicalScope();

  // Statements under must be grouped (by label) in SwitchCase
  // nodes. `cur` is used to keep the node that we are currently
  // adding statements to.

  var cur;
  for (var sawDefault = false; this.type !== types.braceR;) {
    if (this$1.type === types._case || this$1.type === types._default) {
      var isCase = this$1.type === types._case;
      if (cur) { this$1.finishNode(cur, "SwitchCase"); }
      node.cases.push(cur = this$1.startNode());
      cur.consequent = [];
      this$1.next();
      if (isCase) {
        cur.test = this$1.parseExpression();
      } else {
        if (sawDefault) { this$1.raiseRecoverable(this$1.lastTokStart, "Multiple default clauses"); }
        sawDefault = true;
        cur.test = null;
      }
      this$1.expect(types.colon);
    } else {
      if (!cur) { this$1.unexpected(); }
      cur.consequent.push(this$1.parseStatement(true));
    }
  }
  this.exitLexicalScope();
  if (cur) { this.finishNode(cur, "SwitchCase"); }
  this.next(); // Closing brace
  this.labels.pop();
  return this.finishNode(node, "SwitchStatement")
};

pp$1.parseThrowStatement = function(node) {
  this.next();
  if (lineBreak.test(this.input.slice(this.lastTokEnd, this.start)))
    { this.raise(this.lastTokEnd, "Illegal newline after throw"); }
  node.argument = this.parseExpression();
  this.semicolon();
  return this.finishNode(node, "ThrowStatement")
};

// Reused empty array added for node fields that are always empty.

var empty = [];

pp$1.parseTryStatement = function(node) {
  this.next();
  node.block = this.parseBlock();
  node.handler = null;
  if (this.type === types._catch) {
    var clause = this.startNode();
    this.next();
    if (this.eat(types.parenL)) {
      clause.param = this.parseBindingAtom();
      this.enterLexicalScope();
      this.checkLVal(clause.param, "let");
      this.expect(types.parenR);
    } else {
      if (this.options.ecmaVersion < 10) { this.unexpected(); }
      clause.param = null;
      this.enterLexicalScope();
    }
    clause.body = this.parseBlock(false);
    this.exitLexicalScope();
    node.handler = this.finishNode(clause, "CatchClause");
  }
  node.finalizer = this.eat(types._finally) ? this.parseBlock() : null;
  if (!node.handler && !node.finalizer)
    { this.raise(node.start, "Missing catch or finally clause"); }
  return this.finishNode(node, "TryStatement")
};

pp$1.parseVarStatement = function(node, kind) {
  this.next();
  this.parseVar(node, false, kind);
  this.semicolon();
  return this.finishNode(node, "VariableDeclaration")
};

pp$1.parseWhileStatement = function(node) {
  this.next();
  node.test = this.parseParenExpression();
  this.labels.push(loopLabel);
  node.body = this.parseStatement(false);
  this.labels.pop();
  return this.finishNode(node, "WhileStatement")
};

pp$1.parseWithStatement = function(node) {
  if (this.strict) { this.raise(this.start, "'with' in strict mode"); }
  this.next();
  node.object = this.parseParenExpression();
  node.body = this.parseStatement(false);
  return this.finishNode(node, "WithStatement")
};

pp$1.parseEmptyStatement = function(node) {
  this.next();
  return this.finishNode(node, "EmptyStatement")
};

pp$1.parseLabeledStatement = function(node, maybeName, expr) {
  var this$1 = this;

  for (var i$1 = 0, list = this$1.labels; i$1 < list.length; i$1 += 1)
    {
    var label = list[i$1];

    if (label.name === maybeName)
      { this$1.raise(expr.start, "Label '" + maybeName + "' is already declared");
  } }
  var kind = this.type.isLoop ? "loop" : this.type === types._switch ? "switch" : null;
  for (var i = this.labels.length - 1; i >= 0; i--) {
    var label$1 = this$1.labels[i];
    if (label$1.statementStart === node.start) {
      // Update information about previous labels on this node
      label$1.statementStart = this$1.start;
      label$1.kind = kind;
    } else { break }
  }
  this.labels.push({name: maybeName, kind: kind, statementStart: this.start});
  node.body = this.parseStatement(true);
  if (node.body.type === "ClassDeclaration" ||
      node.body.type === "VariableDeclaration" && node.body.kind !== "var" ||
      node.body.type === "FunctionDeclaration" && (this.strict || node.body.generator || node.body.async))
    { this.raiseRecoverable(node.body.start, "Invalid labeled declaration"); }
  this.labels.pop();
  node.label = expr;
  return this.finishNode(node, "LabeledStatement")
};

pp$1.parseExpressionStatement = function(node, expr) {
  node.expression = expr;
  this.semicolon();
  return this.finishNode(node, "ExpressionStatement")
};

// Parse a semicolon-enclosed block of statements, handling `"use
// strict"` declarations when `allowStrict` is true (used for
// function bodies).

pp$1.parseBlock = function(createNewLexicalScope) {
  var this$1 = this;
  if ( createNewLexicalScope === void 0 ) createNewLexicalScope = true;

  var node = this.startNode();
  node.body = [];
  this.expect(types.braceL);
  if (createNewLexicalScope) {
    this.enterLexicalScope();
  }
  while (!this.eat(types.braceR)) {
    var stmt = this$1.parseStatement(true);
    node.body.push(stmt);
  }
  if (createNewLexicalScope) {
    this.exitLexicalScope();
  }
  return this.finishNode(node, "BlockStatement")
};

// Parse a regular `for` loop. The disambiguation code in
// `parseStatement` will already have parsed the init statement or
// expression.

pp$1.parseFor = function(node, init) {
  node.init = init;
  this.expect(types.semi);
  node.test = this.type === types.semi ? null : this.parseExpression();
  this.expect(types.semi);
  node.update = this.type === types.parenR ? null : this.parseExpression();
  this.expect(types.parenR);
  this.exitLexicalScope();
  node.body = this.parseStatement(false);
  this.labels.pop();
  return this.finishNode(node, "ForStatement")
};

// Parse a `for`/`in` and `for`/`of` loop, which are almost
// same from parser's perspective.

pp$1.parseForIn = function(node, init) {
  var type = this.type === types._in ? "ForInStatement" : "ForOfStatement";
  this.next();
  if (type === "ForInStatement") {
    if (init.type === "AssignmentPattern" ||
      (init.type === "VariableDeclaration" && init.declarations[0].init != null &&
       (this.strict || init.declarations[0].id.type !== "Identifier")))
      { this.raise(init.start, "Invalid assignment in for-in loop head"); }
  }
  node.left = init;
  node.right = type === "ForInStatement" ? this.parseExpression() : this.parseMaybeAssign();
  this.expect(types.parenR);
  this.exitLexicalScope();
  node.body = this.parseStatement(false);
  this.labels.pop();
  return this.finishNode(node, type)
};

// Parse a list of variable declarations.

pp$1.parseVar = function(node, isFor, kind) {
  var this$1 = this;

  node.declarations = [];
  node.kind = kind;
  for (;;) {
    var decl = this$1.startNode();
    this$1.parseVarId(decl, kind);
    if (this$1.eat(types.eq)) {
      decl.init = this$1.parseMaybeAssign(isFor);
    } else if (kind === "const" && !(this$1.type === types._in || (this$1.options.ecmaVersion >= 6 && this$1.isContextual("of")))) {
      this$1.unexpected();
    } else if (decl.id.type !== "Identifier" && !(isFor && (this$1.type === types._in || this$1.isContextual("of")))) {
      this$1.raise(this$1.lastTokEnd, "Complex binding patterns require an initialization value");
    } else {
      decl.init = null;
    }
    node.declarations.push(this$1.finishNode(decl, "VariableDeclarator"));
    if (!this$1.eat(types.comma)) { break }
  }
  return node
};

pp$1.parseVarId = function(decl, kind) {
  decl.id = this.parseBindingAtom(kind);
  this.checkLVal(decl.id, kind, false);
};

// Parse a function declaration or literal (depending on the
// `isStatement` parameter).

pp$1.parseFunction = function(node, isStatement, allowExpressionBody, isAsync) {
  this.initFunction(node);
  if (this.options.ecmaVersion >= 9 || this.options.ecmaVersion >= 6 && !isAsync)
    { node.generator = this.eat(types.star); }
  if (this.options.ecmaVersion >= 8)
    { node.async = !!isAsync; }

  if (isStatement) {
    node.id = isStatement === "nullableID" && this.type !== types.name ? null : this.parseIdent();
    if (node.id) {
      this.checkLVal(node.id, this.inModule && !this.inFunction ? "let" : "var");
    }
  }

  var oldInGen = this.inGenerator, oldInAsync = this.inAsync,
      oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldInFunc = this.inFunction;
  this.inGenerator = node.generator;
  this.inAsync = node.async;
  this.yieldPos = 0;
  this.awaitPos = 0;
  this.inFunction = true;
  this.enterFunctionScope();

  if (!isStatement)
    { node.id = this.type === types.name ? this.parseIdent() : null; }

  this.parseFunctionParams(node);
  this.parseFunctionBody(node, allowExpressionBody);

  this.inGenerator = oldInGen;
  this.inAsync = oldInAsync;
  this.yieldPos = oldYieldPos;
  this.awaitPos = oldAwaitPos;
  this.inFunction = oldInFunc;
  return this.finishNode(node, isStatement ? "FunctionDeclaration" : "FunctionExpression")
};

pp$1.parseFunctionParams = function(node) {
  this.expect(types.parenL);
  node.params = this.parseBindingList(types.parenR, false, this.options.ecmaVersion >= 8);
  this.checkYieldAwaitInDefaultParams();
};

// Parse a class declaration or literal (depending on the
// `isStatement` parameter).

pp$1.parseClass = function(node, isStatement) {
  var this$1 = this;

  this.next();

  this.parseClassId(node, isStatement);
  this.parseClassSuper(node);
  var classBody = this.startNode();
  var hadConstructor = false;
  classBody.body = [];
  this.expect(types.braceL);
  while (!this.eat(types.braceR)) {
    var member = this$1.parseClassMember(classBody);
    if (member && member.type === "MethodDefinition" && member.kind === "constructor") {
      if (hadConstructor) { this$1.raise(member.start, "Duplicate constructor in the same class"); }
      hadConstructor = true;
    }
  }
  node.body = this.finishNode(classBody, "ClassBody");
  return this.finishNode(node, isStatement ? "ClassDeclaration" : "ClassExpression")
};

pp$1.parseClassMember = function(classBody) {
  var this$1 = this;

  if (this.eat(types.semi)) { return null }

  var method = this.startNode();
  var tryContextual = function (k, noLineBreak) {
    if ( noLineBreak === void 0 ) noLineBreak = false;

    var start = this$1.start, startLoc = this$1.startLoc;
    if (!this$1.eatContextual(k)) { return false }
    if (this$1.type !== types.parenL && (!noLineBreak || !this$1.canInsertSemicolon())) { return true }
    if (method.key) { this$1.unexpected(); }
    method.computed = false;
    method.key = this$1.startNodeAt(start, startLoc);
    method.key.name = k;
    this$1.finishNode(method.key, "Identifier");
    return false
  };

  method.kind = "method";
  method.static = tryContextual("static");
  var isGenerator = this.eat(types.star);
  var isAsync = false;
  if (!isGenerator) {
    if (this.options.ecmaVersion >= 8 && tryContextual("async", true)) {
      isAsync = true;
      isGenerator = this.options.ecmaVersion >= 9 && this.eat(types.star);
    } else if (tryContextual("get")) {
      method.kind = "get";
    } else if (tryContextual("set")) {
      method.kind = "set";
    }
  }
  if (!method.key) { this.parsePropertyName(method); }
  var key = method.key;
  if (!method.computed && !method.static && (key.type === "Identifier" && key.name === "constructor" ||
      key.type === "Literal" && key.value === "constructor")) {
    if (method.kind !== "method") { this.raise(key.start, "Constructor can't have get/set modifier"); }
    if (isGenerator) { this.raise(key.start, "Constructor can't be a generator"); }
    if (isAsync) { this.raise(key.start, "Constructor can't be an async method"); }
    method.kind = "constructor";
  } else if (method.static && key.type === "Identifier" && key.name === "prototype") {
    this.raise(key.start, "Classes may not have a static property named prototype");
  }
  this.parseClassMethod(classBody, method, isGenerator, isAsync);
  if (method.kind === "get" && method.value.params.length !== 0)
    { this.raiseRecoverable(method.value.start, "getter should have no params"); }
  if (method.kind === "set" && method.value.params.length !== 1)
    { this.raiseRecoverable(method.value.start, "setter should have exactly one param"); }
  if (method.kind === "set" && method.value.params[0].type === "RestElement")
    { this.raiseRecoverable(method.value.params[0].start, "Setter cannot use rest params"); }
  return method
};

pp$1.parseClassMethod = function(classBody, method, isGenerator, isAsync) {
  method.value = this.parseMethod(isGenerator, isAsync);
  classBody.body.push(this.finishNode(method, "MethodDefinition"));
};

pp$1.parseClassId = function(node, isStatement) {
  node.id = this.type === types.name ? this.parseIdent() : isStatement === true ? this.unexpected() : null;
};

pp$1.parseClassSuper = function(node) {
  node.superClass = this.eat(types._extends) ? this.parseExprSubscripts() : null;
};

// Parses module export declaration.

pp$1.parseExport = function(node, exports) {
  var this$1 = this;

  this.next();
  // export * from '...'
  if (this.eat(types.star)) {
    this.expectContextual("from");
    if (this.type !== types.string) { this.unexpected(); }
    node.source = this.parseExprAtom();
    this.semicolon();
    return this.finishNode(node, "ExportAllDeclaration")
  }
  if (this.eat(types._default)) { // export default ...
    this.checkExport(exports, "default", this.lastTokStart);
    var isAsync;
    if (this.type === types._function || (isAsync = this.isAsyncFunction())) {
      var fNode = this.startNode();
      this.next();
      if (isAsync) { this.next(); }
      node.declaration = this.parseFunction(fNode, "nullableID", false, isAsync);
    } else if (this.type === types._class) {
      var cNode = this.startNode();
      node.declaration = this.parseClass(cNode, "nullableID");
    } else {
      node.declaration = this.parseMaybeAssign();
      this.semicolon();
    }
    return this.finishNode(node, "ExportDefaultDeclaration")
  }
  // export var|const|let|function|class ...
  if (this.shouldParseExportStatement()) {
    node.declaration = this.parseStatement(true);
    if (node.declaration.type === "VariableDeclaration")
      { this.checkVariableExport(exports, node.declaration.declarations); }
    else
      { this.checkExport(exports, node.declaration.id.name, node.declaration.id.start); }
    node.specifiers = [];
    node.source = null;
  } else { // export { x, y as z } [from '...']
    node.declaration = null;
    node.specifiers = this.parseExportSpecifiers(exports);
    if (this.eatContextual("from")) {
      if (this.type !== types.string) { this.unexpected(); }
      node.source = this.parseExprAtom();
    } else {
      // check for keywords used as local names
      for (var i = 0, list = node.specifiers; i < list.length; i += 1) {
        var spec = list[i];

        this$1.checkUnreserved(spec.local);
      }

      node.source = null;
    }
    this.semicolon();
  }
  return this.finishNode(node, "ExportNamedDeclaration")
};

pp$1.checkExport = function(exports, name, pos) {
  if (!exports) { return }
  if (has(exports, name))
    { this.raiseRecoverable(pos, "Duplicate export '" + name + "'"); }
  exports[name] = true;
};

pp$1.checkPatternExport = function(exports, pat) {
  var this$1 = this;

  var type = pat.type;
  if (type === "Identifier")
    { this.checkExport(exports, pat.name, pat.start); }
  else if (type === "ObjectPattern")
    { for (var i = 0, list = pat.properties; i < list.length; i += 1)
      {
        var prop = list[i];

        this$1.checkPatternExport(exports, prop);
      } }
  else if (type === "ArrayPattern")
    { for (var i$1 = 0, list$1 = pat.elements; i$1 < list$1.length; i$1 += 1) {
      var elt = list$1[i$1];

        if (elt) { this$1.checkPatternExport(exports, elt); }
    } }
  else if (type === "Property")
    { this.checkPatternExport(exports, pat.value); }
  else if (type === "AssignmentPattern")
    { this.checkPatternExport(exports, pat.left); }
  else if (type === "RestElement")
    { this.checkPatternExport(exports, pat.argument); }
  else if (type === "ParenthesizedExpression")
    { this.checkPatternExport(exports, pat.expression); }
};

pp$1.checkVariableExport = function(exports, decls) {
  var this$1 = this;

  if (!exports) { return }
  for (var i = 0, list = decls; i < list.length; i += 1)
    {
    var decl = list[i];

    this$1.checkPatternExport(exports, decl.id);
  }
};

pp$1.shouldParseExportStatement = function() {
  return this.type.keyword === "var" ||
    this.type.keyword === "const" ||
    this.type.keyword === "class" ||
    this.type.keyword === "function" ||
    this.isLet() ||
    this.isAsyncFunction()
};

// Parses a comma-separated list of module exports.

pp$1.parseExportSpecifiers = function(exports) {
  var this$1 = this;

  var nodes = [], first = true;
  // export { x, y as z } [from '...']
  this.expect(types.braceL);
  while (!this.eat(types.braceR)) {
    if (!first) {
      this$1.expect(types.comma);
      if (this$1.afterTrailingComma(types.braceR)) { break }
    } else { first = false; }

    var node = this$1.startNode();
    node.local = this$1.parseIdent(true);
    node.exported = this$1.eatContextual("as") ? this$1.parseIdent(true) : node.local;
    this$1.checkExport(exports, node.exported.name, node.exported.start);
    nodes.push(this$1.finishNode(node, "ExportSpecifier"));
  }
  return nodes
};

// Parses import declaration.

pp$1.parseImport = function(node) {
  this.next();
  // import '...'
  if (this.type === types.string) {
    node.specifiers = empty;
    node.source = this.parseExprAtom();
  } else {
    node.specifiers = this.parseImportSpecifiers();
    this.expectContextual("from");
    node.source = this.type === types.string ? this.parseExprAtom() : this.unexpected();
  }
  this.semicolon();
  return this.finishNode(node, "ImportDeclaration")
};

// Parses a comma-separated list of module imports.

pp$1.parseImportSpecifiers = function() {
  var this$1 = this;

  var nodes = [], first = true;
  if (this.type === types.name) {
    // import defaultObj, { x, y as z } from '...'
    var node = this.startNode();
    node.local = this.parseIdent();
    this.checkLVal(node.local, "let");
    nodes.push(this.finishNode(node, "ImportDefaultSpecifier"));
    if (!this.eat(types.comma)) { return nodes }
  }
  if (this.type === types.star) {
    var node$1 = this.startNode();
    this.next();
    this.expectContextual("as");
    node$1.local = this.parseIdent();
    this.checkLVal(node$1.local, "let");
    nodes.push(this.finishNode(node$1, "ImportNamespaceSpecifier"));
    return nodes
  }
  this.expect(types.braceL);
  while (!this.eat(types.braceR)) {
    if (!first) {
      this$1.expect(types.comma);
      if (this$1.afterTrailingComma(types.braceR)) { break }
    } else { first = false; }

    var node$2 = this$1.startNode();
    node$2.imported = this$1.parseIdent(true);
    if (this$1.eatContextual("as")) {
      node$2.local = this$1.parseIdent();
    } else {
      this$1.checkUnreserved(node$2.imported);
      node$2.local = node$2.imported;
    }
    this$1.checkLVal(node$2.local, "let");
    nodes.push(this$1.finishNode(node$2, "ImportSpecifier"));
  }
  return nodes
};

// Set `ExpressionStatement#directive` property for directive prologues.
pp$1.adaptDirectivePrologue = function(statements) {
  for (var i = 0; i < statements.length && this.isDirectiveCandidate(statements[i]); ++i) {
    statements[i].directive = statements[i].expression.raw.slice(1, -1);
  }
};
pp$1.isDirectiveCandidate = function(statement) {
  return (
    statement.type === "ExpressionStatement" &&
    statement.expression.type === "Literal" &&
    typeof statement.expression.value === "string" &&
    // Reject parenthesized strings.
    (this.input[statement.start] === "\"" || this.input[statement.start] === "'")
  )
};

var pp$2 = Parser.prototype;

// Convert existing expression atom to assignable pattern
// if possible.

pp$2.toAssignable = function(node, isBinding, refDestructuringErrors) {
  var this$1 = this;

  if (this.options.ecmaVersion >= 6 && node) {
    switch (node.type) {
    case "Identifier":
      if (this.inAsync && node.name === "await")
        { this.raise(node.start, "Can not use 'await' as identifier inside an async function"); }
      break

    case "ObjectPattern":
    case "ArrayPattern":
    case "RestElement":
      break

    case "ObjectExpression":
      node.type = "ObjectPattern";
      if (refDestructuringErrors) { this.checkPatternErrors(refDestructuringErrors, true); }
      for (var i = 0, list = node.properties; i < list.length; i += 1) {
        var prop = list[i];

      this$1.toAssignable(prop, isBinding);
        // Early error:
        //   AssignmentRestProperty[Yield, Await] :
        //     `...` DestructuringAssignmentTarget[Yield, Await]
        //
        //   It is a Syntax Error if |DestructuringAssignmentTarget| is an |ArrayLiteral| or an |ObjectLiteral|.
        if (
          prop.type === "RestElement" &&
          (prop.argument.type === "ArrayPattern" || prop.argument.type === "ObjectPattern")
        ) {
          this$1.raise(prop.argument.start, "Unexpected token");
        }
      }
      break

    case "Property":
      // AssignmentProperty has type === "Property"
      if (node.kind !== "init") { this.raise(node.key.start, "Object pattern can't contain getter or setter"); }
      this.toAssignable(node.value, isBinding);
      break

    case "ArrayExpression":
      node.type = "ArrayPattern";
      if (refDestructuringErrors) { this.checkPatternErrors(refDestructuringErrors, true); }
      this.toAssignableList(node.elements, isBinding);
      break

    case "SpreadElement":
      node.type = "RestElement";
      this.toAssignable(node.argument, isBinding);
      if (node.argument.type === "AssignmentPattern")
        { this.raise(node.argument.start, "Rest elements cannot have a default value"); }
      break

    case "AssignmentExpression":
      if (node.operator !== "=") { this.raise(node.left.end, "Only '=' operator can be used for specifying default value."); }
      node.type = "AssignmentPattern";
      delete node.operator;
      this.toAssignable(node.left, isBinding);
      // falls through to AssignmentPattern

    case "AssignmentPattern":
      break

    case "ParenthesizedExpression":
      this.toAssignable(node.expression, isBinding);
      break

    case "MemberExpression":
      if (!isBinding) { break }

    default:
      this.raise(node.start, "Assigning to rvalue");
    }
  } else if (refDestructuringErrors) { this.checkPatternErrors(refDestructuringErrors, true); }
  return node
};

// Convert list of expression atoms to binding list.

pp$2.toAssignableList = function(exprList, isBinding) {
  var this$1 = this;

  var end = exprList.length;
  for (var i = 0; i < end; i++) {
    var elt = exprList[i];
    if (elt) { this$1.toAssignable(elt, isBinding); }
  }
  if (end) {
    var last = exprList[end - 1];
    if (this.options.ecmaVersion === 6 && isBinding && last && last.type === "RestElement" && last.argument.type !== "Identifier")
      { this.unexpected(last.argument.start); }
  }
  return exprList
};

// Parses spread element.

pp$2.parseSpread = function(refDestructuringErrors) {
  var node = this.startNode();
  this.next();
  node.argument = this.parseMaybeAssign(false, refDestructuringErrors);
  return this.finishNode(node, "SpreadElement")
};

pp$2.parseRestBinding = function() {
  var node = this.startNode();
  this.next();

  // RestElement inside of a function parameter must be an identifier
  if (this.options.ecmaVersion === 6 && this.type !== types.name)
    { this.unexpected(); }

  node.argument = this.parseBindingAtom();

  return this.finishNode(node, "RestElement")
};

// Parses lvalue (assignable) atom.

pp$2.parseBindingAtom = function() {
  if (this.options.ecmaVersion >= 6) {
    switch (this.type) {
    case types.bracketL:
      var node = this.startNode();
      this.next();
      node.elements = this.parseBindingList(types.bracketR, true, true);
      return this.finishNode(node, "ArrayPattern")

    case types.braceL:
      return this.parseObj(true)
    }
  }
  return this.parseIdent()
};

pp$2.parseBindingList = function(close, allowEmpty, allowTrailingComma) {
  var this$1 = this;

  var elts = [], first = true;
  while (!this.eat(close)) {
    if (first) { first = false; }
    else { this$1.expect(types.comma); }
    if (allowEmpty && this$1.type === types.comma) {
      elts.push(null);
    } else if (allowTrailingComma && this$1.afterTrailingComma(close)) {
      break
    } else if (this$1.type === types.ellipsis) {
      var rest = this$1.parseRestBinding();
      this$1.parseBindingListItem(rest);
      elts.push(rest);
      if (this$1.type === types.comma) { this$1.raise(this$1.start, "Comma is not permitted after the rest element"); }
      this$1.expect(close);
      break
    } else {
      var elem = this$1.parseMaybeDefault(this$1.start, this$1.startLoc);
      this$1.parseBindingListItem(elem);
      elts.push(elem);
    }
  }
  return elts
};

pp$2.parseBindingListItem = function(param) {
  return param
};

// Parses assignment pattern around given atom if possible.

pp$2.parseMaybeDefault = function(startPos, startLoc, left) {
  left = left || this.parseBindingAtom();
  if (this.options.ecmaVersion < 6 || !this.eat(types.eq)) { return left }
  var node = this.startNodeAt(startPos, startLoc);
  node.left = left;
  node.right = this.parseMaybeAssign();
  return this.finishNode(node, "AssignmentPattern")
};

// Verify that a node is an lval — something that can be assigned
// to.
// bindingType can be either:
// 'var' indicating that the lval creates a 'var' binding
// 'let' indicating that the lval creates a lexical ('let' or 'const') binding
// 'none' indicating that the binding should be checked for illegal identifiers, but not for duplicate references

pp$2.checkLVal = function(expr, bindingType, checkClashes) {
  var this$1 = this;

  switch (expr.type) {
  case "Identifier":
    if (this.strict && this.reservedWordsStrictBind.test(expr.name))
      { this.raiseRecoverable(expr.start, (bindingType ? "Binding " : "Assigning to ") + expr.name + " in strict mode"); }
    if (checkClashes) {
      if (has(checkClashes, expr.name))
        { this.raiseRecoverable(expr.start, "Argument name clash"); }
      checkClashes[expr.name] = true;
    }
    if (bindingType && bindingType !== "none") {
      if (
        bindingType === "var" && !this.canDeclareVarName(expr.name) ||
        bindingType !== "var" && !this.canDeclareLexicalName(expr.name)
      ) {
        this.raiseRecoverable(expr.start, ("Identifier '" + (expr.name) + "' has already been declared"));
      }
      if (bindingType === "var") {
        this.declareVarName(expr.name);
      } else {
        this.declareLexicalName(expr.name);
      }
    }
    break

  case "MemberExpression":
    if (bindingType) { this.raiseRecoverable(expr.start, "Binding member expression"); }
    break

  case "ObjectPattern":
    for (var i = 0, list = expr.properties; i < list.length; i += 1)
      {
    var prop = list[i];

    this$1.checkLVal(prop, bindingType, checkClashes);
  }
    break

  case "Property":
    // AssignmentProperty has type === "Property"
    this.checkLVal(expr.value, bindingType, checkClashes);
    break

  case "ArrayPattern":
    for (var i$1 = 0, list$1 = expr.elements; i$1 < list$1.length; i$1 += 1) {
      var elem = list$1[i$1];

    if (elem) { this$1.checkLVal(elem, bindingType, checkClashes); }
    }
    break

  case "AssignmentPattern":
    this.checkLVal(expr.left, bindingType, checkClashes);
    break

  case "RestElement":
    this.checkLVal(expr.argument, bindingType, checkClashes);
    break

  case "ParenthesizedExpression":
    this.checkLVal(expr.expression, bindingType, checkClashes);
    break

  default:
    this.raise(expr.start, (bindingType ? "Binding" : "Assigning to") + " rvalue");
  }
};

// A recursive descent parser operates by defining functions for all
// syntactic elements, and recursively calling those, each function
// advancing the input stream and returning an AST node. Precedence
// of constructs (for example, the fact that `!x[1]` means `!(x[1])`
// instead of `(!x)[1]` is handled by the fact that the parser
// function that parses unary prefix operators is called first, and
// in turn calls the function that parses `[]` subscripts — that
// way, it'll receive the node for `x[1]` already parsed, and wraps
// *that* in the unary operator node.
//
// Acorn uses an [operator precedence parser][opp] to handle binary
// operator precedence, because it is much more compact than using
// the technique outlined above, which uses different, nesting
// functions to specify precedence, for all of the ten binary
// precedence levels that JavaScript defines.
//
// [opp]: http://en.wikipedia.org/wiki/Operator-precedence_parser

var pp$3 = Parser.prototype;

// Check if property name clashes with already added.
// Object/class getters and setters are not allowed to clash —
// either with each other or with an init property — and in
// strict mode, init properties are also not allowed to be repeated.

pp$3.checkPropClash = function(prop, propHash, refDestructuringErrors) {
  if (this.options.ecmaVersion >= 9 && prop.type === "SpreadElement")
    { return }
  if (this.options.ecmaVersion >= 6 && (prop.computed || prop.method || prop.shorthand))
    { return }
  var key = prop.key;
  var name;
  switch (key.type) {
  case "Identifier": name = key.name; break
  case "Literal": name = String(key.value); break
  default: return
  }
  var kind = prop.kind;
  if (this.options.ecmaVersion >= 6) {
    if (name === "__proto__" && kind === "init") {
      if (propHash.proto) {
        if (refDestructuringErrors && refDestructuringErrors.doubleProto < 0) { refDestructuringErrors.doubleProto = key.start; }
        // Backwards-compat kludge. Can be removed in version 6.0
        else { this.raiseRecoverable(key.start, "Redefinition of __proto__ property"); }
      }
      propHash.proto = true;
    }
    return
  }
  name = "$" + name;
  var other = propHash[name];
  if (other) {
    var redefinition;
    if (kind === "init") {
      redefinition = this.strict && other.init || other.get || other.set;
    } else {
      redefinition = other.init || other[kind];
    }
    if (redefinition)
      { this.raiseRecoverable(key.start, "Redefinition of property"); }
  } else {
    other = propHash[name] = {
      init: false,
      get: false,
      set: false
    };
  }
  other[kind] = true;
};

// ### Expression parsing

// These nest, from the most general expression type at the top to
// 'atomic', nondivisible expression types at the bottom. Most of
// the functions will simply let the function(s) below them parse,
// and, *if* the syntactic construct they handle is present, wrap
// the AST node that the inner parser gave them in another node.

// Parse a full expression. The optional arguments are used to
// forbid the `in` operator (in for loops initalization expressions)
// and provide reference for storing '=' operator inside shorthand
// property assignment in contexts where both object expression
// and object pattern might appear (so it's possible to raise
// delayed syntax error at correct position).

pp$3.parseExpression = function(noIn, refDestructuringErrors) {
  var this$1 = this;

  var startPos = this.start, startLoc = this.startLoc;
  var expr = this.parseMaybeAssign(noIn, refDestructuringErrors);
  if (this.type === types.comma) {
    var node = this.startNodeAt(startPos, startLoc);
    node.expressions = [expr];
    while (this.eat(types.comma)) { node.expressions.push(this$1.parseMaybeAssign(noIn, refDestructuringErrors)); }
    return this.finishNode(node, "SequenceExpression")
  }
  return expr
};

// Parse an assignment expression. This includes applications of
// operators like `+=`.

pp$3.parseMaybeAssign = function(noIn, refDestructuringErrors, afterLeftParse) {
  if (this.inGenerator && this.isContextual("yield")) { return this.parseYield() }

  var ownDestructuringErrors = false, oldParenAssign = -1, oldTrailingComma = -1;
  if (refDestructuringErrors) {
    oldParenAssign = refDestructuringErrors.parenthesizedAssign;
    oldTrailingComma = refDestructuringErrors.trailingComma;
    refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = -1;
  } else {
    refDestructuringErrors = new DestructuringErrors;
    ownDestructuringErrors = true;
  }

  var startPos = this.start, startLoc = this.startLoc;
  if (this.type === types.parenL || this.type === types.name)
    { this.potentialArrowAt = this.start; }
  var left = this.parseMaybeConditional(noIn, refDestructuringErrors);
  if (afterLeftParse) { left = afterLeftParse.call(this, left, startPos, startLoc); }
  if (this.type.isAssign) {
    var node = this.startNodeAt(startPos, startLoc);
    node.operator = this.value;
    node.left = this.type === types.eq ? this.toAssignable(left, false, refDestructuringErrors) : left;
    if (!ownDestructuringErrors) { DestructuringErrors.call(refDestructuringErrors); }
    refDestructuringErrors.shorthandAssign = -1; // reset because shorthand default was used correctly
    this.checkLVal(left);
    this.next();
    node.right = this.parseMaybeAssign(noIn);
    return this.finishNode(node, "AssignmentExpression")
  } else {
    if (ownDestructuringErrors) { this.checkExpressionErrors(refDestructuringErrors, true); }
  }
  if (oldParenAssign > -1) { refDestructuringErrors.parenthesizedAssign = oldParenAssign; }
  if (oldTrailingComma > -1) { refDestructuringErrors.trailingComma = oldTrailingComma; }
  return left
};

// Parse a ternary conditional (`?:`) operator.

pp$3.parseMaybeConditional = function(noIn, refDestructuringErrors) {
  var startPos = this.start, startLoc = this.startLoc;
  var expr = this.parseExprOps(noIn, refDestructuringErrors);
  if (this.checkExpressionErrors(refDestructuringErrors)) { return expr }
  if (this.eat(types.question)) {
    var node = this.startNodeAt(startPos, startLoc);
    node.test = expr;
    node.consequent = this.parseMaybeAssign();
    this.expect(types.colon);
    node.alternate = this.parseMaybeAssign(noIn);
    return this.finishNode(node, "ConditionalExpression")
  }
  return expr
};

// Start the precedence parser.

pp$3.parseExprOps = function(noIn, refDestructuringErrors) {
  var startPos = this.start, startLoc = this.startLoc;
  var expr = this.parseMaybeUnary(refDestructuringErrors, false);
  if (this.checkExpressionErrors(refDestructuringErrors)) { return expr }
  return expr.start === startPos && expr.type === "ArrowFunctionExpression" ? expr : this.parseExprOp(expr, startPos, startLoc, -1, noIn)
};

// Parse binary operators with the operator precedence parsing
// algorithm. `left` is the left-hand side of the operator.
// `minPrec` provides context that allows the function to stop and
// defer further parser to one of its callers when it encounters an
// operator that has a lower precedence than the set it is parsing.

pp$3.parseExprOp = function(left, leftStartPos, leftStartLoc, minPrec, noIn) {
  var prec = this.type.binop;
  if (prec != null && (!noIn || this.type !== types._in)) {
    if (prec > minPrec) {
      var logical = this.type === types.logicalOR || this.type === types.logicalAND;
      var op = this.value;
      this.next();
      var startPos = this.start, startLoc = this.startLoc;
      var right = this.parseExprOp(this.parseMaybeUnary(null, false), startPos, startLoc, prec, noIn);
      var node = this.buildBinary(leftStartPos, leftStartLoc, left, right, op, logical);
      return this.parseExprOp(node, leftStartPos, leftStartLoc, minPrec, noIn)
    }
  }
  return left
};

pp$3.buildBinary = function(startPos, startLoc, left, right, op, logical) {
  var node = this.startNodeAt(startPos, startLoc);
  node.left = left;
  node.operator = op;
  node.right = right;
  return this.finishNode(node, logical ? "LogicalExpression" : "BinaryExpression")
};

// Parse unary operators, both prefix and postfix.

pp$3.parseMaybeUnary = function(refDestructuringErrors, sawUnary) {
  var this$1 = this;

  var startPos = this.start, startLoc = this.startLoc, expr;
  if (this.isContextual("await") && (this.inAsync || (!this.inFunction && this.options.allowAwaitOutsideFunction))) {
    expr = this.parseAwait();
    sawUnary = true;
  } else if (this.type.prefix) {
    var node = this.startNode(), update = this.type === types.incDec;
    node.operator = this.value;
    node.prefix = true;
    this.next();
    node.argument = this.parseMaybeUnary(null, true);
    this.checkExpressionErrors(refDestructuringErrors, true);
    if (update) { this.checkLVal(node.argument); }
    else if (this.strict && node.operator === "delete" &&
             node.argument.type === "Identifier")
      { this.raiseRecoverable(node.start, "Deleting local variable in strict mode"); }
    else { sawUnary = true; }
    expr = this.finishNode(node, update ? "UpdateExpression" : "UnaryExpression");
  } else {
    expr = this.parseExprSubscripts(refDestructuringErrors);
    if (this.checkExpressionErrors(refDestructuringErrors)) { return expr }
    while (this.type.postfix && !this.canInsertSemicolon()) {
      var node$1 = this$1.startNodeAt(startPos, startLoc);
      node$1.operator = this$1.value;
      node$1.prefix = false;
      node$1.argument = expr;
      this$1.checkLVal(expr);
      this$1.next();
      expr = this$1.finishNode(node$1, "UpdateExpression");
    }
  }

  if (!sawUnary && this.eat(types.starstar))
    { return this.buildBinary(startPos, startLoc, expr, this.parseMaybeUnary(null, false), "**", false) }
  else
    { return expr }
};

// Parse call, dot, and `[]`-subscript expressions.

pp$3.parseExprSubscripts = function(refDestructuringErrors) {
  var startPos = this.start, startLoc = this.startLoc;
  var expr = this.parseExprAtom(refDestructuringErrors);
  var skipArrowSubscripts = expr.type === "ArrowFunctionExpression" && this.input.slice(this.lastTokStart, this.lastTokEnd) !== ")";
  if (this.checkExpressionErrors(refDestructuringErrors) || skipArrowSubscripts) { return expr }
  var result = this.parseSubscripts(expr, startPos, startLoc);
  if (refDestructuringErrors && result.type === "MemberExpression") {
    if (refDestructuringErrors.parenthesizedAssign >= result.start) { refDestructuringErrors.parenthesizedAssign = -1; }
    if (refDestructuringErrors.parenthesizedBind >= result.start) { refDestructuringErrors.parenthesizedBind = -1; }
  }
  return result
};

pp$3.parseSubscripts = function(base, startPos, startLoc, noCalls) {
  var this$1 = this;

  var maybeAsyncArrow = this.options.ecmaVersion >= 8 && base.type === "Identifier" && base.name === "async" &&
      this.lastTokEnd === base.end && !this.canInsertSemicolon() && this.input.slice(base.start, base.end) === "async";
  for (var computed = (void 0);;) {
    if ((computed = this$1.eat(types.bracketL)) || this$1.eat(types.dot)) {
      var node = this$1.startNodeAt(startPos, startLoc);
      node.object = base;
      node.property = computed ? this$1.parseExpression() : this$1.parseIdent(true);
      node.computed = !!computed;
      if (computed) { this$1.expect(types.bracketR); }
      base = this$1.finishNode(node, "MemberExpression");
    } else if (!noCalls && this$1.eat(types.parenL)) {
      var refDestructuringErrors = new DestructuringErrors, oldYieldPos = this$1.yieldPos, oldAwaitPos = this$1.awaitPos;
      this$1.yieldPos = 0;
      this$1.awaitPos = 0;
      var exprList = this$1.parseExprList(types.parenR, this$1.options.ecmaVersion >= 8, false, refDestructuringErrors);
      if (maybeAsyncArrow && !this$1.canInsertSemicolon() && this$1.eat(types.arrow)) {
        this$1.checkPatternErrors(refDestructuringErrors, false);
        this$1.checkYieldAwaitInDefaultParams();
        this$1.yieldPos = oldYieldPos;
        this$1.awaitPos = oldAwaitPos;
        return this$1.parseArrowExpression(this$1.startNodeAt(startPos, startLoc), exprList, true)
      }
      this$1.checkExpressionErrors(refDestructuringErrors, true);
      this$1.yieldPos = oldYieldPos || this$1.yieldPos;
      this$1.awaitPos = oldAwaitPos || this$1.awaitPos;
      var node$1 = this$1.startNodeAt(startPos, startLoc);
      node$1.callee = base;
      node$1.arguments = exprList;
      base = this$1.finishNode(node$1, "CallExpression");
    } else if (this$1.type === types.backQuote) {
      var node$2 = this$1.startNodeAt(startPos, startLoc);
      node$2.tag = base;
      node$2.quasi = this$1.parseTemplate({isTagged: true});
      base = this$1.finishNode(node$2, "TaggedTemplateExpression");
    } else {
      return base
    }
  }
};

// Parse an atomic expression — either a single token that is an
// expression, an expression started by a keyword like `function` or
// `new`, or an expression wrapped in punctuation like `()`, `[]`,
// or `{}`.

pp$3.parseExprAtom = function(refDestructuringErrors) {
  var node, canBeArrow = this.potentialArrowAt === this.start;
  switch (this.type) {
  case types._super:
    if (!this.inFunction)
      { this.raise(this.start, "'super' outside of function or class"); }
    node = this.startNode();
    this.next();
    // The `super` keyword can appear at below:
    // SuperProperty:
    //     super [ Expression ]
    //     super . IdentifierName
    // SuperCall:
    //     super Arguments
    if (this.type !== types.dot && this.type !== types.bracketL && this.type !== types.parenL)
      { this.unexpected(); }
    return this.finishNode(node, "Super")

  case types._this:
    node = this.startNode();
    this.next();
    return this.finishNode(node, "ThisExpression")

  case types.name:
    var startPos = this.start, startLoc = this.startLoc, containsEsc = this.containsEsc;
    var id = this.parseIdent(this.type !== types.name);
    if (this.options.ecmaVersion >= 8 && !containsEsc && id.name === "async" && !this.canInsertSemicolon() && this.eat(types._function))
      { return this.parseFunction(this.startNodeAt(startPos, startLoc), false, false, true) }
    if (canBeArrow && !this.canInsertSemicolon()) {
      if (this.eat(types.arrow))
        { return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], false) }
      if (this.options.ecmaVersion >= 8 && id.name === "async" && this.type === types.name && !containsEsc) {
        id = this.parseIdent();
        if (this.canInsertSemicolon() || !this.eat(types.arrow))
          { this.unexpected(); }
        return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], true)
      }
    }
    return id

  case types.regexp:
    var value = this.value;
    node = this.parseLiteral(value.value);
    node.regex = {pattern: value.pattern, flags: value.flags};
    return node

  case types.num: case types.string:
    return this.parseLiteral(this.value)

  case types._null: case types._true: case types._false:
    node = this.startNode();
    node.value = this.type === types._null ? null : this.type === types._true;
    node.raw = this.type.keyword;
    this.next();
    return this.finishNode(node, "Literal")

  case types.parenL:
    var start = this.start, expr = this.parseParenAndDistinguishExpression(canBeArrow);
    if (refDestructuringErrors) {
      if (refDestructuringErrors.parenthesizedAssign < 0 && !this.isSimpleAssignTarget(expr))
        { refDestructuringErrors.parenthesizedAssign = start; }
      if (refDestructuringErrors.parenthesizedBind < 0)
        { refDestructuringErrors.parenthesizedBind = start; }
    }
    return expr

  case types.bracketL:
    node = this.startNode();
    this.next();
    node.elements = this.parseExprList(types.bracketR, true, true, refDestructuringErrors);
    return this.finishNode(node, "ArrayExpression")

  case types.braceL:
    return this.parseObj(false, refDestructuringErrors)

  case types._function:
    node = this.startNode();
    this.next();
    return this.parseFunction(node, false)

  case types._class:
    return this.parseClass(this.startNode(), false)

  case types._new:
    return this.parseNew()

  case types.backQuote:
    return this.parseTemplate()

  default:
    this.unexpected();
  }
};

pp$3.parseLiteral = function(value) {
  var node = this.startNode();
  node.value = value;
  node.raw = this.input.slice(this.start, this.end);
  this.next();
  return this.finishNode(node, "Literal")
};

pp$3.parseParenExpression = function() {
  this.expect(types.parenL);
  var val = this.parseExpression();
  this.expect(types.parenR);
  return val
};

pp$3.parseParenAndDistinguishExpression = function(canBeArrow) {
  var this$1 = this;

  var startPos = this.start, startLoc = this.startLoc, val, allowTrailingComma = this.options.ecmaVersion >= 8;
  if (this.options.ecmaVersion >= 6) {
    this.next();

    var innerStartPos = this.start, innerStartLoc = this.startLoc;
    var exprList = [], first = true, lastIsComma = false;
    var refDestructuringErrors = new DestructuringErrors, oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, spreadStart;
    this.yieldPos = 0;
    this.awaitPos = 0;
    while (this.type !== types.parenR) {
      first ? first = false : this$1.expect(types.comma);
      if (allowTrailingComma && this$1.afterTrailingComma(types.parenR, true)) {
        lastIsComma = true;
        break
      } else if (this$1.type === types.ellipsis) {
        spreadStart = this$1.start;
        exprList.push(this$1.parseParenItem(this$1.parseRestBinding()));
        if (this$1.type === types.comma) { this$1.raise(this$1.start, "Comma is not permitted after the rest element"); }
        break
      } else {
        exprList.push(this$1.parseMaybeAssign(false, refDestructuringErrors, this$1.parseParenItem));
      }
    }
    var innerEndPos = this.start, innerEndLoc = this.startLoc;
    this.expect(types.parenR);

    if (canBeArrow && !this.canInsertSemicolon() && this.eat(types.arrow)) {
      this.checkPatternErrors(refDestructuringErrors, false);
      this.checkYieldAwaitInDefaultParams();
      this.yieldPos = oldYieldPos;
      this.awaitPos = oldAwaitPos;
      return this.parseParenArrowList(startPos, startLoc, exprList)
    }

    if (!exprList.length || lastIsComma) { this.unexpected(this.lastTokStart); }
    if (spreadStart) { this.unexpected(spreadStart); }
    this.checkExpressionErrors(refDestructuringErrors, true);
    this.yieldPos = oldYieldPos || this.yieldPos;
    this.awaitPos = oldAwaitPos || this.awaitPos;

    if (exprList.length > 1) {
      val = this.startNodeAt(innerStartPos, innerStartLoc);
      val.expressions = exprList;
      this.finishNodeAt(val, "SequenceExpression", innerEndPos, innerEndLoc);
    } else {
      val = exprList[0];
    }
  } else {
    val = this.parseParenExpression();
  }

  if (this.options.preserveParens) {
    var par = this.startNodeAt(startPos, startLoc);
    par.expression = val;
    return this.finishNode(par, "ParenthesizedExpression")
  } else {
    return val
  }
};

pp$3.parseParenItem = function(item) {
  return item
};

pp$3.parseParenArrowList = function(startPos, startLoc, exprList) {
  return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList)
};

// New's precedence is slightly tricky. It must allow its argument to
// be a `[]` or dot subscript expression, but not a call — at least,
// not without wrapping it in parentheses. Thus, it uses the noCalls
// argument to parseSubscripts to prevent it from consuming the
// argument list.

var empty$1 = [];

pp$3.parseNew = function() {
  var node = this.startNode();
  var meta = this.parseIdent(true);
  if (this.options.ecmaVersion >= 6 && this.eat(types.dot)) {
    node.meta = meta;
    var containsEsc = this.containsEsc;
    node.property = this.parseIdent(true);
    if (node.property.name !== "target" || containsEsc)
      { this.raiseRecoverable(node.property.start, "The only valid meta property for new is new.target"); }
    if (!this.inFunction)
      { this.raiseRecoverable(node.start, "new.target can only be used in functions"); }
    return this.finishNode(node, "MetaProperty")
  }
  var startPos = this.start, startLoc = this.startLoc;
  node.callee = this.parseSubscripts(this.parseExprAtom(), startPos, startLoc, true);
  if (this.eat(types.parenL)) { node.arguments = this.parseExprList(types.parenR, this.options.ecmaVersion >= 8, false); }
  else { node.arguments = empty$1; }
  return this.finishNode(node, "NewExpression")
};

// Parse template expression.

pp$3.parseTemplateElement = function(ref) {
  var isTagged = ref.isTagged;

  var elem = this.startNode();
  if (this.type === types.invalidTemplate) {
    if (!isTagged) {
      this.raiseRecoverable(this.start, "Bad escape sequence in untagged template literal");
    }
    elem.value = {
      raw: this.value,
      cooked: null
    };
  } else {
    elem.value = {
      raw: this.input.slice(this.start, this.end).replace(/\r\n?/g, "\n"),
      cooked: this.value
    };
  }
  this.next();
  elem.tail = this.type === types.backQuote;
  return this.finishNode(elem, "TemplateElement")
};

pp$3.parseTemplate = function(ref) {
  var this$1 = this;
  if ( ref === void 0 ) ref = {};
  var isTagged = ref.isTagged; if ( isTagged === void 0 ) isTagged = false;

  var node = this.startNode();
  this.next();
  node.expressions = [];
  var curElt = this.parseTemplateElement({isTagged: isTagged});
  node.quasis = [curElt];
  while (!curElt.tail) {
    if (this$1.type === types.eof) { this$1.raise(this$1.pos, "Unterminated template literal"); }
    this$1.expect(types.dollarBraceL);
    node.expressions.push(this$1.parseExpression());
    this$1.expect(types.braceR);
    node.quasis.push(curElt = this$1.parseTemplateElement({isTagged: isTagged}));
  }
  this.next();
  return this.finishNode(node, "TemplateLiteral")
};

pp$3.isAsyncProp = function(prop) {
  return !prop.computed && prop.key.type === "Identifier" && prop.key.name === "async" &&
    (this.type === types.name || this.type === types.num || this.type === types.string || this.type === types.bracketL || this.type.keyword || (this.options.ecmaVersion >= 9 && this.type === types.star)) &&
    !lineBreak.test(this.input.slice(this.lastTokEnd, this.start))
};

// Parse an object literal or binding pattern.

pp$3.parseObj = function(isPattern, refDestructuringErrors) {
  var this$1 = this;

  var node = this.startNode(), first = true, propHash = {};
  node.properties = [];
  this.next();
  while (!this.eat(types.braceR)) {
    if (!first) {
      this$1.expect(types.comma);
      if (this$1.afterTrailingComma(types.braceR)) { break }
    } else { first = false; }

    var prop = this$1.parseProperty(isPattern, refDestructuringErrors);
    if (!isPattern) { this$1.checkPropClash(prop, propHash, refDestructuringErrors); }
    node.properties.push(prop);
  }
  return this.finishNode(node, isPattern ? "ObjectPattern" : "ObjectExpression")
};

pp$3.parseProperty = function(isPattern, refDestructuringErrors) {
  var prop = this.startNode(), isGenerator, isAsync, startPos, startLoc;
  if (this.options.ecmaVersion >= 9 && this.eat(types.ellipsis)) {
    if (isPattern) {
      prop.argument = this.parseIdent(false);
      if (this.type === types.comma) {
        this.raise(this.start, "Comma is not permitted after the rest element");
      }
      return this.finishNode(prop, "RestElement")
    }
    // To disallow parenthesized identifier via `this.toAssignable()`.
    if (this.type === types.parenL && refDestructuringErrors) {
      if (refDestructuringErrors.parenthesizedAssign < 0) {
        refDestructuringErrors.parenthesizedAssign = this.start;
      }
      if (refDestructuringErrors.parenthesizedBind < 0) {
        refDestructuringErrors.parenthesizedBind = this.start;
      }
    }
    // Parse argument.
    prop.argument = this.parseMaybeAssign(false, refDestructuringErrors);
    // To disallow trailing comma via `this.toAssignable()`.
    if (this.type === types.comma && refDestructuringErrors && refDestructuringErrors.trailingComma < 0) {
      refDestructuringErrors.trailingComma = this.start;
    }
    // Finish
    return this.finishNode(prop, "SpreadElement")
  }
  if (this.options.ecmaVersion >= 6) {
    prop.method = false;
    prop.shorthand = false;
    if (isPattern || refDestructuringErrors) {
      startPos = this.start;
      startLoc = this.startLoc;
    }
    if (!isPattern)
      { isGenerator = this.eat(types.star); }
  }
  var containsEsc = this.containsEsc;
  this.parsePropertyName(prop);
  if (!isPattern && !containsEsc && this.options.ecmaVersion >= 8 && !isGenerator && this.isAsyncProp(prop)) {
    isAsync = true;
    isGenerator = this.options.ecmaVersion >= 9 && this.eat(types.star);
    this.parsePropertyName(prop, refDestructuringErrors);
  } else {
    isAsync = false;
  }
  this.parsePropertyValue(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc);
  return this.finishNode(prop, "Property")
};

pp$3.parsePropertyValue = function(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc) {
  if ((isGenerator || isAsync) && this.type === types.colon)
    { this.unexpected(); }

  if (this.eat(types.colon)) {
    prop.value = isPattern ? this.parseMaybeDefault(this.start, this.startLoc) : this.parseMaybeAssign(false, refDestructuringErrors);
    prop.kind = "init";
  } else if (this.options.ecmaVersion >= 6 && this.type === types.parenL) {
    if (isPattern) { this.unexpected(); }
    prop.kind = "init";
    prop.method = true;
    prop.value = this.parseMethod(isGenerator, isAsync);
  } else if (!isPattern && !containsEsc &&
             this.options.ecmaVersion >= 5 && !prop.computed && prop.key.type === "Identifier" &&
             (prop.key.name === "get" || prop.key.name === "set") &&
             (this.type !== types.comma && this.type !== types.braceR)) {
    if (isGenerator || isAsync) { this.unexpected(); }
    prop.kind = prop.key.name;
    this.parsePropertyName(prop);
    prop.value = this.parseMethod(false);
    var paramCount = prop.kind === "get" ? 0 : 1;
    if (prop.value.params.length !== paramCount) {
      var start = prop.value.start;
      if (prop.kind === "get")
        { this.raiseRecoverable(start, "getter should have no params"); }
      else
        { this.raiseRecoverable(start, "setter should have exactly one param"); }
    } else {
      if (prop.kind === "set" && prop.value.params[0].type === "RestElement")
        { this.raiseRecoverable(prop.value.params[0].start, "Setter cannot use rest params"); }
    }
  } else if (this.options.ecmaVersion >= 6 && !prop.computed && prop.key.type === "Identifier") {
    this.checkUnreserved(prop.key);
    prop.kind = "init";
    if (isPattern) {
      prop.value = this.parseMaybeDefault(startPos, startLoc, prop.key);
    } else if (this.type === types.eq && refDestructuringErrors) {
      if (refDestructuringErrors.shorthandAssign < 0)
        { refDestructuringErrors.shorthandAssign = this.start; }
      prop.value = this.parseMaybeDefault(startPos, startLoc, prop.key);
    } else {
      prop.value = prop.key;
    }
    prop.shorthand = true;
  } else { this.unexpected(); }
};

pp$3.parsePropertyName = function(prop) {
  if (this.options.ecmaVersion >= 6) {
    if (this.eat(types.bracketL)) {
      prop.computed = true;
      prop.key = this.parseMaybeAssign();
      this.expect(types.bracketR);
      return prop.key
    } else {
      prop.computed = false;
    }
  }
  return prop.key = this.type === types.num || this.type === types.string ? this.parseExprAtom() : this.parseIdent(true)
};

// Initialize empty function node.

pp$3.initFunction = function(node) {
  node.id = null;
  if (this.options.ecmaVersion >= 6) {
    node.generator = false;
    node.expression = false;
  }
  if (this.options.ecmaVersion >= 8)
    { node.async = false; }
};

// Parse object or class method.

pp$3.parseMethod = function(isGenerator, isAsync) {
  var node = this.startNode(), oldInGen = this.inGenerator, oldInAsync = this.inAsync,
      oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldInFunc = this.inFunction;

  this.initFunction(node);
  if (this.options.ecmaVersion >= 6)
    { node.generator = isGenerator; }
  if (this.options.ecmaVersion >= 8)
    { node.async = !!isAsync; }

  this.inGenerator = node.generator;
  this.inAsync = node.async;
  this.yieldPos = 0;
  this.awaitPos = 0;
  this.inFunction = true;
  this.enterFunctionScope();

  this.expect(types.parenL);
  node.params = this.parseBindingList(types.parenR, false, this.options.ecmaVersion >= 8);
  this.checkYieldAwaitInDefaultParams();
  this.parseFunctionBody(node, false);

  this.inGenerator = oldInGen;
  this.inAsync = oldInAsync;
  this.yieldPos = oldYieldPos;
  this.awaitPos = oldAwaitPos;
  this.inFunction = oldInFunc;
  return this.finishNode(node, "FunctionExpression")
};

// Parse arrow function expression with given parameters.

pp$3.parseArrowExpression = function(node, params, isAsync) {
  var oldInGen = this.inGenerator, oldInAsync = this.inAsync,
      oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldInFunc = this.inFunction;

  this.enterFunctionScope();
  this.initFunction(node);
  if (this.options.ecmaVersion >= 8)
    { node.async = !!isAsync; }

  this.inGenerator = false;
  this.inAsync = node.async;
  this.yieldPos = 0;
  this.awaitPos = 0;
  this.inFunction = true;

  node.params = this.toAssignableList(params, true);
  this.parseFunctionBody(node, true);

  this.inGenerator = oldInGen;
  this.inAsync = oldInAsync;
  this.yieldPos = oldYieldPos;
  this.awaitPos = oldAwaitPos;
  this.inFunction = oldInFunc;
  return this.finishNode(node, "ArrowFunctionExpression")
};

// Parse function body and check parameters.

pp$3.parseFunctionBody = function(node, isArrowFunction) {
  var isExpression = isArrowFunction && this.type !== types.braceL;
  var oldStrict = this.strict, useStrict = false;

  if (isExpression) {
    node.body = this.parseMaybeAssign();
    node.expression = true;
    this.checkParams(node, false);
  } else {
    var nonSimple = this.options.ecmaVersion >= 7 && !this.isSimpleParamList(node.params);
    if (!oldStrict || nonSimple) {
      useStrict = this.strictDirective(this.end);
      // If this is a strict mode function, verify that argument names
      // are not repeated, and it does not try to bind the words `eval`
      // or `arguments`.
      if (useStrict && nonSimple)
        { this.raiseRecoverable(node.start, "Illegal 'use strict' directive in function with non-simple parameter list"); }
    }
    // Start a new scope with regard to labels and the `inFunction`
    // flag (restore them to their old value afterwards).
    var oldLabels = this.labels;
    this.labels = [];
    if (useStrict) { this.strict = true; }

    // Add the params to varDeclaredNames to ensure that an error is thrown
    // if a let/const declaration in the function clashes with one of the params.
    this.checkParams(node, !oldStrict && !useStrict && !isArrowFunction && this.isSimpleParamList(node.params));
    node.body = this.parseBlock(false);
    node.expression = false;
    this.adaptDirectivePrologue(node.body.body);
    this.labels = oldLabels;
  }
  this.exitFunctionScope();

  if (this.strict && node.id) {
    // Ensure the function name isn't a forbidden identifier in strict mode, e.g. 'eval'
    this.checkLVal(node.id, "none");
  }
  this.strict = oldStrict;
};

pp$3.isSimpleParamList = function(params) {
  for (var i = 0, list = params; i < list.length; i += 1)
    {
    var param = list[i];

    if (param.type !== "Identifier") { return false
  } }
  return true
};

// Checks function params for various disallowed patterns such as using "eval"
// or "arguments" and duplicate parameters.

pp$3.checkParams = function(node, allowDuplicates) {
  var this$1 = this;

  var nameHash = {};
  for (var i = 0, list = node.params; i < list.length; i += 1)
    {
    var param = list[i];

    this$1.checkLVal(param, "var", allowDuplicates ? null : nameHash);
  }
};

// Parses a comma-separated list of expressions, and returns them as
// an array. `close` is the token type that ends the list, and
// `allowEmpty` can be turned on to allow subsequent commas with
// nothing in between them to be parsed as `null` (which is needed
// for array literals).

pp$3.parseExprList = function(close, allowTrailingComma, allowEmpty, refDestructuringErrors) {
  var this$1 = this;

  var elts = [], first = true;
  while (!this.eat(close)) {
    if (!first) {
      this$1.expect(types.comma);
      if (allowTrailingComma && this$1.afterTrailingComma(close)) { break }
    } else { first = false; }

    var elt = (void 0);
    if (allowEmpty && this$1.type === types.comma)
      { elt = null; }
    else if (this$1.type === types.ellipsis) {
      elt = this$1.parseSpread(refDestructuringErrors);
      if (refDestructuringErrors && this$1.type === types.comma && refDestructuringErrors.trailingComma < 0)
        { refDestructuringErrors.trailingComma = this$1.start; }
    } else {
      elt = this$1.parseMaybeAssign(false, refDestructuringErrors);
    }
    elts.push(elt);
  }
  return elts
};

pp$3.checkUnreserved = function(ref) {
  var start = ref.start;
  var end = ref.end;
  var name = ref.name;

  if (this.inGenerator && name === "yield")
    { this.raiseRecoverable(start, "Can not use 'yield' as identifier inside a generator"); }
  if (this.inAsync && name === "await")
    { this.raiseRecoverable(start, "Can not use 'await' as identifier inside an async function"); }
  if (this.isKeyword(name))
    { this.raise(start, ("Unexpected keyword '" + name + "'")); }
  if (this.options.ecmaVersion < 6 &&
    this.input.slice(start, end).indexOf("\\") !== -1) { return }
  var re = this.strict ? this.reservedWordsStrict : this.reservedWords;
  if (re.test(name)) {
    if (!this.inAsync && name === "await")
      { this.raiseRecoverable(start, "Can not use keyword 'await' outside an async function"); }
    this.raiseRecoverable(start, ("The keyword '" + name + "' is reserved"));
  }
};

// Parse the next token as an identifier. If `liberal` is true (used
// when parsing properties), it will also convert keywords into
// identifiers.

pp$3.parseIdent = function(liberal, isBinding) {
  var node = this.startNode();
  if (liberal && this.options.allowReserved === "never") { liberal = false; }
  if (this.type === types.name) {
    node.name = this.value;
  } else if (this.type.keyword) {
    node.name = this.type.keyword;

    // To fix https://github.com/acornjs/acorn/issues/575
    // `class` and `function` keywords push new context into this.context.
    // But there is no chance to pop the context if the keyword is consumed as an identifier such as a property name.
    // If the previous token is a dot, this does not apply because the context-managing code already ignored the keyword
    if ((node.name === "class" || node.name === "function") &&
        (this.lastTokEnd !== this.lastTokStart + 1 || this.input.charCodeAt(this.lastTokStart) !== 46)) {
      this.context.pop();
    }
  } else {
    this.unexpected();
  }
  this.next();
  this.finishNode(node, "Identifier");
  if (!liberal) { this.checkUnreserved(node); }
  return node
};

// Parses yield expression inside generator.

pp$3.parseYield = function() {
  if (!this.yieldPos) { this.yieldPos = this.start; }

  var node = this.startNode();
  this.next();
  if (this.type === types.semi || this.canInsertSemicolon() || (this.type !== types.star && !this.type.startsExpr)) {
    node.delegate = false;
    node.argument = null;
  } else {
    node.delegate = this.eat(types.star);
    node.argument = this.parseMaybeAssign();
  }
  return this.finishNode(node, "YieldExpression")
};

pp$3.parseAwait = function() {
  if (!this.awaitPos) { this.awaitPos = this.start; }

  var node = this.startNode();
  this.next();
  node.argument = this.parseMaybeUnary(null, true);
  return this.finishNode(node, "AwaitExpression")
};

var pp$4 = Parser.prototype;

// This function is used to raise exceptions on parse errors. It
// takes an offset integer (into the current `input`) to indicate
// the location of the error, attaches the position to the end
// of the error message, and then raises a `SyntaxError` with that
// message.

pp$4.raise = function(pos, message) {
  var loc = getLineInfo(this.input, pos);
  message += " (" + loc.line + ":" + loc.column + ")";
  var err = new SyntaxError(message);
  err.pos = pos; err.loc = loc; err.raisedAt = this.pos;
  throw err
};

pp$4.raiseRecoverable = pp$4.raise;

pp$4.curPosition = function() {
  if (this.options.locations) {
    return new Position(this.curLine, this.pos - this.lineStart)
  }
};

var pp$5 = Parser.prototype;

// Object.assign polyfill
var assign = Object.assign || function(target) {
  var sources = [], len = arguments.length - 1;
  while ( len-- > 0 ) sources[ len ] = arguments[ len + 1 ];

  for (var i = 0, list = sources; i < list.length; i += 1) {
    var source = list[i];

    for (var key in source) {
      if (has(source, key)) {
        target[key] = source[key];
      }
    }
  }
  return target
};

// The functions in this module keep track of declared variables in the current scope in order to detect duplicate variable names.

pp$5.enterFunctionScope = function() {
  // var: a hash of var-declared names in the current lexical scope
  // lexical: a hash of lexically-declared names in the current lexical scope
  // childVar: a hash of var-declared names in all child lexical scopes of the current lexical scope (within the current function scope)
  // parentLexical: a hash of lexically-declared names in all parent lexical scopes of the current lexical scope (within the current function scope)
  this.scopeStack.push({var: {}, lexical: {}, childVar: {}, parentLexical: {}});
};

pp$5.exitFunctionScope = function() {
  this.scopeStack.pop();
};

pp$5.enterLexicalScope = function() {
  var parentScope = this.scopeStack[this.scopeStack.length - 1];
  var childScope = {var: {}, lexical: {}, childVar: {}, parentLexical: {}};

  this.scopeStack.push(childScope);
  assign(childScope.parentLexical, parentScope.lexical, parentScope.parentLexical);
};

pp$5.exitLexicalScope = function() {
  var childScope = this.scopeStack.pop();
  var parentScope = this.scopeStack[this.scopeStack.length - 1];

  assign(parentScope.childVar, childScope.var, childScope.childVar);
};

/**
 * A name can be declared with `var` if there are no variables with the same name declared with `let`/`const`
 * in the current lexical scope or any of the parent lexical scopes in this function.
 */
pp$5.canDeclareVarName = function(name) {
  var currentScope = this.scopeStack[this.scopeStack.length - 1];

  return !has(currentScope.lexical, name) && !has(currentScope.parentLexical, name)
};

/**
 * A name can be declared with `let`/`const` if there are no variables with the same name declared with `let`/`const`
 * in the current scope, and there are no variables with the same name declared with `var` in the current scope or in
 * any child lexical scopes in this function.
 */
pp$5.canDeclareLexicalName = function(name) {
  var currentScope = this.scopeStack[this.scopeStack.length - 1];

  return !has(currentScope.lexical, name) && !has(currentScope.var, name) && !has(currentScope.childVar, name)
};

pp$5.declareVarName = function(name) {
  this.scopeStack[this.scopeStack.length - 1].var[name] = true;
};

pp$5.declareLexicalName = function(name) {
  this.scopeStack[this.scopeStack.length - 1].lexical[name] = true;
};

var Node = function Node(parser, pos, loc) {
  this.type = "";
  this.start = pos;
  this.end = 0;
  if (parser.options.locations)
    { this.loc = new SourceLocation(parser, loc); }
  if (parser.options.directSourceFile)
    { this.sourceFile = parser.options.directSourceFile; }
  if (parser.options.ranges)
    { this.range = [pos, 0]; }
};

// Start an AST node, attaching a start offset.

var pp$6 = Parser.prototype;

pp$6.startNode = function() {
  return new Node(this, this.start, this.startLoc)
};

pp$6.startNodeAt = function(pos, loc) {
  return new Node(this, pos, loc)
};

// Finish an AST node, adding `type` and `end` properties.

function finishNodeAt(node, type, pos, loc) {
  node.type = type;
  node.end = pos;
  if (this.options.locations)
    { node.loc.end = loc; }
  if (this.options.ranges)
    { node.range[1] = pos; }
  return node
}

pp$6.finishNode = function(node, type) {
  return finishNodeAt.call(this, node, type, this.lastTokEnd, this.lastTokEndLoc)
};

// Finish node at given position

pp$6.finishNodeAt = function(node, type, pos, loc) {
  return finishNodeAt.call(this, node, type, pos, loc)
};

// The algorithm used to determine whether a regexp can appear at a
// given point in the program is loosely based on sweet.js' approach.
// See https://github.com/mozilla/sweet.js/wiki/design

var TokContext = function TokContext(token, isExpr, preserveSpace, override, generator) {
  this.token = token;
  this.isExpr = !!isExpr;
  this.preserveSpace = !!preserveSpace;
  this.override = override;
  this.generator = !!generator;
};

var types$1 = {
  b_stat: new TokContext("{", false),
  b_expr: new TokContext("{", true),
  b_tmpl: new TokContext("${", false),
  p_stat: new TokContext("(", false),
  p_expr: new TokContext("(", true),
  q_tmpl: new TokContext("`", true, true, function (p) { return p.tryReadTemplateToken(); }),
  f_stat: new TokContext("function", false),
  f_expr: new TokContext("function", true),
  f_expr_gen: new TokContext("function", true, false, null, true),
  f_gen: new TokContext("function", false, false, null, true)
};

var pp$7 = Parser.prototype;

pp$7.initialContext = function() {
  return [types$1.b_stat]
};

pp$7.braceIsBlock = function(prevType) {
  var parent = this.curContext();
  if (parent === types$1.f_expr || parent === types$1.f_stat)
    { return true }
  if (prevType === types.colon && (parent === types$1.b_stat || parent === types$1.b_expr))
    { return !parent.isExpr }

  // The check for `tt.name && exprAllowed` detects whether we are
  // after a `yield` or `of` construct. See the `updateContext` for
  // `tt.name`.
  if (prevType === types._return || prevType === types.name && this.exprAllowed)
    { return lineBreak.test(this.input.slice(this.lastTokEnd, this.start)) }
  if (prevType === types._else || prevType === types.semi || prevType === types.eof || prevType === types.parenR || prevType === types.arrow)
    { return true }
  if (prevType === types.braceL)
    { return parent === types$1.b_stat }
  if (prevType === types._var || prevType === types.name)
    { return false }
  return !this.exprAllowed
};

pp$7.inGeneratorContext = function() {
  var this$1 = this;

  for (var i = this.context.length - 1; i >= 1; i--) {
    var context = this$1.context[i];
    if (context.token === "function")
      { return context.generator }
  }
  return false
};

pp$7.updateContext = function(prevType) {
  var update, type = this.type;
  if (type.keyword && prevType === types.dot)
    { this.exprAllowed = false; }
  else if (update = type.updateContext)
    { update.call(this, prevType); }
  else
    { this.exprAllowed = type.beforeExpr; }
};

// Token-specific context update code

types.parenR.updateContext = types.braceR.updateContext = function() {
  if (this.context.length === 1) {
    this.exprAllowed = true;
    return
  }
  var out = this.context.pop();
  if (out === types$1.b_stat && this.curContext().token === "function") {
    out = this.context.pop();
  }
  this.exprAllowed = !out.isExpr;
};

types.braceL.updateContext = function(prevType) {
  this.context.push(this.braceIsBlock(prevType) ? types$1.b_stat : types$1.b_expr);
  this.exprAllowed = true;
};

types.dollarBraceL.updateContext = function() {
  this.context.push(types$1.b_tmpl);
  this.exprAllowed = true;
};

types.parenL.updateContext = function(prevType) {
  var statementParens = prevType === types._if || prevType === types._for || prevType === types._with || prevType === types._while;
  this.context.push(statementParens ? types$1.p_stat : types$1.p_expr);
  this.exprAllowed = true;
};

types.incDec.updateContext = function() {
  // tokExprAllowed stays unchanged
};

types._function.updateContext = types._class.updateContext = function(prevType) {
  if (prevType.beforeExpr && prevType !== types.semi && prevType !== types._else &&
      !((prevType === types.colon || prevType === types.braceL) && this.curContext() === types$1.b_stat))
    { this.context.push(types$1.f_expr); }
  else
    { this.context.push(types$1.f_stat); }
  this.exprAllowed = false;
};

types.backQuote.updateContext = function() {
  if (this.curContext() === types$1.q_tmpl)
    { this.context.pop(); }
  else
    { this.context.push(types$1.q_tmpl); }
  this.exprAllowed = false;
};

types.star.updateContext = function(prevType) {
  if (prevType === types._function) {
    var index = this.context.length - 1;
    if (this.context[index] === types$1.f_expr)
      { this.context[index] = types$1.f_expr_gen; }
    else
      { this.context[index] = types$1.f_gen; }
  }
  this.exprAllowed = true;
};

types.name.updateContext = function(prevType) {
  var allowed = false;
  if (this.options.ecmaVersion >= 6 && prevType !== types.dot) {
    if (this.value === "of" && !this.exprAllowed ||
        this.value === "yield" && this.inGeneratorContext())
      { allowed = true; }
  }
  this.exprAllowed = allowed;
};

var data = {
  "$LONE": [
    "ASCII",
    "ASCII_Hex_Digit",
    "AHex",
    "Alphabetic",
    "Alpha",
    "Any",
    "Assigned",
    "Bidi_Control",
    "Bidi_C",
    "Bidi_Mirrored",
    "Bidi_M",
    "Case_Ignorable",
    "CI",
    "Cased",
    "Changes_When_Casefolded",
    "CWCF",
    "Changes_When_Casemapped",
    "CWCM",
    "Changes_When_Lowercased",
    "CWL",
    "Changes_When_NFKC_Casefolded",
    "CWKCF",
    "Changes_When_Titlecased",
    "CWT",
    "Changes_When_Uppercased",
    "CWU",
    "Dash",
    "Default_Ignorable_Code_Point",
    "DI",
    "Deprecated",
    "Dep",
    "Diacritic",
    "Dia",
    "Emoji",
    "Emoji_Component",
    "Emoji_Modifier",
    "Emoji_Modifier_Base",
    "Emoji_Presentation",
    "Extender",
    "Ext",
    "Grapheme_Base",
    "Gr_Base",
    "Grapheme_Extend",
    "Gr_Ext",
    "Hex_Digit",
    "Hex",
    "IDS_Binary_Operator",
    "IDSB",
    "IDS_Trinary_Operator",
    "IDST",
    "ID_Continue",
    "IDC",
    "ID_Start",
    "IDS",
    "Ideographic",
    "Ideo",
    "Join_Control",
    "Join_C",
    "Logical_Order_Exception",
    "LOE",
    "Lowercase",
    "Lower",
    "Math",
    "Noncharacter_Code_Point",
    "NChar",
    "Pattern_Syntax",
    "Pat_Syn",
    "Pattern_White_Space",
    "Pat_WS",
    "Quotation_Mark",
    "QMark",
    "Radical",
    "Regional_Indicator",
    "RI",
    "Sentence_Terminal",
    "STerm",
    "Soft_Dotted",
    "SD",
    "Terminal_Punctuation",
    "Term",
    "Unified_Ideograph",
    "UIdeo",
    "Uppercase",
    "Upper",
    "Variation_Selector",
    "VS",
    "White_Space",
    "space",
    "XID_Continue",
    "XIDC",
    "XID_Start",
    "XIDS"
  ],
  "General_Category": [
    "Cased_Letter",
    "LC",
    "Close_Punctuation",
    "Pe",
    "Connector_Punctuation",
    "Pc",
    "Control",
    "Cc",
    "cntrl",
    "Currency_Symbol",
    "Sc",
    "Dash_Punctuation",
    "Pd",
    "Decimal_Number",
    "Nd",
    "digit",
    "Enclosing_Mark",
    "Me",
    "Final_Punctuation",
    "Pf",
    "Format",
    "Cf",
    "Initial_Punctuation",
    "Pi",
    "Letter",
    "L",
    "Letter_Number",
    "Nl",
    "Line_Separator",
    "Zl",
    "Lowercase_Letter",
    "Ll",
    "Mark",
    "M",
    "Combining_Mark",
    "Math_Symbol",
    "Sm",
    "Modifier_Letter",
    "Lm",
    "Modifier_Symbol",
    "Sk",
    "Nonspacing_Mark",
    "Mn",
    "Number",
    "N",
    "Open_Punctuation",
    "Ps",
    "Other",
    "C",
    "Other_Letter",
    "Lo",
    "Other_Number",
    "No",
    "Other_Punctuation",
    "Po",
    "Other_Symbol",
    "So",
    "Paragraph_Separator",
    "Zp",
    "Private_Use",
    "Co",
    "Punctuation",
    "P",
    "punct",
    "Separator",
    "Z",
    "Space_Separator",
    "Zs",
    "Spacing_Mark",
    "Mc",
    "Surrogate",
    "Cs",
    "Symbol",
    "S",
    "Titlecase_Letter",
    "Lt",
    "Unassigned",
    "Cn",
    "Uppercase_Letter",
    "Lu"
  ],
  "Script": [
    "Adlam",
    "Adlm",
    "Ahom",
    "Anatolian_Hieroglyphs",
    "Hluw",
    "Arabic",
    "Arab",
    "Armenian",
    "Armn",
    "Avestan",
    "Avst",
    "Balinese",
    "Bali",
    "Bamum",
    "Bamu",
    "Bassa_Vah",
    "Bass",
    "Batak",
    "Batk",
    "Bengali",
    "Beng",
    "Bhaiksuki",
    "Bhks",
    "Bopomofo",
    "Bopo",
    "Brahmi",
    "Brah",
    "Braille",
    "Brai",
    "Buginese",
    "Bugi",
    "Buhid",
    "Buhd",
    "Canadian_Aboriginal",
    "Cans",
    "Carian",
    "Cari",
    "Caucasian_Albanian",
    "Aghb",
    "Chakma",
    "Cakm",
    "Cham",
    "Cherokee",
    "Cher",
    "Common",
    "Zyyy",
    "Coptic",
    "Copt",
    "Qaac",
    "Cuneiform",
    "Xsux",
    "Cypriot",
    "Cprt",
    "Cyrillic",
    "Cyrl",
    "Deseret",
    "Dsrt",
    "Devanagari",
    "Deva",
    "Duployan",
    "Dupl",
    "Egyptian_Hieroglyphs",
    "Egyp",
    "Elbasan",
    "Elba",
    "Ethiopic",
    "Ethi",
    "Georgian",
    "Geor",
    "Glagolitic",
    "Glag",
    "Gothic",
    "Goth",
    "Grantha",
    "Gran",
    "Greek",
    "Grek",
    "Gujarati",
    "Gujr",
    "Gurmukhi",
    "Guru",
    "Han",
    "Hani",
    "Hangul",
    "Hang",
    "Hanunoo",
    "Hano",
    "Hatran",
    "Hatr",
    "Hebrew",
    "Hebr",
    "Hiragana",
    "Hira",
    "Imperial_Aramaic",
    "Armi",
    "Inherited",
    "Zinh",
    "Qaai",
    "Inscriptional_Pahlavi",
    "Phli",
    "Inscriptional_Parthian",
    "Prti",
    "Javanese",
    "Java",
    "Kaithi",
    "Kthi",
    "Kannada",
    "Knda",
    "Katakana",
    "Kana",
    "Kayah_Li",
    "Kali",
    "Kharoshthi",
    "Khar",
    "Khmer",
    "Khmr",
    "Khojki",
    "Khoj",
    "Khudawadi",
    "Sind",
    "Lao",
    "Laoo",
    "Latin",
    "Latn",
    "Lepcha",
    "Lepc",
    "Limbu",
    "Limb",
    "Linear_A",
    "Lina",
    "Linear_B",
    "Linb",
    "Lisu",
    "Lycian",
    "Lyci",
    "Lydian",
    "Lydi",
    "Mahajani",
    "Mahj",
    "Malayalam",
    "Mlym",
    "Mandaic",
    "Mand",
    "Manichaean",
    "Mani",
    "Marchen",
    "Marc",
    "Masaram_Gondi",
    "Gonm",
    "Meetei_Mayek",
    "Mtei",
    "Mende_Kikakui",
    "Mend",
    "Meroitic_Cursive",
    "Merc",
    "Meroitic_Hieroglyphs",
    "Mero",
    "Miao",
    "Plrd",
    "Modi",
    "Mongolian",
    "Mong",
    "Mro",
    "Mroo",
    "Multani",
    "Mult",
    "Myanmar",
    "Mymr",
    "Nabataean",
    "Nbat",
    "New_Tai_Lue",
    "Talu",
    "Newa",
    "Nko",
    "Nkoo",
    "Nushu",
    "Nshu",
    "Ogham",
    "Ogam",
    "Ol_Chiki",
    "Olck",
    "Old_Hungarian",
    "Hung",
    "Old_Italic",
    "Ital",
    "Old_North_Arabian",
    "Narb",
    "Old_Permic",
    "Perm",
    "Old_Persian",
    "Xpeo",
    "Old_South_Arabian",
    "Sarb",
    "Old_Turkic",
    "Orkh",
    "Oriya",
    "Orya",
    "Osage",
    "Osge",
    "Osmanya",
    "Osma",
    "Pahawh_Hmong",
    "Hmng",
    "Palmyrene",
    "Palm",
    "Pau_Cin_Hau",
    "Pauc",
    "Phags_Pa",
    "Phag",
    "Phoenician",
    "Phnx",
    "Psalter_Pahlavi",
    "Phlp",
    "Rejang",
    "Rjng",
    "Runic",
    "Runr",
    "Samaritan",
    "Samr",
    "Saurashtra",
    "Saur",
    "Sharada",
    "Shrd",
    "Shavian",
    "Shaw",
    "Siddham",
    "Sidd",
    "SignWriting",
    "Sgnw",
    "Sinhala",
    "Sinh",
    "Sora_Sompeng",
    "Sora",
    "Soyombo",
    "Soyo",
    "Sundanese",
    "Sund",
    "Syloti_Nagri",
    "Sylo",
    "Syriac",
    "Syrc",
    "Tagalog",
    "Tglg",
    "Tagbanwa",
    "Tagb",
    "Tai_Le",
    "Tale",
    "Tai_Tham",
    "Lana",
    "Tai_Viet",
    "Tavt",
    "Takri",
    "Takr",
    "Tamil",
    "Taml",
    "Tangut",
    "Tang",
    "Telugu",
    "Telu",
    "Thaana",
    "Thaa",
    "Thai",
    "Tibetan",
    "Tibt",
    "Tifinagh",
    "Tfng",
    "Tirhuta",
    "Tirh",
    "Ugaritic",
    "Ugar",
    "Vai",
    "Vaii",
    "Warang_Citi",
    "Wara",
    "Yi",
    "Yiii",
    "Zanabazar_Square",
    "Zanb"
  ]
};
Array.prototype.push.apply(data.$LONE, data.General_Category);
data.gc = data.General_Category;
data.sc = data.Script_Extensions = data.scx = data.Script;

var pp$9 = Parser.prototype;

var RegExpValidationState = function RegExpValidationState(parser) {
  this.parser = parser;
  this.validFlags = "gim" + (parser.options.ecmaVersion >= 6 ? "uy" : "") + (parser.options.ecmaVersion >= 9 ? "s" : "");
  this.source = "";
  this.flags = "";
  this.start = 0;
  this.switchU = false;
  this.switchN = false;
  this.pos = 0;
  this.lastIntValue = 0;
  this.lastStringValue = "";
  this.lastAssertionIsQuantifiable = false;
  this.numCapturingParens = 0;
  this.maxBackReference = 0;
  this.groupNames = [];
  this.backReferenceNames = [];
};

RegExpValidationState.prototype.reset = function reset (start, pattern, flags) {
  var unicode = flags.indexOf("u") !== -1;
  this.start = start | 0;
  this.source = pattern + "";
  this.flags = flags;
  this.switchU = unicode && this.parser.options.ecmaVersion >= 6;
  this.switchN = unicode && this.parser.options.ecmaVersion >= 9;
};

RegExpValidationState.prototype.raise = function raise (message) {
  this.parser.raiseRecoverable(this.start, ("Invalid regular expression: /" + (this.source) + "/: " + message));
};

// If u flag is given, this returns the code point at the index (it combines a surrogate pair).
// Otherwise, this returns the code unit of the index (can be a part of a surrogate pair).
RegExpValidationState.prototype.at = function at (i) {
  var s = this.source;
  var l = s.length;
  if (i >= l) {
    return -1
  }
  var c = s.charCodeAt(i);
  if (!this.switchU || c <= 0xD7FF || c >= 0xE000 || i + 1 >= l) {
    return c
  }
  var next = s.charCodeAt(i + 1);
  return next >= 0xDC00 && next <= 0xDFFF ? (c << 10) + next - 0x35FDC00 : c
};

RegExpValidationState.prototype.nextIndex = function nextIndex (i) {
  var s = this.source;
  var l = s.length;
  if (i >= l) {
    return l
  }
  var c = s.charCodeAt(i), next;
  if (!this.switchU || c <= 0xD7FF || c >= 0xE000 || i + 1 >= l ||
      (next = s.charCodeAt(i + 1)) < 0xDC00 || next > 0xDFFF) {
    return i + 1
  }
  return i + 2
};

RegExpValidationState.prototype.current = function current () {
  return this.at(this.pos)
};

RegExpValidationState.prototype.lookahead = function lookahead () {
  return this.at(this.nextIndex(this.pos))
};

RegExpValidationState.prototype.advance = function advance () {
  this.pos = this.nextIndex(this.pos);
};

RegExpValidationState.prototype.eat = function eat (ch) {
  if (this.current() === ch) {
    this.advance();
    return true
  }
  return false
};

function codePointToString$1(ch) {
  if (ch <= 0xFFFF) { return String.fromCharCode(ch) }
  ch -= 0x10000;
  return String.fromCharCode((ch >> 10) + 0xD800, (ch & 0x03FF) + 0xDC00)
}

/**
 * Validate the flags part of a given RegExpLiteral.
 *
 * @param {RegExpValidationState} state The state to validate RegExp.
 * @returns {void}
 */
pp$9.validateRegExpFlags = function(state) {
  var this$1 = this;

  var validFlags = state.validFlags;
  var flags = state.flags;

  for (var i = 0; i < flags.length; i++) {
    var flag = flags.charAt(i);
    if (validFlags.indexOf(flag) === -1) {
      this$1.raise(state.start, "Invalid regular expression flag");
    }
    if (flags.indexOf(flag, i + 1) > -1) {
      this$1.raise(state.start, "Duplicate regular expression flag");
    }
  }
};

/**
 * Validate the pattern part of a given RegExpLiteral.
 *
 * @param {RegExpValidationState} state The state to validate RegExp.
 * @returns {void}
 */
pp$9.validateRegExpPattern = function(state) {
  this.regexp_pattern(state);

  // The goal symbol for the parse is |Pattern[~U, ~N]|. If the result of
  // parsing contains a |GroupName|, reparse with the goal symbol
  // |Pattern[~U, +N]| and use this result instead. Throw a *SyntaxError*
  // exception if _P_ did not conform to the grammar, if any elements of _P_
  // were not matched by the parse, or if any Early Error conditions exist.
  if (!state.switchN && this.options.ecmaVersion >= 9 && state.groupNames.length > 0) {
    state.switchN = true;
    this.regexp_pattern(state);
  }
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-Pattern
pp$9.regexp_pattern = function(state) {
  state.pos = 0;
  state.lastIntValue = 0;
  state.lastStringValue = "";
  state.lastAssertionIsQuantifiable = false;
  state.numCapturingParens = 0;
  state.maxBackReference = 0;
  state.groupNames.length = 0;
  state.backReferenceNames.length = 0;

  this.regexp_disjunction(state);

  if (state.pos !== state.source.length) {
    // Make the same messages as V8.
    if (state.eat(0x29 /* ) */)) {
      state.raise("Unmatched ')'");
    }
    if (state.eat(0x5D /* [ */) || state.eat(0x7D /* } */)) {
      state.raise("Lone quantifier brackets");
    }
  }
  if (state.maxBackReference > state.numCapturingParens) {
    state.raise("Invalid escape");
  }
  for (var i = 0, list = state.backReferenceNames; i < list.length; i += 1) {
    var name = list[i];

    if (state.groupNames.indexOf(name) === -1) {
      state.raise("Invalid named capture referenced");
    }
  }
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-Disjunction
pp$9.regexp_disjunction = function(state) {
  var this$1 = this;

  this.regexp_alternative(state);
  while (state.eat(0x7C /* | */)) {
    this$1.regexp_alternative(state);
  }

  // Make the same message as V8.
  if (this.regexp_eatQuantifier(state, true)) {
    state.raise("Nothing to repeat");
  }
  if (state.eat(0x7B /* { */)) {
    state.raise("Lone quantifier brackets");
  }
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-Alternative
pp$9.regexp_alternative = function(state) {
  while (state.pos < state.source.length && this.regexp_eatTerm(state))
    {  }
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-Term
pp$9.regexp_eatTerm = function(state) {
  if (this.regexp_eatAssertion(state)) {
    // Handle `QuantifiableAssertion Quantifier` alternative.
    // `state.lastAssertionIsQuantifiable` is true if the last eaten Assertion
    // is a QuantifiableAssertion.
    if (state.lastAssertionIsQuantifiable && this.regexp_eatQuantifier(state)) {
      // Make the same message as V8.
      if (state.switchU) {
        state.raise("Invalid quantifier");
      }
    }
    return true
  }

  if (state.switchU ? this.regexp_eatAtom(state) : this.regexp_eatExtendedAtom(state)) {
    this.regexp_eatQuantifier(state);
    return true
  }

  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-Assertion
pp$9.regexp_eatAssertion = function(state) {
  var start = state.pos;
  state.lastAssertionIsQuantifiable = false;

  // ^, $
  if (state.eat(0x5E /* ^ */) || state.eat(0x24 /* $ */)) {
    return true
  }

  // \b \B
  if (state.eat(0x5C /* \ */)) {
    if (state.eat(0x42 /* B */) || state.eat(0x62 /* b */)) {
      return true
    }
    state.pos = start;
  }

  // Lookahead / Lookbehind
  if (state.eat(0x28 /* ( */) && state.eat(0x3F /* ? */)) {
    var lookbehind = false;
    if (this.options.ecmaVersion >= 9) {
      lookbehind = state.eat(0x3C /* < */);
    }
    if (state.eat(0x3D /* = */) || state.eat(0x21 /* ! */)) {
      this.regexp_disjunction(state);
      if (!state.eat(0x29 /* ) */)) {
        state.raise("Unterminated group");
      }
      state.lastAssertionIsQuantifiable = !lookbehind;
      return true
    }
  }

  state.pos = start;
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-Quantifier
pp$9.regexp_eatQuantifier = function(state, noError) {
  if ( noError === void 0 ) noError = false;

  if (this.regexp_eatQuantifierPrefix(state, noError)) {
    state.eat(0x3F /* ? */);
    return true
  }
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-QuantifierPrefix
pp$9.regexp_eatQuantifierPrefix = function(state, noError) {
  return (
    state.eat(0x2A /* * */) ||
    state.eat(0x2B /* + */) ||
    state.eat(0x3F /* ? */) ||
    this.regexp_eatBracedQuantifier(state, noError)
  )
};
pp$9.regexp_eatBracedQuantifier = function(state, noError) {
  var start = state.pos;
  if (state.eat(0x7B /* { */)) {
    var min = 0, max = -1;
    if (this.regexp_eatDecimalDigits(state)) {
      min = state.lastIntValue;
      if (state.eat(0x2C /* , */) && this.regexp_eatDecimalDigits(state)) {
        max = state.lastIntValue;
      }
      if (state.eat(0x7D /* } */)) {
        // SyntaxError in https://www.ecma-international.org/ecma-262/8.0/#sec-term
        if (max !== -1 && max < min && !noError) {
          state.raise("numbers out of order in {} quantifier");
        }
        return true
      }
    }
    if (state.switchU && !noError) {
      state.raise("Incomplete quantifier");
    }
    state.pos = start;
  }
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-Atom
pp$9.regexp_eatAtom = function(state) {
  return (
    this.regexp_eatPatternCharacters(state) ||
    state.eat(0x2E /* . */) ||
    this.regexp_eatReverseSolidusAtomEscape(state) ||
    this.regexp_eatCharacterClass(state) ||
    this.regexp_eatUncapturingGroup(state) ||
    this.regexp_eatCapturingGroup(state)
  )
};
pp$9.regexp_eatReverseSolidusAtomEscape = function(state) {
  var start = state.pos;
  if (state.eat(0x5C /* \ */)) {
    if (this.regexp_eatAtomEscape(state)) {
      return true
    }
    state.pos = start;
  }
  return false
};
pp$9.regexp_eatUncapturingGroup = function(state) {
  var start = state.pos;
  if (state.eat(0x28 /* ( */)) {
    if (state.eat(0x3F /* ? */) && state.eat(0x3A /* : */)) {
      this.regexp_disjunction(state);
      if (state.eat(0x29 /* ) */)) {
        return true
      }
      state.raise("Unterminated group");
    }
    state.pos = start;
  }
  return false
};
pp$9.regexp_eatCapturingGroup = function(state) {
  if (state.eat(0x28 /* ( */)) {
    if (this.options.ecmaVersion >= 9) {
      this.regexp_groupSpecifier(state);
    } else if (state.current() === 0x3F /* ? */) {
      state.raise("Invalid group");
    }
    this.regexp_disjunction(state);
    if (state.eat(0x29 /* ) */)) {
      state.numCapturingParens += 1;
      return true
    }
    state.raise("Unterminated group");
  }
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-ExtendedAtom
pp$9.regexp_eatExtendedAtom = function(state) {
  return (
    state.eat(0x2E /* . */) ||
    this.regexp_eatReverseSolidusAtomEscape(state) ||
    this.regexp_eatCharacterClass(state) ||
    this.regexp_eatUncapturingGroup(state) ||
    this.regexp_eatCapturingGroup(state) ||
    this.regexp_eatInvalidBracedQuantifier(state) ||
    this.regexp_eatExtendedPatternCharacter(state)
  )
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-InvalidBracedQuantifier
pp$9.regexp_eatInvalidBracedQuantifier = function(state) {
  if (this.regexp_eatBracedQuantifier(state, true)) {
    state.raise("Nothing to repeat");
  }
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-SyntaxCharacter
pp$9.regexp_eatSyntaxCharacter = function(state) {
  var ch = state.current();
  if (isSyntaxCharacter(ch)) {
    state.lastIntValue = ch;
    state.advance();
    return true
  }
  return false
};
function isSyntaxCharacter(ch) {
  return (
    ch === 0x24 /* $ */ ||
    ch >= 0x28 /* ( */ && ch <= 0x2B /* + */ ||
    ch === 0x2E /* . */ ||
    ch === 0x3F /* ? */ ||
    ch >= 0x5B /* [ */ && ch <= 0x5E /* ^ */ ||
    ch >= 0x7B /* { */ && ch <= 0x7D /* } */
  )
}

// https://www.ecma-international.org/ecma-262/8.0/#prod-PatternCharacter
// But eat eager.
pp$9.regexp_eatPatternCharacters = function(state) {
  var start = state.pos;
  var ch = 0;
  while ((ch = state.current()) !== -1 && !isSyntaxCharacter(ch)) {
    state.advance();
  }
  return state.pos !== start
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-ExtendedPatternCharacter
pp$9.regexp_eatExtendedPatternCharacter = function(state) {
  var ch = state.current();
  if (
    ch !== -1 &&
    ch !== 0x24 /* $ */ &&
    !(ch >= 0x28 /* ( */ && ch <= 0x2B /* + */) &&
    ch !== 0x2E /* . */ &&
    ch !== 0x3F /* ? */ &&
    ch !== 0x5B /* [ */ &&
    ch !== 0x5E /* ^ */ &&
    ch !== 0x7C /* | */
  ) {
    state.advance();
    return true
  }
  return false
};

// GroupSpecifier[U] ::
//   [empty]
//   `?` GroupName[?U]
pp$9.regexp_groupSpecifier = function(state) {
  if (state.eat(0x3F /* ? */)) {
    if (this.regexp_eatGroupName(state)) {
      if (state.groupNames.indexOf(state.lastStringValue) !== -1) {
        state.raise("Duplicate capture group name");
      }
      state.groupNames.push(state.lastStringValue);
      return
    }
    state.raise("Invalid group");
  }
};

// GroupName[U] ::
//   `<` RegExpIdentifierName[?U] `>`
// Note: this updates `state.lastStringValue` property with the eaten name.
pp$9.regexp_eatGroupName = function(state) {
  state.lastStringValue = "";
  if (state.eat(0x3C /* < */)) {
    if (this.regexp_eatRegExpIdentifierName(state) && state.eat(0x3E /* > */)) {
      return true
    }
    state.raise("Invalid capture group name");
  }
  return false
};

// RegExpIdentifierName[U] ::
//   RegExpIdentifierStart[?U]
//   RegExpIdentifierName[?U] RegExpIdentifierPart[?U]
// Note: this updates `state.lastStringValue` property with the eaten name.
pp$9.regexp_eatRegExpIdentifierName = function(state) {
  state.lastStringValue = "";
  if (this.regexp_eatRegExpIdentifierStart(state)) {
    state.lastStringValue += codePointToString$1(state.lastIntValue);
    while (this.regexp_eatRegExpIdentifierPart(state)) {
      state.lastStringValue += codePointToString$1(state.lastIntValue);
    }
    return true
  }
  return false
};

// RegExpIdentifierStart[U] ::
//   UnicodeIDStart
//   `$`
//   `_`
//   `\` RegExpUnicodeEscapeSequence[?U]
pp$9.regexp_eatRegExpIdentifierStart = function(state) {
  var start = state.pos;
  var ch = state.current();
  state.advance();

  if (ch === 0x5C /* \ */ && this.regexp_eatRegExpUnicodeEscapeSequence(state)) {
    ch = state.lastIntValue;
  }
  if (isRegExpIdentifierStart(ch)) {
    state.lastIntValue = ch;
    return true
  }

  state.pos = start;
  return false
};
function isRegExpIdentifierStart(ch) {
  return isIdentifierStart(ch, true) || ch === 0x24 /* $ */ || ch === 0x5F /* _ */
}

// RegExpIdentifierPart[U] ::
//   UnicodeIDContinue
//   `$`
//   `_`
//   `\` RegExpUnicodeEscapeSequence[?U]
//   <ZWNJ>
//   <ZWJ>
pp$9.regexp_eatRegExpIdentifierPart = function(state) {
  var start = state.pos;
  var ch = state.current();
  state.advance();

  if (ch === 0x5C /* \ */ && this.regexp_eatRegExpUnicodeEscapeSequence(state)) {
    ch = state.lastIntValue;
  }
  if (isRegExpIdentifierPart(ch)) {
    state.lastIntValue = ch;
    return true
  }

  state.pos = start;
  return false
};
function isRegExpIdentifierPart(ch) {
  return isIdentifierChar(ch, true) || ch === 0x24 /* $ */ || ch === 0x5F /* _ */ || ch === 0x200C /* <ZWNJ> */ || ch === 0x200D /* <ZWJ> */
}

// https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-AtomEscape
pp$9.regexp_eatAtomEscape = function(state) {
  if (
    this.regexp_eatBackReference(state) ||
    this.regexp_eatCharacterClassEscape(state) ||
    this.regexp_eatCharacterEscape(state) ||
    (state.switchN && this.regexp_eatKGroupName(state))
  ) {
    return true
  }
  if (state.switchU) {
    // Make the same message as V8.
    if (state.current() === 0x63 /* c */) {
      state.raise("Invalid unicode escape");
    }
    state.raise("Invalid escape");
  }
  return false
};
pp$9.regexp_eatBackReference = function(state) {
  var start = state.pos;
  if (this.regexp_eatDecimalEscape(state)) {
    var n = state.lastIntValue;
    if (state.switchU) {
      // For SyntaxError in https://www.ecma-international.org/ecma-262/8.0/#sec-atomescape
      if (n > state.maxBackReference) {
        state.maxBackReference = n;
      }
      return true
    }
    if (n <= state.numCapturingParens) {
      return true
    }
    state.pos = start;
  }
  return false
};
pp$9.regexp_eatKGroupName = function(state) {
  if (state.eat(0x6B /* k */)) {
    if (this.regexp_eatGroupName(state)) {
      state.backReferenceNames.push(state.lastStringValue);
      return true
    }
    state.raise("Invalid named reference");
  }
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-CharacterEscape
pp$9.regexp_eatCharacterEscape = function(state) {
  return (
    this.regexp_eatControlEscape(state) ||
    this.regexp_eatCControlLetter(state) ||
    this.regexp_eatZero(state) ||
    this.regexp_eatHexEscapeSequence(state) ||
    this.regexp_eatRegExpUnicodeEscapeSequence(state) ||
    (!state.switchU && this.regexp_eatLegacyOctalEscapeSequence(state)) ||
    this.regexp_eatIdentityEscape(state)
  )
};
pp$9.regexp_eatCControlLetter = function(state) {
  var start = state.pos;
  if (state.eat(0x63 /* c */)) {
    if (this.regexp_eatControlLetter(state)) {
      return true
    }
    state.pos = start;
  }
  return false
};
pp$9.regexp_eatZero = function(state) {
  if (state.current() === 0x30 /* 0 */ && !isDecimalDigit(state.lookahead())) {
    state.lastIntValue = 0;
    state.advance();
    return true
  }
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-ControlEscape
pp$9.regexp_eatControlEscape = function(state) {
  var ch = state.current();
  if (ch === 0x74 /* t */) {
    state.lastIntValue = 0x09; /* \t */
    state.advance();
    return true
  }
  if (ch === 0x6E /* n */) {
    state.lastIntValue = 0x0A; /* \n */
    state.advance();
    return true
  }
  if (ch === 0x76 /* v */) {
    state.lastIntValue = 0x0B; /* \v */
    state.advance();
    return true
  }
  if (ch === 0x66 /* f */) {
    state.lastIntValue = 0x0C; /* \f */
    state.advance();
    return true
  }
  if (ch === 0x72 /* r */) {
    state.lastIntValue = 0x0D; /* \r */
    state.advance();
    return true
  }
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-ControlLetter
pp$9.regexp_eatControlLetter = function(state) {
  var ch = state.current();
  if (isControlLetter(ch)) {
    state.lastIntValue = ch % 0x20;
    state.advance();
    return true
  }
  return false
};
function isControlLetter(ch) {
  return (
    (ch >= 0x41 /* A */ && ch <= 0x5A /* Z */) ||
    (ch >= 0x61 /* a */ && ch <= 0x7A /* z */)
  )
}

// https://www.ecma-international.org/ecma-262/8.0/#prod-RegExpUnicodeEscapeSequence
pp$9.regexp_eatRegExpUnicodeEscapeSequence = function(state) {
  var start = state.pos;

  if (state.eat(0x75 /* u */)) {
    if (this.regexp_eatFixedHexDigits(state, 4)) {
      var lead = state.lastIntValue;
      if (state.switchU && lead >= 0xD800 && lead <= 0xDBFF) {
        var leadSurrogateEnd = state.pos;
        if (state.eat(0x5C /* \ */) && state.eat(0x75 /* u */) && this.regexp_eatFixedHexDigits(state, 4)) {
          var trail = state.lastIntValue;
          if (trail >= 0xDC00 && trail <= 0xDFFF) {
            state.lastIntValue = (lead - 0xD800) * 0x400 + (trail - 0xDC00) + 0x10000;
            return true
          }
        }
        state.pos = leadSurrogateEnd;
        state.lastIntValue = lead;
      }
      return true
    }
    if (
      state.switchU &&
      state.eat(0x7B /* { */) &&
      this.regexp_eatHexDigits(state) &&
      state.eat(0x7D /* } */) &&
      isValidUnicode(state.lastIntValue)
    ) {
      return true
    }
    if (state.switchU) {
      state.raise("Invalid unicode escape");
    }
    state.pos = start;
  }

  return false
};
function isValidUnicode(ch) {
  return ch >= 0 && ch <= 0x10FFFF
}

// https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-IdentityEscape
pp$9.regexp_eatIdentityEscape = function(state) {
  if (state.switchU) {
    if (this.regexp_eatSyntaxCharacter(state)) {
      return true
    }
    if (state.eat(0x2F /* / */)) {
      state.lastIntValue = 0x2F; /* / */
      return true
    }
    return false
  }

  var ch = state.current();
  if (ch !== 0x63 /* c */ && (!state.switchN || ch !== 0x6B /* k */)) {
    state.lastIntValue = ch;
    state.advance();
    return true
  }

  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-DecimalEscape
pp$9.regexp_eatDecimalEscape = function(state) {
  state.lastIntValue = 0;
  var ch = state.current();
  if (ch >= 0x31 /* 1 */ && ch <= 0x39 /* 9 */) {
    do {
      state.lastIntValue = 10 * state.lastIntValue + (ch - 0x30 /* 0 */);
      state.advance();
    } while ((ch = state.current()) >= 0x30 /* 0 */ && ch <= 0x39 /* 9 */)
    return true
  }
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-CharacterClassEscape
pp$9.regexp_eatCharacterClassEscape = function(state) {
  var ch = state.current();

  if (isCharacterClassEscape(ch)) {
    state.lastIntValue = -1;
    state.advance();
    return true
  }

  if (
    state.switchU &&
    this.options.ecmaVersion >= 9 &&
    (ch === 0x50 /* P */ || ch === 0x70 /* p */)
  ) {
    state.lastIntValue = -1;
    state.advance();
    if (
      state.eat(0x7B /* { */) &&
      this.regexp_eatUnicodePropertyValueExpression(state) &&
      state.eat(0x7D /* } */)
    ) {
      return true
    }
    state.raise("Invalid property name");
  }

  return false
};
function isCharacterClassEscape(ch) {
  return (
    ch === 0x64 /* d */ ||
    ch === 0x44 /* D */ ||
    ch === 0x73 /* s */ ||
    ch === 0x53 /* S */ ||
    ch === 0x77 /* w */ ||
    ch === 0x57 /* W */
  )
}

// UnicodePropertyValueExpression ::
//   UnicodePropertyName `=` UnicodePropertyValue
//   LoneUnicodePropertyNameOrValue
pp$9.regexp_eatUnicodePropertyValueExpression = function(state) {
  var start = state.pos;

  // UnicodePropertyName `=` UnicodePropertyValue
  if (this.regexp_eatUnicodePropertyName(state) && state.eat(0x3D /* = */)) {
    var name = state.lastStringValue;
    if (this.regexp_eatUnicodePropertyValue(state)) {
      var value = state.lastStringValue;
      this.regexp_validateUnicodePropertyNameAndValue(state, name, value);
      return true
    }
  }
  state.pos = start;

  // LoneUnicodePropertyNameOrValue
  if (this.regexp_eatLoneUnicodePropertyNameOrValue(state)) {
    var nameOrValue = state.lastStringValue;
    this.regexp_validateUnicodePropertyNameOrValue(state, nameOrValue);
    return true
  }
  return false
};
pp$9.regexp_validateUnicodePropertyNameAndValue = function(state, name, value) {
  if (!data.hasOwnProperty(name) || data[name].indexOf(value) === -1) {
    state.raise("Invalid property name");
  }
};
pp$9.regexp_validateUnicodePropertyNameOrValue = function(state, nameOrValue) {
  if (data.$LONE.indexOf(nameOrValue) === -1) {
    state.raise("Invalid property name");
  }
};

// UnicodePropertyName ::
//   UnicodePropertyNameCharacters
pp$9.regexp_eatUnicodePropertyName = function(state) {
  var ch = 0;
  state.lastStringValue = "";
  while (isUnicodePropertyNameCharacter(ch = state.current())) {
    state.lastStringValue += codePointToString$1(ch);
    state.advance();
  }
  return state.lastStringValue !== ""
};
function isUnicodePropertyNameCharacter(ch) {
  return isControlLetter(ch) || ch === 0x5F /* _ */
}

// UnicodePropertyValue ::
//   UnicodePropertyValueCharacters
pp$9.regexp_eatUnicodePropertyValue = function(state) {
  var ch = 0;
  state.lastStringValue = "";
  while (isUnicodePropertyValueCharacter(ch = state.current())) {
    state.lastStringValue += codePointToString$1(ch);
    state.advance();
  }
  return state.lastStringValue !== ""
};
function isUnicodePropertyValueCharacter(ch) {
  return isUnicodePropertyNameCharacter(ch) || isDecimalDigit(ch)
}

// LoneUnicodePropertyNameOrValue ::
//   UnicodePropertyValueCharacters
pp$9.regexp_eatLoneUnicodePropertyNameOrValue = function(state) {
  return this.regexp_eatUnicodePropertyValue(state)
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-CharacterClass
pp$9.regexp_eatCharacterClass = function(state) {
  if (state.eat(0x5B /* [ */)) {
    state.eat(0x5E /* ^ */);
    this.regexp_classRanges(state);
    if (state.eat(0x5D /* [ */)) {
      return true
    }
    // Unreachable since it threw "unterminated regular expression" error before.
    state.raise("Unterminated character class");
  }
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-ClassRanges
// https://www.ecma-international.org/ecma-262/8.0/#prod-NonemptyClassRanges
// https://www.ecma-international.org/ecma-262/8.0/#prod-NonemptyClassRangesNoDash
pp$9.regexp_classRanges = function(state) {
  var this$1 = this;

  while (this.regexp_eatClassAtom(state)) {
    var left = state.lastIntValue;
    if (state.eat(0x2D /* - */) && this$1.regexp_eatClassAtom(state)) {
      var right = state.lastIntValue;
      if (state.switchU && (left === -1 || right === -1)) {
        state.raise("Invalid character class");
      }
      if (left !== -1 && right !== -1 && left > right) {
        state.raise("Range out of order in character class");
      }
    }
  }
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-ClassAtom
// https://www.ecma-international.org/ecma-262/8.0/#prod-ClassAtomNoDash
pp$9.regexp_eatClassAtom = function(state) {
  var start = state.pos;

  if (state.eat(0x5C /* \ */)) {
    if (this.regexp_eatClassEscape(state)) {
      return true
    }
    if (state.switchU) {
      // Make the same message as V8.
      var ch$1 = state.current();
      if (ch$1 === 0x63 /* c */ || isOctalDigit(ch$1)) {
        state.raise("Invalid class escape");
      }
      state.raise("Invalid escape");
    }
    state.pos = start;
  }

  var ch = state.current();
  if (ch !== 0x5D /* [ */) {
    state.lastIntValue = ch;
    state.advance();
    return true
  }

  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-ClassEscape
pp$9.regexp_eatClassEscape = function(state) {
  var start = state.pos;

  if (state.eat(0x62 /* b */)) {
    state.lastIntValue = 0x08; /* <BS> */
    return true
  }

  if (state.switchU && state.eat(0x2D /* - */)) {
    state.lastIntValue = 0x2D; /* - */
    return true
  }

  if (!state.switchU && state.eat(0x63 /* c */)) {
    if (this.regexp_eatClassControlLetter(state)) {
      return true
    }
    state.pos = start;
  }

  return (
    this.regexp_eatCharacterClassEscape(state) ||
    this.regexp_eatCharacterEscape(state)
  )
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-ClassControlLetter
pp$9.regexp_eatClassControlLetter = function(state) {
  var ch = state.current();
  if (isDecimalDigit(ch) || ch === 0x5F /* _ */) {
    state.lastIntValue = ch % 0x20;
    state.advance();
    return true
  }
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-HexEscapeSequence
pp$9.regexp_eatHexEscapeSequence = function(state) {
  var start = state.pos;
  if (state.eat(0x78 /* x */)) {
    if (this.regexp_eatFixedHexDigits(state, 2)) {
      return true
    }
    if (state.switchU) {
      state.raise("Invalid escape");
    }
    state.pos = start;
  }
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-DecimalDigits
pp$9.regexp_eatDecimalDigits = function(state) {
  var start = state.pos;
  var ch = 0;
  state.lastIntValue = 0;
  while (isDecimalDigit(ch = state.current())) {
    state.lastIntValue = 10 * state.lastIntValue + (ch - 0x30 /* 0 */);
    state.advance();
  }
  return state.pos !== start
};
function isDecimalDigit(ch) {
  return ch >= 0x30 /* 0 */ && ch <= 0x39 /* 9 */
}

// https://www.ecma-international.org/ecma-262/8.0/#prod-HexDigits
pp$9.regexp_eatHexDigits = function(state) {
  var start = state.pos;
  var ch = 0;
  state.lastIntValue = 0;
  while (isHexDigit(ch = state.current())) {
    state.lastIntValue = 16 * state.lastIntValue + hexToInt(ch);
    state.advance();
  }
  return state.pos !== start
};
function isHexDigit(ch) {
  return (
    (ch >= 0x30 /* 0 */ && ch <= 0x39 /* 9 */) ||
    (ch >= 0x41 /* A */ && ch <= 0x46 /* F */) ||
    (ch >= 0x61 /* a */ && ch <= 0x66 /* f */)
  )
}
function hexToInt(ch) {
  if (ch >= 0x41 /* A */ && ch <= 0x46 /* F */) {
    return 10 + (ch - 0x41 /* A */)
  }
  if (ch >= 0x61 /* a */ && ch <= 0x66 /* f */) {
    return 10 + (ch - 0x61 /* a */)
  }
  return ch - 0x30 /* 0 */
}

// https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-LegacyOctalEscapeSequence
// Allows only 0-377(octal) i.e. 0-255(decimal).
pp$9.regexp_eatLegacyOctalEscapeSequence = function(state) {
  if (this.regexp_eatOctalDigit(state)) {
    var n1 = state.lastIntValue;
    if (this.regexp_eatOctalDigit(state)) {
      var n2 = state.lastIntValue;
      if (n1 <= 3 && this.regexp_eatOctalDigit(state)) {
        state.lastIntValue = n1 * 64 + n2 * 8 + state.lastIntValue;
      } else {
        state.lastIntValue = n1 * 8 + n2;
      }
    } else {
      state.lastIntValue = n1;
    }
    return true
  }
  return false
};

// https://www.ecma-international.org/ecma-262/8.0/#prod-OctalDigit
pp$9.regexp_eatOctalDigit = function(state) {
  var ch = state.current();
  if (isOctalDigit(ch)) {
    state.lastIntValue = ch - 0x30; /* 0 */
    state.advance();
    return true
  }
  state.lastIntValue = 0;
  return false
};
function isOctalDigit(ch) {
  return ch >= 0x30 /* 0 */ && ch <= 0x37 /* 7 */
}

// https://www.ecma-international.org/ecma-262/8.0/#prod-Hex4Digits
// https://www.ecma-international.org/ecma-262/8.0/#prod-HexDigit
// And HexDigit HexDigit in https://www.ecma-international.org/ecma-262/8.0/#prod-HexEscapeSequence
pp$9.regexp_eatFixedHexDigits = function(state, length) {
  var start = state.pos;
  state.lastIntValue = 0;
  for (var i = 0; i < length; ++i) {
    var ch = state.current();
    if (!isHexDigit(ch)) {
      state.pos = start;
      return false
    }
    state.lastIntValue = 16 * state.lastIntValue + hexToInt(ch);
    state.advance();
  }
  return true
};

// Object type used to represent tokens. Note that normally, tokens
// simply exist as properties on the parser object. This is only
// used for the onToken callback and the external tokenizer.

var Token = function Token(p) {
  this.type = p.type;
  this.value = p.value;
  this.start = p.start;
  this.end = p.end;
  if (p.options.locations)
    { this.loc = new SourceLocation(p, p.startLoc, p.endLoc); }
  if (p.options.ranges)
    { this.range = [p.start, p.end]; }
};

// ## Tokenizer

var pp$8 = Parser.prototype;

// Move to the next token

pp$8.next = function() {
  if (this.options.onToken)
    { this.options.onToken(new Token(this)); }

  this.lastTokEnd = this.end;
  this.lastTokStart = this.start;
  this.lastTokEndLoc = this.endLoc;
  this.lastTokStartLoc = this.startLoc;
  this.nextToken();
};

pp$8.getToken = function() {
  this.next();
  return new Token(this)
};

// If we're in an ES6 environment, make parsers iterable
if (typeof Symbol !== "undefined")
  { pp$8[Symbol.iterator] = function() {
    var this$1 = this;

    return {
      next: function () {
        var token = this$1.getToken();
        return {
          done: token.type === types.eof,
          value: token
        }
      }
    }
  }; }

// Toggle strict mode. Re-reads the next number or string to please
// pedantic tests (`"use strict"; 010;` should fail).

pp$8.curContext = function() {
  return this.context[this.context.length - 1]
};

// Read a single token, updating the parser object's token-related
// properties.

pp$8.nextToken = function() {
  var curContext = this.curContext();
  if (!curContext || !curContext.preserveSpace) { this.skipSpace(); }

  this.start = this.pos;
  if (this.options.locations) { this.startLoc = this.curPosition(); }
  if (this.pos >= this.input.length) { return this.finishToken(types.eof) }

  if (curContext.override) { return curContext.override(this) }
  else { this.readToken(this.fullCharCodeAtPos()); }
};

pp$8.readToken = function(code) {
  // Identifier or keyword. '\uXXXX' sequences are allowed in
  // identifiers, so '\' also dispatches to that.
  if (isIdentifierStart(code, this.options.ecmaVersion >= 6) || code === 92 /* '\' */)
    { return this.readWord() }

  return this.getTokenFromCode(code)
};

pp$8.fullCharCodeAtPos = function() {
  var code = this.input.charCodeAt(this.pos);
  if (code <= 0xd7ff || code >= 0xe000) { return code }
  var next = this.input.charCodeAt(this.pos + 1);
  return (code << 10) + next - 0x35fdc00
};

pp$8.skipBlockComment = function() {
  var this$1 = this;

  var startLoc = this.options.onComment && this.curPosition();
  var start = this.pos, end = this.input.indexOf("*/", this.pos += 2);
  if (end === -1) { this.raise(this.pos - 2, "Unterminated comment"); }
  this.pos = end + 2;
  if (this.options.locations) {
    lineBreakG.lastIndex = start;
    var match;
    while ((match = lineBreakG.exec(this.input)) && match.index < this.pos) {
      ++this$1.curLine;
      this$1.lineStart = match.index + match[0].length;
    }
  }
  if (this.options.onComment)
    { this.options.onComment(true, this.input.slice(start + 2, end), start, this.pos,
                           startLoc, this.curPosition()); }
};

pp$8.skipLineComment = function(startSkip) {
  var this$1 = this;

  var start = this.pos;
  var startLoc = this.options.onComment && this.curPosition();
  var ch = this.input.charCodeAt(this.pos += startSkip);
  while (this.pos < this.input.length && !isNewLine(ch)) {
    ch = this$1.input.charCodeAt(++this$1.pos);
  }
  if (this.options.onComment)
    { this.options.onComment(false, this.input.slice(start + startSkip, this.pos), start, this.pos,
                           startLoc, this.curPosition()); }
};

// Called at the start of the parse and after every token. Skips
// whitespace and comments, and.

pp$8.skipSpace = function() {
  var this$1 = this;

  loop: while (this.pos < this.input.length) {
    var ch = this$1.input.charCodeAt(this$1.pos);
    switch (ch) {
    case 32: case 160: // ' '
      ++this$1.pos;
      break
    case 13:
      if (this$1.input.charCodeAt(this$1.pos + 1) === 10) {
        ++this$1.pos;
      }
    case 10: case 8232: case 8233:
      ++this$1.pos;
      if (this$1.options.locations) {
        ++this$1.curLine;
        this$1.lineStart = this$1.pos;
      }
      break
    case 47: // '/'
      switch (this$1.input.charCodeAt(this$1.pos + 1)) {
      case 42: // '*'
        this$1.skipBlockComment();
        break
      case 47:
        this$1.skipLineComment(2);
        break
      default:
        break loop
      }
      break
    default:
      if (ch > 8 && ch < 14 || ch >= 5760 && nonASCIIwhitespace.test(String.fromCharCode(ch))) {
        ++this$1.pos;
      } else {
        break loop
      }
    }
  }
};

// Called at the end of every token. Sets `end`, `val`, and
// maintains `context` and `exprAllowed`, and skips the space after
// the token, so that the next one's `start` will point at the
// right position.

pp$8.finishToken = function(type, val) {
  this.end = this.pos;
  if (this.options.locations) { this.endLoc = this.curPosition(); }
  var prevType = this.type;
  this.type = type;
  this.value = val;

  this.updateContext(prevType);
};

// ### Token reading

// This is the function that is called to fetch the next token. It
// is somewhat obscure, because it works in character codes rather
// than characters, and because operator parsing has been inlined
// into it.
//
// All in the name of speed.
//
pp$8.readToken_dot = function() {
  var next = this.input.charCodeAt(this.pos + 1);
  if (next >= 48 && next <= 57) { return this.readNumber(true) }
  var next2 = this.input.charCodeAt(this.pos + 2);
  if (this.options.ecmaVersion >= 6 && next === 46 && next2 === 46) { // 46 = dot '.'
    this.pos += 3;
    return this.finishToken(types.ellipsis)
  } else {
    ++this.pos;
    return this.finishToken(types.dot)
  }
};

pp$8.readToken_slash = function() { // '/'
  var next = this.input.charCodeAt(this.pos + 1);
  if (this.exprAllowed) { ++this.pos; return this.readRegexp() }
  if (next === 61) { return this.finishOp(types.assign, 2) }
  return this.finishOp(types.slash, 1)
};

pp$8.readToken_mult_modulo_exp = function(code) { // '%*'
  var next = this.input.charCodeAt(this.pos + 1);
  var size = 1;
  var tokentype = code === 42 ? types.star : types.modulo;

  // exponentiation operator ** and **=
  if (this.options.ecmaVersion >= 7 && code === 42 && next === 42) {
    ++size;
    tokentype = types.starstar;
    next = this.input.charCodeAt(this.pos + 2);
  }

  if (next === 61) { return this.finishOp(types.assign, size + 1) }
  return this.finishOp(tokentype, size)
};

pp$8.readToken_pipe_amp = function(code) { // '|&'
  var next = this.input.charCodeAt(this.pos + 1);
  if (next === code) { return this.finishOp(code === 124 ? types.logicalOR : types.logicalAND, 2) }
  if (next === 61) { return this.finishOp(types.assign, 2) }
  return this.finishOp(code === 124 ? types.bitwiseOR : types.bitwiseAND, 1)
};

pp$8.readToken_caret = function() { // '^'
  var next = this.input.charCodeAt(this.pos + 1);
  if (next === 61) { return this.finishOp(types.assign, 2) }
  return this.finishOp(types.bitwiseXOR, 1)
};

pp$8.readToken_plus_min = function(code) { // '+-'
  var next = this.input.charCodeAt(this.pos + 1);
  if (next === code) {
    if (next === 45 && !this.inModule && this.input.charCodeAt(this.pos + 2) === 62 &&
        (this.lastTokEnd === 0 || lineBreak.test(this.input.slice(this.lastTokEnd, this.pos)))) {
      // A `-->` line comment
      this.skipLineComment(3);
      this.skipSpace();
      return this.nextToken()
    }
    return this.finishOp(types.incDec, 2)
  }
  if (next === 61) { return this.finishOp(types.assign, 2) }
  return this.finishOp(types.plusMin, 1)
};

pp$8.readToken_lt_gt = function(code) { // '<>'
  var next = this.input.charCodeAt(this.pos + 1);
  var size = 1;
  if (next === code) {
    size = code === 62 && this.input.charCodeAt(this.pos + 2) === 62 ? 3 : 2;
    if (this.input.charCodeAt(this.pos + size) === 61) { return this.finishOp(types.assign, size + 1) }
    return this.finishOp(types.bitShift, size)
  }
  if (next === 33 && code === 60 && !this.inModule && this.input.charCodeAt(this.pos + 2) === 45 &&
      this.input.charCodeAt(this.pos + 3) === 45) {
    // `<!--`, an XML-style comment that should be interpreted as a line comment
    this.skipLineComment(4);
    this.skipSpace();
    return this.nextToken()
  }
  if (next === 61) { size = 2; }
  return this.finishOp(types.relational, size)
};

pp$8.readToken_eq_excl = function(code) { // '=!'
  var next = this.input.charCodeAt(this.pos + 1);
  if (next === 61) { return this.finishOp(types.equality, this.input.charCodeAt(this.pos + 2) === 61 ? 3 : 2) }
  if (code === 61 && next === 62 && this.options.ecmaVersion >= 6) { // '=>'
    this.pos += 2;
    return this.finishToken(types.arrow)
  }
  return this.finishOp(code === 61 ? types.eq : types.prefix, 1)
};

pp$8.getTokenFromCode = function(code) {
  switch (code) {
  // The interpretation of a dot depends on whether it is followed
  // by a digit or another two dots.
  case 46: // '.'
    return this.readToken_dot()

  // Punctuation tokens.
  case 40: ++this.pos; return this.finishToken(types.parenL)
  case 41: ++this.pos; return this.finishToken(types.parenR)
  case 59: ++this.pos; return this.finishToken(types.semi)
  case 44: ++this.pos; return this.finishToken(types.comma)
  case 91: ++this.pos; return this.finishToken(types.bracketL)
  case 93: ++this.pos; return this.finishToken(types.bracketR)
  case 123: ++this.pos; return this.finishToken(types.braceL)
  case 125: ++this.pos; return this.finishToken(types.braceR)
  case 58: ++this.pos; return this.finishToken(types.colon)
  case 63: ++this.pos; return this.finishToken(types.question)

  case 96: // '`'
    if (this.options.ecmaVersion < 6) { break }
    ++this.pos;
    return this.finishToken(types.backQuote)

  case 48: // '0'
    var next = this.input.charCodeAt(this.pos + 1);
    if (next === 120 || next === 88) { return this.readRadixNumber(16) } // '0x', '0X' - hex number
    if (this.options.ecmaVersion >= 6) {
      if (next === 111 || next === 79) { return this.readRadixNumber(8) } // '0o', '0O' - octal number
      if (next === 98 || next === 66) { return this.readRadixNumber(2) } // '0b', '0B' - binary number
    }

  // Anything else beginning with a digit is an integer, octal
  // number, or float.
  case 49: case 50: case 51: case 52: case 53: case 54: case 55: case 56: case 57: // 1-9
    return this.readNumber(false)

  // Quotes produce strings.
  case 34: case 39: // '"', "'"
    return this.readString(code)

  // Operators are parsed inline in tiny state machines. '=' (61) is
  // often referred to. `finishOp` simply skips the amount of
  // characters it is given as second argument, and returns a token
  // of the type given by its first argument.

  case 47: // '/'
    return this.readToken_slash()

  case 37: case 42: // '%*'
    return this.readToken_mult_modulo_exp(code)

  case 124: case 38: // '|&'
    return this.readToken_pipe_amp(code)

  case 94: // '^'
    return this.readToken_caret()

  case 43: case 45: // '+-'
    return this.readToken_plus_min(code)

  case 60: case 62: // '<>'
    return this.readToken_lt_gt(code)

  case 61: case 33: // '=!'
    return this.readToken_eq_excl(code)

  case 126: // '~'
    return this.finishOp(types.prefix, 1)
  }

  this.raise(this.pos, "Unexpected character '" + codePointToString(code) + "'");
};

pp$8.finishOp = function(type, size) {
  var str = this.input.slice(this.pos, this.pos + size);
  this.pos += size;
  return this.finishToken(type, str)
};

pp$8.readRegexp = function() {
  var this$1 = this;

  var escaped, inClass, start = this.pos;
  for (;;) {
    if (this$1.pos >= this$1.input.length) { this$1.raise(start, "Unterminated regular expression"); }
    var ch = this$1.input.charAt(this$1.pos);
    if (lineBreak.test(ch)) { this$1.raise(start, "Unterminated regular expression"); }
    if (!escaped) {
      if (ch === "[") { inClass = true; }
      else if (ch === "]" && inClass) { inClass = false; }
      else if (ch === "/" && !inClass) { break }
      escaped = ch === "\\";
    } else { escaped = false; }
    ++this$1.pos;
  }
  var pattern = this.input.slice(start, this.pos);
  ++this.pos;
  var flagsStart = this.pos;
  var flags = this.readWord1();
  if (this.containsEsc) { this.unexpected(flagsStart); }

  // Validate pattern
  var state = this.regexpState || (this.regexpState = new RegExpValidationState(this));
  state.reset(start, pattern, flags);
  this.validateRegExpFlags(state);
  this.validateRegExpPattern(state);

  // Create Literal#value property value.
  var value = null;
  try {
    value = new RegExp(pattern, flags);
  } catch (e) {
    // ESTree requires null if it failed to instantiate RegExp object.
    // https://github.com/estree/estree/blob/a27003adf4fd7bfad44de9cef372a2eacd527b1c/es5.md#regexpliteral
  }

  return this.finishToken(types.regexp, {pattern: pattern, flags: flags, value: value})
};

// Read an integer in the given radix. Return null if zero digits
// were read, the integer value otherwise. When `len` is given, this
// will return `null` unless the integer has exactly `len` digits.

pp$8.readInt = function(radix, len) {
  var this$1 = this;

  var start = this.pos, total = 0;
  for (var i = 0, e = len == null ? Infinity : len; i < e; ++i) {
    var code = this$1.input.charCodeAt(this$1.pos), val = (void 0);
    if (code >= 97) { val = code - 97 + 10; } // a
    else if (code >= 65) { val = code - 65 + 10; } // A
    else if (code >= 48 && code <= 57) { val = code - 48; } // 0-9
    else { val = Infinity; }
    if (val >= radix) { break }
    ++this$1.pos;
    total = total * radix + val;
  }
  if (this.pos === start || len != null && this.pos - start !== len) { return null }

  return total
};

pp$8.readRadixNumber = function(radix) {
  this.pos += 2; // 0x
  var val = this.readInt(radix);
  if (val == null) { this.raise(this.start + 2, "Expected number in radix " + radix); }
  if (isIdentifierStart(this.fullCharCodeAtPos())) { this.raise(this.pos, "Identifier directly after number"); }
  return this.finishToken(types.num, val)
};

// Read an integer, octal integer, or floating-point number.

pp$8.readNumber = function(startsWithDot) {
  var start = this.pos;
  if (!startsWithDot && this.readInt(10) === null) { this.raise(start, "Invalid number"); }
  var octal = this.pos - start >= 2 && this.input.charCodeAt(start) === 48;
  if (octal && this.strict) { this.raise(start, "Invalid number"); }
  if (octal && /[89]/.test(this.input.slice(start, this.pos))) { octal = false; }
  var next = this.input.charCodeAt(this.pos);
  if (next === 46 && !octal) { // '.'
    ++this.pos;
    this.readInt(10);
    next = this.input.charCodeAt(this.pos);
  }
  if ((next === 69 || next === 101) && !octal) { // 'eE'
    next = this.input.charCodeAt(++this.pos);
    if (next === 43 || next === 45) { ++this.pos; } // '+-'
    if (this.readInt(10) === null) { this.raise(start, "Invalid number"); }
  }
  if (isIdentifierStart(this.fullCharCodeAtPos())) { this.raise(this.pos, "Identifier directly after number"); }

  var str = this.input.slice(start, this.pos);
  var val = octal ? parseInt(str, 8) : parseFloat(str);
  return this.finishToken(types.num, val)
};

// Read a string value, interpreting backslash-escapes.

pp$8.readCodePoint = function() {
  var ch = this.input.charCodeAt(this.pos), code;

  if (ch === 123) { // '{'
    if (this.options.ecmaVersion < 6) { this.unexpected(); }
    var codePos = ++this.pos;
    code = this.readHexChar(this.input.indexOf("}", this.pos) - this.pos);
    ++this.pos;
    if (code > 0x10FFFF) { this.invalidStringToken(codePos, "Code point out of bounds"); }
  } else {
    code = this.readHexChar(4);
  }
  return code
};

function codePointToString(code) {
  // UTF-16 Decoding
  if (code <= 0xFFFF) { return String.fromCharCode(code) }
  code -= 0x10000;
  return String.fromCharCode((code >> 10) + 0xD800, (code & 1023) + 0xDC00)
}

pp$8.readString = function(quote) {
  var this$1 = this;

  var out = "", chunkStart = ++this.pos;
  for (;;) {
    if (this$1.pos >= this$1.input.length) { this$1.raise(this$1.start, "Unterminated string constant"); }
    var ch = this$1.input.charCodeAt(this$1.pos);
    if (ch === quote) { break }
    if (ch === 92) { // '\'
      out += this$1.input.slice(chunkStart, this$1.pos);
      out += this$1.readEscapedChar(false);
      chunkStart = this$1.pos;
    } else {
      if (isNewLine(ch, this$1.options.ecmaVersion >= 10)) { this$1.raise(this$1.start, "Unterminated string constant"); }
      ++this$1.pos;
    }
  }
  out += this.input.slice(chunkStart, this.pos++);
  return this.finishToken(types.string, out)
};

// Reads template string tokens.

var INVALID_TEMPLATE_ESCAPE_ERROR = {};

pp$8.tryReadTemplateToken = function() {
  this.inTemplateElement = true;
  try {
    this.readTmplToken();
  } catch (err) {
    if (err === INVALID_TEMPLATE_ESCAPE_ERROR) {
      this.readInvalidTemplateToken();
    } else {
      throw err
    }
  }

  this.inTemplateElement = false;
};

pp$8.invalidStringToken = function(position, message) {
  if (this.inTemplateElement && this.options.ecmaVersion >= 9) {
    throw INVALID_TEMPLATE_ESCAPE_ERROR
  } else {
    this.raise(position, message);
  }
};

pp$8.readTmplToken = function() {
  var this$1 = this;

  var out = "", chunkStart = this.pos;
  for (;;) {
    if (this$1.pos >= this$1.input.length) { this$1.raise(this$1.start, "Unterminated template"); }
    var ch = this$1.input.charCodeAt(this$1.pos);
    if (ch === 96 || ch === 36 && this$1.input.charCodeAt(this$1.pos + 1) === 123) { // '`', '${'
      if (this$1.pos === this$1.start && (this$1.type === types.template || this$1.type === types.invalidTemplate)) {
        if (ch === 36) {
          this$1.pos += 2;
          return this$1.finishToken(types.dollarBraceL)
        } else {
          ++this$1.pos;
          return this$1.finishToken(types.backQuote)
        }
      }
      out += this$1.input.slice(chunkStart, this$1.pos);
      return this$1.finishToken(types.template, out)
    }
    if (ch === 92) { // '\'
      out += this$1.input.slice(chunkStart, this$1.pos);
      out += this$1.readEscapedChar(true);
      chunkStart = this$1.pos;
    } else if (isNewLine(ch)) {
      out += this$1.input.slice(chunkStart, this$1.pos);
      ++this$1.pos;
      switch (ch) {
      case 13:
        if (this$1.input.charCodeAt(this$1.pos) === 10) { ++this$1.pos; }
      case 10:
        out += "\n";
        break
      default:
        out += String.fromCharCode(ch);
        break
      }
      if (this$1.options.locations) {
        ++this$1.curLine;
        this$1.lineStart = this$1.pos;
      }
      chunkStart = this$1.pos;
    } else {
      ++this$1.pos;
    }
  }
};

// Reads a template token to search for the end, without validating any escape sequences
pp$8.readInvalidTemplateToken = function() {
  var this$1 = this;

  for (; this.pos < this.input.length; this.pos++) {
    switch (this$1.input[this$1.pos]) {
    case "\\":
      ++this$1.pos;
      break

    case "$":
      if (this$1.input[this$1.pos + 1] !== "{") {
        break
      }
    // falls through

    case "`":
      return this$1.finishToken(types.invalidTemplate, this$1.input.slice(this$1.start, this$1.pos))

    // no default
    }
  }
  this.raise(this.start, "Unterminated template");
};

// Used to read escaped characters

pp$8.readEscapedChar = function(inTemplate) {
  var ch = this.input.charCodeAt(++this.pos);
  ++this.pos;
  switch (ch) {
  case 110: return "\n" // 'n' -> '\n'
  case 114: return "\r" // 'r' -> '\r'
  case 120: return String.fromCharCode(this.readHexChar(2)) // 'x'
  case 117: return codePointToString(this.readCodePoint()) // 'u'
  case 116: return "\t" // 't' -> '\t'
  case 98: return "\b" // 'b' -> '\b'
  case 118: return "\u000b" // 'v' -> '\u000b'
  case 102: return "\f" // 'f' -> '\f'
  case 13: if (this.input.charCodeAt(this.pos) === 10) { ++this.pos; } // '\r\n'
  case 10: // ' \n'
    if (this.options.locations) { this.lineStart = this.pos; ++this.curLine; }
    return ""
  default:
    if (ch >= 48 && ch <= 55) {
      var octalStr = this.input.substr(this.pos - 1, 3).match(/^[0-7]+/)[0];
      var octal = parseInt(octalStr, 8);
      if (octal > 255) {
        octalStr = octalStr.slice(0, -1);
        octal = parseInt(octalStr, 8);
      }
      this.pos += octalStr.length - 1;
      ch = this.input.charCodeAt(this.pos);
      if ((octalStr !== "0" || ch === 56 || ch === 57) && (this.strict || inTemplate)) {
        this.invalidStringToken(
          this.pos - 1 - octalStr.length,
          inTemplate
            ? "Octal literal in template string"
            : "Octal literal in strict mode"
        );
      }
      return String.fromCharCode(octal)
    }
    return String.fromCharCode(ch)
  }
};

// Used to read character escape sequences ('\x', '\u', '\U').

pp$8.readHexChar = function(len) {
  var codePos = this.pos;
  var n = this.readInt(16, len);
  if (n === null) { this.invalidStringToken(codePos, "Bad character escape sequence"); }
  return n
};

// Read an identifier, and return it as a string. Sets `this.containsEsc`
// to whether the word contained a '\u' escape.
//
// Incrementally adds only escaped chars, adding other chunks as-is
// as a micro-optimization.

pp$8.readWord1 = function() {
  var this$1 = this;

  this.containsEsc = false;
  var word = "", first = true, chunkStart = this.pos;
  var astral = this.options.ecmaVersion >= 6;
  while (this.pos < this.input.length) {
    var ch = this$1.fullCharCodeAtPos();
    if (isIdentifierChar(ch, astral)) {
      this$1.pos += ch <= 0xffff ? 1 : 2;
    } else if (ch === 92) { // "\"
      this$1.containsEsc = true;
      word += this$1.input.slice(chunkStart, this$1.pos);
      var escStart = this$1.pos;
      if (this$1.input.charCodeAt(++this$1.pos) !== 117) // "u"
        { this$1.invalidStringToken(this$1.pos, "Expecting Unicode escape sequence \\uXXXX"); }
      ++this$1.pos;
      var esc = this$1.readCodePoint();
      if (!(first ? isIdentifierStart : isIdentifierChar)(esc, astral))
        { this$1.invalidStringToken(escStart, "Invalid Unicode escape"); }
      word += codePointToString(esc);
      chunkStart = this$1.pos;
    } else {
      break
    }
    first = false;
  }
  return word + this.input.slice(chunkStart, this.pos)
};

// Read an identifier or keyword token. Will check for reserved
// words when necessary.

pp$8.readWord = function() {
  var word = this.readWord1();
  var type = types.name;
  if (this.keywords.test(word)) {
    if (this.containsEsc) { this.raiseRecoverable(this.start, "Escape sequence in keyword " + word); }
    type = keywords$1[word];
  }
  return this.finishToken(type, word)
};

// Acorn is a tiny, fast JavaScript parser written in JavaScript.
//
// Acorn was written by Marijn Haverbeke, Ingvar Stepanyan, and
// various contributors and released under an MIT license.
//
// Git repositories for Acorn are available at
//
//     http://marijnhaverbeke.nl/git/acorn
//     https://github.com/acornjs/acorn.git
//
// Please use the [github bug tracker][ghbt] to report issues.
//
// [ghbt]: https://github.com/acornjs/acorn/issues
//
// This file defines the main parser interface. The library also comes
// with a [error-tolerant parser][dammit] and an
// [abstract syntax tree walker][walk], defined in other files.
//
// [dammit]: acorn_loose.js
// [walk]: util/walk.js

var version = "5.7.3";

// The main exported interface (under `self.acorn` when in the
// browser) is a `parse` function that takes a code string and
// returns an abstract syntax tree as specified by [Mozilla parser
// API][api].
//
// [api]: https://developer.mozilla.org/en-US/docs/SpiderMonkey/Parser_API

function parse(input, options) {
  return new Parser(options, input).parse()
}

// This function tries to parse a single expression at a given
// offset in a string. Useful for parsing mixed-language formats
// that embed JavaScript expressions.

function parseExpressionAt(input, pos, options) {
  var p = new Parser(options, input, pos);
  p.nextToken();
  return p.parseExpression()
}

// Acorn is organized as a tokenizer and a recursive-descent parser.
// The `tokenizer` export provides an interface to the tokenizer.

function tokenizer(input, options) {
  return new Parser(options, input)
}

// This is a terrible kludge to support the existing, pre-ES6
// interface where the loose parser module retroactively adds exports
// to this module.
var parse_dammit;
var LooseParser;
var pluginsLoose; // eslint-disable-line camelcase
function addLooseExports(parse, Parser$$1, plugins$$1) {
  parse_dammit = parse; // eslint-disable-line camelcase
  LooseParser = Parser$$1;
  pluginsLoose = plugins$$1;
}




/***/ }),

/***/ "./node_modules/ansi-styles/index.js":
/*!*******************************************!*\
  !*** ./node_modules/ansi-styles/index.js ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(module) {

const wrapAnsi16 = (fn, offset) => (...args) => {
	const code = fn(...args);
	return `\u001B[${code + offset}m`;
};

const wrapAnsi256 = (fn, offset) => (...args) => {
	const code = fn(...args);
	return `\u001B[${38 + offset};5;${code}m`;
};

const wrapAnsi16m = (fn, offset) => (...args) => {
	const rgb = fn(...args);
	return `\u001B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
};

const ansi2ansi = n => n;
const rgb2rgb = (r, g, b) => [r, g, b];

const setLazyProperty = (object, property, get) => {
	Object.defineProperty(object, property, {
		get: () => {
			const value = get();

			Object.defineProperty(object, property, {
				value,
				enumerable: true,
				configurable: true
			});

			return value;
		},
		enumerable: true,
		configurable: true
	});
};

/** @type {typeof import('color-convert')} */
let colorConvert;
const makeDynamicStyles = (wrap, targetSpace, identity, isBackground) => {
	if (colorConvert === undefined) {
		colorConvert = __webpack_require__(/*! color-convert */ "./node_modules/color-convert/index.js");
	}

	const offset = isBackground ? 10 : 0;
	const styles = {};

	for (const [sourceSpace, suite] of Object.entries(colorConvert)) {
		const name = sourceSpace === 'ansi16' ? 'ansi' : sourceSpace;
		if (sourceSpace === targetSpace) {
			styles[name] = wrap(identity, offset);
		} else if (typeof suite === 'object') {
			styles[name] = wrap(suite[targetSpace], offset);
		}
	}

	return styles;
};

function assembleStyles() {
	const codes = new Map();
	const styles = {
		modifier: {
			reset: [0, 0],
			// 21 isn't widely supported and 22 does the same thing
			bold: [1, 22],
			dim: [2, 22],
			italic: [3, 23],
			underline: [4, 24],
			inverse: [7, 27],
			hidden: [8, 28],
			strikethrough: [9, 29]
		},
		color: {
			black: [30, 39],
			red: [31, 39],
			green: [32, 39],
			yellow: [33, 39],
			blue: [34, 39],
			magenta: [35, 39],
			cyan: [36, 39],
			white: [37, 39],

			// Bright color
			blackBright: [90, 39],
			redBright: [91, 39],
			greenBright: [92, 39],
			yellowBright: [93, 39],
			blueBright: [94, 39],
			magentaBright: [95, 39],
			cyanBright: [96, 39],
			whiteBright: [97, 39]
		},
		bgColor: {
			bgBlack: [40, 49],
			bgRed: [41, 49],
			bgGreen: [42, 49],
			bgYellow: [43, 49],
			bgBlue: [44, 49],
			bgMagenta: [45, 49],
			bgCyan: [46, 49],
			bgWhite: [47, 49],

			// Bright color
			bgBlackBright: [100, 49],
			bgRedBright: [101, 49],
			bgGreenBright: [102, 49],
			bgYellowBright: [103, 49],
			bgBlueBright: [104, 49],
			bgMagentaBright: [105, 49],
			bgCyanBright: [106, 49],
			bgWhiteBright: [107, 49]
		}
	};

	// Alias bright black as gray (and grey)
	styles.color.gray = styles.color.blackBright;
	styles.bgColor.bgGray = styles.bgColor.bgBlackBright;
	styles.color.grey = styles.color.blackBright;
	styles.bgColor.bgGrey = styles.bgColor.bgBlackBright;

	for (const [groupName, group] of Object.entries(styles)) {
		for (const [styleName, style] of Object.entries(group)) {
			styles[styleName] = {
				open: `\u001B[${style[0]}m`,
				close: `\u001B[${style[1]}m`
			};

			group[styleName] = styles[styleName];

			codes.set(style[0], style[1]);
		}

		Object.defineProperty(styles, groupName, {
			value: group,
			enumerable: false
		});
	}

	Object.defineProperty(styles, 'codes', {
		value: codes,
		enumerable: false
	});

	styles.color.close = '\u001B[39m';
	styles.bgColor.close = '\u001B[49m';

	setLazyProperty(styles.color, 'ansi', () => makeDynamicStyles(wrapAnsi16, 'ansi16', ansi2ansi, false));
	setLazyProperty(styles.color, 'ansi256', () => makeDynamicStyles(wrapAnsi256, 'ansi256', ansi2ansi, false));
	setLazyProperty(styles.color, 'ansi16m', () => makeDynamicStyles(wrapAnsi16m, 'rgb', rgb2rgb, false));
	setLazyProperty(styles.bgColor, 'ansi', () => makeDynamicStyles(wrapAnsi16, 'ansi16', ansi2ansi, true));
	setLazyProperty(styles.bgColor, 'ansi256', () => makeDynamicStyles(wrapAnsi256, 'ansi256', ansi2ansi, true));
	setLazyProperty(styles.bgColor, 'ansi16m', () => makeDynamicStyles(wrapAnsi16m, 'rgb', rgb2rgb, true));

	return styles;
}

// Make the export immutable
Object.defineProperty(module, 'exports', {
	enumerable: true,
	get: assembleStyles
});

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../webpack/buildin/module.js */ "./node_modules/webpack/buildin/module.js")(module)))

/***/ }),

/***/ "./node_modules/array-filter/index.js":
/*!********************************************!*\
  !*** ./node_modules/array-filter/index.js ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports) {


/**
 * Array#filter.
 *
 * @param {Array} arr
 * @param {Function} fn
 * @param {Object=} self
 * @return {Array}
 * @throw TypeError
 */

module.exports = function (arr, fn, self) {
  if (arr.filter) return arr.filter(fn, self);
  if (void 0 === arr || null === arr) throw new TypeError;
  if ('function' != typeof fn) throw new TypeError;
  var ret = [];
  for (var i = 0; i < arr.length; i++) {
    if (!hasOwn.call(arr, i)) continue;
    var val = arr[i];
    if (fn.call(self, val, i, arr)) ret.push(val);
  }
  return ret;
};

var hasOwn = Object.prototype.hasOwnProperty;


/***/ }),

/***/ "./node_modules/bioterms/dist/Predicates.js":
/*!**************************************************!*\
  !*** ./node_modules/bioterms/dist/Predicates.js ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const Prefixes_1 = __webpack_require__(/*! ./Prefixes */ "./node_modules/bioterms/dist/Prefixes.js");
var Predicates;
(function (Predicates) {
    Predicates.a = Prefixes_1.Prefixes.rdf + 'type';
    let SBOL1;
    (function (SBOL1) {
        SBOL1.nucleotides = Prefixes_1.Prefixes.sbol1 + 'nucleotides';
        SBOL1.subComponent = Prefixes_1.Prefixes.sbol1 + 'subComponent';
        SBOL1.dnaSequence = Prefixes_1.Prefixes.sbol1 + 'dnaSequence';
        SBOL1.bioStart = Prefixes_1.Prefixes.sbol1 + 'bioStart';
        SBOL1.bioEnd = Prefixes_1.Prefixes.sbol1 + 'bioEnd';
        SBOL1.displayId = Prefixes_1.Prefixes.sbol1 + 'displayId';
        SBOL1.name = Prefixes_1.Prefixes.sbol1 + 'name';
        SBOL1.description = Prefixes_1.Prefixes.sbol1 + 'description';
        SBOL1.annotation = Prefixes_1.Prefixes.sbol1 + 'annotation';
        SBOL1.strand = Prefixes_1.Prefixes.sbol1 + 'strand';
        SBOL1.component = Prefixes_1.Prefixes.sbol1 + 'component';
        SBOL1.precedes = Prefixes_1.Prefixes.sbol1 + 'precedes';
    })(SBOL1 = Predicates.SBOL1 || (Predicates.SBOL1 = {}));
    let SBOL2;
    (function (SBOL2) {
        SBOL2.component = Prefixes_1.Prefixes.sbol2 + 'component';
        SBOL2.module = Prefixes_1.Prefixes.sbol2 + 'module';
        SBOL2.definition = Prefixes_1.Prefixes.sbol2 + 'definition';
        SBOL2.functionalComponent = Prefixes_1.Prefixes.sbol2 + 'functionalComponent';
        SBOL2.role = Prefixes_1.Prefixes.sbol2 + 'role';
        SBOL2.location = Prefixes_1.Prefixes.sbol2 + 'location';
        SBOL2.start = Prefixes_1.Prefixes.sbol2 + 'start';
        SBOL2.end = Prefixes_1.Prefixes.sbol2 + 'end';
        SBOL2.at = Prefixes_1.Prefixes.sbol2 + 'at';
        SBOL2.sequenceAnnotation = Prefixes_1.Prefixes.sbol2 + 'sequenceAnnotation';
        SBOL2.sequenceConstraint = Prefixes_1.Prefixes.sbol2 + 'sequenceConstraint';
        SBOL2.orientation = Prefixes_1.Prefixes.sbol2 + 'orientation';
        SBOL2.displayId = Prefixes_1.Prefixes.sbol2 + 'displayId';
        SBOL2.version = Prefixes_1.Prefixes.sbol2 + 'version';
        SBOL2.access = Prefixes_1.Prefixes.sbol2 + 'access';
        SBOL2.mapsTo = Prefixes_1.Prefixes.sbol2 + 'mapsTo';
        SBOL2.local = Prefixes_1.Prefixes.sbol2 + 'local';
        SBOL2.remote = Prefixes_1.Prefixes.sbol2 + 'remote';
        SBOL2.refinement = Prefixes_1.Prefixes.sbol2 + 'refinement';
        SBOL2.interaction = Prefixes_1.Prefixes.sbol2 + 'interaction';
        SBOL2.participation = Prefixes_1.Prefixes.sbol2 + 'participation';
        SBOL2.participant = Prefixes_1.Prefixes.sbol2 + 'participant';
        SBOL2.type = Prefixes_1.Prefixes.sbol2 + 'type';
        SBOL2.sequence = Prefixes_1.Prefixes.sbol2 + 'sequence';
        SBOL2.encoding = Prefixes_1.Prefixes.sbol2 + 'encoding';
        SBOL2.elements = Prefixes_1.Prefixes.sbol2 + 'elements';
        SBOL2.persistentIdentity = Prefixes_1.Prefixes.sbol2 + 'persistentIdentity';
        SBOL2.restriction = Prefixes_1.Prefixes.sbol2 + 'restriction';
        SBOL2.subject = Prefixes_1.Prefixes.sbol2 + 'subject';
        SBOL2.object = Prefixes_1.Prefixes.sbol2 + 'object';
        SBOL2.member = Prefixes_1.Prefixes.sbol2 + 'member';
        SBOL2.model = Prefixes_1.Prefixes.sbol2 + 'model';
        SBOL2.framework = Prefixes_1.Prefixes.sbol2 + 'framework';
        SBOL2.language = Prefixes_1.Prefixes.sbol2 + 'language';
        SBOL2.source = Prefixes_1.Prefixes.sbol2 + 'source';
        SBOL2.attachment = Prefixes_1.Prefixes.sbol2 + 'attachment';
        SBOL2.format = Prefixes_1.Prefixes.sbol2 + 'format';
        SBOL2.size = Prefixes_1.Prefixes.sbol2 + 'size';
        SBOL2.hash = Prefixes_1.Prefixes.sbol2 + 'hash';
        SBOL2.built = Prefixes_1.Prefixes.sbol2 + 'built';
        SBOL2.experimentalData = Prefixes_1.Prefixes.sbol2 + 'experimentalData';
        SBOL2.sourceLocation = Prefixes_1.Prefixes.sbol2 + 'sourceLocation';
        SBOL2.measure = Prefixes_1.Prefixes.sbol2 + 'measure';
    })(SBOL2 = Predicates.SBOL2 || (Predicates.SBOL2 = {}));
    let SBOLX;
    (function (SBOLX) {
        SBOLX.subComponent = Prefixes_1.Prefixes.sbolx + 'subComponent';
        SBOLX.instanceOf = Prefixes_1.Prefixes.sbolx + 'instanceOf';
        SBOLX.role = Prefixes_1.Prefixes.sbolx + 'role';
        SBOLX.location = Prefixes_1.Prefixes.sbolx + 'location';
        SBOLX.start = Prefixes_1.Prefixes.sbolx + 'start';
        SBOLX.end = Prefixes_1.Prefixes.sbolx + 'end';
        SBOLX.at = Prefixes_1.Prefixes.sbolx + 'at';
        SBOLX.sequenceAnnotation = Prefixes_1.Prefixes.sbolx + 'sequenceAnnotation';
        SBOLX.sequenceConstraint = Prefixes_1.Prefixes.sbolx + 'sequenceConstraint';
        SBOLX.orientation = Prefixes_1.Prefixes.sbolx + 'orientation';
        SBOLX.id = Prefixes_1.Prefixes.sbolx + 'id';
        SBOLX.version = Prefixes_1.Prefixes.sbolx + 'version';
        SBOLX.access = Prefixes_1.Prefixes.sbolx + 'access';
        SBOLX.mapsTo = Prefixes_1.Prefixes.sbolx + 'mapsTo';
        SBOLX.local = Prefixes_1.Prefixes.sbolx + 'local';
        SBOLX.remote = Prefixes_1.Prefixes.sbolx + 'remote';
        SBOLX.refinement = Prefixes_1.Prefixes.sbolx + 'refinement';
        SBOLX.interaction = Prefixes_1.Prefixes.sbolx + 'interaction';
        SBOLX.participation = Prefixes_1.Prefixes.sbolx + 'participation';
        SBOLX.participant = Prefixes_1.Prefixes.sbolx + 'participant';
        SBOLX.type = Prefixes_1.Prefixes.sbolx + 'type';
        SBOLX.sequence = Prefixes_1.Prefixes.sbolx + 'sequence';
        SBOLX.encoding = Prefixes_1.Prefixes.sbolx + 'encoding';
        SBOLX.elements = Prefixes_1.Prefixes.sbolx + 'elements';
        SBOLX.persistentIdentity = Prefixes_1.Prefixes.sbolx + 'persistentIdentity';
        SBOLX.restriction = Prefixes_1.Prefixes.sbolx + 'restriction';
        SBOLX.subject = Prefixes_1.Prefixes.sbolx + 'subject';
        SBOLX.object = Prefixes_1.Prefixes.sbolx + 'object';
        SBOLX.member = Prefixes_1.Prefixes.sbolx + 'member';
        SBOLX.model = Prefixes_1.Prefixes.sbolx + 'model';
        SBOLX.framework = Prefixes_1.Prefixes.sbolx + 'framework';
        SBOLX.language = Prefixes_1.Prefixes.sbolx + 'language';
        SBOLX.source = Prefixes_1.Prefixes.sbolx + 'source';
        SBOLX.attachment = Prefixes_1.Prefixes.sbolx + 'attachment';
        SBOLX.format = Prefixes_1.Prefixes.sbolx + 'format';
        SBOLX.size = Prefixes_1.Prefixes.sbolx + 'size';
        SBOLX.hash = Prefixes_1.Prefixes.sbolx + 'hash';
        SBOLX.built = Prefixes_1.Prefixes.sbolx + 'built';
        SBOLX.experimentalData = Prefixes_1.Prefixes.sbolx + 'experimentalData';
        SBOLX.sourceLocation = Prefixes_1.Prefixes.sbolx + 'sourceLocation';
        SBOLX.measure = Prefixes_1.Prefixes.sbolx + 'measure';
    })(SBOLX = Predicates.SBOLX || (Predicates.SBOLX = {}));
    let SBOL3;
    (function (SBOL3) {
        SBOL3.instanceOf = Prefixes_1.Prefixes.sbol3 + 'instanceOf';
        SBOL3.role = Prefixes_1.Prefixes.sbol3 + 'role';
        SBOL3.hasLocation = Prefixes_1.Prefixes.sbol3 + 'hasLocation';
        SBOL3.start = Prefixes_1.Prefixes.sbol3 + 'start';
        SBOL3.end = Prefixes_1.Prefixes.sbol3 + 'end';
        SBOL3.at = Prefixes_1.Prefixes.sbol3 + 'at';
        SBOL3.hasFeature = Prefixes_1.Prefixes.sbol3 + 'hasFeature';
        SBOL3.hasConstraint = Prefixes_1.Prefixes.sbol3 + 'hasConstraint';
        SBOL3.orientation = Prefixes_1.Prefixes.sbol3 + 'orientation';
        SBOL3.displayId = Prefixes_1.Prefixes.sbol3 + 'displayId';
        SBOL3.name = Prefixes_1.Prefixes.sbol3 + 'name';
        SBOL3.description = Prefixes_1.Prefixes.sbol3 + 'description';
        SBOL3.access = Prefixes_1.Prefixes.sbol3 + 'access';
        SBOL3.mapsTo = Prefixes_1.Prefixes.sbol3 + 'mapsTo';
        SBOL3.local = Prefixes_1.Prefixes.sbol3 + 'local';
        SBOL3.remote = Prefixes_1.Prefixes.sbol3 + 'remote';
        SBOL3.refinement = Prefixes_1.Prefixes.sbol3 + 'refinement';
        SBOL3.hasInteraction = Prefixes_1.Prefixes.sbol3 + 'hasInteraction';
        SBOL3.hasInterface = Prefixes_1.Prefixes.sbol3 + 'hasInterface';
        SBOL3.hasParticipation = Prefixes_1.Prefixes.sbol3 + 'hasParticipation';
        SBOL3.participant = Prefixes_1.Prefixes.sbol3 + 'participant';
        SBOL3.type = Prefixes_1.Prefixes.sbol3 + 'type';
        SBOL3.hasSequence = Prefixes_1.Prefixes.sbol3 + 'hasSequence';
        SBOL3.encoding = Prefixes_1.Prefixes.sbol3 + 'encoding';
        SBOL3.elements = Prefixes_1.Prefixes.sbol3 + 'elements';
        SBOL3.persistentIdentity = Prefixes_1.Prefixes.sbol3 + 'persistentIdentity';
        SBOL3.restriction = Prefixes_1.Prefixes.sbol3 + 'restriction';
        SBOL3.subject = Prefixes_1.Prefixes.sbol3 + 'subject';
        SBOL3.object = Prefixes_1.Prefixes.sbol3 + 'object';
        SBOL3.member = Prefixes_1.Prefixes.sbol3 + 'member';
        SBOL3.hasModel = Prefixes_1.Prefixes.sbol3 + 'hasModel';
        SBOL3.framework = Prefixes_1.Prefixes.sbol3 + 'framework';
        SBOL3.language = Prefixes_1.Prefixes.sbol3 + 'language';
        SBOL3.source = Prefixes_1.Prefixes.sbol3 + 'source';
        SBOL3.hasAttachment = Prefixes_1.Prefixes.sbol3 + 'hasAttachment';
        SBOL3.format = Prefixes_1.Prefixes.sbol3 + 'format';
        SBOL3.size = Prefixes_1.Prefixes.sbol3 + 'size';
        SBOL3.hash = Prefixes_1.Prefixes.sbol3 + 'hash';
        SBOL3.built = Prefixes_1.Prefixes.sbol3 + 'built';
        SBOL3.experimentalData = Prefixes_1.Prefixes.sbol3 + 'experimentalData';
        SBOL3.sourceLocation = Prefixes_1.Prefixes.sbol3 + 'sourceLocation';
        SBOL3.hasMeasure = Prefixes_1.Prefixes.sbol3 + 'hasMeasure';
        SBOL3.hasNamespace = Prefixes_1.Prefixes.sbol3 + 'hasNamespace';
    })(SBOL3 = Predicates.SBOL3 || (Predicates.SBOL3 = {}));
    let Dcterms;
    (function (Dcterms) {
        Dcterms.title = Prefixes_1.Prefixes.dcterms + 'title';
        Dcterms.description = Prefixes_1.Prefixes.dcterms + 'description';
    })(Dcterms = Predicates.Dcterms || (Predicates.Dcterms = {}));
    let SVG;
    (function (SVG) {
        SVG.fontFamily = Prefixes_1.Prefixes.svg + 'font-family';
        SVG.fontSize = Prefixes_1.Prefixes.svg + 'font-size';
        SVG.fontStyle = Prefixes_1.Prefixes.svg + 'font-style';
    })(SVG = Predicates.SVG || (Predicates.SVG = {}));
    let SyBiOnt;
    (function (SyBiOnt) {
        SyBiOnt.encodedBy = Prefixes_1.Prefixes.sybio + 'encodedBy';
        SyBiOnt.EC = Prefixes_1.Prefixes.sybio + 'EC';
        SyBiOnt.isBalanced = Prefixes_1.Prefixes.sybio + 'isBalanced';
        SyBiOnt.isReactionClass = Prefixes_1.Prefixes.sybio + 'isReactionClass';
        SyBiOnt.inPolymerization = Prefixes_1.Prefixes.sybio + 'inPolymerization';
        SyBiOnt.inTransport = Prefixes_1.Prefixes.sybio + 'inTransport';
        SyBiOnt.reactionDirection = Prefixes_1.Prefixes.sybio + 'reactionDirection';
        SyBiOnt.hasReactionParticipant = Prefixes_1.Prefixes.sybio + 'hasReactionParticipant';
        SyBiOnt.referencesCompound = Prefixes_1.Prefixes.sybio + 'referencesCompound';
        SyBiOnt.reactionSide = Prefixes_1.Prefixes.sybio + 'reactionSide';
        SyBiOnt.reactionSummary = Prefixes_1.Prefixes.sybio + 'reactionSummary';
        SyBiOnt.stoicRatio = Prefixes_1.Prefixes.sybio + 'stoichiometricRatio';
        SyBiOnt.compoundCharge = Prefixes_1.Prefixes.sybio + 'compoundCharge';
        SyBiOnt.compoundFormula = Prefixes_1.Prefixes.sybio + 'compoundFormula';
        SyBiOnt.compoundMass = Prefixes_1.Prefixes.sybio + 'compoundMass';
        SyBiOnt.compoundSmilesFormula = Prefixes_1.Prefixes.sybio + 'compoundSmilesFormula';
        SyBiOnt.interactsWith = Prefixes_1.Prefixes.sybio + 'interactsWith';
        SyBiOnt.taxId = Prefixes_1.Prefixes.sybio + 'taxId';
    })(SyBiOnt = Predicates.SyBiOnt || (Predicates.SyBiOnt = {}));
    let Prov;
    (function (Prov) {
        Prov.wasDerivedFrom = Prefixes_1.Prefixes.prov + 'wasDerivedFrom';
        Prov.wasGeneratedBy = Prefixes_1.Prefixes.prov + 'wasGeneratedBy';
        Prov.qualifiedAssociation = Prefixes_1.Prefixes.prov + 'qualifiedAssociation';
        Prov.qualifiedUsage = Prefixes_1.Prefixes.prov + 'qualifiedUsage';
        Prov.startedAtTime = Prefixes_1.Prefixes.prov + 'startedAtTime';
        Prov.endedAtTime = Prefixes_1.Prefixes.prov + 'endedAtTime';
        Prov.wasInformedBy = Prefixes_1.Prefixes.prov + 'wasInformedBy';
        Prov.agent = Prefixes_1.Prefixes.prov + 'agent';
        Prov.entity = Prefixes_1.Prefixes.prov + 'entity';
        Prov.hadRole = Prefixes_1.Prefixes.prov + 'hadRole';
        Prov.hadPlan = Prefixes_1.Prefixes.prov + 'hadPlan';
    })(Prov = Predicates.Prov || (Predicates.Prov = {}));
    let Enrichment;
    (function (Enrichment) {
        Enrichment.hint = Prefixes_1.Prefixes.enrichment + 'hint';
        Enrichment.orfStart = Prefixes_1.Prefixes.enrichment + 'orfStart';
        Enrichment.orfEnd = Prefixes_1.Prefixes.enrichment + 'orfEnd';
    })(Enrichment = Predicates.Enrichment || (Predicates.Enrichment = {}));
    let Measure;
    (function (Measure) {
        Measure.hasNumericalValue = Prefixes_1.Prefixes.measure + 'hasNumericalValue';
        Measure.hasUnit = Prefixes_1.Prefixes.measure + 'hasUnit';
    })(Measure = Predicates.Measure || (Predicates.Measure = {}));
})(Predicates = exports.Predicates || (exports.Predicates = {}));


/***/ }),

/***/ "./node_modules/bioterms/dist/Prefixes.js":
/*!************************************************!*\
  !*** ./node_modules/bioterms/dist/Prefixes.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Prefixes;
(function (Prefixes) {
    Prefixes.sbol1 = 'http://sbols.org/v1#';
    Prefixes.sbol2 = 'http://sbols.org/v2#';
    Prefixes.sbolx = 'http://sboldata.org/sbolx#';
    Prefixes.sbol3 = 'http://sbols.org/v3#';
    Prefixes.rdf = 'http://www.w3.org/1999/02/22-rdf-syntax-ns#';
    Prefixes.visual = 'http://wiki.synbiohub.org/wiki/Terms/visual#';
    Prefixes.sequenceOntologyPurl = 'http://purl.org/obo/owl/SO#';
    Prefixes.sequenceOntologyIdentifiersOrg = 'http://identifiers.org/so/';
    Prefixes.go = 'http://identifiers.org/go/';
    Prefixes.dcterms = 'http://purl.org/dc/terms/';
    Prefixes.rdfs = 'http://www.w3.org/2000/01/rdf-schema#';
    Prefixes.svg = 'http://www.w3.org/2000/svg#';
    Prefixes.sbo = 'http://identifiers.org/biomodels.sbo/';
    Prefixes.sybio = 'http://www.sybio.ncl.ac.uk#';
    Prefixes.prov = 'http://www.w3.org/ns/prov#';
    Prefixes.enrichment = 'http://wiki.synbiohub.org/wiki/Terms/enrichment#';
    Prefixes.measure = 'http://www.ontology-of-units-of-measure.org/resource/om-2/';
})(Prefixes = exports.Prefixes || (exports.Prefixes = {}));
function prefixify(uri) {
    uri = '' + uri;
    for (var i = 0; i < keys.length; ++i) {
        const prefix = keys[i];
        const uriPrefix = Prefixes[prefix];
        if (uri.indexOf(uriPrefix) === 0) {
            return prefix + ':' + uri.slice(uriPrefix.length);
        }
    }
    return uri;
}
exports.prefixify = prefixify;
const keys = Object.keys(Prefixes);


/***/ }),

/***/ "./node_modules/bioterms/dist/Specifiers.js":
/*!**************************************************!*\
  !*** ./node_modules/bioterms/dist/Specifiers.js ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const Prefixes_1 = __webpack_require__(/*! ./Prefixes */ "./node_modules/bioterms/dist/Prefixes.js");
var Specifiers;
(function (Specifiers) {
    let SBOL2;
    (function (SBOL2) {
        let Orientation;
        (function (Orientation) {
            Orientation.Inline = Prefixes_1.Prefixes.sbol2 + 'inline';
            Orientation.ReverseComplement = Prefixes_1.Prefixes.sbol2 + 'reverseComplement';
        })(Orientation = SBOL2.Orientation || (SBOL2.Orientation = {}));
        let Direction;
        (function (Direction) {
            Direction.Input = Prefixes_1.Prefixes.sbol2 + 'in';
            Direction.Output = Prefixes_1.Prefixes.sbol2 + 'out';
            Direction.InputAndOutput = Prefixes_1.Prefixes.sbol2 + 'inout';
            Direction.None = Prefixes_1.Prefixes.sbol2 + 'none';
        })(Direction = SBOL2.Direction || (SBOL2.Direction = {}));
        let Access;
        (function (Access) {
            Access.PublicAccess = Prefixes_1.Prefixes.sbol2 + 'public';
            Access.PrivateAccess = Prefixes_1.Prefixes.sbol2 + 'private';
        })(Access = SBOL2.Access || (SBOL2.Access = {}));
        let Type;
        (function (Type) {
            Type.DNA = 'http://www.biopax.org/release/biopax-level3.owl#DnaRegion';
            Type.RNA = 'http://www.biopax.org/release/biopax-level3.owl#RnaRegion';
            Type.Protein = 'http://www.biopax.org/release/biopax-level3.owl#Protein';
            Type.SmallMolecule = 'http://www.biopax.org/release/biopax-level3.owl#SmallMolecule';
            Type.Complex = 'http://www.biopax.org/release/biopax-level3.owl#Complex';
            Type.Effector = 'http://identifiers.org/chebi/CHEBI:35224';
            Type.Circular = Prefixes_1.Prefixes.sequenceOntologyIdentifiersOrg + 'SO:0000988';
        })(Type = SBOL2.Type || (SBOL2.Type = {}));
        let SequenceEncoding;
        (function (SequenceEncoding) {
            SequenceEncoding.NucleicAcid = 'http://www.chem.qmul.ac.uk/iubmb/misc/naseq.html';
            SequenceEncoding.RNA = 'http://www.chem.qmul.ac.uk/iubmb/misc/naseq.html';
            SequenceEncoding.AminoAcid = 'http://www.chem.qmul.ac.uk/iupac/AminoAcid/';
        })(SequenceEncoding = SBOL2.SequenceEncoding || (SBOL2.SequenceEncoding = {}));
        let SequenceConstraint;
        (function (SequenceConstraint) {
            SequenceConstraint.Precedes = Prefixes_1.Prefixes.sbol2 + 'precedes';
            SequenceConstraint.OppositeOrientationAs = Prefixes_1.Prefixes.sbol2 + 'oppositeOrientationAs';
        })(SequenceConstraint = SBOL2.SequenceConstraint || (SBOL2.SequenceConstraint = {}));
        let ProvRole;
        (function (ProvRole) {
            ProvRole.Design = Prefixes_1.Prefixes.sbol2 + 'design';
            ProvRole.Build = Prefixes_1.Prefixes.sbol2 + 'build';
            ProvRole.Test = Prefixes_1.Prefixes.sbol2 + 'test';
            ProvRole.Learn = Prefixes_1.Prefixes.sbol2 + 'learn';
        })(ProvRole = SBOL2.ProvRole || (SBOL2.ProvRole = {}));
        let MapsToRefinement;
        (function (MapsToRefinement) {
            MapsToRefinement.UseLocal = Prefixes_1.Prefixes.sbol2 + 'useLocal';
            MapsToRefinement.UseRemote = Prefixes_1.Prefixes.sbol2 + 'useRemote';
        })(MapsToRefinement = SBOL2.MapsToRefinement || (SBOL2.MapsToRefinement = {}));
    })(SBOL2 = Specifiers.SBOL2 || (Specifiers.SBOL2 = {}));
    let SBOLX;
    (function (SBOLX) {
        let Orientation;
        (function (Orientation) {
            Orientation.Inline = Prefixes_1.Prefixes.sbolx + 'inline';
            Orientation.ReverseComplement = Prefixes_1.Prefixes.sbolx + 'reverseComplement';
        })(Orientation = SBOLX.Orientation || (SBOLX.Orientation = {}));
        let Direction;
        (function (Direction) {
            Direction.Input = Prefixes_1.Prefixes.sbolx + 'in';
            Direction.Output = Prefixes_1.Prefixes.sbolx + 'out';
            Direction.InputAndOutput = Prefixes_1.Prefixes.sbolx + 'inout';
            Direction.None = Prefixes_1.Prefixes.sbolx + 'none';
        })(Direction = SBOLX.Direction || (SBOLX.Direction = {}));
        let Access;
        (function (Access) {
            Access.PublicAccess = Prefixes_1.Prefixes.sbolx + 'public';
            Access.PrivateAccess = Prefixes_1.Prefixes.sbolx + 'private';
        })(Access = SBOLX.Access || (SBOLX.Access = {}));
        let Type;
        (function (Type) {
            Type.DNA = 'http://www.biopax.org/release/biopax-level3.owl#DnaRegion';
            Type.RNA = 'http://www.biopax.org/release/biopax-level3.owl#RnaRegion';
            Type.Protein = 'http://www.biopax.org/release/biopax-level3.owl#Protein';
            Type.SmallMolecule = 'http://www.biopax.org/release/biopax-level3.owl#SmallMolecule';
            Type.Complex = 'http://www.biopax.org/release/biopax-level3.owl#Complex';
            Type.Effector = 'http://identifiers.org/chebi/CHEBI:35224';
            Type.Circular = Prefixes_1.Prefixes.sequenceOntologyIdentifiersOrg + 'SO:0000988';
        })(Type = SBOLX.Type || (SBOLX.Type = {}));
        let SequenceEncoding;
        (function (SequenceEncoding) {
            SequenceEncoding.NucleicAcid = 'http://www.chem.qmul.ac.uk/iubmb/misc/naseq.html';
            SequenceEncoding.RNA = 'http://www.chem.qmul.ac.uk/iubmb/misc/naseq.html';
            SequenceEncoding.AminoAcid = 'http://www.chem.qmul.ac.uk/iupac/AminoAcid/';
        })(SequenceEncoding = SBOLX.SequenceEncoding || (SBOLX.SequenceEncoding = {}));
        let SequenceConstraint;
        (function (SequenceConstraint) {
            SequenceConstraint.Precedes = Prefixes_1.Prefixes.sbolx + 'precedes';
            SequenceConstraint.OppositeOrientationAs = Prefixes_1.Prefixes.sbolx + 'oppositeOrientationAs';
        })(SequenceConstraint = SBOLX.SequenceConstraint || (SBOLX.SequenceConstraint = {}));
        let ProvRole;
        (function (ProvRole) {
            ProvRole.Design = Prefixes_1.Prefixes.sbolx + 'design';
            ProvRole.Build = Prefixes_1.Prefixes.sbolx + 'build';
            ProvRole.Test = Prefixes_1.Prefixes.sbolx + 'test';
            ProvRole.Learn = Prefixes_1.Prefixes.sbolx + 'learn';
        })(ProvRole = SBOLX.ProvRole || (SBOLX.ProvRole = {}));
        let MapsToRefinement;
        (function (MapsToRefinement) {
            MapsToRefinement.UseLocal = Prefixes_1.Prefixes.sbolx + 'useLocal';
            MapsToRefinement.UseRemote = Prefixes_1.Prefixes.sbolx + 'useRemote';
        })(MapsToRefinement = SBOLX.MapsToRefinement || (SBOLX.MapsToRefinement = {}));
    })(SBOLX = Specifiers.SBOLX || (Specifiers.SBOLX = {}));
    let SBOL3;
    (function (SBOL3) {
        let Orientation;
        (function (Orientation) {
            Orientation.Inline = Prefixes_1.Prefixes.sbol3 + 'inline';
            Orientation.ReverseComplement = Prefixes_1.Prefixes.sbol3 + 'reverseComplement';
        })(Orientation = SBOL3.Orientation || (SBOL3.Orientation = {}));
        let Direction;
        (function (Direction) {
            Direction.Input = Prefixes_1.Prefixes.sbol3 + 'in';
            Direction.Output = Prefixes_1.Prefixes.sbol3 + 'out';
            Direction.InputAndOutput = Prefixes_1.Prefixes.sbol3 + 'inout';
            Direction.None = Prefixes_1.Prefixes.sbol3 + 'none';
        })(Direction = SBOL3.Direction || (SBOL3.Direction = {}));
        let Access;
        (function (Access) {
            Access.PublicAccess = Prefixes_1.Prefixes.sbol3 + 'public';
            Access.PrivateAccess = Prefixes_1.Prefixes.sbol3 + 'private';
        })(Access = SBOL3.Access || (SBOL3.Access = {}));
        let Type;
        (function (Type) {
            Type.DNA = 'http://www.biopax.org/release/biopax-level3.owl#DnaRegion';
            Type.RNA = 'http://www.biopax.org/release/biopax-level3.owl#RnaRegion';
            Type.Protein = 'http://www.biopax.org/release/biopax-level3.owl#Protein';
            Type.SmallMolecule = 'http://www.biopax.org/release/biopax-level3.owl#SmallMolecule';
            Type.Complex = 'http://www.biopax.org/release/biopax-level3.owl#Complex';
            Type.Effector = 'http://identifiers.org/chebi/CHEBI:35224';
            Type.Circular = Prefixes_1.Prefixes.sequenceOntologyIdentifiersOrg + 'SO:0000988';
        })(Type = SBOL3.Type || (SBOL3.Type = {}));
        let SequenceEncoding;
        (function (SequenceEncoding) {
            SequenceEncoding.NucleicAcid = 'http://www.chem.qmul.ac.uk/iubmb/misc/naseq.html';
            SequenceEncoding.RNA = 'http://www.chem.qmul.ac.uk/iubmb/misc/naseq.html';
            SequenceEncoding.AminoAcid = 'http://www.chem.qmul.ac.uk/iupac/AminoAcid/';
        })(SequenceEncoding = SBOL3.SequenceEncoding || (SBOL3.SequenceEncoding = {}));
        let Constraint;
        (function (Constraint) {
            Constraint.Precedes = Prefixes_1.Prefixes.sbol3 + 'precedes';
            Constraint.OppositeOrientationAs = Prefixes_1.Prefixes.sbol3 + 'oppositeOrientationAs';
        })(Constraint = SBOL3.Constraint || (SBOL3.Constraint = {}));
        let ProvRole;
        (function (ProvRole) {
            ProvRole.Design = Prefixes_1.Prefixes.sbol3 + 'design';
            ProvRole.Build = Prefixes_1.Prefixes.sbol3 + 'build';
            ProvRole.Test = Prefixes_1.Prefixes.sbol3 + 'test';
            ProvRole.Learn = Prefixes_1.Prefixes.sbol3 + 'learn';
        })(ProvRole = SBOL3.ProvRole || (SBOL3.ProvRole = {}));
        let MapsToRefinement;
        (function (MapsToRefinement) {
            MapsToRefinement.UseLocal = Prefixes_1.Prefixes.sbol3 + 'useLocal';
            MapsToRefinement.UseRemote = Prefixes_1.Prefixes.sbol3 + 'useRemote';
        })(MapsToRefinement = SBOL3.MapsToRefinement || (SBOL3.MapsToRefinement = {}));
    })(SBOL3 = Specifiers.SBOL3 || (Specifiers.SBOL3 = {}));
    let Visual;
    (function (Visual) {
        /* opacity
         */
        Visual.Blackbox = Prefixes_1.Prefixes.visual + 'blackbox';
        Visual.Whitebox = Prefixes_1.Prefixes.visual + 'whitebox';
        /* display modes
         */
        Visual.Float = Prefixes_1.Prefixes.visual + 'float';
        Visual.Backbone = Prefixes_1.Prefixes.visual + 'backbone';
        /* orientation
         */
        Visual.Forward = Prefixes_1.Prefixes.visual + 'forward';
        Visual.Reverse = Prefixes_1.Prefixes.visual + 'reverse';
        /* expandability
         */
        Visual.Expandable = Prefixes_1.Prefixes.visual + 'expandable';
        Visual.NotExpandable = Prefixes_1.Prefixes.visual + 'notExpandable';
        Visual.AnchorTop = Prefixes_1.Prefixes.visual + 'anchorTop';
        Visual.AnchorMid = Prefixes_1.Prefixes.visual + 'anchorMid';
        Visual.AnchorBottom = Prefixes_1.Prefixes.visual + 'anchorBottom';
    })(Visual = Specifiers.Visual || (Specifiers.Visual = {}));
    let SO;
    (function (SO) {
        SO.CDS = Prefixes_1.Prefixes.sequenceOntologyIdentifiersOrg + 'SO:0000316';
        SO.Promoter = Prefixes_1.Prefixes.sequenceOntologyIdentifiersOrg + 'SO:0000167';
        SO.RBS = Prefixes_1.Prefixes.sequenceOntologyIdentifiersOrg + 'SO:0000139';
        SO.RestrictionSite = Prefixes_1.Prefixes.sequenceOntologyIdentifiersOrg + 'SO:0001687';
        SO.Terminator = Prefixes_1.Prefixes.sequenceOntologyIdentifiersOrg + 'SO:0000141';
        SO.OriginOfReplication = Prefixes_1.Prefixes.sequenceOntologyIdentifiersOrg + 'SO:0000296';
        SO.OriginOfTransfer = Prefixes_1.Prefixes.sequenceOntologyIdentifiersOrg + 'SO:0000724';
        SO.PlasmidBackbone = Prefixes_1.Prefixes.sequenceOntologyIdentifiersOrg + 'SO:0000755';
        SO.EngineeredRegion = Prefixes_1.Prefixes.sequenceOntologyIdentifiersOrg + 'SO:0000804';
    })(SO = Specifiers.SO || (Specifiers.SO = {}));
    let SBO;
    (function (SBO) {
        SBO.Inhibition = Prefixes_1.Prefixes.sbo + 'SBO:0000169';
        SBO.Inhibitor = Prefixes_1.Prefixes.sbo + 'SBO:0000020';
        SBO.Inhibited = Prefixes_1.Prefixes.sbo + 'SBO:0000642';
        SBO.Stimulation = Prefixes_1.Prefixes.sbo + 'SBO:0000170';
        SBO.Stimulator = Prefixes_1.Prefixes.sbo + 'SBO:0000459';
        SBO.Stimulated = Prefixes_1.Prefixes.sbo + 'SBO:0000643';
        SBO.GeneticProduction = Prefixes_1.Prefixes.sbo + 'SBO:0000589';
        SBO.Product = Prefixes_1.Prefixes.sbo + 'SBO:0000011';
        SBO.Modifier = Prefixes_1.Prefixes.sbo + 'SBO:0000019';
        SBO.Promoter = Prefixes_1.Prefixes.sbo + 'SBO:0000598';
        SBO.Control = Prefixes_1.Prefixes.sbo + 'SBO:0000168';
    })(SBO = Specifiers.SBO || (Specifiers.SBO = {}));
    let GO;
    (function (GO) {
        GO.ProteinDepolymerization = Prefixes_1.Prefixes.go + 'GO:0051261';
        GO.CovalentChromatinModification = Prefixes_1.Prefixes.go + 'GO:0016569';
        GO.ProteinProcessing = Prefixes_1.Prefixes.go + 'GO:0016485';
        GO.ProteinBinding = Prefixes_1.Prefixes.go + 'GO:0005515';
        GO.CatalyticActivity = Prefixes_1.Prefixes.go + 'GO:0003824';
    })(GO = Specifiers.GO || (Specifiers.GO = {}));
    let SyBiOnt;
    (function (SyBiOnt) {
        SyBiOnt.Bidirectional = Prefixes_1.Prefixes.sybio + 'Bidirectional';
        SyBiOnt.LeftToRight = Prefixes_1.Prefixes.sybio + 'LeftToRight';
        SyBiOnt.RightToLeft = Prefixes_1.Prefixes.sybio + 'RightToLeft';
        SyBiOnt.UndefinedDirection = Prefixes_1.Prefixes.sybio + 'UndefinedDirection';
        SyBiOnt.LeftSide = Prefixes_1.Prefixes.sybio + 'LeftSide';
        SyBiOnt.RightSide = Prefixes_1.Prefixes.sybio + 'RightSide';
    })(SyBiOnt = Specifiers.SyBiOnt || (Specifiers.SyBiOnt = {}));
})(Specifiers = exports.Specifiers || (exports.Specifiers = {}));


/***/ }),

/***/ "./node_modules/bioterms/dist/Types.js":
/*!*********************************************!*\
  !*** ./node_modules/bioterms/dist/Types.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const Prefixes_1 = __webpack_require__(/*! ./Prefixes */ "./node_modules/bioterms/dist/Prefixes.js");
var Types;
(function (Types) {
    let SBOL1;
    (function (SBOL1) {
        SBOL1.DnaComponent = Prefixes_1.Prefixes.sbol1 + 'DnaComponent';
        SBOL1.DnaSequence = Prefixes_1.Prefixes.sbol1 + 'DnaSequence';
        SBOL1.Collection = Prefixes_1.Prefixes.sbol1 + 'Collection';
        SBOL1.SequenceAnnotation = Prefixes_1.Prefixes.sbol1 + 'SequenceAnnotation';
    })(SBOL1 = Types.SBOL1 || (Types.SBOL1 = {}));
    let SBOL2;
    (function (SBOL2) {
        SBOL2.ModuleDefinition = Prefixes_1.Prefixes.sbol2 + 'ModuleDefinition';
        SBOL2.ComponentDefinition = Prefixes_1.Prefixes.sbol2 + 'ComponentDefinition';
        SBOL2.Module = Prefixes_1.Prefixes.sbol2 + 'Module';
        SBOL2.Component = Prefixes_1.Prefixes.sbol2 + 'Component';
        SBOL2.Range = Prefixes_1.Prefixes.sbol2 + 'Range';
        SBOL2.Cut = Prefixes_1.Prefixes.sbol2 + 'Cut';
        SBOL2.GenericLocation = Prefixes_1.Prefixes.sbol2 + 'GenericLocation';
        SBOL2.SequenceAnnotation = Prefixes_1.Prefixes.sbol2 + 'SequenceAnnotation';
        SBOL2.SequenceConstraint = Prefixes_1.Prefixes.sbol2 + 'SequenceConstraint';
        SBOL2.Interaction = Prefixes_1.Prefixes.sbol2 + 'Interaction';
        SBOL2.Participation = Prefixes_1.Prefixes.sbol2 + 'Participation';
        SBOL2.Collection = Prefixes_1.Prefixes.sbol2 + 'Collection';
        SBOL2.FunctionalComponent = Prefixes_1.Prefixes.sbol2 + 'FunctionalComponent';
        SBOL2.Sequence = Prefixes_1.Prefixes.sbol2 + 'Sequence';
        SBOL2.MapsTo = Prefixes_1.Prefixes.sbol2 + 'MapsTo';
        SBOL2.Attachment = Prefixes_1.Prefixes.sbol2 + 'Attachment';
        SBOL2.Model = Prefixes_1.Prefixes.sbol2 + 'Model';
        SBOL2.Implementation = Prefixes_1.Prefixes.sbol2 + 'Implementation';
        SBOL2.Experiment = Prefixes_1.Prefixes.sbol2 + 'Experiment';
        SBOL2.ExperimentalData = Prefixes_1.Prefixes.sbol2 + 'ExperimentalData';
    })(SBOL2 = Types.SBOL2 || (Types.SBOL2 = {}));
    let SBOLX;
    (function (SBOLX) {
        SBOLX.Component = Prefixes_1.Prefixes.sbolx + 'Component';
        SBOLX.SubComponent = Prefixes_1.Prefixes.sbolx + 'SubComponent';
        SBOLX.Range = Prefixes_1.Prefixes.sbolx + 'Range';
        SBOLX.Cut = Prefixes_1.Prefixes.sbolx + 'Cut';
        SBOLX.SequenceConstraint = Prefixes_1.Prefixes.sbolx + 'SequenceConstraint';
        SBOLX.Interaction = Prefixes_1.Prefixes.sbolx + 'Interaction';
        SBOLX.Participation = Prefixes_1.Prefixes.sbolx + 'Participation';
        SBOLX.Collection = Prefixes_1.Prefixes.sbolx + 'Collection';
        SBOLX.Sequence = Prefixes_1.Prefixes.sbolx + 'Sequence';
        SBOLX.OrientedLocation = Prefixes_1.Prefixes.sbolx + 'OrientedLocation';
        SBOLX.SequenceAnnotation = Prefixes_1.Prefixes.sbolx + 'SequenceAnnotation';
        SBOLX.Attachment = Prefixes_1.Prefixes.sbolx + 'Attachment';
        SBOLX.Model = Prefixes_1.Prefixes.sbolx + 'Model';
        SBOLX.Implementation = Prefixes_1.Prefixes.sbolx + 'Implementation';
        SBOLX.MapsTo = Prefixes_1.Prefixes.sbolx + 'MapsTo';
        SBOLX.Experiment = Prefixes_1.Prefixes.sbolx + 'Experiment';
        SBOLX.ExperimentalData = Prefixes_1.Prefixes.sbolx + 'ExperimentalData';
    })(SBOLX = Types.SBOLX || (Types.SBOLX = {}));
    let SBOL3;
    (function (SBOL3) {
        SBOL3.Component = Prefixes_1.Prefixes.sbol3 + 'Component';
        SBOL3.SubComponent = Prefixes_1.Prefixes.sbol3 + 'SubComponent';
        SBOL3.Range = Prefixes_1.Prefixes.sbol3 + 'Range';
        SBOL3.Cut = Prefixes_1.Prefixes.sbol3 + 'Cut';
        SBOL3.EntireSequence = Prefixes_1.Prefixes.sbol3 + 'EntireSequence';
        SBOL3.Constraint = Prefixes_1.Prefixes.sbol3 + 'Constraint';
        SBOL3.Interaction = Prefixes_1.Prefixes.sbol3 + 'Interaction';
        SBOL3.Participation = Prefixes_1.Prefixes.sbol3 + 'Participation';
        SBOL3.Collection = Prefixes_1.Prefixes.sbol3 + 'Collection';
        SBOL3.Sequence = Prefixes_1.Prefixes.sbol3 + 'Sequence';
        SBOL3.OrientedLocation = Prefixes_1.Prefixes.sbol3 + 'OrientedLocation';
        SBOL3.SequenceFeature = Prefixes_1.Prefixes.sbol3 + 'SequenceFeature';
        SBOL3.Attachment = Prefixes_1.Prefixes.sbol3 + 'Attachment';
        SBOL3.Model = Prefixes_1.Prefixes.sbol3 + 'Model';
        SBOL3.Implementation = Prefixes_1.Prefixes.sbol3 + 'Implementation';
        SBOL3.MapsTo = Prefixes_1.Prefixes.sbol3 + 'MapsTo';
        SBOL3.Experiment = Prefixes_1.Prefixes.sbol3 + 'Experiment';
        SBOL3.ExperimentalData = Prefixes_1.Prefixes.sbol3 + 'ExperimentalData';
        SBOL3.Namespace = Prefixes_1.Prefixes.sbol3 + 'Namespace';
    })(SBOL3 = Types.SBOL3 || (Types.SBOL3 = {}));
    let Visual;
    (function (Visual) {
        Visual.ModuleDepiction = Prefixes_1.Prefixes.visual + 'ModuleDepiction';
        Visual.ComponentDepiction = Prefixes_1.Prefixes.visual + 'ComponentDepiction';
        Visual.Glyph = Prefixes_1.Prefixes.visual + 'Glyph';
        Visual.Label = Prefixes_1.Prefixes.visual + 'Label';
    })(Visual = Types.Visual || (Types.Visual = {}));
    let SyBiOnt;
    (function (SyBiOnt) {
        SyBiOnt.Protein = Prefixes_1.Prefixes.sybio + 'Protein';
        SyBiOnt.InduciblePromoter = Prefixes_1.Prefixes.sybio + 'InduciblePromoter';
        SyBiOnt.Reaction = Prefixes_1.Prefixes.sybio + 'Reaction';
        SyBiOnt.ReactionParticipant = Prefixes_1.Prefixes.sybio + 'ReactionParticipant';
        SyBiOnt.Compound = Prefixes_1.Prefixes.sybio + 'Compound';
    })(SyBiOnt = Types.SyBiOnt || (Types.SyBiOnt = {}));
    let Prov;
    (function (Prov) {
        Prov.Agent = Prefixes_1.Prefixes.prov + 'Agent';
        Prov.Association = Prefixes_1.Prefixes.prov + 'Association';
        Prov.Activity = Prefixes_1.Prefixes.prov + 'Activity';
        Prov.Usage = Prefixes_1.Prefixes.prov + 'Usage';
        Prov.Plan = Prefixes_1.Prefixes.prov + 'Plan';
    })(Prov = Types.Prov || (Types.Prov = {}));
    let Enrichment;
    (function (Enrichment) {
        Enrichment.GeneProduct = Prefixes_1.Prefixes.enrichment + 'GeneProduct';
    })(Enrichment = Types.Enrichment || (Types.Enrichment = {}));
    let Measure;
    (function (Measure_1) {
        Measure_1.Measure = Prefixes_1.Prefixes.measure + 'Measure';
    })(Measure = Types.Measure || (Types.Measure = {}));
})(Types = exports.Types || (exports.Types = {}));


/***/ }),

/***/ "./node_modules/bioterms/dist/index.js":
/*!*********************************************!*\
  !*** ./node_modules/bioterms/dist/index.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const Prefixes_1 = __webpack_require__(/*! ./Prefixes */ "./node_modules/bioterms/dist/Prefixes.js");
exports.Prefixes = Prefixes_1.Prefixes;
exports.prefixify = Prefixes_1.prefixify;
const Types_1 = __webpack_require__(/*! ./Types */ "./node_modules/bioterms/dist/Types.js");
exports.Types = Types_1.Types;
const Predicates_1 = __webpack_require__(/*! ./Predicates */ "./node_modules/bioterms/dist/Predicates.js");
exports.Predicates = Predicates_1.Predicates;
const Specifiers_1 = __webpack_require__(/*! ./Specifiers */ "./node_modules/bioterms/dist/Specifiers.js");
exports.Specifiers = Specifiers_1.Specifiers;
const sequenceOntology_1 = __webpack_require__(/*! ./sequenceOntology */ "./node_modules/bioterms/dist/sequenceOntology.js");
exports.sequenceOntology = sequenceOntology_1.sequenceOntology;
exports.uriToName = sequenceOntology_1.uriToName;


/***/ }),

/***/ "./node_modules/bioterms/dist/sequenceOntology.js":
/*!********************************************************!*\
  !*** ./node_modules/bioterms/dist/sequenceOntology.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
function uriToName(uri) {
    let temp = uri.split('/');
    let id = temp.pop();
    let entry = sequenceOntology.so[id];
    if (!entry)
        return undefined;
    let name = entry['name'];
    return name;
}
exports.uriToName = uriToName;
var sequenceOntology;
(function (sequenceOntology) {
    sequenceOntology.so = {
        "SO:0000000": {
            "name": "Sequence_Ontology"
        },
        "SO:0000001": {
            "name": "region",
            "def": "A sequence_feature with an extent greater than zero. A nucleotide region is composed of bases and a polypeptide region is composed of amino acids. [SO:ke]"
        },
        "SO:0000002": {
            "name": "sequence_secondary_structure",
            "def": "A folded sequence. [SO:ke]"
        },
        "SO:0000003": {
            "name": "G_quartet",
            "def": "G-quartets are unusual nucleic acid structures consisting of a planar arrangement where each guanine is hydrogen bonded by hoogsteen pairing to another guanine in the quartet. [http://www.ncbi.nlm.nih.gov/pubmed/7919797?dopt=Abstract]"
        },
        "SO:0000004": {
            "name": "interior_coding_exon"
        },
        "SO:0000005": {
            "name": "satellite_DNA",
            "def": "The many tandem repeats (identical or related) of a short basic repeating unit; many have a base composition or other property different from the genome average that allows them to be separated from the bulk (main band) genomic DNA. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000006": {
            "name": "PCR_product",
            "def": "A region amplified by a PCR reaction. [SO:ke]"
        },
        "SO:0000007": {
            "name": "read_pair",
            "def": "One of a pair of sequencing reads in which the two members of the pair are related by originating at either end of a clone insert. [SO:ls]"
        },
        "SO:0000008": {
            "name": "gene_sensu_your_favorite_organism"
        },
        "SO:0000009": {
            "name": "gene_class"
        },
        "SO:0000010": {
            "name": "protein_coding"
        },
        "SO:0000011": {
            "name": "non_protein_coding"
        },
        "SO:0000012": {
            "name": "scRNA_primary_transcript",
            "def": "The primary transcript of any one of several small cytoplasmic RNA molecules present in the cytoplasm and sometimes nucleus of a Eukaryote. [http://www.ebi.ac.uk/embl/WebFeat/align/scRNA_s.html]"
        },
        "SO:0000013": {
            "name": "scRNA",
            "def": "A small non coding RNA sequence, present in the cytoplasm. [SO:ke]"
        },
        "SO:0000014": {
            "name": "INR_motif",
            "def": "A sequence element characteristic of some RNA polymerase II promoters required for the correct positioning of the polymerase for the start of transcription. Overlaps the TSS. The mammalian consensus sequence is YYAN(T|A)YY; the Drosophila consensus sequence is TCA(G|T)t(T|C). In each the A is at position +1 with respect to the TSS. Functionally similar to the TATA box element. [PMID:12651739, PMID:16858867]"
        },
        "SO:0000015": {
            "name": "DPE_motif",
            "def": "A sequence element characteristic of some RNA polymerase II promoters; Positioned from +28 to +32 with respect to the TSS (+1). Experimental results suggest that the DPE acts in conjunction with the INR_motif to provide a binding site for TFIID in the absence of a TATA box to mediate transcription of TATA-less promoters. Consensus sequence (A|G)G(A|T)(C|T)(G|A|C). [PMID:12651739:12537576, PMID:16858867]"
        },
        "SO:0000016": {
            "name": "BREu_motif",
            "def": "A sequence element characteristic of some RNA polymerase II promoters, located immediately upstream of some TATA box elements at -37 to -32 with respect to the TSS (+1). Consensus sequence is (G|C)(G|C)(G|A)CGCC. Binds TFIIB. [PMID:12651739, PMID:16858867]"
        },
        "SO:0000017": {
            "name": "PSE_motif",
            "def": "A sequence element characteristic of the promoters of snRNA genes transcribed by RNA polymerase II or by RNA polymerase III. Located between -45 and -60 relative to the TSS. The human PSE_motif consensus sequence is TCACCNTNA(C|G)TNAAAAG(T|G). [PMID:12651739]"
        },
        "SO:0000018": {
            "name": "linkage_group",
            "def": "A group of loci that can be grouped in a linear order representing the different degrees of linkage among the genes concerned. [ISBN:038752046]"
        },
        "SO:0000020": {
            "name": "RNA_internal_loop",
            "def": "A region of double stranded RNA where the bases do not conform to WC base pairing. The loop is closed on both sides by canonical base pairing. If the interruption to base pairing occurs on one strand only, it is known as a bulge. [SO:ke]"
        },
        "SO:0000021": {
            "name": "asymmetric_RNA_internal_loop",
            "def": "An internal RNA loop where one of the strands includes more bases than the corresponding region on the other strand. [SO:ke]"
        },
        "SO:0000022": {
            "name": "A_minor_RNA_motif",
            "def": "A region forming a motif, composed of adenines, where the minor groove edges are inserted into the minor groove of another helix. [SO:ke]"
        },
        "SO:0000023": {
            "name": "K_turn_RNA_motif",
            "def": "The kink turn (K-turn) is an RNA structural motif that creates a sharp (~120 degree) bend between two continuous helices. [SO:ke]"
        },
        "SO:0000024": {
            "name": "sarcin_like_RNA_motif",
            "def": "A loop in ribosomal RNA containing the sites of attack for ricin and sarcin. [http://www.ncbi.nlm.nih.gov/pubmed/7897662]"
        },
        "SO:0000025": {
            "name": "symmetric_RNA_internal_loop",
            "def": "An internal RNA loop where the extent of the loop on both stands is the same size. [SO:ke]"
        },
        "SO:0000026": {
            "name": "RNA_junction_loop"
        },
        "SO:0000027": {
            "name": "RNA_hook_turn"
        },
        "SO:0000028": {
            "name": "base_pair"
        },
        "SO:0000029": {
            "name": "WC_base_pair",
            "def": "The canonical base pair, where two bases interact via WC edges, with glycosidic bonds oriented cis relative to the axis of orientation. [PMID:12177293]"
        },
        "SO:0000030": {
            "name": "sugar_edge_base_pair",
            "def": "A type of non-canonical base-pairing. [PMID:12177293]"
        },
        "SO:0000031": {
            "name": "aptamer",
            "def": "DNA or RNA molecules that have been selected from random pools based on their ability to bind other molecules. [http://aptamer.icmb.utexas.edu]"
        },
        "SO:0000032": {
            "name": "DNA_aptamer",
            "def": "DNA molecules that have been selected from random pools based on their ability to bind other molecules. [http:aptamer.icmb.utexas.edu]"
        },
        "SO:0000033": {
            "name": "RNA_aptamer",
            "def": "RNA molecules that have been selected from random pools based on their ability to bind other molecules. [http://aptamer.icmb.utexas.edu]"
        },
        "SO:0000034": {
            "name": "morpholino_oligo",
            "def": "Morpholino oligos are synthesized from four different Morpholino subunits, each of which contains one of the four genetic bases (A, C, G, T) linked to a 6-membered morpholine ring. Eighteen to 25 subunits of these four subunit types are joined in a specific order by non-ionic phosphorodiamidate intersubunit linkages to give a Morpholino. [http://www.gene-tools.com/]"
        },
        "SO:0000035": {
            "name": "riboswitch",
            "def": "A riboswitch is a part of an mRNA that can act as a direct sensor of small molecules to control their own expression. A riboswitch is a cis element in the 5' end of an mRNA, that acts as a direct sensor of metabolites. [PMID:2820954]"
        },
        "SO:0000036": {
            "name": "matrix_attachment_site",
            "def": "A DNA region that is required for the binding of chromatin to the nuclear matrix. [SO:ma]"
        },
        "SO:0000037": {
            "name": "locus_control_region",
            "def": "A DNA region that includes DNAse hypersensitive sites located 5' to a gene that confers the high-level, position-independent, and copy number-dependent expression to that gene. [SO:ma]"
        },
        "SO:0000038": {
            "name": "match_set",
            "def": "A collection of match parts. [SO:ke]"
        },
        "SO:0000039": {
            "name": "match_part",
            "def": "A part of a match, for example an hsp from blast is a match_part. [SO:ke]"
        },
        "SO:0000040": {
            "name": "genomic_clone",
            "def": "A clone of a DNA region of a genome. [SO:ma]"
        },
        "SO:0000041": {
            "name": "sequence_operation",
            "def": "An operation that can be applied to a sequence, that results in a change. [SO:ke]"
        },
        "SO:0000042": {
            "name": "pseudogene_attribute",
            "def": "An attribute of a pseudogene (SO:0000336). [SO:ma]"
        },
        "SO:0000043": {
            "name": "processed_pseudogene",
            "def": "A pseudogene where by an mRNA was retrotransposed. The mRNA sequence is transcribed back into the genome, lacking introns and promoters, but often including a polyA tail. [SO:xp]"
        },
        "SO:0000044": {
            "name": "pseudogene_by_unequal_crossing_over",
            "def": "A pseudogene caused by unequal crossing over at recombination. [SO:ke]"
        },
        "SO:0000045": {
            "name": "delete",
            "def": "To remove a subsection of sequence. [SO:ke]"
        },
        "SO:0000046": {
            "name": "insert",
            "def": "To insert a subsection of sequence. [SO:ke]"
        },
        "SO:0000047": {
            "name": "invert",
            "def": "To invert a subsection of sequence. [SO:ke]"
        },
        "SO:0000048": {
            "name": "substitute",
            "def": "To substitute a subsection of sequence for another. [SO:ke]"
        },
        "SO:0000049": {
            "name": "translocate",
            "def": "To translocate a subsection of sequence. [SO:ke]"
        },
        "SO:0000050": {
            "name": "gene_part",
            "def": "A part of a gene, that has no other route in the ontology back to region. This concept is necessary for logical inference as these parts must have the properties of region. It also allows us to associate all the parts of genes with a gene. [SO:ke]"
        },
        "SO:0000051": {
            "name": "probe",
            "def": "A DNA sequence used experimentally to detect the presence or absence of a complementary nucleic acid. [SO:ma]"
        },
        "SO:0000052": {
            "name": "assortment_derived_deficiency"
        },
        "SO:0000053": {
            "name": "sequence_variant_affecting_regulatory_region",
            "def": "A sequence_variant_effect which changes the regulatory region of a gene. [SO:ke]"
        },
        "SO:0000054": {
            "name": "aneuploid",
            "def": "A kind of chromosome variation where the chromosome complement is not an exact multiple of the haploid number. [SO:ke]"
        },
        "SO:0000055": {
            "name": "hyperploid",
            "def": "A kind of chromosome variation where the chromosome complement is not an exact multiple of the haploid number as extra chromosomes are present. [SO:ke]"
        },
        "SO:0000056": {
            "name": "hypoploid",
            "def": "A kind of chromosome variation where the chromosome complement is not an exact multiple of the haploid number as some chromosomes are missing. [SO:ke]"
        },
        "SO:0000057": {
            "name": "operator",
            "def": "A regulatory element of an operon to which activators or repressors bind thereby effecting translation of genes in that operon. [SO:ma]"
        },
        "SO:0000058": {
            "name": "assortment_derived_aneuploid"
        },
        "SO:0000059": {
            "name": "nuclease_binding_site",
            "def": "A binding site that, of a nucleotide molecule, that interacts selectively and non-covalently with polypeptide residues of a nuclease. [SO:cb]"
        },
        "SO:0000060": {
            "name": "compound_chromosome_arm"
        },
        "SO:0000061": {
            "name": "restriction_enzyme_binding_site",
            "def": "A binding site that, in the nucleotide molecule, interacts selectively and non-covalently with polypeptide residues of a restriction enzyme. [SO:cb]"
        },
        "SO:0000062": {
            "name": "deficient_intrachromosomal_transposition",
            "def": "An intrachromosomal transposition whereby a translocation in which one of the four broken ends loses a segment before re-joining. [FB:reference_manual]"
        },
        "SO:0000063": {
            "name": "deficient_interchromosomal_transposition",
            "def": "An interchromosomal transposition whereby a translocation in which one of the four broken ends loses a segment before re-joining. [SO:ke]"
        },
        "SO:0000064": {
            "name": "gene_by_transcript_attribute"
        },
        "SO:0000065": {
            "name": "free_chromosome_arm",
            "def": "A chromosome structure variation whereby an arm exists as an individual chromosome element. [SO:ke]"
        },
        "SO:0000066": {
            "name": "gene_by_polyadenylation_attribute"
        },
        "SO:0000067": {
            "name": "gene_to_gene_feature"
        },
        "SO:0000068": {
            "name": "overlapping",
            "def": "An attribute describing a gene that has a sequence that overlaps the sequence of another gene. [SO:ke]"
        },
        "SO:0000069": {
            "name": "inside_intron",
            "def": "An attribute to describe a gene when it is located within the intron of another gene. [SO:ke]"
        },
        "SO:0000070": {
            "name": "inside_intron_antiparallel",
            "def": "An attribute to describe a gene when it is located within the intron of another gene and on the opposite strand. [SO:ke]"
        },
        "SO:0000071": {
            "name": "inside_intron_parallel",
            "def": "An attribute to describe a gene when it is located within the intron of another gene and on the same strand. [SO:ke]"
        },
        "SO:0000072": {
            "name": "end_overlapping_gene"
        },
        "SO:0000073": {
            "name": "five_prime_three_prime_overlap",
            "def": "An attribute to describe a gene when the five prime region overlaps with another gene's 3' region. [SO:ke]"
        },
        "SO:0000074": {
            "name": "five_prime_five_prime_overlap",
            "def": "An attribute to describe a gene when the five prime region overlaps with another gene's five prime region. [SO:ke]"
        },
        "SO:0000075": {
            "name": "three_prime_three_prime_overlap",
            "def": "An attribute to describe a gene when the 3' region overlaps with another gene's 3' region. [SO:ke]"
        },
        "SO:0000076": {
            "name": "three_prime_five_prime_overlap",
            "def": "An attribute to describe a gene when the 3' region overlaps with another gene's 5' region. [SO:ke]"
        },
        "SO:0000077": {
            "name": "antisense",
            "def": "A region sequence that is complementary to a sequence of messenger RNA. [SO:ke]"
        },
        "SO:0000078": {
            "name": "polycistronic_transcript",
            "def": "A transcript that is polycistronic. [SO:xp]"
        },
        "SO:0000079": {
            "name": "dicistronic_transcript",
            "def": "A transcript that is dicistronic. [SO:ke]"
        },
        "SO:0000080": {
            "name": "operon_member"
        },
        "SO:0000081": {
            "name": "gene_array_member"
        },
        "SO:0000082": {
            "name": "processed_transcript_attribute"
        },
        "SO:0000083": {
            "name": "macronuclear_sequence"
        },
        "SO:0000084": {
            "name": "micronuclear_sequence"
        },
        "SO:0000085": {
            "name": "gene_by_genome_location"
        },
        "SO:0000086": {
            "name": "gene_by_organelle_of_genome"
        },
        "SO:0000087": {
            "name": "nuclear_gene",
            "def": "A gene from nuclear sequence. [SO:xp]"
        },
        "SO:0000088": {
            "name": "mt_gene",
            "def": "A gene located in mitochondrial sequence. [SO:xp]"
        },
        "SO:0000089": {
            "name": "kinetoplast_gene",
            "def": "A gene located in kinetoplast sequence. [SO:xp]"
        },
        "SO:0000090": {
            "name": "plastid_gene",
            "def": "A gene from plastid sequence. [SO:xp]"
        },
        "SO:0000091": {
            "name": "apicoplast_gene",
            "def": "A gene from apicoplast sequence. [SO:xp]"
        },
        "SO:0000092": {
            "name": "ct_gene",
            "def": "A gene from chloroplast sequence. [SO:xp]"
        },
        "SO:0000093": {
            "name": "chromoplast_gene",
            "def": "A gene from chromoplast_sequence. [SO:xp]"
        },
        "SO:0000094": {
            "name": "cyanelle_gene",
            "def": "A gene from cyanelle sequence. [SO:xp]"
        },
        "SO:0000095": {
            "name": "leucoplast_gene",
            "def": "A plastid gene from leucoplast sequence. [SO:xp]"
        },
        "SO:0000096": {
            "name": "proplastid_gene",
            "def": "A gene from proplastid sequence. [SO:ke]"
        },
        "SO:0000097": {
            "name": "nucleomorph_gene",
            "def": "A gene from nucleomorph sequence. [SO:xp]"
        },
        "SO:0000098": {
            "name": "plasmid_gene",
            "def": "A gene from plasmid sequence. [SO:xp]"
        },
        "SO:0000099": {
            "name": "proviral_gene",
            "def": "A gene from proviral sequence. [SO:xp]"
        },
        "SO:0000100": {
            "name": "endogenous_retroviral_gene",
            "def": "A proviral gene with origin endogenous retrovirus. [SO:xp]"
        },
        "SO:0000101": {
            "name": "transposable_element",
            "def": "A transposon or insertion sequence. An element that can insert in a variety of DNA sequences. [http://www.sci.sdsu.edu/~smaloy/Glossary/T.html]"
        },
        "SO:0000102": {
            "name": "expressed_sequence_match",
            "def": "A match to an EST or cDNA sequence. [SO:ke]"
        },
        "SO:0000103": {
            "name": "clone_insert_end",
            "def": "The end of the clone insert. [SO:ke]"
        },
        "SO:0000104": {
            "name": "polypeptide",
            "def": "A sequence of amino acids linked by peptide bonds which may lack appreciable tertiary structure and may not be liable to irreversible denaturation. [SO:ma]"
        },
        "SO:0000105": {
            "name": "chromosome_arm",
            "def": "A region of the chromosome between the centromere and the telomere. Human chromosomes have two arms, the p arm (short) and the q arm (long) which are separated from each other by the centromere. [http://www.medterms.com/script/main/art.asp?articlekey=5152]"
        },
        "SO:0000106": {
            "name": "non_capped_primary_transcript"
        },
        "SO:0000107": {
            "name": "sequencing_primer"
        },
        "SO:0000108": {
            "name": "mRNA_with_frameshift",
            "def": "An mRNA with a frameshift. [SO:xp]"
        },
        "SO:0000109": {
            "name": "sequence_variant_obs",
            "def": "A sequence_variant is a non exact copy of a sequence_feature or genome exhibiting one or more sequence_alteration. [SO:ke]"
        },
        "SO:0000110": {
            "name": "sequence_feature",
            "def": "Any extent of continuous biological sequence. [LAMHDI:mb, SO:ke]"
        },
        "SO:0000111": {
            "name": "transposable_element_gene",
            "def": "A gene encoded within a transposable element. For example gag, int, env and pol are the transposable element genes of the TY element in yeast. [SO:ke]"
        },
        "SO:0000112": {
            "name": "primer",
            "def": "An oligo to which new deoxyribonucleotides can be added by DNA polymerase. [SO:ke]"
        },
        "SO:0000113": {
            "name": "proviral_region",
            "def": "A viral sequence which has integrated into a host genome. [SO:ke]"
        },
        "SO:0000114": {
            "name": "methylated_cytosine",
            "def": "A methylated deoxy-cytosine. [SO:ke]"
        },
        "SO:0000115": {
            "name": "transcript_feature"
        },
        "SO:0000116": {
            "name": "edited",
            "def": "An attribute describing a sequence that is modified by editing. [SO:ke]"
        },
        "SO:0000117": {
            "name": "transcript_with_readthrough_stop_codon"
        },
        "SO:0000118": {
            "name": "transcript_with_translational_frameshift",
            "def": "A transcript with a translational frameshift. [SO:xp]"
        },
        "SO:0000119": {
            "name": "regulated",
            "def": "An attribute to describe a sequence that is regulated. [SO:ke]"
        },
        "SO:0000120": {
            "name": "protein_coding_primary_transcript",
            "def": "A primary transcript that, at least in part, encodes one or more proteins. [SO:ke]"
        },
        "SO:0000121": {
            "name": "forward_primer",
            "def": "A single stranded oligo used for polymerase chain reaction. [http://mged.sourceforge.net/ontologies/MGEDontology.php]"
        },
        "SO:0000122": {
            "name": "RNA_sequence_secondary_structure",
            "def": "A folded RNA sequence. [SO:ke]"
        },
        "SO:0000123": {
            "name": "transcriptionally_regulated",
            "def": "An attribute describing a gene that is regulated at transcription. [SO:ma]"
        },
        "SO:0000124": {
            "name": "transcriptionally_constitutive",
            "def": "Expressed in relatively constant amounts without regard to cellular environmental conditions such as the concentration of a particular substrate. [SO:ke]"
        },
        "SO:0000125": {
            "name": "transcriptionally_induced",
            "def": "An inducer molecule is required for transcription to occur. [SO:ke]"
        },
        "SO:0000126": {
            "name": "transcriptionally_repressed",
            "def": "A repressor molecule is required for transcription to stop. [SO:ke]"
        },
        "SO:0000127": {
            "name": "silenced_gene",
            "def": "A gene that is silenced. [SO:xp]"
        },
        "SO:0000128": {
            "name": "gene_silenced_by_DNA_modification",
            "def": "A gene that is silenced by DNA modification. [SO:xp]"
        },
        "SO:0000129": {
            "name": "gene_silenced_by_DNA_methylation",
            "def": "A gene that is silenced by DNA methylation. [SO:xp]"
        },
        "SO:0000130": {
            "name": "post_translationally_regulated",
            "def": "An attribute describing a gene that is regulated after it has been translated. [SO:ke]"
        },
        "SO:0000131": {
            "name": "translationally_regulated",
            "def": "An attribute describing a gene that is regulated as it is translated. [SO:ke]"
        },
        "SO:0000132": {
            "name": "reverse_primer",
            "def": "A single stranded oligo used for polymerase chain reaction. [http://mged.sourceforge.net/ontologies/MGEDontology.php]"
        },
        "SO:0000133": {
            "name": "epigenetically_modified",
            "def": "This attribute describes a gene where heritable changes other than those in the DNA sequence occur. These changes include: modification to the DNA (such as DNA methylation, the covalent modification of cytosine), and post-translational modification of histones. [SO:ke]"
        },
        "SO:0000134": {
            "name": "genomically_imprinted",
            "def": "Imprinted genes are epigenetically modified genes that are expressed monoallelically according to their parent of origin. [SO:ke]"
        },
        "SO:0000135": {
            "name": "maternally_imprinted",
            "def": "The maternal copy of the gene is modified, rendering it transcriptionally silent. [SO:ke]"
        },
        "SO:0000136": {
            "name": "paternally_imprinted",
            "def": "The paternal copy of the gene is modified, rendering it transcriptionally silent. [SO:ke]"
        },
        "SO:0000137": {
            "name": "allelically_excluded",
            "def": "Allelic exclusion is a process occurring in diploid organisms, where a gene is inactivated and not expressed in that cell. [SO:ke]"
        },
        "SO:0000138": {
            "name": "gene_rearranged_at_DNA_level",
            "def": "An epigenetically modified gene, rearranged at the DNA level. [SO:xp]"
        },
        "SO:0000139": {
            "name": "ribosome_entry_site",
            "def": "Region in mRNA where ribosome assembles. [SO:ke]"
        },
        "SO:0000140": {
            "name": "attenuator",
            "def": "A sequence segment located within the five prime end of an mRNA that causes premature termination of translation. [SO:as]"
        },
        "SO:0000141": {
            "name": "terminator",
            "def": "The sequence of DNA located either at the end of the transcript that causes RNA polymerase to terminate transcription. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000142": {
            "name": "DNA_sequence_secondary_structure",
            "def": "A folded DNA sequence. [SO:ke]"
        },
        "SO:0000143": {
            "name": "assembly_component",
            "def": "A region of known length which may be used to manufacture a longer region. [SO:ke]"
        },
        "SO:0000144": {
            "name": "primary_transcript_attribute"
        },
        "SO:0000145": {
            "name": "recoded_codon",
            "def": "A codon that has been redefined at translation. The redefinition may be as a result of translational bypass, translational frameshifting or stop codon readthrough. [SO:xp]"
        },
        "SO:0000146": {
            "name": "capped",
            "def": "An attribute describing when a sequence, usually an mRNA is capped by the addition of a modified guanine nucleotide at the 5' end. [SO:ke]"
        },
        "SO:0000147": {
            "name": "exon",
            "def": "A region of the transcript sequence within a gene which is not removed from the primary RNA transcript by RNA splicing. [SO:ke]"
        },
        "SO:0000148": {
            "name": "supercontig",
            "def": "One or more contigs that have been ordered and oriented using end-read information. Contains gaps that are filled with N's. [SO:ls]"
        },
        "SO:0000149": {
            "name": "contig",
            "def": "A contiguous sequence derived from sequence assembly. Has no gaps, but may contain N's from unavailable bases. [SO:ls]"
        },
        "SO:0000150": {
            "name": "read",
            "def": "A sequence obtained from a single sequencing experiment. Typically a read is produced when a base calling program interprets information from a chromatogram trace file produced from a sequencing machine. [SO:rd]"
        },
        "SO:0000151": {
            "name": "clone",
            "def": "A piece of DNA that has been inserted in a vector so that it can be propagated in a host bacterium or some other organism. [SO:ke]"
        },
        "SO:0000152": {
            "name": "YAC",
            "def": "Yeast Artificial Chromosome, a vector constructed from the telomeric, centromeric, and replication origin sequences needed for replication in yeast cells. [SO:ma]"
        },
        "SO:0000153": {
            "name": "BAC",
            "def": "Bacterial Artificial Chromosome, a cloning vector that can be propagated as mini-chromosomes in a bacterial host. [SO:ma]"
        },
        "SO:0000154": {
            "name": "PAC",
            "def": "The P1-derived artificial chromosome are DNA constructs that are derived from the DNA of P1 bacteriophage. They can carry large amounts (about 100-300 kilobases) of other sequences for a variety of bioengineering purposes. It is one type of vector used to clone DNA fragments (100- to 300-kb insert size; average, 150 kb) in Escherichia coli cells. [http://en.wikipedia.org/wiki/P1-derived_artificial_chromosome]"
        },
        "SO:0000155": {
            "name": "plasmid",
            "def": "A self replicating, using the hosts cellular machinery, often circular nucleic acid molecule that is distinct from a chromosome in the organism. [SO:ma]"
        },
        "SO:0000156": {
            "name": "cosmid",
            "def": "A cloning vector that is a hybrid of lambda phages and a plasmid that can be propagated as a plasmid or packaged as a phage,since they retain the lambda cos sites. [SO:ma]"
        },
        "SO:0000157": {
            "name": "phagemid",
            "def": "A plasmid which carries within its sequence a bacteriophage replication origin. When the host bacterium is infected with \\helper\\ phage, a phagemid is replicated along with the phage DNA and packaged into phage capsids. [SO:ma]"
        },
        "SO:0000158": {
            "name": "fosmid",
            "def": "A cloning vector that utilizes the E. coli F factor. [SO:ma]"
        },
        "SO:0000159": {
            "name": "deletion",
            "def": "The point at which one or more contiguous nucleotides were excised. [SO:ke]"
        },
        "SO:0000160": {
            "name": "lambda_clone",
            "def": "A linear clone derived from lambda bacteriophage. The genes involved in the lysogenic pathway are removed from the from the viral DNA. Up to 25 kb of foreign DNA can then be inserted into the lambda genome. [ISBN:0-1767-2380-8]"
        },
        "SO:0000161": {
            "name": "methylated_adenine",
            "def": "A modified  base in which adenine has been methylated. [SO:ke]"
        },
        "SO:0000162": {
            "name": "splice_site",
            "def": "Consensus region of primary transcript bordering junction of splicing. A region that overlaps exactly 2 base and adjacent_to splice_junction. [SO:cjm, SO:ke]"
        },
        "SO:0000163": {
            "name": "five_prime_cis_splice_site",
            "def": "Intronic 2 bp region bordering the exon, at the 5' edge of the intron. A splice_site that is downstream_adjacent_to exon and starts intron. [http://www.ucl.ac.uk/~ucbhjow/b241/glossary.html, SO:cjm, SO:ke]"
        },
        "SO:0000164": {
            "name": "three_prime_cis_splice_site",
            "def": "Intronic 2 bp region bordering the exon, at the 3' edge of the intron. A splice_site that is upstream_adjacent_to exon and finishes intron. [http://www.ucl.ac.uk/~ucbhjow/b241/glossary.html, SO:cjm, SO:ke]"
        },
        "SO:0000165": {
            "name": "enhancer",
            "def": "A cis-acting sequence that increases the utilization of (some) eukaryotic promoters, and can function in either orientation and in any location (upstream or downstream) relative to the promoter. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000166": {
            "name": "enhancer_bound_by_factor",
            "def": "An enhancer bound by a factor. [SO:xp]"
        },
        "SO:0000167": {
            "name": "promoter",
            "def": "A regulatory_region composed of the TSS(s) and binding sites for TF_complexes of the basal transcription machinery. [SO:regcreative]"
        },
        "SO:0000168": {
            "name": "restriction_enzyme_cut_site",
            "def": "A specific nucleotide sequence of DNA at or near which a particular restriction enzyme cuts the DNA. [SO:ma]"
        },
        "SO:0000169": {
            "name": "RNApol_I_promoter",
            "def": "A DNA sequence in eukaryotic DNA to which RNA polymerase I binds, to begin transcription. [SO:ke]"
        },
        "SO:0000170": {
            "name": "RNApol_II_promoter",
            "def": "A DNA sequence in eukaryotic DNA to which RNA polymerase II binds, to begin transcription. [SO:ke]"
        },
        "SO:0000171": {
            "name": "RNApol_III_promoter",
            "def": "A DNA sequence in eukaryotic DNA to which RNA polymerase III binds, to begin transcription. [SO:ke]"
        },
        "SO:0000172": {
            "name": "CAAT_signal",
            "def": "Part of a conserved sequence located about 75-bp upstream of the start point of eukaryotic transcription units which may be involved in RNA polymerase binding; consensus=GG(C|T)CAATCT. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000173": {
            "name": "GC_rich_promoter_region",
            "def": "A conserved GC-rich region located upstream of the start point of eukaryotic transcription units which may occur in multiple copies or in either orientation; consensus=GGGCGG. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000174": {
            "name": "TATA_box",
            "def": "A conserved AT-rich septamer found about 25-bp before the start point of many eukaryotic RNA polymerase II transcript units; may be involved in positioning the enzyme for correct initiation; consensus=TATA(A|T)A(A|T). [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html, PMID:16858867]"
        },
        "SO:0000175": {
            "name": "minus_10_signal",
            "def": "A conserved region about 10-bp upstream of the start point of bacterial transcription units which may be involved in binding RNA polymerase; consensus=TAtAaT. This region is associated with sigma factor 70. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000176": {
            "name": "minus_35_signal",
            "def": "A conserved hexamer about 35-bp upstream of the start point of bacterial transcription units; consensus=TTGACa or TGTTGACA. This region is associated with sigma factor 70. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000177": {
            "name": "cross_genome_match",
            "def": "A nucleotide match against a sequence from another organism. [SO:ma]"
        },
        "SO:0000178": {
            "name": "operon",
            "def": "A group of contiguous genes transcribed as a single (polycistronic) mRNA from a single regulatory region. [SO:ma]"
        },
        "SO:0000179": {
            "name": "clone_insert_start",
            "def": "The start of the clone insert. [SO:ke]"
        },
        "SO:0000180": {
            "name": "retrotransposon",
            "def": "A transposable element that is incorporated into a chromosome by a mechanism that requires reverse transcriptase. [http://www.dddmag.com/Glossary.aspx#r]"
        },
        "SO:0000181": {
            "name": "translated_nucleotide_match",
            "def": "A match against a translated sequence. [SO:ke]"
        },
        "SO:0000182": {
            "name": "DNA_transposon",
            "def": "A transposon where the mechanism of transposition is via a DNA intermediate. [SO:ke]"
        },
        "SO:0000183": {
            "name": "non_transcribed_region",
            "def": "A region of the gene which is not transcribed. [SO:ke]"
        },
        "SO:0000184": {
            "name": "U2_intron",
            "def": "A major type of spliceosomal intron spliced by the U2 spliceosome, that includes U1, U2, U4/U6 and U5 snRNAs. [PMID:9428511]"
        },
        "SO:0000185": {
            "name": "primary_transcript",
            "def": "A transcript that in its initial state requires modification to be functional. [SO:ma]"
        },
        "SO:0000186": {
            "name": "LTR_retrotransposon",
            "def": "A retrotransposon flanked by long terminal repeat sequences. [SO:ke]"
        },
        "SO:0000187": {
            "name": "repeat_family",
            "def": "A group of characterized repeat sequences. [SO:ke]"
        },
        "SO:0000188": {
            "name": "intron",
            "def": "A region of a primary transcript that is transcribed, but removed from within the transcript by splicing together the sequences (exons) on either side of it. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000189": {
            "name": "non_LTR_retrotransposon",
            "def": "A retrotransposon without long terminal repeat sequences. [SO:ke]"
        },
        "SO:0000190": {
            "name": "five_prime_intron"
        },
        "SO:0000191": {
            "name": "interior_intron"
        },
        "SO:0000192": {
            "name": "three_prime_intron"
        },
        "SO:0000193": {
            "name": "RFLP_fragment",
            "def": "A DNA fragment used as a reagent to detect the polymorphic genomic loci by hybridizing against the genomic DNA digested with a given restriction enzyme. [GOC:pj]"
        },
        "SO:0000194": {
            "name": "LINE_element",
            "def": "A dispersed repeat family with many copies, each from 1 to 6 kb long. New elements are generated by retroposition of a transcribed copy. Typically the LINE contains 2 ORF's one of which is reverse transcriptase, and 3'and 5' direct repeats. [http://www.ucl.ac.uk/~ucbhjow/b241/glossary.html]"
        },
        "SO:0000195": {
            "name": "coding_exon",
            "def": "An exon whereby at least one base is part of a codon (here, 'codon' is inclusive of the stop_codon). [SO:ke]"
        },
        "SO:0000196": {
            "name": "five_prime_coding_exon_coding_region",
            "def": "The sequence of the five_prime_coding_exon that codes for protein. [SO:cjm]"
        },
        "SO:0000197": {
            "name": "three_prime_coding_exon_coding_region",
            "def": "The sequence of the three_prime_coding_exon that codes for protein. [SO:cjm]"
        },
        "SO:0000198": {
            "name": "noncoding_exon",
            "def": "An exon that does not contain any codons. [SO:ke]"
        },
        "SO:0000199": {
            "name": "translocation",
            "def": "A region of nucleotide sequence that has translocated to a new position. The observed adjacency of two previously separated regions. [NCBI:th, SO:ke]"
        },
        "SO:0000200": {
            "name": "five_prime_coding_exon",
            "def": "The 5' most coding exon. [SO:ke]"
        },
        "SO:0000201": {
            "name": "interior_exon",
            "def": "An exon that is bounded by 5' and 3' splice sites. [PMID:10373547]"
        },
        "SO:0000202": {
            "name": "three_prime_coding_exon",
            "def": "The coding exon that is most 3-prime on a given transcript. [SO:ma]"
        },
        "SO:0000203": {
            "name": "UTR",
            "def": "Messenger RNA sequences that are untranslated and lie five prime or three prime to sequences which are translated. [SO:ke]"
        },
        "SO:0000204": {
            "name": "five_prime_UTR",
            "def": "A region at the 5' end of a mature transcript (preceding the initiation codon) that is not translated into a protein. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000205": {
            "name": "three_prime_UTR",
            "def": "A region at the 3' end of a mature transcript (following the stop codon) that is not translated into a protein. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000206": {
            "name": "SINE_element",
            "def": "A repetitive element, a few hundred base pairs long, that is dispersed throughout the genome. A common human SINE is the Alu element. [SO:ke]"
        },
        "SO:0000207": {
            "name": "simple_sequence_length_variation"
        },
        "SO:0000208": {
            "name": "terminal_inverted_repeat_element",
            "def": "A DNA transposable element defined as having termini with perfect, or nearly perfect short inverted repeats, generally 10 - 40 nucleotides long. [http://www.genetics.org/cgi/reprint/156/4/1983.pdf]"
        },
        "SO:0000209": {
            "name": "rRNA_primary_transcript",
            "def": "A primary transcript encoding a ribosomal RNA. [SO:ke]"
        },
        "SO:0000210": {
            "name": "tRNA_primary_transcript",
            "def": "A primary transcript encoding a transfer RNA (SO:0000253). [SO:ke]"
        },
        "SO:0000211": {
            "name": "alanine_tRNA_primary_transcript",
            "def": "A primary transcript encoding alanyl tRNA. [SO:ke]"
        },
        "SO:0000212": {
            "name": "arginine_tRNA_primary_transcript",
            "def": "A primary transcript encoding arginyl tRNA (SO:0000255). [SO:ke]"
        },
        "SO:0000213": {
            "name": "asparagine_tRNA_primary_transcript",
            "def": "A primary transcript encoding asparaginyl tRNA (SO:0000256). [SO:ke]"
        },
        "SO:0000214": {
            "name": "aspartic_acid_tRNA_primary_transcript",
            "def": "A primary transcript encoding aspartyl tRNA (SO:0000257). [SO:ke]"
        },
        "SO:0000215": {
            "name": "cysteine_tRNA_primary_transcript",
            "def": "A primary transcript encoding cysteinyl tRNA (SO:0000258). [SO:ke]"
        },
        "SO:0000216": {
            "name": "glutamic_acid_tRNA_primary_transcript",
            "def": "A primary transcript encoding glutaminyl tRNA (SO:0000260). [SO:ke]"
        },
        "SO:0000217": {
            "name": "glutamine_tRNA_primary_transcript",
            "def": "A primary transcript encoding glutamyl tRNA (SO:0000260). [SO:ke]"
        },
        "SO:0000218": {
            "name": "glycine_tRNA_primary_transcript",
            "def": "A primary transcript encoding glycyl tRNA (SO:0000263). [SO:ke]"
        },
        "SO:0000219": {
            "name": "histidine_tRNA_primary_transcript",
            "def": "A primary transcript encoding histidyl tRNA (SO:0000262). [SO:ke]"
        },
        "SO:0000220": {
            "name": "isoleucine_tRNA_primary_transcript",
            "def": "A primary transcript encoding isoleucyl tRNA (SO:0000263). [SO:ke]"
        },
        "SO:0000221": {
            "name": "leucine_tRNA_primary_transcript",
            "def": "A primary transcript encoding leucyl tRNA (SO:0000264). [SO:ke]"
        },
        "SO:0000222": {
            "name": "lysine_tRNA_primary_transcript",
            "def": "A primary transcript encoding lysyl tRNA (SO:0000265). [SO:ke]"
        },
        "SO:0000223": {
            "name": "methionine_tRNA_primary_transcript",
            "def": "A primary transcript encoding methionyl tRNA (SO:0000266). [SO:ke]"
        },
        "SO:0000224": {
            "name": "phenylalanine_tRNA_primary_transcript",
            "def": "A primary transcript encoding phenylalanyl tRNA (SO:0000267). [SO:ke]"
        },
        "SO:0000225": {
            "name": "proline_tRNA_primary_transcript",
            "def": "A primary transcript encoding prolyl tRNA (SO:0000268). [SO:ke]"
        },
        "SO:0000226": {
            "name": "serine_tRNA_primary_transcript",
            "def": "A primary transcript encoding seryl tRNA (SO:000269). [SO:ke]"
        },
        "SO:0000227": {
            "name": "threonine_tRNA_primary_transcript",
            "def": "A primary transcript encoding threonyl tRNA (SO:000270). [SO:ke]"
        },
        "SO:0000228": {
            "name": "tryptophan_tRNA_primary_transcript",
            "def": "A primary transcript encoding tryptophanyl tRNA (SO:000271). [SO:ke]"
        },
        "SO:0000229": {
            "name": "tyrosine_tRNA_primary_transcript",
            "def": "A primary transcript encoding tyrosyl tRNA (SO:000272). [SO:ke]"
        },
        "SO:0000230": {
            "name": "valine_tRNA_primary_transcript",
            "def": "A primary transcript encoding valyl tRNA (SO:000273). [SO:ke]"
        },
        "SO:0000231": {
            "name": "snRNA_primary_transcript",
            "def": "A primary transcript encoding a small nuclear RNA (SO:0000274). [SO:ke]"
        },
        "SO:0000232": {
            "name": "snoRNA_primary_transcript",
            "def": "A primary transcript encoding a small nucleolar mRNA (SO:0000275). [SO:ke]"
        },
        "SO:0000233": {
            "name": "mature_transcript",
            "def": "A transcript which has undergone the necessary modifications, if any, for its function. In eukaryotes this includes, for example, processing of introns, cleavage, base modification, and modifications to the 5' and/or the 3' ends, other than addition of bases. In bacteria functional mRNAs are usually not modified. [SO:ke]"
        },
        "SO:0000234": {
            "name": "mRNA",
            "def": "Messenger RNA is the intermediate molecule between DNA and protein. It includes UTR and coding sequences. It does not contain introns. [SO:ma]"
        },
        "SO:0000235": {
            "name": "TF_binding_site",
            "def": "A region of a nucleotide molecule that binds a Transcription Factor or Transcription Factor complex [GO:0005667]. [SO:ke]"
        },
        "SO:0000236": {
            "name": "ORF",
            "def": "The in-frame interval between the stop codons of a reading frame which when read as sequential triplets, has the potential of encoding a sequential string of amino acids. TER(NNN)nTER. [SGD:rb, SO:ma]"
        },
        "SO:0000237": {
            "name": "transcript_attribute"
        },
        "SO:0000238": {
            "name": "foldback_element",
            "def": "A transposable element with extensive secondary structure, characterized by large modular imperfect long inverted repeats. [http://www.genetics.org/cgi/reprint/156/4/1983.pdf]"
        },
        "SO:0000239": {
            "name": "flanking_region",
            "def": "The sequences extending on either side of a specific region. [SO:ke]"
        },
        "SO:0000240": {
            "name": "chromosome_variation"
        },
        "SO:0000241": {
            "name": "internal_UTR",
            "def": "A UTR bordered by the terminal and initial codons of two CDSs in a polycistronic transcript. Every UTR is either 5', 3' or internal. [SO:cjm]"
        },
        "SO:0000242": {
            "name": "untranslated_region_polycistronic_mRNA",
            "def": "The untranslated sequence separating the 'cistrons' of multicistronic mRNA. [SO:ke]"
        },
        "SO:0000243": {
            "name": "internal_ribosome_entry_site",
            "def": "Sequence element that recruits a ribosomal subunit to internal mRNA for translation initiation. [SO:ke]"
        },
        "SO:0000244": {
            "name": "four_cutter_restriction_site"
        },
        "SO:0000245": {
            "name": "mRNA_by_polyadenylation_status"
        },
        "SO:0000246": {
            "name": "polyadenylated",
            "def": "A attribute describing the addition of a poly A tail to the 3' end of a mRNA molecule. [SO:ke]"
        },
        "SO:0000247": {
            "name": "mRNA_not_polyadenylated"
        },
        "SO:0000248": {
            "name": "sequence_length_variation"
        },
        "SO:0000249": {
            "name": "six_cutter_restriction_site"
        },
        "SO:0000250": {
            "name": "modified_RNA_base_feature",
            "def": "A post_transcriptionally modified base. [SO:ke]"
        },
        "SO:0000251": {
            "name": "eight_cutter_restriction_site"
        },
        "SO:0000252": {
            "name": "rRNA",
            "def": "RNA that comprises part of a ribosome, and that can provide both structural scaffolding and catalytic activity. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html, ISBN:0198506732]"
        },
        "SO:0000253": {
            "name": "tRNA",
            "def": "Transfer RNA (tRNA) molecules are approximately 80 nucleotides in length. Their secondary structure includes four short double-helical elements and three loops (D, anti-codon, and T loops). Further hydrogen bonds mediate the characteristic L-shaped molecular structure. Transfer RNAs have two regions of fundamental functional importance: the anti-codon, which is responsible for specific mRNA codon recognition, and the 3' end, to which the tRNA's corresponding amino acid is attached (by aminoacyl-tRNA synthetases). Transfer RNAs cope with the degeneracy of the genetic code in two manners: having more than one tRNA (with a specific anti-codon) for a particular amino acid; and 'wobble' base-pairing, i.e. permitting non-standard base-pairing at the 3rd anti-codon position. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00005, ISBN:0198506732]"
        },
        "SO:0000254": {
            "name": "alanyl_tRNA",
            "def": "A tRNA sequence that has an alanine anticodon, and a 3' alanine binding region. [SO:ke]"
        },
        "SO:0000255": {
            "name": "rRNA_small_subunit_primary_transcript",
            "def": "A primary transcript encoding a small ribosomal subunit RNA. [SO:ke]"
        },
        "SO:0000256": {
            "name": "asparaginyl_tRNA",
            "def": "A tRNA sequence that has an asparagine anticodon, and a 3' asparagine binding region. [SO:ke]"
        },
        "SO:0000257": {
            "name": "aspartyl_tRNA",
            "def": "A tRNA sequence that has an aspartic acid anticodon, and a 3' aspartic acid binding region. [SO:ke]"
        },
        "SO:0000258": {
            "name": "cysteinyl_tRNA",
            "def": "A tRNA sequence that has a cysteine anticodon, and a 3' cysteine binding region. [SO:ke]"
        },
        "SO:0000259": {
            "name": "glutaminyl_tRNA",
            "def": "A tRNA sequence that has a glutamine anticodon, and a 3' glutamine binding region. [SO:ke]"
        },
        "SO:0000260": {
            "name": "glutamyl_tRNA",
            "def": "A tRNA sequence that has a glutamic acid anticodon, and a 3' glutamic acid binding region. [SO:ke]"
        },
        "SO:0000261": {
            "name": "glycyl_tRNA",
            "def": "A tRNA sequence that has a glycine anticodon, and a 3' glycine binding region. [SO:ke]"
        },
        "SO:0000262": {
            "name": "histidyl_tRNA",
            "def": "A tRNA sequence that has a histidine anticodon, and a 3' histidine binding region. [SO:ke]"
        },
        "SO:0000263": {
            "name": "isoleucyl_tRNA",
            "def": "A tRNA sequence that has an isoleucine anticodon, and a 3' isoleucine binding region. [SO:ke]"
        },
        "SO:0000264": {
            "name": "leucyl_tRNA",
            "def": "A tRNA sequence that has a leucine anticodon, and a 3' leucine binding region. [SO:ke]"
        },
        "SO:0000265": {
            "name": "lysyl_tRNA",
            "def": "A tRNA sequence that has a lysine anticodon, and a 3' lysine binding region. [SO:ke]"
        },
        "SO:0000266": {
            "name": "methionyl_tRNA",
            "def": "A tRNA sequence that has a methionine anticodon, and a 3' methionine binding region. [SO:ke]"
        },
        "SO:0000267": {
            "name": "phenylalanyl_tRNA",
            "def": "A tRNA sequence that has a phenylalanine anticodon, and a 3' phenylalanine binding region. [SO:ke]"
        },
        "SO:0000268": {
            "name": "prolyl_tRNA",
            "def": "A tRNA sequence that has a proline anticodon, and a 3' proline binding region. [SO:ke]"
        },
        "SO:0000269": {
            "name": "seryl_tRNA",
            "def": "A tRNA sequence that has a serine anticodon, and a 3' serine binding region. [SO:ke]"
        },
        "SO:0000270": {
            "name": "threonyl_tRNA",
            "def": "A tRNA sequence that has a threonine anticodon, and a 3' threonine binding region. [SO:ke]"
        },
        "SO:0000271": {
            "name": "tryptophanyl_tRNA",
            "def": "A tRNA sequence that has a tryptophan anticodon, and a 3' tryptophan binding region. [SO:ke]"
        },
        "SO:0000272": {
            "name": "tyrosyl_tRNA",
            "def": "A tRNA sequence that has a tyrosine anticodon, and a 3' tyrosine binding region. [SO:ke]"
        },
        "SO:0000273": {
            "name": "valyl_tRNA",
            "def": "A tRNA sequence that has a valine anticodon, and a 3' valine binding region. [SO:ke]"
        },
        "SO:0000274": {
            "name": "snRNA",
            "def": "A small nuclear RNA molecule involved in pre-mRNA splicing and processing. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html, PMID:11733745, WB:ems]"
        },
        "SO:0000275": {
            "name": "snoRNA",
            "def": "A snoRNA (small nucleolar RNA) is any one of a class of small RNAs that are associated with the eukaryotic nucleus as components of small nucleolar ribonucleoproteins. They participate in the processing or modifications of many RNAs, mostly ribosomal RNAs (rRNAs) though snoRNAs are also known to target other classes of RNA, including spliceosomal RNAs, tRNAs, and mRNAs via a stretch of sequence that is complementary to a sequence in the targeted RNA. [GOC:kgc]"
        },
        "SO:0000276": {
            "name": "miRNA",
            "def": "Small, ~22-nt, RNA molecule that is the endogenous transcript of a miRNA gene (or the product of other non coding RNA genes. Micro RNAs are produced from precursor molecules (SO:0000647) that can form local hairpin structures, which ordinarily are processed (usually via the Dicer pathway) such that a single miRNA molecule accumulates from one arm of a hairpin precursor molecule. Micro RNAs may trigger the cleavage of their target molecules or act as translational repressors. [PMID:11081512, PMID:12592000]"
        },
        "SO:0000277": {
            "name": "bound_by_factor",
            "def": "An attribute describing a sequence that is bound by another molecule. [SO:ke]"
        },
        "SO:0000278": {
            "name": "transcript_bound_by_nucleic_acid",
            "def": "A transcript that is bound by a nucleic acid. [SO:xp]"
        },
        "SO:0000279": {
            "name": "transcript_bound_by_protein",
            "def": "A transcript that is bound by a protein. [SO:xp]"
        },
        "SO:0000280": {
            "name": "engineered_gene",
            "def": "A gene that is engineered. [SO:xp]"
        },
        "SO:0000281": {
            "name": "engineered_foreign_gene",
            "def": "A gene that is engineered and foreign. [SO:xp]"
        },
        "SO:0000282": {
            "name": "mRNA_with_minus_1_frameshift",
            "def": "An mRNA with a minus 1 frameshift. [SO:xp]"
        },
        "SO:0000283": {
            "name": "engineered_foreign_transposable_element_gene",
            "def": "A transposable_element that is engineered and foreign. [SO:xp]"
        },
        "SO:0000284": {
            "name": "type_I_enzyme_restriction_site",
            "def": "The recognition site is bipartite and interrupted. [http://www.promega.com]"
        },
        "SO:0000285": {
            "name": "foreign_gene",
            "def": "A gene that is foreign. [SO:xp]"
        },
        "SO:0000286": {
            "name": "long_terminal_repeat",
            "def": "A sequence directly repeated at both ends of a defined sequence, of the sort typically found in retroviruses. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000287": {
            "name": "fusion_gene",
            "def": "A gene that is a fusion. [SO:xp]"
        },
        "SO:0000288": {
            "name": "engineered_fusion_gene",
            "def": "A fusion gene that is engineered. [SO:xp]"
        },
        "SO:0000289": {
            "name": "microsatellite",
            "def": "A repeat_region containing repeat_units of 2 to 10 bp repeated in tandem. [http://www.informatics.jax.org/silver/glossary.shtml, NCBI:th]"
        },
        "SO:0000290": {
            "name": "dinucleotide_repeat_microsatellite_feature"
        },
        "SO:0000291": {
            "name": "trinucleotide_repeat_microsatellite_feature"
        },
        "SO:0000292": {
            "name": "repetitive_element"
        },
        "SO:0000293": {
            "name": "engineered_foreign_repetitive_element",
            "def": "A repetitive element that is engineered and foreign. [SO:xp]"
        },
        "SO:0000294": {
            "name": "inverted_repeat",
            "def": "The sequence is complementarily repeated on the opposite strand. It is a palindrome, and it may, or may not be hyphenated. Examples: GCTGATCAGC, or GCTGA-----TCAGC. [SO:ke]"
        },
        "SO:0000295": {
            "name": "U12_intron",
            "def": "A type of spliceosomal intron spliced by the U12 spliceosome, that includes U11, U12, U4atac/U6atac and U5 snRNAs. [PMID:9428511]"
        },
        "SO:0000296": {
            "name": "origin_of_replication",
            "def": "The origin of replication; starting site for duplication of a nucleic acid molecule to give two identical copies. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000297": {
            "name": "D_loop",
            "def": "Displacement loop; a region within mitochondrial DNA in which a short stretch of RNA is paired with one strand of DNA, displacing the original partner DNA strand in this region; also used to describe the displacement of a region of one strand of duplex DNA by a single stranded invader in the reaction catalyzed by RecA protein. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000298": {
            "name": "recombination_feature"
        },
        "SO:0000299": {
            "name": "specific_recombination_site"
        },
        "SO:0000300": {
            "name": "recombination_feature_of_rearranged_gene"
        },
        "SO:0000301": {
            "name": "vertebrate_immune_system_gene_recombination_feature"
        },
        "SO:0000302": {
            "name": "J_gene_recombination_feature",
            "def": "Recombination signal including J-heptamer, J-spacer and J-nonamer in 5' of J-region of a J-gene or J-sequence. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000303": {
            "name": "clip",
            "def": "Part of the primary transcript that is clipped off during processing. [SO:ke]"
        },
        "SO:0000304": {
            "name": "type_II_enzyme_restriction_site",
            "def": "The recognition site is either palindromic, partially palindromic or an interrupted palindrome. Cleavage occurs within the recognition site. [http://www.promega.com]"
        },
        "SO:0000305": {
            "name": "modified_DNA_base",
            "def": "A modified nucleotide, i.e. a nucleotide other than A, T, C. G. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000306": {
            "name": "methylated_DNA_base_feature",
            "def": "A nucleotide modified by methylation. [SO:ke]"
        },
        "SO:0000307": {
            "name": "CpG_island",
            "def": "Regions of a few hundred to a few thousand bases in vertebrate genomes that are relatively GC and CpG rich; they are typically unmethylated and often found near the 5' ends of genes. [SO:rd]"
        },
        "SO:0000308": {
            "name": "sequence_feature_locating_method"
        },
        "SO:0000309": {
            "name": "computed_feature"
        },
        "SO:0000310": {
            "name": "predicted_ab_initio_computation"
        },
        "SO:0000311": {
            "name": "computed_feature_by_similarity",
            "def": ". [SO:ma]"
        },
        "SO:0000312": {
            "name": "experimentally_determined",
            "def": "Attribute to describe a feature that has been experimentally verified. [SO:ke]"
        },
        "SO:0000313": {
            "name": "stem_loop",
            "def": "A double-helical region of nucleic acid formed by base-pairing between adjacent (inverted) complementary sequences. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000314": {
            "name": "direct_repeat",
            "def": "A repeat where the same sequence is repeated in the same direction. Example: GCTGA-followed by-GCTGA. [SO:ke]"
        },
        "SO:0000315": {
            "name": "TSS",
            "def": "The first base where RNA polymerase begins to synthesize the RNA transcript. [SO:ke]"
        },
        "SO:0000316": {
            "name": "CDS",
            "def": "A contiguous sequence which begins with, and includes, a start codon and ends with, and includes, a stop codon. [SO:ma]"
        },
        "SO:0000317": {
            "name": "cDNA_clone",
            "def": "Complementary DNA; A piece of DNA copied from an mRNA and spliced into a vector for propagation in a suitable host. [http://seqcore.brcf.med.umich.edu/doc/educ/dnapr/mbglossary/mbgloss.html]"
        },
        "SO:0000318": {
            "name": "start_codon",
            "def": "First codon to be translated by a ribosome. [SO:ke]"
        },
        "SO:0000319": {
            "name": "stop_codon",
            "def": "In mRNA, a set of three nucleotides that indicates the end of information for protein synthesis. [SO:ke]"
        },
        "SO:0000320": {
            "name": "intronic_splice_enhancer",
            "def": "Sequences within the intron that modulate splice site selection for some introns. [SO:ke]"
        },
        "SO:0000321": {
            "name": "mRNA_with_plus_1_frameshift",
            "def": "An mRNA with a plus 1 frameshift. [SO:ke]"
        },
        "SO:0000322": {
            "name": "nuclease_hypersensitive_site"
        },
        "SO:0000323": {
            "name": "coding_start",
            "def": "The first base to be translated into protein. [SO:ke]"
        },
        "SO:0000324": {
            "name": "tag",
            "def": "A nucleotide sequence that may be used to identify a larger sequence. [SO:ke]"
        },
        "SO:0000325": {
            "name": "rRNA_large_subunit_primary_transcript",
            "def": "A primary transcript encoding a large ribosomal subunit RNA. [SO:ke]"
        },
        "SO:0000326": {
            "name": "SAGE_tag",
            "def": "A short diagnostic sequence tag, serial analysis of gene expression (SAGE), that allows the quantitative and simultaneous analysis of a large number of transcripts. [http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=7570003&dopt=Abstract]"
        },
        "SO:0000327": {
            "name": "coding_end",
            "def": "The last base to be translated into protein. It does not include the stop codon. [SO:ke]"
        },
        "SO:0000328": {
            "name": "microarray_oligo"
        },
        "SO:0000329": {
            "name": "mRNA_with_plus_2_frameshift",
            "def": "An mRNA with a plus 2 frameshift. [SO:xp]"
        },
        "SO:0000330": {
            "name": "conserved_region",
            "def": "Region of sequence similarity by descent from a common ancestor. [SO:ke]"
        },
        "SO:0000331": {
            "name": "STS",
            "def": "Short (typically a few hundred base pairs) DNA sequence that has a single occurrence in a genome and whose location and base sequence are known. [http://www.biospace.com]"
        },
        "SO:0000332": {
            "name": "coding_conserved_region",
            "def": "Coding region of sequence similarity by descent from a common ancestor. [SO:ke]"
        },
        "SO:0000333": {
            "name": "exon_junction",
            "def": "The boundary between two exons in a processed transcript. [SO:ke]"
        },
        "SO:0000334": {
            "name": "nc_conserved_region",
            "def": "Non-coding region of sequence similarity by descent from a common ancestor. [SO:ke]"
        },
        "SO:0000335": {
            "name": "mRNA_with_minus_2_frameshift",
            "def": "A mRNA with a minus 2 frameshift. [SO:ke]"
        },
        "SO:0000336": {
            "name": "pseudogene",
            "def": "A sequence that closely resembles a known functional gene, at another locus within a genome, that is non-functional as a consequence of (usually several) mutations that prevent either its transcription or translation (or both). In general, pseudogenes result from either reverse transcription of a transcript of their \\normal\\ paralog (SO:0000043) (in which case the pseudogene typically lacks introns and includes a poly(A) tail) or from recombination (SO:0000044) (in which case the pseudogene is typically a tandem duplication of its \\normal\\ paralog). [http://www.ucl.ac.uk/~ucbhjow/b241/glossary.html]"
        },
        "SO:0000337": {
            "name": "RNAi_reagent",
            "def": "A double stranded RNA duplex, at least 20bp long, used experimentally to inhibit gene function by RNA interference. [SO:rd]"
        },
        "SO:0000338": {
            "name": "MITE",
            "def": "A highly repetitive and short (100-500 base pair) transposable element with terminal inverted repeats (TIR) and target site duplication (TSD). MITEs do not encode proteins. [http://www.pnas.org/cgi/content/full/97/18/10083]"
        },
        "SO:0000339": {
            "name": "recombination_hotspot",
            "def": "A region in a genome which promotes recombination. [SO:rd]"
        },
        "SO:0000340": {
            "name": "chromosome",
            "def": "Structural unit composed of a nucleic acid molecule which controls its own replication through the interaction of specific proteins at one or more origins of replication. [SO:ma]"
        },
        "SO:0000341": {
            "name": "chromosome_band",
            "def": "A cytologically distinguishable feature of a chromosome, often made visible by staining, and usually alternating light and dark. [SO:ma]"
        },
        "SO:0000342": {
            "name": "site_specific_recombination_target_region"
        },
        "SO:0000343": {
            "name": "match",
            "def": "A region of sequence, aligned to another sequence with some statistical significance, using an algorithm such as BLAST or SIM4. [SO:ke]"
        },
        "SO:0000344": {
            "name": "splice_enhancer",
            "def": "Region of a transcript that regulates splicing. [SO:ke]"
        },
        "SO:0000345": {
            "name": "EST",
            "def": "A tag produced from a single sequencing read from a cDNA clone or PCR product; typically a few hundred base pairs long. [SO:ke]"
        },
        "SO:0000346": {
            "name": "loxP_site"
        },
        "SO:0000347": {
            "name": "nucleotide_match",
            "def": "A match against a nucleotide sequence. [SO:ke]"
        },
        "SO:0000348": {
            "name": "nucleic_acid",
            "def": "An attribute describing a sequence consisting of nucleobases bound to repeating units. The forms found in nature are deoxyribonucleic acid (DNA), where the repeating units are 2-deoxy-D-ribose rings connected to a phosphate backbone, and ribonucleic acid (RNA), where the repeating units are D-ribose rings connected to a phosphate backbone. [CHEBI:33696, RSC:cb]"
        },
        "SO:0000349": {
            "name": "protein_match",
            "def": "A match against a protein sequence. [SO:ke]"
        },
        "SO:0000350": {
            "name": "FRT_site",
            "def": "An inversion site found on the Saccharomyces cerevisiae 2 micron plasmid. [SO:ma]"
        },
        "SO:0000351": {
            "name": "synthetic_sequence",
            "def": "An attribute to decide a sequence of nucleotides, nucleotide analogs, or amino acids that has been designed by an experimenter and which may, or may not, correspond with any natural sequence. [SO:ma]"
        },
        "SO:0000352": {
            "name": "DNA",
            "def": "An attribute describing a sequence consisting of nucleobases bound to a repeating unit made of a 2-deoxy-D-ribose ring connected to a phosphate backbone. [RSC:cb]"
        },
        "SO:0000353": {
            "name": "sequence_assembly",
            "def": "A sequence of nucleotides that has been algorithmically derived from an alignment of two or more different sequences. [SO:ma]"
        },
        "SO:0000354": {
            "name": "group_1_intron_homing_endonuclease_target_region",
            "def": "A region of intronic nucleotide sequence targeted by a nuclease enzyme. [SO:ke]"
        },
        "SO:0000355": {
            "name": "haplotype_block",
            "def": "A region of the genome which is co-inherited as the result of the lack of historic recombination within it. [SO:ma]"
        },
        "SO:0000356": {
            "name": "RNA",
            "def": "An attribute describing a sequence consisting of nucleobases bound to a repeating unit made of a D-ribose ring connected to a phosphate backbone. [RSC:cb]"
        },
        "SO:0000357": {
            "name": "flanked",
            "def": "An attribute describing a region that is bounded either side by a particular kind of region. [SO:ke]"
        },
        "SO:0000359": {
            "name": "floxed",
            "def": "An attribute describing sequence that is flanked by Lox-P sites. [SO:ke]"
        },
        "SO:0000360": {
            "name": "codon",
            "def": "A set of (usually) three nucleotide bases in a DNA or RNA sequence, which together code for a unique amino acid or the termination of translation and are contained within the CDS. [http://www.everythingbio.com/glos/definition.php?word=codon, SO:ke]"
        },
        "SO:0000361": {
            "name": "FRT_flanked",
            "def": "An attribute to describe sequence that is flanked by the FLP recombinase recognition site, FRT. [SO:ke]"
        },
        "SO:0000362": {
            "name": "invalidated_by_chimeric_cDNA",
            "def": "A cDNA clone constructed from more than one mRNA. Usually an experimental artifact. [SO:ma]"
        },
        "SO:0000363": {
            "name": "floxed_gene",
            "def": "A transgene that is floxed. [SO:xp]"
        },
        "SO:0000364": {
            "name": "transposable_element_flanking_region",
            "def": "The region of sequence surrounding a transposable element. [SO:ke]"
        },
        "SO:0000365": {
            "name": "integron",
            "def": "A region encoding an integrase which acts at a site adjacent to it (attI_site) to insert DNA which must include but is not limited to an attC_site. [SO:as]"
        },
        "SO:0000366": {
            "name": "insertion_site",
            "def": "The junction where an insertion occurred. [SO:ke]"
        },
        "SO:0000367": {
            "name": "attI_site",
            "def": "A region within an integron, adjacent to an integrase, at which site specific recombination involving an attC_site takes place. [SO:as]"
        },
        "SO:0000368": {
            "name": "transposable_element_insertion_site",
            "def": "The junction in a genome where a transposable_element has inserted. [SO:ke]"
        },
        "SO:0000369": {
            "name": "integrase_coding_region"
        },
        "SO:0000370": {
            "name": "small_regulatory_ncRNA",
            "def": "A non-coding RNA, usually with a specific secondary structure, that acts to regulate gene expression. [SO:ma]"
        },
        "SO:0000371": {
            "name": "conjugative_transposon",
            "def": "A transposon that encodes function required for conjugation. [http://www.sci.sdsu.edu/~smaloy/Glossary/C.html]"
        },
        "SO:0000372": {
            "name": "enzymatic_RNA",
            "def": "An RNA sequence that has catalytic activity with or without an associated ribonucleoprotein. [RSC:cb]"
        },
        "SO:0000373": {
            "name": "recombinationally_inverted_gene",
            "def": "A recombinationally rearranged gene by inversion. [SO:xp]"
        },
        "SO:0000374": {
            "name": "ribozyme",
            "def": "An RNA with catalytic activity. [SO:ma]"
        },
        "SO:0000375": {
            "name": "rRNA_5_8S",
            "def": "5_8S ribosomal RNA (5. 8S rRNA) is a component of the large subunit of the eukaryotic ribosome. It is transcribed by RNA polymerase I as part of the 45S precursor that also contains 18S and 28S rRNA. Functionally, it is thought that 5.8S rRNA may be involved in ribosome translocation. It is also known to form covalent linkage to the p53 tumour suppressor protein. 5_8S rRNA is also found in archaea. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00002]"
        },
        "SO:0000376": {
            "name": "RNA_6S",
            "def": "A small (184-nt in E. coli) RNA that forms a hairpin type structure. 6S RNA associates with RNA polymerase in a highly specific manner. 6S RNA represses expression from a sigma70-dependent promoter during stationary phase. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00013]"
        },
        "SO:0000377": {
            "name": "CsrB_RsmB_RNA",
            "def": "An enterobacterial RNA that binds the CsrA protein. The CsrB RNAs contain a conserved motif CAGGXXG that is found in up to 18 copies and has been suggested to bind CsrA. The Csr regulatory system has a strong negative regulatory effect on glycogen biosynthesis, glyconeogenesis and glycogen catabolism and a positive regulatory effect on glycolysis. In other bacteria such as Erwinia caratovara the RsmA protein has been shown to regulate the production of virulence determinants, such extracellular enzymes. RsmA binds to RsmB regulatory RNA which is also a member of this family. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00018]"
        },
        "SO:0000378": {
            "name": "DsrA_RNA",
            "def": "DsrA RNA regulates both transcription, by overcoming transcriptional silencing by the nucleoid-associated H-NS protein, and translation, by promoting efficient translation of the stress sigma factor, RpoS. These two activities of DsrA can be separated by mutation: the first of three stem-loops of the 85 nucleotide RNA is necessary for RpoS translation but not for anti-H-NS action, while the second stem-loop is essential for antisilencing and less critical for RpoS translation. The third stem-loop, which behaves as a transcription terminator, can be substituted by the trp transcription terminator without loss of either DsrA function. The sequence of the first stem-loop of DsrA is complementary with the upstream leader portion of RpoS messenger RNA, suggesting that pairing of DsrA with the RpoS message might be important for translational regulation. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00014]"
        },
        "SO:0000379": {
            "name": "GcvB_RNA",
            "def": "A small untranslated RNA involved in expression of the dipeptide and oligopeptide transport systems in Escherichia coli. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00022]"
        },
        "SO:0000380": {
            "name": "hammerhead_ribozyme",
            "def": "A small catalytic RNA motif that catalyzes self-cleavage reaction. Its name comes from its secondary structure which resembles a carpenter's hammer. The hammerhead ribozyme is involved in the replication of some viroid and some satellite RNAs. [PMID:2436805]"
        },
        "SO:0000381": {
            "name": "group_IIA_intron"
        },
        "SO:0000382": {
            "name": "group_IIB_intron"
        },
        "SO:0000383": {
            "name": "MicF_RNA",
            "def": "A non-translated 93 nt antisense RNA that binds its target ompF mRNA and regulates ompF expression by inhibiting translation and inducing degradation of the message. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00033]"
        },
        "SO:0000384": {
            "name": "OxyS_RNA",
            "def": "A small untranslated RNA which is induced in response to oxidative stress in Escherichia coli. Acts as a global regulator to activate or repress the expression of as many as 40 genes, including the fhlA-encoded transcriptional activator and the rpoS-encoded sigma(s) subunit of RNA polymerase. OxyS is bound by the Hfq protein, that increases the OxyS RNA interaction with its target messages. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00035]"
        },
        "SO:0000385": {
            "name": "RNase_MRP_RNA",
            "def": "The RNA molecule essential for the catalytic activity of RNase MRP, an enzymatically active ribonucleoprotein with two distinct roles in eukaryotes. In mitochondria it plays a direct role in the initiation of mitochondrial DNA replication. In the nucleus it is involved in precursor rRNA processing, where it cleaves the internal transcribed spacer 1 between 18S and 5.8S rRNAs. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00030]"
        },
        "SO:0000386": {
            "name": "RNase_P_RNA",
            "def": "The RNA component of Ribonuclease P (RNase P), a ubiquitous endoribonuclease, found in archaea, bacteria and eukarya as well as chloroplasts and mitochondria. Its best characterized activity is the generation of mature 5 prime ends of tRNAs by cleaving the 5 prime leader elements of precursor-tRNAs. Cellular RNase Ps are ribonucleoproteins. RNA from bacterial RNase Ps retains its catalytic activity in the absence of the protein subunit, i.e. it is a ribozyme. Isolated eukaryotic and archaeal RNase P RNA has not been shown to retain its catalytic function, but is still essential for the catalytic activity of the holoenzyme. Although the archaeal and eukaryotic holoenzymes have a much greater protein content than the bacterial ones, the RNA cores from all the three lineages are homologous. Helices corresponding to P1, P2, P3, P4, and P10/11 are common to all cellular RNase P RNAs. Yet, there is considerable sequence variation, particularly among the eukaryotic RNAs. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00010]"
        },
        "SO:0000387": {
            "name": "RprA_RNA",
            "def": "Translational regulation of the stationary phase sigma factor RpoS is mediated by the formation of a double-stranded RNA stem-loop structure in the upstream region of the rpoS messenger RNA, occluding the translation initiation site. Clones carrying rprA (RpoS regulator RNA) increased the translation of RpoS. The rprA gene encodes a 106 nucleotide regulatory RNA. As with DsrA Rfam:RF00014, RprA is predicted to form three stem-loops. Thus, at least two small RNAs, DsrA and RprA, participate in the positive regulation of RpoS translation. Unlike DsrA, RprA does not have an extensive region of complementarity to the RpoS leader, leaving its mechanism of action unclear. RprA is non-essential. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00034]"
        },
        "SO:0000388": {
            "name": "RRE_RNA",
            "def": "The Rev response element (RRE) is encoded within the HIV-env gene. Rev is an essential regulatory protein of HIV that binds an internal loop of the RRE leading, encouraging further Rev-RRE binding. This RNP complex is critical for mRNA export and hence for expression of the HIV structural proteins. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00036]"
        },
        "SO:0000389": {
            "name": "spot_42_RNA",
            "def": "A 109-nucleotide RNA of E. coli that seems to have a regulatory role on the galactose operon. Changes in Spot 42 levels are implicated in affecting DNA polymerase I levels. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00021]"
        },
        "SO:0000390": {
            "name": "telomerase_RNA",
            "def": "The RNA component of telomerase, a reverse transcriptase that synthesizes telomeric DNA. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00025]"
        },
        "SO:0000391": {
            "name": "U1_snRNA",
            "def": "U1 is a small nuclear RNA (snRNA) component of the spliceosome (involved in pre-mRNA splicing). Its 5' end forms complementary base pairs with the 5' splice junction, thus defining the 5' donor site of an intron. There are significant differences in sequence and secondary structure between metazoan and yeast U1 snRNAs, the latter being much longer (568 nucleotides as compared to 164 nucleotides in human). Nevertheless, secondary structure predictions suggest that all U1 snRNAs share a 'common core' consisting of helices I, II, the proximal region of III, and IV. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00003]"
        },
        "SO:0000392": {
            "name": "U2_snRNA",
            "def": "U2 is a small nuclear RNA (snRNA) component of the spliceosome (involved in pre-mRNA splicing). Complementary binding between U2 snRNA (in an area lying towards the 5' end but 3' to hairpin I) and the branchpoint sequence (BPS) of the intron results in the bulging out of an unpaired adenine, on the BPS, which initiates a nucleophilic attack at the intronic 5' splice site, thus starting the first of two transesterification reactions that mediate splicing. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00004]"
        },
        "SO:0000393": {
            "name": "U4_snRNA",
            "def": "U4 small nuclear RNA (U4 snRNA) is a component of the major U2-dependent spliceosome. It forms a duplex with U6, and with each splicing round, it is displaced from U6 (and the spliceosome) in an ATP-dependent manner, allowing U6 to refold and create the active site for splicing catalysis. A recycling process involving protein Prp24 re-anneals U4 and U6. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00015]"
        },
        "SO:0000394": {
            "name": "U4atac_snRNA",
            "def": "An snRNA required for the splicing of the minor U12-dependent class of eukaryotic nuclear introns. It forms a base paired complex with U6atac_snRNA (SO:0000397). [PMID:=12409455]"
        },
        "SO:0000395": {
            "name": "U5_snRNA",
            "def": "U5 RNA is a component of both types of known spliceosome. The precise function of this molecule is unknown, though it is known that the 5' loop is required for splice site selection and p220 binding, and that both the 3' stem-loop and the Sm site are important for Sm protein binding and cap methylation. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00020]"
        },
        "SO:0000396": {
            "name": "U6_snRNA",
            "def": "U6 snRNA is a component of the spliceosome which is involved in splicing pre-mRNA. The putative secondary structure consensus base pairing is confined to a short 5' stem loop, but U6 snRNA is thought to form extensive base-pair interactions with U4 snRNA. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00015]"
        },
        "SO:0000397": {
            "name": "U6atac_snRNA",
            "def": "U6atac_snRNA is an snRNA required for the splicing of the minor U12-dependent class of eukaryotic nuclear introns. It forms a base paired complex with U4atac_snRNA (SO:0000394). [http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=retrieve&db=pubmed&list_uids=12409455&dopt=Abstract]"
        },
        "SO:0000398": {
            "name": "U11_snRNA",
            "def": "U11 snRNA plays a role in splicing of the minor U12-dependent class of eukaryotic nuclear introns, similar to U1 snRNA in the major class spliceosome it base pairs to the conserved 5' splice site sequence. [PMID:9622129]"
        },
        "SO:0000399": {
            "name": "U12_snRNA",
            "def": "The U12 small nuclear (snRNA), together with U4atac/U6atac, U5, and U11 snRNAs and associated proteins, forms a spliceosome that cleaves a divergent class of low-abundance pre-mRNA introns. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00007]"
        },
        "SO:0000400": {
            "name": "sequence_attribute",
            "def": "An attribute describes a quality of sequence. [SO:ke]"
        },
        "SO:0000401": {
            "name": "gene_attribute"
        },
        "SO:0000402": {
            "name": "enhancer_attribute"
        },
        "SO:0000403": {
            "name": "U14_snoRNA",
            "def": "U14 small nucleolar RNA (U14 snoRNA) is required for early cleavages of eukaryotic precursor rRNAs. In yeasts, this molecule possess a stem-loop region (known as the Y-domain) which is essential for function. A similar structure, but with a different consensus sequence, is found in plants, but is absent in vertebrates. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00016, PMID:2551119]"
        },
        "SO:0000404": {
            "name": "vault_RNA",
            "def": "A family of RNAs are found as part of the enigmatic vault ribonucleoprotein complex. The complex consists of a major vault protein (MVP), two minor vault proteins (VPARP and TEP1), and several small untranslated RNA molecules. It has been suggested that the vault complex is involved in drug resistance. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00006]"
        },
        "SO:0000405": {
            "name": "Y_RNA",
            "def": "Y RNAs are components of the Ro ribonucleoprotein particle (Ro RNP), in association with Ro60 and La proteins. The Y RNAs and Ro60 and La proteins are well conserved, but the function of the Ro RNP is not known. In humans the RNA component can be one of four small RNAs: hY1, hY3, hY4 and hY5. These small RNAs are predicted to fold into a conserved secondary structure containing three stem structures. The largest of the four, hY1, contains an additional hairpin. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00019]"
        },
        "SO:0000406": {
            "name": "twintron",
            "def": "An intron within an intron. Twintrons are group II or III introns, into which another group II or III intron has been transposed. [PMID:1899376, PMID:7823908]"
        },
        "SO:0000407": {
            "name": "rRNA_18S",
            "def": "A large polynucleotide in eukaryotes, which functions as the small subunit of the ribosome. [SO:ke]"
        },
        "SO:0000408": {
            "name": "site",
            "def": "The interbase position where something (eg an aberration) occurred. [SO:ke]"
        },
        "SO:0000409": {
            "name": "binding_site",
            "def": "A biological_region of sequence that, in the molecule, interacts selectively and non-covalently with other molecules. A region on the surface of a molecule that may interact with another molecule. When applied to polypeptides: Amino acids involved in binding or interactions. It can also apply to an amino acid bond which is represented by the positions of the two flanking amino acids. [EBIBS:GAR, SO:ke]"
        },
        "SO:0000410": {
            "name": "protein_binding_site",
            "def": "A binding site that, in the molecule, interacts selectively and non-covalently with polypeptide molecules. [SO:ke]"
        },
        "SO:0000411": {
            "name": "rescue_region",
            "def": "A region that rescues. [SO:xp]"
        },
        "SO:0000412": {
            "name": "restriction_fragment",
            "def": "A region of polynucleotide sequence produced by digestion with a restriction endonuclease. [SO:ke]"
        },
        "SO:0000413": {
            "name": "sequence_difference",
            "def": "A region where the sequence differs from that of a specified sequence. [SO:ke]"
        },
        "SO:0000414": {
            "name": "invalidated_by_genomic_contamination",
            "def": "An attribute to describe a feature that is invalidated due to genomic contamination. [SO:ke]"
        },
        "SO:0000415": {
            "name": "invalidated_by_genomic_polyA_primed_cDNA",
            "def": "An attribute to describe a feature that is invalidated due to polyA priming. [SO:ke]"
        },
        "SO:0000416": {
            "name": "invalidated_by_partial_processing",
            "def": "An attribute to describe a feature that is invalidated due to partial processing. [SO:ke]"
        },
        "SO:0000417": {
            "name": "polypeptide_domain",
            "def": "A structurally or functionally defined protein region. In proteins with multiple domains, the combination of the domains determines the function of the protein. A region which has been shown to recur throughout evolution. [EBIBS:GAR]"
        },
        "SO:0000418": {
            "name": "signal_peptide",
            "def": "The signal_peptide is a short region of the peptide located at the N-terminus that directs the protein to be secreted or part of membrane components. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000419": {
            "name": "mature_protein_region",
            "def": "The polypeptide sequence that remains when the cleaved peptide regions have been cleaved from the immature peptide. [EBIBS:GAR, http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html, SO:cb]"
        },
        "SO:0000420": {
            "name": "five_prime_terminal_inverted_repeat"
        },
        "SO:0000421": {
            "name": "three_prime_terminal_inverted_repeat"
        },
        "SO:0000422": {
            "name": "U5_LTR_region"
        },
        "SO:0000423": {
            "name": "R_LTR_region"
        },
        "SO:0000424": {
            "name": "U3_LTR_region"
        },
        "SO:0000425": {
            "name": "five_prime_LTR"
        },
        "SO:0000426": {
            "name": "three_prime_LTR"
        },
        "SO:0000427": {
            "name": "R_five_prime_LTR_region"
        },
        "SO:0000428": {
            "name": "U5_five_prime_LTR_region"
        },
        "SO:0000429": {
            "name": "U3_five_prime_LTR_region"
        },
        "SO:0000430": {
            "name": "R_three_prime_LTR_region"
        },
        "SO:0000431": {
            "name": "U3_three_prime_LTR_region"
        },
        "SO:0000432": {
            "name": "U5_three_prime_LTR_region"
        },
        "SO:0000433": {
            "name": "non_LTR_retrotransposon_polymeric_tract",
            "def": "A polymeric tract, such as poly(dA), within a non_LTR_retrotransposon. [SO:ke]"
        },
        "SO:0000434": {
            "name": "target_site_duplication",
            "def": "A sequence of the target DNA that is duplicated when a transposable element or phage inserts; usually found at each end the insertion. [http://www.koko.gov.my/CocoaBioTech/Glossaryt.html]"
        },
        "SO:0000435": {
            "name": "RR_tract",
            "def": "A polypurine tract within an LTR_retrotransposon. [SO:ke]"
        },
        "SO:0000436": {
            "name": "ARS",
            "def": "A sequence that can autonomously replicate, as a plasmid, when transformed into a bacterial host. [SO:ma]"
        },
        "SO:0000437": {
            "name": "assortment_derived_duplication"
        },
        "SO:0000438": {
            "name": "gene_not_polyadenylated"
        },
        "SO:0000439": {
            "name": "inverted_ring_chromosome"
        },
        "SO:0000440": {
            "name": "vector_replicon",
            "def": "A replicon that has been modified to act as a vector for foreign sequence. [SO:ma]"
        },
        "SO:0000441": {
            "name": "ss_oligo",
            "def": "A single stranded oligonucleotide. [SO:ke]"
        },
        "SO:0000442": {
            "name": "ds_oligo",
            "def": "A double stranded oligonucleotide. [SO:ke]"
        },
        "SO:0000443": {
            "name": "polymer_attribute",
            "def": "An attribute to describe the kind of biological sequence. [SO:ke]"
        },
        "SO:0000444": {
            "name": "three_prime_noncoding_exon",
            "def": "Non-coding exon in the 3' UTR. [SO:ke]"
        },
        "SO:0000445": {
            "name": "five_prime_noncoding_exon",
            "def": "Non-coding exon in the 5' UTR. [SO:ke]"
        },
        "SO:0000446": {
            "name": "UTR_intron",
            "def": "Intron located in the untranslated region. [SO:ke]"
        },
        "SO:0000447": {
            "name": "five_prime_UTR_intron",
            "def": "An intron located in the 5' UTR. [SO:ke]"
        },
        "SO:0000448": {
            "name": "three_prime_UTR_intron",
            "def": "An intron located in the 3' UTR. [SO:ke]"
        },
        "SO:0000449": {
            "name": "random_sequence",
            "def": "A sequence of nucleotides or amino acids which, by design, has a \\random\\ order of components, given a predetermined input frequency of these components. [SO:ma]"
        },
        "SO:0000450": {
            "name": "interband",
            "def": "A light region between two darkly staining bands in a polytene chromosome. [SO:ma]"
        },
        "SO:0000451": {
            "name": "gene_with_polyadenylated_mRNA",
            "def": "A gene that encodes a polyadenylated mRNA. [SO:xp]"
        },
        "SO:0000452": {
            "name": "transgene_attribute"
        },
        "SO:0000453": {
            "name": "chromosomal_transposition",
            "def": "A chromosome structure variant whereby a region of a chromosome has been transferred to another position. Among interchromosomal rearrangements, the term transposition is reserved for that class in which the telomeres of the chromosomes involved are coupled (that is to say, form the two ends of a single DNA molecule) as in wild-type. [FB:reference_manual, SO:ke]"
        },
        "SO:0000454": {
            "name": "rasiRNA",
            "def": "A 17-28-nt, small interfering RNA derived from transcripts of repetitive elements. [http://www.developmentalcell.com/content/article/abstract?uid=PIIS1534580703002284]"
        },
        "SO:0000455": {
            "name": "gene_with_mRNA_with_frameshift",
            "def": "A gene that encodes an mRNA with a frameshift. [SO:xp]"
        },
        "SO:0000456": {
            "name": "recombinationally_rearranged_gene",
            "def": "A gene that is recombinationally rearranged. [SO:ke]"
        },
        "SO:0000457": {
            "name": "interchromosomal_duplication",
            "def": "A chromosome duplication involving an insertion from another chromosome. [SO:ke]"
        },
        "SO:0000458": {
            "name": "D_gene_segment",
            "def": "Germline genomic DNA including D-region with 5' UTR and 3' UTR, also designated as D-segment. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000459": {
            "name": "gene_with_trans_spliced_transcript",
            "def": "A gene with a transcript that is trans-spliced. [SO:xp]"
        },
        "SO:0000460": {
            "name": "vertebrate_immunoglobulin_T_cell_receptor_segment"
        },
        "SO:0000461": {
            "name": "inversion_derived_bipartite_deficiency",
            "def": "A chromosomal deletion whereby a chromosome generated by recombination between two inversions; has a deficiency at each end of the inversion. [FB:km]"
        },
        "SO:0000462": {
            "name": "pseudogenic_region",
            "def": "A non-functional descendant of a functional entity. [SO:cjm]"
        },
        "SO:0000463": {
            "name": "encodes_alternately_spliced_transcripts",
            "def": "A gene that encodes more than one transcript. [SO:ke]"
        },
        "SO:0000464": {
            "name": "decayed_exon",
            "def": "A non-functional descendant of an exon. [SO:ke]"
        },
        "SO:0000465": {
            "name": "inversion_derived_deficiency_plus_duplication",
            "def": "A chromosome deletion whereby a chromosome is generated by recombination between two inversions; there is a deficiency at one end of the inversion and a duplication at the other end of the inversion. [FB:km]"
        },
        "SO:0000466": {
            "name": "V_gene_segment",
            "def": "Germline genomic DNA including L-part1, V-intron and V-exon, with the 5' UTR and 3' UTR. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000467": {
            "name": "post_translationally_regulated_by_protein_stability",
            "def": "An attribute describing a gene sequence where the resulting protein is regulated by the stability of the resulting protein. [SO:ke]"
        },
        "SO:0000468": {
            "name": "golden_path_fragment",
            "def": "One of the pieces of sequence that make up a golden path. [SO:rd]"
        },
        "SO:0000469": {
            "name": "post_translationally_regulated_by_protein_modification",
            "def": "An attribute describing a gene sequence where the resulting protein is modified to regulate it. [SO:ke]"
        },
        "SO:0000470": {
            "name": "J_gene_segment",
            "def": "Germline genomic DNA of an immunoglobulin/T-cell receptor gene including J-region with 5' UTR (SO:0000204) and 3' UTR (SO:0000205), also designated as J-segment. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000471": {
            "name": "autoregulated",
            "def": "The gene product is involved in its own transcriptional regulation. [SO:ke]"
        },
        "SO:0000472": {
            "name": "tiling_path",
            "def": "A set of regions which overlap with minimal polymorphism to form a linear sequence. [SO:cjm]"
        },
        "SO:0000473": {
            "name": "negatively_autoregulated",
            "def": "The gene product is involved in its own transcriptional regulation where it decreases transcription. [SO:ke]"
        },
        "SO:0000474": {
            "name": "tiling_path_fragment",
            "def": "A piece of sequence that makes up a tiling_path (SO:0000472). [SO:ke]"
        },
        "SO:0000475": {
            "name": "positively_autoregulated",
            "def": "The gene product is involved in its own transcriptional regulation, where it increases transcription. [SO:ke]"
        },
        "SO:0000476": {
            "name": "contig_read",
            "def": "A DNA sequencer read which is part of a contig. [SO:ke]"
        },
        "SO:0000477": {
            "name": "polycistronic_gene",
            "def": "A gene that is polycistronic. [SO:ke]"
        },
        "SO:0000478": {
            "name": "C_gene_segment",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene including C-region (and introns if present) with 5' UTR (SO:0000204) and 3' UTR (SO:0000205). [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000479": {
            "name": "trans_spliced_transcript",
            "def": "A transcript that is trans-spliced. [SO:xp]"
        },
        "SO:0000480": {
            "name": "tiling_path_clone",
            "def": "A clone which is part of a tiling path. A tiling path is a set of sequencing substrates, typically clones, which have been selected in order to efficiently cover a region of the genome in preparation for sequencing and assembly. [SO:ke]"
        },
        "SO:0000481": {
            "name": "terminal_inverted_repeat",
            "def": "An inverted repeat (SO:0000294) occurring at the termini of a DNA transposon. [SO:ke]"
        },
        "SO:0000482": {
            "name": "vertebrate_immunoglobulin_T_cell_receptor_gene_cluster"
        },
        "SO:0000483": {
            "name": "nc_primary_transcript",
            "def": "A primary transcript that is never translated into a protein. [SO:ke]"
        },
        "SO:0000484": {
            "name": "three_prime_coding_exon_noncoding_region",
            "def": "The sequence of the 3' exon that is not coding. [SO:ke]"
        },
        "SO:0000485": {
            "name": "DJ_J_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one DJ-gene, and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000486": {
            "name": "five_prime_coding_exon_noncoding_region",
            "def": "The sequence of the 5' exon preceding the start codon. [SO:ke]"
        },
        "SO:0000487": {
            "name": "VDJ_J_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one VDJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000488": {
            "name": "VDJ_J_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one VDJ-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000489": {
            "name": "VJ_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one VJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000490": {
            "name": "VJ_J_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one VJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000491": {
            "name": "VJ_J_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one VJ-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000492": {
            "name": "D_gene_recombination_feature"
        },
        "SO:0000493": {
            "name": "three_prime_D_heptamer",
            "def": "7 nucleotide recombination site like CACAGTG, part of a 3' D-recombination signal sequence of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000494": {
            "name": "three_prime_D_nonamer",
            "def": "A 9 nucleotide recombination site (e.g. ACAAAAACC), part of a 3' D-recombination signal sequence of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000495": {
            "name": "three_prime_D_spacer",
            "def": "A 12 or 23 nucleotide spacer between the 3'D-HEPTAMER and 3'D-NONAMER of a 3'D-RS. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000496": {
            "name": "five_prime_D_heptamer",
            "def": "7 nucleotide recombination site (e.g. CACTGTG), part of a 5' D-recombination signal sequence (SO:0000556) of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000497": {
            "name": "five_prime_D_nonamer",
            "def": "9 nucleotide recombination site (e.g. GGTTTTTGT), part of a five_prime_D-recombination signal sequence (SO:0000556) of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000498": {
            "name": "five_prime_D_spacer",
            "def": "12 or 23 nucleotide spacer between the 5' D-heptamer (SO:0000496) and 5' D-nonamer (SO:0000497) of a 5' D-recombination signal sequence (SO:0000556) of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000499": {
            "name": "virtual_sequence",
            "def": "A continuous piece of sequence similar to the 'virtual contig' concept of the Ensembl database. [SO:ke]"
        },
        "SO:0000500": {
            "name": "Hoogsteen_base_pair",
            "def": "A type of non-canonical base-pairing. This is less energetically favourable than watson crick base pairing. Hoogsteen GC base pairs only have two hydrogen bonds. [PMID:12177293]"
        },
        "SO:0000501": {
            "name": "reverse_Hoogsteen_base_pair",
            "def": "A type of non-canonical base-pairing. [SO:ke]"
        },
        "SO:0000502": {
            "name": "transcribed_region",
            "def": "A region of sequence that is transcribed. This region may cover the transcript of a gene, it may emcompas the sequence covered by all of the transcripts of a alternately spliced gene, or it may cover the region transcribed by a polycistronic transcript. A gene may have 1 or more transcribed regions and a transcribed_region may belong to one or more genes. [SO:ke]"
        },
        "SO:0000503": {
            "name": "alternately_spliced_gene_encodeing_one_transcript"
        },
        "SO:0000504": {
            "name": "D_DJ_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one D-gene, one DJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000505": {
            "name": "D_DJ_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one D-gene and one DJ-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000506": {
            "name": "D_DJ_J_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one D-gene, one DJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000507": {
            "name": "pseudogenic_exon",
            "def": "A non functional descendant of an exon, part of a pseudogene. [SO:ke]"
        },
        "SO:0000508": {
            "name": "D_DJ_J_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one D-gene, one DJ-gene, and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000509": {
            "name": "D_J_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one D-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000510": {
            "name": "VD_gene_segment",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in partially rearranged genomic DNA including L-part1, V-intron and V-D-exon, with the 5' UTR (SO:0000204) and 3' UTR (SO:0000205). [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000511": {
            "name": "J_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000512": {
            "name": "inversion_derived_deficiency_plus_aneuploid",
            "def": "A chromosomal deletion whereby a chromosome generated by recombination between two inversions; has a deficiency at one end and presumed to have a deficiency or duplication at the other end of the inversion. [FB:km]"
        },
        "SO:0000513": {
            "name": "J_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including more than one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000514": {
            "name": "J_nonamer",
            "def": "9 nucleotide recombination site (e.g. GGTTTTTGT), part of a J-gene recombination feature of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000515": {
            "name": "J_heptamer",
            "def": "7 nucleotide recombination site (e.g. CACAGTG), part of a J-gene recombination feature of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000516": {
            "name": "pseudogenic_transcript",
            "def": "A non functional descendant of a transcript, part of a pseudogene. [SO:ke]"
        },
        "SO:0000517": {
            "name": "J_spacer",
            "def": "12 or 23 nucleotide spacer between the J-nonamer and the J-heptamer of a J-gene recombination feature of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000518": {
            "name": "V_DJ_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene and one DJ-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000519": {
            "name": "V_DJ_J_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one DJ-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000520": {
            "name": "V_VDJ_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one VDJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000521": {
            "name": "V_VDJ_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene and one VDJ-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000522": {
            "name": "V_VDJ_J_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one VDJ-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000523": {
            "name": "V_VJ_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one VJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000524": {
            "name": "V_VJ_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene and one VJ-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000525": {
            "name": "V_VJ_J_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one VJ-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000526": {
            "name": "V_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including more than one V-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000527": {
            "name": "V_D_DJ_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one D-gene, one DJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000528": {
            "name": "V_D_DJ_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one D-gene, one DJ-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000529": {
            "name": "V_D_DJ_J_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one D-gene, one DJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000530": {
            "name": "V_D_DJ_J_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one D-gene, one DJ-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000531": {
            "name": "V_D_J_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one V-gene, one D-gene and one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000532": {
            "name": "V_D_J_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one V-gene, one D-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000533": {
            "name": "V_heptamer",
            "def": "7 nucleotide recombination site (e.g. CACAGTG), part of V-gene recombination feature of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000534": {
            "name": "V_J_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one V-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000535": {
            "name": "V_J_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one V-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000536": {
            "name": "V_nonamer",
            "def": "9 nucleotide recombination site (e.g. ACAAAAACC), part of V-gene recombination feature of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000537": {
            "name": "V_spacer",
            "def": "12 or 23 nucleotide spacer between the V-heptamer and the V-nonamer of a V-gene recombination feature of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000538": {
            "name": "V_gene_recombination_feature",
            "def": "Recombination signal including V-heptamer, V-spacer and V-nonamer in 3' of V-region of a V-gene or V-sequence of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000539": {
            "name": "DJ_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one DJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000540": {
            "name": "DJ_J_C_cluster",
            "def": "Genomic DNA in rearranged configuration including at least one D-J-GENE, one J-GENE and one C-GENE. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000541": {
            "name": "VDJ_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one VDJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000542": {
            "name": "V_DJ_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one DJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000543": {
            "name": "alternately_spliced_gene_encoding_greater_than_one_transcript"
        },
        "SO:0000544": {
            "name": "helitron",
            "def": "A rolling circle transposon. Autonomous helitrons encode a 5'-to-3' DNA helicase and nuclease/ligase similar to those encoded by known rolling-circle replicons. [http://www.pnas.org/cgi/content/full/100/11/6569]"
        },
        "SO:0000545": {
            "name": "recoding_pseudoknot",
            "def": "The pseudoknots involved in recoding are unique in that, as they play their role as a structure, they are immediately unfolded and their now linear sequence serves as a template for decoding. [http://www.pubmedcentral.nih.gov/articlerender.fcgi?artid=33937]"
        },
        "SO:0000546": {
            "name": "designed_sequence"
        },
        "SO:0000547": {
            "name": "inversion_derived_bipartite_duplication",
            "def": "A chromosome generated by recombination between two inversions; there is a duplication at each end of the inversion. [FB:km]"
        },
        "SO:0000548": {
            "name": "gene_with_edited_transcript",
            "def": "A gene that encodes a transcript that is edited. [SO:xp]"
        },
        "SO:0000549": {
            "name": "inversion_derived_duplication_plus_aneuploid",
            "def": "A chromosome generated by recombination between two inversions; has a duplication at one end and presumed to have a deficiency or duplication at the other end of the inversion. [FB:km]"
        },
        "SO:0000550": {
            "name": "aneuploid_chromosome",
            "def": "A chromosome structural variation whereby either a chromosome exists in addition to the normal chromosome complement or is lacking. [SO:ke]"
        },
        "SO:0000551": {
            "name": "polyA_signal_sequence",
            "def": "The recognition sequence necessary for endonuclease cleavage of an RNA transcript that is followed by polyadenylation; consensus=AATAAA. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000552": {
            "name": "Shine_Dalgarno_sequence",
            "def": "A region in the 5' UTR that pairs with the 16S rRNA during formation of the preinitiation complex. [SO:jh]"
        },
        "SO:0000553": {
            "name": "polyA_site",
            "def": "The site on an RNA transcript to which will be added adenine residues by post-transcriptional polyadenylation. The boundary between the UTR and the polyA sequence. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000554": {
            "name": "assortment_derived_deficiency_plus_duplication"
        },
        "SO:0000555": {
            "name": "five_prime_clip",
            "def": "5' most region of a precursor transcript that is clipped off during processing. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000556": {
            "name": "five_prime_D_recombination_signal_sequence",
            "def": "Recombination signal of an immunoglobulin/T-cell receptor gene, including the 5' D-nonamer (SO:0000497), 5' D-spacer (SO:0000498), and 5' D-heptamer (SO:0000396) in 5' of the D-region of a D-gene, or in 5' of the D-region of DJ-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000557": {
            "name": "three_prime_clip",
            "def": "3'-most region of a precursor transcript that is clipped off during processing. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000558": {
            "name": "C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene including more than one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000559": {
            "name": "D_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including more than one D-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000560": {
            "name": "D_J_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one D-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000561": {
            "name": "heptamer_of_recombination_feature_of_vertebrate_immune_system_gene",
            "def": "Seven nucleotide recombination site (e.g. CACAGTG), part of V-gene, D-gene or J-gene recombination feature of an immunoglobulin or T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000562": {
            "name": "nonamer_of_recombination_feature_of_vertebrate_immune_system_gene"
        },
        "SO:0000563": {
            "name": "vertebrate_immune_system_gene_recombination_spacer"
        },
        "SO:0000564": {
            "name": "V_DJ_J_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one DJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000565": {
            "name": "V_VDJ_J_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one VDJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000566": {
            "name": "V_VJ_J_C_cluster",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one VJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000567": {
            "name": "inversion_derived_aneuploid_chromosome",
            "def": "A chromosome may be generated by recombination between two inversions; presumed to have a deficiency or duplication at each end of the inversion. [FB:km]"
        },
        "SO:0000568": {
            "name": "bidirectional_promoter",
            "def": "An unregulated promoter that allows continuous expression. [SO:ke]"
        },
        "SO:0000569": {
            "name": "retrotransposed",
            "def": "An attribute of a feature that occurred as the product of a reverse transcriptase mediated event. [SO:ke]"
        },
        "SO:0000570": {
            "name": "three_prime_D_recombination_signal_sequence",
            "def": "Recombination signal of an immunoglobulin/T-cell receptor gene, including the 3' D-heptamer (SO:0000493), 3' D-spacer, and 3' D-nonamer (SO:0000494) in 3' of the D-region of a D-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000571": {
            "name": "miRNA_encoding"
        },
        "SO:0000572": {
            "name": "DJ_gene_segment",
            "def": "Genomic DNA of immunoglobulin/T-cell receptor gene in partially rearranged genomic DNA including D-J-region with 5' UTR and 3' UTR, also designated as D-J-segment. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000573": {
            "name": "rRNA_encoding"
        },
        "SO:0000574": {
            "name": "VDJ_gene_segment",
            "def": "Rearranged genomic DNA of immunoglobulin/T-cell receptor gene including L-part1, V-intron and V-D-J-exon, with the 5'UTR (SO:0000204) and 3'UTR (SO:0000205). [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000575": {
            "name": "scRNA_encoding"
        },
        "SO:0000576": {
            "name": "VJ_gene_segment",
            "def": "Rearranged genomic DNA of immunoglobulin/T-cell receptor gene including L-part1, V-intron and V-J-exon, with the 5'UTR (SO:0000204) and 3'UTR (SO:0000205). [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]"
        },
        "SO:0000577": {
            "name": "centromere",
            "def": "A region of chromosome where the spindle fibers attach during mitosis and meiosis. [SO:ke]"
        },
        "SO:0000578": {
            "name": "snoRNA_encoding"
        },
        "SO:0000579": {
            "name": "edited_transcript_feature",
            "def": "A locatable feature on a transcript that is edited. [SO:ma]"
        },
        "SO:0000580": {
            "name": "methylation_guide_snoRNA_primary_transcript",
            "def": "A primary transcript encoding a methylation guide small nucleolar RNA. [SO:ke]"
        },
        "SO:0000581": {
            "name": "cap",
            "def": "A structure consisting of a 7-methylguanosine in 5'-5' triphosphate linkage with the first nucleotide of an mRNA. It is added post-transcriptionally, and is not encoded in the DNA. [http://seqcore.brcf.med.umich.edu/doc/educ/dnapr/mbglossary/mbgloss.html]"
        },
        "SO:0000582": {
            "name": "rRNA_cleavage_snoRNA_primary_transcript",
            "def": "A primary transcript encoding an rRNA cleavage snoRNA. [SO:ke]"
        },
        "SO:0000583": {
            "name": "pre_edited_region",
            "def": "The region of a transcript that will be edited. [http://dna.kdna.ucla.edu/rna/index.aspx]"
        },
        "SO:0000584": {
            "name": "tmRNA",
            "def": "A tmRNA liberates a mRNA from a stalled ribosome. To accomplish this part of the tmRNA is used as a reading frame that ends in a translation stop signal. The broken mRNA is replaced in the ribosome by the tmRNA and translation of the tmRNA leads to addition of a proteolysis tag to the incomplete protein enabling recognition by a protease. Recently a number of permuted tmRNAs genes have been found encoded in two parts. TmRNAs have been identified in eubacteria and some chloroplasts but are absent from archeal and Eukaryote nuclear genomes. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00023]"
        },
        "SO:0000585": {
            "name": "C_D_box_snoRNA_encoding"
        },
        "SO:0000586": {
            "name": "tmRNA_primary_transcript",
            "def": "A primary transcript encoding a tmRNA (SO:0000584). [SO:ke]"
        },
        "SO:0000587": {
            "name": "group_I_intron",
            "def": "Group I catalytic introns are large self-splicing ribozymes. They catalyze their own excision from mRNA, tRNA and rRNA precursors in a wide range of organisms. The core secondary structure consists of 9 paired regions (P1-P9). These fold to essentially two domains, the P4-P6 domain (formed from the stacking of P5, P4, P6 and P6a helices) and the P3-P9 domain (formed from the P8, P3, P7 and P9 helices). Group I catalytic introns often have long ORFs inserted in loop regions. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00028]"
        },
        "SO:0000588": {
            "name": "autocatalytically_spliced_intron",
            "def": "A self spliced intron. [SO:ke]"
        },
        "SO:0000589": {
            "name": "SRP_RNA_primary_transcript",
            "def": "A primary transcript encoding a signal recognition particle RNA. [SO:ke]"
        },
        "SO:0000590": {
            "name": "SRP_RNA",
            "def": "The signal recognition particle (SRP) is a universally conserved ribonucleoprotein. It is involved in the co-translational targeting of proteins to membranes. The eukaryotic SRP consists of a 300-nucleotide 7S RNA and six proteins: SRPs 72, 68, 54, 19, 14, and 9. Archaeal SRP consists of a 7S RNA and homologues of the eukaryotic SRP19 and SRP54 proteins. In most eubacteria, the SRP consists of a 4.5S RNA and the Ffh protein (a homologue of the eukaryotic SRP54 protein). Eukaryotic and archaeal 7S RNAs have very similar secondary structures, with eight helical elements. These fold into the Alu and S domains, separated by a long linker region. Eubacterial SRP is generally a simpler structure, with the M domain of Ffh bound to a region of the 4.5S RNA that corresponds to helix 8 of the eukaryotic and archaeal SRP S domain. Some Gram-positive bacteria (e.g. Bacillus subtilis), however, have a larger SRP RNA that also has an Alu domain. The Alu domain is thought to mediate the peptide chain elongation retardation function of the SRP. The universally conserved helix which interacts with the SRP54/Ffh M domain mediates signal sequence recognition. In eukaryotes and archaea, the SRP19-helix 6 complex is thought to be involved in SRP assembly and stabilizes helix 8 for SRP54 binding. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00017]"
        },
        "SO:0000591": {
            "name": "pseudoknot",
            "def": "A tertiary structure in RNA where nucleotides in a loop form base pairs with a region of RNA downstream of the loop. [RSC:cb]"
        },
        "SO:0000592": {
            "name": "H_pseudoknot",
            "def": "A pseudoknot which contains two stems and at least two loops. [http://www.ncbi.nlm.nih.gov:80/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=10334330&dopt=Abstract]"
        },
        "SO:0000593": {
            "name": "C_D_box_snoRNA",
            "def": "Most box C/D snoRNAs also contain long (>10 nt) sequences complementary to rRNA. Boxes C and D, as well as boxes C' and D', are usually located in close proximity, and form a structure known as the box C/D motif. This motif is important for snoRNA stability, processing, nucleolar targeting and function. A small number of box C/D snoRNAs are involved in rRNA processing; most, however, are known or predicted to serve as guide RNAs in ribose methylation of rRNA. Targeting involves direct base pairing of the snoRNA at the rRNA site to be modified and selection of a rRNA nucleotide a fixed distance from box D or D'. [http://www.bio.umass.edu/biochem/rna-sequence/Yeast_snoRNA_Database/snoRNA_DataBase.html]"
        },
        "SO:0000594": {
            "name": "H_ACA_box_snoRNA",
            "def": "Members of the box H/ACA family contain an ACA triplet, exactly 3 nt upstream from the 3' end and an H-box in a hinge region that links two structurally similar functional domains of the molecule. Both boxes are important for snoRNA biosynthesis and function. A few box H/ACA snoRNAs are involved in rRNA processing; most others are known or predicted to participate in selection of uridine nucleosides in rRNA to be converted to pseudouridines. Site selection is mediated by direct base pairing of the snoRNA with rRNA through one or both targeting domains. [http://www.bio.umass.edu/biochem/rna-sequence/Yeast_snoRNA_Database/snoRNA_DataBase.html]"
        },
        "SO:0000595": {
            "name": "C_D_box_snoRNA_primary_transcript",
            "def": "A primary transcript encoding a small nucleolar RNA of the box C/D family. [SO:ke]"
        },
        "SO:0000596": {
            "name": "H_ACA_box_snoRNA_primary_transcript",
            "def": "A primary transcript encoding a small nucleolar RNA of the box H/ACA family. [SO:ke]"
        },
        "SO:0000597": {
            "name": "transcript_edited_by_U_insertion/deletion",
            "def": "The insertion and deletion of uridine (U) residues, usually within coding regions of mRNA transcripts of cryptogenes in the mitochondrial genome of kinetoplastid protozoa. [http://www.rna.ucla.edu/index.html]"
        },
        "SO:0000598": {
            "name": "edited_by_C_insertion_and_dinucleotide_insertion"
        },
        "SO:0000599": {
            "name": "edited_by_C_to_U_substitution"
        },
        "SO:0000600": {
            "name": "edited_by_A_to_I_substitution"
        },
        "SO:0000601": {
            "name": "edited_by_G_addition"
        },
        "SO:0000602": {
            "name": "guide_RNA",
            "def": "A short 3'-uridylated RNA that can form a duplex (except for its post-transcriptionally added oligo_U tail (SO:0000609)) with a stretch of mature edited mRNA. [http://www.rna.ucla.edu/index.html]"
        },
        "SO:0000603": {
            "name": "group_II_intron",
            "def": "Group II introns are found in rRNA, tRNA and mRNA of organelles in fungi, plants and protists, and also in mRNA in bacteria. They are large self-splicing ribozymes and have 6 structural domains (usually designated dI to dVI). A subset of group II introns also encode essential splicing proteins in intronic ORFs. The length of these introns can therefore be up to 3kb. Splicing occurs in almost identical fashion to nuclear pre-mRNA splicing with two transesterification steps. The 2' hydroxyl of a bulged adenosine in domain VI attacks the 5' splice site, followed by nucleophilic attack on the 3' splice site by the 3' OH of the upstream exon. Protein machinery is required for splicing in vivo, and long range intron to intron and intron-exon interactions are important for splice site positioning. Group II introns are further sub-classified into groups IIA and IIB which differ in splice site consensus, distance of bulged A from 3' splice site, some tertiary interactions, and intronic ORF phylogeny. [http://www.sanger.ac.uk/Software/Rfam/browse/index.shtml]"
        },
        "SO:0000604": {
            "name": "editing_block",
            "def": "Edited mRNA sequence mediated by a single guide RNA (SO:0000602). [http://dna.kdna.ucla.edu/rna/index.aspx]"
        },
        "SO:0000605": {
            "name": "intergenic_region",
            "def": "A region containing or overlapping no genes that is bounded on either side by a gene, or bounded by a gene and the end of the chromosome. [SO:cjm]"
        },
        "SO:0000606": {
            "name": "editing_domain",
            "def": "Edited mRNA sequence mediated by two or more overlapping guide RNAs (SO:0000602). [http://dna.kdna.ucla.edu/rna/index.aspx]"
        },
        "SO:0000607": {
            "name": "unedited_region",
            "def": "The region of an edited transcript that will not be edited. [http://dna.kdna.ucla.edu/rna/index.aspx]"
        },
        "SO:0000608": {
            "name": "H_ACA_box_snoRNA_encoding"
        },
        "SO:0000609": {
            "name": "oligo_U_tail",
            "def": "The string of non-encoded U's at the 3' end of a guide RNA (SO:0000602). [http://www.rna.ucla.edu/]"
        },
        "SO:0000610": {
            "name": "polyA_sequence",
            "def": "Sequence of about 100 nucleotides of A added to the 3' end of most eukaryotic mRNAs. [SO:ke]"
        },
        "SO:0000611": {
            "name": "branch_site",
            "def": "A pyrimidine rich sequence near the 3' end of an intron to which the 5'end becomes covalently bound during nuclear splicing. The resulting structure resembles a lariat. [SO:ke]"
        },
        "SO:0000612": {
            "name": "polypyrimidine_tract",
            "def": "The polypyrimidine tract is one of the cis-acting sequence elements directing intron removal in pre-mRNA splicing. [http://nar.oupjournals.org/cgi/content/full/25/4/888]"
        },
        "SO:0000613": {
            "name": "bacterial_RNApol_promoter",
            "def": "A DNA sequence to which bacterial RNA polymerase binds, to begin transcription. [SO:ke]"
        },
        "SO:0000614": {
            "name": "bacterial_terminator",
            "def": "A terminator signal for bacterial transcription. [SO:ke]"
        },
        "SO:0000615": {
            "name": "terminator_of_type_2_RNApol_III_promoter",
            "def": "A terminator signal for RNA polymerase III transcription. [SO:ke]"
        },
        "SO:0000616": {
            "name": "transcription_end_site",
            "def": "The base where transcription ends. [SO:ke]"
        },
        "SO:0000617": {
            "name": "RNApol_III_promoter_type_1"
        },
        "SO:0000618": {
            "name": "RNApol_III_promoter_type_2"
        },
        "SO:0000619": {
            "name": "A_box",
            "def": "A variably distant linear promoter region recognized by TFIIIC, with consensus sequence TGGCnnAGTGG. [SO:ke]"
        },
        "SO:0000620": {
            "name": "B_box",
            "def": "A variably distant linear promoter region recognized by TFIIIC, with consensus sequence AGGTTCCAnnCC. [SO:ke]"
        },
        "SO:0000621": {
            "name": "RNApol_III_promoter_type_3"
        },
        "SO:0000622": {
            "name": "C_box",
            "def": "An RNA polymerase III type 1 promoter with consensus sequence CAnnCCn. [SO:ke]"
        },
        "SO:0000623": {
            "name": "snRNA_encoding"
        },
        "SO:0000624": {
            "name": "telomere",
            "def": "A specific structure at the end of a linear chromosome, required for the integrity and maintenance of the end. [SO:ma]"
        },
        "SO:0000625": {
            "name": "silencer",
            "def": "A regulatory region which upon binding of transcription factors, suppress the transcription of the gene or genes they control. [SO:ke]"
        },
        "SO:0000626": {
            "name": "chromosomal_regulatory_element"
        },
        "SO:0000627": {
            "name": "insulator",
            "def": "A transcriptional cis regulatory region that when located between a CM and a gene's promoter prevents the CRM from modulating that genes expression. [SO:regcreative]"
        },
        "SO:0000628": {
            "name": "chromosomal_structural_element"
        },
        "SO:0000629": {
            "name": "five_prime_open_reading_frame"
        },
        "SO:0000630": {
            "name": "upstream_AUG_codon",
            "def": "A start codon upstream of the ORF. [SO:ke]"
        },
        "SO:0000631": {
            "name": "polycistronic_primary_transcript",
            "def": "A primary transcript encoding for more than one gene product. [SO:ke]"
        },
        "SO:0000632": {
            "name": "monocistronic_primary_transcript",
            "def": "A primary transcript encoding for one gene product. [SO:ke]"
        },
        "SO:0000633": {
            "name": "monocistronic_mRNA",
            "def": "An mRNA with either a single protein product, or for which the regions encoding all its protein products overlap. [SO:rd]"
        },
        "SO:0000634": {
            "name": "polycistronic_mRNA",
            "def": "An mRNA that encodes multiple proteins from at least two non-overlapping regions. [SO:rd]"
        },
        "SO:0000635": {
            "name": "mini_exon_donor_RNA",
            "def": "A primary transcript that donates the spliced leader to other mRNA. [SO:ke]"
        },
        "SO:0000636": {
            "name": "spliced_leader_RNA"
        },
        "SO:0000637": {
            "name": "engineered_plasmid",
            "def": "A plasmid that is engineered. [SO:xp]"
        },
        "SO:0000638": {
            "name": "transcribed_spacer_region",
            "def": "Part of an rRNA transcription unit that is transcribed but discarded during maturation, not giving rise to any part of rRNA. [http://oregonstate.edu/instruction/bb492/general/glossary.html]"
        },
        "SO:0000639": {
            "name": "internal_transcribed_spacer_region",
            "def": "Non-coding regions of DNA sequence that separate genes coding for the 28S, 5.8S, and 18S ribosomal RNAs. [SO:ke]"
        },
        "SO:0000640": {
            "name": "external_transcribed_spacer_region",
            "def": "Non-coding regions of DNA that precede the sequence that codes for the ribosomal RNA. [SO:ke]"
        },
        "SO:0000641": {
            "name": "tetranucleotide_repeat_microsatellite_feature"
        },
        "SO:0000642": {
            "name": "SRP_RNA_encoding"
        },
        "SO:0000643": {
            "name": "minisatellite",
            "def": "A repeat region containing tandemly repeated sequences having a unit length of 10 to 40 bp. [http://www.informatics.jax.org/silver/glossary.shtml]"
        },
        "SO:0000644": {
            "name": "antisense_RNA",
            "def": "Antisense RNA is RNA that is transcribed from the coding, rather than the template, strand of DNA. It is therefore complementary to mRNA. [SO:ke]"
        },
        "SO:0000645": {
            "name": "antisense_primary_transcript",
            "def": "The reverse complement of the primary transcript. [SO:ke]"
        },
        "SO:0000646": {
            "name": "siRNA",
            "def": "A small RNA molecule that is the product of a longer exogenous or endogenous dsRNA, which is either a bimolecular duplex or very long hairpin, processed (via the Dicer pathway) such that numerous siRNAs accumulate from both strands of the dsRNA. SRNAs trigger the cleavage of their target molecules. [PMID:12592000]"
        },
        "SO:0000647": {
            "name": "miRNA_primary_transcript",
            "def": "A primary transcript encoding a micro RNA. [SO:ke]"
        },
        "SO:0000650": {
            "name": "small_subunit_rRNA",
            "def": "Ribosomal RNA transcript that structures the small subunit of the ribosome. [SO:ke]"
        },
        "SO:0000651": {
            "name": "large_subunit_rRNA",
            "def": "Ribosomal RNA transcript that structures the large subunit of the ribosome. [SO:ke]"
        },
        "SO:0000652": {
            "name": "rRNA_5S",
            "def": "5S ribosomal RNA (5S rRNA) is a component of the large ribosomal subunit in both prokaryotes and eukaryotes. In eukaryotes, it is synthesised by RNA polymerase III (the other eukaryotic rRNAs are cleaved from a 45S precursor synthesised by RNA polymerase I). In Xenopus oocytes, it has been shown that fingers 4-7 of the nine-zinc finger transcription factor TFIIIA can bind to the central region of 5S RNA. Thus, in addition to positively regulating 5S rRNA transcription, TFIIIA also stabilizes 5S rRNA until it is required for transcription. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00001]"
        },
        "SO:0000653": {
            "name": "rRNA_28S",
            "def": "A component of the large ribosomal subunit. [SO:ke]"
        },
        "SO:0000654": {
            "name": "maxicircle_gene",
            "def": "A mitochondrial gene located in a maxicircle. [SO:xp]"
        },
        "SO:0000655": {
            "name": "ncRNA",
            "def": "An RNA transcript that does not encode for a protein rather the RNA molecule is the gene product. [SO:ke]"
        },
        "SO:0000656": {
            "name": "stRNA_encoding"
        },
        "SO:0000657": {
            "name": "repeat_region",
            "def": "A region of sequence containing one or more repeat units. [SO:ke]"
        },
        "SO:0000658": {
            "name": "dispersed_repeat",
            "def": "A repeat that is located at dispersed sites in the genome. [SO:ke]"
        },
        "SO:0000659": {
            "name": "tmRNA_encoding"
        },
        "SO:0000660": {
            "name": "DNA_invertase_target_sequence"
        },
        "SO:0000661": {
            "name": "intron_attribute"
        },
        "SO:0000662": {
            "name": "spliceosomal_intron",
            "def": "An intron which is spliced by the spliceosome. [SO:ke]"
        },
        "SO:0000663": {
            "name": "tRNA_encoding"
        },
        "SO:0000664": {
            "name": "introgressed_chromosome_region"
        },
        "SO:0000665": {
            "name": "monocistronic_transcript",
            "def": "A transcript that is monocistronic. [SO:xp]"
        },
        "SO:0000666": {
            "name": "mobile_intron",
            "def": "An intron (mitochondrial, chloroplast, nuclear or prokaryotic) that encodes a double strand sequence specific endonuclease allowing for mobility. [SO:ke]"
        },
        "SO:0000667": {
            "name": "insertion",
            "def": "The sequence of one or more nucleotides added between two adjacent nucleotides in the sequence. [SO:ke]"
        },
        "SO:0000668": {
            "name": "EST_match",
            "def": "A match against an EST sequence. [SO:ke]"
        },
        "SO:0000669": {
            "name": "sequence_rearrangement_feature"
        },
        "SO:0000670": {
            "name": "chromosome_breakage_sequence",
            "def": "A sequence within the micronuclear DNA of ciliates at which chromosome breakage and telomere addition occurs during nuclear differentiation. [SO:ma]"
        },
        "SO:0000671": {
            "name": "internal_eliminated_sequence",
            "def": "A sequence eliminated from the genome of ciliates during nuclear differentiation. [SO:ma]"
        },
        "SO:0000672": {
            "name": "macronucleus_destined_segment",
            "def": "A sequence that is conserved, although rearranged relative to the micronucleus, in the macronucleus of a ciliate genome. [SO:ma]"
        },
        "SO:0000673": {
            "name": "transcript",
            "def": "An RNA synthesized on a DNA or RNA template by an RNA polymerase. [SO:ma]"
        },
        "SO:0000674": {
            "name": "non_canonical_splice_site",
            "def": "A splice site where the donor and acceptor sites differ from the canonical form. [SO:ke]"
        },
        "SO:0000675": {
            "name": "canonical_splice_site",
            "def": "The major class of splice site with dinucleotides GT and AG for donor and acceptor sites, respectively. [SO:ke]"
        },
        "SO:0000676": {
            "name": "canonical_three_prime_splice_site",
            "def": "The canonical 3' splice site has the sequence \\AG\\. [SO:ke]"
        },
        "SO:0000677": {
            "name": "canonical_five_prime_splice_site",
            "def": "The canonical 5' splice site has the sequence \\GT\\. [SO:ke]"
        },
        "SO:0000678": {
            "name": "non_canonical_three_prime_splice_site",
            "def": "A 3' splice site that does not have the sequence \\AG\\. [SO:ke]"
        },
        "SO:0000679": {
            "name": "non_canonical_five_prime_splice_site",
            "def": "A 5' splice site which does not have the sequence \\GT\\. [SO:ke]"
        },
        "SO:0000680": {
            "name": "non_canonical_start_codon",
            "def": "A start codon that is not the usual AUG sequence. [SO:ke]"
        },
        "SO:0000681": {
            "name": "aberrant_processed_transcript",
            "def": "A transcript that has been processed \\incorrectly\\, for example by the failure of splicing of one or more exons. [SO:ke]"
        },
        "SO:0000682": {
            "name": "splicing_feature"
        },
        "SO:0000683": {
            "name": "exonic_splice_enhancer",
            "def": "Exonic splicing enhancers (ESEs) facilitate exon definition by assisting in the recruitment of splicing factors to the adjacent intron. [http://www.ncbi.nlm.nih.gov:80/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=12403462&dopt=Abstract]"
        },
        "SO:0000684": {
            "name": "nuclease_sensitive_site",
            "def": "A region of nucleotide sequence targeted by a nuclease enzyme. [SO:ma]"
        },
        "SO:0000685": {
            "name": "DNAseI_hypersensitive_site"
        },
        "SO:0000686": {
            "name": "translocation_element",
            "def": "A chromosomal translocation whereby the chromosomes carrying non-homologous centromeres may be recovered independently. These chromosomes are described as translocation elements. This occurs for some translocations, particularly but not exclusively, reciprocal translocations. [SO:ma]"
        },
        "SO:0000687": {
            "name": "deletion_junction",
            "def": "The space between two bases in a sequence which marks the position where a deletion has occurred. [SO:ke]"
        },
        "SO:0000688": {
            "name": "golden_path",
            "def": "A set of subregions selected from sequence contigs which when concatenated form a nonredundant linear sequence. [SO:ls]"
        },
        "SO:0000689": {
            "name": "cDNA_match",
            "def": "A match against cDNA sequence. [SO:ke]"
        },
        "SO:0000690": {
            "name": "gene_with_polycistronic_transcript",
            "def": "A gene that encodes a polycistronic transcript. [SO:xp]"
        },
        "SO:0000691": {
            "name": "cleaved_initiator_methionine",
            "def": "The initiator methionine that has been cleaved from a mature polypeptide sequence. [EBIBS:GAR]"
        },
        "SO:0000692": {
            "name": "gene_with_dicistronic_transcript",
            "def": "A gene that encodes a dicistronic transcript. [SO:xp]"
        },
        "SO:0000693": {
            "name": "gene_with_recoded_mRNA",
            "def": "A gene that encodes an mRNA that is recoded. [SO:xp]"
        },
        "SO:0000694": {
            "name": "SNP",
            "def": "SNPs are single base pair positions in genomic DNA at which different sequence alternatives exist in normal individuals in some population(s), wherein the least frequent variant has an abundance of 1% or greater. [SO:cb]"
        },
        "SO:0000695": {
            "name": "reagent",
            "def": "A sequence used in experiment. [SO:ke]"
        },
        "SO:0000696": {
            "name": "oligo",
            "def": "A short oligonucleotide sequence, of length on the order of 10's of bases; either single or double stranded. [SO:ma]"
        },
        "SO:0000697": {
            "name": "gene_with_stop_codon_read_through",
            "def": "A gene that encodes a transcript with stop codon readthrough. [SO:xp]"
        },
        "SO:0000698": {
            "name": "gene_with_stop_codon_redefined_as_pyrrolysine",
            "def": "A gene encoding an mRNA that has the stop codon redefined as pyrrolysine. [SO:xp]"
        },
        "SO:0000699": {
            "name": "junction",
            "def": "A sequence_feature with an extent of zero. [SO:ke]"
        },
        "SO:0000700": {
            "name": "remark",
            "def": "A comment about the sequence. [SO:ke]"
        },
        "SO:0000701": {
            "name": "possible_base_call_error",
            "def": "A region of sequence where the validity of the base calling is questionable. [SO:ke]"
        },
        "SO:0000702": {
            "name": "possible_assembly_error",
            "def": "A region of sequence where there may have been an error in the assembly. [SO:ke]"
        },
        "SO:0000703": {
            "name": "experimental_result_region",
            "def": "A region of sequence implicated in an experimental result. [SO:ke]"
        },
        "SO:0000704": {
            "name": "gene",
            "def": "A region (or regions) that includes all of the sequence elements necessary to encode a functional transcript. A gene may include regulatory regions, transcribed regions and/or other functional sequence regions. [SO:immuno_workshop]"
        },
        "SO:0000705": {
            "name": "tandem_repeat",
            "def": "Two or more adjacent copies of a region (of length greater than 1). [SO:ke]"
        },
        "SO:0000706": {
            "name": "trans_splice_acceptor_site",
            "def": "The 3' splice site of the acceptor primary transcript. [SO:ke]"
        },
        "SO:0000707": {
            "name": "trans_splice_donor_site",
            "def": "The 5' five prime splice site region of the donor RNA. [SO:ke]"
        },
        "SO:0000708": {
            "name": "SL1_acceptor_site",
            "def": "A trans_splicing_acceptor_site which appends the 22nt SL1 RNA leader sequence to the 5' end of most mRNAs. [SO:nlw]"
        },
        "SO:0000709": {
            "name": "SL2_acceptor_site",
            "def": "A trans_splicing_acceptor_site which appends the 22nt SL2 RNA leader sequence to the 5' end of mRNAs. SL2 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]"
        },
        "SO:0000710": {
            "name": "gene_with_stop_codon_redefined_as_selenocysteine",
            "def": "A gene encoding an mRNA that has the stop codon redefined as selenocysteine. [SO:xp]"
        },
        "SO:0000711": {
            "name": "gene_with_mRNA_recoded_by_translational_bypass",
            "def": "A gene with mRNA recoded by translational bypass. [SO:xp]"
        },
        "SO:0000712": {
            "name": "gene_with_transcript_with_translational_frameshift",
            "def": "A gene encoding a transcript that has a translational frameshift. [SO:xp]"
        },
        "SO:0000713": {
            "name": "DNA_motif",
            "def": "A motif that is active in the DNA form of the sequence. [SO:ke]"
        },
        "SO:0000714": {
            "name": "nucleotide_motif",
            "def": "A region of nucleotide sequence corresponding to a known motif. [SO:ke]"
        },
        "SO:0000715": {
            "name": "RNA_motif",
            "def": "A motif that is active in RNA sequence. [SO:ke]"
        },
        "SO:0000716": {
            "name": "dicistronic_mRNA",
            "def": "An mRNA that has the quality dicistronic. [SO:ke]"
        },
        "SO:0000717": {
            "name": "reading_frame",
            "def": "A nucleic acid sequence that when read as sequential triplets, has the potential of encoding a sequential string of amino acids. It need not contain the start or stop codon. [SGD:rb]"
        },
        "SO:0000718": {
            "name": "blocked_reading_frame",
            "def": "A reading_frame that is interrupted by one or more stop codons; usually identified through inter-genomic sequence comparisons. [SGD:rb]"
        },
        "SO:0000719": {
            "name": "ultracontig",
            "def": "An ordered and oriented set of scaffolds based on somewhat weaker sets of inferential evidence such as one set of mate pair reads together with supporting evidence from ESTs or location of markers from SNP or microsatellite maps, or cytogenetic localization of contained markers. [FB:WG]"
        },
        "SO:0000720": {
            "name": "foreign_transposable_element",
            "def": "A transposable element that is foreign. [SO:ke]"
        },
        "SO:0000721": {
            "name": "gene_with_dicistronic_primary_transcript",
            "def": "A gene that encodes a dicistronic primary transcript. [SO:xp]"
        },
        "SO:0000722": {
            "name": "gene_with_dicistronic_mRNA",
            "def": "A gene that encodes a polycistronic mRNA. [SO:xp]"
        },
        "SO:0000723": {
            "name": "iDNA",
            "def": "Genomic sequence removed from the genome, as a normal event, by a process of recombination. [SO:ma]"
        },
        "SO:0000724": {
            "name": "oriT",
            "def": "A region of a DNA molecule where transfer is initiated during the process of conjugation or mobilization. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000725": {
            "name": "transit_peptide",
            "def": "The transit_peptide is a short region at the N-terminus of the peptide that directs the protein to an organelle (chloroplast, mitochondrion, microbody or cyanelle). [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0000726": {
            "name": "repeat_unit",
            "def": "The simplest repeated component of a repeat region. A single repeat. [SO:ke]"
        },
        "SO:0000727": {
            "name": "CRM",
            "def": "A regulatory region where transcription factor binding sites clustered to regulate various aspects of transcription activities. (CRMs can be located a few kb to hundred kb upstream of the basal promoter, in the coding sequence, within introns, or in the downstream 3'UTR sequences, as well as on different chromosome). A single gene can be regulated by multiple CRMs to give precise control of its spatial and temporal expression. CRMs function as nodes in large, intertwined regulatory network. [PMID:19660565, SO:SG]"
        },
        "SO:0000728": {
            "name": "intein",
            "def": "A region of a peptide that is able to excise itself and rejoin the remaining portions with a peptide bond. [SO:ke]"
        },
        "SO:0000729": {
            "name": "intein_containing",
            "def": "An attribute of protein-coding genes where the initial protein product contains an intein. [SO:ke]"
        },
        "SO:0000730": {
            "name": "gap",
            "def": "A gap in the sequence of known length. The unknown bases are filled in with N's. [SO:ke]"
        },
        "SO:0000731": {
            "name": "fragmentary",
            "def": "An attribute to describe a feature that is incomplete. [SO:ke]"
        },
        "SO:0000732": {
            "name": "predicted",
            "def": "An attribute describing an unverified region. [SO:ke]"
        },
        "SO:0000733": {
            "name": "feature_attribute",
            "def": "An attribute describing a located_sequence_feature. [SO:ke]"
        },
        "SO:0000734": {
            "name": "exemplar_mRNA",
            "def": "An exemplar is a representative cDNA sequence for each gene. The exemplar approach is a method that usually involves some initial clustering into gene groups and the subsequent selection of a representative from each gene group. [http://mged.sourceforge.net/ontologies/MGEDontology.php]"
        },
        "SO:0000735": {
            "name": "sequence_location"
        },
        "SO:0000736": {
            "name": "organelle_sequence"
        },
        "SO:0000737": {
            "name": "mitochondrial_sequence"
        },
        "SO:0000738": {
            "name": "nuclear_sequence"
        },
        "SO:0000739": {
            "name": "nucleomorphic_sequence"
        },
        "SO:0000740": {
            "name": "plastid_sequence"
        },
        "SO:0000741": {
            "name": "kinetoplast",
            "def": "A kinetoplast is an interlocked network of thousands of minicircles and tens of maxicircles, located near the base of the flagellum of some protozoan species. [PMID:8395055]"
        },
        "SO:0000742": {
            "name": "maxicircle",
            "def": "A maxicircle is a replicon, part of a kinetoplast, that contains open reading frames and replicates via a rolling circle method. [PMID:8395055]"
        },
        "SO:0000743": {
            "name": "apicoplast_sequence"
        },
        "SO:0000744": {
            "name": "chromoplast_sequence"
        },
        "SO:0000745": {
            "name": "chloroplast_sequence"
        },
        "SO:0000746": {
            "name": "cyanelle_sequence"
        },
        "SO:0000747": {
            "name": "leucoplast_sequence"
        },
        "SO:0000748": {
            "name": "proplastid_sequence"
        },
        "SO:0000749": {
            "name": "plasmid_location"
        },
        "SO:0000750": {
            "name": "amplification_origin",
            "def": "An origin_of_replication that is used for the amplification of a chromosomal nucleic acid sequence. [SO:ma]"
        },
        "SO:0000751": {
            "name": "proviral_location"
        },
        "SO:0000752": {
            "name": "gene_group_regulatory_region"
        },
        "SO:0000753": {
            "name": "clone_insert",
            "def": "The region of sequence that has been inserted and is being propagated by the clone. [SO:ke]"
        },
        "SO:0000754": {
            "name": "lambda_vector",
            "def": "The lambda bacteriophage is the vector for the linear lambda clone. The genes involved in the lysogenic pathway are removed from the from the viral DNA. Up to 25 kb of foreign DNA can then be inserted into the lambda genome. [ISBN:0-1767-2380-8]"
        },
        "SO:0000755": {
            "name": "plasmid_vector"
        },
        "SO:0000756": {
            "name": "cDNA",
            "def": "DNA synthesized by reverse transcriptase using RNA as a template. [SO:ma]"
        },
        "SO:0000757": {
            "name": "single_stranded_cDNA"
        },
        "SO:0000758": {
            "name": "double_stranded_cDNA"
        },
        "SO:0000759": {
            "name": "plasmid_clone"
        },
        "SO:0000760": {
            "name": "YAC_clone"
        },
        "SO:0000761": {
            "name": "phagemid_clone"
        },
        "SO:0000762": {
            "name": "PAC_clone"
        },
        "SO:0000763": {
            "name": "fosmid_clone"
        },
        "SO:0000764": {
            "name": "BAC_clone"
        },
        "SO:0000765": {
            "name": "cosmid_clone"
        },
        "SO:0000766": {
            "name": "pyrrolysyl_tRNA",
            "def": "A tRNA sequence that has a pyrrolysine anticodon, and a 3' pyrrolysine binding region. [SO:ke]"
        },
        "SO:0000767": {
            "name": "clone_insert_start"
        },
        "SO:0000768": {
            "name": "episome",
            "def": "A plasmid that may integrate with a chromosome. [SO:ma]"
        },
        "SO:0000769": {
            "name": "tmRNA_coding_piece",
            "def": "The region of a two-piece tmRNA that bears the reading frame encoding the proteolysis tag. The tmRNA gene undergoes circular permutation in some groups of bacteria. Processing of the transcripts from such a gene leaves the mature tmRNA in two pieces, base-paired together. [doi:10.1093/nar/gkh795, Indiana:kw, issn:1362-4962]"
        },
        "SO:0000770": {
            "name": "tmRNA_acceptor_piece",
            "def": "The acceptor region of a two-piece tmRNA that when mature is charged at its 3' end with alanine. The tmRNA gene undergoes circular permutation in some groups of bacteria; processing of the transcripts from such a gene leaves the mature tmRNA in two pieces, base-paired together. [doi:10.1093/nar/gkh795, Indiana:kw]"
        },
        "SO:0000771": {
            "name": "QTL",
            "def": "A quantitative trait locus (QTL) is a polymorphic locus which contains alleles that differentially affect the expression of a continuously distributed phenotypic trait. Usually it is a marker described by statistical association to quantitative variation in the particular phenotypic trait that is thought to be controlled by the cumulative action of alleles at multiple loci. [http://rgd.mcw.edu/tu/qtls/]"
        },
        "SO:0000772": {
            "name": "genomic_island",
            "def": "A genomic island is an integrated mobile genetic element, characterized by size (over 10 Kb). It that has features that suggest a foreign origin. These can include nucleotide distribution (oligonucleotides signature, CG content etc.) that differs from the bulk of the chromosome and/or genes suggesting DNA mobility. [Phigo:at, SO:ke]"
        },
        "SO:0000773": {
            "name": "pathogenic_island",
            "def": "Mobile genetic elements that contribute to rapid changes in virulence potential. They are present on the genomes of pathogenic strains but absent from the genomes of non pathogenic members of the same or related species. [SO:ke]"
        },
        "SO:0000774": {
            "name": "metabolic_island",
            "def": "A transmissible element containing genes involved in metabolism, analogous to the pathogenicity islands of gram negative bacteria. [SO:ke]"
        },
        "SO:0000775": {
            "name": "adaptive_island",
            "def": "An adaptive island is a genomic island that provides an adaptive advantage to the host. [SO:ke]"
        },
        "SO:0000776": {
            "name": "symbiosis_island",
            "def": "A transmissible element containing genes involved in symbiosis, analogous to the pathogenicity islands of gram negative bacteria. [SO:ke]"
        },
        "SO:0000777": {
            "name": "pseudogenic_rRNA",
            "def": "A non functional descendant of an rRNA. [SO:ke]"
        },
        "SO:0000778": {
            "name": "pseudogenic_tRNA",
            "def": "A non functional descendent of a tRNA. [SO:ke]"
        },
        "SO:0000779": {
            "name": "engineered_episome",
            "def": "An episome that is engineered. [SO:xp]"
        },
        "SO:0000780": {
            "name": "transposable_element_attribute"
        },
        "SO:0000781": {
            "name": "transgenic",
            "def": "Attribute describing sequence that has been integrated with foreign sequence. [SO:ke]"
        },
        "SO:0000782": {
            "name": "natural",
            "def": "An attribute describing a feature that occurs in nature. [SO:ke]"
        },
        "SO:0000783": {
            "name": "engineered",
            "def": "An attribute to describe a region that was modified in vitro. [SO:ke]"
        },
        "SO:0000784": {
            "name": "foreign",
            "def": "An attribute to describe a region from another species. [SO:ke]"
        },
        "SO:0000785": {
            "name": "cloned_region"
        },
        "SO:0000786": {
            "name": "reagent_attribute"
        },
        "SO:0000787": {
            "name": "clone_attribute"
        },
        "SO:0000788": {
            "name": "cloned"
        },
        "SO:0000789": {
            "name": "validated",
            "def": "An attribute to describe a feature that has been proven. [SO:ke]"
        },
        "SO:0000790": {
            "name": "invalidated",
            "def": "An attribute describing a feature that is invalidated. [SO:ke]"
        },
        "SO:0000791": {
            "name": "cloned_genomic"
        },
        "SO:0000792": {
            "name": "cloned_cDNA"
        },
        "SO:0000793": {
            "name": "engineered_DNA"
        },
        "SO:0000794": {
            "name": "engineered_rescue_region",
            "def": "A rescue region that is engineered. [SO:xp]"
        },
        "SO:0000795": {
            "name": "rescue_mini_gene",
            "def": "A mini_gene that rescues. [SO:xp]"
        },
        "SO:0000796": {
            "name": "transgenic_transposable_element",
            "def": "TE that has been modified in vitro, including insertion of DNA derived from a source other than the originating TE. [FB:mc]"
        },
        "SO:0000797": {
            "name": "natural_transposable_element",
            "def": "TE that exists (or existed) in nature. [FB:mc]"
        },
        "SO:0000798": {
            "name": "engineered_transposable_element",
            "def": "TE that has been modified by manipulations in vitro. [FB:mc]"
        },
        "SO:0000799": {
            "name": "engineered_foreign_transposable_element",
            "def": "A transposable_element that is engineered and foreign. [FB:mc]"
        },
        "SO:0000800": {
            "name": "assortment_derived_duplication",
            "def": "A multi-chromosome duplication aberration generated by reassortment of other aberration components. [FB:gm]"
        },
        "SO:0000801": {
            "name": "assortment_derived_deficiency_plus_duplication",
            "def": "A multi-chromosome aberration generated by reassortment of other aberration components; presumed to have a deficiency and a duplication. [FB:gm]"
        },
        "SO:0000802": {
            "name": "assortment_derived_deficiency",
            "def": "A multi-chromosome deficiency aberration generated by reassortment of other aberration components. [FB:gm]"
        },
        "SO:0000803": {
            "name": "assortment_derived_aneuploid",
            "def": "A multi-chromosome aberration generated by reassortment of other aberration components; presumed to have a deficiency or a duplication. [FB:gm]"
        },
        "SO:0000804": {
            "name": "engineered_region",
            "def": "A region that is engineered. [SO:xp]"
        },
        "SO:0000805": {
            "name": "engineered_foreign_region",
            "def": "A region that is engineered and foreign. [SO:xp]"
        },
        "SO:0000806": {
            "name": "fusion"
        },
        "SO:0000807": {
            "name": "engineered_tag",
            "def": "A tag that is engineered. [SO:xp]"
        },
        "SO:0000808": {
            "name": "validated_cDNA_clone",
            "def": "A cDNA clone that has been validated. [SO:xp]"
        },
        "SO:0000809": {
            "name": "invalidated_cDNA_clone",
            "def": "A cDNA clone that is invalid. [SO:xp]"
        },
        "SO:0000810": {
            "name": "chimeric_cDNA_clone",
            "def": "A cDNA clone invalidated because it is chimeric. [SO:xp]"
        },
        "SO:0000811": {
            "name": "genomically_contaminated_cDNA_clone",
            "def": "A cDNA clone invalidated by genomic contamination. [SO:xp]"
        },
        "SO:0000812": {
            "name": "polyA_primed_cDNA_clone",
            "def": "A cDNA clone invalidated by polyA priming. [SO:xp]"
        },
        "SO:0000813": {
            "name": "partially_processed_cDNA_clone",
            "def": "A cDNA invalidated clone by partial processing. [SO:xp]"
        },
        "SO:0000814": {
            "name": "rescue",
            "def": "An attribute describing a region's ability, when introduced to a mutant organism, to re-establish (rescue) a phenotype. [SO:ke]"
        },
        "SO:0000815": {
            "name": "mini_gene",
            "def": "By definition, minigenes are short open-reading frames (ORF), usually encoding approximately 9 to 20 amino acids, which are expressed in vivo (as distinct from being synthesized as peptide or protein ex vivo and subsequently injected). The in vivo synthesis confers a distinct advantage: the expressed sequences can enter both antigen presentation pathways, MHC I (inducing CD8+ T- cells, which are usually cytotoxic T-lymphocytes (CTL)) and MHC II (inducing CD4+ T-cells, usually 'T-helpers' (Th)); and can encounter B-cells, inducing antibody responses. Three main vector approaches have been used to deliver minigenes: viral vectors, bacterial vectors and plasmid DNA. [PMID:15992143]"
        },
        "SO:0000816": {
            "name": "rescue_gene",
            "def": "A gene that rescues. [SO:xp]"
        },
        "SO:0000817": {
            "name": "wild_type",
            "def": "An attribute describing sequence with the genotype found in nature and/or standard laboratory stock. [SO:ke]"
        },
        "SO:0000818": {
            "name": "wild_type_rescue_gene",
            "def": "A gene that rescues. [SO:xp]"
        },
        "SO:0000819": {
            "name": "mitochondrial_chromosome",
            "def": "A chromosome originating in a mitochondria. [SO:xp]"
        },
        "SO:0000820": {
            "name": "chloroplast_chromosome",
            "def": "A chromosome originating in a chloroplast. [SO:xp]"
        },
        "SO:0000821": {
            "name": "chromoplast_chromosome",
            "def": "A chromosome originating in a chromoplast. [SO:xp]"
        },
        "SO:0000822": {
            "name": "cyanelle_chromosome",
            "def": "A chromosome originating in a cyanelle. [SO:xp]"
        },
        "SO:0000823": {
            "name": "leucoplast_chromosome",
            "def": "A chromosome with origin in a leucoplast. [SO:xp]"
        },
        "SO:0000824": {
            "name": "macronuclear_chromosome",
            "def": "A chromosome originating in a macronucleus. [SO:xp]"
        },
        "SO:0000825": {
            "name": "micronuclear_chromosome",
            "def": "A chromosome originating in a micronucleus. [SO:xp]"
        },
        "SO:0000828": {
            "name": "nuclear_chromosome",
            "def": "A chromosome originating in a nucleus. [SO:xp]"
        },
        "SO:0000829": {
            "name": "nucleomorphic_chromosome",
            "def": "A chromosome originating in a nucleomorph. [SO:xp]"
        },
        "SO:0000830": {
            "name": "chromosome_part",
            "def": "A region of a chromosome. [SO:ke]"
        },
        "SO:0000831": {
            "name": "gene_member_region",
            "def": "A region of a gene. [SO:ke]"
        },
        "SO:0000832": {
            "name": "promoter_region",
            "def": "A region of sequence which is part of a promoter. [SO:ke]"
        },
        "SO:0000833": {
            "name": "transcript_region",
            "def": "A region of a transcript. [SO:ke]"
        },
        "SO:0000834": {
            "name": "mature_transcript_region",
            "def": "A region of a mature transcript. [SO:ke]"
        },
        "SO:0000835": {
            "name": "primary_transcript_region",
            "def": "A part of a primary transcript. [SO:ke]"
        },
        "SO:0000836": {
            "name": "mRNA_region",
            "def": "A region of an mRNA. [SO:cb]"
        },
        "SO:0000837": {
            "name": "UTR_region",
            "def": "A region of UTR. [SO:ke]"
        },
        "SO:0000838": {
            "name": "rRNA_primary_transcript_region",
            "def": "A region of an rRNA primary transcript. [SO:ke]"
        },
        "SO:0000839": {
            "name": "polypeptide_region",
            "def": "Biological sequence region that can be assigned to a specific subsequence of a polypeptide. [SO:GAR, SO:ke]"
        },
        "SO:0000840": {
            "name": "repeat_component",
            "def": "A region of a repeated sequence. [SO:ke]"
        },
        "SO:0000841": {
            "name": "spliceosomal_intron_region",
            "def": "A region within an intron. [SO:ke]"
        },
        "SO:0000842": {
            "name": "gene_component_region"
        },
        "SO:0000843": {
            "name": "bacterial_RNApol_promoter_region",
            "def": "A region which is part of a bacterial RNA polymerase promoter. [SO:ke]"
        },
        "SO:0000844": {
            "name": "RNApol_II_promoter_region",
            "def": "A region of sequence which is a promoter for RNA polymerase II. [SO:ke]"
        },
        "SO:0000845": {
            "name": "RNApol_III_promoter_type_1_region",
            "def": "A region of sequence which is a promoter for RNA polymerase III type 1. [SO:ke]"
        },
        "SO:0000846": {
            "name": "RNApol_III_promoter_type_2_region",
            "def": "A region of sequence which is a promoter for RNA polymerase III type 2. [SO:ke]"
        },
        "SO:0000847": {
            "name": "tmRNA_region",
            "def": "A region of a tmRNA. [SO:cb]"
        },
        "SO:0000848": {
            "name": "LTR_component"
        },
        "SO:0000849": {
            "name": "three_prime_LTR_component"
        },
        "SO:0000850": {
            "name": "five_prime_LTR_component"
        },
        "SO:0000851": {
            "name": "CDS_region",
            "def": "A region of a CDS. [SO:cb]"
        },
        "SO:0000852": {
            "name": "exon_region",
            "def": "A region of an exon. [RSC:cb]"
        },
        "SO:0000853": {
            "name": "homologous_region",
            "def": "A region that is homologous to another region. [SO:ke]"
        },
        "SO:0000854": {
            "name": "paralogous_region",
            "def": "A homologous_region that is paralogous to another region. [SO:ke]"
        },
        "SO:0000855": {
            "name": "orthologous_region",
            "def": "A homologous_region that is orthologous to another region. [SO:ke]"
        },
        "SO:0000856": {
            "name": "conserved"
        },
        "SO:0000857": {
            "name": "homologous",
            "def": "Similarity due to common ancestry. [SO:ke]"
        },
        "SO:0000858": {
            "name": "orthologous",
            "def": "An attribute describing a kind of homology where divergence occurred after a speciation event. [SO:ke]"
        },
        "SO:0000859": {
            "name": "paralogous",
            "def": "An attribute describing a kind of homology where divergence occurred after a duplication event. [SO:ke]"
        },
        "SO:0000860": {
            "name": "syntenic",
            "def": "Attribute describing sequence regions occurring in same order on chromosome of different species. [SO:ke]"
        },
        "SO:0000861": {
            "name": "capped_primary_transcript",
            "def": "A primary transcript that is capped. [SO:xp]"
        },
        "SO:0000862": {
            "name": "capped_mRNA",
            "def": "An mRNA that is capped. [SO:xp]"
        },
        "SO:0000863": {
            "name": "mRNA_attribute",
            "def": "An attribute describing an mRNA feature. [SO:ke]"
        },
        "SO:0000864": {
            "name": "exemplar",
            "def": "An attribute describing a sequence is representative of a class of similar sequences. [SO:ke]"
        },
        "SO:0000865": {
            "name": "frameshift",
            "def": "An attribute describing a sequence that contains a mutation involving the deletion or insertion of one or more bases, where this number is not divisible by 3. [SO:ke]"
        },
        "SO:0000866": {
            "name": "minus_1_frameshift",
            "def": "A frameshift caused by deleting one base. [SO:ke]"
        },
        "SO:0000867": {
            "name": "minus_2_frameshift",
            "def": "A frameshift caused by deleting two bases. [SO:ke]"
        },
        "SO:0000868": {
            "name": "plus_1_frameshift",
            "def": "A frameshift caused by inserting one base. [SO:ke]"
        },
        "SO:0000869": {
            "name": "plus_2_framshift",
            "def": "A frameshift caused by inserting two bases. [SO:ke]"
        },
        "SO:0000870": {
            "name": "trans_spliced",
            "def": "An attribute describing transcript sequence that is created by splicing exons from diferent genes. [SO:ke]"
        },
        "SO:0000871": {
            "name": "polyadenylated_mRNA",
            "def": "An mRNA that is polyadenylated. [SO:xp]"
        },
        "SO:0000872": {
            "name": "trans_spliced_mRNA",
            "def": "An mRNA that is trans-spliced. [SO:xp]"
        },
        "SO:0000873": {
            "name": "edited_transcript",
            "def": "A transcript that is edited. [SO:ke]"
        },
        "SO:0000874": {
            "name": "edited_transcript_by_A_to_I_substitution",
            "def": "A transcript that has been edited by A to I substitution. [SO:ke]"
        },
        "SO:0000875": {
            "name": "bound_by_protein",
            "def": "An attribute describing a sequence that is bound by a protein. [SO:ke]"
        },
        "SO:0000876": {
            "name": "bound_by_nucleic_acid",
            "def": "An attribute describing a sequence that is bound by a nucleic acid. [SO:ke]"
        },
        "SO:0000877": {
            "name": "alternatively_spliced",
            "def": "An attribute describing a situation where a gene may encode for more than 1 transcript. [SO:ke]"
        },
        "SO:0000878": {
            "name": "monocistronic",
            "def": "An attribute describing a sequence that contains the code for one gene product. [SO:ke]"
        },
        "SO:0000879": {
            "name": "dicistronic",
            "def": "An attribute describing a sequence that contains the code for two gene products. [SO:ke]"
        },
        "SO:0000880": {
            "name": "polycistronic",
            "def": "An attribute describing a sequence that contains the code for more than one gene product. [SO:ke]"
        },
        "SO:0000881": {
            "name": "recoded",
            "def": "An attribute describing an mRNA sequence that has been reprogrammed at translation, causing localized alterations. [SO:ke]"
        },
        "SO:0000882": {
            "name": "codon_redefined",
            "def": "An attribute describing the alteration of codon meaning. [SO:ke]"
        },
        "SO:0000883": {
            "name": "stop_codon_read_through",
            "def": "A stop codon redefined to be a new amino acid. [SO:ke]"
        },
        "SO:0000884": {
            "name": "stop_codon_redefined_as_pyrrolysine",
            "def": "A stop codon redefined to be the new amino acid, pyrrolysine. [SO:ke]"
        },
        "SO:0000885": {
            "name": "stop_codon_redefined_as_selenocysteine",
            "def": "A stop codon redefined to be the new amino acid, selenocysteine. [SO:ke]"
        },
        "SO:0000886": {
            "name": "recoded_by_translational_bypass",
            "def": "Recoded mRNA where a block of nucleotides is not translated. [SO:ke]"
        },
        "SO:0000887": {
            "name": "translationally_frameshifted",
            "def": "Recoding by frameshifting a particular site. [SO:ke]"
        },
        "SO:0000888": {
            "name": "maternally_imprinted_gene",
            "def": "A gene that is maternally_imprinted. [SO:xp]"
        },
        "SO:0000889": {
            "name": "paternally_imprinted_gene",
            "def": "A gene that is paternally imprinted. [SO:xp]"
        },
        "SO:0000890": {
            "name": "post_translationally_regulated_gene",
            "def": "A gene that is post translationally regulated. [SO:xp]"
        },
        "SO:0000891": {
            "name": "negatively_autoregulated_gene",
            "def": "A gene that is negatively autoreguated. [SO:xp]"
        },
        "SO:0000892": {
            "name": "positively_autoregulated_gene",
            "def": "A gene that is positively autoregulated. [SO:xp]"
        },
        "SO:0000893": {
            "name": "silenced",
            "def": "An attribute describing an epigenetic process where a gene is inactivated at transcriptional or translational level. [SO:ke]"
        },
        "SO:0000894": {
            "name": "silenced_by_DNA_modification",
            "def": "An attribute describing an epigenetic process where a gene is inactivated by DNA modifications, resulting in repression of transcription. [SO:ke]"
        },
        "SO:0000895": {
            "name": "silenced_by_DNA_methylation",
            "def": "An attribute describing an epigenetic process where a gene is inactivated by DNA methylation, resulting in repression of transcription. [SO:ke]"
        },
        "SO:0000896": {
            "name": "translationally_regulated_gene",
            "def": "A gene that is translationally regulated. [SO:xp]"
        },
        "SO:0000897": {
            "name": "allelically_excluded_gene",
            "def": "A gene that is allelically_excluded. [SO:xp]"
        },
        "SO:0000898": {
            "name": "epigenetically_modified_gene",
            "def": "A gene that is epigenetically modified. [SO:ke]"
        },
        "SO:0000899": {
            "name": "nuclear_mitochondrial",
            "def": "An attribute describing a nuclear pseudogene of a mitochndrial gene. [SO:ke]"
        },
        "SO:0000900": {
            "name": "processed",
            "def": "An attribute describing a pseudogene where by an mRNA was retrotransposed. The mRNA sequence is transcribed back into the genome, lacking introns and promotors, but often including a polyA tail. [SO:ke]"
        },
        "SO:0000901": {
            "name": "unequally_crossed_over",
            "def": "An attribute describing a pseudogene that was created by tandem duplication and unequal crossing over during recombination. [SO:ke]"
        },
        "SO:0000902": {
            "name": "transgene",
            "def": "A transgene is a gene that has been transferred naturally or by any of a number of genetic engineering techniques from one organism to another. [SO:xp]"
        },
        "SO:0000903": {
            "name": "endogenous_retroviral_sequence"
        },
        "SO:0000904": {
            "name": "rearranged_at_DNA_level",
            "def": "An attribute to describe the sequence of a feature, where the DNA is rearranged. [SO:ke]"
        },
        "SO:0000905": {
            "name": "status",
            "def": "An attribute describing the status of a feature, based on the available evidence. [SO:ke]"
        },
        "SO:0000906": {
            "name": "independently_known",
            "def": "Attribute to describe a feature that is independently known - not predicted. [SO:ke]"
        },
        "SO:0000907": {
            "name": "supported_by_sequence_similarity",
            "def": "An attribute to describe a feature that has been predicted using sequence similarity techniques. [SO:ke]"
        },
        "SO:0000908": {
            "name": "supported_by_domain_match",
            "def": "An attribute to describe a feature that has been predicted using sequence similarity of a known domain. [SO:ke]"
        },
        "SO:0000909": {
            "name": "supported_by_EST_or_cDNA",
            "def": "An attribute to describe a feature that has been predicted using sequence similarity to EST or cDNA data. [SO:ke]"
        },
        "SO:0000910": {
            "name": "orphan"
        },
        "SO:0000911": {
            "name": "predicted_by_ab_initio_computation",
            "def": "An attribute describing a feature that is predicted by a computer program that did not rely on sequence similarity. [SO:ke]"
        },
        "SO:0000912": {
            "name": "asx_turn",
            "def": "A motif of three consecutive residues and one H-bond in which: residue(i) is Aspartate or Asparagine (Asx), the side-chain O of residue(i) is H-bonded to the main-chain NH of residue(i+2). [http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0000913": {
            "name": "cloned_cDNA_insert",
            "def": "A clone insert made from cDNA. [SO:xp]"
        },
        "SO:0000914": {
            "name": "cloned_genomic_insert",
            "def": "A clone insert made from genomic DNA. [SO:xp]"
        },
        "SO:0000915": {
            "name": "engineered_insert",
            "def": "A clone insert that is engineered. [SO:xp]"
        },
        "SO:0000916": {
            "name": "edit_operation"
        },
        "SO:0000917": {
            "name": "insert_U",
            "def": "An edit to insert a U. [SO:ke]"
        },
        "SO:0000918": {
            "name": "delete_U",
            "def": "An edit to delete a uridine. [SO:ke]"
        },
        "SO:0000919": {
            "name": "substitute_A_to_I",
            "def": "An edit to substitute an I for an A. [SO:ke]"
        },
        "SO:0000920": {
            "name": "insert_C",
            "def": "An edit to insert a cytidine. [SO:ke]"
        },
        "SO:0000921": {
            "name": "insert_dinucleotide",
            "def": "An edit to insert a dinucleotide. [SO:ke]"
        },
        "SO:0000922": {
            "name": "substitute_C_to_U",
            "def": "An edit to substitute an U for a C. [SO:ke]"
        },
        "SO:0000923": {
            "name": "insert_G",
            "def": "An edit to insert a G. [SO:ke]"
        },
        "SO:0000924": {
            "name": "insert_GC",
            "def": "An edit to insert a GC dinucleotide. [SO:ke]"
        },
        "SO:0000925": {
            "name": "insert_GU",
            "def": "An edit to insert a GU dinucleotide. [SO:ke]"
        },
        "SO:0000926": {
            "name": "insert_CU",
            "def": "An edit to insert a CU dinucleotide. [SO:ke]"
        },
        "SO:0000927": {
            "name": "insert_AU",
            "def": "An edit to insert a AU dinucleotide. [SO:ke]"
        },
        "SO:0000928": {
            "name": "insert_AA",
            "def": "An edit to insert a AA dinucleotide. [SO:ke]"
        },
        "SO:0000929": {
            "name": "edited_mRNA",
            "def": "An mRNA that is edited. [SO:xp]"
        },
        "SO:0000930": {
            "name": "guide_RNA_region",
            "def": "A region of guide RNA. [SO:ma]"
        },
        "SO:0000931": {
            "name": "anchor_region",
            "def": "A region of a guide_RNA that base-pairs to a target mRNA. [SO:jk]"
        },
        "SO:0000932": {
            "name": "pre_edited_mRNA"
        },
        "SO:0000933": {
            "name": "intermediate",
            "def": "An attribute to describe a feature between stages of processing. [SO:ke]"
        },
        "SO:0000934": {
            "name": "miRNA_target_site",
            "def": "A miRNA target site is a binding site where the molecule is a micro RNA. [FB:cds]"
        },
        "SO:0000935": {
            "name": "edited_CDS",
            "def": "A CDS that is edited. [SO:xp]"
        },
        "SO:0000936": {
            "name": "vertebrate_immunoglobulin_T_cell_receptor_rearranged_segment"
        },
        "SO:0000937": {
            "name": "vertebrate_immune_system_feature"
        },
        "SO:0000938": {
            "name": "vertebrate_immunoglobulin_T_cell_receptor_rearranged_gene_cluster"
        },
        "SO:0000939": {
            "name": "vertebrate_immune_system_gene_recombination_signal_feature"
        },
        "SO:0000940": {
            "name": "recombinationally_rearranged"
        },
        "SO:0000941": {
            "name": "recombinationally_rearranged_vertebrate_immune_system_gene",
            "def": "A recombinationally rearranged gene of the vertebrate immune system. [SO:xp]"
        },
        "SO:0000942": {
            "name": "attP_site",
            "def": "An integration/excision site of a phage chromosome at which a recombinase acts to insert the phage DNA at a cognate integration/excision site on a bacterial chromosome. [SO:as]"
        },
        "SO:0000943": {
            "name": "attB_site",
            "def": "An integration/excision site of a bacterial chromosome at which a recombinase acts to insert foreign DNA containing a cognate integration/excision site. [SO:as]"
        },
        "SO:0000944": {
            "name": "attL_site",
            "def": "A region that results from recombination between attP_site and attB_site, composed of the 5' portion of attB_site and the 3' portion of attP_site. [SO:as]"
        },
        "SO:0000945": {
            "name": "attR_site",
            "def": "A region that results from recombination between attP_site and attB_site, composed of the 5' portion of attP_site and the 3' portion of attB_site. [SO:as]"
        },
        "SO:0000946": {
            "name": "integration_excision_site",
            "def": "A region specifically recognised by a recombinase, which inserts or removes another region marked by a distinct cognate integration/excision site. [SO:as]"
        },
        "SO:0000947": {
            "name": "resolution_site",
            "def": "A region specifically recognized by a recombinase, which separates a physically contiguous circle of DNA into two physically separate circles. [SO:as]"
        },
        "SO:0000948": {
            "name": "inversion_site",
            "def": "A region specifically recognised by a recombinase, which inverts the region flanked by a pair of sites. [SO:ma]"
        },
        "SO:0000949": {
            "name": "dif_site",
            "def": "A site at which replicated bacterial circular chromosomes are decatenated by site specific resolvase. [SO:as]"
        },
        "SO:0000950": {
            "name": "attC_site",
            "def": "An attC site is a sequence required for the integration of a DNA of an integron. [SO:as]"
        },
        "SO:0000951": {
            "name": "eukaryotic_terminator"
        },
        "SO:0000952": {
            "name": "oriV",
            "def": "An origin of vegetative replication in plasmids and phages. [SO:as]"
        },
        "SO:0000953": {
            "name": "oriC",
            "def": "An origin of bacterial chromosome replication. [SO:as]"
        },
        "SO:0000954": {
            "name": "DNA_chromosome",
            "def": "Structural unit composed of a self-replicating, DNA molecule. [SO:ma]"
        },
        "SO:0000955": {
            "name": "double_stranded_DNA_chromosome",
            "def": "Structural unit composed of a self-replicating, double-stranded DNA molecule. [SO:ma]"
        },
        "SO:0000956": {
            "name": "single_stranded_DNA_chromosome",
            "def": "Structural unit composed of a self-replicating, single-stranded DNA molecule. [SO:ma]"
        },
        "SO:0000957": {
            "name": "linear_double_stranded_DNA_chromosome",
            "def": "Structural unit composed of a self-replicating, double-stranded, linear DNA molecule. [SO:ma]"
        },
        "SO:0000958": {
            "name": "circular_double_stranded_DNA_chromosome",
            "def": "Structural unit composed of a self-replicating, double-stranded, circular DNA molecule. [SO:ma]"
        },
        "SO:0000959": {
            "name": "linear_single_stranded_DNA_chromosome",
            "def": "Structural unit composed of a self-replicating, single-stranded, linear DNA molecule. [SO:ma]"
        },
        "SO:0000960": {
            "name": "circular_single_stranded_DNA_chromosome",
            "def": "Structural unit composed of a self-replicating, single-stranded, circular DNA molecule. [SO:ma]"
        },
        "SO:0000961": {
            "name": "RNA_chromosome",
            "def": "Structural unit composed of a self-replicating, RNA molecule. [SO:ma]"
        },
        "SO:0000962": {
            "name": "single_stranded_RNA_chromosome",
            "def": "Structural unit composed of a self-replicating, single-stranded RNA molecule. [SO:ma]"
        },
        "SO:0000963": {
            "name": "linear_single_stranded_RNA_chromosome",
            "def": "Structural unit composed of a self-replicating, single-stranded, linear RNA molecule. [SO:ma]"
        },
        "SO:0000964": {
            "name": "linear_double_stranded_RNA_chromosome",
            "def": "Structural unit composed of a self-replicating, double-stranded, linear RNA molecule. [SO:ma]"
        },
        "SO:0000965": {
            "name": "double_stranded_RNA_chromosome",
            "def": "Structural unit composed of a self-replicating, double-stranded RNA molecule. [SO:ma]"
        },
        "SO:0000966": {
            "name": "circular_single_stranded_RNA_chromosome",
            "def": "Structural unit composed of a self-replicating, single-stranded, circular DNA molecule. [SO:ma]"
        },
        "SO:0000967": {
            "name": "circular_double_stranded_RNA_chromosome",
            "def": "Structural unit composed of a self-replicating, double-stranded, circular RNA molecule. [SO:ma]"
        },
        "SO:0000968": {
            "name": "sequence_replication_mode"
        },
        "SO:0000969": {
            "name": "rolling_circle"
        },
        "SO:0000970": {
            "name": "theta_replication"
        },
        "SO:0000971": {
            "name": "DNA_replication_mode"
        },
        "SO:0000972": {
            "name": "RNA_replication_mode"
        },
        "SO:0000973": {
            "name": "insertion_sequence",
            "def": "A terminal_inverted_repeat_element that is bacterial and only encodes the functions required for its transposition between these inverted repeats. [SO:as]"
        },
        "SO:0000975": {
            "name": "minicircle_gene"
        },
        "SO:0000976": {
            "name": "cryptic",
            "def": "A feature_attribute describing a feature that is not manifest under normal conditions. [SO:ke]"
        },
        "SO:0000977": {
            "name": "anchor_binding_site"
        },
        "SO:0000978": {
            "name": "template_region",
            "def": "A region of a guide_RNA that specifies the insertions and deletions of bases in the editing of a target mRNA. [SO:jk]"
        },
        "SO:0000979": {
            "name": "gRNA_encoding",
            "def": "A non-protein_coding gene that encodes a guide_RNA. [SO:ma]"
        },
        "SO:0000980": {
            "name": "minicircle",
            "def": "A minicircle is a replicon, part of a kinetoplast, that encodes for guide RNAs. [PMID:8395055]"
        },
        "SO:0000981": {
            "name": "rho_dependent_bacterial_terminator"
        },
        "SO:0000982": {
            "name": "rho_independent_bacterial_terminator"
        },
        "SO:0000983": {
            "name": "strand_attribute"
        },
        "SO:0000984": {
            "name": "single"
        },
        "SO:0000985": {
            "name": "double"
        },
        "SO:0000986": {
            "name": "topology_attribute"
        },
        "SO:0000987": {
            "name": "linear",
            "def": "A quality of a nucleotide polymer that has a 3'-terminal residue and a 5'-terminal residue. [SO:cb]"
        },
        "SO:0000988": {
            "name": "circular",
            "def": "A quality of a nucleotide polymer that has no terminal nucleotide residues. [SO:cb]"
        },
        "SO:0000989": {
            "name": "class_II_RNA",
            "def": "Small non-coding RNA (59-60 nt long) containing 5' and 3' ends that are predicted to come together to form a stem structure. Identified in the social amoeba Dictyostelium discoideum and localized in the cytoplasm. [PMID:15333696]"
        },
        "SO:0000990": {
            "name": "class_I_RNA",
            "def": "Small non-coding RNA (55-65 nt long) containing highly conserved 5' and 3' ends (16 and 8 nt, respectively) that are predicted to come together to form a stem structure. Identified in the social amoeba Dictyostelium discoideum and localized in the cytoplasm. [PMID:15333696]"
        },
        "SO:0000991": {
            "name": "genomic_DNA"
        },
        "SO:0000992": {
            "name": "BAC_cloned_genomic_insert"
        },
        "SO:0000993": {
            "name": "consensus"
        },
        "SO:0000994": {
            "name": "consensus_region"
        },
        "SO:0000995": {
            "name": "consensus_mRNA"
        },
        "SO:0000996": {
            "name": "predicted_gene"
        },
        "SO:0000997": {
            "name": "gene_fragment"
        },
        "SO:0000998": {
            "name": "recursive_splice_site",
            "def": "A recursive splice site is a splice site which subdivides a large intron. Recursive splicing is a mechanism that splices large introns by sub dividing the intron at non exonic elements and alternate exons. [http://www.genetics.org/cgi/content/full/170/2/661]"
        },
        "SO:0000999": {
            "name": "BAC_end",
            "def": "A region of sequence from the end of a BAC clone that may provide a highly specific marker. [SO:ke]"
        },
        "SO:0001000": {
            "name": "rRNA_16S",
            "def": "A large polynucleotide in Bacteria and Archaea, which functions as the small subunit of the ribosome. [SO:ke]"
        },
        "SO:0001001": {
            "name": "rRNA_23S",
            "def": "A large polynucleotide in Bacteria and Archaea, which functions as the large subunit of the ribosome. [SO:ke]"
        },
        "SO:0001002": {
            "name": "rRNA_25S",
            "def": "A large polynucleotide which functions as part of the large subunit of the ribosome in some eukaryotes. [RSC:cb]"
        },
        "SO:0001003": {
            "name": "solo_LTR",
            "def": "A recombination product between the 2 LTR of the same element. [SO:ke]"
        },
        "SO:0001004": {
            "name": "low_complexity"
        },
        "SO:0001005": {
            "name": "low_complexity_region"
        },
        "SO:0001006": {
            "name": "prophage",
            "def": "A phage genome after it has established in the host genome in a latent/immune state either as a plasmid or as an integrated \\island\\. [GOC:jl]"
        },
        "SO:0001007": {
            "name": "cryptic_prophage",
            "def": "A remnant of an integrated prophage in the host genome or an \\island\\ in the host genome that includes phage like-genes. [GOC:jl]"
        },
        "SO:0001008": {
            "name": "tetraloop",
            "def": "A base-paired stem with loop of 4 non-hydrogen bonded nucleotides. [SO:ke]"
        },
        "SO:0001009": {
            "name": "DNA_constraint_sequence",
            "def": "A double-stranded DNA used to control macromolecular structure and function. [http:/www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=search&db=pubmed&term=SILVERMAN+SK[au\\]&dispmax=50]"
        },
        "SO:0001010": {
            "name": "i_motif",
            "def": "A cytosine rich domain whereby strands associate both inter- and intramolecularly at moderately acidic pH. [PMID:9753739]"
        },
        "SO:0001011": {
            "name": "PNA_oligo",
            "def": "Peptide nucleic acid, is a chemical not known to occur naturally but is artificially synthesized and used in some biological research and medical treatments. The PNA backbone is composed of repeating N-(2-aminoethyl)-glycine units linked by peptide bonds. The purine and pyrimidine bases are linked to the backbone by methylene carbonyl bonds. [SO:ke]"
        },
        "SO:0001012": {
            "name": "DNAzyme",
            "def": "A DNA sequence with catalytic activity. [SO:cb]"
        },
        "SO:0001013": {
            "name": "MNP",
            "def": "A multiple nucleotide polymorphism with alleles of common length > 1, for example AAA/TTT. [http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?rs=rs2067431]"
        },
        "SO:0001014": {
            "name": "intron_domain"
        },
        "SO:0001015": {
            "name": "wobble_base_pair",
            "def": "A type of non-canonical base pairing, most commonly between G and U, which is important for the secondary structure of RNAs. It has similar thermodynamic stability to the Watson-Crick pairing. Wobble base pairs only have two hydrogen bonds. Other wobble base pair possibilities are I-A, I-U and I-C. [PMID:11256617]"
        },
        "SO:0001016": {
            "name": "internal_guide_sequence",
            "def": "A purine-rich sequence in the group I introns which determines the locations of the splice sites in group I intron splicing and has catalytic activity. [SO:cb]"
        },
        "SO:0001017": {
            "name": "silent_mutation",
            "def": "A sequence variant that does not affect protein function. Silent mutations may occur in genic ( CDS, UTR, intron etc) and intergenic regions. Silent mutations may have affects on processes such as splicing and regulation. [SO:ke]"
        },
        "SO:0001018": {
            "name": "epitope",
            "def": "A binding site that, in the molecule, interacts selectively and non-covalently with antibodies, B cells or T cells. [http://en.wikipedia.org/wiki/Epitope, SO:cb]"
        },
        "SO:0001019": {
            "name": "copy_number_variation",
            "def": "A variation that increases or decreases the copy number of a given region. [SO:ke]"
        },
        "SO:0001020": {
            "name": "sequence_variant_affecting_copy_number"
        },
        "SO:0001021": {
            "name": "chromosome_breakpoint"
        },
        "SO:0001022": {
            "name": "inversion_breakpoint",
            "def": "The point within a chromosome where an inversion begins or ends. [SO:cb]"
        },
        "SO:0001023": {
            "name": "allele",
            "def": "An allele is one of a set of coexisting sequence variants of a gene. [SO:immuno_workshop]"
        },
        "SO:0001024": {
            "name": "haplotype",
            "def": "A haplotype is one of a set of coexisting sequence variants of a haplotype block. [SO:immuno_workshop]"
        },
        "SO:0001025": {
            "name": "polymorphic_sequence_variant",
            "def": "A sequence variant that is segregating in one or more natural populations of a species. [SO:immuno_workshop]"
        },
        "SO:0001026": {
            "name": "genome",
            "def": "A genome is the sum of genetic material within a cell or virion. [SO:immuno_workshop]"
        },
        "SO:0001027": {
            "name": "genotype",
            "def": "A genotype is a variant genome, complete or incomplete. [SO:immuno_workshop]"
        },
        "SO:0001028": {
            "name": "diplotype",
            "def": "A diplotype is a pair of haplotypes from a given individual. It is a genotype where the phase is known. [SO:immuno_workshop]"
        },
        "SO:0001029": {
            "name": "direction_attribute"
        },
        "SO:0001030": {
            "name": "forward",
            "def": "Forward is an attribute of the feature, where the feature is in the 5' to 3' direction. [SO:ke]"
        },
        "SO:0001031": {
            "name": "reverse",
            "def": "Reverse is an attribute of the feature, where the feature is in the 3' to 5' direction. Again could be applied to primer. [SO:ke]"
        },
        "SO:0001032": {
            "name": "mitochondrial_DNA"
        },
        "SO:0001033": {
            "name": "chloroplast_DNA"
        },
        "SO:0001034": {
            "name": "miRtron",
            "def": "A de-branched intron which mimics the structure of pre-miRNA and enters the miRNA processing pathway without Drosha mediated cleavage. [PMID:17589500, SO:ma]"
        },
        "SO:0001035": {
            "name": "piRNA",
            "def": "A small non coding RNA, part of a silencing system that prevents the spreading of selfish genetic elements. [SO:ke]"
        },
        "SO:0001036": {
            "name": "arginyl_tRNA",
            "def": "A tRNA sequence that has an arginine anticodon, and a 3' arginine binding region. [SO:ke]"
        },
        "SO:0001037": {
            "name": "mobile_genetic_element",
            "def": "A nucleotide region with either intra-genome or intracellular mobility, of varying length, which often carry the information necessary for transfer and recombination with the host genome. [PMID:14681355]"
        },
        "SO:0001038": {
            "name": "extrachromosomal_mobile_genetic_element",
            "def": "An MGE that is not integrated into the host chromosome. [SO:ke]"
        },
        "SO:0001039": {
            "name": "integrated_mobile_genetic_element",
            "def": "An MGE that is integrated into the host chromosome. [SO:ke]"
        },
        "SO:0001040": {
            "name": "integrated_plasmid",
            "def": "A plasmid sequence that is integrated within the host chromosome. [SO:ke]"
        },
        "SO:0001041": {
            "name": "viral_sequence",
            "def": "The region of nucleotide sequence of a virus, a submicroscopic particle that replicates by infecting a host cell. [SO:ke]"
        },
        "SO:0001042": {
            "name": "phage_sequence",
            "def": "The nucleotide sequence of a virus that infects bacteria. [SO:ke]"
        },
        "SO:0001043": {
            "name": "attCtn_site",
            "def": "An attachment site located on a conjugative transposon and used for site-specific integration of a conjugative transposon. [Phigo:at]"
        },
        "SO:0001044": {
            "name": "nuclear_mt_pseudogene",
            "def": "A nuclear pseudogene of either coding or non-coding mitochondria derived sequence. [SO:xp]"
        },
        "SO:0001045": {
            "name": "cointegrated_plasmid",
            "def": "A MGE region consisting of two fused plasmids resulting from a replicative transposition event. [phigo:at]"
        },
        "SO:0001046": {
            "name": "IRLinv_site",
            "def": "Component of the inversion site located at the left of a region susceptible to site-specific inversion. [Phigo:at]"
        },
        "SO:0001047": {
            "name": "IRRinv_site",
            "def": "Component of the inversion site located at the right of a region susceptible to site-specific inversion. [Phigo:at]"
        },
        "SO:0001048": {
            "name": "inversion_site_part",
            "def": "A region located within an inversion site. [SO:ke]"
        },
        "SO:0001049": {
            "name": "defective_conjugative_transposon",
            "def": "An island that contains genes for integration/excision and the gene and site for the initiation of intercellular transfer by conjugation. It can be complemented for transfer by a conjugative transposon. [Phigo:ariane]"
        },
        "SO:0001050": {
            "name": "repeat_fragment",
            "def": "A portion of a repeat, interrupted by the insertion of another element. [SO:ke]"
        },
        "SO:0001051": {
            "name": "nested_region"
        },
        "SO:0001052": {
            "name": "nested_repeat"
        },
        "SO:0001053": {
            "name": "nested_transposon"
        },
        "SO:0001054": {
            "name": "transposon_fragment",
            "def": "A portion of a transposon, interrupted by the insertion of another element. [SO:ke]"
        },
        "SO:0001055": {
            "name": "transcriptional_cis_regulatory_region",
            "def": "A regulatory_region that modulates the transcription of a gene or genes. [PMID:9679020, SO:regcreative]"
        },
        "SO:0001056": {
            "name": "splicing_regulatory_region",
            "def": "A regulatory_region that modulates splicing. [SO:ke]"
        },
        "SO:0001057": {
            "name": "enhanceosome"
        },
        "SO:0001058": {
            "name": "promoter_targeting_sequence",
            "def": "A transcriptional_cis_regulatory_region that restricts the activity of a CRM to a single promoter and which functions only when both itself and an insulator are located between the CRM and the promoter. [SO:regcreative]"
        },
        "SO:0001059": {
            "name": "sequence_alteration",
            "def": "A sequence_alteration is a sequence_feature whose extent is the deviation from another sequence. [SO:ke]"
        },
        "SO:0001060": {
            "name": "sequence_variant",
            "def": "A sequence_variant is a non exact copy of a sequence_feature or genome exhibiting one or more sequence_alteration. [SO:ke]"
        },
        "SO:0001061": {
            "name": "propeptide_cleavage_site",
            "def": "The propeptide_cleavage_site is the arginine/lysine boundary on a propeptide where cleavage occurs. [EBIBS:GAR]"
        },
        "SO:0001062": {
            "name": "propeptide",
            "def": "Part of a peptide chain which is cleaved off during the formation of the mature protein. [EBIBS:GAR]"
        },
        "SO:0001063": {
            "name": "immature_peptide_region",
            "def": "An immature_peptide_region is the extent of the peptide after it has been translated and before any processing occurs. [EBIBS:GAR]"
        },
        "SO:0001064": {
            "name": "active_peptide",
            "def": "Active peptides are proteins which are biologically active, released from a precursor molecule. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001066": {
            "name": "compositionally_biased_region_of_peptide",
            "def": "Polypeptide region that is rich in a particular amino acid or homopolymeric and greater than three residues in length. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001067": {
            "name": "polypeptide_motif",
            "def": "A sequence motif is a short (up to 20 amino acids) region of biological interest. Such motifs, although they are too short to constitute functional domains, share sequence similarities and are conserved in different proteins. They display a common function (protein-binding, subcellular location etc.). [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001068": {
            "name": "polypeptide_repeat",
            "def": "A polypeptide_repeat is a single copy of an internal sequence repetition. [EBIBS:GAR]"
        },
        "SO:0001070": {
            "name": "polypeptide_structural_region",
            "def": "Region of polypeptide with a given structural property. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001071": {
            "name": "membrane_structure",
            "def": "Arrangement of the polypeptide with respect to the lipid bilayer. [EBIBS:GAR]"
        },
        "SO:0001072": {
            "name": "extramembrane_polypeptide_region",
            "def": "Polypeptide region that is localized outside of a lipid bilayer. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001073": {
            "name": "cytoplasmic_polypeptide_region",
            "def": "Polypeptide region that is localized inside the cytoplasm. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001074": {
            "name": "non_cytoplasmic_polypeptide_region",
            "def": "Polypeptide region that is localized outside of a lipid bilayer and outside of the cytoplasm. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001075": {
            "name": "intramembrane_polypeptide_region",
            "def": "Polypeptide region present in the lipid bilayer. [EBIBS:GAR]"
        },
        "SO:0001076": {
            "name": "membrane_peptide_loop",
            "def": "Polypeptide region localized within the lipid bilayer where both ends traverse the same membrane. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001077": {
            "name": "transmembrane_polypeptide_region",
            "def": "Polypeptide region traversing the lipid bilayer. [EBIBS:GAR, UniProt:curator_manual]"
        },
        "SO:0001078": {
            "name": "polypeptide_secondary_structure",
            "def": "A region of peptide with secondary structure has hydrogen bonding along the peptide chain that causes a defined conformation of the chain. [EBIBS:GAR]"
        },
        "SO:0001079": {
            "name": "polypeptide_structural_motif",
            "def": "Motif is a three-dimensional structural element within the chain, which appears also in a variety of other molecules. Unlike a domain, a motif does not need to form a stable globular unit. [EBIBS:GAR]"
        },
        "SO:0001080": {
            "name": "coiled_coil",
            "def": "A coiled coil is a structural motif in proteins, in which alpha-helices are coiled together like the strands of a rope. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001081": {
            "name": "helix_turn_helix",
            "def": "A motif comprising two helices separated by a turn. [EBIBS:GAR]"
        },
        "SO:0001082": {
            "name": "polypeptide_sequencing_information",
            "def": "Incompatibility in the sequence due to some experimental problem. [EBIBS:GAR]"
        },
        "SO:0001083": {
            "name": "non_adjacent_residues",
            "def": "Indicates that two consecutive residues in a fragment sequence are not consecutive in the full-length protein and that there are a number of unsequenced residues between them. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001084": {
            "name": "non_terminal_residue",
            "def": "The residue at an extremity of the sequence is not the terminal residue. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001085": {
            "name": "sequence_conflict",
            "def": "Different sources report differing sequences. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001086": {
            "name": "sequence_uncertainty",
            "def": "Describes the positions in a sequence where the authors are unsure about the sequence assignment. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001087": {
            "name": "cross_link",
            "def": "Posttranslationally formed amino acid bonds. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001088": {
            "name": "disulfide_bond",
            "def": "The covalent bond between sulfur atoms that binds two peptide chains or different parts of one peptide chain and is a structural determinant in many protein molecules. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001089": {
            "name": "post_translationally_modified_region",
            "def": "A region where a transformation occurs in a protein after it has been synthesized. This which may regulate, stabilize, crosslink or introduce new chemical functionalities in the protein. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001090": {
            "name": "covalent_binding_site",
            "def": "Binding involving a covalent bond. [EBIBS:GAR]"
        },
        "SO:0001091": {
            "name": "non_covalent_binding_site",
            "def": "Binding site for any chemical group (co-enzyme, prosthetic group, etc.). [EBIBS:GAR]"
        },
        "SO:0001092": {
            "name": "polypeptide_metal_contact",
            "def": "A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with metal ions. [EBIBS:GAR, SO:cb, UniProt:curation_manual]"
        },
        "SO:0001093": {
            "name": "protein_protein_contact",
            "def": "A binding site that, in the protein molecule, interacts selectively and non-covalently with polypeptide residues. [EBIBS:GAR, UniProt:Curation_manual]"
        },
        "SO:0001094": {
            "name": "polypeptide_calcium_ion_contact_site",
            "def": "A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with calcium ions. [EBIBS:GAR]"
        },
        "SO:0001095": {
            "name": "polypeptide_cobalt_ion_contact_site",
            "def": "A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with cobalt ions. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001096": {
            "name": "polypeptide_copper_ion_contact_site",
            "def": "A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with copper ions. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001097": {
            "name": "polypeptide_iron_ion_contact_site",
            "def": "A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with iron ions. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001098": {
            "name": "polypeptide_magnesium_ion_contact_site",
            "def": "A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with magnesium ions. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001099": {
            "name": "polypeptide_manganese_ion_contact_site",
            "def": "A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with manganese ions. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001100": {
            "name": "polypeptide_molybdenum_ion_contact_site",
            "def": "A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with molybdenum ions. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001101": {
            "name": "polypeptide_nickel_ion_contact_site",
            "def": "A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with nickel ions. [EBIBS:GAR]"
        },
        "SO:0001102": {
            "name": "polypeptide_tungsten_ion_contact_site",
            "def": "A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with tungsten ions. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001103": {
            "name": "polypeptide_zinc_ion_contact_site",
            "def": "A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with zinc ions. [EBIBS:GAR, SO:cb]"
        },
        "SO:0001104": {
            "name": "catalytic_residue",
            "def": "Amino acid involved in the activity of an enzyme. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001105": {
            "name": "polypeptide_ligand_contact",
            "def": "Residues which interact with a ligand. [EBIBS:GAR]"
        },
        "SO:0001106": {
            "name": "asx_motif",
            "def": "A motif of five consecutive residues and two H-bonds in which: Residue(i) is Aspartate or Asparagine (Asx), side-chain O of residue(i) is H-bonded to the main-chain NH of residue(i+2) or (i+3), main-chain CO of residue(i) is H-bonded to the main-chain NH of residue(i+3) or (i+4). [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001107": {
            "name": "beta_bulge",
            "def": "A motif of three residues within a beta-sheet in which the main chains of two consecutive residues are H-bonded to that of the third, and in which the dihedral angles are as follows: Residue(i): -140 degrees < phi(l) -20 degrees , -90 degrees < psi(l) < 40 degrees. Residue (i+1): -180 degrees < phi < -25 degrees or +120 degrees < phi < +180 degrees, +40 degrees < psi < +180 degrees or -180 degrees < psi < -120 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001108": {
            "name": "beta_bulge_loop",
            "def": "A motif of three residues within a beta-sheet consisting of two H-bonds. Beta bulge loops often occur at the loop ends of beta-hairpins. [EBIBS:GAR, Http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001109": {
            "name": "beta_bulge_loop_five",
            "def": "A motif of three residues within a beta-sheet consisting of two H-bonds in which: the main-chain NH of residue(i) is H-bonded to the main-chain CO of residue(i+4), the main-chain CO of residue i is H-bonded to the main-chain NH of residue(i+3), these loops have an RL nest at residues i+2 and i+3. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001110": {
            "name": "beta_bulge_loop_six",
            "def": "A motif of three residues within a beta-sheet consisting of two H-bonds in which: the main-chain NH of residue(i) is H-bonded to the main-chain CO of residue(i+5), the main-chain CO of residue i is H-bonded to the main-chain NH of residue(i+4), these loops have an RL nest at residues i+3 and i+4. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001111": {
            "name": "beta_strand",
            "def": "A beta strand describes a single length of polypeptide chain that forms part of a beta sheet. A single continuous stretch of amino acids adopting an extended conformation of hydrogen bonds between the N-O and the C=O of another part of the peptide. This forms a secondary protein structure in which two or more extended polypeptide regions are hydrogen-bonded to one another in a planar array. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001112": {
            "name": "antiparallel_beta_strand",
            "def": "A peptide region which hydrogen bonded to another region of peptide running in the oposite direction (one running N-terminal to C-terminal and one running C-terminal to N-terminal). Hydrogen bonding occurs between every other C=O from one strand to every other N-H on the adjacent strand. In this case, if two atoms C-alpha (i) and C-alpha (j) are adjacent in two hydrogen-bonded beta strands, then they form two mutual backbone hydrogen bonds to each other's flanking peptide groups; this is known as a close pair of hydrogen bonds. The peptide backbone dihedral angles (phi, psi) are about (-140 degrees, 135 degrees) in antiparallel sheets. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001113": {
            "name": "parallel_beta_strand",
            "def": "A peptide region which hydrogen bonded to another region of peptide running in the oposite direction (both running N-terminal to C-terminal). This orientation is slightly less stable because it introduces nonplanarity in the inter-strand hydrogen bonding pattern. Hydrogen bonding occurs between every other C=O from one strand to every other N-H on the adjacent strand. In this case, if two atoms C-alpha (i)and C-alpha (j) are adjacent in two hydrogen-bonded beta strands, then they do not hydrogen bond to each other; rather, one residue forms hydrogen bonds to the residues that flank the other (but not vice versa). For example, residue i may form hydrogen bonds to residues j - 1 and j + 1; this is known as a wide pair of hydrogen bonds. By contrast, residue j may hydrogen-bond to different residues altogether, or to none at all. The dihedral angles (phi, psi) are about (-120 degrees, 115 degrees) in parallel sheets. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001114": {
            "name": "peptide_helix",
            "def": "A helix is a secondary_structure conformation where the peptide backbone forms a coil. [EBIBS:GAR]"
        },
        "SO:0001115": {
            "name": "left_handed_peptide_helix",
            "def": "A left handed helix is a region of peptide where the coiled conformation turns in an anticlockwise, left handed screw. [EBIBS:GAR]"
        },
        "SO:0001116": {
            "name": "right_handed_peptide_helix",
            "def": "A right handed helix is a region of peptide where the coiled conformation turns in a clockwise, right handed screw. [EBIBS:GAR]"
        },
        "SO:0001117": {
            "name": "alpha_helix",
            "def": "The helix has 3.6 residues per turn which corresponds to a translation of 1.5 angstroms (= 0.15 nm) along the helical axis. Every backbone N-H group donates a hydrogen bond to the backbone C=O group of the amino acid four residues earlier. [EBIBS:GAR]"
        },
        "SO:0001118": {
            "name": "pi_helix",
            "def": "The pi helix has 4.1 residues per turn and a translation of 1.15  (=0.115 nm) along the helical axis. The N-H group of an amino acid forms a hydrogen bond with the C=O group of the amino acid five residues earlier. [EBIBS:GAR]"
        },
        "SO:0001119": {
            "name": "three_ten_helix",
            "def": "The 3-10 helix has 3 residues per turn with a translation of 2.0 angstroms (=0.2 nm) along the helical axis. The N-H group of an amino acid forms a hydrogen bond with the C=O group of the amino acid three residues earlier. [EBIBS:GAR]"
        },
        "SO:0001120": {
            "name": "polypeptide_nest_motif",
            "def": "A motif of two consecutive residues with dihedral angles. Nest should not have Proline as any residue. Nests frequently occur as parts of other motifs such as Schellman loops. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001121": {
            "name": "polypeptide_nest_left_right_motif",
            "def": "A motif of two consecutive residues with dihedral angles: Residue(i): +20 degrees < phi < +140 degrees, -40 degrees < psi < +90 degrees. Residue(i+1): -140 degrees < phi < -20 degrees, -90 degrees < psi < +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001122": {
            "name": "polypeptide_nest_right_left_motif",
            "def": "A motif of two consecutive residues with dihedral angles: Residue(i): -140 degrees < phi < -20 degrees, -90 degrees < psi < +40 degrees. Residue(i+1): +20 degrees < phi < +140 degrees, -40 degrees < psi < +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001123": {
            "name": "schellmann_loop",
            "def": "A motif of six or seven consecutive residues that contains two H-bonds. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001124": {
            "name": "schellmann_loop_seven",
            "def": "Wild type: A motif of seven consecutive residues that contains two H-bonds in which: the main-chain CO of residue(i) is H-bonded to the main-chain NH of residue(i+6), the main-chain CO of residue(i+1) is H-bonded to the main-chain NH of residue(i+5). [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001125": {
            "name": "schellmann_loop_six",
            "def": "Common Type: A motif of six consecutive residues that contains two H-bonds in which: the main-chain CO of residue(i) is H-bonded to the main-chain NH of residue(i+5) the main-chain CO of residue(i+1) is H-bonded to the main-chain NH of residue(i+4). [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001126": {
            "name": "serine_threonine_motif",
            "def": "A motif of five consecutive residues and two hydrogen bonds in which: residue(i) is Serine (S) or Threonine (T), the side-chain O of residue(i) is H-bonded to the main-chain NH of residue(i+2) or (i+3) , the main-chain CO group of residue(i) is H-bonded to the main-chain NH of residue(i+3) or (i+4). [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001127": {
            "name": "serine_threonine_staple_motif",
            "def": "A motif of four or five consecutive residues and one H-bond in which: residue(i) is Serine (S) or Threonine (T), the side-chain OH of residue(i) is H-bonded to the main-chain CO of residue(i3) or (i4), Phi angles of residues(i1), (i2) and (i3) are negative. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001128": {
            "name": "polypeptide_turn_motif",
            "def": "A reversal in the direction of the backbone of a protein that is stabilized by hydrogen bond between backbone NH and CO groups, involving no more than 4 amino acid residues. [EBIBS:GAR, uniprot:feature_type]"
        },
        "SO:0001129": {
            "name": "asx_turn_left_handed_type_one",
            "def": "Left handed type I (dihedral angles):- Residue(i): -140 degrees < chi (1) -120 degrees < -20 degrees, -90 degrees < psi +120 degrees < +40 degrees. Residue(i+1): -140 degrees < phi < -20 degrees, -90 degrees < psi < +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001130": {
            "name": "asx_turn_left_handed_type_two",
            "def": "Left handed type II (dihedral angles):- Residue(i): -140 degrees < chi (1) -120 degrees < -20 degrees, +80 degrees < psi +120 degrees < +180 degrees. Residue(i+1): +20 degrees < phi < +140 degrees, -40 degrees < psi < +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001131": {
            "name": "asx_turn_right_handed_type_two",
            "def": "Right handed type II (dihedral angles):- Residue(i): -140 degrees < chi (1) -120 degrees < -20 degrees, +80 degrees < psi +120 degrees < +180 degrees. Residue(i+1): +20 degrees < phi < +140 degrees, -40 degrees < psi < +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001132": {
            "name": "asx_turn_right_handed_type_one",
            "def": "Right handed type I (dihedral angles):- Residue(i): -140 degrees < chi (1) -120 degrees < -20 degrees, -90 degrees < psi +120 degrees < +40 degrees. Residue(i+1): -140 degrees < phi < -20 degrees, -90 degrees < psi < +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001133": {
            "name": "beta_turn",
            "def": "A motif of four consecutive residues that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth. It is characterized by the dihedral angles of the second and third residues, which are the basis for sub-categorization. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001134": {
            "name": "beta_turn_left_handed_type_one",
            "def": "Left handed type I:A motif of four consecutive residues that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth. It is characterized by the dihedral angles:- Residue(i+1): -140 degrees > phi > -20 degrees, -90 degrees > psi > +40 degrees. Residue(i+2): -140 degrees > phi > -20 degrees, -90 degrees > psi > +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001135": {
            "name": "beta_turn_left_handed_type_two",
            "def": "Left handed type II: A motif of four consecutive residues that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth. It is characterized by the dihedral angles: Residue(i+1): -140 degrees > phi > -20 degrees, +80 degrees > psi > +180 degrees. Residue(i+2): +20 degrees > phi > +140 degrees, -40 degrees > psi > +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001136": {
            "name": "beta_turn_right_handed_type_one",
            "def": "Right handed type I:A motif of four consecutive residues that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth. It is characterized by the dihedral angles: Residue(i+1): -140 degrees < phi < -20 degrees, -90 degrees < psi < +40 degrees. Residue(i+2): -140 degrees < phi < -20 degrees, -90 degrees < psi < +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001137": {
            "name": "beta_turn_right_handed_type_two",
            "def": "Right handed type II:A motif of four consecutive residues that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth. It is characterized by the dihedral angles: Residue(i+1): -140 degrees < phi < -20 degrees, +80 degrees < psi < +180 degrees. Residue(i+2): +20 degrees < phi < +140 degrees, -40 degrees < psi < +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001138": {
            "name": "gamma_turn",
            "def": "Gamma turns, defined for 3 residues i,( i+1),( i+2) if a hydrogen bond exists between residues i and i+2 and the phi and psi angles of residue i+1 fall within 40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001139": {
            "name": "gamma_turn_classic",
            "def": "Gamma turns, defined for 3 residues i, i+1, i+2 if a hydrogen bond exists between residues i and i+2 and the phi and psi angles of residue i+1 fall within 40 degrees: phi(i+1)=75.0 - psi(i+1)=-64.0. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001140": {
            "name": "gamma_turn_inverse",
            "def": "Gamma turns, defined for 3 residues i, i+1, i+2 if a hydrogen bond exists between residues i and i+2 and the phi and psi angles of residue i+1 fall within 40 degrees: phi(i+1)=-79.0 - psi(i+1)=69.0. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001141": {
            "name": "serine_threonine_turn",
            "def": "A motif of three consecutive residues and one H-bond in which: residue(i) is Serine (S) or Threonine (T), the side-chain O of residue(i) is H-bonded to the main-chain NH of residue(i+2). [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001142": {
            "name": "st_turn_left_handed_type_one",
            "def": "The peptide twists in an anticlockwise, left handed manner. The dihedral angles for this turn are: Residue(i): -140 degrees < chi(1) -120 degrees < -20 degrees, -90 degrees psi +120 degrees < +40 degrees, residue(i+1): -140 degrees < phi < -20 degrees, -90 < psi < +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001143": {
            "name": "st_turn_left_handed_type_two",
            "def": "The peptide twists in an anticlockwise, left handed manner. The dihedral angles for this turn are: Residue(i): -140 degrees < chi(1) -120 degrees < -20 degrees, +80 degrees psi +120 degrees < +180 degrees, residue(i+1): +20 degrees < phi < +140 degrees, -40 < psi < +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001144": {
            "name": "st_turn_right_handed_type_one",
            "def": "The peptide twists in an clockwise, right handed manner. The dihedral angles for this turn are: Residue(i): -140 degrees < chi(1) -120 degrees < -20 degrees, -90 degrees psi +120 degrees < +40 degrees, residue(i+1): -140 degrees < phi < -20 degrees, -90 < psi < +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001145": {
            "name": "st_turn_right_handed_type_two",
            "def": "The peptide twists in an clockwise, right handed manner. The dihedral angles for this turn are: Residue(i): -140 degrees < chi(1) -120 degrees < -20 degrees, +80 degrees psi +120 degrees < +180 degrees, residue(i+1): +20 degrees < phi < +140 degrees, -40 < psi < +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0001146": {
            "name": "polypeptide_variation_site",
            "def": "A site of sequence variation (alteration). Alternative sequence due to naturally occurring events such as polymorphisms and alternative splicing or experimental methods such as site directed mutagenesis. [EBIBS:GAR, SO:ke]"
        },
        "SO:0001147": {
            "name": "natural_variant_site",
            "def": "Describes the natural sequence variants due to polymorphisms, disease-associated mutations, RNA editing and variations between strains, isolates or cultivars. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001148": {
            "name": "mutated_variant_site",
            "def": "Site which has been experimentally altered. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001149": {
            "name": "alternate_sequence_site",
            "def": "Description of sequence variants produced by alternative splicing, alternative promoter usage, alternative initiation and ribosomal frameshifting. [EBIBS:GAR, UniProt:curation_manual]"
        },
        "SO:0001150": {
            "name": "beta_turn_type_six",
            "def": "A motif of four consecutive peptide resides of type VIa or type VIb and where the i+2 residue is cis-proline. [SO:cb]"
        },
        "SO:0001151": {
            "name": "beta_turn_type_six_a",
            "def": "A motif of four consecutive peptide residues, of which the i+2 residue is proline, and that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth and is characterized by the dihedral angles: Residue(i+1): phi ~ -60 degrees, psi ~ 120 degrees. Residue(i+2): phi ~ -90 degrees, psi ~ 0 degrees. [PMID:2371257, SO:cb]"
        },
        "SO:0001152": {
            "name": "beta_turn_type_six_a_one"
        },
        "SO:0001153": {
            "name": "beta_turn_type_six_a_two"
        },
        "SO:0001154": {
            "name": "beta_turn_type_six_b",
            "def": "A motif of four consecutive peptide residues, of which the i+2 residue is proline, and that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth and is characterized by the dihedral angles: Residue(i+1): phi ~ -120 degrees, psi ~ 120 degrees. Residue(i+2): phi ~ -60 degrees, psi ~ 0 degrees. [PMID:2371257, SO:cb]"
        },
        "SO:0001155": {
            "name": "beta_turn_type_eight",
            "def": "A motif of four consecutive peptide residues that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth and is characterized by the dihedral angles: Residue(i+1): phi ~ -60 degrees, psi ~ -30 degrees. Residue(i+2): phi ~ -120 degrees, psi ~ 120 degrees. [PMID:2371257, SO:cb]"
        },
        "SO:0001156": {
            "name": "DRE_motif",
            "def": "A sequence element characteristic of some RNA polymerase II promoters, usually located between -10 and -60 relative to the TSS. Consensus sequence is WATCGATW. [PMID:12537576]"
        },
        "SO:0001157": {
            "name": "DMv4_motif",
            "def": "A sequence element characteristic of some RNA polymerase II promoters, located immediately upstream of some TATA box elements with respect to the TSS (+1). Consensus sequence is YGGTCACACTR. Marked spatial preference within core promoter; tend to occur near the TSS, although not as tightly as INR (SO:0000014). [PMID:16827941:12537576]"
        },
        "SO:0001158": {
            "name": "E_box_motif",
            "def": "A sequence element characteristic of some RNA polymerase II promoters, usually located between -60 and +1 relative to the TSS. Consensus sequence is AWCAGCTGWT. Tends to co-occur with DMv2 (SO:0001161). Tends to not occur with DPE motif (SO:0000015). [PMID:12537576:16827941]"
        },
        "SO:0001159": {
            "name": "DMv5_motif",
            "def": "A sequence element characteristic of some RNA polymerase II promoters, usually located between -50 and -10 relative to the TSS. Consensus sequence is KTYRGTATWTTT. Tends to co-occur with DMv4 (SO:0001157) . Tends to not occur with DPE motif (SO:0000015) or MTE (SO:0001162). [PMID:12537576:16827941]"
        },
        "SO:0001160": {
            "name": "DMv3_motif",
            "def": "A sequence element characteristic of some RNA polymerase II promoters, usually located between -30 and +15 relative to the TSS. Consensus sequence is KNNCAKCNCTRNY. Tends to co-occur with DMv2 (SO:0001161). Tends to not occur with DPE motif (SO:0000015) or MTE (0001162). [PMID:12537576:16827941]"
        },
        "SO:0001161": {
            "name": "DMv2_motif",
            "def": "A sequence element characteristic of some RNA polymerase II promoters, usually located between -60 and -45 relative to the TSS. Consensus sequence is MKSYGGCARCGSYSS. Tends to co-occur with DMv3 (SO:0001160). Tends to not occur with DPE motif (SO:0000015) or MTE (SO:0001162). [PMID:12537576:16827941]"
        },
        "SO:0001162": {
            "name": "MTE",
            "def": "A sequence element characteristic of some RNA polymerase II promoters, usually located between +20 and +30 relative to the TSS. Consensus sequence is CSARCSSAACGS. Tends to co-occur with INR motif (SO:0000014). Tends to not occur with DPE motif (SO:0000015) or DMv5 (SO:0001159). [PMID:12537576:15231738, PMID:16858867]"
        },
        "SO:0001163": {
            "name": "INR1_motif",
            "def": "A promoter motif with consensus sequence TCATTCG. [PMID:16827941]"
        },
        "SO:0001164": {
            "name": "DPE1_motif",
            "def": "A promoter motif with consensus sequence CGGACGT. [PMID:16827941]"
        },
        "SO:0001165": {
            "name": "DMv1_motif",
            "def": "A promoter motif with consensus sequence CARCCCT. [PMID:16827941]"
        },
        "SO:0001166": {
            "name": "GAGA_motif",
            "def": "A non directional promoter motif with consensus sequence GAGAGCG. [PMID:16827941]"
        },
        "SO:0001167": {
            "name": "NDM2_motif",
            "def": "A non directional promoter motif with consensus CGMYGYCR. [PMID:16827941]"
        },
        "SO:0001168": {
            "name": "NDM3_motif",
            "def": "A non directional promoter motif with consensus sequence GAAAGCT. [PMID:16827941]"
        },
        "SO:0001169": {
            "name": "ds_RNA_viral_sequence",
            "def": "A ds_RNA_viral_sequence is a viral_sequence that is the sequence of a virus that exists as double stranded RNA. [SO:ke]"
        },
        "SO:0001170": {
            "name": "polinton",
            "def": "A kind of DNA transposon that populates the genomes of protists, fungi, and animals, characterized by a unique set of proteins necessary for their transposition, including a protein-primed DNA polymerase B, retroviral integrase, cysteine protease, and ATPase. Polintons are characterized by 6-bp target site duplications, terminal-inverted repeats that are several hundred nucleotides long, and 5'-AG and TC-3' termini. Polintons exist as autonomous and nonautonomous elements. [PMID:16537396]"
        },
        "SO:0001171": {
            "name": "rRNA_21S",
            "def": "A component of the large ribosomal subunit in mitochondrial rRNA. [RSC:cb]"
        },
        "SO:0001172": {
            "name": "tRNA_region",
            "def": "A region of a tRNA. [RSC:cb]"
        },
        "SO:0001173": {
            "name": "anticodon_loop",
            "def": "A sequence of seven nucleotide bases in tRNA which contains the anticodon. It has the sequence 5'-pyrimidine-purine-anticodon-modified purine-any base-3. [ISBN:0716719207]"
        },
        "SO:0001174": {
            "name": "anticodon",
            "def": "A sequence of three nucleotide bases in tRNA which recognizes a codon in mRNA. [RSC:cb]"
        },
        "SO:0001175": {
            "name": "CCA_tail",
            "def": "Base sequence at the 3' end of a tRNA. The 3'-hydroxyl group on the terminal adenosine is the attachment point for the amino acid. [ISBN:0716719207]"
        },
        "SO:0001176": {
            "name": "DHU_loop",
            "def": "Non-base-paired sequence of nucleotide bases in tRNA. It contains several dihydrouracil residues. [ISBN:071671920]"
        },
        "SO:0001177": {
            "name": "T_loop",
            "def": "Non-base-paired sequence of three nucleotide bases in tRNA. It has sequence T-Psi-C. [ISBN:0716719207]"
        },
        "SO:0001178": {
            "name": "pyrrolysine_tRNA_primary_transcript",
            "def": "A primary transcript encoding pyrrolysyl tRNA (SO:0000766). [RSC:cb]"
        },
        "SO:0001179": {
            "name": "U3_snoRNA",
            "def": "U3 snoRNA is a member of the box C/D class of small nucleolar RNAs. The U3 snoRNA secondary structure is characterised by a small 5' domain (with boxes A and A'), and a larger 3' domain (with boxes B, C, C', and D), the two domains being linked by a single-stranded hinge. Boxes B and C form the B/C motif, which appears to be exclusive to U3 snoRNAs, and boxes C' and D form the C'/D motif. The latter is functionally similar to the C/D motifs found in other snoRNAs. The 5' domain and the hinge region act as a pre-rRNA-binding domain. The 3' domain has conserved protein-binding sites. Both the box B/C and box C'/D motifs are sufficient for nuclear retention of U3 snoRNA. The box C'/D motif is also necessary for nucleolar localization, stability and hypermethylation of U3 snoRNA. Both box B/C and C'/D motifs are involved in specific protein interactions and are necessary for the rRNA processing functions of U3 snoRNA. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00012]"
        },
        "SO:0001180": {
            "name": "AU_rich_element",
            "def": "A cis-acting element found in the 3' UTR of some mRNA which is rich in AUUUA pentamers. Messenger RNAs bearing multiple AU-rich elements are often unstable. [PMID:7892223]"
        },
        "SO:0001181": {
            "name": "Bruno_response_element",
            "def": "A cis-acting element found in the 3' UTR of some mRNA which is bound by the Drosophila Bruno protein and its homologs. [PMID:10893231]"
        },
        "SO:0001182": {
            "name": "iron_responsive_element",
            "def": "A regulatory sequence found in the 5' and 3' UTRs of many mRNAs which encode iron-binding proteins. It has a hairpin structure and is recognized by trans-acting proteins known as iron-regulatory proteins. [PMID:3198610, PMID:8710843]"
        },
        "SO:0001183": {
            "name": "morpholino_backbone",
            "def": "An attribute describing a sequence composed of nucleobases bound to a morpholino backbone. A morpholino backbone consists of morpholine (CHEBI:34856) rings connected by phosphorodiamidate linkages. [RSC:cb]"
        },
        "SO:0001184": {
            "name": "PNA",
            "def": "An attribute describing a sequence composed of peptide nucleic acid (CHEBI:48021), a chemical consisting of nucleobases bound to a backbone composed of repeating N-(2-aminoethyl)-glycine units linked by peptide bonds. The purine and pyrimidine bases are linked to the backbone by methylene carbonyl bonds. [RSC:cb]"
        },
        "SO:0001185": {
            "name": "enzymatic",
            "def": "An attribute describing the sequence of a transcript that has catalytic activity with or without an associated ribonucleoprotein. [RSC:cb]"
        },
        "SO:0001186": {
            "name": "ribozymic",
            "def": "An attribute describing the sequence of a transcript that has catalytic activity even without an associated ribonucleoprotein. [RSC:cb]"
        },
        "SO:0001187": {
            "name": "pseudouridylation_guide_snoRNA",
            "def": "A snoRNA that specifies the site of pseudouridylation in an RNA molecule by base pairing with a short sequence around the target residue. [GOC:mah, PMID:12457565]"
        },
        "SO:0001188": {
            "name": "LNA",
            "def": "An attribute describing a sequence consisting of nucleobases attached to a repeating unit made of 'locked' deoxyribose rings connected to a phosphate backbone. The deoxyribose unit's conformation is 'locked' by a 2'-C,4'-C-oxymethylene link. [CHEBI:48010]"
        },
        "SO:0001189": {
            "name": "LNA_oligo",
            "def": "An oligo composed of LNA residues. [RSC:cb]"
        },
        "SO:0001190": {
            "name": "TNA",
            "def": "An attribute describing a sequence consisting of nucleobases attached to a repeating unit made of threose rings connected to a phosphate backbone. [CHEBI:48019]"
        },
        "SO:0001191": {
            "name": "TNA_oligo",
            "def": "An oligo composed of TNA residues. [RSC:cb]"
        },
        "SO:0001192": {
            "name": "GNA",
            "def": "An attribute describing a sequence consisting of nucleobases attached to a repeating unit made of an acyclic three-carbon propylene glycol connected to a phosphate backbone. It has two enantiomeric forms, (R)-GNA and (S)-GNA. [CHEBI:48015]"
        },
        "SO:0001193": {
            "name": "GNA_oligo",
            "def": "An oligo composed of GNA residues. [RSC:cb]"
        },
        "SO:0001194": {
            "name": "R_GNA",
            "def": "An attribute describing a GNA sequence in the (R)-GNA enantiomer. [CHEBI:48016]"
        },
        "SO:0001195": {
            "name": "R_GNA_oligo",
            "def": "An oligo composed of (R)-GNA residues. [RSC:cb]"
        },
        "SO:0001196": {
            "name": "S_GNA",
            "def": "An attribute describing a GNA sequence in the (S)-GNA enantiomer. [CHEBI:48017]"
        },
        "SO:0001197": {
            "name": "S_GNA_oligo",
            "def": "An oligo composed of (S)-GNA residues. [RSC:cb]"
        },
        "SO:0001198": {
            "name": "ds_DNA_viral_sequence",
            "def": "A ds_DNA_viral_sequence is a viral_sequence that is the sequence of a virus that exists as double stranded DNA. [SO:ke]"
        },
        "SO:0001199": {
            "name": "ss_RNA_viral_sequence",
            "def": "A ss_RNA_viral_sequence is a viral_sequence that is the sequence of a virus that exists as single stranded RNA. [SO:ke]"
        },
        "SO:0001200": {
            "name": "negative_sense_ssRNA_viral_sequence",
            "def": "A negative_sense_RNA_viral_sequence is a ss_RNA_viral_sequence that is the sequence of a single stranded RNA virus that is complementary to mRNA and must be converted to positive sense RNA by RNA polymerase before translation. [SO:ke]"
        },
        "SO:0001201": {
            "name": "positive_sense_ssRNA_viral_sequence",
            "def": "A positive_sense_RNA_viral_sequence is a ss_RNA_viral_sequence that is the sequence of a single stranded RNA virus that can be immediately translated by the host. [SO:ke]"
        },
        "SO:0001202": {
            "name": "ambisense_ssRNA_viral_sequence",
            "def": "A ambisense_RNA_virus is a ss_RNA_viral_sequence that is the sequence of a single stranded RNA virus with both messenger and anti messenger polarity. [SO:ke]"
        },
        "SO:0001203": {
            "name": "RNA_polymerase_promoter",
            "def": "A region (DNA) to which RNA polymerase binds, to begin transcription. [xenbase:jb]"
        },
        "SO:0001204": {
            "name": "Phage_RNA_Polymerase_Promoter",
            "def": "A region (DNA) to which Bacteriophage RNA polymerase binds, to begin transcription. [xenbase:jb]"
        },
        "SO:0001205": {
            "name": "SP6_RNA_Polymerase_Promoter",
            "def": "A region (DNA) to which the SP6 RNA polymerase binds, to begin transcription. [xenbase:jb]"
        },
        "SO:0001206": {
            "name": "T3_RNA_Polymerase_Promoter",
            "def": "A DNA sequence to which the T3 RNA polymerase binds, to begin transcription. [xenbase:jb]"
        },
        "SO:0001207": {
            "name": "T7_RNA_Polymerase_Promoter",
            "def": "A region (DNA) to which the T7 RNA polymerase binds, to begin transcription. [xenbase:jb]"
        },
        "SO:0001208": {
            "name": "five_prime_EST",
            "def": "An EST read from the 5' end of a transcript that usually codes for a protein. These regions tend to be conserved across species and do not change much within a gene family. [http://www.ncbi.nlm.nih.gov/About/primer/est.html]"
        },
        "SO:0001209": {
            "name": "three_prime_EST",
            "def": "An EST read from the 3' end of a transcript. They are more likely to fall within non-coding, or untranslated regions(UTRs). [http://www.ncbi.nlm.nih.gov/About/primer/est.html]"
        },
        "SO:0001210": {
            "name": "translational_frameshift",
            "def": "The region of mRNA (not divisible by 3 bases) that is skipped during the process of translational frameshifting (GO:0006452), causing the reading frame to be different. [SO:ke]"
        },
        "SO:0001211": {
            "name": "plus_1_translational_frameshift",
            "def": "The region of mRNA 1 base long that is skipped during the process of translational frameshifting (GO:0006452), causing the reading frame to be different. [SO:ke]"
        },
        "SO:0001212": {
            "name": "plus_2_translational_frameshift",
            "def": "The region of mRNA 2 bases long that is skipped during the process of translational frameshifting (GO:0006452), causing the reading frame to be different. [SO:ke]"
        },
        "SO:0001213": {
            "name": "group_III_intron",
            "def": "Group III introns are introns found in the mRNA of the plastids of euglenoid protists. They are spliced by a two step transesterification with bulged adenosine as initiating nucleophile. [PMID:11377794]"
        },
        "SO:0001214": {
            "name": "noncoding_region_of_exon",
            "def": "The maximal intersection of exon and UTR. [SO:ke]"
        },
        "SO:0001215": {
            "name": "coding_region_of_exon",
            "def": "The region of an exon that encodes for protein sequence. [SO:ke]"
        },
        "SO:0001216": {
            "name": "endonuclease_spliced_intron",
            "def": "An intron that spliced via endonucleolytic cleavage and ligation rather than transesterification. [SO:ke]"
        },
        "SO:0001217": {
            "name": "protein_coding_gene"
        },
        "SO:0001218": {
            "name": "transgenic_insertion",
            "def": "An insertion that derives from another organism, via the use of recombinant DNA technology. [SO:bm]"
        },
        "SO:0001219": {
            "name": "retrogene"
        },
        "SO:0001220": {
            "name": "silenced_by_RNA_interference",
            "def": "An attribute describing an epigenetic process where a gene is inactivated by RNA interference. [RSC:cb]"
        },
        "SO:0001221": {
            "name": "silenced_by_histone_modification",
            "def": "An attribute describing an epigenetic process where a gene is inactivated by histone modification. [RSC:cb]"
        },
        "SO:0001222": {
            "name": "silenced_by_histone_methylation",
            "def": "An attribute describing an epigenetic process where a gene is inactivated by histone methylation. [RSC:cb]"
        },
        "SO:0001223": {
            "name": "silenced_by_histone_deacetylation",
            "def": "An attribute describing an epigenetic process where a gene is inactivated by histone deacetylation. [RSC:cb]"
        },
        "SO:0001224": {
            "name": "gene_silenced_by_RNA_interference",
            "def": "A gene that is silenced by RNA interference. [SO:xp]"
        },
        "SO:0001225": {
            "name": "gene_silenced_by_histone_modification",
            "def": "A gene that is silenced by histone modification. [SO:xp]"
        },
        "SO:0001226": {
            "name": "gene_silenced_by_histone_methylation",
            "def": "A gene that is silenced by histone methylation. [SO:xp]"
        },
        "SO:0001227": {
            "name": "gene_silenced_by_histone_deacetylation",
            "def": "A gene that is silenced by histone deacetylation. [SO:xp]"
        },
        "SO:0001228": {
            "name": "dihydrouridine",
            "def": "A modified RNA base in which the 5,6-dihydrouracil is bound to the ribose ring. [RSC:cb]"
        },
        "SO:0001229": {
            "name": "pseudouridine",
            "def": "A modified RNA base in which the 5- position of the uracil is bound to the ribose ring instead of the 4- position. [RSC:cb]"
        },
        "SO:0001230": {
            "name": "inosine",
            "def": "A modified RNA base in which hypoxanthine is bound to the ribose ring. [http://library.med.utah.edu/RNAmods/, RSC:cb]"
        },
        "SO:0001231": {
            "name": "seven_methylguanine",
            "def": "A modified RNA base in which guanine is methylated at the 7- position. [RSC:cb]"
        },
        "SO:0001232": {
            "name": "ribothymidine",
            "def": "A modified RNA base in which thymine is bound to the ribose ring. [RSC:cb]"
        },
        "SO:0001233": {
            "name": "methylinosine",
            "def": "A modified RNA base in which methylhypoxanthine is bound to the ribose ring. [RSC:cb]"
        },
        "SO:0001234": {
            "name": "mobile",
            "def": "An attribute describing a feature that has either intra-genome or intracellular mobility. [RSC:cb]"
        },
        "SO:0001235": {
            "name": "replicon",
            "def": "A region containing at least one unique origin of replication and a unique termination site. [ISBN:0716719207]"
        },
        "SO:0001236": {
            "name": "base",
            "def": "A base is a sequence feature that corresponds to a single unit of a nucleotide polymer. [SO:ke]"
        },
        "SO:0001237": {
            "name": "amino_acid",
            "def": "A sequence feature that corresponds to a single amino acid residue in a polypeptide. [RSC:cb]"
        },
        "SO:0001238": {
            "name": "major_TSS"
        },
        "SO:0001239": {
            "name": "minor_TSS"
        },
        "SO:0001240": {
            "name": "TSS_region",
            "def": "The region of a gene from the 5' most TSS to the 3' TSS. [BBOP:nw]"
        },
        "SO:0001241": {
            "name": "encodes_alternate_transcription_start_sites"
        },
        "SO:0001243": {
            "name": "miRNA_primary_transcript_region",
            "def": "A part of an miRNA primary_transcript. [SO:ke]"
        },
        "SO:0001244": {
            "name": "pre_miRNA",
            "def": "The 60-70 nucleotide region remain after Drosha processing of the primary transcript, that folds back upon itself to form a hairpin structure. [SO:ke]"
        },
        "SO:0001245": {
            "name": "miRNA_stem",
            "def": "The stem of the hairpin loop formed by folding of the pre-miRNA. [SO:ke]"
        },
        "SO:0001246": {
            "name": "miRNA_loop",
            "def": "The loop of the hairpin loop formed by folding of the pre-miRNA. [SO:ke]"
        },
        "SO:0001247": {
            "name": "synthetic_oligo",
            "def": "An oligo composed of synthetic nucleotides. [SO:ke]"
        },
        "SO:0001248": {
            "name": "assembly",
            "def": "A region of the genome of known length that is composed by ordering and aligning two or more different regions. [SO:ke]"
        },
        "SO:0001249": {
            "name": "fragment_assembly",
            "def": "A fragment assembly is a genome assembly that orders overlapping fragments of the genome based on landmark sequences. The base pair distance between the landmarks is known allowing additivity of lengths. [SO:ke]"
        },
        "SO:0001250": {
            "name": "fingerprint_map",
            "def": "A fingerprint_map is a physical map composed of restriction fragments. [SO:ke]"
        },
        "SO:0001251": {
            "name": "STS_map",
            "def": "An STS map is a physical map organized by the unique STS landmarks. [SO:ke]"
        },
        "SO:0001252": {
            "name": "RH_map",
            "def": "A radiation hybrid map is a physical map. [SO:ke]"
        },
        "SO:0001253": {
            "name": "sonicate_fragment",
            "def": "A DNA fragment generated by sonication. Sonication is a technique used to sheer DNA into smaller fragments. [SO:ke]"
        },
        "SO:0001254": {
            "name": "polyploid",
            "def": "A kind of chromosome variation where the chromosome complement is an exact multiple of the haploid number and is greater than the diploid number. [SO:ke]"
        },
        "SO:0001255": {
            "name": "autopolyploid",
            "def": "A polyploid where the multiple chromosome set was derived from the same organism. [SO:ke]"
        },
        "SO:0001256": {
            "name": "allopolyploid",
            "def": "A polyploid where the multiple chromosome set was derived from a different organism. [SO:ke]"
        },
        "SO:0001257": {
            "name": "homing_endonuclease_binding_site",
            "def": "The binding site (recognition site) of a homing endonuclease. The binding site is typically large. [SO:ke]"
        },
        "SO:0001258": {
            "name": "octamer_motif",
            "def": "A sequence element characteristic of some RNA polymerase II promoters with sequence ATTGCAT that binds Pou-domain transcription factors. [GOC:dh, PMID:3095662]"
        },
        "SO:0001259": {
            "name": "apicoplast_chromosome",
            "def": "A chromosome originating in an apicoplast. [SO:xp]"
        },
        "SO:0001260": {
            "name": "sequence_collection",
            "def": "A collection of discontinuous sequences. [SO:ke]"
        },
        "SO:0001261": {
            "name": "overlapping_feature_set",
            "def": "A continuous region of sequence composed of the overlapping of multiple sequence_features, which ultimately provides evidence for another sequence_feature. [SO:ke]"
        },
        "SO:0001262": {
            "name": "overlapping_EST_set",
            "def": "A continous experimental result region extending the length of multiple overlapping EST's. [SO:ke]"
        },
        "SO:0001263": {
            "name": "ncRNA_gene"
        },
        "SO:0001264": {
            "name": "gRNA_gene"
        },
        "SO:0001265": {
            "name": "miRNA_gene"
        },
        "SO:0001266": {
            "name": "scRNA_gene"
        },
        "SO:0001267": {
            "name": "snoRNA_gene"
        },
        "SO:0001268": {
            "name": "snRNA_gene"
        },
        "SO:0001269": {
            "name": "SRP_RNA_gene"
        },
        "SO:0001271": {
            "name": "tmRNA_gene"
        },
        "SO:0001272": {
            "name": "tRNA_gene"
        },
        "SO:0001273": {
            "name": "modified_adenosine",
            "def": "A modified adenine is an adenine base feature that has been altered. [SO:ke]"
        },
        "SO:0001274": {
            "name": "modified_inosine",
            "def": "A modified inosine is an inosine base feature that has been altered. [SO:ke]"
        },
        "SO:0001275": {
            "name": "modified_cytidine",
            "def": "A modified cytidine is a cytidine base feature which has been altered. [SO:ke]"
        },
        "SO:0001276": {
            "name": "modified_guanosine"
        },
        "SO:0001277": {
            "name": "modified_uridine"
        },
        "SO:0001278": {
            "name": "one_methylinosine",
            "def": "1-methylinosine is a modified inosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001279": {
            "name": "one_two_prime_O_dimethylinosine",
            "def": "1,2'-O-dimethylinosine is a modified inosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001280": {
            "name": "two_prime_O_methylinosine",
            "def": "2'-O-methylinosine is a modified inosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001281": {
            "name": "three_methylcytidine",
            "def": "3-methylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001282": {
            "name": "five_methylcytidine",
            "def": "5-methylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001283": {
            "name": "two_prime_O_methylcytidine",
            "def": "2'-O-methylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001284": {
            "name": "two_thiocytidine",
            "def": "2-thiocytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001285": {
            "name": "N4_acetylcytidine",
            "def": "N4-acetylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001286": {
            "name": "five_formylcytidine",
            "def": "5-formylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001287": {
            "name": "five_two_prime_O_dimethylcytidine",
            "def": "5,2'-O-dimethylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001288": {
            "name": "N4_acetyl_2_prime_O_methylcytidine",
            "def": "N4-acetyl-2'-O-methylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001289": {
            "name": "lysidine",
            "def": "Lysidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001290": {
            "name": "N4_methylcytidine",
            "def": "N4-methylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001291": {
            "name": "N4_2_prime_O_dimethylcytidine",
            "def": "N4,2'-O-dimethylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001292": {
            "name": "five_hydroxymethylcytidine",
            "def": "5-hydroxymethylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001293": {
            "name": "five_formyl_two_prime_O_methylcytidine",
            "def": "5-formyl-2'-O-methylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001294": {
            "name": "N4_N4_2_prime_O_trimethylcytidine",
            "def": "N4_N4_2_prime_O_trimethylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001295": {
            "name": "one_methyladenosine",
            "def": "1_methyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001296": {
            "name": "two_methyladenosine",
            "def": "2_methyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001297": {
            "name": "N6_methyladenosine",
            "def": "N6_methyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001298": {
            "name": "two_prime_O_methyladenosine",
            "def": "2prime_O_methyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001299": {
            "name": "two_methylthio_N6_methyladenosine",
            "def": "2_methylthio_N6_methyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001300": {
            "name": "N6_isopentenyladenosine",
            "def": "N6_isopentenyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001301": {
            "name": "two_methylthio_N6_isopentenyladenosine",
            "def": "2_methylthio_N6_isopentenyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001302": {
            "name": "N6_cis_hydroxyisopentenyl_adenosine",
            "def": "N6_cis_hydroxyisopentenyl_adenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001303": {
            "name": "two_methylthio_N6_cis_hydroxyisopentenyl_adenosine",
            "def": "2_methylthio_N6_cis_hydroxyisopentenyl_adenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001304": {
            "name": "N6_glycinylcarbamoyladenosine",
            "def": "N6_glycinylcarbamoyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001305": {
            "name": "N6_threonylcarbamoyladenosine",
            "def": "N6_threonylcarbamoyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001306": {
            "name": "two_methylthio_N6_threonyl_carbamoyladenosine",
            "def": "2_methylthio_N6_threonyl_carbamoyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001307": {
            "name": "N6_methyl_N6_threonylcarbamoyladenosine",
            "def": "N6_methyl_N6_threonylcarbamoyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001308": {
            "name": "N6_hydroxynorvalylcarbamoyladenosine",
            "def": "N6_hydroxynorvalylcarbamoyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001309": {
            "name": "two_methylthio_N6_hydroxynorvalyl_carbamoyladenosine",
            "def": "2_methylthio_N6_hydroxynorvalyl_carbamoyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001310": {
            "name": "two_prime_O_ribosyladenosine_phosphate",
            "def": "2prime_O_ribosyladenosine_phosphate is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001311": {
            "name": "N6_N6_dimethyladenosine",
            "def": "N6_N6_dimethyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001312": {
            "name": "N6_2_prime_O_dimethyladenosine",
            "def": "N6_2prime_O_dimethyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001313": {
            "name": "N6_N6_2_prime_O_trimethyladenosine",
            "def": "N6_N6_2prime_O_trimethyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001314": {
            "name": "one_two_prime_O_dimethyladenosine",
            "def": "1,2'-O-dimethyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001315": {
            "name": "N6_acetyladenosine",
            "def": "N6_acetyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001316": {
            "name": "seven_deazaguanosine",
            "def": "7-deazaguanosine is a modified guanosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001317": {
            "name": "queuosine",
            "def": "Queuosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001318": {
            "name": "epoxyqueuosine",
            "def": "Epoxyqueuosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001319": {
            "name": "galactosyl_queuosine",
            "def": "Galactosyl_queuosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001320": {
            "name": "mannosyl_queuosine",
            "def": "Mannosyl_queuosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001321": {
            "name": "seven_cyano_seven_deazaguanosine",
            "def": "7_cyano_7_deazaguanosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001322": {
            "name": "seven_aminomethyl_seven_deazaguanosine",
            "def": "7_aminomethyl_7_deazaguanosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001323": {
            "name": "archaeosine",
            "def": "Archaeosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001324": {
            "name": "one_methylguanosine",
            "def": "1_methylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001325": {
            "name": "N2_methylguanosine",
            "def": "N2_methylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001326": {
            "name": "seven_methylguanosine",
            "def": "7_methylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001327": {
            "name": "two_prime_O_methylguanosine",
            "def": "2prime_O_methylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001328": {
            "name": "N2_N2_dimethylguanosine",
            "def": "N2_N2_dimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001329": {
            "name": "N2_2_prime_O_dimethylguanosine",
            "def": "N2_2prime_O_dimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001330": {
            "name": "N2_N2_2_prime_O_trimethylguanosine",
            "def": "N2_N2_2prime_O_trimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001331": {
            "name": "two_prime_O_ribosylguanosine_phosphate",
            "def": "2prime_O_ribosylguanosine_phosphate is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001332": {
            "name": "wybutosine",
            "def": "Wybutosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001333": {
            "name": "peroxywybutosine",
            "def": "Peroxywybutosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001334": {
            "name": "hydroxywybutosine",
            "def": "Hydroxywybutosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001335": {
            "name": "undermodified_hydroxywybutosine",
            "def": "Undermodified_hydroxywybutosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001336": {
            "name": "wyosine",
            "def": "Wyosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001337": {
            "name": "methylwyosine",
            "def": "Methylwyosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001338": {
            "name": "N2_7_dimethylguanosine",
            "def": "N2_7_dimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001339": {
            "name": "N2_N2_7_trimethylguanosine",
            "def": "N2_N2_7_trimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001340": {
            "name": "one_two_prime_O_dimethylguanosine",
            "def": "1_2prime_O_dimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001341": {
            "name": "four_demethylwyosine",
            "def": "4_demethylwyosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001342": {
            "name": "isowyosine",
            "def": "Isowyosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001343": {
            "name": "N2_7_2prirme_O_trimethylguanosine",
            "def": "N2_7_2prirme_O_trimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001344": {
            "name": "five_methyluridine",
            "def": "5_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001345": {
            "name": "two_prime_O_methyluridine",
            "def": "2prime_O_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001346": {
            "name": "five_two_prime_O_dimethyluridine",
            "def": "5_2_prime_O_dimethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001347": {
            "name": "one_methylpseudouridine",
            "def": "1_methylpseudouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001348": {
            "name": "two_prime_O_methylpseudouridine",
            "def": "2prime_O_methylpseudouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001349": {
            "name": "two_thiouridine",
            "def": "2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001350": {
            "name": "four_thiouridine",
            "def": "4_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001351": {
            "name": "five_methyl_2_thiouridine",
            "def": "5_methyl_2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001352": {
            "name": "two_thio_two_prime_O_methyluridine",
            "def": "2_thio_2prime_O_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001353": {
            "name": "three_three_amino_three_carboxypropyl_uridine",
            "def": "3_3_amino_3_carboxypropyl_uridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001354": {
            "name": "five_hydroxyuridine",
            "def": "5_hydroxyuridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001355": {
            "name": "five_methoxyuridine",
            "def": "5_methoxyuridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001356": {
            "name": "uridine_five_oxyacetic_acid",
            "def": "Uridine_5_oxyacetic_acid is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001357": {
            "name": "uridine_five_oxyacetic_acid_methyl_ester",
            "def": "Uridine_5_oxyacetic_acid_methyl_ester is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001358": {
            "name": "five_carboxyhydroxymethyl_uridine",
            "def": "5_carboxyhydroxymethyl_uridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001359": {
            "name": "five_carboxyhydroxymethyl_uridine_methyl_ester",
            "def": "5_carboxyhydroxymethyl_uridine_methyl_ester is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001360": {
            "name": "five_methoxycarbonylmethyluridine",
            "def": "Five_methoxycarbonylmethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001361": {
            "name": "five_methoxycarbonylmethyl_two_prime_O_methyluridine",
            "def": "Five_methoxycarbonylmethyl_2_prime_O_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001362": {
            "name": "five_methoxycarbonylmethyl_two_thiouridine",
            "def": "5_methoxycarbonylmethyl_2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001363": {
            "name": "five_aminomethyl_two_thiouridine",
            "def": "5_aminomethyl_2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001364": {
            "name": "five_methylaminomethyluridine",
            "def": "5_methylaminomethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001365": {
            "name": "five_methylaminomethyl_two_thiouridine",
            "def": "5_methylaminomethyl_2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001366": {
            "name": "five_methylaminomethyl_two_selenouridine",
            "def": "5_methylaminomethyl_2_selenouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001367": {
            "name": "five_carbamoylmethyluridine",
            "def": "5_carbamoylmethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001368": {
            "name": "five_carbamoylmethyl_two_prime_O_methyluridine",
            "def": "5_carbamoylmethyl_2_prime_O_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001369": {
            "name": "five_carboxymethylaminomethyluridine",
            "def": "5_carboxymethylaminomethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001370": {
            "name": "five_carboxymethylaminomethyl_two_prime_O_methyluridine",
            "def": "5_carboxymethylaminomethyl_2_prime_O_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001371": {
            "name": "five_carboxymethylaminomethyl_two_thiouridine",
            "def": "5_carboxymethylaminomethyl_2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001372": {
            "name": "three_methyluridine",
            "def": "3_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001373": {
            "name": "one_methyl_three_three_amino_three_carboxypropyl_pseudouridine",
            "def": "1_methyl_3_3_amino_3_carboxypropyl_pseudouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001374": {
            "name": "five_carboxymethyluridine",
            "def": "5_carboxymethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001375": {
            "name": "three_two_prime_O_dimethyluridine",
            "def": "3_2prime_O_dimethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001376": {
            "name": "five_methyldihydrouridine",
            "def": "5_methyldihydrouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001377": {
            "name": "three_methylpseudouridine",
            "def": "3_methylpseudouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001378": {
            "name": "five_taurinomethyluridine",
            "def": "5_taurinomethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001379": {
            "name": "five_taurinomethyl_two_thiouridine",
            "def": "5_taurinomethyl_2_thiouridineis a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001380": {
            "name": "five_isopentenylaminomethyl_uridine",
            "def": "5_isopentenylaminomethyl_uridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001381": {
            "name": "five_isopentenylaminomethyl_two_thiouridine",
            "def": "5_isopentenylaminomethyl_2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001382": {
            "name": "five_isopentenylaminomethyl_two_prime_O_methyluridine",
            "def": "5_isopentenylaminomethyl_2prime_O_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]"
        },
        "SO:0001383": {
            "name": "histone_binding_site",
            "def": "A binding site that, in the nucleotide molecule, interacts selectively and non-covalently with polypeptide residues of a histone. [SO:ke]"
        },
        "SO:0001384": {
            "name": "CDS_fragment"
        },
        "SO:0001385": {
            "name": "modified_amino_acid_feature",
            "def": "A post translationally modified amino acid feature. [SO:ke]"
        },
        "SO:0001386": {
            "name": "modified_glycine",
            "def": "A post translationally modified glycine amino acid feature. [SO:ke]"
        },
        "SO:0001387": {
            "name": "modified_L_alanine",
            "def": "A post translationally modified alanine amino acid feature. [SO:ke]"
        },
        "SO:0001388": {
            "name": "modified_L_asparagine",
            "def": "A post translationally modified asparagine amino acid feature. [SO:ke]"
        },
        "SO:0001389": {
            "name": "modified_L_aspartic_acid",
            "def": "A post translationally modified aspartic acid amino acid feature. [SO:ke]"
        },
        "SO:0001390": {
            "name": "modified_L_cysteine",
            "def": "A post translationally modified cysteine amino acid feature. [SO:ke]"
        },
        "SO:0001391": {
            "name": "modified_L_glutamic_acid"
        },
        "SO:0001392": {
            "name": "modified_L_threonine",
            "def": "A post translationally modified threonine amino acid feature. [SO:ke]"
        },
        "SO:0001393": {
            "name": "modified_L_tryptophan",
            "def": "A post translationally modified tryptophan amino acid feature. [SO:ke]"
        },
        "SO:0001394": {
            "name": "modified_L_glutamine",
            "def": "A post translationally modified glutamine amino acid feature. [SO:ke]"
        },
        "SO:0001395": {
            "name": "modified_L_methionine",
            "def": "A post translationally modified methionine amino acid feature. [SO:ke]"
        },
        "SO:0001396": {
            "name": "modified_L_isoleucine",
            "def": "A post translationally modified isoleucine amino acid feature. [SO:ke]"
        },
        "SO:0001397": {
            "name": "modified_L_phenylalanine",
            "def": "A post translationally modified phenylalanine amino acid feature. [SO:ke]"
        },
        "SO:0001398": {
            "name": "modified_L_histidine",
            "def": "A post translationally modified histidine amino acid feature. [SO:ke]"
        },
        "SO:0001399": {
            "name": "modified_L_serine",
            "def": "A post translationally modified serine amino acid feature. [SO:ke]"
        },
        "SO:0001400": {
            "name": "modified_L_lysine",
            "def": "A post translationally modified lysine amino acid feature. [SO:ke]"
        },
        "SO:0001401": {
            "name": "modified_L_leucine",
            "def": "A post translationally modified leucine amino acid feature. [SO:ke]"
        },
        "SO:0001402": {
            "name": "modified_L_selenocysteine",
            "def": "A post translationally modified selenocysteine amino acid feature. [SO:ke]"
        },
        "SO:0001403": {
            "name": "modified_L_valine",
            "def": "A post translationally modified valine amino acid feature. [SO:ke]"
        },
        "SO:0001404": {
            "name": "modified_L_proline",
            "def": "A post translationally modified proline amino acid feature. [SO:ke]"
        },
        "SO:0001405": {
            "name": "modified_L_tyrosine",
            "def": "A post translationally modified tyrosine amino acid feature. [SO:ke]"
        },
        "SO:0001406": {
            "name": "modified_L_arginine",
            "def": "A post translationally modified arginine amino acid feature. [SO:ke]"
        },
        "SO:0001407": {
            "name": "peptidyl",
            "def": "An attribute describing the nature of a proteinaceous polymer, where by the amino acid units are joined by peptide bonds. [SO:ke]"
        },
        "SO:0001408": {
            "name": "cleaved_for_gpi_anchor_region",
            "def": "The C-terminal residues of a polypeptide which are exchanged for a GPI-anchor. [EBI:rh]"
        },
        "SO:0001409": {
            "name": "biomaterial_region",
            "def": "A region which is intended for use in an experiment. [SO:cb]"
        },
        "SO:0001410": {
            "name": "experimental_feature",
            "def": "A region which is the result of some arbitrary experimental procedure. The procedure may be carried out with biological material or inside a computer. [SO:cb]"
        },
        "SO:0001411": {
            "name": "biological_region",
            "def": "A region defined by its disposition to be involved in a biological process. [SO:cb]"
        },
        "SO:0001412": {
            "name": "topologically_defined_region",
            "def": "A region that is defined according to its relations with other regions within the same sequence. [SO:cb]"
        },
        "SO:0001413": {
            "name": "translocation_breakpoint",
            "def": "The point within a chromosome where a translocation begins or ends. [SO:cb]"
        },
        "SO:0001414": {
            "name": "insertion_breakpoint",
            "def": "The point within a chromosome where a insertion begins or ends. [SO:cb]"
        },
        "SO:0001415": {
            "name": "deletion_breakpoint",
            "def": "The point within a chromosome where a deletion begins or ends. [SO:cb]"
        },
        "SO:0001416": {
            "name": "five_prime_flanking_region",
            "def": "A flanking region located five prime of a specific region. [SO:chado]"
        },
        "SO:0001417": {
            "name": "three_prime_flanking_region",
            "def": "A flanking region located three prime of a specific region. [SO:chado]"
        },
        "SO:0001418": {
            "name": "transcribed_fragment",
            "def": "An experimental region, defined by a tiling array experiment to be transcribed at some level. [SO:ke]"
        },
        "SO:0001419": {
            "name": "cis_splice_site",
            "def": "Intronic 2 bp region bordering exon. A splice_site that adjacent_to exon and overlaps intron. [SO:cjm, SO:ke]"
        },
        "SO:0001420": {
            "name": "trans_splice_site",
            "def": "Primary transcript region bordering trans-splice junction. [SO:ke]"
        },
        "SO:0001421": {
            "name": "splice_junction",
            "def": "The boundary between an intron and an exon. [SO:ke]"
        },
        "SO:0001422": {
            "name": "conformational_switch",
            "def": "A region of a polypeptide, involved in the transition from one conformational state to another. [SO:ke]"
        },
        "SO:0001423": {
            "name": "dye_terminator_read",
            "def": "A read produced by the dye terminator method of sequencing. [SO:ke]"
        },
        "SO:0001424": {
            "name": "pyrosequenced_read",
            "def": "A read produced by pyrosequencing technology. [SO:ke]"
        },
        "SO:0001425": {
            "name": "ligation_based_read",
            "def": "A read produced by ligation based sequencing technologies. [SO:ke]"
        },
        "SO:0001426": {
            "name": "polymerase_synthesis_read",
            "def": "A read produced by the polymerase based sequence by synthesis method. [SO:ke]"
        },
        "SO:0001427": {
            "name": "cis_regulatory_frameshift_element",
            "def": "A structural region in an RNA molecule which promotes ribosomal frameshifting of cis coding sequence. [RFAM:jd]"
        },
        "SO:0001428": {
            "name": "expressed_sequence_assembly",
            "def": "A sequence assembly derived from expressed sequences. [SO:ke]"
        },
        "SO:0001429": {
            "name": "DNA_binding_site",
            "def": "A binding site that, in the molecule, interacts selectively and non-covalently with DNA. [SO:ke]"
        },
        "SO:0001431": {
            "name": "cryptic_gene",
            "def": "A gene that is not transcribed under normal conditions and is not critical to normal cellular functioning. [SO:ke]"
        },
        "SO:0001432": {
            "name": "sequence_variant_affecting_polyadenylation"
        },
        "SO:0001433": {
            "name": "three_prime_RACE_clone",
            "def": "A three prime RACE (Rapid Amplification of cDNA Ends) clone is a cDNA clone copied from the 3' end of an mRNA (using a poly-dT primer to capture the polyA tail and a gene-specific or randomly primed 5' primer), and spliced into a vector for propagation in a suitable host. [modENCODE:nlw]"
        },
        "SO:0001434": {
            "name": "cassette_pseudogene",
            "def": "A cassette pseudogene is a kind of gene in an inactive form which may recombine at a telomeric locus to form a functional copy. [SO:ke]"
        },
        "SO:0001435": {
            "name": "alanine"
        },
        "SO:0001436": {
            "name": "valine"
        },
        "SO:0001437": {
            "name": "leucine"
        },
        "SO:0001438": {
            "name": "isoleucine"
        },
        "SO:0001439": {
            "name": "proline"
        },
        "SO:0001440": {
            "name": "tryptophan"
        },
        "SO:0001441": {
            "name": "phenylalanine"
        },
        "SO:0001442": {
            "name": "methionine"
        },
        "SO:0001443": {
            "name": "glycine"
        },
        "SO:0001444": {
            "name": "serine"
        },
        "SO:0001445": {
            "name": "threonine"
        },
        "SO:0001446": {
            "name": "tyrosine"
        },
        "SO:0001447": {
            "name": "cysteine"
        },
        "SO:0001448": {
            "name": "glutamine"
        },
        "SO:0001449": {
            "name": "asparagine"
        },
        "SO:0001450": {
            "name": "lysine"
        },
        "SO:0001451": {
            "name": "arginine"
        },
        "SO:0001452": {
            "name": "histidine"
        },
        "SO:0001453": {
            "name": "aspartic_acid"
        },
        "SO:0001454": {
            "name": "glutamic_acid"
        },
        "SO:0001455": {
            "name": "selenocysteine"
        },
        "SO:0001456": {
            "name": "pyrrolysine"
        },
        "SO:0001457": {
            "name": "transcribed_cluster",
            "def": "A region defined by a set of transcribed sequences from the same gene or expressed pseudogene. [SO:ke]"
        },
        "SO:0001458": {
            "name": "unigene_cluster",
            "def": "A kind of transcribed_cluster defined by a set of transcribed sequences from the a unique gene. [SO:ke]"
        },
        "SO:0001459": {
            "name": "CRISPR",
            "def": "Clustered Palindromic Repeats interspersed with bacteriophage derived spacer sequences. [RFAM:jd]"
        },
        "SO:0001460": {
            "name": "insulator_binding_site",
            "def": "A binding site that, in an insulator region of a nucleotide molecule, interacts selectively and non-covalently with polypeptide residues. [SO:ke]"
        },
        "SO:0001461": {
            "name": "enhancer_binding_site",
            "def": "A binding site that, in the enhancer region of a nucleotide molecule, interacts selectively and non-covalently with polypeptide residues. [SO:ke]"
        },
        "SO:0001462": {
            "name": "contig_collection",
            "def": "A collection of contigs. [SO:ke]"
        },
        "SO:0001463": {
            "name": "lincRNA",
            "def": "A multiexonic non-coding RNA transcribed by RNA polymerase II. [PMID:19182780, SO:ke]"
        },
        "SO:0001464": {
            "name": "UST",
            "def": "An EST spanning part or all of the untranslated regions of a protein-coding transcript. [SO:nlw]"
        },
        "SO:0001465": {
            "name": "three_prime_UST",
            "def": "A UST located in the 3'UTR of a protein-coding transcript. [SO:nlw]"
        },
        "SO:0001466": {
            "name": "five_prime_UST",
            "def": "An UST located in the 5'UTR of a protein-coding transcript. [SO:nlw]"
        },
        "SO:0001467": {
            "name": "RST",
            "def": "A tag produced from a single sequencing read from a RACE product; typically a few hundred base pairs long. [SO:nlw]"
        },
        "SO:0001468": {
            "name": "three_prime_RST",
            "def": "A tag produced from a single sequencing read from a 3'-RACE product; typically a few hundred base pairs long. [SO:nlw]"
        },
        "SO:0001469": {
            "name": "five_prime_RST",
            "def": "A tag produced from a single sequencing read from a 5'-RACE product; typically a few hundred base pairs long. [SO:nlw]"
        },
        "SO:0001470": {
            "name": "UST_match",
            "def": "A match against an UST sequence. [SO:nlw]"
        },
        "SO:0001471": {
            "name": "RST_match",
            "def": "A match against an RST sequence. [SO:nlw]"
        },
        "SO:0001472": {
            "name": "primer_match",
            "def": "A nucleotide match to a primer sequence. [SO:nlw]"
        },
        "SO:0001473": {
            "name": "miRNA_antiguide",
            "def": "A region of the pri miRNA that base pairs with the guide to form the hairpin. [SO:ke]"
        },
        "SO:0001474": {
            "name": "trans_splice_junction",
            "def": "The boundary between the spliced leader and the first exon of the mRNA. [SO:ke]"
        },
        "SO:0001475": {
            "name": "outron",
            "def": "A region of a primary transcript, that is removed via trans splicing. [PMID:16401417, SO:ke]"
        },
        "SO:0001476": {
            "name": "natural_plasmid",
            "def": "A plasmid that occurs naturally. [SO:xp]"
        },
        "SO:0001477": {
            "name": "gene_trap_construct",
            "def": "A gene trap construct is a type of engineered plasmid which is designed to integrate into a genome and produce a fusion transcript between exons of the gene into which it inserts and a reporter element in the construct. Gene traps contain a splice acceptor, do not contain promoter elements for the reporter, and are mutagenic. Gene traps may be bicistronic with the second cassette containing a promoter driving an a selectable marker. [ZFIN:dh]"
        },
        "SO:0001478": {
            "name": "promoter_trap_construct",
            "def": "A promoter trap construct is a type of engineered plasmid which is designed to integrate into a genome and express a reporter when inserted in close proximity to a promoter element. Promoter traps typically do not contain promoter elements and are mutagenic. [ZFIN:dh]"
        },
        "SO:0001479": {
            "name": "enhancer_trap_construct",
            "def": "An enhancer trap construct is a type of engineered plasmid which is designed to integrate into a genome and express a reporter when the expression from a basic minimal promoter is enhanced by genomic enhancer elements. Enhancer traps contain promoter elements and are not usually mutagenic. [ZFIN:dh]"
        },
        "SO:0001480": {
            "name": "PAC_end",
            "def": "A region of sequence from the end of a PAC clone that may provide a highly specific marker. [ZFIN:mh]"
        },
        "SO:0001481": {
            "name": "RAPD",
            "def": "RAPD is a 'PCR product' where a sequence variant is identified through the use of PCR with random primers. [ZFIN:mh]"
        },
        "SO:0001482": {
            "name": "shadow_enhancer"
        },
        "SO:0001483": {
            "name": "SNV",
            "def": "SNVs are single nucleotide positions in genomic DNA at which different sequence alternatives exist. [SO:bm]"
        },
        "SO:0001484": {
            "name": "X_element_combinatorial_repeat",
            "def": "An X element combinatorial repeat is a repeat region located between the X element and the telomere or adjacent Y' element. [http://www.yeastgenome.org/help/glossary.html]"
        },
        "SO:0001485": {
            "name": "Y_prime_element",
            "def": "A Y' element is a repeat region (SO:0000657) located adjacent to telomeric repeats or X element combinatorial repeats, either as a single copy or tandem repeat of two to four copies. [http:http://www.yeastgenome.org/help/glossary.html]"
        },
        "SO:0001486": {
            "name": "standard_draft",
            "def": "The status of a whole genome sequence, where the data is minimally filtered or un-filtered, from any number of sequencing platforms, and is assembled into contigs. Genome sequence of this quality may harbour regions of poor quality and can be relatively incomplete. [DOI:10.1126]"
        },
        "SO:0001487": {
            "name": "high_quality_draft",
            "def": "The status of a whole genome sequence, where overall coverage represents at least 90 percent of the genome. [DOI:10.1126]"
        },
        "SO:0001488": {
            "name": "improved_high_quality_draft",
            "def": "The status of a whole genome sequence, where additional work has been performed, using either manual or automated methods, such as gap resolution. [DOI:10.1126]"
        },
        "SO:0001489": {
            "name": "annotation_directed_improved_draft",
            "def": "The status of a whole genome sequence,where annotation, and verification of coding regions has occurred. [DOI:10.1126]"
        },
        "SO:0001490": {
            "name": "noncontiguous_finished",
            "def": "The status of a whole genome sequence, where the assembly is high quality, closure approaches have been successful for most gaps, misassemblies and low quality regions. [DOI:10.1126]"
        },
        "SO:0001491": {
            "name": "finished_genome",
            "def": "The status of a whole genome sequence, with less than 1 error per 100,000 base pairs. [DOI:10.1126]"
        },
        "SO:0001492": {
            "name": "intronic_regulatory_region",
            "def": "A regulatory region that is part of an intron. [SO:ke]"
        },
        "SO:0001493": {
            "name": "centromere_DNA_Element_I",
            "def": "A centromere DNA Element I (CDEI) is a conserved region, part of the centromere, consisting of a consensus region composed of 8-11bp which enables binding by the centromere binding factor 1(Cbf1p). [PMID:11222754]"
        },
        "SO:0001494": {
            "name": "centromere_DNA_Element_II",
            "def": "A centromere DNA Element II (CDEII) is part a conserved region of the centromere, consisting of a consensus region that is AT-rich and ~ 75-100 bp in length. [PMID:11222754]"
        },
        "SO:0001495": {
            "name": "centromere_DNA_Element_III",
            "def": "A centromere DNA Element I (CDEI) is a conserved region, part of the centromere, consisting of a consensus region that consists of a 25-bp which enables binding by the centromere DNA binding factor 3 (CBF3) complex. [PMID:11222754]"
        },
        "SO:0001496": {
            "name": "telomeric_repeat",
            "def": "The telomeric repeat is a repeat region, part of the chromosome, which in yeast, is a G-rich terminal sequence of the form (TG(1-3))n or more precisely ((TG)(1-6)TG(2-3))n. [PMID:8720065]"
        },
        "SO:0001497": {
            "name": "X_element",
            "def": "The X element is a conserved region, of the telomere, of ~475 bp that contains an ARS sequence and in most cases an Abf1p binding site. [http://www.yeastgenome.org/help/glossary.html#xelemcoresequence, PMID:7785338, PMID:8005434]"
        },
        "SO:0001498": {
            "name": "YAC_end",
            "def": "A region of sequence from the end of a YAC clone that may provide a highly specific marker. [SO:ke]"
        },
        "SO:0001499": {
            "name": "whole_genome_sequence_status",
            "def": "The status of whole genome sequence. [DOI:10.1126]"
        },
        "SO:0001500": {
            "name": "heritable_phenotypic_marker",
            "def": "A biological_region characterized as a single heritable trait in a phenotype screen. The heritable phenotype may be mapped to a chromosome but generally has not been characterized to a specific gene locus. [JAX:hdene]"
        },
        "SO:0001501": {
            "name": "peptide_collection",
            "def": "A collection of peptide sequences. [BBOP:nlw]"
        },
        "SO:0001502": {
            "name": "high_identity_region",
            "def": "An experimental feature with high sequence identity to another sequence. [SO:ke]"
        },
        "SO:0001503": {
            "name": "processed_transcript",
            "def": "A transcript for which no open reading frame has been identified and for which no other function has been determined. [MGI:hdeen]"
        },
        "SO:0001504": {
            "name": "assortment_derived_variation",
            "def": "A chromosome variation derived from an event during meiosis. [SO:ke]"
        },
        "SO:0001505": {
            "name": "reference_genome",
            "def": "A collection of sequences (often chromosomes) taken as the standard for a given organism and genome assembly. [SO:ke]"
        },
        "SO:0001506": {
            "name": "variant_genome",
            "def": "A collection of sequences (often chromosomes) of an individual. [SO:ke]"
        },
        "SO:0001507": {
            "name": "variant_collection",
            "def": "A collection of one or more sequences of an individual. [SO:ke]"
        },
        "SO:0001508": {
            "name": "alteration_attribute"
        },
        "SO:0001509": {
            "name": "chromosomal_variation_attribute"
        },
        "SO:0001510": {
            "name": "intrachromosomal"
        },
        "SO:0001511": {
            "name": "interchromosomal"
        },
        "SO:0001512": {
            "name": "insertion_attribute",
            "def": "A quality of a chromosomal insertion,. [SO:ke]"
        },
        "SO:0001513": {
            "name": "tandem"
        },
        "SO:0001514": {
            "name": "direct",
            "def": "A quality of an insertion where the insert is not in a cytologically inverted orientation. [SO:ke]"
        },
        "SO:0001515": {
            "name": "inverted",
            "def": "A quality of an insertion where the insert is in a cytologically inverted orientation. [SO:ke]"
        },
        "SO:0001516": {
            "name": "free",
            "def": "The quality of a duplication where the new region exists independently of the original. [SO:ke]"
        },
        "SO:0001517": {
            "name": "inversion_attribute"
        },
        "SO:0001518": {
            "name": "pericentric"
        },
        "SO:0001519": {
            "name": "paracentric"
        },
        "SO:0001520": {
            "name": "translocaton_attribute"
        },
        "SO:0001521": {
            "name": "reciprocal"
        },
        "SO:0001522": {
            "name": "insertional"
        },
        "SO:0001523": {
            "name": "duplication_attribute"
        },
        "SO:0001524": {
            "name": "chromosomally_aberrant_genome"
        },
        "SO:0001525": {
            "name": "assembly_error_correction",
            "def": "A region of sequence where the final nucleotide assignment differs from the original assembly due to an improvement that replaces a mistake. [SO:ke]"
        },
        "SO:0001526": {
            "name": "base_call_error_correction",
            "def": "A region of sequence where the final nucleotide assignment is different from that given by the base caller due to an improvement that replaces a mistake. [SO:ke]"
        },
        "SO:0001527": {
            "name": "peptide_localization_signal",
            "def": "A region of peptide sequence used to target the polypeptide molecule to a specific organelle. [SO:ke]"
        },
        "SO:0001528": {
            "name": "nuclear_localization_signal",
            "def": "A polypeptide region that targets a polypeptide to the nucleus. [SO:ke]"
        },
        "SO:0001529": {
            "name": "endosomal_localization_signal",
            "def": "A polypeptide region that targets a polypeptide to the endosome. [SO:ke]"
        },
        "SO:0001530": {
            "name": "lysosomal_localization_signal",
            "def": "A polypeptide region that targets a polypeptide to the lysosome. [SO:ke]"
        },
        "SO:0001531": {
            "name": "nuclear_export_signal",
            "def": "A polypeptide region that targets a polypeptide to he cytoplasm. [SO:ke]"
        },
        "SO:0001532": {
            "name": "recombination_signal_sequence",
            "def": "A region recognized by a recombinase. [SO:ke]"
        },
        "SO:0001533": {
            "name": "cryptic_splice_site",
            "def": "A splice site that is in part of the transcript not normally spliced. They occur via mutation or transcriptional error. [SO:ke]"
        },
        "SO:0001534": {
            "name": "nuclear_rim_localization_signal",
            "def": "A polypeptide region that targets a polypeptide to the nuclear rim. [SO:ke]"
        },
        "SO:0001535": {
            "name": "p_element",
            "def": "A P_element is a DNA transposon responsible for hybrid dysgenesis. [SO:ke]"
        },
        "SO:0001536": {
            "name": "functional_variant",
            "def": "A sequence variant in which the function of a gene product is altered with respect to a reference. [SO:ke]"
        },
        "SO:0001537": {
            "name": "structural_variant",
            "def": "A sequence variant that changes one or more sequence features. [SO:ke]"
        },
        "SO:0001538": {
            "name": "transcript_function_variant",
            "def": "A sequence variant which alters the functioning of a transcript with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001539": {
            "name": "translational_product_function_variant",
            "def": "A sequence variant that affects the functioning of a translational product with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001540": {
            "name": "level_of_transcript_variant",
            "def": "A sequence variant which alters the level of a transcript. [SO:ke]"
        },
        "SO:0001541": {
            "name": "decreased_transcript_level_variant",
            "def": "A sequence variant that increases the level of mature, spliced and processed RNA with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001542": {
            "name": "increased_transcript_level_variant",
            "def": "A sequence variant that increases the level of mature, spliced and processed RNA with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001543": {
            "name": "transcript_processing_variant",
            "def": "A sequence variant that affects the post transcriptional processing of a transcript with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001544": {
            "name": "editing_variant",
            "def": "A transcript processing variant whereby the process of editing is disrupted with respect to the reference. [SO:ke]"
        },
        "SO:0001545": {
            "name": "polyadenylation_variant",
            "def": "A sequence variant that changes polyadenylation with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001546": {
            "name": "transcript_stability_variant",
            "def": "A variant that changes the stability of a transcript with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001547": {
            "name": "decreased_transcript_stability_variant",
            "def": "A sequence variant that decreases transcript stability with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001548": {
            "name": "increased_transcript_stability_variant",
            "def": "A sequence variant that increases transcript stability with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001549": {
            "name": "transcription_variant",
            "def": "A variant that changes alters the transcription of a transcript with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001550": {
            "name": "rate_of_transcription_variant",
            "def": "A sequence variant that changes the rate of transcription with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001551": {
            "name": "increased_transcription_rate_variant",
            "def": "A sequence variant that increases the rate of transcription with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001552": {
            "name": "decreased_transcription_rate_variant",
            "def": "A sequence variant that decreases the rate of transcription with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001553": {
            "name": "translational_product_level_variant",
            "def": "A functional variant that changes the translational product level with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001554": {
            "name": "polypeptide_function_variant",
            "def": "A sequence variant which changes polypeptide functioning with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001555": {
            "name": "decreased_translational_product_level",
            "def": "A sequence variant which decreases the translational product level with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001556": {
            "name": "increased_translational_product_level",
            "def": "A sequence variant which increases the translational product level with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001557": {
            "name": "polypeptide_gain_of_function_variant",
            "def": "A sequence variant which causes gain of polypeptide function with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001558": {
            "name": "polypeptide_localization_variant",
            "def": "A sequence variant which changes the localization of a polypeptide with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001559": {
            "name": "polypeptide_loss_of_function_variant",
            "def": "A sequence variant that causes the loss of a polypeptide function with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001560": {
            "name": "inactive_ligand_binding_site",
            "def": "A sequence variant that causes the inactivation of a ligand binding site with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001561": {
            "name": "polypeptide_partial_loss_of_function",
            "def": "A sequence variant that causes some but not all loss of polypeptide function with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001562": {
            "name": "polypeptide_post_translational_processing_variant",
            "def": "A sequence variant that causes a change in post translational processing of the peptide with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001563": {
            "name": "copy_number_change",
            "def": "A sequence variant where copies of a feature (CNV) are either increased or decreased. [SO:ke]"
        },
        "SO:0001564": {
            "name": "gene_variant",
            "def": "A sequence variant where the structure of the gene is changed. [SO:ke]"
        },
        "SO:0001565": {
            "name": "gene_fusion",
            "def": "A sequence variant whereby a two genes have become joined. [SO:ke]"
        },
        "SO:0001566": {
            "name": "regulatory_region_variant",
            "def": "A sequence variant located within a regulatory region. [SO:ke]"
        },
        "SO:0001567": {
            "name": "stop_retained_variant",
            "def": "A sequence variant where at least one base in the terminator codon is changed, but the terminator remains. [SO:ke]"
        },
        "SO:0001568": {
            "name": "splicing_variant",
            "def": "A sequence variant that changes the process of splicing. [SO:ke]"
        },
        "SO:0001569": {
            "name": "cryptic_splice_site_variant",
            "def": "A sequence variant causing a new (functional) splice site. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:0001570": {
            "name": "cryptic_splice_acceptor",
            "def": "A sequence variant whereby a new splice site is created due to the activation of a new acceptor. [SO:ke]"
        },
        "SO:0001571": {
            "name": "cryptic_splice_donor",
            "def": "A sequence variant whereby a new splice site is created due to the activation of a new donor. [SO:ke]"
        },
        "SO:0001572": {
            "name": "exon_loss_variant",
            "def": "A sequence variant whereby an exon is lost from the transcript. [SO:ke]"
        },
        "SO:0001573": {
            "name": "intron_gain_variant",
            "def": "A sequence variant whereby an intron is gained by the processed transcript; usually a result of an alteration of the donor or acceptor. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:0001574": {
            "name": "splice_acceptor_variant",
            "def": "A splice variant that changes the 2 base region at the 3' end of an intron. [SO:ke]"
        },
        "SO:0001575": {
            "name": "splice_donor_variant",
            "def": "A splice variant that changes the 2 base pair region at the 5' end of an intron. [SO:ke]"
        },
        "SO:0001576": {
            "name": "transcript_variant",
            "def": "A sequence variant that changes the structure of the transcript. [SO:ke]"
        },
        "SO:0001577": {
            "name": "complex_transcript_variant",
            "def": "A transcript variant with a complex INDEL- Insertion or deletion that spans an exon/intron border or a coding sequence/UTR border. [http://ensembl.org/info/docs/variation/index.html]"
        },
        "SO:0001578": {
            "name": "stop_lost",
            "def": "A sequence variant where at least one base of the terminator codon (stop) is changed, resulting in an elongated transcript. [SO:ke]"
        },
        "SO:0001579": {
            "name": "transcript_sequence_variant"
        },
        "SO:0001580": {
            "name": "coding_sequence_variant",
            "def": "A sequence variant that changes the coding sequence. [SO:ke]"
        },
        "SO:0001582": {
            "name": "initiator_codon_variant",
            "def": "A codon variant that changes at least one base of the first codon of a transcript. [SO:ke]"
        },
        "SO:0001583": {
            "name": "missense_variant",
            "def": "A sequence variant, that changes one or more bases, resulting in a different amino acid sequence but where the length is preserved. [EBI:fc, EBI:gr, SO:ke]"
        },
        "SO:0001585": {
            "name": "conservative_missense_variant",
            "def": "A sequence variant whereby at least one base of a codon is changed resulting in a codon that encodes for a different but similar amino acid. These variants may or may not be deleterious. [SO:ke]"
        },
        "SO:0001586": {
            "name": "non_conservative_missense_variant",
            "def": "A sequence variant whereby at least one base of a codon is changed resulting in a codon that encodes for an amino acid with different biochemical properties. [SO:ke]"
        },
        "SO:0001587": {
            "name": "stop_gained",
            "def": "A sequence variant whereby at least one base of a codon is changed, resulting in a premature stop codon, leading to a shortened transcript. [SO:ke]"
        },
        "SO:0001589": {
            "name": "frameshift_variant",
            "def": "A sequence variant which causes a disruption of the translational reading frame, because the number of nucleotides inserted or deleted is not a multiple of three. [SO:ke]"
        },
        "SO:0001590": {
            "name": "terminator_codon_variant",
            "def": "A sequence variant whereby at least one of the bases in the terminator codon is changed. [SO:ke]"
        },
        "SO:0001591": {
            "name": "frame_restoring_variant",
            "def": "A sequence variant that reverts the sequence of a previous frameshift mutation back to the initial frame. [SO:ke]"
        },
        "SO:0001592": {
            "name": "minus_1_frameshift_variant",
            "def": "A sequence variant which causes a disruption of the translational reading frame, by shifting one base ahead. [http://arjournals.annualreviews.org/doi/pdf/10.1146/annurev.ge.08.120174.001535]"
        },
        "SO:0001593": {
            "name": "minus_2_frameshift_variant"
        },
        "SO:0001594": {
            "name": "plus_1_frameshift_variant",
            "def": "A sequence variant which causes a disruption of the translational reading frame, by shifting one base backward. [http://arjournals.annualreviews.org/doi/pdf/10.1146/annurev.ge.08.120174.001535]"
        },
        "SO:0001595": {
            "name": "plus_2_frameshift_variant"
        },
        "SO:0001596": {
            "name": "transcript_secondary_structure_variant",
            "def": "A sequence variant within a transcript that changes the secondary structure of the RNA product. [SO:ke]"
        },
        "SO:0001597": {
            "name": "compensatory_transcript_secondary_structure_variant",
            "def": "A secondary structure variant that compensate for the change made by a previous variant. [SO:ke]"
        },
        "SO:0001598": {
            "name": "translational_product_structure_variant",
            "def": "A sequence variant within the transcript that changes the structure of the translational product. [SO:ke]"
        },
        "SO:0001599": {
            "name": "3D_polypeptide_structure_variant",
            "def": "A sequence variant that changes the resulting polypeptide structure. [SO:ke]"
        },
        "SO:0001600": {
            "name": "complex_3D_structural_variant",
            "def": "A sequence variant that changes the resulting polypeptide structure. [SO:ke]"
        },
        "SO:0001601": {
            "name": "conformational_change_variant",
            "def": "A sequence variant in the CDS region that causes a conformational change in the resulting polypeptide sequence. [SO:ke]"
        },
        "SO:0001602": {
            "name": "complex_change_of_translational_product_variant"
        },
        "SO:0001603": {
            "name": "polypeptide_sequence_variant",
            "def": "A sequence variant with in the CDS that causes a change in the resulting polypeptide sequence. [SO:ke]"
        },
        "SO:0001604": {
            "name": "amino_acid_deletion",
            "def": "A sequence variant within a CDS resulting in the loss of an amino acid from the resulting polypeptide. [SO:ke]"
        },
        "SO:0001605": {
            "name": "amino_acid_insertion",
            "def": "A sequence variant within a CDS resulting in the gain of an amino acid to the resulting polypeptide. [SO:ke]"
        },
        "SO:0001606": {
            "name": "amino_acid_substitution",
            "def": "A sequence variant of a codon resulting in the substitution of one amino acid for another in the resulting polypeptide. [SO:ke]"
        },
        "SO:0001607": {
            "name": "conservative_amino_acid_substitution",
            "def": "A sequence variant of a codon causing the substitution of a similar amino acid for another in the resulting polypeptide. [SO:ke]"
        },
        "SO:0001608": {
            "name": "non_conservative_amino_acid_substitution",
            "def": "A sequence variant of a codon causing the substitution of a non conservative amino acid for another in the resulting polypeptide. [SO:ke]"
        },
        "SO:0001609": {
            "name": "elongated_polypeptide",
            "def": "A sequence variant with in the CDS that causes elongation of the resulting polypeptide sequence. [SO:ke]"
        },
        "SO:0001610": {
            "name": "elongated_polypeptide_C_terminal",
            "def": "A sequence variant with in the CDS that causes elongation of the resulting polypeptide sequence at the C terminus. [SO:ke]"
        },
        "SO:0001611": {
            "name": "elongated_polypeptide_N_terminal",
            "def": "A sequence variant with in the CDS that causes elongation of the resulting polypeptide sequence at the N terminus. [SO:ke]"
        },
        "SO:0001612": {
            "name": "elongated_in_frame_polypeptide_C_terminal",
            "def": "A sequence variant with in the CDS that causes in frame elongation of the resulting polypeptide sequence at the C terminus. [SO:ke]"
        },
        "SO:0001613": {
            "name": "elongated_out_of_frame_polypeptide_C_terminal",
            "def": "A sequence variant with in the CDS that causes out of frame elongation of the resulting polypeptide sequence at the C terminus. [SO:ke]"
        },
        "SO:0001614": {
            "name": "elongated_in_frame_polypeptide_N_terminal_elongation",
            "def": "A sequence variant with in the CDS that causes in frame elongation of the resulting polypeptide sequence at the N terminus. [SO:ke]"
        },
        "SO:0001615": {
            "name": "elongated_out_of_frame_polypeptide_N_terminal",
            "def": "A sequence variant with in the CDS that causes out of frame elongation of the resulting polypeptide sequence at the N terminus. [SO:ke]"
        },
        "SO:0001616": {
            "name": "polypeptide_fusion",
            "def": "A sequence variant that causes a fusion of two polypeptide sequences. [SO:ke]"
        },
        "SO:0001617": {
            "name": "polypeptide_truncation",
            "def": "A sequence variant of the CD that causes a truncation of the resulting polypeptide. [SO:ke]"
        },
        "SO:0001618": {
            "name": "inactive_catalytic_site",
            "def": "A sequence variant that causes the inactivation of a catalytic site with respect to a reference sequence. [SO:ke]"
        },
        "SO:0001619": {
            "name": "non_coding_transcript_variant",
            "def": "A transcript variant of a non coding RNA gene. [SO:ke]"
        },
        "SO:0001620": {
            "name": "mature_miRNA_variant",
            "def": "A transcript variant located with the sequence of the mature miRNA. [SO:ke]"
        },
        "SO:0001621": {
            "name": "NMD_transcript_variant",
            "def": "A variant in a transcript that is the target of NMD. [SO:ke]"
        },
        "SO:0001622": {
            "name": "UTR_variant",
            "def": "A transcript variant that is located within the UTR. [SO:ke]"
        },
        "SO:0001623": {
            "name": "5_prime_UTR_variant",
            "def": "A UTR variant of the 5' UTR. [SO:ke]"
        },
        "SO:0001624": {
            "name": "3_prime_UTR_variant",
            "def": "A UTR variant of the 3' UTR. [SO:ke]"
        },
        "SO:0001626": {
            "name": "incomplete_terminal_codon_variant",
            "def": "A sequence variant where at least one base of the final codon of an incompletely annotated transcript is changed. [SO:ke]"
        },
        "SO:0001627": {
            "name": "intron_variant",
            "def": "A transcript variant occurring within an intron. [SO:ke]"
        },
        "SO:0001628": {
            "name": "intergenic_variant",
            "def": "A sequence variant located in the intergenic region, between genes. [SO:ke]"
        },
        "SO:0001629": {
            "name": "splice_site_variant",
            "def": "A sequence variant that changes the first two or last two bases of an intron, or the 5th base from the start of the intron in the orientation of the transcript. [http://ensembl.org/info/docs/variation/index.html]"
        },
        "SO:0001630": {
            "name": "splice_region_variant",
            "def": "A sequence variant in which a change has occurred within the region of the splice site, either within 1-3 bases of the exon or 3-8 bases of the intron. [http://ensembl.org/info/docs/variation/index.html]"
        },
        "SO:0001631": {
            "name": "upstream_gene_variant",
            "def": "A sequence variant located 5' of a gene. [SO:ke]"
        },
        "SO:0001632": {
            "name": "downstream_gene_variant",
            "def": "A sequence variant located 3' of a gene. [SO:ke]"
        },
        "SO:0001633": {
            "name": "5KB_downstream_variant",
            "def": "A sequence variant located within 5 KB of the end of a gene. [SO:ke]"
        },
        "SO:0001634": {
            "name": "500B_downstream_variant",
            "def": "A sequence variant located within a half KB of the end of a gene. [SO:ke]"
        },
        "SO:0001635": {
            "name": "5KB_upstream_variant",
            "def": "A sequence variant located within 5KB 5' of a gene. [SO:ke]"
        },
        "SO:0001636": {
            "name": "2KB_upstream_variant",
            "def": "A sequence variant located within 2KB 5' of a gene. [SO:ke]"
        },
        "SO:0001637": {
            "name": "rRNA_gene",
            "def": "A gene that encodes for ribosomal RNA. [SO:ke]"
        },
        "SO:0001638": {
            "name": "piRNA_gene",
            "def": "A gene that encodes for an piwi associated RNA. [SO:ke]"
        },
        "SO:0001639": {
            "name": "RNase_P_RNA_gene",
            "def": "A gene that encodes an RNase P RNA. [SO:ke]"
        },
        "SO:0001640": {
            "name": "RNase_MRP_RNA_gene",
            "def": "A gene that encodes a RNase_MRP_RNA. [SO:ke]"
        },
        "SO:0001641": {
            "name": "lincRNA_gene",
            "def": "A gene that encodes large intervening non-coding RNA. [SO:ke]"
        },
        "SO:0001642": {
            "name": "mathematically_defined_repeat",
            "def": "A mathematically defined repeat (MDR) is a experimental feature that is determined by querying overlapping oligomers of length k against a database of shotgun sequence data and identifying regions in the query sequence that exceed a statistically determined threshold of repetitiveness. [SO:jestill]"
        },
        "SO:0001643": {
            "name": "telomerase_RNA_gene",
            "def": "A telomerase RNA gene is a non coding RNA gene the RNA product of which is a component of telomerase. [SO:ke]"
        },
        "SO:0001644": {
            "name": "targeting_vector",
            "def": "An engineered vector that is able to take part in homologous recombination in a host with the intent of introducing site specific genomic modifications. [MGD:tm, PMID:10354467]"
        },
        "SO:0001645": {
            "name": "genetic_marker",
            "def": "A measurable sequence feature that varies within a population. [SO:db]"
        },
        "SO:0001646": {
            "name": "DArT_marker",
            "def": "A genetic marker, discovered using Diversity Arrays Technology (DArT) technology. [SO:ke]"
        },
        "SO:0001647": {
            "name": "kozak_sequence",
            "def": "A kind of ribosome entry site, specific to Eukaryotic organisms that overlaps part of both 5' UTR and CDS sequence. [SO:ke]"
        },
        "SO:0001648": {
            "name": "nested_transposon",
            "def": "A transposon that is disrupted by the insertion of another element. [SO:ke]"
        },
        "SO:0001649": {
            "name": "nested_repeat",
            "def": "A repeat that is disrupted by the insertion of another element. [SO:ke]"
        },
        "SO:0001650": {
            "name": "inframe_variant",
            "def": "A sequence variant which does not cause a disruption of the translational reading frame. [SO:ke]"
        },
        "SO:0001653": {
            "name": "retinoic_acid_responsive_element",
            "def": "A transcription factor binding site of variable direct repeats of the sequence PuGGTCA spaced by five nucleotides (DR5) found in the promoters of retinoic acid-responsive genes, to which retinoic acid receptors bind. [PMID:11327309, PMID:19917671]"
        },
        "SO:0001654": {
            "name": "nucleotide_to_protein_binding_site",
            "def": "A binding site that, in the nucleotide molecule, interacts selectively and non-covalently with polypeptide residues. [SO:ke]"
        },
        "SO:0001655": {
            "name": "nucleotide_binding_site",
            "def": "A binding site that, in the molecule, interacts selectively and non-covalently with nucleotide residues. [SO:cb]"
        },
        "SO:0001656": {
            "name": "metal_binding_site",
            "def": "A binding site that, in the molecule, interacts selectively and non-covalently with metal ions. [SO:cb]"
        },
        "SO:0001657": {
            "name": "ligand_binding_site",
            "def": "A binding site that, in the molecule, interacts selectively and non-covalently with a small molecule such as a drug, or hormone. [SO:ke]"
        },
        "SO:0001658": {
            "name": "nested_tandem_repeat",
            "def": "An NTR is a nested repeat of two distinct tandem motifs interspersed with each other. [SO:AF]"
        },
        "SO:0001659": {
            "name": "promoter_element"
        },
        "SO:0001660": {
            "name": "core_promoter_element"
        },
        "SO:0001661": {
            "name": "RNA_polymerase_II_TATA_box",
            "def": "A TATA box core promoter of a gene transcribed by RNA polymerase II. [PMID:16858867]"
        },
        "SO:0001662": {
            "name": "RNA_polymerase_III_TATA_box",
            "def": "A TATA box core promoter of a gene transcribed by RNA polymerase III. [SO:ke]"
        },
        "SO:0001663": {
            "name": "BREd_motif",
            "def": "A core TRNA polymerase II promoter element with consensus (G/A)T(T/G/A)(T/A)(G/T)(T/G)(T/G). [PMID:16858867]"
        },
        "SO:0001664": {
            "name": "DCE",
            "def": "A discontinuous core element of RNA polymerase II transcribed genes, situated downstream of the TSS. It is composed of three sub elements: SI, SII and SIII. [PMID:16858867]"
        },
        "SO:0001665": {
            "name": "DCE_SI",
            "def": "A sub element of the DCE core promoter element, with consensus sequence CTTC. [PMID:16858867, SO:ke]"
        },
        "SO:0001666": {
            "name": "DCE_SII",
            "def": "A sub element of the DCE core promoter element with consensus sequence CTGT. [PMID:16858867, SO:ke]"
        },
        "SO:0001667": {
            "name": "DCE_SIII",
            "def": "A sub element of the DCE core promoter element with consensus sequence AGC. [PMID:16858867, SO:ke]"
        },
        "SO:0001668": {
            "name": "proximal_promoter_element",
            "def": "DNA segment that ranges from about -250 to -40 relative to +1 of RNA transcription start site, where sequence specific DNA-binding transcription factors binds, such as Sp1, CTF (CCAAT-binding transcription factor), and CBF (CCAAT-box binding factor). [PMID:12515390, PMID:9679020, SO:ml]"
        },
        "SO:0001669": {
            "name": "RNApol_II_core_promoter",
            "def": "The minimal portion of the promoter required to properly initiate transcription in RNA polymerase II transcribed genes. [PMID:16858867]"
        },
        "SO:0001670": {
            "name": "distal_promoter_element"
        },
        "SO:0001671": {
            "name": "bacterial_RNApol_promoter_sigma_70"
        },
        "SO:0001672": {
            "name": "bacterial_RNApol_promoter_sigma54"
        },
        "SO:0001673": {
            "name": "minus_12_signal",
            "def": "A conserved region about 12-bp upstream of the start point of bacterial transcription units, involved with sigma factor 54. [PMID:18331472]"
        },
        "SO:0001674": {
            "name": "minus_24_signal",
            "def": "A conserved region about 12-bp upstream of the start point of bacterial transcription units, involved with sigma factor 54. [PMID:18331472]"
        },
        "SO:0001675": {
            "name": "A_box_type_1",
            "def": "An A box within an RNA polymerase III type 1 promoter. [SO:ke]"
        },
        "SO:0001676": {
            "name": "A_box_type_2",
            "def": "An A box within an RNA polymerase III type 2 promoter. [SO:ke]"
        },
        "SO:0001677": {
            "name": "intermediate_element",
            "def": "A core promoter region of RNA polymerase III type 1 promoters. [PMID:12381659]"
        },
        "SO:0001678": {
            "name": "regulatory_promoter_element",
            "def": "A promoter element that is not part of the core promoter, but provides the promoter with a specific regulatory region. [PMID:12381659]"
        },
        "SO:0001679": {
            "name": "transcription_regulatory_region",
            "def": "A regulatory region that is involved in the control of the process of transcription. [SO:ke]"
        },
        "SO:0001680": {
            "name": "translation_regulatory_region",
            "def": "A regulatory region that is involved in the control of the process of translation. [SO:ke]"
        },
        "SO:0001681": {
            "name": "recombination_regulatory_region",
            "def": "A regulatory region that is involved in the control of the process of recombination. [SO:ke]"
        },
        "SO:0001682": {
            "name": "replication_regulatory_region",
            "def": "A regulatory region that is involved in the control of the process of nucleotide replication. [SO:ke]"
        },
        "SO:0001683": {
            "name": "sequence_motif",
            "def": "A sequence motif is a nucleotide or amino-acid sequence pattern that may have biological significance. [http://en.wikipedia.org/wiki/Sequence_motif]"
        },
        "SO:0001684": {
            "name": "experimental_feature_attribute",
            "def": "An attribute of an experimentally derived feature. [SO:ke]"
        },
        "SO:0001685": {
            "name": "score",
            "def": "The score of an experimentally derived feature such as a p-value. [SO:ke]"
        },
        "SO:0001686": {
            "name": "quality_value",
            "def": "An experimental feature attribute that defines the quality of the feature in a quantitative way, such as a phred quality score. [SO:ke]"
        },
        "SO:0001687": {
            "name": "restriction_enzyme_recognition_site",
            "def": "The nucleotide region (usually a palindrome) that is recognized by a restriction enzyme. This may or may not be equal to the restriction enzyme binding site. [SO:ke]"
        },
        "SO:0001688": {
            "name": "restriction_enzyme_cleavage_junction",
            "def": "The boundary at which a restriction enzyme breaks the nucleotide sequence. [SO:ke]"
        },
        "SO:0001689": {
            "name": "five_prime_restriction_enzyme_junction",
            "def": "The restriction enzyme cleavage junction on the 5' strand of the nucleotide sequence. [SO:ke]"
        },
        "SO:0001690": {
            "name": "three_prime_restriction_enzyme_junction"
        },
        "SO:0001691": {
            "name": "blunt_end_restriction_enzyme_cleavage_site"
        },
        "SO:0001692": {
            "name": "sticky_end_restriction_enzyme_cleavage_site"
        },
        "SO:0001693": {
            "name": "blunt_end_restriction_enzyme_cleavage_junction",
            "def": "A restriction enzyme cleavage site where both strands are cut at the same position. [SO:ke]"
        },
        "SO:0001694": {
            "name": "single_strand_restriction_enzyme_cleavage_site",
            "def": "A restriction enzyme cleavage site whereby only one strand is cut. [SO:ke]"
        },
        "SO:0001695": {
            "name": "restriction_enzyme_single_strand_overhang",
            "def": "A terminal region of DNA sequence where the end of the region is not blunt ended. [SO:ke]"
        },
        "SO:0001696": {
            "name": "experimentally_defined_binding_region",
            "def": "A region that has been implicated in binding although the exact coordinates of binding may be unknown. [SO:ke]"
        },
        "SO:0001697": {
            "name": "ChIP_seq_region",
            "def": "A region of sequence identified by CHiP seq technology to contain a protein binding site. [SO:ke]"
        },
        "SO:0001698": {
            "name": "ASPE_primer",
            "def": "\\A primer containing an SNV at the 3' end for accurate genotyping. [http://www.ncbi.nlm.nih.gov/pubmed/11252801]"
        },
        "SO:0001699": {
            "name": "dCAPS_primer",
            "def": "A primer with one or more mismatches to the DNA template corresponding to a position within a restriction enzyme recognition site. [http://www.ncbi.nlm.nih.gov/pubmed/9628033]"
        },
        "SO:0001700": {
            "name": "histone_modification",
            "def": "Histone modification is a post translationally modified region whereby residues of the histone protein are modified by methylation, acetylation, phosphorylation, ubiquitination, sumoylation, citrullination, or ADP-ribosylation. [http:en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001701": {
            "name": "histone_methylation_site",
            "def": "A histone modification site where the modification is the methylation of the residue. [SO:ke]"
        },
        "SO:0001702": {
            "name": "histone_acetylation_site",
            "def": "A histone modification where the modification is the acylation of the residue. [SO:ke]"
        },
        "SO:0001703": {
            "name": "H3K9_acetylation_site",
            "def": "A kind of histone modification site, whereby the 9th residue (a lysine), from the start of the H3 histone protein is acylated. [http://en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001704": {
            "name": "H3K14_acetylation_site",
            "def": "A kind of histone modification site, whereby the 14th residue (a lysine), from the start of the H3 histone protein is acylated. [http://en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001705": {
            "name": "H3K4_monomethylation_site",
            "def": "A kind of histone modification, whereby the 4th residue (a lysine), from the start of the H3 protein is mono-methylated. [http://en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001706": {
            "name": "H3K4_trimethylation",
            "def": "A kind of histone modification site, whereby the 4th residue (a lysine), from the start of the H3 protein is tri-methylated. [http://en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001707": {
            "name": "H3K9_trimethylation_site",
            "def": "A kind of histone modification site, whereby the 9th residue (a lysine), from the start of the H3 histone protein is tri-methylated. [http://en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001708": {
            "name": "H3K27_monomethylation_site",
            "def": "A kind of histone modification site, whereby the 27th residue (a lysine), from the start of the H3 histone protein is mono-methylated. [http://en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001709": {
            "name": "H3K27_trimethylation_site",
            "def": "A kind of histone modification site, whereby the 27th residue (a lysine), from the start of the H3 histone protein is tri-methylated. [http://en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001710": {
            "name": "H3K79_monomethylation_site",
            "def": "A kind of histone modification site, whereby the 79th residue (a lysine), from the start of the H3 histone protein is mono- methylated. [http://en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001711": {
            "name": "H3K79_dimethylation_site",
            "def": "A kind of histone modification site, whereby the 79th residue (a lysine), from the start of the H3 histone protein is di-methylated. [http://en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001712": {
            "name": "H3K79_trimethylation_site",
            "def": "A kind of histone modification site, whereby the 79th residue (a lysine), from the start of the H3 histone protein is tri-methylated. [http://en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001713": {
            "name": "H4K20_monomethylation_site",
            "def": "A kind of histone modification site, whereby the 20th residue (a lysine), from the start of the H4histone protein is mono-methylated. [http://en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001714": {
            "name": "H2BK5_monomethylation_site",
            "def": "A kind of histone modification site, whereby the 5th residue (a lysine), from the start of the H2B protein is methylated. [http://en.wikipedia.org/wiki/Histone]"
        },
        "SO:0001715": {
            "name": "ISRE",
            "def": "An ISRE is a transcriptional cis regulatory region, containing the consensus region: YAGTTTC(A/T)YTTTYCC, responsible for increased transcription via interferon binding. [http://genesdev.cshlp.org/content/2/4/383.abstrac]"
        },
        "SO:0001716": {
            "name": "histone_ubiqitination_site",
            "def": "A histone modification site where ubiquitin may be added. [SO:ke]"
        },
        "SO:0001717": {
            "name": "H2B_ubiquitination_site",
            "def": "A histone modification site on H2B where ubiquitin may be added. [SO:ke]"
        },
        "SO:0001718": {
            "name": "H3K18_acetylation_site",
            "def": "A kind of histone modification site, whereby the 14th residue (a lysine), from the start of the H3 histone protein is acylated. [SO:ke]"
        },
        "SO:0001719": {
            "name": "H3K23_acylation_site",
            "def": "A kind of histone modification, whereby the 23rd residue (a lysine), from the start of the H3 histone protein is acylated. [SO:ke]"
        },
        "SO:0001720": {
            "name": "epigenetically_modified_region",
            "def": "A biological region implicated in inherited changes caused by mechanisms other than changes in the underlying DNA sequence. [http://en.wikipedia.org/wiki/Epigenetics, SO:ke]"
        },
        "SO:0001721": {
            "name": "H3K27_acylation_site",
            "def": "A kind of histone modification site, whereby the 27th residue (a lysine), from the start of the H3 histone protein is acylated. [SO:ke]"
        },
        "SO:0001722": {
            "name": "H3K36_monomethylation_site",
            "def": "A kind of histone modification site, whereby the 36th residue (a lysine), from the start of the H3 histone protein is mono-methylated. [SO:ke]"
        },
        "SO:0001723": {
            "name": "H3K36_dimethylation_site",
            "def": "A kind of histone modification site, whereby the 36th residue (a lysine), from the start of the H3 histone protein is dimethylated. [SO:ke]"
        },
        "SO:0001724": {
            "name": "H3K36_trimethylation_site",
            "def": "A kind of histone modification site, whereby the 36th residue (a lysine), from the start of the H3 histone protein is tri-methylated. [SO:ke]"
        },
        "SO:0001725": {
            "name": "H3K4_dimethylation_site",
            "def": "A kind of histone modification site, whereby the 4th residue (a lysine), from the start of the H3 histone protein is di-methylated. [SO:ke]"
        },
        "SO:0001726": {
            "name": "H3K27_dimethylation_site",
            "def": "A kind of histone modification site, whereby the 27th residue (a lysine), from the start of the H3 histone protein is di-methylated. [SO:ke]"
        },
        "SO:0001727": {
            "name": "H3K9_monomethylation_site",
            "def": "A kind of histone modification site, whereby the 9th residue (a lysine), from the start of the H3 histone protein is mono-methylated. [SO:ke]"
        },
        "SO:0001728": {
            "name": "H3K9_dimethylation_site",
            "def": "A kind of histone modification site, whereby the 9th residue (a lysine), from the start of the H3 histone protein may be dimethylated. [SO:ke]"
        },
        "SO:0001729": {
            "name": "H4K16_acylation_site",
            "def": "A kind of histone modification site, whereby the 16th residue (a lysine), from the start of the H4 histone protein is acylated. [SO:ke]"
        },
        "SO:0001730": {
            "name": "H4K5_acylation_site",
            "def": "A kind of histone modification site, whereby the 5th residue (a lysine), from the start of the H4 histone protein is acylated. [SO:ke]"
        },
        "SO:0001731": {
            "name": "H4K8_acylation_site",
            "def": "A kind of histone modification site, whereby the 8th residue (a lysine), from the start of the H4 histone protein is acylated. [SO:KE]"
        },
        "SO:0001732": {
            "name": "H3K27_methylation_site",
            "def": "A kind of histone modification site, whereby the 27th residue (a lysine), from the start of the H3 histone protein is methylated. [SO:ke]"
        },
        "SO:0001733": {
            "name": "H3K36_methylation_site",
            "def": "A kind of histone modification site, whereby the 36th residue (a lysine), from the start of the H3 histone protein is methylated. [SO:ke]"
        },
        "SO:0001734": {
            "name": "H3K4_methylation_site",
            "def": "A kind of histone modification, whereby the 4th residue (a lysine), from the start of the H3 protein is methylated. [SO:ke]"
        },
        "SO:0001735": {
            "name": "H3K79_methylation_site",
            "def": "A kind of histone modification site, whereby the 79th residue (a lysine), from the start of the H3 histone protein is methylated. [SO:ke]"
        },
        "SO:0001736": {
            "name": "H3K9_methylation_site",
            "def": "A kind of histone modification site, whereby the 9th residue (a lysine), from the start of the H3 histone protein is methylated. [SO:ke]"
        },
        "SO:0001737": {
            "name": "histone_acylation_region",
            "def": "A histone modification, whereby the histone protein is acylated at multiple sites in a region. [SO:ke]"
        },
        "SO:0001738": {
            "name": "H4K_acylation_region",
            "def": "A region of the H4 histone whereby multiple lysines are acylated. [SO:ke]"
        },
        "SO:0001739": {
            "name": "gene_with_non_canonical_start_codon",
            "def": "A gene with a start codon other than AUG. [SO:xp]"
        },
        "SO:0001740": {
            "name": "gene_with_start_codon_CUG",
            "def": "A gene with a translational start codon of CUG. [SO:mc]"
        },
        "SO:0001741": {
            "name": "pseudogenic_gene_segment",
            "def": "A gene segment which when incorporated by somatic recombination in the final gene transcript results in a nonfunctional product. [SO:hd]"
        },
        "SO:0001742": {
            "name": "copy_number_gain",
            "def": "A sequence alteration whereby the copy number of a given regions is greater than the reference sequence. [SO:ke]"
        },
        "SO:0001743": {
            "name": "copy_number_loss",
            "def": "A sequence alteration whereby the copy number of a given region is less than the reference sequence. [SO:ke]"
        },
        "SO:0001744": {
            "name": "UPD",
            "def": "Uniparental disomy is a sequence_alteration where a diploid individual receives two copies for all or part of a chromosome from one parent and no copies of the same chromosome or region from the other parent. [SO:BM]"
        },
        "SO:0001745": {
            "name": "maternal_uniparental_disomy",
            "def": "Uniparental disomy is a sequence_alteration where a diploid individual receives two copies for all or part of a chromosome from the mother and no copies of the same chromosome or region from the father. [SO:bm]"
        },
        "SO:0001746": {
            "name": "paternal_uniparental_disomy",
            "def": "Uniparental disomy is a sequence_alteration where a diploid individual receives two copies for all or part of a chromosome from the father and no copies of the same chromosome or region from the mother. [SO:bm]"
        },
        "SO:0001747": {
            "name": "open_chromatin_region",
            "def": "A DNA sequence that in the normal state of the chromosome corresponds to an unfolded, un-complexed stretch of double-stranded DNA. [SO:cb]"
        },
        "SO:0001748": {
            "name": "SL3_acceptor_site",
            "def": "A SL2_acceptor_site which appends the SL3 RNA leader sequence to the 5' end of an mRNA. SL3 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]"
        },
        "SO:0001749": {
            "name": "SL4_acceptor_site",
            "def": "A SL2_acceptor_site which appends the SL4 RNA leader sequence to the 5' end of an mRNA. SL4 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]"
        },
        "SO:0001750": {
            "name": "SL5_acceptor_site",
            "def": "A SL2_acceptor_site which appends the SL5 RNA leader sequence to the 5' end of an mRNA. SL5 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]"
        },
        "SO:0001751": {
            "name": "SL6_acceptor_site",
            "def": "A SL2_acceptor_site which appends the SL6 RNA leader sequence to the 5' end of an mRNA. SL6 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]"
        },
        "SO:0001752": {
            "name": "SL7_acceptor_site",
            "def": "A SL2_acceptor_site which appends the SL7 RNA leader sequence to the 5' end of an mRNA. SL7 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]"
        },
        "SO:0001753": {
            "name": "SL8_acceptor_site",
            "def": "A SL2_acceptor_site which appends the SL8 RNA leader sequence to the 5' end of an mRNA. SL8 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]"
        },
        "SO:0001754": {
            "name": "SL9_acceptor_site",
            "def": "A SL2_acceptor_site which appends the SL9 RNA leader sequence to the 5' end of an mRNA. SL9 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]"
        },
        "SO:0001755": {
            "name": "SL10_acceptor_site",
            "def": "A SL2_acceptor_site which appends the SL10 RNA leader sequence to the 5' end of an mRNA. SL10 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]"
        },
        "SO:0001756": {
            "name": "SL11_acceptor_site",
            "def": "A SL2_acceptor_site which appends the SL11 RNA leader sequence to the 5' end of an mRNA. SL11 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]"
        },
        "SO:0001757": {
            "name": "SL12_acceptor_site",
            "def": "A SL2_acceptor_site which appends the SL12 RNA leader sequence to the 5' end of an mRNA. SL12 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]"
        },
        "SO:0001758": {
            "name": "duplicated_pseudogene",
            "def": "A pseudogene that arose via gene duplication. Generally duplicated pseudogenes have the same structure as the original gene, including intron-exon structure and some regulatory sequence. [http://en.wikipedia.org/wiki/Pseudogene]"
        },
        "SO:0001759": {
            "name": "unitary_pseudogene",
            "def": "A pseudogene, deactivated from original state by mutation, fixed in a population. [http://en.wikipedia.org/wiki/Pseudogene, SO:ke]"
        },
        "SO:0001760": {
            "name": "non_processed_pseudogene",
            "def": "A pseudogene that arose from a means other than retrotransposition. [SO:ke]"
        },
        "SO:0001761": {
            "name": "variant_quality",
            "def": "A dependent entity that inheres in a bearer, a sequence variant. [PMID:17597783, SO:ke]"
        },
        "SO:0001762": {
            "name": "variant_origin",
            "def": "A quality inhering in a variant by virtue of its origin. [PMID:17597783, SO:ke]"
        },
        "SO:0001763": {
            "name": "variant_frequency",
            "def": "A physical quality which inheres to the variant by virtue of the number instances of the variant within a population. [PMID:17597783, SO:ke]"
        },
        "SO:0001764": {
            "name": "unique_variant",
            "def": "A physical quality which inheres to the variant by virtue of the number instances of the variant within a population. [SO:ke]"
        },
        "SO:0001765": {
            "name": "rare_variant"
        },
        "SO:0001766": {
            "name": "polymorphic_variant"
        },
        "SO:0001767": {
            "name": "common_variant"
        },
        "SO:0001768": {
            "name": "fixed_variant"
        },
        "SO:0001769": {
            "name": "variant_phenotype",
            "def": "A quality inhering in a variant by virtue of its phenotype. [PMID:17597783, SO:ke]"
        },
        "SO:0001770": {
            "name": "benign_variant"
        },
        "SO:0001771": {
            "name": "disease_associated_variant"
        },
        "SO:0001772": {
            "name": "disease_causing_variant"
        },
        "SO:0001773": {
            "name": "lethal_variant"
        },
        "SO:0001774": {
            "name": "quantitative_variant"
        },
        "SO:0001775": {
            "name": "maternal_variant"
        },
        "SO:0001776": {
            "name": "paternal_variant"
        },
        "SO:0001777": {
            "name": "somatic_variant"
        },
        "SO:0001778": {
            "name": "germline_variant"
        },
        "SO:0001779": {
            "name": "pedigree_specific_variant"
        },
        "SO:0001780": {
            "name": "population_specific_variant"
        },
        "SO:0001781": {
            "name": "de_novo_variant"
        },
        "SO:0001782": {
            "name": "TF_binding_site_variant",
            "def": "A sequence variant located within a transcription factor binding site. [EBI:fc]"
        },
        "SO:0001784": {
            "name": "complex_structural_alteration",
            "def": "A structural sequence alteration or rearrangement encompassing one or more genome fragments, with 4 or more breakpoints. [FB:reference_manual, NCBI:th, SO:ke]"
        },
        "SO:0001785": {
            "name": "structural_alteration"
        },
        "SO:0001786": {
            "name": "loss_of_heterozygosity",
            "def": "A functional variant whereby the sequence alteration causes a loss of function of one allele of a gene. [SO:ke]"
        },
        "SO:0001787": {
            "name": "splice_donor_5th_base_variant",
            "def": "A sequence variant that causes a change at the 5th base pair after the start of the intron in the orientation of the transcript. [EBI:gr]"
        },
        "SO:0001788": {
            "name": "U_box",
            "def": "An U-box is a conserved T-rich region upstream of a retroviral polypurine tract that is involved in PPT primer creation during reverse transcription. [PMID:10556309, PMID:11577982, PMID:9649446]"
        },
        "SO:0001789": {
            "name": "mating_type_region",
            "def": "A specialized region in the genomes of some yeast and fungi, the genes of which regulate mating type. [SO:ke]"
        },
        "SO:0001790": {
            "name": "paired_end_fragment",
            "def": "An assembly region that has been sequenced from both ends resulting in a read_pair (mate_pair). [SO:ke]"
        },
        "SO:0001791": {
            "name": "exon_variant",
            "def": "A sequence variant that changes exon sequence. [SO:ke]"
        },
        "SO:0001792": {
            "name": "non_coding_transcript_exon_variant",
            "def": "A sequence variant that changes non-coding exon sequence in a non-coding transcript. [EBI:fc, SO:ke]"
        },
        "SO:0001793": {
            "name": "clone_end",
            "def": "A read from an end of the clone sequence. [SO:ke]"
        },
        "SO:0001794": {
            "name": "point_centromere",
            "def": "A point centromere is a relatively small centromere (about 125 bp DNA) in discrete sequence, found in some yeast including S. cerevisiae. [PMID:7502067, SO:vw]"
        },
        "SO:0001795": {
            "name": "regional_centromere",
            "def": "A regional centromere is a large modular centromere found in fission yeast and higher eukaryotes. It consist of a central core region flanked by inverted inner and outer repeat regions. [PMID:7502067, SO:vw]"
        },
        "SO:0001796": {
            "name": "regional_centromere_central_core",
            "def": "A conserved region within the central region of a modular centromere, where the kinetochore is formed. [SO:vw]"
        },
        "SO:0001797": {
            "name": "centromeric_repeat",
            "def": "A repeat region found within the modular centromere. [SO:ke]"
        },
        "SO:0001798": {
            "name": "regional_centromere_inner_repeat_region",
            "def": "The inner inverted repeat region of a modular centromere and part of the central core surrounding a non-conserved central region. This region is adjacent to the central core, on each chromosome arm. [SO:vw]"
        },
        "SO:0001799": {
            "name": "regional_centromere_outer_repeat_region",
            "def": "The heterochromatic outer repeat region of a modular centromere. These repeats exist in tandem arrays on both chromosome arms. [SO:vw]"
        },
        "SO:0001800": {
            "name": "tasiRNA",
            "def": "The sequence of a 21 nucleotide double stranded, polyadenylated non coding RNA, transcribed from the TAS gene. [PMID:16145017]"
        },
        "SO:0001801": {
            "name": "tasiRNA_primary_transcript",
            "def": "A primary transcript encoding a tasiRNA. [PMID:16145017]"
        },
        "SO:0001802": {
            "name": "increased_polyadenylation_variant",
            "def": "A transcript processing variant whereby polyadenylation of the encoded transcript is increased with respect to the reference. [SO:ke]"
        },
        "SO:0001803": {
            "name": "decreased_polyadenylation_variant",
            "def": "A transcript processing variant whereby polyadenylation of the encoded transcript is decreased with respect to the reference. [SO:ke]"
        },
        "SO:0001804": {
            "name": "DDB_box",
            "def": "A conserved polypeptide motif that mediates protein-protein interaction and defines adaptor proteins for DDB1/cullin 4 ubiquitin ligases. [PMID:18794354, PMID:19818632]"
        },
        "SO:0001805": {
            "name": "destruction_box",
            "def": "A conserved polypeptide motif that can be recognized by both Fizzy/Cdc20- and FZR/Cdh1-activated anaphase-promoting complex/cyclosome (APC/C) and targets a protein for ubiquitination and subsequent degradation by the APC/C. The consensus sequence is RXXLXXXXN. [PMID:12208841, PMID:1842691]"
        },
        "SO:0001806": {
            "name": "ER_retention_signal",
            "def": "A C-terminal tetrapeptide motif that mediates retention of a protein in (or retrieval to) the endoplasmic reticulum. In mammals the sequence is KDEL, and in fungi HDEL or DDEL. [doi:10.1093/jxb/50.331.157, PMID:2077689]"
        },
        "SO:0001807": {
            "name": "KEN_box",
            "def": "A conserved polypeptide motif that can be recognized by FZR/Cdh1-activated anaphase-promoting complex/cyclosome (APC/C) and targets a protein for ubiquitination and subsequent degradation by the APC/C. The consensus sequence is KENXXXN. [PMID:10733526, PMID:1220884, PMID:18426916]"
        },
        "SO:0001808": {
            "name": "mitochondrial_targeting_signal",
            "def": "A polypeptide region that targets a polypeptide to the mitochondrion. [PomBase:mah]"
        },
        "SO:0001809": {
            "name": "signal_anchor",
            "def": "A signal sequence that is not cleaved from the polypeptide. Anchors a Type II membrane protein to the membrane. [http://www.cbs.dtu.dk/services/SignalP/background/biobackground.php]"
        },
        "SO:0001810": {
            "name": "PIP_box",
            "def": "A polypeptide region that mediates binding to PCNA. The consensus sequence is QXX(hh)XX(aa), where (h) denotes residues with moderately hydrophobic side chains and (a) denotes residues with highly hydrophobic aromatic side chains. [PMID:9631646]"
        },
        "SO:0001811": {
            "name": "phosphorylation_site",
            "def": "A post-translationally modified region in which residues of the protein are modified by phosphorylation. [PomBase:mah]"
        },
        "SO:0001812": {
            "name": "transmembrane_helix",
            "def": "A region that traverses the lipid bilayer and adopts a helical secondary structure. [PomBase:mah]"
        },
        "SO:0001813": {
            "name": "vacuolar_sorting_signal",
            "def": "A polypeptide region that targets a polypeptide to the vacuole. [PomBase:mah]"
        },
        "SO:0001814": {
            "name": "coding_variant_quality"
        },
        "SO:0001815": {
            "name": "synonymous"
        },
        "SO:0001816": {
            "name": "non_synonymous"
        },
        "SO:0001817": {
            "name": "inframe",
            "def": "An attribute describing a sequence that contains a mutation involving the deletion or insertion of one or more bases, where this number is divisible by 3. [SO:ke]"
        },
        "SO:0001818": {
            "name": "protein_altering_variant",
            "def": "A sequence_variant which is predicted to change the protein encoded in the coding sequence. [EBI:gr]"
        },
        "SO:0001819": {
            "name": "synonymous_variant",
            "def": "A sequence variant where there is no resulting change to the encoded amino acid. [SO:ke]"
        },
        "SO:0001820": {
            "name": "inframe_indel",
            "def": "A coding sequence variant where the change does not alter the frame of the transcript. [SO:ke]"
        },
        "SO:0001821": {
            "name": "inframe_insertion",
            "def": "An inframe non synonymous variant that inserts bases into in the coding sequence. [EBI:gr]"
        },
        "SO:0001822": {
            "name": "inframe_deletion",
            "def": "An inframe non synonymous variant that deletes bases from the coding sequence. [EBI:gr]"
        },
        "SO:0001823": {
            "name": "conservative_inframe_insertion",
            "def": "An inframe increase in cds length that inserts one or more codons into the coding sequence between existing codons. [EBI:gr]"
        },
        "SO:0001824": {
            "name": "disruptive_inframe_insertion",
            "def": "An inframe increase in cds length that inserts one or more codons into the coding sequence within an existing codon. [EBI:gr]"
        },
        "SO:0001825": {
            "name": "conservative_inframe_deletion",
            "def": "An inframe decrease in cds length that deletes one or more entire codons from the coding sequence but does not change any remaining codons. [EBI:gr]"
        },
        "SO:0001826": {
            "name": "disruptive_inframe_deletion",
            "def": "An inframe decrease in cds length that deletes bases from the coding sequence starting within an existing codon. [EBI:gr]"
        },
        "SO:0001827": {
            "name": "mRNA_read",
            "def": "A sequencer read of an mRNA substrate. [SO:ke]"
        },
        "SO:0001828": {
            "name": "genomic_DNA_read",
            "def": "A sequencer read of a genomic DNA substrate. [SO:ke]"
        },
        "SO:0001829": {
            "name": "mRNA_contig",
            "def": "A contig composed of mRNA_reads. [SO:ke]"
        },
        "SO:0001830": {
            "name": "AFLP_fragment",
            "def": "A PCR product obtained by applying the AFLP technique, based on a restriction enzyme digestion of genomic DNA and an amplification of the resulting fragments. [GMOD:ea]"
        },
        "SO:0001831": {
            "name": "protein_hmm_match",
            "def": "A match to a protein HMM such as pfam. [SO:ke]"
        },
        "SO:0001832": {
            "name": "immunoglobulin_region",
            "def": "A region of immunoglobulin sequence, either constant or variable. [SO:ke]"
        },
        "SO:0001833": {
            "name": "V_region",
            "def": "The variable region of an immunoglobulin polypeptide sequence. [SO:ke]"
        },
        "SO:0001834": {
            "name": "C_region",
            "def": "The constant region of an immunoglobulin polypeptide sequence. [SO:ke]"
        },
        "SO:0001835": {
            "name": "N_region",
            "def": "Extra nucleotides inserted between rearranged immunoglobulin segments. [SO:ke]"
        },
        "SO:0001836": {
            "name": "S_region",
            "def": "The switch region of immunoglobulin heavy chains; it is involved in the rearrangement of heavy chain DNA leading to the expression of a different immunoglobulin classes from the same B-cell. [SO:ke]"
        },
        "SO:0001837": {
            "name": "mobile_element_insertion",
            "def": "A kind of insertion where the inserted sequence is a mobile element. [EBI:dvga]"
        },
        "SO:0001838": {
            "name": "novel_sequence_insertion",
            "def": "An insertion the sequence of which cannot be mapped to the reference genome. [NCBI:th]"
        },
        "SO:0001839": {
            "name": "CSL_response_element",
            "def": "A promoter element with consensus sequence GTGRGAA, bound by CSL (CBF1/RBP-JK/Suppressor of Hairless/LAG-1) transcription factors. [PMID:19101542]"
        },
        "SO:0001840": {
            "name": "GATA_box",
            "def": "A GATA transcription factor element containing the consensus sequence WGATAR (in which W indicates A/T and R indicates A/G). [PMID:8321208]"
        },
        "SO:0001841": {
            "name": "polymorphic_pseudogene",
            "def": "Pseudogene owing to a SNP/DIP but in other individuals/haplotypes/strains the gene is translated. [JAX:hd]"
        },
        "SO:0001842": {
            "name": "AP_1_binding_site",
            "def": "A promoter element with consensus sequence TGACTCA, bound by AP-1 and related transcription factors. [PMID:1899230, PMID:3034432, PMID:3125983]"
        },
        "SO:0001843": {
            "name": "CRE",
            "def": "A promoter element with consensus sequence TGACGTCA; bound by the ATF/CREB family of transcription factors. [PMID:11483355, PMID:11483993]"
        },
        "SO:0001844": {
            "name": "CuRE",
            "def": "A promoter element bound by copper ion-sensing transcription factors such as S. cerevisiae Mac1p or S. pombe Cuf1; the consensus sequence is HTHNNGCTGD (more specifically TTTGCKCR in budding yeast). [PMID:10593913, PMID:9188496, PMID:9211922]"
        },
        "SO:0001845": {
            "name": "DRE",
            "def": "A promoter element with consensus sequence CGWGGWNGMM, bound by transcription factors related to RecA and found in promoters of genes expressed following several types of DNA damage or inhibition of DNA synthesis. [PMID:11073995, PMID:8668127]"
        },
        "SO:0001846": {
            "name": "FLEX_element",
            "def": "A promoter element that has consensus sequence GTAAACAAACAAAM and contains a heptameric core GTAAACA, bound by transcription factors with a forkhead DNA-binding domain. [PMID:10747048, PMID:14871934]"
        },
        "SO:0001847": {
            "name": "forkhead_motif",
            "def": "A promoter element with consensus sequence TTTRTTTACA, bound by transcription factors with a forkhead DNA-binding domain. [PMID:15195092]"
        },
        "SO:0001848": {
            "name": "homol_D_box",
            "def": "A core promoter element that has the consensus sequence CAGTCACA (or its inverted form TGTGACTG), and plays the role of a TATA box in promoters that do not contain a canonical TATA sequence. [PMID:7501449, PMID:8458332]"
        },
        "SO:0001849": {
            "name": "homol_E_box",
            "def": "A core promoter element that has the consensus sequence ACCCTACCCT (or its inverted form AGGGTAGGGT), and is found near the homol D box in some promoters that use a homol D box instead of a canonical TATA sequence. [PMID:7501449]"
        },
        "SO:0001850": {
            "name": "HSE",
            "def": "A promoter element that consists of at least three copies of the pentanucleotide NGAAN, bound by the heat shock transcription factor HSF. [PMID:17347150, PMID:8689565]"
        },
        "SO:0001851": {
            "name": "iron_repressed_GATA_element",
            "def": "A GATA promoter element with consensus sequence WGATAA, found in promoters of genes repressed in the presence of iron. [PMID:11956219, PMID:17211681]"
        },
        "SO:0001852": {
            "name": "mating_type_M_box",
            "def": "A promoter element with consensus sequence ACAAT, found in promoters of mating type M-specific genes in fission yeast and bound by the transcription factor Mat1-Mc. [PMID:9233811]"
        },
        "SO:0001853": {
            "name": "androgen_response_element",
            "def": "A non-palindromic sequence found in the promoters of genes whose expression is regulated in response to androgen. [PMID:21796522]"
        },
        "SO:0001854": {
            "name": "smFISH_probe",
            "def": "A smFISH is a probe that binds RNA in a single molecule in situ hybridization experiment. [PMID:18806792]"
        },
        "SO:0001855": {
            "name": "MCB",
            "def": "A promoter element with consensus sequence ACGCGT, bound by the transcription factor complex MBF (MCB-binding factor) and found in promoters of genes expressed during the G1/S transition of the cell cycle. [PMID:16285853]"
        },
        "SO:0001856": {
            "name": "CCAAT_motif",
            "def": "A promoter element with consensus sequence CCAAT, bound by a protein complex that represses transcription in response to low iron levels. [PMID:16963626]"
        },
        "SO:0001857": {
            "name": "Ace2_UAS",
            "def": "A promoter element with consensus sequence CCAGCC, bound by the fungal transcription factor Ace2. [PMID:16678171]"
        },
        "SO:0001858": {
            "name": "TR_box",
            "def": "A promoter element with consensus sequence TTCTTTGTTY, bound an HMG-box transcription factor such as S. pombe Ste11, and found in promoters of genes up-regulated early in meiosis. [PMID:1657709]"
        },
        "SO:0001859": {
            "name": "STREP_motif",
            "def": "A promoter element with consensus sequence CCCCTC, bound by the PKA-responsive zinc finger transcription factor Rst2. [PMID:11739717]"
        },
        "SO:0001860": {
            "name": "rDNA_intergenic_spacer_element",
            "def": "A DNA motif that contains a core consensus sequence AGGTAAGGGTAATGCAC, is found in the intergenic regions of rDNA repeats, and is bound by an RNA polymerase I transcription termination factor (e.g. S. pombe Reb1). [PMID:9016645]"
        },
        "SO:0001861": {
            "name": "sterol_regulatory_element",
            "def": "A 10-bp promoter element bound by sterol regulatory element binding proteins (SREBPs), found in promoters of genes involved in sterol metabolism. Many variants of the sequence ATCACCCCAC function as SREs. [GO:mah, PMID:11111080, PMID:16537923]"
        },
        "SO:0001862": {
            "name": "GT_dinucleotide_repeat",
            "def": "A dinucleotide repeat region composed of GT repeating elements. [SO:ke]"
        },
        "SO:0001863": {
            "name": "GTT_trinucleotide_repeat",
            "def": "A trinucleotide repeat region composed of GTT repeating elements. [SO:ke]"
        },
        "SO:0001864": {
            "name": "Sap1_recognition_motif",
            "def": "A DNA motif to which the S. pombe Sap1 protein binds. The consensus sequence is 5'-TARGCAGNTNYAACGMG-3'; it is found at the mating type locus, where it is important for mating type switching, and at replication fork barriers in rDNA repeats. [PMID:16166653, PMID:7651412]"
        },
        "SO:0001865": {
            "name": "CDRE_motif",
            "def": "An RNA polymerase II promoter element found in the promoters of genes regulated by calcineurin. The consensus sequence is GNGGCKCA. [PMID:16928959]"
        },
        "SO:0001866": {
            "name": "BAC_read_contig",
            "def": "A contig of BAC reads. [GMOD:ea]"
        },
        "SO:0001867": {
            "name": "candidate_gene",
            "def": "A gene suspected of being involved in the expression of a trait. [GMOD:ea]"
        },
        "SO:0001868": {
            "name": "positional_candidate_gene",
            "def": "A candidate gene whose association with a trait is based on the gene's location on a chromosome. [GMOD:ea]"
        },
        "SO:0001869": {
            "name": "functional_candidate_gene",
            "def": "A candidate gene whose function has something in common biologically with the trait under investigation. [GMOD:ea]"
        },
        "SO:0001870": {
            "name": "enhancerRNA",
            "def": "A short ncRNA that is transcribed from an enhancer. May have a regulatory function. [doi:10.1038/465173a, SO:cjm]"
        },
        "SO:0001871": {
            "name": "PCB",
            "def": "A promoter element with consensus sequence GNAACR, bound by the transcription factor complex PBF (PCB-binding factor) and found in promoters of genes expressed during the M/G1 transition of the cell cycle. [GO:mah, PMID:12411492]"
        },
        "SO:0001872": {
            "name": "rearrangement_region",
            "def": "A region of a chromosome, where the chromosome has undergone a large structural rearrangement that altered the genome organization. There is no longer synteny to the reference genome. [NCBI:th, PMID:18564416]"
        },
        "SO:0001873": {
            "name": "interchromosomal_breakpoint",
            "def": "A rearrangement breakpoint between two different chromosomes. [NCBI:th]"
        },
        "SO:0001874": {
            "name": "intrachromosomal_breakpoint",
            "def": "A rearrangement breakpoint within the same chromosome. [NCBI:th]"
        },
        "SO:0001875": {
            "name": "unassigned_supercontig",
            "def": "A supercontig that is not been assigned to any ultracontig during a genome assembly project. [GMOD:ea]"
        },
        "SO:0001876": {
            "name": "partial_genomic_sequence_assembly",
            "def": "A partial DNA sequence assembly of a chromosome or full genome, which contains gaps that are filled with N's. [GMOD:ea]"
        },
        "SO:0001877": {
            "name": "lnc_RNA",
            "def": "A non-coding RNA over 200nucleotides in length. [HGNC:mw]"
        },
        "SO:0001878": {
            "name": "feature_variant",
            "def": "A sequence variant that falls entirely or partially within a genomic feature. [EBI:fc, SO:ke]"
        },
        "SO:0001879": {
            "name": "feature_ablation",
            "def": "A sequence variant, caused by an alteration of the genomic sequence, where the deletion, is greater than the extent of the underlying genomic features. [SO:ke]"
        },
        "SO:0001880": {
            "name": "feature_amplification",
            "def": "A sequence variant, caused by an alteration of the genomic sequence, where the structural change, an amplification of sequence, is greater than the extent of the underlying genomic features. [SO:ke]"
        },
        "SO:0001881": {
            "name": "feature_translocation",
            "def": "A sequence variant, caused by an alteration of the genomic sequence, where the structural change, a translocation, is greater than the extent of the underlying genomic features. [SO:ke]"
        },
        "SO:0001882": {
            "name": "feature_fusion",
            "def": "A sequence variant, caused by an alteration of the genomic sequence, where a deletion fuses genomic features. [SO:ke]"
        },
        "SO:0001883": {
            "name": "transcript_translocation",
            "def": "A feature translocation where the region contains a transcript. [SO:ke]"
        },
        "SO:0001884": {
            "name": "regulatory_region_translocation",
            "def": "A feature translocation where the region contains a regulatory region. [SO:ke]"
        },
        "SO:0001885": {
            "name": "TFBS_translocation",
            "def": "A feature translocation where the region contains a transcription factor binding site. [SO:ke]"
        },
        "SO:0001886": {
            "name": "transcript_fusion",
            "def": "A feature fusion where the deletion brings together transcript regions. [SO:ke]"
        },
        "SO:0001887": {
            "name": "regulatory_region_fusion",
            "def": "A feature fusion where the deletion brings together regulatory regions. [SO:ke]"
        },
        "SO:0001888": {
            "name": "TFBS_fusion",
            "def": "A fusion where the deletion brings together transcription factor binding sites. [SO:ke]"
        },
        "SO:0001889": {
            "name": "transcript_amplification",
            "def": "A feature amplification of a region containing a transcript. [SO:ke]"
        },
        "SO:0001890": {
            "name": "transcript_regulatory_region_fusion",
            "def": "A feature fusion where the deletion brings together a regulatory region and a transcript region. [SO:ke]"
        },
        "SO:0001891": {
            "name": "regulatory_region_amplification",
            "def": "A feature amplification of a region containing a regulatory region. [SO:ke]"
        },
        "SO:0001892": {
            "name": "TFBS_amplification",
            "def": "A feature amplification of a region containing a transcription factor binding site. [SO:ke]"
        },
        "SO:0001893": {
            "name": "transcript_ablation",
            "def": "A feature ablation whereby the deleted region includes a transcript feature. [SO:ke]"
        },
        "SO:0001894": {
            "name": "regulatory_region_ablation",
            "def": "A feature ablation whereby the deleted region includes a regulatory region. [SO:ke]"
        },
        "SO:0001895": {
            "name": "TFBS_ablation",
            "def": "A feature ablation whereby the deleted region includes a transcription factor binding site. [SO:ke]"
        },
        "SO:0001896": {
            "name": "transposable_element_CDS",
            "def": "A CDS that is part of a transposable element. [SO:ke]"
        },
        "SO:0001897": {
            "name": "transposable_element_pseudogene",
            "def": "A pseudogene contained within a transposable element. [SO:ke]"
        },
        "SO:0001898": {
            "name": "dg_repeat",
            "def": "A repeat region which is part of the regional centromere outer repeat region. [PMID:16407326, SO:vw]"
        },
        "SO:0001899": {
            "name": "dh_repeat",
            "def": "A repeat region which is part of the regional centromere outer repeat region. [PMID:16407326, SO:vw]"
        },
        "SO:0001900": {
            "name": "M26_binding_site",
            "def": "A promoter element that contains a core sequence TGACGT, bound by a protein complex that regulates transcription of genes encoding PKA pathway components. [PMID:15448137]"
        },
        "SO:0001901": {
            "name": "AACCCT_box",
            "def": "A conserved 17-bp sequence (5'-ATCA(C/A)AACCCTAACCCT-3') commonly present upstream of the start site of histone transcription units functioning as a transcription factor binding site. [PMID:17452352, PMID:4092687]"
        },
        "SO:0001902": {
            "name": "splice_region",
            "def": "A region surrounding a cis_splice site, either within 1-3 bases of the exon or 3-8 bases of the intron. [SO:bm]"
        },
        "SO:0001903": {
            "name": "intronic_lncRNA",
            "def": "A lnc_RNA totally contained within an intron. [PMID:19071207, SO:ke]"
        },
        "SO:0001904": {
            "name": "antisense_lncRNA",
            "def": "Non-coding RNA transcribed from the opposite DNA strand compared with other transcripts and overlap in part with sense RNA. [PMID:19638999]"
        },
        "SO:0001905": {
            "name": "regional_centromere_outer_repeat_transcript",
            "def": "A transcript that is transcribed from the outer repeat region of a regional centromere. [PomBase:mah]"
        },
        "SO:0001906": {
            "name": "feature_truncation",
            "def": "A sequence variant that causes the reduction of a genomic feature, with regard to the reference sequence. [SO:ke]"
        },
        "SO:0001907": {
            "name": "feature_elongation",
            "def": "A sequence variant that causes the extension of a genomic feature, with regard to the reference sequence. [SO:ke]"
        },
        "SO:0001908": {
            "name": "internal_feature_elongation",
            "def": "A sequence variant that causes the extension of a genomic feature from within the feature rather than from the terminus of the feature, with regard to the reference sequence. [SO:ke]"
        },
        "SO:0001909": {
            "name": "frameshift_elongation",
            "def": "A frameshift variant that causes the translational reading frame to be extended relative to the reference feature. [SO:ke]"
        },
        "SO:0001910": {
            "name": "frameshift_truncation",
            "def": "A frameshift variant that causes the translational reading frame to be shortened relative to the reference feature. [SO:ke]"
        },
        "SO:0001911": {
            "name": "copy_number_increase",
            "def": "A sequence variant where copies of a feature are increased relative to the reference. [SO:ke]"
        },
        "SO:0001912": {
            "name": "copy_number_decrease",
            "def": "A sequence variant where copies of a feature are decreased relative to the reference. [SO:ke]"
        },
        "SO:0001913": {
            "name": "bacterial_RNApol_promoter_sigma_ecf",
            "def": "A bacterial promoter with sigma ecf factor binding dependency. This is a type of bacterial promoters that requires a sigma ECF factor to bind to identified -10 and -35 sequence regions in order to mediate binding of the RNA polymerase to the promoter region as part of transcription initiation. [Invitrogen:kc]"
        },
        "SO:0001914": {
            "name": "rDNA_replication_fork_barrier",
            "def": "A DNA motif that is found in eukaryotic rDNA repeats, and is a site of replication fork pausing. [PMID:14645529]"
        },
        "SO:0001915": {
            "name": "transcription_start_cluster",
            "def": "A region defined by a cluster of experimentally determined transcription starting sites. [PMID:19624849, PMID:21372179, SO:andrewgibson]"
        },
        "SO:0001916": {
            "name": "CAGE_tag",
            "def": "A CAGE tag is a sequence tag hat corresponds to 5' ends of mRNA at cap sites, produced by cap analysis gene expression and used to identify transcriptional start sites. [SO:andrewgibson]"
        },
        "SO:0001917": {
            "name": "CAGE_cluster",
            "def": "A kind of transcription_initiation_cluster defined by the clustering of CAGE tags on a sequence region. [PMID:16645617, SO:andrewgibson]"
        },
        "SO:0001918": {
            "name": "5_methylcytosine",
            "def": "A cytosine methylated at the 5 carbon. [SO:rtapella]"
        },
        "SO:0001919": {
            "name": "4_methylcytosine",
            "def": "A cytosine methylated at the 4 nitrogen. [SO:rtapella]"
        },
        "SO:0001920": {
            "name": "N6_methyladenine",
            "def": "An adenine methylated at the 6 nitrogen. [SO:rtapella]"
        },
        "SO:0001921": {
            "name": "mitochondrial_contig",
            "def": "A contig of mitochondria derived sequences. [GMOD:ea]"
        },
        "SO:0001922": {
            "name": "mitochondrial_supercontig",
            "def": "A scaffold composed of mitochondrial contigs. [GMOD:ea]"
        },
        "SO:0001923": {
            "name": "TERRA",
            "def": "A non-coding RNA transcript, derived from the transcription of the telomere. These  transcripts contain G rich telomeric RNA repeats and RNA tracts corresponding to adjacent subtelomeric sequences. They are 100-9000 bases long. [PMID:22139915]"
        },
        "SO:0001924": {
            "name": "ARRET",
            "def": "A non coding RNA transcript, complementary to subtelomeric tract of TERRA transcript but devoid of the repeats. [PMID:2139915]"
        },
        "SO:0001925": {
            "name": "ARIA",
            "def": "A non-coding RNA transcript, derived from the transcription of the telomere. These  transcripts consist of C rich repeats. [PMID:22139915]"
        },
        "SO:0001926": {
            "name": "anti_ARRET",
            "def": "A non-coding RNA transcript, derived from the transcription of the telomere. These  transcripts are antisense of ARRET transcripts. [PMID:22139915]"
        },
        "SO:0001927": {
            "name": "telomeric_transcript",
            "def": "A non-coding transcript derived from the transcript of the telomere. [PMID:22139915]"
        },
        "SO:0001928": {
            "name": "distal_duplication",
            "def": "A duplication of the distal region of a chromosome. [SO:bm]"
        },
        "SO:0001929": {
            "name": "mitochondrial_DNA_read",
            "def": "A sequencer read of a mitochondrial DNA sample. [GMOD:ea]"
        },
        "SO:0001930": {
            "name": "chloroplast_DNA_read",
            "def": "A sequencer read of a chloroplast DNA sample. [GMOD:ea]"
        },
        "SO:0001931": {
            "name": "consensus_gDNA",
            "def": "Genomic DNA sequence produced from some base calling or alignment algorithm which uses aligned or assembled multiple gDNA sequences as input. [GMOD:ea]"
        },
        "SO:0001932": {
            "name": "restriction_enzyme_five_prime_single_strand_overhang",
            "def": "A terminal region of DNA sequence where the end of the region is not blunt ended and the exposed single strand terminates at the 5' end. [SO:ke]"
        },
        "SO:0001933": {
            "name": "restriction_enzyme_three_prime_single_strand_overhang",
            "def": "A terminal region of DNA sequence where the end of the region is not blunt ended and the exposed single strand terminates at the 3' end. [SO:ke]"
        },
        "SO:0001934": {
            "name": "monomeric_repeat",
            "def": "A repeat_region containing repeat_units of 1 bp that is repeated multiple times in tandem. [SO:ke]"
        },
        "SO:0001935": {
            "name": "H3K20_trimethylation_site",
            "def": "A kind of histone modification site, whereby the 20th residue (a lysine), from the start of the H3 protein is tri-methylated. [EBI:nj]"
        },
        "SO:0001936": {
            "name": "H3K36_acetylation_site",
            "def": "A kind of histone modification site, whereby the 36th residue (a lysine), from the start of the H3 histone protein is acylated. [EBI:nj]"
        },
        "SO:0001937": {
            "name": "H2BK12_acetylation_site",
            "def": "A kind of histone modification site, whereby the 12th residue (a lysine), from the start of the H2B protein is methylated. [EBI:nj]"
        },
        "SO:0001938": {
            "name": "H2AK5_acetylation_site",
            "def": "A kind of histone modification site, whereby the 5th residue (a lysine), from the start of the H2A histone protein is acetylated. [EBI:nj]"
        },
        "SO:0001939": {
            "name": "H4K12_acetylation_site",
            "def": "A kind of histone modification site, whereby the 12th residue (a lysine), from the start of the H4 histone protein is acetylated. [EBI:nj]"
        },
        "SO:0001940": {
            "name": "H2BK120_acetylation_site",
            "def": "A kind of histone modification site, whereby the 120th residue (a lysine), from the start of the H2B histone protein is acetylated. [EBI:nj]"
        },
        "SO:0001941": {
            "name": "H4K91_acetylation_site",
            "def": "A kind of histone modification site, whereby the 91st residue (a lysine), from the start of the H4 histone protein is acetylated. [EBI:nj]"
        },
        "SO:0001942": {
            "name": "H2BK20_acetylation_site",
            "def": "A kind of histone modification site, whereby the 20th residue (a lysine), from the start of the H2B histone protein is acetylated. [EBI:nj]"
        },
        "SO:0001943": {
            "name": "H3K4ac_acetylation_site",
            "def": "A kind of histone modification site, whereby the 4th residue (a lysine), from the start of the H3 histone protein is acetylated. [EBI:nj]"
        },
        "SO:0001944": {
            "name": "H2AK9_acetylation_site",
            "def": "A kind of histone modification site, whereby the 9th residue (a lysine), from the start of the H2A histone protein is acetylated. [EBI:nj]"
        },
        "SO:0001945": {
            "name": "H3K56_acetylation_site",
            "def": "A kind of histone modification site, whereby the 56th residue (a lysine), from the start of the H3 histone protein is acetylated. [EBI:nj]"
        },
        "SO:0001946": {
            "name": "H2BK15_acetylation_site",
            "def": "A kind of histone modification site, whereby the 15th residue (a lysine), from the start of the H2B histone protein is acetylated. [EBI:nj]"
        },
        "SO:0001947": {
            "name": "H3R2_monomethylation_site",
            "def": "A kind of histone modification site, whereby the 2nd residue (an arginine), from the start of the H3 protein is mono-methylated. [EBI:nj]"
        },
        "SO:0001948": {
            "name": "H3R2_dimethylation_site",
            "def": "A kind of histone modification site, whereby the 2nd residue (an arginine), from the start of the H3 protein is di-methylated. [EBI:nj]"
        },
        "SO:0001949": {
            "name": "H4R3_dimethylation_site",
            "def": "A kind of histone modification site, whereby the 3nd residue (an arginine), from the start of the H4 protein is di-methylated. [EBI:nj]"
        },
        "SO:0001950": {
            "name": "H4K4_trimethylation_site",
            "def": "A kind of histone modification site, whereby the 4th residue (a lysine), from the start of the H4 protein is tri-methylated. [EBI:nj]"
        },
        "SO:0001951": {
            "name": "H3K23_dimethylation_site",
            "def": "A kind of histone modification site, whereby the 23rd residue (a lysine), from the start of the H3 protein is di-methylated. [EBI:nj]"
        },
        "SO:0001952": {
            "name": "promoter_flanking_region",
            "def": "A region immediately adjacent to a promoter which may or may not contain transcription factor binding sites. [EBI:nj]"
        },
        "SO:0001953": {
            "name": "restriction_enzyme_assembly_scar",
            "def": "A region of DNA sequence formed from the ligation of two sticky ends where the palindrome is broken and no longer comprises the recognition site and thus cannot be re-cut by the restriction enzymes used to create the sticky ends. [SO:ke]"
        },
        "SO:0001954": {
            "name": "restriction_enzyme_region",
            "def": "A region related to restriction enzyme function. [SO:ke]"
        },
        "SO:0001955": {
            "name": "protein_stability_element",
            "def": "A polypeptide region that proves structure in a protein that affects the stability of the protein. [SO:ke]"
        },
        "SO:0001956": {
            "name": "protease_site",
            "def": "A polypeptide_region that  codes for a protease cleavage site. [SO:ke]"
        },
        "SO:0001957": {
            "name": "RNA_stability_element",
            "def": "RNA secondary structure that affects the stability of an RNA molecule. [SO:ke]"
        },
        "SO:0001958": {
            "name": "lariat_intron",
            "def": "A kind of intron whereby the excision is driven by lariat formation. [SO:ke]"
        },
        "SO:0001959": {
            "name": "TCT_motif",
            "def": "A cis-regulatory element, conserved sequence YYC+1TTTYY, and spans -2 to +6 relative to +1 TSS. It is present in most ribosomal protein genes in Drosophila and mammals but not in the yeast Saccharomyces cerevisiae. Resembles the initiator (TCAKTY in Drosophila) but functionally distinct from initiator. [PMID:20801935, SO:myl]"
        },
        "SO:0001960": {
            "name": "5_hydroxymethylcytosine",
            "def": "A modified DNA cytosine base feature, modified by a hydroxymethyl group at the 5 carbon. [SO:ke]"
        },
        "SO:0001961": {
            "name": "5_formylcytosine",
            "def": "A modified DNA cytosine base feature, modified by a formyl group at the 5 carbon. [SO:ke]"
        },
        "SO:0001962": {
            "name": "modified_adenine",
            "def": "A modified adenine DNA base feature. [SO:ke]"
        },
        "SO:0001963": {
            "name": "modified_cytosine",
            "def": "A modified cytosine DNA base feature. [SO:ke]"
        },
        "SO:0001964": {
            "name": "modified_guanine",
            "def": "A modified guanine DNA base feature. [SO:ke]"
        },
        "SO:0001965": {
            "name": "8_oxoguanine",
            "def": "A modified DNA guanine base,at the 8 carbon, often the product of DNA damage. [SO:ke]"
        },
        "SO:0001966": {
            "name": "5_carboxylcytosine",
            "def": "A modified DNA cytosine base feature, modified by a carboxy group at the 5 carbon. [SO:ke]"
        },
        "SO:0001967": {
            "name": "8_oxoadenine",
            "def": "A modified DNA adenine base,at the 8 carbon, often the product of DNA damage. [SO:ke]"
        },
        "SO:0001968": {
            "name": "coding_transcript_variant",
            "def": "A transcript variant of a protein coding gene. [SO:ke]"
        },
        "SO:0001969": {
            "name": "coding_transcript_intron_variant",
            "def": "A transcript variant occurring within an intron of a coding transcript. [SO:ke]"
        },
        "SO:0001970": {
            "name": "non_coding_transcript_intron_variant",
            "def": "A transcript variant occurring within an intron of a non coding transcript. [SO:ke]"
        },
        "SO:0001971": {
            "name": "zinc_finger_binding_site"
        },
        "SO:0001972": {
            "name": "histone_4_acylation_site",
            "def": "A histone 4 modification where the modification is the acylation of the residue. [EBI:nj, SO:ke]"
        },
        "SO:0001973": {
            "name": "histone_3_acetylation_site",
            "def": "A histone 3 modification where the modification is the acylation of the residue. [EBI:nj, SO:ke]"
        },
        "SO:0001974": {
            "name": "CTCF_binding_site",
            "def": "A transcription factor binding site with consensus sequence CCGCGNGGNGGCAG, bound by CCCTF-binding factor. [EBI:nj]"
        },
        "SO:0001975": {
            "name": "five_prime_sticky_end_restriction_enzyme_cleavage_site",
            "def": "A restriction enzyme recognition site that, when cleaved, results in 5 prime overhangs. [SO:ke]"
        },
        "SO:0001976": {
            "name": "three_prime_sticky_end_restriction_enzyme_cleavage_site",
            "def": "A restriction enzyme recognition site that, when cleaved, results in 3 prime overhangs. [SO:ke]"
        },
        "SO:0001977": {
            "name": "ribonuclease_site",
            "def": "A region of a transcript encoding the cleavage site for a ribonuclease enzyme. [SO:ke]"
        },
        "SO:0001978": {
            "name": "signature",
            "def": "A region of  sequence where developer information is encoded. [SO:ke]"
        },
        "SO:0001979": {
            "name": "RNA_stability_element",
            "def": "A motif that affects the stability of RNA. [PMID:22495308, SO:ke]"
        },
        "SO:0001980": {
            "name": "G_box",
            "def": "A regulatory promoter element identified in mutation experiments, with consensus sequence: CACGTG. Present in promoters, intergenic regions, coding regions, and introns. They are involved in gene expression responses to light and interact with G-box binding factor and I-box binding factor 1a. [PMID:19249238, PMID:8571452, SO:ml]"
        },
        "SO:0001981": {
            "name": "L_box",
            "def": "An orientation dependent  regulatory promoter element, with consensus sequence of TTGCACAN4TTGCACA, found in plants. [PMID:17381552, PMID:2902624, SO:ml]"
        },
        "SO:0001982": {
            "name": "I-box",
            "def": "A plant regulatory promoter motif,  composed of a highly conserved hexamer GATAAG (I-box core). [PMID:2347304, PMID:2902624, SO:ml]"
        },
        "SO:0001983": {
            "name": "5_prime_UTR_premature_start_codon_variant",
            "def": "A 5' UTR variant where a premature start codon is introduced, moved or lost. [SANGER:am]"
        },
        "SO:0001984": {
            "name": "silent_mating_type_cassette_array",
            "def": "A gene cassette array that corresponds to a silenced version of a mating type region. [PomBase:mah]"
        },
        "SO:0001985": {
            "name": "Okazaki_fragment",
            "def": "Any of the DNA segments produced by discontinuous synthesis of the lagging strand during DNA replication. [ISBN:0805350152]"
        },
        "SO:0001986": {
            "name": "upstream_transcript_variant",
            "def": "A feature variant, where the alteration occurs upstream of the transcript TSS. [EBI:gr]"
        },
        "SO:0001987": {
            "name": "downstream_transcript_variant"
        },
        "SO:0001988": {
            "name": "5_prime_UTR_premature_start_codon_gain_variant",
            "def": "A 5' UTR variant where a premature start codon is gained. [Sanger:am]"
        },
        "SO:0001989": {
            "name": "5_prime_UTR_premature_start_codon_loss_variant",
            "def": "A 5' UTR variant where a premature start codon is lost. [SANGER:am]"
        },
        "SO:0001990": {
            "name": "five_prime_UTR_premature_start_codon_location_variant",
            "def": "A 5' UTR variant where a premature start codon is moved. [SANGER:am]"
        },
        "SO:0001991": {
            "name": "consensus_AFLP_fragment",
            "def": "A consensus AFLP fragment is an AFLP sequence produced from any alignment algorithm which uses assembled multiple AFLP sequences as input. [GMOD:ea]"
        },
        "SO:0001992": {
            "name": "nonsynonymous_variant",
            "def": "A non-synonymous variant is an inframe, protein altering variant, resulting in a codon change. [SO:ke]"
        },
        "SO:0001993": {
            "name": "extended_cis_splice_site",
            "def": "Intronic positions associated with cis-splicing. Contains the first and second positions immediately before the exon and the first, second and fifth positions immediately after. [SANGER:am]"
        },
        "SO:0001994": {
            "name": "intron_base_5",
            "def": "Fifth intronic position after the intron exon boundary, close to the 5' edge of the intron. [SANGER:am]"
        },
        "SO:0001995": {
            "name": "extended_intronic_splice_region_variant",
            "def": "A sequence variant occurring in the intron, within 10 bases of exon. [sanger:am]"
        },
        "SO:0001996": {
            "name": "extended_intronic_splice_region",
            "def": "Region of intronic sequence within 10 bases of an exon. [SANGER:am]"
        },
        "SO:0001997": {
            "name": "subtelomere",
            "def": "A heterochromatic region of the chromosome,  adjacent to the telomere (on the centromeric side) that contains repetitive DNA and sometimes genes and it is transcribed. [POMBE:al]"
        },
        "SO:0001998": {
            "name": "sgRNA",
            "def": "A small RNA oligo, typically about 20 bases, that guides the cas nuclease to a target DNA sequence in the CRISPR/cas mutagenesis method. [PMID:23934893]"
        },
        "SO:0001999": {
            "name": "mating_type_region_motif",
            "def": "DNA motif that is a component of a mating type region. [SO:ke]"
        },
        "SO:0002001": {
            "name": "Y_region",
            "def": "A segment of non-homology between a and alpha mating alleles, found at all three mating loci (HML, MAT, and HMR), has two forms (Ya and Yalpha). [SGD:jd]"
        },
        "SO:0002002": {
            "name": "Z1_region",
            "def": "A mating type region motif, one of two segments of homology found at all three mating loci (HML, MAT, and HMR). [SGD:jd]"
        },
        "SO:0002003": {
            "name": "Z2_region",
            "def": "A mating type region motif, the rightmost segment of homology in the HML and MAT mating loci (not present in HMR). [SGD:jd]"
        },
        "SO:0002004": {
            "name": "ARS_consensus_sequence",
            "def": "The ACS is an 11-bp sequence of the form 5'-WTTTAYRTTTW-3' which is at the core of every yeast ARS, and is necessary but not sufficient for recognition and binding by the origin recognition complex (ORC). Functional ARSs require an ACS, as well as other cis elements in the 5' (C domain) and 3' (B domain) flanking sequences of the ACS. [SGD:jd]"
        },
        "SO:0002005": {
            "name": "DSR_motif",
            "def": "The determinant of selective removal (DSR) motif consists of repeats of U(U/C)AAAC. The motif targets meiotic transcripts for removal during mitosis via the exosome. [PMID:22645662]"
        },
        "SO:0002006": {
            "name": "zinc_repressed_element",
            "def": "A promoter element that has the consensus sequence GNMGATC, and is found in promoters of genes repressed in the presence of zinc. [PMID:24003116, POMBE:mh]"
        },
        "SO:0002007": {
            "name": "MNV",
            "def": "An MNV is a multiple nucleotide variant (substitution) in which the inserted sequence is the same length as the replaced sequence. [NCBI:th]"
        },
        "SO:0002008": {
            "name": "rare_amino_acid_variant",
            "def": "A sequence variant whereby at least one base of a codon encoding a rare amino acid is changed, resulting in a different encoded amino acid. [SO:ke]"
        },
        "SO:0002009": {
            "name": "selenocysteine_loss",
            "def": "A sequence variant whereby at least one base of a codon encoding selenocysteine  is changed, resulting in a different encoded amino acid. [SO:ke]"
        },
        "SO:0002010": {
            "name": "pyrrolysine_loss",
            "def": "A sequence variant whereby at least one base of a codon encoding pyrrolysine is changed, resulting in a different encoded amino acid. [SO:ke]"
        },
        "SO:0002011": {
            "name": "intragenic_variant",
            "def": "A variant that occurs within a gene but falls outside of all transcript features. This occurs when alternate transcripts of a gene do not share overlapping  sequence. [SO:ke]"
        },
        "SO:0002012": {
            "name": "start_lost",
            "def": "A codon variant that changes at least one base of the canonical start codon. [SO:ke]"
        },
        "SO:0002013": {
            "name": "5_prime_UTR_truncation",
            "def": "A sequence variant that causes the reduction of a the 5'UTR  with regard to the reference sequence. [SO:ke]"
        },
        "SO:0002014": {
            "name": "5_prime_UTR_elongation",
            "def": "A sequence variant that causes the extension of 5' UTR, with regard to the reference sequence. [SO:ke]"
        },
        "SO:0002015": {
            "name": "3_prime_UTR_truncation",
            "def": "A sequence variant that causes the reduction of a the 3' UTR  with regard to the reference sequence. [SO:ke]"
        },
        "SO:0002016": {
            "name": "3_prime_UTR_elongation",
            "def": "A sequence variant that causes the extension of 3' UTR, with regard to the reference sequence. [SO:ke]"
        },
        "SO:0002017": {
            "name": "conserved_intergenic_variant",
            "def": "A sequence variant located in a conserved intergenic region, between genes. [SO:ke]"
        },
        "SO:0002018": {
            "name": "conserved_intron_variant",
            "def": "A transcript variant occurring within a conserved region of an intron. [SO:ke]"
        },
        "SO:0002019": {
            "name": "start_retained_variant",
            "def": "A sequence variant where at least one base in the start codon is changed, but the start remains. [SO:ke]"
        },
        "SO:0002020": {
            "name": "boundary_element",
            "def": "Boundary elements are DNA motifs that prevent heterochromatin from spreading into neighboring euchromatic regions. [PMID:24013502]"
        },
        "SO:0002021": {
            "name": "mating_type_region_replication_fork_barrier",
            "def": "A DNA motif that is found in eukaryotic rDNA repeats, and is a site of replication fork pausing. [PMID:17614787]"
        },
        "SO:0002022": {
            "name": "priRNA",
            "def": "A small RNA molecule, 22-23 nt in size, that is the product of a longer RNA. The production of priRNAs is independent of dicer and involves binding of RNA by argonaute and trimming by triman. In fission yeast, priRNAs trigger the establishment of heterochromatin. PriRNAs are primarily generated from centromeric transcripts (dg and dh repeats), but may also be produced from degradation products of primary transcripts. [PMID:20178743, PMID:24095277, PomBase:al]"
        },
        "SO:0002023": {
            "name": "multiplexing_sequence_identifier",
            "def": "A nucleic tag which is used in a ligation step of library preparation process to allow pooling of samples while maintaining ability to identify individual source material and creation of a multiplexed library. [OBO:prs, PMID:22574170]"
        },
        "SO:0002024": {
            "name": "W_region",
            "def": "The leftmost segment of homology in the HML and MAT mating loci,  but not present in HMR. [SGD:jd]"
        },
        "SO:0002025": {
            "name": "cis_acting_homologous_chromosome_pairing_region",
            "def": "A genome region where chromosome pairing occurs preferentially during homologous chromosome pairing during early meiotic prophase of Meiosis I. [PMID:22582262, PMID:23117617, PMID:24173580, PomBase:vw]"
        },
        "SO:0002026": {
            "name": "intein_encoding_region",
            "def": "The nucleotide sequence which encodes the intein portion of the precursor gene. [PMID:8165123]"
        },
        "SO:0002027": {
            "name": "uORF",
            "def": "A short open reading frame that is found in the 5' untranslated region of an mRNA and plays a role in translational regulation. [PMID:12890013, PMID:16153175, POMBASE:mah]"
        },
        "SO:0002028": {
            "name": "sORF",
            "def": "An open reading frame that encodes a peptide of less than 100 amino acids. [PMID:23970561, PMID:24705786, POMBASE:mah]"
        },
        "SO:0002029": {
            "name": "tnaORF",
            "def": "A translated ORF encoded entirely within the antisense strand of a known protein coding gene. [POMBASE:vw]"
        },
        "SO:0002030": {
            "name": "X_region",
            "def": "One of two segments of homology found at all three mating loci (HML, MAT and HMR). [SGD:jd]"
        },
        "SO:0002031": {
            "name": "shRNA",
            "def": "A short hairpin RNA (shRNA) is an RNA transcript that makes a tight hairpin turn that can be used to silence target gene expression via RNA interference. [PMID:6699500, SO:ke]"
        },
        "SO:0002032": {
            "name": "moR",
            "def": "A non-coding transcript encoded by sequences adjacent to the ends of the 5' and 3' miR-encoding sequences that abut the loop in precursor miRNA. [SO:ke]"
        },
        "SO:0002033": {
            "name": "loR",
            "def": "A short, non coding transcript of loop-derived sequences encoded in precursor miRNA. [SO:ke]"
        },
        "SO:0002034": {
            "name": "miR_encoding_snoRNA_primary_transcript",
            "def": "A snoRNA primary transcript that also encodes pre-miR sequence that is processed to form functionally active miRNA. [SO:ke]"
        },
        "SO:0002035": {
            "name": "lncRNA_primary_transcript",
            "def": "A primary transcript encoding a  lncRNA. [SO:ke]"
        },
        "SO:0002036": {
            "name": "miR_encoding_lncRNA_primary_transcript",
            "def": "A lncRNA primary transcript that also encodes pre-miR sequence that is processed to form functionally active miRNA. [SO:ke]"
        },
        "SO:0002037": {
            "name": "miR_encoding_tRNA_primary_transcript",
            "def": "A tRNA primary transcript that also encodes pre-miR sequence that is processed to form functionally active miRNA. [SO:ke]"
        },
        "SO:0002038": {
            "name": "shRNA_primary_transcript",
            "def": "A primary transcript encoding an shRNA. [SO:ke]"
        },
        "SO:0002039": {
            "name": "miR_encoding_shRNA_primary_transcript",
            "def": "A shRNA primary transcript that also encodes pre-miR sequence that is processed to form functionally active miRNA. [SO:ke]"
        },
        "SO:0002040": {
            "name": "vaultRNA_primary_transcript",
            "def": "A primary transcript encoding a  vaultRNA. [SO:ke]"
        },
        "SO:0002041": {
            "name": "miR_encoding_vaultRNA_primary_transcript",
            "def": "A vaultRNA primary transcript that also encodes pre-miR sequence that is processed to form functionally active miRNA. [SO:ke]"
        },
        "SO:0002042": {
            "name": "Y_RNA_primary_transcript",
            "def": "A primary transcript encoding a  Y-RNA. [SO:ke]"
        },
        "SO:0002043": {
            "name": "miR_encoding_Y_RNA_primary_transcript",
            "def": "A Y-RNA primary transcript that also encodes pre-miR sequence that is processed to form functionally active miRNA. [SO:ke]"
        },
        "SO:0002044": {
            "name": "TCS_element",
            "def": "A TCS element is a (yeast) transcription factor binding site, bound by the TEA DNA binding domain (DBD) of transcription factors. The consensus site is CATTCC or CATTCT. [PMID:1489142, PMID:20118212, SO:ke]"
        },
        "SO:0002045": {
            "name": "pheromone_response_element",
            "def": "A PRE is a (yeast) TFBS with consensus site [TGAAAC(A/G)]. [PMID:1489142, SO:ke]"
        },
        "SO:0002046": {
            "name": "FRE",
            "def": "A FRE is an enhancer element necessary and sufficient to confer filamentation associated expression in S. cerevisiae. [PMID:1489142, SO:ke]"
        },
        "SO:0002047": {
            "name": "transcription_pause_site",
            "def": "Transcription pause sites are regions of a gene where RNA polymerase may pause during transcription. The functional role of pausing may be to facilitate factor recruitment, RNA folding, and synchronization with translation. Consensus transcription pause site have been observed in E. coli. [PMID:24789973, SO:ke]"
        },
        "SO:0002048": {
            "name": "disabled_reading_frame",
            "def": "A reading frame that could encode a full-length protein but which contains obvious mid-sequence disablements (frameshifts or premature stop codons). [SGD:se]"
        },
        "SO:0002049": {
            "name": "H3K27_acetylation_site",
            "def": "A kind of histone modification site, whereby the 27th residue (a lysine), from the start of the H3 histone protein is acetylated. [SO:rs]"
        },
        "SO:0002050": {
            "name": "constitutive_promoter",
            "def": "A promoter that allows for continual transcription of gene. [SO:ke]"
        },
        "SO:0002051": {
            "name": "inducible_promoter",
            "def": "A promoter whereby activity is induced by the presence or absence of biotic or abiotic factors. [SO:ke]"
        },
        "SO:0002052": {
            "name": "dominant_negative_variant",
            "def": "A variant where the mutated gene product adversely affects the other (wild type) gene product. [SO:ke]"
        },
        "SO:0002053": {
            "name": "gain_of_function_variant",
            "def": "A sequence variant whereby new or enhanced function is conferred on the gene product. [SO:ke]"
        },
        "SO:0002054": {
            "name": "loss_of_function_variant",
            "def": "A sequence variant whereby the gene product has diminished or abolished function. [SO:ke]"
        },
        "SO:0002055": {
            "name": "null_mutation",
            "def": "A variant whereby the gene product is not functional or the gene product is not produced. [SO:ke]"
        },
        "SO:0002056": {
            "name": "intronic_splicing_silencer",
            "def": "An intronic  splicing regulatory element that functions to recruit trans acting splicing factors suppress the transcription of the gene or genes they control. [PMID:23241926, SO:ke]"
        },
        "SO:0002057": {
            "name": "intronic_splicing_enhancer"
        },
        "SO:0002058": {
            "name": "exonic_splicing_silencer",
            "def": "An exonic  splicing regulatory element that functions to recruit trans acting splicing factors suppress the transcription of the gene or genes they control. [PMID:23241926, SO:ke]"
        },
        "SO:0002059": {
            "name": "recombination_enhancer",
            "def": "A regulatory_region that promotes or induces the process of recombination. [PMID:8861911, SGD:se]"
        },
        "SO:0002060": {
            "name": "interchomosomal_translocation",
            "def": "A translocation where the regions involved are from different chromosomes. [NCBI:th]"
        },
        "SO:0002061": {
            "name": "intrachomosomal_translocation",
            "def": "A translocation where the regions involved are from the same chromosome. [NCBI:th]"
        },
        "SO:0002062": {
            "name": "complex_chromosomal_rearrangement",
            "def": "A contiguous cluster of translocations, usually the result of a single catastrophic event such as chromothripsis or chromoanasynthesis. [NCBI:th]"
        },
        "SO:0002063": {
            "name": "alu_insertion",
            "def": "An insertion of sequence from the Alu family of mobile elements. [NCBI:th]"
        },
        "SO:0002064": {
            "name": "LINE1_insertion",
            "def": "An insertion from the Line1 family of mobile elements. [NCBI:th]"
        },
        "SO:0002065": {
            "name": "SVA_insertion",
            "def": "An insertion of sequence from the SVA family of mobile elements. [NCBI:th]"
        },
        "SO:0005836": {
            "name": "regulatory_region",
            "def": "A region of sequence that is involved in the control of a biological process. [SO:ke]"
        },
        "SO:0005837": {
            "name": "U14_snoRNA_primary_transcript",
            "def": "The primary transcript of an evolutionarily conserved eukaryotic low molecular weight RNA capable of intermolecular hybridization with both homologous and heterologous 18S rRNA. [PMID:2251119]"
        },
        "SO:0005841": {
            "name": "methylation_guide_snoRNA",
            "def": "A snoRNA that specifies the site of 2'-O-ribose methylation in an RNA molecule by base pairing with a short sequence around the target residue. [GOC:mah, PMID:12457565]"
        },
        "SO:0005843": {
            "name": "rRNA_cleavage_RNA",
            "def": "An ncRNA that is part of a ribonucleoprotein that cleaves the primary pre-rRNA transcript in the process of producing mature rRNA molecules. [GOC:kgc]"
        },
        "SO:0005845": {
            "name": "exon_of_single_exon_gene",
            "def": "An exon that is the only exon in a gene. [RSC:cb]"
        },
        "SO:0005847": {
            "name": "cassette_array_member"
        },
        "SO:0005848": {
            "name": "gene_cassette_member"
        },
        "SO:0005849": {
            "name": "gene_subarray_member"
        },
        "SO:0005850": {
            "name": "primer_binding_site",
            "def": "Non-covalent primer binding site for initiation of replication, transcription, or reverse transcription. [http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html]"
        },
        "SO:0005851": {
            "name": "gene_array",
            "def": "An array includes two or more genes, or two or more gene subarrays, contiguously arranged where the individual genes, or subarrays, are either identical in sequence, or essentially so. [SO:ma]"
        },
        "SO:0005852": {
            "name": "gene_subarray",
            "def": "A subarray is, by defintition, a member of a gene array (SO:0005851); the members of a subarray may differ substantially in sequence, but are closely related in function. [SO:ma]"
        },
        "SO:0005853": {
            "name": "gene_cassette",
            "def": "A gene that can be substituted for a related gene at a different site in the genome. [SGD:se]"
        },
        "SO:0005854": {
            "name": "gene_cassette_array",
            "def": "An array of non-functional genes whose members, when captured by recombination form functional genes. [SO:ma]"
        },
        "SO:0005855": {
            "name": "gene_group",
            "def": "A collection of related genes. [SO:ma]"
        },
        "SO:0005856": {
            "name": "selenocysteine_tRNA_primary_transcript",
            "def": "A primary transcript encoding seryl tRNA (SO:000269). [SO:ke]"
        },
        "SO:0005857": {
            "name": "selenocysteinyl_tRNA",
            "def": "A tRNA sequence that has a selenocysteine anticodon, and a 3' selenocysteine binding region. [SO:ke]"
        },
        "SO:0005858": {
            "name": "syntenic_region",
            "def": "A region in which two or more pairs of homologous markers occur on the same chromosome in two or more species. [http://www.informatics.jax.org/silverbook/glossary.shtml]"
        },
        "SO:0100001": {
            "name": "biochemical_region_of_peptide",
            "def": "A region of a peptide that is involved in a biochemical function. [EBIBS:GAR]"
        },
        "SO:0100002": {
            "name": "molecular_contact_region",
            "def": "A region that is involved a contact with another molecule. [EBIBS:GAR]"
        },
        "SO:0100003": {
            "name": "intrinsically_unstructured_polypeptide_region",
            "def": "A region of polypeptide chain with high conformational flexibility. [EBIBS:GAR]"
        },
        "SO:0100004": {
            "name": "catmat_left_handed_three",
            "def": "A motif of 3 consecutive residues with dihedral angles as follows: res i: phi -90 bounds -120 to -60, res i: psi -10 bounds -50 to 30, res i+1: phi -75 bounds -100 to -50, res i+1: psi 140 bounds 110 to 170. An extra restriction of the length of the O to O distance would be useful, that it be less than 5 Angstrom. More precisely these two oxygens are the main chain carbonyl oxygen atoms of residues i-1 and i+1. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0100005": {
            "name": "catmat_left_handed_four",
            "def": "A motif of 4 consecutive residues with dihedral angles as follows: res i: phi -90 bounds -120 to -60, res i psi -10 bounds -50 to 30, res i+1: phi -90 bounds -120 to -60, res i+1: psi -10 bounds -50 to 30, res i+2: phi -75 bounds -100 to -50, res i+2: psi 140 bounds 110 to 170.  The extra restriction of the length of the O to O distance is similar, that it be less than 5 Angstrom. In this case these two Oxygen atoms are the main chain carbonyl oxygen atoms of residues i-1 and i+2. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0100006": {
            "name": "catmat_right_handed_three",
            "def": "A motif of 3 consecutive residues with dihedral angles as follows: res i: phi -90 bounds -120 to -60, res i: psi -10 bounds -50 to 30, res i+1: phi -75 bounds -100 to -50, res i+1: psi 140 bounds 110 to 170. An extra restriction of the length of the O to O distance would be useful, that it be less than 5 Angstrom. More precisely these two oxygens are the main chain carbonyl oxygen atoms of residues i-1 and i+1. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0100007": {
            "name": "catmat_right_handed_four",
            "def": "A motif of 4 consecutive residues with dihedral angles as follows: res i: phi -90 bounds -120 to -60, res i: psi -10 bounds -50 to 30, res i+1: phi -90 bounds -120 to -60, res i+1: psi -10 bounds -50 to 30, res i+2: phi -75 bounds -100 to -50, res i+2: psi 140 bounds 110 to 170. The extra restriction of the length of the O to O distance is similar, that it be less than 5 Angstrom. In this case these two Oxygen atoms are the main chain carbonyl oxygen atoms of residues i-1 and i+2. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0100008": {
            "name": "alpha_beta_motif",
            "def": "A motif of five consecutive residues and two H-bonds in which: H-bond between CO of residue(i) and NH of residue(i+4), H-bond between CO of residue(i) and NH of residue(i+3),Phi angles of residues(i+1), (i+2) and (i+3) are negative. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]"
        },
        "SO:0100009": {
            "name": "lipoprotein_signal_peptide",
            "def": "A peptide that acts as a signal for both membrane translocation and lipid attachment in prokaryotes. [EBIBS:GAR]"
        },
        "SO:0100010": {
            "name": "no_output",
            "def": "An experimental region wherean analysis has been run and not produced any annotation. [EBIBS:GAR]"
        },
        "SO:0100011": {
            "name": "cleaved_peptide_region",
            "def": "The cleaved_peptide_region is the region of a peptide sequence that is cleaved during maturation. [EBIBS:GAR]"
        },
        "SO:0100012": {
            "name": "peptide_coil",
            "def": "Irregular, unstructured regions of a protein's backbone, as distinct from the regular region (namely alpha helix and beta strand - characterised by specific patterns of main-chain hydrogen bonds). [EBIBS:GAR]"
        },
        "SO:0100013": {
            "name": "hydrophobic_region_of_peptide",
            "def": "Hydrophobic regions are regions with a low affinity for water. [EBIBS:GAR]"
        },
        "SO:0100014": {
            "name": "n_terminal_region",
            "def": "The amino-terminal positively-charged region of a signal peptide (approx 1-5 aa). [EBIBS:GAR]"
        },
        "SO:0100015": {
            "name": "c_terminal_region",
            "def": "The more polar, carboxy-terminal region of the signal peptide (approx 3-7 aa). [EBIBS:GAR]"
        },
        "SO:0100016": {
            "name": "central_hydrophobic_region_of_signal_peptide",
            "def": "The central, hydrophobic region of the signal peptide (approx 7-15 aa). [EBIBS:GAR]"
        },
        "SO:0100017": {
            "name": "polypeptide_conserved_motif",
            "def": "A conserved motif is a short (up to 20 amino acids) region of biological interest that is conserved in different proteins. They may or may not have functional or structural significance within the proteins in which they are found. [EBIBS:GAR]"
        },
        "SO:0100018": {
            "name": "polypeptide_binding_motif",
            "def": "A polypeptide binding motif is a short (up to 20 amino acids) polypeptide region of biological interest that contains one or more amino acids experimentally shown to bind to a ligand. [EBIBS:GAR]"
        },
        "SO:0100019": {
            "name": "polypeptide_catalytic_motif",
            "def": "A polypeptide catalytic motif is a short (up to 20 amino acids) polypeptide region that contains one or more active site residues. [EBIBS:GAR]"
        },
        "SO:0100020": {
            "name": "polypeptide_DNA_contact",
            "def": "A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with DNA. [EBIBS:GAR, SO:ke]"
        },
        "SO:0100021": {
            "name": "polypeptide_conserved_region",
            "def": "A subsection of sequence with biological interest that is conserved in different proteins. They may or may not have functional or structural significance within the proteins in which they are found. [EBIBS:GAR]"
        },
        "SO:1000002": {
            "name": "substitution",
            "def": "A sequence alteration where the length of the change in the variant is the same as that of the reference. [SO:ke]"
        },
        "SO:1000005": {
            "name": "complex_substitution",
            "def": "When no simple or well defined DNA mutation event describes the observed DNA change, the keyword \\complex\\ should be used. Usually there are multiple equally plausible explanations for the change. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000008": {
            "name": "point_mutation",
            "def": "A single nucleotide change which has occurred at the same position of a corresponding nucleotide in a reference sequence. [SO:immuno_workshop]"
        },
        "SO:1000009": {
            "name": "transition",
            "def": "Change of a pyrimidine nucleotide, C or T, into an other pyrimidine nucleotide, or change of a purine nucleotide, A or G, into an other purine nucleotide. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000010": {
            "name": "pyrimidine_transition",
            "def": "A substitution of a pyrimidine, C or T, for another pyrimidine. [SO:ke]"
        },
        "SO:1000011": {
            "name": "C_to_T_transition",
            "def": "A transition of a cytidine to a thymine. [SO:ke]"
        },
        "SO:1000012": {
            "name": "C_to_T_transition_at_pCpG_site",
            "def": "The transition of cytidine to thymine occurring at a pCpG site as a consequence of the spontaneous deamination of 5'-methylcytidine. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000013": {
            "name": "T_to_C_transition"
        },
        "SO:1000014": {
            "name": "purine_transition",
            "def": "A substitution of a purine, A or G, for another purine. [SO:ke]"
        },
        "SO:1000015": {
            "name": "A_to_G_transition",
            "def": "A transition of an adenine to a guanine. [SO:ke]"
        },
        "SO:1000016": {
            "name": "G_to_A_transition",
            "def": "A transition of a guanine to an adenine. [SO:ke]"
        },
        "SO:1000017": {
            "name": "transversion",
            "def": "Change of a pyrimidine nucleotide, C or T, into a purine nucleotide, A or G, or vice versa. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000018": {
            "name": "pyrimidine_to_purine_transversion",
            "def": "Change of a pyrimidine nucleotide, C or T, into a purine nucleotide, A or G. [SO:ke]"
        },
        "SO:1000019": {
            "name": "C_to_A_transversion",
            "def": "A transversion from cytidine to adenine. [SO:ke]"
        },
        "SO:1000020": {
            "name": "C_to_G_transversion"
        },
        "SO:1000021": {
            "name": "T_to_A_transversion",
            "def": "A transversion from T to A. [SO:ke]"
        },
        "SO:1000022": {
            "name": "T_to_G_transversion",
            "def": "A transversion from T to G. [SO:ke]"
        },
        "SO:1000023": {
            "name": "purine_to_pyrimidine_transversion",
            "def": "Change of a purine nucleotide, A or G , into a pyrimidine nucleotide C or T. [SO:ke]"
        },
        "SO:1000024": {
            "name": "A_to_C_transversion",
            "def": "A transversion from adenine to cytidine. [SO:ke]"
        },
        "SO:1000025": {
            "name": "A_to_T_transversion",
            "def": "A transversion from adenine to thymine. [SO:ke]"
        },
        "SO:1000026": {
            "name": "G_to_C_transversion",
            "def": "A transversion from guanine to cytidine. [SO:ke]"
        },
        "SO:1000027": {
            "name": "G_to_T_transversion",
            "def": "A transversion from guanine to thymine. [SO:ke]"
        },
        "SO:1000028": {
            "name": "intrachromosomal_mutation",
            "def": "A chromosomal structure variation within a single chromosome. [SO:ke]"
        },
        "SO:1000029": {
            "name": "chromosomal_deletion",
            "def": "An incomplete chromosome. [SO:ke]"
        },
        "SO:1000030": {
            "name": "chromosomal_inversion",
            "def": "An interchromosomal mutation where a region of the chromosome is inverted with respect to wild type. [SO:ke]"
        },
        "SO:1000031": {
            "name": "interchromosomal_mutation",
            "def": "A chromosomal structure variation whereby more than one chromosome is involved. [SO:ke]"
        },
        "SO:1000032": {
            "name": "indel",
            "def": "A sequence alteration which included an insertion and a deletion, affecting 2 or more bases. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html, http:http://www.hgvs.org/mutnomen/recs-DNA.html#indel]"
        },
        "SO:1000035": {
            "name": "duplication",
            "def": "An insertion which derives from, or is identical in sequence to, nucleotides present at a known location in the genome. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html, NCBI:th]"
        },
        "SO:1000036": {
            "name": "inversion",
            "def": "A continuous nucleotide sequence is inverted in the same position. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000037": {
            "name": "chromosomal_duplication",
            "def": "An extra chromosome. [SO:ke]"
        },
        "SO:1000038": {
            "name": "intrachromosomal_duplication",
            "def": "A duplication that occurred within a chromosome. [SO:ke]"
        },
        "SO:1000039": {
            "name": "direct_tandem_duplication",
            "def": "A tandem duplication where the individual regions are in the same orientation. [SO:ke]"
        },
        "SO:1000040": {
            "name": "inverted_tandem_duplication",
            "def": "A tandem duplication where the individual regions are not in the same orientation. [SO:ke]"
        },
        "SO:1000041": {
            "name": "intrachromosomal_transposition",
            "def": "A chromosome structure variation whereby a transposition occurred within a chromosome. [SO:ke]"
        },
        "SO:1000042": {
            "name": "compound_chromosome",
            "def": "A chromosome structure variant where a monocentric element is caused by the fusion of two chromosome arms. [SO:ke]"
        },
        "SO:1000043": {
            "name": "Robertsonian_fusion",
            "def": "A non reciprocal translocation whereby the participating chromosomes break at their centromeres and the long arms fuse to form a single chromosome with a single centromere. [http://en.wikipedia.org/wiki/Robertsonian_translocation]"
        },
        "SO:1000044": {
            "name": "chromosomal_translocation",
            "def": "An interchromosomal mutation. Rearrangements that alter the pairing of telomeres are classified as translocations. [FB:reference_manual]"
        },
        "SO:1000045": {
            "name": "ring_chromosome",
            "def": "A ring chromosome is a chromosome whose arms have fused together to form a ring, often with the loss of the ends of the chromosome. [http://en.wikipedia.org/wiki/Ring_chromosome]"
        },
        "SO:1000046": {
            "name": "pericentric_inversion",
            "def": "A chromosomal inversion that includes the centromere. [FB:reference_manual]"
        },
        "SO:1000047": {
            "name": "paracentric_inversion",
            "def": "A chromosomal inversion that does not include the centromere. [FB:reference_manual]"
        },
        "SO:1000048": {
            "name": "reciprocal_chromosomal_translocation",
            "def": "A chromosomal translocation with two breaks; two chromosome segments have simply been exchanged. [FB:reference_manual]"
        },
        "SO:1000049": {
            "name": "sequence_variation_affecting_transcript",
            "def": "Any change in mature, spliced and processed, RNA that results from a change in the corresponding DNA sequence. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000050": {
            "name": "sequence_variant_causing_no_change_in_transcript",
            "def": "No effect on the state of the RNA. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000054": {
            "name": "sequence_variation_affecting_coding_sequence",
            "def": "Any of the amino acid coding triplets of a gene are affected by the DNA mutation. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000055": {
            "name": "sequence_variant_causing_initiator_codon_change_in_transcript",
            "def": "The DNA mutation changes, usually destroys, the first coding triplet of a gene. Usually prevents translation although another initiator codon may be used. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000056": {
            "name": "sequence_variant_causing_amino_acid_coding_codon_change_in_transcript",
            "def": "The DNA mutation affects the amino acid coding sequence of a gene; this region includes both the initiator and terminator codons. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000057": {
            "name": "sequence_variant_causing_synonymous_codon_change_in_transcript",
            "def": "The changed codon has the same translation product as the original codon. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000058": {
            "name": "sequence_variant_causing_non_synonymous_codon_change_in_transcript",
            "def": "A DNA point mutation that causes a substitution of an amino acid by an other. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000059": {
            "name": "sequence_variant_causing_missense_codon_change_in_transcript",
            "def": "The nucleotide change in the codon leads to a new codon coding for a new amino acid. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000060": {
            "name": "sequence_variant_causing_conservative_missense_codon_change_in_transcript",
            "def": "The amino acid change following from the codon change does not change the gross properties (size, charge, hydrophobicity) of the amino acid at that position. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000061": {
            "name": "sequence_variant_causing_nonconservative_missense_codon_change_in_transcript",
            "def": "The amino acid change following from the codon change changes the gross properties (size, charge, hydrophobicity) of the amino acid in that position. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000062": {
            "name": "sequence_variant_causing_nonsense_codon_change_in_transcript",
            "def": "The nucleotide change in the codon triplet creates a terminator codon. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000063": {
            "name": "sequence_variant_causing_terminator_codon_change_in_transcript",
            "def": "The nucleotide change in the codon triplet changes the stop codon, causing an elongated transcript sequence. [SO:ke]"
        },
        "SO:1000064": {
            "name": "sequence_variation_affecting_reading_frame",
            "def": "An umbrella term for terms describing an effect of a sequence variation on the frame of translation. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000065": {
            "name": "frameshift_sequence_variation",
            "def": "A mutation causing a disruption of the translational reading frame, because the number of nucleotides inserted or deleted is not a multiple of three. [SO:ke]"
        },
        "SO:1000066": {
            "name": "sequence_variant_causing_plus_1_frameshift_mutation",
            "def": "A mutation causing a disruption of the translational reading frame, due to the insertion of a nucleotide. [SO:ke]"
        },
        "SO:1000067": {
            "name": "sequence_variant_causing_minus_1_frameshift",
            "def": "A mutation causing a disruption of the translational reading frame, due to the deletion of a nucleotide. [SO:ke]"
        },
        "SO:1000068": {
            "name": "sequence_variant_causing_plus_2_frameshift",
            "def": "A mutation causing a disruption of the translational reading frame, due to the insertion of two nucleotides. [SO:ke]"
        },
        "SO:1000069": {
            "name": "sequence_variant_causing_minus_2_frameshift",
            "def": "A mutation causing a disruption of the translational reading frame, due to the deletion of two nucleotides. [SO:ke]"
        },
        "SO:1000070": {
            "name": "sequence_variant_affecting_transcript_processing",
            "def": "Sequence variant affects the way in which the primary transcriptional product is processed to form the mature transcript. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000071": {
            "name": "sequence_variant_affecting_splicing",
            "def": "A sequence_variant_effect where the way in which the primary transcriptional product is processed to form the mature transcript, specifically by the removal (splicing) of intron sequences is changed. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000072": {
            "name": "sequence_variant_affecting_splice_donor",
            "def": "A sequence_variant_effect that changes the splice donor sequence. [SO:ke]"
        },
        "SO:1000073": {
            "name": "sequence_variant_affecting_splice_acceptor",
            "def": "A sequence_variant_effect that changes the splice acceptor sequence. [SO:ke]"
        },
        "SO:1000074": {
            "name": "sequence_variant_causing_cryptic_splice_activation",
            "def": "A sequence variant causing a new (functional) splice site. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000075": {
            "name": "sequence_variant_affecting_editing",
            "def": "Sequence variant affects the editing of the transcript. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000076": {
            "name": "sequence_variant_affecting_transcription",
            "def": "Mutation affects the process of transcription, its initiation, progression or termination. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000078": {
            "name": "sequence_variant_decreasing_rate_of_transcription",
            "def": "A sequence variation that decreases the rate a which transcription of the sequence occurs. [SO:ke]"
        },
        "SO:1000079": {
            "name": "sequence_variation_affecting_transcript_sequence"
        },
        "SO:1000080": {
            "name": "sequence_variant_increasing_rate_of_transcription"
        },
        "SO:1000081": {
            "name": "sequence_variant_affecting_rate_of_transcription",
            "def": "A mutation that alters the rate a which transcription of the sequence occurs. [SO:ke]"
        },
        "SO:1000082": {
            "name": "sequence variant_affecting_transcript_stability",
            "def": "Sequence variant affects the stability of the transcript. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000083": {
            "name": "sequence_variant_increasing_transcript_stability",
            "def": "Sequence variant increases the stability (half-life) of the transcript. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000084": {
            "name": "sequence_variant_decreasing_transcript_stability",
            "def": "Sequence variant decreases the stability (half-life) of the transcript. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000085": {
            "name": "sequence_variation_affecting_level_of_transcript",
            "def": "A sequence variation that causes a change in the level of mature, spliced and processed RNA, resulting from a change in the corresponding DNA sequence. [SO:ke]"
        },
        "SO:1000086": {
            "name": "sequence_variation_decreasing_level_of_transcript",
            "def": "A sequence variation that causes a decrease in the level of mature, spliced and processed RNA, resulting from a change in the corresponding DNA sequence. [SO:ke]"
        },
        "SO:1000087": {
            "name": "sequence_variation_increasing_level_of_transcript",
            "def": "A sequence_variation that causes an increase in the level of mature, spliced and processed RNA, resulting from a change in the corresponding DNA sequence. [SO:ke]"
        },
        "SO:1000088": {
            "name": "sequence_variant_affecting_translational_product",
            "def": "A sequence variant causing a change in primary translation product of a transcript. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000089": {
            "name": "sequence_variant_causing_no_change_of_translational_product",
            "def": "The sequence variant at RNA level does not lead to any change in polypeptide. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000092": {
            "name": "sequence_variant_causing_complex_change_of_translational_product",
            "def": "Any sequence variant effect that is known at nucleotide level but cannot be explained by using other key terms. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000093": {
            "name": "sequence_variant_causing_amino_acid_substitution",
            "def": "The replacement of a single amino acid by another. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000094": {
            "name": "sequence_variant_causing_conservative_amino_acid_substitution"
        },
        "SO:1000095": {
            "name": "sequence_variant_causing_nonconservative_amino_acid_substitution"
        },
        "SO:1000096": {
            "name": "sequence_variant_causing_amino_acid_insertion",
            "def": "The insertion of one or more amino acids from the polypeptide, without affecting the surrounding sequence. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000097": {
            "name": "sequence_variant_causing_amino_acid_deletion",
            "def": "The deletion of one or more amino acids from the polypeptide, without affecting the surrounding sequence. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000098": {
            "name": "sequence_variant_causing_polypeptide_truncation",
            "def": "The translational product is truncated at its C-terminus, usually a result of a nonsense codon change in transcript (SO:1000062). [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000099": {
            "name": "sequence_variant_causing_polypeptide_elongation",
            "def": "The extension of the translational product at either (or both) the N-terminus and/or the C-terminus. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000100": {
            "name": "mutation_causing_polypeptide_N_terminal_elongation",
            "def": ". [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000101": {
            "name": "mutation_causing_polypeptide_C_terminal_elongation",
            "def": ". [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000102": {
            "name": "sequence_variant_affecting_level_of_translational_product"
        },
        "SO:1000103": {
            "name": "sequence_variant_decreasing_level_of_translation_product"
        },
        "SO:1000104": {
            "name": "sequence_variant_increasing_level_of_translation_product"
        },
        "SO:1000105": {
            "name": "sequence_variant_affecting_polypeptide_amino_acid_sequence"
        },
        "SO:1000106": {
            "name": "mutation_causing_inframe_polypeptide_N_terminal_elongation"
        },
        "SO:1000107": {
            "name": "mutation_causing_out_of_frame_polypeptide_N_terminal_elongation"
        },
        "SO:1000108": {
            "name": "mutaton_causing_inframe_polypeptide_C_terminal_elongation"
        },
        "SO:1000109": {
            "name": "mutation_causing_out_of_frame_polypeptide_C_terminal_elongation"
        },
        "SO:1000110": {
            "name": "frame_restoring_sequence_variant",
            "def": "A mutation that reverts the sequence of a previous frameshift mutation back to the initial frame. [SO:ke]"
        },
        "SO:1000111": {
            "name": "sequence_variant_affecting_3D_structure_of_polypeptide",
            "def": "A mutation that changes the amino acid sequence of the peptide in such a way that it changes the 3D structure of the molecule. [SO:ke]"
        },
        "SO:1000112": {
            "name": "sequence_variant_causing_no_3D_structural_change"
        },
        "SO:1000115": {
            "name": "sequence_variant_causing_complex_3D_structural_change"
        },
        "SO:1000116": {
            "name": "sequence_variant_causing_conformational_change"
        },
        "SO:1000117": {
            "name": "sequence_variant_affecting_polypeptide_function"
        },
        "SO:1000118": {
            "name": "sequence_variant_causing_loss_of_function_of_polypeptide"
        },
        "SO:1000119": {
            "name": "sequence_variant_causing_inactive_ligand_binding_site"
        },
        "SO:1000120": {
            "name": "sequence_variant_causing_inactive_catalytic_site"
        },
        "SO:1000121": {
            "name": "sequence_variant_causing_polypeptide_localization_change"
        },
        "SO:1000122": {
            "name": "sequence_variant_causing_polypeptide_post_translational_processing_change"
        },
        "SO:1000123": {
            "name": "polypeptide_post_translational_processing_affected"
        },
        "SO:1000124": {
            "name": "sequence_variant_causing_partial_loss_of_function_of_polypeptide"
        },
        "SO:1000125": {
            "name": "sequence_variant_causing_gain_of_function_of_polypeptide"
        },
        "SO:1000126": {
            "name": "sequence_variant_affecting_transcript_secondary_structure",
            "def": "A sequence variant that affects the secondary structure (folding) of the RNA transcript molecule. [SO:ke]"
        },
        "SO:1000127": {
            "name": "sequence_variant_causing_compensatory_transcript_secondary_structure_mutation"
        },
        "SO:1000132": {
            "name": "sequence_variant_effect",
            "def": "The effect of a change in nucleotide sequence. [SO:ke]"
        },
        "SO:1000134": {
            "name": "sequence_variant_causing_polypeptide_fusion"
        },
        "SO:1000136": {
            "name": "autosynaptic_chromosome",
            "def": "An autosynaptic chromosome is the aneuploid product of recombination between a pericentric inversion and a cytologically wild-type chromosome. [PMID:6804304]"
        },
        "SO:1000138": {
            "name": "homo_compound_chromosome",
            "def": "A compound chromosome whereby two copies of the same chromosomal arm attached to a common centromere. The chromosome is diploid for the arm involved. [SO:ke]"
        },
        "SO:1000140": {
            "name": "hetero_compound_chromosome",
            "def": "A compound chromosome whereby two arms from different chromosomes are connected through the centromere of one of them. [FB:reference_manual, SO:ke]"
        },
        "SO:1000141": {
            "name": "chromosome_fission",
            "def": "A chromosome that occurred by the division of a larger chromosome. [SO:ke]"
        },
        "SO:1000142": {
            "name": "dexstrosynaptic_chromosome",
            "def": "An autosynaptic chromosome carrying the two right (D = dextro) telomeres. [FB:manual]"
        },
        "SO:1000143": {
            "name": "laevosynaptic_chromosome",
            "def": "LS is an autosynaptic chromosome carrying the two left (L = levo) telomeres. [FB:manual]"
        },
        "SO:1000144": {
            "name": "free_duplication",
            "def": "A chromosome structure variation whereby the duplicated sequences are carried as a free centric element. [FB:reference_manual]"
        },
        "SO:1000145": {
            "name": "free_ring_duplication",
            "def": "A ring chromosome which is a copy of another chromosome. [SO:ke]"
        },
        "SO:1000147": {
            "name": "deficient_translocation",
            "def": "A chromosomal deletion whereby a translocation occurs in which one of the four broken ends loses a segment before re-joining. [FB:reference_manual]"
        },
        "SO:1000148": {
            "name": "inversion_cum_translocation",
            "def": "A chromosomal translocation whereby the first two breaks are in the same chromosome, and the region between them is rejoined in inverted order to the other side of the first break, such that both sides of break one are present on the same chromosome. The remaining free ends are joined as a translocation with those resulting from the third break. [FB:reference_manual]"
        },
        "SO:1000149": {
            "name": "bipartite_duplication",
            "def": "An interchromosomal mutation whereby the (large) region between the first two breaks listed is lost, and the two flanking segments (one of them centric) are joined as a translocation to the free ends resulting from the third break. [FB:reference_manual]"
        },
        "SO:1000150": {
            "name": "cyclic_translocation",
            "def": "A chromosomal translocation whereby three breaks occurred in three different chromosomes. The centric segment resulting from the first break listed is joined to the acentric segment resulting from the second, rather than the third. [FB:reference_manual]"
        },
        "SO:1000151": {
            "name": "bipartite_inversion",
            "def": "A chromosomal inversion caused by three breaks in the same chromosome; both central segments are inverted in place (i.e., they are not transposed). [FB:reference_manual]"
        },
        "SO:1000152": {
            "name": "uninverted_insertional_duplication",
            "def": "An insertional duplication where a copy of the segment between the first two breaks listed is inserted at the third break; the insertion is in cytologically the same orientation as its flanking segments. [FB:reference_manual]"
        },
        "SO:1000153": {
            "name": "inverted_insertional_duplication",
            "def": "An insertional duplication where a copy of the segment between the first two breaks listed is inserted at the third break; the insertion is in cytologically inverted orientation with respect to its flanking segments. [FB:reference_manual]"
        },
        "SO:1000154": {
            "name": "insertional_duplication",
            "def": "A chromosome duplication involving the insertion of a duplicated region (as opposed to a free duplication). [SO:ke]"
        },
        "SO:1000155": {
            "name": "interchromosomal_transposition",
            "def": "A chromosome structure variation whereby a transposition occurred between chromosomes. [SO:ke]"
        },
        "SO:1000156": {
            "name": "inverted_interchromosomal_transposition",
            "def": "An interchromosomal transposition whereby a copy of the segment between the first two breaks listed is inserted at the third break; the insertion is in cytologically inverted orientation with respect to its flanking segment. [FB:reference_manual]"
        },
        "SO:1000157": {
            "name": "uninverted_interchromosomal_transposition",
            "def": "An interchromosomal transition where the segment between the first two breaks listed is removed and inserted at the third break; the insertion is in cytologically the same orientation as its flanking segments. [FB:reference_manual]"
        },
        "SO:1000158": {
            "name": "inverted_intrachromosomal_transposition",
            "def": "An intrachromosomal transposition whereby the segment between the first two breaks listed is removed and inserted at the third break; the insertion is in cytologically inverted orientation with respect to its flanking segments. [FB:reference_manual]"
        },
        "SO:1000159": {
            "name": "uninverted_intrachromosomal_transposition",
            "def": "An intrachromosomal transposition whereby the segment between the first two breaks listed is removed and inserted at the third break; the insertion is in cytologically the same orientation as its flanking segments. [FB:reference_manual]"
        },
        "SO:1000160": {
            "name": "unoriented_insertional_duplication",
            "def": "An insertional duplication where a copy of the segment between the first two breaks listed is inserted at the third break; the orientation of the insertion with respect to its flanking segments is not recorded. [FB:reference_manual]"
        },
        "SO:1000161": {
            "name": "unoriented_interchromosomal_transposition",
            "def": "An interchromosomal transposition whereby a copy of the segment between the first two breaks listed is inserted at the third break; the orientation of the insertion with respect to its flanking segments is not recorded. [FB:reference_manual]"
        },
        "SO:1000162": {
            "name": "unoriented_intrachromosomal_transposition",
            "def": "An intrachromosomal transposition whereby the segment between the first two breaks listed is removed and inserted at the third break; the orientation of the insertion with respect to its flanking segments is not recorded. [FB:reference_manual]"
        },
        "SO:1000170": {
            "name": "uncharacterized_chromosomal_mutation"
        },
        "SO:1000171": {
            "name": "deficient_inversion",
            "def": "A chromosomal deletion whereby three breaks occur in the same chromosome; one central region is lost, and the other is inverted. [FB:reference_manual, SO:ke]"
        },
        "SO:1000173": {
            "name": "tandem_duplication",
            "def": "A duplication consisting of 2 identical adjacent regions. [SO:ke]"
        },
        "SO:1000175": {
            "name": "partially_characterized_chromosomal_mutation"
        },
        "SO:1000180": {
            "name": "sequence_variant_affecting_gene_structure",
            "def": "A sequence_variant_effect that changes the gene structure. [SO:ke]"
        },
        "SO:1000181": {
            "name": "sequence_variant_causing_gene_fusion",
            "def": "A sequence_variant_effect that changes the gene structure by causing a fusion to another gene. [SO:ke]"
        },
        "SO:1000182": {
            "name": "chromosome_number_variation",
            "def": "A kind of chromosome variation where the chromosome complement is not an exact multiple of the haploid number. [SO:ke]"
        },
        "SO:1000183": {
            "name": "chromosome_structure_variation"
        },
        "SO:1000184": {
            "name": "sequence_variant_causes_exon_loss",
            "def": "A sequence variant affecting splicing and causes an exon loss. [SO:ke]"
        },
        "SO:1000185": {
            "name": "sequence_variant_causes_intron_gain",
            "def": "A sequence variant effect, causing an intron to be gained by the processed transcript; usually a result of a donor acceptor mutation (SO:1000072). [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]"
        },
        "SO:1000186": {
            "name": "sequence_variant_causing_cryptic_splice_donor_activation"
        },
        "SO:1001186": {
            "name": "sequence_variant_causing_cryptic_splice_acceptor_activation"
        },
        "SO:1001187": {
            "name": "alternatively_spliced_transcript",
            "def": "A transcript that is alternatively spliced. [SO:xp]"
        },
        "SO:1001188": {
            "name": "encodes_1_polypeptide",
            "def": "A gene that is alternately spliced, but encodes only one polypeptide. [SO:ke]"
        },
        "SO:1001189": {
            "name": "encodes_greater_than_1_polypeptide",
            "def": "A gene that is alternately spliced, and encodes more than one polypeptide. [SO:ke]"
        },
        "SO:1001190": {
            "name": "encodes_different_polypeptides_different_stop",
            "def": "A gene that is alternately spliced, and encodes more than one polypeptide, that have overlapping peptide sequences, but use different stop codons. [SO:ke]"
        },
        "SO:1001191": {
            "name": "encodes_overlapping_peptides_different_start",
            "def": "A gene that is alternately spliced, and encodes more than one polypeptide, that have overlapping peptide sequences, but use different start codons. [SO:ke]"
        },
        "SO:1001192": {
            "name": "encodes_disjoint_polypeptides",
            "def": "A gene that is alternately spliced, and encodes more than one polypeptide, that do not have overlapping peptide sequences. [SO:ke]"
        },
        "SO:1001193": {
            "name": "encodes_overlapping_polypeptides_different_start_and_stop",
            "def": "A gene that is alternately spliced, and encodes more than one polypeptide, that have overlapping peptide sequences, but use different start and stop codons. [SO:ke]"
        },
        "SO:1001194": {
            "name": "alternatively_spliced_gene_encoding_greater_than_1_polypeptide_coding_regions_overlapping"
        },
        "SO:1001195": {
            "name": "encodes_overlapping_peptides",
            "def": "A gene that is alternately spliced, and encodes more than one polypeptide, that have overlapping peptide sequences. [SO:ke]"
        },
        "SO:1001196": {
            "name": "cryptogene",
            "def": "A maxicircle gene so extensively edited that it cannot be matched to its edited mRNA sequence. [SO:ma]"
        },
        "SO:1001197": {
            "name": "dicistronic_primary_transcript",
            "def": "A primary transcript that has the quality dicistronic. [SO:xp]"
        },
        "SO:1001217": {
            "name": "member_of_regulon"
        },
        "SO:1001244": {
            "name": "alternatively_spliced_transcript_encoding_greater_than_1_polypeptide_different_start_codon_different_stop_codon_coding_regions_non_overlapping"
        },
        "SO:1001246": {
            "name": "CDS_independently_known",
            "def": "A CDS with the evidence status of being independently known. [SO:xp]"
        },
        "SO:1001247": {
            "name": "orphan_CDS",
            "def": "A CDS whose predicted amino acid sequence is unsupported by any experimental evidence or by any match with any other known sequence. [SO:ma]"
        },
        "SO:1001249": {
            "name": "CDS_supported_by_domain_match_data",
            "def": "A CDS that is supported by domain similarity. [SO:xp]"
        },
        "SO:1001251": {
            "name": "CDS_supported_by_sequence_similarity_data",
            "def": "A CDS that is supported by sequence similarity data. [SO:xp]"
        },
        "SO:1001254": {
            "name": "CDS_predicted",
            "def": "A CDS that is predicted. [SO:ke]"
        },
        "SO:1001255": {
            "name": "status_of_coding_sequence"
        },
        "SO:1001259": {
            "name": "CDS_supported_by_EST_or_cDNA_data",
            "def": "A CDS that is supported by similarity to EST or cDNA data. [SO:xp]"
        },
        "SO:1001260": {
            "name": "internal_Shine_Dalgarno_sequence",
            "def": "A Shine-Dalgarno sequence that stimulates recoding through interactions with the anti-Shine-Dalgarno in the RNA of small ribosomal subunits of translating ribosomes. The signal is only operative in Bacteria. [PMID:12519954, SO:ke]"
        },
        "SO:1001261": {
            "name": "recoded_mRNA",
            "def": "The sequence of a mature mRNA transcript, modified before translation or during translation, usually by special cis-acting signals. [http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=8811194&dopt=Abstract]"
        },
        "SO:1001262": {
            "name": "minus_1_translationally_frameshifted",
            "def": "An attribute describing a translational frameshift of -1. [SO:ke]"
        },
        "SO:1001263": {
            "name": "plus_1_translationally_frameshifted",
            "def": "An attribute describing a translational frameshift of +1. [SO:ke]"
        },
        "SO:1001264": {
            "name": "mRNA_recoded_by_translational_bypass",
            "def": "A recoded_mRNA where translation was suspended at a particular codon and resumed at a particular non-overlapping downstream codon. [http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=8811194&dopt=Abstract]"
        },
        "SO:1001265": {
            "name": "mRNA_recoded_by_codon_redefinition",
            "def": "A recoded_mRNA that was modified by an alteration of codon meaning. [SO:ma]"
        },
        "SO:1001266": {
            "name": "stop_codon_redefinition_as_selenocysteine"
        },
        "SO:1001267": {
            "name": "stop_codon_readthrough"
        },
        "SO:1001268": {
            "name": "recoding_stimulatory_region",
            "def": "A site in an mRNA sequence that stimulates the recoding of a region in the same mRNA. [http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=12519954&dopt=Abstract]"
        },
        "SO:1001269": {
            "name": "four_bp_start_codon",
            "def": "A non-canonical start codon with 4 base pairs. [SO:ke]"
        },
        "SO:1001270": {
            "name": "stop_codon_redefinition_as_pyrrolysine"
        },
        "SO:1001271": {
            "name": "archaeal_intron",
            "def": "An intron characteristic of Archaeal tRNA and rRNA genes, where intron transcript generates a bulge-helix-bulge motif that is recognised by a splicing endoribonuclease. [PMID:9301331, SO:ma]"
        },
        "SO:1001272": {
            "name": "tRNA_intron",
            "def": "An intron found in tRNA that is spliced via endonucleolytic cleavage and ligation rather than transesterification. [SO:ke]"
        },
        "SO:1001273": {
            "name": "CTG_start_codon",
            "def": "A non-canonical start codon of sequence CTG. [SO:ke]"
        },
        "SO:1001274": {
            "name": "SECIS_element",
            "def": "The incorporation of selenocysteine into a protein sequence is directed by an in-frame UGA codon (usually a stop codon) within the coding region of the mRNA. Selenoprotein mRNAs contain a conserved secondary structure in the 3' UTR that is required for the distinction of UGA stop from UGA selenocysteine. The selenocysteine insertion sequence (SECIS) is around 60 nt in length and adopts a hairpin structure which is sufficiently well-defined and conserved to act as a computational screen for selenoprotein genes. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00031]"
        },
        "SO:1001275": {
            "name": "retron",
            "def": "Sequence coding for a short, single-stranded, DNA sequence via a retrotransposed RNA intermediate; characteristic of some microbial genomes. [SO:ma]"
        },
        "SO:1001277": {
            "name": "three_prime_recoding_site",
            "def": "The recoding stimulatory signal located downstream of the recoding site. [SO:ke]"
        },
        "SO:1001279": {
            "name": "three_prime_stem_loop_structure",
            "def": "A recoding stimulatory region, the stem-loop secondary structural element is downstream of the redefined region. [PMID:12519954, SO:ke]"
        },
        "SO:1001280": {
            "name": "five_prime_recoding_site",
            "def": "The recoding stimulatory signal located upstream of the recoding site. [SO:ke]"
        },
        "SO:1001281": {
            "name": "flanking_three_prime_quadruplet_recoding_signal",
            "def": "Four base pair sequence immediately downstream of the redefined region. The redefined region is a frameshift site. The quadruplet is 2 overlapping codons. [PMID:12519954, SO:ke]"
        },
        "SO:1001282": {
            "name": "UAG_stop_codon_signal",
            "def": "A stop codon signal for a UAG stop codon redefinition. [SO:ke]"
        },
        "SO:1001283": {
            "name": "UAA_stop_codon_signal",
            "def": "A stop codon signal for a UAA stop codon redefinition. [SO:ke]"
        },
        "SO:1001284": {
            "name": "regulon",
            "def": "A group of genes, whether linked as a cluster or not, that respond to a common regulatory signal. [ISBN:0198506732]"
        },
        "SO:1001285": {
            "name": "UGA_stop_codon_signal",
            "def": "A stop codon signal for a UGA stop codon redefinition. [SO:ke]"
        },
        "SO:1001286": {
            "name": "three_prime_repeat_recoding_signal",
            "def": "A recoding stimulatory signal, downstream sequence important for recoding that contains repetitive elements. [PMID:12519954, SO:ke]"
        },
        "SO:1001287": {
            "name": "distant_three_prime_recoding_signal",
            "def": "A recoding signal that is found many hundreds of nucleotides 3' of a redefined stop codon. [http://www.ncbi.nlm.nih.gov:80/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=8709208&dopt=Abstract]"
        },
        "SO:1001288": {
            "name": "stop_codon_signal",
            "def": "A recoding stimulatory signal that is a stop codon and has effect on efficiency of recoding. [PMID:12519954, SO:ke]"
        },
        "SO:2000061": {
            "name": "databank_entry",
            "def": "The sequence referred to by an entry in a databank such as GenBank or SwissProt. [SO:ke]"
        },
        "SO:3000000": {
            "name": "gene_segment",
            "def": "A gene component region which acts as a recombinational unit of a gene whose functional form is generated through somatic recombination. [GOC:add]"
        }
    };
})(sequenceOntology = exports.sequenceOntology || (exports.sequenceOntology = {}));


/***/ }),

/***/ "./node_modules/buffer-from/index.js":
/*!*******************************************!*\
  !*** ./node_modules/buffer-from/index.js ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var toString = Object.prototype.toString

var isModern = (
  typeof Buffer.alloc === 'function' &&
  typeof Buffer.allocUnsafe === 'function' &&
  typeof Buffer.from === 'function'
)

function isArrayBuffer (input) {
  return toString.call(input).slice(8, -1) === 'ArrayBuffer'
}

function fromArrayBuffer (obj, byteOffset, length) {
  byteOffset >>>= 0

  var maxLength = obj.byteLength - byteOffset

  if (maxLength < 0) {
    throw new RangeError("'offset' is out of bounds")
  }

  if (length === undefined) {
    length = maxLength
  } else {
    length >>>= 0

    if (length > maxLength) {
      throw new RangeError("'length' is out of bounds")
    }
  }

  return isModern
    ? Buffer.from(obj.slice(byteOffset, byteOffset + length))
    : new Buffer(new Uint8Array(obj.slice(byteOffset, byteOffset + length)))
}

function fromString (string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('"encoding" must be a valid string encoding')
  }

  return isModern
    ? Buffer.from(string, encoding)
    : new Buffer(string, encoding)
}

function bufferFrom (value, encodingOrOffset, length) {
  if (typeof value === 'number') {
    throw new TypeError('"value" argument must not be a number')
  }

  if (isArrayBuffer(value)) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof value === 'string') {
    return fromString(value, encodingOrOffset)
  }

  return isModern
    ? Buffer.from(value)
    : new Buffer(value)
}

module.exports = bufferFrom


/***/ }),

/***/ "./node_modules/call-signature/index.js":
/*!**********************************************!*\
  !*** ./node_modules/call-signature/index.js ***!
  \**********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

module.exports.parse = parse;
module.exports.generate = generate;

// TODO(jamestalmage): Allow full range of identifier characters instead of just ASCII
//
// This will likely require a build step
//
// SPEC: http://www.ecma-international.org/ecma-262/5.1/#sec-7.6
//
// TOOLING:
//    https://github.com/mathiasbynens/regenerate
//    https://www.npmjs.com/package/regjsgen

var regex = /^\s*(?:([A-Za-z$_][A-Za-z0-9$_]*)\s*\.)?\s*([A-Za-z$_][A-Za-z0-9$_]*)\s*\(\s*((?:[A-Za-z$_][A-Za-z0-9$_]*)|(?:\[\s*[A-Za-z$_][A-Za-z0-9$_]*\s*]))?((?:\s*,\s*(?:(?:[A-Za-z$_][A-Za-z0-9$_]*)|(?:\[\s*[A-Za-z$_][A-Za-z0-9$_]*\s*])))+)?\s*\)\s*$/;

function parse(str) {
	var match = regex.exec(str);
	if (!match) {
		return null;
	}

	var callee;
	if (match[1]) {
		callee = {
			type: 'MemberExpression',
			object: match[1],
			member: match[2]
		};
	} else {
		callee = {
			type: 'Identifier',
			name: match[2]
		};
	}

	var args = match[4] || '';
	args = args.split(',');
	if (match[3]) {
		args[0] = match[3];
	}
	var trimmed = [];
	args.forEach(function (str) {
		var optional = false;
		str = str.replace(/\s+/g, '');
		if (!str.length) {
			return;
		}
		if (str.charAt(0) === '[' && str.charAt(str.length - 1) === ']') {
			optional = true;
			str = str.substring(1, str.length - 1);
		}
		trimmed.push({
			name: str,
			optional: optional
		});
	});

	return {
		callee: callee,
		args: trimmed
	};
}

function generate(parsed) {
	var callee;
	if (parsed.callee.type === 'MemberExpression') {
		callee = [
			parsed.callee.object,
			'.',
			parsed.callee.member
		];
	} else {
		callee = [parsed.callee.name];
	}
	return callee.concat([
		'(',
		parsed.args.map(function (arg) {
			return arg.optional ? '[' + arg.name + ']' : arg.name;
		}).join(', '),
		')'
	]).join('');
}


/***/ }),

/***/ "./node_modules/chalk/source/index.js":
/*!********************************************!*\
  !*** ./node_modules/chalk/source/index.js ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

const ansiStyles = __webpack_require__(/*! ansi-styles */ "./node_modules/ansi-styles/index.js");
const {stdout: stdoutColor, stderr: stderrColor} = __webpack_require__(/*! supports-color */ "./node_modules/supports-color/index.js");
const {
	stringReplaceAll,
	stringEncaseCRLFWithFirstIndex
} = __webpack_require__(/*! ./util */ "./node_modules/chalk/source/util.js");

const {isArray} = Array;

// `supportsColor.level` → `ansiStyles.color[name]` mapping
const levelMapping = [
	'ansi',
	'ansi',
	'ansi256',
	'ansi16m'
];

const styles = Object.create(null);

const applyOptions = (object, options = {}) => {
	if (options.level && !(Number.isInteger(options.level) && options.level >= 0 && options.level <= 3)) {
		throw new Error('The `level` option should be an integer from 0 to 3');
	}

	// Detect level if not set manually
	const colorLevel = stdoutColor ? stdoutColor.level : 0;
	object.level = options.level === undefined ? colorLevel : options.level;
};

class ChalkClass {
	constructor(options) {
		// eslint-disable-next-line no-constructor-return
		return chalkFactory(options);
	}
}

const chalkFactory = options => {
	const chalk = {};
	applyOptions(chalk, options);

	chalk.template = (...arguments_) => chalkTag(chalk.template, ...arguments_);

	Object.setPrototypeOf(chalk, Chalk.prototype);
	Object.setPrototypeOf(chalk.template, chalk);

	chalk.template.constructor = () => {
		throw new Error('`chalk.constructor()` is deprecated. Use `new chalk.Instance()` instead.');
	};

	chalk.template.Instance = ChalkClass;

	return chalk.template;
};

function Chalk(options) {
	return chalkFactory(options);
}

for (const [styleName, style] of Object.entries(ansiStyles)) {
	styles[styleName] = {
		get() {
			const builder = createBuilder(this, createStyler(style.open, style.close, this._styler), this._isEmpty);
			Object.defineProperty(this, styleName, {value: builder});
			return builder;
		}
	};
}

styles.visible = {
	get() {
		const builder = createBuilder(this, this._styler, true);
		Object.defineProperty(this, 'visible', {value: builder});
		return builder;
	}
};

const usedModels = ['rgb', 'hex', 'keyword', 'hsl', 'hsv', 'hwb', 'ansi', 'ansi256'];

for (const model of usedModels) {
	styles[model] = {
		get() {
			const {level} = this;
			return function (...arguments_) {
				const styler = createStyler(ansiStyles.color[levelMapping[level]][model](...arguments_), ansiStyles.color.close, this._styler);
				return createBuilder(this, styler, this._isEmpty);
			};
		}
	};
}

for (const model of usedModels) {
	const bgModel = 'bg' + model[0].toUpperCase() + model.slice(1);
	styles[bgModel] = {
		get() {
			const {level} = this;
			return function (...arguments_) {
				const styler = createStyler(ansiStyles.bgColor[levelMapping[level]][model](...arguments_), ansiStyles.bgColor.close, this._styler);
				return createBuilder(this, styler, this._isEmpty);
			};
		}
	};
}

const proto = Object.defineProperties(() => {}, {
	...styles,
	level: {
		enumerable: true,
		get() {
			return this._generator.level;
		},
		set(level) {
			this._generator.level = level;
		}
	}
});

const createStyler = (open, close, parent) => {
	let openAll;
	let closeAll;
	if (parent === undefined) {
		openAll = open;
		closeAll = close;
	} else {
		openAll = parent.openAll + open;
		closeAll = close + parent.closeAll;
	}

	return {
		open,
		close,
		openAll,
		closeAll,
		parent
	};
};

const createBuilder = (self, _styler, _isEmpty) => {
	const builder = (...arguments_) => {
		if (isArray(arguments_[0]) && isArray(arguments_[0].raw)) {
			// Called as a template literal, for example: chalk.red`2 + 3 = {bold ${2+3}}`
			return applyStyle(builder, chalkTag(builder, ...arguments_));
		}

		// Single argument is hot path, implicit coercion is faster than anything
		// eslint-disable-next-line no-implicit-coercion
		return applyStyle(builder, (arguments_.length === 1) ? ('' + arguments_[0]) : arguments_.join(' '));
	};

	// We alter the prototype because we must return a function, but there is
	// no way to create a function with a different prototype
	Object.setPrototypeOf(builder, proto);

	builder._generator = self;
	builder._styler = _styler;
	builder._isEmpty = _isEmpty;

	return builder;
};

const applyStyle = (self, string) => {
	if (self.level <= 0 || !string) {
		return self._isEmpty ? '' : string;
	}

	let styler = self._styler;

	if (styler === undefined) {
		return string;
	}

	const {openAll, closeAll} = styler;
	if (string.indexOf('\u001B') !== -1) {
		while (styler !== undefined) {
			// Replace any instances already present with a re-opening code
			// otherwise only the part of the string until said closing code
			// will be colored, and the rest will simply be 'plain'.
			string = stringReplaceAll(string, styler.close, styler.open);

			styler = styler.parent;
		}
	}

	// We can move both next actions out of loop, because remaining actions in loop won't have
	// any/visible effect on parts we add here. Close the styling before a linebreak and reopen
	// after next line to fix a bleed issue on macOS: https://github.com/chalk/chalk/pull/92
	const lfIndex = string.indexOf('\n');
	if (lfIndex !== -1) {
		string = stringEncaseCRLFWithFirstIndex(string, closeAll, openAll, lfIndex);
	}

	return openAll + string + closeAll;
};

let template;
const chalkTag = (chalk, ...strings) => {
	const [firstString] = strings;

	if (!isArray(firstString) || !isArray(firstString.raw)) {
		// If chalk() was called by itself or with a string,
		// return the string itself as a string.
		return strings.join(' ');
	}

	const arguments_ = strings.slice(1);
	const parts = [firstString.raw[0]];

	for (let i = 1; i < firstString.length; i++) {
		parts.push(
			String(arguments_[i - 1]).replace(/[{}\\]/g, '\\$&'),
			String(firstString.raw[i])
		);
	}

	if (template === undefined) {
		template = __webpack_require__(/*! ./templates */ "./node_modules/chalk/source/templates.js");
	}

	return template(chalk, parts.join(''));
};

Object.defineProperties(Chalk.prototype, styles);

const chalk = Chalk(); // eslint-disable-line new-cap
chalk.supportsColor = stdoutColor;
chalk.stderr = Chalk({level: stderrColor ? stderrColor.level : 0}); // eslint-disable-line new-cap
chalk.stderr.supportsColor = stderrColor;

module.exports = chalk;


/***/ }),

/***/ "./node_modules/chalk/source/templates.js":
/*!************************************************!*\
  !*** ./node_modules/chalk/source/templates.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

const TEMPLATE_REGEX = /(?:\\(u(?:[a-f\d]{4}|\{[a-f\d]{1,6}\})|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
const STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
const STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
const ESCAPE_REGEX = /\\(u(?:[a-f\d]{4}|{[a-f\d]{1,6}})|x[a-f\d]{2}|.)|([^\\])/gi;

const ESCAPES = new Map([
	['n', '\n'],
	['r', '\r'],
	['t', '\t'],
	['b', '\b'],
	['f', '\f'],
	['v', '\v'],
	['0', '\0'],
	['\\', '\\'],
	['e', '\u001B'],
	['a', '\u0007']
]);

function unescape(c) {
	const u = c[0] === 'u';
	const bracket = c[1] === '{';

	if ((u && !bracket && c.length === 5) || (c[0] === 'x' && c.length === 3)) {
		return String.fromCharCode(parseInt(c.slice(1), 16));
	}

	if (u && bracket) {
		return String.fromCodePoint(parseInt(c.slice(2, -1), 16));
	}

	return ESCAPES.get(c) || c;
}

function parseArguments(name, arguments_) {
	const results = [];
	const chunks = arguments_.trim().split(/\s*,\s*/g);
	let matches;

	for (const chunk of chunks) {
		const number = Number(chunk);
		if (!Number.isNaN(number)) {
			results.push(number);
		} else if ((matches = chunk.match(STRING_REGEX))) {
			results.push(matches[2].replace(ESCAPE_REGEX, (m, escape, character) => escape ? unescape(escape) : character));
		} else {
			throw new Error(`Invalid Chalk template style argument: ${chunk} (in style '${name}')`);
		}
	}

	return results;
}

function parseStyle(style) {
	STYLE_REGEX.lastIndex = 0;

	const results = [];
	let matches;

	while ((matches = STYLE_REGEX.exec(style)) !== null) {
		const name = matches[1];

		if (matches[2]) {
			const args = parseArguments(name, matches[2]);
			results.push([name].concat(args));
		} else {
			results.push([name]);
		}
	}

	return results;
}

function buildStyle(chalk, styles) {
	const enabled = {};

	for (const layer of styles) {
		for (const style of layer.styles) {
			enabled[style[0]] = layer.inverse ? null : style.slice(1);
		}
	}

	let current = chalk;
	for (const [styleName, styles] of Object.entries(enabled)) {
		if (!Array.isArray(styles)) {
			continue;
		}

		if (!(styleName in current)) {
			throw new Error(`Unknown Chalk style: ${styleName}`);
		}

		current = styles.length > 0 ? current[styleName](...styles) : current[styleName];
	}

	return current;
}

module.exports = (chalk, temporary) => {
	const styles = [];
	const chunks = [];
	let chunk = [];

	// eslint-disable-next-line max-params
	temporary.replace(TEMPLATE_REGEX, (m, escapeCharacter, inverse, style, close, character) => {
		if (escapeCharacter) {
			chunk.push(unescape(escapeCharacter));
		} else if (style) {
			const string = chunk.join('');
			chunk = [];
			chunks.push(styles.length === 0 ? string : buildStyle(chalk, styles)(string));
			styles.push({inverse, styles: parseStyle(style)});
		} else if (close) {
			if (styles.length === 0) {
				throw new Error('Found extraneous } in Chalk template literal');
			}

			chunks.push(buildStyle(chalk, styles)(chunk.join('')));
			chunk = [];
			styles.pop();
		} else {
			chunk.push(character);
		}
	});

	chunks.push(chunk.join(''));

	if (styles.length > 0) {
		const errMessage = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? '' : 's'} (\`}\`)`;
		throw new Error(errMessage);
	}

	return chunks.join('');
};


/***/ }),

/***/ "./node_modules/chalk/source/util.js":
/*!*******************************************!*\
  !*** ./node_modules/chalk/source/util.js ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


const stringReplaceAll = (string, substring, replacer) => {
	let index = string.indexOf(substring);
	if (index === -1) {
		return string;
	}

	const substringLength = substring.length;
	let endIndex = 0;
	let returnValue = '';
	do {
		returnValue += string.substr(endIndex, index - endIndex) + substring + replacer;
		endIndex = index + substringLength;
		index = string.indexOf(substring, endIndex);
	} while (index !== -1);

	returnValue += string.substr(endIndex);
	return returnValue;
};

const stringEncaseCRLFWithFirstIndex = (string, prefix, postfix, index) => {
	let endIndex = 0;
	let returnValue = '';
	do {
		const gotCR = string[index - 1] === '\r';
		returnValue += string.substr(endIndex, (gotCR ? index - 1 : index) - endIndex) + prefix + (gotCR ? '\r\n' : '\n') + postfix;
		endIndex = index + 1;
		index = string.indexOf('\n', endIndex);
	} while (index !== -1);

	returnValue += string.substr(endIndex);
	return returnValue;
};

module.exports = {
	stringReplaceAll,
	stringEncaseCRLFWithFirstIndex
};


/***/ }),

/***/ "./node_modules/color-convert/conversions.js":
/*!***************************************************!*\
  !*** ./node_modules/color-convert/conversions.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

/* MIT license */
/* eslint-disable no-mixed-operators */
const cssKeywords = __webpack_require__(/*! color-name */ "./node_modules/color-name/index.js");

// NOTE: conversions should only return primitive values (i.e. arrays, or
//       values that give correct `typeof` results).
//       do not use box values types (i.e. Number(), String(), etc.)

const reverseKeywords = {};
for (const key of Object.keys(cssKeywords)) {
	reverseKeywords[cssKeywords[key]] = key;
}

const convert = {
	rgb: {channels: 3, labels: 'rgb'},
	hsl: {channels: 3, labels: 'hsl'},
	hsv: {channels: 3, labels: 'hsv'},
	hwb: {channels: 3, labels: 'hwb'},
	cmyk: {channels: 4, labels: 'cmyk'},
	xyz: {channels: 3, labels: 'xyz'},
	lab: {channels: 3, labels: 'lab'},
	lch: {channels: 3, labels: 'lch'},
	hex: {channels: 1, labels: ['hex']},
	keyword: {channels: 1, labels: ['keyword']},
	ansi16: {channels: 1, labels: ['ansi16']},
	ansi256: {channels: 1, labels: ['ansi256']},
	hcg: {channels: 3, labels: ['h', 'c', 'g']},
	apple: {channels: 3, labels: ['r16', 'g16', 'b16']},
	gray: {channels: 1, labels: ['gray']}
};

module.exports = convert;

// Hide .channels and .labels properties
for (const model of Object.keys(convert)) {
	if (!('channels' in convert[model])) {
		throw new Error('missing channels property: ' + model);
	}

	if (!('labels' in convert[model])) {
		throw new Error('missing channel labels property: ' + model);
	}

	if (convert[model].labels.length !== convert[model].channels) {
		throw new Error('channel and label counts mismatch: ' + model);
	}

	const {channels, labels} = convert[model];
	delete convert[model].channels;
	delete convert[model].labels;
	Object.defineProperty(convert[model], 'channels', {value: channels});
	Object.defineProperty(convert[model], 'labels', {value: labels});
}

convert.rgb.hsl = function (rgb) {
	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;
	const min = Math.min(r, g, b);
	const max = Math.max(r, g, b);
	const delta = max - min;
	let h;
	let s;

	if (max === min) {
		h = 0;
	} else if (r === max) {
		h = (g - b) / delta;
	} else if (g === max) {
		h = 2 + (b - r) / delta;
	} else if (b === max) {
		h = 4 + (r - g) / delta;
	}

	h = Math.min(h * 60, 360);

	if (h < 0) {
		h += 360;
	}

	const l = (min + max) / 2;

	if (max === min) {
		s = 0;
	} else if (l <= 0.5) {
		s = delta / (max + min);
	} else {
		s = delta / (2 - max - min);
	}

	return [h, s * 100, l * 100];
};

convert.rgb.hsv = function (rgb) {
	let rdif;
	let gdif;
	let bdif;
	let h;
	let s;

	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;
	const v = Math.max(r, g, b);
	const diff = v - Math.min(r, g, b);
	const diffc = function (c) {
		return (v - c) / 6 / diff + 1 / 2;
	};

	if (diff === 0) {
		h = 0;
		s = 0;
	} else {
		s = diff / v;
		rdif = diffc(r);
		gdif = diffc(g);
		bdif = diffc(b);

		if (r === v) {
			h = bdif - gdif;
		} else if (g === v) {
			h = (1 / 3) + rdif - bdif;
		} else if (b === v) {
			h = (2 / 3) + gdif - rdif;
		}

		if (h < 0) {
			h += 1;
		} else if (h > 1) {
			h -= 1;
		}
	}

	return [
		h * 360,
		s * 100,
		v * 100
	];
};

convert.rgb.hwb = function (rgb) {
	const r = rgb[0];
	const g = rgb[1];
	let b = rgb[2];
	const h = convert.rgb.hsl(rgb)[0];
	const w = 1 / 255 * Math.min(r, Math.min(g, b));

	b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));

	return [h, w * 100, b * 100];
};

convert.rgb.cmyk = function (rgb) {
	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;

	const k = Math.min(1 - r, 1 - g, 1 - b);
	const c = (1 - r - k) / (1 - k) || 0;
	const m = (1 - g - k) / (1 - k) || 0;
	const y = (1 - b - k) / (1 - k) || 0;

	return [c * 100, m * 100, y * 100, k * 100];
};

function comparativeDistance(x, y) {
	/*
		See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
	*/
	return (
		((x[0] - y[0]) ** 2) +
		((x[1] - y[1]) ** 2) +
		((x[2] - y[2]) ** 2)
	);
}

convert.rgb.keyword = function (rgb) {
	const reversed = reverseKeywords[rgb];
	if (reversed) {
		return reversed;
	}

	let currentClosestDistance = Infinity;
	let currentClosestKeyword;

	for (const keyword of Object.keys(cssKeywords)) {
		const value = cssKeywords[keyword];

		// Compute comparative distance
		const distance = comparativeDistance(rgb, value);

		// Check if its less, if so set as closest
		if (distance < currentClosestDistance) {
			currentClosestDistance = distance;
			currentClosestKeyword = keyword;
		}
	}

	return currentClosestKeyword;
};

convert.keyword.rgb = function (keyword) {
	return cssKeywords[keyword];
};

convert.rgb.xyz = function (rgb) {
	let r = rgb[0] / 255;
	let g = rgb[1] / 255;
	let b = rgb[2] / 255;

	// Assume sRGB
	r = r > 0.04045 ? (((r + 0.055) / 1.055) ** 2.4) : (r / 12.92);
	g = g > 0.04045 ? (((g + 0.055) / 1.055) ** 2.4) : (g / 12.92);
	b = b > 0.04045 ? (((b + 0.055) / 1.055) ** 2.4) : (b / 12.92);

	const x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);
	const y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
	const z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);

	return [x * 100, y * 100, z * 100];
};

convert.rgb.lab = function (rgb) {
	const xyz = convert.rgb.xyz(rgb);
	let x = xyz[0];
	let y = xyz[1];
	let z = xyz[2];

	x /= 95.047;
	y /= 100;
	z /= 108.883;

	x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
	y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
	z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

	const l = (116 * y) - 16;
	const a = 500 * (x - y);
	const b = 200 * (y - z);

	return [l, a, b];
};

convert.hsl.rgb = function (hsl) {
	const h = hsl[0] / 360;
	const s = hsl[1] / 100;
	const l = hsl[2] / 100;
	let t2;
	let t3;
	let val;

	if (s === 0) {
		val = l * 255;
		return [val, val, val];
	}

	if (l < 0.5) {
		t2 = l * (1 + s);
	} else {
		t2 = l + s - l * s;
	}

	const t1 = 2 * l - t2;

	const rgb = [0, 0, 0];
	for (let i = 0; i < 3; i++) {
		t3 = h + 1 / 3 * -(i - 1);
		if (t3 < 0) {
			t3++;
		}

		if (t3 > 1) {
			t3--;
		}

		if (6 * t3 < 1) {
			val = t1 + (t2 - t1) * 6 * t3;
		} else if (2 * t3 < 1) {
			val = t2;
		} else if (3 * t3 < 2) {
			val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
		} else {
			val = t1;
		}

		rgb[i] = val * 255;
	}

	return rgb;
};

convert.hsl.hsv = function (hsl) {
	const h = hsl[0];
	let s = hsl[1] / 100;
	let l = hsl[2] / 100;
	let smin = s;
	const lmin = Math.max(l, 0.01);

	l *= 2;
	s *= (l <= 1) ? l : 2 - l;
	smin *= lmin <= 1 ? lmin : 2 - lmin;
	const v = (l + s) / 2;
	const sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);

	return [h, sv * 100, v * 100];
};

convert.hsv.rgb = function (hsv) {
	const h = hsv[0] / 60;
	const s = hsv[1] / 100;
	let v = hsv[2] / 100;
	const hi = Math.floor(h) % 6;

	const f = h - Math.floor(h);
	const p = 255 * v * (1 - s);
	const q = 255 * v * (1 - (s * f));
	const t = 255 * v * (1 - (s * (1 - f)));
	v *= 255;

	switch (hi) {
		case 0:
			return [v, t, p];
		case 1:
			return [q, v, p];
		case 2:
			return [p, v, t];
		case 3:
			return [p, q, v];
		case 4:
			return [t, p, v];
		case 5:
			return [v, p, q];
	}
};

convert.hsv.hsl = function (hsv) {
	const h = hsv[0];
	const s = hsv[1] / 100;
	const v = hsv[2] / 100;
	const vmin = Math.max(v, 0.01);
	let sl;
	let l;

	l = (2 - s) * v;
	const lmin = (2 - s) * vmin;
	sl = s * vmin;
	sl /= (lmin <= 1) ? lmin : 2 - lmin;
	sl = sl || 0;
	l /= 2;

	return [h, sl * 100, l * 100];
};

// http://dev.w3.org/csswg/css-color/#hwb-to-rgb
convert.hwb.rgb = function (hwb) {
	const h = hwb[0] / 360;
	let wh = hwb[1] / 100;
	let bl = hwb[2] / 100;
	const ratio = wh + bl;
	let f;

	// Wh + bl cant be > 1
	if (ratio > 1) {
		wh /= ratio;
		bl /= ratio;
	}

	const i = Math.floor(6 * h);
	const v = 1 - bl;
	f = 6 * h - i;

	if ((i & 0x01) !== 0) {
		f = 1 - f;
	}

	const n = wh + f * (v - wh); // Linear interpolation

	let r;
	let g;
	let b;
	/* eslint-disable max-statements-per-line,no-multi-spaces */
	switch (i) {
		default:
		case 6:
		case 0: r = v;  g = n;  b = wh; break;
		case 1: r = n;  g = v;  b = wh; break;
		case 2: r = wh; g = v;  b = n; break;
		case 3: r = wh; g = n;  b = v; break;
		case 4: r = n;  g = wh; b = v; break;
		case 5: r = v;  g = wh; b = n; break;
	}
	/* eslint-enable max-statements-per-line,no-multi-spaces */

	return [r * 255, g * 255, b * 255];
};

convert.cmyk.rgb = function (cmyk) {
	const c = cmyk[0] / 100;
	const m = cmyk[1] / 100;
	const y = cmyk[2] / 100;
	const k = cmyk[3] / 100;

	const r = 1 - Math.min(1, c * (1 - k) + k);
	const g = 1 - Math.min(1, m * (1 - k) + k);
	const b = 1 - Math.min(1, y * (1 - k) + k);

	return [r * 255, g * 255, b * 255];
};

convert.xyz.rgb = function (xyz) {
	const x = xyz[0] / 100;
	const y = xyz[1] / 100;
	const z = xyz[2] / 100;
	let r;
	let g;
	let b;

	r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);
	g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);
	b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);

	// Assume sRGB
	r = r > 0.0031308
		? ((1.055 * (r ** (1.0 / 2.4))) - 0.055)
		: r * 12.92;

	g = g > 0.0031308
		? ((1.055 * (g ** (1.0 / 2.4))) - 0.055)
		: g * 12.92;

	b = b > 0.0031308
		? ((1.055 * (b ** (1.0 / 2.4))) - 0.055)
		: b * 12.92;

	r = Math.min(Math.max(0, r), 1);
	g = Math.min(Math.max(0, g), 1);
	b = Math.min(Math.max(0, b), 1);

	return [r * 255, g * 255, b * 255];
};

convert.xyz.lab = function (xyz) {
	let x = xyz[0];
	let y = xyz[1];
	let z = xyz[2];

	x /= 95.047;
	y /= 100;
	z /= 108.883;

	x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
	y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
	z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

	const l = (116 * y) - 16;
	const a = 500 * (x - y);
	const b = 200 * (y - z);

	return [l, a, b];
};

convert.lab.xyz = function (lab) {
	const l = lab[0];
	const a = lab[1];
	const b = lab[2];
	let x;
	let y;
	let z;

	y = (l + 16) / 116;
	x = a / 500 + y;
	z = y - b / 200;

	const y2 = y ** 3;
	const x2 = x ** 3;
	const z2 = z ** 3;
	y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
	x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
	z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;

	x *= 95.047;
	y *= 100;
	z *= 108.883;

	return [x, y, z];
};

convert.lab.lch = function (lab) {
	const l = lab[0];
	const a = lab[1];
	const b = lab[2];
	let h;

	const hr = Math.atan2(b, a);
	h = hr * 360 / 2 / Math.PI;

	if (h < 0) {
		h += 360;
	}

	const c = Math.sqrt(a * a + b * b);

	return [l, c, h];
};

convert.lch.lab = function (lch) {
	const l = lch[0];
	const c = lch[1];
	const h = lch[2];

	const hr = h / 360 * 2 * Math.PI;
	const a = c * Math.cos(hr);
	const b = c * Math.sin(hr);

	return [l, a, b];
};

convert.rgb.ansi16 = function (args, saturation = null) {
	const [r, g, b] = args;
	let value = saturation === null ? convert.rgb.hsv(args)[2] : saturation; // Hsv -> ansi16 optimization

	value = Math.round(value / 50);

	if (value === 0) {
		return 30;
	}

	let ansi = 30
		+ ((Math.round(b / 255) << 2)
		| (Math.round(g / 255) << 1)
		| Math.round(r / 255));

	if (value === 2) {
		ansi += 60;
	}

	return ansi;
};

convert.hsv.ansi16 = function (args) {
	// Optimization here; we already know the value and don't need to get
	// it converted for us.
	return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
};

convert.rgb.ansi256 = function (args) {
	const r = args[0];
	const g = args[1];
	const b = args[2];

	// We use the extended greyscale palette here, with the exception of
	// black and white. normal palette only has 4 greyscale shades.
	if (r === g && g === b) {
		if (r < 8) {
			return 16;
		}

		if (r > 248) {
			return 231;
		}

		return Math.round(((r - 8) / 247) * 24) + 232;
	}

	const ansi = 16
		+ (36 * Math.round(r / 255 * 5))
		+ (6 * Math.round(g / 255 * 5))
		+ Math.round(b / 255 * 5);

	return ansi;
};

convert.ansi16.rgb = function (args) {
	let color = args % 10;

	// Handle greyscale
	if (color === 0 || color === 7) {
		if (args > 50) {
			color += 3.5;
		}

		color = color / 10.5 * 255;

		return [color, color, color];
	}

	const mult = (~~(args > 50) + 1) * 0.5;
	const r = ((color & 1) * mult) * 255;
	const g = (((color >> 1) & 1) * mult) * 255;
	const b = (((color >> 2) & 1) * mult) * 255;

	return [r, g, b];
};

convert.ansi256.rgb = function (args) {
	// Handle greyscale
	if (args >= 232) {
		const c = (args - 232) * 10 + 8;
		return [c, c, c];
	}

	args -= 16;

	let rem;
	const r = Math.floor(args / 36) / 5 * 255;
	const g = Math.floor((rem = args % 36) / 6) / 5 * 255;
	const b = (rem % 6) / 5 * 255;

	return [r, g, b];
};

convert.rgb.hex = function (args) {
	const integer = ((Math.round(args[0]) & 0xFF) << 16)
		+ ((Math.round(args[1]) & 0xFF) << 8)
		+ (Math.round(args[2]) & 0xFF);

	const string = integer.toString(16).toUpperCase();
	return '000000'.substring(string.length) + string;
};

convert.hex.rgb = function (args) {
	const match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
	if (!match) {
		return [0, 0, 0];
	}

	let colorString = match[0];

	if (match[0].length === 3) {
		colorString = colorString.split('').map(char => {
			return char + char;
		}).join('');
	}

	const integer = parseInt(colorString, 16);
	const r = (integer >> 16) & 0xFF;
	const g = (integer >> 8) & 0xFF;
	const b = integer & 0xFF;

	return [r, g, b];
};

convert.rgb.hcg = function (rgb) {
	const r = rgb[0] / 255;
	const g = rgb[1] / 255;
	const b = rgb[2] / 255;
	const max = Math.max(Math.max(r, g), b);
	const min = Math.min(Math.min(r, g), b);
	const chroma = (max - min);
	let grayscale;
	let hue;

	if (chroma < 1) {
		grayscale = min / (1 - chroma);
	} else {
		grayscale = 0;
	}

	if (chroma <= 0) {
		hue = 0;
	} else
	if (max === r) {
		hue = ((g - b) / chroma) % 6;
	} else
	if (max === g) {
		hue = 2 + (b - r) / chroma;
	} else {
		hue = 4 + (r - g) / chroma;
	}

	hue /= 6;
	hue %= 1;

	return [hue * 360, chroma * 100, grayscale * 100];
};

convert.hsl.hcg = function (hsl) {
	const s = hsl[1] / 100;
	const l = hsl[2] / 100;

	const c = l < 0.5 ? (2.0 * s * l) : (2.0 * s * (1.0 - l));

	let f = 0;
	if (c < 1.0) {
		f = (l - 0.5 * c) / (1.0 - c);
	}

	return [hsl[0], c * 100, f * 100];
};

convert.hsv.hcg = function (hsv) {
	const s = hsv[1] / 100;
	const v = hsv[2] / 100;

	const c = s * v;
	let f = 0;

	if (c < 1.0) {
		f = (v - c) / (1 - c);
	}

	return [hsv[0], c * 100, f * 100];
};

convert.hcg.rgb = function (hcg) {
	const h = hcg[0] / 360;
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;

	if (c === 0.0) {
		return [g * 255, g * 255, g * 255];
	}

	const pure = [0, 0, 0];
	const hi = (h % 1) * 6;
	const v = hi % 1;
	const w = 1 - v;
	let mg = 0;

	/* eslint-disable max-statements-per-line */
	switch (Math.floor(hi)) {
		case 0:
			pure[0] = 1; pure[1] = v; pure[2] = 0; break;
		case 1:
			pure[0] = w; pure[1] = 1; pure[2] = 0; break;
		case 2:
			pure[0] = 0; pure[1] = 1; pure[2] = v; break;
		case 3:
			pure[0] = 0; pure[1] = w; pure[2] = 1; break;
		case 4:
			pure[0] = v; pure[1] = 0; pure[2] = 1; break;
		default:
			pure[0] = 1; pure[1] = 0; pure[2] = w;
	}
	/* eslint-enable max-statements-per-line */

	mg = (1.0 - c) * g;

	return [
		(c * pure[0] + mg) * 255,
		(c * pure[1] + mg) * 255,
		(c * pure[2] + mg) * 255
	];
};

convert.hcg.hsv = function (hcg) {
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;

	const v = c + g * (1.0 - c);
	let f = 0;

	if (v > 0.0) {
		f = c / v;
	}

	return [hcg[0], f * 100, v * 100];
};

convert.hcg.hsl = function (hcg) {
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;

	const l = g * (1.0 - c) + 0.5 * c;
	let s = 0;

	if (l > 0.0 && l < 0.5) {
		s = c / (2 * l);
	} else
	if (l >= 0.5 && l < 1.0) {
		s = c / (2 * (1 - l));
	}

	return [hcg[0], s * 100, l * 100];
};

convert.hcg.hwb = function (hcg) {
	const c = hcg[1] / 100;
	const g = hcg[2] / 100;
	const v = c + g * (1.0 - c);
	return [hcg[0], (v - c) * 100, (1 - v) * 100];
};

convert.hwb.hcg = function (hwb) {
	const w = hwb[1] / 100;
	const b = hwb[2] / 100;
	const v = 1 - b;
	const c = v - w;
	let g = 0;

	if (c < 1) {
		g = (v - c) / (1 - c);
	}

	return [hwb[0], c * 100, g * 100];
};

convert.apple.rgb = function (apple) {
	return [(apple[0] / 65535) * 255, (apple[1] / 65535) * 255, (apple[2] / 65535) * 255];
};

convert.rgb.apple = function (rgb) {
	return [(rgb[0] / 255) * 65535, (rgb[1] / 255) * 65535, (rgb[2] / 255) * 65535];
};

convert.gray.rgb = function (args) {
	return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
};

convert.gray.hsl = function (args) {
	return [0, 0, args[0]];
};

convert.gray.hsv = convert.gray.hsl;

convert.gray.hwb = function (gray) {
	return [0, 100, gray[0]];
};

convert.gray.cmyk = function (gray) {
	return [0, 0, 0, gray[0]];
};

convert.gray.lab = function (gray) {
	return [gray[0], 0, 0];
};

convert.gray.hex = function (gray) {
	const val = Math.round(gray[0] / 100 * 255) & 0xFF;
	const integer = (val << 16) + (val << 8) + val;

	const string = integer.toString(16).toUpperCase();
	return '000000'.substring(string.length) + string;
};

convert.rgb.gray = function (rgb) {
	const val = (rgb[0] + rgb[1] + rgb[2]) / 3;
	return [val / 255 * 100];
};


/***/ }),

/***/ "./node_modules/color-convert/index.js":
/*!*********************************************!*\
  !*** ./node_modules/color-convert/index.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

const conversions = __webpack_require__(/*! ./conversions */ "./node_modules/color-convert/conversions.js");
const route = __webpack_require__(/*! ./route */ "./node_modules/color-convert/route.js");

const convert = {};

const models = Object.keys(conversions);

function wrapRaw(fn) {
	const wrappedFn = function (...args) {
		const arg0 = args[0];
		if (arg0 === undefined || arg0 === null) {
			return arg0;
		}

		if (arg0.length > 1) {
			args = arg0;
		}

		return fn(args);
	};

	// Preserve .conversion property if there is one
	if ('conversion' in fn) {
		wrappedFn.conversion = fn.conversion;
	}

	return wrappedFn;
}

function wrapRounded(fn) {
	const wrappedFn = function (...args) {
		const arg0 = args[0];

		if (arg0 === undefined || arg0 === null) {
			return arg0;
		}

		if (arg0.length > 1) {
			args = arg0;
		}

		const result = fn(args);

		// We're assuming the result is an array here.
		// see notice in conversions.js; don't use box types
		// in conversion functions.
		if (typeof result === 'object') {
			for (let len = result.length, i = 0; i < len; i++) {
				result[i] = Math.round(result[i]);
			}
		}

		return result;
	};

	// Preserve .conversion property if there is one
	if ('conversion' in fn) {
		wrappedFn.conversion = fn.conversion;
	}

	return wrappedFn;
}

models.forEach(fromModel => {
	convert[fromModel] = {};

	Object.defineProperty(convert[fromModel], 'channels', {value: conversions[fromModel].channels});
	Object.defineProperty(convert[fromModel], 'labels', {value: conversions[fromModel].labels});

	const routes = route(fromModel);
	const routeModels = Object.keys(routes);

	routeModels.forEach(toModel => {
		const fn = routes[toModel];

		convert[fromModel][toModel] = wrapRounded(fn);
		convert[fromModel][toModel].raw = wrapRaw(fn);
	});
});

module.exports = convert;


/***/ }),

/***/ "./node_modules/color-convert/route.js":
/*!*********************************************!*\
  !*** ./node_modules/color-convert/route.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

const conversions = __webpack_require__(/*! ./conversions */ "./node_modules/color-convert/conversions.js");

/*
	This function routes a model to all other models.

	all functions that are routed have a property `.conversion` attached
	to the returned synthetic function. This property is an array
	of strings, each with the steps in between the 'from' and 'to'
	color models (inclusive).

	conversions that are not possible simply are not included.
*/

function buildGraph() {
	const graph = {};
	// https://jsperf.com/object-keys-vs-for-in-with-closure/3
	const models = Object.keys(conversions);

	for (let len = models.length, i = 0; i < len; i++) {
		graph[models[i]] = {
			// http://jsperf.com/1-vs-infinity
			// micro-opt, but this is simple.
			distance: -1,
			parent: null
		};
	}

	return graph;
}

// https://en.wikipedia.org/wiki/Breadth-first_search
function deriveBFS(fromModel) {
	const graph = buildGraph();
	const queue = [fromModel]; // Unshift -> queue -> pop

	graph[fromModel].distance = 0;

	while (queue.length) {
		const current = queue.pop();
		const adjacents = Object.keys(conversions[current]);

		for (let len = adjacents.length, i = 0; i < len; i++) {
			const adjacent = adjacents[i];
			const node = graph[adjacent];

			if (node.distance === -1) {
				node.distance = graph[current].distance + 1;
				node.parent = current;
				queue.unshift(adjacent);
			}
		}
	}

	return graph;
}

function link(from, to) {
	return function (args) {
		return to(from(args));
	};
}

function wrapConversion(toModel, graph) {
	const path = [graph[toModel].parent, toModel];
	let fn = conversions[graph[toModel].parent][toModel];

	let cur = graph[toModel].parent;
	while (graph[cur].parent) {
		path.unshift(graph[cur].parent);
		fn = link(conversions[graph[cur].parent][cur], fn);
		cur = graph[cur].parent;
	}

	fn.conversion = path;
	return fn;
}

module.exports = function (fromModel) {
	const graph = deriveBFS(fromModel);
	const conversion = {};

	const models = Object.keys(graph);
	for (let len = models.length, i = 0; i < len; i++) {
		const toModel = models[i];
		const node = graph[toModel];

		if (node.parent === null) {
			// No possible conversion, or this node is the source model.
			continue;
		}

		conversion[toModel] = wrapConversion(toModel, graph);
	}

	return conversion;
};



/***/ }),

/***/ "./node_modules/color-name/index.js":
/*!******************************************!*\
  !*** ./node_modules/color-name/index.js ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = {
	"aliceblue": [240, 248, 255],
	"antiquewhite": [250, 235, 215],
	"aqua": [0, 255, 255],
	"aquamarine": [127, 255, 212],
	"azure": [240, 255, 255],
	"beige": [245, 245, 220],
	"bisque": [255, 228, 196],
	"black": [0, 0, 0],
	"blanchedalmond": [255, 235, 205],
	"blue": [0, 0, 255],
	"blueviolet": [138, 43, 226],
	"brown": [165, 42, 42],
	"burlywood": [222, 184, 135],
	"cadetblue": [95, 158, 160],
	"chartreuse": [127, 255, 0],
	"chocolate": [210, 105, 30],
	"coral": [255, 127, 80],
	"cornflowerblue": [100, 149, 237],
	"cornsilk": [255, 248, 220],
	"crimson": [220, 20, 60],
	"cyan": [0, 255, 255],
	"darkblue": [0, 0, 139],
	"darkcyan": [0, 139, 139],
	"darkgoldenrod": [184, 134, 11],
	"darkgray": [169, 169, 169],
	"darkgreen": [0, 100, 0],
	"darkgrey": [169, 169, 169],
	"darkkhaki": [189, 183, 107],
	"darkmagenta": [139, 0, 139],
	"darkolivegreen": [85, 107, 47],
	"darkorange": [255, 140, 0],
	"darkorchid": [153, 50, 204],
	"darkred": [139, 0, 0],
	"darksalmon": [233, 150, 122],
	"darkseagreen": [143, 188, 143],
	"darkslateblue": [72, 61, 139],
	"darkslategray": [47, 79, 79],
	"darkslategrey": [47, 79, 79],
	"darkturquoise": [0, 206, 209],
	"darkviolet": [148, 0, 211],
	"deeppink": [255, 20, 147],
	"deepskyblue": [0, 191, 255],
	"dimgray": [105, 105, 105],
	"dimgrey": [105, 105, 105],
	"dodgerblue": [30, 144, 255],
	"firebrick": [178, 34, 34],
	"floralwhite": [255, 250, 240],
	"forestgreen": [34, 139, 34],
	"fuchsia": [255, 0, 255],
	"gainsboro": [220, 220, 220],
	"ghostwhite": [248, 248, 255],
	"gold": [255, 215, 0],
	"goldenrod": [218, 165, 32],
	"gray": [128, 128, 128],
	"green": [0, 128, 0],
	"greenyellow": [173, 255, 47],
	"grey": [128, 128, 128],
	"honeydew": [240, 255, 240],
	"hotpink": [255, 105, 180],
	"indianred": [205, 92, 92],
	"indigo": [75, 0, 130],
	"ivory": [255, 255, 240],
	"khaki": [240, 230, 140],
	"lavender": [230, 230, 250],
	"lavenderblush": [255, 240, 245],
	"lawngreen": [124, 252, 0],
	"lemonchiffon": [255, 250, 205],
	"lightblue": [173, 216, 230],
	"lightcoral": [240, 128, 128],
	"lightcyan": [224, 255, 255],
	"lightgoldenrodyellow": [250, 250, 210],
	"lightgray": [211, 211, 211],
	"lightgreen": [144, 238, 144],
	"lightgrey": [211, 211, 211],
	"lightpink": [255, 182, 193],
	"lightsalmon": [255, 160, 122],
	"lightseagreen": [32, 178, 170],
	"lightskyblue": [135, 206, 250],
	"lightslategray": [119, 136, 153],
	"lightslategrey": [119, 136, 153],
	"lightsteelblue": [176, 196, 222],
	"lightyellow": [255, 255, 224],
	"lime": [0, 255, 0],
	"limegreen": [50, 205, 50],
	"linen": [250, 240, 230],
	"magenta": [255, 0, 255],
	"maroon": [128, 0, 0],
	"mediumaquamarine": [102, 205, 170],
	"mediumblue": [0, 0, 205],
	"mediumorchid": [186, 85, 211],
	"mediumpurple": [147, 112, 219],
	"mediumseagreen": [60, 179, 113],
	"mediumslateblue": [123, 104, 238],
	"mediumspringgreen": [0, 250, 154],
	"mediumturquoise": [72, 209, 204],
	"mediumvioletred": [199, 21, 133],
	"midnightblue": [25, 25, 112],
	"mintcream": [245, 255, 250],
	"mistyrose": [255, 228, 225],
	"moccasin": [255, 228, 181],
	"navajowhite": [255, 222, 173],
	"navy": [0, 0, 128],
	"oldlace": [253, 245, 230],
	"olive": [128, 128, 0],
	"olivedrab": [107, 142, 35],
	"orange": [255, 165, 0],
	"orangered": [255, 69, 0],
	"orchid": [218, 112, 214],
	"palegoldenrod": [238, 232, 170],
	"palegreen": [152, 251, 152],
	"paleturquoise": [175, 238, 238],
	"palevioletred": [219, 112, 147],
	"papayawhip": [255, 239, 213],
	"peachpuff": [255, 218, 185],
	"peru": [205, 133, 63],
	"pink": [255, 192, 203],
	"plum": [221, 160, 221],
	"powderblue": [176, 224, 230],
	"purple": [128, 0, 128],
	"rebeccapurple": [102, 51, 153],
	"red": [255, 0, 0],
	"rosybrown": [188, 143, 143],
	"royalblue": [65, 105, 225],
	"saddlebrown": [139, 69, 19],
	"salmon": [250, 128, 114],
	"sandybrown": [244, 164, 96],
	"seagreen": [46, 139, 87],
	"seashell": [255, 245, 238],
	"sienna": [160, 82, 45],
	"silver": [192, 192, 192],
	"skyblue": [135, 206, 235],
	"slateblue": [106, 90, 205],
	"slategray": [112, 128, 144],
	"slategrey": [112, 128, 144],
	"snow": [255, 250, 250],
	"springgreen": [0, 255, 127],
	"steelblue": [70, 130, 180],
	"tan": [210, 180, 140],
	"teal": [0, 128, 128],
	"thistle": [216, 191, 216],
	"tomato": [255, 99, 71],
	"turquoise": [64, 224, 208],
	"violet": [238, 130, 238],
	"wheat": [245, 222, 179],
	"white": [255, 255, 255],
	"whitesmoke": [245, 245, 245],
	"yellow": [255, 255, 0],
	"yellowgreen": [154, 205, 50]
};


/***/ }),

/***/ "./node_modules/concat-stream/index.js":
/*!*********************************************!*\
  !*** ./node_modules/concat-stream/index.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var Writable = __webpack_require__(/*! readable-stream */ "./node_modules/readable-stream/readable.js").Writable
var inherits = __webpack_require__(/*! inherits */ "./node_modules/inherits/inherits.js")
var bufferFrom = __webpack_require__(/*! buffer-from */ "./node_modules/buffer-from/index.js")

if (typeof Uint8Array === 'undefined') {
  var U8 = __webpack_require__(/*! typedarray */ "./node_modules/typedarray/index.js").Uint8Array
} else {
  var U8 = Uint8Array
}

function ConcatStream(opts, cb) {
  if (!(this instanceof ConcatStream)) return new ConcatStream(opts, cb)

  if (typeof opts === 'function') {
    cb = opts
    opts = {}
  }
  if (!opts) opts = {}

  var encoding = opts.encoding
  var shouldInferEncoding = false

  if (!encoding) {
    shouldInferEncoding = true
  } else {
    encoding =  String(encoding).toLowerCase()
    if (encoding === 'u8' || encoding === 'uint8') {
      encoding = 'uint8array'
    }
  }

  Writable.call(this, { objectMode: true })

  this.encoding = encoding
  this.shouldInferEncoding = shouldInferEncoding

  if (cb) this.on('finish', function () { cb(this.getBody()) })
  this.body = []
}

module.exports = ConcatStream
inherits(ConcatStream, Writable)

ConcatStream.prototype._write = function(chunk, enc, next) {
  this.body.push(chunk)
  next()
}

ConcatStream.prototype.inferEncoding = function (buff) {
  var firstBuffer = buff === undefined ? this.body[0] : buff;
  if (Buffer.isBuffer(firstBuffer)) return 'buffer'
  if (typeof Uint8Array !== 'undefined' && firstBuffer instanceof Uint8Array) return 'uint8array'
  if (Array.isArray(firstBuffer)) return 'array'
  if (typeof firstBuffer === 'string') return 'string'
  if (Object.prototype.toString.call(firstBuffer) === "[object Object]") return 'object'
  return 'buffer'
}

ConcatStream.prototype.getBody = function () {
  if (!this.encoding && this.body.length === 0) return []
  if (this.shouldInferEncoding) this.encoding = this.inferEncoding()
  if (this.encoding === 'array') return arrayConcat(this.body)
  if (this.encoding === 'string') return stringConcat(this.body)
  if (this.encoding === 'buffer') return bufferConcat(this.body)
  if (this.encoding === 'uint8array') return u8Concat(this.body)
  return this.body
}

var isArray = Array.isArray || function (arr) {
  return Object.prototype.toString.call(arr) == '[object Array]'
}

function isArrayish (arr) {
  return /Array\]$/.test(Object.prototype.toString.call(arr))
}

function isBufferish (p) {
  return typeof p === 'string' || isArrayish(p) || (p && typeof p.subarray === 'function')
}

function stringConcat (parts) {
  var strings = []
  var needsToString = false
  for (var i = 0; i < parts.length; i++) {
    var p = parts[i]
    if (typeof p === 'string') {
      strings.push(p)
    } else if (Buffer.isBuffer(p)) {
      strings.push(p)
    } else if (isBufferish(p)) {
      strings.push(bufferFrom(p))
    } else {
      strings.push(bufferFrom(String(p)))
    }
  }
  if (Buffer.isBuffer(parts[0])) {
    strings = Buffer.concat(strings)
    strings = strings.toString('utf8')
  } else {
    strings = strings.join('')
  }
  return strings
}

function bufferConcat (parts) {
  var bufs = []
  for (var i = 0; i < parts.length; i++) {
    var p = parts[i]
    if (Buffer.isBuffer(p)) {
      bufs.push(p)
    } else if (isBufferish(p)) {
      bufs.push(bufferFrom(p))
    } else {
      bufs.push(bufferFrom(String(p)))
    }
  }
  return Buffer.concat(bufs)
}

function arrayConcat (parts) {
  var res = []
  for (var i = 0; i < parts.length; i++) {
    res.push.apply(res, parts[i])
  }
  return res
}

function u8Concat (parts) {
  var len = 0
  for (var i = 0; i < parts.length; i++) {
    if (typeof parts[i] === 'string') {
      parts[i] = bufferFrom(parts[i])
    }
    len += parts[i].length
  }
  var u8 = new U8(len)
  for (var i = 0, offset = 0; i < parts.length; i++) {
    var part = parts[i]
    for (var j = 0; j < part.length; j++) {
      u8[offset++] = part[j]
    }
  }
  return u8
}


/***/ }),

/***/ "./node_modules/core-js/library/fn/array/filter.js":
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/fn/array/filter.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.array.filter */ "./node_modules/core-js/library/modules/es6.array.filter.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Array.filter;


/***/ }),

/***/ "./node_modules/core-js/library/fn/array/for-each.js":
/*!***********************************************************!*\
  !*** ./node_modules/core-js/library/fn/array/for-each.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.array.for-each */ "./node_modules/core-js/library/modules/es6.array.for-each.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Array.forEach;


/***/ }),

/***/ "./node_modules/core-js/library/fn/array/index-of.js":
/*!***********************************************************!*\
  !*** ./node_modules/core-js/library/fn/array/index-of.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.array.index-of */ "./node_modules/core-js/library/modules/es6.array.index-of.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Array.indexOf;


/***/ }),

/***/ "./node_modules/core-js/library/fn/array/is-array.js":
/*!***********************************************************!*\
  !*** ./node_modules/core-js/library/fn/array/is-array.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.array.is-array */ "./node_modules/core-js/library/modules/es6.array.is-array.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Array.isArray;


/***/ }),

/***/ "./node_modules/core-js/library/fn/array/map.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/fn/array/map.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.array.map */ "./node_modules/core-js/library/modules/es6.array.map.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Array.map;


/***/ }),

/***/ "./node_modules/core-js/library/fn/array/reduce-right.js":
/*!***************************************************************!*\
  !*** ./node_modules/core-js/library/fn/array/reduce-right.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.array.reduce-right */ "./node_modules/core-js/library/modules/es6.array.reduce-right.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Array.reduceRight;


/***/ }),

/***/ "./node_modules/core-js/library/fn/array/reduce.js":
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/fn/array/reduce.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.array.reduce */ "./node_modules/core-js/library/modules/es6.array.reduce.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Array.reduce;


/***/ }),

/***/ "./node_modules/core-js/library/fn/array/some.js":
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/fn/array/some.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.array.some */ "./node_modules/core-js/library/modules/es6.array.some.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Array.some;


/***/ }),

/***/ "./node_modules/core-js/library/fn/map.js":
/*!************************************************!*\
  !*** ./node_modules/core-js/library/fn/map.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../modules/es6.object.to-string */ "./node_modules/core-js/library/modules/es6.object.to-string.js");
__webpack_require__(/*! ../modules/es6.string.iterator */ "./node_modules/core-js/library/modules/es6.string.iterator.js");
__webpack_require__(/*! ../modules/web.dom.iterable */ "./node_modules/core-js/library/modules/web.dom.iterable.js");
__webpack_require__(/*! ../modules/es6.map */ "./node_modules/core-js/library/modules/es6.map.js");
__webpack_require__(/*! ../modules/es7.map.to-json */ "./node_modules/core-js/library/modules/es7.map.to-json.js");
__webpack_require__(/*! ../modules/es7.map.of */ "./node_modules/core-js/library/modules/es7.map.of.js");
__webpack_require__(/*! ../modules/es7.map.from */ "./node_modules/core-js/library/modules/es7.map.from.js");
module.exports = __webpack_require__(/*! ../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Map;


/***/ }),

/***/ "./node_modules/core-js/library/fn/object/assign.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/fn/object/assign.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.object.assign */ "./node_modules/core-js/library/modules/es6.object.assign.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Object.assign;


/***/ }),

/***/ "./node_modules/core-js/library/fn/object/create.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/fn/object/create.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.object.create */ "./node_modules/core-js/library/modules/es6.object.create.js");
var $Object = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Object;
module.exports = function create(P, D) {
  return $Object.create(P, D);
};


/***/ }),

/***/ "./node_modules/core-js/library/fn/object/define-property.js":
/*!*******************************************************************!*\
  !*** ./node_modules/core-js/library/fn/object/define-property.js ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.object.define-property */ "./node_modules/core-js/library/modules/es6.object.define-property.js");
var $Object = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Object;
module.exports = function defineProperty(it, key, desc) {
  return $Object.defineProperty(it, key, desc);
};


/***/ }),

/***/ "./node_modules/core-js/library/fn/object/keys.js":
/*!********************************************************!*\
  !*** ./node_modules/core-js/library/fn/object/keys.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.object.keys */ "./node_modules/core-js/library/modules/es6.object.keys.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").Object.keys;


/***/ }),

/***/ "./node_modules/core-js/library/fn/string/ends-with.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/fn/string/ends-with.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ../../modules/es6.string.ends-with */ "./node_modules/core-js/library/modules/es6.string.ends-with.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "./node_modules/core-js/library/modules/_core.js").String.endsWith;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_a-function.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_a-function.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = function (it) {
  if (typeof it != 'function') throw TypeError(it + ' is not a function!');
  return it;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_add-to-unscopables.js":
/*!*********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_add-to-unscopables.js ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = function () { /* empty */ };


/***/ }),

/***/ "./node_modules/core-js/library/modules/_an-instance.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_an-instance.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = function (it, Constructor, name, forbiddenField) {
  if (!(it instanceof Constructor) || (forbiddenField !== undefined && forbiddenField in it)) {
    throw TypeError(name + ': incorrect invocation!');
  } return it;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_an-object.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_an-object.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
module.exports = function (it) {
  if (!isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_array-from-iterable.js":
/*!**********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_array-from-iterable.js ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var forOf = __webpack_require__(/*! ./_for-of */ "./node_modules/core-js/library/modules/_for-of.js");

module.exports = function (iter, ITERATOR) {
  var result = [];
  forOf(iter, false, result.push, result, ITERATOR);
  return result;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_array-includes.js":
/*!*****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_array-includes.js ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// false -> Array#indexOf
// true  -> Array#includes
var toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/library/modules/_to-iobject.js");
var toLength = __webpack_require__(/*! ./_to-length */ "./node_modules/core-js/library/modules/_to-length.js");
var toAbsoluteIndex = __webpack_require__(/*! ./_to-absolute-index */ "./node_modules/core-js/library/modules/_to-absolute-index.js");
module.exports = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIObject($this);
    var length = toLength(O.length);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) if (IS_INCLUDES || index in O) {
      if (O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_array-methods.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_array-methods.js ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 0 -> Array#forEach
// 1 -> Array#map
// 2 -> Array#filter
// 3 -> Array#some
// 4 -> Array#every
// 5 -> Array#find
// 6 -> Array#findIndex
var ctx = __webpack_require__(/*! ./_ctx */ "./node_modules/core-js/library/modules/_ctx.js");
var IObject = __webpack_require__(/*! ./_iobject */ "./node_modules/core-js/library/modules/_iobject.js");
var toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/library/modules/_to-object.js");
var toLength = __webpack_require__(/*! ./_to-length */ "./node_modules/core-js/library/modules/_to-length.js");
var asc = __webpack_require__(/*! ./_array-species-create */ "./node_modules/core-js/library/modules/_array-species-create.js");
module.exports = function (TYPE, $create) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  var create = $create || asc;
  return function ($this, callbackfn, that) {
    var O = toObject($this);
    var self = IObject(O);
    var f = ctx(callbackfn, that, 3);
    var length = toLength(self.length);
    var index = 0;
    var result = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
    var val, res;
    for (;length > index; index++) if (NO_HOLES || index in self) {
      val = self[index];
      res = f(val, index, O);
      if (TYPE) {
        if (IS_MAP) result[index] = res;   // map
        else if (res) switch (TYPE) {
          case 3: return true;             // some
          case 5: return val;              // find
          case 6: return index;            // findIndex
          case 2: result.push(val);        // filter
        } else if (IS_EVERY) return false; // every
      }
    }
    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : result;
  };
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_array-reduce.js":
/*!***************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_array-reduce.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var aFunction = __webpack_require__(/*! ./_a-function */ "./node_modules/core-js/library/modules/_a-function.js");
var toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/library/modules/_to-object.js");
var IObject = __webpack_require__(/*! ./_iobject */ "./node_modules/core-js/library/modules/_iobject.js");
var toLength = __webpack_require__(/*! ./_to-length */ "./node_modules/core-js/library/modules/_to-length.js");

module.exports = function (that, callbackfn, aLen, memo, isRight) {
  aFunction(callbackfn);
  var O = toObject(that);
  var self = IObject(O);
  var length = toLength(O.length);
  var index = isRight ? length - 1 : 0;
  var i = isRight ? -1 : 1;
  if (aLen < 2) for (;;) {
    if (index in self) {
      memo = self[index];
      index += i;
      break;
    }
    index += i;
    if (isRight ? index < 0 : length <= index) {
      throw TypeError('Reduce of empty array with no initial value');
    }
  }
  for (;isRight ? index >= 0 : length > index; index += i) if (index in self) {
    memo = callbackfn(memo, self[index], index, O);
  }
  return memo;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_array-species-constructor.js":
/*!****************************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_array-species-constructor.js ***!
  \****************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
var isArray = __webpack_require__(/*! ./_is-array */ "./node_modules/core-js/library/modules/_is-array.js");
var SPECIES = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('species');

module.exports = function (original) {
  var C;
  if (isArray(original)) {
    C = original.constructor;
    // cross-realm fallback
    if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;
    if (isObject(C)) {
      C = C[SPECIES];
      if (C === null) C = undefined;
    }
  } return C === undefined ? Array : C;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_array-species-create.js":
/*!***********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_array-species-create.js ***!
  \***********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 9.4.2.3 ArraySpeciesCreate(originalArray, length)
var speciesConstructor = __webpack_require__(/*! ./_array-species-constructor */ "./node_modules/core-js/library/modules/_array-species-constructor.js");

module.exports = function (original, length) {
  return new (speciesConstructor(original))(length);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_classof.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_classof.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// getting tag from 19.1.3.6 Object.prototype.toString()
var cof = __webpack_require__(/*! ./_cof */ "./node_modules/core-js/library/modules/_cof.js");
var TAG = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('toStringTag');
// ES3 wrong here
var ARG = cof(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (e) { /* empty */ }
};

module.exports = function (it) {
  var O, T, B;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (T = tryGet(O = Object(it), TAG)) == 'string' ? T
    // builtinTag case
    : ARG ? cof(O)
    // ES3 arguments fallback
    : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_cof.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_cof.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_collection-strong.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_collection-strong.js ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var dP = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js").f;
var create = __webpack_require__(/*! ./_object-create */ "./node_modules/core-js/library/modules/_object-create.js");
var redefineAll = __webpack_require__(/*! ./_redefine-all */ "./node_modules/core-js/library/modules/_redefine-all.js");
var ctx = __webpack_require__(/*! ./_ctx */ "./node_modules/core-js/library/modules/_ctx.js");
var anInstance = __webpack_require__(/*! ./_an-instance */ "./node_modules/core-js/library/modules/_an-instance.js");
var forOf = __webpack_require__(/*! ./_for-of */ "./node_modules/core-js/library/modules/_for-of.js");
var $iterDefine = __webpack_require__(/*! ./_iter-define */ "./node_modules/core-js/library/modules/_iter-define.js");
var step = __webpack_require__(/*! ./_iter-step */ "./node_modules/core-js/library/modules/_iter-step.js");
var setSpecies = __webpack_require__(/*! ./_set-species */ "./node_modules/core-js/library/modules/_set-species.js");
var DESCRIPTORS = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js");
var fastKey = __webpack_require__(/*! ./_meta */ "./node_modules/core-js/library/modules/_meta.js").fastKey;
var validate = __webpack_require__(/*! ./_validate-collection */ "./node_modules/core-js/library/modules/_validate-collection.js");
var SIZE = DESCRIPTORS ? '_s' : 'size';

var getEntry = function (that, key) {
  // fast case
  var index = fastKey(key);
  var entry;
  if (index !== 'F') return that._i[index];
  // frozen object case
  for (entry = that._f; entry; entry = entry.n) {
    if (entry.k == key) return entry;
  }
};

module.exports = {
  getConstructor: function (wrapper, NAME, IS_MAP, ADDER) {
    var C = wrapper(function (that, iterable) {
      anInstance(that, C, NAME, '_i');
      that._t = NAME;         // collection type
      that._i = create(null); // index
      that._f = undefined;    // first entry
      that._l = undefined;    // last entry
      that[SIZE] = 0;         // size
      if (iterable != undefined) forOf(iterable, IS_MAP, that[ADDER], that);
    });
    redefineAll(C.prototype, {
      // 23.1.3.1 Map.prototype.clear()
      // 23.2.3.2 Set.prototype.clear()
      clear: function clear() {
        for (var that = validate(this, NAME), data = that._i, entry = that._f; entry; entry = entry.n) {
          entry.r = true;
          if (entry.p) entry.p = entry.p.n = undefined;
          delete data[entry.i];
        }
        that._f = that._l = undefined;
        that[SIZE] = 0;
      },
      // 23.1.3.3 Map.prototype.delete(key)
      // 23.2.3.4 Set.prototype.delete(value)
      'delete': function (key) {
        var that = validate(this, NAME);
        var entry = getEntry(that, key);
        if (entry) {
          var next = entry.n;
          var prev = entry.p;
          delete that._i[entry.i];
          entry.r = true;
          if (prev) prev.n = next;
          if (next) next.p = prev;
          if (that._f == entry) that._f = next;
          if (that._l == entry) that._l = prev;
          that[SIZE]--;
        } return !!entry;
      },
      // 23.2.3.6 Set.prototype.forEach(callbackfn, thisArg = undefined)
      // 23.1.3.5 Map.prototype.forEach(callbackfn, thisArg = undefined)
      forEach: function forEach(callbackfn /* , that = undefined */) {
        validate(this, NAME);
        var f = ctx(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
        var entry;
        while (entry = entry ? entry.n : this._f) {
          f(entry.v, entry.k, this);
          // revert to the last existing entry
          while (entry && entry.r) entry = entry.p;
        }
      },
      // 23.1.3.7 Map.prototype.has(key)
      // 23.2.3.7 Set.prototype.has(value)
      has: function has(key) {
        return !!getEntry(validate(this, NAME), key);
      }
    });
    if (DESCRIPTORS) dP(C.prototype, 'size', {
      get: function () {
        return validate(this, NAME)[SIZE];
      }
    });
    return C;
  },
  def: function (that, key, value) {
    var entry = getEntry(that, key);
    var prev, index;
    // change existing entry
    if (entry) {
      entry.v = value;
    // create new entry
    } else {
      that._l = entry = {
        i: index = fastKey(key, true), // <- index
        k: key,                        // <- key
        v: value,                      // <- value
        p: prev = that._l,             // <- previous entry
        n: undefined,                  // <- next entry
        r: false                       // <- removed
      };
      if (!that._f) that._f = entry;
      if (prev) prev.n = entry;
      that[SIZE]++;
      // add to index
      if (index !== 'F') that._i[index] = entry;
    } return that;
  },
  getEntry: getEntry,
  setStrong: function (C, NAME, IS_MAP) {
    // add .keys, .values, .entries, [@@iterator]
    // 23.1.3.4, 23.1.3.8, 23.1.3.11, 23.1.3.12, 23.2.3.5, 23.2.3.8, 23.2.3.10, 23.2.3.11
    $iterDefine(C, NAME, function (iterated, kind) {
      this._t = validate(iterated, NAME); // target
      this._k = kind;                     // kind
      this._l = undefined;                // previous
    }, function () {
      var that = this;
      var kind = that._k;
      var entry = that._l;
      // revert to the last existing entry
      while (entry && entry.r) entry = entry.p;
      // get next entry
      if (!that._t || !(that._l = entry = entry ? entry.n : that._t._f)) {
        // or finish the iteration
        that._t = undefined;
        return step(1);
      }
      // return step by kind
      if (kind == 'keys') return step(0, entry.k);
      if (kind == 'values') return step(0, entry.v);
      return step(0, [entry.k, entry.v]);
    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);

    // add [@@species], 23.1.2.2, 23.2.2.2
    setSpecies(NAME);
  }
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_collection-to-json.js":
/*!*********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_collection-to-json.js ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// https://github.com/DavidBruant/Map-Set.prototype.toJSON
var classof = __webpack_require__(/*! ./_classof */ "./node_modules/core-js/library/modules/_classof.js");
var from = __webpack_require__(/*! ./_array-from-iterable */ "./node_modules/core-js/library/modules/_array-from-iterable.js");
module.exports = function (NAME) {
  return function toJSON() {
    if (classof(this) != NAME) throw TypeError(NAME + "#toJSON isn't generic");
    return from(this);
  };
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_collection.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_collection.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js");
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var meta = __webpack_require__(/*! ./_meta */ "./node_modules/core-js/library/modules/_meta.js");
var fails = __webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js");
var hide = __webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js");
var redefineAll = __webpack_require__(/*! ./_redefine-all */ "./node_modules/core-js/library/modules/_redefine-all.js");
var forOf = __webpack_require__(/*! ./_for-of */ "./node_modules/core-js/library/modules/_for-of.js");
var anInstance = __webpack_require__(/*! ./_an-instance */ "./node_modules/core-js/library/modules/_an-instance.js");
var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
var setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ "./node_modules/core-js/library/modules/_set-to-string-tag.js");
var dP = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js").f;
var each = __webpack_require__(/*! ./_array-methods */ "./node_modules/core-js/library/modules/_array-methods.js")(0);
var DESCRIPTORS = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js");

module.exports = function (NAME, wrapper, methods, common, IS_MAP, IS_WEAK) {
  var Base = global[NAME];
  var C = Base;
  var ADDER = IS_MAP ? 'set' : 'add';
  var proto = C && C.prototype;
  var O = {};
  if (!DESCRIPTORS || typeof C != 'function' || !(IS_WEAK || proto.forEach && !fails(function () {
    new C().entries().next();
  }))) {
    // create collection constructor
    C = common.getConstructor(wrapper, NAME, IS_MAP, ADDER);
    redefineAll(C.prototype, methods);
    meta.NEED = true;
  } else {
    C = wrapper(function (target, iterable) {
      anInstance(target, C, NAME, '_c');
      target._c = new Base();
      if (iterable != undefined) forOf(iterable, IS_MAP, target[ADDER], target);
    });
    each('add,clear,delete,forEach,get,has,set,keys,values,entries,toJSON'.split(','), function (KEY) {
      var IS_ADDER = KEY == 'add' || KEY == 'set';
      if (KEY in proto && !(IS_WEAK && KEY == 'clear')) hide(C.prototype, KEY, function (a, b) {
        anInstance(this, C, KEY);
        if (!IS_ADDER && IS_WEAK && !isObject(a)) return KEY == 'get' ? undefined : false;
        var result = this._c[KEY](a === 0 ? 0 : a, b);
        return IS_ADDER ? this : result;
      });
    });
    IS_WEAK || dP(C.prototype, 'size', {
      get: function () {
        return this._c.size;
      }
    });
  }

  setToStringTag(C, NAME);

  O[NAME] = C;
  $export($export.G + $export.W + $export.F, O);

  if (!IS_WEAK) common.setStrong(C, NAME, IS_MAP);

  return C;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_core.js":
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_core.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var core = module.exports = { version: '2.6.12' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef


/***/ }),

/***/ "./node_modules/core-js/library/modules/_ctx.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_ctx.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// optional / simple context binding
var aFunction = __webpack_require__(/*! ./_a-function */ "./node_modules/core-js/library/modules/_a-function.js");
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_defined.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_defined.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

// 7.2.1 RequireObjectCoercible(argument)
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on  " + it);
  return it;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_descriptors.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_descriptors.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// Thank's IE8 for his funny defineProperty
module.exports = !__webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js")(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/_dom-create.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_dom-create.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
var document = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js").document;
// typeof document.createElement is 'object' in old IE
var is = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
  return is ? document.createElement(it) : {};
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_enum-bug-keys.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_enum-bug-keys.js ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

// IE 8- don't enum bug keys
module.exports = (
  'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
).split(',');


/***/ }),

/***/ "./node_modules/core-js/library/modules/_export.js":
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_export.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js");
var core = __webpack_require__(/*! ./_core */ "./node_modules/core-js/library/modules/_core.js");
var ctx = __webpack_require__(/*! ./_ctx */ "./node_modules/core-js/library/modules/_ctx.js");
var hide = __webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js");
var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/library/modules/_has.js");
var PROTOTYPE = 'prototype';

var $export = function (type, name, source) {
  var IS_FORCED = type & $export.F;
  var IS_GLOBAL = type & $export.G;
  var IS_STATIC = type & $export.S;
  var IS_PROTO = type & $export.P;
  var IS_BIND = type & $export.B;
  var IS_WRAP = type & $export.W;
  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
  var expProto = exports[PROTOTYPE];
  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE];
  var key, own, out;
  if (IS_GLOBAL) source = name;
  for (key in source) {
    // contains in native
    own = !IS_FORCED && target && target[key] !== undefined;
    if (own && has(exports, key)) continue;
    // export native or passed
    out = own ? target[key] : source[key];
    // prevent global pollution for namespaces
    exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
    // bind timers to global for call from export context
    : IS_BIND && own ? ctx(out, global)
    // wrap global constructors for prevent change them in library
    : IS_WRAP && target[key] == out ? (function (C) {
      var F = function (a, b, c) {
        if (this instanceof C) {
          switch (arguments.length) {
            case 0: return new C();
            case 1: return new C(a);
            case 2: return new C(a, b);
          } return new C(a, b, c);
        } return C.apply(this, arguments);
      };
      F[PROTOTYPE] = C[PROTOTYPE];
      return F;
    // make static versions for prototype methods
    })(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
    // export proto methods to core.%CONSTRUCTOR%.methods.%NAME%
    if (IS_PROTO) {
      (exports.virtual || (exports.virtual = {}))[key] = out;
      // export proto methods to core.%CONSTRUCTOR%.prototype.%NAME%
      if (type & $export.R && expProto && !expProto[key]) hide(expProto, key, out);
    }
  }
};
// type bitmap
$export.F = 1;   // forced
$export.G = 2;   // global
$export.S = 4;   // static
$export.P = 8;   // proto
$export.B = 16;  // bind
$export.W = 32;  // wrap
$export.U = 64;  // safe
$export.R = 128; // real proto method for `library`
module.exports = $export;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_fails-is-regexp.js":
/*!******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_fails-is-regexp.js ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var MATCH = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('match');
module.exports = function (KEY) {
  var re = /./;
  try {
    '/./'[KEY](re);
  } catch (e) {
    try {
      re[MATCH] = false;
      return !'/./'[KEY](re);
    } catch (f) { /* empty */ }
  } return true;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_fails.js":
/*!********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_fails.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (e) {
    return true;
  }
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_for-of.js":
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_for-of.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var ctx = __webpack_require__(/*! ./_ctx */ "./node_modules/core-js/library/modules/_ctx.js");
var call = __webpack_require__(/*! ./_iter-call */ "./node_modules/core-js/library/modules/_iter-call.js");
var isArrayIter = __webpack_require__(/*! ./_is-array-iter */ "./node_modules/core-js/library/modules/_is-array-iter.js");
var anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/library/modules/_an-object.js");
var toLength = __webpack_require__(/*! ./_to-length */ "./node_modules/core-js/library/modules/_to-length.js");
var getIterFn = __webpack_require__(/*! ./core.get-iterator-method */ "./node_modules/core-js/library/modules/core.get-iterator-method.js");
var BREAK = {};
var RETURN = {};
var exports = module.exports = function (iterable, entries, fn, that, ITERATOR) {
  var iterFn = ITERATOR ? function () { return iterable; } : getIterFn(iterable);
  var f = ctx(fn, that, entries ? 2 : 1);
  var index = 0;
  var length, step, iterator, result;
  if (typeof iterFn != 'function') throw TypeError(iterable + ' is not iterable!');
  // fast case for arrays with default iterator
  if (isArrayIter(iterFn)) for (length = toLength(iterable.length); length > index; index++) {
    result = entries ? f(anObject(step = iterable[index])[0], step[1]) : f(iterable[index]);
    if (result === BREAK || result === RETURN) return result;
  } else for (iterator = iterFn.call(iterable); !(step = iterator.next()).done;) {
    result = call(iterator, f, step.value, entries);
    if (result === BREAK || result === RETURN) return result;
  }
};
exports.BREAK = BREAK;
exports.RETURN = RETURN;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_global.js":
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_global.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self
  // eslint-disable-next-line no-new-func
  : Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef


/***/ }),

/***/ "./node_modules/core-js/library/modules/_has.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_has.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var hasOwnProperty = {}.hasOwnProperty;
module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_hide.js":
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_hide.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js");
var createDesc = __webpack_require__(/*! ./_property-desc */ "./node_modules/core-js/library/modules/_property-desc.js");
module.exports = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js") ? function (object, key, value) {
  return dP.f(object, key, createDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_html.js":
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_html.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var document = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js").document;
module.exports = document && document.documentElement;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_ie8-dom-define.js":
/*!*****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_ie8-dom-define.js ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = !__webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js") && !__webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js")(function () {
  return Object.defineProperty(__webpack_require__(/*! ./_dom-create */ "./node_modules/core-js/library/modules/_dom-create.js")('div'), 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/_iobject.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iobject.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var cof = __webpack_require__(/*! ./_cof */ "./node_modules/core-js/library/modules/_cof.js");
// eslint-disable-next-line no-prototype-builtins
module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
  return cof(it) == 'String' ? it.split('') : Object(it);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_is-array-iter.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_is-array-iter.js ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// check on default Array iterator
var Iterators = __webpack_require__(/*! ./_iterators */ "./node_modules/core-js/library/modules/_iterators.js");
var ITERATOR = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('iterator');
var ArrayProto = Array.prototype;

module.exports = function (it) {
  return it !== undefined && (Iterators.Array === it || ArrayProto[ITERATOR] === it);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_is-array.js":
/*!***********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_is-array.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 7.2.2 IsArray(argument)
var cof = __webpack_require__(/*! ./_cof */ "./node_modules/core-js/library/modules/_cof.js");
module.exports = Array.isArray || function isArray(arg) {
  return cof(arg) == 'Array';
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_is-object.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_is-object.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_is-regexp.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_is-regexp.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 7.2.8 IsRegExp(argument)
var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
var cof = __webpack_require__(/*! ./_cof */ "./node_modules/core-js/library/modules/_cof.js");
var MATCH = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('match');
module.exports = function (it) {
  var isRegExp;
  return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : cof(it) == 'RegExp');
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_iter-call.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iter-call.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// call something on iterator step with safe closing on error
var anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/library/modules/_an-object.js");
module.exports = function (iterator, fn, value, entries) {
  try {
    return entries ? fn(anObject(value)[0], value[1]) : fn(value);
  // 7.4.6 IteratorClose(iterator, completion)
  } catch (e) {
    var ret = iterator['return'];
    if (ret !== undefined) anObject(ret.call(iterator));
    throw e;
  }
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_iter-create.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iter-create.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var create = __webpack_require__(/*! ./_object-create */ "./node_modules/core-js/library/modules/_object-create.js");
var descriptor = __webpack_require__(/*! ./_property-desc */ "./node_modules/core-js/library/modules/_property-desc.js");
var setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ "./node_modules/core-js/library/modules/_set-to-string-tag.js");
var IteratorPrototype = {};

// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
__webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js")(IteratorPrototype, __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('iterator'), function () { return this; });

module.exports = function (Constructor, NAME, next) {
  Constructor.prototype = create(IteratorPrototype, { next: descriptor(1, next) });
  setToStringTag(Constructor, NAME + ' Iterator');
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_iter-define.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iter-define.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var LIBRARY = __webpack_require__(/*! ./_library */ "./node_modules/core-js/library/modules/_library.js");
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var redefine = __webpack_require__(/*! ./_redefine */ "./node_modules/core-js/library/modules/_redefine.js");
var hide = __webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js");
var Iterators = __webpack_require__(/*! ./_iterators */ "./node_modules/core-js/library/modules/_iterators.js");
var $iterCreate = __webpack_require__(/*! ./_iter-create */ "./node_modules/core-js/library/modules/_iter-create.js");
var setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ "./node_modules/core-js/library/modules/_set-to-string-tag.js");
var getPrototypeOf = __webpack_require__(/*! ./_object-gpo */ "./node_modules/core-js/library/modules/_object-gpo.js");
var ITERATOR = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('iterator');
var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
var FF_ITERATOR = '@@iterator';
var KEYS = 'keys';
var VALUES = 'values';

var returnThis = function () { return this; };

module.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
  $iterCreate(Constructor, NAME, next);
  var getMethod = function (kind) {
    if (!BUGGY && kind in proto) return proto[kind];
    switch (kind) {
      case KEYS: return function keys() { return new Constructor(this, kind); };
      case VALUES: return function values() { return new Constructor(this, kind); };
    } return function entries() { return new Constructor(this, kind); };
  };
  var TAG = NAME + ' Iterator';
  var DEF_VALUES = DEFAULT == VALUES;
  var VALUES_BUG = false;
  var proto = Base.prototype;
  var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
  var $default = $native || getMethod(DEFAULT);
  var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
  var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
  var methods, key, IteratorPrototype;
  // Fix native
  if ($anyNative) {
    IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));
    if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
      // Set @@toStringTag to native iterators
      setToStringTag(IteratorPrototype, TAG, true);
      // fix for some old engines
      if (!LIBRARY && typeof IteratorPrototype[ITERATOR] != 'function') hide(IteratorPrototype, ITERATOR, returnThis);
    }
  }
  // fix Array#{values, @@iterator}.name in V8 / FF
  if (DEF_VALUES && $native && $native.name !== VALUES) {
    VALUES_BUG = true;
    $default = function values() { return $native.call(this); };
  }
  // Define iterator
  if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
    hide(proto, ITERATOR, $default);
  }
  // Plug for library
  Iterators[NAME] = $default;
  Iterators[TAG] = returnThis;
  if (DEFAULT) {
    methods = {
      values: DEF_VALUES ? $default : getMethod(VALUES),
      keys: IS_SET ? $default : getMethod(KEYS),
      entries: $entries
    };
    if (FORCED) for (key in methods) {
      if (!(key in proto)) redefine(proto, key, methods[key]);
    } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
  }
  return methods;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_iter-step.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iter-step.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = function (done, value) {
  return { value: value, done: !!done };
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_iterators.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_iterators.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = {};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_library.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_library.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = true;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_meta.js":
/*!*******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_meta.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var META = __webpack_require__(/*! ./_uid */ "./node_modules/core-js/library/modules/_uid.js")('meta');
var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/library/modules/_has.js");
var setDesc = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js").f;
var id = 0;
var isExtensible = Object.isExtensible || function () {
  return true;
};
var FREEZE = !__webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js")(function () {
  return isExtensible(Object.preventExtensions({}));
});
var setMeta = function (it) {
  setDesc(it, META, { value: {
    i: 'O' + ++id, // object ID
    w: {}          // weak collections IDs
  } });
};
var fastKey = function (it, create) {
  // return primitive with prefix
  if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return 'F';
    // not necessary to add metadata
    if (!create) return 'E';
    // add missing metadata
    setMeta(it);
  // return object ID
  } return it[META].i;
};
var getWeak = function (it, create) {
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return true;
    // not necessary to add metadata
    if (!create) return false;
    // add missing metadata
    setMeta(it);
  // return hash weak collections IDs
  } return it[META].w;
};
// add metadata on freeze-family methods calling
var onFreeze = function (it) {
  if (FREEZE && meta.NEED && isExtensible(it) && !has(it, META)) setMeta(it);
  return it;
};
var meta = module.exports = {
  KEY: META,
  NEED: false,
  fastKey: fastKey,
  getWeak: getWeak,
  onFreeze: onFreeze
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-assign.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-assign.js ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// 19.1.2.1 Object.assign(target, source, ...)
var DESCRIPTORS = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js");
var getKeys = __webpack_require__(/*! ./_object-keys */ "./node_modules/core-js/library/modules/_object-keys.js");
var gOPS = __webpack_require__(/*! ./_object-gops */ "./node_modules/core-js/library/modules/_object-gops.js");
var pIE = __webpack_require__(/*! ./_object-pie */ "./node_modules/core-js/library/modules/_object-pie.js");
var toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/library/modules/_to-object.js");
var IObject = __webpack_require__(/*! ./_iobject */ "./node_modules/core-js/library/modules/_iobject.js");
var $assign = Object.assign;

// should work with symbols and should have deterministic property order (V8 bug)
module.exports = !$assign || __webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js")(function () {
  var A = {};
  var B = {};
  // eslint-disable-next-line no-undef
  var S = Symbol();
  var K = 'abcdefghijklmnopqrst';
  A[S] = 7;
  K.split('').forEach(function (k) { B[k] = k; });
  return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars
  var T = toObject(target);
  var aLen = arguments.length;
  var index = 1;
  var getSymbols = gOPS.f;
  var isEnum = pIE.f;
  while (aLen > index) {
    var S = IObject(arguments[index++]);
    var keys = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) {
      key = keys[j++];
      if (!DESCRIPTORS || isEnum.call(S, key)) T[key] = S[key];
    }
  } return T;
} : $assign;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-create.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-create.js ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
var anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/library/modules/_an-object.js");
var dPs = __webpack_require__(/*! ./_object-dps */ "./node_modules/core-js/library/modules/_object-dps.js");
var enumBugKeys = __webpack_require__(/*! ./_enum-bug-keys */ "./node_modules/core-js/library/modules/_enum-bug-keys.js");
var IE_PROTO = __webpack_require__(/*! ./_shared-key */ "./node_modules/core-js/library/modules/_shared-key.js")('IE_PROTO');
var Empty = function () { /* empty */ };
var PROTOTYPE = 'prototype';

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var createDict = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = __webpack_require__(/*! ./_dom-create */ "./node_modules/core-js/library/modules/_dom-create.js")('iframe');
  var i = enumBugKeys.length;
  var lt = '<';
  var gt = '>';
  var iframeDocument;
  iframe.style.display = 'none';
  __webpack_require__(/*! ./_html */ "./node_modules/core-js/library/modules/_html.js").appendChild(iframe);
  iframe.src = 'javascript:'; // eslint-disable-line no-script-url
  // createDict = iframe.contentWindow.Object;
  // html.removeChild(iframe);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
  iframeDocument.close();
  createDict = iframeDocument.F;
  while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];
  return createDict();
};

module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    Empty[PROTOTYPE] = anObject(O);
    result = new Empty();
    Empty[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = createDict();
  return Properties === undefined ? result : dPs(result, Properties);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-dp.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-dp.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/library/modules/_an-object.js");
var IE8_DOM_DEFINE = __webpack_require__(/*! ./_ie8-dom-define */ "./node_modules/core-js/library/modules/_ie8-dom-define.js");
var toPrimitive = __webpack_require__(/*! ./_to-primitive */ "./node_modules/core-js/library/modules/_to-primitive.js");
var dP = Object.defineProperty;

exports.f = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js") ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return dP(O, P, Attributes);
  } catch (e) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-dps.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-dps.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var dP = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js");
var anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/library/modules/_an-object.js");
var getKeys = __webpack_require__(/*! ./_object-keys */ "./node_modules/core-js/library/modules/_object-keys.js");

module.exports = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js") ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject(O);
  var keys = getKeys(Properties);
  var length = keys.length;
  var i = 0;
  var P;
  while (length > i) dP.f(O, P = keys[i++], Properties[P]);
  return O;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-gops.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-gops.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

exports.f = Object.getOwnPropertySymbols;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-gpo.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-gpo.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)
var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/library/modules/_has.js");
var toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/library/modules/_to-object.js");
var IE_PROTO = __webpack_require__(/*! ./_shared-key */ "./node_modules/core-js/library/modules/_shared-key.js")('IE_PROTO');
var ObjectProto = Object.prototype;

module.exports = Object.getPrototypeOf || function (O) {
  O = toObject(O);
  if (has(O, IE_PROTO)) return O[IE_PROTO];
  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
    return O.constructor.prototype;
  } return O instanceof Object ? ObjectProto : null;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-keys-internal.js":
/*!***********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-keys-internal.js ***!
  \***********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/library/modules/_has.js");
var toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/library/modules/_to-iobject.js");
var arrayIndexOf = __webpack_require__(/*! ./_array-includes */ "./node_modules/core-js/library/modules/_array-includes.js")(false);
var IE_PROTO = __webpack_require__(/*! ./_shared-key */ "./node_modules/core-js/library/modules/_shared-key.js")('IE_PROTO');

module.exports = function (object, names) {
  var O = toIObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (has(O, key = names[i++])) {
    ~arrayIndexOf(result, key) || result.push(key);
  }
  return result;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-keys.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-keys.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.14 / 15.2.3.14 Object.keys(O)
var $keys = __webpack_require__(/*! ./_object-keys-internal */ "./node_modules/core-js/library/modules/_object-keys-internal.js");
var enumBugKeys = __webpack_require__(/*! ./_enum-bug-keys */ "./node_modules/core-js/library/modules/_enum-bug-keys.js");

module.exports = Object.keys || function keys(O) {
  return $keys(O, enumBugKeys);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-pie.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-pie.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

exports.f = {}.propertyIsEnumerable;


/***/ }),

/***/ "./node_modules/core-js/library/modules/_object-sap.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_object-sap.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// most Object methods by ES6 should accept primitives
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var core = __webpack_require__(/*! ./_core */ "./node_modules/core-js/library/modules/_core.js");
var fails = __webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js");
module.exports = function (KEY, exec) {
  var fn = (core.Object || {})[KEY] || Object[KEY];
  var exp = {};
  exp[KEY] = exec(fn);
  $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_property-desc.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_property-desc.js ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_redefine-all.js":
/*!***************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_redefine-all.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var hide = __webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js");
module.exports = function (target, src, safe) {
  for (var key in src) {
    if (safe && target[key]) target[key] = src[key];
    else hide(target, key, src[key]);
  } return target;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_redefine.js":
/*!***********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_redefine.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js");


/***/ }),

/***/ "./node_modules/core-js/library/modules/_set-collection-from.js":
/*!**********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_set-collection-from.js ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// https://tc39.github.io/proposal-setmap-offrom/
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var aFunction = __webpack_require__(/*! ./_a-function */ "./node_modules/core-js/library/modules/_a-function.js");
var ctx = __webpack_require__(/*! ./_ctx */ "./node_modules/core-js/library/modules/_ctx.js");
var forOf = __webpack_require__(/*! ./_for-of */ "./node_modules/core-js/library/modules/_for-of.js");

module.exports = function (COLLECTION) {
  $export($export.S, COLLECTION, { from: function from(source /* , mapFn, thisArg */) {
    var mapFn = arguments[1];
    var mapping, A, n, cb;
    aFunction(this);
    mapping = mapFn !== undefined;
    if (mapping) aFunction(mapFn);
    if (source == undefined) return new this();
    A = [];
    if (mapping) {
      n = 0;
      cb = ctx(mapFn, arguments[2], 2);
      forOf(source, false, function (nextItem) {
        A.push(cb(nextItem, n++));
      });
    } else {
      forOf(source, false, A.push, A);
    }
    return new this(A);
  } });
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_set-collection-of.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_set-collection-of.js ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

// https://tc39.github.io/proposal-setmap-offrom/
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");

module.exports = function (COLLECTION) {
  $export($export.S, COLLECTION, { of: function of() {
    var length = arguments.length;
    var A = new Array(length);
    while (length--) A[length] = arguments[length];
    return new this(A);
  } });
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_set-species.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_set-species.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js");
var core = __webpack_require__(/*! ./_core */ "./node_modules/core-js/library/modules/_core.js");
var dP = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js");
var DESCRIPTORS = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js");
var SPECIES = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('species');

module.exports = function (KEY) {
  var C = typeof core[KEY] == 'function' ? core[KEY] : global[KEY];
  if (DESCRIPTORS && C && !C[SPECIES]) dP.f(C, SPECIES, {
    configurable: true,
    get: function () { return this; }
  });
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_set-to-string-tag.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_set-to-string-tag.js ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var def = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js").f;
var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/library/modules/_has.js");
var TAG = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('toStringTag');

module.exports = function (it, tag, stat) {
  if (it && !has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_shared-key.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_shared-key.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var shared = __webpack_require__(/*! ./_shared */ "./node_modules/core-js/library/modules/_shared.js")('keys');
var uid = __webpack_require__(/*! ./_uid */ "./node_modules/core-js/library/modules/_uid.js");
module.exports = function (key) {
  return shared[key] || (shared[key] = uid(key));
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_shared.js":
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/modules/_shared.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var core = __webpack_require__(/*! ./_core */ "./node_modules/core-js/library/modules/_core.js");
var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js");
var SHARED = '__core-js_shared__';
var store = global[SHARED] || (global[SHARED] = {});

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: core.version,
  mode: __webpack_require__(/*! ./_library */ "./node_modules/core-js/library/modules/_library.js") ? 'pure' : 'global',
  copyright: '© 2020 Denis Pushkarev (zloirock.ru)'
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/_strict-method.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_strict-method.js ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var fails = __webpack_require__(/*! ./_fails */ "./node_modules/core-js/library/modules/_fails.js");

module.exports = function (method, arg) {
  return !!method && fails(function () {
    // eslint-disable-next-line no-useless-call
    arg ? method.call(null, function () { /* empty */ }, 1) : method.call(null);
  });
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_string-at.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_string-at.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(/*! ./_to-integer */ "./node_modules/core-js/library/modules/_to-integer.js");
var defined = __webpack_require__(/*! ./_defined */ "./node_modules/core-js/library/modules/_defined.js");
// true  -> String#at
// false -> String#codePointAt
module.exports = function (TO_STRING) {
  return function (that, pos) {
    var s = String(defined(that));
    var i = toInteger(pos);
    var l = s.length;
    var a, b;
    if (i < 0 || i >= l) return TO_STRING ? '' : undefined;
    a = s.charCodeAt(i);
    return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
      ? TO_STRING ? s.charAt(i) : a
      : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
  };
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_string-context.js":
/*!*****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_string-context.js ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// helper for String#{startsWith, endsWith, includes}
var isRegExp = __webpack_require__(/*! ./_is-regexp */ "./node_modules/core-js/library/modules/_is-regexp.js");
var defined = __webpack_require__(/*! ./_defined */ "./node_modules/core-js/library/modules/_defined.js");

module.exports = function (that, searchString, NAME) {
  if (isRegExp(searchString)) throw TypeError('String#' + NAME + " doesn't accept regex!");
  return String(defined(that));
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_to-absolute-index.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-absolute-index.js ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var toInteger = __webpack_require__(/*! ./_to-integer */ "./node_modules/core-js/library/modules/_to-integer.js");
var max = Math.max;
var min = Math.min;
module.exports = function (index, length) {
  index = toInteger(index);
  return index < 0 ? max(index + length, 0) : min(index, length);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_to-integer.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-integer.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

// 7.1.4 ToInteger
var ceil = Math.ceil;
var floor = Math.floor;
module.exports = function (it) {
  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_to-iobject.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-iobject.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// to indexed object, toObject with fallback for non-array-like ES3 strings
var IObject = __webpack_require__(/*! ./_iobject */ "./node_modules/core-js/library/modules/_iobject.js");
var defined = __webpack_require__(/*! ./_defined */ "./node_modules/core-js/library/modules/_defined.js");
module.exports = function (it) {
  return IObject(defined(it));
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_to-length.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-length.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.15 ToLength
var toInteger = __webpack_require__(/*! ./_to-integer */ "./node_modules/core-js/library/modules/_to-integer.js");
var min = Math.min;
module.exports = function (it) {
  return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_to-object.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-object.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.13 ToObject(argument)
var defined = __webpack_require__(/*! ./_defined */ "./node_modules/core-js/library/modules/_defined.js");
module.exports = function (it) {
  return Object(defined(it));
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_to-primitive.js":
/*!***************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_to-primitive.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 7.1.1 ToPrimitive(input [, PreferredType])
var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (it, S) {
  if (!isObject(it)) return it;
  var fn, val;
  if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
  if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  throw TypeError("Can't convert object to primitive value");
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_uid.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_uid.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var id = 0;
var px = Math.random();
module.exports = function (key) {
  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_validate-collection.js":
/*!**********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/_validate-collection.js ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/library/modules/_is-object.js");
module.exports = function (it, TYPE) {
  if (!isObject(it) || it._t !== TYPE) throw TypeError('Incompatible receiver, ' + TYPE + ' required!');
  return it;
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/_wks.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/library/modules/_wks.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var store = __webpack_require__(/*! ./_shared */ "./node_modules/core-js/library/modules/_shared.js")('wks');
var uid = __webpack_require__(/*! ./_uid */ "./node_modules/core-js/library/modules/_uid.js");
var Symbol = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js").Symbol;
var USE_SYMBOL = typeof Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] =
    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
};

$exports.store = store;


/***/ }),

/***/ "./node_modules/core-js/library/modules/core.get-iterator-method.js":
/*!**************************************************************************!*\
  !*** ./node_modules/core-js/library/modules/core.get-iterator-method.js ***!
  \**************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var classof = __webpack_require__(/*! ./_classof */ "./node_modules/core-js/library/modules/_classof.js");
var ITERATOR = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('iterator');
var Iterators = __webpack_require__(/*! ./_iterators */ "./node_modules/core-js/library/modules/_iterators.js");
module.exports = __webpack_require__(/*! ./_core */ "./node_modules/core-js/library/modules/_core.js").getIteratorMethod = function (it) {
  if (it != undefined) return it[ITERATOR]
    || it['@@iterator']
    || Iterators[classof(it)];
};


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.array.filter.js":
/*!******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.array.filter.js ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var $filter = __webpack_require__(/*! ./_array-methods */ "./node_modules/core-js/library/modules/_array-methods.js")(2);

$export($export.P + $export.F * !__webpack_require__(/*! ./_strict-method */ "./node_modules/core-js/library/modules/_strict-method.js")([].filter, true), 'Array', {
  // 22.1.3.7 / 15.4.4.20 Array.prototype.filter(callbackfn [, thisArg])
  filter: function filter(callbackfn /* , thisArg */) {
    return $filter(this, callbackfn, arguments[1]);
  }
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.array.for-each.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.array.for-each.js ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var $forEach = __webpack_require__(/*! ./_array-methods */ "./node_modules/core-js/library/modules/_array-methods.js")(0);
var STRICT = __webpack_require__(/*! ./_strict-method */ "./node_modules/core-js/library/modules/_strict-method.js")([].forEach, true);

$export($export.P + $export.F * !STRICT, 'Array', {
  // 22.1.3.10 / 15.4.4.18 Array.prototype.forEach(callbackfn [, thisArg])
  forEach: function forEach(callbackfn /* , thisArg */) {
    return $forEach(this, callbackfn, arguments[1]);
  }
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.array.index-of.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.array.index-of.js ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var $indexOf = __webpack_require__(/*! ./_array-includes */ "./node_modules/core-js/library/modules/_array-includes.js")(false);
var $native = [].indexOf;
var NEGATIVE_ZERO = !!$native && 1 / [1].indexOf(1, -0) < 0;

$export($export.P + $export.F * (NEGATIVE_ZERO || !__webpack_require__(/*! ./_strict-method */ "./node_modules/core-js/library/modules/_strict-method.js")($native)), 'Array', {
  // 22.1.3.11 / 15.4.4.14 Array.prototype.indexOf(searchElement [, fromIndex])
  indexOf: function indexOf(searchElement /* , fromIndex = 0 */) {
    return NEGATIVE_ZERO
      // convert -0 to +0
      ? $native.apply(this, arguments) || 0
      : $indexOf(this, searchElement, arguments[1]);
  }
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.array.is-array.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.array.is-array.js ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 22.1.2.2 / 15.4.3.2 Array.isArray(arg)
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");

$export($export.S, 'Array', { isArray: __webpack_require__(/*! ./_is-array */ "./node_modules/core-js/library/modules/_is-array.js") });


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.array.iterator.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.array.iterator.js ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var addToUnscopables = __webpack_require__(/*! ./_add-to-unscopables */ "./node_modules/core-js/library/modules/_add-to-unscopables.js");
var step = __webpack_require__(/*! ./_iter-step */ "./node_modules/core-js/library/modules/_iter-step.js");
var Iterators = __webpack_require__(/*! ./_iterators */ "./node_modules/core-js/library/modules/_iterators.js");
var toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/library/modules/_to-iobject.js");

// 22.1.3.4 Array.prototype.entries()
// 22.1.3.13 Array.prototype.keys()
// 22.1.3.29 Array.prototype.values()
// 22.1.3.30 Array.prototype[@@iterator]()
module.exports = __webpack_require__(/*! ./_iter-define */ "./node_modules/core-js/library/modules/_iter-define.js")(Array, 'Array', function (iterated, kind) {
  this._t = toIObject(iterated); // target
  this._i = 0;                   // next index
  this._k = kind;                // kind
// 22.1.5.2.1 %ArrayIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var kind = this._k;
  var index = this._i++;
  if (!O || index >= O.length) {
    this._t = undefined;
    return step(1);
  }
  if (kind == 'keys') return step(0, index);
  if (kind == 'values') return step(0, O[index]);
  return step(0, [index, O[index]]);
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)
Iterators.Arguments = Iterators.Array;

addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.array.map.js":
/*!***************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.array.map.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var $map = __webpack_require__(/*! ./_array-methods */ "./node_modules/core-js/library/modules/_array-methods.js")(1);

$export($export.P + $export.F * !__webpack_require__(/*! ./_strict-method */ "./node_modules/core-js/library/modules/_strict-method.js")([].map, true), 'Array', {
  // 22.1.3.15 / 15.4.4.19 Array.prototype.map(callbackfn [, thisArg])
  map: function map(callbackfn /* , thisArg */) {
    return $map(this, callbackfn, arguments[1]);
  }
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.array.reduce-right.js":
/*!************************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.array.reduce-right.js ***!
  \************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var $reduce = __webpack_require__(/*! ./_array-reduce */ "./node_modules/core-js/library/modules/_array-reduce.js");

$export($export.P + $export.F * !__webpack_require__(/*! ./_strict-method */ "./node_modules/core-js/library/modules/_strict-method.js")([].reduceRight, true), 'Array', {
  // 22.1.3.19 / 15.4.4.22 Array.prototype.reduceRight(callbackfn [, initialValue])
  reduceRight: function reduceRight(callbackfn /* , initialValue */) {
    return $reduce(this, callbackfn, arguments.length, arguments[1], true);
  }
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.array.reduce.js":
/*!******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.array.reduce.js ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var $reduce = __webpack_require__(/*! ./_array-reduce */ "./node_modules/core-js/library/modules/_array-reduce.js");

$export($export.P + $export.F * !__webpack_require__(/*! ./_strict-method */ "./node_modules/core-js/library/modules/_strict-method.js")([].reduce, true), 'Array', {
  // 22.1.3.18 / 15.4.4.21 Array.prototype.reduce(callbackfn [, initialValue])
  reduce: function reduce(callbackfn /* , initialValue */) {
    return $reduce(this, callbackfn, arguments.length, arguments[1], false);
  }
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.array.some.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.array.some.js ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var $some = __webpack_require__(/*! ./_array-methods */ "./node_modules/core-js/library/modules/_array-methods.js")(3);

$export($export.P + $export.F * !__webpack_require__(/*! ./_strict-method */ "./node_modules/core-js/library/modules/_strict-method.js")([].some, true), 'Array', {
  // 22.1.3.23 / 15.4.4.17 Array.prototype.some(callbackfn [, thisArg])
  some: function some(callbackfn /* , thisArg */) {
    return $some(this, callbackfn, arguments[1]);
  }
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.map.js":
/*!*********************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.map.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var strong = __webpack_require__(/*! ./_collection-strong */ "./node_modules/core-js/library/modules/_collection-strong.js");
var validate = __webpack_require__(/*! ./_validate-collection */ "./node_modules/core-js/library/modules/_validate-collection.js");
var MAP = 'Map';

// 23.1 Map Objects
module.exports = __webpack_require__(/*! ./_collection */ "./node_modules/core-js/library/modules/_collection.js")(MAP, function (get) {
  return function Map() { return get(this, arguments.length > 0 ? arguments[0] : undefined); };
}, {
  // 23.1.3.6 Map.prototype.get(key)
  get: function get(key) {
    var entry = strong.getEntry(validate(this, MAP), key);
    return entry && entry.v;
  },
  // 23.1.3.9 Map.prototype.set(key, value)
  set: function set(key, value) {
    return strong.def(validate(this, MAP), key === 0 ? 0 : key, value);
  }
}, strong, true);


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.object.assign.js":
/*!*******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.assign.js ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.3.1 Object.assign(target, source)
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");

$export($export.S + $export.F, 'Object', { assign: __webpack_require__(/*! ./_object-assign */ "./node_modules/core-js/library/modules/_object-assign.js") });


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.object.create.js":
/*!*******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.create.js ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
$export($export.S, 'Object', { create: __webpack_require__(/*! ./_object-create */ "./node_modules/core-js/library/modules/_object-create.js") });


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.object.define-property.js":
/*!****************************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.define-property.js ***!
  \****************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
// 19.1.2.4 / 15.2.3.6 Object.defineProperty(O, P, Attributes)
$export($export.S + $export.F * !__webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/library/modules/_descriptors.js"), 'Object', { defineProperty: __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/library/modules/_object-dp.js").f });


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.object.keys.js":
/*!*****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.keys.js ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// 19.1.2.14 Object.keys(O)
var toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/library/modules/_to-object.js");
var $keys = __webpack_require__(/*! ./_object-keys */ "./node_modules/core-js/library/modules/_object-keys.js");

__webpack_require__(/*! ./_object-sap */ "./node_modules/core-js/library/modules/_object-sap.js")('keys', function () {
  return function keys(it) {
    return $keys(toObject(it));
  };
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.object.to-string.js":
/*!**********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.object.to-string.js ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {



/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.string.ends-with.js":
/*!**********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.string.ends-with.js ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// 21.1.3.6 String.prototype.endsWith(searchString [, endPosition])

var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");
var toLength = __webpack_require__(/*! ./_to-length */ "./node_modules/core-js/library/modules/_to-length.js");
var context = __webpack_require__(/*! ./_string-context */ "./node_modules/core-js/library/modules/_string-context.js");
var ENDS_WITH = 'endsWith';
var $endsWith = ''[ENDS_WITH];

$export($export.P + $export.F * __webpack_require__(/*! ./_fails-is-regexp */ "./node_modules/core-js/library/modules/_fails-is-regexp.js")(ENDS_WITH), 'String', {
  endsWith: function endsWith(searchString /* , endPosition = @length */) {
    var that = context(this, searchString, ENDS_WITH);
    var endPosition = arguments.length > 1 ? arguments[1] : undefined;
    var len = toLength(that.length);
    var end = endPosition === undefined ? len : Math.min(toLength(endPosition), len);
    var search = String(searchString);
    return $endsWith
      ? $endsWith.call(that, search, end)
      : that.slice(end - search.length, end) === search;
  }
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/es6.string.iterator.js":
/*!*********************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es6.string.iterator.js ***!
  \*********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var $at = __webpack_require__(/*! ./_string-at */ "./node_modules/core-js/library/modules/_string-at.js")(true);

// 21.1.3.27 String.prototype[@@iterator]()
__webpack_require__(/*! ./_iter-define */ "./node_modules/core-js/library/modules/_iter-define.js")(String, 'String', function (iterated) {
  this._t = String(iterated); // target
  this._i = 0;                // next index
// 21.1.5.2.1 %StringIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var index = this._i;
  var point;
  if (index >= O.length) return { value: undefined, done: true };
  point = $at(O, index);
  this._i += point.length;
  return { value: point, done: false };
});


/***/ }),

/***/ "./node_modules/core-js/library/modules/es7.map.from.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es7.map.from.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// https://tc39.github.io/proposal-setmap-offrom/#sec-map.from
__webpack_require__(/*! ./_set-collection-from */ "./node_modules/core-js/library/modules/_set-collection-from.js")('Map');


/***/ }),

/***/ "./node_modules/core-js/library/modules/es7.map.of.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es7.map.of.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// https://tc39.github.io/proposal-setmap-offrom/#sec-map.of
__webpack_require__(/*! ./_set-collection-of */ "./node_modules/core-js/library/modules/_set-collection-of.js")('Map');


/***/ }),

/***/ "./node_modules/core-js/library/modules/es7.map.to-json.js":
/*!*****************************************************************!*\
  !*** ./node_modules/core-js/library/modules/es7.map.to-json.js ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// https://github.com/DavidBruant/Map-Set.prototype.toJSON
var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/library/modules/_export.js");

$export($export.P + $export.R, 'Map', { toJSON: __webpack_require__(/*! ./_collection-to-json */ "./node_modules/core-js/library/modules/_collection-to-json.js")('Map') });


/***/ }),

/***/ "./node_modules/core-js/library/modules/web.dom.iterable.js":
/*!******************************************************************!*\
  !*** ./node_modules/core-js/library/modules/web.dom.iterable.js ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! ./es6.array.iterator */ "./node_modules/core-js/library/modules/es6.array.iterator.js");
var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/library/modules/_global.js");
var hide = __webpack_require__(/*! ./_hide */ "./node_modules/core-js/library/modules/_hide.js");
var Iterators = __webpack_require__(/*! ./_iterators */ "./node_modules/core-js/library/modules/_iterators.js");
var TO_STRING_TAG = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/library/modules/_wks.js")('toStringTag');

var DOMIterables = ('CSSRuleList,CSSStyleDeclaration,CSSValueList,ClientRectList,DOMRectList,DOMStringList,' +
  'DOMTokenList,DataTransferItemList,FileList,HTMLAllCollection,HTMLCollection,HTMLFormElement,HTMLSelectElement,' +
  'MediaList,MimeTypeArray,NamedNodeMap,NodeList,PaintRequestList,Plugin,PluginArray,SVGLengthList,SVGNumberList,' +
  'SVGPathSegList,SVGPointList,SVGStringList,SVGTransformList,SourceBufferList,StyleSheetList,TextTrackCueList,' +
  'TextTrackList,TouchList').split(',');

for (var i = 0; i < DOMIterables.length; i++) {
  var NAME = DOMIterables[i];
  var Collection = global[NAME];
  var proto = Collection && Collection.prototype;
  if (proto && !proto[TO_STRING_TAG]) hide(proto, TO_STRING_TAG, NAME);
  Iterators[NAME] = Iterators.Array;
}


/***/ }),

/***/ "./node_modules/core-util-is/lib/util.js":
/*!***********************************************!*\
  !*** ./node_modules/core-util-is/lib/util.js ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.

function isArray(arg) {
  if (Array.isArray) {
    return Array.isArray(arg);
  }
  return objectToString(arg) === '[object Array]';
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return objectToString(d) === '[object Date]';
}
exports.isDate = isDate;

function isError(e) {
  return (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = Buffer.isBuffer;

function objectToString(o) {
  return Object.prototype.toString.call(o);
}


/***/ }),

/***/ "./node_modules/define-properties/index.js":
/*!*************************************************!*\
  !*** ./node_modules/define-properties/index.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var keys = __webpack_require__(/*! object-keys */ "./node_modules/object-keys/index.js");
var hasSymbols = typeof Symbol === 'function' && typeof Symbol('foo') === 'symbol';

var toStr = Object.prototype.toString;
var concat = Array.prototype.concat;
var origDefineProperty = Object.defineProperty;

var isFunction = function (fn) {
	return typeof fn === 'function' && toStr.call(fn) === '[object Function]';
};

var arePropertyDescriptorsSupported = function () {
	var obj = {};
	try {
		origDefineProperty(obj, 'x', { enumerable: false, value: obj });
		// eslint-disable-next-line no-unused-vars, no-restricted-syntax
		for (var _ in obj) { // jscs:ignore disallowUnusedVariables
			return false;
		}
		return obj.x === obj;
	} catch (e) { /* this is IE 8. */
		return false;
	}
};
var supportsDescriptors = origDefineProperty && arePropertyDescriptorsSupported();

var defineProperty = function (object, name, value, predicate) {
	if (name in object && (!isFunction(predicate) || !predicate())) {
		return;
	}
	if (supportsDescriptors) {
		origDefineProperty(object, name, {
			configurable: true,
			enumerable: false,
			value: value,
			writable: true
		});
	} else {
		object[name] = value;
	}
};

var defineProperties = function (object, map) {
	var predicates = arguments.length > 2 ? arguments[2] : {};
	var props = keys(map);
	if (hasSymbols) {
		props = concat.call(props, Object.getOwnPropertySymbols(map));
	}
	for (var i = 0; i < props.length; i += 1) {
		defineProperty(object, props[i], map[props[i]], predicates[props[i]]);
	}
};

defineProperties.supportsDescriptors = !!supportsDescriptors;

module.exports = defineProperties;


/***/ }),

/***/ "./node_modules/diff-match-patch/index.js":
/*!************************************************!*\
  !*** ./node_modules/diff-match-patch/index.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

/**
 * Diff Match and Patch
 * Copyright 2018 The diff-match-patch Authors.
 * https://github.com/google/diff-match-patch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Computes the difference between two texts to create a patch.
 * Applies the patch onto another text, allowing for errors.
 * @author fraser@google.com (Neil Fraser)
 */

/**
 * Class containing the diff, match and patch methods.
 * @constructor
 */
var diff_match_patch = function() {

  // Defaults.
  // Redefine these in your program to override the defaults.

  // Number of seconds to map a diff before giving up (0 for infinity).
  this.Diff_Timeout = 1.0;
  // Cost of an empty edit operation in terms of edit characters.
  this.Diff_EditCost = 4;
  // At what point is no match declared (0.0 = perfection, 1.0 = very loose).
  this.Match_Threshold = 0.5;
  // How far to search for a match (0 = exact location, 1000+ = broad match).
  // A match this many characters away from the expected location will add
  // 1.0 to the score (0.0 is a perfect match).
  this.Match_Distance = 1000;
  // When deleting a large block of text (over ~64 characters), how close do
  // the contents have to be to match the expected contents. (0.0 = perfection,
  // 1.0 = very loose).  Note that Match_Threshold controls how closely the
  // end points of a delete need to match.
  this.Patch_DeleteThreshold = 0.5;
  // Chunk size for context length.
  this.Patch_Margin = 4;

  // The number of bits in an int.
  this.Match_MaxBits = 32;
};


//  DIFF FUNCTIONS


/**
 * The data structure representing a diff is an array of tuples:
 * [[DIFF_DELETE, 'Hello'], [DIFF_INSERT, 'Goodbye'], [DIFF_EQUAL, ' world.']]
 * which means: delete 'Hello', add 'Goodbye' and keep ' world.'
 */
var DIFF_DELETE = -1;
var DIFF_INSERT = 1;
var DIFF_EQUAL = 0;

/**
 * Class representing one diff tuple.
 * ~Attempts to look like a two-element array (which is what this used to be).~
 * Constructor returns an actual two-element array, to allow destructing @JackuB
 * See https://github.com/JackuB/diff-match-patch/issues/14 for details
 * @param {number} op Operation, one of: DIFF_DELETE, DIFF_INSERT, DIFF_EQUAL.
 * @param {string} text Text to be deleted, inserted, or retained.
 * @constructor
 */
diff_match_patch.Diff = function(op, text) {
  return [op, text];
};

/**
 * Find the differences between two texts.  Simplifies the problem by stripping
 * any common prefix or suffix off the texts before diffing.
 * @param {string} text1 Old string to be diffed.
 * @param {string} text2 New string to be diffed.
 * @param {boolean=} opt_checklines Optional speedup flag. If present and false,
 *     then don't run a line-level diff first to identify the changed areas.
 *     Defaults to true, which does a faster, slightly less optimal diff.
 * @param {number=} opt_deadline Optional time when the diff should be complete
 *     by.  Used internally for recursive calls.  Users should set DiffTimeout
 *     instead.
 * @return {!Array.<!diff_match_patch.Diff>} Array of diff tuples.
 */
diff_match_patch.prototype.diff_main = function(text1, text2, opt_checklines,
    opt_deadline) {
  // Set a deadline by which time the diff must be complete.
  if (typeof opt_deadline == 'undefined') {
    if (this.Diff_Timeout <= 0) {
      opt_deadline = Number.MAX_VALUE;
    } else {
      opt_deadline = (new Date).getTime() + this.Diff_Timeout * 1000;
    }
  }
  var deadline = opt_deadline;

  // Check for null inputs.
  if (text1 == null || text2 == null) {
    throw new Error('Null input. (diff_main)');
  }

  // Check for equality (speedup).
  if (text1 == text2) {
    if (text1) {
      return [new diff_match_patch.Diff(DIFF_EQUAL, text1)];
    }
    return [];
  }

  if (typeof opt_checklines == 'undefined') {
    opt_checklines = true;
  }
  var checklines = opt_checklines;

  // Trim off common prefix (speedup).
  var commonlength = this.diff_commonPrefix(text1, text2);
  var commonprefix = text1.substring(0, commonlength);
  text1 = text1.substring(commonlength);
  text2 = text2.substring(commonlength);

  // Trim off common suffix (speedup).
  commonlength = this.diff_commonSuffix(text1, text2);
  var commonsuffix = text1.substring(text1.length - commonlength);
  text1 = text1.substring(0, text1.length - commonlength);
  text2 = text2.substring(0, text2.length - commonlength);

  // Compute the diff on the middle block.
  var diffs = this.diff_compute_(text1, text2, checklines, deadline);

  // Restore the prefix and suffix.
  if (commonprefix) {
    diffs.unshift(new diff_match_patch.Diff(DIFF_EQUAL, commonprefix));
  }
  if (commonsuffix) {
    diffs.push(new diff_match_patch.Diff(DIFF_EQUAL, commonsuffix));
  }
  this.diff_cleanupMerge(diffs);
  return diffs;
};


/**
 * Find the differences between two texts.  Assumes that the texts do not
 * have any common prefix or suffix.
 * @param {string} text1 Old string to be diffed.
 * @param {string} text2 New string to be diffed.
 * @param {boolean} checklines Speedup flag.  If false, then don't run a
 *     line-level diff first to identify the changed areas.
 *     If true, then run a faster, slightly less optimal diff.
 * @param {number} deadline Time when the diff should be complete by.
 * @return {!Array.<!diff_match_patch.Diff>} Array of diff tuples.
 * @private
 */
diff_match_patch.prototype.diff_compute_ = function(text1, text2, checklines,
    deadline) {
  var diffs;

  if (!text1) {
    // Just add some text (speedup).
    return [new diff_match_patch.Diff(DIFF_INSERT, text2)];
  }

  if (!text2) {
    // Just delete some text (speedup).
    return [new diff_match_patch.Diff(DIFF_DELETE, text1)];
  }

  var longtext = text1.length > text2.length ? text1 : text2;
  var shorttext = text1.length > text2.length ? text2 : text1;
  var i = longtext.indexOf(shorttext);
  if (i != -1) {
    // Shorter text is inside the longer text (speedup).
    diffs = [new diff_match_patch.Diff(DIFF_INSERT, longtext.substring(0, i)),
             new diff_match_patch.Diff(DIFF_EQUAL, shorttext),
             new diff_match_patch.Diff(DIFF_INSERT,
                 longtext.substring(i + shorttext.length))];
    // Swap insertions for deletions if diff is reversed.
    if (text1.length > text2.length) {
      diffs[0][0] = diffs[2][0] = DIFF_DELETE;
    }
    return diffs;
  }

  if (shorttext.length == 1) {
    // Single character string.
    // After the previous speedup, the character can't be an equality.
    return [new diff_match_patch.Diff(DIFF_DELETE, text1),
            new diff_match_patch.Diff(DIFF_INSERT, text2)];
  }

  // Check to see if the problem can be split in two.
  var hm = this.diff_halfMatch_(text1, text2);
  if (hm) {
    // A half-match was found, sort out the return data.
    var text1_a = hm[0];
    var text1_b = hm[1];
    var text2_a = hm[2];
    var text2_b = hm[3];
    var mid_common = hm[4];
    // Send both pairs off for separate processing.
    var diffs_a = this.diff_main(text1_a, text2_a, checklines, deadline);
    var diffs_b = this.diff_main(text1_b, text2_b, checklines, deadline);
    // Merge the results.
    return diffs_a.concat([new diff_match_patch.Diff(DIFF_EQUAL, mid_common)],
                          diffs_b);
  }

  if (checklines && text1.length > 100 && text2.length > 100) {
    return this.diff_lineMode_(text1, text2, deadline);
  }

  return this.diff_bisect_(text1, text2, deadline);
};


/**
 * Do a quick line-level diff on both strings, then rediff the parts for
 * greater accuracy.
 * This speedup can produce non-minimal diffs.
 * @param {string} text1 Old string to be diffed.
 * @param {string} text2 New string to be diffed.
 * @param {number} deadline Time when the diff should be complete by.
 * @return {!Array.<!diff_match_patch.Diff>} Array of diff tuples.
 * @private
 */
diff_match_patch.prototype.diff_lineMode_ = function(text1, text2, deadline) {
  // Scan the text on a line-by-line basis first.
  var a = this.diff_linesToChars_(text1, text2);
  text1 = a.chars1;
  text2 = a.chars2;
  var linearray = a.lineArray;

  var diffs = this.diff_main(text1, text2, false, deadline);

  // Convert the diff back to original text.
  this.diff_charsToLines_(diffs, linearray);
  // Eliminate freak matches (e.g. blank lines)
  this.diff_cleanupSemantic(diffs);

  // Rediff any replacement blocks, this time character-by-character.
  // Add a dummy entry at the end.
  diffs.push(new diff_match_patch.Diff(DIFF_EQUAL, ''));
  var pointer = 0;
  var count_delete = 0;
  var count_insert = 0;
  var text_delete = '';
  var text_insert = '';
  while (pointer < diffs.length) {
    switch (diffs[pointer][0]) {
      case DIFF_INSERT:
        count_insert++;
        text_insert += diffs[pointer][1];
        break;
      case DIFF_DELETE:
        count_delete++;
        text_delete += diffs[pointer][1];
        break;
      case DIFF_EQUAL:
        // Upon reaching an equality, check for prior redundancies.
        if (count_delete >= 1 && count_insert >= 1) {
          // Delete the offending records and add the merged ones.
          diffs.splice(pointer - count_delete - count_insert,
                       count_delete + count_insert);
          pointer = pointer - count_delete - count_insert;
          var subDiff =
              this.diff_main(text_delete, text_insert, false, deadline);
          for (var j = subDiff.length - 1; j >= 0; j--) {
            diffs.splice(pointer, 0, subDiff[j]);
          }
          pointer = pointer + subDiff.length;
        }
        count_insert = 0;
        count_delete = 0;
        text_delete = '';
        text_insert = '';
        break;
    }
    pointer++;
  }
  diffs.pop();  // Remove the dummy entry at the end.

  return diffs;
};


/**
 * Find the 'middle snake' of a diff, split the problem in two
 * and return the recursively constructed diff.
 * See Myers 1986 paper: An O(ND) Difference Algorithm and Its Variations.
 * @param {string} text1 Old string to be diffed.
 * @param {string} text2 New string to be diffed.
 * @param {number} deadline Time at which to bail if not yet complete.
 * @return {!Array.<!diff_match_patch.Diff>} Array of diff tuples.
 * @private
 */
diff_match_patch.prototype.diff_bisect_ = function(text1, text2, deadline) {
  // Cache the text lengths to prevent multiple calls.
  var text1_length = text1.length;
  var text2_length = text2.length;
  var max_d = Math.ceil((text1_length + text2_length) / 2);
  var v_offset = max_d;
  var v_length = 2 * max_d;
  var v1 = new Array(v_length);
  var v2 = new Array(v_length);
  // Setting all elements to -1 is faster in Chrome & Firefox than mixing
  // integers and undefined.
  for (var x = 0; x < v_length; x++) {
    v1[x] = -1;
    v2[x] = -1;
  }
  v1[v_offset + 1] = 0;
  v2[v_offset + 1] = 0;
  var delta = text1_length - text2_length;
  // If the total number of characters is odd, then the front path will collide
  // with the reverse path.
  var front = (delta % 2 != 0);
  // Offsets for start and end of k loop.
  // Prevents mapping of space beyond the grid.
  var k1start = 0;
  var k1end = 0;
  var k2start = 0;
  var k2end = 0;
  for (var d = 0; d < max_d; d++) {
    // Bail out if deadline is reached.
    if ((new Date()).getTime() > deadline) {
      break;
    }

    // Walk the front path one step.
    for (var k1 = -d + k1start; k1 <= d - k1end; k1 += 2) {
      var k1_offset = v_offset + k1;
      var x1;
      if (k1 == -d || (k1 != d && v1[k1_offset - 1] < v1[k1_offset + 1])) {
        x1 = v1[k1_offset + 1];
      } else {
        x1 = v1[k1_offset - 1] + 1;
      }
      var y1 = x1 - k1;
      while (x1 < text1_length && y1 < text2_length &&
             text1.charAt(x1) == text2.charAt(y1)) {
        x1++;
        y1++;
      }
      v1[k1_offset] = x1;
      if (x1 > text1_length) {
        // Ran off the right of the graph.
        k1end += 2;
      } else if (y1 > text2_length) {
        // Ran off the bottom of the graph.
        k1start += 2;
      } else if (front) {
        var k2_offset = v_offset + delta - k1;
        if (k2_offset >= 0 && k2_offset < v_length && v2[k2_offset] != -1) {
          // Mirror x2 onto top-left coordinate system.
          var x2 = text1_length - v2[k2_offset];
          if (x1 >= x2) {
            // Overlap detected.
            return this.diff_bisectSplit_(text1, text2, x1, y1, deadline);
          }
        }
      }
    }

    // Walk the reverse path one step.
    for (var k2 = -d + k2start; k2 <= d - k2end; k2 += 2) {
      var k2_offset = v_offset + k2;
      var x2;
      if (k2 == -d || (k2 != d && v2[k2_offset - 1] < v2[k2_offset + 1])) {
        x2 = v2[k2_offset + 1];
      } else {
        x2 = v2[k2_offset - 1] + 1;
      }
      var y2 = x2 - k2;
      while (x2 < text1_length && y2 < text2_length &&
             text1.charAt(text1_length - x2 - 1) ==
             text2.charAt(text2_length - y2 - 1)) {
        x2++;
        y2++;
      }
      v2[k2_offset] = x2;
      if (x2 > text1_length) {
        // Ran off the left of the graph.
        k2end += 2;
      } else if (y2 > text2_length) {
        // Ran off the top of the graph.
        k2start += 2;
      } else if (!front) {
        var k1_offset = v_offset + delta - k2;
        if (k1_offset >= 0 && k1_offset < v_length && v1[k1_offset] != -1) {
          var x1 = v1[k1_offset];
          var y1 = v_offset + x1 - k1_offset;
          // Mirror x2 onto top-left coordinate system.
          x2 = text1_length - x2;
          if (x1 >= x2) {
            // Overlap detected.
            return this.diff_bisectSplit_(text1, text2, x1, y1, deadline);
          }
        }
      }
    }
  }
  // Diff took too long and hit the deadline or
  // number of diffs equals number of characters, no commonality at all.
  return [new diff_match_patch.Diff(DIFF_DELETE, text1),
          new diff_match_patch.Diff(DIFF_INSERT, text2)];
};


/**
 * Given the location of the 'middle snake', split the diff in two parts
 * and recurse.
 * @param {string} text1 Old string to be diffed.
 * @param {string} text2 New string to be diffed.
 * @param {number} x Index of split point in text1.
 * @param {number} y Index of split point in text2.
 * @param {number} deadline Time at which to bail if not yet complete.
 * @return {!Array.<!diff_match_patch.Diff>} Array of diff tuples.
 * @private
 */
diff_match_patch.prototype.diff_bisectSplit_ = function(text1, text2, x, y,
    deadline) {
  var text1a = text1.substring(0, x);
  var text2a = text2.substring(0, y);
  var text1b = text1.substring(x);
  var text2b = text2.substring(y);

  // Compute both diffs serially.
  var diffs = this.diff_main(text1a, text2a, false, deadline);
  var diffsb = this.diff_main(text1b, text2b, false, deadline);

  return diffs.concat(diffsb);
};


/**
 * Split two texts into an array of strings.  Reduce the texts to a string of
 * hashes where each Unicode character represents one line.
 * @param {string} text1 First string.
 * @param {string} text2 Second string.
 * @return {{chars1: string, chars2: string, lineArray: !Array.<string>}}
 *     An object containing the encoded text1, the encoded text2 and
 *     the array of unique strings.
 *     The zeroth element of the array of unique strings is intentionally blank.
 * @private
 */
diff_match_patch.prototype.diff_linesToChars_ = function(text1, text2) {
  var lineArray = [];  // e.g. lineArray[4] == 'Hello\n'
  var lineHash = {};   // e.g. lineHash['Hello\n'] == 4

  // '\x00' is a valid character, but various debuggers don't like it.
  // So we'll insert a junk entry to avoid generating a null character.
  lineArray[0] = '';

  /**
   * Split a text into an array of strings.  Reduce the texts to a string of
   * hashes where each Unicode character represents one line.
   * Modifies linearray and linehash through being a closure.
   * @param {string} text String to encode.
   * @return {string} Encoded string.
   * @private
   */
  function diff_linesToCharsMunge_(text) {
    var chars = '';
    // Walk the text, pulling out a substring for each line.
    // text.split('\n') would would temporarily double our memory footprint.
    // Modifying text would create many large strings to garbage collect.
    var lineStart = 0;
    var lineEnd = -1;
    // Keeping our own length variable is faster than looking it up.
    var lineArrayLength = lineArray.length;
    while (lineEnd < text.length - 1) {
      lineEnd = text.indexOf('\n', lineStart);
      if (lineEnd == -1) {
        lineEnd = text.length - 1;
      }
      var line = text.substring(lineStart, lineEnd + 1);

      if (lineHash.hasOwnProperty ? lineHash.hasOwnProperty(line) :
          (lineHash[line] !== undefined)) {
        chars += String.fromCharCode(lineHash[line]);
      } else {
        if (lineArrayLength == maxLines) {
          // Bail out at 65535 because
          // String.fromCharCode(65536) == String.fromCharCode(0)
          line = text.substring(lineStart);
          lineEnd = text.length;
        }
        chars += String.fromCharCode(lineArrayLength);
        lineHash[line] = lineArrayLength;
        lineArray[lineArrayLength++] = line;
      }
      lineStart = lineEnd + 1;
    }
    return chars;
  }
  // Allocate 2/3rds of the space for text1, the rest for text2.
  var maxLines = 40000;
  var chars1 = diff_linesToCharsMunge_(text1);
  maxLines = 65535;
  var chars2 = diff_linesToCharsMunge_(text2);
  return {chars1: chars1, chars2: chars2, lineArray: lineArray};
};


/**
 * Rehydrate the text in a diff from a string of line hashes to real lines of
 * text.
 * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.
 * @param {!Array.<string>} lineArray Array of unique strings.
 * @private
 */
diff_match_patch.prototype.diff_charsToLines_ = function(diffs, lineArray) {
  for (var i = 0; i < diffs.length; i++) {
    var chars = diffs[i][1];
    var text = [];
    for (var j = 0; j < chars.length; j++) {
      text[j] = lineArray[chars.charCodeAt(j)];
    }
    diffs[i][1] = text.join('');
  }
};


/**
 * Determine the common prefix of two strings.
 * @param {string} text1 First string.
 * @param {string} text2 Second string.
 * @return {number} The number of characters common to the start of each
 *     string.
 */
diff_match_patch.prototype.diff_commonPrefix = function(text1, text2) {
  // Quick check for common null cases.
  if (!text1 || !text2 || text1.charAt(0) != text2.charAt(0)) {
    return 0;
  }
  // Binary search.
  // Performance analysis: https://neil.fraser.name/news/2007/10/09/
  var pointermin = 0;
  var pointermax = Math.min(text1.length, text2.length);
  var pointermid = pointermax;
  var pointerstart = 0;
  while (pointermin < pointermid) {
    if (text1.substring(pointerstart, pointermid) ==
        text2.substring(pointerstart, pointermid)) {
      pointermin = pointermid;
      pointerstart = pointermin;
    } else {
      pointermax = pointermid;
    }
    pointermid = Math.floor((pointermax - pointermin) / 2 + pointermin);
  }
  return pointermid;
};


/**
 * Determine the common suffix of two strings.
 * @param {string} text1 First string.
 * @param {string} text2 Second string.
 * @return {number} The number of characters common to the end of each string.
 */
diff_match_patch.prototype.diff_commonSuffix = function(text1, text2) {
  // Quick check for common null cases.
  if (!text1 || !text2 ||
      text1.charAt(text1.length - 1) != text2.charAt(text2.length - 1)) {
    return 0;
  }
  // Binary search.
  // Performance analysis: https://neil.fraser.name/news/2007/10/09/
  var pointermin = 0;
  var pointermax = Math.min(text1.length, text2.length);
  var pointermid = pointermax;
  var pointerend = 0;
  while (pointermin < pointermid) {
    if (text1.substring(text1.length - pointermid, text1.length - pointerend) ==
        text2.substring(text2.length - pointermid, text2.length - pointerend)) {
      pointermin = pointermid;
      pointerend = pointermin;
    } else {
      pointermax = pointermid;
    }
    pointermid = Math.floor((pointermax - pointermin) / 2 + pointermin);
  }
  return pointermid;
};


/**
 * Determine if the suffix of one string is the prefix of another.
 * @param {string} text1 First string.
 * @param {string} text2 Second string.
 * @return {number} The number of characters common to the end of the first
 *     string and the start of the second string.
 * @private
 */
diff_match_patch.prototype.diff_commonOverlap_ = function(text1, text2) {
  // Cache the text lengths to prevent multiple calls.
  var text1_length = text1.length;
  var text2_length = text2.length;
  // Eliminate the null case.
  if (text1_length == 0 || text2_length == 0) {
    return 0;
  }
  // Truncate the longer string.
  if (text1_length > text2_length) {
    text1 = text1.substring(text1_length - text2_length);
  } else if (text1_length < text2_length) {
    text2 = text2.substring(0, text1_length);
  }
  var text_length = Math.min(text1_length, text2_length);
  // Quick check for the worst case.
  if (text1 == text2) {
    return text_length;
  }

  // Start by looking for a single character match
  // and increase length until no match is found.
  // Performance analysis: https://neil.fraser.name/news/2010/11/04/
  var best = 0;
  var length = 1;
  while (true) {
    var pattern = text1.substring(text_length - length);
    var found = text2.indexOf(pattern);
    if (found == -1) {
      return best;
    }
    length += found;
    if (found == 0 || text1.substring(text_length - length) ==
        text2.substring(0, length)) {
      best = length;
      length++;
    }
  }
};


/**
 * Do the two texts share a substring which is at least half the length of the
 * longer text?
 * This speedup can produce non-minimal diffs.
 * @param {string} text1 First string.
 * @param {string} text2 Second string.
 * @return {Array.<string>} Five element Array, containing the prefix of
 *     text1, the suffix of text1, the prefix of text2, the suffix of
 *     text2 and the common middle.  Or null if there was no match.
 * @private
 */
diff_match_patch.prototype.diff_halfMatch_ = function(text1, text2) {
  if (this.Diff_Timeout <= 0) {
    // Don't risk returning a non-optimal diff if we have unlimited time.
    return null;
  }
  var longtext = text1.length > text2.length ? text1 : text2;
  var shorttext = text1.length > text2.length ? text2 : text1;
  if (longtext.length < 4 || shorttext.length * 2 < longtext.length) {
    return null;  // Pointless.
  }
  var dmp = this;  // 'this' becomes 'window' in a closure.

  /**
   * Does a substring of shorttext exist within longtext such that the substring
   * is at least half the length of longtext?
   * Closure, but does not reference any external variables.
   * @param {string} longtext Longer string.
   * @param {string} shorttext Shorter string.
   * @param {number} i Start index of quarter length substring within longtext.
   * @return {Array.<string>} Five element Array, containing the prefix of
   *     longtext, the suffix of longtext, the prefix of shorttext, the suffix
   *     of shorttext and the common middle.  Or null if there was no match.
   * @private
   */
  function diff_halfMatchI_(longtext, shorttext, i) {
    // Start with a 1/4 length substring at position i as a seed.
    var seed = longtext.substring(i, i + Math.floor(longtext.length / 4));
    var j = -1;
    var best_common = '';
    var best_longtext_a, best_longtext_b, best_shorttext_a, best_shorttext_b;
    while ((j = shorttext.indexOf(seed, j + 1)) != -1) {
      var prefixLength = dmp.diff_commonPrefix(longtext.substring(i),
                                               shorttext.substring(j));
      var suffixLength = dmp.diff_commonSuffix(longtext.substring(0, i),
                                               shorttext.substring(0, j));
      if (best_common.length < suffixLength + prefixLength) {
        best_common = shorttext.substring(j - suffixLength, j) +
            shorttext.substring(j, j + prefixLength);
        best_longtext_a = longtext.substring(0, i - suffixLength);
        best_longtext_b = longtext.substring(i + prefixLength);
        best_shorttext_a = shorttext.substring(0, j - suffixLength);
        best_shorttext_b = shorttext.substring(j + prefixLength);
      }
    }
    if (best_common.length * 2 >= longtext.length) {
      return [best_longtext_a, best_longtext_b,
              best_shorttext_a, best_shorttext_b, best_common];
    } else {
      return null;
    }
  }

  // First check if the second quarter is the seed for a half-match.
  var hm1 = diff_halfMatchI_(longtext, shorttext,
                             Math.ceil(longtext.length / 4));
  // Check again based on the third quarter.
  var hm2 = diff_halfMatchI_(longtext, shorttext,
                             Math.ceil(longtext.length / 2));
  var hm;
  if (!hm1 && !hm2) {
    return null;
  } else if (!hm2) {
    hm = hm1;
  } else if (!hm1) {
    hm = hm2;
  } else {
    // Both matched.  Select the longest.
    hm = hm1[4].length > hm2[4].length ? hm1 : hm2;
  }

  // A half-match was found, sort out the return data.
  var text1_a, text1_b, text2_a, text2_b;
  if (text1.length > text2.length) {
    text1_a = hm[0];
    text1_b = hm[1];
    text2_a = hm[2];
    text2_b = hm[3];
  } else {
    text2_a =