from turtle import Turtle
import math as m

class TurtleQS:

  def __init__(self, limit):
    if limit > 15: 
      print(f"Setting grid limit: {15}")    
      self.lx = 15 * -1
      self.ly = 15 * -1
      self.ux = 15
      self.uy = 15
    else:
      print(f"Setting grid limit: {limit}")    
      self.lx = abs(limit) * -1
      self.ly = abs(limit) * -1
      self.ux = abs(limit)
      self.uy = abs(limit)
    self.t = Turtle()

  def mainloop(self):
    self.t.screen.mainloop()

  def start(self, tracerOn, showGrid):
    screen = self.t.getscreen()
    screen.tracer(0)
    screen.setup(400, 400)
    screen.bgcolor("white")
    screen.setworldcoordinates(self.lx, self.ly, self.ux, self.uy)
    self.t.speed(0)  # Fastest speed

    if showGrid:
      self.drawGrid()

    screen.tracer(1 if tracerOn else 0)

    self.t.goto(0,0)
    self.t.pendown()
    return self.t

  def drawGrid(self):
    grid = Turtle()          # separate turtle
    grid.hideturtle()
    grid.penup()
    x = self.lx
    for i in range((self.ux * 2) + 1):
      # print(f"x: {x}")
      if i == ((self.ux * 2) / 2):
        grid.pencolor("red")
      else:
        grid.pencolor("black")
      grid.goto(x, self.uy)
      grid.pendown()
      grid.goto(x, self.ly)
      grid.penup()
      x += 1

    grid.penup()
    y = self.ly
    for i in range((self.uy * 2) + 1):
      # print(f"y: {y}")
      if i == (self.uy * 2) / 2:
        grid.pencolor("red")
      else:
        grid.pencolor("black")
      grid.goto(self.lx, y)
      grid.pendown()
      grid.goto(self.ux, y)
      grid.penup()
      y += 1
