
# Shared defaults
PROGRESS_BAR = False
NOTEBOOK = False
FRAMES_PER_SECOND = 10
LOG_LEVEL = 'WARNING'
LOG_LEVEL_OPTIONS = ['CRITICAL', 'ERROR', 'WARNING', 'INFO', 'DEBUG']

# 3D pose reconstruction defaults
RECONSTRUCTION_MIN_KEYPOINT_QUALITY = None
RECONSTRUCTION_MIN_NUM_KEYPOINTS = None
RECONSTRUCTION_MIN_POSE_QUALITY = None
RECONSTRUCTION_MIN_POSE_PAIR_SCORE = None
RECONSTRUCTION_MAX_POSE_PAIR_SCORE = 25.0
RECONSTRUCTION_POSE_PAIR_SCORE_DISTANCE_METHOD = 'pixels'
RECONSTRUCTION_POSE_PAIR_SCORE_PIXEL_DISTANCE_SCALE = 5.0
RECONSTRUCTION_POSE_PAIR_SCORE_SUMMARY_METHOD = 'rms'
RECONSTRUCTION_POSE_3D_GRAPH_INITIAL_EDGE_THRESHOLD = 2
RECONSTRUCTION_POSE_3D_GRAPH_MAX_DISPERSION = 0.20
RECONSTRUCTION_INCLUDE_TRACK_LABELS = False

# 3D pose spatial limit defaults
POSE_3D_FLOOR_Z = 0.0
POSE_3D_FOOT_Z_LIMITS = (0.0, 1.0)
POSE_3D_KNEE_Z_LIMITS = (0.0, 1.0)
POSE_3D_HIP_Z_LIMITS = (0.0, 1.5)
POSE_3D_THORAX_Z_LIMITS = (0.0, 1.7)
POSE_3D_SHOULDER_Z_LIMITS = (0.0, 1.9)
POSE_3D_ELBOW_Z_LIMITS = (0.0, 2.0)
POSE_3D_HAND_Z_LIMITS = (0.0, 3.0)
POSE_3D_NECK_Z_LIMITS = (0.0, 1.9)
POSE_3D_HEAD_Z_LIMITS = (0.0,2.0)
POSE_3D_LIMITS_TOLERANCE = 0.2

# Single timestamp 3D pose reconstruction defaults
RECONSTRUCTION_RETURN_DIAGNOSTICS = False

# 3D pose tracking defaults
TRACKING_MAX_MATCH_DISTANCE = 1.0
TRACKING_MAX_ITERATIONS_SINCE_LAST_MATCH = 20
TRACKING_CENTROID_POSITION_INITIAL_SD = 1.0
TRACKING_CENTROID_VELOCITY_INITIAL_SD = 1.0
TRACKING_REFERENCE_DELTA_T_SECONDS = 1.0
TRACKING_REFERENCE_VELOCITY_DRIFT = 0.30
TRACKING_POSITION_OBSERVATION_SD = 0.5
TRACKING_NUM_POSES_PER_TRACK_MIN = 11

# 3D pose track identification defaults
IDENTIFICATION_ID_FIELD_NAMES = ['person_id']
IDENTIFICATION_INTERPOLATION_FIELD_NAMES = ['x_position', 'y_position', 'z_position']
IDENTIFICATION_TIMESTAMP_FIELD_NAME = 'timestamp'
IDENTIFICATION_SENSOR_POSITION_KEYPOINT_INDEX = None
IDENTIFICATION_ACTIVE_PERSON_IDS = None
IDENTIFICATION_IGNORE_Z = True
IDENTIFICATION_MAX_DISTANCE = 2.0
IDENTIFICATION_RETURN_MATCH_STATISTICS=False
IDENTIFICATION_MIN_TRACK_FRACTION_MATCHED = 0.5

# Pose overlay defaults
OVERLAY_VIDEO_START_TIMEZONE='UTC'
OVERLAY_POSE_TYPE = '2d'
OVERLAY_CAMERA_ID = None
OVERLAY_CAMERA_CALIBRATION = None
OVERLAY_CAMERA_CALIBRATIONS = None
OVERLAY_POSE_LABEL_COLUMN = None
OVERLAY_POSE_LABEL_MAP = None
OVERLAY_GENERATE_POSE_LABEL_MAP = False
OVERLAY_VIDEO_FPS = None
OVERLAY_VIDEO_FRAME_COUNT = None
OVERLAY_VIDEO_OUTPUT_PATH = None
OVERLAY_VIDEO_OUTPUT_DIRECTORY = None
OVERLAY_VIDEO_OUTPUT_FILENAME_SUFFIX = None
OVERLAY_VIDEO_OUTPUT_FILENAME_EXTENSION = None
OVERLAY_VIDEO_OUTPUT_FOURCC_STRING= None
OVERLAY_IMAGE_OUTPUT_PATH = None
OVERLAY_IMAGE_OUTPUT_DIRECTORY = None
OVERLAY_DRAW_KEYPOINT_CONNECTORS = True
OVERLAY_KEYPOINT_CONNECTORS = None
OVERLAY_POSE_MODEL_NAME = None
OVERLAY_POSE_COLOR = 'green'
OVERLAY_KEYPOINT_RADIUS = 3
OVERLAY_KEYPOINT_ALPHA = 0.6
OVERLAY_KEYPOINT_CONNECTOR_ALPHA = 0.6
OVERLAY_KEYPOINT_CONNECTOR_LINEWIDTH = 3
OVERLAY_POSE_LABEL_TEXT_COLOR = 'white'
OVERLAY_POSE_LABEL_BOX_ALPHA = 0.6
OVERLAY_POSE_LABEL_FONT_SCALE = 1.5
OVERLAY_POSE_LABEL_TEXT_LINE_WIDTH = 1
OVERLAY_VIDEO_OUTPUT_FILENAME_SUFFIX_POSES_2D = 'poses_2d'
OVERLAY_VIDEO_OUTPUT_FILENAME_SUFFIX_POSES_3D = 'poses_3d'
OVERLAY_VIDEO_OUTPUT_FILENAME_SUFFIX_POSES_3D_TRACKED = 'poses_3d_tracked'
OVERLAY_VIDEO_OUTPUT_FILENAME_SUFFIX_POSES_3D_IDENTIFIED = 'poses_3d_identified'
OVERLAY_DRAW_TIMESTAMP = True
OVERLAY_TIMESTAMP_PADDING = 5
OVERLAY_TIMESTAMP_FONT_SCALE = 1.5
OVERLAY_TIMESTAMP_TEXT_LINE_WIDTH = 1
OVERLAY_TIMESTAMP_TEXT_COLOR = 'white'
OVERLAY_TIMESTAMP_BOX_COLOR = 'black'
OVERLAY_TIMESTAMP_BOX_ALPHA = 0.5
OVERLAY_TIMESTAMP_OFFSET_MAX_MILLISECONDS = 200
OVERLAY_IMAGE_OUTPUT_FILENAME_SUFFIX = 'frame'
OVERLAY_IMAGE_OUTPUT_FILENAME_EXTENSION = 'jpg'
