from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
from __future__ import unicode_literals
from future import standard_library
standard_library.install_aliases()

HEADER_LUMPS = 64
OVERLAY_BSP_FACE_COUNT = 64
WATEROVERLAY_BSP_FACE_COUNT = 256
MAX_MAP_LEAFS = 65536

MAX_MAP_DISP_POWER = 4


def NUM_DISP_POWER_VERTS(power):
    return (1 * (2 ** power) + 1) * (1 * (2 ** power) + 1)


MAX_DISPVERTS = NUM_DISP_POWER_VERTS(4)


def PAD_NUMBER(number, boundary):
    return (number + boundary - 1) // boundary * boundary


ALLOWEDVERTS_SIZE = PAD_NUMBER(MAX_DISPVERTS, 32) // 32
MAX_DISP_CORNER_NEIGHBORS = 4

STATIC_PROP_NAME_LENGTH = 128
DETAIL_NAME_LENGTH = 128

LUMP_ALIGNMENT = 4

LUMP_ENTITIES = 0
LUMP_PLANES = 1
LUMP_TEXDATA = 2
LUMP_VERTEXES = 3
LUMP_VISIBILITY = 4
LUMP_NODES = 5
LUMP_TEXINFO = 6
LUMP_FACES = 7
LUMP_LIGHTING = 8
LUMP_OCCLUSION = 9
LUMP_LEAFS = 10
LUMP_FACEIDS = 11
LUMP_EDGES = 12
LUMP_SURFEDGES = 13
LUMP_MODELS = 14
LUMP_WORLDLIGHTS = 15
LUMP_LEAFFACES = 16
LUMP_LEAFBRUSHES = 17
LUMP_BRUSHES = 18
LUMP_BRUSHSIDES = 19
LUMP_AREAS = 20
LUMP_AREAPORTALS = 21
LUMP_UNUSED0 = 22
LUMP_UNUSED1 = 23
LUMP_UNUSED2 = 24
LUMP_UNUSED3 = 25
LUMP_DISPINFO = 26
LUMP_ORIGINALFACES = 27
LUMP_PHYSDISP = 28
LUMP_PHYSCOLLIDE = 29
LUMP_VERTNORMALS = 30
LUMP_VERTNORMALINDICES = 31
LUMP_DISP_LIGHTMAP_ALPHAS = 32
LUMP_DISP_VERTS = 33
LUMP_DISP_LIGHTMAP_SAMPLE_POSITIONS = 34
LUMP_GAME_LUMP = 35
LUMP_LEAFWATERDATA = 36
LUMP_PRIMITIVES = 37
LUMP_PRIMVERTS = 38
LUMP_PRIMINDICES = 39
LUMP_PAKFILE = 40
LUMP_CLIPPORTALVERTS = 41
LUMP_CUBEMAPS = 42
LUMP_TEXDATA_STRING_DATA = 43
LUMP_TEXDATA_STRING_TABLE = 44
LUMP_OVERLAYS = 45
LUMP_LEAFMINDISTTOWATER = 46
LUMP_FACE_MACRO_TEXTURE_INFO = 47
LUMP_DISP_TRIS = 48
LUMP_PHYSCOLLIDESURFACE = 49
LUMP_WATEROVERLAYS = 50
LUMP_LEAF_AMBIENT_INDEX_HDR = 51
LUMP_LEAF_AMBIENT_INDEX = 52
LUMP_LIGHTING_HDR = 53
LUMP_WORLDLIGHTS_HDR = 54
LUMP_LEAF_AMBIENT_LIGHTING_HDR = 55
LUMP_LEAF_AMBIENT_LIGHTING = 56
LUMP_XZIPPAKFILE = 57
LUMP_FACES_HDR = 58
LUMP_MAP_FLAGS = 59
LUMP_OVERLAY_FADES = 60
LUMP_OVERLAY_SYSTEM_LEVELS = 61
LUMP_PHYSLEVEL = 62
LUMP_DISP_MULTIBLEND = 63


# Profiles
TEAMFORTRESS2 = 'TF2'
PORTAL2 = 'P2'
LEFT4DEAD2 = 'L4D2'
ALIENSWARM = 'AS'
ZENOCLASH = 'ZC'
VINDICTUS = 'VIN'
CONTAGION = 'CON'
TITANFALL = 'TIT'
THESHIP = 'SHIP'
