# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['netcdfella', 'netcdfella.cli', 'netcdfella.core', 'netcdfella.qnotify']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['netcdfella = netcdfella.cli.__main__:main']}

setup_kwargs = {
    'name': 'netcdfella',
    'version': '0.3.0',
    'description': 'Netcdfella is providing multiple ways to convert netcdf filed into other data types such as ASCII, PNG and JPG, and even create graphs.',
    'long_description': '<a name="readme-top"></a>\n\n[![Issues][issues-shield]][issues-url]\n[![GPL License][license-shield]][license-url]\n[![LinkedIn][linkedin-shield]][linkedin-url]\n\n<!-- PROJECT LOGO -->\n<br />\n<div align="center">\n  <a href="https://github.com/nikfot/netcdfella">\n    <img src="assets/netcdfella_logo.png" alt="Logo" height="300" width="auto">\n  </a>\n\n  <h3 align="center">NetcdFella</h3>\n\n  <p align="center">\n    The easy as duck duck netcdf converter to ASCII, JPEG and more...\n    <br />\n    <a href="https://github.com/nikfot/netcdfella"><strong>Explore the docs »</strong></a>\n    <br />\n    <br />\n    ·\n    <a href="https://github.com/nikfot/netcdfella/issues">Report Bug</a>\n    ·\n    <a href="https://github.com/nikfot/netcdfella/issues">Request Feature</a>\n  </p>\n</div>\n\n<!-- TABLE OF CONTENTS -->\n<details>\n  <summary>Table of Contents</summary>\n  <ol>\n    <li>\n      <a href="#about-the-project">About The Project</a>\n      <ul>\n        <li><a href="#built-with">Built With</a></li>\n      </ul>\n    </li>\n    <li>\n      <a href="#getting-started">Getting Started</a>\n      <ul>\n        <li><a href="#prerequisites">Prerequisites</a></li>\n        <li><a href="#installation">Installation</a></li>\n      </ul>\n    </li>\n    <li><a href="#usage">Usage</a></li>\n    <li><a href="#roadmap">Roadmap</a></li>\n    <li><a href="#contributing">Contributing</a></li>\n    <li><a href="#license">License</a></li>\n    <li><a href="#contact">Contact</a></li>\n    <li><a href="#acknowledgments">Acknowledgments</a></li>\n  </ol>\n</details>\n\n<!-- ABOUT THE PROJECT -->\n\n## About The Project\n\nNetcdfella is a command line interface (cli) tool for converting netcdf files to ASCII and JPG/PNG format, as well as creating graphs based on the vectors of the file.\n\nNetcdfella supports two ways for converting documents at the time being:\n\n- single/multi convert\n- conversion upon creation\n\nDuring the run of the cli the output types, the mapping dimension and variable can be selected aling with other options.\n\n### single/multi convert\n\nYou can convert a single file or all netcdf files in a directory on your command. This is the case of the single/multi select.\n\n### conversion upon creation\n\nA directory can be selected to be watched by netcdfella. WHen a new netcdf file is created in that directory, it is automatically converted in the selected formats.\n\n#### qnotify\n\nIn order to handle any amount of input documents in the case of watch. A producer-consumer queue is created in the module qnotify using the inotify library. In this case the producers are the directory events. This creates a buffer that can handle the set amount of concurrent document creations.\n\nUse the `README.md` to get started.\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n### Built With\n\nThis section should list any major frameworks/libraries used to bootstrap your project. Leave any add-ons/plugins for the acknowledgements section. Here are a few examples.\n\n- [![Python][python]][python-url]\n- [![Poetry][poetry]][poetry-url]\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n<!-- GETTING STARTED -->\n\n## Getting Started\n\nThis is an example of how you may give instructions on setting up your project locally.\nTo get a local copy up and running follow these simple example steps.\n\n### Prerequisites\n\nThis software and tested for Python version 3.10.4.\n\nIf you need to manually install packages:\n\n- requirements\n  ```sh\n  pip install -r requirements.txt\n  ```\n\nIf you wish to make use of the pyproject.toml you need to install poetry:\n\n- poetry\n  ```sh\n  curl -sSL https://install.python-poetry.org | python3 -\n  ```\n\n### Installation\n\n_You can install from source or from pypi_\n\n#### Source\n\n1. Clone the repo\n   ```sh\n   git clone https://github.com/nikfot/netcdfella.git\n   ```\n2. Install using poetry\n   ```sh\n   poetry install\n   ```\n3. Run `netcdfella` to see the help with available choices:\n\n   ```sh\n   netcdfella\n   ```\n\n   or\n\n   ```sh\n   netcdfella --help\n   ```\n\n#### PYPI\n\nUse PYPI to pip install the project:\n\n    ```sh\n    pip install netcdfella\n    ```\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n<!-- USAGE EXAMPLES -->\n\n## Usage\n\nYou can use the netcdfella to get a better description of the available choices:\n\n    ```sh\n    netcdfella\n    ```\n\n    or\n\n    ```sh\n    netcdfella --help\n    ```\n\n### convert\n\nUse netcdfella to convert a single document or all documents in a directory:\n\n    ```sh\n    netcdfella convert "/path/to/documents" -k "ascii,graph,scatter,marks" -md "flashes" -mv "radiance"\n    ```\n\nAll choices for convert subcommand:\nOptions:\n-o, --output-dir TEXT set the output directory for converted files.\n-k, --output-kinds TEXT set the output kind for conversion.\n-md, --map-dimension TEXT set the dimenion to use for mapping.\n-mv, --map-variable TEXT set the variable to use for mapping.\n-e, --exclude-variables TEXT comma separated list of variables to be\nexcluded from conversion.\n--help Show this message and exit.\n\n### watch\n\nUse netcdfella to watch over a directory and convert files upon creation:\n\n    ```sh\n    netcdfella watch "/path/to/documents" -k "ascii,graph,scatter,marks" -md "flashes" -mv "radiance"\n    ```\n\nOptions:\n-o, --output-dir TEXT set the output directory for converted files.\n-k, --output-kinds TEXT set the output kind for conversion.\n-md, --map-dimension TEXT set the dimenion to use for mapping.\n-mv, --map-variable TEXT set the variable to use for mapping.\n-e, --exclude-variables TEXT comma separated list of variables to be\nexcluded from conversion.\n--help Show this message and exit.\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n<!-- ROADMAP -->\n\n## Roadmap\n\n- [x] Add cli conversion\n- [x] Add ascii,jpg/png, graphs\n- [ ] Add docker support\n- [ ] Check compatibility with more netcdf filetypes (current test METEOSAT 4th gen)\n- [ ] Add REST API Server\n- [ ] Add gui\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n<!-- CONTRIBUTING -->\n\n## Contributing\n\nThere are still a lot to be done, so if you find the project usefull please contribute you comments, ideas and code. It is **greatly appreciated**.\n\nIf you have a suggestion that would make this better, please fork the repo and create a pull request. You can also simply open an issue with the tag "enhancement".\nDon\'t forget to give the project a star! Thanks again!\n\n1. Fork the Project\n2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)\n3. Commit your Changes (`git commit -m \'Add some AmazingFeature\'`)\n4. Push to the Branch (`git push origin feature/AmazingFeature`)\n5. Open a Pull Request\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n<!-- LICENSE -->\n\n## License\n\nDistributed under the GPL License. See `LICENSE.md` for more information.\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n<!-- CONTACT -->\n\n## Contact\n\nNikos Fotiou - [@workaround18](https://twitter.com/workaround18) - nik_fot@hotmail.gr\n\nNetcdfella: [https://github.com/nikfot/netcdfella](https://github.com/nikfot/netcdfella)\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n<!-- ACKNOWLEDGMENTS -->\n\n## Acknowledgments\n\nThis tool is created as part of my postgrad studies "Space Technologies Applications and Services - STAR" programm at the National and Kapodestrian University of Athens Greece (NKUA). It was a semester project for the class "Space Image Processing" by professor Stavros Kolios.\n\n<p align="right">(<a href="#readme-top">back to top</a>)</p>\n\n[issues-shield]: https://img.shields.io/badge/github-issues-gray?style=for-the-badge&logo=Github\n[issues-url]: https://github.com/nikfot/netcdfella/issues\n[license-shield]: https://img.shields.io/pypi/l/netcdfella?style=plastic\n[license-url]: https://github.com/nikfot/netcdfella/blob/master/LICENSE.md\n[linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555\n[linkedin-url]: https://www.linkedin.com/in/nikosfotiou/\n[netcdfella-logo]: assets/netcdfella_logo.png\n[python]: https://img.shields.io/badge/python-yellow?style=for-the-badge&logo=Python\n[python-url]: https://www.python.org/\n[poetry]: https://img.shields.io/badge/poetry-blue?style=for-the-badge&logo=Poetry\n[poetry-url]: https://upstreamsystems.atlassian.net/jira/your-work\n',
    'author': 'Nikos Fotiou',
    'author_email': 'nik_fot@hotmail.gr',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://nikfot.github.io/netcdfella/',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.10.4,<4.0.0',
}


setup(**setup_kwargs)
