/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import java.io.NotSerializableException;
import java.io.ObjectStreamClass;
import java.security.AccessController;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.serializer.SerializationDebugger;
import org.apache.spark.serializer.SerializationDebugger$ObjectStreamClassMethods$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;
import sun.security.action.GetBooleanAction;

public final class SerializationDebugger$
implements Logging {
    public static final SerializationDebugger$ MODULE$;
    private boolean enableDebugging;
    private final SerializationDebugger.ObjectStreamClassReflection org$apache$spark$serializer$SerializationDebugger$$reflect;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SerializationDebugger$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NotSerializableException improveException(Object obj, NotSerializableException e) {
        NotSerializableException notSerializableException;
        if (this.enableDebugging() && this.org$apache$spark$serializer$SerializationDebugger$$reflect() != null) {
            try {
                notSerializableException = new NotSerializableException(new StringBuilder().append((Object)e.getMessage()).append((Object)"\nSerialization stack:\n").append((Object)((TraversableOnce)this.find(obj).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$1) {
                        return new StringBuilder().append((Object)"\t- ").append((Object)x$1).toString();
                    }
                }, List$.MODULE$.canBuildFrom())).mkString("\n")).toString());
                return notSerializableException;
            }
            catch (Throwable throwable) {
                NotSerializableException notSerializableException2;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option.get();
                this.logWarning((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Exception in serialization debugger";
                    }
                }, t);
                notSerializableException = notSerializableException2 = e;
                return notSerializableException;
            }
        } else {
            notSerializableException = e;
            return notSerializableException;
        }
    }

    public List<String> find(Object obj) {
        return new SerializationDebugger.SerializationDebugger().visit(obj, (List<String>)List$.MODULE$.empty());
    }

    public boolean enableDebugging() {
        return this.enableDebugging;
    }

    public void enableDebugging_$eq(boolean x$1) {
        this.enableDebugging = x$1;
    }

    public Tuple2<Object, ObjectStreamClass> org$apache$spark$serializer$SerializationDebugger$$findObjectAndDescriptor(Object o) {
        Tuple2 tuple2;
        block2: {
            Class<?> cl;
            ObjectStreamClass desc;
            while (SerializationDebugger$ObjectStreamClassMethods$.MODULE$.hasWriteReplaceMethod$extension(this.ObjectStreamClassMethods(desc = ObjectStreamClass.lookupAny(cl = o.getClass())))) {
                Object replaced = SerializationDebugger$ObjectStreamClassMethods$.MODULE$.invokeWriteReplace$extension(this.ObjectStreamClassMethods(desc), o);
                Class<?> clazz = replaced.getClass();
                Class<?> clazz2 = o.getClass();
                if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                    tuple2 = new Tuple2(replaced, (Object)desc);
                    break block2;
                }
                o = replaced;
            }
            tuple2 = new Tuple2(o, (Object)desc);
        }
        return tuple2;
    }

    public ObjectStreamClass ObjectStreamClassMethods(ObjectStreamClass desc) {
        return desc;
    }

    public SerializationDebugger.ObjectStreamClassReflection org$apache$spark$serializer$SerializationDebugger$$reflect() {
        return this.org$apache$spark$serializer$SerializationDebugger$$reflect;
    }

    private final SerializationDebugger.ObjectStreamClassReflection liftedTree1$1() {
        SerializationDebugger.ObjectStreamClassReflection objectStreamClassReflection;
        try {
            objectStreamClassReflection = new SerializationDebugger.ObjectStreamClassReflection();
        }
        catch (Exception exception2) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot find private methods using reflection";
                }
            }, exception2);
            objectStreamClassReflection = null;
        }
        return objectStreamClassReflection;
    }

    private SerializationDebugger$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.enableDebugging = AccessController.doPrivileged(new GetBooleanAction("sun.io.serialization.extendedDebugInfo")) == false;
        this.org$apache$spark$serializer$SerializationDebugger$$reflect = this.liftedTree1$1();
    }
}

