/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.MetaStoreSchemaInfo;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.HiveSchemaHelper;

public class HiveSchemaTool {
    private String userName = null;
    private String passWord = null;
    private boolean dryRun = false;
    private boolean verbose = false;
    private String dbOpts = null;
    private final HiveConf hiveConf;
    private final String dbType;
    private final MetaStoreSchemaInfo metaStoreSchemaInfo;

    public HiveSchemaTool(String dbType) throws HiveMetaException {
        this(System.getenv("HIVE_HOME"), new HiveConf(HiveSchemaTool.class), dbType);
    }

    public HiveSchemaTool(String hiveHome, HiveConf hiveConf, String dbType) throws HiveMetaException {
        if (hiveHome == null || hiveHome.isEmpty()) {
            throw new HiveMetaException("No Hive home directory provided");
        }
        this.hiveConf = hiveConf;
        this.dbType = dbType;
        this.metaStoreSchemaInfo = new MetaStoreSchemaInfo(hiveHome, hiveConf, dbType);
        this.userName = hiveConf.get(HiveConf.ConfVars.METASTORE_CONNECTION_USER_NAME.varname);
        try {
            this.passWord = ShimLoader.getHadoopShims().getPassword((Configuration)hiveConf, HiveConf.ConfVars.METASTOREPWD.varname);
        }
        catch (IOException err) {
            throw new HiveMetaException("Error getting metastore password", (Throwable)err);
        }
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDbOpts(String dbOpts) {
        this.dbOpts = dbOpts;
    }

    private static void printAndExit(Options cmdLineOptions) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("schemaTool", cmdLineOptions);
        System.exit(1);
    }

    private Connection getConnectionToMetastore(boolean printInfo) throws HiveMetaException {
        return HiveSchemaHelper.getConnectionToMetastore(this.userName, this.passWord, printInfo, this.hiveConf);
    }

    private HiveSchemaHelper.NestedScriptParser getDbCommandParser(String dbType) {
        return HiveSchemaHelper.getDbCommandParser(dbType, this.dbOpts, this.userName, this.passWord, this.hiveConf);
    }

    public void showInfo() throws HiveMetaException {
        Connection metastoreConn = this.getConnectionToMetastore(true);
        System.out.println("Hive distribution version:\t " + MetaStoreSchemaInfo.getHiveSchemaVersion());
        System.out.println("Metastore schema version:\t " + this.getMetaStoreSchemaVersion(metastoreConn));
    }

    private String getMetaStoreSchemaVersion(Connection metastoreConn) throws HiveMetaException {
        String versionQuery = this.getDbCommandParser(this.dbType).needsQuotedIdentifier() ? "select t.\"SCHEMA_VERSION\" from \"VERSION\" t" : "select t.SCHEMA_VERSION from VERSION t";
        try {
            Statement stmt = metastoreConn.createStatement();
            ResultSet res = stmt.executeQuery(versionQuery);
            if (!res.next()) {
                throw new HiveMetaException("Didn't find version data in metastore");
            }
            String currentSchemaVersion = res.getString(1);
            metastoreConn.close();
            return currentSchemaVersion;
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get schema version.", (Throwable)e);
        }
    }

    private void testConnectionToMetastore() throws HiveMetaException {
        Connection conn = this.getConnectionToMetastore(true);
        try {
            conn.close();
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to close metastore connection", (Throwable)e);
        }
    }

    public void verifySchemaVersion() throws HiveMetaException {
        if (this.dryRun) {
            return;
        }
        String newSchemaVersion = this.getMetaStoreSchemaVersion(this.getConnectionToMetastore(false));
        if (!MetaStoreSchemaInfo.getHiveSchemaVersion().equalsIgnoreCase(newSchemaVersion)) {
            throw new HiveMetaException("Expected schema version " + MetaStoreSchemaInfo.getHiveSchemaVersion() + ", found version " + newSchemaVersion);
        }
    }

    public void doUpgrade() throws HiveMetaException {
        String fromVersion = this.getMetaStoreSchemaVersion(this.getConnectionToMetastore(false));
        if (fromVersion == null || fromVersion.isEmpty()) {
            throw new HiveMetaException("Schema version not stored in the metastore. Metastore schema is too old or corrupt. Try specifying the version manually");
        }
        this.doUpgrade(fromVersion);
    }

    public void doUpgrade(String fromSchemaVer) throws HiveMetaException {
        if (MetaStoreSchemaInfo.getHiveSchemaVersion().equals(fromSchemaVer)) {
            System.out.println("No schema upgrade required from version " + fromSchemaVer);
            return;
        }
        List upgradeScripts = this.metaStoreSchemaInfo.getUpgradeScripts(fromSchemaVer);
        this.testConnectionToMetastore();
        System.out.println("Starting upgrade metastore schema from version " + fromSchemaVer + " to " + MetaStoreSchemaInfo.getHiveSchemaVersion());
        String scriptDir = this.metaStoreSchemaInfo.getMetaStoreScriptDir();
        try {
            for (String scriptFile : upgradeScripts) {
                System.out.println("Upgrade script " + scriptFile);
                if (this.dryRun) continue;
                this.runPreUpgrade(scriptDir, scriptFile);
                this.runBeeLine(scriptDir, scriptFile);
                System.out.println("Completed " + scriptFile);
            }
        }
        catch (IOException eIO) {
            throw new HiveMetaException("Upgrade FAILED! Metastore state would be inconsistent !!", (Throwable)eIO);
        }
        this.verifySchemaVersion();
    }

    public void doInit() throws HiveMetaException {
        this.doInit(MetaStoreSchemaInfo.getHiveSchemaVersion());
        this.verifySchemaVersion();
    }

    public void doInit(String toVersion) throws HiveMetaException {
        this.testConnectionToMetastore();
        System.out.println("Starting metastore schema initialization to " + toVersion);
        String initScriptDir = this.metaStoreSchemaInfo.getMetaStoreScriptDir();
        String initScriptFile = this.metaStoreSchemaInfo.generateInitFileName(toVersion);
        try {
            System.out.println("Initialization script " + initScriptFile);
            if (!this.dryRun) {
                this.runBeeLine(initScriptDir, initScriptFile);
                System.out.println("Initialization script completed");
            }
        }
        catch (IOException e) {
            throw new HiveMetaException("Schema initialization FAILED! Metastore state would be inconsistent !!", (Throwable)e);
        }
    }

    private void runPreUpgrade(String scriptDir, String scriptFile) {
        String preUpgradeScript;
        File preUpgradeScriptFile;
        int i = 0;
        while ((preUpgradeScriptFile = new File(scriptDir, preUpgradeScript = MetaStoreSchemaInfo.getPreUpgradeScriptName((int)i, (String)scriptFile))).isFile()) {
            block3: {
                try {
                    this.runBeeLine(scriptDir, preUpgradeScript);
                    System.out.println("Completed " + preUpgradeScript);
                }
                catch (Exception e) {
                    System.err.println("Warning in pre-upgrade script " + preUpgradeScript + ": " + e.getMessage());
                    if (!this.verbose) break block3;
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void runBeeLine(String scriptDir, String scriptFile) throws IOException, HiveMetaException {
        HiveSchemaHelper.NestedScriptParser dbCommandParser = this.getDbCommandParser(this.dbType);
        String sqlCommands = dbCommandParser.buildCommand(scriptDir, scriptFile);
        File tmpFile = File.createTempFile("schematool", ".sql");
        tmpFile.deleteOnExit();
        FileWriter fstream = new FileWriter(tmpFile.getPath());
        BufferedWriter out = new BufferedWriter(fstream);
        out.write("!autocommit on" + System.getProperty("line.separator"));
        out.write(sqlCommands);
        out.write("!closeall" + System.getProperty("line.separator"));
        out.close();
        this.runBeeLine(tmpFile.getPath());
    }

    public void runBeeLine(String sqlScriptFile) throws IOException {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-u");
        argList.add(HiveSchemaHelper.getValidConfVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, this.hiveConf));
        argList.add("-d");
        argList.add(HiveSchemaHelper.getValidConfVar(HiveConf.ConfVars.METASTORE_CONNECTION_DRIVER, this.hiveConf));
        argList.add("-n");
        argList.add(this.userName);
        argList.add("-p");
        argList.add(this.passWord);
        argList.add("-f");
        argList.add(sqlScriptFile);
        BeeLine beeLine = new BeeLine();
        if (!this.verbose) {
            beeLine.setOutputStream(new PrintStream((OutputStream)new NullOutputStream()));
            beeLine.getOpts().setSilent(true);
        }
        beeLine.getOpts().setAllowMultiLineCommand(false);
        beeLine.getOpts().setIsolation("TRANSACTION_READ_COMMITTED");
        beeLine.getOpts().setEntireLineAsCommand(true);
        int status = beeLine.begin(argList.toArray(new String[0]), null);
        if (status != 0) {
            throw new IOException("Schema script failed, errorcode " + status);
        }
    }

    private static void initOptions(Options cmdLineOptions) {
        Option help = new Option("help", "print this message");
        Option upgradeOpt = new Option("upgradeSchema", "Schema upgrade");
        OptionBuilder.withArgName((String)"upgradeFrom");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Schema upgrade from a version");
        Option upgradeFromOpt = OptionBuilder.create((String)"upgradeSchemaFrom");
        Option initOpt = new Option("initSchema", "Schema initialization");
        OptionBuilder.withArgName((String)"initTo");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Schema initialization to a version");
        Option initToOpt = OptionBuilder.create((String)"initSchemaTo");
        Option infoOpt = new Option("info", "Show config and schema details");
        OptionGroup optGroup = new OptionGroup();
        optGroup.addOption(upgradeOpt).addOption(initOpt).addOption(help).addOption(upgradeFromOpt).addOption(initToOpt).addOption(infoOpt);
        optGroup.setRequired(true);
        OptionBuilder.withArgName((String)"user");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Override config file user name");
        Option userNameOpt = OptionBuilder.create((String)"userName");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Override config file password");
        Option passwdOpt = OptionBuilder.create((String)"passWord");
        OptionBuilder.withArgName((String)"databaseType");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Metastore database type");
        Option dbTypeOpt = OptionBuilder.create((String)"dbType");
        OptionBuilder.withArgName((String)"databaseOpts");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Backend DB specific options");
        Option dbOpts = OptionBuilder.create((String)"dbOpts");
        Option dryRunOpt = new Option("dryRun", "list SQL scripts (no execute)");
        Option verboseOpt = new Option("verbose", "only print SQL statements");
        cmdLineOptions.addOption(help);
        cmdLineOptions.addOption(dryRunOpt);
        cmdLineOptions.addOption(userNameOpt);
        cmdLineOptions.addOption(passwdOpt);
        cmdLineOptions.addOption(dbTypeOpt);
        cmdLineOptions.addOption(verboseOpt);
        cmdLineOptions.addOption(dbOpts);
        cmdLineOptions.addOptionGroup(optGroup);
    }

    public static void main(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        String dbType = null;
        String schemaVer = null;
        Options cmdLineOptions = new Options();
        HiveSchemaTool.initOptions(cmdLineOptions);
        try {
            line = parser.parse(cmdLineOptions, args);
        }
        catch (ParseException e) {
            System.err.println("HiveSchemaTool:Parsing failed.  Reason: " + e.getLocalizedMessage());
            HiveSchemaTool.printAndExit(cmdLineOptions);
        }
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("schemaTool", cmdLineOptions);
            return;
        }
        if (line.hasOption("dbType")) {
            dbType = line.getOptionValue("dbType");
            if (!(dbType.equalsIgnoreCase("derby") || dbType.equalsIgnoreCase("mssql") || dbType.equalsIgnoreCase("mysql") || dbType.equalsIgnoreCase("postgres") || dbType.equalsIgnoreCase("oracle"))) {
                System.err.println("Unsupported dbType " + dbType);
                HiveSchemaTool.printAndExit(cmdLineOptions);
            }
        } else {
            System.err.println("no dbType supplied");
            HiveSchemaTool.printAndExit(cmdLineOptions);
        }
        System.setProperty(HiveConf.ConfVars.METASTORE_SCHEMA_VERIFICATION.varname, "true");
        try {
            HiveSchemaTool schemaTool = new HiveSchemaTool(dbType);
            if (line.hasOption("userName")) {
                schemaTool.setUserName(line.getOptionValue("userName"));
            }
            if (line.hasOption("passWord")) {
                schemaTool.setPassWord(line.getOptionValue("passWord"));
            }
            if (line.hasOption("dryRun")) {
                schemaTool.setDryRun(true);
            }
            if (line.hasOption("verbose")) {
                schemaTool.setVerbose(true);
            }
            if (line.hasOption("dbOpts")) {
                schemaTool.setDbOpts(line.getOptionValue("dbOpts"));
            }
            if (line.hasOption("info")) {
                schemaTool.showInfo();
            } else if (line.hasOption("upgradeSchema")) {
                schemaTool.doUpgrade();
            } else if (line.hasOption("upgradeSchemaFrom")) {
                schemaVer = line.getOptionValue("upgradeSchemaFrom");
                schemaTool.doUpgrade(schemaVer);
            } else if (line.hasOption("initSchema")) {
                schemaTool.doInit();
            } else if (line.hasOption("initSchemaTo")) {
                schemaVer = line.getOptionValue("initSchemaTo");
                schemaTool.doInit(schemaVer);
            } else {
                System.err.println("no valid option supplied");
                HiveSchemaTool.printAndExit(cmdLineOptions);
            }
        }
        catch (HiveMetaException e) {
            System.err.println((Object)e);
            if (line.hasOption("verbose")) {
                e.printStackTrace();
            }
            System.err.println("*** schemaTool failed ***");
            System.exit(1);
        }
        System.out.println("schemaTool completed");
    }
}

