/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public strictfp class FloatFFT_3D {
    private int slices;
    private int rows;
    private int columns;
    private int sliceStride;
    private int rowStride;
    private float[] t;
    private FloatFFT_1D fftSlices;
    private FloatFFT_1D fftRows;
    private FloatFFT_1D fftColumns;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatFFT_3D(int slices, int rows, int columns) {
        if (slices <= 1 || rows <= 1 || columns <= 1) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = slices;
        this.rows = rows;
        this.columns = columns;
        this.sliceStride = rows * columns;
        this.rowStride = columns;
        if (slices * rows * columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(slices) && ConcurrencyUtils.isPowerOf2(rows) && ConcurrencyUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = slices;
            if (this.nt < rows) {
                this.nt = rows;
            }
            this.nt *= 8;
            if (this.oldNthreads > 1) {
                this.nt *= this.oldNthreads;
            }
            if (2 * columns == 4) {
                this.nt >>= 1;
            } else if (2 * columns < 4) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
        }
        this.fftSlices = new FloatFFT_1D(slices);
        this.fftRows = slices == rows ? this.fftSlices : new FloatFFT_1D(rows);
        this.fftColumns = slices == columns ? this.fftSlices : (rows == columns ? this.fftRows : new FloatFFT_1D(columns));
    }

    public void complexForward(final float[] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns *= 2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, a, true);
                this.cdft3db_subth(-1, a, true);
            } else {
                this.xdft3da_sub2(0, -1, a, true);
                this.cdft3db_sub(-1, a, true);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                int l = 0;
                while (l < nthreads) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int s = firstSlice;
                            while (s < lastSlice) {
                                int idx1 = s * FloatFFT_3D.this.sliceStride;
                                int r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.complexForward(a, idx1 + r * FloatFFT_3D.this.rowStride);
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                l = 0;
                while (l < nthreads) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            float[] temp = new float[2 * FloatFFT_3D.this.rows];
                            int s = firstSlice;
                            while (s < lastSlice) {
                                int idx1 = s * FloatFFT_3D.this.sliceStride;
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx4;
                                    int idx3;
                                    int idx2 = 2 * c;
                                    int r = 0;
                                    while (r < FloatFFT_3D.this.rows) {
                                        idx3 = idx1 + idx2 + r * FloatFFT_3D.this.rowStride;
                                        idx4 = 2 * r;
                                        temp[idx4] = a[idx3];
                                        temp[idx4 + 1] = a[idx3 + 1];
                                        ++r;
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(temp);
                                    r = 0;
                                    while (r < FloatFFT_3D.this.rows) {
                                        idx3 = idx1 + idx2 + r * FloatFFT_3D.this.rowStride;
                                        idx4 = 2 * r;
                                        a[idx3] = temp[idx4];
                                        a[idx3 + 1] = temp[idx4 + 1];
                                        ++r;
                                    }
                                    ++c;
                                }
                                ++s;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.rows / nthreads;
                l = 0;
                while (l < nthreads) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            float[] temp = new float[2 * FloatFFT_3D.this.slices];
                            int r = firstRow;
                            while (r < lastRow) {
                                int idx1 = r * FloatFFT_3D.this.rowStride;
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx4;
                                    int idx3;
                                    int idx2 = 2 * c;
                                    int s = 0;
                                    while (s < FloatFFT_3D.this.slices) {
                                        idx3 = s * FloatFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s;
                                        temp[idx4] = a[idx3];
                                        temp[idx4 + 1] = a[idx3 + 1];
                                        ++s;
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(temp);
                                    s = 0;
                                    while (s < FloatFFT_3D.this.slices) {
                                        idx3 = s * FloatFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s;
                                        a[idx3] = temp[idx4];
                                        a[idx3 + 1] = temp[idx4 + 1];
                                        ++s;
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx4;
                int idx3;
                int idx2;
                int c;
                int idx1;
                int s = 0;
                while (s < this.slices) {
                    int idx12 = s * this.sliceStride;
                    int r = 0;
                    while (r < this.rows) {
                        this.fftColumns.complexForward(a, idx12 + r * this.rowStride);
                        ++r;
                    }
                    ++s;
                }
                float[] temp = new float[2 * this.rows];
                int s2 = 0;
                while (s2 < this.slices) {
                    idx1 = s2 * this.sliceStride;
                    c = 0;
                    while (c < this.columns) {
                        idx2 = 2 * c;
                        int r = 0;
                        while (r < this.rows) {
                            idx3 = idx1 + idx2 + r * this.rowStride;
                            idx4 = 2 * r;
                            temp[idx4] = a[idx3];
                            temp[idx4 + 1] = a[idx3 + 1];
                            ++r;
                        }
                        this.fftRows.complexForward(temp);
                        r = 0;
                        while (r < this.rows) {
                            idx3 = idx1 + idx2 + r * this.rowStride;
                            idx4 = 2 * r;
                            a[idx3] = temp[idx4];
                            a[idx3 + 1] = temp[idx4 + 1];
                            ++r;
                        }
                        ++c;
                    }
                    ++s2;
                }
                temp = new float[2 * this.slices];
                int r = 0;
                while (r < this.rows) {
                    idx1 = r * this.rowStride;
                    c = 0;
                    while (c < this.columns) {
                        idx2 = 2 * c;
                        int s3 = 0;
                        while (s3 < this.slices) {
                            idx3 = s3 * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s3;
                            temp[idx4] = a[idx3];
                            temp[idx4 + 1] = a[idx3 + 1];
                            ++s3;
                        }
                        this.fftSlices.complexForward(temp);
                        s3 = 0;
                        while (s3 < this.slices) {
                            idx3 = s3 * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s3;
                            a[idx3] = temp[idx4];
                            a[idx3 + 1] = temp[idx4 + 1];
                            ++s3;
                        }
                        ++c;
                    }
                    ++r;
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexForward(final float[][][] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns *= 2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, a, true);
                this.cdft3db_subth(-1, a, true);
            } else {
                this.xdft3da_sub2(0, -1, a, true);
                this.cdft3db_sub(-1, a, true);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            int l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FloatFFT_3D.this.rows) {
                                FloatFFT_3D.this.fftColumns.complexForward(a[s][r]);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.rows];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int c = 0;
                            while (c < FloatFFT_3D.this.columns) {
                                int idx4;
                                int idx2 = 2 * c;
                                int r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx4 = 2 * r;
                                    temp[idx4] = a[s][r][idx2];
                                    temp[idx4 + 1] = a[s][r][idx2 + 1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexForward(temp);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx4 = 2 * r;
                                    a[s][r][idx2] = temp[idx4];
                                    a[s][r][idx2 + 1] = temp[idx4 + 1];
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            l = 0;
            while (l < nthreads) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.slices];
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FloatFFT_3D.this.columns) {
                                int idx4;
                                int idx2 = 2 * c;
                                int s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx4 = 2 * s;
                                    temp[idx4] = a[s][r][idx2];
                                    temp[idx4 + 1] = a[s][r][idx2 + 1];
                                    ++s;
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(temp);
                                s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx4 = 2 * s;
                                    a[s][r][idx2] = temp[idx4];
                                    a[s][r][idx2 + 1] = temp[idx4 + 1];
                                    ++s;
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx4;
            int idx2;
            int c;
            int r;
            int s = 0;
            while (s < this.slices) {
                r = 0;
                while (r < this.rows) {
                    this.fftColumns.complexForward(a[s][r]);
                    ++r;
                }
                ++s;
            }
            float[] temp = new float[2 * this.rows];
            int s2 = 0;
            while (s2 < this.slices) {
                c = 0;
                while (c < this.columns) {
                    idx2 = 2 * c;
                    int r2 = 0;
                    while (r2 < this.rows) {
                        idx4 = 2 * r2;
                        temp[idx4] = a[s2][r2][idx2];
                        temp[idx4 + 1] = a[s2][r2][idx2 + 1];
                        ++r2;
                    }
                    this.fftRows.complexForward(temp);
                    r2 = 0;
                    while (r2 < this.rows) {
                        idx4 = 2 * r2;
                        a[s2][r2][idx2] = temp[idx4];
                        a[s2][r2][idx2 + 1] = temp[idx4 + 1];
                        ++r2;
                    }
                    ++c;
                }
                ++s2;
            }
            temp = new float[2 * this.slices];
            r = 0;
            while (r < this.rows) {
                c = 0;
                while (c < this.columns) {
                    idx2 = 2 * c;
                    int s3 = 0;
                    while (s3 < this.slices) {
                        idx4 = 2 * s3;
                        temp[idx4] = a[s3][r][idx2];
                        temp[idx4 + 1] = a[s3][r][idx2 + 1];
                        ++s3;
                    }
                    this.fftSlices.complexForward(temp);
                    s3 = 0;
                    while (s3 < this.slices) {
                        idx4 = 2 * s3;
                        a[s3][r][idx2] = temp[idx4];
                        a[s3][r][idx2 + 1] = temp[idx4 + 1];
                        ++s3;
                    }
                    ++c;
                }
                ++r;
            }
        }
    }

    public void complexInverse(final float[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns *= 2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
            } else {
                this.xdft3da_sub2(0, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                int l = 0;
                while (l < nthreads) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int s = firstSlice;
                            while (s < lastSlice) {
                                int idx1 = s * FloatFFT_3D.this.sliceStride;
                                int r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(a, idx1 + r * FloatFFT_3D.this.rowStride, scale);
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                l = 0;
                while (l < nthreads) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            float[] temp = new float[2 * FloatFFT_3D.this.rows];
                            int s = firstSlice;
                            while (s < lastSlice) {
                                int idx1 = s * FloatFFT_3D.this.sliceStride;
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx4;
                                    int idx3;
                                    int idx2 = 2 * c;
                                    int r = 0;
                                    while (r < FloatFFT_3D.this.rows) {
                                        idx3 = idx1 + idx2 + r * FloatFFT_3D.this.rowStride;
                                        idx4 = 2 * r;
                                        temp[idx4] = a[idx3];
                                        temp[idx4 + 1] = a[idx3 + 1];
                                        ++r;
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(temp, scale);
                                    r = 0;
                                    while (r < FloatFFT_3D.this.rows) {
                                        idx3 = idx1 + idx2 + r * FloatFFT_3D.this.rowStride;
                                        idx4 = 2 * r;
                                        a[idx3] = temp[idx4];
                                        a[idx3 + 1] = temp[idx4 + 1];
                                        ++r;
                                    }
                                    ++c;
                                }
                                ++s;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.rows / nthreads;
                l = 0;
                while (l < nthreads) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            float[] temp = new float[2 * FloatFFT_3D.this.slices];
                            int r = firstRow;
                            while (r < lastRow) {
                                int idx1 = r * FloatFFT_3D.this.rowStride;
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx4;
                                    int idx3;
                                    int idx2 = 2 * c;
                                    int s = 0;
                                    while (s < FloatFFT_3D.this.slices) {
                                        idx3 = s * FloatFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s;
                                        temp[idx4] = a[idx3];
                                        temp[idx4 + 1] = a[idx3 + 1];
                                        ++s;
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                    s = 0;
                                    while (s < FloatFFT_3D.this.slices) {
                                        idx3 = s * FloatFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s;
                                        a[idx3] = temp[idx4];
                                        a[idx3 + 1] = temp[idx4 + 1];
                                        ++s;
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx4;
                int idx3;
                int idx2;
                int c;
                int idx1;
                int s = 0;
                while (s < this.slices) {
                    int idx12 = s * this.sliceStride;
                    int r = 0;
                    while (r < this.rows) {
                        this.fftColumns.complexInverse(a, idx12 + r * this.rowStride, scale);
                        ++r;
                    }
                    ++s;
                }
                float[] temp = new float[2 * this.rows];
                int s2 = 0;
                while (s2 < this.slices) {
                    idx1 = s2 * this.sliceStride;
                    c = 0;
                    while (c < this.columns) {
                        idx2 = 2 * c;
                        int r = 0;
                        while (r < this.rows) {
                            idx3 = idx1 + idx2 + r * this.rowStride;
                            idx4 = 2 * r;
                            temp[idx4] = a[idx3];
                            temp[idx4 + 1] = a[idx3 + 1];
                            ++r;
                        }
                        this.fftRows.complexInverse(temp, scale);
                        r = 0;
                        while (r < this.rows) {
                            idx3 = idx1 + idx2 + r * this.rowStride;
                            idx4 = 2 * r;
                            a[idx3] = temp[idx4];
                            a[idx3 + 1] = temp[idx4 + 1];
                            ++r;
                        }
                        ++c;
                    }
                    ++s2;
                }
                temp = new float[2 * this.slices];
                int r = 0;
                while (r < this.rows) {
                    idx1 = r * this.rowStride;
                    c = 0;
                    while (c < this.columns) {
                        idx2 = 2 * c;
                        int s3 = 0;
                        while (s3 < this.slices) {
                            idx3 = s3 * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s3;
                            temp[idx4] = a[idx3];
                            temp[idx4 + 1] = a[idx3 + 1];
                            ++s3;
                        }
                        this.fftSlices.complexInverse(temp, scale);
                        s3 = 0;
                        while (s3 < this.slices) {
                            idx3 = s3 * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s3;
                            a[idx3] = temp[idx4];
                            a[idx3 + 1] = temp[idx4 + 1];
                            ++s3;
                        }
                        ++c;
                    }
                    ++r;
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexInverse(final float[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns *= 2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
            } else {
                this.xdft3da_sub2(0, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            int l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FloatFFT_3D.this.rows) {
                                FloatFFT_3D.this.fftColumns.complexInverse(a[s][r], scale);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.rows];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int c = 0;
                            while (c < FloatFFT_3D.this.columns) {
                                int idx4;
                                int idx2 = 2 * c;
                                int r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx4 = 2 * r;
                                    temp[idx4] = a[s][r][idx2];
                                    temp[idx4 + 1] = a[s][r][idx2 + 1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(temp, scale);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx4 = 2 * r;
                                    a[s][r][idx2] = temp[idx4];
                                    a[s][r][idx2 + 1] = temp[idx4 + 1];
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            l = 0;
            while (l < nthreads) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.slices];
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FloatFFT_3D.this.columns) {
                                int idx4;
                                int idx2 = 2 * c;
                                int s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx4 = 2 * s;
                                    temp[idx4] = a[s][r][idx2];
                                    temp[idx4 + 1] = a[s][r][idx2 + 1];
                                    ++s;
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx4 = 2 * s;
                                    a[s][r][idx2] = temp[idx4];
                                    a[s][r][idx2 + 1] = temp[idx4 + 1];
                                    ++s;
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx4;
            int idx2;
            int c;
            int r;
            int s = 0;
            while (s < this.slices) {
                r = 0;
                while (r < this.rows) {
                    this.fftColumns.complexInverse(a[s][r], scale);
                    ++r;
                }
                ++s;
            }
            float[] temp = new float[2 * this.rows];
            int s2 = 0;
            while (s2 < this.slices) {
                c = 0;
                while (c < this.columns) {
                    idx2 = 2 * c;
                    int r2 = 0;
                    while (r2 < this.rows) {
                        idx4 = 2 * r2;
                        temp[idx4] = a[s2][r2][idx2];
                        temp[idx4 + 1] = a[s2][r2][idx2 + 1];
                        ++r2;
                    }
                    this.fftRows.complexInverse(temp, scale);
                    r2 = 0;
                    while (r2 < this.rows) {
                        idx4 = 2 * r2;
                        a[s2][r2][idx2] = temp[idx4];
                        a[s2][r2][idx2 + 1] = temp[idx4 + 1];
                        ++r2;
                    }
                    ++c;
                }
                ++s2;
            }
            temp = new float[2 * this.slices];
            r = 0;
            while (r < this.rows) {
                c = 0;
                while (c < this.columns) {
                    idx2 = 2 * c;
                    int s3 = 0;
                    while (s3 < this.slices) {
                        idx4 = 2 * s3;
                        temp[idx4] = a[s3][r][idx2];
                        temp[idx4 + 1] = a[s3][r][idx2 + 1];
                        ++s3;
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    s3 = 0;
                    while (s3 < this.slices) {
                        idx4 = 2 * s3;
                        a[s3][r][idx2] = temp[idx4];
                        a[s3][r][idx2 + 1] = temp[idx4 + 1];
                        ++s3;
                    }
                    ++c;
                }
                ++r;
            }
        }
    }

    public void realForward(float[] a) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (nthreads > 1) {
                this.nt *= nthreads;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, a, true);
            this.cdft3db_subth(-1, a, true);
            this.rdft3d_sub(1, a);
        } else {
            this.xdft3da_sub1(1, -1, a, true);
            this.cdft3db_sub(-1, a, true);
            this.rdft3d_sub(1, a);
        }
    }

    public void realForward(float[][][] a) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (nthreads > 1) {
                this.nt *= nthreads;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, a, true);
            this.cdft3db_subth(-1, a, true);
            this.rdft3d_sub(1, a);
        } else {
            this.xdft3da_sub1(1, -1, a, true);
            this.cdft3db_sub(-1, a, true);
            this.rdft3d_sub(1, a);
        }
    }

    public void realForwardFull(float[] a) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, a, true);
                this.cdft3db_subth(-1, a, true);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1, -1, a, true);
                this.cdft3db_sub(-1, a, true);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealForwardFull(a);
        }
    }

    public void realForwardFull(float[][][] a) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, a, true);
                this.cdft3db_subth(-1, a, true);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1, -1, a, true);
                this.cdft3db_sub(-1, a, true);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealForwardFull(a);
        }
    }

    public void realInverse(float[] a, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (nthreads > 1) {
                this.nt *= nthreads;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.rdft3d_sub(-1, a);
            this.cdft3db_subth(1, a, scale);
            this.xdft3da_subth1(1, 1, a, scale);
        } else {
            this.rdft3d_sub(-1, a);
            this.cdft3db_sub(1, a, scale);
            this.xdft3da_sub1(1, 1, a, scale);
        }
    }

    public void realInverse(float[][][] a, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (nthreads > 1) {
                this.nt *= nthreads;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.rdft3d_sub(-1, a);
            this.cdft3db_subth(1, a, scale);
            this.xdft3da_subth1(1, 1, a, scale);
        } else {
            this.rdft3d_sub(-1, a);
            this.cdft3db_sub(1, a, scale);
            this.xdft3da_sub1(1, 1, a, scale);
        }
    }

    public void realInverseFull(float[] a, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealInverseFull(a, scale);
        }
    }

    public void realInverseFull(float[][][] a, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealInverseFull(a, scale);
        }
    }

    private void mixedRadixRealForwardFull(final float[][][] a) {
        float[] temp = new float[2 * this.rows];
        int ldimn2 = this.rows / 2 + 1;
        final int newn3 = 2 * this.columns;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            int l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FloatFFT_3D.this.rows) {
                                FloatFFT_3D.this.fftColumns.realForwardFull(a[s][r]);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.rows];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int c = 0;
                            while (c < FloatFFT_3D.this.columns) {
                                int idx4;
                                int idx2 = 2 * c;
                                int r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx4 = 2 * r;
                                    temp[idx4] = a[s][r][idx2];
                                    temp[idx4 + 1] = a[s][r][idx2 + 1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexForward(temp);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx4 = 2 * r;
                                    a[s][r][idx2] = temp[idx4];
                                    a[s][r][idx2 + 1] = temp[idx4 + 1];
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = ldimn2 / nthreads;
            l = 0;
            while (l < nthreads) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.slices];
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FloatFFT_3D.this.columns) {
                                int idx2;
                                int idx1 = 2 * c;
                                int s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = 2 * s;
                                    temp[idx2] = a[s][r][idx1];
                                    temp[idx2 + 1] = a[s][r][idx1 + 1];
                                    ++s;
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(temp);
                                s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = 2 * s;
                                    a[s][r][idx1] = temp[idx2];
                                    a[s][r][idx1 + 1] = temp[idx2 + 1];
                                    ++s;
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.slices / nthreads;
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx2 = (FloatFFT_3D.this.slices - s) % FloatFFT_3D.this.slices;
                            int r = 1;
                            while (r < n2d2) {
                                int idx4 = FloatFFT_3D.this.rows - r;
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx1 = 2 * c;
                                    int idx3 = newn3 - idx1;
                                    a[idx2][idx4][idx3 % newn3] = a[s][r][idx1];
                                    a[idx2][idx4][(idx3 + 1) % newn3] = -a[s][r][idx1 + 1];
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    this.fftColumns.realForwardFull(a[s][r]);
                    ++r;
                }
                ++s;
            }
            s = 0;
            while (s < this.slices) {
                c = 0;
                while (c < this.columns) {
                    int idx4;
                    int idx2 = 2 * c;
                    int r = 0;
                    while (r < this.rows) {
                        idx4 = 2 * r;
                        temp[idx4] = a[s][r][idx2];
                        temp[idx4 + 1] = a[s][r][idx2 + 1];
                        ++r;
                    }
                    this.fftRows.complexForward(temp);
                    r = 0;
                    while (r < this.rows) {
                        idx4 = 2 * r;
                        a[s][r][idx2] = temp[idx4];
                        a[s][r][idx2 + 1] = temp[idx4 + 1];
                        ++r;
                    }
                    ++c;
                }
                ++s;
            }
            temp = new float[2 * this.slices];
            int r = 0;
            while (r < ldimn2) {
                c = 0;
                while (c < this.columns) {
                    int idx2;
                    int idx1 = 2 * c;
                    int s2 = 0;
                    while (s2 < this.slices) {
                        idx2 = 2 * s2;
                        temp[idx2] = a[s2][r][idx1];
                        temp[idx2 + 1] = a[s2][r][idx1 + 1];
                        ++s2;
                    }
                    this.fftSlices.complexForward(temp);
                    s2 = 0;
                    while (s2 < this.slices) {
                        idx2 = 2 * s2;
                        a[s2][r][idx1] = temp[idx2];
                        a[s2][r][idx1 + 1] = temp[idx2 + 1];
                        ++s2;
                    }
                    ++c;
                }
                ++r;
            }
            s = 0;
            while (s < this.slices) {
                int idx2 = (this.slices - s) % this.slices;
                int r2 = 1;
                while (r2 < n2d2) {
                    int idx4 = this.rows - r2;
                    int c2 = 0;
                    while (c2 < this.columns) {
                        int idx1 = 2 * c2;
                        int idx3 = newn3 - idx1;
                        a[idx2][idx4][idx3 % newn3] = a[s][r2][idx1];
                        a[idx2][idx4][(idx3 + 1) % newn3] = -a[s][r2][idx1 + 1];
                        ++c2;
                    }
                    ++r2;
                }
                ++s;
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[][][] a, final boolean scale) {
        float[] temp = new float[2 * this.rows];
        int ldimn2 = this.rows / 2 + 1;
        final int newn3 = 2 * this.columns;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            int l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FloatFFT_3D.this.rows) {
                                FloatFFT_3D.this.fftColumns.realInverseFull(a[s][r], scale);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.rows];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int c = 0;
                            while (c < FloatFFT_3D.this.columns) {
                                int idx4;
                                int idx2 = 2 * c;
                                int r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx4 = 2 * r;
                                    temp[idx4] = a[s][r][idx2];
                                    temp[idx4 + 1] = a[s][r][idx2 + 1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(temp, scale);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx4 = 2 * r;
                                    a[s][r][idx2] = temp[idx4];
                                    a[s][r][idx2 + 1] = temp[idx4 + 1];
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = ldimn2 / nthreads;
            l = 0;
            while (l < nthreads) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.slices];
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < FloatFFT_3D.this.columns) {
                                int idx2;
                                int idx1 = 2 * c;
                                int s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = 2 * s;
                                    temp[idx2] = a[s][r][idx1];
                                    temp[idx2 + 1] = a[s][r][idx1 + 1];
                                    ++s;
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = 2 * s;
                                    a[s][r][idx1] = temp[idx2];
                                    a[s][r][idx1 + 1] = temp[idx2 + 1];
                                    ++s;
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.slices / nthreads;
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx2 = (FloatFFT_3D.this.slices - s) % FloatFFT_3D.this.slices;
                            int r = 1;
                            while (r < n2d2) {
                                int idx4 = FloatFFT_3D.this.rows - r;
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx1 = 2 * c;
                                    int idx3 = newn3 - idx1;
                                    a[idx2][idx4][idx3 % newn3] = a[s][r][idx1];
                                    a[idx2][idx4][(idx3 + 1) % newn3] = -a[s][r][idx1 + 1];
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    this.fftColumns.realInverseFull(a[s][r], scale);
                    ++r;
                }
                ++s;
            }
            s = 0;
            while (s < this.slices) {
                c = 0;
                while (c < this.columns) {
                    int idx4;
                    int idx2 = 2 * c;
                    int r = 0;
                    while (r < this.rows) {
                        idx4 = 2 * r;
                        temp[idx4] = a[s][r][idx2];
                        temp[idx4 + 1] = a[s][r][idx2 + 1];
                        ++r;
                    }
                    this.fftRows.complexInverse(temp, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx4 = 2 * r;
                        a[s][r][idx2] = temp[idx4];
                        a[s][r][idx2 + 1] = temp[idx4 + 1];
                        ++r;
                    }
                    ++c;
                }
                ++s;
            }
            temp = new float[2 * this.slices];
            int r = 0;
            while (r < ldimn2) {
                c = 0;
                while (c < this.columns) {
                    int idx2;
                    int idx1 = 2 * c;
                    int s2 = 0;
                    while (s2 < this.slices) {
                        idx2 = 2 * s2;
                        temp[idx2] = a[s2][r][idx1];
                        temp[idx2 + 1] = a[s2][r][idx1 + 1];
                        ++s2;
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    s2 = 0;
                    while (s2 < this.slices) {
                        idx2 = 2 * s2;
                        a[s2][r][idx1] = temp[idx2];
                        a[s2][r][idx1 + 1] = temp[idx2 + 1];
                        ++s2;
                    }
                    ++c;
                }
                ++r;
            }
            s = 0;
            while (s < this.slices) {
                int idx2 = (this.slices - s) % this.slices;
                int r2 = 1;
                while (r2 < n2d2) {
                    int idx4 = this.rows - r2;
                    int c2 = 0;
                    while (c2 < this.columns) {
                        int idx1 = 2 * c2;
                        int idx3 = newn3 - idx1;
                        a[idx2][idx4][idx3 % newn3] = a[s][r2][idx1];
                        a[idx2][idx4][(idx3 + 1) % newn3] = -a[s][r2][idx1 + 1];
                        ++c2;
                    }
                    ++r2;
                }
                ++s;
            }
        }
    }

    private void mixedRadixRealForwardFull(final float[] a) {
        final int twon3 = 2 * this.columns;
        float[] temp = new float[twon3];
        int ldimn2 = this.rows / 2 + 1;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int twoSliceStride = 2 * this.sliceStride;
        final int twoRowStride = 2 * this.rowStride;
        int n1d2 = this.slices / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = n1d2 / nthreads;
            int l = 0;
            while (l < nthreads) {
                final int firstSlice2 = this.slices - 1 - l * p;
                final int lastSlice2 = l == nthreads - 1 ? n1d2 + 1 : firstSlice2 - p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[twon3];
                        int s = firstSlice2;
                        while (s >= lastSlice2) {
                            int idx1 = s * FloatFFT_3D.this.sliceStride;
                            int idx2 = s * twoSliceStride;
                            int r = FloatFFT_3D.this.rows - 1;
                            while (r >= 0) {
                                System.arraycopy(a, idx1 + r * FloatFFT_3D.this.rowStride, temp, 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realForwardFull(temp);
                                System.arraycopy(temp, 0, a, idx2 + r * twoRowStride, twon3);
                                --r;
                            }
                            --s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            final float[][][] temp2 = new float[n1d2 + 1][this.rows][twon3];
            int l2 = 0;
            while (l2 < nthreads) {
                firstSlice = l2 * p;
                lastSlice = l2 == nthreads - 1 ? n1d2 + 1 : firstSlice + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = s * FloatFFT_3D.this.sliceStride;
                            int r = 0;
                            while (r < FloatFFT_3D.this.rows) {
                                System.arraycopy(a, idx1 + r * FloatFFT_3D.this.rowStride, temp2[s][r], 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realForwardFull(temp2[s][r]);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l2 = 0;
            while (l2 < nthreads) {
                firstSlice = l2 * p;
                lastSlice = l2 == nthreads - 1 ? n1d2 + 1 : firstSlice + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = s * twoSliceStride;
                            int r = 0;
                            while (r < FloatFFT_3D.this.rows) {
                                System.arraycopy(temp2[s][r], 0, a, idx1 + r * twoRowStride, twon3);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.slices / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                firstSlice = l2 * p;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.rows];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = s * twoSliceStride;
                            int c = 0;
                            while (c < FloatFFT_3D.this.columns) {
                                int idx4;
                                int idx3;
                                int idx2 = 2 * c;
                                int r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2 * r;
                                    temp[idx4] = a[idx3];
                                    temp[idx4 + 1] = a[idx3 + 1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexForward(temp);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2 * r;
                                    a[idx3] = temp[idx4];
                                    a[idx3 + 1] = temp[idx4 + 1];
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = ldimn2 / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                final int firstRow = l2 * p;
                final int lastRow = l2 == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.slices];
                        int r = firstRow;
                        while (r < lastRow) {
                            int idx3 = r * twoRowStride;
                            int c = 0;
                            while (c < FloatFFT_3D.this.columns) {
                                int idx4;
                                int idx2;
                                int idx1 = 2 * c;
                                int s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = 2 * s;
                                    idx4 = s * twoSliceStride + idx3 + idx1;
                                    temp[idx2] = a[idx4];
                                    temp[idx2 + 1] = a[idx4 + 1];
                                    ++s;
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(temp);
                                s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = 2 * s;
                                    idx4 = s * twoSliceStride + idx3 + idx1;
                                    a[idx4] = temp[idx2];
                                    a[idx4 + 1] = temp[idx2 + 1];
                                    ++s;
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.slices / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                firstSlice = l2 * p;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx2 = (FloatFFT_3D.this.slices - s) % FloatFFT_3D.this.slices;
                            int idx5 = idx2 * twoSliceStride;
                            int idx6 = s * twoSliceStride;
                            int r = 1;
                            while (r < n2d2) {
                                int idx4 = FloatFFT_3D.this.rows - r;
                                int idx7 = idx4 * twoRowStride;
                                int idx8 = r * twoRowStride;
                                int idx9 = idx5 + idx7;
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx1 = 2 * c;
                                    int idx3 = twon3 - idx1;
                                    int idx10 = idx6 + idx8 + idx1;
                                    a[idx9 + idx3 % twon3] = a[idx10];
                                    a[idx9 + (idx3 + 1) % twon3] = -a[idx10 + 1];
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx4;
            int r;
            int c;
            int idx1;
            int s = this.slices - 1;
            while (s >= 0) {
                idx1 = s * this.sliceStride;
                int idx2 = s * twoSliceStride;
                int r2 = this.rows - 1;
                while (r2 >= 0) {
                    System.arraycopy(a, idx1 + r2 * this.rowStride, temp, 0, this.columns);
                    this.fftColumns.realForwardFull(temp);
                    System.arraycopy(temp, 0, a, idx2 + r2 * twoRowStride, twon3);
                    --r2;
                }
                --s;
            }
            temp = new float[2 * this.rows];
            s = 0;
            while (s < this.slices) {
                idx1 = s * twoSliceStride;
                c = 0;
                while (c < this.columns) {
                    int idx3;
                    int idx2 = 2 * c;
                    r = 0;
                    while (r < this.rows) {
                        idx4 = 2 * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        temp[idx4] = a[idx3];
                        temp[idx4 + 1] = a[idx3 + 1];
                        ++r;
                    }
                    this.fftRows.complexForward(temp);
                    r = 0;
                    while (r < this.rows) {
                        idx4 = 2 * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        a[idx3] = temp[idx4];
                        a[idx3 + 1] = temp[idx4 + 1];
                        ++r;
                    }
                    ++c;
                }
                ++s;
            }
            temp = new float[2 * this.slices];
            int r3 = 0;
            while (r3 < ldimn2) {
                int idx3 = r3 * twoRowStride;
                c = 0;
                while (c < this.columns) {
                    int idx42;
                    int idx2;
                    int idx12 = 2 * c;
                    int s2 = 0;
                    while (s2 < this.slices) {
                        idx2 = 2 * s2;
                        idx42 = s2 * twoSliceStride + idx3 + idx12;
                        temp[idx2] = a[idx42];
                        temp[idx2 + 1] = a[idx42 + 1];
                        ++s2;
                    }
                    this.fftSlices.complexForward(temp);
                    s2 = 0;
                    while (s2 < this.slices) {
                        idx2 = 2 * s2;
                        idx42 = s2 * twoSliceStride + idx3 + idx12;
                        a[idx42] = temp[idx2];
                        a[idx42 + 1] = temp[idx2 + 1];
                        ++s2;
                    }
                    ++c;
                }
                ++r3;
            }
            s = 0;
            while (s < this.slices) {
                int idx2 = (this.slices - s) % this.slices;
                int idx5 = idx2 * twoSliceStride;
                int idx6 = s * twoSliceStride;
                r = 1;
                while (r < n2d2) {
                    idx4 = this.rows - r;
                    int idx7 = idx4 * twoRowStride;
                    int idx8 = r * twoRowStride;
                    int idx9 = idx5 + idx7;
                    int c2 = 0;
                    while (c2 < this.columns) {
                        int idx13 = 2 * c2;
                        int idx3 = twon3 - idx13;
                        int idx10 = idx6 + idx8 + idx13;
                        a[idx9 + idx3 % twon3] = a[idx10];
                        a[idx9 + (idx3 + 1) % twon3] = -a[idx10 + 1];
                        ++c2;
                    }
                    ++r;
                }
                ++s;
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[] a, final boolean scale) {
        final int twon3 = 2 * this.columns;
        float[] temp = new float[twon3];
        int ldimn2 = this.rows / 2 + 1;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int twoSliceStride = 2 * this.sliceStride;
        final int twoRowStride = 2 * this.rowStride;
        int n1d2 = this.slices / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = n1d2 / nthreads;
            int l = 0;
            while (l < nthreads) {
                final int firstSlice2 = this.slices - 1 - l * p;
                final int lastSlice2 = l == nthreads - 1 ? n1d2 + 1 : firstSlice2 - p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[twon3];
                        int s = firstSlice2;
                        while (s >= lastSlice2) {
                            int idx1 = s * FloatFFT_3D.this.sliceStride;
                            int idx2 = s * twoSliceStride;
                            int r = FloatFFT_3D.this.rows - 1;
                            while (r >= 0) {
                                System.arraycopy(a, idx1 + r * FloatFFT_3D.this.rowStride, temp, 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realInverseFull(temp, scale);
                                System.arraycopy(temp, 0, a, idx2 + r * twoRowStride, twon3);
                                --r;
                            }
                            --s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            final float[][][] temp2 = new float[n1d2 + 1][this.rows][twon3];
            int l2 = 0;
            while (l2 < nthreads) {
                firstSlice = l2 * p;
                lastSlice = l2 == nthreads - 1 ? n1d2 + 1 : firstSlice + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = s * FloatFFT_3D.this.sliceStride;
                            int r = 0;
                            while (r < FloatFFT_3D.this.rows) {
                                System.arraycopy(a, idx1 + r * FloatFFT_3D.this.rowStride, temp2[s][r], 0, FloatFFT_3D.this.columns);
                                FloatFFT_3D.this.fftColumns.realInverseFull(temp2[s][r], scale);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l2 = 0;
            while (l2 < nthreads) {
                firstSlice = l2 * p;
                lastSlice = l2 == nthreads - 1 ? n1d2 + 1 : firstSlice + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = s * twoSliceStride;
                            int r = 0;
                            while (r < FloatFFT_3D.this.rows) {
                                System.arraycopy(temp2[s][r], 0, a, idx1 + r * twoRowStride, twon3);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.slices / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                firstSlice = l2 * p;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.rows];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = s * twoSliceStride;
                            int c = 0;
                            while (c < FloatFFT_3D.this.columns) {
                                int idx4;
                                int idx3;
                                int idx2 = 2 * c;
                                int r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2 * r;
                                    temp[idx4] = a[idx3];
                                    temp[idx4 + 1] = a[idx3 + 1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(temp, scale);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2 * r;
                                    a[idx3] = temp[idx4];
                                    a[idx3 + 1] = temp[idx4 + 1];
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = ldimn2 / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                final int firstRow = l2 * p;
                final int lastRow = l2 == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        float[] temp = new float[2 * FloatFFT_3D.this.slices];
                        int r = firstRow;
                        while (r < lastRow) {
                            int idx3 = r * twoRowStride;
                            int c = 0;
                            while (c < FloatFFT_3D.this.columns) {
                                int idx4;
                                int idx2;
                                int idx1 = 2 * c;
                                int s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = 2 * s;
                                    idx4 = s * twoSliceStride + idx3 + idx1;
                                    temp[idx2] = a[idx4];
                                    temp[idx2 + 1] = a[idx4 + 1];
                                    ++s;
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = 2 * s;
                                    idx4 = s * twoSliceStride + idx3 + idx1;
                                    a[idx4] = temp[idx2];
                                    a[idx4 + 1] = temp[idx2 + 1];
                                    ++s;
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.slices / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                firstSlice = l2 * p;
                lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx2 = (FloatFFT_3D.this.slices - s) % FloatFFT_3D.this.slices;
                            int idx5 = idx2 * twoSliceStride;
                            int idx6 = s * twoSliceStride;
                            int r = 1;
                            while (r < n2d2) {
                                int idx4 = FloatFFT_3D.this.rows - r;
                                int idx7 = idx4 * twoRowStride;
                                int idx8 = r * twoRowStride;
                                int idx9 = idx5 + idx7;
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx1 = 2 * c;
                                    int idx3 = twon3 - idx1;
                                    int idx10 = idx6 + idx8 + idx1;
                                    a[idx9 + idx3 % twon3] = a[idx10];
                                    a[idx9 + (idx3 + 1) % twon3] = -a[idx10 + 1];
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx4;
            int r;
            int c;
            int idx1;
            int s = this.slices - 1;
            while (s >= 0) {
                idx1 = s * this.sliceStride;
                int idx2 = s * twoSliceStride;
                int r2 = this.rows - 1;
                while (r2 >= 0) {
                    System.arraycopy(a, idx1 + r2 * this.rowStride, temp, 0, this.columns);
                    this.fftColumns.realInverseFull(temp, scale);
                    System.arraycopy(temp, 0, a, idx2 + r2 * twoRowStride, twon3);
                    --r2;
                }
                --s;
            }
            temp = new float[2 * this.rows];
            s = 0;
            while (s < this.slices) {
                idx1 = s * twoSliceStride;
                c = 0;
                while (c < this.columns) {
                    int idx3;
                    int idx2 = 2 * c;
                    r = 0;
                    while (r < this.rows) {
                        idx4 = 2 * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        temp[idx4] = a[idx3];
                        temp[idx4 + 1] = a[idx3 + 1];
                        ++r;
                    }
                    this.fftRows.complexInverse(temp, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx4 = 2 * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        a[idx3] = temp[idx4];
                        a[idx3 + 1] = temp[idx4 + 1];
                        ++r;
                    }
                    ++c;
                }
                ++s;
            }
            temp = new float[2 * this.slices];
            int r3 = 0;
            while (r3 < ldimn2) {
                int idx3 = r3 * twoRowStride;
                c = 0;
                while (c < this.columns) {
                    int idx42;
                    int idx2;
                    int idx12 = 2 * c;
                    int s2 = 0;
                    while (s2 < this.slices) {
                        idx2 = 2 * s2;
                        idx42 = s2 * twoSliceStride + idx3 + idx12;
                        temp[idx2] = a[idx42];
                        temp[idx2 + 1] = a[idx42 + 1];
                        ++s2;
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    s2 = 0;
                    while (s2 < this.slices) {
                        idx2 = 2 * s2;
                        idx42 = s2 * twoSliceStride + idx3 + idx12;
                        a[idx42] = temp[idx2];
                        a[idx42 + 1] = temp[idx2 + 1];
                        ++s2;
                    }
                    ++c;
                }
                ++r3;
            }
            s = 0;
            while (s < this.slices) {
                int idx2 = (this.slices - s) % this.slices;
                int idx5 = idx2 * twoSliceStride;
                int idx6 = s * twoSliceStride;
                r = 1;
                while (r < n2d2) {
                    idx4 = this.rows - r;
                    int idx7 = idx4 * twoRowStride;
                    int idx8 = r * twoRowStride;
                    int idx9 = idx5 + idx7;
                    int c2 = 0;
                    while (c2 < this.columns) {
                        int idx13 = 2 * c2;
                        int idx3 = twon3 - idx13;
                        int idx10 = idx6 + idx8 + idx13;
                        a[idx9 + idx3 % twon3] = a[idx10];
                        a[idx9 + (idx3 + 1) % twon3] = -a[idx10 + 1];
                        ++c2;
                    }
                    ++r;
                }
                ++s;
            }
        }
    }

    private void xdft3da_sub1(int icr, int isgn, float[] a, boolean scale) {
        if (isgn == -1) {
            int s = 0;
            while (s < this.slices) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                if (icr == 0) {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.complexForward(a, idx0 + r * this.rowStride);
                        ++r;
                    }
                } else {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.realForward(a, idx0 + r * this.rowStride);
                        ++r;
                    }
                }
                if (this.columns > 4) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx5;
                        int idx4;
                        int r2 = 0;
                        while (r2 < this.rows) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[idx1];
                            this.t[idx2 + 1] = a[idx1 + 1];
                            this.t[idx3] = a[idx1 + 2];
                            this.t[idx3 + 1] = a[idx1 + 3];
                            this.t[idx4] = a[idx1 + 4];
                            this.t[idx4 + 1] = a[idx1 + 5];
                            this.t[idx5] = a[idx1 + 6];
                            this.t[idx5 + 1] = a[idx1 + 7];
                            ++r2;
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        r2 = 0;
                        while (r2 < this.rows) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[idx1] = this.t[idx2];
                            a[idx1 + 1] = this.t[idx2 + 1];
                            a[idx1 + 2] = this.t[idx3];
                            a[idx1 + 3] = this.t[idx3 + 1];
                            a[idx1 + 4] = this.t[idx4];
                            a[idx1 + 5] = this.t[idx4 + 1];
                            a[idx1 + 6] = this.t[idx5];
                            a[idx1 + 7] = this.t[idx5 + 1];
                            ++r2;
                        }
                        c += 8;
                    }
                } else if (this.columns == 4) {
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                        ++r;
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                        ++r;
                    }
                } else if (this.columns == 2) {
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        ++r;
                    }
                    this.fftRows.complexForward(this.t, 0);
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        ++r;
                    }
                }
                ++s;
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                if (icr == 0) {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.complexInverse(a, idx0 + r * this.rowStride, scale);
                        ++r;
                    }
                }
                if (this.columns > 4) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx5;
                        int idx4;
                        int r3 = 0;
                        while (r3 < this.rows) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[idx1];
                            this.t[idx2 + 1] = a[idx1 + 1];
                            this.t[idx3] = a[idx1 + 2];
                            this.t[idx3 + 1] = a[idx1 + 3];
                            this.t[idx4] = a[idx1 + 4];
                            this.t[idx4 + 1] = a[idx1 + 5];
                            this.t[idx5] = a[idx1 + 6];
                            this.t[idx5 + 1] = a[idx1 + 7];
                            ++r3;
                        }
                        this.fftRows.complexInverse(this.t, 0, scale);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                        r3 = 0;
                        while (r3 < this.rows) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[idx1] = this.t[idx2];
                            a[idx1 + 1] = this.t[idx2 + 1];
                            a[idx1 + 2] = this.t[idx3];
                            a[idx1 + 3] = this.t[idx3 + 1];
                            a[idx1 + 4] = this.t[idx4];
                            a[idx1 + 5] = this.t[idx4 + 1];
                            a[idx1 + 6] = this.t[idx5];
                            a[idx1 + 7] = this.t[idx5 + 1];
                            ++r3;
                        }
                        c += 8;
                    }
                } else if (this.columns == 4) {
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                        ++r;
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                        ++r;
                    }
                } else if (this.columns == 2) {
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        ++r;
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        ++r;
                    }
                }
                if (icr != 0) {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.realInverse(a, idx0 + r * this.rowStride, scale);
                        ++r;
                    }
                }
                ++s;
            }
        }
    }

    private void xdft3da_sub2(int icr, int isgn, float[] a, boolean scale) {
        if (isgn == -1) {
            int s = 0;
            while (s < this.slices) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                if (icr == 0) {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.complexForward(a, idx0 + r * this.rowStride);
                        ++r;
                    }
                } else {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.realForward(a, idx0 + r * this.rowStride);
                        ++r;
                    }
                }
                if (this.columns > 4) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx5;
                        int idx4;
                        int r2 = 0;
                        while (r2 < this.rows) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[idx1];
                            this.t[idx2 + 1] = a[idx1 + 1];
                            this.t[idx3] = a[idx1 + 2];
                            this.t[idx3 + 1] = a[idx1 + 3];
                            this.t[idx4] = a[idx1 + 4];
                            this.t[idx4 + 1] = a[idx1 + 5];
                            this.t[idx5] = a[idx1 + 6];
                            this.t[idx5 + 1] = a[idx1 + 7];
                            ++r2;
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        r2 = 0;
                        while (r2 < this.rows) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[idx1] = this.t[idx2];
                            a[idx1 + 1] = this.t[idx2 + 1];
                            a[idx1 + 2] = this.t[idx3];
                            a[idx1 + 3] = this.t[idx3 + 1];
                            a[idx1 + 4] = this.t[idx4];
                            a[idx1 + 5] = this.t[idx4 + 1];
                            a[idx1 + 6] = this.t[idx5];
                            a[idx1 + 7] = this.t[idx5 + 1];
                            ++r2;
                        }
                        c += 8;
                    }
                } else if (this.columns == 4) {
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                        ++r;
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                        ++r;
                    }
                } else if (this.columns == 2) {
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        ++r;
                    }
                    this.fftRows.complexForward(this.t, 0);
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        ++r;
                    }
                }
                ++s;
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                if (icr == 0) {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.complexInverse(a, idx0 + r * this.rowStride, scale);
                        ++r;
                    }
                } else {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.realInverse2(a, idx0 + r * this.rowStride, scale);
                        ++r;
                    }
                }
                if (this.columns > 4) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx5;
                        int idx4;
                        int r3 = 0;
                        while (r3 < this.rows) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[idx1];
                            this.t[idx2 + 1] = a[idx1 + 1];
                            this.t[idx3] = a[idx1 + 2];
                            this.t[idx3 + 1] = a[idx1 + 3];
                            this.t[idx4] = a[idx1 + 4];
                            this.t[idx4 + 1] = a[idx1 + 5];
                            this.t[idx5] = a[idx1 + 6];
                            this.t[idx5 + 1] = a[idx1 + 7];
                            ++r3;
                        }
                        this.fftRows.complexInverse(this.t, 0, scale);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                        r3 = 0;
                        while (r3 < this.rows) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[idx1] = this.t[idx2];
                            a[idx1 + 1] = this.t[idx2 + 1];
                            a[idx1 + 2] = this.t[idx3];
                            a[idx1 + 3] = this.t[idx3 + 1];
                            a[idx1 + 4] = this.t[idx4];
                            a[idx1 + 5] = this.t[idx4 + 1];
                            a[idx1 + 6] = this.t[idx5];
                            a[idx1 + 7] = this.t[idx5 + 1];
                            ++r3;
                        }
                        c += 8;
                    }
                } else if (this.columns == 4) {
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                        ++r;
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                        ++r;
                    }
                } else if (this.columns == 2) {
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        ++r;
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        ++r;
                    }
                }
                ++s;
            }
        }
    }

    private void xdft3da_sub1(int icr, int isgn, float[][][] a, boolean scale) {
        if (isgn == -1) {
            int s = 0;
            while (s < this.slices) {
                int idx3;
                int idx2;
                int r;
                if (icr == 0) {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.complexForward(a[s][r]);
                        ++r;
                    }
                } else {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.realForward(a[s][r], 0);
                        ++r;
                    }
                }
                if (this.columns > 4) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx5;
                        int idx4;
                        int r2 = 0;
                        while (r2 < this.rows) {
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[s][r2][c];
                            this.t[idx2 + 1] = a[s][r2][c + 1];
                            this.t[idx3] = a[s][r2][c + 2];
                            this.t[idx3 + 1] = a[s][r2][c + 3];
                            this.t[idx4] = a[s][r2][c + 4];
                            this.t[idx4 + 1] = a[s][r2][c + 5];
                            this.t[idx5] = a[s][r2][c + 6];
                            this.t[idx5 + 1] = a[s][r2][c + 7];
                            ++r2;
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        r2 = 0;
                        while (r2 < this.rows) {
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[s][r2][c] = this.t[idx2];
                            a[s][r2][c + 1] = this.t[idx2 + 1];
                            a[s][r2][c + 2] = this.t[idx3];
                            a[s][r2][c + 3] = this.t[idx3 + 1];
                            a[s][r2][c + 4] = this.t[idx4];
                            a[s][r2][c + 5] = this.t[idx4 + 1];
                            a[s][r2][c + 6] = this.t[idx5];
                            a[s][r2][c + 7] = this.t[idx5 + 1];
                            ++r2;
                        }
                        c += 8;
                    }
                } else if (this.columns == 4) {
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        this.t[idx3] = a[s][r][2];
                        this.t[idx3 + 1] = a[s][r][3];
                        ++r;
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        a[s][r][2] = this.t[idx3];
                        a[s][r][3] = this.t[idx3 + 1];
                        ++r;
                    }
                } else if (this.columns == 2) {
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        ++r;
                    }
                    this.fftRows.complexForward(this.t, 0);
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        ++r;
                    }
                }
                ++s;
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int idx3;
                int idx2;
                int r;
                if (icr == 0) {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.complexInverse(a[s][r], scale);
                        ++r;
                    }
                }
                if (this.columns > 4) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx5;
                        int idx4;
                        int r3 = 0;
                        while (r3 < this.rows) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[s][r3][c];
                            this.t[idx2 + 1] = a[s][r3][c + 1];
                            this.t[idx3] = a[s][r3][c + 2];
                            this.t[idx3 + 1] = a[s][r3][c + 3];
                            this.t[idx4] = a[s][r3][c + 4];
                            this.t[idx4 + 1] = a[s][r3][c + 5];
                            this.t[idx5] = a[s][r3][c + 6];
                            this.t[idx5 + 1] = a[s][r3][c + 7];
                            ++r3;
                        }
                        this.fftRows.complexInverse(this.t, 0, scale);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                        r3 = 0;
                        while (r3 < this.rows) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[s][r3][c] = this.t[idx2];
                            a[s][r3][c + 1] = this.t[idx2 + 1];
                            a[s][r3][c + 2] = this.t[idx3];
                            a[s][r3][c + 3] = this.t[idx3 + 1];
                            a[s][r3][c + 4] = this.t[idx4];
                            a[s][r3][c + 5] = this.t[idx4 + 1];
                            a[s][r3][c + 6] = this.t[idx5];
                            a[s][r3][c + 7] = this.t[idx5 + 1];
                            ++r3;
                        }
                        c += 8;
                    }
                } else if (this.columns == 4) {
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        this.t[idx3] = a[s][r][2];
                        this.t[idx3 + 1] = a[s][r][3];
                        ++r;
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        a[s][r][2] = this.t[idx3];
                        a[s][r][3] = this.t[idx3 + 1];
                        ++r;
                    }
                } else if (this.columns == 2) {
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        ++r;
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        ++r;
                    }
                }
                if (icr != 0) {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.realInverse(a[s][r], 0, scale);
                        ++r;
                    }
                }
                ++s;
            }
        }
    }

    private void xdft3da_sub2(int icr, int isgn, float[][][] a, boolean scale) {
        if (isgn == -1) {
            int s = 0;
            while (s < this.slices) {
                int idx3;
                int idx2;
                int r;
                if (icr == 0) {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.complexForward(a[s][r]);
                        ++r;
                    }
                } else {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.realForward(a[s][r]);
                        ++r;
                    }
                }
                if (this.columns > 4) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx5;
                        int idx4;
                        int r2 = 0;
                        while (r2 < this.rows) {
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[s][r2][c];
                            this.t[idx2 + 1] = a[s][r2][c + 1];
                            this.t[idx3] = a[s][r2][c + 2];
                            this.t[idx3 + 1] = a[s][r2][c + 3];
                            this.t[idx4] = a[s][r2][c + 4];
                            this.t[idx4 + 1] = a[s][r2][c + 5];
                            this.t[idx5] = a[s][r2][c + 6];
                            this.t[idx5 + 1] = a[s][r2][c + 7];
                            ++r2;
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        r2 = 0;
                        while (r2 < this.rows) {
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[s][r2][c] = this.t[idx2];
                            a[s][r2][c + 1] = this.t[idx2 + 1];
                            a[s][r2][c + 2] = this.t[idx3];
                            a[s][r2][c + 3] = this.t[idx3 + 1];
                            a[s][r2][c + 4] = this.t[idx4];
                            a[s][r2][c + 5] = this.t[idx4 + 1];
                            a[s][r2][c + 6] = this.t[idx5];
                            a[s][r2][c + 7] = this.t[idx5 + 1];
                            ++r2;
                        }
                        c += 8;
                    }
                } else if (this.columns == 4) {
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        this.t[idx3] = a[s][r][2];
                        this.t[idx3 + 1] = a[s][r][3];
                        ++r;
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        a[s][r][2] = this.t[idx3];
                        a[s][r][3] = this.t[idx3 + 1];
                        ++r;
                    }
                } else if (this.columns == 2) {
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        ++r;
                    }
                    this.fftRows.complexForward(this.t, 0);
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        ++r;
                    }
                }
                ++s;
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int idx3;
                int idx2;
                int r;
                if (icr == 0) {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.complexInverse(a[s][r], scale);
                        ++r;
                    }
                } else {
                    r = 0;
                    while (r < this.rows) {
                        this.fftColumns.realInverse2(a[s][r], 0, scale);
                        ++r;
                    }
                }
                if (this.columns > 4) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx5;
                        int idx4;
                        int r3 = 0;
                        while (r3 < this.rows) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[s][r3][c];
                            this.t[idx2 + 1] = a[s][r3][c + 1];
                            this.t[idx3] = a[s][r3][c + 2];
                            this.t[idx3 + 1] = a[s][r3][c + 3];
                            this.t[idx4] = a[s][r3][c + 4];
                            this.t[idx4 + 1] = a[s][r3][c + 5];
                            this.t[idx5] = a[s][r3][c + 6];
                            this.t[idx5 + 1] = a[s][r3][c + 7];
                            ++r3;
                        }
                        this.fftRows.complexInverse(this.t, 0, scale);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                        r3 = 0;
                        while (r3 < this.rows) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[s][r3][c] = this.t[idx2];
                            a[s][r3][c + 1] = this.t[idx2 + 1];
                            a[s][r3][c + 2] = this.t[idx3];
                            a[s][r3][c + 3] = this.t[idx3 + 1];
                            a[s][r3][c + 4] = this.t[idx4];
                            a[s][r3][c + 5] = this.t[idx4 + 1];
                            a[s][r3][c + 6] = this.t[idx5];
                            a[s][r3][c + 7] = this.t[idx5 + 1];
                            ++r3;
                        }
                        c += 8;
                    }
                } else if (this.columns == 4) {
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        this.t[idx3] = a[s][r][2];
                        this.t[idx3 + 1] = a[s][r][3];
                        ++r;
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        a[s][r][2] = this.t[idx3];
                        a[s][r][3] = this.t[idx3 + 1];
                        ++r;
                    }
                } else if (this.columns == 2) {
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        ++r;
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx2 = 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        ++r;
                    }
                }
                ++s;
            }
        }
    }

    private void cdft3db_sub(int isgn, float[] a, boolean scale) {
        block27: {
            block25: {
                block28: {
                    block26: {
                        if (isgn != -1) break block25;
                        if (this.columns <= 4) break block26;
                        int r = 0;
                        while (r < this.rows) {
                            int idx0 = r * this.rowStride;
                            int c = 0;
                            while (c < this.columns) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int idx1;
                                int s = 0;
                                while (s < this.slices) {
                                    idx1 = s * this.sliceStride + idx0 + c;
                                    idx2 = 2 * s;
                                    idx3 = 2 * this.slices + 2 * s;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    this.t[idx2] = a[idx1];
                                    this.t[idx2 + 1] = a[idx1 + 1];
                                    this.t[idx3] = a[idx1 + 2];
                                    this.t[idx3 + 1] = a[idx1 + 3];
                                    this.t[idx4] = a[idx1 + 4];
                                    this.t[idx4 + 1] = a[idx1 + 5];
                                    this.t[idx5] = a[idx1 + 6];
                                    this.t[idx5 + 1] = a[idx1 + 7];
                                    ++s;
                                }
                                this.fftSlices.complexForward(this.t, 0);
                                this.fftSlices.complexForward(this.t, 2 * this.slices);
                                this.fftSlices.complexForward(this.t, 4 * this.slices);
                                this.fftSlices.complexForward(this.t, 6 * this.slices);
                                s = 0;
                                while (s < this.slices) {
                                    idx1 = s * this.sliceStride + idx0 + c;
                                    idx2 = 2 * s;
                                    idx3 = 2 * this.slices + 2 * s;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    a[idx1] = this.t[idx2];
                                    a[idx1 + 1] = this.t[idx2 + 1];
                                    a[idx1 + 2] = this.t[idx3];
                                    a[idx1 + 3] = this.t[idx3 + 1];
                                    a[idx1 + 4] = this.t[idx4];
                                    a[idx1 + 5] = this.t[idx4 + 1];
                                    a[idx1 + 6] = this.t[idx5];
                                    a[idx1 + 7] = this.t[idx5 + 1];
                                    ++s;
                                }
                                c += 8;
                            }
                            ++r;
                        }
                        break block27;
                    }
                    if (this.columns != 4) break block28;
                    int r = 0;
                    while (r < this.rows) {
                        int idx3;
                        int idx2;
                        int idx1;
                        int idx0 = r * this.rowStride;
                        int s = 0;
                        while (s < this.slices) {
                            idx1 = s * this.sliceStride + idx0;
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            this.t[idx2] = a[idx1];
                            this.t[idx2 + 1] = a[idx1 + 1];
                            this.t[idx3] = a[idx1 + 2];
                            this.t[idx3 + 1] = a[idx1 + 3];
                            ++s;
                        }
                        this.fftSlices.complexForward(this.t, 0);
                        this.fftSlices.complexForward(this.t, 2 * this.slices);
                        s = 0;
                        while (s < this.slices) {
                            idx1 = s * this.sliceStride + idx0;
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            a[idx1] = this.t[idx2];
                            a[idx1 + 1] = this.t[idx2 + 1];
                            a[idx1 + 2] = this.t[idx3];
                            a[idx1 + 3] = this.t[idx3 + 1];
                            ++s;
                        }
                        ++r;
                    }
                    break block27;
                }
                if (this.columns != 2) break block27;
                int r = 0;
                while (r < this.rows) {
                    int idx2;
                    int idx1;
                    int idx0 = r * this.rowStride;
                    int s = 0;
                    while (s < this.slices) {
                        idx1 = s * this.sliceStride + idx0;
                        idx2 = 2 * s;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        ++s;
                    }
                    this.fftSlices.complexForward(this.t, 0);
                    s = 0;
                    while (s < this.slices) {
                        idx1 = s * this.sliceStride + idx0;
                        idx2 = 2 * s;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        ++s;
                    }
                    ++r;
                }
                break block27;
            }
            if (this.columns > 4) {
                int r = 0;
                while (r < this.rows) {
                    int idx0 = r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        int idx5;
                        int idx4;
                        int idx3;
                        int idx2;
                        int idx1;
                        int s = 0;
                        while (s < this.slices) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            this.t[idx2] = a[idx1];
                            this.t[idx2 + 1] = a[idx1 + 1];
                            this.t[idx3] = a[idx1 + 2];
                            this.t[idx3 + 1] = a[idx1 + 3];
                            this.t[idx4] = a[idx1 + 4];
                            this.t[idx4 + 1] = a[idx1 + 5];
                            this.t[idx5] = a[idx1 + 6];
                            this.t[idx5 + 1] = a[idx1 + 7];
                            ++s;
                        }
                        this.fftSlices.complexInverse(this.t, 0, scale);
                        this.fftSlices.complexInverse(this.t, 2 * this.slices, scale);
                        this.fftSlices.complexInverse(this.t, 4 * this.slices, scale);
                        this.fftSlices.complexInverse(this.t, 6 * this.slices, scale);
                        s = 0;
                        while (s < this.slices) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            a[idx1] = this.t[idx2];
                            a[idx1 + 1] = this.t[idx2 + 1];
                            a[idx1 + 2] = this.t[idx3];
                            a[idx1 + 3] = this.t[idx3 + 1];
                            a[idx1 + 4] = this.t[idx4];
                            a[idx1 + 5] = this.t[idx4 + 1];
                            a[idx1 + 6] = this.t[idx5];
                            a[idx1 + 7] = this.t[idx5 + 1];
                            ++s;
                        }
                        c += 8;
                    }
                    ++r;
                }
            } else if (this.columns == 4) {
                int r = 0;
                while (r < this.rows) {
                    int idx3;
                    int idx2;
                    int idx1;
                    int idx0 = r * this.rowStride;
                    int s = 0;
                    while (s < this.slices) {
                        idx1 = s * this.sliceStride + idx0;
                        idx2 = 2 * s;
                        idx3 = 2 * this.slices + 2 * s;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                        ++s;
                    }
                    this.fftSlices.complexInverse(this.t, 0, scale);
                    this.fftSlices.complexInverse(this.t, 2 * this.slices, scale);
                    s = 0;
                    while (s < this.slices) {
                        idx1 = s * this.sliceStride + idx0;
                        idx2 = 2 * s;
                        idx3 = 2 * this.slices + 2 * s;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                        ++s;
                    }
                    ++r;
                }
            } else if (this.columns == 2) {
                int r = 0;
                while (r < this.rows) {
                    int idx2;
                    int idx1;
                    int idx0 = r * this.rowStride;
                    int s = 0;
                    while (s < this.slices) {
                        idx1 = s * this.sliceStride + idx0;
                        idx2 = 2 * s;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        ++s;
                    }
                    this.fftSlices.complexInverse(this.t, 0, scale);
                    s = 0;
                    while (s < this.slices) {
                        idx1 = s * this.sliceStride + idx0;
                        idx2 = 2 * s;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        ++s;
                    }
                    ++r;
                }
            }
        }
    }

    private void cdft3db_sub(int isgn, float[][][] a, boolean scale) {
        block27: {
            block25: {
                block28: {
                    block26: {
                        if (isgn != -1) break block25;
                        if (this.columns <= 4) break block26;
                        int r = 0;
                        while (r < this.rows) {
                            int c = 0;
                            while (c < this.columns) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int s = 0;
                                while (s < this.slices) {
                                    idx2 = 2 * s;
                                    idx3 = 2 * this.slices + 2 * s;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    this.t[idx2] = a[s][r][c];
                                    this.t[idx2 + 1] = a[s][r][c + 1];
                                    this.t[idx3] = a[s][r][c + 2];
                                    this.t[idx3 + 1] = a[s][r][c + 3];
                                    this.t[idx4] = a[s][r][c + 4];
                                    this.t[idx4 + 1] = a[s][r][c + 5];
                                    this.t[idx5] = a[s][r][c + 6];
                                    this.t[idx5 + 1] = a[s][r][c + 7];
                                    ++s;
                                }
                                this.fftSlices.complexForward(this.t, 0);
                                this.fftSlices.complexForward(this.t, 2 * this.slices);
                                this.fftSlices.complexForward(this.t, 4 * this.slices);
                                this.fftSlices.complexForward(this.t, 6 * this.slices);
                                s = 0;
                                while (s < this.slices) {
                                    idx2 = 2 * s;
                                    idx3 = 2 * this.slices + 2 * s;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    a[s][r][c] = this.t[idx2];
                                    a[s][r][c + 1] = this.t[idx2 + 1];
                                    a[s][r][c + 2] = this.t[idx3];
                                    a[s][r][c + 3] = this.t[idx3 + 1];
                                    a[s][r][c + 4] = this.t[idx4];
                                    a[s][r][c + 5] = this.t[idx4 + 1];
                                    a[s][r][c + 6] = this.t[idx5];
                                    a[s][r][c + 7] = this.t[idx5 + 1];
                                    ++s;
                                }
                                c += 8;
                            }
                            ++r;
                        }
                        break block27;
                    }
                    if (this.columns != 4) break block28;
                    int r = 0;
                    while (r < this.rows) {
                        int idx3;
                        int idx2;
                        int s = 0;
                        while (s < this.slices) {
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            this.t[idx2] = a[s][r][0];
                            this.t[idx2 + 1] = a[s][r][1];
                            this.t[idx3] = a[s][r][2];
                            this.t[idx3 + 1] = a[s][r][3];
                            ++s;
                        }
                        this.fftSlices.complexForward(this.t, 0);
                        this.fftSlices.complexForward(this.t, 2 * this.slices);
                        s = 0;
                        while (s < this.slices) {
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            a[s][r][0] = this.t[idx2];
                            a[s][r][1] = this.t[idx2 + 1];
                            a[s][r][2] = this.t[idx3];
                            a[s][r][3] = this.t[idx3 + 1];
                            ++s;
                        }
                        ++r;
                    }
                    break block27;
                }
                if (this.columns != 2) break block27;
                int r = 0;
                while (r < this.rows) {
                    int idx2;
                    int s = 0;
                    while (s < this.slices) {
                        idx2 = 2 * s;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        ++s;
                    }
                    this.fftSlices.complexForward(this.t, 0);
                    s = 0;
                    while (s < this.slices) {
                        idx2 = 2 * s;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        ++s;
                    }
                    ++r;
                }
                break block27;
            }
            if (this.columns > 4) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx5;
                        int idx4;
                        int idx3;
                        int idx2;
                        int s = 0;
                        while (s < this.slices) {
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            this.t[idx2] = a[s][r][c];
                            this.t[idx2 + 1] = a[s][r][c + 1];
                            this.t[idx3] = a[s][r][c + 2];
                            this.t[idx3 + 1] = a[s][r][c + 3];
                            this.t[idx4] = a[s][r][c + 4];
                            this.t[idx4 + 1] = a[s][r][c + 5];
                            this.t[idx5] = a[s][r][c + 6];
                            this.t[idx5 + 1] = a[s][r][c + 7];
                            ++s;
                        }
                        this.fftSlices.complexInverse(this.t, 0, scale);
                        this.fftSlices.complexInverse(this.t, 2 * this.slices, scale);
                        this.fftSlices.complexInverse(this.t, 4 * this.slices, scale);
                        this.fftSlices.complexInverse(this.t, 6 * this.slices, scale);
                        s = 0;
                        while (s < this.slices) {
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            a[s][r][c] = this.t[idx2];
                            a[s][r][c + 1] = this.t[idx2 + 1];
                            a[s][r][c + 2] = this.t[idx3];
                            a[s][r][c + 3] = this.t[idx3 + 1];
                            a[s][r][c + 4] = this.t[idx4];
                            a[s][r][c + 5] = this.t[idx4 + 1];
                            a[s][r][c + 6] = this.t[idx5];
                            a[s][r][c + 7] = this.t[idx5 + 1];
                            ++s;
                        }
                        c += 8;
                    }
                    ++r;
                }
            } else if (this.columns == 4) {
                int r = 0;
                while (r < this.rows) {
                    int idx3;
                    int idx2;
                    int s = 0;
                    while (s < this.slices) {
                        idx2 = 2 * s;
                        idx3 = 2 * this.slices + 2 * s;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        this.t[idx3] = a[s][r][2];
                        this.t[idx3 + 1] = a[s][r][3];
                        ++s;
                    }
                    this.fftSlices.complexInverse(this.t, 0, scale);
                    this.fftSlices.complexInverse(this.t, 2 * this.slices, scale);
                    s = 0;
                    while (s < this.slices) {
                        idx2 = 2 * s;
                        idx3 = 2 * this.slices + 2 * s;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        a[s][r][2] = this.t[idx3];
                        a[s][r][3] = this.t[idx3 + 1];
                        ++s;
                    }
                    ++r;
                }
            } else if (this.columns == 2) {
                int r = 0;
                while (r < this.rows) {
                    int idx2;
                    int s = 0;
                    while (s < this.slices) {
                        idx2 = 2 * s;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        ++s;
                    }
                    this.fftSlices.complexInverse(this.t, 0, scale);
                    s = 0;
                    while (s < this.slices) {
                        idx2 = 2 * s;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        ++s;
                    }
                    ++r;
                }
            }
        }
    }

    private void xdft3da_subth1(final int icr, final int isgn, final float[] a, final boolean scale) {
        final int nthreads = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int nt = 8 * this.rows;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (isgn == -1) {
                        int s = n0;
                        while (s < FloatFFT_3D.this.slices) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            int idx0 = s * FloatFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.complexForward(a, idx0 + r * FloatFFT_3D.this.rowStride);
                                    ++r;
                                }
                            } else {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.realForward(a, idx0 + r * FloatFFT_3D.this.rowStride);
                                    ++r;
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx5;
                                    int idx4;
                                    int r2 = 0;
                                    while (r2 < FloatFFT_3D.this.rows) {
                                        idx1 = idx0 + r2 * FloatFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[idx1 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[idx1 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4] = a[idx1 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4 + 1] = a[idx1 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5] = a[idx1 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5 + 1] = a[idx1 + 7];
                                        ++r2;
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 6 * FloatFFT_3D.this.rows);
                                    r2 = 0;
                                    while (r2 < FloatFFT_3D.this.rows) {
                                        idx1 = idx0 + r2 * FloatFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a[idx1] = FloatFFT_3D.this.t[idx2];
                                        a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                        a[idx1 + 2] = FloatFFT_3D.this.t[idx3];
                                        a[idx1 + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                        a[idx1 + 4] = FloatFFT_3D.this.t[idx4];
                                        a[idx1 + 5] = FloatFFT_3D.this.t[idx4 + 1];
                                        a[idx1 + 6] = FloatFFT_3D.this.t[idx5];
                                        a[idx1 + 7] = FloatFFT_3D.this.t[idx5 + 1];
                                        ++r2;
                                    }
                                    c += 8;
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[idx1 + 2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[idx1 + 3];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt);
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    a[idx1] = FloatFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                    a[idx1 + 2] = FloatFFT_3D.this.t[idx3];
                                    a[idx1 + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                    ++r;
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    a[idx1] = FloatFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                    ++r;
                                }
                            }
                            s += nthreads;
                        }
                    } else {
                        int s = n0;
                        while (s < FloatFFT_3D.this.slices) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            int idx0 = s * FloatFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(a, idx0 + r * FloatFFT_3D.this.rowStride, scale);
                                    ++r;
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx5;
                                    int idx4;
                                    int r3 = 0;
                                    while (r3 < FloatFFT_3D.this.rows) {
                                        idx1 = idx0 + r3 * FloatFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[idx1 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[idx1 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4] = a[idx1 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4 + 1] = a[idx1 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5] = a[idx1 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5 + 1] = a[idx1 + 7];
                                        ++r3;
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 4 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 6 * FloatFFT_3D.this.rows, scale);
                                    r3 = 0;
                                    while (r3 < FloatFFT_3D.this.rows) {
                                        idx1 = idx0 + r3 * FloatFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a[idx1] = FloatFFT_3D.this.t[idx2];
                                        a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                        a[idx1 + 2] = FloatFFT_3D.this.t[idx3];
                                        a[idx1 + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                        a[idx1 + 4] = FloatFFT_3D.this.t[idx4];
                                        a[idx1 + 5] = FloatFFT_3D.this.t[idx4 + 1];
                                        a[idx1 + 6] = FloatFFT_3D.this.t[idx5];
                                        a[idx1 + 7] = FloatFFT_3D.this.t[idx5 + 1];
                                        ++r3;
                                    }
                                    c += 8;
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[idx1 + 2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[idx1 + 3];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows, scale);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    a[idx1] = FloatFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                    a[idx1 + 2] = FloatFFT_3D.this.t[idx3];
                                    a[idx1 + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                    ++r;
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    a[idx1] = FloatFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                    ++r;
                                }
                            }
                            if (icr != 0) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.realInverse(a, idx0 + r * FloatFFT_3D.this.rowStride, scale);
                                    ++r;
                                }
                            }
                            s += nthreads;
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void xdft3da_subth2(final int icr, final int isgn, final float[] a, final boolean scale) {
        final int nthreads = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int nt = 8 * this.rows;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (isgn == -1) {
                        int s = n0;
                        while (s < FloatFFT_3D.this.slices) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            int idx0 = s * FloatFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.complexForward(a, idx0 + r * FloatFFT_3D.this.rowStride);
                                    ++r;
                                }
                            } else {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.realForward(a, idx0 + r * FloatFFT_3D.this.rowStride);
                                    ++r;
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx5;
                                    int idx4;
                                    int r2 = 0;
                                    while (r2 < FloatFFT_3D.this.rows) {
                                        idx1 = idx0 + r2 * FloatFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[idx1 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[idx1 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4] = a[idx1 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4 + 1] = a[idx1 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5] = a[idx1 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5 + 1] = a[idx1 + 7];
                                        ++r2;
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 6 * FloatFFT_3D.this.rows);
                                    r2 = 0;
                                    while (r2 < FloatFFT_3D.this.rows) {
                                        idx1 = idx0 + r2 * FloatFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a[idx1] = FloatFFT_3D.this.t[idx2];
                                        a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                        a[idx1 + 2] = FloatFFT_3D.this.t[idx3];
                                        a[idx1 + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                        a[idx1 + 4] = FloatFFT_3D.this.t[idx4];
                                        a[idx1 + 5] = FloatFFT_3D.this.t[idx4 + 1];
                                        a[idx1 + 6] = FloatFFT_3D.this.t[idx5];
                                        a[idx1 + 7] = FloatFFT_3D.this.t[idx5 + 1];
                                        ++r2;
                                    }
                                    c += 8;
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[idx1 + 2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[idx1 + 3];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt);
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    a[idx1] = FloatFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                    a[idx1 + 2] = FloatFFT_3D.this.t[idx3];
                                    a[idx1 + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                    ++r;
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    a[idx1] = FloatFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                    ++r;
                                }
                            }
                            s += nthreads;
                        }
                    } else {
                        int s = n0;
                        while (s < FloatFFT_3D.this.slices) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            int idx0 = s * FloatFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(a, idx0 + r * FloatFFT_3D.this.rowStride, scale);
                                    ++r;
                                }
                            } else {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.realInverse2(a, idx0 + r * FloatFFT_3D.this.rowStride, scale);
                                    ++r;
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx5;
                                    int idx4;
                                    int r3 = 0;
                                    while (r3 < FloatFFT_3D.this.rows) {
                                        idx1 = idx0 + r3 * FloatFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[idx1 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[idx1 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4] = a[idx1 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4 + 1] = a[idx1 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5] = a[idx1 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5 + 1] = a[idx1 + 7];
                                        ++r3;
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 4 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 6 * FloatFFT_3D.this.rows, scale);
                                    r3 = 0;
                                    while (r3 < FloatFFT_3D.this.rows) {
                                        idx1 = idx0 + r3 * FloatFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a[idx1] = FloatFFT_3D.this.t[idx2];
                                        a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                        a[idx1 + 2] = FloatFFT_3D.this.t[idx3];
                                        a[idx1 + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                        a[idx1 + 4] = FloatFFT_3D.this.t[idx4];
                                        a[idx1 + 5] = FloatFFT_3D.this.t[idx4 + 1];
                                        a[idx1 + 6] = FloatFFT_3D.this.t[idx5];
                                        a[idx1 + 7] = FloatFFT_3D.this.t[idx5 + 1];
                                        ++r3;
                                    }
                                    c += 8;
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[idx1 + 2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[idx1 + 3];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows, scale);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    a[idx1] = FloatFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                    a[idx1 + 2] = FloatFFT_3D.this.t[idx3];
                                    a[idx1 + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                    ++r;
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx1 = idx0 + r * FloatFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    a[idx1] = FloatFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                    ++r;
                                }
                            }
                            s += nthreads;
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void xdft3da_subth1(final int icr, final int isgn, final float[][][] a, final boolean scale) {
        final int nthreads = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int nt = 8 * this.rows;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (isgn == -1) {
                        int s = n0;
                        while (s < FloatFFT_3D.this.slices) {
                            int idx3;
                            int idx2;
                            int r;
                            if (icr == 0) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.complexForward(a[s][r]);
                                    ++r;
                                }
                            } else {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.realForward(a[s][r], 0);
                                    ++r;
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx5;
                                    int idx4;
                                    int r2 = 0;
                                    while (r2 < FloatFFT_3D.this.rows) {
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r2][c];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r2][c + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[s][r2][c + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[s][r2][c + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4] = a[s][r2][c + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4 + 1] = a[s][r2][c + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5] = a[s][r2][c + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5 + 1] = a[s][r2][c + 7];
                                        ++r2;
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 6 * FloatFFT_3D.this.rows);
                                    r2 = 0;
                                    while (r2 < FloatFFT_3D.this.rows) {
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a[s][r2][c] = FloatFFT_3D.this.t[idx2];
                                        a[s][r2][c + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                        a[s][r2][c + 2] = FloatFFT_3D.this.t[idx3];
                                        a[s][r2][c + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                        a[s][r2][c + 4] = FloatFFT_3D.this.t[idx4];
                                        a[s][r2][c + 5] = FloatFFT_3D.this.t[idx4 + 1];
                                        a[s][r2][c + 6] = FloatFFT_3D.this.t[idx5];
                                        a[s][r2][c + 7] = FloatFFT_3D.this.t[idx5 + 1];
                                        ++r2;
                                    }
                                    c += 8;
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[s][r][2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[s][r][3];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt);
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    a[s][r][0] = FloatFFT_3D.this.t[idx2];
                                    a[s][r][1] = FloatFFT_3D.this.t[idx2 + 1];
                                    a[s][r][2] = FloatFFT_3D.this.t[idx3];
                                    a[s][r][3] = FloatFFT_3D.this.t[idx3 + 1];
                                    ++r;
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    a[s][r][0] = FloatFFT_3D.this.t[idx2];
                                    a[s][r][1] = FloatFFT_3D.this.t[idx2 + 1];
                                    ++r;
                                }
                            }
                            s += nthreads;
                        }
                    } else {
                        int s = n0;
                        while (s < FloatFFT_3D.this.slices) {
                            int idx3;
                            int idx2;
                            int r;
                            if (icr == 0) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(a[s][r], scale);
                                    ++r;
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx5;
                                    int idx4;
                                    int r3 = 0;
                                    while (r3 < FloatFFT_3D.this.rows) {
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r3][c];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r3][c + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[s][r3][c + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[s][r3][c + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4] = a[s][r3][c + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4 + 1] = a[s][r3][c + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5] = a[s][r3][c + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5 + 1] = a[s][r3][c + 7];
                                        ++r3;
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 4 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 6 * FloatFFT_3D.this.rows, scale);
                                    r3 = 0;
                                    while (r3 < FloatFFT_3D.this.rows) {
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a[s][r3][c] = FloatFFT_3D.this.t[idx2];
                                        a[s][r3][c + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                        a[s][r3][c + 2] = FloatFFT_3D.this.t[idx3];
                                        a[s][r3][c + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                        a[s][r3][c + 4] = FloatFFT_3D.this.t[idx4];
                                        a[s][r3][c + 5] = FloatFFT_3D.this.t[idx4 + 1];
                                        a[s][r3][c + 6] = FloatFFT_3D.this.t[idx5];
                                        a[s][r3][c + 7] = FloatFFT_3D.this.t[idx5 + 1];
                                        ++r3;
                                    }
                                    c += 8;
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[s][r][2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[s][r][3];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows, scale);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    a[s][r][0] = FloatFFT_3D.this.t[idx2];
                                    a[s][r][1] = FloatFFT_3D.this.t[idx2 + 1];
                                    a[s][r][2] = FloatFFT_3D.this.t[idx3];
                                    a[s][r][3] = FloatFFT_3D.this.t[idx3 + 1];
                                    ++r;
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    a[s][r][0] = FloatFFT_3D.this.t[idx2];
                                    a[s][r][1] = FloatFFT_3D.this.t[idx2 + 1];
                                    ++r;
                                }
                            }
                            if (icr != 0) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.realInverse(a[s][r], scale);
                                    ++r;
                                }
                            }
                            s += nthreads;
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void xdft3da_subth2(final int icr, final int isgn, final float[][][] a, final boolean scale) {
        final int nthreads = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int nt = 8 * this.rows;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (isgn == -1) {
                        int s = n0;
                        while (s < FloatFFT_3D.this.slices) {
                            int idx3;
                            int idx2;
                            int r;
                            if (icr == 0) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.complexForward(a[s][r]);
                                    ++r;
                                }
                            } else {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.realForward(a[s][r]);
                                    ++r;
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx5;
                                    int idx4;
                                    int r2 = 0;
                                    while (r2 < FloatFFT_3D.this.rows) {
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r2][c];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r2][c + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[s][r2][c + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[s][r2][c + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4] = a[s][r2][c + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4 + 1] = a[s][r2][c + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5] = a[s][r2][c + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5 + 1] = a[s][r2][c + 7];
                                        ++r2;
                                    }
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 4 * FloatFFT_3D.this.rows);
                                    FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 6 * FloatFFT_3D.this.rows);
                                    r2 = 0;
                                    while (r2 < FloatFFT_3D.this.rows) {
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a[s][r2][c] = FloatFFT_3D.this.t[idx2];
                                        a[s][r2][c + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                        a[s][r2][c + 2] = FloatFFT_3D.this.t[idx3];
                                        a[s][r2][c + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                        a[s][r2][c + 4] = FloatFFT_3D.this.t[idx4];
                                        a[s][r2][c + 5] = FloatFFT_3D.this.t[idx4 + 1];
                                        a[s][r2][c + 6] = FloatFFT_3D.this.t[idx5];
                                        a[s][r2][c + 7] = FloatFFT_3D.this.t[idx5 + 1];
                                        ++r2;
                                    }
                                    c += 8;
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[s][r][2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[s][r][3];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt);
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    a[s][r][0] = FloatFFT_3D.this.t[idx2];
                                    a[s][r][1] = FloatFFT_3D.this.t[idx2 + 1];
                                    a[s][r][2] = FloatFFT_3D.this.t[idx3];
                                    a[s][r][3] = FloatFFT_3D.this.t[idx3 + 1];
                                    ++r;
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexForward(FloatFFT_3D.this.t, startt);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    a[s][r][0] = FloatFFT_3D.this.t[idx2];
                                    a[s][r][1] = FloatFFT_3D.this.t[idx2 + 1];
                                    ++r;
                                }
                            }
                            s += nthreads;
                        }
                    } else {
                        int s = n0;
                        while (s < FloatFFT_3D.this.slices) {
                            int idx3;
                            int idx2;
                            int r;
                            if (icr == 0) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.complexInverse(a[s][r], scale);
                                    ++r;
                                }
                            } else {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    FloatFFT_3D.this.fftColumns.realInverse2(a[s][r], 0, scale);
                                    ++r;
                                }
                            }
                            if (FloatFFT_3D.this.columns > 4) {
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx5;
                                    int idx4;
                                    int r3 = 0;
                                    while (r3 < FloatFFT_3D.this.rows) {
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r3][c];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r3][c + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[s][r3][c + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[s][r3][c + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4] = a[s][r3][c + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4 + 1] = a[s][r3][c + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5] = a[s][r3][c + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5 + 1] = a[s][r3][c + 7];
                                        ++r3;
                                    }
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 4 * FloatFFT_3D.this.rows, scale);
                                    FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 6 * FloatFFT_3D.this.rows, scale);
                                    r3 = 0;
                                    while (r3 < FloatFFT_3D.this.rows) {
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.rows;
                                        a[s][r3][c] = FloatFFT_3D.this.t[idx2];
                                        a[s][r3][c + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                        a[s][r3][c + 2] = FloatFFT_3D.this.t[idx3];
                                        a[s][r3][c + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                        a[s][r3][c + 4] = FloatFFT_3D.this.t[idx4];
                                        a[s][r3][c + 5] = FloatFFT_3D.this.t[idx4 + 1];
                                        a[s][r3][c + 6] = FloatFFT_3D.this.t[idx5];
                                        a[s][r3][c + 7] = FloatFFT_3D.this.t[idx5 + 1];
                                        ++r3;
                                    }
                                    c += 8;
                                }
                            } else if (FloatFFT_3D.this.columns == 4) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[s][r][2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[s][r][3];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.rows, scale);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * FloatFFT_3D.this.rows + 2 * r;
                                    a[s][r][0] = FloatFFT_3D.this.t[idx2];
                                    a[s][r][1] = FloatFFT_3D.this.t[idx2 + 1];
                                    a[s][r][2] = FloatFFT_3D.this.t[idx3];
                                    a[s][r][3] = FloatFFT_3D.this.t[idx3 + 1];
                                    ++r;
                                }
                            } else if (FloatFFT_3D.this.columns == 2) {
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][1];
                                    ++r;
                                }
                                FloatFFT_3D.this.fftRows.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                r = 0;
                                while (r < FloatFFT_3D.this.rows) {
                                    idx2 = startt + 2 * r;
                                    a[s][r][0] = FloatFFT_3D.this.t[idx2];
                                    a[s][r][1] = FloatFFT_3D.this.t[idx2 + 1];
                                    ++r;
                                }
                            }
                            s += nthreads;
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void cdft3db_subth(final int isgn, final float[] a, final boolean scale) {
        final int nthreads = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int nt = 8 * this.slices;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block27: {
                        block25: {
                            block28: {
                                block26: {
                                    if (isgn != -1) break block25;
                                    if (FloatFFT_3D.this.columns <= 4) break block26;
                                    int r = n0;
                                    while (r < FloatFFT_3D.this.rows) {
                                        int idx0 = r * FloatFFT_3D.this.rowStride;
                                        int c = 0;
                                        while (c < FloatFFT_3D.this.columns) {
                                            int idx5;
                                            int idx4;
                                            int idx3;
                                            int idx2;
                                            int idx1;
                                            int s = 0;
                                            while (s < FloatFFT_3D.this.slices) {
                                                idx1 = s * FloatFFT_3D.this.sliceStride + idx0 + c;
                                                idx2 = startt + 2 * s;
                                                idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                                idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[idx1 + 2];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[idx1 + 3];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx4] = a[idx1 + 4];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx4 + 1] = a[idx1 + 5];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx5] = a[idx1 + 6];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx5 + 1] = a[idx1 + 7];
                                                ++s;
                                            }
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt);
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt + 4 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt + 6 * FloatFFT_3D.this.slices);
                                            s = 0;
                                            while (s < FloatFFT_3D.this.slices) {
                                                idx1 = s * FloatFFT_3D.this.sliceStride + idx0 + c;
                                                idx2 = startt + 2 * s;
                                                idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                                idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                                a[idx1] = FloatFFT_3D.this.t[idx2];
                                                a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                                a[idx1 + 2] = FloatFFT_3D.this.t[idx3];
                                                a[idx1 + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                                a[idx1 + 4] = FloatFFT_3D.this.t[idx4];
                                                a[idx1 + 5] = FloatFFT_3D.this.t[idx4 + 1];
                                                a[idx1 + 6] = FloatFFT_3D.this.t[idx5];
                                                a[idx1 + 7] = FloatFFT_3D.this.t[idx5 + 1];
                                                ++s;
                                            }
                                            c += 8;
                                        }
                                        r += nthreads;
                                    }
                                    break block27;
                                }
                                if (FloatFFT_3D.this.columns != 4) break block28;
                                int r = n0;
                                while (r < FloatFFT_3D.this.rows) {
                                    int idx3;
                                    int idx2;
                                    int idx1;
                                    int idx0 = r * FloatFFT_3D.this.rowStride;
                                    int s = 0;
                                    while (s < FloatFFT_3D.this.slices) {
                                        idx1 = s * FloatFFT_3D.this.sliceStride + idx0;
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[idx1 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[idx1 + 3];
                                        ++s;
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt);
                                    FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.slices);
                                    s = 0;
                                    while (s < FloatFFT_3D.this.slices) {
                                        idx1 = s * FloatFFT_3D.this.sliceStride + idx0;
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                        a[idx1] = FloatFFT_3D.this.t[idx2];
                                        a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                        a[idx1 + 2] = FloatFFT_3D.this.t[idx3];
                                        a[idx1 + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                        ++s;
                                    }
                                    r += nthreads;
                                }
                                break block27;
                            }
                            if (FloatFFT_3D.this.columns != 2) break block27;
                            int r = n0;
                            while (r < FloatFFT_3D.this.rows) {
                                int idx2;
                                int idx1;
                                int idx0 = r * FloatFFT_3D.this.rowStride;
                                int s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx1 = s * FloatFFT_3D.this.sliceStride + idx0;
                                    idx2 = startt + 2 * s;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ++s;
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt);
                                s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx1 = s * FloatFFT_3D.this.sliceStride + idx0;
                                    idx2 = startt + 2 * s;
                                    a[idx1] = FloatFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                    ++s;
                                }
                                r += nthreads;
                            }
                            break block27;
                        }
                        if (FloatFFT_3D.this.columns > 4) {
                            int r = n0;
                            while (r < FloatFFT_3D.this.rows) {
                                int idx0 = r * FloatFFT_3D.this.rowStride;
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx5;
                                    int idx4;
                                    int idx3;
                                    int idx2;
                                    int idx1;
                                    int s = 0;
                                    while (s < FloatFFT_3D.this.slices) {
                                        idx1 = s * FloatFFT_3D.this.sliceStride + idx0 + c;
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[idx1 + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[idx1 + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4] = a[idx1 + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4 + 1] = a[idx1 + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5] = a[idx1 + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5 + 1] = a[idx1 + 7];
                                        ++s;
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.slices, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt + 4 * FloatFFT_3D.this.slices, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt + 6 * FloatFFT_3D.this.slices, scale);
                                    s = 0;
                                    while (s < FloatFFT_3D.this.slices) {
                                        idx1 = s * FloatFFT_3D.this.sliceStride + idx0 + c;
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                        a[idx1] = FloatFFT_3D.this.t[idx2];
                                        a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                        a[idx1 + 2] = FloatFFT_3D.this.t[idx3];
                                        a[idx1 + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                        a[idx1 + 4] = FloatFFT_3D.this.t[idx4];
                                        a[idx1 + 5] = FloatFFT_3D.this.t[idx4 + 1];
                                        a[idx1 + 6] = FloatFFT_3D.this.t[idx5];
                                        a[idx1 + 7] = FloatFFT_3D.this.t[idx5 + 1];
                                        ++s;
                                    }
                                    c += 8;
                                }
                                r += nthreads;
                            }
                        } else if (FloatFFT_3D.this.columns == 4) {
                            int r = n0;
                            while (r < FloatFFT_3D.this.rows) {
                                int idx3;
                                int idx2;
                                int idx1;
                                int idx0 = r * FloatFFT_3D.this.rowStride;
                                int s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx1 = s * FloatFFT_3D.this.sliceStride + idx0;
                                    idx2 = startt + 2 * s;
                                    idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[idx1 + 2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[idx1 + 3];
                                    ++s;
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.slices, scale);
                                s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx1 = s * FloatFFT_3D.this.sliceStride + idx0;
                                    idx2 = startt + 2 * s;
                                    idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                    a[idx1] = FloatFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                    a[idx1 + 2] = FloatFFT_3D.this.t[idx3];
                                    a[idx1 + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                    ++s;
                                }
                                r += nthreads;
                            }
                        } else if (FloatFFT_3D.this.columns == 2) {
                            int r = n0;
                            while (r < FloatFFT_3D.this.rows) {
                                int idx2;
                                int idx1;
                                int idx0 = r * FloatFFT_3D.this.rowStride;
                                int s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx1 = s * FloatFFT_3D.this.sliceStride + idx0;
                                    idx2 = startt + 2 * s;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[idx1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[idx1 + 1];
                                    ++s;
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx1 = s * FloatFFT_3D.this.sliceStride + idx0;
                                    idx2 = startt + 2 * s;
                                    a[idx1] = FloatFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                    ++s;
                                }
                                r += nthreads;
                            }
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void cdft3db_subth(final int isgn, final float[][][] a, final boolean scale) {
        final int nthreads = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int nt = 8 * this.slices;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block27: {
                        block25: {
                            block28: {
                                block26: {
                                    if (isgn != -1) break block25;
                                    if (FloatFFT_3D.this.columns <= 4) break block26;
                                    int r = n0;
                                    while (r < FloatFFT_3D.this.rows) {
                                        int c = 0;
                                        while (c < FloatFFT_3D.this.columns) {
                                            int idx5;
                                            int idx4;
                                            int idx3;
                                            int idx2;
                                            int s = 0;
                                            while (s < FloatFFT_3D.this.slices) {
                                                idx2 = startt + 2 * s;
                                                idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                                idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][c];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][c + 1];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[s][r][c + 2];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[s][r][c + 3];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx4] = a[s][r][c + 4];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx4 + 1] = a[s][r][c + 5];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx5] = a[s][r][c + 6];
                                                ((FloatFFT_3D)FloatFFT_3D.this).t[idx5 + 1] = a[s][r][c + 7];
                                                ++s;
                                            }
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt);
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt + 4 * FloatFFT_3D.this.slices);
                                            FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt + 6 * FloatFFT_3D.this.slices);
                                            s = 0;
                                            while (s < FloatFFT_3D.this.slices) {
                                                idx2 = startt + 2 * s;
                                                idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                                idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                                a[s][r][c] = FloatFFT_3D.this.t[idx2];
                                                a[s][r][c + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                                a[s][r][c + 2] = FloatFFT_3D.this.t[idx3];
                                                a[s][r][c + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                                a[s][r][c + 4] = FloatFFT_3D.this.t[idx4];
                                                a[s][r][c + 5] = FloatFFT_3D.this.t[idx4 + 1];
                                                a[s][r][c + 6] = FloatFFT_3D.this.t[idx5];
                                                a[s][r][c + 7] = FloatFFT_3D.this.t[idx5 + 1];
                                                ++s;
                                            }
                                            c += 8;
                                        }
                                        r += nthreads;
                                    }
                                    break block27;
                                }
                                if (FloatFFT_3D.this.columns != 4) break block28;
                                int r = n0;
                                while (r < FloatFFT_3D.this.rows) {
                                    int idx3;
                                    int idx2;
                                    int s = 0;
                                    while (s < FloatFFT_3D.this.slices) {
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][0];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[s][r][2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[s][r][3];
                                        ++s;
                                    }
                                    FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt);
                                    FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.slices);
                                    s = 0;
                                    while (s < FloatFFT_3D.this.slices) {
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                        a[s][r][0] = FloatFFT_3D.this.t[idx2];
                                        a[s][r][1] = FloatFFT_3D.this.t[idx2 + 1];
                                        a[s][r][2] = FloatFFT_3D.this.t[idx3];
                                        a[s][r][3] = FloatFFT_3D.this.t[idx3 + 1];
                                        ++s;
                                    }
                                    r += nthreads;
                                }
                                break block27;
                            }
                            if (FloatFFT_3D.this.columns != 2) break block27;
                            int r = n0;
                            while (r < FloatFFT_3D.this.rows) {
                                int idx2;
                                int s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = startt + 2 * s;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][1];
                                    ++s;
                                }
                                FloatFFT_3D.this.fftSlices.complexForward(FloatFFT_3D.this.t, startt);
                                s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = startt + 2 * s;
                                    a[s][r][0] = FloatFFT_3D.this.t[idx2];
                                    a[s][r][1] = FloatFFT_3D.this.t[idx2 + 1];
                                    ++s;
                                }
                                r += nthreads;
                            }
                            break block27;
                        }
                        if (FloatFFT_3D.this.columns > 4) {
                            int r = n0;
                            while (r < FloatFFT_3D.this.rows) {
                                int c = 0;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx5;
                                    int idx4;
                                    int idx3;
                                    int idx2;
                                    int s = 0;
                                    while (s < FloatFFT_3D.this.slices) {
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][c];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][c + 1];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[s][r][c + 2];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[s][r][c + 3];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4] = a[s][r][c + 4];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx4 + 1] = a[s][r][c + 5];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5] = a[s][r][c + 6];
                                        ((FloatFFT_3D)FloatFFT_3D.this).t[idx5 + 1] = a[s][r][c + 7];
                                        ++s;
                                    }
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.slices, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt + 4 * FloatFFT_3D.this.slices, scale);
                                    FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt + 6 * FloatFFT_3D.this.slices, scale);
                                    s = 0;
                                    while (s < FloatFFT_3D.this.slices) {
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                        idx4 = idx3 + 2 * FloatFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * FloatFFT_3D.this.slices;
                                        a[s][r][c] = FloatFFT_3D.this.t[idx2];
                                        a[s][r][c + 1] = FloatFFT_3D.this.t[idx2 + 1];
                                        a[s][r][c + 2] = FloatFFT_3D.this.t[idx3];
                                        a[s][r][c + 3] = FloatFFT_3D.this.t[idx3 + 1];
                                        a[s][r][c + 4] = FloatFFT_3D.this.t[idx4];
                                        a[s][r][c + 5] = FloatFFT_3D.this.t[idx4 + 1];
                                        a[s][r][c + 6] = FloatFFT_3D.this.t[idx5];
                                        a[s][r][c + 7] = FloatFFT_3D.this.t[idx5 + 1];
                                        ++s;
                                    }
                                    c += 8;
                                }
                                r += nthreads;
                            }
                        } else if (FloatFFT_3D.this.columns == 4) {
                            int r = n0;
                            while (r < FloatFFT_3D.this.rows) {
                                int idx3;
                                int idx2;
                                int s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = startt + 2 * s;
                                    idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][1];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3] = a[s][r][2];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx3 + 1] = a[s][r][3];
                                    ++s;
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt + 2 * FloatFFT_3D.this.slices, scale);
                                s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = startt + 2 * s;
                                    idx3 = startt + 2 * FloatFFT_3D.this.slices + 2 * s;
                                    a[s][r][0] = FloatFFT_3D.this.t[idx2];
                                    a[s][r][1] = FloatFFT_3D.this.t[idx2 + 1];
                                    a[s][r][2] = FloatFFT_3D.this.t[idx3];
                                    a[s][r][3] = FloatFFT_3D.this.t[idx3 + 1];
                                    ++s;
                                }
                                r += nthreads;
                            }
                        } else if (FloatFFT_3D.this.columns == 2) {
                            int r = n0;
                            while (r < FloatFFT_3D.this.rows) {
                                int idx2;
                                int s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = startt + 2 * s;
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2] = a[s][r][0];
                                    ((FloatFFT_3D)FloatFFT_3D.this).t[idx2 + 1] = a[s][r][1];
                                    ++s;
                                }
                                FloatFFT_3D.this.fftSlices.complexInverse(FloatFFT_3D.this.t, startt, scale);
                                s = 0;
                                while (s < FloatFFT_3D.this.slices) {
                                    idx2 = startt + 2 * s;
                                    a[s][r][0] = FloatFFT_3D.this.t[idx2];
                                    a[s][r][1] = FloatFFT_3D.this.t[idx2 + 1];
                                    ++s;
                                }
                                r += nthreads;
                            }
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void rdft3d_sub(int isgn, float[] a) {
        int n1h = this.slices >> 1;
        int n2h = this.rows >> 1;
        if (isgn < 0) {
            int l;
            int k;
            float xi;
            int idx4;
            int idx3;
            int idx2;
            int idx1;
            int i = 1;
            while (i < n1h) {
                int j = this.slices - i;
                idx1 = i * this.sliceStride;
                idx2 = j * this.sliceStride;
                idx3 = i * this.sliceStride + n2h * this.rowStride;
                idx4 = j * this.sliceStride + n2h * this.rowStride;
                xi = a[idx1] - a[idx2];
                int n = idx1;
                a[n] = a[n] + a[idx2];
                a[idx2] = xi;
                xi = a[idx2 + 1] - a[idx1 + 1];
                int n2 = idx1 + 1;
                a[n2] = a[n2] + a[idx2 + 1];
                a[idx2 + 1] = xi;
                xi = a[idx3] - a[idx4];
                int n3 = idx3;
                a[n3] = a[n3] + a[idx4];
                a[idx4] = xi;
                xi = a[idx4 + 1] - a[idx3 + 1];
                int n4 = idx3 + 1;
                a[n4] = a[n4] + a[idx4 + 1];
                a[idx4 + 1] = xi;
                k = 1;
                while (k < n2h) {
                    l = this.rows - k;
                    idx1 = i * this.sliceStride + k * this.rowStride;
                    idx2 = j * this.sliceStride + l * this.rowStride;
                    xi = a[idx1] - a[idx2];
                    int n5 = idx1;
                    a[n5] = a[n5] + a[idx2];
                    a[idx2] = xi;
                    xi = a[idx2 + 1] - a[idx1 + 1];
                    int n6 = idx1 + 1;
                    a[n6] = a[n6] + a[idx2 + 1];
                    a[idx2 + 1] = xi;
                    idx3 = j * this.sliceStride + k * this.rowStride;
                    idx4 = i * this.sliceStride + l * this.rowStride;
                    xi = a[idx3] - a[idx4];
                    int n7 = idx3;
                    a[n7] = a[n7] + a[idx4];
                    a[idx4] = xi;
                    xi = a[idx4 + 1] - a[idx3 + 1];
                    int n8 = idx3 + 1;
                    a[n8] = a[n8] + a[idx4 + 1];
                    a[idx4 + 1] = xi;
                    ++k;
                }
                ++i;
            }
            k = 1;
            while (k < n2h) {
                l = this.rows - k;
                idx1 = k * this.rowStride;
                idx2 = l * this.rowStride;
                xi = a[idx1] - a[idx2];
                int n = idx1;
                a[n] = a[n] + a[idx2];
                a[idx2] = xi;
                xi = a[idx2 + 1] - a[idx1 + 1];
                int n9 = idx1 + 1;
                a[n9] = a[n9] + a[idx2 + 1];
                a[idx2 + 1] = xi;
                idx3 = n1h * this.sliceStride + k * this.rowStride;
                idx4 = n1h * this.sliceStride + l * this.rowStride;
                xi = a[idx3] - a[idx4];
                int n10 = idx3;
                a[n10] = a[n10] + a[idx4];
                a[idx4] = xi;
                xi = a[idx4 + 1] - a[idx3 + 1];
                int n11 = idx3 + 1;
                a[n11] = a[n11] + a[idx4 + 1];
                a[idx4 + 1] = xi;
                ++k;
            }
        } else {
            int l;
            int k;
            int idx4;
            int idx3;
            int idx2;
            int idx1;
            int i = 1;
            while (i < n1h) {
                int j = this.slices - i;
                idx1 = j * this.sliceStride;
                idx2 = i * this.sliceStride;
                a[idx1] = 0.5f * (a[idx2] - a[idx1]);
                int n = idx2;
                a[n] = a[n] - a[idx1];
                a[idx1 + 1] = 0.5f * (a[idx2 + 1] + a[idx1 + 1]);
                int n12 = idx2 + 1;
                a[n12] = a[n12] - a[idx1 + 1];
                idx3 = j * this.sliceStride + n2h * this.rowStride;
                idx4 = i * this.sliceStride + n2h * this.rowStride;
                a[idx3] = 0.5f * (a[idx4] - a[idx3]);
                int n13 = idx4;
                a[n13] = a[n13] - a[idx3];
                a[idx3 + 1] = 0.5f * (a[idx4 + 1] + a[idx3 + 1]);
                int n14 = idx4 + 1;
                a[n14] = a[n14] - a[idx3 + 1];
                k = 1;
                while (k < n2h) {
                    l = this.rows - k;
                    idx1 = j * this.sliceStride + l * this.rowStride;
                    idx2 = i * this.sliceStride + k * this.rowStride;
                    a[idx1] = 0.5f * (a[idx2] - a[idx1]);
                    int n15 = idx2;
                    a[n15] = a[n15] - a[idx1];
                    a[idx1 + 1] = 0.5f * (a[idx2 + 1] + a[idx1 + 1]);
                    int n16 = idx2 + 1;
                    a[n16] = a[n16] - a[idx1 + 1];
                    idx3 = i * this.sliceStride + l * this.rowStride;
                    idx4 = j * this.sliceStride + k * this.rowStride;
                    a[idx3] = 0.5f * (a[idx4] - a[idx3]);
                    int n17 = idx4;
                    a[n17] = a[n17] - a[idx3];
                    a[idx3 + 1] = 0.5f * (a[idx4 + 1] + a[idx3 + 1]);
                    int n18 = idx4 + 1;
                    a[n18] = a[n18] - a[idx3 + 1];
                    ++k;
                }
                ++i;
            }
            k = 1;
            while (k < n2h) {
                l = this.rows - k;
                idx1 = l * this.rowStride;
                idx2 = k * this.rowStride;
                a[idx1] = 0.5f * (a[idx2] - a[idx1]);
                int n = idx2;
                a[n] = a[n] - a[idx1];
                a[idx1 + 1] = 0.5f * (a[idx2 + 1] + a[idx1 + 1]);
                int n19 = idx2 + 1;
                a[n19] = a[n19] - a[idx1 + 1];
                idx3 = n1h * this.sliceStride + l * this.rowStride;
                idx4 = n1h * this.sliceStride + k * this.rowStride;
                a[idx3] = 0.5f * (a[idx4] - a[idx3]);
                int n20 = idx4;
                a[n20] = a[n20] - a[idx3];
                a[idx3 + 1] = 0.5f * (a[idx4 + 1] + a[idx3 + 1]);
                int n21 = idx4 + 1;
                a[n21] = a[n21] - a[idx3 + 1];
                ++k;
            }
        }
    }

    private void rdft3d_sub(int isgn, float[][][] a) {
        int n1h = this.slices >> 1;
        int n2h = this.rows >> 1;
        if (isgn < 0) {
            int l;
            int k;
            float xi;
            int i = 1;
            while (i < n1h) {
                int j = this.slices - i;
                xi = a[i][0][0] - a[j][0][0];
                float[] fArray = a[i][0];
                fArray[0] = fArray[0] + a[j][0][0];
                a[j][0][0] = xi;
                xi = a[j][0][1] - a[i][0][1];
                float[] fArray2 = a[i][0];
                fArray2[1] = fArray2[1] + a[j][0][1];
                a[j][0][1] = xi;
                xi = a[i][n2h][0] - a[j][n2h][0];
                float[] fArray3 = a[i][n2h];
                fArray3[0] = fArray3[0] + a[j][n2h][0];
                a[j][n2h][0] = xi;
                xi = a[j][n2h][1] - a[i][n2h][1];
                float[] fArray4 = a[i][n2h];
                fArray4[1] = fArray4[1] + a[j][n2h][1];
                a[j][n2h][1] = xi;
                k = 1;
                while (k < n2h) {
                    l = this.rows - k;
                    xi = a[i][k][0] - a[j][l][0];
                    float[] fArray5 = a[i][k];
                    fArray5[0] = fArray5[0] + a[j][l][0];
                    a[j][l][0] = xi;
                    xi = a[j][l][1] - a[i][k][1];
                    float[] fArray6 = a[i][k];
                    fArray6[1] = fArray6[1] + a[j][l][1];
                    a[j][l][1] = xi;
                    xi = a[j][k][0] - a[i][l][0];
                    float[] fArray7 = a[j][k];
                    fArray7[0] = fArray7[0] + a[i][l][0];
                    a[i][l][0] = xi;
                    xi = a[i][l][1] - a[j][k][1];
                    float[] fArray8 = a[j][k];
                    fArray8[1] = fArray8[1] + a[i][l][1];
                    a[i][l][1] = xi;
                    ++k;
                }
                ++i;
            }
            k = 1;
            while (k < n2h) {
                l = this.rows - k;
                xi = a[0][k][0] - a[0][l][0];
                float[] fArray = a[0][k];
                fArray[0] = fArray[0] + a[0][l][0];
                a[0][l][0] = xi;
                xi = a[0][l][1] - a[0][k][1];
                float[] fArray9 = a[0][k];
                fArray9[1] = fArray9[1] + a[0][l][1];
                a[0][l][1] = xi;
                xi = a[n1h][k][0] - a[n1h][l][0];
                float[] fArray10 = a[n1h][k];
                fArray10[0] = fArray10[0] + a[n1h][l][0];
                a[n1h][l][0] = xi;
                xi = a[n1h][l][1] - a[n1h][k][1];
                float[] fArray11 = a[n1h][k];
                fArray11[1] = fArray11[1] + a[n1h][l][1];
                a[n1h][l][1] = xi;
                ++k;
            }
        } else {
            int l;
            int k;
            int i = 1;
            while (i < n1h) {
                int j = this.slices - i;
                a[j][0][0] = 0.5f * (a[i][0][0] - a[j][0][0]);
                float[] fArray = a[i][0];
                fArray[0] = fArray[0] - a[j][0][0];
                a[j][0][1] = 0.5f * (a[i][0][1] + a[j][0][1]);
                float[] fArray12 = a[i][0];
                fArray12[1] = fArray12[1] - a[j][0][1];
                a[j][n2h][0] = 0.5f * (a[i][n2h][0] - a[j][n2h][0]);
                float[] fArray13 = a[i][n2h];
                fArray13[0] = fArray13[0] - a[j][n2h][0];
                a[j][n2h][1] = 0.5f * (a[i][n2h][1] + a[j][n2h][1]);
                float[] fArray14 = a[i][n2h];
                fArray14[1] = fArray14[1] - a[j][n2h][1];
                k = 1;
                while (k < n2h) {
                    l = this.rows - k;
                    a[j][l][0] = 0.5f * (a[i][k][0] - a[j][l][0]);
                    float[] fArray15 = a[i][k];
                    fArray15[0] = fArray15[0] - a[j][l][0];
                    a[j][l][1] = 0.5f * (a[i][k][1] + a[j][l][1]);
                    float[] fArray16 = a[i][k];
                    fArray16[1] = fArray16[1] - a[j][l][1];
                    a[i][l][0] = 0.5f * (a[j][k][0] - a[i][l][0]);
                    float[] fArray17 = a[j][k];
                    fArray17[0] = fArray17[0] - a[i][l][0];
                    a[i][l][1] = 0.5f * (a[j][k][1] + a[i][l][1]);
                    float[] fArray18 = a[j][k];
                    fArray18[1] = fArray18[1] - a[i][l][1];
                    ++k;
                }
                ++i;
            }
            k = 1;
            while (k < n2h) {
                l = this.rows - k;
                a[0][l][0] = 0.5f * (a[0][k][0] - a[0][l][0]);
                float[] fArray = a[0][k];
                fArray[0] = fArray[0] - a[0][l][0];
                a[0][l][1] = 0.5f * (a[0][k][1] + a[0][l][1]);
                float[] fArray19 = a[0][k];
                fArray19[1] = fArray19[1] - a[0][l][1];
                a[n1h][l][0] = 0.5f * (a[n1h][k][0] - a[n1h][l][0]);
                float[] fArray20 = a[n1h][k];
                fArray20[0] = fArray20[0] - a[n1h][l][0];
                a[n1h][l][1] = 0.5f * (a[n1h][k][1] + a[n1h][l][1]);
                float[] fArray21 = a[n1h][k];
                fArray21[1] = fArray21[1] - a[n1h][l][1];
                ++k;
            }
        }
    }

    private void fillSymmetric(final float[][][] a) {
        int idx1;
        final int twon3 = 2 * this.columns;
        final int n2d2 = this.rows / 2;
        int n1d2 = this.slices / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            int l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = (FloatFFT_3D.this.slices - s) % FloatFFT_3D.this.slices;
                            int r = 0;
                            while (r < FloatFFT_3D.this.rows) {
                                int idx2 = (FloatFFT_3D.this.rows - r) % FloatFFT_3D.this.rows;
                                int c = 1;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx3 = twon3 - c;
                                    a[idx1][idx2][idx3] = -a[s][r][c + 2];
                                    a[idx1][idx2][idx3 - 1] = a[s][r][c + 1];
                                    c += 2;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = (FloatFFT_3D.this.slices - s) % FloatFFT_3D.this.slices;
                            int r = 1;
                            while (r < n2d2) {
                                int idx2 = FloatFFT_3D.this.rows - r;
                                a[idx1][r][((FloatFFT_3D)FloatFFT_3D.this).columns] = a[s][idx2][1];
                                a[s][idx2][((FloatFFT_3D)FloatFFT_3D.this).columns] = a[s][idx2][1];
                                a[idx1][r][((FloatFFT_3D)FloatFFT_3D.this).columns + 1] = -a[s][idx2][0];
                                a[s][idx2][((FloatFFT_3D)FloatFFT_3D.this).columns + 1] = a[s][idx2][0];
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = (FloatFFT_3D.this.slices - s) % FloatFFT_3D.this.slices;
                            int r = 1;
                            while (r < n2d2) {
                                int idx2 = FloatFFT_3D.this.rows - r;
                                a[idx1][idx2][0] = a[s][r][0];
                                a[idx1][idx2][1] = -a[s][r][1];
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx2;
            int r;
            int s = 0;
            while (s < this.slices) {
                idx1 = (this.slices - s) % this.slices;
                r = 0;
                while (r < this.rows) {
                    idx2 = (this.rows - r) % this.rows;
                    int c = 1;
                    while (c < this.columns) {
                        int idx3 = twon3 - c;
                        a[idx1][idx2][idx3] = -a[s][r][c + 2];
                        a[idx1][idx2][idx3 - 1] = a[s][r][c + 1];
                        c += 2;
                    }
                    ++r;
                }
                ++s;
            }
            s = 0;
            while (s < this.slices) {
                idx1 = (this.slices - s) % this.slices;
                r = 1;
                while (r < n2d2) {
                    idx2 = this.rows - r;
                    a[idx1][r][this.columns] = a[s][idx2][1];
                    a[s][idx2][this.columns] = a[s][idx2][1];
                    a[idx1][r][this.columns + 1] = -a[s][idx2][0];
                    a[s][idx2][this.columns + 1] = a[s][idx2][0];
                    ++r;
                }
                ++s;
            }
            s = 0;
            while (s < this.slices) {
                idx1 = (this.slices - s) % this.slices;
                r = 1;
                while (r < n2d2) {
                    idx2 = this.rows - r;
                    a[idx1][idx2][0] = a[s][r][0];
                    a[idx1][idx2][1] = -a[s][r][1];
                    ++r;
                }
                ++s;
            }
        }
        int s = 1;
        while (s < n1d2) {
            idx1 = this.slices - s;
            a[s][0][this.columns] = a[idx1][0][1];
            a[idx1][0][this.columns] = a[idx1][0][1];
            a[s][0][this.columns + 1] = -a[idx1][0][0];
            a[idx1][0][this.columns + 1] = a[idx1][0][0];
            a[s][n2d2][this.columns] = a[idx1][n2d2][1];
            a[idx1][n2d2][this.columns] = a[idx1][n2d2][1];
            a[s][n2d2][this.columns + 1] = -a[idx1][n2d2][0];
            a[idx1][n2d2][this.columns + 1] = a[idx1][n2d2][0];
            a[idx1][0][0] = a[s][0][0];
            a[idx1][0][1] = -a[s][0][1];
            a[idx1][n2d2][0] = a[s][n2d2][0];
            a[idx1][n2d2][1] = -a[s][n2d2][1];
            ++s;
        }
        a[0][0][this.columns] = a[0][0][1];
        a[0][0][1] = 0.0f;
        a[0][n2d2][this.columns] = a[0][n2d2][1];
        a[0][n2d2][1] = 0.0f;
        a[n1d2][0][this.columns] = a[n1d2][0][1];
        a[n1d2][0][1] = 0.0f;
        a[n1d2][n2d2][this.columns] = a[n1d2][n2d2][1];
        a[n1d2][n2d2][1] = 0.0f;
        a[n1d2][0][this.columns + 1] = 0.0f;
        a[n1d2][n2d2][this.columns + 1] = 0.0f;
    }

    private void fillSymmetric(final float[] a) {
        int idx2;
        int idx1;
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        final int twon3 = 2 * this.columns;
        final int n2d2 = this.rows / 2;
        int n1d2 = this.slices / 2;
        final int twoSliceStride = this.rows * twon3;
        final int twoRowStride = twon3;
        int s = this.slices - 1;
        while (s >= 1) {
            idx3 = s * this.sliceStride;
            idx4 = 2 * idx3;
            int r = 0;
            while (r < this.rows) {
                idx5 = r * this.rowStride;
                idx6 = 2 * idx5;
                int c = 0;
                while (c < this.columns) {
                    idx1 = idx3 + idx5 + c;
                    idx2 = idx4 + idx6 + c;
                    a[idx2] = a[idx1];
                    a[idx1] = 0.0f;
                    a[++idx2] = a[++idx1];
                    a[idx1] = 0.0f;
                    c += 2;
                }
                ++r;
            }
            --s;
        }
        int r = 1;
        while (r < this.rows) {
            idx3 = (this.rows - r) * this.rowStride;
            idx4 = (this.rows - r) * twoRowStride;
            int c = 0;
            while (c < this.columns) {
                idx1 = idx3 + c;
                idx2 = idx4 + c;
                a[idx2] = a[idx1];
                a[idx1] = 0.0f;
                a[++idx2] = a[++idx1];
                a[idx1] = 0.0f;
                c += 2;
            }
            ++r;
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            int l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx3 = (FloatFFT_3D.this.slices - s) % FloatFFT_3D.this.slices * twoSliceStride;
                            int idx5 = s * twoSliceStride;
                            int r = 0;
                            while (r < FloatFFT_3D.this.rows) {
                                int idx4 = (FloatFFT_3D.this.rows - r) % FloatFFT_3D.this.rows * twoRowStride;
                                int idx6 = r * twoRowStride;
                                int c = 1;
                                while (c < FloatFFT_3D.this.columns) {
                                    int idx1 = idx3 + idx4 + twon3 - c;
                                    int idx2 = idx5 + idx6 + c;
                                    a[idx1] = -a[idx2 + 2];
                                    a[idx1 - 1] = a[idx2 + 1];
                                    c += 2;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx5 = (FloatFFT_3D.this.slices - s) % FloatFFT_3D.this.slices * twoSliceStride;
                            int idx6 = s * twoSliceStride;
                            int r = 1;
                            while (r < n2d2) {
                                int idx4 = idx6 + (FloatFFT_3D.this.rows - r) * twoRowStride;
                                int idx1 = idx5 + r * twoRowStride + FloatFFT_3D.this.columns;
                                int idx2 = idx4 + FloatFFT_3D.this.columns;
                                int idx3 = idx4 + 1;
                                a[idx1] = a[idx3];
                                a[idx2] = a[idx3];
                                a[idx1 + 1] = -a[idx4];
                                a[idx2 + 1] = a[idx4];
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx3 = (FloatFFT_3D.this.slices - s) % FloatFFT_3D.this.slices * twoSliceStride;
                            int idx4 = s * twoSliceStride;
                            int r = 1;
                            while (r < n2d2) {
                                int idx1 = idx3 + (FloatFFT_3D.this.rows - r) * twoRowStride;
                                int idx2 = idx4 + r * twoRowStride;
                                a[idx1] = a[idx2];
                                a[idx1 + 1] = -a[idx2 + 1];
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r2;
            int s2 = 0;
            while (s2 < this.slices) {
                idx3 = (this.slices - s2) % this.slices * twoSliceStride;
                idx5 = s2 * twoSliceStride;
                r2 = 0;
                while (r2 < this.rows) {
                    idx4 = (this.rows - r2) % this.rows * twoRowStride;
                    idx6 = r2 * twoRowStride;
                    int c = 1;
                    while (c < this.columns) {
                        idx1 = idx3 + idx4 + twon3 - c;
                        idx2 = idx5 + idx6 + c;
                        a[idx1] = -a[idx2 + 2];
                        a[idx1 - 1] = a[idx2 + 1];
                        c += 2;
                    }
                    ++r2;
                }
                ++s2;
            }
            s2 = 0;
            while (s2 < this.slices) {
                idx5 = (this.slices - s2) % this.slices * twoSliceStride;
                idx6 = s2 * twoSliceStride;
                r2 = 1;
                while (r2 < n2d2) {
                    idx4 = idx6 + (this.rows - r2) * twoRowStride;
                    idx1 = idx5 + r2 * twoRowStride + this.columns;
                    idx2 = idx4 + this.columns;
                    idx3 = idx4 + 1;
                    a[idx1] = a[idx3];
                    a[idx2] = a[idx3];
                    a[idx1 + 1] = -a[idx4];
                    a[idx2 + 1] = a[idx4];
                    ++r2;
                }
                ++s2;
            }
            s2 = 0;
            while (s2 < this.slices) {
                idx3 = (this.slices - s2) % this.slices * twoSliceStride;
                idx4 = s2 * twoSliceStride;
                r2 = 1;
                while (r2 < n2d2) {
                    idx1 = idx3 + (this.rows - r2) * twoRowStride;
                    idx2 = idx4 + r2 * twoRowStride;
                    a[idx1] = a[idx2];
                    a[idx1 + 1] = -a[idx2 + 1];
                    ++r2;
                }
                ++s2;
            }
        }
        int s3 = 1;
        while (s3 < n1d2) {
            idx1 = s3 * twoSliceStride;
            idx2 = (this.slices - s3) * twoSliceStride;
            idx3 = n2d2 * twoRowStride;
            idx4 = idx1 + idx3;
            idx5 = idx2 + idx3;
            a[idx1 + this.columns] = a[idx2 + 1];
            a[idx2 + this.columns] = a[idx2 + 1];
            a[idx1 + this.columns + 1] = -a[idx2];
            a[idx2 + this.columns + 1] = a[idx2];
            a[idx4 + this.columns] = a[idx5 + 1];
            a[idx5 + this.columns] = a[idx5 + 1];
            a[idx4 + this.columns + 1] = -a[idx5];
            a[idx5 + this.columns + 1] = a[idx5];
            a[idx2] = a[idx1];
            a[idx2 + 1] = -a[idx1 + 1];
            a[idx5] = a[idx4];
            a[idx5 + 1] = -a[idx4 + 1];
            ++s3;
        }
        a[this.columns] = a[1];
        a[1] = 0.0f;
        idx1 = n2d2 * twoRowStride;
        idx2 = n1d2 * twoSliceStride;
        idx3 = idx1 + idx2;
        a[idx1 + this.columns] = a[idx1 + 1];
        a[idx1 + 1] = 0.0f;
        a[idx2 + this.columns] = a[idx2 + 1];
        a[idx2 + 1] = 0.0f;
        a[idx3 + this.columns] = a[idx3 + 1];
        a[idx3 + 1] = 0.0f;
        a[idx2 + this.columns + 1] = 0.0f;
        a[idx3 + this.columns + 1] = 0.0f;
    }
}

