/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Set;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.ICompiler;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.compiler.java9.java.lang.module.ModuleFinder;
import org.codehaus.commons.compiler.java9.java.lang.module.ModuleReference;
import org.codehaus.commons.compiler.util.StringUtil;
import org.codehaus.commons.compiler.util.resource.Resource;
import org.codehaus.commons.compiler.util.resource.ResourceFinder;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.ResourceFinderIClassLoader;
import org.codehaus.janino.util.resource.JarDirectoriesResourceFinder;
import org.codehaus.janino.util.resource.LazyMultiResourceFinder;
import org.codehaus.janino.util.resource.MultiResourceFinder;
import org.codehaus.janino.util.resource.PathResourceFinder;

public abstract class AbstractCompiler
extends ICompiler {
    private File[] extensionDirectories = StringUtil.parsePath((String)System.getProperty("java.ext.dirs", ""));
    private File[] classPath = StringUtil.parsePath((String)System.getProperty("java.class.path"));
    @Nullable
    private File[] bootClassPath = StringUtil.parseOptionalPath((String)System.getProperty("sun.boot.class.path"));
    @Nullable
    protected ErrorHandler compileErrorHandler;
    @Nullable
    protected WarningHandler warningHandler;

    public AbstractCompiler() {
        this.updateIClassLoader();
    }

    public void setSourcePath(File[] directoriesAndArchives) {
        this.setSourceFinder(new PathResourceFinder(directoriesAndArchives));
    }

    public final void setBootClassPath(File[] directoriesAndArchives) {
        if (this.bootClassPath == null) {
            throw new IllegalArgumentException("This JVM doese not support BOOTCLASSPATH; probably because it is 9+");
        }
        this.bootClassPath = directoriesAndArchives;
        this.updateIClassLoader();
    }

    public final void setExtensionDirectories(File[] directories) {
        this.extensionDirectories = directories;
        this.updateIClassLoader();
    }

    public final void setClassPath(File[] directoriesAndArchives) {
        this.classPath = directoriesAndArchives;
        this.updateIClassLoader();
    }

    private void updateIClassLoader() {
        File[] bcp = this.bootClassPath;
        if (bcp != null) {
            this.setIClassLoader(new ResourceFinderIClassLoader(new MultiResourceFinder(Arrays.asList(new LazyMultiResourceFinder[]{new PathResourceFinder(bcp), new JarDirectoriesResourceFinder(this.extensionDirectories), new PathResourceFinder(this.classPath)})), null));
        } else {
            String sbcp = System.getProperty("sun.boot.class.path");
            if (sbcp != null) {
                this.bootClassPath = StringUtil.parsePath((String)sbcp);
            } else {
                URL r = ClassLoader.getSystemClassLoader().getResource("java/lang/Object.class");
                assert (r != null);
                assert ("jrt".equalsIgnoreCase(r.getProtocol())) : r.toString();
                ResourceFinder rf = new ResourceFinder(){

                    @Nullable
                    public Resource findResource(final String resourceName) {
                        try {
                            Set mrs = ModuleFinder.ofSystem().findAll();
                            for (ModuleReference mr : mrs) {
                                final URI moduleContentLocation = (URI)mr.location().get();
                                URL classFileUrl = new URL(moduleContentLocation + "/" + resourceName);
                                final URLConnection uc = classFileUrl.openConnection();
                                try {
                                    uc.connect();
                                    return new Resource(){

                                        public InputStream open() throws IOException {
                                            try {
                                                return uc.getInputStream();
                                            }
                                            catch (IOException ioe) {
                                                throw new IOException(moduleContentLocation + ", " + resourceName, ioe);
                                            }
                                        }

                                        public String getFileName() {
                                            return resourceName;
                                        }

                                        public long lastModified() {
                                            return uc.getLastModified();
                                        }
                                    };
                                }
                                catch (IOException ioe) {
                                }
                            }
                            return null;
                        }
                        catch (Exception e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                };
                this.setIClassLoader(new ResourceFinderIClassLoader(new MultiResourceFinder(Arrays.asList(new ResourceFinder[]{rf, new JarDirectoriesResourceFinder(this.extensionDirectories), new PathResourceFinder(this.classPath)})), null));
            }
        }
    }

    public abstract void setIClassLoader(IClassLoader var1);

    public void setCompileErrorHandler(@Nullable ErrorHandler compileErrorHandler) {
        this.compileErrorHandler = compileErrorHandler;
    }

    public void setWarningHandler(@Nullable WarningHandler warningHandler) {
        this.warningHandler = warningHandler;
    }
}

