/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ColumnWriter;
import org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.recordlevel.FilteringRecordMaterializer;
import org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicateBuilder;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.EmptyRecordReader;
import org.apache.parquet.io.FilteredRecordReader;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.io.RecordConsumerLoggingWrapper;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.RecordReaderImplementation;
import org.apache.parquet.io.ValidatingRecordConsumer;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.apache.parquet.it.unimi.dsi.fastutil.ints.IntListIterator;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageColumnIO
extends GroupColumnIO {
    private static final Logger LOG = LoggerFactory.getLogger(MessageColumnIO.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private List<PrimitiveColumnIO> leaves;
    private final boolean validating;
    private final String createdBy;

    MessageColumnIO(MessageType messageType, boolean validating, String createdBy) {
        super(messageType, null, 0);
        this.validating = validating;
        this.createdBy = createdBy;
    }

    @Override
    public List<String[]> getColumnNames() {
        return super.getColumnNames();
    }

    public <T> RecordReader<T> getRecordReader(PageReadStore columns, RecordMaterializer<T> recordMaterializer) {
        return this.getRecordReader(columns, recordMaterializer, FilterCompat.NOOP);
    }

    @Deprecated
    public <T> RecordReader<T> getRecordReader(PageReadStore columns, RecordMaterializer<T> recordMaterializer, UnboundRecordFilter filter) {
        return this.getRecordReader(columns, recordMaterializer, FilterCompat.get(filter));
    }

    public <T> RecordReader<T> getRecordReader(final PageReadStore columns, final RecordMaterializer<T> recordMaterializer, FilterCompat.Filter filter) {
        Preconditions.checkNotNull((Object)columns, (String)"columns");
        Preconditions.checkNotNull(recordMaterializer, (String)"recordMaterializer");
        Preconditions.checkNotNull((Object)filter, (String)"filter");
        if (this.leaves.isEmpty()) {
            return new EmptyRecordReader<T>(recordMaterializer);
        }
        return (RecordReader)filter.accept(new FilterCompat.Visitor<RecordReader<T>>(){

            @Override
            public RecordReader<T> visit(FilterCompat.FilterPredicateCompat filterPredicateCompat) {
                FilterPredicate predicate = filterPredicateCompat.getFilterPredicate();
                IncrementallyUpdatedFilterPredicateBuilder builder = new IncrementallyUpdatedFilterPredicateBuilder(MessageColumnIO.this.leaves);
                IncrementallyUpdatedFilterPredicate streamingPredicate = builder.build(predicate);
                FilteringRecordMaterializer filteringRecordMaterializer = new FilteringRecordMaterializer(recordMaterializer, MessageColumnIO.this.leaves, builder.getValueInspectorsByColumn(), streamingPredicate);
                return new RecordReaderImplementation(MessageColumnIO.this, filteringRecordMaterializer, MessageColumnIO.this.validating, new ColumnReadStoreImpl(columns, ((RecordMaterializer)filteringRecordMaterializer).getRootConverter(), MessageColumnIO.this.getType(), MessageColumnIO.this.createdBy));
            }

            @Override
            public RecordReader<T> visit(FilterCompat.UnboundRecordFilterCompat unboundRecordFilterCompat) {
                return new FilteredRecordReader(MessageColumnIO.this, recordMaterializer, MessageColumnIO.this.validating, new ColumnReadStoreImpl(columns, recordMaterializer.getRootConverter(), MessageColumnIO.this.getType(), MessageColumnIO.this.createdBy), unboundRecordFilterCompat.getUnboundRecordFilter(), columns.getRowCount());
            }

            @Override
            public RecordReader<T> visit(FilterCompat.NoOpFilter noOpFilter) {
                return new RecordReaderImplementation(MessageColumnIO.this, recordMaterializer, MessageColumnIO.this.validating, new ColumnReadStoreImpl(columns, recordMaterializer.getRootConverter(), MessageColumnIO.this.getType(), MessageColumnIO.this.createdBy));
            }
        });
    }

    public RecordConsumer getRecordWriter(ColumnWriteStore columns) {
        RecordConsumer recordWriter = new MessageColumnIORecordConsumer(columns);
        if (DEBUG) {
            recordWriter = new RecordConsumerLoggingWrapper(recordWriter);
        }
        return this.validating ? new ValidatingRecordConsumer(recordWriter, this.getType()) : recordWriter;
    }

    void setLevels() {
        this.setLevels(0, 0, new String[0], new int[0], Arrays.asList(this), Arrays.asList(this));
    }

    void setLeaves(List<PrimitiveColumnIO> leaves) {
        this.leaves = leaves;
    }

    public List<PrimitiveColumnIO> getLeaves() {
        return this.leaves;
    }

    @Override
    public MessageType getType() {
        return (MessageType)super.getType();
    }

    private class MessageColumnIORecordConsumer
    extends RecordConsumer {
        private ColumnIO currentColumnIO;
        private int currentLevel = 0;
        private final FieldsMarker[] fieldsWritten;
        private final int[] r;
        private final ColumnWriter[] columnWriter;
        private Map<GroupColumnIO, List<ColumnWriter>> groupToLeafWriter = new HashMap<GroupColumnIO, List<ColumnWriter>>();
        private Map<GroupColumnIO, IntArrayList> groupNullCache = new HashMap<GroupColumnIO, IntArrayList>();
        private final ColumnWriteStore columns;
        private boolean emptyField = true;

        private void buildGroupToLeafWriterMap(PrimitiveColumnIO primitive, ColumnWriter writer) {
            GroupColumnIO parent = primitive.getParent();
            do {
                this.getLeafWriters(parent).add(writer);
            } while ((parent = parent.getParent()) != null);
        }

        private List<ColumnWriter> getLeafWriters(GroupColumnIO group) {
            List<ColumnWriter> writers = this.groupToLeafWriter.get(group);
            if (writers == null) {
                writers = new ArrayList<ColumnWriter>();
                this.groupToLeafWriter.put(group, writers);
            }
            return writers;
        }

        public MessageColumnIORecordConsumer(ColumnWriteStore columns) {
            this.columns = columns;
            int maxDepth = 0;
            this.columnWriter = new ColumnWriter[MessageColumnIO.this.getLeaves().size()];
            for (PrimitiveColumnIO primitiveColumnIO : MessageColumnIO.this.getLeaves()) {
                ColumnWriter w = columns.getColumnWriter(primitiveColumnIO.getColumnDescriptor());
                maxDepth = Math.max(maxDepth, primitiveColumnIO.getFieldPath().length);
                this.columnWriter[primitiveColumnIO.getId()] = w;
                this.buildGroupToLeafWriterMap(primitiveColumnIO, w);
            }
            this.fieldsWritten = new FieldsMarker[maxDepth];
            for (int i = 0; i < maxDepth; ++i) {
                this.fieldsWritten[i] = new FieldsMarker();
            }
            this.r = new int[maxDepth];
        }

        private void printState() {
            if (DEBUG) {
                this.log(this.currentLevel + ", " + this.fieldsWritten[this.currentLevel] + ": " + Arrays.toString(this.currentColumnIO.getFieldPath()) + " r:" + this.r[this.currentLevel], new Object[0]);
                if (this.r[this.currentLevel] > this.currentColumnIO.getRepetitionLevel()) {
                    throw new InvalidRecordException(this.r[this.currentLevel] + "(r) > " + this.currentColumnIO.getRepetitionLevel() + " ( schema r)");
                }
            }
        }

        private void log(Object message, Object ... parameters) {
            if (DEBUG) {
                String indent = "";
                for (int i = 0; i < this.currentLevel; ++i) {
                    indent = indent + "  ";
                }
                LOG.debug(indent + message, parameters);
            }
        }

        @Override
        public void startMessage() {
            if (DEBUG) {
                this.log("< MESSAGE START >", new Object[0]);
            }
            this.currentColumnIO = MessageColumnIO.this;
            this.r[0] = 0;
            int numberOfFieldsToVisit = ((GroupColumnIO)this.currentColumnIO).getChildrenCount();
            this.fieldsWritten[0].reset(numberOfFieldsToVisit);
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void endMessage() {
            this.writeNullForMissingFieldsAtCurrentLevel();
            this.columns.endRecord();
            if (DEBUG) {
                this.log("< MESSAGE END >", new Object[0]);
            }
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void startField(String field, int index) {
            try {
                if (DEBUG) {
                    this.log("startField({}, {})", field, index);
                }
                this.currentColumnIO = ((GroupColumnIO)this.currentColumnIO).getChild(index);
                this.emptyField = true;
                if (DEBUG) {
                    this.printState();
                }
            }
            catch (RuntimeException e) {
                throw new ParquetEncodingException("error starting field " + field + " at " + index, e);
            }
        }

        @Override
        public void endField(String field, int index) {
            if (DEBUG) {
                this.log("endField({}, {})", field, index);
            }
            this.currentColumnIO = this.currentColumnIO.getParent();
            if (this.emptyField) {
                throw new ParquetEncodingException("empty fields are illegal, the field should be ommited completely instead");
            }
            this.fieldsWritten[this.currentLevel].markWritten(index);
            int n = this.r[this.currentLevel] = this.currentLevel == 0 ? 0 : this.r[this.currentLevel - 1];
            if (DEBUG) {
                this.printState();
            }
        }

        private void writeNullForMissingFieldsAtCurrentLevel() {
            int currentFieldsCount = ((GroupColumnIO)this.currentColumnIO).getChildrenCount();
            for (int i = 0; i < currentFieldsCount; ++i) {
                if (this.fieldsWritten[this.currentLevel].isWritten(i)) continue;
                try {
                    ColumnIO undefinedField = ((GroupColumnIO)this.currentColumnIO).getChild(i);
                    int d = this.currentColumnIO.getDefinitionLevel();
                    if (DEBUG) {
                        this.log(Arrays.toString(undefinedField.getFieldPath()) + ".writeNull(" + this.r[this.currentLevel] + "," + d + ")", new Object[0]);
                    }
                    this.writeNull(undefinedField, this.r[this.currentLevel], d);
                    continue;
                }
                catch (RuntimeException e) {
                    throw new ParquetEncodingException("error while writing nulls for fields of indexes " + i + " . current index: " + this.fieldsWritten[this.currentLevel], e);
                }
            }
        }

        private void writeNull(ColumnIO undefinedField, int r, int d) {
            if (undefinedField.getType().isPrimitive()) {
                this.columnWriter[((PrimitiveColumnIO)undefinedField).getId()].writeNull(r, d);
            } else {
                GroupColumnIO groupColumnIO = (GroupColumnIO)undefinedField;
                this.cacheNullForGroup(groupColumnIO, r);
            }
        }

        private void cacheNullForGroup(GroupColumnIO group, int r) {
            IntArrayList nulls = this.groupNullCache.get(group);
            if (nulls == null) {
                nulls = new IntArrayList();
                this.groupNullCache.put(group, nulls);
            }
            nulls.add(r);
        }

        private void writeNullToLeaves(GroupColumnIO group) {
            IntArrayList nullCache = this.groupNullCache.get(group);
            if (nullCache == null || nullCache.isEmpty()) {
                return;
            }
            int parentDefinitionLevel = group.getParent().getDefinitionLevel();
            for (ColumnWriter leafWriter : this.groupToLeafWriter.get(group)) {
                IntListIterator iter = nullCache.iterator();
                while (iter.hasNext()) {
                    int repetitionLevel = iter.nextInt();
                    leafWriter.writeNull(repetitionLevel, parentDefinitionLevel);
                }
            }
            nullCache.clear();
        }

        private void setRepetitionLevel() {
            this.r[this.currentLevel] = this.currentColumnIO.getRepetitionLevel();
            if (DEBUG) {
                this.log("r: {}", this.r[this.currentLevel]);
            }
        }

        @Override
        public void startGroup() {
            GroupColumnIO group;
            if (DEBUG) {
                this.log("startGroup()", new Object[0]);
            }
            if (this.hasNullCache(group = (GroupColumnIO)this.currentColumnIO)) {
                this.flushCachedNulls(group);
            }
            ++this.currentLevel;
            this.r[this.currentLevel] = this.r[this.currentLevel - 1];
            int fieldsCount = ((GroupColumnIO)this.currentColumnIO).getChildrenCount();
            this.fieldsWritten[this.currentLevel].reset(fieldsCount);
            if (DEBUG) {
                this.printState();
            }
        }

        private boolean hasNullCache(GroupColumnIO group) {
            IntArrayList nulls = this.groupNullCache.get(group);
            return nulls != null && !nulls.isEmpty();
        }

        private void flushCachedNulls(GroupColumnIO group) {
            for (int i = 0; i < group.getChildrenCount(); ++i) {
                ColumnIO child = group.getChild(i);
                if (!(child instanceof GroupColumnIO)) continue;
                this.flushCachedNulls((GroupColumnIO)child);
            }
            this.writeNullToLeaves(group);
        }

        @Override
        public void endGroup() {
            if (DEBUG) {
                this.log("endGroup()", new Object[0]);
            }
            this.emptyField = false;
            this.writeNullForMissingFieldsAtCurrentLevel();
            --this.currentLevel;
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        private ColumnWriter getColumnWriter() {
            return this.columnWriter[((PrimitiveColumnIO)this.currentColumnIO).getId()];
        }

        @Override
        public void addInteger(int value) {
            if (DEBUG) {
                this.log("addInt({})", value);
            }
            this.emptyField = false;
            this.getColumnWriter().write(value, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addLong(long value) {
            if (DEBUG) {
                this.log("addLong({})", value);
            }
            this.emptyField = false;
            this.getColumnWriter().write(value, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addBoolean(boolean value) {
            if (DEBUG) {
                this.log("addBoolean({})", value);
            }
            this.emptyField = false;
            this.getColumnWriter().write(value, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addBinary(Binary value) {
            if (DEBUG) {
                this.log("addBinary({} bytes)", value.length());
            }
            this.emptyField = false;
            this.getColumnWriter().write(value, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addFloat(float value) {
            if (DEBUG) {
                this.log("addFloat({})", Float.valueOf(value));
            }
            this.emptyField = false;
            this.getColumnWriter().write(value, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addDouble(double value) {
            if (DEBUG) {
                this.log("addDouble({})", value);
            }
            this.emptyField = false;
            this.getColumnWriter().write(value, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void flush() {
            this.flushCachedNulls(MessageColumnIO.this);
        }

        private class FieldsMarker {
            private BitSet vistedIndexes = new BitSet();

            private FieldsMarker() {
            }

            public String toString() {
                return "VistedIndex{vistedIndexes=" + this.vistedIndexes + '}';
            }

            public void reset(int fieldsCount) {
                this.vistedIndexes.clear(0, fieldsCount);
            }

            public void markWritten(int i) {
                this.vistedIndexes.set(i);
            }

            public boolean isWritten(int i) {
                return this.vistedIndexes.get(i);
            }
        }
    }
}

