/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rex.RexLiteral;

public abstract class PruneEmptyRules {
    public static final RelOptRule UNION_INSTANCE = new RelOptRule(RelOptRule.operand(LogicalUnion.class, RelOptRule.unordered(RelOptRule.operand(Values.class, null, Values.IS_EMPTY, RelOptRule.none()), new RelOptRuleOperand[0])), "Union"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            RelNode newRel;
            LogicalUnion union = (LogicalUnion)call.rel(0);
            List<RelNode> childRels = call.getChildRels(union);
            ArrayList<RelNode> newChildRels = new ArrayList<RelNode>();
            for (RelNode childRel : childRels) {
                if (PruneEmptyRules.isEmpty(childRel)) continue;
                newChildRels.add(childRel);
            }
            assert (newChildRels.size() < childRels.size()) : "planner promised us at least one Empty child";
            switch (newChildRels.size()) {
                case 0: {
                    newRel = PruneEmptyRules.empty(union);
                    break;
                }
                case 1: {
                    newRel = RelOptUtil.createCastRel((RelNode)newChildRels.get(0), union.getRowType(), true);
                    break;
                }
                default: {
                    newRel = LogicalUnion.create(newChildRels, union.all);
                }
            }
            call.transformTo(newRel);
        }
    };
    public static final RelOptRule PROJECT_INSTANCE = new RemoveEmptySingleRule(Project.class, "PruneEmptyProject");
    public static final RelOptRule FILTER_INSTANCE = new RemoveEmptySingleRule(Filter.class, "PruneEmptyFilter");
    public static final RelOptRule SORT_INSTANCE = new RemoveEmptySingleRule(Sort.class, "PruneEmptySort");
    public static final RelOptRule SORT_FETCH_ZERO_INSTANCE = new RelOptRule(RelOptRule.operand(Sort.class, RelOptRule.any()), "PruneSortLimit0"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            if (sort.fetch != null && RexLiteral.intValue(sort.fetch) == 0) {
                call.transformTo(PruneEmptyRules.empty(sort));
            }
        }
    };
    public static final RelOptRule AGGREGATE_INSTANCE = new RemoveEmptySingleRule(Aggregate.class, "PruneEmptyAggregate");
    public static final RelOptRule JOIN_LEFT_INSTANCE = new RelOptRule(RelOptRule.operand(Join.class, RelOptRule.some(RelOptRule.operand(Values.class, null, Values.IS_EMPTY, RelOptRule.none()), RelOptRule.operand(RelNode.class, RelOptRule.any()))), "PruneEmptyJoin(left)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            if (join.getJoinType().generatesNullsOnLeft()) {
                return;
            }
            call.transformTo(PruneEmptyRules.empty(join));
        }
    };
    public static final RelOptRule JOIN_RIGHT_INSTANCE = new RelOptRule(RelOptRule.operand(Join.class, RelOptRule.some(RelOptRule.operand(RelNode.class, RelOptRule.any()), RelOptRule.operand(Values.class, null, Values.IS_EMPTY, RelOptRule.none()))), "PruneEmptyJoin(right)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            if (join.getJoinType().generatesNullsOnRight()) {
                return;
            }
            call.transformTo(PruneEmptyRules.empty(join));
        }
    };

    private static boolean isEmpty(RelNode node) {
        return node instanceof Values && ((Values)node).getTuples().isEmpty();
    }

    private static Values empty(RelNode node) {
        return LogicalValues.createEmpty(node.getCluster(), node.getRowType());
    }

    private static class RemoveEmptySingleRule
    extends RelOptRule {
        public RemoveEmptySingleRule(Class<? extends SingleRel> clazz, String description) {
            super(RemoveEmptySingleRule.operand(clazz, RemoveEmptySingleRule.operand(Values.class, null, Values.IS_EMPTY, RemoveEmptySingleRule.none()), new RelOptRuleOperand[0]), description);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            SingleRel single = (SingleRel)call.rel(0);
            call.transformTo(PruneEmptyRules.empty(single));
        }
    }
}

