/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;

public class PersistenceFileMetaData
extends MetaData {
    protected String filename = null;
    protected HashSet<PersistenceUnitMetaData> persistenceUnits = new HashSet();

    public PersistenceFileMetaData(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getNoOfPersistenceUnits() {
        return this.persistenceUnits.size();
    }

    public PersistenceUnitMetaData getPersistenceUnit(String name) {
        for (PersistenceUnitMetaData p : this.persistenceUnits) {
            if (!p.name.equals(name)) continue;
            return p;
        }
        return null;
    }

    public PersistenceUnitMetaData[] getPersistenceUnits() {
        if (this.persistenceUnits.size() == 0) {
            return null;
        }
        return this.persistenceUnits.toArray(new PersistenceUnitMetaData[this.persistenceUnits.size()]);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void addPersistenceUnit(PersistenceUnitMetaData pumd) {
        if (pumd == null) {
            return;
        }
        pumd.parent = this;
        for (PersistenceUnitMetaData p : this.persistenceUnits) {
            if (!pumd.getName().equals(p.getName())) continue;
            return;
        }
        this.persistenceUnits.add(pumd);
    }

    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<persistence>\n");
        Iterator<PersistenceUnitMetaData> iter = this.persistenceUnits.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString(indent, indent));
        }
        sb.append("</persistence>");
        return sb.toString();
    }
}

