/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.HasId;
import org.spark_project.dmg.pmml.Indexable;
import org.spark_project.dmg.pmml.ItemRef;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "itemRefs"})
@XmlRootElement(name="Itemset", namespace="http://www.dmg.org/PMML-4_2")
public class Itemset
extends PMMLObject
implements HasExtensions,
HasId,
Indexable<String> {
    @XmlAttribute(name="id", required=true)
    private String id;
    @XmlAttribute(name="support")
    private Double support;
    @XmlAttribute(name="numberOfItems")
    private Integer numberOfItems;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="ItemRef", namespace="http://www.dmg.org/PMML-4_2")
    private List<ItemRef> itemRefs;

    public Itemset() {
    }

    public Itemset(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Itemset setId(String id) {
        this.id = id;
        return this;
    }

    public Double getSupport() {
        return this.support;
    }

    public Itemset setSupport(Double support) {
        this.support = support;
        return this;
    }

    public Integer getNumberOfItems() {
        return this.numberOfItems;
    }

    public Itemset setNumberOfItems(Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<ItemRef> getItemRefs() {
        if (this.itemRefs == null) {
            this.itemRefs = new ArrayList<ItemRef>();
        }
        return this.itemRefs;
    }

    @Override
    public String getKey() {
        return this.getId();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public Itemset addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasItemRefs() {
        return this.itemRefs != null && this.itemRefs.size() > 0;
    }

    public Itemset addItemRefs(ItemRef ... itemRefs) {
        this.getItemRefs().addAll(Arrays.asList(itemRefs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasItemRefs()) {
                status = PMMLObject.traverse(visitor, this.getItemRefs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

