/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001I4Q!\u0001\u0002\u0001\u0005)\u0011QbQ8oi\u0016DHoV1ji\u0016\u0014(BA\u0002\u0005\u0003%\u0019HO]3b[&twM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\t\u00011\u0002\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006%\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0004\u0019\u0001\t\u0007I\u0011B\r\u0002\t1|7m[\u000b\u00025A\u00111\u0004J\u0007\u00029)\u0011QDH\u0001\u0006Y>\u001c7n\u001d\u0006\u0003?\u0001\n!bY8oGV\u0014(/\u001a8u\u0015\t\t#%\u0001\u0003vi&d'\"A\u0012\u0002\t)\fg/Y\u0005\u0003Kq\u0011QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0007BB\u0014\u0001A\u0003%!$A\u0003m_\u000e\\\u0007\u0005C\u0004*\u0001\t\u0007I\u0011\u0002\u0016\u0002\u0013\r|g\u000eZ5uS>tW#A\u0016\u0011\u0005ma\u0013BA\u0017\u001d\u0005%\u0019uN\u001c3ji&|g\u000e\u0003\u00040\u0001\u0001\u0006IaK\u0001\u000bG>tG-\u001b;j_:\u0004\u0003bB\u0019\u0001\u0001\u0004%IAM\u0001\u0006KJ\u0014xN]\u000b\u0002gA\u0011A\u0007\u0010\b\u0003kir!AN\u001d\u000e\u0003]R!\u0001O\n\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0011BA\u001e\u000e\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0010 \u0003\u0013QC'o\\<bE2,'BA\u001e\u000e\u0011\u001d\u0001\u0005\u00011A\u0005\n\u0005\u000b\u0011\"\u001a:s_J|F%Z9\u0015\u0005\t+\u0005C\u0001\u0007D\u0013\t!UB\u0001\u0003V]&$\bb\u0002$@\u0003\u0003\u0005\raM\u0001\u0004q\u0012\n\u0004B\u0002%\u0001A\u0003&1'\u0001\u0004feJ|'\u000f\t\u0005\b\u0015\u0002\u0001\r\u0011\"\u0003L\u0003\u001d\u0019Ho\u001c9qK\u0012,\u0012\u0001\u0014\t\u0003\u00195K!AT\u0007\u0003\u000f\t{w\u000e\\3b]\"9\u0001\u000b\u0001a\u0001\n\u0013\t\u0016aC:u_B\u0004X\rZ0%KF$\"A\u0011*\t\u000f\u0019{\u0015\u0011!a\u0001\u0019\"1A\u000b\u0001Q!\n1\u000b\u0001b\u001d;paB,G\r\t\u0005\u0006-\u0002!\taV\u0001\f]>$\u0018NZ=FeJ|'\u000f\u0006\u0002C1\")\u0011,\u0016a\u0001g\u0005\tQ\rC\u0003\\\u0001\u0011\u0005A,\u0001\u0006o_RLg-_*u_B$\u0012A\u0011\u0005\u0006=\u0002!\taX\u0001\u0013o\u0006LGOR8s'R|\u0007o\u0014:FeJ|'\u000f\u0006\u0002MA\"9\u0011-\u0018I\u0001\u0002\u0004\u0011\u0017a\u0002;j[\u0016|W\u000f\u001e\t\u0003\u0019\rL!\u0001Z\u0007\u0003\t1{gn\u001a\u0005\bM\u0002\t\n\u0011\"\u0001h\u0003q9\u0018-\u001b;G_J\u001cFo\u001c9Pe\u0016\u0013(o\u001c:%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001b\u0016\u0003E&\\\u0013A\u001b\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005=l\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011\u000f\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ContextWaiter {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock().newCondition();
    private Throwable error = null;
    private boolean stopped = false;

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition condition() {
        return this.condition;
    }

    private Throwable error() {
        return this.error;
    }

    private void error_$eq(Throwable x$1) {
        this.error = x$1;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public void notifyError(Throwable e) {
        this.lock().lock();
        try {
            this.error_$eq(e);
            this.condition().signalAll();
            return;
        }
        finally {
            this.lock().unlock();
        }
    }

    public void notifyStop() {
        this.lock().lock();
        try {
            this.stopped_$eq(true);
            this.condition().signalAll();
            return;
        }
        finally {
            this.lock().unlock();
        }
    }

    public boolean waitForStopOrError(long timeout) {
        this.lock().lock();
        try {
            if (timeout < 0L) {
                while (!this.stopped() && this.error() == null) {
                    this.condition().await();
                }
            } else {
                long nanos = TimeUnit.MILLISECONDS.toNanos(timeout);
                while (!this.stopped() && this.error() == null && nanos > 0L) {
                    nanos = this.condition().awaitNanos(nanos);
                }
            }
            if (this.error() == null) {
                return this.stopped();
            }
            throw this.error();
        }
        finally {
            this.lock().unlock();
        }
    }

    public long waitForStopOrError$default$1() {
        return -1L;
    }
}

