/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import org.apache.spark.annotation.Private;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.spark_project.guava.base.Preconditions;

@Private
public abstract class KVStoreView<T>
implements Iterable<T> {
    boolean ascending = true;
    String index = "__main__";
    Object first = null;
    Object last = null;
    Object parent = null;
    long skip = 0L;
    long max = Long.MAX_VALUE;

    public KVStoreView<T> reverse() {
        this.ascending = !this.ascending;
        return this;
    }

    public KVStoreView<T> index(String name) {
        this.index = (String)Preconditions.checkNotNull((Object)name);
        return this;
    }

    public KVStoreView<T> parent(Object value) {
        this.parent = value;
        return this;
    }

    public KVStoreView<T> first(Object value) {
        this.first = value;
        return this;
    }

    public KVStoreView<T> last(Object value) {
        this.last = value;
        return this;
    }

    public KVStoreView<T> max(long max) {
        Preconditions.checkArgument((max > 0L ? 1 : 0) != 0, (Object)"max must be positive.");
        this.max = max;
        return this;
    }

    public KVStoreView<T> skip(long n) {
        this.skip = n;
        return this;
    }

    public KVStoreIterator<T> closeableIterator() throws Exception {
        return (KVStoreIterator)this.iterator();
    }
}

