/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper$class;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001f\tI\u0012j]89mA\nD+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0015\t\u0019A!\u0001\u0003vi&d'BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011-i\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u0019\u001b\u0005\u0011\u0011BA\r\u0003\u0005I!\u0016.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:\u0011\u0005]Y\u0012B\u0001\u000f\u0003\u0005]!\u0015\r^3US6,gi\u001c:nCR$XM\u001d%fYB,'\u000f\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0003\u001d\u0001\u0018\r\u001e;fe:\u0004\"\u0001I\u0012\u000f\u0005E\t\u0013B\u0001\u0012\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u0012\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u0011QLW.\u001a.p]\u0016\u0004\"!K\u0017\u000e\u0003)R!aA\u0016\u000b\u00031\nAA[1wC&\u0011aF\u000b\u0002\t)&lWMW8oK\"A\u0001\u0007\u0001B\u0001B\u0003%\u0011'\u0001\u0004m_\u000e\fG.\u001a\t\u0003SIJ!a\r\u0016\u0003\r1{7-\u00197f\u0011\u0015)\u0004\u0001\"\u00017\u0003\u0019a\u0014N\\5u}Q!q\u0007O\u001d;!\t9\u0002\u0001C\u0003\u001fi\u0001\u0007q\u0004C\u0003(i\u0001\u0007\u0001\u0006C\u00031i\u0001\u0007\u0011\u0007\u0003\u0005=\u0001!\u0015\r\u0011\"\u0003>\u0003%1wN]7biR,'/F\u0001?!\tyD)D\u0001A\u0015\t\t%)\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003\u0007.\nA\u0001^5nK&\u0011Q\t\u0011\u0002\u0012\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\b\u0002C$\u0001\u0011\u0003\u0005\u000b\u0015\u0002 \u0002\u0015\u0019|'/\\1ui\u0016\u0014\b\u0005\u000b\u0002G\u0013B\u0011\u0011CS\u0005\u0003\u0017J\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000b5\u0003A\u0011\u0002(\u0002\u0013Q|\u0017J\\:uC:$HCA(T!\t\u0001\u0016+D\u0001C\u0013\t\u0011&IA\u0004J]N$\u0018M\u001c;\t\u000bQc\u0005\u0019A\u0010\u0002\u0003MDQA\u0016\u0001\u0005B]\u000bQ\u0001]1sg\u0016$\"\u0001W.\u0011\u0005EI\u0016B\u0001.\u0013\u0005\u0011auN\\4\t\u000bQ+\u0006\u0019A\u0010\t\u000b\u0005\u0003A\u0011I/\u0015\u0005}q\u0006\"B0]\u0001\u0004A\u0016AA;t\u0001")
public class Iso8601TimestampFormatter
implements TimestampFormatter,
DateTimeFormatterHelper {
    private final String pattern;
    private final TimeZone timeZone;
    private final Locale locale;
    private transient DateTimeFormatter formatter;
    private volatile transient boolean bitmap$trans$0;

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if (!this.bitmap$trans$0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale);
                this.bitmap$trans$0 = true;
            }
            return this.formatter;
        }
    }

    @Override
    public Instant toInstantWithZoneId(TemporalAccessor temporalAccessor, ZoneId zoneId) {
        return DateTimeFormatterHelper$class.toInstantWithZoneId(this, temporalAccessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale) {
        return DateTimeFormatterHelper$class.getOrCreateFormatter(this, pattern, locale);
    }

    private DateTimeFormatter formatter() {
        return this.bitmap$trans$0 ? this.formatter : this.formatter$lzycompute();
    }

    private Instant toInstant(String s) {
        TemporalAccessor temporalAccessor = this.formatter().parse(s);
        return temporalAccessor.query(TemporalQueries.offset()) == null ? this.toInstantWithZoneId(temporalAccessor, this.timeZone.toZoneId()) : Instant.from(temporalAccessor);
    }

    @Override
    public long parse(String s) {
        return DateTimeUtils$.MODULE$.instantToMicros(this.toInstant(s));
    }

    @Override
    public String format(long us) {
        long secs = Math.floorDiv(us, 1000000L);
        long mos = Math.floorMod(us, 1000000L);
        Instant instant = Instant.ofEpochSecond(secs, mos * 1000L);
        return this.formatter().withZone(this.timeZone.toZoneId()).format(instant);
    }

    public Iso8601TimestampFormatter(String pattern, TimeZone timeZone, Locale locale) {
        this.pattern = pattern;
        this.timeZone = timeZone;
        this.locale = locale;
        DateTimeFormatterHelper$class.$init$(this);
    }
}

