/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringRepeat$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, n) - Returns the string which repeats the given string value n times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       123123\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001>\u0011Ab\u0015;sS:<'+\u001a9fCRT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001A!r#\b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005E)\u0012B\u0001\f\u0003\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"a\u0002)s_\u0012,8\r\u001e\t\u00031yI!aH\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0005\u0002!Q3A\u0005\u0002\t\n1a\u001d;s+\u0005\u0019\u0003CA\t%\u0013\t)#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0005gR\u0014\b\u0005\u0003\u0005*\u0001\tU\r\u0011\"\u0001#\u0003\u0015!\u0018.\\3t\u0011!Y\u0003A!E!\u0002\u0013\u0019\u0013A\u0002;j[\u0016\u001c\b\u0005C\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0004_A\n\u0004CA\t\u0001\u0011\u0015\tC\u00061\u0001$\u0011\u0015IC\u00061\u0001$\u0011\u0015\u0019\u0004\u0001\"\u0011#\u0003\u0011aWM\u001a;\t\u000bU\u0002A\u0011\t\u0012\u0002\u000bILw\r\u001b;\t\u000b]\u0002A\u0011\t\u001d\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003y\u0019\tQ\u0001^=qKNL!AP\u001e\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ\u0001\u0011\u0001\u0005B\u0005\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0011\u0005cA\"Ls9\u0011A)\u0013\b\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f:\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005)K\u0012a\u00029bG.\fw-Z\u0005\u0003\u00196\u00131aU3r\u0015\tQ\u0015\u0004C\u0003P\u0001\u0011\u0005\u0003+\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002R)Z\u0003\"\u0001\u0007*\n\u0005MK\"aA!os\")QK\u0014a\u0001#\u000611\u000f\u001e:j]\u001eDQa\u0016(A\u0002E\u000b\u0011A\u001c\u0005\u00063\u0002!\tEW\u0001\u000baJ,G\u000f^=OC6,W#A.\u0011\u0005q{fB\u0001\r^\u0013\tq\u0016$\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0006\u0014aa\u0015;sS:<'B\u00010\u001a\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003%!wnR3o\u0007>$W\rF\u0002fWB\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u0002\u0002\u000f\r|G-Z4f]&\u0011!n\u001a\u0002\t\u000bb\u0004(oQ8eK\")AN\u0019a\u0001[\u0006\u00191\r\u001e=\u0011\u0005\u0019t\u0017BA8h\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ!\u001d2A\u0002\u0015\f!!\u001a<\t\u000fM\u0004\u0011\u0011!C\u0001i\u0006!1m\u001c9z)\rySO\u001e\u0005\bCI\u0004\n\u00111\u0001$\u0011\u001dI#\u000f%AA\u0002\rBq\u0001\u001f\u0001\u0012\u0002\u0013\u0005\u00110\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003iT#aI>,\u0003q\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007I\u0012AC1o]>$\u0018\r^5p]&\u0019\u0011q\u0001@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0005\u0002\f\u0001\t\n\u0011\"\u0001z\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"a\u0004\u0001\u0003\u0003%\t%!\u0005\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\t1\fgn\u001a\u0006\u0003\u0003;\tAA[1wC&\u0019\u0001-a\u0006\t\u0013\u0005\r\u0002!!A\u0005\u0002\u0005\u0015\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0014!\rA\u0012\u0011F\u0005\u0004\u0003WI\"aA%oi\"I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0011\u0011G\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\t\u00161\u0007\u0005\u000b\u0003k\ti#!AA\u0002\u0005\u001d\u0012a\u0001=%c!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00131H\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\b\t\u0006\u0003\u007f\t)%U\u0007\u0003\u0003\u0003R1!a\u0011\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\n\tE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tY\u0005AA\u0001\n\u0003\ti%\u0001\u0005dC:,\u0015/^1m)\u0011\ty%!\u0016\u0011\u0007a\t\t&C\u0002\u0002Te\u0011qAQ8pY\u0016\fg\u000eC\u0005\u00026\u0005%\u0013\u0011!a\u0001#\"I\u0011\u0011\f\u0001\u0002\u0002\u0013\u0005\u00131L\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005=\u0013Q\f\u0005\n\u0003k\t9&!AA\u0002ECs\u0002AA1\u0003O\nI'!\u001c\u0002p\u0005M\u0014Q\u000f\t\u0004#\u0005\r\u0014bAA3\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA6\u0003E{f)\u0016(D?\"\u001aHO\u001d\u0017!]&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043\u000f\u001e:j]\u001e\u0004s\u000f[5dQ\u0002\u0012X\r]3biN\u0004C\u000f[3!O&4XM\u001c\u0011tiJLgn\u001a\u0011wC2,X\r\t8!i&lWm\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u001d\u0002\u0001*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u001a4O1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cI\u001a\u0014GM\u001a\u000bA\u0001\nQa]5oG\u0016\f#!a\u001e\u0002\u000bErSG\f\u0019\b\u0013\u0005m$!!A\t\u0002\u0005u\u0014\u0001D*ue&twMU3qK\u0006$\bcA\t\u0002\u0000\u0019A\u0011AAA\u0001\u0012\u0003\t\tiE\u0003\u0002\u0000\u0005\rU\u0004E\u0004\u0002\u0006\u0006-5eI\u0018\u000e\u0005\u0005\u001d%bAAE3\u00059!/\u001e8uS6,\u0017\u0002BAG\u0003\u000f\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001di\u0013q\u0010C\u0001\u0003##\"!! \t\u0015\u0005U\u0015qPA\u0001\n\u000b\n9*\u0001\u0005u_N#(/\u001b8h)\t\t\u0019\u0002\u0003\u0006\u0002\u001c\u0006}\u0014\u0011!CA\u0003;\u000bQ!\u00199qYf$RaLAP\u0003CCa!IAM\u0001\u0004\u0019\u0003BB\u0015\u0002\u001a\u0002\u00071\u0005\u0003\u0006\u0002&\u0006}\u0014\u0011!CA\u0003O\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002*\u0006U\u0006#\u0002\r\u0002,\u0006=\u0016bAAW3\t1q\n\u001d;j_:\u0004R\u0001GAYG\rJ1!a-\u001a\u0005\u0019!V\u000f\u001d7fe!I\u0011qWAR\u0003\u0003\u0005\raL\u0001\u0004q\u0012\u0002\u0004BCA^\u0003\u007f\n\t\u0011\"\u0003\u0002>\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\f\u0005\u0003\u0002\u0016\u0005\u0005\u0017\u0002BAb\u0003/\u0011aa\u00142kK\u000e$\b")
public class StringRepeat
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression str;
    private final Expression times;

    public static Option<Tuple2<Expression, Expression>> unapply(StringRepeat stringRepeat) {
        return StringRepeat$.MODULE$.unapply(stringRepeat);
    }

    public static Function1<Tuple2<Expression, Expression>, StringRepeat> tupled() {
        return StringRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringRepeat>> curried() {
        return StringRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression times() {
        return this.times;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.times();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object string, Object n) {
        return ((UTF8String)string).repeat(Predef$.MODULE$.Integer2int((Integer)n));
    }

    @Override
    public String prettyName() {
        return "repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String l, String r) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ").repeat(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l, r}));
            }
        });
    }

    public StringRepeat copy(Expression str, Expression times) {
        return new StringRepeat(str, times);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.times();
    }

    @Override
    public String productPrefix() {
        return "StringRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.times();
                break;
            }
            case 0: {
                expression = this.str();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRepeat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRepeat stringRepeat = (StringRepeat)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRepeat.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.times();
        Expression expression4 = stringRepeat.times();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringRepeat.canEqual(this)) return false;
        return true;
    }

    public StringRepeat(Expression str, Expression times) {
        this.str = str;
        this.times = times;
        ExpectsInputTypes$class.$init$(this);
    }
}

