/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns the result of bitwise exclusive OR of `expr1` and `expr2`.", examples="\n    Examples:\n      > SELECT 3 _FUNC_ 5;\n       6\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u0001>\u0011!BQ5uo&\u001cX\rW8s\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011)i\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003!\tKg.\u0019:z\u0003JLG\u000f[7fi&\u001c\u0007CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"a\u0002)s_\u0012,8\r\u001e\t\u0003+mI!\u0001\b\f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011y\u0001!Q3A\u0005\u0002}\tA\u0001\\3giV\t\u0001\u0005\u0005\u0002\u0012C%\u0011!E\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u0013\u0001\u0005#\u0005\u000b\u0011\u0002\u0011\u0002\u000b1,g\r\u001e\u0011\t\u0011\u0019\u0002!Q3A\u0005\u0002}\tQA]5hQRD\u0001\u0002\u000b\u0001\u0003\u0012\u0003\u0006I\u0001I\u0001\u0007e&<\u0007\u000e\u001e\u0011\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\raSF\f\t\u0003#\u0001AQAH\u0015A\u0002\u0001BQAJ\u0015A\u0002\u0001BQ\u0001\r\u0001\u0005BE\n\u0011\"\u001b8qkR$\u0016\u0010]3\u0016\u0003I\u0002\"a\r\u001c\u000e\u0003QR!!\u000e\u0004\u0002\u000bQL\b/Z:\n\u0005]\"$\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015I\u0004\u0001\"\u0011;\u0003\u0019\u0019\u00180\u001c2pYV\t1\b\u0005\u0002=\u007f9\u0011Q#P\u0005\u0003}Y\ta\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011aH\u0006\u0005\t\u0007\u0002A)\u0019!C\u0005\t\u0006\u0019\u0001p\u001c:\u0016\u0003\u0015\u0003R!\u0006$I\u0011\"K!a\u0012\f\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004CA\u000bJ\u0013\tQeCA\u0002B]fD\u0001\u0002\u0014\u0001\t\u0002\u0003\u0006K!R\u0001\u0005q>\u0014\b\u0005C\u0003O\u0001\u0011Es*\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002I!JCQ!U'A\u0002!\u000ba!\u001b8qkR\f\u0004\"B*N\u0001\u0004A\u0015AB5oaV$(\u0007C\u0004V\u0001\u0005\u0005I\u0011\u0001,\u0002\t\r|\u0007/\u001f\u000b\u0004Y]C\u0006b\u0002\u0010U!\u0003\u0005\r\u0001\t\u0005\bMQ\u0003\n\u00111\u0001!\u0011\u001dQ\u0006!%A\u0005\u0002m\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001]U\t\u0001SlK\u0001_!\tyF-D\u0001a\u0015\t\t'-A\u0005v]\u000eDWmY6fI*\u00111MF\u0001\u000bC:tw\u000e^1uS>t\u0017BA3a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\bO\u0002\t\n\u0011\"\u0001\\\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIBq!\u001b\u0001\u0002\u0002\u0013\u0005#.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\u0005Y\u0006twMC\u0001q\u0003\u0011Q\u0017M^1\n\u0005\u0001k\u0007bB:\u0001\u0003\u0003%\t\u0001^\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002kB\u0011QC^\u0005\u0003oZ\u00111!\u00138u\u0011\u001dI\b!!A\u0005\u0002i\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002Iw\"9A\u0010_A\u0001\u0002\u0004)\u0018a\u0001=%c!9a\u0010AA\u0001\n\u0003z\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0001#BA\u0002\u0003\u0013AUBAA\u0003\u0015\r\t9AF\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0006\u0003\u000b\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u001f\u0001\u0011\u0011!C\u0001\u0003#\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003'\tI\u0002E\u0002\u0016\u0003+I1!a\u0006\u0017\u0005\u001d\u0011un\u001c7fC:D\u0001\u0002`A\u0007\u0003\u0003\u0005\r\u0001\u0013\u0005\n\u0003;\u0001\u0011\u0011!C!\u0003?\ta!Z9vC2\u001cH\u0003BA\n\u0003CA\u0001\u0002`A\u000e\u0003\u0003\u0005\r\u0001\u0013\u0015\f\u0001\u0005\u0015\u00121FA\u0017\u0003c\t\u0019\u0004E\u0002\u0012\u0003OI1!!\u000b\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\f\u0002/\u0016D\bO]\u0019!?\u001a+fjQ0!Kb\u0004(O\r\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011sKN,H\u000e\u001e\u0011pM\u0002\u0012\u0017\u000e^<jg\u0016\u0004S\r_2mkNLg/\u001a\u0011P%\u0002zg\r\t1fqB\u0014\u0018\u0007\u0019\u0011b]\u0012\u0004\u0003-\u001a=qeJ\u0002g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t)$A\u001b\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAM\u0002sLR+O\u0007~\u0003Sg\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00117\u0015\u0001\u0002s!CA\u001d\u0005\u0005\u0005\t\u0012AA\u001e\u0003)\u0011\u0015\u000e^<jg\u0016DvN\u001d\t\u0004#\u0005ub\u0001C\u0001\u0003\u0003\u0003E\t!a\u0010\u0014\u000b\u0005u\u0012\u0011\t\u000e\u0011\u000f\u0005\r\u0013\u0011\n\u0011!Y5\u0011\u0011Q\t\u0006\u0004\u0003\u000f2\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003\u0017\n)EA\tBEN$(/Y2u\rVt7\r^5p]JBqAKA\u001f\t\u0003\ty\u0005\u0006\u0002\u0002<!Q\u00111KA\u001f\u0003\u0003%)%!\u0016\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u001b\u0005\u000b\u00033\ni$!A\u0005\u0002\u0006m\u0013!B1qa2LH#\u0002\u0017\u0002^\u0005}\u0003B\u0002\u0010\u0002X\u0001\u0007\u0001\u0005\u0003\u0004'\u0003/\u0002\r\u0001\t\u0005\u000b\u0003G\ni$!A\u0005\u0002\u0006\u0015\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003O\n\u0019\bE\u0003\u0016\u0003S\ni'C\u0002\u0002lY\u0011aa\u00149uS>t\u0007#B\u000b\u0002p\u0001\u0002\u0013bAA9-\t1A+\u001e9mKJB\u0011\"!\u001e\u0002b\u0005\u0005\t\u0019\u0001\u0017\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002z\u0005u\u0012\u0011!C\u0005\u0003w\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0010\t\u0004Y\u0006}\u0014bAAA[\n1qJ\u00196fGR\u0004")
public class BitwiseXor
extends BinaryArithmetic
implements Serializable {
    private final Expression left;
    private final Expression right;
    private Function2<Object, Object, Object> xor;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(BitwiseXor bitwiseXor) {
        return BitwiseXor$.MODULE$.unapply(bitwiseXor);
    }

    public static Function1<Tuple2<Expression, Expression>, BitwiseXor> tupled() {
        return BitwiseXor$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, BitwiseXor>> curried() {
        return BitwiseXor$.MODULE$.curried();
    }

    private Function2 xor$lzycompute() {
        BitwiseXor bitwiseXor = this;
        synchronized (bitwiseXor) {
            DataType dataType2;
            block11: {
                if (!this.bitmap$0) {
                    Serializable serializable;
                    dataType2 = this.dataType();
                    if (ByteType$.MODULE$.equals(dataType2)) {
                        serializable = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final byte apply(byte evalE1, byte evalE2) {
                                return (byte)(evalE1 ^ evalE2);
                            }
                        };
                    } else if (ShortType$.MODULE$.equals(dataType2)) {
                        serializable = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final short apply(short evalE1, short evalE2) {
                                return (short)(evalE1 ^ evalE2);
                            }
                        };
                    } else if (IntegerType$.MODULE$.equals(dataType2)) {
                        serializable = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int evalE1, int evalE2) {
                                return this.apply$mcIII$sp(evalE1, evalE2);
                            }

                            public int apply$mcIII$sp(int evalE1, int evalE2) {
                                return evalE1 ^ evalE2;
                            }
                        };
                    } else {
                        if (!LongType$.MODULE$.equals(dataType2)) break block11;
                        serializable = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(long evalE1, long evalE2) {
                                return this.apply$mcJJJ$sp(evalE1, evalE2);
                            }

                            public long apply$mcJJJ$sp(long evalE1, long evalE2) {
                                return evalE1 ^ evalE2;
                            }
                        };
                    }
                    this.xor = serializable;
                    this.bitmap$0 = true;
                }
                return this.xor;
            }
            throw new MatchError((Object)dataType2);
        }
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public AbstractDataType inputType() {
        return IntegralType$.MODULE$;
    }

    @Override
    public String symbol() {
        return "^";
    }

    private Function2<Object, Object, Object> xor() {
        return this.bitmap$0 ? this.xor : this.xor$lzycompute();
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return this.xor().apply(input1, input2);
    }

    public BitwiseXor copy(Expression left, Expression right) {
        return new BitwiseXor(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "BitwiseXor";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitwiseXor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitwiseXor)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitwiseXor bitwiseXor = (BitwiseXor)x$1;
        Expression expression = this.left();
        Expression expression2 = bitwiseXor.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = bitwiseXor.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!bitwiseXor.canEqual(this)) return false;
        return true;
    }

    public BitwiseXor(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

