/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.io.UnsupportedEncodingException;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class StringSubstrColStart
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int startIdx;
    private int colNum;
    private int outputColumn;
    private static transient byte[] EMPTY_STRING;

    public StringSubstrColStart(int colNum, int startIdx, int outputColumn) {
        this();
        this.colNum = colNum;
        this.startIdx = startIdx >= 1 ? startIdx - 1 : (startIdx == 0 ? 0 : startIdx);
        this.outputColumn = outputColumn;
    }

    public StringSubstrColStart() {
    }

    static int getSubstrStartOffset(byte[] utf8String, int start, int len, int substrStart) {
        int i;
        int end = start + len;
        if (substrStart < 0) {
            int length = 0;
            for (i = start; i != end; ++i) {
                if ((utf8String[i] & 0xC0) == 128) continue;
                ++length;
            }
            if (-substrStart > length) {
                return -1;
            }
            substrStart = length + substrStart;
        }
        int curIdx = -1;
        for (i = start; i != end; ++i) {
            if ((utf8String[i] & 0xC0) == 128 || ++curIdx != substrStart) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inV = (BytesColumnVector)batch.cols[this.colNum];
        BytesColumnVector outV = (BytesColumnVector)batch.cols[this.outputColumn];
        int n = batch.size;
        if (n == 0) {
            return;
        }
        byte[][] vector = inV.vector;
        int[] sel = batch.selected;
        int[] len = inV.length;
        int[] start = inV.start;
        outV.initBuffer();
        if (inV.isRepeating) {
            outV.isRepeating = true;
            if (!inV.noNulls && inV.isNull[0]) {
                outV.isNull[0] = true;
                outV.noNulls = false;
                outV.setVal(0, EMPTY_STRING, 0, EMPTY_STRING.length);
                return;
            }
            outV.noNulls = true;
            int offset = StringSubstrColStart.getSubstrStartOffset(vector[0], start[0], len[0], this.startIdx);
            if (offset != -1) {
                outV.setVal(0, vector[0], offset, len[0] - (offset - start[0]));
            } else {
                outV.setVal(0, EMPTY_STRING, 0, EMPTY_STRING.length);
            }
        } else {
            outV.isRepeating = false;
            if (batch.selectedInUse) {
                if (!inV.noNulls) {
                    outV.noNulls = false;
                    for (int i = 0; i != n; ++i) {
                        int selected = sel[i];
                        if (!inV.isNull[selected]) {
                            int offset = StringSubstrColStart.getSubstrStartOffset(vector[selected], start[selected], len[selected], this.startIdx);
                            outV.isNull[selected] = false;
                            if (offset != -1) {
                                outV.setVal(selected, vector[selected], offset, len[selected] - (offset - start[selected]));
                                continue;
                            }
                            outV.setVal(selected, EMPTY_STRING, 0, EMPTY_STRING.length);
                            continue;
                        }
                        outV.isNull[selected] = true;
                    }
                } else {
                    outV.noNulls = true;
                    for (int i = 0; i != n; ++i) {
                        int selected = sel[i];
                        int offset = StringSubstrColStart.getSubstrStartOffset(vector[selected], start[selected], len[selected], this.startIdx);
                        if (offset != -1) {
                            outV.setVal(selected, vector[selected], offset, len[selected] - (offset - start[selected]));
                            continue;
                        }
                        outV.setVal(selected, EMPTY_STRING, 0, EMPTY_STRING.length);
                    }
                }
            } else if (!inV.noNulls) {
                outV.noNulls = false;
                System.arraycopy(inV.isNull, 0, outV.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inV.isNull[i]) continue;
                    int offset = StringSubstrColStart.getSubstrStartOffset(vector[i], start[i], len[i], this.startIdx);
                    if (offset != -1) {
                        outV.setVal(i, vector[i], offset, len[i] - (offset - start[i]));
                        continue;
                    }
                    outV.setVal(i, EMPTY_STRING, 0, EMPTY_STRING.length);
                }
            } else {
                outV.noNulls = true;
                for (int i = 0; i != n; ++i) {
                    int offset = StringSubstrColStart.getSubstrStartOffset(vector[i], start[i], len[i], this.startIdx);
                    if (offset != -1) {
                        outV.setVal(i, vector[i], offset, len[i] - (offset - start[i]));
                        continue;
                    }
                    outV.setVal(i, EMPTY_STRING, 0, EMPTY_STRING.length);
                }
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "string";
    }

    public int getStartIdx() {
        return this.startIdx;
    }

    public void setStartIdx(int startIdx) {
        this.startIdx = startIdx;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR);
        return b.build();
    }

    static {
        try {
            EMPTY_STRING = "".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

