/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.Collection;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRowDynBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinBaseOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class VectorMapJoinOuterFilteredOperator
extends VectorMapJoinBaseOperator {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private transient boolean firstBatch;
    private transient VectorExtractRowDynBatch vectorExtractRowDynBatch;
    protected transient Object[] singleRow;

    public VectorMapJoinOuterFilteredOperator() {
    }

    public VectorMapJoinOuterFilteredOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(vContext, conf);
        this.vContext = vContext;
    }

    @Override
    public Collection<Future<?>> initializeOp(Configuration hconf) throws HiveException {
        int posBigTable = ((MapJoinDesc)this.conf).getPosBigTable();
        this.inputObjInspectors[posBigTable] = VectorizedBatchUtil.convertToStandardStructObjectInspector((StructObjectInspector)this.inputObjInspectors[posBigTable]);
        Collection<Future<?>> result = super.initializeOp(hconf);
        this.firstBatch = true;
        return result;
    }

    @Override
    public void process(Object data, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)data;
        this.tag = tag;
        if (this.scratchBatch == null) {
            this.scratchBatch = VectorizedBatchUtil.makeLike(batch);
        }
        if (this.firstBatch) {
            this.vectorExtractRowDynBatch = new VectorExtractRowDynBatch();
            this.vectorExtractRowDynBatch.init((StructObjectInspector)this.inputObjInspectors[0], this.vContext.getProjectedColumns());
            this.singleRow = new Object[this.vectorExtractRowDynBatch.getCount()];
            this.firstBatch = false;
        }
        this.vectorExtractRowDynBatch.setBatchOnEntry(batch);
        if (batch.selectedInUse) {
            int[] selected = batch.selected;
            for (int logical = 0; logical < batch.size; ++logical) {
                int batchIndex = selected[logical];
                this.vectorExtractRowDynBatch.extractRow(batchIndex, this.singleRow);
                super.process(this.singleRow, tag);
            }
        } else {
            for (int batchIndex = 0; batchIndex < batch.size; ++batchIndex) {
                this.vectorExtractRowDynBatch.extractRow(batchIndex, this.singleRow);
                super.process(this.singleRow, tag);
            }
        }
        this.vectorExtractRowDynBatch.forgetBatchOnExit();
    }
}

