/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.ExprNodeGenericFuncEvaluator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.io.IOContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

public class FilterOperator
extends Operator<FilterDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient ExprNodeEvaluator conditionEvaluator;
    private transient PrimitiveObjectInspector conditionInspector;
    private transient int consecutiveSearches = 0;
    private transient IOContext ioContext;
    protected transient int heartbeatInterval;

    @Override
    protected Collection<Future<?>> initializeOp(Configuration hconf) throws HiveException {
        Collection<Future<?>> result = super.initializeOp(hconf);
        try {
            this.heartbeatInterval = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVESENDHEARTBEAT);
            this.conditionEvaluator = ExprNodeEvaluatorFactory.get(((FilterDesc)this.conf).getPredicate());
            if (HiveConf.getBoolVar(hconf, HiveConf.ConfVars.HIVEEXPREVALUATIONCACHE)) {
                this.conditionEvaluator = ExprNodeEvaluatorFactory.toCachedEval(this.conditionEvaluator);
            }
            this.conditionInspector = null;
            this.ioContext = IOContext.get(hconf);
        }
        catch (Throwable e) {
            throw new HiveException(e);
        }
        return result;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        ObjectInspector rowInspector = this.inputObjInspectors[tag];
        if (this.conditionInspector == null) {
            this.conditionInspector = (PrimitiveObjectInspector)this.conditionEvaluator.initialize(rowInspector);
        }
        if (((FilterDesc)this.conf).isSortedFilter() && this.ioContext.useSorted()) {
            if (!(this.conditionEvaluator instanceof ExprNodeGenericFuncEvaluator)) {
                this.LOG.error((Object)"Attempted to use the fact data is sorted when the conditionEvaluator is not of type ExprNodeGenericFuncEvaluator");
                this.ioContext.setUseSorted(false);
                return;
            }
            this.ioContext.setComparison(((ExprNodeGenericFuncEvaluator)this.conditionEvaluator).compare(row));
            if (this.ioContext.getGenericUDFClassName() == null) {
                this.ioContext.setGenericUDFClassName(((ExprNodeGenericFuncEvaluator)this.conditionEvaluator).genericUDF.getClass().getName());
            }
            if (this.ioContext.isBinarySearching()) {
                ++this.consecutiveSearches;
                if (this.consecutiveSearches % this.heartbeatInterval == 0 && this.reporter != null) {
                    this.reporter.progress();
                }
                return;
            }
        }
        Object condition = this.conditionEvaluator.evaluate(row);
        if (this.ioContext.isBinarySearching()) {
            return;
        }
        Boolean ret = (Boolean)this.conditionInspector.getPrimitiveJavaObject(condition);
        if (Boolean.TRUE.equals(ret)) {
            this.forward(row, rowInspector);
        }
    }

    @Override
    public String getName() {
        return FilterOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "FIL";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.FILTER;
    }

    @Override
    public boolean supportSkewJoinOptimization() {
        return true;
    }

    @Override
    public boolean columnNamesRowResolvedCanBeObtained() {
        return true;
    }

    @Override
    public boolean supportAutomaticSortMergeJoin() {
        return true;
    }

    @Override
    public boolean supportUnionRemoveOptimization() {
        return true;
    }
}

