import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::FSx::FileSystem`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 * @external
 */
export interface CfnFileSystemProps {
    /**
     * `AWS::FSx::FileSystem.FileSystemType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtype
     * @external
     */
    readonly fileSystemType: string;
    /**
     * `AWS::FSx::FileSystem.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-subnetids
     * @external
     */
    readonly subnetIds: string[];
    /**
     * `AWS::FSx::FileSystem.BackupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-backupid
     * @external
     */
    readonly backupId?: string;
    /**
     * `AWS::FSx::FileSystem.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::FSx::FileSystem.LustreConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-lustreconfiguration
     * @external
     */
    readonly lustreConfiguration?: CfnFileSystem.LustreConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::FSx::FileSystem.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-securitygroupids
     * @external
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::FSx::FileSystem.StorageCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagecapacity
     * @external
     */
    readonly storageCapacity?: number;
    /**
     * `AWS::FSx::FileSystem.StorageType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagetype
     * @external
     */
    readonly storageType?: string;
    /**
     * `AWS::FSx::FileSystem.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::FSx::FileSystem.WindowsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-windowsconfiguration
     * @external
     */
    readonly windowsConfiguration?: CfnFileSystem.WindowsConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 */
export declare class CfnFileSystem extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::FSx::FileSystem";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFileSystem;
    /**
     * @external
     * @cloudformationAttribute LustreMountName
     */
    readonly attrLustreMountName: string;
    /**
     * `AWS::FSx::FileSystem.FileSystemType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtype
     * @external
     */
    fileSystemType: string;
    /**
     * `AWS::FSx::FileSystem.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-subnetids
     * @external
     */
    subnetIds: string[];
    /**
     * `AWS::FSx::FileSystem.BackupId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-backupid
     * @external
     */
    backupId: string | undefined;
    /**
     * `AWS::FSx::FileSystem.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::FSx::FileSystem.LustreConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-lustreconfiguration
     * @external
     */
    lustreConfiguration: CfnFileSystem.LustreConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::FSx::FileSystem.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-securitygroupids
     * @external
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::FSx::FileSystem.StorageCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagecapacity
     * @external
     */
    storageCapacity: number | undefined;
    /**
     * `AWS::FSx::FileSystem.StorageType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagetype
     * @external
     */
    storageType: string | undefined;
    /**
     * `AWS::FSx::FileSystem.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::FSx::FileSystem.WindowsConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-windowsconfiguration
     * @external
     */
    windowsConfiguration: CfnFileSystem.WindowsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::FSx::FileSystem`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFileSystemProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 */
export declare namespace CfnFileSystem {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html
     * @external
     */
    interface LustreConfigurationProperty {
        /**
         * `CfnFileSystem.LustreConfigurationProperty.AutoImportPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-autoimportpolicy
         * @external
         */
        readonly autoImportPolicy?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.AutomaticBackupRetentionDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-automaticbackupretentiondays
         * @external
         */
        readonly automaticBackupRetentionDays?: number;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.CopyTagsToBackups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-copytagstobackups
         * @external
         */
        readonly copyTagsToBackups?: boolean | cdk.IResolvable;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.DailyAutomaticBackupStartTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-dailyautomaticbackupstarttime
         * @external
         */
        readonly dailyAutomaticBackupStartTime?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.DeploymentType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-deploymenttype
         * @external
         */
        readonly deploymentType?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.DriveCacheType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-drivecachetype
         * @external
         */
        readonly driveCacheType?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.ExportPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-exportpath
         * @external
         */
        readonly exportPath?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.ImportPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-importpath
         * @external
         */
        readonly importPath?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.ImportedFileChunkSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-importedfilechunksize
         * @external
         */
        readonly importedFileChunkSize?: number;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.PerUnitStorageThroughput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-perunitstoragethroughput
         * @external
         */
        readonly perUnitStorageThroughput?: number;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.WeeklyMaintenanceStartTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-weeklymaintenancestarttime
         * @external
         */
        readonly weeklyMaintenanceStartTime?: string;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 */
export declare namespace CfnFileSystem {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html
     * @external
     */
    interface SelfManagedActiveDirectoryConfigurationProperty {
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.DnsIps`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-dnsips
         * @external
         */
        readonly dnsIps?: string[];
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.DomainName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-domainname
         * @external
         */
        readonly domainName?: string;
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.FileSystemAdministratorsGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-filesystemadministratorsgroup
         * @external
         */
        readonly fileSystemAdministratorsGroup?: string;
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.OrganizationalUnitDistinguishedName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-organizationalunitdistinguishedname
         * @external
         */
        readonly organizationalUnitDistinguishedName?: string;
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-password
         * @external
         */
        readonly password?: string;
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.UserName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-username
         * @external
         */
        readonly userName?: string;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 */
export declare namespace CfnFileSystem {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html
     * @external
     */
    interface WindowsConfigurationProperty {
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.ActiveDirectoryId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-activedirectoryid
         * @external
         */
        readonly activeDirectoryId?: string;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.AutomaticBackupRetentionDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-automaticbackupretentiondays
         * @external
         */
        readonly automaticBackupRetentionDays?: number;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.CopyTagsToBackups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-copytagstobackups
         * @external
         */
        readonly copyTagsToBackups?: boolean | cdk.IResolvable;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.DailyAutomaticBackupStartTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-dailyautomaticbackupstarttime
         * @external
         */
        readonly dailyAutomaticBackupStartTime?: string;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.DeploymentType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-deploymenttype
         * @external
         */
        readonly deploymentType?: string;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.PreferredSubnetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-preferredsubnetid
         * @external
         */
        readonly preferredSubnetId?: string;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.SelfManagedActiveDirectoryConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration
         * @external
         */
        readonly selfManagedActiveDirectoryConfiguration?: CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.ThroughputCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-throughputcapacity
         * @external
         */
        readonly throughputCapacity?: number;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.WeeklyMaintenanceStartTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-weeklymaintenancestarttime
         * @external
         */
        readonly weeklyMaintenanceStartTime?: string;
    }
}
