#!/usr/bin/env python
# Part of TotalDepth: Petrophysical data processing and presentation
# Copyright (C) 2011-2021 Paul Ross
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
# 
# Paul Ross: apaulross@gmail.com
"""LAS Test data

Created on 19 jan 2012

@author: p2ross
"""

__author__  = 'Paul Ross'
__date__    = '2012-01-19'
__version__ = '0.1.0'
__rights__  = 'Copyright (c) Paul Ross'

LAS_00_200_FEET_DOWN = """# 03/10/1999 14:53:39 Updated by the Kansas Geological Survey
# #KGS#ID: 31S33W/1001178923
# Additions:   1001178923.add
# Old: WELL.                    GASKILL NO. 1-5: Well Name
# New: WELL.                                1-5: Well Name
# New: LEAS.                            GASKILL: Lease Name
#
# 03/04/1999 13:55:28 Updated by the Kansas Geological Survey
# Additions:   1001178923.add
# New: UWI .                       15-175-21301: Unique Well Id
# New: PM  .                                  6: Principal Meridian
# Old: STAT.                             KANSAS: STATE
# New: STAT.                             Kansas: State
#
# 02/25/1999 15:08:23 Updated by the Kansas Geological Survey
# #KGS#INPUT_FILE: /home/crude2_3/WellLogs/Guy/105-Ddrive/Hugelogs/GASKIL15.las.las
~VERSION INFORMATION
 VERS.                                2.0: CWLS LOG ASCII STANDARD - VERSION 2.0
 WRAP.                                 NO: ONE LINE PER DEPTH STEP
~WELL INFORMATION BLOCK
#MNEM.UNIT       DATA TYPE    INFORMATION
#---------    -------------   ------------------------------
 UWI .                       15-175-21301: Unique Well Id
 PM  .                                  6: Principal Meridian
 STAT.                             Kansas: State
 SECT.                                  5: Section
 TOWN.                                31S: Township
 RANG.                                33W: Range
 COUN.                             SEWARD: County Name
 COMP.         HUGOTON ENERGY CORPORATION: Company
 WELL.                                1-5: Well Name
 LEAS.                            GASKILL: Lease Name
 FLD .                            VICTORY: Field
 STRT.F                        5487.00000: 
 STOP.F                        5687.00000: 
 STEP.F                           0.50000: 
 NULL.                         -999.25000: NULL VALUE
 LOC .     440' FNL & 440' FWL, 5-31S-33W: LOCATION
 LOC1.                                   : LOCATION1
 CTRY.                                   : COUNTRY
 DATE.                        22-MAR-1993: LOG DATE
 API .                       15-175-21301: API NUMBER
 DAY .                                 22: LOG DAY
 MONT.                                  3: LOG MONTH
 YEAR.                                 93: LOG YEAR
 DMF .                      KELLY BUSHING: DRILLING REF
 LMF .                      KELLY BUSHING: LOGGING  REF
 PDAT.                       GROUND LEVEL: PERMANENT DATUM
 ENGI.                          JON BLACK: LOGGING ENGINEER
 WITN.                     KARL OSTERBUHR: LOGGING WITNESS
 LATI.                                   : LATITUDE
 LONG.                                   : LONGITUDE
 LUL .                       LIBERAL,  KS: LOGGING DISTRICT
 LUN .                               8510: LOGGING UNIT NO.
 RUN .                                ONE: LOGGING RUN NO.
 SON .                             603664: SERVICE ORDER NO.
 SRVC.         SCHLUMBERGER WELL SERVICES: SERVICE COMPANY
~CURVE INFORMATION
#MNEM.UNIT      API CODE      CURVE DESCRIPTION
#---------    -------------   ------------------------------
 DEPT.F                                 0: 1  Depth
 GR  .GAPI                        7310010: 2 Gamma Ray
 ILD .OHMM                        7120460: 3 Deep  Induction Standard Resistivity
 ILM .OHMM                        7120440: 4 Medium Induction Standard Resistivity
 SFLU.OHMM                        7220010: 5 SFL Resistivity (unaveraged)
 SP  .MV                          7010010: 6 Spontaneous Potential
 BMIN.OHMM                        1525001: 7 MICRO INVERSE
 BMNO.OHMM                        1525201: 8 MICRO NORMAL
 CALI.IN                          1528001: 9 Caliper
 DPHI.V/V                         1589001: 10 Density Porosity
 DRHO.G/C3                        1535601: 11 Delta  RHO
 NPHI.V/V                         1589000: 12 Neutron Porosity N
 PEF .                            1535801: 13 Photoelectric Factor
 RHOB.G/C3                        1535002: 14 Bulk Density
 TNPH.V/V                         1589000: 15 Thermal Neutron Porosity
~PARAMETER INFORMATION
#MNEM.UNIT        VALUE       DESCRIPTION
#---------    -------------   ------------------------------
 BHT .DEGF                            N/A: Bottom Hole Temperature
 BS  .IN                            7.875: Bit Size
 MDEN.G/C3                            N/A: Matrix Density
 DFD .LB/G                            9.1: Drilling Fluid Density
 DFV .S                               52.: Drilling Fluid Viscosity
 DFL .C3                         8.799999: Drilling Fluid Loss
 RMFS.OHMM                           1.14: Resistivity of Mud Filtrate Sample
 EKB .F                             2944.: Elevation of Kelly Bushing
 EGL .F                             2936.: Elevation of Ground Level
 BLI .F                             5664.: Bottom Log Interval
 BSAL.PPM                           2200.: Borehole Salinity
 FLEV.F                                0.: Fluid Level
 MCST.DEGF                            58.: Mud Cake Sample Temperature
 MFST.DEGF                            58.: Mud Filtrate Sample Temperature
 MRT .DEGF                           123.: Maximum Recorded Temperature
 MST .DEGF                            58.: Mud Sample Temperature
 RMCS.OHMM                           2.15: Resistivity of Mud Cake Sample
 RMS .OHMM                           1.43: Resistivity of Mud Sample
 RW  .OHMM                             1.: Resistivity of Water
 TDD .F                             5670.: Total Depth - Driller
 TDL .F                             5670.: Total Depth - Logger
 TLI .F                           -50000.: Top Log Interval
~OTHER INFORMATION
 HIDE.     DUAL INDUCTION LOG                      : Header Identifer
 MATR.     N/A                                     : Matrix
 FNUM.     N/A                                     : F-Numerator for Formation F
 FEXP.     N/A                                     : F-Exponent for Formation Fa
 DFT .     CHEMICAL                                : Drilling Fluid Type
 DFPH.     9.                                      : Drilling Fluid Ph
 MCSS.     MEASURED                                : Mud Cake Sample Source
 MFSS.     MEASURED                                : Mud Filtrate Sample Source
 FD  .     N/A                                     : Fluid Density
 MSS .     CIRCULATED                              : Mud Sample Source
 OS1 .     DIL-SFL-GR                              : Other Services Line 1
 OS2 .     LDL-CNL-GR                              : Other Services Line 2
 OS3 .     ML-GR                                   : Other Services Line 3
 OS4 .                                             : Other Services Line 4
 OS5 .                                             : Other Services Line 5
 OS6 .                                             : Other Services Line 6
 R1  .     1 1/2" STANDOFFS USED ABOVE AND BELOW   : Remark Line 1
 R2  .     INDUCTION TOOL.                         : Remark Line 2
 R3  .                                             : Remark Line 3
 R4  .                                             : Remark Line 4
 R5  .                                             : Remark Line 5
 R6  .                                             : Remark line 6
 R7  .                                             : Remark line 7
 R8  .                                             : Remark line 8
 HIDE.     POROSITY LOG                            : Header Identifer
 MATR.     0.0                                     : Neutron Matrix (0=LIME)
 FNUM.     1.                                      : F-Numerator for Formation F
 FEXP.     2.                                      : F-Exponent for Formation Fa
 DFT .     CHEMICAL                                : Drilling Fluid Type
 DFPH.     9.                                      : Drilling Fluid Ph
 MCSS.     MEASURED                                : Mud Cake Sample Source
 MFSS.     MEASURED                                : Mud Filtrate Sample Source
 FD  .G/C3 0.9999999                               : Fluid Density
 MSS .     CIRCULATED                              : Mud Sample Source
 OS1 .     DIL-SFL-GR                              : Other Services Line 1
 OS2 .     LDL-CNL-GR                              : Other Services Line 2
 OS3 .     ML-GR                                   : Other Services Line 3
 OS4 .                                             : Other Services Line 4
 OS5 .                                             : Other Services Line 5
 OS6 .                                             : Other Services Line 6
 R1  .     BOW SPRING ECCENTRALIZER RAN            : Remark Line 1
 R2  .     ON NEUTRON TOOL. TOOL STRING            : Remark Line 2
 R3  .     ALSO ECCENTRALIZED BY CALIPERS          : Remark Line 3
 R4  .     ON DENSITY AND MICROLOG TOOLS.          : Remark Line 4
 R5  .     THANKS FOR CHOOSING SCHLUMBERGER!       : Remark Line 5
 R6  .                                             : Remark line 6
 R7  .                                             : Remark line 7
 R8  .                                             : Remark line 8
#MNEM.UNIT    VALUE                                 DESCRIPTION
#---------    -----------------------------------   ----------------------------
~A       DEPT         GR           ILD          ILM          SFLU         SP           BMIN         BMNO         CALI         DPHI         DRHO         NPHI         PEF          RHOB         TNPH
   5487.00000     29.68750    105.56013     95.05438     85.65103    195.50000     46.15625     41.87500      8.14844      0.01455     -0.00509      0.01106      3.95117      2.68513      0.01476
   5487.50000     28.56250    111.44106    104.31622     90.79524    195.87500     42.90625     44.96875      8.12500      0.01244     -0.00330      0.01034      4.30859      2.68873      0.01445
   5488.00000     27.50000    115.60748    114.34204     98.16499    196.12500     41.53125     46.43750      8.14063      0.01379     -0.00396      0.00969      4.61328      2.68642      0.01337
   5488.50000     28.59375    116.73145    123.57886    110.75026    196.12500     41.50000     46.06250      8.12500      0.01805     -0.00526      0.00909      4.65625      2.67913      0.01317
   5489.00000     34.00000    120.02603    126.49835    127.03708    196.12500     45.25000     49.28125      8.07813      0.02836     -0.00790      0.00959      4.52734      2.66151      0.01188
   5489.50000     34.00000    116.00172    116.83722    135.58218    196.12500     45.56250     52.43750      8.03906      0.03480     -0.01028      0.00916      4.35156      2.65049      0.01222
   5490.00000     40.40625    111.25877    111.95113    127.03708    196.50000     61.40625     60.43750      8.05469      0.03796     -0.01122      0.00889      4.23828      2.64508      0.01176
   5490.50000     36.12500    110.77559    107.45705    108.75833    196.50000     59.25000     52.53125      8.00781      0.03327     -0.01024      0.00838      4.29297      2.65311      0.01261
   5491.00000     38.28125    113.54929    107.45705    101.45911    196.75000     64.87500     61.18750      8.06250      0.02598     -0.01208      0.00867      4.32031      2.66557      0.01109
   5491.50000     33.06250    109.23373    107.45705    101.45911    196.62500     56.06250     47.06250      8.02344      0.02546     -0.01182      0.00866      4.37891      2.66646      0.01155
   5492.00000     34.25000    105.45097    105.34258    108.75833    196.62500     59.84375     57.90625      8.00781      0.02171     -0.01196      0.00945      4.33594      2.67287      0.01186
   5492.50000     32.03125    105.39650    105.34258    112.81650    196.25000     55.81250     52.78125      8.00781      0.02129     -0.01472      0.00848      4.35938      2.67359      0.01321
   5493.00000     34.12500    100.71284    103.30966    117.18924    196.00000     55.65625     53.90625      8.00781      0.02322     -0.01658      0.00920      4.51563      2.67029      0.01192
   5493.50000     33.06250     98.28586    100.40318    119.50523    195.75000     58.84375     56.34375      8.00000      0.03066     -0.01521      0.00904      4.51953      2.65757      0.01225
   5494.00000     35.18750     98.90559     96.77287    121.91460    195.62500     58.18750     55.93750      8.00000      0.03901     -0.01919      0.00933      4.44531      2.64328      0.01216
   5494.50000     34.03125     96.79285     93.39581    117.18924    195.25000     58.87500     57.46875      8.00000      0.03741     -0.01951      0.00944      4.44531      2.64603      0.01233
   5495.00000     33.06250     99.58176     91.01363     99.78487    194.87500     48.09375     44.78125      8.00781      0.03057     -0.01870      0.00898      4.56641      2.65772      0.01250
   5495.50000     35.25000    101.51494     92.58803     90.79524    194.50000     45.12500     41.68750      8.00781      0.03905     -0.02144      0.00996      4.64453      2.64323      0.01187
   5496.00000     33.15625    102.48410     96.77287     92.17931    193.87500     53.56250     48.56250      8.00000      0.04247     -0.02186      0.01011      4.44922      2.63738      0.01221
   5496.50000     31.90625    109.76259    106.38930    101.45911    193.12500     52.28125     50.21875      8.00000      0.04458     -0.02226      0.01032      4.45313      2.63378      0.01262
   5497.00000     28.73438    113.61250    111.95113    121.91460    192.50000     53.09375     51.59375      8.00000      0.03294     -0.01638      0.00937      4.26563      2.65367      0.01236
   5497.50000     27.76563    116.39864    120.79100    141.94754    191.62500     63.28125     67.43750      8.00000      0.03501     -0.01574      0.00841      4.59375      2.65014      0.01140
   5498.00000     28.75000    124.41455    126.49835    148.94003    191.00000     63.12500     66.50000      8.00000      0.02878     -0.01101      0.00867      4.34375      2.66078      0.01108
   5498.50000     26.50000    127.68199    131.14560    152.70114    190.12500     56.84375     58.62500      8.00000      0.03018     -0.01355      0.00913      4.47656      2.65840      0.01154
   5499.00000     26.40625    136.92682    136.14713    145.35974    189.12500     55.34375     55.09375      8.00000      0.02267     -0.01058      0.00993      4.39063      2.67123      0.01218
   5499.50000     26.50000    137.85083    139.69882    145.35974    188.25000     57.12500     58.12500      8.00000      0.02768     -0.01537      0.00943      4.67578      2.66266      0.01321
   5500.00000     25.53125    139.26038    145.38779    145.35974    187.25000     59.87500     61.34375      8.00000      0.02620     -0.01442      0.00879      4.60938      2.66519      0.01256
   5500.50000     26.68750    147.39813    145.38779    148.94003    186.25000     53.84375     59.87500      8.00000      0.02904     -0.01680      0.00821      4.36328      2.66034      0.01132
   5501.00000     25.65625    144.78705    153.73480    152.70114    185.25000     55.46875     60.40625      8.00000      0.03037     -0.01495      0.00833      4.32422      2.65807      0.01071
   5501.50000     27.65625    159.35062    153.73480    160.82358    184.62500     55.56250     64.00000      7.97266      0.02922     -0.01432      0.00870      4.35938      2.66003      0.01046
   5502.00000     25.48438    165.27719    155.97342    169.85861    183.37500     53.00000     65.87500      7.96484      0.02595     -0.00921      0.00833      4.53516      2.66562      0.01032
   5502.50000     24.31250    180.92578    163.09811    165.21765    181.87500     46.03125     57.84375      7.98047      0.01957     -0.00687      0.00830      4.48828      2.67653      0.01013
   5503.00000     23.32813    188.25363    176.53751    165.21765    180.50000     47.21875     62.96875      7.97266      0.02054     -0.00908      0.00852      4.87891      2.67487      0.01019
   5503.50000     24.32813    198.48349    185.71906    165.21765    179.37500     43.46875     58.12500      7.94141      0.01814     -0.01015      0.00868      5.04297      2.67897      0.01066
   5504.00000     25.56250    191.96402    199.55676    174.76782    178.37500     39.65625     57.34375      7.96484      0.02480     -0.01354      0.00870      5.21484      2.66760      0.01024
   5504.50000     23.48438    188.42706    203.34442    197.61334    177.25000     43.15625     67.81250      7.92578      0.02709     -0.01750      0.00840      5.00781      2.66367      0.01051
   5505.00000     22.45313    201.41489    185.71906    185.48981    176.12500     44.46875     82.93750      7.91406      0.03195     -0.01573      0.00923      4.62500      2.65536      0.01118
   5505.50000     25.51563    198.67627    199.55676    156.65717    174.62500     31.60938     53.31250      7.92578      0.03314     -0.01752      0.00973      4.76953      2.65332      0.01209
   5506.00000     28.67188    166.08279    220.05023    145.35974    172.62500     28.59375     53.62500      7.90234      0.03331     -0.01798      0.01094      4.73828      2.65304      0.01303
   5506.50000     32.84375    128.89081    195.90765    160.82358    170.37500     25.31250     59.28125      7.91406      0.03037     -0.01422      0.01146      4.69922      2.65807      0.01428
   5507.00000     32.78125     82.12546    134.43811    165.21765    167.75000     26.35938     49.43750      7.87109      0.02972     -0.01344      0.01335      4.46094      2.65919      0.01614
   5507.50000     38.18750     52.57391     80.11407    135.58218    164.87500     25.00000     45.15625      7.85547      0.03080     -0.01552      0.01598      4.48828      2.65733      0.02119
   5508.00000     46.81250     37.91559     46.40105    101.45911    162.12500     23.50000     34.46875      7.85547      0.02774     -0.01039      0.02305      4.89453      2.66257      0.02704
   5508.50000     59.78125     29.33891     30.50050     72.33208    159.25000     15.77344     23.03125      7.85547      0.03249     -0.00987      0.03623      4.95313      2.65444      0.03747
   5509.00000     58.65625     24.31559     22.65895     56.72572    156.87500      7.67188     10.27344      7.84375      0.04581     -0.00931      0.05310      4.98438      2.63166      0.05020
   5509.50000     45.81250     21.45826     18.58562     52.76581    155.50000      6.97656     10.09375      7.85547      0.06537     -0.00687      0.06457      4.88672      2.59822      0.06228
   5510.00000     29.89063     19.74206     16.66400     51.41974    155.25000      7.03125     10.20313      7.85547      0.07824     -0.00499      0.06639      4.99609      2.57620      0.06617
   5510.50000     26.68750     19.28831     16.23150     52.30936    155.87500      7.19141     10.14844      7.84375      0.09355     -0.00480      0.05591      4.69922      2.55003      0.06167
   5511.00000     28.81250     19.91993     17.42867     56.72572    157.87500      7.66016     10.81250      7.85547      0.09193     -0.00341      0.03642      4.82813      2.55280      0.04833
   5511.50000     29.89063     21.72940     19.98111     69.82635    160.12500      8.28125     11.56250      7.85547      0.08106     -0.00598      0.01889      4.64844      2.57139      0.03196
   5512.00000     30.92188     24.87772     24.42440     89.45212    163.00000     10.82031     14.53125      7.85547      0.06359     -0.00965      0.01197      5.03906      2.60127      0.01886
   5512.50000     36.12500     30.78076     31.77156    108.75833    166.12500     85.68750     66.75000      7.88281      0.04112     -0.01267      0.00960      4.71094      2.63968      0.01236
   5513.00000     43.53125     40.17815     43.38725    110.75026    169.12500     82.00000     87.56250      7.92188      0.03519     -0.01733      0.00927      4.61328      2.64983      0.01140
   5513.50000     50.96875     55.89066     60.94733    112.81650    172.00000     68.81250     73.37500      7.93750      0.02493     -0.01625      0.00925      4.41797      2.66737      0.01237
   5514.00000     48.93750     83.88426     86.59589    114.96129    174.12500     54.65625     70.75000      7.92969      0.02226     -0.01404      0.00926      4.20703      2.67193      0.01209
   5514.50000     46.75000    123.66106    128.01044    121.91460    175.87500     42.06250     56.53125      7.92188      0.01544     -0.01031      0.00967      4.07031      2.68359      0.01117
   5515.00000     40.25000    158.97879    185.71906    148.94003    177.37500     53.84375     61.09375      7.92578      0.00241     -0.00303      0.00827      4.09375      2.70588      0.00970
   5515.50000     35.93750    173.11411    234.49854    227.32965    178.75000     52.93750     68.31250      7.94141     -0.00371     -0.00102      0.00590      4.55078      2.71635      0.00608
   5516.00000     26.37500    162.13120    229.47620    444.63074    180.00000     68.12500     61.18750      7.91406     -0.00271     -0.00195      0.00456      5.00781      2.71463      0.00378
   5516.50000     23.28125    146.13318    176.53751    629.89429    181.37500    109.06250     93.18750      7.86328      0.00814     -0.00778      0.00590      5.24219      2.69608      0.00539
   5517.00000     27.73438    141.28284    116.83722    293.54230    182.62500    124.50000    146.87500      7.90234      0.01594     -0.01277      0.00893      5.12500      2.68274      0.00993
   5517.50000     38.28125    146.97409     95.90594    127.03708    183.75000     98.37500    126.18750      7.98047      0.02297     -0.02145      0.01484      5.03125      2.67073      0.01660
   5518.00000     42.37500    139.07080     95.90594     81.05847    184.87500     39.25000     34.62500      7.98047      0.02798     -0.02407      0.01888      4.57422      2.66215      0.02477
   5518.50000     39.12500    134.40411    108.54640     81.05847    185.37500     48.84375     49.78125      7.96484      0.02947     -0.02526      0.01836      4.58203      2.65961      0.02540
   5519.00000     31.75000    126.80980    120.79100    101.45911    184.87500     49.46875     60.25000      7.97266      0.02707     -0.02293      0.01334      4.54688      2.66371      0.02073
   5519.50000     27.62500    120.16734    129.55905    148.94003    184.25000     44.12500     65.81250      7.96484      0.02720     -0.02073      0.01034      4.79688      2.66348      0.01520
   5520.00000     25.54688    127.20477    139.69882    191.35971    183.50000     61.09375     68.75000      7.98047      0.01837     -0.01532      0.00864      4.89844      2.67859      0.01150
   5520.50000     26.70313    149.66522    170.90457    219.09305    182.75000     66.56250     77.87500      7.98047      0.01317     -0.01094      0.00764      4.91797      2.68748      0.00891
   5521.00000     27.87500    175.34088    203.34442    236.20972    182.12500     75.81250     64.56250      7.93750      0.01058     -0.01246      0.00688      4.79297      2.69190      0.00772
   5521.50000     29.96875    221.23392    245.23273    227.32965    181.37500     79.62500     72.12500      7.97266      0.01386     -0.01290      0.00660      4.62891      2.68629      0.00653
   5522.00000     30.89063    241.60623    263.31183    256.22754    180.87500     75.62500     64.37500      7.98047      0.01200     -0.01085      0.00560      4.37500      2.68948      0.00705
   5522.50000     32.00000    234.68033    239.74554    256.22754    180.25000     86.81250     71.31250      7.98047      0.00618     -0.00770      0.00652      4.44141      2.69943      0.00628
   5523.00000     34.00000    233.07675    211.36783    236.20972    180.12500     97.31250     88.00000      8.00000      0.00847     -0.00965      0.00732      4.50391      2.69552      0.00791
   5523.50000     36.21875    200.23199    203.34442    204.28946    180.00000     78.56250     82.06250      8.00000      0.00770     -0.00357      0.00896      4.95703      2.69684      0.00980
   5524.00000     32.00000    181.40729    185.71906    179.96927    180.00000     83.37500     86.06250      7.99219      0.01419     -0.00340      0.00896      5.16016      2.68574      0.01221
   5524.50000     27.81250    171.08612    160.65201    174.76782    179.62500     66.93750     73.68750      7.96484      0.01631     -0.00448      0.00856      4.79297      2.68211      0.01217
   5525.00000     25.71875    164.08325    147.38843    156.65717    179.00000     57.43750     56.12500      7.98047      0.02199     -0.00674      0.00865      4.65625      2.67240      0.01182
   5525.50000     28.68750    159.72415    141.54504    132.60889    178.12500     53.37500     51.28125      7.96484      0.01841     -0.00609      0.00931      4.64453      2.67851      0.01149
   5526.00000     35.12500    152.57034    147.38843    129.76318    177.00000     54.78125     51.12500      7.95313      0.02145     -0.01057      0.00936      4.98047      2.67332      0.01141
   5526.50000     37.12500    143.06360    158.27817    132.60889    175.37500     59.28125     56.90625      7.96094      0.01856     -0.01047      0.00908      5.03125      2.67826      0.00891
   5527.00000     37.18750    125.33096    165.61984    145.35974    173.50000     57.68750     61.28125      7.92969      0.02206     -0.01200      0.00778      5.07813      2.67227      0.00780
   5527.50000     39.43750    105.39650    145.38779    156.65717    171.37500    101.37500     98.12500      7.91406      0.02920     -0.01157      0.00647      3.77539      2.66006      0.00673
   5528.00000     37.18750     90.15733    100.40318    148.94003    169.50000     94.25000     87.43750      7.85547      0.03776     -0.00867      0.00602      3.51758      2.64543      0.00643
   5528.50000     32.90625     79.09502     75.05714    119.50523    167.87500     77.75000     78.12500      7.85547      0.04049     -0.00556      0.00770      3.52734      2.64076      0.00733
   5529.00000     24.28125     71.10822     63.47906     96.59685    166.75000     92.18750     81.43750      7.85547      0.03468     -0.00514      0.00925      4.68750      2.65070      0.01029
   5529.50000     19.21875     66.96396     57.35246     85.65103    166.00000    103.87500     98.31250      7.85547      0.02648     -0.00140      0.01034      4.79688      2.66472      0.01195
   5530.00000     20.37500     63.77071     54.15762     83.29150    165.75000     95.00000     82.50000      7.85547      0.01822     -0.00068      0.00952      4.63672      2.67885      0.01350
   5530.50000     20.37500     60.86686     53.61456     84.45479    165.12500     89.31250     76.56250      7.85547      0.01624     -0.00331      0.00947      4.82031      2.68222      0.01268
   5531.00000     23.54688     62.49587     55.85481     86.88165    165.00000     95.87500     91.18750      7.85547      0.01965     -0.00697      0.01000      5.04688      2.67639      0.01233
   5531.50000     24.50000     65.56029     62.36876     92.17931    164.87500     94.81250    102.31250      7.85547      0.02363     -0.00646      0.01096      5.15625      2.66960      0.01286
   5532.00000     26.50000     72.24454     72.02594    101.45911    165.12500     91.25000     74.43750      7.86328      0.02867     -0.00942      0.01177      5.12109      2.66098      0.01415
   5532.50000     29.87500     83.30106     83.22908    119.50523    165.75000     92.37500     76.37500      7.85547      0.02633     -0.01117      0.01157      5.12500      2.66497      0.01574
   5533.00000     30.01563     97.48705     98.55463    135.58218    166.37500     92.06250     73.25000      7.85547      0.02176     -0.01021      0.01159      5.27344      2.67280      0.01548
   5533.50000     29.01563    113.42308    110.79274    141.94754    167.25000     92.43750     81.75000      7.85547      0.02085     -0.01133      0.01168      4.94531      2.67435      0.01557
   5534.00000     23.54688    133.70029    128.01044    129.76318    168.25000     68.93750     63.53125      7.85547      0.02452     -0.01242      0.01194      4.88281      2.66806      0.01557
   5534.50000     21.34375    152.57034    143.44070    127.03708    169.50000     71.06250     67.87500      7.85547      0.02816     -0.01311      0.01195      4.73828      2.66185      0.01620
   5535.00000     21.34375    168.26999    153.73480    132.60889    170.37500     69.75000     57.15625      7.85547      0.02711     -0.01325      0.01204      4.93750      2.66365      0.01642
   5535.50000     26.65625    187.39120    170.90457    141.94754    171.25000     41.53125     47.84375      7.85547      0.02441     -0.01429      0.01235      5.20313      2.66826      0.01669
   5536.00000     33.03125    198.29108    179.49548    156.65717    172.00000     89.75000     70.37500      7.85547      0.02006     -0.01111      0.01282      5.24219      2.67569      0.01727
   5536.50000     32.03125    224.88080    207.27850    165.21765    172.62500     65.31250     62.06250      7.85547      0.02075     -0.01184      0.01305      4.99609      2.67452      0.01719
   5537.00000     26.67188    245.07776    220.05023    191.35971    173.12500     55.90625     51.37500      7.85547      0.02167     -0.01105      0.01285      4.96875      2.67295      0.01591
   5537.50000     20.25000    272.47968    245.23273    211.43246    173.37500     86.18750     72.93750      7.85547      0.01674     -0.00862      0.01194      4.74609      2.68138      0.01416
   5538.00000     18.09375    304.94348    276.92151    227.32965    173.25000     83.43750     93.87500      7.85547      0.01563     -0.00881      0.01129      4.97656      2.68327      0.01452
   5538.50000     20.28125    298.28088    263.31183    256.22754    173.25000     60.71875     67.87500      7.85547      0.01139     -0.01015      0.01075      4.92578      2.69053      0.01442
   5539.00000     19.23438    310.49164    263.31183    236.20972    173.37500     84.75000     58.21875      7.85547      0.01242     -0.00919      0.01034      5.18359      2.68876      0.01431
   5539.50000     20.28125    292.73737    245.23273    211.43246    173.37500     69.93750     60.65625      7.85547      0.01269     -0.01186      0.01091      5.16797      2.68830      0.01431
   5540.00000     18.18750    286.59149    234.49854    191.35971    173.75000     97.81250     85.50000      7.85547      0.01701     -0.01261      0.01284      4.91016      2.68091      0.01503
   5540.50000     22.39063    318.21063    207.27850    165.21765    174.25000     53.93750     51.06250      7.85547      0.02079     -0.01387      0.01445      4.84375      2.67445      0.01864
   5541.00000     28.71875    322.72351    220.05023    169.85861    174.50000     61.93750     53.65625      7.86328      0.02473     -0.01293      0.01459      4.51172      2.66771      0.01980
   5541.50000     29.71875    309.08575    250.97684    169.85861    175.12500     79.43750     65.25000      7.85547      0.02625     -0.01467      0.01297      4.65625      2.66512      0.01786
   5542.00000     28.62500    298.71594    263.31183    204.28946    175.75000     88.00000     72.62500      7.85547      0.01791     -0.01000      0.01125      4.52734      2.67938      0.01489
   5542.50000     25.48438    237.95456    250.97684    245.81177    176.50000     96.93750     79.31250      7.85547      0.01503     -0.01225      0.00903      5.09766      2.68429      0.01251
   5543.00000     27.67188    209.88699    195.90765    267.56506    177.25000    119.12500    116.37500      7.85547      0.01071     -0.00948      0.00745      4.89453      2.69168      0.00966
   5543.50000     27.85938    200.23199    151.55951    219.09305    178.12500    101.43750    126.00000      7.85547      0.01582     -0.01081      0.00857      4.86719      2.68294      0.00883
   5544.00000     26.75000    199.45111    132.77145    141.94754    178.87500     40.81250     43.25000      7.92188      0.01934     -0.00993      0.00965      4.47656      2.67693      0.01090
   5544.50000     24.53125    203.41766    134.43811    110.75026    179.25000     34.25000     35.37500      7.93750      0.01936     -0.01125      0.01163      4.75391      2.67689      0.01198
   5545.00000     24.40625    212.72385    145.38779    104.98201    179.50000     39.28125     35.87500      7.92969      0.01712     -0.00655      0.01024      4.71875      2.68072      0.01448
   5545.50000     29.78125    212.06244    176.53751    121.91460    179.62500     51.81250     43.90625      7.92188      0.01674     -0.00685      0.00944      4.59375      2.68138      0.01244
   5546.00000     36.21875    221.71329    207.27850    174.76782    179.87500     66.12500     50.93750      7.92578      0.01605     -0.00708      0.00727      4.65625      2.68255      0.01059
   5546.50000     34.12500    232.81155    256.99646    256.22754    179.87500     87.93750     64.00000      7.90234      0.01113     -0.00623      0.00612      4.78906      2.69096      0.00614
   5547.00000     28.73438    266.45099    300.19482    325.10608    180.12500     79.81250     58.18750      7.86328      0.00938     -0.00495      0.00567      5.04297      2.69396      0.00403
   5547.50000     23.34375    312.38617    338.07733    343.57800    180.37500    106.12500     94.12500      7.85547      0.01066     -0.00456      0.00597      4.82813      2.69177      0.00430
   5548.00000     24.43750    325.80371    338.07733    325.10608    181.00000     86.62500     77.43750      7.85547      0.01664     -0.00507      0.00700      4.73828      2.68155      0.00621
   5548.50000     23.42188    288.20508    263.31183    279.95233    181.25000    110.56250    111.00000      7.85547      0.01620     -0.00419      0.00701      4.98438      2.68230      0.00771
   5549.00000     26.89063    267.14642    192.38950    256.22754    181.62500    103.31250    107.50000      7.85547      0.01637     -0.00649      0.00806      4.80469      2.68200      0.00775
   5549.50000     30.10938    269.96460    158.27817    169.85861    181.50000     75.81250     77.62500      7.85547      0.01464     -0.00596      0.00872      4.69531      2.68497      0.00989
   5550.00000     35.46875    269.96460    168.22070    121.91460    181.62500     48.18750     40.21875      7.86328      0.01014     -0.00594      0.00907      4.31641      2.69266      0.01053
   5550.50000     37.40625    269.60907    215.62170    117.18924    181.62500     69.43750     46.71875      7.85547      0.00978     -0.00496      0.00775      4.56641      2.69327      0.00931
   5551.00000     38.34375    253.26511    239.74554    165.21765    181.25000     87.62500     77.68750      7.85547      0.00744     -0.00445      0.00630      4.61328      2.69729      0.00645
   5551.50000     40.50000    249.86450    256.99646    267.56506    180.37500    110.56250    103.12500      7.85547      0.01618     -0.00671      0.00576      4.59766      2.68233      0.00474
   5552.00000     38.34375    255.15930    263.31183    325.10608    179.75000     90.37500     99.81250      7.85547      0.01564     -0.00721      0.00610      4.71484      2.68325      0.00388
   5552.50000     38.53125    275.41199    300.19482    343.57800    179.00000     81.81250     73.43750      7.85547      0.01619     -0.00805      0.00629      4.95703      2.68231      0.00453
   5553.00000     38.31250    274.67303    263.31183    293.54230    178.00000     85.43750     85.25000      7.85547      0.01528     -0.01025      0.00685      5.13672      2.68387      0.00604
   5553.50000     37.25000    237.40256    195.90765    227.32965    177.12500     63.59375     62.15625      7.85547      0.01996     -0.01169      0.00723      5.09375      2.67587      0.00807
   5554.00000     35.00000    214.05917    160.65201    156.65717    176.50000     59.15625     55.59375      7.85547      0.01991     -0.01034      0.00894      4.80859      2.67595      0.00914
   5554.50000     28.73438    195.44916    136.14713    129.76318    175.50000     53.21875     47.87500      7.85547      0.02513     -0.01388      0.00984      4.94141      2.66702      0.01148
   5555.00000     25.46875    177.01050    125.02158    127.03708    174.75000     50.71875     54.46875      7.85547      0.02516     -0.01547      0.01090      4.64844      2.66697      0.01330
   5555.50000     23.25000    170.65771    120.79100    141.94754    174.87500     37.25000     41.43750      7.85547      0.02872     -0.01572      0.01041      4.81641      2.66090      0.01435
   5556.00000     23.25000    161.49078    129.55905    160.82358    175.12500     16.57813     21.43750      7.85547      0.02489     -0.01458      0.00940      4.68359      2.66743      0.01244
   5556.50000     27.53125    167.44305    147.38843    211.43246    176.00000     41.21875     26.48438      7.85547      0.02684     -0.01764      0.00771      4.79688      2.66410      0.00926
   5557.00000     29.78125    170.51541    160.65201    236.20972    176.87500     78.25000     47.15625      7.85547      0.02238     -0.01441      0.00594      4.62500      2.67173      0.00584
   5557.50000     36.21875    185.01788    168.22070    227.32965    177.75000     61.50000     48.12500      7.85547      0.01591     -0.01266      0.00566      4.75391      2.68280      0.00444
   5558.00000     36.25000    225.87369    182.55426    197.61334    178.75000     56.50000     44.31250      7.85547      0.01191     -0.01215      0.00490      5.02344      2.68963      0.00413
   5558.50000     37.31250    258.05420    211.36783    179.96927    179.37500     52.84375     44.00000      7.85547      0.01097     -0.01556      0.00549      5.50000      2.69125      0.00322
   5559.00000     30.98438    300.02893    245.23273    191.35971    179.37500     42.93750     53.53125      7.85547      0.01593     -0.01801      0.00535      5.69141      2.68276      0.00437
   5559.50000     31.03125    301.79761    263.31183    219.09305    179.50000     61.62500     44.43750      7.85547      0.01943     -0.02158      0.00599      5.12109      2.67678      0.00401
   5560.00000     34.21875    328.41589    292.01440    227.32965    179.50000     58.21875     43.96875      7.85547      0.02565     -0.02664      0.00611      4.76563      2.66614      0.00480
   5560.50000     40.50000    343.85339    308.84680    227.32965    179.12500     82.12500     58.81250      7.85547      0.02346     -0.02449      0.00633      4.42578      2.66988      0.00503
   5561.00000     42.56250    373.98645    327.73798    267.56506    178.87500     44.43750     48.84375      7.85547      0.02513     -0.02284      0.00654      4.53906      2.66702      0.00594
   5561.50000     42.56250    427.87781    360.84442    267.56506    178.75000     80.93750     64.81250      7.85547      0.02356     -0.01735      0.00589      4.82422      2.66971      0.00570
   5562.00000     42.71875    474.43817    386.89862    293.54230    178.87500     89.68750     92.25000      7.85547      0.02405     -0.01548      0.00565      4.64453      2.66888      0.00366
   5562.50000     42.90625    524.19055    493.87054    293.54230    180.75000     78.81250     72.87500      7.85547      0.02049     -0.01175      0.00552      4.45703      2.67497      0.00267
   5563.00000     47.31250    491.50598    573.09180    308.51898    181.37500     52.87500     45.43750      7.85547      0.01873     -0.01144      0.00502      4.11328      2.67797      0.00309
   5563.50000     43.90625    479.99426    573.09180    343.57800    182.12500     63.90625     53.59375      7.85547      0.01765     -0.01145      0.00478      4.28906      2.67981      0.00288
   5564.00000     41.59375    389.63452    452.19629    444.63074    182.75000     82.56250     72.43750      7.85547      0.02003     -0.01423      0.00477      4.32031      2.67576      0.00347
   5564.50000     35.06250    351.52466    327.73798    343.57800    183.37500     86.50000     78.81250      7.85547      0.01822     -0.01579      0.00660      4.42188      2.67884      0.00510
   5565.00000     37.37500    304.49011    284.26782    267.56506    183.87500     51.84375     42.18750      7.85547      0.01019     -0.01505      0.00791      4.58594      2.69257      0.00761
   5565.50000     37.37500    267.49548    276.92151    204.28946    184.37500     83.93750     61.00000      7.85547      0.00377     -0.01478      0.00913      4.48828      2.70356      0.00910
   5566.00000     39.40625    242.17798    229.47620    204.28946    184.62500     63.53125     72.87500      7.85547      0.00571     -0.01572      0.00904      4.49219      2.70023      0.01151
   5566.50000     39.12500    210.75180    195.90765    191.35971    184.62500     61.87500     46.78125      7.85547      0.00822     -0.01252      0.00925      4.39453      2.69594      0.01194
   5567.00000     38.09375    202.01160    176.53751    169.85861    184.75000     48.81250     51.62500      7.85547      0.00962     -0.01227      0.00932      4.16016      2.69355      0.01229
   5567.50000     37.09375    201.81229    176.53751    145.35974    184.87500     44.81250     43.59375      7.85547      0.00484     -0.00956      0.00964      4.23828      2.70172      0.01086
   5568.00000     37.28125    210.75180    192.38950    148.94003    184.87500     34.31250     35.81250      7.85547      0.00218     -0.00888      0.00899      4.35938      2.70627      0.01014
   5568.50000     39.62500    205.87411    220.05023    179.96927    184.62500     80.56250     67.87500      7.85547      0.00244     -0.00757      0.00833      4.57031      2.70583      0.00918
   5569.00000     40.65625    238.23157    245.23273    219.09305    184.00000     35.00000     49.09375      7.85547      0.00498     -0.00978      0.00745      4.44531      2.70148      0.00820
   5569.50000     36.40625    252.32855    300.19482    245.81177    183.87500     60.81250     51.93750      7.85547      0.00508     -0.00842      0.00660      4.30859      2.70131      0.00605
   5570.00000     33.93750    330.00336    373.41772    308.51898    183.25000     75.75000     68.50000      7.84375      0.00712     -0.00771      0.00531      4.41797      2.69783      0.00381
   5570.50000     36.21875    437.00311    605.46497    387.62665    182.75000     90.81250     69.56250      7.73438      0.01439     -0.00638      0.00413      3.79102      2.68539      0.00195
   5571.00000     45.78125    537.94861    729.00281    570.46997    182.12500     89.00000     68.68750      7.72266      0.02640     -0.00611      0.00336      3.10156      2.66485      0.00068
   5571.50000     46.90625    463.70288    843.77356    570.46997    181.75000     38.12500     45.21875      7.71094      0.03173     -0.00227      0.00348      3.03906      2.65575     -0.00011
   5572.00000     39.43750    475.53912    782.20068    570.46997    181.62500     78.62500     52.34375      7.75391      0.02379     -0.00022      0.00437      3.39844      2.66931      0.00025
   5572.50000     33.06250    345.59387    544.00439    521.29138    181.62500    115.31250     88.37500      7.80078      0.01006      0.00166      0.00511      4.04297      2.69279      0.00218
   5573.00000     34.37500    273.20691    292.01440    414.17645    181.37500    113.43750    110.06250      7.80469     -0.00247      0.00109      0.00661      4.20313      2.71422      0.00424
   5573.50000     39.59375    256.11700    185.71906    236.20972    181.50000     85.68750     72.31250      7.76563     -0.00331     -0.00206      0.00892      4.18359      2.71566      0.00790
   5574.00000     42.68750    251.09045    158.27817    138.69186    181.37500     59.18750     68.68750      7.80469      0.00302     -0.00851      0.01032      4.40625      2.70484      0.01140
   5574.50000     44.71875    237.12747    176.53751    104.98201    181.25000     42.59375     36.65625      7.78125      0.00353     -0.00964      0.01007      4.80859      2.70397      0.01189
   5575.00000     41.62500    231.23331    234.49854    129.76318    181.00000     61.87500     49.09375      7.77734      0.00794     -0.01125      0.00815      5.11328      2.69643      0.00956
   5575.50000     33.12500    204.22995    250.97684    197.61334    180.62500     87.00000     60.34375      7.79297      0.01601     -0.01572      0.00687      5.23828      2.68262      0.00706
   5576.00000     28.76563    191.60437    263.31183    325.10608    180.12500     85.25000     63.06250      7.80078      0.01808     -0.01370      0.00688      4.67188      2.67908      0.00599
   5576.50000     28.81250    221.47333    256.99646    343.57800    179.37500     98.37500     79.18750      7.78125      0.01982     -0.01259      0.00741      4.73828      2.67611      0.00685
   5577.00000     33.06250    256.75952    292.01440    267.56506    178.50000     53.15625     41.06250      7.77344      0.01283     -0.00831      0.00846      4.64844      2.68806      0.00780
   5577.50000     34.12500    268.19635    300.19482    245.81177    177.50000     31.43750     36.00000      7.78906      0.02151     -0.01151      0.00808      4.12109      2.67321      0.00996
   5578.00000     35.21875    259.36200    292.01440    245.81177    176.37500     30.76563     37.62500      7.83203      0.02926     -0.00877      0.00891      3.50781      2.65996      0.01034
   5578.50000     34.34375    215.86584    250.97684    236.20972    175.25000     83.56250     67.12500      7.71094      0.04279     -0.00871      0.00930      2.71484      2.63682      0.01187
   5579.00000     36.53125    175.64209    203.34442    219.09305    174.12500     72.43750     70.43750      7.73438      0.05271     -0.00915      0.01100      2.69922      2.61987      0.01190
   5579.50000     34.25000    141.87149    168.22070    191.35971    173.50000     79.43750     71.12500      7.83203      0.05313     -0.00719      0.01209      2.94141      2.61915      0.01453
   5580.00000     35.15625    117.74147    136.14713    174.76782    172.87500     49.53125     44.34375      7.84375      0.04832     -0.00298      0.01528      3.57422      2.62737      0.01695
   5580.50000     29.73438    110.53555    106.38930    141.94754    172.25000     41.00000     40.65625      7.83203      0.04523     -0.00015      0.01703      3.79688      2.63265      0.02160
   5581.00000     28.70313    115.28099     95.90594    117.18924    172.25000     29.90625     34.75000      7.84375      0.05376     -0.00330      0.01626      3.73633      2.61807      0.02211
   5581.50000     26.56250    118.90742     99.47032    104.98201    172.62500     37.09375     37.06250      7.84375      0.06087     -0.00531      0.01329      4.00391      2.60591      0.01895
   5582.00000     28.82813    123.36220    119.44371    108.75833    173.37500     31.92188     38.12500      7.84375      0.05424     -0.00905      0.01048      4.37500      2.61725      0.01409
   5582.50000     34.09375    122.32742    145.38779    141.94754    174.62500     59.93750     65.68750      7.82031      0.03685     -0.00763      0.00853      4.43750      2.64698      0.01034
   5583.00000     38.28125    124.64243    163.09811    219.09305    176.25000     65.68750     84.00000      7.82031      0.01852     -0.00853      0.00750      4.28906      2.67833      0.00840
   5583.50000     39.37500    121.59883    170.90457    293.54230    177.75000     65.25000     91.68750      7.82031      0.00684     -0.01151      0.00714      4.35938      2.69830      0.00849
   5584.00000     37.31250    131.88730    155.97342    279.95233    178.87500     65.31250    105.12500      7.82031      0.00047     -0.01224      0.00801      4.35156      2.70919      0.00905
   5584.50000     40.46875    146.02875    151.55951    191.35971    180.25000     60.78125     77.87500      7.83203      0.00235     -0.00978      0.00933      4.73438      2.70599      0.01079
   5585.00000     41.46875    157.75183    158.27817    141.94754    180.87500     37.31250     44.53125      7.83203      0.01049     -0.01153      0.00975      4.75000      2.69207      0.01135
   5585.50000     42.53125    171.22940    199.55676    132.60889    181.75000     47.90625     40.84375      7.82031      0.01462     -0.01130      0.00900      5.01172      2.68499      0.00988
   5586.00000     40.46875    169.66638    234.49854    156.65717    181.87500     51.43750     45.37500      7.83203      0.01160     -0.00642      0.00764      4.97656      2.69016      0.00871
   5586.50000     41.46875    148.46909    276.92151    219.09305    182.37500     36.68750     40.12500      7.85547      0.01504     -0.00666      0.00674      4.76172      2.68428      0.00663
   5587.00000     43.65625    120.87886    229.47620    308.51898    182.37500     34.21875     42.40625      7.85547      0.01413     -0.00772      0.00568      4.27734      2.68584      0.00537
   5587.50000     43.84375     90.75958    160.65201    387.62665    182.50000     45.34375     54.25000      7.85547      0.01480     -0.00645      0.00648      4.17188      2.68470      0.00460
   5588.00000     42.84375     72.06541     97.65564    267.56506    182.37500     40.15625     47.43750      7.85547      0.01300     -0.00818      0.00875      4.06641      2.68778      0.00841
   5588.50000     40.62500     57.83340     58.29018    127.03708    182.37500     55.90625     62.28125      7.85547      0.01158     -0.00889      0.01441      4.21484      2.69020      0.01502
   5589.00000     35.21875     50.04346     41.37153     60.10897    182.12500     24.48438     24.87500      7.85547      0.00328     -0.00562      0.01984      4.22266      2.70439      0.02329
   5589.50000     32.03125     46.29268     35.23129     36.29628    182.37500     27.73438     20.64063      7.85547      0.00155     -0.00530      0.02364      4.05078      2.70734      0.02962
   5590.00000     34.28125     44.40394     35.34790     28.85000    181.62500     21.25000     17.67188      7.85547      0.00371     -0.00583      0.02019      3.84961      2.70366      0.03068
   5590.50000     35.31250     43.99845     40.12849     30.75768    180.62500     38.56250     27.75000      7.85547      0.00439     -0.00673      0.01586      3.84961      2.70249      0.02345
   5591.00000     40.53125     44.50159     46.60335     42.10976    179.50000     52.06250     36.96875      7.85547      0.00579     -0.00970      0.01211      4.10938      2.70010      0.01863
   5591.50000     36.31250     46.46263     55.56461     68.25014    177.62500     50.15625     38.34375      7.85547      0.00292     -0.00897      0.01122      4.64844      2.70501      0.01545
   5592.00000     37.37500     49.69986     66.64252    108.75833    176.00000     55.81250     44.87500      7.85547      0.01135     -0.01109      0.01014      4.48047      2.69058      0.01419
   5592.50000     35.34375     49.12162     76.12500    145.35974    174.62500     60.96875     49.50000      7.85547      0.01990     -0.01249      0.00995      4.28125      2.67597      0.01325
   5593.00000     34.03125     41.04299     68.78477    165.21765    173.25000     46.43750     46.84375      7.84375      0.02559     -0.01094      0.01076      4.23828      2.66625      0.01429
   5593.50000     33.93750     30.55630     42.52400    132.60889    171.75000     75.43750     60.75000      7.85547      0.01702     -0.00693      0.01551      4.50000      2.68089      0.01721
   5594.00000     31.62500     22.84585     24.76482     66.01486    170.50000     65.62500     50.50000      7.85547      0.01350     -0.00888      0.02688      4.43750      2.68691      0.02717
   5594.50000     29.59375     18.27340     16.15749     30.44794    169.62500     33.25000     24.17188      7.85547      0.00516     -0.00587      0.04816      3.91602      2.70118      0.04380
   5595.00000     26.51563     15.87236     12.41604     17.80613    169.12500     27.93750     16.40625      7.85547      0.00449     -0.00499      0.06558      3.68945      2.70231      0.06389
   5595.50000     25.53125     14.72517     11.24359     13.72437    168.75000     24.78125     16.57813      7.85547      0.00083     -0.00585      0.07108      3.83008      2.70858      0.07153
   5596.00000     25.48438     14.17875     11.53751     12.82222    168.62500     19.82813     11.00781      7.85547      0.00345     -0.00432      0.05719      4.05078      2.70409      0.06453
   5596.50000     28.60938     13.98706     12.89930     13.94594    168.87500     23.32813     12.79688      7.85547      0.00713     -0.00549      0.03714      4.19531      2.69781      0.04611
   5597.00000     28.67188     14.33271     15.16597     17.65020    169.37500     26.48438     15.69531      7.85547      0.01193     -0.01169      0.02000      4.46875      2.68961      0.03147
   5597.50000     32.96875     15.64349     18.52093     26.56837    169.87500     43.46875     25.43750      7.85547      0.01591     -0.01532      0.01356      5.11719      2.68280      0.02034
   5598.00000     30.95313     18.54308     23.56064     44.92542    169.50000     57.65625     43.21875      7.85547      0.01195     -0.01245      0.01080      5.38672      2.68956      0.01503
   5598.50000     31.01563     23.79499     31.30565     74.10493    169.12500     54.46875     39.78125      7.85547      0.01919     -0.01416      0.00994      4.97266      2.67718      0.01313
   5599.00000     26.79688     31.58779     43.56410     99.78487    168.75000     42.50000     34.68750      7.85547      0.01981     -0.01597      0.01111      4.41406      2.67612      0.01282
   5599.50000     23.50000     42.92490     61.29659    112.81650    168.37500     66.87500     60.40625      7.85547      0.01813     -0.01236      0.01100      4.63281      2.67900      0.01413
   5600.00000     25.56250     52.57391     85.21703    124.42314    167.50000     80.37500     67.50000      7.85547      0.00661     -0.00863      0.01054      4.90625      2.69870      0.01308
   5600.50000     25.59375     56.09146    106.38930    141.94754    166.37500     55.93750     50.21875      7.85547      0.01270     -0.01135      0.01004      4.97266      2.68827      0.01172
   5601.00000     26.64063     57.83340    114.34204    174.76782    165.00000     82.18750     67.31250      7.85547      0.02154     -0.01566      0.01001      4.61328      2.67316      0.01138
   5601.50000     23.43750     57.47319    113.13396    191.35971    163.62500     90.12500     64.56250      7.85547      0.02512     -0.01011      0.00953      4.54297      2.66704      0.01192
   5602.00000     24.53125     59.30291    110.79274    185.48981    162.62500     95.93750     79.12500      7.85547      0.01714     -0.00590      0.00987      4.69531      2.68070      0.01196
   5602.50000     28.93750     61.28925    116.83722    174.76782    161.75000     78.00000     70.00000      7.85547      0.01337     -0.00587      0.00970      4.67578      2.68714      0.01208
   5603.00000     27.87500     63.85085    119.44371    185.48981    161.00000     66.68750     65.75000      7.85547      0.01209     -0.00459      0.00971      4.72266      2.68933      0.01134
   5603.50000     26.71875     63.05832    107.45705    197.61334    160.25000     90.93750     89.43750      7.85547      0.01189     -0.00191      0.00936      5.10156      2.68967      0.01118
   5604.00000     23.50000     59.32022     89.49184    174.76782    159.37500     83.68750     78.50000      7.85547      0.01565     -0.00400      0.00941      5.08984      2.68324      0.01165
   5604.50000     23.43750     55.20646     76.12500    121.91460    158.25000     59.96875     58.68750      7.85547      0.02202     -0.00957      0.01034      5.19531      2.67235      0.01306
   5605.00000     24.50000     49.43317     66.64252     90.79524    157.37500     49.34375     41.06250      7.85547      0.02078     -0.00908      0.01131      4.87500      2.67447      0.01476
   5605.50000     25.40625     43.19070     57.97423     78.94208    156.25000     44.28125     51.28125      7.85547      0.02364     -0.00963      0.01308      5.04688      2.66957      0.01595
   5606.00000     28.65625     35.39493     52.56041     69.82635    154.37500     42.50000     40.00000      7.85547      0.02756     -0.01310      0.01562      5.23438      2.66288      0.01855
   5606.50000     29.71875     25.80726     44.65627     62.59795    152.12500     40.81250     33.15625      7.85547      0.03348     -0.01566      0.01690      4.99219      2.65274      0.02233
   5607.00000     29.71875     17.83641     33.46465     54.18425    149.37500     38.09375     32.93750      7.85547      0.03280     -0.01619      0.01848      4.47266      2.65391      0.02376
   5607.50000     26.57813     11.95105     21.60228     50.55988    146.25000     33.31250     26.53125      7.85547      0.02719     -0.01640      0.02055      4.23047      2.66351      0.02724
   5608.00000     26.64063      8.02752     12.56315     47.38998    142.75000     34.46875     34.25000      7.85547      0.02579     -0.01069      0.03391      3.89648      2.66591      0.03690
   5608.50000     26.78125      5.62814      7.38818     32.23326    139.87500     24.15625     25.15625      7.80078      0.03751     -0.00568      0.12260      3.78320      2.64586      0.06425
   5609.00000     27.73438      4.15270      4.78753     15.01977    137.37500      7.92578     12.35156      7.67188      0.09971     -0.00988      0.21829      3.12695      2.53950      0.12671
   5609.50000     25.54688      3.15364      3.45275      8.17599    135.75000      4.87109      6.37500      7.73438      0.15686     -0.00736      0.30225      2.89648      2.44177      0.23597
   5610.00000     26.57813      2.48236      2.64134      6.28843    135.00000      5.08203      5.67969      7.70703      0.20296     -0.00603      0.29242      2.68945      2.36293      0.32729
   5610.50000     27.56250      2.04423      2.10148      5.82783    135.25000      8.07031      8.07031      7.70703      0.20920     -0.00725      0.25865      2.69141      2.35227      0.26654
   5611.00000     31.98438      1.74583      1.77690      5.17896    136.37500      6.20313      7.14453      7.80469      0.19124     -0.00159      0.21699      2.60352      2.38298      0.23286
   5611.50000     35.31250      1.55769      1.59276      4.29899    137.50000      4.81641      5.23047      7.85547      0.15991      0.00569      0.20529      2.36914      2.43655      0.20807
   5612.00000     38.65625      1.45769      1.48828      4.05673    138.75000      5.37500      5.62500      7.85547      0.14698      0.00129      0.20496      2.41992      2.45867      0.20342
   5612.50000     39.56250      1.43223      1.43639      4.23279    140.37500      5.36328      5.67969      7.85547      0.14147     -0.00057      0.21952      2.42969      2.46808      0.20056
   5613.00000     38.37500      1.49113      1.44892      4.29289    142.12500      5.21484      5.53516      7.85547      0.15323     -0.00359      0.21558      2.53516      2.44797      0.20254
   5613.50000     43.71875      1.62609      1.56150      4.15427    145.00000      5.37500      5.48438      7.72266      0.16631     -0.00555      0.18935      2.44727      2.42561      0.18300
   5614.00000     46.84375      1.81132      1.79938      4.13439    148.75000      5.23047      5.62500      7.60547      0.16696     -0.00954      0.14198      2.62500      2.42450      0.14013
   5614.50000     48.93750      2.02780      2.14947      4.81216    152.75000      6.04297      6.16406      7.82031      0.12901     -0.00679      0.09710      2.87695      2.48939      0.10232
   5615.00000     47.87500      2.27865      2.54878      6.00135    156.37500     16.35938     12.31250      7.85547      0.08062     -0.00245      0.08561      3.06250      2.57213      0.08955
   5615.50000     49.00000      2.63048      2.89108      6.85130    159.37500     21.75000     10.77344      7.85547      0.04860      0.00141      0.09820      2.83203      2.62690      0.09615
   5616.00000     53.12500      3.24975      3.18069      6.45629    160.37500     15.73438     12.53125      7.76172      0.06826     -0.00200      0.13079      2.71680      2.59328      0.11228
   5616.50000     49.00000      4.19926      3.61735      5.67470    161.00000     11.10156      9.07813      7.70703      0.08190     -0.00524      0.13426      2.81055      2.56995      0.12176
   5617.00000     47.03125      5.36885      4.45749      5.63241    161.25000     11.25000      8.66406      7.73438      0.07933     -0.00283      0.11423      3.24609      2.57434      0.09943
   5617.50000     47.09375      6.45642      5.78108      6.34785    162.12500     10.84375      9.55469      7.81641      0.05400      0.00322      0.06632      3.81836      2.61767      0.07460
   5618.00000     50.28125      7.17147      7.44567      9.63505    162.75000     15.77344     13.22656      7.76172      0.03832      0.01025      0.04446      4.14063      2.64448      0.04946
   5618.50000     51.40625      7.68235      9.11233     16.72279    162.25000     19.57813     20.60938      7.72266      0.03988      0.00478      0.03519      4.18359      2.64181      0.04298
   5619.00000     50.21875      8.69878     10.38335     26.68562    160.87500     15.05469     15.05469      7.70703      0.03830      0.00134      0.04502      4.01563      2.64451      0.04214
   5619.50000     51.00000     10.25952     11.07891     26.10950    158.50000     22.75000     24.04688      7.70703      0.02985      0.00285      0.05823      3.76953      2.65895      0.05276
   5620.00000     46.46875     10.96683     11.19604     20.52600    156.25000     10.14063     11.67188      7.75391      0.02612      0.00121      0.06724      3.60547      2.66534      0.06383
   5620.50000     40.31250     10.90709     10.23270     18.07220    153.37500      9.61719     10.93750      7.78906      0.03097     -0.00399      0.07853      3.83594      2.65703      0.07378
   5621.00000     32.93750     10.96435      8.72813     14.54995    151.25000     14.44531     16.51563      7.71094      0.03626     -0.00383      0.08392      3.83594      2.64800      0.08423
   5621.50000     28.76563     10.58521      8.30882     11.39646    150.37500     10.24219     14.87500      7.69531      0.05046     -0.00569      0.07900      3.83789      2.62371      0.08228
   5622.00000     25.64063     10.12212      8.97296     10.65356    150.12500      9.14063     10.32813      7.72266      0.04570     -0.00260      0.05386      3.72852      2.63185      0.06515
   5622.50000     27.76563      9.79824      9.99105     13.94594    150.87500     22.92188     19.42188      7.73438      0.04013     -0.00085      0.04006      3.91992      2.64139      0.04326
   5623.00000     34.00000      9.51311     10.53847     18.34636    151.87500     32.43750     23.56250      7.70703      0.02250      0.00166      0.04021      3.91602      2.67153      0.04169
   5623.50000     40.18750      9.63194     11.05578     18.23571    152.12500     16.01563     16.18750      7.70703      0.02830     -0.00539      0.04798      3.97070      2.66161      0.04612
   5624.00000     37.03125     10.18500     11.92711     18.07220    151.75000     18.06250     12.22656      7.70703      0.01885     -0.00566      0.04569      4.23438      2.67776      0.05244
   5624.50000     29.71875     10.15773     11.37643     20.80854    150.00000     29.71875     23.34375      7.70703      0.02121     -0.00731      0.05085      4.36719      2.67374      0.05185
   5625.00000     22.34375      9.45847      9.62713     21.78300    148.00000     23.73438     22.12500      7.70703      0.02614     -0.00760      0.06024      4.11719      2.66531      0.05937
   5625.50000     22.42188      8.67633      8.23742     18.86139    146.62500     11.06250     14.28125      7.70703      0.04309     -0.00803      0.07301      3.93750      2.63632      0.06955
   5626.00000     24.46875      7.99351      7.35719     15.01977    145.75000      9.27344     11.24219      7.70703      0.05107     -0.00590      0.08027      3.97266      2.62267      0.07811
   5626.50000     23.40625      7.44103      6.82259     12.84947    145.62500      9.92188     10.53906      7.70703      0.05815     -0.00501      0.08532      4.02734      2.61057      0.08027
   5627.00000     23.37500      7.21968      6.51778     12.00747    146.62500     10.10938     10.75781      7.70703      0.06123     -0.00578      0.08971      4.00391      2.60529      0.08279
   5627.50000     23.56250      7.26740      6.60802     12.32564    148.25000     12.83594     12.92188      7.70703      0.05771     -0.00495      0.08549      3.89648      2.61132      0.08491
   5628.00000     24.73438      7.25875      7.11343     13.21451    150.62500     14.82031     13.08594      7.70703      0.05233     -0.00289      0.08227      3.97266      2.62051      0.07972
   5628.50000     22.56250      6.96379      7.81013     14.44567    154.00000     14.96094     13.56250      7.70703      0.04381     -0.00420      0.06908      4.19922      2.63508      0.07602
   5629.00000     21.35938      6.32852      7.96963     16.36082    157.75000     16.00000     14.07031      7.00000      0.04279     -0.00402      0.06531      4.44531      2.63683      0.06456
   5629.50000     21.29688      5.37042      6.98120     18.68653    160.62500     18.68750     16.64063      6.71094      0.03800     -0.00583      0.05956      4.48047      2.64503      0.06142
   5630.00000     28.76563      4.63773      5.16693     17.05291    163.25000     19.68750     17.62500      6.81250      0.05122      0.00364      0.09243      3.83594      2.62241      0.06793
   5630.50000     34.09375      4.41783      3.75128      8.07769    165.12500     20.60938     18.98438      7.37500      0.07483      0.01088      0.16897      3.20508      2.58203      0.10748
   5631.00000     40.53125      4.62259      3.22358      4.22983    164.87500     13.64063     11.90625      7.66406      0.10178      0.01324      0.21158      2.82422      2.53596      0.17498
   5631.50000     41.68750      4.94828      3.45390      6.67730    165.12500      3.22852      2.26172      7.72266      0.10113      0.01553      0.19384      3.05859      2.53707      0.17265
   5632.00000     44.93750      5.13494      4.36211      5.02406    163.87500      7.09766      4.96094      7.73438      0.06255      0.03446      0.10624      3.95313      2.60304      0.10878
   5632.50000     48.90625      5.16750      5.55997     10.34376    163.00000     69.62500     53.81250      7.82031      0.03820      0.01488      0.04224      4.74219      2.64468      0.05562
   5633.00000     48.81250      5.47944      6.64145     32.40601    164.12500     59.53125     71.62500      7.84375      0.02133      0.00300      0.01493      4.78125      2.67352      0.03205
   5633.50000     53.96875      6.93740      8.62118     85.65103    165.00000     78.06250     74.81250      7.84375      0.01713     -0.00236      0.01201      4.51953      2.68071      0.01982
   5634.00000     50.96875     11.24469     13.54136     89.45212    165.62500     40.71875     53.71875      7.85547      0.01728     -0.00505      0.01117      4.69922      2.68045      0.01631
   5634.50000     46.50000     22.95082     26.03460     95.07803    166.00000     38.75000     43.40625      7.82031      0.01573     -0.00614      0.01087      4.67578      2.68310      0.01347
   5635.00000     33.78125     55.44781     54.71179    127.03708    166.00000     54.53125     68.31250      7.70703      0.01499     -0.00622      0.00951      5.02344      2.68436      0.01127
   5635.50000     27.43750     80.02765    110.79274    179.96927    165.75000     46.68750     61.28125      7.70703      0.01310     -0.00652      0.01146      5.03906      2.68760      0.01099
   5636.00000     28.73438     36.34518     83.88135    219.09305    164.62500     48.81250     33.40625      7.70703      0.01722     -0.00958      0.01519      4.86328      2.68056      0.01930
   5636.50000     30.89063     18.43462     29.40785    121.91460    163.25000     40.18750     32.28125      7.70703      0.01726     -0.00668      0.02859      3.90039      2.68049      0.03168
   5637.00000     31.95313     11.91383     13.37075     45.26169    161.50000     16.87500     17.62500      7.70703      0.02016     -0.00025      0.05675      3.46484      2.67553      0.05150
   5637.50000     33.06250      9.05939      7.92766     20.59591    159.62500     11.19531      9.88281      7.70703      0.02696      0.00542      0.08765      3.31250      2.66391      0.06920
   5638.00000     33.12500      7.94284      5.74618     12.71438    158.00000      7.35156      6.71484      7.70703      0.03328      0.00864      0.11812      3.02539      2.65310      0.09936
   5638.50000     35.18750      7.71166      5.06909      9.63505    156.50000      7.29688      6.21484      7.67188      0.04142      0.02220      0.14298      2.77734      2.63918      0.13125
   5639.00000     30.93750      7.81339      5.40760      8.11019    155.62500      6.58984      6.01953      7.69531      0.05823      0.01797      0.14963      2.54297      2.61043      0.13223
   5639.50000     29.70313      8.02854      6.68371      7.99228    156.00000      6.24609      5.44531      7.69531      0.07777      0.00444      0.11865      2.78906      2.57701      0.11455
   5640.00000     29.87500      8.25149      8.38145     10.56053    156.87500      6.66016      6.14453      7.71094      0.08248     -0.00382      0.07042      2.90820      2.56895      0.07286
   5640.50000     29.87500      8.81558      9.94407     19.28240    158.25000     13.07813     12.42188      7.77734      0.08149     -0.00662      0.03136      3.17969      2.57065      0.04447
   5641.00000     30.07813     10.65969     12.13188     35.65425    159.00000     18.28125     12.85156      7.68359      0.09003     -0.01843      0.02311      2.99414      2.55604      0.03261
   5641.50000     29.00000     14.75164     15.93942     41.53133    159.25000     18.34375     12.81250      7.67188      0.09876     -0.02504      0.02465      2.98438      2.54113      0.03091
   5642.00000     35.37500     22.01468     21.64618     33.48262    159.25000     18.34375     12.81250      7.70703      0.09405     -0.01546      0.02663      2.99805      2.54918      0.03355
   5642.50000     38.50000     31.66731     27.79879     28.04713    158.75000     18.34375     12.81250      7.65234      0.08301     -0.00361      0.03093      3.28125      2.56805      0.03549
   5643.00000     38.31250     37.61184     30.41358     25.66622    157.50000     18.34375     12.81250      7.55469      0.07783      0.00090      0.03595      3.69336      2.57691      0.03891
   5643.50000     35.06250     32.51115     27.51201     25.34351    155.75000     18.34375     12.79688      7.58594      0.06203      0.00325      0.04106      4.15234      2.60392      0.04380
   5644.00000     31.95313     24.24489     22.65895     26.22272    153.12500     18.34375     12.79688      7.64453      0.05308      0.01078      0.04809      4.35547      2.61924      0.04788
   5644.50000     32.09375     17.95427     18.11111     27.16514    150.75000     18.34375     12.81250      7.58594      0.05557      0.01037      0.05569      4.57422      2.61497      0.05469
   5645.00000     27.81250     13.75688     14.44415     27.53625    148.00000     18.34375     12.81250      7.55469      0.07880      0.00208      0.06346      4.70313      2.57525      0.06093
   5645.50000     28.73438     10.82561     11.51243     27.78934    146.00000     18.35938     12.78125      7.55469      0.08644     -0.00264      0.06708      5.03516      2.56219      0.06324
   5646.00000     29.71875      8.93504      8.91236     25.99725    144.12500     18.34375     12.76563      7.64063      0.08098     -0.00191      0.08191      4.97656      2.57153      0.07201
   5646.50000     32.96875      8.01503      6.87167     19.22111    143.00000     18.34375     12.76563      7.61328      0.06903     -0.00262      0.10670      3.97070      2.59195      0.09319
   5647.00000     33.06250      7.89149      5.86526     11.93636    142.87500     18.39063     12.78125      7.64063      0.06856     -0.00437      0.13085      3.18555      2.59276      0.11387
   5647.50000     33.09375      8.16047      6.07611      8.54573    143.37500     18.32813     12.78125      7.55469      0.07164     -0.00551      0.10708      3.21484      2.58750      0.11463
   5648.00000     34.06250      8.38623      7.17653      9.48394    144.00000     18.39063     12.76563      7.55469      0.06857     -0.00173      0.06677      3.83203      2.59274      0.05402
   5648.50000     31.95313      8.48672      8.68504     15.92982    144.87500     18.32813     12.76563      7.59375      0.05880      0.00547      0.02455      4.83984      2.60945      0.03087
   5649.00000     31.95313      8.71341      9.68003     30.14437    145.37500     18.32813     12.76563      7.59766      0.04564      0.00778      0.01972      4.50781      2.63195      0.01936
   5649.50000     31.95313      9.74186     10.40377     39.11359    145.37500     18.31250     12.76563      7.64453      0.03598      0.00834      0.01833      4.07813      2.64847      0.03352
   5650.00000     33.00000     12.07080     11.29154     26.80390    145.25000     18.29688     12.76563      7.63281      0.03098      0.00998      0.01840      3.65039      2.65703      0.03338
   5650.50000     33.06250     15.29545     12.62296     18.51488    145.12500     18.31250     12.76563      7.69531      0.03328      0.00514      0.01772      3.30664      2.65310      0.02393
   5651.00000     32.06250     19.11029     14.52316     17.14963    145.62500     18.28125     12.76563      7.67188      0.04354     -0.00095      0.01809      3.12891      2.63555      0.02358
   5651.50000     33.25000     22.61309     17.14768     20.73717    146.50000     18.28125     12.74219      7.66016      0.04601      0.00045      0.01717      3.32422      2.63133      0.02370
   5652.00000     34.18750     24.34815     20.40224     28.71301    147.37500     18.25000     12.72656      7.56250      0.04068     -0.00047      0.01703      3.58398      2.64044      0.01847
   5652.50000     32.15625     24.50017     23.77081     39.11359    147.87500     18.25000     12.72656      7.53516      0.04459     -0.00543      0.01747      4.09375      2.63375      0.01793
   5653.00000     31.76563     25.03637     26.16234     48.14460    147.50000     18.26563     12.71094      7.52344      0.04047     -0.00289      0.01969      3.76758      2.64079      0.01790
   5653.50000     30.95313     26.50336     27.94442     56.19852    146.12500     18.25000     12.71094      7.66016      0.04808     -0.00632      0.01883      3.72852      2.62779      0.03062
   5654.00000     33.28125     26.42652     27.72654     52.30936    144.12500     18.25000     12.71094      7.59375      0.05528     -0.01080      0.01897      3.51758      2.61546      0.03001
   5654.50000     33.93750     25.13063     26.16234     45.26169    142.00000     18.23438     12.71094      7.55469      0.06622     -0.00855      0.01774      3.09570      2.59677      0.02377
   5655.00000     33.06250     24.20090     22.18713     33.11589    139.75000     18.21875     12.71094      7.57422      0.09268     -0.00406      0.01803      2.75977      2.55151      0.02386
   5655.50000     33.06250     22.56200     18.29799     23.02727    137.37500     18.21875     12.71094      7.60547      0.11167     -0.00100      0.01782      2.31445      2.51905      0.02362
   5656.00000     33.06250     19.47342     16.23150     15.72272    135.50000     18.21875     12.71094      7.57422      0.12571      0.00587      0.01802      2.25586      2.49504      0.02321
   5656.50000     33.06250     15.07905     14.26946     17.24746    134.12500     18.20313     12.68750      7.53516      0.11636      0.01202      0.01791      2.00977      2.51102      0.02351
   5657.00000     33.06250     10.27477      9.80574     29.99484    133.50000     18.18750     12.65625      7.61328      0.09541      0.02481      0.01716      1.92676      2.54684      0.02257
   5657.50000     33.06250      6.46221      6.29872     35.86572    132.87500     18.14063     12.65625      7.67188      0.06765      0.03618      0.01682      1.97070      2.59433      0.02161
   5658.00000     33.06250      4.85245      4.61978     23.38345    132.50000     18.10938     12.65625      7.59375      0.06077      0.03869      0.01833      2.16797      2.60609      0.02197
   5658.50000     33.06250      4.16246      3.95933     12.84947    132.00000     18.10938     12.65625      7.56250      0.07923      0.03207      0.01881      2.42773      2.57452      0.02282
   5659.00000     33.06250      3.75716      3.68050      7.52484    131.75000     18.10938     12.65625      7.48438      0.10724      0.02032      0.01944      2.50781      2.52663      0.02290
   5659.50000     33.06250      3.57433      3.51392      5.27382    131.87500     18.10938     12.65625      7.51172      0.15231     -0.02700      0.01942      2.60352      2.44955      0.02325
   5660.00000     33.06250      3.55223      3.39252      5.39137    132.12500     18.10938     12.65625      7.58594      0.17495     -0.06860      0.01942      2.18750      2.41084      0.02371
   5660.50000     33.06250      3.55050      3.34732      6.17289    132.62500     18.10938     12.65625      7.55469      0.20700     -0.14350      0.01898      1.35156      2.35603      0.02490
   5661.00000     33.06250      3.55158      3.50199      7.23667    133.00000     18.10938     12.65625      7.55469      0.26281     -0.28608      0.01923      0.84033      2.26059      0.02427
   5661.50000     33.06250      3.55115      4.68842     12.10360    133.75000     18.10938     12.65625      7.55469      0.32152     -0.47577      0.01850      0.57080      2.16019      0.02518
   5662.00000     33.06250      3.54820      6.97656     25.66622    134.50000     18.10938     12.65625      7.56250      0.30992     -0.57040      0.01850      0.63330      2.18003      0.02411
   5662.50000     33.06250      3.54942      8.74259     41.24803    135.00000     18.10938     12.65625      7.57422      0.28831     -0.66322      0.01732      0.52783      2.21699      0.02287
   5663.00000     33.06250      3.56161      9.01124     43.62887    135.62500     18.10938     12.65625      7.61719      0.37138     -0.87544      0.01683      0.01709      2.07494      0.02214
   5663.50000     33.06250      3.58119      9.01894     43.62887    135.62500     18.10938     12.65625      7.58594      0.55934     -1.24701      0.01681   1000.00000      1.75353      0.02181
   5664.00000     33.06250      3.61759      9.01124     43.62887    135.12500     18.10938     12.65625      7.58594      0.93171     -2.08922      0.01693   1000.00000      1.11678      0.02202
   5664.50000     33.06250      3.64982      9.02665     43.94594    134.25000     18.10938     12.65625      7.55469     -1.00401      0.68612      0.01782   1000.00000      4.42685      0.02175
   5665.00000     33.06250      3.67115      9.01894     44.26765    133.37500     18.10938     12.65625      7.55469      0.64374     -1.08007      0.01826   1000.00000      1.60921      0.02203
   5665.50000     33.06250      3.68900      9.01124     44.92542    133.00000     18.10938     12.65625      7.53516     -0.02077      0.01898      0.01848   1000.00000      2.74551      0.02240
   5666.00000     33.06250      3.69573      9.03437     44.59411    132.62500     18.10938     12.65625     10.42188      0.61858     -1.06544      0.00279   1000.00000      1.65222      0.01281
   5666.50000     33.06250      3.69682      9.01894     44.59411    132.62500     18.10938     12.65625      7.30859      0.44165     -0.73469      0.01944   1000.00000      1.95479      0.02361
   5667.00000     33.06250      3.69853      9.01894     44.92542    132.50000     18.10938     12.65625      7.23828      0.42079     -0.69115      0.01984   1000.00000      1.99045      0.02330
   5667.50000     33.06250      3.70024      9.01894     44.59411    132.37500     18.10938     12.65625      7.23828      0.39352     -0.66916      0.01984   1000.00000      2.03709      0.02293
   5668.00000     33.06250      3.69511      9.01894     44.59411    132.12500     18.10938     12.65625      7.22656      0.37311     -0.65708      0.01990   1000.00000      2.07198      0.02293
   5668.50000     33.06250      3.69713      9.01124     44.59411    132.00000     18.10938     12.65625      7.19141      0.56263     -0.98052      0.02009   1000.00000      1.74791      0.02293
   5669.00000     33.06250      3.69387      9.00356     44.59411    131.87500     18.10938     12.65625      7.20703     -0.00908      0.01347      0.02001      1.03027      2.72553      0.02293
   5669.50000     33.06250      3.69721      9.02665     44.59411    131.75000     18.10938     12.65625      7.21484      1.26855     -3.31966      0.01997      2.48242      0.54079      0.02293
   5670.00000     33.06250      3.69713      9.02665     44.26765    131.87500     18.10938     12.65625     16.87500      0.43213     -0.97116     -0.00628      3.68750      1.97106     -0.00478
   5670.50000     33.06250      3.69721      9.01124     44.59411    132.00000     18.10938     12.65625      7.22656      0.36477     -0.52936      0.01990      3.55664      2.08625      0.02293
   5671.00000     33.06250      3.69713      9.02665     44.59411    132.12500     18.10938     12.65625      7.20703      0.21097     -0.21444      0.02001      3.56445      2.34924      0.02293
   5671.50000     33.06250      3.69713      9.01894     44.59411    132.12500     18.10938     12.65625      7.22656      0.09550     -0.02028      0.01990      3.36523      2.54670      0.02293
   5672.00000     33.06250      3.69705      9.02665     44.59411    132.25000     18.10938     12.65625      7.21875      0.03541      0.08048      0.01995      3.32813      2.64945      0.02293
   5672.50000     33.06250      3.69713      9.02665     44.59411    132.50000     18.10938     12.65625      7.21484      0.02986      0.08236      0.01997      3.35742      2.65894      0.02293
   5673.00000     33.06250      3.69542      9.02665     44.59411    132.62500     18.10938     12.65625      7.21875      0.02560      0.08678      0.01995      3.43555      2.66622      0.02293
   5673.50000     33.06250      3.69705      9.01124     44.59411    132.75000     18.10938     12.65625      7.21484      0.03217      0.07752      0.01997      3.72852      2.65498      0.02293
   5674.00000     33.06250      3.69698      9.00356     44.59411    132.87500     18.10938     12.65625      7.20703      0.03426      0.07452      0.02001      3.75781      2.65142      0.02293
   5674.50000     33.06250      3.69892      9.02665     44.59411    132.87500     18.10938     12.65625      7.22656      0.04894      0.06010      0.01990      3.71289      2.62632      0.02293
   5675.00000     33.06250      3.69713      9.02665     44.59411    132.87500     18.10938     12.65625      7.19141      0.05213      0.05955      0.02009      3.56250      2.62086      0.02293
   5675.50000     33.06250      3.69729      9.01124     44.59411    132.75000     18.10938     12.65625      7.20703      0.05583      0.05297      0.02001      3.52734      2.61453      0.02293
   5676.00000     33.06250      3.69542      9.03437     44.59411    132.75000     18.10938     12.65625      7.21484      0.05353      0.05300      0.01997      3.56055      2.61847      0.02293
   5676.50000     33.06250      3.69713      9.01124     44.59411    132.62500     18.10938     12.65625      7.22656      0.04688      0.06075      0.01990      3.56055      2.62984      0.02293
   5677.00000     33.06250      3.69542      9.01124     44.59411    132.37500     18.10938     12.65625      7.22656      0.03823      0.07113      0.01990      3.63867      2.64462      0.02293
   5677.50000     33.06250      3.69713      9.01894     44.92542    132.12500     18.10938     12.65625      7.21484      0.03440      0.07544      0.01997      3.67773      2.65117      0.02293
   5678.00000     33.06250      3.69713      9.02665     44.59411    132.00000     18.10938     12.65625      7.20703      0.03727      0.07418      0.02001      3.58008      2.64627      0.02293
   5678.50000     33.06250      3.69713      9.03437     44.59411    131.87500     18.10938     12.65625      7.23828      0.04473      0.07010      0.01984      3.69531      2.63351      0.02293
   5679.00000     33.06250      3.69713      9.01894     44.92542    131.62500     18.10938     12.65625      7.21484      0.04388      0.06960      0.01997      3.52734      2.63496      0.02293
   5679.50000     33.06250      3.69721      9.01894     44.59411    131.75000     18.10938     12.65625      7.22656      0.04608      0.07083      0.01990      3.45508      2.63121      0.02293
   5680.00000     33.06250      3.69713      9.01894     44.26765    132.00000     18.10938     12.65625      7.22656      0.04201      0.07010      0.01990      3.41211      2.63816      0.02293
   5680.50000     33.06250      3.69713      9.01894     44.59411    132.12500     18.10938     12.65625      7.20313      0.03986      0.07002      0.02003      3.52930      2.64183      0.02293
   5681.00000     33.06250      3.69705      9.02665     44.59411    132.00000     18.10938     12.65625      7.20703      0.02985      0.08031      0.02001      3.77539      2.65895      0.02293
   5681.50000     33.06250      3.69713      9.02665     44.59411    131.87500     18.10938     12.65625      7.22656      0.03232      0.08029      0.01990      3.69727      2.65473      0.02293
   5682.00000     33.06250      3.69713      9.02665     44.59411    131.87500     18.10938     12.65625      7.20703      0.04153      0.07313      0.02001      3.70898      2.63899      0.02293
   5682.50000     33.06250      3.69721      9.02665     44.59411    132.00000     18.10938     12.65625      7.22656      0.04122      0.07021      0.01990      3.65625      2.63952      0.02293
   5683.00000     33.06250      3.69713      9.02665     44.59411    132.12500     18.10938     12.65625      7.23047      0.03448      0.07835      0.01988      3.61719      2.65103      0.02293
   5683.50000     33.06250      3.69721      9.02665     44.59411    132.37500     18.10938     12.65625      7.22266      0.03979      0.07078      0.01992      3.62500      2.64196      0.02293
   5684.00000     33.06250      3.69713      9.02665     44.59411    132.62500     18.10938     12.65625      7.22266      0.04799      0.06316      0.01992      3.62500      2.62793      0.02293
   5684.50000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000     18.10938     12.65625      7.22266      0.05396      0.05820      0.01992      3.62500      2.61772      0.02293
   5685.00000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000     18.10938     12.65625      7.22266      0.05276      0.06027      0.01992      3.62500      2.61979      0.02293
   5685.50000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000     18.10938     12.65625      7.22266      0.05616      0.05444      0.01992      3.62500      2.61397      0.02293
   5686.00000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000     18.10938     12.65625      7.22266      0.05616      0.05444      0.01992      3.62500      2.61397      0.02293
   5686.50000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000     18.10938     12.65625      7.22266      0.05616      0.05444      0.01992      3.83398      2.61397      0.02293
   5687.00000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000     18.10938     12.65625      7.22266      0.05616      0.05444      0.01992      4.11328      2.61397      0.02293
"""

LAS_01_200_FEET_UP = """# 03/10/1999 14:53:39 Updated by the Kansas Geological Survey
# #KGS#ID: 31S33W/1001178923
# Additions:   1001178923.add
# Old: WELL.                    GASKILL NO. 1-5: Well Name
# New: WELL.                                1-5: Well Name
# New: LEAS.                            GASKILL: Lease Name
#
# 03/04/1999 13:55:28 Updated by the Kansas Geological Survey
# Additions:   1001178923.add
# New: UWI .                       15-175-21301: Unique Well Id
# New: PM  .                                  6: Principal Meridian
# Old: STAT.                             KANSAS: STATE
# New: STAT.                             Kansas: State
#
# 02/25/1999 15:08:23 Updated by the Kansas Geological Survey
# #KGS#INPUT_FILE: /home/crude2_3/WellLogs/Guy/105-Ddrive/Hugelogs/GASKIL15.las.las
~VERSION INFORMATION
 VERS.                                2.0: CWLS LOG ASCII STANDARD - VERSION 2.0
 WRAP.                                 NO: ONE LINE PER DEPTH STEP
~WELL INFORMATION BLOCK
#MNEM.UNIT       DATA TYPE    INFORMATION
#---------    -------------   ------------------------------
 UWI .                       15-175-21301: Unique Well Id
 PM  .                                  6: Principal Meridian
 STAT.                             Kansas: State
 SECT.                                  5: Section
 TOWN.                                31S: Township
 RANG.                                33W: Range
 COUN.                             SEWARD: County Name
 COMP.         HUGOTON ENERGY CORPORATION: Company
 WELL.                                1-5: Well Name
 LEAS.                            GASKILL: Lease Name
 FLD .                            VICTORY: Field
 STRT.F                        5687.00000: 
 STOP.F                        5487.00000: 
 STEP.F                          -0.50000: 
 NULL.                         -999.25000: NULL VALUE
 LOC .     440' FNL & 440' FWL, 5-31S-33W: LOCATION
 LOC1.                                   : LOCATION1
 CTRY.                                   : COUNTRY
 DATE.                        22-MAR-1993: LOG DATE
 API .                       15-175-21301: API NUMBER
 DAY .                                 22: LOG DAY
 MONT.                                  3: LOG MONTH
 YEAR.                                 93: LOG YEAR
 DMF .                      KELLY BUSHING: DRILLING REF
 LMF .                      KELLY BUSHING: LOGGING  REF
 PDAT.                       GROUND LEVEL: PERMANENT DATUM
 ENGI.                          JON BLACK: LOGGING ENGINEER
 WITN.                     KARL OSTERBUHR: LOGGING WITNESS
 LATI.                                   : LATITUDE
 LONG.                                   : LONGITUDE
 LUL .                       LIBERAL,  KS: LOGGING DISTRICT
 LUN .                               8510: LOGGING UNIT NO.
 RUN .                                ONE: LOGGING RUN NO.
 SON .                             603664: SERVICE ORDER NO.
 SRVC.         SCHLUMBERGER WELL SERVICES: SERVICE COMPANY
~CURVE INFORMATION
#MNEM.UNIT      API CODE      CURVE DESCRIPTION
#---------    -------------   ------------------------------
 DEPT.F                                 0: 1  Depth
 GR  .GAPI                        7310010: 2 Gamma Ray
 ILD .OHMM                        7120460: 3 Deep  Induction Standard Resistivity
 ILM .OHMM                        7120440: 4 Medium Induction Standard Resistivity
 SFLU.OHMM                        7220010: 5 SFL Resistivity (unaveraged)
 SP  .MV                          7010010: 6 Spontaneous Potential
 BMIN.OHMM                        1525001: 7 MICRO INVERSE
 BMNO.OHMM                        1525201: 8 MICRO NORMAL
 CALI.IN                          1528001: 9 Caliper
 DPHI.V/V                         1589001: 10 Density Porosity
 DRHO.G/C3                        1535601: 11 Delta  RHO
 NPHI.V/V                         1589000: 12 Neutron Porosity N
 PEF .                            1535801: 13 Photoelectric Factor
 RHOB.G/C3                        1535002: 14 Bulk Density
 TNPH.V/V                         1589000: 15 Thermal Neutron Porosity
~PARAMETER INFORMATION
#MNEM.UNIT        VALUE       DESCRIPTION
#---------    -------------   ------------------------------
 BHT .DEGF                            N/A: Bottom Hole Temperature
 BS  .IN                            7.875: Bit Size
 MDEN.G/C3                            N/A: Matrix Density
 DFD .LB/G                            9.1: Drilling Fluid Density
 DFV .S                               52.: Drilling Fluid Viscosity
 DFL .C3                         8.799999: Drilling Fluid Loss
 RMFS.OHMM                           1.14: Resistivity of Mud Filtrate Sample
 EKB .F                             2944.: Elevation of Kelly Bushing
 EGL .F                             2936.: Elevation of Ground Level
 BLI .F                             5664.: Bottom Log Interval
 BSAL.PPM                           2200.: Borehole Salinity
 FLEV.F                                0.: Fluid Level
 MCST.DEGF                            58.: Mud Cake Sample Temperature
 MFST.DEGF                            58.: Mud Filtrate Sample Temperature
 MRT .DEGF                           123.: Maximum Recorded Temperature
 MST .DEGF                            58.: Mud Sample Temperature
 RMCS.OHMM                           2.15: Resistivity of Mud Cake Sample
 RMS .OHMM                           1.43: Resistivity of Mud Sample
 RW  .OHMM                             1.: Resistivity of Water
 TDD .F                             5670.: Total Depth - Driller
 TDL .F                             5670.: Total Depth - Logger
 TLI .F                           -50000.: Top Log Interval
~OTHER INFORMATION
 HIDE.     DUAL INDUCTION LOG                      : Header Identifer
 MATR.     N/A                                     : Matrix
 FNUM.     N/A                                     : F-Numerator for Formation F
 FEXP.     N/A                                     : F-Exponent for Formation Fa
 DFT .     CHEMICAL                                : Drilling Fluid Type
 DFPH.     9.                                      : Drilling Fluid Ph
 MCSS.     MEASURED                                : Mud Cake Sample Source
 MFSS.     MEASURED                                : Mud Filtrate Sample Source
 FD  .     N/A                                     : Fluid Density
 MSS .     CIRCULATED                              : Mud Sample Source
 OS1 .     DIL-SFL-GR                              : Other Services Line 1
 OS2 .     LDL-CNL-GR                              : Other Services Line 2
 OS3 .     ML-GR                                   : Other Services Line 3
 OS4 .                                             : Other Services Line 4
 OS5 .                                             : Other Services Line 5
 OS6 .                                             : Other Services Line 6
 R1  .     1 1/2" STANDOFFS USED ABOVE AND BELOW   : Remark Line 1
 R2  .     INDUCTION TOOL.                         : Remark Line 2
 R3  .                                             : Remark Line 3
 R4  .                                             : Remark Line 4
 R5  .                                             : Remark Line 5
 R6  .                                             : Remark line 6
 R7  .                                             : Remark line 7
 R8  .                                             : Remark line 8
 HIDE.     POROSITY LOG                            : Header Identifer
 MATR.     0.0                                     : Neutron Matrix (0=LIME)
 FNUM.     1.                                      : F-Numerator for Formation F
 FEXP.     2.                                      : F-Exponent for Formation Fa
 DFT .     CHEMICAL                                : Drilling Fluid Type
 DFPH.     9.                                      : Drilling Fluid Ph
 MCSS.     MEASURED                                : Mud Cake Sample Source
 MFSS.     MEASURED                                : Mud Filtrate Sample Source
 FD  .G/C3 0.9999999                               : Fluid Density
 MSS .     CIRCULATED                              : Mud Sample Source
 OS1 .     DIL-SFL-GR                              : Other Services Line 1
 OS2 .     LDL-CNL-GR                              : Other Services Line 2
 OS3 .     ML-GR                                   : Other Services Line 3
 OS4 .                                             : Other Services Line 4
 OS5 .                                             : Other Services Line 5
 OS6 .                                             : Other Services Line 6
 R1  .     BOW SPRING ECCENTRALIZER RAN            : Remark Line 1
 R2  .     ON NEUTRON TOOL. TOOL STRING            : Remark Line 2
 R3  .     ALSO ECCENTRALIZED BY CALIPERS          : Remark Line 3
 R4  .     ON DENSITY AND MICROLOG TOOLS.          : Remark Line 4
 R5  .     THANKS FOR CHOOSING SCHLUMBERGER!       : Remark Line 5
 R6  .                                             : Remark line 6
 R7  .                                             : Remark line 7
 R8  .                                             : Remark line 8
#MNEM.UNIT    VALUE                                 DESCRIPTION
#---------    -----------------------------------   ----------------------------
~A       DEPT         GR           ILD          ILM          SFLU         SP           BMIN         BMNO         CALI         DPHI         DRHO         NPHI         PEF          RHOB         TNPH
   5687.00000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000     18.10938     12.65625      7.22266      0.05616      0.05444      0.01992      4.11328      2.61397      0.02293
   5686.50000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000     18.10938     12.65625      7.22266      0.05616      0.05444      0.01992      3.83398      2.61397      0.02293
   5686.00000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000     18.10938     12.65625      7.22266      0.05616      0.05444      0.01992      3.62500      2.61397      0.02293
   5685.50000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000     18.10938     12.65625      7.22266      0.05616      0.05444      0.01992      3.62500      2.61397      0.02293
   5685.00000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000     18.10938     12.65625      7.22266      0.05276      0.06027      0.01992      3.62500      2.61979      0.02293
   5684.50000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000     18.10938     12.65625      7.22266      0.05396      0.05820      0.01992      3.62500      2.61772      0.02293
   5684.00000     33.06250      3.69713      9.02665     44.59411    132.62500     18.10938     12.65625      7.22266      0.04799      0.06316      0.01992      3.62500      2.62793      0.02293
   5683.50000     33.06250      3.69721      9.02665     44.59411    132.37500     18.10938     12.65625      7.22266      0.03979      0.07078      0.01992      3.62500      2.64196      0.02293
   5683.00000     33.06250      3.69713      9.02665     44.59411    132.12500     18.10938     12.65625      7.23047      0.03448      0.07835      0.01988      3.61719      2.65103      0.02293
   5682.50000     33.06250      3.69721      9.02665     44.59411    132.00000     18.10938     12.65625      7.22656      0.04122      0.07021      0.01990      3.65625      2.63952      0.02293
   5682.00000     33.06250      3.69713      9.02665     44.59411    131.87500     18.10938     12.65625      7.20703      0.04153      0.07313      0.02001      3.70898      2.63899      0.02293
   5681.50000     33.06250      3.69713      9.02665     44.59411    131.87500     18.10938     12.65625      7.22656      0.03232      0.08029      0.01990      3.69727      2.65473      0.02293
   5681.00000     33.06250      3.69705      9.02665     44.59411    132.00000     18.10938     12.65625      7.20703      0.02985      0.08031      0.02001      3.77539      2.65895      0.02293
   5680.50000     33.06250      3.69713      9.01894     44.59411    132.12500     18.10938     12.65625      7.20313      0.03986      0.07002      0.02003      3.52930      2.64183      0.02293
   5680.00000     33.06250      3.69713      9.01894     44.26765    132.00000     18.10938     12.65625      7.22656      0.04201      0.07010      0.01990      3.41211      2.63816      0.02293
   5679.50000     33.06250      3.69721      9.01894     44.59411    131.75000     18.10938     12.65625      7.22656      0.04608      0.07083      0.01990      3.45508      2.63121      0.02293
   5679.00000     33.06250      3.69713      9.01894     44.92542    131.62500     18.10938     12.65625      7.21484      0.04388      0.06960      0.01997      3.52734      2.63496      0.02293
   5678.50000     33.06250      3.69713      9.03437     44.59411    131.87500     18.10938     12.65625      7.23828      0.04473      0.07010      0.01984      3.69531      2.63351      0.02293
   5678.00000     33.06250      3.69713      9.02665     44.59411    132.00000     18.10938     12.65625      7.20703      0.03727      0.07418      0.02001      3.58008      2.64627      0.02293
   5677.50000     33.06250      3.69713      9.01894     44.92542    132.12500     18.10938     12.65625      7.21484      0.03440      0.07544      0.01997      3.67773      2.65117      0.02293
   5677.00000     33.06250      3.69542      9.01124     44.59411    132.37500     18.10938     12.65625      7.22656      0.03823      0.07113      0.01990      3.63867      2.64462      0.02293
   5676.50000     33.06250      3.69713      9.01124     44.59411    132.62500     18.10938     12.65625      7.22656      0.04688      0.06075      0.01990      3.56055      2.62984      0.02293
   5676.00000     33.06250      3.69542      9.03437     44.59411    132.75000     18.10938     12.65625      7.21484      0.05353      0.05300      0.01997      3.56055      2.61847      0.02293
   5675.50000     33.06250      3.69729      9.01124     44.59411    132.75000     18.10938     12.65625      7.20703      0.05583      0.05297      0.02001      3.52734      2.61453      0.02293
   5675.00000     33.06250      3.69713      9.02665     44.59411    132.87500     18.10938     12.65625      7.19141      0.05213      0.05955      0.02009      3.56250      2.62086      0.02293
   5674.50000     33.06250      3.69892      9.02665     44.59411    132.87500     18.10938     12.65625      7.22656      0.04894      0.06010      0.01990      3.71289      2.62632      0.02293
   5674.00000     33.06250      3.69698      9.00356     44.59411    132.87500     18.10938     12.65625      7.20703      0.03426      0.07452      0.02001      3.75781      2.65142      0.02293
   5673.50000     33.06250      3.69705      9.01124     44.59411    132.75000     18.10938     12.65625      7.21484      0.03217      0.07752      0.01997      3.72852      2.65498      0.02293
   5673.00000     33.06250      3.69542      9.02665     44.59411    132.62500     18.10938     12.65625      7.21875      0.02560      0.08678      0.01995      3.43555      2.66622      0.02293
   5672.50000     33.06250      3.69713      9.02665     44.59411    132.50000     18.10938     12.65625      7.21484      0.02986      0.08236      0.01997      3.35742      2.65894      0.02293
   5672.00000     33.06250      3.69705      9.02665     44.59411    132.25000     18.10938     12.65625      7.21875      0.03541      0.08048      0.01995      3.32813      2.64945      0.02293
   5671.50000     33.06250      3.69713      9.01894     44.59411    132.12500     18.10938     12.65625      7.22656      0.09550     -0.02028      0.01990      3.36523      2.54670      0.02293
   5671.00000     33.06250      3.69713      9.02665     44.59411    132.12500     18.10938     12.65625      7.20703      0.21097     -0.21444      0.02001      3.56445      2.34924      0.02293
   5670.50000     33.06250      3.69721      9.01124     44.59411    132.00000     18.10938     12.65625      7.22656      0.36477     -0.52936      0.01990      3.55664      2.08625      0.02293
   5670.00000     33.06250      3.69713      9.02665     44.26765    131.87500     18.10938     12.65625     16.87500      0.43213     -0.97116     -0.00628      3.68750      1.97106     -0.00478
   5669.50000     33.06250      3.69721      9.02665     44.59411    131.75000     18.10938     12.65625      7.21484      1.26855     -3.31966      0.01997      2.48242      0.54079      0.02293
   5669.00000     33.06250      3.69387      9.00356     44.59411    131.87500     18.10938     12.65625      7.20703     -0.00908      0.01347      0.02001      1.03027      2.72553      0.02293
   5668.50000     33.06250      3.69713      9.01124     44.59411    132.00000     18.10938     12.65625      7.19141      0.56263     -0.98052      0.02009   1000.00000      1.74791      0.02293
   5668.00000     33.06250      3.69511      9.01894     44.59411    132.12500     18.10938     12.65625      7.22656      0.37311     -0.65708      0.01990   1000.00000      2.07198      0.02293
   5667.50000     33.06250      3.70024      9.01894     44.59411    132.37500     18.10938     12.65625      7.23828      0.39352     -0.66916      0.01984   1000.00000      2.03709      0.02293
   5667.00000     33.06250      3.69853      9.01894     44.92542    132.50000     18.10938     12.65625      7.23828      0.42079     -0.69115      0.01984   1000.00000      1.99045      0.02330
   5666.50000     33.06250      3.69682      9.01894     44.59411    132.62500     18.10938     12.65625      7.30859      0.44165     -0.73469      0.01944   1000.00000      1.95479      0.02361
   5666.00000     33.06250      3.69573      9.03437     44.59411    132.62500     18.10938     12.65625     10.42188      0.61858     -1.06544      0.00279   1000.00000      1.65222      0.01281
   5665.50000     33.06250      3.68900      9.01124     44.92542    133.00000     18.10938     12.65625      7.53516     -0.02077      0.01898      0.01848   1000.00000      2.74551      0.02240
   5665.00000     33.06250      3.67115      9.01894     44.26765    133.37500     18.10938     12.65625      7.55469      0.64374     -1.08007      0.01826   1000.00000      1.60921      0.02203
   5664.50000     33.06250      3.64982      9.02665     43.94594    134.25000     18.10938     12.65625      7.55469     -1.00401      0.68612      0.01782   1000.00000      4.42685      0.02175
   5664.00000     33.06250      3.61759      9.01124     43.62887    135.12500     18.10938     12.65625      7.58594      0.93171     -2.08922      0.01693   1000.00000      1.11678      0.02202
   5663.50000     33.06250      3.58119      9.01894     43.62887    135.62500     18.10938     12.65625      7.58594      0.55934     -1.24701      0.01681   1000.00000      1.75353      0.02181
   5663.00000     33.06250      3.56161      9.01124     43.62887    135.62500     18.10938     12.65625      7.61719      0.37138     -0.87544      0.01683      0.01709      2.07494      0.02214
   5662.50000     33.06250      3.54942      8.74259     41.24803    135.00000     18.10938     12.65625      7.57422      0.28831     -0.66322      0.01732      0.52783      2.21699      0.02287
   5662.00000     33.06250      3.54820      6.97656     25.66622    134.50000     18.10938     12.65625      7.56250      0.30992     -0.57040      0.01850      0.63330      2.18003      0.02411
   5661.50000     33.06250      3.55115      4.68842     12.10360    133.75000     18.10938     12.65625      7.55469      0.32152     -0.47577      0.01850      0.57080      2.16019      0.02518
   5661.00000     33.06250      3.55158      3.50199      7.23667    133.00000     18.10938     12.65625      7.55469      0.26281     -0.28608      0.01923      0.84033      2.26059      0.02427
   5660.50000     33.06250      3.55050      3.34732      6.17289    132.62500     18.10938     12.65625      7.55469      0.20700     -0.14350      0.01898      1.35156      2.35603      0.02490
   5660.00000     33.06250      3.55223      3.39252      5.39137    132.12500     18.10938     12.65625      7.58594      0.17495     -0.06860      0.01942      2.18750      2.41084      0.02371
   5659.50000     33.06250      3.57433      3.51392      5.27382    131.87500     18.10938     12.65625      7.51172      0.15231     -0.02700      0.01942      2.60352      2.44955      0.02325
   5659.00000     33.06250      3.75716      3.68050      7.52484    131.75000     18.10938     12.65625      7.48438      0.10724      0.02032      0.01944      2.50781      2.52663      0.02290
   5658.50000     33.06250      4.16246      3.95933     12.84947    132.00000     18.10938     12.65625      7.56250      0.07923      0.03207      0.01881      2.42773      2.57452      0.02282
   5658.00000     33.06250      4.85245      4.61978     23.38345    132.50000     18.10938     12.65625      7.59375      0.06077      0.03869      0.01833      2.16797      2.60609      0.02197
   5657.50000     33.06250      6.46221      6.29872     35.86572    132.87500     18.14063     12.65625      7.67188      0.06765      0.03618      0.01682      1.97070      2.59433      0.02161
   5657.00000     33.06250     10.27477      9.80574     29.99484    133.50000     18.18750     12.65625      7.61328      0.09541      0.02481      0.01716      1.92676      2.54684      0.02257
   5656.50000     33.06250     15.07905     14.26946     17.24746    134.12500     18.20313     12.68750      7.53516      0.11636      0.01202      0.01791      2.00977      2.51102      0.02351
   5656.00000     33.06250     19.47342     16.23150     15.72272    135.50000     18.21875     12.71094      7.57422      0.12571      0.00587      0.01802      2.25586      2.49504      0.02321
   5655.50000     33.06250     22.56200     18.29799     23.02727    137.37500     18.21875     12.71094      7.60547      0.11167     -0.00100      0.01782      2.31445      2.51905      0.02362
   5655.00000     33.06250     24.20090     22.18713     33.11589    139.75000     18.21875     12.71094      7.57422      0.09268     -0.00406      0.01803      2.75977      2.55151      0.02386
   5654.50000     33.93750     25.13063     26.16234     45.26169    142.00000     18.23438     12.71094      7.55469      0.06622     -0.00855      0.01774      3.09570      2.59677      0.02377
   5654.00000     33.28125     26.42652     27.72654     52.30936    144.12500     18.25000     12.71094      7.59375      0.05528     -0.01080      0.01897      3.51758      2.61546      0.03001
   5653.50000     30.95313     26.50336     27.94442     56.19852    146.12500     18.25000     12.71094      7.66016      0.04808     -0.00632      0.01883      3.72852      2.62779      0.03062
   5653.00000     31.76563     25.03637     26.16234     48.14460    147.50000     18.26563     12.71094      7.52344      0.04047     -0.00289      0.01969      3.76758      2.64079      0.01790
   5652.50000     32.15625     24.50017     23.77081     39.11359    147.87500     18.25000     12.72656      7.53516      0.04459     -0.00543      0.01747      4.09375      2.63375      0.01793
   5652.00000     34.18750     24.34815     20.40224     28.71301    147.37500     18.25000     12.72656      7.56250      0.04068     -0.00047      0.01703      3.58398      2.64044      0.01847
   5651.50000     33.25000     22.61309     17.14768     20.73717    146.50000     18.28125     12.74219      7.66016      0.04601      0.00045      0.01717      3.32422      2.63133      0.02370
   5651.00000     32.06250     19.11029     14.52316     17.14963    145.62500     18.28125     12.76563      7.67188      0.04354     -0.00095      0.01809      3.12891      2.63555      0.02358
   5650.50000     33.06250     15.29545     12.62296     18.51488    145.12500     18.31250     12.76563      7.69531      0.03328      0.00514      0.01772      3.30664      2.65310      0.02393
   5650.00000     33.00000     12.07080     11.29154     26.80390    145.25000     18.29688     12.76563      7.63281      0.03098      0.00998      0.01840      3.65039      2.65703      0.03338
   5649.50000     31.95313      9.74186     10.40377     39.11359    145.37500     18.31250     12.76563      7.64453      0.03598      0.00834      0.01833      4.07813      2.64847      0.03352
   5649.00000     31.95313      8.71341      9.68003     30.14437    145.37500     18.32813     12.76563      7.59766      0.04564      0.00778      0.01972      4.50781      2.63195      0.01936
   5648.50000     31.95313      8.48672      8.68504     15.92982    144.87500     18.32813     12.76563      7.59375      0.05880      0.00547      0.02455      4.83984      2.60945      0.03087
   5648.00000     34.06250      8.38623      7.17653      9.48394    144.00000     18.39063     12.76563      7.55469      0.06857     -0.00173      0.06677      3.83203      2.59274      0.05402
   5647.50000     33.09375      8.16047      6.07611      8.54573    143.37500     18.32813     12.78125      7.55469      0.07164     -0.00551      0.10708      3.21484      2.58750      0.11463
   5647.00000     33.06250      7.89149      5.86526     11.93636    142.87500     18.39063     12.78125      7.64063      0.06856     -0.00437      0.13085      3.18555      2.59276      0.11387
   5646.50000     32.96875      8.01503      6.87167     19.22111    143.00000     18.34375     12.76563      7.61328      0.06903     -0.00262      0.10670      3.97070      2.59195      0.09319
   5646.00000     29.71875      8.93504      8.91236     25.99725    144.12500     18.34375     12.76563      7.64063      0.08098     -0.00191      0.08191      4.97656      2.57153      0.07201
   5645.50000     28.73438     10.82561     11.51243     27.78934    146.00000     18.35938     12.78125      7.55469      0.08644     -0.00264      0.06708      5.03516      2.56219      0.06324
   5645.00000     27.81250     13.75688     14.44415     27.53625    148.00000     18.34375     12.81250      7.55469      0.07880      0.00208      0.06346      4.70313      2.57525      0.06093
   5644.50000     32.09375     17.95427     18.11111     27.16514    150.75000     18.34375     12.81250      7.58594      0.05557      0.01037      0.05569      4.57422      2.61497      0.05469
   5644.00000     31.95313     24.24489     22.65895     26.22272    153.12500     18.34375     12.79688      7.64453      0.05308      0.01078      0.04809      4.35547      2.61924      0.04788
   5643.50000     35.06250     32.51115     27.51201     25.34351    155.75000     18.34375     12.79688      7.58594      0.06203      0.00325      0.04106      4.15234      2.60392      0.04380
   5643.00000     38.31250     37.61184     30.41358     25.66622    157.50000     18.34375     12.81250      7.55469      0.07783      0.00090      0.03595      3.69336      2.57691      0.03891
   5642.50000     38.50000     31.66731     27.79879     28.04713    158.75000     18.34375     12.81250      7.65234      0.08301     -0.00361      0.03093      3.28125      2.56805      0.03549
   5642.00000     35.37500     22.01468     21.64618     33.48262    159.25000     18.34375     12.81250      7.70703      0.09405     -0.01546      0.02663      2.99805      2.54918      0.03355
   5641.50000     29.00000     14.75164     15.93942     41.53133    159.25000     18.34375     12.81250      7.67188      0.09876     -0.02504      0.02465      2.98438      2.54113      0.03091
   5641.00000     30.07813     10.65969     12.13188     35.65425    159.00000     18.28125     12.85156      7.68359      0.09003     -0.01843      0.02311      2.99414      2.55604      0.03261
   5640.50000     29.87500      8.81558      9.94407     19.28240    158.25000     13.07813     12.42188      7.77734      0.08149     -0.00662      0.03136      3.17969      2.57065      0.04447
   5640.00000     29.87500      8.25149      8.38145     10.56053    156.87500      6.66016      6.14453      7.71094      0.08248     -0.00382      0.07042      2.90820      2.56895      0.07286
   5639.50000     29.70313      8.02854      6.68371      7.99228    156.00000      6.24609      5.44531      7.69531      0.07777      0.00444      0.11865      2.78906      2.57701      0.11455
   5639.00000     30.93750      7.81339      5.40760      8.11019    155.62500      6.58984      6.01953      7.69531      0.05823      0.01797      0.14963      2.54297      2.61043      0.13223
   5638.50000     35.18750      7.71166      5.06909      9.63505    156.50000      7.29688      6.21484      7.67188      0.04142      0.02220      0.14298      2.77734      2.63918      0.13125
   5638.00000     33.12500      7.94284      5.74618     12.71438    158.00000      7.35156      6.71484      7.70703      0.03328      0.00864      0.11812      3.02539      2.65310      0.09936
   5637.50000     33.06250      9.05939      7.92766     20.59591    159.62500     11.19531      9.88281      7.70703      0.02696      0.00542      0.08765      3.31250      2.66391      0.06920
   5637.00000     31.95313     11.91383     13.37075     45.26169    161.50000     16.87500     17.62500      7.70703      0.02016     -0.00025      0.05675      3.46484      2.67553      0.05150
   5636.50000     30.89063     18.43462     29.40785    121.91460    163.25000     40.18750     32.28125      7.70703      0.01726     -0.00668      0.02859      3.90039      2.68049      0.03168
   5636.00000     28.73438     36.34518     83.88135    219.09305    164.62500     48.81250     33.40625      7.70703      0.01722     -0.00958      0.01519      4.86328      2.68056      0.01930
   5635.50000     27.43750     80.02765    110.79274    179.96927    165.75000     46.68750     61.28125      7.70703      0.01310     -0.00652      0.01146      5.03906      2.68760      0.01099
   5635.00000     33.78125     55.44781     54.71179    127.03708    166.00000     54.53125     68.31250      7.70703      0.01499     -0.00622      0.00951      5.02344      2.68436      0.01127
   5634.50000     46.50000     22.95082     26.03460     95.07803    166.00000     38.75000     43.40625      7.82031      0.01573     -0.00614      0.01087      4.67578      2.68310      0.01347
   5634.00000     50.96875     11.24469     13.54136     89.45212    165.62500     40.71875     53.71875      7.85547      0.01728     -0.00505      0.01117      4.69922      2.68045      0.01631
   5633.50000     53.96875      6.93740      8.62118     85.65103    165.00000     78.06250     74.81250      7.84375      0.01713     -0.00236      0.01201      4.51953      2.68071      0.01982
   5633.00000     48.81250      5.47944      6.64145     32.40601    164.12500     59.53125     71.62500      7.84375      0.02133      0.00300      0.01493      4.78125      2.67352      0.03205
   5632.50000     48.90625      5.16750      5.55997     10.34376    163.00000     69.62500     53.81250      7.82031      0.03820      0.01488      0.04224      4.74219      2.64468      0.05562
   5632.00000     44.93750      5.13494      4.36211      5.02406    163.87500      7.09766      4.96094      7.73438      0.06255      0.03446      0.10624      3.95313      2.60304      0.10878
   5631.50000     41.68750      4.94828      3.45390      6.67730    165.12500      3.22852      2.26172      7.72266      0.10113      0.01553      0.19384      3.05859      2.53707      0.17265
   5631.00000     40.53125      4.62259      3.22358      4.22983    164.87500     13.64063     11.90625      7.66406      0.10178      0.01324      0.21158      2.82422      2.53596      0.17498
   5630.50000     34.09375      4.41783      3.75128      8.07769    165.12500     20.60938     18.98438      7.37500      0.07483      0.01088      0.16897      3.20508      2.58203      0.10748
   5630.00000     28.76563      4.63773      5.16693     17.05291    163.25000     19.68750     17.62500      6.81250      0.05122      0.00364      0.09243      3.83594      2.62241      0.06793
   5629.50000     21.29688      5.37042      6.98120     18.68653    160.62500     18.68750     16.64063      6.71094      0.03800     -0.00583      0.05956      4.48047      2.64503      0.06142
   5629.00000     21.35938      6.32852      7.96963     16.36082    157.75000     16.00000     14.07031      7.00000      0.04279     -0.00402      0.06531      4.44531      2.63683      0.06456
   5628.50000     22.56250      6.96379      7.81013     14.44567    154.00000     14.96094     13.56250      7.70703      0.04381     -0.00420      0.06908      4.19922      2.63508      0.07602
   5628.00000     24.73438      7.25875      7.11343     13.21451    150.62500     14.82031     13.08594      7.70703      0.05233     -0.00289      0.08227      3.97266      2.62051      0.07972
   5627.50000     23.56250      7.26740      6.60802     12.32564    148.25000     12.83594     12.92188      7.70703      0.05771     -0.00495      0.08549      3.89648      2.61132      0.08491
   5627.00000     23.37500      7.21968      6.51778     12.00747    146.62500     10.10938     10.75781      7.70703      0.06123     -0.00578      0.08971      4.00391      2.60529      0.08279
   5626.50000     23.40625      7.44103      6.82259     12.84947    145.62500      9.92188     10.53906      7.70703      0.05815     -0.00501      0.08532      4.02734      2.61057      0.08027
   5626.00000     24.46875      7.99351      7.35719     15.01977    145.75000      9.27344     11.24219      7.70703      0.05107     -0.00590      0.08027      3.97266      2.62267      0.07811
   5625.50000     22.42188      8.67633      8.23742     18.86139    146.62500     11.06250     14.28125      7.70703      0.04309     -0.00803      0.07301      3.93750      2.63632      0.06955
   5625.00000     22.34375      9.45847      9.62713     21.78300    148.00000     23.73438     22.12500      7.70703      0.02614     -0.00760      0.06024      4.11719      2.66531      0.05937
   5624.50000     29.71875     10.15773     11.37643     20.80854    150.00000     29.71875     23.34375      7.70703      0.02121     -0.00731      0.05085      4.36719      2.67374      0.05185
   5624.00000     37.03125     10.18500     11.92711     18.07220    151.75000     18.06250     12.22656      7.70703      0.01885     -0.00566      0.04569      4.23438      2.67776      0.05244
   5623.50000     40.18750      9.63194     11.05578     18.23571    152.12500     16.01563     16.18750      7.70703      0.02830     -0.00539      0.04798      3.97070      2.66161      0.04612
   5623.00000     34.00000      9.51311     10.53847     18.34636    151.87500     32.43750     23.56250      7.70703      0.02250      0.00166      0.04021      3.91602      2.67153      0.04169
   5622.50000     27.76563      9.79824      9.99105     13.94594    150.87500     22.92188     19.42188      7.73438      0.04013     -0.00085      0.04006      3.91992      2.64139      0.04326
   5622.00000     25.64063     10.12212      8.97296     10.65356    150.12500      9.14063     10.32813      7.72266      0.04570     -0.00260      0.05386      3.72852      2.63185      0.06515
   5621.50000     28.76563     10.58521      8.30882     11.39646    150.37500     10.24219     14.87500      7.69531      0.05046     -0.00569      0.07900      3.83789      2.62371      0.08228
   5621.00000     32.93750     10.96435      8.72813     14.54995    151.25000     14.44531     16.51563      7.71094      0.03626     -0.00383      0.08392      3.83594      2.64800      0.08423
   5620.50000     40.31250     10.90709     10.23270     18.07220    153.37500      9.61719     10.93750      7.78906      0.03097     -0.00399      0.07853      3.83594      2.65703      0.07378
   5620.00000     46.46875     10.96683     11.19604     20.52600    156.25000     10.14063     11.67188      7.75391      0.02612      0.00121      0.06724      3.60547      2.66534      0.06383
   5619.50000     51.00000     10.25952     11.07891     26.10950    158.50000     22.75000     24.04688      7.70703      0.02985      0.00285      0.05823      3.76953      2.65895      0.05276
   5619.00000     50.21875      8.69878     10.38335     26.68562    160.87500     15.05469     15.05469      7.70703      0.03830      0.00134      0.04502      4.01563      2.64451      0.04214
   5618.50000     51.40625      7.68235      9.11233     16.72279    162.25000     19.57813     20.60938      7.72266      0.03988      0.00478      0.03519      4.18359      2.64181      0.04298
   5618.00000     50.28125      7.17147      7.44567      9.63505    162.75000     15.77344     13.22656      7.76172      0.03832      0.01025      0.04446      4.14063      2.64448      0.04946
   5617.50000     47.09375      6.45642      5.78108      6.34785    162.12500     10.84375      9.55469      7.81641      0.05400      0.00322      0.06632      3.81836      2.61767      0.07460
   5617.00000     47.03125      5.36885      4.45749      5.63241    161.25000     11.25000      8.66406      7.73438      0.07933     -0.00283      0.11423      3.24609      2.57434      0.09943
   5616.50000     49.00000      4.19926      3.61735      5.67470    161.00000     11.10156      9.07813      7.70703      0.08190     -0.00524      0.13426      2.81055      2.56995      0.12176
   5616.00000     53.12500      3.24975      3.18069      6.45629    160.37500     15.73438     12.53125      7.76172      0.06826     -0.00200      0.13079      2.71680      2.59328      0.11228
   5615.50000     49.00000      2.63048      2.89108      6.85130    159.37500     21.75000     10.77344      7.85547      0.04860      0.00141      0.09820      2.83203      2.62690      0.09615
   5615.00000     47.87500      2.27865      2.54878      6.00135    156.37500     16.35938     12.31250      7.85547      0.08062     -0.00245      0.08561      3.06250      2.57213      0.08955
   5614.50000     48.93750      2.02780      2.14947      4.81216    152.75000      6.04297      6.16406      7.82031      0.12901     -0.00679      0.09710      2.87695      2.48939      0.10232
   5614.00000     46.84375      1.81132      1.79938      4.13439    148.75000      5.23047      5.62500      7.60547      0.16696     -0.00954      0.14198      2.62500      2.42450      0.14013
   5613.50000     43.71875      1.62609      1.56150      4.15427    145.00000      5.37500      5.48438      7.72266      0.16631     -0.00555      0.18935      2.44727      2.42561      0.18300
   5613.00000     38.37500      1.49113      1.44892      4.29289    142.12500      5.21484      5.53516      7.85547      0.15323     -0.00359      0.21558      2.53516      2.44797      0.20254
   5612.50000     39.56250      1.43223      1.43639      4.23279    140.37500      5.36328      5.67969      7.85547      0.14147     -0.00057      0.21952      2.42969      2.46808      0.20056
   5612.00000     38.65625      1.45769      1.48828      4.05673    138.75000      5.37500      5.62500      7.85547      0.14698      0.00129      0.20496      2.41992      2.45867      0.20342
   5611.50000     35.31250      1.55769      1.59276      4.29899    137.50000      4.81641      5.23047      7.85547      0.15991      0.00569      0.20529      2.36914      2.43655      0.20807
   5611.00000     31.98438      1.74583      1.77690      5.17896    136.37500      6.20313      7.14453      7.80469      0.19124     -0.00159      0.21699      2.60352      2.38298      0.23286
   5610.50000     27.56250      2.04423      2.10148      5.82783    135.25000      8.07031      8.07031      7.70703      0.20920     -0.00725      0.25865      2.69141      2.35227      0.26654
   5610.00000     26.57813      2.48236      2.64134      6.28843    135.00000      5.08203      5.67969      7.70703      0.20296     -0.00603      0.29242      2.68945      2.36293      0.32729
   5609.50000     25.54688      3.15364      3.45275      8.17599    135.75000      4.87109      6.37500      7.73438      0.15686     -0.00736      0.30225      2.89648      2.44177      0.23597
   5609.00000     27.73438      4.15270      4.78753     15.01977    137.37500      7.92578     12.35156      7.67188      0.09971     -0.00988      0.21829      3.12695      2.53950      0.12671
   5608.50000     26.78125      5.62814      7.38818     32.23326    139.87500     24.15625     25.15625      7.80078      0.03751     -0.00568      0.12260      3.78320      2.64586      0.06425
   5608.00000     26.64063      8.02752     12.56315     47.38998    142.75000     34.46875     34.25000      7.85547      0.02579     -0.01069      0.03391      3.89648      2.66591      0.03690
   5607.50000     26.57813     11.95105     21.60228     50.55988    146.25000     33.31250     26.53125      7.85547      0.02719     -0.01640      0.02055      4.23047      2.66351      0.02724
   5607.00000     29.71875     17.83641     33.46465     54.18425    149.37500     38.09375     32.93750      7.85547      0.03280     -0.01619      0.01848      4.47266      2.65391      0.02376
   5606.50000     29.71875     25.80726     44.65627     62.59795    152.12500     40.81250     33.15625      7.85547      0.03348     -0.01566      0.01690      4.99219      2.65274      0.02233
   5606.00000     28.65625     35.39493     52.56041     69.82635    154.37500     42.50000     40.00000      7.85547      0.02756     -0.01310      0.01562      5.23438      2.66288      0.01855
   5605.50000     25.40625     43.19070     57.97423     78.94208    156.25000     44.28125     51.28125      7.85547      0.02364     -0.00963      0.01308      5.04688      2.66957      0.01595
   5605.00000     24.50000     49.43317     66.64252     90.79524    157.37500     49.34375     41.06250      7.85547      0.02078     -0.00908      0.01131      4.87500      2.67447      0.01476
   5604.50000     23.43750     55.20646     76.12500    121.91460    158.25000     59.96875     58.68750      7.85547      0.02202     -0.00957      0.01034      5.19531      2.67235      0.01306
   5604.00000     23.50000     59.32022     89.49184    174.76782    159.37500     83.68750     78.50000      7.85547      0.01565     -0.00400      0.00941      5.08984      2.68324      0.01165
   5603.50000     26.71875     63.05832    107.45705    197.61334    160.25000     90.93750     89.43750      7.85547      0.01189     -0.00191      0.00936      5.10156      2.68967      0.01118
   5603.00000     27.87500     63.85085    119.44371    185.48981    161.00000     66.68750     65.75000      7.85547      0.01209     -0.00459      0.00971      4.72266      2.68933      0.01134
   5602.50000     28.93750     61.28925    116.83722    174.76782    161.75000     78.00000     70.00000      7.85547      0.01337     -0.00587      0.00970      4.67578      2.68714      0.01208
   5602.00000     24.53125     59.30291    110.79274    185.48981    162.62500     95.93750     79.12500      7.85547      0.01714     -0.00590      0.00987      4.69531      2.68070      0.01196
   5601.50000     23.43750     57.47319    113.13396    191.35971    163.62500     90.12500     64.56250      7.85547      0.02512     -0.01011      0.00953      4.54297      2.66704      0.01192
   5601.00000     26.64063     57.83340    114.34204    174.76782    165.00000     82.18750     67.31250      7.85547      0.02154     -0.01566      0.01001      4.61328      2.67316      0.01138
   5600.50000     25.59375     56.09146    106.38930    141.94754    166.37500     55.93750     50.21875      7.85547      0.01270     -0.01135      0.01004      4.97266      2.68827      0.01172
   5600.00000     25.56250     52.57391     85.21703    124.42314    167.50000     80.37500     67.50000      7.85547      0.00661     -0.00863      0.01054      4.90625      2.69870      0.01308
   5599.50000     23.50000     42.92490     61.29659    112.81650    168.37500     66.87500     60.40625      7.85547      0.01813     -0.01236      0.01100      4.63281      2.67900      0.01413
   5599.00000     26.79688     31.58779     43.56410     99.78487    168.75000     42.50000     34.68750      7.85547      0.01981     -0.01597      0.01111      4.41406      2.67612      0.01282
   5598.50000     31.01563     23.79499     31.30565     74.10493    169.12500     54.46875     39.78125      7.85547      0.01919     -0.01416      0.00994      4.97266      2.67718      0.01313
   5598.00000     30.95313     18.54308     23.56064     44.92542    169.50000     57.65625     43.21875      7.85547      0.01195     -0.01245      0.01080      5.38672      2.68956      0.01503
   5597.50000     32.96875     15.64349     18.52093     26.56837    169.87500     43.46875     25.43750      7.85547      0.01591     -0.01532      0.01356      5.11719      2.68280      0.02034
   5597.00000     28.67188     14.33271     15.16597     17.65020    169.37500     26.48438     15.69531      7.85547      0.01193     -0.01169      0.02000      4.46875      2.68961      0.03147
   5596.50000     28.60938     13.98706     12.89930     13.94594    168.87500     23.32813     12.79688      7.85547      0.00713     -0.00549      0.03714      4.19531      2.69781      0.04611
   5596.00000     25.48438     14.17875     11.53751     12.82222    168.62500     19.82813     11.00781      7.85547      0.00345     -0.00432      0.05719      4.05078      2.70409      0.06453
   5595.50000     25.53125     14.72517     11.24359     13.72437    168.75000     24.78125     16.57813      7.85547      0.00083     -0.00585      0.07108      3.83008      2.70858      0.07153
   5595.00000     26.51563     15.87236     12.41604     17.80613    169.12500     27.93750     16.40625      7.85547      0.00449     -0.00499      0.06558      3.68945      2.70231      0.06389
   5594.50000     29.59375     18.27340     16.15749     30.44794    169.62500     33.25000     24.17188      7.85547      0.00516     -0.00587      0.04816      3.91602      2.70118      0.04380
   5594.00000     31.62500     22.84585     24.76482     66.01486    170.50000     65.62500     50.50000      7.85547      0.01350     -0.00888      0.02688      4.43750      2.68691      0.02717
   5593.50000     33.93750     30.55630     42.52400    132.60889    171.75000     75.43750     60.75000      7.85547      0.01702     -0.00693      0.01551      4.50000      2.68089      0.01721
   5593.00000     34.03125     41.04299     68.78477    165.21765    173.25000     46.43750     46.84375      7.84375      0.02559     -0.01094      0.01076      4.23828      2.66625      0.01429
   5592.50000     35.34375     49.12162     76.12500    145.35974    174.62500     60.96875     49.50000      7.85547      0.01990     -0.01249      0.00995      4.28125      2.67597      0.01325
   5592.00000     37.37500     49.69986     66.64252    108.75833    176.00000     55.81250     44.87500      7.85547      0.01135     -0.01109      0.01014      4.48047      2.69058      0.01419
   5591.50000     36.31250     46.46263     55.56461     68.25014    177.62500     50.15625     38.34375      7.85547      0.00292     -0.00897      0.01122      4.64844      2.70501      0.01545
   5591.00000     40.53125     44.50159     46.60335     42.10976    179.50000     52.06250     36.96875      7.85547      0.00579     -0.00970      0.01211      4.10938      2.70010      0.01863
   5590.50000     35.31250     43.99845     40.12849     30.75768    180.62500     38.56250     27.75000      7.85547      0.00439     -0.00673      0.01586      3.84961      2.70249      0.02345
   5590.00000     34.28125     44.40394     35.34790     28.85000    181.62500     21.25000     17.67188      7.85547      0.00371     -0.00583      0.02019      3.84961      2.70366      0.03068
   5589.50000     32.03125     46.29268     35.23129     36.29628    182.37500     27.73438     20.64063      7.85547      0.00155     -0.00530      0.02364      4.05078      2.70734      0.02962
   5589.00000     35.21875     50.04346     41.37153     60.10897    182.12500     24.48438     24.87500      7.85547      0.00328     -0.00562      0.01984      4.22266      2.70439      0.02329
   5588.50000     40.62500     57.83340     58.29018    127.03708    182.37500     55.90625     62.28125      7.85547      0.01158     -0.00889      0.01441      4.21484      2.69020      0.01502
   5588.00000     42.84375     72.06541     97.65564    267.56506    182.37500     40.15625     47.43750      7.85547      0.01300     -0.00818      0.00875      4.06641      2.68778      0.00841
   5587.50000     43.84375     90.75958    160.65201    387.62665    182.50000     45.34375     54.25000      7.85547      0.01480     -0.00645      0.00648      4.17188      2.68470      0.00460
   5587.00000     43.65625    120.87886    229.47620    308.51898    182.37500     34.21875     42.40625      7.85547      0.01413     -0.00772      0.00568      4.27734      2.68584      0.00537
   5586.50000     41.46875    148.46909    276.92151    219.09305    182.37500     36.68750     40.12500      7.85547      0.01504     -0.00666      0.00674      4.76172      2.68428      0.00663
   5586.00000     40.46875    169.66638    234.49854    156.65717    181.87500     51.43750     45.37500      7.83203      0.01160     -0.00642      0.00764      4.97656      2.69016      0.00871
   5585.50000     42.53125    171.22940    199.55676    132.60889    181.75000     47.90625     40.84375      7.82031      0.01462     -0.01130      0.00900      5.01172      2.68499      0.00988
   5585.00000     41.46875    157.75183    158.27817    141.94754    180.87500     37.31250     44.53125      7.83203      0.01049     -0.01153      0.00975      4.75000      2.69207      0.01135
   5584.50000     40.46875    146.02875    151.55951    191.35971    180.25000     60.78125     77.87500      7.83203      0.00235     -0.00978      0.00933      4.73438      2.70599      0.01079
   5584.00000     37.31250    131.88730    155.97342    279.95233    178.87500     65.31250    105.12500      7.82031      0.00047     -0.01224      0.00801      4.35156      2.70919      0.00905
   5583.50000     39.37500    121.59883    170.90457    293.54230    177.75000     65.25000     91.68750      7.82031      0.00684     -0.01151      0.00714      4.35938      2.69830      0.00849
   5583.00000     38.28125    124.64243    163.09811    219.09305    176.25000     65.68750     84.00000      7.82031      0.01852     -0.00853      0.00750      4.28906      2.67833      0.00840
   5582.50000     34.09375    122.32742    145.38779    141.94754    174.62500     59.93750     65.68750      7.82031      0.03685     -0.00763      0.00853      4.43750      2.64698      0.01034
   5582.00000     28.82813    123.36220    119.44371    108.75833    173.37500     31.92188     38.12500      7.84375      0.05424     -0.00905      0.01048      4.37500      2.61725      0.01409
   5581.50000     26.56250    118.90742     99.47032    104.98201    172.62500     37.09375     37.06250      7.84375      0.06087     -0.00531      0.01329      4.00391      2.60591      0.01895
   5581.00000     28.70313    115.28099     95.90594    117.18924    172.25000     29.90625     34.75000      7.84375      0.05376     -0.00330      0.01626      3.73633      2.61807      0.02211
   5580.50000     29.73438    110.53555    106.38930    141.94754    172.25000     41.00000     40.65625      7.83203      0.04523     -0.00015      0.01703      3.79688      2.63265      0.02160
   5580.00000     35.15625    117.74147    136.14713    174.76782    172.87500     49.53125     44.34375      7.84375      0.04832     -0.00298      0.01528      3.57422      2.62737      0.01695
   5579.50000     34.25000    141.87149    168.22070    191.35971    173.50000     79.43750     71.12500      7.83203      0.05313     -0.00719      0.01209      2.94141      2.61915      0.01453
   5579.00000     36.53125    175.64209    203.34442    219.09305    174.12500     72.43750     70.43750      7.73438      0.05271     -0.00915      0.01100      2.69922      2.61987      0.01190
   5578.50000     34.34375    215.86584    250.97684    236.20972    175.25000     83.56250     67.12500      7.71094      0.04279     -0.00871      0.00930      2.71484      2.63682      0.01187
   5578.00000     35.21875    259.36200    292.01440    245.81177    176.37500     30.76563     37.62500      7.83203      0.02926     -0.00877      0.00891      3.50781      2.65996      0.01034
   5577.50000     34.12500    268.19635    300.19482    245.81177    177.50000     31.43750     36.00000      7.78906      0.02151     -0.01151      0.00808      4.12109      2.67321      0.00996
   5577.00000     33.06250    256.75952    292.01440    267.56506    178.50000     53.15625     41.06250      7.77344      0.01283     -0.00831      0.00846      4.64844      2.68806      0.00780
   5576.50000     28.81250    221.47333    256.99646    343.57800    179.37500     98.37500     79.18750      7.78125      0.01982     -0.01259      0.00741      4.73828      2.67611      0.00685
   5576.00000     28.76563    191.60437    263.31183    325.10608    180.12500     85.25000     63.06250      7.80078      0.01808     -0.01370      0.00688      4.67188      2.67908      0.00599
   5575.50000     33.12500    204.22995    250.97684    197.61334    180.62500     87.00000     60.34375      7.79297      0.01601     -0.01572      0.00687      5.23828      2.68262      0.00706
   5575.00000     41.62500    231.23331    234.49854    129.76318    181.00000     61.87500     49.09375      7.77734      0.00794     -0.01125      0.00815      5.11328      2.69643      0.00956
   5574.50000     44.71875    237.12747    176.53751    104.98201    181.25000     42.59375     36.65625      7.78125      0.00353     -0.00964      0.01007      4.80859      2.70397      0.01189
   5574.00000     42.68750    251.09045    158.27817    138.69186    181.37500     59.18750     68.68750      7.80469      0.00302     -0.00851      0.01032      4.40625      2.70484      0.01140
   5573.50000     39.59375    256.11700    185.71906    236.20972    181.50000     85.68750     72.31250      7.76563     -0.00331     -0.00206      0.00892      4.18359      2.71566      0.00790
   5573.00000     34.37500    273.20691    292.01440    414.17645    181.37500    113.43750    110.06250      7.80469     -0.00247      0.00109      0.00661      4.20313      2.71422      0.00424
   5572.50000     33.06250    345.59387    544.00439    521.29138    181.62500    115.31250     88.37500      7.80078      0.01006      0.00166      0.00511      4.04297      2.69279      0.00218
   5572.00000     39.43750    475.53912    782.20068    570.46997    181.62500     78.62500     52.34375      7.75391      0.02379     -0.00022      0.00437      3.39844      2.66931      0.00025
   5571.50000     46.90625    463.70288    843.77356    570.46997    181.75000     38.12500     45.21875      7.71094      0.03173     -0.00227      0.00348      3.03906      2.65575     -0.00011
   5571.00000     45.78125    537.94861    729.00281    570.46997    182.12500     89.00000     68.68750      7.72266      0.02640     -0.00611      0.00336      3.10156      2.66485      0.00068
   5570.50000     36.21875    437.00311    605.46497    387.62665    182.75000     90.81250     69.56250      7.73438      0.01439     -0.00638      0.00413      3.79102      2.68539      0.00195
   5570.00000     33.93750    330.00336    373.41772    308.51898    183.25000     75.75000     68.50000      7.84375      0.00712     -0.00771      0.00531      4.41797      2.69783      0.00381
   5569.50000     36.40625    252.32855    300.19482    245.81177    183.87500     60.81250     51.93750      7.85547      0.00508     -0.00842      0.00660      4.30859      2.70131      0.00605
   5569.00000     40.65625    238.23157    245.23273    219.09305    184.00000     35.00000     49.09375      7.85547      0.00498     -0.00978      0.00745      4.44531      2.70148      0.00820
   5568.50000     39.62500    205.87411    220.05023    179.96927    184.62500     80.56250     67.87500      7.85547      0.00244     -0.00757      0.00833      4.57031      2.70583      0.00918
   5568.00000     37.28125    210.75180    192.38950    148.94003    184.87500     34.31250     35.81250      7.85547      0.00218     -0.00888      0.00899      4.35938      2.70627      0.01014
   5567.50000     37.09375    201.81229    176.53751    145.35974    184.87500     44.81250     43.59375      7.85547      0.00484     -0.00956      0.00964      4.23828      2.70172      0.01086
   5567.00000     38.09375    202.01160    176.53751    169.85861    184.75000     48.81250     51.62500      7.85547      0.00962     -0.01227      0.00932      4.16016      2.69355      0.01229
   5566.50000     39.12500    210.75180    195.90765    191.35971    184.62500     61.87500     46.78125      7.85547      0.00822     -0.01252      0.00925      4.39453      2.69594      0.01194
   5566.00000     39.40625    242.17798    229.47620    204.28946    184.62500     63.53125     72.87500      7.85547      0.00571     -0.01572      0.00904      4.49219      2.70023      0.01151
   5565.50000     37.37500    267.49548    276.92151    204.28946    184.37500     83.93750     61.00000      7.85547      0.00377     -0.01478      0.00913      4.48828      2.70356      0.00910
   5565.00000     37.37500    304.49011    284.26782    267.56506    183.87500     51.84375     42.18750      7.85547      0.01019     -0.01505      0.00791      4.58594      2.69257      0.00761
   5564.50000     35.06250    351.52466    327.73798    343.57800    183.37500     86.50000     78.81250      7.85547      0.01822     -0.01579      0.00660      4.42188      2.67884      0.00510
   5564.00000     41.59375    389.63452    452.19629    444.63074    182.75000     82.56250     72.43750      7.85547      0.02003     -0.01423      0.00477      4.32031      2.67576      0.00347
   5563.50000     43.90625    479.99426    573.09180    343.57800    182.12500     63.90625     53.59375      7.85547      0.01765     -0.01145      0.00478      4.28906      2.67981      0.00288
   5563.00000     47.31250    491.50598    573.09180    308.51898    181.37500     52.87500     45.43750      7.85547      0.01873     -0.01144      0.00502      4.11328      2.67797      0.00309
   5562.50000     42.90625    524.19055    493.87054    293.54230    180.75000     78.81250     72.87500      7.85547      0.02049     -0.01175      0.00552      4.45703      2.67497      0.00267
   5562.00000     42.71875    474.43817    386.89862    293.54230    178.87500     89.68750     92.25000      7.85547      0.02405     -0.01548      0.00565      4.64453      2.66888      0.00366
   5561.50000     42.56250    427.87781    360.84442    267.56506    178.75000     80.93750     64.81250      7.85547      0.02356     -0.01735      0.00589      4.82422      2.66971      0.00570
   5561.00000     42.56250    373.98645    327.73798    267.56506    178.87500     44.43750     48.84375      7.85547      0.02513     -0.02284      0.00654      4.53906      2.66702      0.00594
   5560.50000     40.50000    343.85339    308.84680    227.32965    179.12500     82.12500     58.81250      7.85547      0.02346     -0.02449      0.00633      4.42578      2.66988      0.00503
   5560.00000     34.21875    328.41589    292.01440    227.32965    179.50000     58.21875     43.96875      7.85547      0.02565     -0.02664      0.00611      4.76563      2.66614      0.00480
   5559.50000     31.03125    301.79761    263.31183    219.09305    179.50000     61.62500     44.43750      7.85547      0.01943     -0.02158      0.00599      5.12109      2.67678      0.00401
   5559.00000     30.98438    300.02893    245.23273    191.35971    179.37500     42.93750     53.53125      7.85547      0.01593     -0.01801      0.00535      5.69141      2.68276      0.00437
   5558.50000     37.31250    258.05420    211.36783    179.96927    179.37500     52.84375     44.00000      7.85547      0.01097     -0.01556      0.00549      5.50000      2.69125      0.00322
   5558.00000     36.25000    225.87369    182.55426    197.61334    178.75000     56.50000     44.31250      7.85547      0.01191     -0.01215      0.00490      5.02344      2.68963      0.00413
   5557.50000     36.21875    185.01788    168.22070    227.32965    177.75000     61.50000     48.12500      7.85547      0.01591     -0.01266      0.00566      4.75391      2.68280      0.00444
   5557.00000     29.78125    170.51541    160.65201    236.20972    176.87500     78.25000     47.15625      7.85547      0.02238     -0.01441      0.00594      4.62500      2.67173      0.00584
   5556.50000     27.53125    167.44305    147.38843    211.43246    176.00000     41.21875     26.48438      7.85547      0.02684     -0.01764      0.00771      4.79688      2.66410      0.00926
   5556.00000     23.25000    161.49078    129.55905    160.82358    175.12500     16.57813     21.43750      7.85547      0.02489     -0.01458      0.00940      4.68359      2.66743      0.01244
   5555.50000     23.25000    170.65771    120.79100    141.94754    174.87500     37.25000     41.43750      7.85547      0.02872     -0.01572      0.01041      4.81641      2.66090      0.01435
   5555.00000     25.46875    177.01050    125.02158    127.03708    174.75000     50.71875     54.46875      7.85547      0.02516     -0.01547      0.01090      4.64844      2.66697      0.01330
   5554.50000     28.73438    195.44916    136.14713    129.76318    175.50000     53.21875     47.87500      7.85547      0.02513     -0.01388      0.00984      4.94141      2.66702      0.01148
   5554.00000     35.00000    214.05917    160.65201    156.65717    176.50000     59.15625     55.59375      7.85547      0.01991     -0.01034      0.00894      4.80859      2.67595      0.00914
   5553.50000     37.25000    237.40256    195.90765    227.32965    177.12500     63.59375     62.15625      7.85547      0.01996     -0.01169      0.00723      5.09375      2.67587      0.00807
   5553.00000     38.31250    274.67303    263.31183    293.54230    178.00000     85.43750     85.25000      7.85547      0.01528     -0.01025      0.00685      5.13672      2.68387      0.00604
   5552.50000     38.53125    275.41199    300.19482    343.57800    179.00000     81.81250     73.43750      7.85547      0.01619     -0.00805      0.00629      4.95703      2.68231      0.00453
   5552.00000     38.34375    255.15930    263.31183    325.10608    179.75000     90.37500     99.81250      7.85547      0.01564     -0.00721      0.00610      4.71484      2.68325      0.00388
   5551.50000     40.50000    249.86450    256.99646    267.56506    180.37500    110.56250    103.12500      7.85547      0.01618     -0.00671      0.00576      4.59766      2.68233      0.00474
   5551.00000     38.34375    253.26511    239.74554    165.21765    181.25000     87.62500     77.68750      7.85547      0.00744     -0.00445      0.00630      4.61328      2.69729      0.00645
   5550.50000     37.40625    269.60907    215.62170    117.18924    181.62500     69.43750     46.71875      7.85547      0.00978     -0.00496      0.00775      4.56641      2.69327      0.00931
   5550.00000     35.46875    269.96460    168.22070    121.91460    181.62500     48.18750     40.21875      7.86328      0.01014     -0.00594      0.00907      4.31641      2.69266      0.01053
   5549.50000     30.10938    269.96460    158.27817    169.85861    181.50000     75.81250     77.62500      7.85547      0.01464     -0.00596      0.00872      4.69531      2.68497      0.00989
   5549.00000     26.89063    267.14642    192.38950    256.22754    181.62500    103.31250    107.50000      7.85547      0.01637     -0.00649      0.00806      4.80469      2.68200      0.00775
   5548.50000     23.42188    288.20508    263.31183    279.95233    181.25000    110.56250    111.00000      7.85547      0.01620     -0.00419      0.00701      4.98438      2.68230      0.00771
   5548.00000     24.43750    325.80371    338.07733    325.10608    181.00000     86.62500     77.43750      7.85547      0.01664     -0.00507      0.00700      4.73828      2.68155      0.00621
   5547.50000     23.34375    312.38617    338.07733    343.57800    180.37500    106.12500     94.12500      7.85547      0.01066     -0.00456      0.00597      4.82813      2.69177      0.00430
   5547.00000     28.73438    266.45099    300.19482    325.10608    180.12500     79.81250     58.18750      7.86328      0.00938     -0.00495      0.00567      5.04297      2.69396      0.00403
   5546.50000     34.12500    232.81155    256.99646    256.22754    179.87500     87.93750     64.00000      7.90234      0.01113     -0.00623      0.00612      4.78906      2.69096      0.00614
   5546.00000     36.21875    221.71329    207.27850    174.76782    179.87500     66.12500     50.93750      7.92578      0.01605     -0.00708      0.00727      4.65625      2.68255      0.01059
   5545.50000     29.78125    212.06244    176.53751    121.91460    179.62500     51.81250     43.90625      7.92188      0.01674     -0.00685      0.00944      4.59375      2.68138      0.01244
   5545.00000     24.40625    212.72385    145.38779    104.98201    179.50000     39.28125     35.87500      7.92969      0.01712     -0.00655      0.01024      4.71875      2.68072      0.01448
   5544.50000     24.53125    203.41766    134.43811    110.75026    179.25000     34.25000     35.37500      7.93750      0.01936     -0.01125      0.01163      4.75391      2.67689      0.01198
   5544.00000     26.75000    199.45111    132.77145    141.94754    178.87500     40.81250     43.25000      7.92188      0.01934     -0.00993      0.00965      4.47656      2.67693      0.01090
   5543.50000     27.85938    200.23199    151.55951    219.09305    178.12500    101.43750    126.00000      7.85547      0.01582     -0.01081      0.00857      4.86719      2.68294      0.00883
   5543.00000     27.67188    209.88699    195.90765    267.56506    177.25000    119.12500    116.37500      7.85547      0.01071     -0.00948      0.00745      4.89453      2.69168      0.00966
   5542.50000     25.48438    237.95456    250.97684    245.81177    176.50000     96.93750     79.31250      7.85547      0.01503     -0.01225      0.00903      5.09766      2.68429      0.01251
   5542.00000     28.62500    298.71594    263.31183    204.28946    175.75000     88.00000     72.62500      7.85547      0.01791     -0.01000      0.01125      4.52734      2.67938      0.01489
   5541.50000     29.71875    309.08575    250.97684    169.85861    175.12500     79.43750     65.25000      7.85547      0.02625     -0.01467      0.01297      4.65625      2.66512      0.01786
   5541.00000     28.71875    322.72351    220.05023    169.85861    174.50000     61.93750     53.65625      7.86328      0.02473     -0.01293      0.01459      4.51172      2.66771      0.01980
   5540.50000     22.39063    318.21063    207.27850    165.21765    174.25000     53.93750     51.06250      7.85547      0.02079     -0.01387      0.01445      4.84375      2.67445      0.01864
   5540.00000     18.18750    286.59149    234.49854    191.35971    173.75000     97.81250     85.50000      7.85547      0.01701     -0.01261      0.01284      4.91016      2.68091      0.01503
   5539.50000     20.28125    292.73737    245.23273    211.43246    173.37500     69.93750     60.65625      7.85547      0.01269     -0.01186      0.01091      5.16797      2.68830      0.01431
   5539.00000     19.23438    310.49164    263.31183    236.20972    173.37500     84.75000     58.21875      7.85547      0.01242     -0.00919      0.01034      5.18359      2.68876      0.01431
   5538.50000     20.28125    298.28088    263.31183    256.22754    173.25000     60.71875     67.87500      7.85547      0.01139     -0.01015      0.01075      4.92578      2.69053      0.01442
   5538.00000     18.09375    304.94348    276.92151    227.32965    173.25000     83.43750     93.87500      7.85547      0.01563     -0.00881      0.01129      4.97656      2.68327      0.01452
   5537.50000     20.25000    272.47968    245.23273    211.43246    173.37500     86.18750     72.93750      7.85547      0.01674     -0.00862      0.01194      4.74609      2.68138      0.01416
   5537.00000     26.67188    245.07776    220.05023    191.35971    173.12500     55.90625     51.37500      7.85547      0.02167     -0.01105      0.01285      4.96875      2.67295      0.01591
   5536.50000     32.03125    224.88080    207.27850    165.21765    172.62500     65.31250     62.06250      7.85547      0.02075     -0.01184      0.01305      4.99609      2.67452      0.01719
   5536.00000     33.03125    198.29108    179.49548    156.65717    172.00000     89.75000     70.37500      7.85547      0.02006     -0.01111      0.01282      5.24219      2.67569      0.01727
   5535.50000     26.65625    187.39120    170.90457    141.94754    171.25000     41.53125     47.84375      7.85547      0.02441     -0.01429      0.01235      5.20313      2.66826      0.01669
   5535.00000     21.34375    168.26999    153.73480    132.60889    170.37500     69.75000     57.15625      7.85547      0.02711     -0.01325      0.01204      4.93750      2.66365      0.01642
   5534.50000     21.34375    152.57034    143.44070    127.03708    169.50000     71.06250     67.87500      7.85547      0.02816     -0.01311      0.01195      4.73828      2.66185      0.01620
   5534.00000     23.54688    133.70029    128.01044    129.76318    168.25000     68.93750     63.53125      7.85547      0.02452     -0.01242      0.01194      4.88281      2.66806      0.01557
   5533.50000     29.01563    113.42308    110.79274    141.94754    167.25000     92.43750     81.75000      7.85547      0.02085     -0.01133      0.01168      4.94531      2.67435      0.01557
   5533.00000     30.01563     97.48705     98.55463    135.58218    166.37500     92.06250     73.25000      7.85547      0.02176     -0.01021      0.01159      5.27344      2.67280      0.01548
   5532.50000     29.87500     83.30106     83.22908    119.50523    165.75000     92.37500     76.37500      7.85547      0.02633     -0.01117      0.01157      5.12500      2.66497      0.01574
   5532.00000     26.50000     72.24454     72.02594    101.45911    165.12500     91.25000     74.43750      7.86328      0.02867     -0.00942      0.01177      5.12109      2.66098      0.01415
   5531.50000     24.50000     65.56029     62.36876     92.17931    164.87500     94.81250    102.31250      7.85547      0.02363     -0.00646      0.01096      5.15625      2.66960      0.01286
   5531.00000     23.54688     62.49587     55.85481     86.88165    165.00000     95.87500     91.18750      7.85547      0.01965     -0.00697      0.01000      5.04688      2.67639      0.01233
   5530.50000     20.37500     60.86686     53.61456     84.45479    165.12500     89.31250     76.56250      7.85547      0.01624     -0.00331      0.00947      4.82031      2.68222      0.01268
   5530.00000     20.37500     63.77071     54.15762     83.29150    165.75000     95.00000     82.50000      7.85547      0.01822     -0.00068      0.00952      4.63672      2.67885      0.01350
   5529.50000     19.21875     66.96396     57.35246     85.65103    166.00000    103.87500     98.31250      7.85547      0.02648     -0.00140      0.01034      4.79688      2.66472      0.01195
   5529.00000     24.28125     71.10822     63.47906     96.59685    166.75000     92.18750     81.43750      7.85547      0.03468     -0.00514      0.00925      4.68750      2.65070      0.01029
   5528.50000     32.90625     79.09502     75.05714    119.50523    167.87500     77.75000     78.12500      7.85547      0.04049     -0.00556      0.00770      3.52734      2.64076      0.00733
   5528.00000     37.18750     90.15733    100.40318    148.94003    169.50000     94.25000     87.43750      7.85547      0.03776     -0.00867      0.00602      3.51758      2.64543      0.00643
   5527.50000     39.43750    105.39650    145.38779    156.65717    171.37500    101.37500     98.12500      7.91406      0.02920     -0.01157      0.00647      3.77539      2.66006      0.00673
   5527.00000     37.18750    125.33096    165.61984    145.35974    173.50000     57.68750     61.28125      7.92969      0.02206     -0.01200      0.00778      5.07813      2.67227      0.00780
   5526.50000     37.12500    143.06360    158.27817    132.60889    175.37500     59.28125     56.90625      7.96094      0.01856     -0.01047      0.00908      5.03125      2.67826      0.00891
   5526.00000     35.12500    152.57034    147.38843    129.76318    177.00000     54.78125     51.12500      7.95313      0.02145     -0.01057      0.00936      4.98047      2.67332      0.01141
   5525.50000     28.68750    159.72415    141.54504    132.60889    178.12500     53.37500     51.28125      7.96484      0.01841     -0.00609      0.00931      4.64453      2.67851      0.01149
   5525.00000     25.71875    164.08325    147.38843    156.65717    179.00000     57.43750     56.12500      7.98047      0.02199     -0.00674      0.00865      4.65625      2.67240      0.01182
   5524.50000     27.81250    171.08612    160.65201    174.76782    179.62500     66.93750     73.68750      7.96484      0.01631     -0.00448      0.00856      4.79297      2.68211      0.01217
   5524.00000     32.00000    181.40729    185.71906    179.96927    180.00000     83.37500     86.06250      7.99219      0.01419     -0.00340      0.00896      5.16016      2.68574      0.01221
   5523.50000     36.21875    200.23199    203.34442    204.28946    180.00000     78.56250     82.06250      8.00000      0.00770     -0.00357      0.00896      4.95703      2.69684      0.00980
   5523.00000     34.00000    233.07675    211.36783    236.20972    180.12500     97.31250     88.00000      8.00000      0.00847     -0.00965      0.00732      4.50391      2.69552      0.00791
   5522.50000     32.00000    234.68033    239.74554    256.22754    180.25000     86.81250     71.31250      7.98047      0.00618     -0.00770      0.00652      4.44141      2.69943      0.00628
   5522.00000     30.89063    241.60623    263.31183    256.22754    180.87500     75.62500     64.37500      7.98047      0.01200     -0.01085      0.00560      4.37500      2.68948      0.00705
   5521.50000     29.96875    221.23392    245.23273    227.32965    181.37500     79.62500     72.12500      7.97266      0.01386     -0.01290      0.00660      4.62891      2.68629      0.00653
   5521.00000     27.87500    175.34088    203.34442    236.20972    182.12500     75.81250     64.56250      7.93750      0.01058     -0.01246      0.00688      4.79297      2.69190      0.00772
   5520.50000     26.70313    149.66522    170.90457    219.09305    182.75000     66.56250     77.87500      7.98047      0.01317     -0.01094      0.00764      4.91797      2.68748      0.00891
   5520.00000     25.54688    127.20477    139.69882    191.35971    183.50000     61.09375     68.75000      7.98047      0.01837     -0.01532      0.00864      4.89844      2.67859      0.01150
   5519.50000     27.62500    120.16734    129.55905    148.94003    184.25000     44.12500     65.81250      7.96484      0.02720     -0.02073      0.01034      4.79688      2.66348      0.01520
   5519.00000     31.75000    126.80980    120.79100    101.45911    184.87500     49.46875     60.25000      7.97266      0.02707     -0.02293      0.01334      4.54688      2.66371      0.02073
   5518.50000     39.12500    134.40411    108.54640     81.05847    185.37500     48.84375     49.78125      7.96484      0.02947     -0.02526      0.01836      4.58203      2.65961      0.02540
   5518.00000     42.37500    139.07080     95.90594     81.05847    184.87500     39.25000     34.62500      7.98047      0.02798     -0.02407      0.01888      4.57422      2.66215      0.02477
   5517.50000     38.28125    146.97409     95.90594    127.03708    183.75000     98.37500    126.18750      7.98047      0.02297     -0.02145      0.01484      5.03125      2.67073      0.01660
   5517.00000     27.73438    141.28284    116.83722    293.54230    182.62500    124.50000    146.87500      7.90234      0.01594     -0.01277      0.00893      5.12500      2.68274      0.00993
   5516.50000     23.28125    146.13318    176.53751    629.89429    181.37500    109.06250     93.18750      7.86328      0.00814     -0.00778      0.00590      5.24219      2.69608      0.00539
   5516.00000     26.37500    162.13120    229.47620    444.63074    180.00000     68.12500     61.18750      7.91406     -0.00271     -0.00195      0.00456      5.00781      2.71463      0.00378
   5515.50000     35.93750    173.11411    234.49854    227.32965    178.75000     52.93750     68.31250      7.94141     -0.00371     -0.00102      0.00590      4.55078      2.71635      0.00608
   5515.00000     40.25000    158.97879    185.71906    148.94003    177.37500     53.84375     61.09375      7.92578      0.00241     -0.00303      0.00827      4.09375      2.70588      0.00970
   5514.50000     46.75000    123.66106    128.01044    121.91460    175.87500     42.06250     56.53125      7.92188      0.01544     -0.01031      0.00967      4.07031      2.68359      0.01117
   5514.00000     48.93750     83.88426     86.59589    114.96129    174.12500     54.65625     70.75000      7.92969      0.02226     -0.01404      0.00926      4.20703      2.67193      0.01209
   5513.50000     50.96875     55.89066     60.94733    112.81650    172.00000     68.81250     73.37500      7.93750      0.02493     -0.01625      0.00925      4.41797      2.66737      0.01237
   5513.00000     43.53125     40.17815     43.38725    110.75026    169.12500     82.00000     87.56250      7.92188      0.03519     -0.01733      0.00927      4.61328      2.64983      0.01140
   5512.50000     36.12500     30.78076     31.77156    108.75833    166.12500     85.68750     66.75000      7.88281      0.04112     -0.01267      0.00960      4.71094      2.63968      0.01236
   5512.00000     30.92188     24.87772     24.42440     89.45212    163.00000     10.82031     14.53125      7.85547      0.06359     -0.00965      0.01197      5.03906      2.60127      0.01886
   5511.50000     29.89063     21.72940     19.98111     69.82635    160.12500      8.28125     11.56250      7.85547      0.08106     -0.00598      0.01889      4.64844      2.57139      0.03196
   5511.00000     28.81250     19.91993     17.42867     56.72572    157.87500      7.66016     10.81250      7.85547      0.09193     -0.00341      0.03642      4.82813      2.55280      0.04833
   5510.50000     26.68750     19.28831     16.23150     52.30936    155.87500      7.19141     10.14844      7.84375      0.09355     -0.00480      0.05591      4.69922      2.55003      0.06167
   5510.00000     29.89063     19.74206     16.66400     51.41974    155.25000      7.03125     10.20313      7.85547      0.07824     -0.00499      0.06639      4.99609      2.57620      0.06617
   5509.50000     45.81250     21.45826     18.58562     52.76581    155.50000      6.97656     10.09375      7.85547      0.06537     -0.00687      0.06457      4.88672      2.59822      0.06228
   5509.00000     58.65625     24.31559     22.65895     56.72572    156.87500      7.67188     10.27344      7.84375      0.04581     -0.00931      0.05310      4.98438      2.63166      0.05020
   5508.50000     59.78125     29.33891     30.50050     72.33208    159.25000     15.77344     23.03125      7.85547      0.03249     -0.00987      0.03623      4.95313      2.65444      0.03747
   5508.00000     46.81250     37.91559     46.40105    101.45911    162.12500     23.50000     34.46875      7.85547      0.02774     -0.01039      0.02305      4.89453      2.66257      0.02704
   5507.50000     38.18750     52.57391     80.11407    135.58218    164.87500     25.00000     45.15625      7.85547      0.03080     -0.01552      0.01598      4.48828      2.65733      0.02119
   5507.00000     32.78125     82.12546    134.43811    165.21765    167.75000     26.35938     49.43750      7.87109      0.02972     -0.01344      0.01335      4.46094      2.65919      0.01614
   5506.50000     32.84375    128.89081    195.90765    160.82358    170.37500     25.31250     59.28125      7.91406      0.03037     -0.01422      0.01146      4.69922      2.65807      0.01428
   5506.00000     28.67188    166.08279    220.05023    145.35974    172.62500     28.59375     53.62500      7.90234      0.03331     -0.01798      0.01094      4.73828      2.65304      0.01303
   5505.50000     25.51563    198.67627    199.55676    156.65717    174.62500     31.60938     53.31250      7.92578      0.03314     -0.01752      0.00973      4.76953      2.65332      0.01209
   5505.00000     22.45313    201.41489    185.71906    185.48981    176.12500     44.46875     82.93750      7.91406      0.03195     -0.01573      0.00923      4.62500      2.65536      0.01118
   5504.50000     23.48438    188.42706    203.34442    197.61334    177.25000     43.15625     67.81250      7.92578      0.02709     -0.01750      0.00840      5.00781      2.66367      0.01051
   5504.00000     25.56250    191.96402    199.55676    174.76782    178.37500     39.65625     57.34375      7.96484      0.02480     -0.01354      0.00870      5.21484      2.66760      0.01024
   5503.50000     24.32813    198.48349    185.71906    165.21765    179.37500     43.46875     58.12500      7.94141      0.01814     -0.01015      0.00868      5.04297      2.67897      0.01066
   5503.00000     23.32813    188.25363    176.53751    165.21765    180.50000     47.21875     62.96875      7.97266      0.02054     -0.00908      0.00852      4.87891      2.67487      0.01019
   5502.50000     24.31250    180.92578    163.09811    165.21765    181.87500     46.03125     57.84375      7.98047      0.01957     -0.00687      0.00830      4.48828      2.67653      0.01013
   5502.00000     25.48438    165.27719    155.97342    169.85861    183.37500     53.00000     65.87500      7.96484      0.02595     -0.00921      0.00833      4.53516      2.66562      0.01032
   5501.50000     27.65625    159.35062    153.73480    160.82358    184.62500     55.56250     64.00000      7.97266      0.02922     -0.01432      0.00870      4.35938      2.66003      0.01046
   5501.00000     25.65625    144.78705    153.73480    152.70114    185.25000     55.46875     60.40625      8.00000      0.03037     -0.01495      0.00833      4.32422      2.65807      0.01071
   5500.50000     26.68750    147.39813    145.38779    148.94003    186.25000     53.84375     59.87500      8.00000      0.02904     -0.01680      0.00821      4.36328      2.66034      0.01132
   5500.00000     25.53125    139.26038    145.38779    145.35974    187.25000     59.87500     61.34375      8.00000      0.02620     -0.01442      0.00879      4.60938      2.66519      0.01256
   5499.50000     26.50000    137.85083    139.69882    145.35974    188.25000     57.12500     58.12500      8.00000      0.02768     -0.01537      0.00943      4.67578      2.66266      0.01321
   5499.00000     26.40625    136.92682    136.14713    145.35974    189.12500     55.34375     55.09375      8.00000      0.02267     -0.01058      0.00993      4.39063      2.67123      0.01218
   5498.50000     26.50000    127.68199    131.14560    152.70114    190.12500     56.84375     58.62500      8.00000      0.03018     -0.01355      0.00913      4.47656      2.65840      0.01154
   5498.00000     28.75000    124.41455    126.49835    148.94003    191.00000     63.12500     66.50000      8.00000      0.02878     -0.01101      0.00867      4.34375      2.66078      0.01108
   5497.50000     27.76563    116.39864    120.79100    141.94754    191.62500     63.28125     67.43750      8.00000      0.03501     -0.01574      0.00841      4.59375      2.65014      0.01140
   5497.00000     28.73438    113.61250    111.95113    121.91460    192.50000     53.09375     51.59375      8.00000      0.03294     -0.01638      0.00937      4.26563      2.65367      0.01236
   5496.50000     31.90625    109.76259    106.38930    101.45911    193.12500     52.28125     50.21875      8.00000      0.04458     -0.02226      0.01032      4.45313      2.63378      0.01262
   5496.00000     33.15625    102.48410     96.77287     92.17931    193.87500     53.56250     48.56250      8.00000      0.04247     -0.02186      0.01011      4.44922      2.63738      0.01221
   5495.50000     35.25000    101.51494     92.58803     90.79524    194.50000     45.12500     41.68750      8.00781      0.03905     -0.02144      0.00996      4.64453      2.64323      0.01187
   5495.00000     33.06250     99.58176     91.01363     99.78487    194.87500     48.09375     44.78125      8.00781      0.03057     -0.01870      0.00898      4.56641      2.65772      0.01250
   5494.50000     34.03125     96.79285     93.39581    117.18924    195.25000     58.87500     57.46875      8.00000      0.03741     -0.01951      0.00944      4.44531      2.64603      0.01233
   5494.00000     35.18750     98.90559     96.77287    121.91460    195.62500     58.18750     55.93750      8.00000      0.03901     -0.01919      0.00933      4.44531      2.64328      0.01216
   5493.50000     33.06250     98.28586    100.40318    119.50523    195.75000     58.84375     56.34375      8.00000      0.03066     -0.01521      0.00904      4.51953      2.65757      0.01225
   5493.00000     34.12500    100.71284    103.30966    117.18924    196.00000     55.65625     53.90625      8.00781      0.02322     -0.01658      0.00920      4.51563      2.67029      0.01192
   5492.50000     32.03125    105.39650    105.34258    112.81650    196.25000     55.81250     52.78125      8.00781      0.02129     -0.01472      0.00848      4.35938      2.67359      0.01321
   5492.00000     34.25000    105.45097    105.34258    108.75833    196.62500     59.84375     57.90625      8.00781      0.02171     -0.01196      0.00945      4.33594      2.67287      0.01186
   5491.50000     33.06250    109.23373    107.45705    101.45911    196.62500     56.06250     47.06250      8.02344      0.02546     -0.01182      0.00866      4.37891      2.66646      0.01155
   5491.00000     38.28125    113.54929    107.45705    101.45911    196.75000     64.87500     61.18750      8.06250      0.02598     -0.01208      0.00867      4.32031      2.66557      0.01109
   5490.50000     36.12500    110.77559    107.45705    108.75833    196.50000     59.25000     52.53125      8.00781      0.03327     -0.01024      0.00838      4.29297      2.65311      0.01261
   5490.00000     40.40625    111.25877    111.95113    127.03708    196.50000     61.40625     60.43750      8.05469      0.03796     -0.01122      0.00889      4.23828      2.64508      0.01176
   5489.50000     34.00000    116.00172    116.83722    135.58218    196.12500     45.56250     52.43750      8.03906      0.03480     -0.01028      0.00916      4.35156      2.65049      0.01222
   5489.00000     34.00000    120.02603    126.49835    127.03708    196.12500     45.25000     49.28125      8.07813      0.02836     -0.00790      0.00959      4.52734      2.66151      0.01188
   5488.50000     28.59375    116.73145    123.57886    110.75026    196.12500     41.50000     46.06250      8.12500      0.01805     -0.00526      0.00909      4.65625      2.67913      0.01317
   5488.00000     27.50000    115.60748    114.34204     98.16499    196.12500     41.53125     46.43750      8.14063      0.01379     -0.00396      0.00969      4.61328      2.68642      0.01337
   5487.50000     28.56250    111.44106    104.31622     90.79524    195.87500     42.90625     44.96875      8.12500      0.01244     -0.00330      0.01034      4.30859      2.68873      0.01445
   5487.00000     29.68750    105.56013     95.05438     85.65103    195.50000     46.15625     41.87500      8.14844      0.01455     -0.00509      0.01106      3.95117      2.68513      0.01476
"""

LAS_02_1000FT_DOWN = """# 03/10/1999 14:53:39 Updated by the Kansas Geological Survey
# #KGS#ID: 31S33W/1001178923
# Additions:   1001178923.add
# Old: WELL.                    GASKILL NO. 1-5: Well Name
# New: WELL.                                1-5: Well Name
# New: LEAS.                            GASKILL: Lease Name
#
# 03/04/1999 13:55:28 Updated by the Kansas Geological Survey
# Additions:   1001178923.add
# New: UWI .                       15-175-21301: Unique Well Id
# New: PM  .                                  6: Principal Meridian
# Old: STAT.                             KANSAS: STATE
# New: STAT.                             Kansas: State
#
# 02/25/1999 15:08:23 Updated by the Kansas Geological Survey
# #KGS#INPUT_FILE: /home/crude2_3/WellLogs/Guy/105-Ddrive/Hugelogs/GASKIL15.las.las
~VERSION INFORMATION
 VERS.                                2.0: CWLS LOG ASCII STANDARD - VERSION 2.0
 WRAP.                                 NO: ONE LINE PER DEPTH STEP
~WELL INFORMATION BLOCK
#MNEM.UNIT       DATA TYPE    INFORMATION
#---------    -------------   ------------------------------
 UWI .                       15-175-21301: Unique Well Id
 PM  .                                  6: Principal Meridian
 STAT.                             Kansas: State
 SECT.                                  5: Section
 TOWN.                                31S: Township
 RANG.                                33W: Range
 COUN.                             SEWARD: County Name
 COMP.         HUGOTON ENERGY CORPORATION: Company
 WELL.                                1-5: Well Name
 LEAS.                            GASKILL: Lease Name
 FLD .                            VICTORY: Field
 STRT.F                        1786.50000: 
 STOP.F                        2786.50000: 
 STEP.F                           0.50000: 
 NULL.                         -999.25000: NULL VALUE
 LOC .     440' FNL & 440' FWL, 5-31S-33W: LOCATION
 LOC1.                                   : LOCATION1
 CTRY.                                   : COUNTRY
 DATE.                        22-MAR-1993: LOG DATE
 API .                       15-175-21301: API NUMBER
 DAY .                                 22: LOG DAY
 MONT.                                  3: LOG MONTH
 YEAR.                                 93: LOG YEAR
 DMF .                      KELLY BUSHING: DRILLING REF
 LMF .                      KELLY BUSHING: LOGGING  REF
 PDAT.                       GROUND LEVEL: PERMANENT DATUM
 ENGI.                          JON BLACK: LOGGING ENGINEER
 WITN.                     KARL OSTERBUHR: LOGGING WITNESS
 LATI.                                   : LATITUDE
 LONG.                                   : LONGITUDE
 LUL .                       LIBERAL,  KS: LOGGING DISTRICT
 LUN .                               8510: LOGGING UNIT NO.
 RUN .                                ONE: LOGGING RUN NO.
 SON .                             603664: SERVICE ORDER NO.
 SRVC.         SCHLUMBERGER WELL SERVICES: SERVICE COMPANY
~CURVE INFORMATION
#MNEM.UNIT      API CODE      CURVE DESCRIPTION
#---------    -------------   ------------------------------
 DEPT.F                                 0: 1  Depth
 GR  .GAPI                        7310010: 2 Gamma Ray
 ILD .OHMM                        7120460: 3 Deep  Induction Standard Resistivity
 ILM .OHMM                        7120440: 4 Medium Induction Standard Resistivity
 SFLU.OHMM                        7220010: 5 SFL Resistivity (unaveraged)
 SP  .MV                          7010010: 6 Spontaneous Potential
 BMIN.OHMM                        1525001: 7 MICRO INVERSE
 BMNO.OHMM                        1525201: 8 MICRO NORMAL
 CALI.IN                          1528001: 9 Caliper
 DPHI.V/V                         1589001: 10 Density Porosity
 DRHO.G/C3                        1535601: 11 Delta  RHO
 NPHI.V/V                         1589000: 12 Neutron Porosity N
 PEF .                            1535801: 13 Photoelectric Factor
 RHOB.G/C3                        1535002: 14 Bulk Density
 TNPH.V/V                         1589000: 15 Thermal Neutron Porosity
~PARAMETER INFORMATION
#MNEM.UNIT        VALUE       DESCRIPTION
#---------    -------------   ------------------------------
 BHT .DEGF                            N/A: Bottom Hole Temperature
 BS  .IN                            7.875: Bit Size
 MDEN.G/C3                            N/A: Matrix Density
 DFD .LB/G                            9.1: Drilling Fluid Density
 DFV .S                               52.: Drilling Fluid Viscosity
 DFL .C3                         8.799999: Drilling Fluid Loss
 RMFS.OHMM                           1.14: Resistivity of Mud Filtrate Sample
 EKB .F                             2944.: Elevation of Kelly Bushing
 EGL .F                             2936.: Elevation of Ground Level
 BLI .F                             5664.: Bottom Log Interval
 BSAL.PPM                           2200.: Borehole Salinity
 FLEV.F                                0.: Fluid Level
 MCST.DEGF                            58.: Mud Cake Sample Temperature
 MFST.DEGF                            58.: Mud Filtrate Sample Temperature
 MRT .DEGF                           123.: Maximum Recorded Temperature
 MST .DEGF                            58.: Mud Sample Temperature
 RMCS.OHMM                           2.15: Resistivity of Mud Cake Sample
 RMS .OHMM                           1.43: Resistivity of Mud Sample
 RW  .OHMM                             1.: Resistivity of Water
 TDD .F                             5670.: Total Depth - Driller
 TDL .F                             5670.: Total Depth - Logger
 TLI .F                           -50000.: Top Log Interval
~OTHER INFORMATION
 HIDE.     DUAL INDUCTION LOG                      : Header Identifer
 MATR.     N/A                                     : Matrix
 FNUM.     N/A                                     : F-Numerator for Formation F
 FEXP.     N/A                                     : F-Exponent for Formation Fa
 DFT .     CHEMICAL                                : Drilling Fluid Type
 DFPH.     9.                                      : Drilling Fluid Ph
 MCSS.     MEASURED                                : Mud Cake Sample Source
 MFSS.     MEASURED                                : Mud Filtrate Sample Source
 FD  .     N/A                                     : Fluid Density
 MSS .     CIRCULATED                              : Mud Sample Source
 OS1 .     DIL-SFL-GR                              : Other Services Line 1
 OS2 .     LDL-CNL-GR                              : Other Services Line 2
 OS3 .     ML-GR                                   : Other Services Line 3
 OS4 .                                             : Other Services Line 4
 OS5 .                                             : Other Services Line 5
 OS6 .                                             : Other Services Line 6
 R1  .     1 1/2" STANDOFFS USED ABOVE AND BELOW   : Remark Line 1
 R2  .     INDUCTION TOOL.                         : Remark Line 2
 R3  .                                             : Remark Line 3
 R4  .                                             : Remark Line 4
 R5  .                                             : Remark Line 5
 R6  .                                             : Remark line 6
 R7  .                                             : Remark line 7
 R8  .                                             : Remark line 8
 HIDE.     POROSITY LOG                            : Header Identifer
 MATR.     0.0                                     : Neutron Matrix (0=LIME)
 FNUM.     1.                                      : F-Numerator for Formation F
 FEXP.     2.                                      : F-Exponent for Formation Fa
 DFT .     CHEMICAL                                : Drilling Fluid Type
 DFPH.     9.                                      : Drilling Fluid Ph
 MCSS.     MEASURED                                : Mud Cake Sample Source
 MFSS.     MEASURED                                : Mud Filtrate Sample Source
 FD  .G/C3 0.9999999                               : Fluid Density
 MSS .     CIRCULATED                              : Mud Sample Source
 OS1 .     DIL-SFL-GR                              : Other Services Line 1
 OS2 .     LDL-CNL-GR                              : Other Services Line 2
 OS3 .     ML-GR                                   : Other Services Line 3
 OS4 .                                             : Other Services Line 4
 OS5 .                                             : Other Services Line 5
 OS6 .                                             : Other Services Line 6
 R1  .     BOW SPRING ECCENTRALIZER RAN            : Remark Line 1
 R2  .     ON NEUTRON TOOL. TOOL STRING            : Remark Line 2
 R3  .     ALSO ECCENTRALIZED BY CALIPERS          : Remark Line 3
 R4  .     ON DENSITY AND MICROLOG TOOLS.          : Remark Line 4
 R5  .     THANKS FOR CHOOSING SCHLUMBERGER!       : Remark Line 5
 R6  .                                             : Remark line 6
 R7  .                                             : Remark line 7
 R8  .                                             : Remark line 8
#MNEM.UNIT    VALUE                                 DESCRIPTION
#---------    -----------------------------------   ----------------------------
~A       DEPT         GR           ILD          ILM          SFLU         SP           BMIN         BMNO         CALI         DPHI         DRHO         NPHI         PEF          RHOB         TNPH
   1786.50000     49.75000    100.71284     43.38725   2000.00000    221.87500   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000
   1787.00000     47.68750    118.83820     39.10045   2000.00000    222.62500   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000
   1787.50000     46.75000    105.99890     37.06535   2000.00000    223.12500   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000
   1788.00000     47.18750     97.16185     44.65627   2000.00000    223.62500   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000
   1788.50000     53.65625     93.20831     72.51404   2000.00000    224.37500   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000
   1789.00000     52.56250     88.32082    132.77145   2000.00000    225.75000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000
   1789.50000     51.28125     77.11755    199.55676   2000.00000    227.12500   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000
   1790.00000     44.78125     71.00893    300.19482   2000.00000    228.50000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000
   1790.50000     41.81250     62.94113   1816.66284   2000.00000    231.62500   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000
   1791.00000     39.68750     58.48309   2000.00000   2000.00000    235.87500   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000
   1791.50000     36.78125     52.28925   2000.00000   2000.00000    239.62500   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000   -999.25000
   1792.00000     39.78125     56.52889   2000.00000   2000.00000    242.37500      0.72021      0.47314      8.03906      0.48225     -0.55476      0.18359     25.62500      1.88534      0.16121
   1792.50000     41.96875     69.26782   2000.00000   2000.00000    242.87500      0.73340      0.43750      8.06250      0.46947     -0.54582      0.15441     29.12500      1.90721      0.14985
   1793.00000     41.96875     44.92635   2000.00000   2000.00000    240.87500      0.72021      0.43750      8.03906      0.46037     -0.54853      0.13409     26.92188      1.92276      0.12861
   1793.50000     38.90625     22.35489   2000.00000   2000.00000    238.87500      0.73340      0.45557      8.03906      0.45991     -0.55415      0.12595     27.70313      1.92355      0.12085
   1794.00000     31.87500     23.79499   2000.00000   2000.00000    237.37500      0.73340      0.47314      8.00781      0.45706     -0.55132      0.13965     24.46875      1.92843      0.12110
   1794.50000     36.81250     19.86029   2000.00000   2000.00000    238.62500      0.72021      0.41992      8.02344      0.45838     -0.55449      0.14807     28.68750      1.92618      0.13435
   1795.00000     37.75000     16.60017   2000.00000   2000.00000    240.87500      0.73340      0.41992      8.04688      0.45154     -0.55700      0.15708     35.46875      1.93786      0.14531
   1795.50000     41.56250     20.20913   2000.00000   2000.00000    243.12500      0.70654      0.41992      8.07813      0.43430     -0.54613      0.15392     40.71875      1.96734      0.15233
   1796.00000     39.53125     20.11520    105.34258   2000.00000    245.37500      0.70654      0.41992      8.08594      0.42519     -0.53358      0.17081     39.68750      1.98292      0.15446
   1796.50000     44.65625     19.64653   2000.00000   2000.00000    245.62500      0.72021      0.41992      8.08594      0.42106     -0.52996      0.20286     27.43750      1.98999      0.17199
   1797.00000     51.87500     19.52504   2000.00000   2000.00000    245.62500      0.69336      0.41992      8.05469      0.40069     -0.50842      0.25705     34.09375      2.02482      0.20420
   1797.50000     60.03125     16.86905   2000.00000   2000.00000    244.87500      0.72021      0.41992      8.07813      0.35865     -0.47429      0.27622     37.18750      2.09670      0.25402
   1798.00000     64.00000     49.16930   2000.00000   2000.00000    244.12500      0.70654      0.41992      8.11719      0.34218     -0.47403      0.28182     26.89063      2.12488      0.27756
   1798.50000     65.12500   2000.00000   2000.00000   2000.00000    244.87500      0.47998      0.34814      8.10938      0.35127     -0.47724      0.29215     21.48438      2.10933      0.29127
   1799.00000     60.28125   2000.00000   2000.00000   2000.00000    246.87500      0.72021      0.41992      8.08594      0.36413     -0.48241      0.32908     19.01563      2.08733      0.30633
   1799.50000     56.21875    671.96948   2000.00000   2000.00000    250.62500      0.70654      0.41992      8.07813      0.37984     -0.50243      0.34635     26.50000      2.06047      0.34204
   1800.00000     52.12500    173.99792   2000.00000   2000.00000    254.12500      0.70654      0.41992      8.12500      0.37526     -0.51103      0.34928     25.29688      2.06830      0.34040
   1800.50000     46.96875     26.89433   2000.00000   2000.00000    255.37500      0.72021      0.43750      8.14844      0.36713     -0.50249      0.34397     34.03125      2.08221      0.33253
   1801.00000     46.96875   2000.00000   2000.00000      1.18045    255.37500      0.68018      0.41992      8.14844      0.37987     -0.51404      0.32191     33.84375      2.06042      0.33015
   1801.50000     45.06250   2000.00000   2000.00000      0.13572    248.12500      0.73340      0.41992      8.14844      0.38961     -0.59249      0.32331     80.68750      2.04377      0.33021
   1802.00000     53.18750   2000.00000   2000.00000      0.12538    235.87500      0.68018      0.41992      8.14844      0.37249     -0.52855      0.40371      5.22266      2.07304      0.35246
   1802.50000     60.40625   2000.00000   2000.00000      0.13470    222.75000      0.70654      0.45557      8.25781      0.26246     -0.24209      0.47594      3.01367      2.26120      0.40538
   1803.00000     74.43750   2000.00000   2000.00000      0.15300    207.75000      0.74707      0.54492      9.52344      0.43965     -0.18232      0.44303      2.35742      1.95819      0.41080
   1803.50000     78.93750   2000.00000   2000.00000      0.28284    194.50000      0.73340      0.67041     10.28125      0.44405     -0.10721      0.31743      1.93262      1.95067      0.30448
   1804.00000     76.43750   2000.00000      8.32850      1.00371    190.00000      0.73340      0.72363      9.47656      0.38707     -0.01967      0.23297      2.47461      2.04811      0.24139
   1804.50000     71.06250      2.63272   2000.00000      1.36236    188.87500      0.76025      0.72363      9.48438      0.21294      0.03584      0.19855      2.52930      2.34587      0.20423
   1805.00000     72.31250      0.48276      0.96357      1.53765    187.87500      0.74707      0.74170      9.60156      0.13334      0.00993      0.17468      2.52930      2.48198      0.19130
   1805.50000     70.50000      0.89008      1.07778      1.97768    187.75000      0.74707      0.74170      9.74219      0.11485     -0.00051      0.17552      2.48242      2.51361      0.18332
   1806.00000     74.56250      1.05385      1.33316      2.26342    187.87500      0.73340      0.74170      9.89844      0.11143      0.00087      0.17888      2.51758      2.51946      0.19109
   1806.50000     82.18750      1.08849      1.21077      2.11981    187.50000      0.76025      0.74170     10.06250      0.12478     -0.00100      0.19419      2.42773      2.49663      0.19799
   1807.00000     93.25000      1.81881      1.16727      2.03082    187.37500      0.74707      0.74170     10.25000      0.14449     -0.00257      0.22136      2.46289      2.46292      0.21625
   1807.50000     93.87500      1.85126      1.25354      1.98287    188.00000      0.74707      0.72363     10.54688      0.16442      0.00624      0.25222      2.53711      2.42884      0.24394
   1808.00000     89.06250      1.38615      1.63546      1.75498    188.50000      0.74707      0.72363     10.99219      0.20294      0.02493      0.27976      2.56445      2.36297      0.26933
   1808.50000     82.18750      1.32279      1.53666      1.82931    190.00000      0.77393      0.74170     11.13281      0.22964      0.01796      0.29666      2.66016      2.31731      0.29191
   1809.00000     83.75000      1.27380      1.48850      1.81940    190.25000      0.80029      0.74170     11.26563      0.22346      0.01856      0.28783      2.76758      2.32788      0.30424
   1809.50000     78.25000      1.24582      1.32264      1.71418    190.37500      0.78711      0.74170     11.50781      0.16185      0.05381      0.26544      2.94336      2.43324      0.30162
   1810.00000     77.31250      1.24453      1.29650      1.52910    190.50000      0.80029      0.74170     11.57813      0.14096      0.06957      0.26731      2.87500      2.46896      0.28274
   1810.50000     80.12500      1.21904      1.53858      1.36605    190.12500      0.76025      0.74170     11.78906      0.17482      0.02709      0.28591      2.81836      2.41106      0.28627
   1811.00000     90.31250      1.28788      1.34477      1.25492    190.00000      0.77344      0.74170     11.75000      0.18416      0.02481      0.33024      2.91016      2.39508      0.29251
   1811.50000     96.62500      1.38242      1.25876      1.25466    189.87500      0.77393      0.74170     11.60156      0.16364      0.03813      0.33714      3.04883      2.43017      0.33681
   1812.00000     95.62500      1.29619      1.22804      1.33528    189.62500      0.80029      0.74170     11.58594      0.15614      0.02745      0.32353      3.26172      2.44300      0.35210
   1812.50000     97.43750      1.26246      1.21199      1.34778    189.37500      0.78711      0.74170     11.70313      0.16712      0.01442      0.31674      3.22852      2.42422      0.33998
   1813.00000     96.12500      1.24682      1.20834      1.25336    189.00000      0.78711      0.74170     11.83594      0.18541      0.03324      0.31032      3.12305      2.39295      0.33296
   1813.50000    102.50000      1.20819      1.20471      1.15431    188.75000      0.77344      0.72363     11.87500      0.23070      0.03339      0.32869      2.87891      2.31550      0.30260
   1814.00000     98.50000      1.19246      1.19991      1.17586    188.50000      0.72021      0.67041     11.80469      0.23876      0.03258      0.31585      2.72656      2.30171      0.30003
   1814.50000     96.56250      1.18806      1.19159      1.19067    187.75000      0.54639      0.56250     11.45313      0.22267      0.02998      0.29661      2.75781      2.32923      0.29855
   1815.00000     94.18750      1.17653      1.17527      1.15497    187.12500      0.41309      0.61621     11.14063      0.18210      0.01989      0.27879      2.92188      2.39861      0.29416
   1815.50000     95.06250      1.15924      1.14937      1.08086    186.75000      0.77344      0.84912     11.13281      0.16744      0.00892      0.26248      3.13672      2.42368      0.29468
   1816.00000     95.37500      1.13205      1.12453      1.07337    186.50000      0.74658      0.75977     11.44531      0.16376      0.00196      0.26458      3.29102      2.42997      0.28534
   1816.50000     93.37500      1.10096      1.10069      1.05668    186.37500      0.90674      0.70605     11.79688      0.17825      0.00888      0.31535      3.16602      2.40520      0.28116
   1817.00000     97.50000      1.06090      1.07974      1.04445    185.75000      1.01367      0.68799     12.66406      0.20249      0.02431      0.32369      2.94141      2.36375      0.31123
   1817.50000    107.81250      1.01503      1.06142      1.02952    184.75000      0.61328      0.67041     13.03125      0.21638      0.02637      0.32085      2.52539      2.34000      0.30235
   1818.00000    102.87500      0.95823      1.02828      1.02707    183.62500      0.69336      0.68799     12.58594      0.20619      0.03540      0.26449      2.37695      2.35741      0.28672
   1818.50000     98.43750      0.90758      0.97315      1.06225    181.87500      0.76025      0.83105     11.74219      0.16755      0.04903      0.25173      2.34570      2.42349      0.25439
   1819.00000     86.56250      0.87007      0.91107      0.99758    180.12500      0.98682      0.92090     11.24219      0.16573      0.02664      0.25672      2.48633      2.42660      0.24769
   1819.50000     82.56250      0.84948      0.86432      0.96173    178.87500      1.70801      1.00977     11.12500      0.17517      0.00790      0.24712      2.45898      2.41045      0.24678
   1820.00000     74.75000      0.85994      0.84167      0.89616    178.25000      1.56152      1.17090     11.10938      0.18681      0.00650      0.25231      2.48242      2.39056      0.24547
   1820.50000     72.06250      0.88504      0.85412      0.86144    178.50000      1.62793      1.11719     11.10938      0.18840      0.00521      0.24329      2.53125      2.38783      0.25975
   1821.00000     69.68750      0.92750      0.90190      0.81942    179.12500      1.34766      1.04590     11.10156      0.18585      0.01162      0.26157      2.57031      2.39220      0.25220
   1821.50000     71.68750      1.00356      0.98373      0.95746    179.50000      1.52051      1.00977     11.07031      0.18290      0.03030      0.25043      2.45703      2.39724      0.24863
   1822.00000     74.31250      1.13296      1.09462      1.11493    179.12500      0.90674      1.00977     10.96875      0.21014      0.01180      0.21188      2.37305      2.35067      0.21482
   1822.50000     71.75000      1.33643      1.25094      1.16813    178.25000      0.80029      0.92090     10.77344      0.21572      0.00956      0.14484      2.31836      2.34112      0.16965
   1823.00000     64.87500      1.57701      1.49964      1.27611    177.12500      0.54639      0.74170     10.58594      0.20757      0.00915      0.10422      2.40234      2.35506      0.12797
   1823.50000     55.25000      1.78740      1.77913      1.71079    176.00000      0.56006      0.77734     10.51563      0.20085      0.00450      0.09536      2.36523      2.36654      0.11252
   1824.00000     53.09375      1.92528      1.92494      2.36154    175.62500      0.58691      0.74170     10.42969      0.20692     -0.00089      0.12403      2.39063      2.35617      0.11327
   1824.50000     53.68750      1.93988      1.92051      2.49195    175.37500      0.49316      0.72363     10.38281      0.20766      0.00684      0.15643      2.36719      2.35489      0.13970
   1825.00000     58.59375      1.79623      1.77216      1.91081    175.00000      0.69385      0.79541     10.29688      0.21390      0.00888      0.19425      2.31641      2.34423      0.16488
   1825.50000     57.65625      1.57919      1.50677      1.49952    174.75000      0.56006      0.70605     10.10156      0.21326      0.01082      0.20889      2.27734      2.34532      0.19054
   1826.00000     62.06250      1.29008      1.24965      1.27128    174.62500      0.78711      0.92041      9.98438      0.21383      0.01366      0.19833      2.22266      2.34436      0.19904
   1826.50000     62.00000      1.00126      1.01679      1.12259    174.50000      0.70703      0.88477      9.92969      0.20979      0.01358      0.19785      2.30078      2.35125      0.19575
   1827.00000     64.87500      0.78373      0.79843      1.03074    174.12500      0.80029      0.95654      9.92969      0.20752      0.01424      0.21235      2.33594      2.35514      0.20894
   1827.50000     61.75000      0.64155      0.64152      0.83885    173.50000      0.60010      0.77734      9.99219      0.21977      0.01325      0.24807      2.21094      2.33420      0.23622
   1828.00000     61.68750      0.54093      0.55603      0.70944    172.87500      0.53320      0.72363     10.08594      0.24460      0.00884      0.25357      2.18945      2.29174      0.25986
   1828.50000     59.53125      0.48880      0.50699      0.59968    172.50000      0.58691      0.83105     10.08594      0.26092      0.00249      0.24886      2.09570      2.26382      0.25585
   1829.00000     57.59375      0.46960      0.47888      0.65931    172.37500      0.43994      0.67041     10.08594      0.26416     -0.00057      0.24408      2.19141      2.25828      0.25793
   1829.50000     56.78125      0.47630      0.47047      0.62445    172.37500      0.49316      0.68799     10.08594      0.26073     -0.00020      0.24170      2.13281      2.26415      0.25598
   1830.00000     62.09375      0.52887      0.49910      0.61182    171.87500      0.61328      0.74170     10.11719      0.27127     -0.00216      0.22502      2.14063      2.24613      0.23980
   1830.50000     64.31250      0.61872      0.59116      0.57505    171.62500      0.62695      0.74170     10.17969      0.27893     -0.00286      0.18804      2.15430      2.23303      0.21098
   1831.00000     66.43750      0.68887      0.75510      0.70154    171.37500      0.65332      0.88477     10.12500      0.28079      0.00405      0.17395      2.23047      2.22984      0.17652
   1831.50000     66.43750      0.73872      0.90541      1.09198    171.37500      0.62695      0.88477     10.13281      0.27949      0.01131      0.18205      2.25781      2.23208      0.17537
   1832.00000     62.25000      0.76305      0.92625      1.68599    171.50000      0.64014      0.81299     10.14844      0.28156      0.02172      0.22967      2.21680      2.22853      0.19300
   1832.50000     64.68750      0.80073      0.84290      1.40379    171.87500      0.49316      0.74170     10.15625      0.28456      0.02872      0.25715      2.11719      2.22340      0.23678
   1833.00000     65.25000      0.87428      0.75913      0.80437    172.25000      0.39990      0.59863     10.08594      0.28378      0.04388      0.27305      2.06445      2.22474      0.25671
   1833.50000     73.18750      0.92199      0.72935      0.57636    172.75000      0.45313      0.59863     10.08594      0.28084      0.04308      0.24496      2.04688      2.22976      0.25964
   1834.00000     71.68750      0.85577      0.74226      0.57417    172.75000      0.46680      0.61670     10.08594      0.27328      0.03680      0.22788      2.12891      2.24269      0.23429
   1834.50000     76.06250      0.72038      0.74226      0.76548    172.87500      0.47998      0.70557     10.08594      0.24986      0.03094      0.22718      2.32227      2.28273      0.22216
   1835.00000     80.06250      0.60935      0.68578      1.08590    173.00000      0.54639      0.83105     10.10156      0.22054      0.03304      0.22840      2.34180      2.33287      0.22711
   1835.50000     78.87500      0.54830      0.62483      1.04121    173.00000      0.38623      0.58057     10.08594      0.22032      0.01795      0.23684      2.27734      2.33325      0.22970
   1836.00000     68.75000      0.53351      0.59535      0.85317    173.12500      0.34619      0.56250     10.15625      0.22791      0.01311      0.22094      2.24414      2.32027      0.24126
   1836.50000     61.46875      0.54772      0.56890      0.74145    173.25000      0.31982      0.52686     10.21875      0.24220      0.01134      0.24039      2.33789      2.29583      0.23157
   1837.00000     62.18750      0.56646      0.55775      0.64469    173.62500      0.34619      0.52686     10.27344      0.24450      0.01794      0.23235      2.35352      2.29191      0.25104
   1837.50000     74.37500      0.58454      0.58356      0.55724    174.50000      0.53320      0.63428     10.39844      0.25432      0.01491      0.25348      2.48047      2.27511      0.27232
   1838.00000     91.50000      0.60235      0.65401      0.56770    175.37500      0.80029      0.83105     10.59375      0.25136      0.02948      0.28677      2.65820      2.28017      0.31472
   1838.50000    105.87500      0.62312      0.72421      0.64414    176.62500      0.72021      0.77734     11.06250      0.24976      0.06642      0.33216      2.88672      2.28291      0.33788
   1839.00000    112.68750      0.66595      0.76629      0.80630    177.50000      0.80029      0.88477     11.52344      0.25694      0.05607      0.35475      2.99023      2.27062      0.34359
   1839.50000    108.56250      0.75661      0.83557      0.90448    178.00000      0.68018      0.79541     11.63281      0.25341      0.04408      0.33720      2.80469      2.27667      0.32278
   1840.00000    109.56250      0.90777      0.96595      0.96804    177.87500      0.65332      0.77734     11.69531      0.20266      0.05089      0.29690      2.70703      2.36345      0.29649
   1840.50000     96.87500      1.10383      1.12984      0.98942    177.50000      1.08008      1.04590     11.48438      0.17275      0.03804      0.24719      2.49414      2.41459      0.25250
   1841.00000     90.00000      1.28191      1.29235      1.15321    176.75000      1.50781      1.20605     11.26563      0.16495      0.00023      0.19823      2.57031      2.42794      0.21832
   1841.50000     81.37500      1.39049      1.38509      1.39151    176.75000      2.30859      1.52930     11.13281      0.14737      0.00041      0.19515      2.59375      2.45800      0.19795
   1842.00000     84.31250      1.47060      1.40462      1.71857    176.75000      1.82813      1.81543     11.28906      0.13249      0.00217      0.20159      2.70117      2.48344      0.20976
   1842.50000     85.43750      1.52764      1.39619      1.58730    177.00000      1.01367      0.99219     11.54688      0.13230      0.00062      0.22410      2.73633      2.48377      0.21696
   1843.00000     84.00000      1.58762      1.41294      1.30898    177.12500      1.36035      0.99219     11.55469      0.14339     -0.00332      0.24458      2.80469      2.46480      0.23103
   1843.50000     79.93750      1.63498      1.45950      1.19822    177.50000      1.21387      1.13477     11.57813      0.14666     -0.00355      0.24370      2.73047      2.45922      0.24392
   1844.00000     77.18750      1.65308      1.48805      1.31524    177.75000      2.05469      1.74316     11.66406      0.14300     -0.00245      0.23826      2.70117      2.46546      0.23909
   1844.50000     78.50000      1.65339      1.49804      1.40151    178.37500      0.93359      1.17090     11.71875      0.13667     -0.00409      0.22023      2.61914      2.47630      0.22872
   1845.00000     84.12500      1.67547      1.53092      1.48625    179.12500      0.86719      1.06348     11.73438      0.13462     -0.00581      0.22829      2.73242      2.47980      0.21276
   1845.50000     87.81250      1.70807      1.59689      1.57736    179.37500      1.49414      1.47461     11.52344      0.13075     -0.00824      0.22613      2.76563      2.48641      0.22127
   1846.00000     82.62500      1.70164      1.62338      1.69877    179.75000      1.41406      1.49316     11.48438      0.12312     -0.00627      0.21733      2.82422      2.49946      0.21646
   1846.50000     82.31250      1.64804      1.59611      1.76420    179.75000      2.24023      1.69043     11.30469      0.12233     -0.00685      0.19227      2.73047      2.50082      0.21082
   1847.00000     80.00000      1.56848      1.52146      1.76060    179.25000      2.28125      1.83301     11.27344      0.12802     -0.01152      0.17760      2.60547      2.49108      0.19069
   1847.50000     82.68750      1.50118      1.40867      1.68223    179.12500      2.73438      1.77930     11.27344      0.13088     -0.01085      0.17008      2.68164      2.48619      0.18418
   1848.00000     79.25000      1.45969      1.28960      1.39698    178.87500      1.54688      1.17090     11.27344      0.13603     -0.00419      0.17495      2.62695      2.47739      0.18092
   1848.50000     79.25000      1.41710      1.23558      1.15233    179.00000      1.30762      0.99219     11.26563      0.16242     -0.00894      0.18851      2.63086      2.43227      0.17743
   1849.00000     74.12500      1.37300      1.26667      1.01893    179.37500      1.30762      0.88477     11.22656      0.18091     -0.01171      0.20395      2.52734      2.40064      0.18381
   1849.50000     75.12500      1.30455      1.29789      1.10758    179.50000      1.86816      1.29590     11.27344      0.17762     -0.00674      0.19737      2.51172      2.40626      0.19622
   1850.00000     72.31250      1.23807      1.27736      1.28889    180.12500      2.06641      1.63574     11.13281      0.15843     -0.00320      0.19026      2.47461      2.43908      0.19899
   1850.50000     79.68750      1.21040      1.21199      1.39730    180.37500      2.69531      1.67188     11.16406      0.15220      0.00067      0.20722      2.51563      2.44973      0.20830
   1851.00000     91.68750      1.23270      1.17069      1.28834    180.62500      1.12012      1.18848     11.37500      0.15390      0.00354      0.24108      2.72461      2.44684      0.23288
   1851.50000    100.00000      1.27057      1.19871      1.17312    180.75000      1.09375      1.04590     11.53906      0.15837      0.00354      0.26990      2.94531      2.43919      0.25393
   1852.00000    100.37500      1.29214      1.25745      1.16029    180.87500      1.38770      1.29590     11.57813      0.14629      0.00397      0.24053      2.88672      2.45985      0.26065
   1852.50000     93.62500      1.29883      1.30768      1.23116    181.25000      1.45410      1.33105     11.47656      0.13271      0.00329      0.23933      2.74023      2.48306      0.23121
   1853.00000     94.43750      1.31199      1.29373      1.31182    181.37500      2.60156      1.54688     11.38281      0.11999      0.00134      0.23281      2.79883      2.50481      0.23998
   1853.50000     96.62500      1.34532      1.27871      1.29719    181.62500      1.46777      1.20605     11.47656      0.12194      0.00136      0.25757      3.05273      2.50147      0.24615
   1854.00000     97.18750      1.41099      1.32915      1.25103    182.00000      1.53418      1.11719     11.56250      0.13190     -0.00059      0.26947      3.21289      2.48446      0.25426
   1854.50000     93.18750      1.46734      1.42385      1.23822    182.50000      1.85449      1.34961     11.57813      0.13695     -0.00051      0.24232      2.92773      2.47582      0.25076
   1855.00000     91.00000      1.47128      1.51700      1.34449    182.87500      1.56055      1.31445     11.51563      0.13201      0.00384      0.22331      2.73242      2.48426      0.22339
   1855.50000     82.56250      1.44180      1.52783      1.49840    183.37500      2.46875      1.61816     11.40625      0.11514      0.00753      0.20506      2.65820      2.51312      0.22348
   1856.00000     78.81250      1.41448      1.42509      1.54868    184.00000      2.05469      1.58301     11.47656      0.11185      0.00779      0.23407      2.74219      2.51873      0.22707
   1856.50000     80.43750      1.39877      1.33334      1.42597    185.25000      1.70801      1.45703     11.67188      0.11674      0.00530      0.26505      2.86133      2.51037      0.25795
   1857.00000     92.18750      1.38400      1.24707      1.24408    185.62500      1.74805      1.29590     11.71875      0.13352     -0.00085      0.28024      2.82422      2.48168      0.27948
   1857.50000     95.62500      1.37114      1.23432      1.16185    186.25000      1.40039      1.18848     11.71875      0.14243      0.00170      0.27874      2.76758      2.46645      0.28462
   1858.00000     96.31250      1.29991      1.29235      1.16007    187.12500      1.57422      1.17090     11.71875      0.14786      0.00093      0.24441      2.54297      2.45716      0.26878
   1858.50000     91.43750      1.23537      1.31316      1.19420    187.75000      1.54785      1.24219     11.48438      0.15266      0.00034      0.22261      2.59180      2.44895      0.23939
   1859.00000     88.68750      1.21074      1.26933      1.23569    188.62500      2.08008      1.40332     11.42188      0.15048      0.01105      0.22993      2.70898      2.45269      0.23712
   1859.50000     88.00000      1.21044      1.22306      1.18276    189.00000      1.37402      1.22461     11.55469      0.15207      0.01460      0.25232      2.91602      2.44996      0.25060
   1860.00000     86.75000      1.22476      1.24450      1.15475    189.50000      1.00000      1.02734     11.57813      0.16064      0.00930      0.28511      2.98242      2.43531      0.26001
   1860.50000    101.00000      1.24456      1.28278      1.17244    189.75000      1.37402      1.24219     11.58594      0.15149      0.01392      0.28862      2.93945      2.45095      0.26932
   1861.00000    101.68750      1.23849      1.28414      1.19799    190.12500      1.33398      1.24219     11.63281      0.14418      0.01551      0.26636      2.73242      2.46344      0.26601
   1861.50000     98.87500      1.22295      1.28414      1.21483    190.00000      1.29395      1.09863     11.70313      0.14223      0.01118      0.23607      2.60938      2.46679      0.25168
   1862.00000     83.43750      1.19909      1.27066      1.22097    189.87500      1.25391      1.22461     11.60938      0.14185      0.00998      0.22222      2.75195      2.46744      0.23959
   1862.50000     82.93750      1.17972      1.19277      1.22245    190.12500      1.89453      1.33203     11.57813      0.13729      0.01160      0.24848      2.89648      2.47524      0.24963
   1863.00000     87.18750      1.17100      1.10476      1.15475    190.62500      1.45410      1.18848     11.57813      0.13938      0.00882      0.28685      3.03516      2.47166      0.27982
   1863.50000     91.12500      1.18622      1.07876      1.04953    191.12500      1.54688      1.06348     11.57813      0.15078      0.01209      0.31209      2.91992      2.45216      0.29699
   1864.00000     91.62500      1.20036      1.12984      0.99283    191.00000      1.34668      0.93848     11.57813      0.16768      0.01205      0.28442      2.78906      2.42327      0.28959
   1864.50000     85.43750      1.20051      1.18105      1.00388    190.62500      1.57422      1.02734     11.36719      0.17691      0.00973      0.23505      2.69727      2.40748      0.24181
   1865.00000     85.62500      1.18820      1.18105      1.14296    190.37500      2.20117      1.52832     11.27344      0.16571      0.01459      0.18639      2.64063      2.42663      0.21915
   1865.50000     82.81250      1.17307      1.16614      1.22741    190.00000      1.72070      1.36816     11.31250      0.15630      0.01453      0.19775      2.75586      2.44273      0.21224
   1866.00000     89.50000      1.15124      1.15269      1.27021    190.25000      1.78809      1.38574     11.40625      0.14898      0.01125      0.23413      2.80078      2.45524      0.23089
   1866.50000     92.62500      1.17458      1.10476      1.26252    190.25000      1.53418      1.31445     11.53125      0.15312      0.00613      0.25848      2.61914      2.44817      0.24201
   1867.00000     91.81250      1.19176      1.07778      1.11247    190.12500      1.30762      1.24219     11.57813      0.16110      0.00729      0.24745      2.58594      2.43452      0.25088
   1867.50000     93.12500      1.17557      1.11197      1.02342    190.87500      0.73340      0.84912     11.58594      0.16742      0.00698      0.22761      2.59180      2.42371      0.25043
   1868.00000     92.81250      1.13003      1.10069      1.05983    191.50000      1.56152      1.11719     11.71875      0.16472      0.01178      0.24496      2.82422      2.42833      0.26603
   1868.50000    101.81250      1.08006      1.05576      1.06675    192.12500      1.21387      1.11719     11.87500      0.15382      0.02112      0.29003      3.08203      2.44696      0.30432
   1869.00000     99.50000      1.02364      0.99789      1.07147    192.75000      0.93359      0.83105     11.97656      0.14833      0.04365      0.32357      3.15625      2.45635      0.33378
   1869.50000    102.87500      1.00194      0.97074      0.96913    193.37500      0.85352      0.84912     12.10156      0.15945      0.04319      0.33115      3.32031      2.43734      0.32858
   1870.00000     97.50000      1.01213      0.96675      0.96020    193.12500      1.18750      1.04590     12.17188      0.16656      0.03774      0.36482      3.24414      2.42519      0.31981
   1870.50000    102.50000      1.02703      0.97315      0.89936    192.75000      1.06641      0.83105     12.02344      0.17255      0.04166      0.35369      3.03125      2.41494      0.34084
   1871.00000     98.37500      1.01618      1.03911      0.89023    191.37500      0.82715      0.79541     11.92188      0.18303      0.02877      0.30980      2.76172      2.39701      0.29778
   1871.50000     99.37500      1.00547      1.08962      0.96219    189.87500      1.72070      1.33203     11.46094      0.19152      0.00822      0.22595      2.51563      2.38250      0.24181
   1872.00000     86.75000      0.98816      1.05109      1.10657    188.37500      1.45410      1.11719     11.43750      0.16910      0.00611      0.18897      2.45898      2.42084      0.20839
   1872.50000     77.00000      0.96862      1.00298      1.14124    187.12500      1.52051      0.93848     11.42969      0.15033      0.00527      0.17608      2.63477      2.45293      0.21491
   1873.00000     69.62500      0.96899      0.96595      1.13015    186.87500      1.80078      1.08105     11.52344      0.15655      0.00060      0.22024      2.60938      2.44230      0.23062
   1873.50000     78.87500      0.99616      0.92113      1.04807    187.12500      1.60059      1.00977     11.60938      0.22696      0.00798      0.28287      2.39453      2.32189      0.28584
   1874.00000     87.56250      1.01977      0.89842      0.99758    187.87500      1.05371      0.81299     12.52344      0.35316      0.01240      0.34942      2.31445      2.10610      0.32892
   1874.50000     96.81250      1.04549      0.94647      0.89869    188.62500      0.65332      0.65234     13.04688      0.41577      0.04134      0.37639      2.23242      1.99903      0.35350
   1875.00000    102.25000      1.07103      1.07002      0.91640    189.62500      0.57324      0.59863     12.75000      0.40197      0.05563      0.32786      2.46680      2.02263      0.33804
   1875.50000    110.56250      1.08784      1.17989      0.90366    190.12500      0.58691      0.61621     12.27344      0.30403      0.07331      0.29132      2.53516      2.19010      0.27922
   1876.00000    106.00000      1.08569      1.21566      1.09041    191.12500      1.29395      0.99219     11.87500      0.19033      0.07376      0.25544      2.76367      2.38454      0.27202
   1876.50000    105.25000      1.12687      1.21443      1.23016    192.00000      2.05469      1.11719     11.89063      0.14773      0.05288      0.28938      2.95117      2.45738      0.27378
   1877.00000     96.00000      1.20225      1.23180      1.20707    192.87500      1.33398      1.09863     12.01563      0.14914      0.06052      0.29454      2.93164      2.45497      0.31477
   1877.50000     91.81250      1.27611      1.27199      1.17976    193.00000      1.56152      1.22461     12.01563      0.16245      0.06410      0.28625      2.89453      2.43221      0.31045
   1878.00000     88.37500      1.32673      1.30207      1.22121    192.87500      1.76172      1.29590     12.00000      0.16598      0.07025      0.24419      2.79297      2.42617      0.28457
   1878.50000     94.93750      1.33734      1.30980      1.26861    191.25000      1.77441      1.17090     11.93750      0.14504      0.08811      0.23511      2.73828      2.46197      0.25134
   1879.00000    106.12500      1.31292      1.30768      1.32853    190.87500      1.57422      1.17090     12.10938      0.13077      0.10868      0.21634      2.77148      2.48639      0.25385
   1879.50000    108.18750      1.27020      1.26402      1.32417    190.62500      0.47998      0.97412     13.10156      0.15445      0.09749      0.24403      2.84180      2.44590      0.24431
   1880.00000    105.56250      1.22316      1.18923      1.26542    189.25000      0.35986      0.70605     13.98438      0.17834      0.11329      0.31211      2.77148      2.40503      0.27977
   1880.50000    102.37500      1.19303      1.12771      1.09139    188.87500      0.33301      0.58057     14.02344      0.22761      0.13153      0.36713      2.69531      2.32079      0.32204
   1881.00000    100.68750      1.16481      1.11509      0.98942    188.50000      0.57324      0.61621     13.85156      0.26606      0.12815      0.37375      2.70703      2.25504      0.35544
   1881.50000     98.68750      1.13128      1.12453      0.97965    188.37500      0.69336      0.68799     13.58594      0.28153      0.11675      0.33934      2.88867      2.22858      0.36687
   1882.00000     93.62500      1.09988      1.11301      0.99726    188.62500      0.82666      0.74170     13.18750      0.26486      0.12374      0.33225      2.83789      2.25708      0.35140
   1882.50000     93.50000      1.08606      1.08862      1.01025    188.75000      0.68018      0.84912     13.13281      0.27941      0.11600      0.32341      2.63281      2.23221      0.35044
   1883.00000     91.43750      1.10066      1.09362      1.00555    186.87500      0.77344      0.72363     13.57031      0.30519      0.07472      0.33584      2.51367      2.18813      0.32038
   1883.50000     93.00000      1.13347      1.13305      1.00857    186.25000      0.81348      0.65234     14.17969      0.29523      0.09172      0.33038      2.46680      2.20515      0.31650
   1884.00000     92.43750      1.17512      1.19159      1.05946    186.62500      0.76025      0.65234     13.69531      0.25369      0.09819      0.34297      2.58203      2.27618      0.30975
   1884.50000     90.81250      1.21295      1.24322      1.09654    185.62500      0.57324      0.61670     12.89844      0.24947      0.04890      0.31693      2.62891      2.28341      0.31042
   1885.00000     86.43750      1.24252      1.27467      1.17838    186.12500      0.60010      0.72363     12.53125      0.20046      0.02554      0.28836      3.00000      2.36722      0.29554
   1885.50000     83.00000      1.26960      1.29098      1.25388    185.62500      0.68018      0.86719     12.27344      0.14906      0.03904      0.28469      3.02539      2.45511      0.28253
   1886.00000     81.00000      1.28379      1.28278      1.29164    185.75000      0.93359      0.93848     12.17188      0.14861      0.04205      0.27448      2.99805      2.45588      0.29159
   1886.50000     88.75000      1.28033      1.26402      1.28506    185.62500      1.05371      1.06348     12.17188      0.17664      0.02957      0.29226      3.00391      2.40794      0.29259
   1887.00000     85.87500      1.24172      1.24707      1.22072    184.87500      1.25391      1.06348     12.27344      0.18215      0.07007      0.29886      2.83984      2.39853      0.30254
   1887.50000     91.00000      1.19719      1.19752      1.17449    184.25000      1.70801      1.13477     12.32813      0.18587      0.13101      0.32766      2.43164      2.39217      0.29320
   1888.00000     86.50000      1.14831      1.15491      1.16207    183.37500      1.09375      1.11719     12.24219      0.25357      0.13042      0.32244      2.18359      2.27640      0.28896
   1888.50000     88.43750      1.12534      1.11822      1.03604    180.62500      0.62695      0.75928     12.01563      0.30064      0.08566      0.28061      2.05469      2.19590      0.26172
   1889.00000     85.43750      1.13223      1.08565      0.98959    179.50000      1.02734      0.88477     11.34375      0.27479      0.08813      0.23085      2.29297      2.24010      0.24968
   1889.50000     82.75000      1.14299      1.08962      0.98251    179.37500      1.76074      1.13477     11.10938      0.21007      0.09451      0.21427      2.44922      2.35077      0.24010
   1890.00000     84.75000      1.13724      1.14607      1.22072    178.50000      1.41406      1.25977     11.26563      0.19415      0.03149      0.22859      2.72070      2.37800      0.24313
   1890.50000     90.12500      1.13431      1.19752      1.33263    180.00000      1.37402      1.06348     11.42969      0.17696      0.00967      0.24185      3.01563      2.40739      0.24928
   1891.00000     99.00000      1.14003      1.21935      1.44195    180.87500      1.86816      1.33203     11.57813      0.14088      0.01021      0.26852      3.18164      2.46909      0.26287
   1891.50000     99.87500      1.18408      1.22182      1.39472    180.00000      1.88184      1.36816     11.57813      0.12970      0.00953      0.29568      3.18945      2.48822      0.29138
   1892.00000     98.93750      1.25550      1.22804      1.31267    179.87500      1.70703      1.24219     11.60156      0.13932     -0.01153      0.33692      3.22852      2.47177      0.32009
   1892.50000     98.25000      1.32234      1.24066      1.21508    179.75000      1.44043      1.24219     11.60156      0.14134     -0.01146      0.34679      3.35352      2.46831      0.35500
   1893.00000    103.50000      1.34937      1.27871      1.14948    179.00000      1.61426      1.22461     11.57813      0.14236     -0.01022      0.34279      3.31250      2.46657      0.34511
   1893.50000    114.93750      1.32071      1.30768      1.18160    178.00000      1.56055      1.11719     11.64063      0.14376     -0.00385      0.33343      3.04297      2.46416      0.31520
   1894.00000    118.43750      1.22546      1.31050      1.22716    175.87500      1.34668      1.11719     11.61719      0.16354      0.00249      0.30086      2.70898      2.43035      0.28234
   1894.50000    108.68750      1.10151      1.25614      1.42194    173.62500      0.76025      0.97412     11.35938      0.17603      0.00468      0.24679      2.57617      2.40899      0.24432
   1895.00000     90.31250      1.03836      1.09563      1.48771    171.37500      2.28125      1.45703     10.69531      0.17164      0.01111      0.19122      2.43164      2.41649      0.20594
   1895.50000     70.75000      1.01657      0.94647      1.23216    169.25000      1.32031      1.54688     10.53125      0.15897      0.02640      0.17626      2.45703      2.43816      0.18909
   1896.00000     65.31250      1.00690      0.89222      0.90705    168.25000      0.45313      0.52686     10.53125      0.17066      0.02255      0.17666      2.26563      2.41818      0.19709
   1896.50000     64.62500      1.01968      0.89912      0.82298    168.00000      0.77344      0.74170     10.71875      0.19774      0.00789      0.19396      2.52344      2.37186      0.21020
   1897.00000     75.00000      1.02754      0.92478      0.87718    168.87500      1.13379      0.93848     10.94531      0.18693      0.01055      0.19390      2.72852      2.39035      0.23359
   1897.50000     93.43750      1.01428      0.98290      1.04862    169.62500      1.20020      0.99219     11.22656      0.16875      0.01126      0.21435      3.05469      2.42144      0.22289
   1898.00000     96.56250      1.02814      1.05389      1.19420    170.37500      1.90723      1.17090     11.30469      0.15411      0.00891      0.21879      2.97852      2.44647      0.22661
   1898.50000     99.37500      1.04806      1.12559      1.27854    171.12500      1.45410      1.27832     11.53906      0.15379      0.00803      0.23507      2.82813      2.44702      0.22163
   1899.00000     92.12500      1.04588      1.15158      1.38896    171.37500      1.34668      1.13477     11.71875      0.15518      0.00469      0.25656      2.84766      2.44464      0.23251
   1899.50000     94.93750      0.99569      1.12453      1.44782    171.37500      1.26660      1.20703     11.73438      0.14698      0.00709      0.25525      2.88281      2.45867      0.25334
   1900.00000     89.75000      0.92357      1.00726      1.52370    170.75000      1.12012      1.18848     11.62500      0.14444      0.00734      0.25942      2.61328      2.46302      0.25108
   1900.50000     83.68750      0.88666      0.84167      1.16972    169.62500      2.04102      1.45703     11.43750      0.17008      0.00723      0.24715      2.37891      2.41917      0.24622
   1901.00000     72.75000      0.83720      0.76526      0.76470    168.50000      0.56006      0.70605     11.46875      0.20824      0.00207      0.24494      2.18164      2.35392      0.23255
   1901.50000     69.81250      0.76016      0.76836      0.59449    167.50000      0.53320      0.47314     11.42969      0.22543     -0.00048      0.23198      2.28125      2.32451      0.23293
   1902.00000     67.93750      0.69277      0.75510      0.68938    166.62500      1.52051      0.99219     11.16406      0.21745     -0.00092      0.22040      2.40625      2.33816      0.22227
   1902.50000     78.06250      0.62733      0.70429      0.78536    166.25000      0.89355      0.72363     11.10938      0.19824      0.00406      0.22652      2.48438      2.37101      0.21454
   1903.00000     79.87500      0.58599      0.67015      0.85053    165.87500      1.53418      0.90283     11.12500      0.19701     -0.00005      0.23215      2.47656      2.37311      0.22741
   1903.50000     80.62500      0.60522      0.65132      0.81204    165.62500      1.96094      1.33203     11.12500      0.20669     -0.00414      0.23867      2.39453      2.35657      0.23699
   1904.00000     71.50000      0.65127      0.65209      0.74218    165.50000      0.76025      0.66992     11.12500      0.20938     -0.00074      0.23318      2.41602      2.35195      0.24679
   1904.50000     71.93750      0.69794      0.68873      0.65024    165.62500      0.80029      0.61621     11.20313      0.21115     -0.00224      0.22071      2.39453      2.34893      0.24400
   1905.00000     73.43750      0.75931      0.76167      0.71010    166.37500      1.48047      0.88477     11.36719      0.20176     -0.00603      0.21711      2.57617      2.36500      0.22631
   1905.50000     85.56250      0.81970      0.85223      0.88385    167.75000      1.66797      1.08105     11.50781      0.17971     -0.00585      0.21497      2.70703      2.40269      0.22619
   1906.00000     92.00000      0.87003      0.93964      1.07951    169.00000      1.92090      1.18848     11.61719      0.15826     -0.00745      0.22175      2.93164      2.43938      0.23019
   1906.50000    101.43750      0.96321      1.02384      1.22072    169.75000      1.45410      1.20605     11.70313      0.14410     -0.01014      0.22569      3.09961      2.46358      0.22974
   1907.00000     98.93750      1.09522      1.10681      1.24280    170.50000      1.16016      1.33203     11.79688      0.14057     -0.00933      0.23873      2.96875      2.46963      0.22360
   1907.50000     97.93750      1.24394      1.18806      1.18577    171.00000      1.24023      1.17090     11.87500      0.14525     -0.00524      0.22530      2.79297      2.46162      0.22976
   1908.00000     84.25000      1.33525      1.29928      1.19989    171.12500      1.29395      1.04590     11.72656      0.14416     -0.00295      0.20941      2.77734      2.46348      0.21742
   1908.50000     84.81250      1.34101      1.35111      1.26994    171.75000      2.13477      1.38574     11.57813      0.14447      0.00561      0.20921      2.89453      2.46295      0.21353
   1909.00000     88.18750      1.31341      1.28278      1.34121    173.00000      1.72070      1.22461     11.70313      0.14455      0.05132      0.25594      2.86133      2.46281      0.23912
   1909.50000    101.12500      1.28153      1.17989      1.20037    174.37500      0.45313      0.92041     12.27344      0.21112      0.08093      0.31749      2.70898      2.34899      0.30084
   1910.00000    107.68750      1.25201      1.15158      1.05447    175.50000      0.58691      0.72363     12.60156      0.26967      0.08173      0.32987      2.76563      2.24887      0.35251
   1910.50000    103.43750      1.25042      1.16162      1.00907    176.37500      0.95996      0.88477     12.31250      0.26104      0.09566      0.34200      3.01758      2.26362      0.33053
   1911.00000    102.43750      1.23737      1.16501      1.02742    176.75000      1.16016      1.00977     12.31250      0.18661      0.13929      0.30941      3.25977      2.39089      0.32957
   1911.50000     99.50000      1.22373      1.17412      1.01876    176.37500      1.06641      0.97412     12.32031      0.13744      0.11156      0.29744      3.05469      2.47497      0.28320
   1912.00000    100.25000      1.24332      1.21935      1.08299    176.12500      1.13379      1.09863     12.31250      0.14666      0.05712      0.25650      2.95117      2.45922      0.25971
   1912.50000    102.00000      1.27196      1.26007      1.23292    175.50000      1.41406      1.26074     12.18750      0.13636      0.03563      0.25635      2.93750      2.47682      0.24335
   1913.00000    101.25000      1.28027      1.28278      1.34150    175.00000      1.44043      1.17090     12.17188      0.12605      0.02962      0.26274      2.92383      2.49445      0.25648
   1913.50000    104.56250      1.29927      1.28960      1.31754    174.75000      1.33398      1.27832     12.17188      0.13896      0.00454      0.27989      2.94336      2.47237      0.26126
   1914.00000     99.00000      1.27495      1.31530      1.30081    174.12500      1.02734      1.11719     12.04688      0.14173      0.00556      0.24991      3.07813      2.46764      0.25988
   1914.50000     93.31250      1.20691      1.30768      1.39472    173.62500      1.90723      1.40332     11.57031      0.14037      0.00648      0.23022      3.12109      2.46996      0.23340
   1915.00000     86.50000      1.17281      1.16275      1.48079    172.75000      2.65625      1.81543     11.27344      0.14091      0.01100      0.23156      2.78906      2.46904      0.22457
   1915.50000     83.50000      1.19393      1.04369      1.11699    172.00000      1.70801      1.45703     11.42188      0.16947      0.00627      0.23232      2.55078      2.42020      0.23448
   1916.00000     85.00000      1.20737      1.06237      0.87238    172.25000      1.17383      0.97412     11.42969      0.19742     -0.00347      0.22738      2.54102      2.37241      0.22884
   1916.50000     86.00000      1.22109      1.15048      0.85790    172.75000      2.06836      1.67188     11.57813      0.19625     -0.01090      0.19946      2.79297      2.37442      0.22140
   1917.00000     93.93750      1.19862      1.20955      1.14665    174.25000      1.69434      1.45703     11.57813      0.15993     -0.00510      0.20809      3.01953      2.43652      0.21492
   1917.50000     98.25000      1.16805      1.20592      1.37537    175.87500      2.06641      1.47461     11.57813      0.13382     -0.00285      0.21409      2.72266      2.48117      0.22895
   1918.00000    119.31250      1.21431      1.20592      1.34688    177.12500      2.05469      1.43945     11.63281      0.13569     -0.00645      0.24619      2.71289      2.47797      0.23239
   1918.50000    125.18750      1.30548      1.27871      1.22641    177.62500      1.40039      1.13477     11.69531      0.13763     -0.00536      0.25158      2.60547      2.47464      0.24950
   1919.00000    129.12500      1.34868      1.35431      1.31068    178.37500      1.94824      1.43945     11.66406      0.13005      0.00276      0.25509      2.87695      2.48761      0.25612
   1919.50000    110.06250      1.36063      1.34365      1.45478    179.37500      3.06836      1.86914     11.70313      0.11650      0.02332      0.25308      2.91992      2.51079      0.27176
   1920.00000    105.43750      1.34854      1.29235      1.41794    179.75000      1.68066      1.36719     11.78125      0.13596      0.04471      0.28892      2.93164      2.47752      0.28519
   1920.50000    100.12500      1.33045      1.25614      1.19680    179.87500      1.36035      1.04590     11.84375      0.16867      0.08923      0.32184      2.75391      2.42158      0.31207
   1921.00000    101.87500      1.29909      1.28006      1.03693    180.12500      0.58691      0.81299     12.15625      0.20516      0.09366      0.30936      2.73633      2.35917      0.31173
   1921.50000    100.00000      1.25497      1.30856      1.12301    180.25000      1.25391      0.99219     11.96094      0.19615      0.08727      0.28139      2.97461      2.37458      0.29244
   1922.00000     98.93750      1.20134      1.25224      1.20539    180.12500      1.82813      1.34961     11.72656      0.15843      0.09874      0.27138      3.23047      2.43909      0.29886
   1922.50000    102.12500      1.15678      1.16614      1.26781    180.37500      1.77441      1.26074     11.85938      0.15640      0.12937      0.30442      3.16797      2.44255      0.31077
   1923.00000     96.50000      1.13864      1.12137      1.12762    180.50000      0.96045      1.00977     12.60156      0.23403      0.13190      0.32544      2.93945      2.30980      0.32641
   1923.50000    100.93750      1.13808      1.12559      1.01654    180.62500      0.81348      0.83105     13.07813      0.26677      0.14870      0.31377      2.77148      2.25383      0.31829
   1924.00000    109.06250      1.12925      1.14717      1.00255    180.75000      0.64014      0.68799     13.07031      0.24623      0.15823      0.30329      2.89844      2.28895      0.29320
   1924.50000    116.75000      1.11725      1.13520      1.03110    180.75000      1.33398      1.00977     11.81250      0.16250      0.18714      0.28029      3.26953      2.43212      0.30468
   1925.00000    122.50000      1.11629      1.10990      1.09773    180.50000      1.52051      1.08105     11.75781      0.11666      0.15405      0.30460      3.32031      2.51052      0.28708
   1925.50000    120.68750      1.13764      1.11404      1.07109    180.25000      1.18750      1.02734     12.06250      0.15224      0.10841      0.31165      2.97266      2.44966      0.29898
   1926.00000    117.62500      1.18216      1.16501      1.04211    179.87500      1.04004      0.97412     12.32031      0.20596      0.08102      0.31284      2.73438      2.35781      0.28634
   1926.50000    110.06250      1.21124      1.25614      1.07376    179.75000      0.77344      0.95654     12.10156      0.21560      0.08277      0.26341      2.58203      2.34133      0.27080
   1927.00000     96.75000      1.21913      1.31851      1.20491    179.50000      1.41406      1.22461     11.59375      0.18889      0.07417      0.21084      2.73047      2.38700      0.23557
   1927.50000     97.93750      1.21584      1.30627      1.39569    179.62500      2.16211      1.36816     11.27344      0.12756      0.08656      0.21197      3.02930      2.49188      0.23187
   1928.00000     98.37500      1.22665      1.24450      1.40968    179.87500      2.04102      1.34961     11.37500      0.12525      0.06578      0.25225      3.23828      2.49582      0.25984
   1928.50000    105.43750      1.25107      1.19871      1.24254    180.37500      1.60059      1.08105     11.53125      0.16567      0.07547      0.28744      3.21484      2.42670      0.30171
   1929.00000    106.25000      1.28098      1.19752      1.08688    180.75000      0.86670      0.83105     11.82813      0.28951      0.07986      0.33169      2.98633      2.21494      0.31373
   1929.50000    104.50000      1.29069      1.22929      1.08512    181.00000      0.60010      0.77734     12.52344      0.33984      0.10723      0.33517      2.74023      2.12888      0.32318
   1930.00000    101.50000      1.27124      1.27333      1.10334    181.50000      1.02734      0.84912     12.20313      0.33137      0.11395      0.32481      2.63281      2.14335      0.31323
   1930.50000     98.00000      1.23530      1.31192      1.20251    182.00000      0.73340      0.93848     12.17969      0.23320      0.12113      0.28410      2.80469      2.31123      0.29216
   1931.00000    102.87500      1.21928      1.31050      1.27692    182.25000      1.20117      1.08105     11.83594      0.13286      0.12695      0.28031      3.07617      2.48281      0.28155
   1931.50000     98.87500      1.24061      1.27467      1.31524    182.37500      2.00000      1.43945     11.86719      0.11404      0.11379      0.29598      3.17383      2.51499      0.29261
   1932.00000    100.81250      1.29630      1.26667      1.18276    182.12500      1.33398      1.18848     12.04688      0.15174      0.06444      0.31744      3.20117      2.45052      0.30202
   1932.50000     97.25000      1.35835      1.32336      1.16768    181.50000      1.36035      1.11719     11.96094      0.15517      0.05627      0.30938      2.91992      2.44466      0.28927
   1933.00000    104.00000      1.39373      1.42759      1.21924    180.25000      1.32031      1.18848     11.52344      0.14169      0.06178      0.27105      2.72461      2.46772      0.25394
   1933.50000    102.75000      1.37267      1.50193      1.36082    178.50000      1.84082      1.27832     10.75000      0.16088      0.01917      0.20395      2.48047      2.43489      0.20685
   1934.00000     98.06250      1.34797      1.48154      1.63228    176.87500      2.74805      1.76172     10.50781      0.16196     -0.00029      0.14041      2.49609      2.43305      0.17839
   1934.50000     93.12500      1.33876      1.39619      1.77247    176.12500      3.12109      2.02930     10.51563      0.14978     -0.00636      0.15735      2.55273      2.45387      0.17172
   1935.00000     93.31250      1.36378      1.31050      1.55425    176.50000      1.92090      1.27832     10.64063      0.13974      0.00785      0.22593      2.74219      2.47104      0.20777
   1935.50000    100.56250      1.40004      1.27736      1.24793    177.75000      2.25391      1.11719     10.78125      0.14378      0.00468      0.27623      2.93750      2.46414      0.26150
   1936.00000    105.00000      1.39917      1.31797      1.05282    178.12500      1.33398      1.02832     10.90625      0.15641      0.00239      0.26046      2.80664      2.44253      0.25932
   1936.50000    106.68750      1.33051      1.38195      1.20780    178.12500      2.24023      1.40332     10.82813      0.13763      0.00700      0.20181      2.69531      2.47465      0.23019
   1937.00000    101.81250      1.23152      1.32012      1.42664    178.12500      2.13477      1.43945     10.85156      0.12182      0.01537      0.21216      2.65039      2.50169      0.22120
   1937.50000    105.56250      1.14709      1.21688      1.58896    179.00000      1.74707      1.29590     11.05469      0.12498      0.00401      0.25881      3.12109      2.49629      0.26552
   1938.00000    111.75000      1.11961      1.11822      1.29719    180.00000      1.61426      1.13477     11.24219      0.13265      0.02510      0.33545      3.45117      2.48316      0.30245
   1938.50000    115.87500      1.12722      1.07778      1.01262    180.87500      1.33398      1.02734     11.47656      0.16584      0.06361      0.34523      3.33008      2.42641      0.38277
   1939.00000    116.87500      1.13258      1.08367      0.90801    181.12500      1.29395      0.88477     11.71875      0.19050      0.07314      0.32131      3.08203      2.38425      0.34544
   1939.50000    113.25000      1.11902      1.11404      0.95580    181.12500      1.38672      1.08105     11.71875      0.20481      0.05649      0.29022      3.01953      2.35977      0.30472
   1940.00000    114.12500      1.09597      1.13198      1.06769    181.00000      1.62793      1.06348     11.78125      0.16049      0.07863      0.27943      3.32422      2.43556      0.30022
   1940.50000    110.18750      1.07832      1.13305      1.20084    181.25000      1.26660      1.20605     11.95313      0.14040      0.09196      0.29203      3.43945      2.46992      0.30573
   1941.00000    105.56250      1.07645      1.12878      1.25910    181.62500      1.33398      1.15234     12.16406      0.17777      0.05959      0.29962      3.44531      2.40601      0.31433
   1941.50000    102.56250      1.09304      1.12878      1.24076    181.75000      1.32031      1.20605     12.34375      0.19054      0.06622      0.32075      3.31445      2.38418      0.31542
   1942.00000    100.50000      1.11731      1.13091      1.20084    180.62500      1.02637      0.97412     12.63281      0.17839      0.11912      0.31435      3.20313      2.40496      0.33034
   1942.50000    102.68750      1.14241      1.12559      1.15696    180.37500      1.00000      0.92090     13.26563      0.21743      0.14133      0.31370      2.82617      2.33819      0.32387
   1943.00000    107.56250      1.16317      1.12665      1.06939    179.87500      0.70703      0.90283     13.49219      0.29978      0.11394      0.30725      2.61523      2.19737      0.30947
   1943.50000    105.75000      1.20427      1.15826      0.97632    179.50000      0.60010      0.67041     13.22656      0.33061      0.09954      0.30278      2.45703      2.14465      0.28434
   1944.00000    110.00000      1.25994      1.22182      0.96727    178.87500      0.92041      0.79541     12.14844      0.29876      0.08504      0.28984      2.88867      2.19912      0.26597
   1944.50000    101.93750      1.28932      1.31050      1.09021    179.12500      1.14648      1.04590     11.74219      0.21894      0.06257      0.26020      3.40039      2.33562      0.25879
   1945.00000     95.31250      1.31480      1.39959      1.50138    179.25000      2.56055      1.69043     11.57813      0.14384      0.04947      0.26564      3.35547      2.46403      0.24166
   1945.50000     84.31250      1.35892      1.42468      1.65598    179.87500      2.81445      2.06445     11.56250      0.12953      0.04237      0.25235      3.00000      2.48850      0.24852
   1946.00000     90.75000      1.36752      1.47641      1.64695    180.00000      1.04004      1.11719     11.64063      0.15832      0.02342      0.23697      2.80078      2.43928      0.23979
   1946.50000    107.37500      1.36612      1.47753      1.63449    179.50000      1.86719      1.45703     11.10156      0.17329      0.04606      0.22351      2.79688      2.41367      0.24018
   1947.00000    115.87500      1.38053      1.37533      1.65055    179.12500      3.89453      2.42188     11.12500      0.16004      0.09139      0.23944      2.88867      2.43633      0.25878
   1947.50000    110.00000      1.36314      1.28142      1.33117    178.75000      1.54785      1.25977     11.28125      0.17793      0.06790      0.27047      3.11523      2.40575      0.27542
   1948.00000    106.56250      1.33911      1.26402      1.06882    179.12500      1.36035      0.99219     11.39063      0.17207      0.04609      0.28346      3.41992      2.41575      0.28302
   1948.50000    104.62500      1.34850      1.29511      0.99791    179.25000      1.22656      0.99219     11.38281      0.13621      0.05388      0.28567      3.52539      2.47708      0.28001
   1949.00000    105.87500      1.32939      1.34551      1.08747    179.75000      2.00000      1.20703     11.27344      0.11118      0.06850      0.28540      3.16211      2.51989      0.27789
   1949.50000     95.87500      1.28947      1.39459      1.36513    180.37500      2.34766      1.61816     11.39063      0.12179      0.02659      0.26907      2.93359      2.50174      0.26642
   1950.00000     93.18750      1.29748      1.41376      1.63892    180.62500      2.57422      2.04688     11.42188      0.11532      0.02705      0.26524      2.91016      2.51280      0.24599
   1950.50000     93.62500      1.34794      1.39778      1.70212    180.12500      2.37500      1.63574     11.15625      0.09127      0.04546      0.25952      2.84570      2.55393      0.24761
   1951.00000     97.93750      1.40268      1.41724      1.49433    179.12500      2.38867      1.58203     11.12500      0.10500      0.04269      0.24914      2.63867      2.53044      0.23845
   1951.50000     90.75000      1.44047      1.47797      1.43340    177.75000      2.16016      1.51074     10.96094      0.14365      0.00179      0.21049      2.55469      2.46435      0.22656
   1952.00000     86.87500      1.44550      1.48154      1.51227    176.75000      2.21484      1.85059     10.91406      0.14711      0.00042      0.17591      2.61328      2.45845      0.20460
   1952.50000     81.06250      1.38204      1.42884      1.60712    176.50000      1.64063      1.22461     10.97656      0.13516      0.00374      0.16638      2.72656      2.47888      0.19439
   1953.00000     85.50000      1.29588      1.36934      1.54630    176.50000      2.49414      1.47461     10.97656      0.12635     -0.00193      0.16448      2.78125      2.49395      0.19420
   1953.50000     89.00000      1.23570      1.28550      1.46005    176.87500      1.82715      1.42188     10.97656      0.12493     -0.00489      0.21491      3.04102      2.49638      0.19926
   1954.00000    101.68750      1.22849      1.18806      1.32272    177.37500      2.12109      1.34961     11.07813      0.13440     -0.00492      0.23987      3.32617      2.48018      0.24678
   1954.50000    113.18750      1.23987      1.15048      1.04953    177.75000      1.32031      0.99219     11.16406      0.14582     -0.00868      0.29728      3.68555      2.46065      0.26020
   1955.00000    111.43750      1.26202      1.20471      0.99726    178.12500      1.38770      0.99219     11.27344      0.14345     -0.01024      0.28044      3.48242      2.46470      0.28822
   1955.50000    100.68750      1.29245      1.27736      1.12134    177.75000      1.94824      1.36816     11.27344      0.13529     -0.00450      0.30174      3.44141      2.47866      0.25734
   1956.00000     97.93750      1.32134      1.33060      1.25701    177.62500      1.78711      1.33203     11.27344      0.13794      0.00874      0.27654      3.07031      2.47412      0.26856
   1956.50000    101.12500      1.35301      1.42530      1.39119    177.75000      1.57422      1.29590     11.27344      0.14106      0.00947      0.25041      2.84766      2.46879      0.24296
   1957.00000    101.87500      1.43591      1.53331      1.55906    177.62500      3.13477      1.86816     10.96875      0.13818      0.00913      0.19570      2.69336      2.47371      0.21803
   1957.50000     91.81250      1.52569      1.59328      1.99399    177.25000      3.73633      2.01172     10.69531      0.10479      0.01331      0.17810      2.66797      2.53081      0.18729
   1958.00000     80.25000      1.61069      1.56423      1.87410    176.50000      2.33398      1.43945     10.67969      0.10261      0.01463      0.20519      2.66406      2.53454      0.18449
   1958.50000     81.50000      1.68978      1.58969      1.64248    175.62500      2.50781      1.51074     10.67969      0.10957     -0.00082      0.21153      2.54688      2.52263      0.19712
   1959.00000     78.37500      1.70388      1.65460      1.39023    174.12500      1.68066      1.27832     10.63281      0.11865     -0.00215      0.18132      2.50781      2.50710      0.19604
   1959.50000     78.87500      1.59966      1.64607      1.62789    174.00000      3.33594      2.11914     10.53125      0.10669      0.00360      0.14584      2.60547      2.52757      0.18549
   1960.00000     83.87500      1.47638      1.47686      1.72938    174.12500      2.58789      1.88672     10.62500      0.10610      0.01266      0.17726      2.74805      2.52858      0.19087
   1960.50000    102.00000      1.36402      1.32733      1.58107    175.50000      1.94824      1.42188     10.84375      0.12549      0.00807      0.23378      2.97852      2.49542      0.24008
   1961.00000    125.68750      1.28269      1.23685      1.23266    177.00000      1.66699      1.04590     11.18750      0.15089      0.01352      0.28388      3.05469      2.45197      0.29309
   1961.50000    135.50000      1.20420      1.18105      1.09218    178.75000      1.41406      1.00977     11.30469      0.15911      0.01767      0.27959      3.34180      2.43792      0.32404
   1962.00000    129.87500      1.12626      1.12137      1.06693    179.75000      1.34766      1.00977     11.55469      0.15836      0.01613      0.29000      3.44531      2.43920      0.29397
   1962.50000    120.12500      1.05318      1.06142      1.06001    179.87500      1.46777      1.00977     11.67969      0.14877      0.01137      0.30069      3.66992      2.45561      0.30742
   1963.00000    110.06250      1.01259      1.01505      1.03586    179.62500      1.13379      0.97412     11.71875      0.15024      0.01477      0.35664      3.44727      2.45309      0.32443
   1963.50000    116.12500      1.00592      0.99368      0.97162    179.37500      1.58789      0.99219     11.77344      0.17113      0.01869      0.38174      3.33984      2.41737      0.37390
   1964.00000    118.81250      1.02475      1.00812      0.93251    179.25000      1.20020      0.92090     11.96094      0.20608      0.00719      0.39047      3.13281      2.35760      0.37870
   1964.50000    116.87500      1.05644      1.07099      0.97053    179.25000      1.05371      0.97412     12.20313      0.21294      0.00626      0.34116      3.05859      2.34587      0.36251
   1965.00000    111.06250      1.10379      1.14170      1.08299    179.87500      1.24023      1.11719     12.17188      0.18565      0.00947      0.30030      3.07813      2.39254      0.31124
   1965.50000    101.62500      1.16012      1.20471      1.23292    180.62500      1.18750      1.26074     12.04688      0.14392      0.01149      0.27549      3.00391      2.46389      0.28711
   1966.00000     97.68750      1.21858      1.26933      1.32970    181.12500      1.49414      1.29590     11.96094      0.12966     -0.00457      0.27630      3.08789      2.48827      0.26835
   1966.50000     88.93750      1.29773      1.33170      1.39087    181.50000      2.05273      1.63672     11.87500      0.11982     -0.00546      0.29151      3.26563      2.50511      0.27085
   1967.00000     83.56250      1.37171      1.38195      1.39119    181.87500      1.74805      1.29688     11.89063      0.11822     -0.00678      0.27519      3.39258      2.50784      0.29088
   1967.50000     83.75000      1.38637      1.40442      1.40804    182.12500      2.08008      1.51074     11.87500      0.11301     -0.00584      0.27037      3.32031      2.51675      0.27694
   1968.00000     80.00000      1.37220      1.39141      1.42833    181.62500      1.76074      1.56445     11.96875      0.11774     -0.00353      0.25592      3.17383      2.50867      0.27982
   1968.50000     89.50000      1.34407      1.32318      1.45689    181.75000      1.72070      1.38574     11.87500      0.11961      0.00024      0.28582      3.33984      2.50547      0.27743
   1969.00000     95.25000      1.30579      1.26667      1.33117    181.87500      1.90820      1.42188     11.90625      0.12985      0.00231      0.31473      3.27148      2.48795      0.31431
   1969.50000    101.81250      1.26962      1.23180      1.21094    181.75000      1.40039      1.17090     12.01563      0.14468      0.01382      0.33705      3.21875      2.46260      0.33331
   1970.00000    101.12500      1.23398      1.21566      1.14469    181.37500      1.66797      1.20605     12.04688      0.15408      0.03185      0.32751      2.96289      2.44652      0.34344
   1970.50000     97.50000      1.18678      1.20111      1.11125    181.25000      2.09375      1.18848     12.12500      0.17585      0.02085      0.29854      3.16602      2.40930      0.32763
   1971.00000     95.87500      1.14274      1.17758      1.10962    181.12500      1.57422      1.24219     12.30469      0.15642      0.05092      0.28133      3.19922      2.44251      0.31325
   1971.50000     94.25000      1.14194      1.14498      1.10133    180.75000      1.30762      1.04590     12.42188      0.15493      0.08296      0.31530      3.15430      2.44507      0.30544
   1972.00000     92.00000      1.16688      1.14279      1.07356    180.50000      0.90674      0.99219     12.78906      0.21205      0.06663      0.31232      3.01953      2.34739      0.31034
   1972.50000     94.12500      1.20204      1.19514      1.03622    181.00000      0.62695      0.75928     12.75781      0.24221      0.04907      0.30235      2.94531      2.29581      0.27188
   1973.00000     96.25000      1.25626      1.27066      1.09693    180.87500      1.20020      0.97412     12.39844      0.21825      0.05685      0.26094      3.16602      2.33680      0.25941
   1973.50000     93.37500      1.30118      1.33006      1.26569    181.12500      1.92090      1.43945     12.33594      0.15122      0.05274      0.25549      3.12695      2.45141      0.24663
   1974.00000     89.75000      1.33421      1.38195      1.41695    181.00000      2.06836      1.49316     12.30469      0.12409      0.02276      0.26318      2.94727      2.49781      0.25160
   1974.50000     91.37500      1.38828      1.42800      1.48516    181.00000      2.05469      1.74316     12.34375      0.12651      0.00956      0.25273      2.81641      2.49366      0.26111
   1975.00000     92.18750      1.44103      1.46934      1.49915    180.50000      1.61426      1.61816     12.44531      0.13611      0.00874      0.26093      2.90625      2.47726      0.24956
   1975.50000     94.50000      1.47927      1.47553      1.52832    180.25000      1.86816      1.52832     12.53906      0.13913      0.00868      0.25463      3.20898      2.47209      0.26279
   1976.00000     87.62500      1.52855      1.45841      1.47142    179.62500      1.60059      1.63574     12.61719      0.12960      0.02613      0.25169      3.24414      2.48839      0.24734
   1976.50000     87.75000      1.56039      1.48221      1.40346    179.25000      1.98730      1.56445     12.53906      0.12549      0.02751      0.22647      3.09180      2.49542      0.23324
   1977.00000     91.50000      1.56373      1.52689      1.38040    179.12500      1.36133      1.36816     12.40625      0.12425      0.02101      0.22601      2.86328      2.49752      0.20850
   1977.50000    102.06250      1.56412      1.54027      1.46643    178.62500      3.09570      1.81543     12.10156      0.12314      0.02107      0.22483      2.82031      2.49944      0.21296
   1978.00000    110.68750      1.54442      1.55706      1.43749    177.87500      1.20020      1.34961     12.05469      0.12752      0.01988      0.21071      2.69336      2.49195      0.20223
   1978.50000    108.81250      1.50476      1.57799      1.38387    177.00000      2.20117      1.38574     11.75000      0.13743      0.00014      0.16996      2.77930      2.47499      0.17970
   1979.00000     97.62500      1.46449      1.54777      1.47465    175.75000      2.52148      1.83301     11.77344      0.11452      0.00493      0.14274      2.80469      2.51417      0.15630
   1979.50000     85.12500      1.39542      1.47066      1.56754    174.75000      2.82813      1.72559     11.85938      0.09316      0.00734      0.15348      2.81641      2.55070      0.15138
   1980.00000     80.00000      1.31786      1.36512      1.47970    173.50000      2.17383      1.58203     11.87500      0.10110      0.00016      0.16706      2.54883      2.53712      0.16538
   1980.50000     78.37500      1.26382      1.26933      1.31524    172.62500      1.46680      1.18848     11.89844      0.13482     -0.00524      0.17695      2.52930      2.47946      0.17653
   1981.00000     77.37500      1.21427      1.18806      1.13909    172.12500      1.18652      0.99219     12.01563      0.15333     -0.00203      0.18029      2.51172      2.44780      0.18181
   1981.50000     74.68750      1.15777      1.13736      1.07128    171.75000      1.29395      1.02734     12.00000      0.16880     -0.00728      0.19397      2.59961      2.42135      0.18404
   1982.00000     74.00000      1.10774      1.11094      1.03215    171.50000      1.44141      1.02734     11.96094      0.15771     -0.00532      0.19706      2.57227      2.44032      0.19072
   1982.50000     75.68750      1.05195      1.09362      1.07223    171.37500      1.82813      1.17090     11.78906      0.14766     -0.00315      0.18812      2.50781      2.45751      0.19015
   1983.00000     76.62500      1.02227      1.08170      1.08454    170.87500      2.05469      1.18848     11.71875      0.14624     -0.00787      0.16859      2.44336      2.45992      0.18443
   1983.50000     74.50000      1.01020      1.07002      1.22592    170.75000      2.02734      1.43945     11.69531      0.14928     -0.00825      0.16235      2.51367      2.45473      0.17987
   1984.00000     73.87500      1.03212      1.05016      1.23670    171.50000      2.02734      1.33203     11.67188      0.15939     -0.00328      0.18740      2.62695      2.43745      0.19780
   1984.50000     77.93750      1.09229      1.05295      1.15475    172.87500      1.18750      1.13477     11.89063      0.16822      0.00196      0.24746      2.95313      2.42235      0.24016
   1985.00000     88.93750      1.17835      1.10476      0.94623    173.87500      1.20020      1.04590     12.01563      0.17287      0.00120      0.30731      3.11523      2.41438      0.28467
   1985.50000     98.81250      1.25564      1.23180      0.96418    175.00000      1.00000      0.97412     12.08594      0.15801      0.00474      0.29904      3.28906      2.43980      0.29219
   1986.00000    101.50000      1.31332      1.38039      1.16274    175.37500      1.50781      1.38574     11.79688      0.12505      0.00919      0.24973      3.05469      2.49617      0.25024
   1986.50000     91.18750      1.33211      1.43807      1.63449    174.87500      3.05469      2.01172     11.71875      0.10233      0.00795      0.19956      2.79297      2.53501      0.21105
   1987.00000     88.18750      1.32451      1.41458      1.85969    174.00000      2.14648      2.06641     11.77344      0.09553      0.00020      0.19244      2.74023      2.54664      0.20014
   1987.50000     82.43750      1.30913      1.35657      1.67062    173.00000      1.46777      1.27832     11.81250      0.10256     -0.00022      0.20450      2.69141      2.53462      0.20314
   1988.00000     83.93750      1.29711      1.27333      1.38673    172.12500      2.30859      1.36719     11.75781      0.12290      0.00228      0.22396      2.69336      2.49984      0.21456
   1988.50000     80.00000      1.27137      1.18105      1.13759    171.50000      1.70703      1.36719     11.85938      0.15436     -0.00178      0.23782      2.58594      2.44604      0.22788
   1989.00000     80.18750      1.26064      1.11926      0.95354    170.12500      1.24023      0.95654     11.83594      0.17031     -0.00102      0.24188      2.48438      2.41876      0.22664
   1989.50000     81.50000      1.25901      1.12559      0.84318    169.62500      1.05371      0.84912     11.78906      0.16877      0.00056      0.22512      2.50000      2.42141      0.22310
   1990.00000     78.56250      1.24775      1.19991      0.87024    169.75000      1.14746      0.86719     11.67969      0.14965      0.00466      0.21092      2.58789      2.45410      0.20595
   1990.50000     77.18750      1.25112      1.28006      1.10233    170.37500      2.06641      1.26074     11.55469      0.13255      0.00716      0.19158      2.78125      2.48334      0.19325
   1991.00000     73.50000      1.27393      1.34831      1.39504    170.62500      1.90820      1.40332     11.50781      0.12100      0.01129      0.17231      2.63867      2.50309      0.17727
   1991.50000     72.37500      1.30997      1.41213      1.65416    171.12500      1.85449      1.38574     11.42188      0.11683      0.01396      0.14556      2.60547      2.51021      0.16506
   1992.00000     69.50000      1.38037      1.42488      1.79456    171.25000      2.93555      1.90430     11.42188      0.11268      0.01427      0.15176      2.61914      2.51731      0.15473
   1992.50000     70.93750      1.42659      1.39879      1.67293    171.12500      2.61523      1.68945     11.42188      0.11954      0.01432      0.15985      2.75391      2.50558      0.17107
   1993.00000     73.87500      1.43019      1.37417      1.48808    171.00000      2.41406      1.63672     11.48438      0.12649      0.01258      0.17874      2.73633      2.49370      0.17814
   1993.50000     70.00000      1.40943      1.32120      1.35170    171.12500      2.18750      1.47461     11.52344      0.14460      0.01036      0.17744      2.69922      2.46274      0.19202
   1994.00000     69.68750      1.36740      1.25614      1.28396    171.37500      2.20117      1.42188     11.58594      0.15773      0.00447      0.19227      2.75391      2.44028      0.20088
   1994.50000     75.31250      1.31042      1.20231      1.09021    171.87500      1.18750      0.99219     11.82813      0.16818      0.00051      0.20273      2.71875      2.42241      0.22050
   1995.00000     84.75000      1.26548      1.20351      1.00890    173.12500      1.13379      1.02734     11.85938      0.17799     -0.00654      0.22656      2.68555      2.40564      0.22406
   1995.50000     89.75000      1.23071      1.21935      1.08454    175.00000      1.92090      1.20703     11.89063      0.16983     -0.00637      0.23943      2.88281      2.41959      0.25091
   1996.00000     97.12500      1.17022      1.21566      1.21459    176.50000      1.18750      1.11719     12.01563      0.16701     -0.00844      0.27058      3.25977      2.42442      0.27918
   1996.50000    111.56250      1.11198      1.17989      1.26490    178.12500      2.02734      1.47461     12.15625      0.17537      0.01190      0.28334      3.51953      2.41012      0.32295
   1997.00000    118.75000      1.08296      1.11509      1.20108    179.12500      1.12012      1.11719     12.35938      0.23206      0.04438      0.32609      3.36133      2.31317      0.33634
   1997.50000    123.43750      1.05779      1.04553      1.05447    178.87500      1.06641      0.99219     12.70313      0.34814      0.05644      0.35144      3.14063      2.11469      0.35882
   1998.00000    121.43750      1.02704      1.00984      0.96510    179.00000      0.61328      0.75928     12.88281      0.39595      0.08359      0.37458      2.95313      2.03293      0.36618
   1998.50000    127.18750      0.98845      0.98951      0.93280    178.50000      0.62695      0.65234     13.17188      0.37487      0.12488      0.39691      2.83984      2.06898      0.36792
   1999.00000    125.06250      0.95318      0.96437      0.92297    177.75000      0.78711      0.74170     13.25781      0.31231      0.13667      0.38741      2.80273      2.17595      0.36159
   1999.50000    117.62500      0.89816      0.96121      0.90205    176.87500      0.47998      0.61621     13.06250      0.26707      0.11411      0.32504      2.62109      2.25331      0.32308
   2000.00000    101.12500      0.85249      0.95964      0.92509    175.37500      0.54639      0.65234     12.31250      0.23008      0.08175      0.24677      2.54492      2.31657      0.25849
   2000.50000     91.75000      0.83745      0.91392      1.07261    174.12500      1.09375      1.02734     12.17188      0.17081      0.06112      0.20420      2.62109      2.41791      0.23273
   2001.00000     94.18750      0.84482      0.86432      1.03110    173.87500      0.94727      0.88477     12.18750      0.15071      0.03470      0.24365      2.88672      2.45229      0.23474
   2001.50000    105.87500      0.88451      0.85665      0.95444    174.00000      1.09375      0.79541     12.34375      0.17003      0.01246      0.27333      3.08398      2.41925      0.27500
   2002.00000    109.68750      0.96168      0.89981      0.83296    173.75000      1.21387      1.00977     12.46875      0.17927      0.02958      0.31178      2.97461      2.40344      0.25823
   2002.50000    106.75000      1.03076      0.99873      0.81500    174.62500      1.02637      0.93848     12.34375      0.17036      0.06487      0.27658      2.80859      2.41869      0.25850
   2003.00000     96.93750      1.05976      1.14937      0.96112    174.62500      1.20020      0.99219     12.07813      0.16639      0.05636      0.22740      2.72461      2.42548      0.20926
   2003.50000     87.75000      1.08279      1.25876      1.39924    174.62500      2.56055      1.79688     11.67969      0.14339      0.05059      0.15487      2.86914      2.46481      0.18528
   2004.00000     85.87500      1.10909      1.24707      2.23498    175.12500      3.12305      2.90625     11.42188      0.10931      0.04080      0.15521      2.82227      2.52309      0.18069
   2004.50000    102.00000      1.15501      1.14607      1.89643    175.50000      1.34766      1.43945     11.50781      0.12656      0.01022      0.20055      2.96875      2.49359      0.21506
   2005.00000    119.25000      1.21174      1.11094      1.16768    175.87500      1.04004      1.08105     11.75000      0.15076     -0.01338      0.26815      3.15625      2.45220      0.25834
   2005.50000    128.75000      1.18323      1.15269      0.91543    175.87500      0.90674      0.81348     11.83594      0.15747     -0.01598      0.28312      3.51172      2.44073      0.29130
   2006.00000    118.43750      1.04049      1.12453      1.03622    176.00000      1.74707      1.17090     11.72656      0.14188     -0.01042      0.29951      3.45703      2.46739      0.27209
   2006.50000    108.06250      0.88213      0.96516      1.23822    174.37500      2.12109      1.43945     11.92969      0.14081     -0.00966      0.29821      3.24609      2.46922      0.29006
   2007.00000     89.93750      0.78213      0.80799      1.04481    172.50000      1.45410      1.17090     12.01563      0.15998     -0.01146      0.30801      2.83398      2.43644      0.30155
   2007.50000     78.75000      0.74394      0.72281      0.74072    170.75000      1.10742      0.75977     12.13281      0.19308     -0.00928      0.26867      2.61719      2.37984      0.29854
   2008.00000     68.12500      0.76073      0.70341      0.66162    169.25000      0.94727      0.70605     12.17188      0.22280     -0.00773      0.23875      2.47070      2.32901      0.24956
   2008.50000     74.43750      0.79654      0.73171      0.67042    169.12500      1.50781      0.90283     12.17188      0.23950     -0.00946      0.24288      2.60938      2.30045      0.21980
   2009.00000     84.37500      0.82072      0.81256      0.71278    170.50000      1.05371      0.77734     12.10156      0.22859     -0.00229      0.22949      2.67969      2.31912      0.22380
   2009.50000     91.37500      0.83605      0.94191      0.93136    171.62500      1.70801      1.25977     11.89063      0.19814      0.00046      0.20510      2.85938      2.37119      0.21809
   2010.00000     89.31250      0.86685      1.04645      1.35230    173.12500      3.53516      2.15430     11.74219      0.15939      0.00476      0.18114      2.94727      2.43745      0.20523
   2010.50000     90.18750      0.92963      1.08367      1.88168    173.37500      2.16016      1.88672     11.85938      0.12949      0.01085      0.20937      2.88867      2.48857      0.20248
   2011.00000     98.43750      1.03690      1.10272      1.65416    173.00000      0.94727      1.00977     12.00000      0.12726      0.01279      0.25019      2.84766      2.49238      0.21839
   2011.50000    102.12500      1.15330      1.12242      1.25753    172.37500      0.60010      0.81348     12.11719      0.14399      0.00894      0.24660      2.71094      2.46378      0.24108
   2012.00000    100.56250      1.24525      1.11301      1.06958    171.62500      0.54639      0.74170     12.07031      0.16493      0.00665      0.24684      2.76563      2.42797      0.23788
   2012.50000     97.06250      1.29724      1.11509      0.93874    171.50000      0.68018      0.75928     12.01563      0.18009      0.00132      0.22465      2.77539      2.40204      0.23621
   2013.00000    101.56250      1.30481      1.17989      0.88437    171.25000      0.60010      0.77734     12.02344      0.17650     -0.00122      0.21491      2.73633      2.40819      0.21298
   2013.50000     97.87500      1.27973      1.29373      1.00840    172.50000      1.34766      1.17090     11.87500      0.15329     -0.00287      0.18610      2.66992      2.44787      0.19308
   2014.00000     97.18750      1.25330      1.36436      1.43715    173.25000      2.30859      1.67188     11.87500      0.12262     -0.00160      0.17797      2.66797      2.50032      0.17879
   2014.50000    100.50000      1.23952      1.36646      1.91748    174.37500      2.81445      1.95801     11.90625      0.10743      0.00428      0.18876      2.76953      2.52630      0.19467
   2015.00000    107.25000      1.25597      1.31405      1.90780    176.00000      2.40039      1.68945     12.02344      0.11049      0.00910      0.22099      2.98438      2.52107      0.22864
   2015.50000    102.68750      1.27889      1.26007      1.58314    177.37500      1.97461      1.42188     12.18750      0.13368      0.01153      0.27966      3.20117      2.48141      0.27512
   2016.00000     98.06250      1.26963      1.17989      1.16274    178.37500      1.60059      1.25977     12.32031      0.14647      0.02311      0.33263      3.38281      2.45953      0.31718
   2016.50000    100.93750      1.21698      1.13520      0.94935    179.00000      1.22656      0.93848     12.28125      0.15638      0.02508      0.33416      3.30273      2.44258      0.34200
   2017.00000    114.31250      1.13875      1.10579      0.93280    179.25000      1.46680      1.04590     12.13281      0.15950      0.01374      0.30324      3.33398      2.43726      0.33291
   2017.50000    113.62500      1.04331      1.05576      1.01093    179.37500      1.74805      1.17090     12.01563      0.14757      0.01055      0.31010      3.42383      2.45765      0.31423
   2018.00000    116.75000      1.00328      1.00468      1.03409    179.12500      1.48047      1.00977     12.01563      0.14732      0.00168      0.34282      3.66406      2.45809      0.32435
   2018.50000    114.25000      1.00692      0.99368      0.92679    178.75000      1.33398      1.00977     12.01563      0.15000     -0.00511      0.33893      3.61719      2.45350      0.32520
   2019.00000    119.37500      1.02990      1.04923      0.90232    178.12500      1.14746      0.93848     11.94531      0.15590     -0.00757      0.26172      3.24219      2.44341      0.28832
   2019.50000    114.62500      1.04109      1.11613      1.06300    177.62500      1.26758      1.08105     11.75781      0.14773     -0.00077      0.20865      2.94531      2.45738      0.22108
   2020.00000    111.93750      1.04643      1.12137      1.33175    177.75000      2.80273      1.74316     11.63281      0.13675      0.00308      0.21358      2.91602      2.47616      0.21925
   2020.50000    113.81250      1.04746      1.09062      1.40281    177.50000      1.40039      1.31348     11.71875      0.13138      0.00278      0.27630      3.25195      2.48534      0.24521
   2021.00000    115.81250      1.07634      1.06619      1.17085    177.87500      1.73438      1.24219     11.82813      0.13681     -0.00205      0.32313      3.50586      2.47606      0.30566
   2021.50000    112.18750      1.11467      1.07681      1.01177    178.37500      1.38770      1.00977     11.88281      0.14392     -0.00599      0.32384      3.42188      2.46390      0.34445
   2022.00000    106.81250      1.13023      1.10272      0.99300    178.62500      1.49414      1.04590     11.88281      0.14617     -0.01046      0.32384      3.28906      2.46005      0.31844
   2022.50000    101.43750      1.13819      1.11404      1.05742    179.00000      1.48047      1.17090     11.96094      0.14345     -0.01380      0.29575      3.15820      2.46470      0.31245
   2023.00000    103.43750      1.16056      1.12771      1.08982    179.25000      1.72070      1.20605     12.00000      0.14090     -0.01114      0.30367      3.21094      2.46906      0.28416
   2023.50000    102.25000      1.18077      1.17412      1.09873    179.00000      1.48047      1.13477     12.01563      0.13744     -0.00738      0.25984      3.02344      2.47498      0.27978
   2024.00000    109.93750      1.19416      1.23558      1.16476    178.62500      1.40039      1.15332     11.88281      0.13912     -0.00705      0.23304      2.87305      2.47211      0.23471
   2024.50000    106.06250      1.18527      1.25745      1.36821    178.25000      2.10742      1.42188     11.87500      0.13691     -0.00628      0.20942      2.66797      2.47588      0.21726
   2025.00000    115.62500      1.14574      1.21199      1.45095    178.37500      1.94824      1.34961     11.88281      0.13952     -0.00469      0.22284      2.72656      2.47142      0.22855
   2025.50000    112.00000      1.09211      1.13953      1.38896    179.25000      1.92090      1.33203     12.01563      0.14106     -0.00504      0.24558      2.89063      2.46878      0.26884
   2026.00000    123.06250      1.06355      1.04923      1.15984    179.87500      1.65430      1.09863     12.13281      0.14839     -0.00835      0.30195      3.13672      2.45625      0.30307
   2026.50000    118.93750      1.03896      0.97800      0.96081    180.62500      1.28027      0.97412     12.25781      0.16341     -0.00860      0.34358      3.30859      2.43057      0.35505
   2027.00000    125.50000      1.01580      0.94724      0.80738    181.12500      1.06641      0.81299     12.36719      0.17626     -0.01246      0.36692      3.31445      2.40860      0.36510
   2027.50000    123.06250      0.97746      0.95417      0.78211    181.62500      1.13379      0.88477     12.46875      0.17950     -0.01367      0.34404      3.36133      2.40306      0.36093
   2028.00000    116.00000      0.93670      0.96437      0.89075    181.37500      1.32031      0.99219     12.46875      0.16682     -0.00908      0.31601      3.32813      2.42474      0.34375
   2028.50000    105.00000      0.89805      0.96121      1.03569    181.37500      1.50781      1.15332     12.54688      0.16496     -0.00033      0.35710      3.40625      2.42792      0.33912
   2029.00000    101.12500      0.88638      0.94342      1.04050    180.50000      1.29395      1.00977     12.69531      0.18798      0.01775      0.37800      3.09961      2.38855      0.39263
   2029.50000    109.25000      0.91581      0.93439      0.99332    179.75000      0.89355      0.79541     13.21875      0.23593      0.04147      0.37830      2.94336      2.30656      0.39039
   2030.00000    119.62500      0.94968      0.95031      0.94386    179.12500      0.35986      0.66992     14.43750      0.26502      0.03672      0.32565      2.83789      2.25682      0.37193
   2030.50000    118.56250      0.98795      0.96914      0.93395    178.12500      0.50635      0.58057     13.88281      0.25728      0.06552      0.39429      2.56055      2.27005      0.33606
   2031.00000    110.87500      1.06209      0.97476      0.93222    177.37500      0.93359      0.74170     13.70313      0.27930      0.07454      0.44908      2.32422      2.23239      0.38809
   2031.50000     98.31250      1.14826      1.06237      0.90529    176.62500      0.74658      0.52686     15.36719      0.33132      0.02348      0.41974      2.07617      2.14344      0.38199
   2032.00000     89.62500      1.19807      1.22804      0.95822    176.37500      0.66699      0.47314     13.92188      0.33001      0.00206      0.28745      2.37500      2.14568      0.29917
   2032.50000     77.25000      1.22244      1.33940      1.17769    176.37500      1.70801      1.24219     12.78125      0.24554      0.01270      0.21922      2.58398      2.29012      0.22697
   2033.00000     70.75000      1.20207      1.30962      1.48625    177.00000      2.21484      1.65430     12.88281      0.16542      0.01357      0.20187      2.56250      2.42712      0.22520
   2033.50000     63.68750      1.17670      1.23054      1.58855    177.12500      1.45410      1.22363     13.04688      0.14603      0.00124      0.23413      2.69336      2.46029      0.25032
   2034.00000     72.68750      1.19477      1.13628      1.45514    176.37500      1.97461      1.24219     13.15625      0.16673      0.00762      0.30741      2.65430      2.42489      0.31664
   2034.50000     75.93750      1.24177      1.02118      1.16588    175.87500      0.86719      0.93848     13.96094      0.27720      0.00859      0.40721      2.36719      2.23599      0.37501
   2035.00000     83.12500      1.30015      0.96357      0.91529    175.62500      0.61328      0.54492     14.92188      0.44195      0.00339      0.45584      2.12891      1.95427      0.42516
   2035.50000     82.12500      1.30614      1.07486      0.86712    175.62500      0.52002      0.41992     17.87500      0.48538      0.00263      0.35947      2.04102      1.87999      0.38457
   2036.00000     93.25000      1.20594      1.26007      0.98668    176.00000      0.58691      0.50879     14.47656      0.44260      0.01568      0.28635      2.66797      1.95315      0.32665
   2036.50000    103.56250      1.11008      1.19041      1.34868    176.37500      2.02734      1.54688     12.78125      0.28291      0.07913      0.30717      2.38867      2.22622      0.33086
   2037.00000    104.56250      1.07326      0.99873      1.31097    176.37500      2.38867      1.42188     13.24219      0.36809      0.05659      0.38623      2.13086      2.08056      0.40503
   2037.50000     93.06250      1.09706      0.95031      1.08844    175.75000      0.45313      0.49121     15.33594      0.48070      0.01617      0.43301      2.13672      1.88800      0.44143
   2038.00000     85.25000      1.14648      1.03548      0.92495    175.37500      0.42676      0.43750     15.96094      0.51715      0.03341      0.39060      2.47070      1.82567      0.42833
   2038.50000     82.56250      1.17395      1.07583      0.92495    175.50000      0.49316      0.43750     15.95313      0.49893      0.04751      0.39819      2.52734      1.85683      0.40267
   2039.00000     85.25000      1.11342      1.03911      1.08124    175.62500      0.45313      0.38379     17.50000      0.51119      0.02909      0.42101      2.33984      1.83586      0.41666
   2039.50000     89.43750      1.07480      0.99536      1.08903    175.37500      0.47998      0.47314     17.32813      0.51829      0.03100      0.46288      2.20117      1.82372      0.43179
   2040.00000     90.25000      1.16176      0.98785      0.98475    175.12500      0.33301      0.41943     15.55469      0.49267      0.03382      0.45280      2.36719      1.86754      0.43874
   2040.50000     88.56250      1.28662      1.07486      0.79194    175.37500      0.33301      0.36572     15.89844      0.44500      0.03880      0.38041      2.22070      1.94905      0.35799
   2041.00000     83.18750      1.35031      1.29373      0.91239    176.62500      0.58691      0.49121     15.99219      0.37349      0.03727      0.27666      2.41602      2.07134      0.25881
   2041.50000     84.43750      1.44702      1.54244      1.12384    177.87500      1.86719      1.22461     12.56250      0.29578      0.03183      0.21138      2.39453      2.20422      0.20864
   2042.00000     81.75000      1.48985      1.64061      1.49028    179.37500      3.40234      2.01172     12.56250      0.19827      0.01804      0.17603      2.54492      2.37096      0.19062
   2042.50000     75.43750      1.49998      1.65931      1.90660    180.62500      1.73340      1.72559     12.66406      0.13866      0.01341      0.17160      2.49609      2.47289      0.19043
   2043.00000     78.31250      1.59807      1.65074      2.19602    181.12500      2.86914      2.06445     12.61719      0.12444     -0.00170      0.19389      2.50586      2.49720      0.20395
   2043.50000     85.37500      1.75868      1.57146      1.98939    181.37500      2.19922      1.65332     12.73438      0.12888      0.00006      0.22663      2.65625      2.48961      0.23109
   2044.00000     94.12500      1.77149      1.52855      1.63582    181.50000      0.74658      0.95654     13.19531      0.14504      0.00058      0.25459      2.85352      2.46198      0.26668
   2044.50000     93.62500      1.70932      1.51583      1.33205    180.87500      1.77441      1.04590     12.93750      0.15966      0.00438      0.26474      2.87500      2.43698      0.26873
   2045.00000     91.43750      1.59048      1.48693      1.34959    181.62500      1.60059      1.31445     13.28906      0.16490      0.00389      0.25261      2.81836      2.42802      0.26096
   2045.50000     91.50000      1.43085      1.42780      1.34389    181.50000      1.21387      0.93799     12.99219      0.16397      0.00371      0.27204      2.83984      2.42960      0.25830
   2046.00000     93.12500      1.31926      1.33079      1.39827    182.12500      1.60059      1.24219     12.92188      0.16415      0.00189      0.28668      3.29883      2.42930      0.30475
   2046.50000     95.56250      1.28391      1.26667      1.26914    183.12500      1.58789      1.13477     12.91406      0.16803      0.02679      0.33678      3.31250      2.42267      0.33330
   2047.00000     99.31250      1.24847      1.24322      1.23367    183.62500      1.09375      0.97412     13.31250      0.19215      0.03350      0.34730      3.08984      2.38143      0.36579
   2047.50000    102.12500      1.23802      1.24194      1.12573    184.00000      0.72021      0.77734     13.30469      0.19759      0.04959      0.38062      2.75391      2.37213      0.34775
   2048.00000    106.56250      1.24155      1.24066      1.24000    183.87500      0.70703      0.68799     13.69531      0.18568      0.08362      0.38256      2.56836      2.39248      0.37467
   2048.50000    113.12500      1.23094      1.26402      1.32620    183.50000      0.60010      0.59863     14.04688      0.18049      0.11435      0.34719      2.53516      2.40135      0.36535
   2049.00000    115.62500      1.19864      1.30067      1.49249    183.50000      0.72021      0.65234     13.11719      0.21228      0.06562      0.32116      2.71484      2.34701      0.32797
   2049.50000    109.75000      1.20018      1.25354      1.41429    183.87500      1.81445      1.20605     12.79688      0.20037      0.05150      0.30964      3.03516      2.36737      0.32508
   2050.00000     97.00000      1.20339      1.19159      1.29385    184.37500      1.45410      1.33203     12.79688      0.15600      0.05389      0.32468      3.36328      2.44325      0.33754
   2050.50000     93.06250      1.19367      1.19159      1.12531    184.87500      1.24023      0.90283     12.79688      0.15199      0.01958      0.31725      3.39453      2.45009      0.34272
   2051.00000     94.06250      1.19392      1.22182      1.20132    184.00000      1.25391      1.09863     12.83594      0.16478      0.00810      0.32781      2.88281      2.42823      0.32244
   2051.50000     98.06250      1.21335      1.18221      1.30249    183.50000      1.65430      1.15332     12.89844      0.19608      0.02631      0.35917      2.63281      2.37471      0.35078
   2052.00000     99.50000      1.21243      1.15602      1.55906    182.37500      0.35938      0.59863     14.00000      0.24378      0.03554      0.37165      2.49609      2.29314      0.37941
   2052.50000    100.93750      1.25276      1.17873      1.39376    181.37500      0.90674      0.63428     13.38281      0.25040      0.06256      0.37037      2.67383      2.28182      0.38053
   2053.00000    101.12500      1.32138      1.23939      1.28315    181.25000      0.43994      0.68799     14.17969      0.22389      0.09274      0.36011      2.76172      2.32715      0.35388
   2053.50000     97.25000      1.34884      1.32915      1.32620    181.62500      0.46680      0.59863     14.35156      0.18735      0.08778      0.33456      3.09766      2.38963      0.33968
   2054.00000     92.37500      1.30367      1.35619      1.56107    182.00000      1.68066      1.24219     12.97656      0.16834      0.06403      0.35021      2.98828      2.42214      0.35595
   2054.50000     85.31250      1.32467      1.24194      1.49840    181.50000      1.65430      1.38574     12.85156      0.22299      0.04810      0.38812      2.59766      2.32869      0.42520
   2055.00000     80.18750      1.43648      1.14279      2.35970    181.50000      1.60059      0.99219     14.24219      0.43186      0.00565      0.44249      2.29102      1.97153      0.45166
   2055.50000     77.87500      1.59493      1.24836      2.09556    180.75000      0.41309      0.47314     17.21875      0.50284     -0.00254      0.39850      2.05859      1.85014      0.42776
   2056.00000     89.37500      1.76521      1.66154      1.87759    181.00000      0.37305      0.41992     17.62500      0.49555      0.00060      0.36762      2.60742      1.86261      0.34689
   2056.50000     96.25000      2.03105      1.89002      1.49729    181.87500      1.25391      1.02734     12.99219      0.36685      0.04230      0.41096      2.72852      2.08268      0.35746
   2057.00000    104.81250      2.24907      1.98481      1.88696    182.87500      1.44043      0.99219     13.28125      0.34424      0.04105      0.44649      2.77539      2.12134      0.36732
   2057.50000     95.37500      2.66809      2.45756      2.39048    183.75000      0.43994      0.61621     12.92188      0.34586      0.02078      0.32386      2.43359      2.11857      0.30395
   2058.00000     78.50000      3.42195      3.99906      3.27820    183.87500      1.77441      1.42090     12.21094      0.26632      0.03061      0.13071      3.50195      2.25459      0.10268
   2058.50000     49.87500      4.01637      5.85215      6.78214    184.12500     28.85938     18.95313     11.71875      0.06777      0.08743      0.00483      5.27734      2.59412      0.04533
   2059.00000     34.93750      3.94485      5.11379     37.65231    183.50000     56.40625     42.93750     11.71875     -0.14620      0.14834      0.02123      4.96875      2.96000      0.03777
   2059.50000     38.78125      3.94057      3.64544     16.63080    182.62500     51.28125     39.68750     11.75000     -0.14724      0.14499      0.09502      4.48438      2.96179      0.08806
   2060.00000     58.68750      3.46927      2.92077      6.82039    181.50000      1.76172      2.83398     12.11719     -0.04068      0.11219      0.18819      3.96680      2.77956      0.17085
   2060.50000     76.62500      3.01539      2.20733      3.46809    179.75000      3.96289      2.61914     12.13281      0.07205      0.11623      0.32356      3.36914      2.58680      0.27456
   2061.00000     82.56250      2.81775      1.67389      2.32343    178.62500      2.02734      1.76172     13.16406      0.30928      0.05991      0.38306      2.83398      2.18113      0.35360
   2061.50000     86.43750      2.57630      1.60754      1.83319    178.50000      0.39990      0.49121     15.23438      0.41146      0.02770      0.37502      2.40625      2.00640      0.34210
   2062.00000     85.25000      2.28121      1.86324      2.11832    179.37500      0.61328      0.65234     14.46094      0.42990      0.01305      0.28078      2.41016      1.97488      0.27693
   2062.50000     87.43750      2.14652      2.12096      2.33600    180.87500      1.74805      1.24219     12.92188      0.31268      0.01742      0.23623      3.05078      2.17532      0.22907
   2063.00000     82.62500      1.98174      2.14170      3.38651    182.50000      2.01367      1.54688     12.77344      0.19973      0.00610      0.22285      3.01563      2.36846      0.20727
   2063.50000     76.87500      1.96628      2.11073      4.70727    183.12500      2.74805      2.04688     12.60156      0.15307      0.00103      0.20572      3.08594      2.44825      0.20118
   2064.00000     71.87500      2.24954      2.24811      5.48925    183.50000      2.77539      2.20703     12.50000      0.14392     -0.00318      0.20410      3.06445      2.46390      0.18902
   2064.50000     71.43750      2.54943      2.42006      4.30511    183.50000      4.01563      2.45898     12.46875      0.13749     -0.00730      0.20063      3.27539      2.47490      0.18816
   2065.00000     72.12500      2.58499      2.60354      5.12628    183.37500      3.09570      2.33203     12.45313      0.11092     -0.00898      0.17457      3.95313      2.52032      0.19644
   2065.50000     74.12500      2.45496      2.48888      7.27148    182.62500      9.06250      5.42969     12.35938      0.07243      0.00403      0.20143      4.19531      2.58615      0.20111
   2066.00000     71.31250      2.28253      2.01795      4.17435    181.75000      4.33594      3.35352     12.62500      0.06794      0.01188      0.22996      3.45703      2.59382      0.25864
   2066.50000     73.62500      1.99987      1.67332      2.38107    180.62500      0.53320      0.88477     13.57031      0.12213      0.00704      0.32109      2.95898      2.50116      0.30985
   2067.00000     75.43750      1.80256      1.52712      1.61098    179.37500      0.27930      0.50879     14.37500      0.20334      0.00589      0.34868      2.39844      2.36229      0.39961
   2067.50000     81.50000      1.67805      1.44892      1.54433    178.75000      0.64014      0.52686     13.84375      0.28294      0.00507      0.35691      2.64063      2.22617      0.37188
   2068.00000     81.31250      1.46835      1.41335      1.49212    178.62500      0.46631      0.54492     14.74219      0.33472      0.00313      0.34464      2.44141      2.13763      0.34161
   2068.50000     86.25000      1.30974      1.33829      1.49840    178.50000      1.65430      0.79541     13.46094      0.35572      0.00180      0.36463      2.70508      2.10173      0.36003
   2069.00000     87.75000      1.30667      1.22182      1.26199    178.62500      0.61328      0.67041     14.14063      0.39283      0.01107      0.41705      2.31641      2.03827      0.37737
   2069.50000     90.56250      1.35949      1.20713      1.24485    179.25000      0.69336      0.58057     13.85938      0.38758      0.00613      0.39906      2.39453      2.04725      0.40786
   2070.00000     85.12500      1.43834      1.34980      1.15365    180.62500      0.39990      0.41943     14.68750      0.36447      0.00191      0.33801      2.37109      2.08676      0.33163
   2070.50000     83.56250      1.56371      1.60964      1.40021    181.87500      1.06738      0.68799     13.03125      0.25675      0.00874      0.27353      2.76172      2.27095      0.26640
   2071.00000     84.62500      1.71472      1.76462      1.73933    183.50000      2.33398      1.61816     12.79688      0.18911      0.01448      0.25041      2.80664      2.38662      0.22779
   2071.50000     83.87500      1.85068      1.98129      2.20322    184.25000      1.70801      1.47461     12.71094      0.16378      0.00082      0.21192      2.93359      2.42994      0.20740
   2072.00000     79.00000      2.08980      2.25766      2.65032    184.75000      2.76172      2.01172     12.42188      0.15878     -0.00430      0.16830      2.84375      2.43848      0.16926
   2072.50000     67.31250      2.37664      2.44043      3.60883    185.25000      5.23047      3.20898     12.38281      0.13524      0.00074      0.13522      2.77930      2.47874      0.15149
   2073.00000     64.50000      2.53737      2.38871      3.92507    185.37500      3.34961      2.56641     12.35156      0.11678      0.00131      0.14468      2.79688      2.51031      0.14860
   2073.50000     66.50000      2.65601      2.25665      3.21373    184.87500      3.02734      2.36914     12.41406      0.11468     -0.00213      0.15752      2.83203      2.51389      0.17016
   2074.00000     69.56250      2.53283      2.19915      2.52947    185.12500      2.72070      2.09961     12.46875      0.12417     -0.00382      0.16531      3.08203      2.49766      0.19180
   2074.50000     74.81250      2.21853      2.09317      2.21614    185.75000      2.01367      1.72559     12.55469      0.11502     -0.00418      0.19185      3.32813      2.51332      0.20699
   2075.00000     78.68750      1.94103      1.82809      2.07971    186.37500      3.56250      2.49414     12.60156      0.09601      0.00263      0.22722      3.74414      2.54582      0.22911
   2075.50000     83.62500      1.69176      1.61833      1.75804    186.62500      1.49414      1.33203     12.64063      0.09174      0.00694      0.26155      3.66602      2.55312      0.24549
   2076.00000     92.18750      1.49763      1.47931      1.55066    185.62500      2.18750      1.56445     12.74219      0.10590      0.00906      0.30030      3.44336      2.52891      0.29512
   2076.50000     95.56250      1.43586      1.31050      1.39023    184.25000      2.06836      1.45703     12.92969      0.15136      0.03519      0.37658      2.91992      2.45118      0.35782
   2077.00000    100.12500      1.44457      1.20592      1.23016    183.00000      0.54639      0.79541     13.25000      0.24060      0.03522      0.43225      2.61523      2.29857      0.40861
   2077.50000     95.31250      1.44533      1.30347      1.10394    182.62500      0.45313      0.52686     13.92969      0.29328      0.01031      0.39868      2.39844      2.20849      0.37753
   2078.00000     94.37500      1.38914      1.52476      1.16859    182.75000      0.80029      0.63428     13.16406      0.26285      0.00621      0.27491      3.34375      2.26053      0.31677
   2078.50000     87.75000      1.24200      1.53594      1.82710    183.37500      3.78906      2.65625     12.77344      0.13528      0.02762      0.21479      3.93750      2.47867      0.26485
   2079.00000     85.75000      1.10489      1.26667      3.66349    183.12500      4.30859      3.87109     12.83594      0.06991      0.04127      0.28926      3.04688      2.59045      0.29426
   2079.50000     82.18750      1.05541      1.02118      5.16128    182.50000      2.13281      1.40332     13.55469      0.19187      0.00925      0.38568      2.71484      2.38191      0.37364
   2080.00000     81.87500      1.07358      0.95651      1.97574    180.62500      0.26611      0.40186     16.07813      0.28659      0.01093      0.41496      2.54297      2.21993      0.43664
   2080.50000     81.68750      1.08747      0.98045      1.20227    179.75000      0.25244      0.36572     16.23438      0.30814      0.03626      0.40456      2.82617      2.18308      0.41829
   2081.00000     84.56250      1.09013      0.97476      1.07128    179.62500      0.29297      0.38379     14.39063      0.27204      0.08077      0.43854      2.61328      2.24481      0.41088
   2081.50000     90.81250      1.08547      0.96042      1.19091    179.87500      0.39990      0.43750     14.22656      0.29520      0.06010      0.42859      2.40820      2.20521      0.42370
   2082.00000     91.62500      1.10234      1.01592      1.25388    180.25000      0.45313      0.43750     15.50781      0.30198      0.03058      0.39206      2.39063      2.19361      0.35231
   2082.50000     91.50000      1.17875      1.12453      1.21508    180.62500      1.98828      0.68799     13.35156      0.27422      0.01293      0.30968      3.14453      2.24108      0.33614
   2083.00000     91.12500      1.21366      1.25224      1.48079    180.87500      0.85352      1.22461     12.98438      0.16881      0.01048      0.26425      4.03906      2.42133      0.31528
   2083.50000     86.43750      1.20680      1.27199      1.53804    181.00000      2.40234      1.79688     12.70313      0.11201      0.01847      0.29219      3.13672      2.51847      0.32324
   2084.00000     84.00000      1.26240      1.12453      3.11122    179.87500      4.75000      3.12109     13.21094      0.25691      0.00014      0.38474      2.47461      2.27068      0.38428
   2084.50000     81.68750      1.35185      1.00468   2000.00000    178.37500      0.49316      0.63428     15.50781      0.50080     -0.02231      0.46447      2.07617      1.85363      0.47657
   2085.00000     78.93750      1.47799      0.97557      8.41492    177.00000      0.47998      0.43750     19.00000      0.59704     -0.01626      0.43516      1.99023      1.68907      0.55903
   2085.50000     77.00000      1.69981      1.05016      2.21777    176.37500      0.46680      0.41992     18.78125      0.63199     -0.00286      0.43400      2.12891      1.62930      0.42880
   2086.00000     81.93750      1.82809      1.23812      1.70404    176.87500      0.65332      0.41992     17.68750      0.56303     -0.00341      0.44432      2.27734      1.74723      0.40394
   2086.50000     92.50000      1.69059      1.48603      1.66510    178.25000      0.56006      0.52686     15.03125      0.49177     -0.00057      0.41911      2.26367      1.86908      0.37756
   2087.00000     99.18750      1.54130      1.73082      1.84494    180.50000      0.39990      0.45557     13.41406      0.36186      0.00766      0.31859      2.82617      2.09122      0.33011
   2087.50000     92.12500      1.46352      1.76806      2.82885    182.37500      3.09570      1.29590     12.61719      0.24518      0.01065      0.26136      3.62109      2.29075      0.27492
   2088.00000     85.68750      1.47539      1.54365      2.98380    183.12500      1.86816      1.79785     12.66406      0.12195      0.04473      0.27114      3.73047      2.50146      0.28280
   2088.50000     80.81250      1.63498      1.42260      2.51057    183.37500      2.92188      1.81445     12.96094      0.11584      0.05923      0.33268      3.40625      2.51191      0.32439
   2089.00000     85.75000      1.80404      1.42302      1.74737    183.25000      0.54639      0.61670     12.96875      0.18296      0.02647      0.34227      3.04688      2.39714      0.35479
   2089.50000     82.56250      1.86322      1.49371      1.45829    182.75000      1.02734      0.83105     12.75000      0.21399      0.01759      0.35065      2.89258      2.34407      0.33240
   2090.00000     82.43750      1.75294      1.49690      1.41595    182.87500      1.78809      1.26074     12.88281      0.17795      0.04145      0.31005      2.89844      2.40571      0.32778
   2090.50000     77.87500      1.49604      1.45258      1.51114    182.75000      1.01367      0.93848     12.78125      0.14813      0.03806      0.26961      3.42578      2.45669      0.30278
   2091.00000     80.68750      1.27462      1.33866      1.67154    182.12500      1.22656      1.04590     12.73438      0.13726      0.03313      0.30005      2.90820      2.47529      0.30735
   2091.50000     75.75000      1.18641      1.16955      1.58355    181.62500      3.46875      1.86816     13.00781      0.24131      0.04240      0.35947      2.63672      2.29735      0.37961
   2092.00000     74.00000      1.14392      1.04461      1.16230    180.62500      0.38623      0.56250     15.40625      0.37534      0.04300      0.42632      2.29492      2.06818      0.44031
   2092.50000     77.87500      1.13386      1.03911      0.95189    179.50000      0.26611      0.38379     15.78906      0.42876      0.05921      0.38797      2.33398      1.97682      0.42590
   2093.00000     92.62500      1.15358      1.09563      1.00655    179.37500      0.35986      0.41992     14.91406      0.39042      0.07158      0.35213      2.54102      2.04238      0.34901
   2093.50000    105.62500      1.11831      1.14607      0.86390    179.87500      0.78711      0.58057     14.00781      0.27172      0.10188      0.28916      2.61328      2.24536      0.31675
   2094.00000    109.56250      1.03889      1.15602      1.10576    180.62500      0.72021      0.72412     13.70313      0.20225      0.07353      0.29138      2.63281      2.36416      0.28280
   2094.50000    107.62500      1.01888      1.08072      1.33499    180.87500      2.00000      1.20703     13.11719      0.19601      0.05982      0.28512      2.51367      2.37482      0.30178
   2095.00000    100.56250      1.03037      1.02739      1.35960    181.12500      1.00000      0.88477     14.25781      0.22459      0.02457      0.30995      2.50977      2.32596      0.28782
   2095.50000     95.06250      1.06472      1.04830      1.13481    181.50000      0.37305      0.49121     15.07031      0.23465      0.01948      0.29699      2.69336      2.30874      0.29414
   2096.00000     90.31250      1.11654      1.09062      1.07280    182.62500      0.60010      0.59863     13.03125      0.21883      0.01454      0.31683      3.12109      2.33580      0.28249
   2096.50000     92.50000      1.13814      1.11926      1.01534    183.75000      9.14844      3.38867     12.72656      0.16913      0.03851      0.30153      3.36328      2.42080      0.30827
   2097.00000     93.18750      1.09019      1.12665      1.19208    185.37500      1.85352      2.04688     12.79688      0.14366      0.01325      0.29161      3.16602      2.46434      0.29076
   2097.50000     94.06250      1.07187      1.09362      1.31324    186.62500      2.16016      1.40332     12.94531      0.12416      0.01017      0.30691      2.98633      2.49769      0.29159
   2098.00000     93.12500      1.06321      1.04553      1.30249    187.25000      1.56152      1.36719     13.04688      0.11687      0.01306      0.31610      3.00781      2.51016      0.32645
   2098.50000     97.25000      1.06060      1.01942      1.09257    188.00000      1.49414      1.11719     13.14844      0.13946      0.00573      0.33881      3.17188      2.47153      0.34386
   2099.00000     99.06250      1.05962      1.01767      0.95746    188.25000      1.74805      1.52832     12.96094      0.15943     -0.00457      0.31440      3.33789      2.43737      0.35367
   2099.50000    100.37500      1.04564      1.01767      0.93786    189.12500      1.33398      1.27832     13.18750      0.16093     -0.00084      0.31750      3.31250      2.43481      0.31430
   2100.00000    105.18750      0.98313      1.00640      0.98684    189.50000      1.16016      1.02734     13.05469      0.15809      0.00145      0.27103      3.14844      2.43967      0.32020
   2100.50000    109.50000      0.93525      0.95108      1.00072    189.25000      1.84082      1.18848     12.63281      0.16289     -0.00014      0.30544      3.28125      2.43145      0.29940
   2101.00000    107.00000      0.90899      0.87674      0.93093    187.00000      1.49316      1.31445     12.75000      0.17501      0.01908      0.35040      2.94727      2.41073      0.35984
   2101.50000    102.06250      0.89318      0.83376      0.81709    185.12500      0.76025      0.68799     13.13281      0.22710      0.04122      0.42075      2.76172      2.32166      0.37846
   2102.00000    101.18750      0.89411      0.82777      0.82658    183.25000      0.22607      0.49121     13.82031      0.28271      0.03821      0.40769      2.55664      2.22657      0.41634
   2102.50000    109.31250      0.90027      0.84910      0.84189    183.12500      0.38623      0.43750     13.64844      0.29482      0.04081      0.37920      2.76172      2.20585      0.38592
   2103.00000    113.62500      0.89583      0.86756      0.84910    183.37500      0.50635      0.52686     13.21875      0.25111      0.05444      0.37715      3.17773      2.28061      0.39384
   2103.50000    118.87500      0.89302      0.87807      0.83204    184.25000      0.73340      0.63428     13.07031      0.20632      0.04139      0.38802      3.48242      2.35719      0.40523
   2104.00000    113.50000      0.89679      0.88881      0.95944    184.50000      1.18750      0.77734     12.89063      0.18789      0.01483      0.39010      3.59766      2.38870      0.41131
   2104.50000    104.37500      0.89786      0.88476      1.03162    183.87500      1.25391      0.83105     12.96875      0.18624      0.02016      0.41063      3.26367      2.39153      0.44177
   2105.00000     92.25000      0.90272      0.86239      1.02969    182.62500      1.13379      0.84912     13.09375      0.21588      0.03794      0.45300      2.60352      2.34084      0.48561
   2105.50000     91.25000      0.93109      0.83497      0.88983    181.12500      0.86670      0.65234     14.09375      0.40792      0.00633      0.45624      2.25000      2.01245      0.52909
   2106.00000     91.25000      0.94363      0.85728      0.79184    179.87500      0.39990      0.50879     16.78125      0.48444      0.00315      0.41867      1.94434      1.88161      0.44073
   2106.50000     88.12500      0.91765      0.90470      0.73855    179.62500      0.52002      0.50879     17.60938      0.49202      0.00580      0.34490      2.23633      1.86864      0.38256
   2107.00000     92.00000      0.87393      0.92041      0.83990    180.12500      0.37305      0.45557     15.04688      0.37013      0.01709      0.34388      2.84180      2.07709      0.35641
   2107.50000     98.18750      0.82144      0.85538      0.87175    180.37500      0.58643      0.50879     14.40625      0.27568      0.03457      0.35246      2.86914      2.23858      0.37400
   2108.00000    104.93750      0.78491      0.78798      0.82965    180.87500      0.69336      0.68799     16.21875      0.27747      0.04719      0.41092      2.75391      2.23553      0.38124
   2108.50000     90.62500      0.78440      0.76577      0.78211    181.00000      0.54639      0.59863     17.04688      0.34652      0.04290      0.44245      2.63281      2.11745      0.43546
   2109.00000     81.25000      0.78308      0.76836      0.78049    180.75000      0.60010      0.58057     17.03125      0.39012      0.03563      0.43915      2.75977      2.04289      0.44334
   2109.50000     76.43750      0.76980      0.77305      0.83136    181.12500      0.64014      0.61670     15.34375      0.36925      0.04092      0.41026      2.79883      2.07859      0.44739
   2110.00000     84.37500      0.75205      0.76991      0.81324    181.25000      0.56006      0.54492     14.14844      0.31705      0.05583      0.40976      2.74219      2.16784      0.43140
   2110.50000     95.43750      0.74062      0.76629      0.90597    181.62500      0.39990      0.43750     15.08594      0.29462      0.04391      0.41610      2.59766      2.20620      0.43232
   2111.00000     94.12500      0.76605      0.76423      0.90272    181.25000      0.38623      0.41992     16.59375      0.34191      0.02951      0.40348      2.32617      2.12534      0.44071
   2111.50000     93.93750      0.82505      0.78744      0.88372    181.50000      0.45313      0.45557     16.51563      0.39927      0.01412      0.40394      2.34375      2.02724      0.41902
   2112.00000     85.68750      0.89115      0.85728      0.79475    181.62500      0.53320      0.49121     17.51563      0.41627      0.00789      0.42829      2.25391      1.99818      0.39280
   2112.50000     85.68750      1.00116      0.93663      0.82388    181.37500      0.50635      0.52686     15.66406      0.40389      0.01310      0.42908      2.45898      2.01935      0.41575
   2113.00000     85.87500      1.08539      1.04002      0.91006    181.62500      0.46631      0.50879     15.74219      0.36861      0.01051      0.35458      2.57813      2.07968      0.38043
   2113.50000     83.81250      1.09973      1.18571      0.96634    181.62500      0.58691      0.63428     15.49219      0.32968      0.00226      0.28447      2.84961      2.14625      0.29969
   2114.00000     77.37500      1.16267      1.22554      1.41198    181.00000      2.29492      1.15332     13.09375      0.24507      0.04352      0.33666      2.48633      2.29093      0.30044
   2114.50000     75.31250      1.24851      1.14717      1.43955    180.37500      1.29395      0.90283     13.35938      0.23191      0.09273      0.38498      2.15625      2.31344      0.37229
   2115.00000     78.50000      1.27073      1.14717      1.47898    179.62500      0.54639      0.56250     15.49219      0.29670      0.06278      0.41140      1.99023      2.20264      0.40924
   2115.50000     83.12500      1.37353      1.16955      1.16791    178.62500      0.62646      0.52686     13.78906      0.34694      0.06498      0.37091      2.12305      2.11672      0.42915
   2116.00000     83.37500      1.42481      1.19752      1.12573    179.00000      1.85449      0.92041     13.85938      0.34426      0.06264      0.35332      2.46289      2.12132      0.39997
   2116.50000     91.06250      1.35391      1.23306      1.03427    179.37500      0.29297      0.56250     14.32813      0.34318      0.04047      0.36517      2.49219      2.12316      0.36630
   2117.00000     97.43750      1.37501      1.24965      1.22691    179.25000      0.72021      0.65234     14.00000      0.37978      0.01433      0.41339      2.41211      2.06058      0.36839
   2117.50000     92.56250      1.44057      1.31192      1.39537    180.00000      0.52002      0.70605     15.69531      0.41081      0.01055      0.37879      2.17188      2.00752      0.35378
   2118.00000     77.62500      1.41907      1.49895      1.69070    181.50000      0.51953      0.58057     13.81250      0.40613      0.00798      0.29921      2.20117      2.01552      0.27120
   2118.50000     69.56250      1.48828      1.62258      2.09774    182.87500      1.18750      1.11719     12.73438      0.32039      0.02559      0.20981      2.71289      2.16214      0.22401
   2119.00000     76.31250      1.58002      1.58560      1.95214    184.25000      2.44141      1.77930     12.61719      0.19088      0.05070      0.20722      2.74219      2.38360      0.20421
   2119.50000     78.68750      1.62292      1.54244      1.70212    185.25000      1.82813      1.31445     12.61719      0.14214      0.03428      0.22611      2.75781      2.46694      0.21898
   2120.00000     78.50000      1.71399      1.56796      1.50026    185.50000      1.80078      1.31445     12.64063      0.15043      0.01389      0.22804      2.76758      2.45276      0.22674
   2120.50000     74.62500      1.78977      1.60937      1.53648    185.50000      1.82813      1.27832     12.69531      0.14436      0.01061      0.22761      2.95703      2.46315      0.21729
   2121.00000     80.37500      1.74791      1.59689      1.56107    185.62500      1.48047      1.18848     12.64063      0.13152      0.01710      0.21210      2.90234      2.48509      0.21709
   2121.50000     82.37500      1.69187      1.55363      1.70404    185.12500      2.28125      1.51074     12.61719      0.12963      0.01295      0.20296      2.84961      2.48834      0.20798
   2122.00000     76.93750      1.62994      1.52381      1.63537    184.50000      1.92090      1.42188     12.62500      0.13830      0.01067      0.17505      2.82813      2.47350      0.20636
   2122.50000     72.93750      1.54765      1.48828      1.58397    183.62500      1.68066      1.24219     12.70313      0.15320      0.00735      0.18946      2.86719      2.44802      0.20742
   2123.00000     68.06250      1.47456      1.40664      1.57859    182.50000      1.45410      1.20605     12.88281      0.16990      0.00567      0.23220      2.72656      2.41947      0.24499
   2123.50000     74.81250      1.46680      1.29373      1.46359    181.50000      1.33398      1.11719     13.02344      0.21585      0.01199      0.31918      2.44531      2.34089      0.29742
   2124.00000     71.75000      1.53119      1.22306      1.29082    181.00000      0.94727      0.81348     13.77344      0.29765      0.00934      0.35636      2.31641      2.20101      0.34428
   2124.50000     76.50000      1.59338      1.30207      1.12594    180.75000      0.38623      0.56250     15.03125      0.35046      0.01031      0.33189      2.21484      2.11072      0.31413
   2125.00000     73.06250      1.59699      1.53594      1.24922    181.50000      0.29297      0.45557     13.87500      0.33130      0.01374      0.27127      2.48047      2.14348      0.27131
   2125.50000     77.31250      1.53979      1.65488      1.46928    183.12500      0.89355      0.77734     13.24219      0.25714      0.02105      0.22397      2.58203      2.27029      0.23283
   2126.00000     77.68750      1.42263      1.58407      1.79670    184.12500      1.61426      1.34961     13.01563      0.17352      0.01143      0.20850      2.80859      2.41328      0.23255
   2126.50000     85.75000      1.32825      1.40786      1.87062    183.75000      1.86816      1.38574     13.00000      0.15883      0.00951      0.26570      2.78516      2.43841      0.25339
   2127.00000     84.00000      1.32945      1.23685      1.52910    182.00000      1.54785      1.26074     13.03125      0.23017      0.00405      0.33672      2.44531      2.31640      0.32747
   2127.50000     85.75000      1.33749      1.13413      1.17062    180.37500      1.16016      0.93799     13.72656      0.34349      0.00351      0.40537      2.35156      2.12264      0.40192
   2128.00000     84.31250      1.32971      1.11717      0.86700    178.62500      0.50635      0.54492     15.01563      0.41680      0.02173      0.39130      2.15039      1.99727      0.42654
   2128.50000     91.06250      1.31378      1.15826      0.90178    178.25000      0.26611      0.36572     15.92969      0.41152      0.04589      0.34943      2.28125      2.00630      0.34777
   2129.00000     94.31250      1.23258      1.22430      0.95565    179.25000      0.25293      0.36572     16.39063      0.34401      0.06045      0.29495      2.36133      2.12174      0.29454
   2129.50000     88.62500      1.15930      1.26139      1.12741    180.75000      0.56006      0.45557     13.57813      0.24945      0.06910      0.29125      2.72070      2.28344      0.28423
   2130.00000     84.62500      1.16300      1.24322      1.26437    181.87500      1.14648      0.93848     13.21094      0.18762      0.08057      0.33318      2.73828      2.38917      0.30285
   2130.50000     80.68750      1.22210      1.22430      1.27396    182.75000      0.98682      1.00977     13.46875      0.20915      0.06861      0.33349      2.59375      2.35235      0.33251
   2131.00000     81.75000      1.30031      1.30627      1.26278    184.00000      0.37305      0.65234     14.76563      0.24894      0.04849      0.29909      2.48633      2.28432      0.26776
   2131.50000     82.81250      1.38733      1.43639      1.30926    185.25000      0.49316      0.54492     13.57813      0.24310      0.04062      0.23990      2.59570      2.29430      0.23117
   2132.00000     87.68750      1.46938      1.47110      1.47754    186.12500      2.42773      1.56445     12.72656      0.18066      0.05730      0.23757      2.73438      2.40107      0.22037
   2132.50000     90.25000      1.53899      1.46342      1.43306    186.50000      1.86816      1.40332     12.76563      0.13531      0.04612      0.23550      2.79688      2.47862      0.22970
   2133.00000     86.00000      1.63897      1.53858      1.33029    186.12500      1.48047      1.26074     12.73438      0.14637      0.00460      0.23320      2.73633      2.45970      0.21343
   2133.50000     78.25000      1.73202      1.68298      1.35291    185.62500      1.56152      1.17090     12.58594      0.14516     -0.00678      0.20517      2.88672      2.46177      0.20957
   2134.00000     70.56250      1.73679      1.79290      1.74586    185.37500      2.32031      1.63672     12.58594      0.12566     -0.00633      0.17872      2.96094      2.49512      0.19043
   2134.50000     63.68750      1.71040      1.78743      2.09629    185.37500      3.00195      1.88672     12.57031      0.11961     -0.01150      0.16623      2.97852      2.50546      0.17947
   2135.00000     60.40625      1.71015      1.74205      2.14310    185.25000      2.78711      2.04688     12.58594      0.11493     -0.01324      0.16775      2.78320      2.51346      0.18413
   2135.50000     61.46875      1.70788      1.67587      1.88344    184.87500      2.17383      1.65430     12.61719      0.12807     -0.01096      0.20135      2.73633      2.49100      0.20416
   2136.00000     68.06250      1.70712      1.56622      1.58813    183.62500      2.18750      1.52832     12.67969      0.13856     -0.00273      0.24378      2.68945      2.47306      0.24542
   2136.50000     76.68750      1.69778      1.48423      1.36605    183.00000      1.66699      1.09961     13.10938      0.16508     -0.00290      0.26658      2.71680      2.42771      0.27193
   2137.00000     85.81250      1.61582      1.50193      1.18484    182.37500      0.57324      0.70605     13.46094      0.18873     -0.00510      0.26222      2.75977      2.38727      0.27905
   2137.50000     90.62500      1.46223      1.52358      1.30502    181.75000      1.00000      0.88477     12.97656      0.19174     -0.00513      0.26365      2.89453      2.38213      0.27541
   2138.00000     97.25000      1.32807      1.39559      1.45269    181.50000      1.50781      1.29688     13.04688      0.18374      0.00564      0.30781      2.85352      2.39581      0.30459
   2138.50000    100.87500      1.22835      1.22804      1.45794    181.37500      0.64014      0.77734     13.35938      0.19346      0.01022      0.35333      2.86523      2.37919      0.36464
   2139.00000    103.25000      1.17934      1.13413      1.19326    180.50000      0.26611      0.52686     14.73438      0.23391      0.01413      0.35990      2.77344      2.31002      0.39445
   2139.50000     96.87500      1.16209      1.10784      1.07989    180.00000      0.27930      0.43750     15.55469      0.26356      0.02627      0.37125      2.85352      2.25931      0.37823
   2140.00000     94.12500      1.14833      1.09262      1.00122    180.37500      0.39990      0.38379     14.65625      0.27104      0.04821      0.40191      2.91016      2.24652      0.38870
   2140.50000     91.00000      1.12330      1.09563      0.96357    180.62500      0.41309      0.41992     14.72656      0.25863      0.03506      0.41399      3.09961      2.26773      0.39652
   2141.00000     92.43750      1.12268      1.12137      0.94935    181.25000      0.33301      0.45557     15.06250      0.23759      0.01944      0.38111      3.18555      2.30373      0.39315
   2141.50000     93.50000      1.14452      1.18454      0.99447    182.50000      0.45313      0.52686     14.20313      0.19809      0.01708      0.34008      3.01953      2.37127      0.34386
   2142.00000     92.75000      1.19156      1.25354      1.06712    184.00000      0.57324      0.56250     13.78906      0.18373      0.00767      0.29645      2.86719      2.39581      0.30251
   2142.50000     91.81250      1.27692      1.32480      1.30277    184.75000      0.53320      0.72363     13.39063      0.17329     -0.00391      0.26896      2.73047      2.41368      0.27101
   2143.00000     87.56250      1.40278      1.42198      1.39344    185.87500      0.45313      0.63428     13.21875      0.16199     -0.00370      0.24994      2.87891      2.43300      0.25341
   2143.50000     84.56250      1.52894      1.55118      1.43306    186.37500      0.93359      0.93848     13.00000      0.15908     -0.00537      0.24367      2.82617      2.43796      0.23916
   2144.00000     82.37500      1.64194      1.66853      1.57325    186.75000      1.36035      1.27832     12.91406      0.15559     -0.00697      0.23065      2.86133      2.44393      0.23465
   2144.50000     81.12500      1.73037      1.73263      2.02064    187.12500      1.62793      1.40332     12.87500      0.14101      0.00129      0.20810      2.83398      2.46887      0.22458
   2145.00000     80.93750      1.80079      1.71085      2.24494    187.37500      1.70703      1.56445     12.85938      0.12879      0.01365      0.21720      2.76953      2.48976      0.21536
   2145.50000     76.81250      1.85015      1.68699      1.91748    187.25000      2.01367      1.49316     12.89063      0.12156      0.04472      0.23782      2.79102      2.50213      0.22926
   2146.00000     73.37500      1.89526      1.71974      1.52910    187.25000      1.61426      1.29590     12.97656      0.13134      0.04726      0.24193      2.73633      2.48541      0.23567
   2146.50000     74.62500      1.84251      1.81544      1.58771    187.62500      1.02637      0.97412     12.93750      0.14727      0.04175      0.20829      2.96094      2.45817      0.22433
   2147.00000     74.81250      1.67777      1.80329      2.04871    187.00000      2.04102      1.51074     12.72656      0.13578      0.03823      0.22838      3.17383      2.47781      0.20974
   2147.50000     76.93750      1.57456      1.55731      2.24744    185.62500      4.75000      2.76172     12.64063      0.15146      0.04558      0.31355      2.83789      2.45100      0.25340
   2148.00000     76.18750      1.53728      1.37281      1.82875    184.37500      1.80078      1.56445     13.35156      0.24629      0.01072      0.34173      2.55078      2.28885      0.32803
   2148.50000     84.18750      1.47900      1.37727      1.35503    183.37500      0.31982      0.50879     14.92969      0.30416     -0.00013      0.33406      2.47656      2.18989      0.33753
   2149.00000     95.68750      1.44013      1.39479      1.20013    183.00000      0.50635      0.50879     13.35938      0.31297      0.00780      0.33227      2.52539      2.17482      0.35965
   2149.50000    102.43750      1.41219      1.30909      1.28288    183.12500      1.41406      0.97461     13.40625      0.28387      0.04290      0.37732      2.59180      2.22459      0.38220
   2150.00000    106.06250      1.33628      1.26270      1.35230    182.87500      0.26611      0.43750     15.09375      0.30133      0.01360      0.35724      2.49414      2.19473      0.39268
   2150.50000     98.25000      1.32655      1.32770      1.36389    183.12500      0.45313      0.47314     14.65625      0.30524      0.00744      0.32706      2.80078      2.18804      0.32966
   2151.00000     97.37500      1.37153      1.42634      1.30559    183.87500      0.50635      0.54492     13.59375      0.24423      0.03025      0.30294      3.08008      2.29237      0.31018
   2151.50000     93.62500      1.36959      1.44508      1.47645    185.00000      0.61328      0.61670     13.38281      0.19105      0.03596      0.31795      3.04688      2.38330      0.29659
   2152.00000     93.81250      1.37720      1.40786      1.52678    186.37500      1.13379      0.86719     12.96094      0.19141      0.02802      0.33567      2.92383      2.38269      0.32437
   2152.50000     91.62500      1.46350      1.39679      1.64920    187.12500      1.30762      1.17090     12.99219      0.20206      0.04470      0.32714      2.80859      2.36448      0.32772
   2153.00000     88.37500      1.53115      1.47287      1.59022    187.62500      0.50635      0.70605     13.97656      0.20667      0.03904      0.29145      2.74805      2.35660      0.30333
   2153.50000     87.06250      1.53452      1.57346      1.66510    188.12500      0.61328      0.66992     13.15625      0.18936      0.04638      0.26170      2.99023      2.38619      0.27759
   2154.00000     85.06250      1.55453      1.56324      1.85342    187.75000      2.01367      1.24219     12.73438      0.16465      0.07221      0.27750      2.87695      2.42845      0.28574
   2154.50000     84.37500      1.59903      1.47530      1.63892    187.25000      1.52051      1.09863     12.67188      0.22212      0.05477      0.31308      2.79297      2.33017      0.31643
   2155.00000     84.56250      1.63713      1.50216      1.50850    187.37500      0.78662      0.79541     12.84375      0.28208      0.03036      0.30728      2.66211      2.22765      0.32010
   2155.50000     86.62500      1.68938      1.62152      1.50737    187.50000      0.56006      0.61670     12.92188      0.28118      0.03209      0.31632      2.80273      2.22918      0.29513
   2156.00000     93.62500      1.76032      1.64307      1.59651    187.25000      2.06641      1.24219     12.76563      0.26150      0.05596      0.32111      2.62305      2.26284      0.31276
   2156.50000     91.68750      1.80419      1.64525      1.79723    189.00000      2.20117      1.40332     12.93750      0.26265      0.02593      0.32552      2.56641      2.26086      0.32241
   2157.00000     93.18750      1.76539      1.75558      1.66647    190.62500      0.69336      0.70605     13.05469      0.28566      0.00180      0.27345      2.41602      2.22152      0.30604
   2157.50000     83.43750      1.68251      1.83549      1.95088    190.50000      1.92090      1.27832     12.91406      0.24310     -0.00475      0.25567      2.82813      2.29429      0.28530
   2158.00000     85.87500      1.60095      1.65129      2.08833    190.25000      1.88086      1.83301     12.86719      0.18927      0.02846      0.32667      2.76953      2.38635      0.31414
   2158.50000     85.00000      1.53504      1.36417      1.97059    188.25000      1.22656      1.20703     13.32813      0.22068      0.02870      0.40858      2.74609      2.33264      0.39483
   2159.00000     85.18750      1.51628      1.24066      1.55986    186.12500      0.31934      0.52686     15.50781      0.31157      0.02012      0.44361      2.61914      2.17721      0.48285
   2159.50000     79.87500      1.56570      1.21566      1.23166    184.00000      0.41309      0.49121     16.60938      0.38210      0.03495      0.44338      2.50977      2.05661      0.45399
   2160.00000     80.37500      1.59088      1.27736      1.14556    183.50000      0.52002      0.47314     14.71875      0.42464      0.05332      0.39945      2.40234      1.98386      0.41727
   2160.50000     84.00000      1.45776      1.47066      1.34002    184.50000      0.43994      0.47314     16.04688      0.42404      0.02435      0.34392      2.59961      1.98489      0.33389
   2161.00000     89.93750      1.31177      1.48468      1.75600    184.62500      0.76025      0.63428     12.78125      0.36366      0.02935      0.34825      2.31836      2.08813      0.34385
   2161.50000     88.00000      1.28210      1.27467      1.98092    184.87500      2.14648      1.51074     12.78906      0.36518      0.03821      0.39687      2.03711      2.08554      0.40295
   2162.00000     82.18750      1.32379      1.13413      1.35807    185.00000      0.43994      0.58057     15.25781      0.56546      0.00213      0.44156      1.79395      1.74306      0.46112
   2162.50000     80.18750      1.39448      1.21566      1.24870    185.00000      0.43994      0.52686     17.75000      0.61690     -0.00545      0.37233      1.82813      1.65509      0.41002
   2163.00000     79.25000      1.41083      1.41807      1.24587    186.37500      0.37305      0.47314     14.23438      0.58195     -0.00835      0.35144      2.31641      1.71487      0.35031
   2163.50000     82.31250      1.32486      1.35582      1.24613    186.87500      1.66797      1.09961     12.48438      0.38309      0.01469      0.32877      2.51758      2.05492      0.37184
   2164.00000     75.31250      1.22457      1.20231      1.39408    188.00000      1.74805      1.26074     12.86719      0.30583      0.03557      0.31702      2.63086      2.18703      0.37157
   2164.50000     73.00000      1.20221      1.14498      1.19989    187.50000      0.54639      0.63428     13.81250      0.29916      0.04707      0.35527      2.70508      2.19844      0.33690
   2165.00000     78.12500      1.26499      1.15158      1.09080    186.37500      0.57324      0.68799     13.70313      0.29454      0.07436      0.41717      2.64844      2.20634      0.35836
   2165.50000     89.68750      1.37429      1.17758      1.12072    187.00000      0.47949      0.47314     14.31250      0.32263      0.08514      0.44642      2.46875      2.15829      0.40212
   2166.00000     93.56250      1.42537      1.32770      1.26648    188.75000      0.49316      0.50879     15.71094      0.36867      0.05111      0.36830      2.37305      2.07958      0.37739
   2166.50000     96.18750      1.48230      1.60806      1.44990    190.62500      1.85449      1.02734     12.67969      0.34814      0.03346      0.27161      2.63281      2.11468      0.30400
   2167.00000     90.62500      1.49775      1.76087      1.78819    193.25000      1.13379      1.40332     12.54688      0.25501      0.02250      0.24785      2.73633      2.27393      0.25287
   2167.50000     91.68750      1.45497      1.65598      2.20563    194.37500      1.96094      1.56445     12.44531      0.16924      0.01414      0.27513      2.64453      2.42060      0.25750
   2168.00000     92.06250      1.46265      1.54220      1.98939    194.00000      1.58789      1.49316     12.46875      0.15376      0.00874      0.28816      2.74609      2.44707      0.28236
   2168.50000     91.25000      1.54649      1.50033      1.66235    193.25000      1.38770      1.36816     12.46875      0.15551      0.00236      0.26446      2.73438      2.44407      0.28075
   2169.00000     88.62500      1.55242      1.47176      1.53609    191.87500      2.01367      1.52832     12.46875      0.15365     -0.00047      0.23169      2.78125      2.44726      0.25031
   2169.50000     82.37500      1.53396      1.43093      1.38355    190.87500      1.85449      1.31445     12.46875      0.16203     -0.00112      0.23975      2.73828      2.43293      0.22797
   2170.00000     85.31250      1.55032      1.43323      1.27638    190.00000      1.66797      1.31445     12.46875      0.16979     -0.00926      0.24584      2.76367      2.41966      0.22831
   2170.50000     83.12500      1.58439      1.50515      1.22368    189.62500      1.49414      1.27832     12.46875      0.17420     -0.01304      0.23945      2.85938      2.41211      0.22428
   2171.00000     75.06250      1.62266      1.64634      1.35019    189.75000      1.44141      1.26074     12.29688      0.15971     -0.00989      0.20253      3.11328      2.43689      0.21520
   2171.50000     66.93750      1.73362      1.79646      1.74586    190.00000      2.05469      1.77930     12.17188      0.13983     -0.00638      0.18133      3.15234      2.47089      0.18479
   2172.00000     62.09375      1.88620      1.97465      2.36987    190.37500      2.04102      1.94043     12.17188      0.12534     -0.00651      0.16335      3.25977      2.49566      0.17725
   2172.50000     63.43750      2.05095      2.16796      2.70606    190.62500      1.97461      1.85059     12.15625      0.11193     -0.00480      0.16453      3.15820      2.51859      0.16643
   2173.00000     64.56250      2.19113      2.30500      2.69400    190.75000      2.33398      2.17188     12.17188      0.10795     -0.00522      0.15682      3.17969      2.52541      0.17249
   2173.50000     65.50000      2.21554      2.31079      2.45253    190.62500      2.14844      1.76172     12.12500      0.10496     -0.00655      0.16795      2.88477      2.53052      0.16982
   2174.00000     69.12500      2.08419      2.20781      2.31897    190.37500      2.18750      1.61816     12.01563      0.11606     -0.00784      0.17199      2.87109      2.51155      0.18395
   2174.50000     74.06250      1.85161      1.95539      2.29783    189.50000      1.96094      1.61816     12.02344      0.12310     -0.01109      0.20226      2.85938      2.49949      0.20483
   2175.00000     79.00000      1.62792      1.58892      2.08401    188.75000      1.93457      1.67188     12.10156      0.15149     -0.00007      0.25508      2.84375      2.45095      0.26242
   2175.50000     80.31250      1.50834      1.32516      1.54709    187.50000      1.32031      1.11719     12.78906      0.21163      0.02222      0.33551      2.72266      2.34810      0.31407
   2176.00000     81.56250      1.47818      1.25354      1.14643    186.62500      0.34619      0.56250     14.53125      0.28307      0.03281      0.35197      2.55859      2.22595      0.33682
   2176.50000     84.18750      1.48902      1.33060      1.02272    187.12500      0.27930      0.41943     15.28125      0.30397      0.03329      0.32413      2.57227      2.19020      0.29107
   2177.00000     83.18750      1.53533      1.50285      1.03462    188.37500      0.86719      0.61621     13.75781      0.26704      0.05007      0.27495      2.77930      2.25336      0.25414
   2177.50000     84.50000      1.61385      1.68384      1.21070    189.62500      1.41406      1.24219     12.04688      0.20021      0.04478      0.24311      3.15430      2.36764      0.22419
   2178.00000     75.62500      1.72528      1.93611      1.59231    191.75000      1.96191      1.67188     11.74219      0.16919      0.00799      0.18923      3.16602      2.42069      0.19000
   2178.50000     74.68750      1.92081      2.27800      2.47664    192.50000      3.48242      2.53125     11.47656      0.12788     -0.00062      0.13995      3.16992      2.49132      0.14697
   2179.00000     66.00000      2.16320      2.60620      4.40548    192.75000      6.01563      3.78320     11.32031      0.09327      0.00237      0.11149      3.11133      2.55051      0.13177
   2179.50000     63.31250      2.33425      2.69012      8.15394    192.62500      4.39063      3.49609     11.39063      0.07355      0.00108      0.12181      2.99414      2.58423      0.13591
   2180.00000     60.28125      2.44036      2.52599      8.70567    192.00000      3.17578      2.56641     11.42188      0.08144      0.00033      0.14776      2.76172      2.57073      0.16338
   2180.50000     62.37500      2.45288      2.28624      4.22983    191.37500      5.13672      3.12109     11.42188      0.10484     -0.00573      0.17190      2.80664      2.53073      0.18807
   2181.00000     71.12500      2.33078      2.06439      2.39143    191.12500      2.46875      2.13672     11.57813      0.13053     -0.01145      0.21894      2.94336      2.48679      0.21930
   2181.50000     79.93750      2.17465      1.87022      1.81394    190.62500      2.06641      1.60059     11.67969      0.16589     -0.00585      0.27402      2.98633      2.42633      0.25804
   2182.00000     84.56250      2.07541      1.76995      1.65916    190.50000      1.53418      1.31445     11.81250      0.18879     -0.00162      0.35821      2.90039      2.38717      0.28923
   2182.50000     82.75000      2.02626      1.84670      1.55986    190.75000      0.47998      0.74170     11.86719      0.22088      0.00685      0.37502      2.75586      2.33230      0.33153
   2183.00000     76.81250      2.00180      2.08883      1.82654    191.75000      1.04004      0.99219     11.72656      0.20312      0.01329      0.30812      2.81641      2.36266      0.31243
   2183.50000     73.25000      2.03551      2.28212      2.26682    193.25000      2.36133      1.47559     10.99219      0.16781      0.02748      0.22747      2.89258      2.42304      0.24191
   2184.00000     73.43750      2.15527      2.29663      3.22401    195.75000      9.17969      5.16016     10.61719      0.09375      0.03484      0.19915      3.07031      2.54969      0.21995
   2184.50000     73.56250      2.36557      2.35759      3.06703    197.87500      3.20313      2.78125     10.75000      0.06162      0.03177      0.22153      3.25000      2.60463      0.22611
   2185.00000     79.31250      2.56781      2.58438      3.13379    200.00000      4.17578      2.26172     10.83594      0.05747      0.00562      0.22168      3.41406      2.61173      0.24128
   2185.50000     75.12500      2.64767      2.68023      3.24129    201.12500      2.54883      2.67383     10.96094      0.05293      0.00293      0.21455      3.66016      2.61949      0.22727
   2186.00000     82.56250      2.55347      2.52913      3.52059    201.25000      7.81641      4.78125     11.02344      0.03920      0.00410      0.22188      3.37695      2.64297      0.23382
   2186.50000     83.56250      2.29884      2.27237      3.18328    200.50000      3.45703      2.52930     11.13281      0.05848     -0.00538      0.23465      3.58789      2.61000      0.26742
   2187.00000     90.68750      2.07376      2.03183      2.83150    198.25000      3.17578      2.11914     11.26563      0.07487     -0.00563      0.28608      3.75977      2.58197      0.29483
   2187.50000     88.12500      1.92414      1.75280      2.37919    195.37500      2.98828      1.99414     11.75000      0.16727     -0.00169      0.33304      2.96875      2.42397      0.33699
   2188.00000     91.18750      1.74765      1.60233      1.89703    192.62500      0.43994      0.70605     13.08594      0.26031     -0.00131      0.35221      2.71289      2.26487      0.35846
   2188.50000     94.00000      1.59698      1.56597      2.03423    190.62500      0.34619      0.50879     13.34375      0.30587     -0.00732      0.33337      2.44141      2.18696      0.35007
   2189.00000    101.12500      1.53928      1.47886      1.99005    190.25000      1.04004      0.88477     12.30469      0.30640      0.00908      0.34573      2.58594      2.18605      0.33449
   2189.50000     91.37500      1.47331      1.44040      1.87468    192.50000      1.25391      0.83105     12.19531      0.28774      0.01265      0.34553      2.58594      2.21797      0.34244
   2190.00000     91.62500      1.43997      1.47619      1.62614    194.62500      1.29395      0.93848     12.02344      0.26812      0.00939      0.35240      2.58398      2.25152      0.32753
   2190.50000     86.00000      1.50390      1.53834      1.73236    196.12500      2.05469      1.45703     11.71875      0.21870      0.02538      0.33944      2.82031      2.33602      0.33990
   2191.00000     90.12500      1.56224      1.61674      1.75041    199.25000      1.61426      1.33203     11.87500      0.16028      0.03853      0.32725      2.88086      2.43592      0.33413
   2191.50000     89.81250      1.61444      1.71232      1.87875    199.75000      2.12109      1.54688     11.77344      0.15205      0.02121      0.30949      2.97461      2.45000      0.31404
   2192.00000     88.37500      1.81087      1.80787      2.10578    200.25000      4.07031      2.17188     11.72656      0.11388      0.03908      0.29014      3.26563      2.51526      0.29347
   2192.50000     90.00000      2.06530      1.98639      2.19283    201.37500      1.64160      1.83301     11.68750      0.10081      0.02048      0.28320      3.27344      2.53762      0.27620
   2193.00000     84.31250      2.33535      2.30500      2.36709    201.62500      2.52148      1.56445     11.42188      0.08747     -0.00182      0.24811      3.49219      2.56042      0.25258
   2193.50000     77.31250      2.69330      2.67531      2.76673    202.25000      3.83008      2.74414     11.30469      0.05962      0.00447      0.20383      4.03516      2.60805      0.21589
   2194.00000     73.25000      3.00092      3.01355      3.57048    202.75000      3.72266      2.92383     11.35156      0.02727      0.00785      0.18522      4.25000      2.66337      0.19046
   2194.50000     68.93750      3.20779      3.31072      4.39587    203.12500      7.48828      3.94336     11.27344      0.01950      0.00075      0.18073      4.13672      2.67666      0.18488
   2195.00000     72.68750      3.46342      3.58222      4.86638    203.87500      5.04297      3.33594     11.27344      0.01707      0.00576      0.19730      3.94531      2.68080      0.18312
   2195.50000     82.81250      3.53259      3.67004      5.16128    204.87500      5.94922      3.72852     11.27344      0.01819      0.01190      0.20786      3.59180      2.67889      0.20521
   2196.00000     88.00000      3.39672      3.45738      4.72197    205.25000      2.80273      2.78125     11.35156      0.03543      0.00674      0.23951      3.40234      2.64941      0.22221
   2196.50000     86.06250      3.21245      3.11133      4.17723    205.62500      5.63281      3.53320     11.39063      0.05034      0.00017      0.23932      3.16016      2.62391      0.25252
   2197.00000     74.00000      2.92681      2.80235      3.30146    205.37500      3.73438      2.42383     11.46094      0.05892      0.00191      0.23284      3.16602      2.60925      0.26017
   2197.50000     76.93750      2.65415      2.52160      2.82885    204.25000      2.78711      2.08203     11.50781      0.06805     -0.00327      0.23389      3.24219      2.59363      0.26583
   2198.00000     83.75000      2.49429      2.20637      2.64684    201.62500      3.12109      2.24414     11.57813      0.09694     -0.00028      0.25359      3.03906      2.54424      0.26926
   2198.50000     92.62500      2.35762      2.07077      2.35419    199.75000      2.00000      1.65430     11.69531      0.15373     -0.00661      0.27273      2.95508      2.44713      0.28330
   2199.00000     96.68750      2.29090      2.08191      1.97639    197.37500      1.41406      0.95605     11.80469      0.20162     -0.00226      0.31599      2.74219      2.36524      0.27782
   2199.50000     98.93750      2.26319      2.17263      2.26088    196.50000      1.66699      1.43945     11.86719      0.21500      0.00816      0.30704      2.88672      2.34236      0.30133
   2200.00000     92.50000      2.14307      2.29090      2.76546    197.37500      0.67969      1.00977     12.32031      0.19210      0.01290      0.28227      3.07227      2.38150      0.28175
   2200.50000     82.56250      2.05296      2.22975      3.21203    196.25000      3.53711      1.90430     11.63281      0.14846      0.02534      0.24805      3.22266      2.45614      0.26096
   2201.00000     77.93750      2.07082      2.07375      3.08897    196.00000      5.07031      3.20898     11.58594      0.10161      0.05104      0.23692      3.07422      2.53625      0.26140
   2201.50000     83.87500      2.04170      2.01876      2.58241    195.25000      1.10742      1.11719     11.81250      0.12287      0.03017      0.26533      3.03125      2.49990      0.27112
   2202.00000     93.93750      2.08651      1.91757      2.15455    193.62500      2.36133      1.79688     11.87500      0.15619      0.03393      0.27570      2.83203      2.44292      0.28772
   2202.50000     93.62500      2.13385      1.81346      1.89168    193.12500      1.76074      1.54688     12.17969      0.21099      0.03254      0.28540      2.70898      2.34921      0.29534
   2203.00000     84.06250      1.99840      1.87232      1.65779    193.00000      0.35938      0.70605     13.03125      0.25244      0.00851      0.27420      2.62109      2.27832      0.27492
   2203.50000     79.81250      1.86434      1.95921      1.74184    192.87500      1.49414      1.04590     12.20313      0.24546      0.00613      0.24306      2.83984      2.29027      0.26781
   2204.00000     79.00000      1.72467      1.86150      1.89050    193.75000      1.41309      1.25977     12.07813      0.20446      0.01559      0.26737      3.30664      2.36038      0.26851
   2204.50000     86.56250      1.56534      1.61252      2.16148    193.37500      2.00000      1.67188     12.17969      0.19090      0.00429      0.32574      2.66602      2.38355      0.31083
   2205.00000     85.93750      1.56575      1.37262      1.71467    191.25000      1.08008      1.20605     12.43750      0.32953     -0.01060      0.41941      2.32813      2.14650      0.37301
   2205.50000     87.00000      1.65958      1.33206      1.30362    189.62500      0.66650      0.65234     13.70313      0.48164     -0.01899      0.41224      1.99316      1.88640      0.43733
   2206.00000     90.87500      1.65852      1.53450      1.10233    189.50000      0.47998      0.45557     14.71094      0.51808     -0.02570      0.33805      1.96777      1.82409      0.34848
   2206.50000     92.12500      1.62174      1.78295      1.30531    191.25000      1.12012      0.59863     12.35156      0.45142     -0.02466      0.25922      2.41602      1.93807      0.26577
   2207.00000     92.56250      1.57261      1.76524      1.78345    193.37500      2.38672      1.77930     11.80469      0.26587     -0.00371      0.23103      2.64453      2.25537      0.23372
   2207.50000     85.50000      1.52436      1.64662      2.01123    195.37500      1.89453      1.69043     11.78906      0.17400     -0.00121      0.23675      2.65430      2.41246      0.22935
   2208.00000     86.81250      1.59319      1.62445      1.84945    195.25000      1.58789      1.40332     11.71875      0.16675     -0.00864      0.24925      2.65625      2.42486      0.23556
   2208.50000     85.00000      1.76904      1.69884      1.66326    194.87500      1.68066      1.42188     11.71875      0.17349     -0.00982      0.24305      2.61523      2.41334      0.24451
   2209.00000     82.75000      1.92509      1.80852      1.65870    194.87500      1.94824      1.43945     11.71875      0.16857     -0.00696      0.23748      2.64258      2.42175      0.23162
   2209.50000     80.75000      2.11216      1.92457      1.70308    194.62500      2.13477      1.58203     11.58594      0.15687     -0.00335      0.21370      2.56055      2.44175      0.21926
   2210.00000     76.75000      2.35714      2.10367      1.72347    194.37500      2.50781      1.90430     11.35938      0.14669      0.00073      0.20349      2.64648      2.45916      0.19461
   2210.50000     80.12500      2.56444      2.40914      1.85512    194.00000      2.38672      1.94043     11.21094      0.14183     -0.00273      0.18656      2.77734      2.46748      0.18087
   2211.00000     79.31250      2.81949      2.77722      2.31542    193.50000      2.36133      2.08203     11.03906      0.13510     -0.00204      0.16978      2.86523      2.47898      0.16977
   2211.50000     82.50000      3.23363      3.08979      3.25350    193.50000      2.62695      2.27930     10.87500      0.12176      0.00051      0.16092      2.91406      2.50180      0.16206
   2212.00000     74.37500      3.72464      3.44237      4.33287    193.50000      2.78906      2.42188     10.82813      0.10991     -0.00113      0.15994      2.83594      2.52205      0.15902
   2212.50000     67.31250      4.31956      4.05062      5.02824    194.00000      3.08203      2.45703     10.80469      0.10278     -0.00445      0.15510      2.93555      2.53424      0.16204
   2213.00000     64.18750      4.93717      4.80076      5.68537    194.50000      3.22852      2.58398     10.69531      0.09122     -0.00361      0.15539      3.17188      2.55401      0.15698
   2213.50000     67.06250      5.20384      5.09880      6.27538    195.12500      3.08203      2.69141     10.67969      0.08133     -0.00179      0.15435      3.16602      2.57093      0.15630
   2214.00000     71.31250      4.99687      4.92783      6.01927    195.50000      3.14844      2.63867     10.64063      0.07165     -0.00057      0.18733      3.41016      2.58748      0.15989
   2214.50000     72.56250      4.50653      4.64866      5.00742    195.62500      3.22852      2.67383     10.53125      0.08000     -0.00124      0.19708      3.29102      2.57321      0.18870
   2215.00000     65.43750      3.87925      4.21690      4.44107    195.50000      3.77539      2.99609     10.42969      0.07637     -0.00095      0.18553      3.41602      2.57940      0.19618
   2215.50000     56.21875      3.33915      3.54775      4.75166    195.25000      6.28516      3.49609     10.38281      0.06143      0.00667      0.15963      3.47070      2.60495      0.19617
   2216.00000     54.21875      3.02147      2.83421      4.05129    195.00000      7.04297      4.26563     10.38281      0.05255      0.02960      0.18588      3.07227      2.62014      0.19906
   2216.50000     69.31250      2.92474      2.44749      2.93030    195.25000      3.58984      2.78125     10.45313      0.09664      0.04572      0.27797      2.76563      2.54474      0.24002
   2217.00000     81.62500      2.93145      2.41775      2.01861    196.12500      1.50781      1.36719     10.72656      0.15913      0.04575      0.31539      2.45898      2.43789      0.28776
   2217.50000     81.31250      2.88262      2.73923      2.03218    198.12500      0.52002      0.92090     11.51563      0.17808      0.03216      0.27217      2.57422      2.40548      0.26942
   2218.00000     73.31250      2.72560      3.05939      2.71822    199.25000      3.73633      2.47656     10.50781      0.13434      0.04429      0.19442      3.12891      2.48028      0.21217
   2218.50000     67.00000      2.58515      2.96903      3.88223    201.00000      6.04688      4.48047     10.38281      0.04385      0.05794      0.16299      3.46094      2.63502      0.18314
   2219.00000     73.81250      2.55847      2.79240      5.68537    202.12500      5.32422      5.05078     10.45313     -0.00090      0.04196      0.17964      3.64844      2.71154      0.18447
   2219.50000     83.87500      2.72008      2.71663      4.47062    201.87500      4.65625      3.17383     10.53125      0.01046      0.01202      0.19557      3.37695      2.69211      0.19894
   2220.00000     92.93750      3.01002      2.79240      3.67909    201.25000      3.56250      2.42188     10.51563      0.04404      0.01235      0.20356      3.36914      2.63469      0.20017
   2220.50000     92.31250      3.24328      2.97420      3.21715    200.87500      3.14844      2.34961     10.50000      0.07351      0.00354      0.19875      2.99414      2.58430      0.19547
   2221.00000     83.31250      3.38937      3.22459      3.46213    201.25000      4.87109      2.90625     10.46875      0.08989     -0.00561      0.17496      3.13867      2.55630      0.18329
   2221.50000     72.25000      3.46163      3.51153      4.04858    201.75000      4.33594      3.06641     10.46094      0.07584     -0.00876      0.16744      3.35547      2.58031      0.16501
   2222.00000     70.43750      3.52143      3.75809      5.11760    202.37500      7.09766      4.60547     10.38281      0.05631      0.00202      0.15077      3.66406      2.61371      0.16329
   2222.50000     70.56250      3.69194      3.93527      6.53302    203.12500      7.59375      5.82031     10.38281      0.03209      0.00153      0.16343      3.83984      2.65513      0.15481
   2223.00000     75.50000      4.02299      4.12965      6.82039    204.37500      6.28516      4.33594     10.38281      0.02380      0.00790      0.18244      3.86133      2.66930      0.16710
   2223.50000     67.06250      4.45637      4.46707      6.51893    205.25000      7.75000      5.03516     10.28906      0.00980      0.01228      0.19572      3.95117      2.69324      0.18118
   2224.00000     57.59375      4.84187      4.88169      6.42200    205.75000      9.77344      4.23047     10.23438      0.00744      0.01464      0.19407      3.78711      2.69728      0.18574
   2224.50000     49.71875      5.20000      5.17718      6.65525    206.37500     29.40625     18.54688     10.22656      0.00727      0.00959      0.15850      3.71289      2.69757      0.17688
   2225.00000     45.96875      5.45095      5.43007      6.42883    206.62500     11.32031      6.62500     10.22656      0.00571      0.00654      0.13410      4.02344      2.70023      0.15565
   2225.50000     50.28125      5.67386      5.70547      6.43567    207.00000      8.48438      4.89063     10.22656      0.00070     -0.00240      0.11758      4.39844      2.70880      0.13473
   2226.00000     51.34375      5.97292      5.88834      7.67770    207.75000     14.32813     10.25781     10.22656     -0.02009     -0.00427      0.11228      4.44531      2.74436      0.12284
   2226.50000     57.34375      6.22026      6.14376      8.93727    208.12500      6.81641      5.28516     10.22656     -0.02991     -0.00321      0.11795      4.45313      2.76114      0.11980
   2227.00000     53.21875      6.62284      6.54623     10.45102    208.12500     15.45313     10.56250     10.23438     -0.04291     -0.00627      0.11379      4.76172      2.78337      0.12114
   2227.50000     54.84375      7.16413      7.04198     10.82520    207.87500     11.12500      7.98828     10.28125     -0.03626     -0.00461      0.11627      5.42578      2.77201      0.12144
   2228.00000     53.65625      7.58113      7.61807     12.32564    207.62500      8.75000      6.78516     10.38281     -0.04722      0.00079      0.11619      5.56641      2.79074      0.12559
   2228.50000     59.84375      8.17866      7.97566     13.44964    207.25000      9.46875      7.28906     10.38281     -0.03838      0.00320      0.12545      5.02344      2.77563      0.12349
   2229.00000     61.25000      8.49651      8.55824     14.90868    206.62500      8.10938      7.84375     10.39063     -0.02912     -0.00096      0.11402      4.50391      2.75979      0.12567
   2229.50000     56.21875      8.34558      9.10447     17.14963    205.75000      7.04688      5.64063     10.50781     -0.03280     -0.00593      0.09109      4.37500      2.76608      0.10822
   2230.00000     52.12500      7.77506      8.80825     20.73717    204.50000     18.85938     14.19531     10.53125     -0.04981     -0.00600      0.07485      4.24609      2.79517      0.09105
   2230.50000     49.00000      6.67414      7.66241     18.74445    202.87500     15.17188     12.11719     10.53125     -0.07427     -0.00873      0.06971      4.63672      2.83700      0.09222
   2231.00000     53.18750      5.32552      6.16544     13.75560    201.12500     10.70313      5.30469     10.53125     -0.07474     -0.01347      0.08746      4.89844      2.83780      0.09974
   2231.50000     63.21875      4.37237      4.53919      8.23164    199.12500     11.66406      9.02344     10.53125     -0.04467     -0.01127      0.10873      4.29688      2.78638      0.12265
   2232.00000     73.06250      3.55511      3.42977      4.63511    197.87500      7.87109      6.37891     10.67188      0.00677     -0.00877      0.14543      3.82422      2.69843      0.15515
   2232.50000     86.56250      2.92615      2.77345      2.75287    196.50000      3.32227      2.02930     10.76563      0.07330     -0.01059      0.18797      3.10156      2.58465      0.19694
   2233.00000     93.00000      2.52804      2.35048      2.23912    196.37500      3.18750      2.15430     10.87500      0.11726     -0.00398      0.23274      2.88867      2.50948      0.22700
   2233.50000     90.25000      2.21956      2.08623      1.92542    197.25000      1.14648      1.42188     11.03906      0.14878     -0.00065      0.26071      2.68555      2.45559      0.25115
   2234.00000     85.93750      1.97520      1.92791      2.02199    197.12500      2.00000      1.60059     11.12500      0.16006     -0.00110      0.26653      2.61523      2.43630      0.25927
   2234.50000     76.43750      1.83028      1.82909      2.18097    197.62500      2.17383      1.67188     11.12500      0.16675     -0.00119      0.26057      2.64063      2.42486      0.26095
   2235.00000     77.56250      1.73435      1.77913      2.45851    197.25000      2.18750      1.68945     11.12500      0.16680     -0.00153      0.24572      2.68359      2.42477      0.25468
   2235.50000     77.43750      1.67287      1.75838      2.63990    196.87500      2.16016      1.72559     11.14063      0.17279     -0.00734      0.22688      2.80273      2.41453      0.23631
   2236.00000     74.00000      1.63128      1.75496      2.89800    196.50000      2.16016      1.72656     11.12500      0.16865     -0.01162      0.21272      3.00195      2.42162      0.22390
   2236.50000     71.87500      1.60780      1.71410      2.90217    196.12500      2.56055      1.92285     11.18750      0.16162     -0.01061      0.22965      2.96484      2.43363      0.22651
   2237.00000     70.87500      1.60982      1.64307      2.35786    196.00000      2.58789      2.08203     11.24219      0.16219     -0.00157      0.26089      2.90234      2.43266      0.25454
   2237.50000     79.18750      1.64961      1.60676      1.88168    195.62500      1.89453      1.61816     11.31250      0.17238     -0.00156      0.28896      2.68359      2.41524      0.28761
   2238.00000     90.12500      1.71871      1.65377      1.58231    195.75000      1.21387      1.29590     11.38281      0.18680      0.00578      0.29910      2.66797      2.39057      0.29203
   2238.50000     96.81250      1.79907      1.77247      1.51606    196.50000      1.22656      1.24219     11.37500      0.17772      0.01359      0.28399      2.66016      2.40611      0.28255
   2239.00000    102.81250      1.88620      1.93275      1.68364    197.62500      2.14844      1.58301     11.28906      0.16871      0.01296      0.24769      2.77539      2.42150      0.25414
   2239.50000    104.56250      2.01065      2.10896      2.03355    199.25000      1.58789      1.56445     11.15625      0.14176      0.00690      0.21775      2.81250      2.46759      0.21628
   2240.00000    104.43750      2.23632      2.32512      2.56488    200.50000      3.10742      2.42188     10.98438      0.12060      0.00458      0.20391      2.89844      2.50378      0.19621
   2240.50000     96.56250      2.57837      2.63792      2.95319    201.50000      3.86914      2.83398     10.96094      0.11295      0.00132      0.18778      3.02734      2.51686      0.18815
   2241.00000     83.81250      3.03985      3.11227      3.35830    202.50000      3.50977      2.74414     10.82813      0.10794     -0.00268      0.17306      3.17969      2.52543      0.16492
   2241.50000     72.06250      3.56785      3.71623      4.10353    203.12500      6.75391      4.31641     10.61719      0.09775     -0.00243      0.14535      3.29492      2.54285      0.14948
   2242.00000     70.25000      3.97769      4.33663      5.03242    203.50000      5.91016      4.44531     10.39844      0.07025      0.00183      0.12755      3.36719      2.58987      0.13466
   2242.50000     68.31250      4.25266      4.72886      6.42883    203.75000      8.06250      6.41406     10.32031      0.04569      0.00236      0.11405      3.49219      2.63186      0.12986
   2243.00000     73.62500      4.51430      4.69900      6.75940    203.75000      7.03125      6.96484     10.32031      0.03122     -0.00338      0.12509      3.83789      2.65662      0.13277
   2243.50000     70.87500      4.65583      4.54712      6.23655    203.75000      6.19141      5.16016     10.36719      0.02615     -0.00689      0.14790      3.82813      2.66528      0.15016
   2244.00000     74.81250      4.94118      4.36394      5.01989    204.00000      7.12500      4.65625     10.34375      0.03051     -0.00117      0.19528      3.67969      2.65782      0.16989
   2244.50000     73.31250      5.35605      4.47668      4.85856    204.50000      5.79297      4.26563     10.35938      0.04155     -0.00391      0.21190      3.75781      2.63895      0.19832
   2245.00000     70.68750      5.58751      5.14402      5.22370    205.12500      3.34766      2.65625     10.31250      0.04830     -0.00562      0.18664      4.00781      2.62740      0.18165
   2245.50000     60.87500      5.70989      6.21660      7.27148    206.00000      6.12500      3.72852     10.16406      0.02226     -0.00164      0.11614      5.07031      2.67193      0.13148
   2246.00000     48.21875      6.08355      6.76549     11.46126    206.75000     19.50000     17.89063     10.08594     -0.01954      0.00739      0.07382      5.26953      2.74341      0.09157
   2246.50000     42.43750      6.68245      7.08468     16.09947    207.37500     20.57813     25.75000     10.08594     -0.05220      0.00179      0.05972      5.00781      2.79927      0.07831
   2247.00000     41.40625      7.98045      8.25031     15.44168    207.75000      8.29688      7.21875     10.06250     -0.05432     -0.00361      0.05258      4.71094      2.80289      0.06708
   2247.50000     37.34375     10.46407     10.74169     17.10113    208.25000     18.25000     15.92969      9.92969     -0.06594     -0.00186      0.03189      4.62109      2.82276      0.05441
   2248.00000     31.26563     13.56111     14.28866     21.94107    208.25000     14.28125     12.28125      9.92969     -0.08475      0.00144      0.01463      5.74609      2.85492      0.03664
   2248.50000     23.03125     16.22027     19.64922     37.18919    208.37500     21.15625     22.20313      9.92969     -0.10941      0.00096      0.00324      6.20313      2.89709      0.01751
   2249.00000     19.98438     20.47510     26.03460     64.60429    208.25000     40.43750     36.40625      9.92969     -0.12255      0.00151     -0.00386      6.33984      2.91957     -0.00003
   2249.50000     16.95313     26.78658     36.30933    156.65717    208.00000     76.75000     90.50000      9.92969     -0.13908      0.00392     -0.00695      5.46875      2.94783     -0.00971
   2250.00000     14.04688     33.72502     47.22097    629.89429    207.62500     92.68750    148.87500      9.92969     -0.15129      0.00321     -0.00743      5.59766      2.96870     -0.01230
   2250.50000     12.99219     39.82969     63.10459   1923.65649    207.62500     99.31250    145.25000      9.92969     -0.15215      0.00176     -0.00524      5.66797      2.97017     -0.01087
   2251.00000     13.96875     36.72221     70.60023   2000.00000    207.50000    103.75000    157.12500      9.92969     -0.15275      0.00003     -0.00115      6.42188      2.97121     -0.00440
   2251.50000     15.92969     26.91237     51.29955    916.21167    207.25000     91.87500    150.37500      9.92969     -0.14575     -0.00124      0.00474      5.57813      2.95924      0.00708
   2252.00000     19.00000     18.31894     29.00811    293.54230    206.87500    100.06250    125.06250      9.92969     -0.13768     -0.00529      0.01118      6.51172      2.94543      0.02592
   2252.50000     23.95313     13.73282     15.31904    110.75026    206.00000     43.84375     40.59375      9.92969     -0.12617     -0.00500      0.03665      5.74219      2.92575      0.04837
   2253.00000     35.87500     12.03656      9.12020     36.29628    205.25000     85.25000    111.62500      9.96094     -0.09123     -0.00166      0.12440      4.71484      2.86601      0.08642
   2253.50000     50.96875     11.93497      7.42466     16.22909    204.12500     17.84375     23.95313     10.07031     -0.01903      0.00056      0.17198      3.91602      2.74255      0.14070
   2254.00000     52.15625     11.70923      8.46893     11.88942    203.37500      8.59375      4.23047     10.10156      0.02244     -0.00140      0.14499      3.64258      2.67162      0.13443
   2254.50000     42.34375     11.28382     11.37643     13.15701    203.12500     13.34375      7.30859     10.01563      0.02122      0.00024      0.05036      4.65234      2.67372      0.06667
   2255.00000     26.26563     10.67847     13.89593     27.66222    203.25000     84.62500    101.31250      9.92969     -0.05868      0.01385      0.01052      5.81641      2.81035      0.03065
   2255.50000     20.12500     10.43983     13.33713     61.32822    203.87500     73.50000     94.18750      9.92969     -0.12107      0.02220      0.01253      6.08984      2.91703      0.02623
   2256.00000     21.04688     11.24274     14.08023     61.32822    204.87500     43.96875     57.28125      9.92969     -0.13988      0.00809      0.02602      5.76172      2.94919      0.03815
   2256.50000     23.98438     13.18284     15.61163     40.42087    205.50000     28.28125     19.67188      9.92969     -0.11483      0.00133      0.04236      5.86328      2.90636      0.05243
   2257.00000     30.00000     13.47451     16.10851     38.86222    205.87500     24.53125     29.68750      9.92969     -0.10605     -0.00057      0.04664      5.87500      2.89135      0.06327
   2257.50000     30.07813     11.18841     13.13895     40.15247    206.37500     23.60938     19.39063      9.93750     -0.10535      0.00307      0.05376      5.60938      2.89015      0.06983
   2258.00000     35.28125      9.06537      9.32141     29.55504    206.12500     29.28125     26.59375     10.00000     -0.09827      0.00688      0.08492      4.97656      2.87804      0.08869
   2258.50000     42.31250      7.36811      6.88968     14.90868    205.50000     14.14063     11.81250     10.07031     -0.07718      0.00671      0.12575      4.47266      2.84197      0.12484
   2259.00000     55.28125      5.88539      5.67762      9.63505    204.25000      5.39063      3.58594     10.14844     -0.04770      0.00107      0.13872      4.29297      2.79156      0.15681
   2259.50000     63.93750      5.03734      4.60547      8.45020    202.62500      7.98047      4.30078     10.21094     -0.03455      0.00768      0.15544      4.01953      2.76909      0.16206
   2260.00000     73.87500      4.65452      3.78145      8.50965    200.50000     13.03906      8.28906     10.22656      0.00039      0.01029      0.20887      3.70898      2.70934      0.18387
   2260.50000     74.93750      4.42087      3.57230      7.26274    198.87500      1.76074      2.19141     10.36719      0.05590      0.00844      0.28400      3.33398      2.61442      0.22710
   2261.00000     75.87500      4.37885      3.92483      6.56137    197.50000      2.89453      1.94043     10.39844      0.10940      0.01060      0.28232      3.05469      2.52292      0.26806
   2261.50000     70.93750      4.46663      4.50577      7.20219    197.50000      1.80078      2.20703     10.39063      0.11804      0.01070      0.22320      3.12305      2.50814      0.22304
   2262.00000     67.93750      4.53207      4.88856      8.95050    197.37500      5.30859      3.31641     10.23438      0.08804      0.01243      0.17791      3.49414      2.55945      0.18260
   2262.50000     61.15625      4.93437      5.02515     11.29007    197.75000      4.69531      4.15625     10.21875      0.03989      0.01368      0.17896      4.18359      2.64179      0.16979
   2263.00000     54.31250      6.11328      5.59266     10.13570    198.50000      4.54688      3.19336     10.22656      0.02685      0.00750      0.16932      4.30469      2.66408      0.16624
   2263.50000     49.28125      7.69729      7.22582      9.22355    199.25000      8.14844      4.05078     10.16406      0.02991     -0.00497      0.11632      4.26953      2.65885      0.12728
   2264.00000     43.43750      9.49202     10.00049     11.24806    199.62500     30.09375     20.09375     10.08594      0.00818     -0.00616      0.04868      4.63672      2.69601      0.07038
   2264.50000     33.34375     10.99476     12.80586     22.10146    200.00000     94.62500    111.62500     10.08594     -0.05672      0.00691      0.01289      5.32422      2.80699      0.03446
   2265.00000     25.23438     11.22263     14.25031     49.72830    200.25000     47.65625     50.46875     10.08594     -0.10671      0.00895      0.00674      5.89063      2.89247      0.02392
   2265.50000     21.00000     11.16400     13.52411    101.45911    200.62500     97.18750    106.43750     10.10156     -0.13239      0.00472      0.01373      5.08203      2.93639      0.02979
   2266.00000     24.82813     12.46990     11.03274     59.51734    200.87500     91.68750    152.25000     10.22656     -0.12725      0.00338      0.04893      4.59766      2.92759      0.05421
   2266.50000     31.85938     12.45481      9.48032     27.66222    200.87500     11.72656     12.72656     10.22656     -0.10448      0.00033      0.09568      4.53125      2.88867      0.09645
   2267.00000     46.00000     11.18198      8.70653     16.58519    200.75000      7.69922      4.49609     10.28906     -0.06222     -0.00849      0.15955      4.80078      2.81640      0.12243
   2267.50000     55.15625      9.86583      8.11693     13.30171    199.75000     16.68750      8.39844     10.36719     -0.02137     -0.00363      0.16659      4.75781      2.74654      0.15683
   2268.00000     58.21875      7.52043      7.88023     13.07168    198.37500      3.76172      3.31641     10.38281      0.00511     -0.00567      0.13773      4.85547      2.70127      0.15115
   2268.50000     54.31250      5.55226      6.73513     17.96482    197.00000      9.07031      4.98047     10.38281     -0.00206     -0.00776      0.09101      5.29688      2.71351      0.13597
   2269.00000     51.12500      4.89532      4.33301     18.40219    195.87500     57.21875     45.21875     10.38281     -0.00503      0.00854      0.16469      3.27734      2.71860      0.15031
   2269.50000     57.06250      4.94078      3.26762     10.67236    195.37500     35.00000     44.81250     10.48438      0.14644     -0.00418      0.25915      2.71484      2.45959      0.23306
   2270.00000     69.75000      4.98161      3.49132      5.48427    197.75000      0.73340      1.00977     10.96875      0.29232     -0.03256      0.31160      2.19531      2.21013      0.28484
   2270.50000     80.81250      5.07871      4.72886      6.57564    199.50000      1.02637      0.88477     10.82813      0.31861     -0.03041      0.26092      2.44727      2.16518      0.27766
   2271.00000     80.00000      4.94815      5.20038      8.35677    202.50000     10.72656      7.25391     10.82813      0.25086     -0.00575      0.23351      2.94141      2.28102      0.23339
   2271.50000     74.00000      4.49118      4.79855      8.59431    204.50000      3.65625      3.24609     10.82813      0.14828      0.00551      0.25883      2.91211      2.45644      0.22758
   2272.00000     68.00000      4.77117      4.76781      7.12581    204.50000      5.64063      3.42383     10.82813      0.13516      0.00651      0.27743      2.76563      2.47888      0.23329
   2272.50000     61.03125      6.13580      5.77152      6.17289    205.00000      3.76367      3.08398     10.78125      0.12186      0.00530      0.20396      2.76367      2.50163      0.20381
   2273.00000     47.06250      7.73929      8.05490      7.43235    205.87500      5.45703      4.21094     10.42188      0.06258      0.01146      0.08425      3.19727      2.60298      0.07957
   2273.50000     31.04688      9.77591     10.90771     16.36082    206.25000     32.56250     29.01563     10.21875     -0.03516      0.01873      0.00441      4.43359      2.77013      0.02170
   2274.00000     22.95313     13.38441     14.15532     42.70453    206.25000     40.87500     51.31250     10.09375     -0.13192      0.03292     -0.00267      5.35156      2.93559      0.00295
   2274.50000     18.06250     18.87793     20.01868     79.98627    206.12500     29.90625     35.28125     10.08594     -0.14851      0.00457     -0.00310      5.65625      2.96395     -0.00203
   2275.00000     19.23438     26.01497     32.34924     95.07803    206.25000     33.93750     33.43750     10.08594     -0.14458     -0.00997     -0.00348      5.82422      2.95723     -0.00175
   2275.50000     15.24219     28.57524     46.20049    135.58218    206.25000     48.21875     58.06250     10.08594     -0.14716     -0.01528     -0.00261      6.27344      2.96164      0.00003
   2276.00000     19.28125     20.43938     33.46465    219.09305    206.12500     55.53125     48.12500     10.08594     -0.15086     -0.01049      0.00350      6.33594      2.96797      0.00918
   2276.50000     23.17188     12.48902     17.42867    179.96927    205.62500     62.75000     68.25000     10.08594     -0.13592     -0.00741      0.02150      5.78125      2.94242      0.02960
   2277.00000     43.09375      8.12952      9.40438     50.55988    205.50000     34.06250     40.18750     10.18750     -0.09939     -0.00183      0.08094      4.83984      2.87996      0.06906
   2277.50000     62.00000      6.42233      5.57478     15.24700    205.12500     20.20313     16.82813     10.21875     -0.04762      0.00937      0.16558      4.00000      2.79143      0.13563
   2278.00000     81.12500      5.95590      4.06811      7.59096    205.37500     12.12500      4.37109     10.29688      0.01498      0.01259      0.27130      3.56250      2.68439      0.21478
   2278.50000     86.50000      5.75921      3.90118      5.61151    205.87500      1.32031      1.90430     10.38281      0.08708      0.01118      0.30159      3.34766      2.56110      0.27127
   2279.00000     81.56250      5.42800      4.58115      5.71222    206.62500      1.92090      1.51074     10.39063      0.10437      0.00754      0.24811      3.62695      2.53154      0.23920
   2279.50000     68.50000      5.14719      5.42725      7.41412    207.50000      7.11328      4.28125     10.17969      0.07801      0.00738      0.14875      4.18359      2.57660      0.16117
   2280.00000     58.03125      4.97849      5.81317     14.62031    208.00000     16.92188     12.18750     10.08594      0.00177      0.01128      0.10179      4.88672      2.70698      0.11558
   2280.50000     48.87500      5.30112      6.10087     20.88039    208.50000     13.66406     11.11719     10.08594     -0.04812      0.00916      0.09539      5.12500      2.79229      0.10554
   2281.00000     49.81250      6.48390      6.90326     18.51488    208.62500     17.12500     11.56250     10.08594     -0.05354      0.00042      0.09623      4.99609      2.80155      0.09991
   2281.50000     44.81250      8.04073      8.27621     17.19841    208.62500      7.72656      5.50000     10.08594     -0.04270     -0.00424      0.07993      4.56641      2.78301      0.09585
   2282.00000     45.68750      8.65242      9.43798     17.96482    208.37500      9.21875      6.71484     10.08594     -0.03151     -0.00834      0.07616      4.23047      2.76388      0.09072
   2282.50000     39.59375      8.30712      8.67076     20.80854    208.00000     29.73438     22.45313     10.08594     -0.03298     -0.00992      0.10741      3.12305      2.76640      0.10728
   2283.00000     36.78125      7.45215      7.17653     20.45657    208.12500     26.51563     13.86719     10.08594     -0.03911     -0.00575      0.16449      2.66602      2.77688      0.15190
   2283.50000     35.00000      6.63173      6.11867     11.26903    208.00000      4.14844      4.12109     10.08594     -0.01509     -0.00736      0.21636      2.04883      2.73580      0.20351
   2284.00000     39.09375      6.17622      5.42725      8.45020    208.75000      4.38672      3.71094     10.09375      0.01628     -0.00764      0.23771      1.99902      2.68217      0.23486
   2284.50000     46.34375      5.94391      4.98673      7.71690    209.50000      4.77734      3.37109     10.18750      0.04746     -0.00518      0.26515      1.94922      2.62885      0.23248
   2285.00000     50.37500      5.83033      4.98673      6.96976    210.75000      5.23047      3.24609     10.20313      0.06242     -0.00385      0.23255      2.36328      2.60326      0.23557
   2285.50000     46.28125      5.70216      5.53936      6.81271    211.75000      3.52344      3.03125     10.22656      0.04798     -0.00387      0.17063      3.07227      2.62796      0.17588
   2286.00000     43.06250      5.63568      6.20924      9.80694    212.75000     27.51563     10.96875     10.22656      0.00763     -0.00247      0.09363      4.28125      2.69695      0.12653
   2286.50000     44.18750      5.73321      6.20924     18.74445    213.00000     13.99219     14.80469     10.22656     -0.05375      0.00606      0.09982      4.97266      2.80192      0.10749
   2287.00000     48.25000      6.22689      5.89828     18.97979    212.87500     17.45313      8.71875     10.22656     -0.04897      0.01444      0.16361      4.08984      2.79374      0.12888
   2287.50000     56.28125      6.97435      6.38302     12.76807    212.50000      8.10156      6.53516     10.32031     -0.01360      0.00264      0.18107      4.12500      2.73326      0.16594
   2288.00000     60.40625      7.50495      7.70727     10.16979    212.12500      6.60547      2.81641     10.19531      0.01329      0.00126      0.16564      4.03125      2.68727      0.15197
   2288.50000     58.50000      7.12738      8.42160     12.93191    211.50000     11.43750      9.17969     10.17188     -0.01296      0.00731      0.09665      5.39844      2.73216      0.13357
   2289.00000     51.40625      6.30122      7.33156     17.34641    210.75000     25.79688     14.76563     10.17969     -0.04024      0.01147      0.08461      5.00391      2.77882      0.10565
   2289.50000     51.46875      5.81044      5.81963     17.49699    209.87500     28.96875     33.37500     10.18750     -0.05130      0.00361      0.11021      4.25781      2.79772      0.12092
   2290.00000     62.46875      6.00568      4.88398     10.37926    208.87500      5.85938      5.64063     10.22656     -0.01424      0.00078      0.16367      3.71289      2.73435      0.14719
   2290.50000     72.37500      6.29041      4.82521      7.11742    207.75000      5.71094      3.33594     10.28125      0.02510     -0.00865      0.18108      3.48438      2.66707      0.17854
   2291.00000     76.12500      6.48053      5.45272      6.32130    207.50000      4.14844      2.99609     10.32813      0.03791     -0.00915      0.16855      3.82813      2.64518      0.16782
   2291.50000     68.00000      6.45575      6.31769      8.08850    206.87500      7.40234      8.39844     10.36719      0.00441      0.00022      0.14589      4.24609      2.70246      0.14556
   2292.00000     57.09375      6.25713      6.97194     12.15225    207.25000     18.20313     11.75781     10.35938     -0.02886     -0.00072      0.12211      5.25000      2.75935      0.13124
   2292.50000     47.00000      6.17356      7.39336     19.59481    207.75000      7.56641      4.98047     10.31250     -0.06045      0.00463      0.10730      5.54688      2.81338      0.12217
   2293.00000     51.09375      6.94942      7.32645     23.65791    208.12500     17.64063     14.97656     10.32031     -0.06346      0.01223      0.11803      5.24609      2.81852      0.12200
   2293.50000     55.15625      8.42949      7.52013     18.12638    208.37500     17.65625     12.93750     10.27344     -0.04273      0.01091      0.14025      4.36328      2.78306      0.13508
   2294.00000     56.84375     10.00375      8.79358     14.48027    208.37500      3.14844      3.63867     10.28906     -0.01538      0.00077      0.13940      4.14844      2.73630      0.14039
   2294.50000     48.65625     11.41487     10.78547     14.87201    208.50000     15.81250      9.41406     10.22656     -0.01952      0.00459      0.12260      4.05469      2.74339      0.11915
   2295.00000     41.62500     12.08499     12.32941     18.92040    208.37500     30.00000     22.60938     10.22656     -0.03766      0.00860      0.09333      4.48438      2.77440      0.10685
   2295.50000     34.00000     11.28906     13.71636     24.82332    207.87500     10.10156      7.84375     10.15625     -0.05385      0.00406      0.06535      4.43359      2.80208      0.08445
   2296.00000     31.21875     10.64857     14.28866     35.65425    207.62500     14.28125     14.42188     10.14063     -0.06276      0.00009      0.03032      4.95313      2.81733      0.06368
   2296.50000     30.28125     10.54377     12.04914     54.18425    207.50000     55.56250     56.87500     10.17969     -0.09804      0.00714      0.04763      5.02734      2.87766      0.05961
   2297.00000     39.34375     10.85648      9.30499     29.55504    207.37500     40.25000     52.31250     10.22656     -0.09780      0.01381      0.10087      4.38672      2.87724      0.08558
   2297.50000     49.15625     11.40216      8.92743     15.09476    207.37500     10.52344     14.28125     10.30469     -0.05917      0.00049      0.14287      4.19922      2.81118      0.13058
   2298.00000     53.93750     11.48016     10.14438     11.59310    207.50000      8.78125      6.62500     10.36719     -0.01801     -0.00709      0.13881      4.08203      2.74079      0.14503
   2298.50000     47.75000     10.14761     10.76353     12.76807    207.62500     11.20313     12.83594     10.35938     -0.02243     -0.00585      0.12010      4.92188      2.74835      0.12491
   2299.00000     44.09375      8.12156      9.80574     15.17050    207.25000     13.98438     11.50781     10.35938     -0.04308     -0.00109      0.10592      5.44922      2.78366      0.11746
   2299.50000     46.12500      6.51341      8.18626     14.83553    206.25000     10.35156      8.42969     10.38281     -0.04958     -0.00907      0.10920      5.19531      2.79477      0.11782
   2300.00000     53.31250      5.36041      6.50970     13.30171    205.25000     14.34375     11.20313     10.36719     -0.04247     -0.00720      0.11231      4.58203      2.78263      0.13259
   2300.50000     55.21875      4.55731      4.68842      8.64345    203.87500      9.19531     10.03906     10.38281     -0.02738     -0.00482      0.16969      3.73438      2.75682      0.15254
   2301.00000     65.31250      4.05373      3.55019      4.77417    202.62500      9.07031      8.07031     10.46875      0.01660      0.00824      0.22075      3.28320      2.68161      0.20316
   2301.50000     71.18750      3.58947      3.13220      2.80004    202.37500      2.93555      1.90430     10.66406      0.08154      0.00215      0.24244      2.92383      2.57057      0.24329
   2302.00000     77.25000      3.13039      3.01976      2.59237    202.25000      2.85547      1.83301     10.76563      0.12620     -0.00150      0.22418      2.76367      2.49420      0.23892
   2302.50000     74.00000      2.70011      2.78176      3.01053    202.87500      3.16211      2.33398     10.82813      0.12376      0.00578      0.20429      2.71289      2.49837      0.22126
   2303.00000     69.87500      2.37785      2.46712      3.76148    202.75000      4.66797      2.58398     10.82813      0.09995      0.01129      0.22125      2.80469      2.53908      0.22108
   2303.50000     68.68750      2.25716      2.21459      3.42100    201.62500      2.49414      2.10156     10.85156      0.09966      0.00454      0.22952      2.69336      2.53957      0.23768
   2304.00000     69.93750      2.28012      2.15821      2.88143    201.12500      2.24219      1.88672     10.88281      0.11742      0.00746      0.23541      2.60938      2.50922      0.23485
   2304.50000     73.18750      2.34573      2.24711      2.52736    201.00000      1.76074      1.51074     10.76563      0.14239      0.00754      0.22298      2.45898      2.46651      0.22999
   2305.00000     76.37500      2.43314      2.38366      2.68324    202.00000      2.89453      2.02930     10.67969      0.14955      0.00610      0.21166      2.54883      2.45426      0.21319
   2305.50000     71.56250      2.50708      2.55454      2.79099    203.25000      2.98828      2.36914     10.67969      0.13290      0.00861      0.20921      2.70313      2.48273      0.20032
   2306.00000     70.68750      2.52407      2.74512      3.15669    203.62500      3.28125      2.47656     10.66406      0.11187      0.00143      0.20212      3.08398      2.51871      0.19417
   2306.50000     65.43750      2.60976      2.81781      3.71526    202.62500      4.06641      3.01367     10.53125      0.08549     -0.00134      0.20310      3.31055      2.56381      0.19099
   2307.00000     69.50000      2.74789      2.77496      3.80408    201.50000      6.60547      5.08594     10.53125      0.07468     -0.00078      0.20790      3.35352      2.58229      0.20371
   2307.50000     67.37500      2.85410      2.80929      3.08267    200.12500      3.12305      2.65625     10.53125      0.08155     -0.00485      0.20445      3.15234      2.57055      0.21942
   2308.00000     63.46875      2.90528      2.92244      2.86504    198.62500      3.65625      2.26172     10.42188      0.08491     -0.00685      0.20195      2.84570      2.56480      0.21684
   2308.50000     61.09375      2.86003      2.87969      2.87731    198.62500      2.65430      2.43945     10.41406      0.07722      0.00197      0.20468      2.65430      2.57795      0.21393
   2309.00000     61.00000      2.69282      2.72898      3.21715    199.62500      3.61719      3.26367     10.49219      0.06789      0.00760      0.22173      2.57031      2.59390      0.22109
   2309.50000     66.00000      2.56294      2.57197      2.86504    201.37500      3.72266      2.63672     10.55469      0.07326      0.00807      0.22892      2.57422      2.58472      0.23843
   2310.00000     69.00000      2.45025      2.47916      2.67375    203.25000      3.12109      2.38672     10.66406      0.08403      0.00919      0.21476      2.75781      2.56630      0.23717
   2310.50000     73.93750      2.33502      2.35376      2.69761    204.00000      3.69531      2.22461     10.67969      0.08892      0.01478      0.21839      2.75391      2.55795      0.22352
   2311.00000     72.87500      2.28179      2.20011      2.71456    203.50000      3.57617      2.74414     10.67969      0.10940      0.01570      0.25353      2.69531      2.52292      0.22863
   2311.50000     74.00000      2.31675      2.13444      2.40092    203.25000      2.53516      1.94043     10.77344      0.13019      0.02313      0.28765      2.56055      2.48737      0.25735
   2312.00000     71.93750      2.40826      2.24113      2.05707    203.12500      1.13379      1.43945     10.97656      0.16431      0.03020      0.29058      2.46875      2.42904      0.27419
   2312.50000     72.00000      2.55253      2.50236      2.06903    203.75000      1.97461      1.68945     10.67188      0.17004      0.01999      0.25598      2.55664      2.41922      0.25054
   2313.00000     65.87500      2.69681      2.83893      2.57580    205.00000      3.70898      2.36914     10.47656      0.15044      0.01240      0.20215      2.80273      2.45274      0.21800
   2313.50000     62.96875      2.86536      3.16015      3.66571    206.25000      4.64453      3.42383     10.32813      0.08718      0.01101      0.17262      3.19531      2.56092      0.18072
   2314.00000     59.00000      3.15937      3.45854      4.78550    207.25000      4.29688      4.01563     10.27344      0.04846      0.00432      0.16208      3.27734      2.62714      0.16446
   2314.50000     60.06250      3.53494      3.81632      5.10464    207.62500      4.50781      3.78320     10.22656      0.03222     -0.01251      0.15671      3.39844      2.65490      0.16029
   2315.00000     59.62500      3.85293      4.23237      5.36268    207.62500      4.77344      4.17578     10.22656      0.03640     -0.01974      0.14336      3.57617      2.64775      0.15287
   2315.50000     63.65625      4.12930      4.34933      6.14154    207.75000      7.29688      5.64063     10.22656      0.03648     -0.01551      0.13668      3.54883      2.64761      0.15212
   2316.00000     56.81250      4.30724      4.13624      7.15955    207.75000     16.67188     12.31250     10.22656      0.03775     -0.00848      0.16801      3.21289      2.64545      0.16279
   2316.50000     60.40625      4.30693      4.00989      5.76120    207.75000      4.53516      3.54883     10.22656      0.05510     -0.00943      0.21927      2.62500      2.61578      0.19842
   2317.00000     54.53125      4.31178      4.06332      4.24765    207.87500      3.29492      2.45703     10.20313      0.06782     -0.00719      0.26482      2.42578      2.59402      0.23534
   2317.50000     60.65625      4.37609      4.20665      3.72441    207.87500      2.97461      2.29688     10.17188      0.06865     -0.00328      0.24791      2.51367      2.59260      0.24987
   2318.00000     57.68750      4.39017      4.40649      4.18591    208.37500      5.83203      3.26367     10.20313      0.05469     -0.00577      0.19895      3.12305      2.61648      0.20092
   2318.50000     59.43750      4.50777      4.74177      5.52941    208.87500      7.16406      5.94531     10.09375      0.03363     -0.01071      0.14595      4.02344      2.65249      0.16651
   2319.00000     56.06250      4.90532      5.03242      7.80656    209.12500     11.36719      7.37891     10.08594      0.00657     -0.00692      0.15788      4.34375      2.69877      0.15187
   2319.50000     58.84375      5.55059      5.20816      7.89833    209.50000      7.72656      6.28906     10.08594      0.00271     -0.00179      0.18023      4.19531      2.70536      0.16586
   2320.00000     60.03125      6.23001      6.10797      7.34211    209.37500      8.14063      4.12109     10.11719      0.01453     -0.00208      0.15807      4.06641      2.68515      0.16282
   2320.50000     56.31250      6.58798      7.71857      8.29942    208.87500     16.42188      7.48828     10.00000      0.01265     -0.00197      0.10762      4.26172      2.68837      0.11364
   2321.00000     42.37500      6.05390      8.10445     13.88191    208.50000     23.37500     19.29688      9.92969     -0.03074      0.00700      0.06255      4.94141      2.76257      0.08973
   2321.50000     39.34375      5.06929      6.43389     21.62719    208.25000     27.06250     21.57813      9.92969     -0.07606      0.01604      0.07269      4.90625      2.84007      0.09146
   2322.00000     49.31250      4.41697      4.61159     15.17050    207.50000     20.37500     12.17188      9.92969     -0.06875      0.01349      0.12192      3.96289      2.82756      0.12302
   2322.50000     59.12500      4.16721      3.56121      7.04281    206.87500      4.87109      4.92578     10.09375     -0.01217      0.00915      0.17809      3.44727      2.73081      0.16913
   2323.00000     67.87500      4.08043      3.13986      4.01898    206.25000      3.18945      1.83301     10.21094      0.06231      0.00185      0.23514      3.04102      2.60346      0.19957
   2323.50000     70.18750      3.96174      3.15627      3.58742    206.00000      2.21484      1.52832     10.22656      0.10966      0.00347      0.23698      2.93555      2.52248      0.21688
   2324.00000     74.18750      3.71185      3.49251      3.94813    206.50000      2.38672      1.76074     10.20313      0.11878      0.00289      0.19890      2.87109      2.50689      0.19498
   2324.50000     72.25000      3.43362      3.80930      5.59593    207.50000      2.70898      2.18945     10.08594      0.09116      0.00357      0.14116      3.22070      2.55411      0.15954
   2325.00000     68.62500      3.25182      3.77318     11.04266    208.37500      4.12109      3.03125      9.92969      0.04531      0.00642      0.12588      3.51563      2.63252      0.13720
   2325.50000     68.87500      3.34134      3.58969     13.36049    208.75000     11.36719      8.46875      9.92969      0.02131      0.00810      0.14947      3.78906      2.67357      0.14498
   2326.00000     72.06250      3.75747      3.55141      8.54573    208.50000      3.69727      3.54883      9.92969      0.03334      0.00235      0.19316      3.59961      2.65298      0.16052
   2326.50000     70.25000      4.31613      3.90706      5.85039    208.25000      5.68359      3.39063      9.92969      0.05402      0.00391      0.20043      3.68359      2.61762      0.17668
   2327.00000     63.31250      4.64319      4.57511      5.22370    207.87500      3.52148      2.49414      9.92969      0.05424     -0.00094      0.17474      4.27344      2.61724      0.16636
   2327.50000     52.90625      4.89558      4.81851      6.69949    207.62500     47.71875     29.53125      9.78906      0.01466      0.00804      0.14818      4.49609      2.68494      0.14438
   2328.00000     46.84375      5.29761      4.75259      9.00381    208.12500     67.37500     70.87500      9.78906     -0.02371      0.01452      0.12372      4.51953      2.75054      0.14083
   2328.50000     45.43750      5.90671      5.39922      9.63505    208.62500      3.04102      3.01367      9.80469     -0.00822      0.00759      0.10752      3.74609      2.72405      0.12284
   2329.00000     47.34375      7.19194      7.09424     10.82520    209.12500     12.78125      6.78906      9.80469      0.01825     -0.00010      0.06958      3.69727      2.67879      0.08709
   2329.50000     43.21875      9.15912      9.48883     14.83553    209.50000     11.30469      8.88281      9.80469      0.01224      0.00181      0.02622      3.65625      2.68906      0.05630
   2330.00000     33.34375     11.17748     13.07418     26.45214    209.25000     27.32813     16.09375      9.84375     -0.03366     -0.00092      0.00716      4.55859      2.76755      0.02256
   2330.50000     23.62500     15.35977     19.08555     57.26290    208.75000     81.56250     88.68750      9.82813     -0.09608      0.00079     -0.00243      5.87500      2.87429      0.00631
   2331.00000     17.78125     24.18627     31.03260    236.20972    208.37500     94.06250    155.87500      9.82031     -0.14560      0.00460     -0.00202      5.83594      2.95898     -0.00268
   2331.50000     15.85156     32.01485     45.41528   1706.50708    208.37500    101.31250    130.37500      9.82031     -0.15190     -0.00706     -0.00020      5.24219      2.96975      0.00105
   2332.00000     13.81250     30.99417     47.85515   1808.58691    208.12500     94.00000    144.75000      9.84375     -0.14950     -0.00788      0.00522      5.08984      2.96565      0.01083
   2332.50000     18.67188     26.43697     29.90228    293.54230    207.25000     98.87500    144.00000      9.91406     -0.14115     -0.00246      0.03231      4.67969      2.95137      0.03519
   2333.00000     28.48438     19.23419     18.74934     71.47710    206.87500     54.62500     73.75000      9.92969     -0.11456      0.00370      0.09582      3.56445      2.90589      0.07662
   2333.50000     36.37500     13.89802     13.28703     34.83273    205.50000      8.46094      7.89453     10.08594     -0.07172     -0.00233      0.13942      3.72852      2.83264      0.13441
   2334.00000     43.28125     12.85836      8.91989     24.72183    204.62500     12.76563      8.34375     10.16406     -0.03362      0.00290      0.22434      3.43359      2.76749      0.17408
   2334.50000     45.31250     13.89605      7.49871     18.97979    202.87500      9.08594      8.28906     10.28125      0.04487      0.00268      0.24030      3.74609      2.63328      0.22080
   2335.00000     46.28125     14.00001      9.68003     14.87201    202.12500      1.30762      1.60059     10.44531      0.10471     -0.00251      0.19600      3.39258      2.53095      0.17548
   2335.50000     39.21875     14.13492     18.39288     16.44984    201.37500      3.92383      2.27930     10.36719      0.09317     -0.00586      0.05658      3.94727      2.55068      0.05884
   2336.00000     26.43750     14.83944     26.82025     31.23430    201.50000     55.81250     54.40625     10.10156      0.00449      0.00774     -0.00154      4.94141      2.70231      0.00589
   2336.50000     15.57031     14.46868     27.09275    114.96129    201.50000    100.93750    132.50000     10.08594     -0.13890      0.03658     -0.00851      5.12891      2.94753     -0.01165
   2337.00000     10.81250     17.69633     29.24664    479.91895    201.25000     87.62500    144.25000     10.08594     -0.15667      0.01123     -0.00904      5.23828      2.97791     -0.01644
   2337.50000      9.82813     30.58883     45.22312    916.21167    201.00000     61.46875    100.31250     10.08594     -0.16850      0.00063     -0.00798      5.30469      2.99814     -0.01516
   2338.00000      9.85156     66.22237     74.01880   1314.56812    200.50000     74.18750    107.50000     10.08594     -0.16990     -0.00170     -0.00554      5.15234      3.00053     -0.01073
   2338.50000      9.87500    177.31750    110.79274   1314.56812    200.50000    101.18750    147.12500     10.08594     -0.16450      0.00314     -0.00128      5.46484      2.99129     -0.00255
   2339.00000     10.84375   2000.00000    145.38779   1079.82202    200.37500     91.31250    137.50000     10.10156     -0.15423      0.00254      0.00660      5.30078      2.97373      0.01018
   2339.50000     14.74219    414.88208    145.38779    521.29138    200.12500     76.06250     99.62500     10.09375     -0.13428      0.00075      0.01289      5.25781      2.93962      0.02602
   2340.00000     16.59375    102.63882     92.58803    308.51898    200.12500     56.84375     72.06250     10.10156     -0.13506      0.00249      0.01581      5.32031      2.94095      0.03305
   2340.50000     17.57813     72.81334     45.03259    245.81177    200.00000     58.06250     54.46875     10.16406     -0.12676      0.00164      0.01401      5.04688      2.92675      0.03539
   2341.00000     18.64063     78.81944     25.90810     98.16499    199.62500     70.93750     79.87500     10.21094     -0.12469      0.00196      0.02197      5.05859      2.92323      0.04242
   2341.50000     26.62500    413.20923     19.32814     44.92542    199.25000     92.81250    111.31250     10.21875     -0.11150     -0.00273      0.06073      5.00781      2.90066      0.06451
   2342.00000     36.62500   2000.00000     15.61163     27.28773    199.00000     15.29688      7.83984     10.22656     -0.06729      0.00022      0.10789      4.43359      2.82507      0.09634
   2342.50000     44.53125   2000.00000     30.50050     33.85756    198.37500     11.68750     10.36719     10.42188     -0.01576     -0.00834      0.10440      4.39063      2.73695      0.11212
   2343.00000     44.43750   2000.00000   2000.00000     56.19852    197.62500      6.89453      1.65430     10.50781      0.01739     -0.01554      0.06400      4.15625      2.68026      0.08359
   2343.50000     39.40625   2000.00000   2000.00000    138.69186    196.87500     52.68750     46.50000     10.22656     -0.01664     -0.01300      0.03595      5.00781      2.73845      0.06075
   2344.00000     36.18750   2000.00000    349.09015    132.60889    196.25000     57.15625     70.37500     10.26563     -0.07324      0.00358      0.04227      4.95703      2.83525      0.06615
   2344.50000     31.26563   2000.00000      8.52367     63.92137    195.37500     17.29688     15.44531     10.38281     -0.09851     -0.00322      0.07597      3.25000      2.87846      0.09461
   2345.00000     25.34375     28.35335      2.71446     48.14460    194.62500     29.93750     20.48438     10.38281     -0.07223     -0.00010      0.14867      2.49219      2.83351      0.17479
   2345.50000     18.64063     12.66696      1.59714     96.59685    194.00000      1.79980      3.33594     12.64844      0.42285     -0.08409      0.24534      1.88086      1.98693      0.26196
   2346.00000     16.70313      7.30922      1.34310    103.19051    193.37500      0.41309      0.49072     17.06250      0.71331     -0.08792      0.35455      1.42285      1.49025      0.31399
   2346.50000     19.68750      5.03484      1.30487     85.65103    193.12500      0.22607      0.25830     17.84375      0.84357     -0.05809      0.46458      1.30176      1.26750      0.38985
   2347.00000     21.65625      3.72763      1.19633    444.63074    193.12500      0.25293      0.33008     20.95313      0.84902     -0.01447      0.50140      1.31641      1.25818      0.46995
   2347.50000     27.65625      3.17253      1.07195    795.65686    193.37500      0.23926      0.31201     20.92188      0.81822      0.00183      0.56290      1.48145      1.31085      0.54514
   2348.00000     29.57813      3.80162      1.11301   2000.00000    193.75000      0.18604      0.24072     17.46875      0.78922     -0.00317      0.48986      1.65625      1.36044      0.59929
   2348.50000     33.59375      4.80064      1.73687   2000.00000    193.50000      0.14600      0.25830     19.48438      0.72483     -0.01506      0.33297      1.66504      1.47054      0.32403
   2349.00000     27.73438      5.35542      4.15279   2000.00000    193.50000      0.15918      0.27637     14.79688      0.58723     -0.01803      0.14147      2.78906      1.70584      0.15155
   2349.50000     27.73438      6.68792      9.07318   2000.00000    193.25000      0.42627      0.49072     11.17188      0.33905     -0.00471      0.07699      4.87891      2.13022      0.08822
   2350.00000     28.54688     11.21875     10.81854     66.74350    193.37500      0.29297      0.58057     11.26563      0.17816      0.02100      0.08239      4.60156      2.40535      0.07664
   2350.50000     32.34375   1938.65796     35.70242     39.88760    193.87500      0.21289      0.47314     11.26563      0.15137      0.01421      0.08053      4.26172      2.45115      0.08018
   2351.00000     31.37500   2000.00000   2000.00000     29.84679    194.25000      0.66650      0.70605     10.85156      0.14230      0.00883      0.05457      4.25781      2.46667      0.06669
   2351.50000     27.51563   2000.00000   2000.00000     30.60203    195.37500      4.58984      3.69336     10.41406      0.06063      0.01992      0.03542      5.29297      2.60633      0.05705
   2352.00000     28.60938   2000.00000   2000.00000     38.61405    196.00000      5.91016      7.09375     10.33594     -0.03427      0.03631      0.06512      4.82813      2.76860      0.05849
   2352.50000     36.21875   2000.00000   2000.00000     39.62622    196.37500     12.53125     14.89063     10.24219     -0.05805      0.01323      0.08820      4.76172      2.80926      0.08230
   2353.00000     44.00000   2000.00000   2000.00000     33.85756    197.12500      5.83203      5.62500     10.22656     -0.04975      0.00752      0.08188      4.55078      2.79508      0.09275
   2353.50000     45.87500    175.04071    782.20068     38.86222    197.87500     14.50781     12.78125     10.22656     -0.04598      0.00604      0.05985      5.53516      2.78863      0.08078
   2354.00000     41.21875     44.03674     44.65627     41.53133    198.37500      9.50000     11.88281     10.22656     -0.05642      0.01185      0.06747      5.40625      2.80648      0.07402
   2354.50000     35.31250     31.79739     35.58346     37.65231    199.00000      4.73438      5.62500     10.22656     -0.04814      0.00938      0.07752      5.62109      2.79232      0.08292
   2355.00000     34.28125     25.13063     55.85481     31.56034    199.62500      7.36719      4.92969     10.21875     -0.04776      0.00074      0.06905      5.01172      2.79167      0.07815
   2355.50000     29.37500     22.41260     91.01363     35.23870    200.37500     14.47656     10.81250     10.20313     -0.05615     -0.00249      0.03870      5.53125      2.80601      0.06067
   2356.00000     28.37500     20.34957     48.72768     47.76431    201.12500     21.39063     24.10938     10.09375     -0.09104      0.00286      0.03466      5.60938      2.86568      0.05206
   2356.50000     25.34375     19.57114     25.29356     48.14460    201.75000     21.98438     18.85938     10.07031     -0.09927      0.00033      0.04226      5.83203      2.87975      0.05659
   2357.00000     31.15625     21.38463     20.88232     36.73730    202.25000     13.14063     14.73438     10.04688     -0.09972     -0.00144      0.04540      5.34766      2.88052      0.05811
   2357.50000     28.37500     22.65156     24.09319     32.06236    202.87500     11.76563      8.69531     10.03906     -0.08906     -0.00353      0.02632      5.75000      2.86230      0.05095
   2358.00000     22.64063     24.50316     32.84690     43.31635    203.62500     21.71875     17.59375     10.04688     -0.09813     -0.00565      0.01040      5.42578      2.87780      0.02787
   2358.50000     16.79688     27.61238     37.71980     93.60623    204.25000     33.65625     39.71875     10.04688     -0.10571     -0.00775      0.00131      6.05859      2.89076      0.01328
   2359.00000     13.85156     29.51991     38.95786    256.22754    204.50000     35.93750     51.46875     10.07031     -0.12219     -0.00949      0.00018      5.70313      2.91895      0.00670
   2359.50000     14.82813     31.35645     40.43221    414.17645    205.00000     23.60938     35.56250     10.08594     -0.12999     -0.00693      0.00392      5.47266      2.93229      0.00915
   2360.00000     18.78125     33.37861     36.18630    245.81177    205.50000     31.28125     40.40625     10.08594     -0.12955     -0.00426      0.01253      5.02344      2.93152      0.01994
   2360.50000     27.56250     30.54238     29.65301    117.18924    206.37500     29.20313     34.31250     10.07031     -0.12042     -0.00142      0.02706      4.82422      2.91591      0.03611
   2361.00000     31.40625     25.90066     23.82394     72.33208    206.62500     16.96875     13.53125     10.08594     -0.11006     -0.00008      0.04961      5.47266      2.89820      0.05739
   2361.50000     36.34375     22.52383     19.01736     54.67416    207.25000     35.18750     27.00000     10.08594     -0.10600     -0.00057      0.07867      5.50000      2.89127      0.07748
   2362.00000     36.43750     20.74805     15.36335     38.12712    207.62500     12.62500     13.67188     10.08594     -0.08613     -0.00302      0.10324      5.45703      2.85728      0.10218
   2362.50000     42.59375     20.07058     14.60304     29.12794    207.62500     19.95313     12.99219     10.08594     -0.07343     -0.00623      0.10690      4.63672      2.83556      0.10862
   2363.00000     36.68750     20.58087     16.20675     25.66622    207.75000      8.10156      6.91406     10.08594     -0.05831     -0.01075      0.08285      4.55469      2.80971      0.09571
   2363.50000     33.71875     21.74125     20.28565     31.07380    207.37500     12.50000      8.64844      9.95313     -0.08076     -0.00583      0.04090      4.74219      2.84810      0.06778
   2364.00000     22.70313     23.14756     24.76482     48.53099    206.62500     21.98438     16.92188      9.94531     -0.10511     -0.00055      0.00988      5.42969      2.88973      0.03331
   2364.50000     18.67188     26.63007     31.49037    106.83682    205.62500     42.65625     42.50000     10.01563     -0.13556      0.00183     -0.00346      5.80469      2.94180      0.00766
   2365.00000     11.68750     35.98216     39.97834    293.54230    205.00000     57.96875     63.31250     10.08594     -0.14169      0.00219     -0.00808      5.78906      2.95230     -0.00665
   2365.50000     10.67969     62.43825     53.08226   1706.50708    204.25000     27.87500     40.03125     10.08594     -0.13255      0.00275     -0.00711      5.91797      2.93665     -0.01042
   2366.00000      9.78125    173.11414     80.11407   1923.65649    203.50000      6.76563     15.17969     10.08594     -0.10820     -0.00180     -0.00402      5.53906      2.89502     -0.00790
   2366.50000     11.73438    225.12820    224.66440   2000.00000    202.62500      7.80469      8.64844     10.08594     -0.08466     -0.00077      0.00135      5.46094      2.85477     -0.00352
   2367.00000     12.71094    122.10791   1948.75342   2000.00000    201.37500     12.13281     11.24219     10.08594     -0.07336     -0.00568      0.00506      5.17188      2.83545      0.00564
   2367.50000     12.71094     61.34478    185.71906   2000.00000    200.00000      5.10938     10.42188     10.00781     -0.07754     -0.00902      0.00705      5.57422      2.84259      0.01321
   2368.00000     14.70313     31.55312     50.33354   1808.58691    198.62500     50.15625     51.93750      9.92969     -0.10671     -0.00468      0.00730      5.44922      2.89247      0.02630
   2368.50000     19.75000     22.13921     19.75863    148.94003    197.75000     39.46875     57.65625      9.92969     -0.11672     -0.00007      0.03697      5.48828      2.90958      0.04566
   2369.00000     38.12500     23.68228     10.82960     44.59411    196.75000     31.29688     29.62500      9.92969     -0.05858      0.02769      0.14600      4.11328      2.81017      0.09236
   2369.50000     50.12500     24.61163     11.53751     23.93888    196.50000      5.89844      8.25000     10.04688      0.02080      0.02797      0.18195      3.76172      2.67442      0.15112
   2370.00000     52.90625     24.59954     22.46784     20.11630    196.50000      1.32031      1.20605     10.08594      0.06065      0.01765      0.13757      3.41602      2.60629      0.11332
   2370.50000     35.50000     25.67170     40.89648     25.45017    197.25000     17.20313     10.79688      9.86719     -0.00262      0.04260      0.02789      5.32813      2.71448      0.04834
   2371.00000     22.54688     23.44622     39.53453     54.18425    197.75000     34.18750     43.71875      9.82031     -0.10649      0.07267      0.00327      6.80078      2.89211      0.01666
   2371.50000     13.77344     21.00169     34.77240    179.96927    197.87500     27.46875     34.09375      9.81250     -0.14210      0.01286     -0.00042      6.32813      2.95299      0.00558
   2372.00000     15.79688     29.83540     39.53453    444.63074    198.00000     63.03125     74.25000      9.81250     -0.14368     -0.00096     -0.00049      5.96875      2.95569      0.00419
   2372.50000     17.81250     50.08056     59.58918    795.65686    198.25000     88.18750    115.12500      9.79688     -0.13420     -0.00580      0.00192      4.91406      2.93948      0.00588
   2373.00000     19.78125     81.66440     80.71829    795.65686    198.25000     75.00000    102.25000      9.80469     -0.13226     -0.00632      0.00633      4.68750      2.93617      0.01158
   2373.50000     18.71875    144.99252     99.47032    795.65686    198.50000     46.78125     64.75000      9.81250     -0.13257     -0.00404      0.00900      4.29297      2.93669      0.02002
   2374.00000     17.71875    139.35538     95.90594    279.95233    198.62500     54.53125     55.12500      9.84375     -0.13597      0.00294      0.01307      4.81641      2.94250      0.02474
   2374.50000     17.73438     65.39157     79.51881    121.91460    199.00000     83.00000    133.75000      9.90625     -0.12916      0.00315      0.01403      5.45703      2.93087      0.02979
   2375.00000     17.76563     40.50834     55.27740     84.45479    199.00000     34.21875     48.90625      9.92969     -0.11528      0.00366      0.01565      5.60156      2.90714      0.03036
   2375.50000     17.67188     27.59719     36.18630    104.98201    198.87500     49.34375     56.37500      9.92969     -0.10563      0.00043      0.01734      5.48047      2.89063      0.03273
   2376.00000     23.57813     22.09999     22.23343     98.16499    198.50000     40.59375     49.46875      9.92969     -0.10566     -0.00111      0.03027      5.36719      2.89068      0.04158
   2376.50000     34.43750     21.09503     15.70391     40.15247    198.12500     32.12500     32.06250      9.92969     -0.10047     -0.00114      0.06512      5.57813      2.88180      0.05998
   2377.00000     39.25000     21.40299     15.36335     21.94107    197.75000     12.84375     10.04688     10.00000     -0.07995     -0.00369      0.06222      5.74609      2.84672      0.08118
   2377.50000     36.25000     21.92038     19.15424     18.86139    197.37500     28.31250     13.50000      9.96094     -0.06565     -0.00794      0.04209      5.53906      2.82226      0.05679
   2378.00000     27.37500     22.19336     23.00131     29.41129    197.00000     54.43750     72.68750      9.93750     -0.07940     -0.00184      0.01254      5.69531      2.84577      0.03542
   2378.50000     23.59375     21.53704     24.76482     68.25014    196.75000     48.56250     56.50000      9.96875     -0.11203      0.00950      0.00909      5.78516      2.90157      0.02110
   2379.00000     21.64063     22.67727     27.44124    160.82358    196.50000     86.81250    130.62500     10.00000     -0.13111      0.01124      0.00904      6.05859      2.93420      0.02055
   2379.50000     19.68750     30.21654     34.65954    185.48981    196.12500     63.62500     90.68750     10.07031     -0.13113      0.00601      0.00901      5.94531      2.93423      0.02175
   2380.00000     17.81250     45.01627     48.28748    227.32965    195.62500     56.28125     64.43750     10.08594     -0.12999      0.00554      0.00884      5.36328      2.93228      0.02228
   2380.50000     15.85938     56.49743     61.29659    267.56506    195.37500     71.31250     98.62500     10.08594     -0.12871      0.00039      0.01114      5.34766      2.93010      0.02486
   2381.00000     15.79688     55.52365     68.78477    211.43246    195.00000     62.40625     80.62500     10.08594     -0.13148     -0.00243      0.01576      4.97656      2.93483      0.03123
   2381.50000     15.62500     41.42991     57.66167    141.94754    194.50000     36.15625     51.37500     10.08594     -0.12667     -0.00776      0.02015      5.10156      2.92660      0.03880
   2382.00000     16.56250     25.69475     38.81631    132.60889    194.12500     29.07813     31.28125     10.08594     -0.11682     -0.00823      0.02025      5.19922      2.90977      0.04501
   2382.50000     19.57813     17.53045     19.98111    119.50523    193.75000     33.15625     45.25000     10.08594     -0.10892     -0.00759      0.04254      5.89063      2.89626      0.05808
   2383.00000     32.50000     15.26231     10.80749     43.62887    193.62500     35.78125     52.18750     10.08594     -0.07201      0.01476      0.14129      4.94922      2.83314      0.09806
   2383.50000     49.56250     14.24345      8.77165     19.91752    194.12500     10.95313     14.43750     10.21094     -0.00066      0.01253      0.20198      4.29297      2.71113      0.16770
   2384.00000     59.25000     13.13601     10.23270     13.81846    195.00000      1.08008      1.40332     10.35938      0.06844      0.00073      0.19990      3.81055      2.59296      0.18397
   2384.50000     52.34375     11.99660     12.65309     15.80491    196.00000     15.72656      8.75000     10.15625      0.05243      0.00382      0.11533      4.18750      2.62035      0.13333
   2385.00000     43.18750     10.63631     11.61339     20.45657    197.12500     21.31250     13.21094     10.15625     -0.00789      0.01636      0.06799      5.35938      2.72349      0.09150
   2385.50000     38.15625      9.86381      9.86061     26.45214    197.00000     21.64063     26.62500     10.22656     -0.07724      0.00591      0.07750      5.24609      2.84209      0.08501
   2386.00000     37.12500     11.29496      9.66233     21.86175    196.62500     13.23438      8.64844     10.22656     -0.05616      0.00128      0.08878      4.96484      2.80603      0.09302
   2386.50000     34.18750     13.83148     12.40152     19.16020    196.25000      5.39063      4.35547     10.32031     -0.02833     -0.00429      0.07052      4.76953      2.75844      0.08192
   2387.00000     30.43750     16.99358     18.20407     23.56571    195.62500      6.49609      4.19141     10.19531     -0.02572     -0.00674      0.02742      5.03516      2.75398      0.04927
   2387.50000     24.54688     21.03049     23.66526     40.69287    195.25000     34.84375     42.31250     10.08594     -0.07295     -0.00034      0.00837      5.28516      2.83475      0.02597
   2388.00000     20.62500     26.08947     29.40785     89.45212    195.00000     41.59375     42.31250     10.08594     -0.12549      0.00514      0.00425      5.57422      2.92459      0.01606
   2388.50000     15.79688     33.52301     41.05362    174.76782    194.75000     53.84375     56.46875     10.08594     -0.14012     -0.00352      0.00371      5.46484      2.94961      0.01280
   2389.00000     14.81250     47.25404     62.73452    308.51898    194.62500     65.50000     82.31250     10.08594     -0.13365     -0.00497      0.00354      6.06250      2.93853      0.01310
   2389.50000     14.83594     55.73717     83.88135    570.46997    194.62500     63.93750     86.56250     10.08594     -0.12979     -0.00338      0.00460      5.59375      2.93195      0.01326
   2390.00000     13.80469     47.19898     78.93236   1314.56812    194.37500     60.18750     77.50000     10.08594     -0.12866     -0.00154      0.00455      5.61719      2.93001      0.01549
   2390.50000     15.79688     31.32716     55.85481   1079.82202    194.12500     62.78125     79.81250     10.08594     -0.13164     -0.00001      0.00554      5.27734      2.93510      0.01851
   2391.00000     17.82813     20.84354     30.41358    343.57800    194.00000     55.71875     78.43750     10.08594     -0.12112     -0.00247      0.00931      5.46875      2.91711      0.02615
   2391.50000     25.70313     15.96602     16.53443     89.45212    194.12500     34.15625     43.68750     10.14844     -0.12589     -0.00007      0.03027      5.82422      2.92528      0.04028
   2392.00000     37.53125     13.76266     11.14890     32.40601    193.87500     36.31250     38.43750     10.21094     -0.10828      0.00155      0.07845      5.90234      2.89516      0.06890
   2392.50000     47.28125     12.70727      9.55748     17.29679    194.25000      4.66797      4.67578     10.22656     -0.07364     -0.00512      0.11993      5.75000      2.83592      0.10119
   2393.00000     48.21875     12.77028      9.68890     14.14163    194.00000      3.46875      3.37109     10.25781     -0.03583     -0.00701      0.11059      5.49219      2.77126      0.11447
   2393.50000     40.37500     12.68832     11.25554     16.14244    192.87500     10.24219      6.19531     10.25781     -0.03761     -0.00906      0.06784      5.99609      2.77430      0.08399
   2394.00000     29.46875     12.22266     14.04298     25.23773    192.87500      8.41406      6.07031     10.14063     -0.06667     -0.00615      0.02278      5.86328      2.82400      0.04676
   2394.50000     22.56250     12.45640     15.56589     47.02148    193.37500     33.43750     34.93750     10.15625     -0.09361     -0.00386      0.00852      5.51953      2.87007      0.02467
   2395.00000     22.50000     12.68174     17.01054     88.14815    193.87500     16.06250     21.28125     10.14844     -0.11578     -0.00043      0.00384      5.21875      2.90799      0.01302
   2395.50000     23.50000     12.30737     16.63792    129.76318    194.00000     24.50000     25.10938     10.09375     -0.12634     -0.00537      0.00176      5.18750      2.92605      0.01107
   2396.00000     25.43750     12.68667     12.32941    119.50523    194.00000     52.31250     74.62500     10.08594     -0.15547      0.00086      0.01526      5.22266      2.97585      0.01923
   2396.50000     27.32813     14.62564      8.96534     37.18919    193.87500     74.12500     99.43750     10.08594     -0.14810      0.00419      0.06956      4.55469      2.96325      0.05168
   2397.00000     29.35938     16.80460      9.13598     17.80613    193.50000     26.90625     36.81250     10.18750     -0.11492     -0.00197      0.08637      4.66797      2.90651      0.08924
   2397.50000     28.43750     18.07862     12.53345     14.62031    193.25000      4.53516      2.38672     10.32031     -0.08885     -0.00731      0.05194      5.03906      2.86193      0.06577
   2398.00000     22.53125     18.02115     17.25898     22.59701    193.00000     26.01563     19.25000     10.08594     -0.09442     -0.00410      0.00723      5.53516      2.87146      0.02573
   2398.50000     17.60938     16.52114     20.32437     58.93725    192.87500     28.53125     34.62500     10.08594     -0.11813      0.00292     -0.00308      5.49609      2.91201      0.00365
   2399.00000     13.66406     17.66480     23.10102    236.20972    192.62500     36.65625     48.43750     10.08594     -0.13752     -0.00012     -0.00655      5.41797      2.94515     -0.00676
   2399.50000      9.82031     24.86846     31.96182    414.17645    192.50000     49.21875     74.93750     10.08594     -0.14331     -0.00291     -0.00639      6.07031      2.95507     -0.00885
   2400.00000     10.88281     35.50710     49.17596    414.17645    192.37500     44.71875     71.43750     10.08594     -0.15731     -0.00245     -0.00319      6.12891      2.97900     -0.00484
   2400.50000     11.93750     43.59085     52.56041    343.57800    192.12500     27.45313     37.03125     10.08594     -0.15885     -0.00341      0.00228      5.35156      2.98163      0.00585
   2401.00000     17.90625     47.03457     38.12366    197.61334    192.25000     30.12500     52.87500     10.08594     -0.14600     -0.00821      0.01565      5.03125      2.95966      0.02177
   2401.50000     25.75000     35.03213     27.09275     81.05847    192.00000     28.96875     42.34375     10.08594     -0.12668     -0.01060      0.04479      4.69531      2.92662      0.04605
   2402.00000     36.31250     23.42150     21.69025     40.69287    191.62500     22.42188     29.10938     10.08594     -0.09687     -0.01102      0.07863      4.91406      2.87565      0.07284
   2402.50000     40.03125     17.67425     17.63089     31.23430    191.37500     27.79688     23.53125     10.08594     -0.07449     -0.01218      0.08496      4.48047      2.83737      0.09404
   2403.00000     40.18750     13.56111     13.87776     29.12794    190.87500      9.80469     11.54688     10.08594     -0.05257     -0.01567      0.08278      4.83594      2.79990      0.09726
   2403.50000     39.56250     10.93473     10.79647     29.70020    190.25000     17.57813     14.28125     10.08594     -0.05737     -0.01149      0.08189      4.96094      2.80811      0.09946
   2404.00000     45.62500     10.63981      8.30228     21.32215    189.37500     12.17188     11.77344     10.08594     -0.06121     -0.00664      0.12539      5.01563      2.81467      0.10412
   2404.50000     48.56250     11.40417      7.82754     14.65574    188.37500      9.31250      6.89453     10.09375     -0.03685     -0.00526      0.13090      4.21875      2.77301      0.12992
   2405.00000     47.53125     12.23338      9.79665     12.00747    188.00000      8.71094      5.83984     10.20313     -0.00965     -0.01243      0.10280      4.30859      2.72650      0.10939
   2405.50000     39.59375     12.07677     13.91414     17.49699    188.00000     22.25000     21.85938      9.95313     -0.02427     -0.00873      0.03726      4.68750      2.75150      0.06513
   2406.00000     29.64063     11.44574     14.60304     36.73730    188.50000     21.67188     30.70313      9.96875     -0.06916     -0.00322      0.01779      6.14063      2.82826      0.03979
   2406.50000     25.43750     10.57886     13.43847     70.64207    189.25000     24.79688     36.78125      9.98438     -0.10494      0.00254      0.02110      5.75000      2.88944      0.03786
   2407.00000     25.37500     10.24594     12.65309     55.68105    189.25000     13.41406     19.48438     10.06250     -0.09411     -0.00927      0.02654      5.91016      2.87092      0.04462
   2407.50000     29.21875      9.66863     10.79647     51.86073    189.12500     26.76563     34.56250     10.08594     -0.10001     -0.00599      0.04361      5.23047      2.88102      0.05938
   2408.00000     36.09375     10.00117      7.39336     27.78934    189.00000     22.98438     32.40625     10.08594     -0.09484      0.00484      0.12431      4.34375      2.87218      0.08890
   2408.50000     41.06250     10.13432      6.58316     14.14163    188.62500     11.59375      9.64844     10.09375     -0.02705      0.00068      0.16577      4.08594      2.75625      0.14927
   2409.00000     44.03125      9.48735      7.87434      9.83885    189.00000      2.56250      1.76074     10.29688      0.02375     -0.00926      0.15929      3.99219      2.66939      0.15119
   2409.50000     40.28125      8.93837      9.42115     12.74117    189.62500     20.09375     21.57813     10.17188      0.01215     -0.00295      0.10724      4.82031      2.68922      0.11591
   2410.00000     40.28125      8.63877      8.43507     16.14244    191.00000     16.48438     29.81250     10.21094     -0.04678      0.01456      0.09500      5.01953      2.78999      0.10475
   2410.50000     40.28125      8.31001      8.67076     17.54777    192.00000     10.00781      8.17969     10.22656     -0.08289      0.01086      0.09428      5.23438      2.85174      0.10611
   2411.00000     39.28125      9.63964     10.17365     18.68653    192.37500      8.78906      4.82031     10.22656     -0.07210      0.00158      0.07340      5.34375      2.83329      0.09038
   2411.50000     32.40625     12.05737     12.13188     25.99725    192.62500     31.29688     32.03125     10.21875     -0.08525      0.00613      0.06336      5.21094      2.85577      0.07375
   2412.00000     27.60938     14.11969     13.68101     31.39647    192.87500     32.21875     34.25000     10.22656     -0.09010      0.00291      0.05591      5.28906      2.86408      0.07064
   2412.50000     23.65625     17.55840     17.37174     30.91493    193.00000      8.95313      9.99219     10.22656     -0.09446     -0.00407      0.03899      5.41406      2.87152      0.05617
   2413.00000     20.68750     25.34049     24.76482     41.81854    192.75000     18.23438     19.85938     10.21875     -0.09700     -0.00403      0.01259      5.56250      2.87588      0.03438
   2413.50000     16.70313     28.58744     33.56986     73.20778    192.50000     26.17188     32.37500     10.20313     -0.11444     -0.00410      0.00365      5.47656      2.90569      0.01737
   2414.00000     13.82031     29.67244     39.53453    121.91460    192.37500     31.53125     54.37500     10.17188     -0.13121     -0.00502      0.00056      4.87891      2.93436      0.00964
   2414.50000     12.82813     33.11523     42.69390    135.58218    192.12500     33.93750     56.18750     10.17188     -0.14428     -0.00176     -0.00066      4.93750      2.95672      0.00416
   2415.00000     13.81250     31.12845     43.74242    174.76782    192.25000     39.46875     47.09375     10.21094     -0.15009     -0.00235     -0.00188      4.89453      2.96666      0.00239
   2415.50000     15.75781     23.83185     33.78230    293.54230    192.50000     47.31250     77.68750     10.20313     -0.14871     -0.00732      0.00033      5.31250      2.96430      0.00624
   2416.00000     19.65625     21.03049     20.48072    132.60889    192.50000     54.87500    106.12500     10.22656     -0.15349     -0.00127      0.02167      5.22266      2.97247      0.02151
   2416.50000     30.39063     20.15593     14.86880     43.00826    192.37500     36.25000     70.43750     10.22656     -0.13244      0.00239      0.06696      4.72656      2.93647      0.05780
   2417.00000     36.25000     17.76610     14.56300     26.22272    192.12500      5.93750      5.75000     10.22656     -0.09207     -0.00840      0.07583      5.23828      2.86744      0.08481
   2417.50000     38.34375     15.89152     14.64331     27.91764    191.50000     18.76563     15.80469     10.22656     -0.08633      0.00016      0.06451      5.26172      2.85763      0.08341
   2418.00000     34.50000     15.71822     12.37258     33.11589    190.75000     43.93750     65.75000     10.26563     -0.08242      0.01106      0.07462      5.26953      2.85094      0.08001
   2418.50000     35.43750     15.79240     12.62296     30.75768    190.00000     17.14063     23.96875     10.29688     -0.06043      0.01301      0.09014      4.59766      2.81333      0.08764
   2419.00000     32.34375     17.48097     17.45727     28.57732    189.37500      1.46680      3.17383     10.26563     -0.03650      0.00312      0.05463      4.63672      2.77242      0.07143
   2419.50000     23.48438     21.80540     29.48912     43.94594    188.75000     24.78125     26.92188     10.14844     -0.06001      0.01127      0.00832      5.39063      2.81261      0.02107
   2420.00000     13.71094     26.24317     37.19442    117.18924    188.37500     33.09375     49.53125     10.17188     -0.11275      0.01031     -0.00592      6.30469      2.90280     -0.00072
   2420.50000     11.85156     30.93222     44.10345    570.46997    188.12500     40.25000     60.43750     10.21875     -0.14863      0.01031     -0.00798      5.87500      2.96416     -0.01151
   2421.00000     11.89063     51.38815     60.94733    916.21167    187.50000     47.09375     66.00000     10.19531     -0.14625     -0.00044     -0.00880      5.65234      2.96009     -0.01329
   2421.50000     11.89063     83.78075    116.83722   1808.58691    187.00000     46.31250     71.43750     10.17969     -0.14892     -0.00295     -0.00850      5.12891      2.96465     -0.01416
   2422.00000      9.89063    130.37186    199.55676   2000.00000    186.62500     53.28125     80.06250     10.20313     -0.15696     -0.00429     -0.00831      5.71484      2.97840     -0.01307
   2422.50000     10.82031    122.32742    165.61984   2000.00000    186.25000     61.62500     81.62500     10.20313     -0.17430      0.00419     -0.00701      5.26563      3.00806     -0.01126
   2423.00000     11.71875     62.72739    125.02158   2000.00000    186.00000     50.59375     67.87500     10.22656     -0.16375     -0.00109     -0.00564      5.35938      2.99002     -0.00760
   2423.50000     15.60156     31.86282     54.99315   2000.00000    185.50000     50.06250     60.34375     10.22656     -0.15884     -0.00088     -0.00180      5.13281      2.98161     -0.00047
   2424.00000     16.64063     23.38862     24.59343    795.65686    185.37500     49.37500     70.87500     10.22656     -0.15458      0.00218      0.00920      5.53906      2.97434      0.01589
   2424.50000     22.60938     17.92183     16.40685     69.02925    185.12500     21.84375     34.34375     10.22656     -0.15088      0.00784      0.06832      5.35547      2.96801      0.04858
   2425.00000     30.53125     16.70247     12.45981     22.26421    185.00000     27.76563     30.82813     10.32031     -0.10121      0.01168      0.12961      4.50391      2.88308      0.10069
   2425.50000     38.34375     17.54131     11.27951     13.66236    185.37500      4.72266      2.88672     10.41406     -0.03862      0.00618      0.13400      4.56641      2.77604      0.12721
   2426.00000     37.40625     16.17514     10.99836     15.72272    185.75000     10.99219      5.98438     10.36719     -0.01692     -0.00015      0.07562      4.68359      2.73893      0.09559
   2426.50000     27.57813     14.83609     13.73411     28.71301    186.37500     21.06250     19.96875     10.23438     -0.04781      0.00557      0.03301      6.11328      2.79175      0.05557
   2427.00000     22.57813     17.27372     15.45271     64.60429    186.50000     28.73438     33.62500     10.24219     -0.09992      0.02182      0.02663      5.34766      2.88086      0.04763
   2427.50000     21.43750     20.68129     20.76020     71.47710    186.50000     13.34375     14.46094     10.24219     -0.10485      0.00473      0.02379      5.04688      2.88930      0.04471
   2428.00000     22.42188     29.27906     29.90228     72.33208    186.00000     24.03125     14.42969     10.22656     -0.10714      0.00011      0.01082      5.32422      2.89321      0.03027
   2428.50000     20.51563     42.15546     54.15762    103.19051    185.62500     52.96875     37.75000     10.24219     -0.12838      0.00470      0.00155      5.54297      2.92954      0.01348
   2429.00000     17.68750     47.11115     62.73452    197.61334    184.87500     54.25000     48.50000     10.25000     -0.14091      0.00689      0.00027      5.69141      2.95095      0.00719
   2429.50000     17.70313     38.99928     50.57163    267.56506    183.87500     72.00000     55.68750     10.32813     -0.14341     -0.00387      0.00333      5.60938      2.95523      0.01121
   2430.00000     16.76563     31.66233     31.58355    174.76782    183.12500     79.25000     62.15625     10.36719     -0.14536     -0.00533      0.01252      6.08594      2.95857      0.02748
   2430.50000     21.64063     30.77605     17.09256     77.92477    182.37500     72.00000     65.56250     10.38281     -0.14987     -0.00579      0.07980      5.97656      2.96628      0.06102
   2431.00000     26.56250     40.46779     13.43847     39.36823    181.62500     14.51563     14.28125     10.41406     -0.04290     -0.01367      0.14747      4.30859      2.78336      0.12372
   2431.50000     35.37500     46.11345     19.46955     30.75768    181.37500      3.76367      2.87109     10.88281      0.09073     -0.05432      0.14971      3.93164      2.55486      0.14454
   2432.00000     31.54688     42.60841     66.22997     36.07972    181.00000     12.46094      8.03906     10.56250      0.13310     -0.05533      0.08691      3.48438      2.48240      0.09048
   2432.50000     28.64063     33.96948    102.32231     53.23030    181.37500      9.52344     10.67188     10.39063      0.08165     -0.03589      0.02072      5.31250      2.57037      0.04581
   2433.00000     17.82813     21.63750     57.35246    119.50523    181.12500     52.12500     33.15625     10.33594     -0.02821     -0.01397      0.00795      5.73438      2.75824      0.02649
   2433.50000     16.81250     16.40738     25.41413    236.20972    180.62500     44.90625     41.28125     10.32031     -0.10336     -0.01125      0.00553      6.62109      2.88674      0.03041
   2434.00000     21.53125     15.26940     13.69866    132.60889    180.37500    115.56250     96.68750     10.33594     -0.13268      0.00930      0.04712      5.62891      2.93688      0.05494
   2434.50000     34.53125     16.69402      8.63529     39.36823    180.00000     54.84375     75.18750     10.38281     -0.04807      0.02715      0.16402      4.48828      2.79220      0.12164
   2435.00000     47.43750     19.48487      8.60010     18.68653    180.00000      2.54883      2.87109     10.55469      0.05615      0.03525      0.25101      3.88281      2.61398      0.16772
   2435.50000     49.34375     22.00011     14.42453     15.13253    180.12500      3.38867      1.54688     10.60938      0.11809      0.03643      0.20973      3.61328      2.50807      0.19021
   2436.00000     40.21875     22.25273     29.90228     16.22909    180.25000      3.42969      3.49609     10.61719      0.07711      0.05579      0.08683      4.26172      2.57814      0.08699
   2436.50000     25.31250     19.51929     37.71980     27.28773    180.75000     22.03125     18.95313     10.32813     -0.02710      0.07971      0.00480      4.38672      2.75634      0.02194
   2437.00000     15.61719     18.04409     30.58791     89.45212    180.75000     59.28125     64.62500     10.24219     -0.13321      0.06449     -0.00517      4.63281      2.93778      0.00021
   2437.50000     13.66406     21.55100     31.21410    479.91895    180.87500     50.78125     73.81250     10.32031     -0.18292      0.03631     -0.00483      5.01563      3.02279     -0.00287
   2438.00000     15.61719     28.38541     36.80988    703.13818    181.00000     44.06250     56.53125     10.31250     -0.17594      0.01574      0.00146      5.51563      3.01085      0.00458
   2438.50000     18.59375     33.14792     34.10602    343.57800    180.62500     45.21875     47.34375     10.29688     -0.16810      0.01222      0.01649      5.32813      2.99745      0.02040
   2439.00000     26.40625     32.40650     25.53585    174.76782    180.62500     39.65625     38.78125     10.38281     -0.14041      0.00530      0.04155      5.00000      2.95010      0.04635
   2439.50000     39.03125     29.39469     18.84896     88.14815    180.37500     18.93750     12.28125     10.38281     -0.12696      0.00231      0.08147      4.74219      2.92711      0.07561
   2440.00000     48.71875     24.88391     15.77383     42.10976    180.37500     18.90625     13.86719     10.42969     -0.09938     -0.00120      0.10531      4.67188      2.87993      0.10444
   2440.50000     50.87500     21.71522     15.61163     25.88596    180.25000      9.53906      4.49609     10.53125     -0.08396     -0.00238      0.10652      4.45313      2.85358      0.11215
   2441.00000     44.28125     19.15634     17.23102     21.70481    180.37500      8.80469      5.42578     10.53125     -0.07057     -0.00532      0.07751      4.82422      2.83067      0.09842
   2441.50000     32.65625     16.66730     18.08034     27.41143    180.12500     28.48438     22.40625     10.60156     -0.08198     -0.00260      0.05321      4.66797      2.85019      0.07302
   2442.00000     24.81250     14.66267     17.77821     38.36904    179.62500     30.14063     35.40625     10.67969     -0.09043      0.00191      0.04596      5.48438      2.86464      0.06652
   2442.50000     22.76563     13.56017     17.03779     44.26765    179.12500     14.14063     14.80469     10.81250     -0.09949      0.00096      0.04572      5.52734      2.88013      0.06574
   2443.00000     27.65625     12.98626     14.99473     44.92542    178.75000     17.81250     18.48438     10.82813     -0.09608     -0.00518      0.03955      6.19141      2.87430      0.07176
   2443.50000     29.45313     12.78530     11.12547     37.65231    178.25000     16.85938     20.64063     10.91406     -0.10510      0.00220      0.07261      5.51953      2.88971      0.08782
   2444.00000     36.15625     13.78682      8.55824     21.02559    177.75000     14.62500     14.39063     10.99219     -0.07113      0.01459      0.16771      4.53906      2.83164      0.12361
   2444.50000     43.15625     14.95774      8.98823     13.72437    177.25000      4.85547      4.87500     11.15625      0.02268      0.00666      0.20078      3.92383      2.67122      0.17604
   2445.00000     44.21875     15.52169     12.89930     12.71438    177.37500      0.90674      1.45703     11.44531      0.07534     -0.00220      0.15878      3.68555      2.58117      0.14706
   2445.50000     38.59375     15.80504     17.95827     18.57174    177.37500      6.32422      4.01563     11.01563      0.05301      0.00362      0.05178      4.23047      2.61935      0.07615
   2446.00000     25.71875     15.58790     18.39288     35.86572    177.87500     14.10938     16.43750     10.98438     -0.03231      0.01377      0.01325      5.32813      2.76524      0.03781
   2446.50000     21.82813     17.20321     18.94964     60.71247    178.62500     17.04688     19.68750     11.09375     -0.10813      0.01047      0.00779      5.50000      2.89491      0.02487
   2447.00000     16.81250     21.22529     21.17290     54.18425    179.00000      9.36719     10.81250     11.10938     -0.11643     -0.00872      0.00608      5.78906      2.90910      0.02114
   2447.50000     17.75000     23.73287     22.65895     78.94208    179.12500     20.64063     19.32813     11.12500     -0.12833     -0.00698      0.00389      6.09375      2.92944      0.02199
   2448.00000     19.50000     24.86846     14.97359     81.05847    178.62500     26.51563     31.54688     11.12500     -0.13193      0.00035      0.01792      6.05078      2.93560      0.03208
   2448.50000     30.31250     22.53145      9.50590     27.16514    178.00000     32.25000     43.28125     11.25781     -0.09730      0.03173      0.09274      4.33984      2.87639      0.06757
   2449.00000     41.09375     14.44955      7.30103     10.98249    176.62500     10.00781     14.23438     11.50000      0.01568      0.04246      0.16634      3.93750      2.68319      0.13405
   2449.50000     53.03125      9.49857      5.65614      6.23655    175.00000      1.68066      2.01172     11.83594      0.10739      0.05085      0.22560      3.14258      2.52636      0.21531
   2450.00000     56.03125      6.36231      4.44036      5.61672    172.75000      5.38672      3.94336     11.81250      0.15313      0.05858      0.22619      3.22656      2.44815      0.25864
   2450.50000     57.06250      4.39982      3.28326      4.89395    170.75000      1.01367      1.67188     12.00781      0.14284      0.06079      0.25510      2.82422      2.46574      0.27311
   2451.00000     56.03125      3.82117      2.28263      5.13063    168.50000      4.84375      2.27930     12.02344      0.20658      0.03411      0.29911      2.31250      2.35674      0.32187
   2451.50000     54.09375      4.02981      1.81445      4.43131    166.50000      2.61523      1.81543     13.71875      0.39768     -0.00983      0.37955      2.19922      2.02996      0.35615
   2452.00000     59.03125      4.51645      1.97699      5.52941    164.62500      0.42676      0.58057     14.09375      0.50889     -0.01230      0.45614      2.08203      1.83981      0.39313
   2452.50000     58.15625      5.16808      3.10193      7.15955    164.00000      0.23975      0.38379     13.57813      0.54532     -0.00105      0.44139      2.41602      1.77751      0.41194
   2453.00000     61.12500      5.00056      6.03067      6.50490    165.12500      0.22607      0.38379     13.32813      0.46295      0.04444      0.35496      2.48828      1.91836      0.34328
   2453.50000     61.12500      4.50440      7.51476      6.63335    167.37500      0.52002      0.68799     12.33594      0.34771      0.04794      0.24636      3.49414      2.11541      0.26254
   2454.00000     65.87500      4.85930      6.01682      7.03462    170.00000      2.29492      1.47461     11.71875      0.19430      0.07069      0.24726      4.23828      2.37775      0.21343
   2454.50000     61.93750      6.78664      5.74618      7.75649    172.12500      9.25781      6.73438     11.58594      0.02850      0.11351      0.26443      3.87695      2.66126      0.22576
   2455.00000     54.18750     11.92694      7.83336      7.54361    173.50000      2.29297      2.72656     11.83594      0.03128      0.05962      0.20462      3.35547      2.65650      0.20246
   2455.50000     36.65625     26.47536     14.06158      9.65043    174.37500      4.56250      3.19336     11.64844      0.04246      0.00477      0.07221      3.36914      2.63738      0.07222
   2456.00000     25.70313     89.21013     21.34259     18.34636    175.00000     16.15625     16.78125     11.36719     -0.02079      0.00357     -0.00323      4.64063      2.74556      0.00628
   2456.50000     12.83594    128.89081     33.36008     53.70303    175.25000     21.46875     22.64063     11.27344     -0.11042      0.01145     -0.01027      5.39063      2.89881     -0.01306
   2457.00000     11.77344    204.02628     56.14806    156.65717    175.62500     21.28125     25.35938     11.27344     -0.15634     -0.00481     -0.01079      5.50391      2.97735     -0.01796
   2457.50000      8.88281   2000.00000    147.38843    236.20972    176.12500     21.28125     34.06250     11.26563     -0.16303     -0.00463     -0.01100      5.59766      2.98878     -0.01823
   2458.00000      9.86719   2000.00000    682.57922    325.10608    176.50000     23.96875     31.78125     11.24219     -0.16187     -0.00359     -0.01151      5.14453      2.98679     -0.01847
   2458.50000      8.89844   2000.00000   2000.00000    444.63074    177.00000     25.23438     31.48438     11.21094     -0.15729     -0.00039     -0.01170      5.61328      2.97896     -0.01919
   2459.00000      9.85938   2000.00000   2000.00000    629.89429    177.25000     32.71875     40.31250     11.12500     -0.16830      0.00033     -0.01169      6.07813      2.99779     -0.01844
   2459.50000      9.85938   2000.00000   2000.00000   1079.82202    177.25000     24.35938     36.12500     11.12500     -0.15505     -0.00290     -0.01173      6.57422      2.97514     -0.01853
   2460.00000      8.88281    602.81213   2000.00000   1706.50708    177.50000     33.84375     43.93750     11.12500     -0.14907      0.00075     -0.01098      6.32813      2.96491     -0.01807
   2460.50000     10.85156    286.99316   2000.00000   1706.50708    177.62500     31.89063     49.18750     11.12500     -0.13380     -0.00516     -0.01029      6.25000      2.93879     -0.01658
   2461.00000     12.78906    194.15057    300.19482   1923.65649    177.62500     27.65625     40.71875     11.12500     -0.13095     -0.01014     -0.00970      5.96875      2.93393     -0.01460
   2461.50000     15.83594    230.45215    136.14713   1923.65649    177.75000     27.14063     33.43750     11.12500     -0.13538     -0.00943     -0.00822      5.21484      2.94149     -0.01090
   2462.00000     17.82813    130.87314     96.77287    414.17645    177.75000     24.78125     32.06250     11.12500     -0.13010     -0.00388     -0.00565      5.15625      2.93247     -0.00478
   2462.50000     20.92188     77.76567     81.95447    141.94754    177.75000     23.42188     32.03125     11.16406     -0.13371     -0.00393      0.00012      5.15625      2.93864      0.00346
   2463.00000     23.82813     53.27824     60.60203     92.17931    177.37500     15.11719     20.84375     11.27344     -0.12046     -0.00146      0.00380      5.88672      2.91599      0.01282
   2463.50000     25.85938     33.01211     41.85772    101.45911    177.12500     11.42188     16.42188     11.24219     -0.10864      0.00865      0.00596      5.62891      2.89578      0.01835
   2464.00000     28.68750     21.72231     22.09510    179.96927    176.75000     15.64844     20.60938     11.12500     -0.09681      0.00906      0.01393      5.93359      2.87555      0.03144
   2464.50000     36.25000     24.98950     10.60181     68.25014    176.62500     40.21875     50.28125     11.12500     -0.07662      0.01895      0.10199      4.11719      2.84102      0.06422
   2465.00000     46.84375     32.18890      9.21569     23.93888    176.37500     32.81250     48.96875     11.16406      0.04126      0.01273      0.17233      3.55469      2.63944      0.13444
   2465.50000     48.81250     31.79739     17.31518     15.80491    176.12500      1.06738      1.76172     11.63281      0.12455     -0.00059      0.15048      2.91406      2.49702      0.14363
   2466.00000     37.25000     33.53976     77.22366     20.52600    176.37500      9.82031      4.83594     11.09375      0.12304     -0.00816      0.04292      3.46875      2.49961      0.05195
   2466.50000     23.62500     24.35704     47.01328     52.76581    176.37500     24.06250     35.71875     10.97656      0.00816      0.01143     -0.00154      4.90625      2.69604      0.01462
   2467.00000     19.81250     14.91245     20.05639    414.17645    176.87500     30.87500     38.56250     10.98438     -0.15124      0.04008      0.00410      4.84375      2.96861      0.01176
   2467.50000     26.57813     16.50047     10.47587    124.42314    177.62500     37.40625     47.96875     10.99219     -0.14812      0.03282      0.08484      3.89844      2.96328      0.03850
   2468.00000     36.46875     20.63844      9.41276     42.70453    177.62500     18.78125     26.64063     11.10938     -0.04038      0.01469      0.14385      3.67773      2.77905      0.11229
   2468.50000     37.21875     17.39504     12.10418     32.58060    177.87500      1.17383      1.70801     11.25781      0.03386      0.00071      0.13842      3.82813      2.65211      0.14493
   2469.00000     41.09375     15.03190     12.17368     32.75710    177.62500     14.85156      8.75000     11.12500      0.04025      0.00876      0.09105      5.03516      2.64117      0.11836
   2469.50000     46.09375     13.56017      8.56519     19.59481    178.75000     40.40625     46.00000     11.12500     -0.00160      0.03438      0.11216      4.92969      2.71273      0.11367
   2470.00000     57.00000     11.77714      7.29597     11.39646    180.12500     11.42188     14.50781     11.17969      0.02075      0.01479      0.16065      4.24609      2.67452      0.13953
   2470.50000     60.15625     11.70642      7.84503     11.10349    181.62500      2.26758      2.58398     11.24219      0.04652     -0.00123      0.15697      3.95508      2.63045      0.15796
   2471.00000     55.09375     10.63398      8.55824     13.60090    182.37500      4.72266      2.85156     11.15625      0.05372      0.00341      0.12388      3.71484      2.61813      0.13261
   2471.50000     54.25000      8.75440      7.54709     16.90984    182.12500      9.56250      6.78906     10.98438      0.01873      0.00847      0.10989      3.77930      2.67798      0.12364
   2472.00000     53.37500      7.38794      6.37914     16.09947    181.12500     10.23438      7.25000     11.03906      0.01032      0.01015      0.11151      3.54492      2.69236      0.13445
   2472.50000     60.50000      6.26868      5.28189     15.01977    179.37500      4.94922      3.92578     11.07031      0.00393      0.00622      0.12601      4.34766      2.70328      0.16042
   2473.00000     66.56250      6.38488      3.69762     14.14163    176.50000      8.40625      5.69531     11.10938      0.06554      0.01232      0.22677      2.77930      2.59793      0.20712
   2473.50000     77.18750      8.15350      3.01532     15.24700    174.12500      6.83203      5.46484     11.31250      0.27853     -0.00127      0.36726      2.34766      2.23372      0.31289
   2474.00000     80.00000      9.90732      3.94726     12.32564    174.37500      1.05371      1.06348     12.72656      0.40951     -0.01182      0.45577      1.81738      2.00974      0.38245
   2474.50000     74.81250     11.16400      9.08880      9.51378    175.87500      0.53320      0.67041     12.44531      0.44301     -0.01567      0.37498      1.98438      1.95245      0.33720
   2475.00000     57.28125     11.68746     32.25151      8.78153    178.25000      2.18750      1.61816     11.16406      0.33604     -0.00471      0.20123      3.03125      2.13537      0.18148
   2475.50000     40.53125     10.30375     28.69605     12.35082    181.25000     11.79688      8.93750     10.92188      0.14272      0.00571      0.04088      4.05078      2.46594      0.04963
   2476.00000     24.79688     11.94081     22.51532     31.72592    181.87500     56.28125     61.78125     10.67969     -0.06109      0.01343     -0.00537      5.59375      2.81447      0.00201
   2476.50000     19.81250     25.91406     29.73563    101.45911    182.25000     52.31250     69.18750     10.67969     -0.14535      0.01246     -0.01169      5.68750      2.95855     -0.01559
   2477.00000     14.83594    128.48535     52.04871    325.10608    182.50000     45.43750     61.12500     10.66406     -0.18590      0.00814     -0.01273      6.10547      3.02789     -0.02103
   2477.50000     14.75781   2000.00000     84.54393    521.29138    182.75000     42.87500     57.56250     10.66406     -0.17764      0.00059     -0.01171      6.21094      3.01376     -0.02051
   2478.00000     13.73438   2000.00000    203.34442    414.17645    183.25000     41.71875     58.46875     10.67969     -0.16742     -0.00312     -0.01023      6.53125      2.99630     -0.01706
   2478.50000     14.71875   2000.00000   2000.00000    267.56506    183.37500     40.15625     57.75000     10.66406     -0.15024     -0.00880     -0.00882      6.48438      2.96691     -0.01290
   2479.00000     14.70313   2000.00000   2000.00000    236.20972    183.87500     25.89063     30.59375     10.67969     -0.14334     -0.01086     -0.00718      6.74609      2.95512     -0.00938
   2479.50000     14.70313    158.97879    195.90765    308.51898    184.12500     36.40625     47.56250     10.66406     -0.14249     -0.01127     -0.00486      6.91797      2.95367     -0.00347
   2480.00000     17.57813     61.25228     72.02594    364.27551    184.00000     32.18750     40.06250     10.66406     -0.14402     -0.00669      0.00509      6.76953      2.95627      0.00657
   2480.50000     20.56250     42.80680     44.28620    169.85861    184.12500     31.95313     47.75000     10.67969     -0.11191      0.00174      0.02703      5.65234      2.90136      0.03055
   2481.00000     26.43750     31.27847     43.38725     79.98627    184.25000     24.04688     29.17188     10.68750     -0.07023     -0.00056      0.04666      5.16016      2.83009      0.05943
   2481.50000     27.40625     25.71454     37.58707     46.65865    184.37500     16.93750     19.23438     10.82813     -0.03456     -0.00132      0.04620      4.82813      2.76910      0.06672
   2482.00000     28.45313     22.51367     25.11483     37.18919    184.50000     13.75781     19.89063     10.82813     -0.05196      0.00262      0.03134      5.03516      2.79886      0.06559
   2482.50000     28.45313     20.40169     18.04967     31.56034    184.75000     19.54688     20.56250     10.82813     -0.05905      0.01194      0.05415      5.04297      2.81098      0.06281
   2483.00000     29.64063     19.65430     15.68073     27.78934    184.62500     13.89844     18.04688     10.82813     -0.06827      0.00956      0.07087      5.07031      2.82675      0.07604
   2483.50000     29.73438     21.59299     17.66015     26.68562    184.25000      6.36328      6.19922     10.85938     -0.04713      0.00391      0.06021      5.08984      2.79059      0.07386
   2484.00000     28.89063     23.08339     23.56064     32.40601    183.75000      6.91016      6.26953     10.88281     -0.05745      0.00410      0.02010      5.64844      2.80823      0.04544
   2484.50000     27.76563     23.68789     30.94263     62.59795    183.37500     29.32813     36.21875     10.82813     -0.08433      0.00727      0.00185      6.28125      2.85420      0.01682
   2485.00000     23.67188     23.48478     32.94827    169.85861    182.62500     28.03125     45.12500     10.82813     -0.11491      0.00579     -0.00320      6.92578      2.90650      0.00498
   2485.50000     19.59375     22.76774     30.07080    387.62665    181.87500     26.95313     47.34375     10.83594     -0.14328      0.00177     -0.00175      5.97266      2.95501      0.00513
   2486.00000     18.62500     21.11961     24.09319    236.20972    181.12500     37.87500     49.50000     10.93750     -0.14574     -0.00108      0.00667      5.60938      2.95922      0.01562
   2486.50000     25.76563     20.80655     16.33124     75.02434    180.75000     33.65625     47.18750     10.97656     -0.14257      0.00526      0.04805      5.00391      2.95380      0.04478
   2487.00000     35.75000     22.34238     12.21576     25.99725    180.37500     15.64063     21.93750     11.05469     -0.08023      0.01277      0.12585      4.67188      2.84719      0.10216
   2487.50000     44.75000     23.04081     13.38761     16.44984    180.50000      2.98828      4.19141     11.22656     -0.01719      0.00955      0.16513      4.48047      2.73939      0.15426
   2488.00000     41.59375     23.05143     19.25821     15.36321    180.75000      5.68359      2.26172     11.18750      0.03288      0.01386      0.14189      4.52344      2.65377      0.14396
   2488.50000     33.62500     22.26266     25.53585     21.24722    181.37500      9.99219     10.84375     11.10156      0.00208      0.03328      0.07120      4.96484      2.70645      0.08978
   2489.00000     22.70313     20.66842     27.87142     44.59411    182.25000     12.82031     16.06250     10.85938     -0.03303      0.02986      0.01850      5.53125      2.76649      0.04733
   2489.50000     21.64063     20.08071     27.30078    106.83682    182.75000     30.89063     35.34375     10.71875     -0.10118      0.02603      0.00560      6.14844      2.88302      0.02823
   2490.00000     24.57813     23.95745     26.22668    185.48981    182.50000     45.75000     61.87500     10.71875     -0.12401      0.01183      0.00745      6.48047      2.92206      0.02332
   2490.50000     30.46875     28.71413     23.61283     96.59685    182.25000     45.43750     60.87500     10.71094     -0.12654      0.00799      0.01877      5.50781      2.92639      0.03163
   2491.00000     35.43750     27.09412     22.90244     55.68105    182.00000     21.59375     26.96875     10.68750     -0.10904     -0.00142      0.02472      5.31641      2.89645      0.04615
   2491.50000     37.43750     23.53178     19.68556     42.70453    181.25000     20.15625     10.03906     10.67969     -0.09075     -0.00743      0.03098      5.28516      2.86519      0.05336
   2492.00000     37.34375     20.67271     14.00593     29.84679    180.37500     39.71875     28.71875     10.68750     -0.08997     -0.00246      0.04556      5.08984      2.86385      0.06351
   2492.50000     41.40625     16.57653     12.00819     21.24722    179.50000     27.37500     30.62500     10.82813     -0.07730      0.00347      0.07366      4.91016      2.84218      0.08022
   2493.00000     42.37500     13.98606     10.73080     17.49699    178.62500     14.10156      8.59375     10.82813     -0.04792     -0.00239      0.10867      4.69531      2.79194      0.11249
   2493.50000     50.28125     13.50977      9.02665     17.19841    177.37500      5.30859      3.72852     10.90625      0.00258      0.01998      0.17109      3.65039      2.70559      0.15307
   2494.00000     54.09375     12.64894      8.79358     17.14963    176.25000      7.64453      5.12500     11.07813      0.09753      0.03059      0.22121      3.36719      2.54323      0.19501
   2494.50000     57.18750     11.95838     10.09596     17.05291    175.12500      1.34668      1.85059     11.13281      0.16882      0.04625      0.22066      2.87891      2.42132      0.21106
   2495.00000     50.28125     11.42090     11.71612     22.76717    174.50000      6.40625      2.54883     11.03906      0.17447      0.04683      0.16271      3.73438      2.41166      0.19064
   2495.50000     48.37500     11.86239      9.91609     24.62117    174.12500     18.32813      8.32031     10.77344      0.11376      0.08367      0.19217      3.83398      2.51547      0.15510
   2496.00000     47.25000     13.51349      9.07318     24.82332    174.37500     26.10938     14.57031     10.65625      0.07494      0.10570      0.21178      3.90430      2.58185      0.18689
   2496.50000     50.25000     16.10134     13.82354     20.66630    175.12500      0.45313      1.20605     10.81250      0.12382      0.06009      0.18141      3.52344      2.49826      0.16711
   2497.00000     42.43750     19.42397     25.47485     27.66222    175.62500     19.70313     10.46875     10.62500      0.13109      0.01140      0.07274      3.94336      2.48584      0.10023
   2497.50000     36.56250     25.19703     19.15424     48.92364    176.12500     38.21875     24.43750     10.46875      0.02851      0.03351      0.03341      4.91797      2.66124      0.06654
   2498.00000     33.65625     30.36254     13.48972     47.38998    176.12500     59.65625     44.68750     10.51563     -0.07763      0.06627      0.07411      4.19922      2.84274      0.06938
   2498.50000     34.46875     39.21886     16.90239     32.58060    176.12500     12.94531     10.18750     10.57031     -0.03689      0.00006      0.06955      3.78906      2.77308      0.08682
   2499.00000     31.53125     42.95224     42.69390     29.41129    175.87500      6.44531      3.12109     10.56250      0.00146     -0.01562      0.03504      3.83203      2.70750      0.05031
   2499.50000     23.57813     27.31174     37.71980     48.14460    175.37500     93.12500     81.31250     10.38281     -0.04809     -0.00429      0.00721      5.78516      2.79223      0.03628
   2500.00000     22.64063     16.28978     12.62296    141.94754    175.25000    136.37500    142.75000     10.38281     -0.10308      0.00569      0.04966      6.06641      2.88627      0.04489
   2500.50000     33.53125     17.46556      6.01682    127.03708    175.00000     67.43750     51.78125     10.45313     -0.01686     -0.00654      0.21894      3.60547      2.73882      0.12097
   2501.00000     55.34375     32.09141      5.07648     44.59411    174.50000     41.59375     33.71875     10.73438      0.29333     -0.02194      0.42907      3.13281      2.20840      0.28630
   2501.50000     65.31250     40.07457      9.15975     46.30139    174.50000      0.98730      1.06348     11.10938      0.39440     -0.01466      0.44787      2.16016      2.03558      0.42681
   2502.00000     60.18750     31.82756    318.01215     65.30197    174.62500      0.60010      0.88477     11.53125      0.39408     -0.01508      0.27874      2.65820      2.03612      0.23008
   2502.50000     42.25000     19.37099   2000.00000    179.96927    175.12500     49.59375     29.03125     10.50781      0.22466      0.00986      0.06482      3.70508      2.32583      0.07764
   2503.00000     26.45313     10.93042     44.47047   2000.00000    176.37500    102.43750    128.12500     10.24219     -0.02902      0.05956      0.00732      5.43359      2.75963      0.04389
   2503.50000     26.65625      9.60555     12.09037    129.76318    177.62500     59.18750     61.21875     10.22656     -0.10462      0.02079      0.04845      4.78516      2.88889      0.04780
   2504.00000     34.84375     13.18639      7.84503     26.10950    178.50000     82.18750     72.18750     10.22656     -0.05439      0.02152      0.20251      3.62109      2.80301      0.10558
   2504.50000     53.09375     19.62134      8.48255     14.14163    179.37500      0.97363      2.56641     10.37500      0.11335      0.00801      0.26712      3.02734      2.51617      0.21305
   2505.00000     55.93750     26.85112     14.02443     13.53999    180.50000      1.18652      1.51074     10.53125      0.18038      0.00038      0.20712      2.59180      2.40156      0.18561
   2505.50000     44.81250     27.50264     26.03460     19.65852    182.00000     12.98438      4.44531     10.07813      0.16306      0.00215      0.05295      3.36328      2.43116      0.05710
   2506.00000     26.45313     17.28577     29.81873     44.92542    183.62500     89.68750     77.00000      9.92969      0.01760      0.02994      0.00169      5.39453      2.67990      0.01692
   2506.50000     15.61719     12.55799     21.13089    256.22754    184.87500     87.93750    113.31250      9.92969     -0.10453      0.02091      0.00179      6.59766      2.88875      0.00761
   2507.00000     22.60938     12.10973     14.50333    219.09305    186.00000    104.87500    121.37500      9.92969     -0.12809      0.01494      0.01933      6.09375      2.92904      0.02145
   2507.50000     35.43750     12.17390     11.40092     65.30197    186.75000     70.37500     76.37500      9.96094     -0.09382      0.01824      0.07149      4.78906      2.87042      0.05835
   2508.00000     51.25000     13.74436      9.02665     26.45214    186.50000      3.80273      3.40625     10.03125     -0.03667      0.02329      0.16797      4.12891      2.77270      0.11262
   2508.50000     58.12500     17.07712      8.95014     16.63080    185.62500     13.68750      7.78906      9.93750      0.06012      0.03237      0.19461      3.65625      2.60719      0.18102
   2509.00000     52.25000     17.82518     13.82354     13.30171    184.50000      1.98828      2.17188     10.18750      0.11741      0.01852      0.14003      3.58984      2.50923      0.14241
   2509.50000     39.40625     17.19424     27.44124     17.14963    183.00000     19.85938     10.96094      9.89063      0.10516      0.00420      0.03212      3.96875      2.53018      0.03988
   2510.00000     25.59375     17.53045     28.16576     37.41931    182.00000     47.53125     49.03125      9.74219     -0.00794      0.01805     -0.00267      5.07813      2.72358      0.00386
   2510.50000     16.67188     17.27371     27.72654    169.85861    181.75000     72.31250     76.50000      9.60938     -0.13985      0.04301     -0.00592      5.11328      2.94915     -0.00931
   2511.00000     12.73438     23.42150     32.94827    444.63074    181.00000     63.59375     99.62500      9.56250     -0.15325      0.00555     -0.00707      4.84375      2.97206     -0.01244
   2511.50000     10.77344     42.29654     67.48323    629.89429    180.50000     64.43750    119.25000      9.48438     -0.14642     -0.00528     -0.00749      5.04688      2.96038     -0.01379
   2512.00000     10.82031     73.36467    139.69882    916.21167    179.62500     88.37500    148.50000      9.48438     -0.15742     -0.00493     -0.00750      5.27344      2.97919     -0.01482
   2512.50000      9.83594    116.73146    160.65201   1314.56812    179.12500    101.43750    164.75000      9.48438     -0.15153     -0.01061     -0.00595      5.56250      2.96911     -0.01330
   2513.00000      8.90625    212.50290    114.34204    570.46997    178.62500     83.50000    152.25000      9.48438     -0.15259     -0.00769     -0.00326      6.14844      2.97092     -0.00748
   2513.50000     14.77344     89.48434     89.49184    165.21765    178.00000     88.37500    138.50000      9.48438     -0.13641     -0.01094      0.00262      5.88281      2.94326      0.00104
   2514.00000     18.79688     42.66234     67.06024     77.92477    177.00000     54.75000     42.28125      9.48438     -0.12453     -0.00876      0.00739      5.58594      2.92294      0.01421
   2514.50000     21.73438     23.65706     39.53453     69.82635    175.25000     56.50000     82.50000      9.48438     -0.11311     -0.00920      0.01297      5.14453      2.90342      0.02344
   2515.00000     20.79688     13.83927     21.00587     57.26290    174.25000     67.18750     60.28125      9.48438     -0.10897     -0.00819      0.01980      5.57031      2.89634      0.03531
   2515.50000     28.76563      9.12954     11.43785     37.18919    173.50000     58.75000     69.18750      9.48438     -0.09955     -0.00490      0.04268      5.28516      2.88023      0.05083
   2516.00000     41.50000      6.99090      6.77421     14.94553    172.87500     28.40625     16.92188      9.48438     -0.06411      0.00425      0.09423      4.02734      2.81963      0.07977
   2516.50000     56.53125      5.82521      4.93249      7.78645    173.50000     57.31250     58.71875      9.48438     -0.00028      0.00297      0.16392      3.21875      2.71047      0.13201
   2517.00000     69.06250      5.19250      4.18123      5.17896    173.87500      2.10742      2.22656      9.48438      0.07635     -0.00009      0.21794      2.66211      2.57943      0.19138
   2517.50000     74.31250      4.95378      3.92483      4.80070    175.00000      4.16016      2.79883      9.48438      0.11480      0.00555      0.26205      2.49609      2.51370      0.22224
   2518.00000     82.31250      4.83506      4.12309      4.45744    175.62500      3.49609      2.47656      9.50000      0.13122      0.00676      0.25458      2.44727      2.48561      0.23476
   2518.50000     74.56250      4.81664      4.82744      4.38949    175.37500      3.57617      2.60156      9.37500      0.12186     -0.00141      0.20663      2.79883      2.50163      0.19479
   2519.00000     61.46875      5.13451      5.86526      6.28843    175.12500      5.80469      3.69336      9.28906      0.07717     -0.00209      0.11477      3.62305      2.57805      0.11876
   2519.50000     39.43750      5.68326      7.04198     15.09476    175.12500     20.26563     12.92188      9.19531      0.01298      0.00229      0.04565      4.73828      2.68780      0.06306
   2520.00000     30.46875      6.57160      8.09200     35.03454    175.12500     80.43750     83.75000      9.17969     -0.06255      0.00607      0.02818      5.25391      2.81696      0.04529
   2520.50000     30.40625      8.19059      9.08099     46.30139    174.75000     47.65625     54.96875      9.05469     -0.08696      0.00425      0.04730      4.78906      2.85870      0.04899
   2521.00000     39.31250     10.26496      9.93473     25.55774    174.37500     32.59375     29.01563      9.04688     -0.07745      0.00320      0.07549      4.30078      2.84244      0.06726
   2521.50000     44.15625     11.61432     10.81854     15.84633    173.75000     16.59375     11.11719      8.92969     -0.04081      0.00006      0.09485      4.10547      2.77979      0.08957
   2522.00000     49.15625     11.96498     11.14890     13.39008    173.50000     15.32031      8.30469      8.89844     -0.01835     -0.00236      0.09589      3.79688      2.74139      0.09971
   2522.50000     45.06250     11.62541     10.73080     13.30171    173.25000     25.76563     15.53125      8.89844     -0.01251     -0.00075      0.08572      3.75195      2.73139      0.09412
   2523.00000     45.84375     11.14928     10.44485     13.60090    173.00000     12.19531      8.87500      8.89844     -0.02431     -0.00198      0.07797      3.71484      2.75157      0.08551
   2523.50000     45.00000     11.56194     10.64446     13.30171    172.75000     18.03125      9.73438      8.89844     -0.03929     -0.00219      0.09084      3.76172      2.77719      0.07945
   2524.00000     44.18750     13.08339     11.88697     14.65574    172.50000     35.84375     27.04688      8.89844     -0.05745     -0.00249      0.08918      3.94727      2.80825      0.08533
   2524.50000     36.71875     15.20816     15.47522     17.75385    172.25000     14.64844      9.86719      8.89844     -0.05625     -0.00508      0.07086      3.85547      2.80619      0.07329
   2525.00000     28.78125     18.16302     21.17290     27.91764    171.50000     45.09375     27.78125      8.89844     -0.06148     -0.00414      0.03076      4.09766      2.81512      0.04868
   2525.50000     22.84375     22.05603     28.85124     58.93725    171.00000    110.81250     99.50000      8.88281     -0.07005     -0.00290      0.01360      4.62109      2.82978      0.02752
   2526.00000     21.71875     27.28202     37.58707    141.94754    171.00000    102.56250    121.75000      8.89844     -0.09573     -0.00015      0.00871      4.87109      2.87370      0.01893
   2526.50000     19.70313     38.00122     49.86404    308.51898    171.25000    122.37500    151.37500      8.89844     -0.10477      0.00076      0.00745      4.52344      2.88916      0.01504
   2527.00000     18.65625     54.18909     69.22983    343.57800    171.25000    117.50000    137.37500      8.89844     -0.10722     -0.00116      0.00690      4.21484      2.89335      0.01383
   2527.50000     17.73438     65.39156     92.58803    325.10608    171.50000    104.75000    130.00000      8.89844     -0.11455     -0.00465      0.00770      3.78125      2.90588      0.01435
   2528.00000     24.71875     61.71750    100.40318    279.95233    172.25000     97.31250    106.50000      8.89844     -0.12310     -0.00338      0.00868      4.15625      2.92049      0.01570
   2528.50000     29.71875     49.39703     72.51404    308.51898    172.50000     93.50000    102.18750      8.89844     -0.12854     -0.00133      0.00945      3.79297      2.92980      0.01799
   2529.00000     34.78125     30.99417     43.21181    293.54230    173.12500    109.56250    125.12500      8.89844     -0.11658     -0.00498      0.01243      3.98828      2.90934      0.02587
   2529.50000     44.62500     21.09950     23.66526     93.60623    173.87500    124.31250    141.37500      8.89844     -0.10595     -0.00387      0.03789      3.81641      2.89117      0.03984
   2530.00000     52.56250     16.48534     14.82729     30.60203    174.37500     50.15625     56.90625      8.89844     -0.07703     -0.00242      0.08703      3.70898      2.84172      0.07368
   2530.50000     63.31250     13.09301     11.63891     17.10113    174.25000     10.47656      8.21875      8.89844     -0.03666     -0.00233      0.10151      3.40430      2.77269      0.11023
   2531.00000     58.09375     10.59331      9.67117     15.17050    174.12500     10.20313      6.69922      9.00781     -0.02262     -0.00226      0.09194      3.80664      2.74868      0.12470
   2531.50000     54.96875     10.16841      7.44567     14.51502    173.25000     26.78125     19.21875      9.09375     -0.02722      0.00872      0.15479      4.03516      2.75655      0.12327
   2532.00000     48.06250     10.60838      6.81375     11.75080    171.75000     34.87500     19.39063      9.38281      0.04426      0.00861      0.19528      3.71289      2.63432      0.16030
   2532.50000     46.34375     10.70262      8.96534     10.05146    171.00000      1.32031      1.51074      9.90625      0.11431     -0.00813      0.16645      3.46289      2.51453      0.14825
   2533.00000     38.56250     11.27663     14.38545     14.04310    170.25000     46.62500     26.73438      9.32813      0.12961     -0.01957      0.06011      3.40820      2.48836      0.06376
   2533.50000     28.70313     11.54549     16.23150     31.39647    170.62500     53.75000     53.90625      9.34375      0.03056      0.00026      0.01134      5.02734      2.65774      0.02915
   2534.00000     19.75000     11.00784     15.49779     66.74350    171.62500     78.93750     82.93750      9.34375     -0.08842      0.01160      0.01309      5.23828      2.86120      0.02228
   2534.50000     21.71875     12.19824     14.52316     58.36836    172.12500     33.62500     33.62500      9.34375     -0.12670      0.00190      0.02612      5.75391      2.92665      0.02915
   2535.00000     28.51563     15.05026     14.13647     38.86222    172.00000     88.56250     80.93750      9.34375     -0.11464      0.00342      0.05413      5.00000      2.90604      0.04825
   2535.50000     34.56250     16.60993     13.85964     24.62117    171.50000     39.53125     68.12500      9.32813     -0.08698     -0.00312      0.08140      4.35547      2.85874      0.07269
   2536.00000     39.43750     17.75020     14.70413     19.78717    171.37500     22.20313      9.81250      9.28906     -0.06969      0.00131      0.08994      3.63477      2.82917      0.08887
   2536.50000     42.43750     19.23977     15.70391     20.25104    171.00000     26.18750     18.85938      9.31250     -0.06112      0.00439      0.08418      3.64648      2.81451      0.08744
   2537.00000     46.18750     19.05168     17.68952     24.12993    170.62500     38.09375     18.92188      9.32031     -0.05834      0.00658      0.06644      3.68945      2.80976      0.07863
   2537.50000     43.25000     19.23605     20.52019     29.70020    170.37500     23.71875     16.12500      9.34375     -0.06138      0.00138      0.04828      3.64648      2.81496      0.06187
   2538.00000     37.37500     21.72940     25.53585     45.60303    170.50000     44.50000     27.93750      9.34375     -0.07061      0.00274      0.02401      3.98633      2.83074      0.04701
   2538.50000     31.65625     25.14009     31.49037     99.78487    170.75000     92.93750     79.37500      9.34375     -0.09437      0.00070      0.01681      4.20313      2.87137      0.03271
   2539.00000     28.76563     27.54417     36.55789    197.61334    171.00000    107.50000    104.12500      9.37500     -0.11015      0.00037      0.01756      4.50781      2.89836      0.03094
   2539.50000     32.65625     27.41622     38.81631    132.60889    171.37500     85.43750     96.43750      9.44531     -0.11352     -0.00285      0.02556      3.85938      2.90413      0.03734
   2540.00000     33.40625     25.43379     34.32529     75.02434    171.87500     40.84375     36.09375      9.48438     -0.09082     -0.00308      0.03189      3.54492      2.86530      0.05077
   2540.50000     37.40625     22.16379     25.23370     55.17302    172.12500     37.21875     27.09375      9.48438     -0.07382     -0.00509      0.03133      3.63281      2.83622      0.05839
   2541.00000     37.31250     18.54481     17.51476     42.70453    172.75000     67.37500     41.81250      9.51563     -0.06598     -0.00308      0.03406      4.48438      2.82282      0.06490
   2541.50000     40.56250     15.03993     12.63801     26.22272    173.37500     54.03125     50.09375      9.69531     -0.05501      0.00184      0.06659      4.76953      2.80407      0.07839
   2542.00000     48.37500     13.03639     10.19326     14.27516    173.62500      8.55469      8.48438      9.89063     -0.01141      0.02433      0.13534      4.04297      2.72950      0.11043
   2542.50000     52.34375     10.67494     10.18345     12.03135    173.37500      5.05859      5.25000     10.07813      0.05990      0.00778      0.15874      3.80273      2.60757      0.14849
   2543.00000     52.15625      8.22199     10.23270     14.27516    172.87500      2.34766      2.72656     10.17969      0.08333      0.00283      0.12986      4.20703      2.56751      0.14582
   2543.50000     43.15625      6.67936      7.62359     20.59591    172.25000     27.56250     18.82813     10.20313      0.03686      0.02291      0.09646      4.40234      2.64696      0.13478
   2544.00000     48.15625      6.31740      5.24214     15.84633    171.75000     25.59375     25.68750     10.28125     -0.01817      0.08394      0.17437      3.71875      2.74107      0.14833
   2544.50000     59.31250      6.35885      4.80519      8.97708    171.37500      2.77539      2.49414     10.50781      0.15354      0.01446      0.21834      3.04102      2.44745      0.21965
   2545.00000     65.50000      6.60653      5.79708      6.91397    171.50000      0.64014      1.13477     11.00000      0.23225     -0.00280      0.22394      3.08203      2.31285      0.20299
   2545.50000     59.81250      7.28278      6.84481      9.16762    171.37500     11.18750      7.14453     10.31250      0.22984      0.00062      0.19681      3.34180      2.31697      0.17092
   2546.00000     56.81250      7.72137      6.95809     12.90431    171.37500     22.35938     18.28125     10.22656      0.11522      0.04848      0.18164      4.03906      2.51297      0.17084
   2546.50000     49.81250      7.71604      8.43507     15.01977    171.62500      3.89648      3.62305     10.23438      0.05912      0.02656      0.12695      3.53906      2.60891      0.13320
   2547.00000     40.71875      8.51959     11.43785     18.45836    171.50000      3.64258      3.40625     10.23438      0.03999      0.00000      0.03682      4.00000      2.64162      0.05696
   2547.50000     24.68750      8.64656     12.69854     40.15247    171.37500     54.68750     56.18750     10.22656     -0.04199      0.01253      0.00619      5.14844      2.78180      0.03571
   2548.00000     20.60938      7.71479      9.42956    141.94754    171.37500     69.56250     94.50000     10.24219     -0.13782      0.06043      0.02319      4.16406      2.94567      0.04123
   2548.50000     33.34375      7.91643      6.28364     47.38998    171.25000     62.43750     86.87500     10.37500     -0.06558      0.03895      0.14475      3.57617      2.82214      0.09683
   2549.00000     47.25000      9.06879      5.08886     13.39008    170.87500     29.10938     25.89063     10.66406      0.17215     -0.00736      0.27022      3.14258      2.41562      0.19245
   2549.50000     62.06250      9.44410      5.56589      8.09933    170.50000      1.08008      1.40332     11.16406      0.28735     -0.02052      0.31994      2.99609      2.21863      0.26528
   2550.00000     55.25000      9.27842      7.56879      8.19815    170.50000     28.42188      5.41016     10.70313      0.30288     -0.01730      0.23067      3.11523      2.19208      0.22845
   2550.50000     45.31250      8.71183      9.87903     10.54212    171.62500      2.13477      2.49414     10.53906      0.20775     -0.00561      0.11772      3.64648      2.35476      0.11773
   2551.00000     27.62500      7.76173     11.32777     23.38345    173.12500     25.70313     24.85938     10.38281      0.05857     -0.00768      0.03714      4.19922      2.60984      0.06500
   2551.50000     19.64063      7.40700     10.79647     53.23030    174.37500     20.48438      9.61719     10.39063     -0.05340     -0.00254      0.01561      4.99609      2.80131      0.04635
   2552.00000     19.54688      8.07992      9.26418     73.20778    174.87500     45.75000     61.68750     10.38281     -0.12015      0.00727      0.05911      5.08984      2.91545      0.05307
   2552.50000     35.25000      9.49202      7.76981     31.23430    175.00000     37.96875     66.62500     10.38281     -0.04148      0.02441      0.16851      3.94336      2.78094      0.10257
   2553.00000     43.15625      9.71684      8.36815     18.45836    174.62500      7.08594      8.75781     10.45313      0.08773     -0.00689      0.18917      3.65039      2.55998      0.16851
   2553.50000     47.28125      8.54622      9.09663     17.96482    174.12500      7.12109      3.65625     10.42969      0.12267     -0.01359      0.14460      3.70898      2.50023      0.15167
   2554.00000     43.28125      7.69012      6.89873     20.95274    173.75000     79.06250     80.75000     10.38281      0.07210      0.01124      0.11469      3.72656      2.58671      0.13499
   2554.50000     54.25000      7.00934      5.34402     15.36321    174.50000     54.15625     51.84375     10.38281      0.01490      0.05247      0.18928      3.24609      2.68452      0.16079
   2555.00000     66.12500      7.13950      5.42162     10.22136    175.75000      0.92041      2.33398     10.51563      0.12724      0.00526      0.26360      2.82813      2.49242      0.21622
   2555.50000     65.43750      8.17165      6.97194     10.01816    177.00000      3.20313      2.13672     10.38281      0.16219      0.00442      0.20256      3.00586      2.43265      0.21306
   2556.00000     49.65625      8.85220      9.83310     12.47825    178.00000      2.09375      2.58398     10.42969      0.12903      0.00952      0.09445      3.92578      2.48936      0.09606
   2556.50000     29.82813      9.26055     12.41604     28.57732    178.62500     20.14063     18.28125     10.11719     -0.00409      0.02004      0.01421      5.20703      2.71699      0.03572
   2557.00000     22.70313     11.04287     14.66353     63.25274    179.37500     23.53125     39.93750     10.08594     -0.10011      0.03231      0.00802      5.03516      2.88119      0.02072
   2557.50000     20.67188     14.02899     19.32814     88.14815    180.25000     23.37500     37.46875      9.96875     -0.12244      0.00487      0.01208      4.68750      2.91936      0.02239
   2558.00000     18.73438     18.38681     25.05581    106.83682    181.25000     28.60938     30.14063      9.92969     -0.11368     -0.00902      0.01043      4.88281      2.90440      0.02500
   2558.50000     17.79688     21.83403     25.29356    211.43246    181.87500     53.37500     73.50000      9.92969     -0.12466     -0.00754      0.01198      5.01172      2.92317      0.02630
   2559.00000     25.87500     25.09914     19.25821     96.59685    182.37500     61.50000    104.56250      9.92969     -0.12445     -0.00378      0.03738      4.60938      2.92281      0.04009
   2559.50000     37.84375     23.13683     16.79560     30.75768    182.50000     38.59375     61.43750      9.92969     -0.09758     -0.00450      0.08130      4.09766      2.87685      0.07036
   2560.00000     45.71875     17.29936     19.08555     18.86139    182.62500     10.46094     14.39063      9.92969     -0.05915     -0.01274      0.08290      3.78125      2.81115      0.09192
   2560.50000     38.62500     12.42157     18.36114     23.29338    182.37500     23.67188     13.25781      9.92969     -0.05182     -0.01414      0.05554      4.08984      2.79861      0.06880
   2561.00000     36.43750      9.24498     11.56269     39.62622    181.62500     48.53125     62.18750      9.92969     -0.08885     -0.00806      0.04076      4.74609      2.86193      0.06435
   2561.50000     39.46875      7.04152      7.39856     38.12712    181.12500     58.56250     80.37500      9.92969     -0.08736     -0.00530      0.09671      3.81250      2.85939      0.08933
   2562.00000     62.03125      6.33645      5.20556     13.88191    180.12500     12.51563     16.98438      9.92969     -0.02907     -0.00522      0.21701      3.01953      2.75971      0.17694
   2562.50000     77.68750      6.12975      4.62799      8.28805    179.75000      5.68359      3.92578     10.14844      0.11370     -0.00818      0.29224      2.58789      2.51557      0.26541
   2563.00000     85.31250      5.57638      4.98673      7.13421    180.12500      1.08008      1.45703     10.85156      0.18140     -0.01377      0.26650      2.59180      2.39981      0.26587
   2563.50000     78.50000      5.19382      5.18746      8.06692    180.62500      2.90820      1.49316      9.88281      0.17177     -0.00340      0.20476      3.40039      2.41627      0.21168
   2564.00000     71.68750      5.28953      4.75259      9.32310    182.12500     36.15625     28.00000      9.78906      0.08016      0.01804      0.21635      3.77344      2.57292      0.17890
   2564.50000     64.62500      5.42066      4.94887      8.58212    182.50000      7.21875      7.94922      9.78906      0.01909      0.02103      0.22203      3.69141      2.67736      0.20708
   2565.00000     52.81250      6.02142      6.24250      8.40322    182.75000      2.97461      2.83398      9.79688      0.02267     -0.00190      0.17779      3.55469      2.67124      0.16029
   2565.50000     36.15625      6.86510      8.32193     13.27252    182.12500     13.66406      6.42969      9.78906     -0.00090     -0.00584      0.05519      4.40625      2.71154      0.07552
   2566.00000     21.70313      6.92898      9.39602     37.41931    181.25000     18.65625     15.04688      9.76563     -0.07353      0.00172      0.01113      4.92578      2.83574      0.03423
   2566.50000     19.89063      6.75618      8.42833     85.65103    180.75000     88.68750     95.62500      9.75000     -0.12755      0.00260      0.01588      5.12891      2.92811      0.03277
   2567.00000     30.87500      7.10245      6.57492     39.88760    180.12500     90.25000    141.00000      9.75000     -0.11113      0.00468      0.10806      3.64844      2.90003      0.06433
   2567.50000     53.34375      7.22824      5.66533      9.71243    179.87500     14.80469     15.89063      9.74219      0.04067     -0.00651      0.20728      2.93945      2.64046      0.16209
   2568.00000     63.12500      6.87839      5.76199      4.93388    181.00000      1.70703      2.52930      9.85938      0.15393     -0.02023      0.25528      2.47461      2.44678      0.22521
   2568.50000     63.87500      6.34332      5.94177      5.32960    181.00000      3.88281      2.02930      9.59375      0.18294     -0.01268      0.22958      2.57031      2.39717      0.21970
   2569.00000     54.93750      5.64979      5.53643      6.72931    181.75000      6.12500      4.19141      9.51563      0.12851      0.00321      0.18787      2.92578      2.49025      0.20619
   2569.50000     59.06250      5.35761      4.95358      7.59096    180.75000      6.24609      4.58594      9.48438      0.07934      0.01758      0.22061      2.77148      2.57433      0.19843
   2570.00000     64.25000      5.69883      5.10878      6.42883    178.50000      7.48438      5.05469      9.48438      0.12785      0.01336      0.26936      2.67969      2.49138      0.22374
   2570.50000     61.71875      6.28956      6.46958      5.55480    176.25000      1.20020      1.81445      9.59375      0.17724      0.00530      0.25735      2.72070      2.40692      0.23183
   2571.00000     44.75000      6.95634      8.23742      9.03070    175.25000      7.71484      3.63867      9.42969      0.18148     -0.00095      0.18439      2.93555      2.39966      0.16809
   2571.50000     30.79688      7.59843      8.98059     20.04960    174.87500     20.00000     24.20313      9.32031      0.12493      0.00513      0.09882      3.41016      2.49636      0.11985
   2572.00000     32.56250      8.39507      8.99589     24.03402    175.12500     13.08594     21.26563      9.25000      0.06268      0.00677      0.10007      3.35938      2.60281      0.10033
   2572.50000     42.18750     10.12370      9.75146     14.87201    175.12500     24.20313     26.31250      9.26563      0.04002     -0.00947      0.13139      3.35156      2.64156      0.11184
   2573.00000     48.00000     12.39794     12.21576     11.57091    174.37500     17.56250     16.81250      9.25000      0.03140     -0.01070      0.14185      3.33203      2.65630      0.13644
   2573.50000     41.15625     14.47719     14.76546     16.44984    173.00000     14.26563     13.67188      9.21094      0.03287     -0.01320      0.12500      3.95898      2.65379      0.12752
   2574.00000     35.46875     15.87109     16.28122     30.91493    171.12500     13.04688     20.50000      9.31250      0.01308     -0.00786      0.08938      4.63672      2.68764      0.10357
   2574.50000     32.53125     16.50735     17.80797     53.23030    169.50000     29.09375     35.75000      9.34375      0.00083     -0.00832      0.07580      4.82813      2.70858      0.08670
   2575.00000     35.50000     16.95574     19.75863     49.72830    168.50000     19.32813     30.40625      9.34375     -0.01834     -0.00655      0.06547      4.18359      2.74136      0.08081
   2575.50000     41.43750     17.68528     21.00587     42.40506    167.62500     49.25000     46.90625      9.34375     -0.02166     -0.00586      0.06340      3.90430      2.74704      0.07377
   2576.00000     48.40625     17.21816     20.24708     37.18919    167.25000     64.31250     73.43750      9.34375     -0.03195     -0.00441      0.06199      3.89063      2.76463      0.07585
   2576.50000     56.40625     15.63358     18.45668     35.65425    166.87500     54.93750     48.40625      9.38281     -0.03471     -0.00557      0.06648      3.83203      2.76935      0.07741
   2577.00000     51.40625     13.85978     15.68073     30.29539    166.50000     64.75000     63.18750      9.40625     -0.02658     -0.00634      0.07330      3.69531      2.75546      0.08315
   2577.50000     48.28125     12.08948     12.63801     19.98335    167.00000     50.50000     70.06250      9.46875     -0.00534     -0.00625      0.09578      3.57813      2.71913      0.09428
   2578.00000     45.06250     10.82138     10.49665     13.88191    167.50000     30.87500     27.20313      9.48438      0.01822     -0.01104      0.11193      3.47852      2.67884      0.11243
   2578.50000     48.00000      9.68174      9.09663     12.03135    168.62500     22.84375     17.62500      9.48438      0.03373     -0.01057      0.12482      3.28320      2.65232      0.12270
   2579.00000     46.25000      8.34996      8.13572     10.92298    170.00000     16.12500     11.70313      9.48438      0.03047     -0.00833      0.12603      3.20703      2.65790      0.12984
   2579.50000     42.34375      7.32960      7.30611     10.34376    171.37500     11.87500      8.32031      9.54688      0.02846     -0.00605      0.13528      3.12891      2.66134      0.13363
   2580.00000     46.46875      6.64275      6.67097     10.10184    172.87500     15.39844      8.66406      9.63281      0.02652     -0.00663      0.13491      3.30078      2.66465      0.14494
   2580.50000     48.37500      6.16846      6.18726      9.75946    174.62500     17.98438     10.21875      9.63281      0.02818     -0.00747      0.13453      3.21875      2.66181      0.15371
   2581.00000     55.21875      6.14207      5.62574      8.59431    176.12500     11.92969      7.52344      9.66406      0.03620     -0.00872      0.14527      3.16016      2.64809      0.16755
   2581.50000     56.93750      6.74068      5.33311      6.40839    177.12500      8.56250      5.71484      9.78906      0.07057      0.00340      0.22317      2.88281      2.58932      0.18502
   2582.00000     57.03125      7.45743      6.14376      5.09175    177.75000      6.08594      4.37109      9.79688      0.12353      0.00228      0.26687      2.71094      2.49877      0.23105
   2582.50000     48.06250      7.87549      8.57215      5.61672    177.12500      2.01367      2.47656      9.92969      0.14013     -0.00502      0.21581      2.81836      2.47038      0.20496
   2583.00000     35.43750      7.69853     10.86294     12.32564    176.62500     58.06250     19.45313      9.92969      0.07127      0.00668      0.09105      3.99609      2.58812      0.08889
   2583.50000     26.45313      6.75521     10.25254     48.53099    175.87500     95.68750     92.81250      9.92969     -0.05683      0.03751      0.01416      5.39844      2.80718      0.04539
   2584.00000     27.59375      5.95094      7.87434     66.74350    175.12500     72.37500     82.25000      9.92969     -0.13546      0.02448      0.01675      5.52344      2.94163      0.03712
   2584.50000     42.46875      5.51793      5.79708     18.68653    174.37500     76.43750     64.56250      9.92969     -0.09970      0.00793      0.07388      4.53906      2.88049      0.06106
   2585.00000     64.93750      5.06522      4.44606      6.14778    174.50000     20.68750     15.00000     10.00781     -0.01293      0.00890      0.14413      3.50195      2.73211      0.12322
   2585.50000     79.50000      4.53833      3.79672      3.43070    175.50000      7.03125      4.19141     10.06250      0.08656      0.01318      0.24319      2.90234      2.56199      0.19424
   2586.00000     84.31250      4.02335      3.51512      2.78585    177.12500      2.36133      2.26172     10.20313      0.13168      0.02261      0.27409      2.59961      2.48482      0.28129
   2586.50000     84.75000      3.53766      3.31819      2.90496    178.62500      2.49414      1.94043     10.22656      0.13579      0.02996      0.28166      2.70703      2.47780      0.27190
   2587.00000     88.43750      3.17364      3.10756      3.24826    179.50000      2.24023      2.58398     10.21875      0.10793      0.04130      0.26263      2.79883      2.52543      0.26475
   2587.50000     91.75000      3.01406      2.98895      3.68807    179.75000      4.18750      2.63672     10.20313      0.10805      0.03625      0.25724      2.66211      2.52523      0.25790
   2588.00000     91.62500      2.99024      3.01443      3.83544    180.00000      3.86914      2.63672     10.23438      0.12062      0.00783      0.25290      2.74609      2.50374      0.25694
   2588.50000     86.37500      2.97875      3.11038      4.40227    180.12500      2.85547      2.22461     10.19531      0.10509      0.00266      0.22065      2.90820      2.53029      0.24327
   2589.00000     88.81250      2.99976      3.06762      4.98677    179.50000      4.72266      2.79883     10.08594      0.07444      0.00754      0.20320      3.37109      2.58272      0.21801
   2589.50000     90.25000      3.10385      2.93585      4.31433    178.12500      5.33594      3.55078     10.09375      0.08432      0.01435      0.22518      3.23633      2.56581      0.22551
   2590.00000     97.18750      3.24334      2.99156      3.21032    177.75000      4.00000      2.65625     10.26563      0.12816      0.01089      0.26164      3.10156      2.49085      0.24869
   2590.50000     94.56250      3.34649      3.25212      2.75538    177.50000      1.38770      1.68945     10.40625      0.16506      0.00398      0.28581      2.78125      2.42774      0.26682
   2591.00000     86.12500      3.41243      3.45390      3.00604    178.62500      2.60156      1.94043     10.07031      0.14507      0.00825      0.26925      2.89844      2.46193      0.26358
   2591.50000     79.93750      3.37864      3.53923      3.42682    179.75000      5.29688      2.92383      9.92969      0.08315      0.03183      0.25527      3.02344      2.56781      0.23353
   2592.00000     73.81250      3.29718      3.63390      4.46732    180.50000      3.60156      2.51172      9.92969      0.03724      0.01743      0.21936      3.39844      2.64632      0.22413
   2592.50000     77.62500      3.30315      3.56244      6.90608    180.50000      3.56250      2.40625      9.92969      0.02391      0.00381      0.19270      3.70898      2.66912      0.20164
   2593.00000     83.37500      3.37673      3.29588      7.22802    180.25000      7.66016      4.96094      9.92969      0.02022      0.00786      0.18760      3.53320      2.67543      0.20343
   2593.50000     93.12500      3.45765      3.20749      4.88604    180.37500      6.25781      5.12500     10.00000      0.04412      0.00598      0.22680      3.36523      2.63456      0.21731
   2594.00000     94.81250      3.49986      3.37916      3.39221    180.50000      2.09375      1.90430     10.00781      0.07748     -0.00125      0.25395      3.10938      2.57752      0.23968
   2594.50000     88.06250      3.44781      3.54897      4.01631    180.50000      3.25586      2.06445      9.91406      0.08738     -0.00168      0.23060      3.04102      2.56058      0.23284
   2595.00000     76.37500      3.40589      3.40935      4.78550    180.25000      4.61719      3.26367      9.79688      0.06688      0.00456      0.19970      3.10352      2.59564      0.20235
   2595.50000     69.87500      3.60896      3.27594      4.15999    179.62500      9.17969      5.66016      9.78906      0.04588      0.00895      0.22724      2.87305      2.63155      0.20094
   2596.00000     71.00000      4.12835      3.66094      3.26757    178.75000      4.40234      3.58594      9.78906      0.06041      0.00612      0.27307      2.83984      2.60670      0.22437
   2596.50000     65.18750      4.82967      4.81406      3.39031    176.87500      3.06836      2.20703      9.78906      0.07735      0.00071      0.23011      2.87695      2.57774      0.22607
   2597.00000     48.50000      5.43312      6.47756      5.87883    174.87500      8.00781      4.21094      9.58594      0.05641      0.00019      0.11964      3.35742      2.61353      0.10877
   2597.50000     27.75000      5.70549      7.92766     17.24746    172.25000     62.65625     52.21875      9.52344     -0.00879      0.00378      0.01572      4.28125      2.72504      0.03792
   2598.00000     16.79688      5.92932      8.64944     55.17302    169.37500     79.43750     76.81250      9.48438     -0.08049      0.00364      0.00427      4.78906      2.84764      0.01495
   2598.50000     16.78125      6.29126      8.30882     45.26169    166.62500     97.62500    163.75000      9.48438     -0.11563     -0.00224      0.01783      5.27344      2.90772      0.01720
   2599.00000     19.73438      6.54044      7.31118     18.51488    163.50000     89.31250    145.62500      9.46875     -0.08975     -0.00694      0.07805      4.13281      2.86347      0.04531
   2599.50000     23.71875      6.47695      6.35211      9.95221    160.00000     52.06250     79.43750      9.42188     -0.03670     -0.01113      0.13603      3.45313      2.77276      0.10181
   2600.00000     29.65625      6.04919      5.79708      9.45428    156.25000      5.40234      6.87891      9.27344      0.02792     -0.01142      0.16148      2.85547      2.66226      0.15088
   2600.50000     29.71875      5.23977      5.50149     11.02253    152.75000      4.25391      6.64453      9.14063      0.06483     -0.00693      0.15892      2.71484      2.59914      0.15782
   2601.00000     32.71875      4.55124      5.07402     13.21451    149.87500      5.36328      6.80859      8.75781      0.08988     -0.00083      0.15874      2.79883      2.55631      0.16027
   2601.50000     33.75000      4.22381      4.62388     12.35082    147.25000      4.20313      6.91406      8.85938      0.10079      0.00576      0.17235      2.92188      2.53765      0.16056
   2602.00000     39.40625      4.14279      4.43847     10.72917    144.62500      4.34766      6.71484      8.85938      0.11120      0.00863      0.18299      3.03711      2.51985      0.17095
   2602.50000     39.46875      4.25266      4.53128     10.90328    142.00000      4.98828      6.71484      8.80469      0.11245      0.00965      0.19081      3.01563      2.51771      0.17603
   2603.00000     40.34375      4.44484      4.75259     12.32564    138.87500      3.54883      6.55469      8.75000      0.10725      0.01285      0.18042      3.08789      2.52660      0.17952
   2603.50000     37.46875      4.53560      4.98196     13.53999    136.12500      4.07031      6.10938      8.75000      0.10044      0.01452      0.17869      3.13281      2.53825      0.16830
   2604.00000     38.37500      4.59363      5.22902     13.78696    133.75000      3.99023      6.50000      8.60156      0.10432      0.00808      0.17200      3.12891      2.53161      0.17019
   2604.50000     38.37500      4.72503      5.40201     14.37699    132.00000      5.26953      7.91406      8.60156      0.10297      0.00629      0.17435      3.10547      2.53391      0.16374
   2605.00000     39.43750      4.87268      5.54524     14.72713    130.75000      5.05469      8.30469      8.60156      0.10277      0.00402      0.16347      3.04297      2.53426      0.16637
   2605.50000     37.34375      5.03249      5.68997     14.01057    130.00000      5.49609      8.27344      8.61719      0.10569     -0.00080      0.16762      2.92969      2.52927      0.15688
   2606.00000     34.37500      5.16589      5.87183     13.57038    129.12500      5.56641      8.23438      8.60156      0.10881      0.00076      0.16361      2.80273      2.52393      0.15924
   2606.50000     31.25000      5.24186      5.96545     13.78696    129.00000      5.88281      8.69531      8.60156      0.11083     -0.00093      0.16234      2.73438      2.52048      0.15778
   2607.00000     33.28125      5.20871      5.92832     14.69135    128.87500      6.13672      9.16406      8.60156      0.10605      0.00106      0.15602      2.70703      2.52866      0.15683
   2607.50000     35.46875      5.19000      5.80673     15.80491    129.12500      6.25781      9.23438      8.60156      0.10000      0.00262      0.14874      2.72070      2.53899      0.15138
   2608.00000     39.68750      5.14027      5.68379     16.31668    129.50000      5.55078      8.83594      8.60156      0.09053      0.00533      0.13738      2.85156      2.55519      0.14727
   2608.50000     39.75000      5.06382      5.55407     16.63080    129.87500      5.87109      8.62500      8.63281      0.08288      0.00504      0.12828      2.96484      2.56827      0.13199
   2609.00000     42.53125      4.94092      5.45557     17.39632    130.25000      5.55078      8.50000      8.72656      0.07697      0.00906      0.12223      2.98242      2.57838      0.12220
   2609.50000     40.34375      4.83275      5.34949     17.96482    131.00000      6.12500      9.75781      8.68750      0.07327      0.00895      0.12518      2.95703      2.58472      0.11845
   2610.00000     37.43750      4.72282      5.18232     17.80613    131.12500      7.55469     11.81250      8.67188      0.06104      0.01339      0.12984      2.86523      2.60562      0.12243
   2610.50000     35.28125      4.70447      5.00587     16.36082    131.25000      6.78906     11.47656      8.69531      0.06010      0.01347      0.14463      2.83789      2.60722      0.13178
   2611.00000     36.53125      4.73452      4.93016     14.87201    131.50000      6.32422     10.31250      8.61719      0.06952      0.01368      0.15549      2.77539      2.59113      0.14808
   2611.50000     39.53125      4.80406      4.96064     14.24154    131.00000      5.76172      9.43750      8.61719      0.08559      0.00849      0.16647      2.85742      2.56363      0.15573
   2612.00000     41.68750      4.88404      5.18489     14.83553    130.75000      5.87109      9.23438      8.55469      0.08852      0.00949      0.16711      2.91797      2.55863      0.16307
   2612.50000     43.56250      4.97904      5.56293     16.40521    130.37500      5.64453      8.55469      8.56250      0.09990      0.00691      0.16435      2.94727      2.53917      0.16045
   2613.00000     44.43750      5.08068      5.93168     18.29087    130.12500      5.42969      8.42969      8.60156      0.11491      0.00598      0.16236      2.81250      2.51351      0.15713
   2613.50000     39.59375      5.20723      6.28364     19.22111    130.12500      5.37500      8.60938      8.60156      0.12688      0.00240      0.16287      2.75391      2.49304      0.15744
   2614.00000     35.37500      5.32845      6.50163     18.07220    130.37500      5.40234      8.87500      8.57813      0.12745      0.00310      0.16169      2.67188      2.49206      0.15803
   2614.50000     30.46875      5.32028      6.45367     16.31668    131.00000      5.30859      8.62500      8.56250      0.12790      0.00469      0.16172      2.63672      2.49130      0.15599
   2615.00000     31.28125      5.16691      6.16544     16.05672    131.87500      4.92188      7.96875      8.60156      0.13409      0.00239      0.15620      2.67188      2.48071      0.15471
   2615.50000     34.46875      4.96213      5.60465     16.31668    133.25000      4.89844      8.02344      8.60156      0.13459     -0.00131      0.16266      2.65625      2.47984      0.15386
   2616.00000     35.43750      4.72479      5.01549     14.98256    135.00000      4.92188      8.21875      8.64844      0.12388      0.00044      0.15966      2.68359      2.49817      0.15921
   2616.50000     34.75000      4.48706      4.62799     12.63468    137.62500      5.44141      8.53906      8.73438      0.10894      0.00303      0.17245      2.66992      2.52372      0.16117
   2617.00000     32.68750      4.30951      4.41585     11.63772    142.00000      7.09766     10.68750      8.76563      0.10093     -0.00018      0.17585      2.68945      2.53741      0.17706
   2617.50000     36.68750      4.18093      4.25492     11.75080    147.50000      5.89844      9.48438      8.80469      0.10008      0.00048      0.17895      2.65625      2.53887      0.17464
   2618.00000     36.56250      4.13283      4.10189     10.90328    154.50000      6.51172      9.75781      8.85938      0.09440      0.00181      0.17762      2.61133      2.54857      0.17224
   2618.50000     40.56250      4.18103      4.07931      8.41492    162.62500      6.43359      9.57813      8.90625      0.09202     -0.00267      0.17396      2.68945      2.55265      0.17487
   2619.00000     44.37500      4.29982      4.22376      5.96583    171.00000     11.14063     12.18750      9.03125      0.06950     -0.00260      0.17300      2.78906      2.59115      0.17988
   2619.50000     54.00000      4.42651      4.41773      4.72197    178.25000      8.14844      6.51953      9.07813      0.05152     -0.00146      0.17278      2.85352      2.62190      0.18692
   2620.00000     59.75000      4.57726      4.57109      4.36730    183.00000      7.01953      4.87109      9.17969      0.03219     -0.00223      0.18356      2.88477      2.65496      0.18838
   2620.50000     66.62500      4.75172      4.74393      4.35785    185.00000      6.09766      4.44141      9.19531      0.02804     -0.00260      0.19165      2.95508      2.66205      0.19413
   2621.00000     63.84375      4.95930      4.92550      4.32667    185.00000      5.94922      4.14063      9.19531      0.02031     -0.00145      0.19146      3.07617      2.67527      0.19122
   2621.50000     61.15625      5.15312      5.16438      4.36100    183.00000      5.77734      4.06641      9.19531      0.01655      0.00257      0.20506      3.02930      2.68170      0.18336
   2622.00000     55.53125      5.32259      5.39644      4.69995    179.62500      6.00391      4.21094      9.19531      0.01717     -0.00163      0.20553      3.07617      2.68065      0.18858
   2622.50000     52.43750      5.51875      5.59565      5.55991    175.62500      9.36719      5.75000      9.19531      0.01276     -0.00045      0.20072      3.01172      2.68817      0.18097
   2623.00000     50.15625      5.70760      5.81640      6.86686    171.00000     17.89063     10.73438      9.19531      0.01082     -0.00264      0.17933      3.11914      2.69150      0.17489
   2623.50000     48.00000      5.85257      6.05506      8.97708    166.75000     19.04688     10.82813      9.19531      0.00500     -0.00357      0.16823      3.16211      2.70145      0.15991
   2624.00000     56.81250      6.01461      6.14737     11.20638    163.12500     24.53125     18.40625      9.19531      0.01244     -0.00985      0.15302      3.12891      2.68873      0.15492
   2624.50000     61.00000      6.15625      6.14376     11.06286    160.00000     24.12500     27.92188      9.17969      0.01517     -0.00881      0.14050      3.03516      2.68405      0.14328
   2625.00000     66.93750      6.24041      6.21292      9.61973    156.75000     25.42188     21.26563      9.17188      0.00672     -0.00707      0.13811      3.12891      2.69851      0.13563
   2625.50000     66.12500      6.37901      6.29495      9.46909    153.25000     20.18750     12.29688      9.16406     -0.00788     -0.00282      0.13746      3.19531      2.72348      0.13609
   2626.00000     72.93750      6.56401      6.45367     10.86410    148.87500     34.12500     30.04688      9.07813     -0.01234     -0.00085      0.13652      3.37891      2.73110      0.13454
   2626.50000     71.75000      6.77199      6.73513     12.93191    144.62500     31.84375     31.37500      9.06250     -0.00133     -0.00179      0.13058      3.40820      2.71227      0.13205
   2627.00000     74.56250      7.00128      7.28083     15.40234    140.25000     22.10938     29.73438      9.05469      0.00386     -0.00143      0.12605      3.54297      2.70341      0.12681
   2627.50000     69.87500      7.23598      8.02424     19.65852    136.62500     15.39844     24.04688      9.04688      0.00229     -0.00164      0.12563      3.42773      2.70608      0.12106
   2628.00000     79.06250      7.47272      8.74984     25.99725    133.00000      6.49609     11.60156      9.03125     -0.00001      0.00485      0.13107      3.36133      2.71002      0.12093
   2628.50000     80.68750      7.79897      9.39602     31.39647    129.50000      4.33594      7.32422      8.89844      0.00618      0.00949      0.13093      3.09766      2.69943      0.12823
   2629.00000     92.56250      8.22412     10.08633     33.85756    126.81250      4.44141      7.25391      8.87500      0.01679      0.01243      0.14125      3.19922      2.68129      0.13040
   2629.50000     91.43750      8.69720     10.78547     34.04820    124.43750      4.78906      7.77344      8.87500      0.02361      0.01433      0.13591      3.20703      2.66962      0.14034
   2630.00000     95.87500      9.02534     11.31567     33.85756    122.62500      5.15234      8.42969      8.89844      0.02632      0.02373      0.14865      3.43555      2.66500      0.13721
   2630.50000     99.81250      9.13865     11.40092     34.04820    121.25000      4.97656      7.94922      8.88281      0.04454      0.01637      0.14580      3.34570      2.63383      0.14905
   2631.00000    102.50000      9.01898     11.41321     34.04820    120.06250      4.29688      7.39844      8.89844      0.06047      0.01374      0.15148      3.26172      2.60659      0.14934
   2631.50000    105.62500      8.86119     11.05578     33.48262    119.18750      4.26953      7.30859      8.88281      0.07165      0.01329      0.15232      3.08008      2.58747      0.15230
   2632.00000     96.50000      8.81032     10.66592     33.48262    118.06250      4.00391      6.78516      8.84375      0.06893      0.01494      0.14845      3.01953      2.59212      0.14479
   2632.50000     92.93750      8.93504     10.49665     33.48262    117.43750      3.08203      7.23438      8.88281      0.05950      0.01199      0.15245      3.00586      2.60825      0.14401
   2633.00000     90.68750      9.14039     10.58061     32.40601    116.87500      4.00391      6.46484      8.88281      0.04749      0.01194      0.15692      3.08594      2.62880      0.15392
   2633.50000     87.81250      9.42515     10.96419     28.71301    116.87500      4.38672      7.27344      8.77344      0.04669      0.01385      0.17489      3.17578      2.63015      0.16404
   2634.00000     88.62500      9.82517     11.75512     26.92324    116.62500      4.60156      7.52344      8.75000      0.06064      0.01249      0.17177      3.12891      2.60630      0.16973
   2634.50000     79.56250     10.43702     12.79042     28.17782    116.25000      4.80078      7.77344      8.75000      0.08036      0.00856      0.16927      3.11328      2.57258      0.15925
   2635.00000     78.12500     11.10343     13.91414     30.75768    116.00000      4.29688      7.64844      8.75000      0.07521      0.01189      0.16222      2.97266      2.58139      0.16316
   2635.50000     71.93750     11.76009     15.14436     30.44794    115.68750      4.38672      7.50391      8.75000      0.07123      0.01411      0.16717      2.98242      2.58819      0.16355
   2636.00000     70.12500     12.18606     16.10851     29.12794    115.56250      4.23047      7.07422      8.75000      0.07010      0.01270      0.17440      2.97266      2.59013      0.17125
   2636.50000     61.53125     12.53304     16.66400     29.41129    115.43750      4.12109      7.01953      8.75000      0.08131      0.00809      0.17477      3.04688      2.57097      0.17427
   2637.00000     55.09375     12.66532     16.66400     31.23430    115.00000      4.29297      7.25391      8.75000      0.08463      0.00832      0.17437      3.04883      2.56528      0.16827
   2637.50000     54.25000     12.81711     16.43221     33.66904    115.00000      4.14844      7.39844      8.75000      0.07719      0.00903      0.17272      2.98047      2.57801      0.16486
   2638.00000     51.31250     13.03292     16.25632     36.29628    115.00000      4.91016      7.94922      8.75000      0.06793      0.00754      0.16975      3.04492      2.59384      0.16463
   2638.50000     49.37500     13.18994     16.38157     38.12712    115.00000      4.12109      7.44922      8.75781      0.05976      0.00664      0.16648      3.17188      2.60781      0.16168
   2639.00000     47.46875     13.36891     16.87557     38.12712    114.75000      4.35938      7.52344      8.75781      0.06274      0.00471      0.16221      3.34375      2.60271      0.15999
   2639.50000     52.31250     13.41462     17.54365     37.88823    114.75000      4.72266      7.80859      8.75000      0.07160      0.00083      0.16707      3.19727      2.58756      0.16021
   2640.00000     61.31250     13.43391     18.14199     38.86222    114.75000      4.66797      8.16406      8.75000      0.08011     -0.00383      0.16190      3.08789      2.57301      0.15995
   2640.50000     75.75000     13.47636     18.55322     41.24803    113.62500      4.62891      7.84375      8.75000      0.07575     -0.00254      0.14919      2.92578      2.58047      0.14954
   2641.00000     84.81250     13.28378     18.42472     43.94594    113.50000      4.46875      7.77344      8.75000      0.06859      0.00127      0.13752      3.00195      2.59271      0.13725
   2641.50000     84.62500     12.80035     17.80797     46.65865    113.43750      5.01563      8.16406      8.78125      0.05227      0.00241      0.12383      2.99414      2.62062      0.12968
   2642.00000     87.25000     12.28879     16.40685     47.76431    113.37500      5.13672      8.64063      8.78125      0.04387      0.00398      0.12055      3.16797      2.63498      0.11918
   2642.50000     98.25000     11.90874     15.05849     46.30139    113.00000      5.20313      8.85938      8.87500      0.03338      0.00753      0.10726      3.11914      2.65292      0.11459
   2643.00000    110.37500     11.60948     14.36599     42.40506    113.06250      5.75000      9.57813      8.89844      0.03263      0.00553      0.11042      3.16406      2.65420      0.10600
   2643.50000    108.75000     11.30283     14.28866     40.96857    113.31250      6.31250     10.17188      8.88281      0.02305      0.00547      0.10805      3.03516      2.67059      0.10874
   2644.00000     96.37500     10.78411     14.17422     42.70453    113.56250      5.42969      9.02344      8.89844      0.01611      0.00768      0.11187      3.13867      2.68245      0.10870
   2644.50000     89.56250     10.05004     13.73411     45.94955    113.75000      4.57813      8.26563      8.89844      0.01566      0.00685      0.11247      3.19922      2.68321      0.11382
   2645.00000     82.68750      9.35736     12.99411     48.53099    114.50000      4.65625      8.03906      8.89844      0.02052      0.00747      0.11808      3.21094      2.67492      0.11455
   2645.50000     79.06250      8.78288     11.96751     48.14460    115.12500      4.80078      8.16406      8.89844      0.02799      0.00930      0.12152      3.19922      2.66214      0.12132
   2646.00000     73.68750      8.34121     10.86294     42.70453    115.75000      4.66797      8.77344      8.89844      0.04008      0.00559      0.13052      3.03320      2.64146      0.13021
   2646.50000     68.93750      7.92994      9.89753     32.40601    116.62500      4.44141      8.28906      8.87500      0.05341      0.00298      0.14099      3.00586      2.61867      0.14484
   2647.00000     63.78125      7.60726      9.23180     23.65791    117.50000      4.18750      7.23828      8.78125      0.06050      0.00399      0.16687      2.93750      2.60654      0.15911
   2647.50000     54.78125      7.30358      8.90484     18.86139    118.37500      4.68359      7.43359      8.75781      0.08061      0.00090      0.19186      2.94531      2.57216      0.17724
   2648.00000     45.87500      7.00544      8.79358     16.90984    119.12500      4.57422      7.62891      8.89844      0.09736     -0.00007      0.21393      2.95703      2.54351      0.18945
   2648.50000     40.09375      6.73778      8.77895     16.36082    120.12500      4.83984      7.86328      8.89844      0.11224      0.00000      0.21882      2.79492      2.51806      0.20925
   2649.00000     36.53125      6.40104      8.62823     16.49471    121.37500      5.57422      8.39063      8.89844      0.11895     -0.00057      0.20956      2.76367      2.50659      0.21123
   2649.50000     35.56250      6.15747      8.08580     17.19841    122.75000      5.57422      8.67969      8.89844      0.11816      0.00224      0.18078      2.70703      2.50795      0.20035
   2650.00000     39.56250      5.95133      7.33156     17.34641    124.75000      4.91016      8.70313      8.90625      0.10783      0.00801      0.16151      2.83984      2.52561      0.17378
   2650.50000     45.31250      5.75385      6.66251     15.52095    126.87500      4.70703      7.43359      9.01563      0.09622      0.00920      0.15351      2.83789      2.54546      0.16000
   2651.00000     46.25000      5.64376      6.10442     12.32564    129.50000      3.70898      6.30469      9.06250      0.09682      0.00845      0.16048      2.84961      2.54443      0.15878
   2651.50000     47.12500      5.62763      5.79708     10.01816    131.50000      3.49609      5.92969      9.11719      0.10217      0.00960      0.17821      2.91016      2.53528      0.16229
   2652.00000     49.03125      5.64445      5.84236      9.65043    132.87500      3.94922      6.01953      9.19531      0.09785      0.00401      0.18104      2.99219      2.54268      0.16854
   2652.50000     50.06250      5.71747      6.23879     11.98367    133.12500      4.32031      6.89453      9.19531      0.07608      0.00002      0.16880      3.04492      2.57991      0.16193
   2653.00000     49.37500      5.91818      6.54623     17.49699    133.00000      4.44141      6.55469      9.19531      0.04349      0.00317      0.13118      2.91016      2.63564      0.13984
   2653.50000     45.53125      6.33452      6.89873     22.10146    133.75000      6.45703     10.04688      9.31250      0.02400      0.00228      0.10719      2.92773      2.66896      0.11447
   2654.00000     52.50000      7.08008      7.47740     22.34649    135.12500      9.03125     14.85156      9.34375      0.01053      0.00176      0.10717      2.90820      2.69200      0.10945
   2654.50000     50.25000      7.97477      8.56519     22.02098    136.75000     10.19531     15.73438      9.34375      0.00713      0.00111      0.11333      2.87891      2.69782      0.11255
   2655.00000     49.37500      8.30567      9.55748     25.23773    140.00000     10.93750     16.32813      9.37500      0.00714      0.00143      0.11045      2.92969      2.69779      0.11551
   2655.50000     47.15625      7.77887      9.61837     31.23430    144.87500     12.43750     20.92188      9.48438      0.00494     -0.00135      0.09899      3.01172      2.70155      0.11114
   2656.00000     49.93750      6.76736      8.35489     33.66904    149.87500     12.39844     19.76563      9.48438      0.00607     -0.00254      0.08863      3.09570      2.69962      0.10953
   2656.50000     58.68750      5.82594      6.41031     21.39759    155.37500     20.65625     27.87500      9.48438      0.00542     -0.00780      0.08234      3.14844      2.70074      0.11699
   2657.00000     74.87500      5.16502      4.79414      8.63111    161.50000     17.46875     23.50000      9.55469      0.02434      0.00065      0.10767      3.12891      2.66837      0.13898
   2657.50000     92.62500      4.74478      3.94877      3.58742    166.50000     12.96875     17.59375      9.64063      0.07966      0.01241      0.17324      2.79688      2.57378      0.17813
   2658.00000    100.68750      4.38248      3.74449      2.54117    171.37500      1.70801      2.09961      9.82813      0.19499      0.01743      0.25030      2.58594      2.37656      0.22249
   2658.50000     92.75000      4.01709      3.75128      2.48990    175.12500      2.29492      1.63574     10.04688      0.25875      0.02607      0.27537      2.41602      2.26754      0.25407
   2659.00000     82.25000      3.70117      3.70956      3.08424    177.75000      5.05469      2.92383      9.96094      0.25172      0.04657      0.25872      2.52344      2.27956      0.24721
   2659.50000     77.75000      3.49594      3.54775      3.65685    180.25000      5.97656      3.92578      9.92969      0.18267      0.05540      0.22798      2.79883      2.39764      0.23374
   2660.00000     78.56250      3.44706      3.50437      3.98718    181.75000      3.62891      2.85352      9.92969      0.10081      0.04681      0.21624      2.91992      2.53762      0.21317
   2660.50000     80.12500      3.53323      3.58844      3.84520    182.12500      6.13672      3.62109      9.92969      0.07357      0.01512      0.21908      3.10547      2.58420      0.20742
   2661.00000     77.56250      3.57717      3.73367      4.05129    181.62500      4.94922      3.83594      9.96875      0.06187      0.00528      0.21136      3.05664      2.60421      0.21124
   2661.50000     75.43750      3.56618      3.73907      4.74048    181.62500      5.04297      3.22852     10.03125      0.06412     -0.00072      0.18637      3.17578      2.60036      0.20588
   2662.00000     79.43750      3.62977      3.50675      4.63511    181.25000      5.96484      4.98047     10.04688      0.06284     -0.00082      0.18381      3.19922      2.60254      0.19571
   2662.50000     85.50000      3.70358      3.37584      3.53087    181.12500      6.37891      4.62109     10.03906      0.08675      0.00858      0.21526      3.06055      2.56166      0.21028
   2663.00000     89.62500      3.72220      3.52955      2.67375    181.62500      2.85547      2.83398     10.08594      0.11802      0.00668      0.25396      3.05469      2.50819      0.23839
   2663.50000     84.87500      3.72228      3.74178      3.03623    181.37500      4.94922      3.24609     10.15625      0.14328     -0.00081      0.24392      2.95508      2.46499      0.24177
   2664.00000     79.56250      3.61960      3.74992      3.77793    182.25000      8.01563      5.17578     10.04688      0.12184      0.00571      0.20836      3.06445      2.50165      0.21095
   2664.50000     78.37500      3.44856      3.69365      4.52414    182.37500      6.84375      4.71094     10.03125      0.08677      0.01218      0.18953      2.91406      2.56162      0.19458
   2665.00000     82.18750      3.45827      3.56983      4.31125    182.62500      7.50000      4.28125     10.03906      0.07343     -0.00203      0.19531      3.01758      2.58443      0.19959
   2665.50000     87.50000      3.51718      3.52232      3.71983    182.50000      7.67188      5.16016     10.07031      0.07761     -0.00233      0.21620      3.03906      2.57728      0.20996
   2666.00000     88.56250      3.50526      3.52593      3.47806    181.62500      3.66797      3.17383     10.08594      0.09546     -0.00585      0.21603      3.05078      2.54676      0.22203
   2666.50000     90.62500      3.54052      3.45622      3.28532    180.25000      5.33594      3.51367      9.96094      0.10634     -0.01280      0.22973      3.07031      2.52816      0.21460
   2667.00000     93.25000      3.54633      3.45506      2.96042    177.37500      6.81641      4.55078      9.92969      0.10092     -0.00674      0.22555      3.11133      2.53743      0.22798
   2667.50000     87.43750      3.47694      3.60977      3.00008    173.75000      3.34961      2.78125      9.92969      0.09535     -0.00206      0.22440      3.02148      2.54695      0.22199
   2668.00000     84.62500      3.53694      3.69233      4.24169    170.00000      5.58984      4.46094      9.85156      0.10375     -0.00642      0.21052      2.83008      2.53258      0.20783
   2668.50000     81.50000      3.70756      3.72560      6.24299    165.75000      7.15234      9.03906      9.68750      0.10932     -0.00215      0.21417      2.77148      2.52307      0.19100
   2669.00000     86.62500      3.96094      3.85757      7.13421    162.50000      5.57813      7.59375      9.63281      0.11729      0.00181      0.22614      2.85938      2.50944      0.19232
   2669.50000     77.56250      4.34891      4.33844      7.00204    159.87500      5.21484      6.69531      9.63281      0.12490     -0.00408      0.23368      3.10938      2.49642      0.19504
   2670.00000     66.50000      4.69681      5.15672      8.28805    156.50000      7.52344      8.59375      9.63281      0.11566     -0.00619      0.18839      3.09375      2.51222      0.19006
   2670.50000     55.65625      4.86164      5.85215     13.30171    153.00000     27.53125     22.84375      9.61719      0.07924     -0.00391      0.14538      2.92969      2.57450      0.14329
   2671.00000     60.65625      5.12288      5.95866     18.92040    148.87500     24.34375     35.78125      9.52344      0.02883     -0.00186      0.11607      2.76172      2.66070      0.12597
   2671.50000     79.25000      5.58683      5.92162     16.81580    144.87500     18.62500     26.85938      9.48438     -0.00069     -0.00104      0.14323      2.80859      2.71117      0.12954
   2672.00000    101.75000      6.13197      6.14017     12.10360    140.75000     13.53125     21.93750      9.48438      0.00469     -0.00054      0.17671      2.85938      2.70198      0.16750
   2672.50000    113.31250      6.58497      6.62051     10.88366    137.00000      5.72266      8.28906      9.38281      0.03461     -0.00175      0.19414      2.98047      2.65082      0.19816
   2673.00000     94.43750      6.76322      7.29597     13.10000    133.50000      4.50781      6.73438      9.19531      0.05803      0.00306      0.19467      3.06055      2.61077      0.19182
   2673.50000     73.93750      6.81121      7.95760     17.91161    130.25000      4.29297      7.07422      9.11719      0.07810      0.00916      0.18862      3.10352      2.57645      0.17637
   2674.00000     62.46875      7.09952      8.69219     23.11529    127.62500      4.62891      7.12891      9.04688      0.09394      0.00999      0.17848      3.14844      2.54937      0.17007
   2674.50000     67.56250      7.84561      9.83310     27.04365    125.50000      3.84375      6.89453      9.04688      0.09964      0.00989      0.17259      3.16016      2.53961      0.16615
   2675.00000     69.25000      8.91636     11.23167     29.55504    124.12500      4.02734      6.92969      9.04688      0.10236      0.00828      0.16832      3.11328      2.53496      0.16944
   2675.50000     61.06250     10.03075     12.63801     29.99484    122.62500      4.45313      7.41406      9.04688      0.10116      0.00492      0.17233      3.04102      2.53701      0.17073
   2676.00000     57.87500     10.88204     13.98747     29.99484    121.37500      4.39063      7.27344      9.04688      0.10142      0.00163      0.17680      3.08789      2.53657      0.17154
   2676.50000     58.59375     11.48490     14.88964     30.75768    120.12500      4.07031      7.09375      9.04688      0.10204      0.00016      0.16983      3.19727      2.53551      0.17040
   2677.00000     65.37500     11.89059     15.27500     32.23326    119.12500      4.20313      7.12891      9.04688      0.09716     -0.00433      0.16204      3.25977      2.54386      0.15886
   2677.50000     67.37500     12.18834     15.47522     34.83273    118.25000      4.26953      7.16406      9.04688      0.08383     -0.00240      0.14710      3.04102      2.56665      0.14976
   2678.00000     65.62500     12.53304     15.49779     40.15247    117.37500      4.02734      7.12891      9.04688      0.06640     -0.00234      0.13586      3.20313      2.59645      0.13785
   2678.50000     66.68750     12.85836     15.89176     46.30139    116.75000      4.05469      7.69922      9.04688      0.04845     -0.00212      0.13227      3.26367      2.62715      0.13051
   2679.00000     66.75000     13.25594     16.58601     48.92364    116.12500      3.83008      7.28906      9.11719      0.04459     -0.00151      0.13093      3.45898      2.63375      0.13080
   2679.50000     65.06250     13.64407     17.42867     51.86073    116.00000      4.16016      7.27344      9.11719      0.04298      0.00207      0.12978      3.40430      2.63650      0.13030
   2680.00000     55.50000     14.07924     17.83783     59.51734    115.87500      4.46875      7.87891      9.17969      0.05348     -0.00075      0.12333      3.18750      2.61855      0.12930
   2680.50000     46.75000     14.49532     18.14199     62.59795    115.62500      5.85547      9.95313      9.19531      0.05264      0.00183      0.12249      3.28125      2.61999      0.12835
   2681.00000     40.53125     14.73619     18.74934     56.19852    115.50000      6.36328     10.63281      9.14063      0.04991      0.00629      0.13344      3.15625      2.62466      0.13156
   2681.50000     40.40625     14.60502     19.46955     47.38998    115.62500      6.04297     10.84375      9.17188      0.05404      0.00485      0.14305      3.37695      2.61759      0.14124
   2682.00000     30.40625     14.12679     19.75863     44.92542    116.00000      4.46875      8.16406      9.11719      0.05716     -0.00006      0.14389      3.50586      2.61225      0.14597
   2682.50000     25.67188     13.48470     19.32814     44.92542    116.25000      3.54883      6.26953      9.11719      0.05952      0.00217      0.14990      3.61133      2.60822      0.14630
   2683.00000     21.82813     12.94763     18.20407     40.42087    116.75000      3.56250      6.32031      9.17969      0.06239      0.00167      0.16014      3.56836      2.60331      0.15887
   2683.50000     28.73438     12.51780     17.17537     33.66904    117.37500      3.37500      6.12500      9.19531      0.07764     -0.00361      0.18263      3.33008      2.57723      0.17068
   2684.00000     31.68750     12.12929     16.58601     28.57732    117.75000      3.41602      6.23438      9.19531      0.09414     -0.00531      0.19645      3.25195      2.54903      0.18721
   2684.50000     31.59375     11.72120     16.18208     26.22272    118.62500      3.45703      6.26953      9.19531      0.10670     -0.00049      0.20987      3.15430      2.52754      0.19322
   2685.00000     29.65625     11.09266     15.91556     26.10950    119.62500      4.13672      6.66406      9.19531      0.11580     -0.00367      0.20941      3.21484      2.51198      0.19802
   2685.50000     26.57813     10.28350     15.45271     29.12794    120.75000      5.40234      8.42969      9.27344      0.10948     -0.00560      0.18598      3.19922      2.52278      0.18639
   2686.00000     22.64063      9.45847     14.19316     38.12712    121.87500      5.61719      8.98438      9.32813      0.09342     -0.00614      0.14462      3.25195      2.55024      0.16388
   2686.50000     24.57813      8.78127     12.24398     37.88823    123.37500      6.83203     11.02344      9.34375      0.08031     -0.00396      0.12400      2.87109      2.57267      0.14050
   2687.00000     25.64063      8.23050     10.54897     26.22272    125.00000      7.14063     12.42188      9.35938      0.09415     -0.00858      0.13082      2.65234      2.54901      0.13773
   2687.50000     27.56250      7.90952      9.43798     18.74445    126.87500      5.53906      9.73438      9.39844      0.11938     -0.00784      0.14429      2.53125      2.50587      0.14761
   2688.00000     29.53125      7.69542      8.83775     17.14963    129.12500      5.30859      8.41406      9.40625      0.13297     -0.00247      0.15755      2.70898      2.48262      0.15249
   2688.50000     33.56250      7.66932      8.57215     17.91161    131.37500      4.89453      8.00000      9.34375      0.12040      0.00603      0.16627      2.84375      2.50412      0.15981
   2689.00000     39.25000      7.80441      8.69219     19.59481    133.87500      5.09766      7.23828      9.26563      0.10257      0.00998      0.17749      2.89063      2.53460      0.16610
   2689.50000     42.06250      8.02347      9.35442     22.42938    136.75000      4.33594      7.21875      9.54688      0.08564      0.01271      0.16338      2.99609      2.56356      0.16507
   2690.00000     43.00000      8.25149     10.22281     29.26893    140.62500      3.77539      6.73438      9.69531      0.08101      0.00807      0.14244      3.10352      2.57148      0.14930
   2690.50000     45.15625      8.21315     10.82960     41.53133    145.37500      3.84375      6.85938      9.78906      0.06568      0.00490      0.12651      3.23047      2.59768      0.13519
   2691.00000     48.50000      7.62375     10.32256     54.67416    150.62500      4.76172      7.27344      9.85938      0.04472      0.00227      0.11066      3.16406      2.63353      0.12854
   2691.50000     55.31250      6.80284      8.38812     39.11359    156.25000      4.41406      7.46875     10.01563      0.02960      0.00095      0.09790      3.19531      2.65939      0.12453
   2692.00000     66.25000      6.03078      6.33294     15.88797    162.87500      5.89844      9.02344     10.09375      0.01921     -0.00061      0.09368      3.23047      2.67716      0.12928
   2692.50000     72.56250      5.27814      4.99628      6.56137    169.12500      8.04688     10.61719     10.24219      0.03353     -0.00046      0.11893      3.23438      2.65266      0.14451
   2693.00000     82.12500      4.61576      4.23410      3.55997    174.12500      9.82813      7.39453     10.43750      0.06469      0.00132      0.15924      3.20898      2.59938      0.17781
   2693.50000     84.87500      4.05088      3.76357      2.72189    177.37500      3.52344      3.74805     10.67188      0.13232      0.01896      0.20126      2.85352      2.48373      0.21078
   2694.00000     87.56250      3.58609      3.45506      2.58904    177.87500      2.80273      2.99609     11.05469      0.21445      0.03089      0.24129      2.62891      2.34329      0.23116
   2694.50000     78.06250      3.27814      3.23270      2.67139    177.75000      1.69434      2.13672     11.34375      0.25052      0.04361      0.25804      2.45117      2.28161      0.24915
   2695.00000     79.37500      3.09450      3.10850      2.80133    177.37500      2.14844      2.29688     10.99219      0.23439      0.07903      0.26848      2.46484      2.30920      0.26274
   2695.50000     86.75000      2.98083      3.05757      2.88143    177.12500      2.46680      2.95898     11.07031      0.18541      0.09617      0.25087      2.48047      2.39296      0.26007
   2696.00000     92.75000      2.92761      3.03226      3.14684    176.62500      2.69531      2.88672     10.96094      0.16327      0.06555      0.23374      2.50391      2.43081      0.24043
   2696.50000     87.56250      2.93059      2.98026      3.34530    176.12500      5.00391      3.60352     10.67969      0.13907      0.04483      0.22012      2.63477      2.47219      0.22413
   2697.00000     77.81250      2.95170      2.95533      3.32141    175.62500      4.24219      4.05078     10.66406      0.11611      0.06119      0.21413      2.65820      2.51146      0.22093
   2697.50000     75.50000      2.99760      2.97334      3.04848    175.37500      3.66797      3.65820     10.67969      0.14128      0.03482      0.22124      2.66016      2.46842      0.22108
   2698.00000     76.56250      3.03537      3.03405      2.98380    175.50000      4.24219      3.12109     10.72656      0.15633      0.05701      0.22466      2.58398      2.44267      0.21884
   2698.50000     79.37500      3.02730      3.07774      3.03928    176.12500      2.22852      2.94141     11.29688      0.15091      0.07459      0.22893      2.58008      2.45194      0.21554
   2699.00000     82.56250      2.98532      3.06030      3.16661    176.50000      1.85449      2.54688     11.16406      0.13613      0.07966      0.22394      2.55859      2.47722      0.22842
   2699.50000     81.62500      2.93753      3.00384      3.11763    176.37500      3.56250      2.79883     10.67969      0.10920      0.07534      0.23468      2.62305      2.52326      0.23669
   2700.00000     81.31250      2.88959      2.91578      2.96042    176.25000      3.05664      2.74414     10.64063      0.10139      0.07810      0.22209      2.76367      2.53662      0.25874
   2700.50000     82.18750      2.86997      2.79928      2.80653    175.50000      3.02734      2.44141     10.66406      0.13759      0.05761      0.23591      2.86914      2.47472      0.25603
   2701.00000     89.56250      2.86076      2.71952      2.60353    174.50000      3.01563      2.85156     10.74219      0.20780      0.05988      0.25330      2.69336      2.35466      0.26780
   2701.50000     89.25000      2.86934      2.73190      2.30220    173.00000      2.60156      2.51172     10.93750      0.27600      0.07107      0.29817      2.45508      2.23805      0.26382
   2702.00000     88.12500      2.87143      2.85957      2.13251    171.62500      2.92188      2.08203     11.37500      0.31282      0.07945      0.31157      2.29883      2.17508      0.27578
   2702.50000     81.68750      2.82015      3.03047      2.21939    171.00000      1.78809      1.85059     11.21875      0.30041      0.08150      0.27279      2.36133      2.19630      0.26604
   2703.00000     73.56250      2.76442      3.06946      2.82225    170.50000      1.73438      1.85059     10.89063      0.24587      0.06961      0.21458      2.65625      2.28957      0.22419
   2703.50000     72.93750      2.77939      2.92161      3.22746    170.50000      5.77734      3.81836     10.39844      0.16344      0.05902      0.18798      2.80664      2.43052      0.20080
   2704.00000     76.87500      2.79762      2.87726      2.99711    170.12500      5.20313      5.75000     10.38281      0.10668      0.05954      0.19674      2.83789      2.52757      0.19645
   2704.50000     83.87500      2.78431      2.94090      2.34961    168.75000      4.68359      3.19141     10.38281      0.11715      0.04327      0.20329      2.66406      2.50967      0.19679
   2705.00000     85.56250      2.73693      2.97161      2.60802    166.50000      2.74805      2.22461     10.24219      0.15500      0.01290      0.20342      2.57227      2.44495      0.18687
   2705.50000     85.87500      2.59560      2.87000      3.95588    164.75000      6.44531      4.76563     10.07031      0.15428      0.01196      0.19946      2.44531      2.44619      0.18660
   2706.00000     92.25000      2.44101      2.66691      6.17919    163.12500      5.52344      6.08984      9.91406      0.13664      0.01238      0.19781      2.53125      2.47635      0.19472
   2706.50000     95.18750      2.37461      2.41948      6.16031    163.00000      3.69727      4.85547      9.78906      0.13752      0.00088      0.18153      2.47461      2.47485      0.20510
   2707.00000     96.87500      2.37803      2.27749      3.55997    163.00000      3.48242      5.17578      9.90625      0.14787     -0.00979      0.20929      2.52148      2.45714      0.19991
   2707.50000     95.00000      2.41870      2.36696      2.18097    160.87500      5.00391      5.33984      9.92969      0.16469      0.00634      0.23691      2.38867      2.42837      0.21993
   2708.00000     90.50000      2.50173      2.61155      2.28480    156.75000      2.13281      2.17188      9.94531      0.18407      0.00296      0.25025      2.39063      2.39524      0.22177
   2708.50000     85.50000      2.60903      2.85080      4.02969    150.25000      4.21484      3.83594      9.63281      0.18714     -0.00040      0.21702      2.31641      2.39000      0.20270
   2709.00000     74.93750      2.73657      3.06854      6.97780    143.00000      3.61523      5.03125      9.46875      0.15626      0.00714      0.19399      2.30273      2.44279      0.18052
   2709.50000     67.87500      2.99124      3.35386      8.74343    137.12500      3.54883      4.87109      9.32031      0.13647      0.00904      0.20326      2.27539      2.47664      0.18106
   2710.00000     56.15625      3.39287      3.83187      8.89782    132.12500      3.21484      5.19531      9.26563      0.13343     -0.00594      0.21939      2.31055      2.48184      0.19329
   2710.50000     49.15625      3.86816      4.45558      9.77523    127.87500      4.08203      5.69531      8.92188      0.13703     -0.00040      0.21911      2.32813      2.47567      0.20929
   2711.00000     43.43750      4.40908      5.23164     11.52680    124.37500      3.73633      5.71484      8.84375      0.14061      0.00080      0.20337      2.37305      2.46956      0.19958
   2711.50000     41.68750      4.99878      6.07611     13.30171    121.50000      4.35938      6.53516      8.77344      0.15542     -0.00178      0.18476      2.25781      2.44423      0.18618
   2712.00000     43.90625      5.53994      6.93972     14.17478    119.50000      5.10938      6.98438      8.75000      0.16980     -0.00602      0.17866      2.40039      2.41964      0.17742
   2712.50000     48.65625      5.88968      7.62911     16.40521    117.50000      5.28516      7.69922      8.78125      0.16627     -0.00579      0.16273      2.42969      2.42568      0.16519
   2713.00000     54.46875      6.05056      7.89204     21.86175    116.37500      5.51172      8.28906      8.75000      0.16405     -0.00828      0.14583      2.54297      2.42947      0.14891
   2713.50000     56.21875      5.90221      7.88023     27.41143    115.50000      5.21484      8.25000      8.75000      0.14068     -0.00640      0.13831      2.61719      2.46943      0.14012
   2714.00000     55.28125      5.52949      7.49871     28.17782    115.00000      4.25391      7.07422      8.75000      0.12634     -0.00615      0.14593      2.62891      2.49397      0.14105
   2714.50000     50.28125      5.05836      6.82259     23.47423    114.87500      3.75000      6.53516      8.75000      0.10570     -0.00053      0.15867      2.73633      2.52926      0.15236
   2715.00000     48.65625      4.65571      5.84562     17.75385    114.75000      3.60352      6.23438      8.75000      0.10365      0.00138      0.17563      2.57422      2.53276      0.16890
   2715.50000     48.59375      4.37843      4.96773     13.72437    114.37500      3.65625      6.46484      8.75000      0.12490     -0.00327      0.18594      2.60156      2.49643      0.18319
   2716.00000     51.53125      4.23529      4.38419     11.79664    114.25000      3.36328      5.69531      8.77344      0.12882      0.00013      0.19007      2.61328      2.48972      0.18503
   2716.50000     55.34375      4.24160      4.15945     10.94274    113.62500      3.40234      5.83984      8.89844      0.12216     -0.00233      0.18829      2.79883      2.50111      0.18064
   2717.00000     53.34375      4.33330      4.25492     11.29007    113.00000      3.12305      5.57031      8.84375      0.09860     -0.00359      0.18531      2.88672      2.54139      0.17419
   2717.50000     50.31250      4.53514      4.66532     13.66236    112.25000      4.02734      6.07031      8.77344      0.08250     -0.00548      0.16885      3.07227      2.56892      0.16756
   2718.00000     46.15625      4.92452      5.33039     19.59481    111.25000      4.78906      8.03906      8.89844      0.07112     -0.00723      0.14568      3.08203      2.58838      0.14571
   2718.50000     42.06250      5.58127      6.37527     31.07380    110.62500      8.46094     12.46094      8.85938      0.06319     -0.01112      0.12442      3.26563      2.60194      0.12421
   2719.00000     39.06250      6.61584      7.89204     43.62887    110.37500     28.73438     40.00000      8.76563      0.04343     -0.00554      0.12314      3.34375      2.63574      0.11343
   2719.50000     37.15625      8.23192     10.14438     43.00826    110.12500     34.62500     63.34375      8.64844      0.03178      0.00154      0.13936      3.29492      2.65566      0.12157
   2720.00000     31.43750     10.40339     13.18794     33.11589    110.00000     12.55469     25.93750      8.39063      0.05327      0.00104      0.15821      3.31055      2.61891      0.14593
   2720.50000     29.54688     12.77112     16.58601     29.41129    110.00000      3.72266      7.10938      8.29688      0.08768      0.00116      0.16338      3.49805      2.56007      0.16388
   2721.00000     22.68750     14.95887     19.90640     30.91493    110.12500      3.76172      6.80469      8.21094      0.10978      0.00207      0.15764      3.70313      2.52227      0.16157
   2721.50000     25.59375     16.46201     22.27992     34.63322    110.00000      4.16406      7.23438      8.14844      0.12048      0.00644      0.16294      3.84961      2.50398      0.15691
   2722.00000     21.73438     17.19723     23.25223     38.86222    109.75000      6.23047      9.96875      8.17188      0.12449      0.00660      0.16301      3.52734      2.49713      0.16298
   2722.50000     21.76563     17.53355     23.10102     41.53133    109.62500      8.61719     12.74219      8.28906      0.13672      0.00606      0.17014      3.62695      2.47620      0.16336
   2723.00000     18.84375     17.46556     22.51532     39.36823    109.62500     14.10156     23.17188      8.29688      0.13216      0.00879      0.17540      3.46484      2.48401      0.17747
   2723.50000     22.65625     17.34935     22.32661     32.93552    109.87500      4.76172      8.66406      8.29688      0.13841      0.01197      0.20154      3.57227      2.47332      0.18587
   2724.00000     22.65625     17.14513     22.37349     28.85000    109.75000      4.85547      7.80859      8.29688      0.14438      0.01008      0.21759      3.49023      2.46310      0.20507
   2724.50000     27.57813     16.76048     22.46784     28.85000    109.87500      4.48047      7.62891      8.29688      0.15593      0.00687      0.21723      3.51953      2.44337      0.20614
   2725.00000     25.65625     16.44559     21.77893     30.75768    110.00000      4.56250      7.53906      8.18750      0.14649      0.00663      0.20494      3.51953      2.45951      0.19906
   2725.50000     27.64063     16.45243     21.17290     31.23430    110.12500      4.70703      8.02344      8.14063      0.14056      0.00027      0.20365      3.50195      2.46965      0.19068
   2726.00000     25.75000     16.47024     21.77893     29.26893    110.12500      4.96484      8.62500      8.14063      0.14129     -0.00417      0.20476      3.42773      2.46840      0.19245
   2726.50000     27.76563     16.51701     23.25223     32.40601    110.50000      4.98828      8.19531      8.14844      0.15211     -0.00740      0.18380      3.53516      2.44989      0.18070
   2727.00000     25.70313     16.46887     24.25767     46.65865    110.62500      5.18750      8.57031      8.14844      0.13764     -0.00565      0.14517      3.56445      2.47464      0.14070
   2727.50000     26.59375     16.20564     24.09319     83.29150    110.50000      5.25781      9.09375      8.14844      0.09861      0.00094      0.10525      3.62305      2.54138      0.11232
   2728.00000     30.51563     16.36935     23.05106     99.78487    110.12500      5.12500      9.32813      8.14844      0.05384      0.01165      0.10277      3.62305      2.61793      0.09797
   2728.50000     37.53125     16.63787     22.27992     66.74350    109.87500      5.48047      9.91406      8.14844      0.04221      0.01324      0.11643      3.68164      2.63782      0.10973
   2729.00000     42.59375     16.86617     22.09510     41.81854    110.25000      5.71094     10.16406      8.14063      0.07161      0.00966      0.14666      3.97656      2.58755      0.13116
   2729.50000     39.56250     17.04185     22.23343     32.75710    110.12500      5.56250      9.52344      8.03125      0.11044      0.00727      0.17684      4.19141      2.52115      0.16065
   2730.00000     35.53125     17.04918     22.46784     29.99484    110.00000      5.56641      9.35938      8.03125      0.15032      0.00119      0.18834      4.24609      2.45294      0.17793
   2730.50000     27.59375     16.92241     22.85332     29.12794    109.87500      5.53906      9.32813      8.02344      0.17074     -0.00256      0.19850      4.20313      2.41804      0.18075
   2731.00000     26.51563     16.96155     23.45693     29.12794    109.75000      5.75000      9.39844      8.00781      0.17346     -0.00043      0.19301      4.06641      2.41339      0.18390
   2731.50000     24.65625     16.86330     24.31299     29.99484    110.00000      5.65625      9.20313      8.03125      0.17605     -0.00100      0.19518      4.02344      2.40895      0.17765
   2732.00000     25.59375     16.69120     24.53683     33.48262    109.62500      5.58984      8.96875      8.07031      0.17234     -0.00348      0.18436      4.12891      2.41529      0.17755
   2732.50000     23.82813     16.46887     24.20259     37.65231    109.37500      5.91016      9.64844      8.03906      0.16865     -0.00383      0.17704      4.28125      2.42161      0.17257
   2733.00000     24.67188     16.08168     23.40542     39.11359    109.25000      5.73828      9.82813      8.04688      0.16256     -0.00328      0.17422      4.41016      2.43202      0.17403
   2733.50000     25.57813     15.84308     22.75573     36.51546    109.37500      5.61719      9.57813      8.03906      0.16178     -0.00531      0.18455      4.14453      2.43336      0.17555
   2734.00000     25.42188     15.58297     22.37349     33.66904    109.62500      5.26953      8.75000      8.08594      0.16487     -0.00688      0.19433      4.03906      2.42808      0.18086
   2734.50000     24.50000     15.16838     22.04938     33.11589    109.75000      5.21875      8.62500      8.12500      0.16745     -0.00649      0.19721      4.06641      2.42367      0.18283
   2735.00000     24.57813     14.80710     21.34259     34.24100    109.87500      5.16406      8.46094      8.11719      0.16719     -0.00268      0.19004      4.41016      2.42411      0.18188
   2735.50000     23.67188     14.49639     20.59958     33.85756    110.12500      5.29688      8.57031      8.10156      0.16275     -0.00261      0.18858      4.45313      2.43169      0.18075
   2736.00000     22.68750     14.32541     20.17037     31.39647    110.12500      4.60156      7.89844      8.07813      0.15989     -0.00239      0.19611      4.44141      2.43658      0.18877
   2736.50000     24.73438     14.30041     19.90640     28.85000    110.50000      4.23047      7.12891      8.14063      0.16429     -0.00459      0.20349      3.85156      2.42907      0.19574
   2737.00000     29.62500     14.39775     20.17037     28.17782    110.87500      4.24219      6.92969      8.14844      0.17248     -0.00558      0.21394      3.72461      2.41505      0.20058
   2737.50000     37.50000     14.45274     20.59958     29.70020    111.12500      4.26953      7.10938      8.14844      0.16826     -0.00615      0.19941      3.72852      2.42227      0.19986
   2738.00000     38.25000     14.58123     21.17290     33.29824    111.25000      4.33203      7.27344      8.14844      0.15716     -0.00206      0.18573      4.14453      2.44126      0.17791
   2738.50000     38.21875     14.65613     21.86834     37.65231    111.50000      3.89648      6.94922      8.22656      0.15159     -0.00315      0.16365      4.33984      2.45079      0.16918
   2739.00000     35.21875     14.60286     22.18713     40.96857    111.62500      4.29688      7.37891      8.29688      0.15307      0.00043      0.16113      4.64453      2.44825      0.16176
   2739.50000     33.34375     14.51563     22.27992     41.53133    111.75000      4.34766      7.59375      8.30469      0.16132     -0.00363      0.16507      4.73438      2.43414      0.16711
   2740.00000     33.37500     14.20333     21.91332     40.15247    111.75000      4.29297      7.21875      8.32813      0.17050     -0.00784      0.17215      5.03125      2.41844      0.16715
   2740.50000     27.51563     13.64217     21.00587     39.11359    111.87500      4.25391      7.28906      8.43750      0.17595     -0.00844      0.17139      4.91016      2.40912      0.16476
   2741.00000     26.62500     12.97508     19.43400     38.61405    112.12500      4.23047      7.25391      8.44531      0.17549     -0.00625      0.16607      4.95313      2.40990      0.15831
   2741.50000     22.73438     12.19138     17.83783     40.15247    112.37500      4.65625      7.66406      8.47656      0.17024     -0.01192      0.15548      4.66406      2.41889      0.15049
   2742.00000     25.73438     11.36488     16.43221     43.62887    112.75000      5.10938      8.42969      8.58594      0.14606     -0.00806      0.13732      4.19922      2.46024      0.14184
   2742.50000     28.73438     10.49354     15.20940     48.92364    112.81250      4.66797      8.14844      8.67969      0.11340      0.00059      0.12949      3.87891      2.51608      0.13136
   2743.00000     32.96875      9.72811     14.00593     48.92364    112.93750      4.94922      8.53906      8.75781      0.07805      0.00370      0.13086      3.58984      2.57654      0.13148
   2743.50000     37.71875      9.02576     12.97821     45.94955    113.06250      4.52344      7.77344      8.89844      0.06922      0.00494      0.14245      3.45508      2.59164      0.13510
   2744.00000     39.62500      8.52680     11.98104     42.10976    113.50000      5.72266      8.95313      8.89844      0.06812      0.00776      0.14450      3.48242      2.59351      0.14684
   2744.50000     37.34375      8.09605     11.13717     36.07972    113.87500      6.32422     10.34375      8.89844      0.07165      0.00855      0.14676      3.49609      2.58749      0.14477
   2745.00000     39.56250      7.62682     10.47587     28.04713    114.12500      5.83203      9.84375      8.89844      0.07014      0.00615      0.14842      3.52344      2.59007      0.14779
   2745.50000     42.43750      7.14814      9.86061     23.47423    114.50000      3.49609      6.10938      8.90625      0.07297      0.00612      0.14872      3.46484      2.58522      0.14997
   2746.00000     44.53125      6.70319      9.19163     22.10146    114.75000      3.64258      5.66016      9.01563      0.06872      0.00232      0.14447      3.60352      2.59249      0.14469
   2746.50000     42.59375      6.28385      8.44858     21.55011    114.56250      3.22852      5.73438      9.04688      0.05560      0.00145      0.14440      3.99023      2.61492      0.13844
   2747.00000     39.59375      6.04840      7.71292     21.09895    114.43750      3.14844      5.19531      9.07031      0.02739      0.00621      0.15760      3.80664      2.66317      0.14332
   2747.50000     49.06250      6.01286      7.20602     22.51288    114.18750      3.05469      5.08594      9.09375      0.02589      0.00384      0.15016      3.49414      2.66573      0.15597
   2748.00000     57.65625      6.10927      7.11343     25.77562    114.00000      3.72266      5.75000      9.22656      0.03219     -0.00159      0.14476      3.31836      2.65495      0.14740
   2748.50000     68.50000      6.28174      7.47740     28.04713    114.25000      4.18750      6.78906      9.34375      0.03865     -0.00170      0.14194      3.65820      2.64391      0.14636
   2749.00000     70.62500      6.50776      8.21816     28.57732    114.56250      3.97656      6.26953      9.20313      0.05413     -0.00289      0.15743      3.96484      2.61745      0.14868
   2749.50000     72.81250      6.76784      9.20766     30.44794    115.06250      3.12109      5.89453      9.30469      0.08303     -0.00877      0.16418      4.32813      2.56802      0.15474
   2750.00000     73.81250      7.16386     10.36301     34.24100    115.62500      3.17578      5.39453      9.34375      0.11346     -0.01243      0.16056      4.36719      2.51599      0.15733
   2750.50000     71.87500      7.69386     11.70318     35.86572    115.75000      3.45703      5.98438      9.35938      0.12536     -0.01063      0.16206      4.25391      2.49563      0.16117
   2751.00000     69.75000      8.23050     12.99411     32.93552    116.18750      3.47070      5.96484      9.43750      0.11646     -0.00610      0.17133      3.78320      2.51086      0.17138
   2751.50000     62.03125      8.58763     13.73411     29.12794    116.62500      3.40234      5.78516      9.46875      0.11055     -0.00457      0.18845      3.53711      2.52096      0.18379
   2752.00000     64.00000      8.62398     13.78763     26.56837    117.31250      3.24219      5.53516      9.48438      0.10981     -0.00125      0.19482      3.36914      2.52223      0.19180
   2752.50000     64.12500      8.32340     13.61083     26.10950    117.81250      3.44336      5.53516      9.48438      0.11892      0.00017      0.19254      3.37695      2.50665      0.19102
   2753.00000     65.31250      7.85565     12.89930     27.66222    118.37500      3.47070      5.64453      9.48438      0.11614      0.00549      0.17751      3.64648      2.51141      0.18442
   2753.50000     65.56250      7.33727     11.78125     31.23430    118.93750      3.25586      5.30469      9.60156      0.11093      0.00974      0.16498      4.03516      2.52032      0.16758
   2754.00000     67.43750      6.87362     10.51752     35.65425    119.93750      3.29492      5.53516      9.63281      0.11161      0.01068      0.14787      4.44531      2.51915      0.15316
   2754.50000     73.37500      6.53497      9.41276     37.88823    121.06250      3.22852      5.28516      9.63281      0.11923      0.00687      0.13684      4.57422      2.50612      0.13765
   2755.00000     76.18750      6.35496      8.65654     36.73730    122.50000      2.98828      5.39453      9.63281      0.11741      0.00399      0.13327      4.46484      2.50923      0.13350
   2755.50000     70.31250      6.23937      8.28922     34.24100    124.50000      3.10938      5.39453      9.64063      0.10326      0.00084      0.13648      4.26563      2.53342      0.13565
   2756.00000     67.06250      6.09728      8.10445     30.75768    127.18750      3.25586      5.33984      9.75000      0.08540     -0.00037      0.14492      3.88867      2.56396      0.14562
   2756.50000     59.28125      5.91950      7.96963     26.22272    130.62500      3.34961      5.44531      9.67969      0.08095      0.00177      0.16580      3.83008      2.57158      0.16290
   2757.00000     58.46875      5.62985      7.70164     22.26421    134.75000      3.49609      5.67969      9.77344      0.09985      0.00031      0.18881      3.51172      2.53926      0.18516
   2757.50000     54.65625      5.31414      7.07991     19.22111    139.87500      3.56250      5.50000      9.78906      0.12486     -0.00304      0.20376      3.34180      2.49650      0.20262
   2758.00000     59.68750      5.10064      6.09023     13.91385    145.62500      3.96289      5.57031      9.78906      0.13307     -0.00401      0.18831      3.16016      2.48245      0.20722
   2758.50000     82.00000      4.85723      5.30334      8.76879    152.00000      4.21484      5.69531      9.82031      0.12306      0.00154      0.17673      3.23438      2.49956      0.18598
   2759.00000    100.68750      4.52787      4.88856      5.71222    157.75000      5.61719      6.76953     10.11719      0.10131      0.00365      0.15940      3.09375      2.53675      0.17956
   2759.50000    112.93750      4.14260      4.55907      4.86638    162.62500      7.87500      5.57031     10.29688      0.08352      0.00268      0.15832      2.89063      2.56719      0.16932
   2760.00000    105.93750      3.70763      4.15945      4.72566    165.62500     11.21094      5.98438     10.38281      0.06591      0.00283      0.15177      2.84766      2.59730      0.16927
   2760.50000     99.81250      3.33024      3.72158      4.51738    168.00000      9.76563      5.62500     10.38281      0.06644      0.00089      0.15096      2.87891      2.59638      0.17154
   2761.00000     97.18750      3.12600      3.33863      3.58317    169.25000      7.87109      4.89063     10.38281      0.08282     -0.00530      0.17406      2.88281      2.56838      0.17969
   2761.50000    102.12500      3.03397      3.17185      2.67375    168.62500      6.95313      4.62109     10.41406      0.10878     -0.00025      0.21392      2.73438      2.52399      0.20585
   2762.00000    104.18750      2.95462      3.22257      2.35786    165.37500      3.26758      2.79883     10.59375      0.11964      0.00373      0.23866      2.67578      2.50542      0.23325
   2762.50000    101.18750      2.87114      3.35823      3.08424    160.37500      1.98828      2.17188     10.50000      0.13135      0.00307      0.24200      2.76367      2.48540      0.22097
   2763.00000     83.56250      2.77317      3.40485      5.42037    153.62500      5.39063      3.98047     10.21875      0.11812      0.00874      0.21548      2.84375      2.50802      0.20222
   2763.50000     75.12500      2.66473      3.40935      9.35193    147.37500      4.16016      5.48047      9.92969      0.12120      0.01317      0.19242      2.80273      2.50275      0.18792
   2764.00000     71.31250      2.59795      3.36371     11.68269    142.87500      3.97656      5.85938      9.80469      0.13647      0.00469      0.17805      2.62891      2.47663      0.17961
   2764.50000     75.12500      2.56250      3.32140     11.35366    139.62500      3.84375      5.64453      9.78906      0.15453      0.00264      0.17760      2.53125      2.44575      0.17727
   2765.00000     72.68750      2.52187      3.24392     10.71017    136.75000      3.34961      5.39453      9.78906      0.16330      0.00337      0.18039      2.52148      2.43075      0.17842
   2765.50000     66.50000      2.46131      3.11510     10.25604    134.75000      3.69727      5.42969      9.79688      0.16679      0.00297      0.17763      2.63867      2.42479      0.17756
   2766.00000     64.00000      2.39542      2.97161      9.98507    133.25000      3.60352      5.58984      9.78906      0.17185     -0.00310      0.16352      2.64063      2.41613      0.17150
   2766.50000     64.31250      2.32476      2.86517      9.82287    132.37500      3.40234      5.35547      9.79688      0.17296     -0.00447      0.16500      2.61719      2.41424      0.16235
   2767.00000     67.43750      2.24904      2.78859      9.85489    131.62500      2.98828      4.89063      9.78906      0.17113     -0.00761      0.16071      2.58398      2.41736      0.16568
   2767.50000     66.18750      2.17669      2.75549      9.91955    131.00000      2.98828      5.12109      9.78906      0.16700     -0.00360      0.17305      2.70508      2.42444      0.16255
   2768.00000     65.18750      2.13581      2.74882      9.85489    130.75000      3.13477      5.08594      9.78906      0.16655     -0.00224      0.17581      2.72070      2.42520      0.17317
   2768.50000     66.93750      2.12891      2.74070      9.63505    130.50000      2.94727      4.81641      9.78906      0.17352      0.00004      0.18459      2.64453      2.41328      0.17408
   2769.00000     65.93750      2.15819      2.75400      9.45428    130.00000      3.01367      4.89063      9.78906      0.17945     -0.00398      0.19019      2.59375      2.40313      0.18244
   2769.50000     67.93750      2.18970      2.78176      9.38095    130.12500      2.98828      4.81641      9.78906      0.17876     -0.00163      0.19515      2.61719      2.40432      0.19100
   2770.00000     68.00000      2.19463      2.81083      9.38095    129.75000      2.98828      4.65625      9.78906      0.17293     -0.00070      0.19430      2.66602      2.41429      0.19903
   2770.50000     68.12500      2.18476      2.80159      9.49884    129.50000      2.93555      4.76563      9.78906      0.16913     -0.00062      0.18688      2.70703      2.42078      0.19662
   2771.00000     68.62500      2.17707      2.74291      9.65043    129.25000      2.98828      4.85547      9.78906      0.16752     -0.00142      0.19097      2.75586      2.42354      0.18691
   2771.50000     63.00000      2.19988      2.67882      9.71243    128.25000      3.14844      4.85547      9.78906      0.16223      0.00337      0.19790      2.79883      2.43259      0.19143
   2772.00000     64.87500      2.28461      2.64958      9.22355    127.06250      2.72070      4.76563      9.78906      0.16239      0.00353      0.21136      2.67188      2.43232      0.19987
   2772.50000     54.31250      2.43382      2.70367      7.80656    125.31250      2.96094      4.85547      9.79688      0.15584      0.00143      0.24356      2.79883      2.44351      0.21768
   2773.00000     47.25000      2.61460      2.88537      7.03462    123.81250      2.85547      4.74609      9.80469      0.14823      0.00376      0.24515      2.92578      2.45653      0.23641
   2773.50000     38.40625      2.82946      3.26866      8.28805    122.31250      2.96094      4.62109      9.85938      0.14092      0.00212      0.21567      3.50781      2.46902      0.21153
   2774.00000     37.62500      3.08664      3.78560     13.18570    120.56250      3.12109      5.21094      9.81250      0.13567     -0.00051      0.14906      3.95703      2.47800      0.16547
   2774.50000     39.56250      3.38410      4.39531     21.47358    119.68750      3.54883      6.05469      9.78906      0.12469     -0.00195      0.11646      4.65625      2.49678      0.12754
   2775.00000     43.53125      3.74878      5.02032     26.45214    119.31250      4.61719      7.41406      9.78906      0.11402     -0.00011      0.10913      4.88672      2.51502      0.11683
   2775.50000     50.96875      4.21964      5.63483     25.88596    118.93750      5.09375      8.27344      9.78906      0.11643     -0.00168      0.11369      4.73828      2.51090      0.11479
   2776.00000     53.87500      4.66517      6.16182     24.52133    118.81250      5.03125      7.77344      9.87500      0.12226     -0.00003      0.11458      4.53906      2.50094      0.12054
   2776.50000     56.75000      4.94922      6.64986     23.65791    118.43750      4.81641      7.46875      9.92969      0.12359      0.00089      0.11590      4.29688      2.49867      0.12358
   2777.00000     55.03125      4.98583      6.97656     23.20399    118.43750      3.52344      5.87500      9.92969      0.12489     -0.00150      0.12148      4.54297      2.49644      0.12547
   2777.50000     52.15625      4.78511      7.12307     23.84448    117.93750      3.06836      5.58984      9.92969      0.12641     -0.00172      0.12820      4.89844      2.49383      0.12768
   2778.00000     45.34375      4.41632      6.69649     25.66622    117.81250      3.04102      5.17578      9.91406      0.13273     -0.00508      0.12977      5.18359      2.48303      0.13066
   2778.50000     42.43750      4.00058      5.92162     26.68562    117.81250      3.10938      5.14063      9.80469      0.13828     -0.00916      0.13346      5.26172      2.47354      0.13145
   2779.00000     42.34375      3.57564      5.00587     24.12993    117.18750      3.28320      5.30469      9.82813      0.13533     -0.01115      0.14199      5.17188      2.47859      0.13638
   2779.50000     42.12500      3.20040      4.17787     19.85213    116.81250      2.98828      5.19531      9.92969      0.13164     -0.00787      0.15266      4.61328      2.48489      0.15054
   2780.00000     41.06250      2.88767      3.57230     16.36082    116.31250      2.88086      4.94141      9.92969      0.12339     -0.00273      0.15889      4.16797      2.49900      0.16457
   2780.50000     39.18750      2.65715      3.14756     13.63156    115.81250      2.85547      4.73047      9.84375      0.11958     -0.00250      0.16385      3.75195      2.50552      0.17185
   2781.00000     42.21875      2.51322      2.87080     11.43958    115.06250      3.00195      4.98047      9.90625      0.11429      0.00057      0.17062      3.79688      2.51456      0.17183
   2781.50000     46.12500      2.43462      2.75623     10.48727    114.06250      2.68164      4.69141      9.92969      0.11585     -0.00123      0.17361      3.82422      2.51190      0.17211
   2782.00000     51.06250      2.40336      2.77119     11.10349    112.87500      2.92188      4.67578      9.92969      0.11554     -0.00502      0.15957      4.15234      2.51242      0.16745
   2782.50000     54.12500      2.41251      2.85319     12.93191    111.75000      2.90820      4.89063     10.01563      0.11043     -0.00997      0.14661      4.44531      2.52117      0.15039
   2783.00000     60.15625      2.44127      2.96216     14.37699    110.62500      3.01563      5.19531      9.99219      0.09976     -0.00732      0.13512      4.39063      2.53941      0.14506
   2783.50000     62.18750      2.46802      3.07313     15.13253    110.00000      2.88086      5.10547     10.00000      0.09717     -0.00601      0.13525      4.12500      2.54383      0.14166
   2784.00000     63.50000      2.48068      3.12934     16.49471    109.56250      2.90820      4.96094      9.96094      0.09962      0.00315      0.13186      3.87500      2.53965      0.14397
   2784.50000     54.93750      2.45954      3.06487     18.12638    108.93750      3.34961      5.26563      9.95313      0.10921      0.01305      0.13807      3.84766      2.52325      0.14097
   2785.00000     54.59375      2.44083      2.89599     16.81580    108.93750      3.97656      6.07031     10.00000      0.11621      0.02955      0.14944      3.81836      2.51129      0.14762
   2785.50000     51.31250      2.45262      2.75623     13.36049    109.06250      3.33594      5.35547     10.00000      0.12141      0.04218      0.17293      3.84570      2.50238      0.15963
   2786.00000     57.00000      2.48356      2.72170     11.61537    109.25000      3.25586      5.16016      9.92969      0.12531      0.04435      0.17794      3.84570      2.49572      0.17679
   2786.50000     53.59375      2.48801      2.79011     12.42696    109.31250      3.37695      5.03516      9.92969      0.12307      0.04103      0.16426      4.11328      2.49955      0.16512
"""

# This has multiple different named gammma ray curves
LAS_03_MULTI_GR = """~VERSION INFORMATION
 VERS.                                2.0: CWLS LOG ASCII STANDARD - VERSION 2.0
 WRAP.                                 NO: ONE LINE PER DEPTH STEP
~WELL INFORMATION BLOCK
#MNEM.UNIT       DATA TYPE    INFORMATION
#---------    -------------   ------------------------------
 STRT.F                        1000.00000: 
 STOP.F                        1100.00000: 
 STEP.F                           0.50000: 
 NULL.                         -999.25000: NULL VALUE
 COMP.         ANY OIL COMPANY INC.: COMPANY
 WELL.        ANY ET AL A9-16-49-20: WELL
 LEAS.                SOME LEASE   : Lease Name
 FLD .                         EDAM: FIELD
 LOC .               A9-16-49-20W3M: LOCATION
 PROV.                 SASKATCHEWAN: PROVINCE
 SRVC.     ANY LOGGING COMPANY INC.: SERVICE COMPANY
 DATE.                    13-DEC-86: LOG DATE
 UWI .             100091604920W300: UNIQUE WELL ID
 LAT .                     38.53915: Latitude North (KGS,LEO3.6)
 LON .                     98.95341: LONGITUDE WEST (KGS, LEO3.6)
 API .                 151812004700: UNIQUE WELL ID
 UWI .                       15-175-21301: Unique Well Id
 PM  .                                  6: Principal Meridian
 STAT.                             Kansas: State
 SECT.                                  5: Section
 TOWN.                                31S: Township
 RANG.                                33W: Range
 COUN.                             SEWARD: County Name
~CURVE INFORMATION
#MNEM.UNIT      API CODE      CURVE DESCRIPTION
#---------    -------------   ------------------------------
DEPT.F                                 0: 1  Depth
GR  .GAPI                        7310010: 2 Gamma Ray
DLGR  .GAPI                        7310010: 2 Gamma Ray
DLGRH  .GAPI                        7310010: 2 Gamma Ray
GRDI  .GAPI                        7310010: 2 Gamma Ray
GRPD  .GAPI                        7310010: 2 Gamma Ray
GRSG.GAPI                        7310010: 2 Gamma Ray
GSGR  .GAPI                        7310010: 2 Gamma Ray
#MNEM.UNIT    VALUE                                 DESCRIPTION
#---------    -----------------------------------   ----------------------------
~A       DEPT         GR    DLGR    DLGRH    GRDI    GRPD
1000.000    10.000    -999.250    -999.250    -999.250    -999.250
1000.500    12.000    -999.250    -999.250    -999.250    -999.250
1001.000    14.000    -999.250    -999.250    -999.250    -999.250
1001.500    16.000    -999.250    -999.250    -999.250    -999.250
1002.000    18.000    -999.250    -999.250    -999.250    -999.250
1002.500    20.000    -999.250    -999.250    -999.250    -999.250
1003.000    22.000    -999.250    -999.250    -999.250    -999.250
1003.500    24.000    -999.250    -999.250    -999.250    -999.250
1004.000    26.000    10.000    -999.250    -999.250    -999.250
1004.500    28.000    12.000    -999.250    -999.250    -999.250
1005.000    30.000    14.000    -999.250    -999.250    -999.250
1005.500    32.000    16.000    -999.250    -999.250    -999.250
1006.000    34.000    18.000    -999.250    -999.250    -999.250
1006.500    36.000    20.000    -999.250    -999.250    -999.250
1007.000    38.000    22.000    -999.250    -999.250    -999.250
1007.500    40.000    24.000    -999.250    -999.250    -999.250
1008.000    42.000    26.000    10.000    -999.250    -999.250
1008.500    44.000    28.000    12.000    -999.250    -999.250
1009.000    46.000    30.000    14.000    -999.250    -999.250
1009.500    48.000    32.000    16.000    -999.250    -999.250
1010.000    50.000    34.000    18.000    -999.250    -999.250
1010.500    52.000    36.000    20.000    -999.250    -999.250
1011.000    54.000    38.000    22.000    -999.250    -999.250
1011.500    56.000    40.000    24.000    -999.250    -999.250
1012.000    58.000    42.000    26.000    10.000    -999.250
1012.500    60.000    44.000    28.000    12.000    -999.250
1013.000    62.000    46.000    30.000    14.000    -999.250
1013.500    64.000    48.000    32.000    16.000    -999.250
1014.000    66.000    50.000    34.000    18.000    -999.250
1014.500    68.000    52.000    36.000    20.000    -999.250
1015.000    70.000    54.000    38.000    22.000    -999.250
1015.500    72.000    56.000    40.000    24.000    -999.250
1016.000    74.000    58.000    42.000    26.000    10.000
1016.500    76.000    60.000    44.000    28.000    12.000
1017.000    78.000    62.000    46.000    30.000    14.000
1017.500    80.000    64.000    48.000    32.000    16.000
1018.000    82.000    66.000    50.000    34.000    18.000
1018.500    84.000    68.000    52.000    36.000    20.000
1019.000    86.000    70.000    54.000    38.000    22.000
1019.500    88.000    72.000    56.000    40.000    24.000
1020.000    90.000    74.000    58.000    42.000    26.000
1020.500    10.000    76.000    60.000    44.000    28.000
1021.000    12.000    78.000    62.000    46.000    30.000
1021.500    14.000    80.000    64.000    48.000    32.000
1022.000    16.000    82.000    66.000    50.000    34.000
1022.500    18.000    84.000    68.000    52.000    36.000
1023.000    20.000    86.000    70.000    54.000    38.000
1023.500    22.000    88.000    72.000    56.000    40.000
1024.000    24.000    90.000    74.000    58.000    42.000
1024.500    26.000    10.000    76.000    60.000    44.000
1025.000    28.000    12.000    78.000    62.000    46.000
1025.500    30.000    14.000    80.000    64.000    48.000
1026.000    32.000    16.000    82.000    66.000    50.000
1026.500    34.000    18.000    84.000    68.000    52.000
1027.000    36.000    20.000    86.000    70.000    54.000
1027.500    38.000    22.000    88.000    72.000    56.000
1028.000    40.000    24.000    90.000    74.000    58.000
1028.500    42.000    26.000    10.000    76.000    60.000
1029.000    44.000    28.000    12.000    78.000    62.000
1029.500    46.000    30.000    14.000    80.000    64.000
1030.000    48.000    32.000    16.000    82.000    66.000
1030.500    50.000    34.000    18.000    84.000    68.000
1031.000    52.000    36.000    20.000    86.000    70.000
1031.500    54.000    38.000    22.000    88.000    72.000
1032.000    56.000    40.000    24.000    90.000    74.000
1032.500    58.000    42.000    26.000    10.000    76.000
1033.000    60.000    44.000    28.000    12.000    78.000
1033.500    62.000    46.000    30.000    14.000    80.000
1034.000    64.000    48.000    32.000    16.000    82.000
1034.500    66.000    50.000    34.000    18.000    84.000
1035.000    68.000    52.000    36.000    20.000    86.000
1035.500    70.000    54.000    38.000    22.000    88.000
1036.000    72.000    56.000    40.000    24.000    90.000
1036.500    74.000    58.000    42.000    26.000    10.000
1037.000    76.000    60.000    44.000    28.000    12.000
1037.500    78.000    62.000    46.000    30.000    14.000
1038.000    80.000    64.000    48.000    32.000    16.000
1038.500    82.000    66.000    50.000    34.000    18.000
1039.000    84.000    68.000    52.000    36.000    20.000
1039.500    86.000    70.000    54.000    38.000    22.000
1040.000    88.000    72.000    56.000    40.000    24.000
1040.500    90.000    74.000    58.000    42.000    26.000
1041.000    10.000    76.000    60.000    44.000    28.000
1041.500    12.000    78.000    62.000    46.000    30.000
1042.000    14.000    80.000    64.000    48.000    32.000
1042.500    16.000    82.000    66.000    50.000    34.000
1043.000    18.000    84.000    68.000    52.000    36.000
1043.500    20.000    86.000    70.000    54.000    38.000
1044.000    22.000    88.000    72.000    56.000    40.000
1044.500    24.000    90.000    74.000    58.000    42.000
1045.000    26.000    10.000    76.000    60.000    44.000
1045.500    28.000    12.000    78.000    62.000    46.000
1046.000    30.000    14.000    80.000    64.000    48.000
1046.500    32.000    16.000    82.000    66.000    50.000
1047.000    34.000    18.000    84.000    68.000    52.000
1047.500    36.000    20.000    86.000    70.000    54.000
1048.000    38.000    22.000    88.000    72.000    56.000
1048.500    40.000    24.000    90.000    74.000    58.000
1049.000    42.000    26.000    10.000    76.000    60.000
1049.500    44.000    28.000    12.000    78.000    62.000
1050.000    46.000    30.000    14.000    80.000    64.000
1050.500    48.000    32.000    16.000    82.000    66.000
1051.000    50.000    34.000    18.000    84.000    68.000
1051.500    52.000    36.000    20.000    86.000    70.000
1052.000    54.000    38.000    22.000    88.000    72.000
1052.500    56.000    40.000    24.000    90.000    74.000
1053.000    58.000    42.000    26.000    10.000    76.000
1053.500    60.000    44.000    28.000    12.000    78.000
1054.000    62.000    46.000    30.000    14.000    80.000
1054.500    64.000    48.000    32.000    16.000    82.000
1055.000    66.000    50.000    34.000    18.000    84.000
1055.500    68.000    52.000    36.000    20.000    86.000
1056.000    70.000    54.000    38.000    22.000    88.000
1056.500    72.000    56.000    40.000    24.000    90.000
1057.000    74.000    58.000    42.000    26.000    10.000
1057.500    76.000    60.000    44.000    28.000    12.000
1058.000    78.000    62.000    46.000    30.000    14.000
1058.500    80.000    64.000    48.000    32.000    16.000
1059.000    82.000    66.000    50.000    34.000    18.000
1059.500    84.000    68.000    52.000    36.000    20.000
1060.000    86.000    70.000    54.000    38.000    22.000
1060.500    88.000    72.000    56.000    40.000    24.000
1061.000    90.000    74.000    58.000    42.000    26.000
1061.500    10.000    76.000    60.000    44.000    28.000
1062.000    12.000    78.000    62.000    46.000    30.000
1062.500    14.000    80.000    64.000    48.000    32.000
1063.000    16.000    82.000    66.000    50.000    34.000
1063.500    18.000    84.000    68.000    52.000    36.000
1064.000    20.000    86.000    70.000    54.000    38.000
1064.500    22.000    88.000    72.000    56.000    40.000
1065.000    24.000    90.000    74.000    58.000    42.000
1065.500    26.000    10.000    76.000    60.000    44.000
1066.000    28.000    12.000    78.000    62.000    46.000
1066.500    30.000    14.000    80.000    64.000    48.000
1067.000    32.000    16.000    82.000    66.000    50.000
1067.500    34.000    18.000    84.000    68.000    52.000
1068.000    36.000    20.000    86.000    70.000    54.000
1068.500    38.000    22.000    88.000    72.000    56.000
1069.000    40.000    24.000    90.000    74.000    58.000
1069.500    42.000    26.000    10.000    76.000    60.000
1070.000    44.000    28.000    12.000    78.000    62.000
1070.500    46.000    30.000    14.000    80.000    64.000
1071.000    48.000    32.000    16.000    82.000    66.000
1071.500    50.000    34.000    18.000    84.000    68.000
1072.000    52.000    36.000    20.000    86.000    70.000
1072.500    54.000    38.000    22.000    88.000    72.000
1073.000    56.000    40.000    24.000    90.000    74.000
1073.500    58.000    42.000    26.000    10.000    76.000
1074.000    60.000    44.000    28.000    12.000    78.000
1074.500    62.000    46.000    30.000    14.000    80.000
1075.000    64.000    48.000    32.000    16.000    82.000
1075.500    66.000    50.000    34.000    18.000    84.000
1076.000    68.000    52.000    36.000    20.000    86.000
1076.500    70.000    54.000    38.000    22.000    88.000
1077.000    72.000    56.000    40.000    24.000    90.000
1077.500    74.000    58.000    42.000    26.000    10.000
1078.000    76.000    60.000    44.000    28.000    12.000
1078.500    78.000    62.000    46.000    30.000    14.000
1079.000    80.000    64.000    48.000    32.000    16.000
1079.500    82.000    66.000    50.000    34.000    18.000
1080.000    84.000    68.000    52.000    36.000    20.000
1080.500    86.000    70.000    54.000    38.000    22.000
1081.000    88.000    72.000    56.000    40.000    24.000
1081.500    90.000    74.000    58.000    42.000    26.000
1082.000    10.000    76.000    60.000    44.000    28.000
1082.500    12.000    78.000    62.000    46.000    30.000
1083.000    14.000    80.000    64.000    48.000    32.000
1083.500    16.000    82.000    66.000    50.000    34.000
1084.000    18.000    84.000    68.000    52.000    36.000
1084.500    20.000    86.000    70.000    54.000    38.000
1085.000    22.000    88.000    72.000    56.000    40.000
1085.500    24.000    90.000    74.000    58.000    42.000
1086.000    26.000    10.000    76.000    60.000    44.000
1086.500    28.000    12.000    78.000    62.000    46.000
1087.000    30.000    14.000    80.000    64.000    48.000
1087.500    32.000    16.000    82.000    66.000    50.000
1088.000    34.000    18.000    84.000    68.000    52.000
1088.500    36.000    20.000    86.000    70.000    54.000
1089.000    38.000    22.000    88.000    72.000    56.000
1089.500    40.000    24.000    90.000    74.000    58.000
1090.000    42.000    26.000    10.000    76.000    60.000
1090.500    44.000    28.000    12.000    78.000    62.000
1091.000    46.000    30.000    14.000    80.000    64.000
1091.500    48.000    32.000    16.000    82.000    66.000
1092.000    50.000    34.000    18.000    84.000    68.000
1092.500    52.000    36.000    20.000    86.000    70.000
1093.000    54.000    38.000    22.000    88.000    72.000
1093.500    56.000    40.000    24.000    90.000    74.000
1094.000    58.000    42.000    26.000    10.000    76.000
1094.500    60.000    44.000    28.000    12.000    78.000
1095.000    62.000    46.000    30.000    14.000    80.000
1095.500    64.000    48.000    32.000    16.000    82.000
1096.000    66.000    50.000    34.000    18.000    84.000
1096.500    68.000    52.000    36.000    20.000    86.000
1097.000    70.000    54.000    38.000    22.000    88.000
1097.500    72.000    56.000    40.000    24.000    90.000
1098.000    74.000    58.000    42.000    26.000    10.000
1098.500    76.000    60.000    44.000    28.000    12.000
1099.000    78.000    62.000    46.000    30.000    14.000
1099.500    80.000    64.000    48.000    32.000    16.000
1100.000    82.000    66.000    50.000    34.000    18.000
"""
# This has density, porosity and multiple different named gammma ray curves
LAS_03_DENS_PORO_MULTI_GR = """~VERSION INFORMATION
 VERS.   2.0    : CWLS LOG ASCII STANDARD - VERSION 2.0 
 WRAP.                               NO: ONE LINE PER DEPTH STEP              
~WELL INFORMATION BLOCK                                                       
#MNEM.UNIT           DATA TYPE           INFORMATION                          
#--------- ----------------------------  -------------------------------------
 STRT.F                       1427.0000:                                      
 STOP.F                       1527.0000:                                      
 STEP.F                          0.5000:                                      
 NULL.                        -999.2500:                                      
 COMP.         ANY OIL COMPANY INC.: COMPANY
 WELL.        ANY ET AL A9-16-49-20: WELL
 LEAS.                SOME LEASE   : Lease Name
 FLD .                         EDAM: FIELD
 LOC .               A9-16-49-20W3M: LOCATION
 PROV.                 SASKATCHEWAN: PROVINCE
 SRVC.     ANY LOGGING COMPANY INC.: SERVICE COMPANY
 DATE.                    13-DEC-86: LOG DATE
 UWI .             100091604920W300: UNIQUE WELL ID
 LAT .                     38.53915: Latitude North (KGS,LEO3.6)
 LON .                     98.95341: LONGITUDE WEST (KGS, LEO3.6)
 API .                 151812004700: UNIQUE WELL ID
 UWI .                       15-175-21301: Unique Well Id
 PM  .                                  6: Principal Meridian
 STAT.                             Kansas: State
 SECT.                                  5: Section
 TOWN.                                31S: Township
 RANG.                                33W: Range
 COUN.                             SEWARD: County Name
~CURVE INFORMATION BLOCK                                                      
#MNEM.UNIT                   API CODE    Curve Description                  
#---------                 ------------  -------------------------------------
 DEPT.F                    00 000 00 00:   1  Depth Curve                     
 GRKC.GAPI                 99 700 20 01:   2                              
 GKCL.GAPI                 99 100 10 01:   3  GAMMA KCL                   
 GKUT.GAPI                 99 100 10 01:   4  GAMMA KUT                   
 GRKT.GAPI                 99 100 10 01:   5  GAMMA KT                    
 GRTH.GAPI                 99 100 10 01:   6  GAMMA THORIUM               
 GRTO.GAPI                 99 100 10 01:   7  TOTAL GAMMA (150KEV - 3MEV) 
 GRUR.GAPI                 99 905 20 01:   8  GAMMA URANIUM               
 GRK .GAPI                 99 905 20 01:   9  GAMMA POTASSIUM             
 NPHI.DECP                 99 900 40 01:  10  NEUTRON POROSITY            
 DPHI.DECP                 99 901 30 01:  11  DENSITY POROSITY            
 DRHO.G/C3                 99 560 10 01:  12  DENSITY CORRECTION          
 PE  .B/E                  99 580 10 01:  13  PHOTO-ELECTRIC FACTOR       
 RHOB.G/C3                 99 500 10 01:  14  BULK DENSITY                
 CALI.IN                   99 800 10 01:  15  CALIPER                     
 MINV.OHMM                 99 500 10 01:  16  MICROINVERSE RESISTIVITY    
 MNOR.OHMM                 99 520 20 01:  17  MICRONORMAL RESISTIVITY     
~A   DEPT       GRKC       GKCL       GKUT       GRKT       GRTH       GRTO       GRUR       GRK        NPHI       DPHI       DRHO       PE         RHOB       CALI       MINV       MNOR  
  1427.0000   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250
  1427.5000   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250
  1428.0000   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250
  1428.5000   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250   -999.250
  1429.0000     93.190      0.000     94.434     63.336     20.821     87.397     31.098     42.514      0.254      0.155      0.079      2.966      2.444      9.084      0.981      1.194
  1429.5000     88.760      0.000     90.042     60.294     20.245     83.574     29.749     40.049      0.223      0.137      0.087      3.007      2.476      8.834      0.981      1.194
  1430.0000     81.204      0.000     84.217     61.853     20.344     76.318     22.364     41.509      0.198      0.122      0.080      2.980      2.502      8.778      0.981      1.194
  1430.5000     78.748      0.000     83.594     65.454     22.171     74.720     18.140     43.283      0.184      0.110      0.066      2.965      2.522      8.795      0.981      1.194
  1431.0000     78.489      0.000     83.969     67.674     23.787     74.643     16.295     43.887      0.178      0.108      0.059      2.959      2.525      8.808      0.981      1.194
  1431.5000     80.463      0.000     84.779     73.572     26.579     75.861     11.208     46.992      0.181      0.112      0.057      2.960      2.519      8.757      0.981      1.194
  1432.0000     84.002      0.000     87.512     73.594     27.744     79.214     13.918     45.849      0.190      0.118      0.060      2.970      2.509      8.748      0.981      1.194
  1432.5000     87.239      0.000     89.535     72.246     27.964     82.003     17.289     44.282      0.205      0.125      0.063      2.953      2.496      8.821      0.981      1.194
  1433.0000     96.801      0.000     97.863     75.232     27.638     90.082     22.631     47.594      0.224      0.133      0.063      2.973      2.483      8.770      0.981      1.194
  1433.5000    101.209      0.000    101.669     78.123     26.493     93.039     23.545     51.630      0.239      0.133      0.075      2.982      2.483      8.718      0.981      1.194
  1434.0000    102.803      0.000    102.799     78.937     26.369     93.993     23.862     52.568      0.247      0.136      0.101      3.019      2.478      8.696      0.981      1.194
  1434.5000    103.117      0.000    102.771     79.613     27.643     94.046     23.158     51.969      0.265      0.161      0.131      2.953      2.435      8.765      0.981      1.194
  1435.0000    101.809      0.000    101.512     78.021     28.012     93.264     23.492     50.008      0.288      0.214      0.109      2.816      2.344      8.709      0.981      1.194
  1435.5000    100.053      0.000     99.611     75.783     26.611     91.532     23.828     49.172      0.295      0.227      0.108      2.800      2.322      8.821      0.981      1.194
  1436.0000     98.154      0.000     97.745     74.245     25.360     89.649     23.500     48.885      0.277      0.221      0.121      2.826      2.331      8.748      0.981      1.194
  1436.5000     94.699      0.000     95.162     69.822     24.754     87.070     25.341     45.067      0.263      0.206      0.118      2.837      2.359      8.688      0.981      1.194
  1437.0000     92.674      0.000     93.872     70.539     25.627     85.490     23.333     44.912      0.263      0.160      0.117      2.929      2.436      8.744      0.981      1.194
  1437.5000     91.168      0.000     93.024     71.134     25.302     84.222     21.890     45.832      0.259      0.146      0.118      3.012      2.461      8.752      0.981      1.194
  1438.0000     91.353      0.000     92.903     71.122     25.078     83.792     21.780     46.045      0.267      0.158      0.120      3.018      2.441      8.778      0.981      1.194
  1438.5000     92.071      0.000     92.985     71.005     24.924     83.623     21.980     46.081      0.290      0.179      0.105      2.938      2.404      8.869      0.981      1.194
  1439.0000     92.068      0.000     92.656     70.133     24.683     83.295     22.524     45.450      0.295      0.187      0.094      2.850      2.391      9.205      0.981      1.194
  1439.5000     91.381      0.000     91.998     70.001     24.783     82.738     21.997     45.218      0.267      0.180      0.093      2.849      2.402      9.179      0.981      1.194
  1440.0000     91.420      0.000     91.718     70.330     24.799     82.334     21.387     45.532      0.242      0.171      0.081      2.817      2.417      8.757      0.981      1.194
  1440.5000     91.013      0.000     91.714     71.499     24.791     81.976     20.214     46.708      0.234      0.145      0.083      2.836      2.462      8.692      0.981      1.194
  1441.0000     89.432      0.000     91.066     71.175     25.764     81.659     19.891     45.411      0.242      0.138      0.085      2.795      2.473      8.666      0.981      1.194
  1441.5000     87.937      0.000     90.374     69.620     26.252     81.616     20.755     43.368      0.246      0.143      0.078      2.785      2.465      8.748      0.981      1.194
  1442.0000     87.717      0.000     90.264     69.519     26.596     81.712     20.745     42.923      0.244      0.136      0.087      2.818      2.477      8.748      0.981      1.194
  1442.5000     87.085      0.000     89.768     69.128     26.796     81.666     20.641     42.331      0.243      0.133      0.100      2.828      2.483      8.662      0.981      1.194
  1443.0000     86.513      0.000     89.593     69.264     27.578     81.734     20.329     41.686      0.245      0.141      0.090      2.782      2.469      8.614      0.981      1.194
  1443.5000     85.481      0.000     89.552     68.286     28.452     82.128     21.266     39.834      0.256      0.146      0.080      2.781      2.460      8.847      0.981      1.194
  1444.0000     85.534      0.000     90.047     68.168     29.665     82.826     21.879     38.503      0.253      0.145      0.087      2.834      2.463      8.882      0.981      1.194
  1444.5000     86.109      0.000     89.134     67.514     30.437     83.766     21.620     37.077      0.246      0.145      0.091      2.843      2.463      8.614      0.981      1.194
  1445.0000     86.335      0.000     89.826     68.292     31.449     84.641     21.534     36.844      0.243      0.144      0.084      2.833      2.464      8.571      0.981      1.194
  1445.5000     88.027      0.000     91.785     69.966     32.307     86.439     21.820     37.658      0.249      0.141      0.085      2.830      2.469      8.563      0.981      1.194
  1446.0000     90.468      0.000     94.198     70.569     33.807     89.123     23.629     36.762      0.260      0.141      0.096      2.876      2.469      8.558      0.981      1.194
  1446.5000     93.949      0.000     97.300     68.907     32.791     92.719     28.393     36.116      0.285      0.158      0.119      2.873      2.440      8.558      0.981      1.194
  1447.0000     97.766      0.000    100.854     66.609     30.906     96.860     34.245     35.703      0.325      0.207      0.122      2.820      2.356      8.576      0.981      1.194
  1447.5000    108.588      0.000    110.392     64.168     23.219    108.837     46.224     40.949      0.385      0.239      0.110      2.836      2.301      8.718      0.981      1.194
  1448.0000    126.360      0.000    127.053     51.146     16.572    130.766     75.908     34.573      0.411      0.243      0.111      2.875      2.295      8.813      0.981      1.194
  1448.5000    127.467      0.000    127.611     49.206     15.760    131.918     78.405     33.446      0.384      0.224      0.134      2.968      2.327      8.701      0.981      1.194
  1449.0000    118.865      0.000    118.449     48.740     16.085    121.908     69.709     32.655      0.347      0.187      0.152      3.056      2.389      8.619      0.981      1.194
  1449.5000    103.557      0.000    101.529     61.285     19.519     99.135     40.243     41.767      0.315      0.176      0.120      3.076      2.408      8.606      0.981      1.194
  1450.0000     94.067      0.000     91.177     67.939     23.360     85.808     23.238     44.579      0.297      0.163      0.126      3.133      2.431      8.623      0.981      1.194
  1450.5000     93.440      0.000     89.976     68.201     24.086     84.504     21.775     44.115      0.294      0.160      0.130      3.134      2.437      8.610      0.981      1.194
  1451.0000     93.373      0.000     89.500     67.640     23.755     84.057     21.860     43.885      0.288      0.157      0.118      3.134      2.442      8.614      0.981      1.194
  1451.5000     93.487      0.000     89.583     67.247     22.771     83.994     22.336     44.476      0.280      0.155      0.093      3.120      2.444      8.619      0.981      1.194
  1452.0000     93.420      0.000     89.436     67.438     22.596     83.699     21.998     44.841      0.270      0.149      0.086      3.129      2.456      8.584      0.981      1.194
  1452.5000     92.195      0.000     88.175     65.919     22.522     82.784     22.256     43.397      0.265      0.139      0.086      3.121      2.473      8.571      0.981      1.194
  1453.0000     90.471      0.000     86.379     63.810     23.008     81.625     22.569     40.802      0.269      0.146      0.063      3.075      2.460      8.567      0.981      1.194
  1453.5000     88.720      0.000     84.607     61.532     23.140     80.441     23.075     38.392      0.281      0.139      0.088      3.054      2.472      8.571      0.981      1.194
  1454.0000     86.925      0.000     83.181     61.712     24.188     79.016     21.469     37.525      0.296      0.136      0.144      3.085      2.478      8.563      0.981      1.194
  1454.5000     84.107      0.000     81.132     61.914     25.366     77.172     19.218     36.548      0.318      0.174      0.140      3.066      2.412      8.619      0.981      1.194
  1455.0000     74.280      0.000     72.695     52.752     23.876     70.183     19.942     28.876      0.344      0.198      0.123      3.187      2.372      8.662      0.981      1.194
  1455.5000     54.898      0.000     53.727     35.777     18.850     53.393     17.950     16.927      0.342      0.200      0.097      3.364      2.369      8.787      0.981      1.194
  1456.0000     32.470      0.000     30.752     18.166     10.166     31.468     12.586      8.000      0.227      0.158      0.082      3.689      2.440      8.653      0.981      1.194
  1456.5000     15.744      0.000     15.380     12.293      7.285     15.360      3.087      5.008      0.079      0.088      0.040      4.114      2.560      8.614      0.981      1.194
  1457.0000      8.835      0.000      9.236      4.652      1.895      9.382      4.584      2.756      0.021     -0.001      0.002      4.691      2.711      8.584      0.981      1.194
  1457.5000      8.931      0.000      9.366      4.591      1.672      9.498      4.775      2.919      0.006     -0.094      0.006      4.921      2.870      8.550      0.981      1.194
  1458.0000      9.572      0.000      9.896      5.357      1.856      9.986      4.539      3.500      0.002     -0.128      0.002      5.055      2.929      8.545      0.981      1.194
  1458.5000     10.364      0.000     10.584      5.704      2.013     10.629      4.880      3.691      0.002     -0.138      0.005      5.036      2.947      8.537      0.981      1.194
  1459.0000     11.461      0.000     11.383      5.556      1.716     11.514      5.827      3.840      0.002     -0.137      0.005      5.015      2.944      8.533      0.981      1.194
  1459.5000     12.666      0.000     12.419      5.393      1.590     12.703      7.026      3.803      0.003     -0.136      0.003      5.027      2.943      8.580      0.981      1.194
  1460.0000     15.626      0.000     15.316      5.207      1.674     16.056     10.110      3.533      0.007     -0.136      0.014      4.847      2.942      8.580      0.981      1.194
  1460.5000     25.439      0.000     24.966      6.122      2.565     26.907     18.844      3.557      0.017     -0.120      0.018      4.503      2.915      8.533      0.981      1.194
  1461.0000     39.805      0.000     38.357      6.650      1.200     41.700     31.708      5.450      0.031     -0.100      0.018      4.263      2.881      8.511      0.981      1.194
  1461.5000     41.356      0.000     39.529      6.610      0.982     43.005     32.919      5.628      0.039     -0.088      0.018      4.086      2.861      8.524      0.981      1.194
  1462.0000     36.512      0.000     36.256      4.666      0.280     38.975     31.590      4.386      0.032     -0.087      0.024      4.036      2.858      8.507      0.981      1.194
  1462.5000     27.246      0.000     28.896      6.424      0.136     29.387     22.472      6.288      0.022     -0.095      0.033      4.022      2.872      8.520      0.981      1.194
  1463.0000     24.463      0.000     26.837      5.352      0.169     27.283     21.486      5.183      0.016     -0.105      0.032      4.173      2.890      8.511      0.981      1.194
  1463.5000     24.484      0.000     26.791      5.177      0.183     27.354     21.614      4.994      0.013     -0.114      0.033      4.322      2.904      8.533      0.981      1.194
  1464.0000     24.707      0.000     26.925      4.865      0.199     27.830     22.060      4.666      0.014     -0.115      0.029      4.407      2.907      8.533      0.981      1.194
  1464.5000     26.001      0.000     27.143      5.824      0.225     28.850     21.318      5.599      0.016     -0.109      0.022      4.398      2.897      8.507      0.981      1.194
  1465.0000     28.022      0.000     29.258      7.598      0.693     30.906     21.659      6.905      0.019     -0.106      0.018      4.306      2.891      8.528      0.981      1.194
  1465.5000     29.377      0.000     30.771      8.176      1.131     32.565     22.595      7.045      0.024     -0.103      0.022      4.221      2.887      8.554      0.981      1.194
  1466.0000     31.219      0.000     32.662      8.350      1.314     34.758     24.312      7.037      0.030     -0.097      0.022      4.085      2.875      8.576      0.981      1.194
  1466.5000     34.440      0.000     35.515     10.107      1.436     37.473     25.408      8.671      0.041     -0.090      0.029      3.906      2.863      8.524      0.981      1.194
  1467.0000     41.806      0.000     42.535     14.728      4.120     44.504     27.807     10.607      0.057     -0.073      0.031      3.803      2.835      8.502      0.981      1.194
  1467.5000     49.475      0.000     49.773     21.302      6.984     51.005     28.471     14.317      0.073     -0.061      0.040      3.671      2.814      8.524      0.981      1.194
  1468.0000     60.139      0.000     61.618     35.978     13.208     60.681     25.640     22.771      0.089     -0.043      0.049      3.497      2.783      8.489      0.981      1.194
  1468.5000     62.319      0.000     63.913     40.184     14.330     62.126     23.728     25.854      0.104     -0.008      0.046      3.308      2.723      8.502      0.981      1.194
  1469.0000     62.571      0.000     64.167     40.579     14.239     62.276     23.587     26.340      0.116      0.025      0.042      3.212      2.668      8.550      0.981      1.194
  1469.5000     62.793      0.000     64.245     40.576     13.848     62.265     23.669     26.728      0.122      0.046      0.044      3.143      2.631      8.511      0.981      1.194
  1470.0000     63.826      0.000     64.747     41.425     13.938     62.563     23.322     27.488      0.120      0.058      0.049      3.056      2.610      8.524      0.981      1.194
  1470.5000     65.863      0.000     66.186     43.005     13.915     63.626     23.181     29.091      0.118      0.062      0.051      3.019      2.603      8.558      0.981      1.194
  1471.0000     67.855      0.000     67.358     43.963     13.713     64.557     23.396     30.250      0.127      0.065      0.051      3.007      2.599      8.558      0.981      1.194
  1471.5000     67.790      0.000     67.475     44.035     13.263     64.527     23.440     30.771      0.141      0.074      0.052      2.981      2.584      8.541      0.981      1.194
  1472.0000     66.761      0.000     67.072     44.867     14.081     63.987     22.204     30.787      0.160      0.088      0.049      2.913      2.560      8.554      0.981      1.194
  1472.5000     65.518      0.000     65.937     46.241     15.500     62.595     19.696     30.741      0.175      0.105      0.047      2.806      2.531      8.576      0.981      1.194
  1473.0000     65.092      0.000     65.362     48.601     17.256     61.560     16.762     31.345      0.186      0.118      0.050      2.728      2.509      8.558      0.981      1.194
  1473.5000     64.010      0.000     64.566     49.603     18.931     60.727     14.963     30.673      0.193      0.124      0.054      2.694      2.498      8.558      0.981      1.194
  1474.0000     64.052      0.000     64.391     49.590     19.651     60.735     14.801     29.939      0.198      0.133      0.054      2.659      2.482      8.507      0.981      1.194
  1474.5000     64.295      0.000     64.342     49.356     19.860     60.841     14.986     29.497      0.201      0.140      0.053      2.623      2.470      8.528      0.981      1.194
  1475.0000     65.100      0.000     64.487     49.869     19.947     60.885     14.618     29.922      0.209      0.146      0.053      2.614      2.460      8.576      0.981      1.194
  1475.5000     66.131      0.000     64.430     49.105     19.029     60.920     15.324     30.077      0.217      0.155      0.053      2.609      2.446      8.593      0.981      1.194
  1476.0000     67.234      0.000     64.709     50.057     19.375     61.032     14.653     30.682      0.229      0.164      0.050      2.609      2.430      8.567      0.981      1.194
  1476.5000     66.647      0.000     64.751     51.888     20.797     60.790     12.863     31.091      0.242      0.172      0.052      2.577      2.416      8.563      0.981      1.194
  1477.0000     65.932      0.000     64.692     53.122     20.870     60.293     11.569     32.252      0.254      0.185      0.052      2.543      2.394      8.580      0.981      1.194
  1477.5000     65.899      0.000     64.654     52.754     19.876     60.142     11.900     32.878      0.253      0.194      0.051      2.527      2.379      8.589      0.981      1.194
  1478.0000     66.301      0.000     65.337     51.398     19.381     60.335     13.939     32.017      0.248      0.199      0.050      2.520      2.370      8.554      0.981      1.194
  1478.5000     66.275      0.000     65.496     50.431     18.482     60.558     15.064     31.950      0.245      0.201      0.054      2.495      2.367      8.545      0.981      1.194
  1479.0000     65.964      0.000     64.866     50.593     17.219     60.450     14.273     33.374      0.245      0.199      0.058      2.461      2.370      8.550      0.981      1.194
  1479.5000     65.384      0.000     64.587     50.650     16.835     59.981     13.937     33.815      0.243      0.195      0.059      2.445      2.376      8.494      0.981      1.194
  1480.0000     63.618      0.000     63.076     49.417     16.899     58.738     13.659     32.518      0.236      0.190      0.059      2.461      2.385      8.485      0.981      1.194
  1480.5000     60.924      0.000     60.888     46.885     16.065     56.942     14.003     30.820      0.225      0.183      0.073      2.457      2.397      8.485      0.981      1.194
  1481.0000     59.405      0.000     59.351     45.634     15.470     55.437     13.717     30.164      0.224      0.193      0.073      2.424      2.380      8.481      0.981      1.194
  1481.5000     58.751      0.000     58.775     45.800     15.924     54.804     12.976     29.875      0.242      0.202      0.079      2.450      2.365      8.472      0.981      1.194
  1482.0000     58.425      0.000     58.718     46.976     16.919     54.577     11.742     30.057      0.263      0.212      0.090      2.467      2.347      8.468      0.981      1.194
  1482.5000     57.876      0.000     58.722     48.213     17.837     54.384     10.509     30.376      0.273      0.226      0.099      2.416      2.324      8.476      0.981      1.194
  1483.0000     57.557      0.000     58.598     47.689     17.433     54.306     10.909     30.256      0.275      0.235      0.099      2.381      2.309      8.412      0.981      1.194
  1483.5000     57.748      0.000     58.420     46.998     16.466     54.074     11.422     30.532      0.280      0.240      0.094      2.334      2.299      8.455      0.981      1.194
  1484.0000     57.956      0.000     58.107     46.554     15.538     53.633     11.553     31.015      0.280      0.246      0.090      2.280      2.290      8.390      0.981      1.194
  1484.5000     57.264      0.000     57.653     46.264     14.909     53.057     11.390     31.354      0.275      0.253      0.076      2.262      2.278      8.408      0.981      1.194
  1485.0000     57.423      0.000     57.871     47.391     14.882     52.901     10.480     32.508      0.261      0.243      0.068      2.332      2.294      8.489      0.981      1.194
  1485.5000     58.053      0.000     58.429     49.010     15.052     53.015      9.419     33.958      0.250      0.222      0.068      2.389      2.330      8.455      0.981      1.194
  1486.0000     56.824      0.000     57.871     49.486     15.978     52.433      8.385     33.508      0.246      0.196      0.081      2.464      2.375      8.459      0.981      1.194
  1486.5000     54.031      0.000     56.099     48.089     16.981     51.171      8.009     31.108      0.251      0.174      0.092      2.574      2.412      8.507      0.981      1.194
  1487.0000     45.592      0.000     47.133     36.824     15.977     44.759     10.308     20.848      0.256      0.177      0.102      2.560      2.408      8.481      0.981      1.194
  1487.5000     44.867      0.000     46.017     36.251     15.859     43.647      9.766     20.393      0.266      0.217      0.090      2.400      2.338      8.339      0.981      1.194
  1488.0000     44.636      0.000     45.661     36.074     15.456     43.180      9.587     20.618      0.279      0.250      0.085      2.296      2.282      8.231      0.981      1.194
  1488.5000     44.201      0.000     45.503     35.890     15.029     42.974      9.613     20.860      0.286      0.274      0.083      2.241      2.242      8.205      0.981      1.194
  1489.0000     43.551      0.000     45.305     34.908     14.801     43.080     10.397     20.107      0.286      0.283      0.082      2.175      2.226      8.205      0.981      1.194
  1489.5000     43.553      0.000     45.322     33.995     14.999     43.472     11.328     18.996      0.279      0.278      0.081      2.156      2.234      8.183      0.981      1.194
  1490.0000     44.871      0.000     46.145     34.315     15.989     44.547     11.830     18.327      0.265      0.266      0.073      2.196      2.254      8.239      0.981      1.194
  1490.5000     49.309      0.000     50.485     38.383     18.334     48.642     12.102     20.049      0.244      0.243      0.068      2.279      2.294      8.304      0.981      1.194
  1491.0000     53.510      0.000     54.440     42.626     23.358     53.085     11.814     19.268      0.226      0.211      0.061      2.405      2.350      8.326      0.981      1.194
  1491.5000     55.352      0.000     55.552     46.210     26.202     53.921      9.342     20.008      0.204      0.169      0.060      2.535      2.422      8.360      0.981      1.194
  1492.0000     54.992      0.000     55.306     47.431     26.451     53.308      7.874     20.980      0.183      0.122      0.070      2.600      2.501      8.455      0.981      1.194
  1492.5000     54.420      0.000     54.663     47.418     25.713     52.369      7.245     21.705      0.172      0.097      0.069      2.683      2.545      8.464      0.981      1.194
  1493.0000     55.396      0.000     55.038     48.879     25.714     52.223      6.159     23.165      0.168      0.082      0.063      2.740      2.570      8.429      0.981      1.194
  1493.5000     57.784      0.000     56.777     51.713     26.406     53.400      5.064     25.307      0.159      0.070      0.066      2.789      2.591      8.321      0.981      1.194
  1494.0000     59.587      0.000     58.340     52.966     25.864     54.600      5.374     27.102      0.151      0.059      0.073      2.757      2.609      8.334      0.981      1.194
  1494.5000     59.387      0.000     58.576     52.123     24.766     54.866      6.453     27.357      0.151      0.044      0.088      2.807      2.635      8.412      0.981      1.194
  1495.0000     57.855      0.000     58.172     49.852     21.468     54.275      8.321     28.384      0.157      0.044      0.107      2.814      2.635      8.494      0.981      1.194
  1495.5000     56.448      0.000     57.931     48.748     18.663     53.603      9.182     30.085      0.172      0.067      0.121      2.849      2.596      8.528      0.981      1.194
  1496.0000     57.505      0.000     58.833     49.614     17.296     53.960      9.219     32.318      0.190      0.104      0.130      2.812      2.532      8.524      0.981      1.194
  1496.5000     59.892      0.000     60.721     52.591     18.127     55.240      8.130     34.464      0.215      0.145      0.121      2.665      2.462      8.541      0.981      1.194
  1497.0000     61.438      0.000     61.714     54.293     18.730     55.902      7.421     35.563      0.235      0.160      0.123      2.599      2.437      8.606      0.981      1.194
  1497.5000     62.002      0.000     61.927     55.455     19.432     55.913      6.472     36.023      0.245      0.175      0.107      2.514      2.410      8.576      0.981      1.194
  1498.0000     61.408      0.000     61.733     54.251     18.404     55.834      7.482     35.847      0.247      0.184      0.092      2.406      2.396      8.537      0.981      1.194
  1498.5000     61.084      0.000     61.964     53.450     17.744     56.178      8.514     35.706      0.248      0.193      0.071      2.272      2.380      8.537      0.981      1.194
  1499.0000     60.708      0.000     62.423     53.260     18.006     56.836      9.163     35.254      0.247      0.198      0.065      2.245      2.372      8.554      0.981      1.194
  1499.5000     60.930      0.000     63.072     53.400     19.130     57.826      9.673     34.270      0.240      0.195      0.071      2.259      2.376      8.550      0.981      1.194
  1500.0000     62.408      0.000     64.171     52.298     19.560     59.618     11.873     32.737      0.242      0.194      0.079      2.288      2.379      8.584      0.981      1.194
  1500.5000     67.242      0.000     67.905     54.049     20.853     63.673     13.856     33.197      0.261      0.187      0.119      2.420      2.390      8.563      0.981      1.194
  1501.0000     72.116      0.000     72.548     55.008     21.238     68.735     17.540     33.771      0.279      0.196      0.134      2.597      2.376      8.545      0.981      1.194
  1501.5000     74.357      0.000     74.110     54.944     21.301     70.560     19.167     33.643      0.297      0.203      0.132      2.692      2.364      8.554      0.981      1.194
  1502.0000     74.965      0.000     73.816     55.032     21.345     70.220     18.784     33.687      0.290      0.193      0.141      2.702      2.380      8.657      0.981      1.194
  1502.5000     73.898      0.000     72.167     54.835     21.172     68.355     17.332     33.662      0.267      0.182      0.143      2.701      2.399      8.645      0.981      1.194
  1503.0000     70.943      0.000     70.563     49.271     19.221     66.198     21.292     30.049      0.244      0.158      0.144      2.721      2.439      8.576      0.981      1.194
  1503.5000     69.926      0.000     70.020     47.295     18.246     65.829     22.725     29.049      0.244      0.163      0.109      2.565      2.431      8.541      0.981      1.194
  1504.0000     70.008      0.000     70.452     48.114     18.886     66.035     22.338     29.229      0.248      0.171      0.106      2.419      2.417      8.533      0.981      1.194
  1504.5000     70.819      0.000     70.820     48.091     18.980     66.403     22.729     29.111      0.249      0.189      0.089      2.312      2.387      8.545      0.981      1.194
  1505.0000     70.905      0.000     70.517     47.705     18.640     66.225     22.812     29.065      0.250      0.193      0.083      2.276      2.380      8.550      0.981      1.194
  1505.5000     71.517      0.000     70.350     47.557     18.841     66.343     22.793     28.717      0.241      0.196      0.081      2.279      2.376      8.459      0.981      1.194
  1506.0000     73.081      0.000     71.270     46.631     18.656     67.774     24.639     27.975      0.234      0.191      0.105      2.375      2.384      8.339      0.981      1.194
  1506.5000     79.102      0.000     77.977     49.018     18.584     74.591     28.959     30.434      0.248      0.209      0.115      2.524      2.352      8.351      0.981      1.194
  1507.0000     87.232      0.000     88.678     59.073     19.271     81.961     29.605     39.803      0.291      0.234      0.116      2.688      2.311      8.472      0.981      1.194
  1507.5000     96.665      0.000     99.272     78.998     27.502     89.252     20.274     51.496      0.341      0.238      0.123      2.896      2.304      8.864      0.981      1.194
  1508.0000     99.470      0.000    101.562     83.360     30.336     91.053     18.203     53.024      0.362      0.229      0.140      3.155      2.318      9.226      0.981      1.194
  1508.5000    101.909      0.000    103.293     86.660     31.763     92.015     16.634     54.897      0.371      0.207      0.172      3.401      2.356      9.334      0.981      1.194
  1509.0000    103.560      0.000    104.256     89.006     32.690     92.474     15.251     56.316      0.387      0.209      0.163      3.444      2.352      9.248      0.981      1.194
  1509.5000    104.279      0.000    104.340     87.955     31.702     92.563     16.384     56.253      0.407      0.226      0.152      3.417      2.324      9.080      0.981      1.194
  1510.0000    104.225      0.000    103.825     84.723     29.720     92.632     19.102     55.003      0.424      0.243      0.153      3.448      2.294      9.114      0.981      1.194
  1510.5000    103.680      0.000    102.954     79.945     26.777     92.417     23.009     53.168      0.423      0.249      0.161      3.454      2.285      9.175      0.981      1.194
  1511.0000    102.502      0.000    101.880     76.614     25.915     92.080     25.266     50.699      0.430      0.247      0.159      3.493      2.287      9.235      0.981      1.194
  1511.5000    101.056      0.000    100.255     75.195     26.563     91.295     25.060     48.631      0.421      0.233      0.170      3.489      2.311      9.192      0.981      1.194
  1512.0000     98.718      0.000     97.854     73.359     26.570     90.357     24.495     46.789      0.400      0.240      0.139      3.231      2.300      9.007      0.981      1.194
  1512.5000     96.482      0.000     96.195     70.498     26.770     89.533     25.696     43.728      0.345      0.209      0.132      3.103      2.352      9.050      0.981      1.194
  1513.0000     87.897      0.000     89.018     65.682     28.692     83.678     23.336     36.991      0.284      0.182      0.106      2.986      2.399      8.843      0.981      1.194
  1513.5000     77.681      0.000     79.359     59.961     28.736     74.933     19.398     31.225      0.232      0.132      0.111      2.918      2.485      8.550      0.981      1.194
  1514.0000     67.240      0.000     67.758     52.194     23.353     63.390     15.564     28.841      0.201      0.094      0.096      2.823      2.550      8.528      0.981      1.194
  1514.5000     64.744      0.000     65.198     50.610     21.136     60.521     14.588     29.473      0.193      0.081      0.086      2.799      2.572      8.541      0.981      1.194
  1515.0000     63.805      0.000     64.138     50.663     20.068     59.090     13.475     30.594      0.208      0.106      0.080      2.706      2.529      8.533      0.981      1.194
  1515.5000     61.197      0.000     62.020     49.835     18.966     56.795     12.185     30.869      0.235      0.140      0.081      2.593      2.471      8.528      0.981      1.194
  1516.0000     56.334      0.000     57.231     44.533     16.959     52.729     12.698     27.575      0.238      0.169      0.081      2.464      2.422      8.507      0.981      1.194
  1516.5000     51.299      0.000     53.095     40.254     15.383     49.213     12.841     24.870      0.228      0.189      0.080      2.365      2.387      8.464      0.981      1.194
  1517.0000     50.693      0.000     52.844     40.557     15.710     48.925     12.287     24.847      0.229      0.205      0.075      2.253      2.360      8.446      0.981      1.194
  1517.5000     50.277      0.000     52.633     40.266     15.836     48.800     12.366     24.430      0.233      0.210      0.078      2.221      2.351      8.481      0.981      1.194
  1518.0000     49.996      0.000     52.369     39.310     15.484     48.738     13.060     23.826      0.233      0.221      0.073      2.197      2.333      8.485      0.981      1.194
  1518.5000     49.811      0.000     52.197     38.883     15.590     48.701     13.314     23.293      0.232      0.233      0.064      2.200      2.311      8.489      0.981      1.194
  1519.0000     51.306      0.000     53.061     40.534     16.441     49.294     12.527     24.092      0.233      0.237      0.065      2.218      2.305      8.455      0.981      1.194
  1519.5000     54.350      0.000     55.405     44.329     18.390     51.102     11.077     25.938      0.224      0.229      0.083      2.303      2.319      8.438      0.981      1.194
  1520.0000     66.428      0.000     67.355     55.171     23.384     61.838     12.184     31.787      0.225      0.222      0.078      2.378      2.330      8.485      0.981      1.194
  1520.5000     77.195      0.000     79.390     65.963     28.183     72.876     13.427     37.780      0.235      0.200      0.079      2.545      2.368      8.567      0.981      1.194
  1521.0000     83.212      0.000     86.546     72.458     29.184     78.797     14.088     43.274      0.248      0.175      0.086      2.685      2.411      8.558      0.981      1.194
  1521.5000     85.074      0.000     88.229     73.164     28.826     80.305     15.065     44.338      0.260      0.139      0.113      2.855      2.473      8.610      0.981      1.194
  1522.0000     86.242      0.000     88.611     72.137     28.256     80.940     16.474     43.881      0.270      0.133      0.116      2.902      2.482      8.830      0.981      1.194
  1522.5000     86.731      0.000     88.747     71.336     28.001     81.307     17.411     43.335      0.270      0.145      0.108      2.929      2.462      8.976      0.981      1.194
  1523.0000     87.775      0.000     89.516     71.214     27.816     82.149     18.302     43.398      0.271      0.142      0.144      2.985      2.467      9.032      0.981      1.194
  1523.5000     88.197      0.000     90.238     70.476     26.740     82.937     19.762     43.736      0.285      0.165      0.191      2.966      2.427      8.890      0.981      1.194
  1524.0000     88.578      0.000     90.656     69.342     25.711     83.543     21.315     43.631      0.313      0.205      0.203      2.920      2.359      8.864      0.981      1.194
  1524.5000     89.213      0.000     90.961     68.622     25.034     83.970     22.339     43.587      0.343      0.248      0.190      2.847      2.286      9.153      0.981      1.194
  1525.0000     88.107      0.000     90.348     66.925     23.709     83.539     23.423     43.215      0.351      0.281      0.206      2.846      2.229      9.205      0.981      1.194
  1525.5000     85.825      0.000     89.005     64.830     21.957     82.285     24.175     42.874      0.346      0.286      0.211      2.907      2.221      9.244      0.981      1.194
  1526.0000     84.994      0.000     88.491     63.574     20.862     81.850     24.917     42.711      0.336      0.266      0.200      3.005      2.255      9.192      0.981      1.194
  1526.5000     85.564      0.000     89.007     64.004     20.719     82.194     25.003     43.284      0.326      0.248      0.183      3.103      2.286      9.114      0.981      1.194
  1527.0000     86.915      0.000     89.804     66.726     22.061     82.466     23.078     44.665      0.319      0.208      0.180      3.232      2.354      9.002      0.981      1.194
"""