<?xml version="1.0"?>
<VOTABLE version="1.1" xsi:schemaLocation="http://www.ivoa.net/xml/VOTable/v1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
  <INFO name="QUERY_STATUS" value="OK"/>
  <RESOURCE type="results">
    <TABLE utype="photdm:PhotometryFilter.transmissionCurve.spectrum">
    <PARAM name="FilterProfileService" value="ivo://svo/fps" ucd="meta.ref.ivorn" utype="PhotometryFilter.fpsIdentifier" datatype="char" arraysize="*"/>
    <PARAM name="filterID" value="MKO/NSFCam.H" ucd="meta.id" utype="photdm:PhotometryFilter.identifier" datatype="char" arraysize="*"/>
    <PARAM name="WavelengthUnit" value="Angstrom" ucd="meta.unit" utype="PhotometryFilter.SpectralAxis.unit" datatype="char" arraysize="*"/>
    <PARAM name="WavelengthUCD" value="em.wl" ucd="meta.ucd" utype="PhotometryFilter.SpectralAxis.UCD" datatype="char" arraysize="*"/>
    <PARAM name="Description" value="Mauna kea Obsevatory. NSFCam H filter" ucd="meta.note" utype="photdm:PhotometryFilter.description" datatype="char" arraysize="*"/>
    <PARAM name="PhotSystem" value="NSFCam" utype="photdm:PhotometricSystem.description" datatype="char" arraysize="*">
       <DESCRIPTION>Photometric system</DESCRIPTION>
    </PARAM>
    <PARAM name="Instrument" value="NSFCam" ucd="instr" datatype="char" arraysize="*">
       <DESCRIPTION>Instrument</DESCRIPTION>
    </PARAM>
    <PARAM name="Facility" value="MKO" ucd="instr.obsty" datatype="char" arraysize="*">
       <DESCRIPTION>Observational facility</DESCRIPTION>
    </PARAM>
    <PARAM name="ProfileReference" value="http://irtfweb.ifa.hawaii.edu/~nsfcam2/Filter_Profiles.html" datatype="char" arraysize="*"/>
    <PARAM name="Description" value="Mauna kea Obsevatory. NSFCam H filter" ucd="meta.note" utype="photdm:PhotometryFilter.description" datatype="char" arraysize="*"/>
    <PARAM name="WavelengthMean" value="16298.26090007" unit="Angstrom" ucd="em.wl" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Location.Value" datatype="float" >
       <DESCRIPTION>Mean wavelength. Defined as integ[x*filter(x) dx]/integ[filter(x) dx]</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthEff" value="16141.059581183" unit="Angstrom" ucd="em.wl.effective" datatype="float" >
       <DESCRIPTION>Effective wavelength. Defined as integ[x*filter(x)*vega(x) dx]/integ[filter(x)*vega(x) dx]</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthMin" value="14509.797991543" unit="Angstrom" ucd="em.wl;stat.min" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Bounds.Start" datatype="float" >
       <DESCRIPTION>Minimum filter wavelength. Defined as the first lambda value with a transmission at least 1% of maximum transmission</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthMax" value="18091.05323295" unit="Angstrom" ucd="em.wl;stat.max" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Bounds.Stop" datatype="float" >
       <DESCRIPTION>Maximum filter wavelength. Defined as the last lambda value with a transmission at least 1% of maximum transmission</DESCRIPTION>
    </PARAM>
    <PARAM name="WidthEff" value="2845.7873474091" unit="Angstrom" ucd="instr.bandwidth" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Bounds.Extent" datatype="float" >
       <DESCRIPTION>Effective width. Defined as integ[x*filter(x) dx].\nEquivalent to the horizontal size of a rectangle with height equal to maximum transmission and with the same area that the one covered by the filter transmission curve.</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthCen" value="16317.995053937" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Central wavelength. Defined as the central wavelength between the two points defining FWMH</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthPivot" value="16275.26349001" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Peak wavelength. Defined as sqrt{integ[x*filter(x) dx]/integ[filter(x) dx/x]}</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthPeak" value="16111" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Peak wavelength. Defined as the lambda value with larger transmission</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthPhot" value="16186.773347798" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Photon distribution based effective wavelength. Defined as integ[x^2*filter(x)*vega(x) dx]/integ[x*filter(x)*vega(x) dx]</DESCRIPTION>
    </PARAM>
    <PARAM name="FWHM" value="2956.9480764561" unit="Angstrom" ucd="instr.bandwidth" datatype="float" >
       <DESCRIPTION>Full width at half maximum. Defined as the difference between the two wavelengths for which filter transmission is half maximum</DESCRIPTION>
    </PARAM>
    <PARAM name="PhotCalID" value="MKO/NSFCam.H/Vega" ucd="meta.id" utype="photdm:PhotCal.identifier" datatype="char" arraysize="*"/>
    <PARAM name="MagSys" value="Vega" ucd="meta.code" utype="photdm:PhotCal.MagnitudeSystem.type" datatype="char" arraysize="*"/>
    <PARAM name="ZeroPoint" value="1045.8863841551" unit="Jy" ucd="phot.flux.density" utype="photdm:PhotCal.ZeroPoint.Flux.value" datatype="float" />
    <PARAM name="ZeroPointUnit" value="Jy" ucd="meta.unit" utype="photdm:PhotCal.ZeroPoint.Flux.unit" datatype="char" arraysize="*"/>
    <PARAM name="ZeroPointType" value="Pogson" ucd="meta.code" utype="photdm:PhotCal.ZeroPoint.type" datatype="char" arraysize="*"/>
      <FIELD name="Wavelength" utype="spec:Data.SpectralAxis.Value" ucd="em.wl" unit="Angstrom" datatype="float"/>
      <FIELD name="Transmission" utype="spec:Data.FluxAxis.Value" ucd="phys.transmission" unit="" datatype="float"/>
      <DATA>
        <TABLEDATA>
          <TR>
            <TD>13820.000</TD>
            <TD>0</TD>
          </TR>
          <TR>
            <TD>13825.000</TD>
            <TD>3.05e-05</TD>
          </TR>
          <TR>
            <TD>13830.000</TD>
            <TD>3.05e-05</TD>
          </TR>
          <TR>
            <TD>13835.000</TD>
            <TD>3.07e-05</TD>
          </TR>
          <TR>
            <TD>13840.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13845.000</TD>
            <TD>3.07e-05</TD>
          </TR>
          <TR>
            <TD>13850.000</TD>
            <TD>3.07e-05</TD>
          </TR>
          <TR>
            <TD>13855.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13860.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13865.000</TD>
            <TD>0.0001069</TD>
          </TR>
          <TR>
            <TD>13870.000</TD>
            <TD>0.0001069</TD>
          </TR>
          <TR>
            <TD>13875.000</TD>
            <TD>0.0001069</TD>
          </TR>
          <TR>
            <TD>13880.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13885.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13890.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13895.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13900.000</TD>
            <TD>0.0001069</TD>
          </TR>
          <TR>
            <TD>13905.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13910.000</TD>
            <TD>0.0001069</TD>
          </TR>
          <TR>
            <TD>13915.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13920.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13925.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13930.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13935.000</TD>
            <TD>0.0001069</TD>
          </TR>
          <TR>
            <TD>13940.000</TD>
            <TD>0.0001069</TD>
          </TR>
          <TR>
            <TD>13945.000</TD>
            <TD>0.0001526</TD>
          </TR>
          <TR>
            <TD>13950.000</TD>
            <TD>0.0001526</TD>
          </TR>
          <TR>
            <TD>13955.000</TD>
            <TD>0.0001526</TD>
          </TR>
          <TR>
            <TD>13960.000</TD>
            <TD>0.0001069</TD>
          </TR>
          <TR>
            <TD>13965.000</TD>
            <TD>0.0001069</TD>
          </TR>
          <TR>
            <TD>13970.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13975.000</TD>
            <TD>7.64e-05</TD>
          </TR>
          <TR>
            <TD>13980.000</TD>
            <TD>0.0001069</TD>
          </TR>
          <TR>
            <TD>13985.000</TD>
            <TD>0.0001526</TD>
          </TR>
          <TR>
            <TD>13990.000</TD>
            <TD>0.0001831</TD>
          </TR>
          <TR>
            <TD>13995.000</TD>
            <TD>0.0001831</TD>
          </TR>
          <TR>
            <TD>14000.000</TD>
            <TD>0.0001831</TD>
          </TR>
          <TR>
            <TD>14005.000</TD>
            <TD>0.0001532</TD>
          </TR>
          <TR>
            <TD>14010.000</TD>
            <TD>0.0001532</TD>
          </TR>
          <TR>
            <TD>14015.000</TD>
            <TD>0.0001837</TD>
          </TR>
          <TR>
            <TD>14020.000</TD>
            <TD>0.0001837</TD>
          </TR>
          <TR>
            <TD>14025.000</TD>
            <TD>0.0002294</TD>
          </TR>
          <TR>
            <TD>14030.000</TD>
            <TD>0.0002294</TD>
          </TR>
          <TR>
            <TD>14035.000</TD>
            <TD>0.0001837</TD>
          </TR>
          <TR>
            <TD>14040.000</TD>
            <TD>0.0002294</TD>
          </TR>
          <TR>
            <TD>14045.000</TD>
            <TD>0.0001837</TD>
          </TR>
          <TR>
            <TD>14050.000</TD>
            <TD>0.0001837</TD>
          </TR>
          <TR>
            <TD>14055.000</TD>
            <TD>0.0001837</TD>
          </TR>
          <TR>
            <TD>14060.000</TD>
            <TD>0.0001532</TD>
          </TR>
          <TR>
            <TD>14065.000</TD>
            <TD>0.0001837</TD>
          </TR>
          <TR>
            <TD>14070.000</TD>
            <TD>0.0002294</TD>
          </TR>
          <TR>
            <TD>14075.000</TD>
            <TD>0.0002751</TD>
          </TR>
          <TR>
            <TD>14080.000</TD>
            <TD>0.0003513</TD>
          </TR>
          <TR>
            <TD>14085.000</TD>
            <TD>0.000397</TD>
          </TR>
          <TR>
            <TD>14090.000</TD>
            <TD>0.000397</TD>
          </TR>
          <TR>
            <TD>14095.000</TD>
            <TD>0.0004275</TD>
          </TR>
          <TR>
            <TD>14100.000</TD>
            <TD>0.000397</TD>
          </TR>
          <TR>
            <TD>14105.000</TD>
            <TD>0.0003513</TD>
          </TR>
          <TR>
            <TD>14110.000</TD>
            <TD>0.000397</TD>
          </TR>
          <TR>
            <TD>14115.000</TD>
            <TD>0.000397</TD>
          </TR>
          <TR>
            <TD>14120.000</TD>
            <TD>0.0004275</TD>
          </TR>
          <TR>
            <TD>14125.000</TD>
            <TD>0.0004732</TD>
          </TR>
          <TR>
            <TD>14130.000</TD>
            <TD>0.0005037</TD>
          </TR>
          <TR>
            <TD>14135.000</TD>
            <TD>0.0005037</TD>
          </TR>
          <TR>
            <TD>14140.000</TD>
            <TD>0.0005494</TD>
          </TR>
          <TR>
            <TD>14144.000</TD>
            <TD>0.0005951</TD>
          </TR>
          <TR>
            <TD>14149.000</TD>
            <TD>0.0005957</TD>
          </TR>
          <TR>
            <TD>14154.000</TD>
            <TD>0.0005805</TD>
          </TR>
          <TR>
            <TD>14159.000</TD>
            <TD>0.0005805</TD>
          </TR>
          <TR>
            <TD>14164.000</TD>
            <TD>0.000611</TD>
          </TR>
          <TR>
            <TD>14169.000</TD>
            <TD>0.0005805</TD>
          </TR>
          <TR>
            <TD>14174.000</TD>
            <TD>0.0006568</TD>
          </TR>
          <TR>
            <TD>14179.000</TD>
            <TD>0.0006873</TD>
          </TR>
          <TR>
            <TD>14184.000</TD>
            <TD>0.0006873</TD>
          </TR>
          <TR>
            <TD>14189.000</TD>
            <TD>0.0007635</TD>
          </TR>
          <TR>
            <TD>14194.000</TD>
            <TD>0.000794</TD>
          </TR>
          <TR>
            <TD>14199.000</TD>
            <TD>0.0008702</TD>
          </TR>
          <TR>
            <TD>14204.000</TD>
            <TD>0.0009159</TD>
          </TR>
          <TR>
            <TD>14209.000</TD>
            <TD>0.0009464</TD>
          </TR>
          <TR>
            <TD>14214.000</TD>
            <TD>0.0009464</TD>
          </TR>
          <TR>
            <TD>14219.000</TD>
            <TD>0.0009464</TD>
          </TR>
          <TR>
            <TD>14224.000</TD>
            <TD>0.0009464</TD>
          </TR>
          <TR>
            <TD>14229.000</TD>
            <TD>0.0009769</TD>
          </TR>
          <TR>
            <TD>14234.000</TD>
            <TD>0.0009769</TD>
          </TR>
          <TR>
            <TD>14239.000</TD>
            <TD>0.0010074</TD>
          </TR>
          <TR>
            <TD>14244.000</TD>
            <TD>0.0010836</TD>
          </TR>
          <TR>
            <TD>14249.000</TD>
            <TD>0.0011599</TD>
          </TR>
          <TR>
            <TD>14254.000</TD>
            <TD>0.0012514</TD>
          </TR>
          <TR>
            <TD>14259.000</TD>
            <TD>0.0012514</TD>
          </TR>
          <TR>
            <TD>14264.000</TD>
            <TD>0.0012971</TD>
          </TR>
          <TR>
            <TD>14269.000</TD>
            <TD>0.0012971</TD>
          </TR>
          <TR>
            <TD>14274.000</TD>
            <TD>0.0013276</TD>
          </TR>
          <TR>
            <TD>14279.000</TD>
            <TD>0.0013276</TD>
          </TR>
          <TR>
            <TD>14284.000</TD>
            <TD>0.0013276</TD>
          </TR>
          <TR>
            <TD>14289.000</TD>
            <TD>0.0013428</TD>
          </TR>
          <TR>
            <TD>14294.000</TD>
            <TD>0.0013437</TD>
          </TR>
          <TR>
            <TD>14299.000</TD>
            <TD>0.00142</TD>
          </TR>
          <TR>
            <TD>14304.000</TD>
            <TD>0.00142</TD>
          </TR>
          <TR>
            <TD>14309.000</TD>
            <TD>0.0014657</TD>
          </TR>
          <TR>
            <TD>14314.000</TD>
            <TD>0.001542</TD>
          </TR>
          <TR>
            <TD>14319.000</TD>
            <TD>0.0016182</TD>
          </TR>
          <TR>
            <TD>14324.000</TD>
            <TD>0.0017402</TD>
          </TR>
          <TR>
            <TD>14329.000</TD>
            <TD>0.0017859</TD>
          </TR>
          <TR>
            <TD>14334.000</TD>
            <TD>0.0018164</TD>
          </TR>
          <TR>
            <TD>14339.000</TD>
            <TD>0.0018164</TD>
          </TR>
          <TR>
            <TD>14344.000</TD>
            <TD>0.0018926</TD>
          </TR>
          <TR>
            <TD>14349.000</TD>
            <TD>0.0020146</TD>
          </TR>
          <TR>
            <TD>14354.000</TD>
            <TD>0.0021061</TD>
          </TR>
          <TR>
            <TD>14359.000</TD>
            <TD>0.0021824</TD>
          </TR>
          <TR>
            <TD>14364.000</TD>
            <TD>0.0021976</TD>
          </TR>
          <TR>
            <TD>14369.000</TD>
            <TD>0.0023044</TD>
          </TR>
          <TR>
            <TD>14374.000</TD>
            <TD>0.0024722</TD>
          </TR>
          <TR>
            <TD>14379.000</TD>
            <TD>0.0025942</TD>
          </TR>
          <TR>
            <TD>14384.000</TD>
            <TD>0.002762</TD>
          </TR>
          <TR>
            <TD>14389.000</TD>
            <TD>0.0028077</TD>
          </TR>
          <TR>
            <TD>14394.000</TD>
            <TD>0.0028534</TD>
          </TR>
          <TR>
            <TD>14399.000</TD>
            <TD>0.0029297</TD>
          </TR>
          <TR>
            <TD>14404.000</TD>
            <TD>0.0030221</TD>
          </TR>
          <TR>
            <TD>14409.000</TD>
            <TD>0.0031594</TD>
          </TR>
          <TR>
            <TD>14414.000</TD>
            <TD>0.0032509</TD>
          </TR>
          <TR>
            <TD>14419.000</TD>
            <TD>0.0034187</TD>
          </TR>
          <TR>
            <TD>14424.000</TD>
            <TD>0.003617</TD>
          </TR>
          <TR>
            <TD>14429.000</TD>
            <TD>0.0037848</TD>
          </TR>
          <TR>
            <TD>14434.000</TD>
            <TD>0.0040594</TD>
          </TR>
          <TR>
            <TD>14439.000</TD>
            <TD>0.004273</TD>
          </TR>
          <TR>
            <TD>14444.000</TD>
            <TD>0.0044713</TD>
          </TR>
          <TR>
            <TD>14449.000</TD>
            <TD>0.0047306</TD>
          </TR>
          <TR>
            <TD>14454.000</TD>
            <TD>0.0048679</TD>
          </TR>
          <TR>
            <TD>14459.000</TD>
            <TD>0.0051273</TD>
          </TR>
          <TR>
            <TD>14464.000</TD>
            <TD>0.0054324</TD>
          </TR>
          <TR>
            <TD>14469.000</TD>
            <TD>0.005768</TD>
          </TR>
          <TR>
            <TD>14474.000</TD>
            <TD>0.0061189</TD>
          </TR>
          <TR>
            <TD>14479.000</TD>
            <TD>0.0064546</TD>
          </TR>
          <TR>
            <TD>14484.000</TD>
            <TD>0.0067902</TD>
          </TR>
          <TR>
            <TD>14489.000</TD>
            <TD>0.0071114</TD>
          </TR>
          <TR>
            <TD>14494.000</TD>
            <TD>0.0075386</TD>
          </TR>
          <TR>
            <TD>14499.000</TD>
            <TD>0.0079963</TD>
          </TR>
          <TR>
            <TD>14504.000</TD>
            <TD>0.0084235</TD>
          </TR>
          <TR>
            <TD>14509.000</TD>
            <TD>0.0089423</TD>
          </TR>
          <TR>
            <TD>14514.000</TD>
            <TD>0.0094153</TD>
          </TR>
          <TR>
            <TD>14519.000</TD>
            <TD>0.0099798</TD>
          </TR>
          <TR>
            <TD>14524.000</TD>
            <TD>0.0106511</TD>
          </TR>
          <TR>
            <TD>14529.000</TD>
            <TD>0.0113377</TD>
          </TR>
          <TR>
            <TD>14534.000</TD>
            <TD>0.0121921</TD>
          </TR>
          <TR>
            <TD>14539.000</TD>
            <TD>0.0130618</TD>
          </TR>
          <TR>
            <TD>14544.000</TD>
            <TD>0.0138552</TD>
          </TR>
          <TR>
            <TD>14549.000</TD>
            <TD>0.0148012</TD>
          </TR>
          <TR>
            <TD>14554.000</TD>
            <TD>0.0157472</TD>
          </TR>
          <TR>
            <TD>14559.000</TD>
            <TD>0.016739</TD>
          </TR>
          <TR>
            <TD>14564.000</TD>
            <TD>0.0179291</TD>
          </TR>
          <TR>
            <TD>14569.000</TD>
            <TD>0.0192115</TD>
          </TR>
          <TR>
            <TD>14574.000</TD>
            <TD>0.0205695</TD>
          </TR>
          <TR>
            <TD>14579.000</TD>
            <TD>0.0221411</TD>
          </TR>
          <TR>
            <TD>14584.000</TD>
            <TD>0.023728</TD>
          </TR>
          <TR>
            <TD>14589.000</TD>
            <TD>0.0254369</TD>
          </TR>
          <TR>
            <TD>14594.000</TD>
            <TD>0.0272679</TD>
          </TR>
          <TR>
            <TD>14599.000</TD>
            <TD>0.0292668</TD>
          </TR>
          <TR>
            <TD>14604.000</TD>
            <TD>0.0313725</TD>
          </TR>
          <TR>
            <TD>14609.000</TD>
            <TD>0.033646</TD>
          </TR>
          <TR>
            <TD>14614.000</TD>
            <TD>0.0361026</TD>
          </TR>
          <TR>
            <TD>14619.000</TD>
            <TD>0.0387576</TD>
          </TR>
          <TR>
            <TD>14624.000</TD>
            <TD>0.0416872</TD>
          </TR>
          <TR>
            <TD>14629.000</TD>
            <TD>0.0448457</TD>
          </TR>
          <TR>
            <TD>14634.000</TD>
            <TD>0.0481879</TD>
          </TR>
          <TR>
            <TD>14639.000</TD>
            <TD>0.0518347</TD>
          </TR>
          <TR>
            <TD>14644.000</TD>
            <TD>0.0556493</TD>
          </TR>
          <TR>
            <TD>14649.000</TD>
            <TD>0.0597386</TD>
          </TR>
          <TR>
            <TD>14654.000</TD>
            <TD>0.064011</TD>
          </TR>
          <TR>
            <TD>14659.000</TD>
            <TD>0.0686344</TD>
          </TR>
          <TR>
            <TD>14664.000</TD>
            <TD>0.073624</TD>
          </TR>
          <TR>
            <TD>14669.000</TD>
            <TD>0.0790713</TD>
          </TR>
          <TR>
            <TD>14674.000</TD>
            <TD>0.0847628</TD>
          </TR>
          <TR>
            <TD>14679.000</TD>
            <TD>0.0907595</TD>
          </TR>
          <TR>
            <TD>14684.000</TD>
            <TD>0.0969545</TD>
          </TR>
          <TR>
            <TD>14689.000</TD>
            <TD>0.103638</TD>
          </TR>
          <TR>
            <TD>14694.000</TD>
            <TD>0.110764</TD>
          </TR>
          <TR>
            <TD>14698.000</TD>
            <TD>0.117936</TD>
          </TR>
          <TR>
            <TD>14703.000</TD>
            <TD>0.125428</TD>
          </TR>
          <TR>
            <TD>14708.000</TD>
            <TD>0.133255</TD>
          </TR>
          <TR>
            <TD>14713.000</TD>
            <TD>0.141465</TD>
          </TR>
          <TR>
            <TD>14718.000</TD>
            <TD>0.150528</TD>
          </TR>
          <TR>
            <TD>14723.000</TD>
            <TD>0.159287</TD>
          </TR>
          <TR>
            <TD>14728.000</TD>
            <TD>0.1689</TD>
          </TR>
          <TR>
            <TD>14733.000</TD>
            <TD>0.178452</TD>
          </TR>
          <TR>
            <TD>14738.000</TD>
            <TD>0.188248</TD>
          </TR>
          <TR>
            <TD>14743.000</TD>
            <TD>0.199066</TD>
          </TR>
          <TR>
            <TD>14748.000</TD>
            <TD>0.209152</TD>
          </TR>
          <TR>
            <TD>14753.000</TD>
            <TD>0.219834</TD>
          </TR>
          <TR>
            <TD>14758.000</TD>
            <TD>0.231095</TD>
          </TR>
          <TR>
            <TD>14763.000</TD>
            <TD>0.242402</TD>
          </TR>
          <TR>
            <TD>14768.000</TD>
            <TD>0.254563</TD>
          </TR>
          <TR>
            <TD>14773.000</TD>
            <TD>0.266541</TD>
          </TR>
          <TR>
            <TD>14778.000</TD>
            <TD>0.278733</TD>
          </TR>
          <TR>
            <TD>14783.000</TD>
            <TD>0.291107</TD>
          </TR>
          <TR>
            <TD>14788.000</TD>
            <TD>0.303696</TD>
          </TR>
          <TR>
            <TD>14793.000</TD>
            <TD>0.316971</TD>
          </TR>
          <TR>
            <TD>14798.000</TD>
            <TD>0.330048</TD>
          </TR>
          <TR>
            <TD>14803.000</TD>
            <TD>0.343582</TD>
          </TR>
          <TR>
            <TD>14808.000</TD>
            <TD>0.357758</TD>
          </TR>
          <TR>
            <TD>14813.000</TD>
            <TD>0.372025</TD>
          </TR>
          <TR>
            <TD>14818.000</TD>
            <TD>0.386795</TD>
          </TR>
          <TR>
            <TD>14823.000</TD>
            <TD>0.401032</TD>
          </TR>
          <TR>
            <TD>14828.000</TD>
            <TD>0.415634</TD>
          </TR>
          <TR>
            <TD>14833.000</TD>
            <TD>0.43042</TD>
          </TR>
          <TR>
            <TD>14838.000</TD>
            <TD>0.445816</TD>
          </TR>
          <TR>
            <TD>14843.000</TD>
            <TD>0.462494</TD>
          </TR>
          <TR>
            <TD>14848.000</TD>
            <TD>0.478028</TD>
          </TR>
          <TR>
            <TD>14853.000</TD>
            <TD>0.49408</TD>
          </TR>
          <TR>
            <TD>14858.000</TD>
            <TD>0.510513</TD>
          </TR>
          <TR>
            <TD>14863.000</TD>
            <TD>0.525833</TD>
          </TR>
          <TR>
            <TD>14868.000</TD>
            <TD>0.542282</TD>
          </TR>
          <TR>
            <TD>14873.000</TD>
            <TD>0.558701</TD>
          </TR>
          <TR>
            <TD>14878.000</TD>
            <TD>0.574402</TD>
          </TR>
          <TR>
            <TD>14883.000</TD>
            <TD>0.591065</TD>
          </TR>
          <TR>
            <TD>14888.000</TD>
            <TD>0.6082</TD>
          </TR>
          <TR>
            <TD>14893.000</TD>
            <TD>0.624115</TD>
          </TR>
          <TR>
            <TD>14898.000</TD>
            <TD>0.640427</TD>
          </TR>
          <TR>
            <TD>14903.000</TD>
            <TD>0.656754</TD>
          </TR>
          <TR>
            <TD>14908.000</TD>
            <TD>0.671662</TD>
          </TR>
          <TR>
            <TD>14913.000</TD>
            <TD>0.686844</TD>
          </TR>
          <TR>
            <TD>14918.000</TD>
            <TD>0.701431</TD>
          </TR>
          <TR>
            <TD>14923.000</TD>
            <TD>0.714707</TD>
          </TR>
          <TR>
            <TD>14928.000</TD>
            <TD>0.727982</TD>
          </TR>
          <TR>
            <TD>14933.000</TD>
            <TD>0.741135</TD>
          </TR>
          <TR>
            <TD>14938.000</TD>
            <TD>0.752961</TD>
          </TR>
          <TR>
            <TD>14943.000</TD>
            <TD>0.763794</TD>
          </TR>
          <TR>
            <TD>14948.000</TD>
            <TD>0.774414</TD>
          </TR>
          <TR>
            <TD>14953.000</TD>
            <TD>0.784653</TD>
          </TR>
          <TR>
            <TD>14958.000</TD>
            <TD>0.794251</TD>
          </TR>
          <TR>
            <TD>14963.000</TD>
            <TD>0.804657</TD>
          </TR>
          <TR>
            <TD>14968.000</TD>
            <TD>0.813034</TD>
          </TR>
          <TR>
            <TD>14973.000</TD>
            <TD>0.820404</TD>
          </TR>
          <TR>
            <TD>14978.000</TD>
            <TD>0.827133</TD>
          </TR>
          <TR>
            <TD>14983.000</TD>
            <TD>0.832794</TD>
          </TR>
          <TR>
            <TD>14988.000</TD>
            <TD>0.837585</TD>
          </TR>
          <TR>
            <TD>14993.000</TD>
            <TD>0.841843</TD>
          </TR>
          <TR>
            <TD>14998.000</TD>
            <TD>0.845428</TD>
          </TR>
          <TR>
            <TD>15003.000</TD>
            <TD>0.848694</TD>
          </TR>
          <TR>
            <TD>15008.000</TD>
            <TD>0.85144</TD>
          </TR>
          <TR>
            <TD>15013.000</TD>
            <TD>0.854202</TD>
          </TR>
          <TR>
            <TD>15018.000</TD>
            <TD>0.855453</TD>
          </TR>
          <TR>
            <TD>15023.000</TD>
            <TD>0.856384</TD>
          </TR>
          <TR>
            <TD>15028.000</TD>
            <TD>0.857132</TD>
          </TR>
          <TR>
            <TD>15033.000</TD>
            <TD>0.856781</TD>
          </TR>
          <TR>
            <TD>15038.000</TD>
            <TD>0.857162</TD>
          </TR>
          <TR>
            <TD>15043.000</TD>
            <TD>0.856598</TD>
          </TR>
          <TR>
            <TD>15048.000</TD>
            <TD>0.855835</TD>
          </TR>
          <TR>
            <TD>15053.000</TD>
            <TD>0.855133</TD>
          </TR>
          <TR>
            <TD>15058.000</TD>
            <TD>0.853912</TD>
          </TR>
          <TR>
            <TD>15063.000</TD>
            <TD>0.852921</TD>
          </TR>
          <TR>
            <TD>15068.000</TD>
            <TD>0.852631</TD>
          </TR>
          <TR>
            <TD>15073.000</TD>
            <TD>0.851624</TD>
          </TR>
          <TR>
            <TD>15078.000</TD>
            <TD>0.851608</TD>
          </TR>
          <TR>
            <TD>15083.000</TD>
            <TD>0.851349</TD>
          </TR>
          <TR>
            <TD>15088.000</TD>
            <TD>0.850464</TD>
          </TR>
          <TR>
            <TD>15093.000</TD>
            <TD>0.850479</TD>
          </TR>
          <TR>
            <TD>15098.000</TD>
            <TD>0.849487</TD>
          </TR>
          <TR>
            <TD>15103.000</TD>
            <TD>0.848114</TD>
          </TR>
          <TR>
            <TD>15108.000</TD>
            <TD>0.847473</TD>
          </TR>
          <TR>
            <TD>15113.000</TD>
            <TD>0.847107</TD>
          </TR>
          <TR>
            <TD>15118.000</TD>
            <TD>0.846786</TD>
          </TR>
          <TR>
            <TD>15123.000</TD>
            <TD>0.847809</TD>
          </TR>
          <TR>
            <TD>15128.000</TD>
            <TD>0.848144</TD>
          </TR>
          <TR>
            <TD>15133.000</TD>
            <TD>0.84845</TD>
          </TR>
          <TR>
            <TD>15138.000</TD>
            <TD>0.849396</TD>
          </TR>
          <TR>
            <TD>15143.000</TD>
            <TD>0.849899</TD>
          </TR>
          <TR>
            <TD>15148.000</TD>
            <TD>0.851059</TD>
          </TR>
          <TR>
            <TD>15153.000</TD>
            <TD>0.851776</TD>
          </TR>
          <TR>
            <TD>15158.000</TD>
            <TD>0.852264</TD>
          </TR>
          <TR>
            <TD>15163.000</TD>
            <TD>0.85376</TD>
          </TR>
          <TR>
            <TD>15168.000</TD>
            <TD>0.854294</TD>
          </TR>
          <TR>
            <TD>15173.000</TD>
            <TD>0.856186</TD>
          </TR>
          <TR>
            <TD>15178.000</TD>
            <TD>0.858597</TD>
          </TR>
          <TR>
            <TD>15183.000</TD>
            <TD>0.860062</TD>
          </TR>
          <TR>
            <TD>15188.000</TD>
            <TD>0.862366</TD>
          </TR>
          <TR>
            <TD>15193.000</TD>
            <TD>0.864243</TD>
          </TR>
          <TR>
            <TD>15198.000</TD>
            <TD>0.865051</TD>
          </TR>
          <TR>
            <TD>15203.000</TD>
            <TD>0.866974</TD>
          </TR>
          <TR>
            <TD>15208.000</TD>
            <TD>0.868957</TD>
          </TR>
          <TR>
            <TD>15213.000</TD>
            <TD>0.869904</TD>
          </TR>
          <TR>
            <TD>15218.000</TD>
            <TD>0.871628</TD>
          </TR>
          <TR>
            <TD>15223.000</TD>
            <TD>0.872955</TD>
          </TR>
          <TR>
            <TD>15228.000</TD>
            <TD>0.873733</TD>
          </TR>
          <TR>
            <TD>15233.000</TD>
            <TD>0.87532</TD>
          </TR>
          <TR>
            <TD>15238.000</TD>
            <TD>0.877396</TD>
          </TR>
          <TR>
            <TD>15243.000</TD>
            <TD>0.878525</TD>
          </TR>
          <TR>
            <TD>15248.000</TD>
            <TD>0.879974</TD>
          </TR>
          <TR>
            <TD>15252.000</TD>
            <TD>0.881683</TD>
          </TR>
          <TR>
            <TD>15257.000</TD>
            <TD>0.883133</TD>
          </TR>
          <TR>
            <TD>15262.000</TD>
            <TD>0.884247</TD>
          </TR>
          <TR>
            <TD>15267.000</TD>
            <TD>0.885895</TD>
          </TR>
          <TR>
            <TD>15272.000</TD>
            <TD>0.887009</TD>
          </TR>
          <TR>
            <TD>15277.000</TD>
            <TD>0.887375</TD>
          </TR>
          <TR>
            <TD>15282.000</TD>
            <TD>0.888336</TD>
          </TR>
          <TR>
            <TD>15287.000</TD>
            <TD>0.888672</TD>
          </TR>
          <TR>
            <TD>15292.000</TD>
            <TD>0.88855</TD>
          </TR>
          <TR>
            <TD>15297.000</TD>
            <TD>0.888138</TD>
          </TR>
          <TR>
            <TD>15302.000</TD>
            <TD>0.888397</TD>
          </TR>
          <TR>
            <TD>15307.000</TD>
            <TD>0.887573</TD>
          </TR>
          <TR>
            <TD>15312.000</TD>
            <TD>0.887405</TD>
          </TR>
          <TR>
            <TD>15317.000</TD>
            <TD>0.887955</TD>
          </TR>
          <TR>
            <TD>15322.000</TD>
            <TD>0.887329</TD>
          </TR>
          <TR>
            <TD>15327.000</TD>
            <TD>0.887436</TD>
          </TR>
          <TR>
            <TD>15332.000</TD>
            <TD>0.886917</TD>
          </TR>
          <TR>
            <TD>15337.000</TD>
            <TD>0.885498</TD>
          </TR>
          <TR>
            <TD>15342.000</TD>
            <TD>0.883697</TD>
          </TR>
          <TR>
            <TD>15347.000</TD>
            <TD>0.881988</TD>
          </TR>
          <TR>
            <TD>15352.000</TD>
            <TD>0.880463</TD>
          </TR>
          <TR>
            <TD>15357.000</TD>
            <TD>0.879806</TD>
          </TR>
          <TR>
            <TD>15362.000</TD>
            <TD>0.879822</TD>
          </TR>
          <TR>
            <TD>15367.000</TD>
            <TD>0.879547</TD>
          </TR>
          <TR>
            <TD>15372.000</TD>
            <TD>0.87883</TD>
          </TR>
          <TR>
            <TD>15377.000</TD>
            <TD>0.877655</TD>
          </TR>
          <TR>
            <TD>15382.000</TD>
            <TD>0.876572</TD>
          </TR>
          <TR>
            <TD>15387.000</TD>
            <TD>0.875748</TD>
          </TR>
          <TR>
            <TD>15392.000</TD>
            <TD>0.874161</TD>
          </TR>
          <TR>
            <TD>15397.000</TD>
            <TD>0.872986</TD>
          </TR>
          <TR>
            <TD>15402.000</TD>
            <TD>0.871063</TD>
          </TR>
          <TR>
            <TD>15407.000</TD>
            <TD>0.8685</TD>
          </TR>
          <TR>
            <TD>15412.000</TD>
            <TD>0.867432</TD>
          </TR>
          <TR>
            <TD>15417.000</TD>
            <TD>0.866226</TD>
          </TR>
          <TR>
            <TD>15422.000</TD>
            <TD>0.864838</TD>
          </TR>
          <TR>
            <TD>15427.000</TD>
            <TD>0.864746</TD>
          </TR>
          <TR>
            <TD>15432.000</TD>
            <TD>0.863983</TD>
          </TR>
          <TR>
            <TD>15437.000</TD>
            <TD>0.862991</TD>
          </TR>
          <TR>
            <TD>15442.000</TD>
            <TD>0.863052</TD>
          </TR>
          <TR>
            <TD>15447.000</TD>
            <TD>0.862717</TD>
          </TR>
          <TR>
            <TD>15452.000</TD>
            <TD>0.862549</TD>
          </TR>
          <TR>
            <TD>15457.000</TD>
            <TD>0.862442</TD>
          </TR>
          <TR>
            <TD>15462.000</TD>
            <TD>0.861893</TD>
          </TR>
          <TR>
            <TD>15467.000</TD>
            <TD>0.861191</TD>
          </TR>
          <TR>
            <TD>15472.000</TD>
            <TD>0.860672</TD>
          </TR>
          <TR>
            <TD>15477.000</TD>
            <TD>0.860336</TD>
          </TR>
          <TR>
            <TD>15482.000</TD>
            <TD>0.86058</TD>
          </TR>
          <TR>
            <TD>15487.000</TD>
            <TD>0.860321</TD>
          </TR>
          <TR>
            <TD>15492.000</TD>
            <TD>0.860336</TD>
          </TR>
          <TR>
            <TD>15497.000</TD>
            <TD>0.86058</TD>
          </TR>
          <TR>
            <TD>15502.000</TD>
            <TD>0.859802</TD>
          </TR>
          <TR>
            <TD>15507.000</TD>
            <TD>0.860535</TD>
          </TR>
          <TR>
            <TD>15512.000</TD>
            <TD>0.861893</TD>
          </TR>
          <TR>
            <TD>15517.000</TD>
            <TD>0.862701</TD>
          </TR>
          <TR>
            <TD>15522.000</TD>
            <TD>0.864136</TD>
          </TR>
          <TR>
            <TD>15527.000</TD>
            <TD>0.865127</TD>
          </TR>
          <TR>
            <TD>15532.000</TD>
            <TD>0.865295</TD>
          </TR>
          <TR>
            <TD>15537.000</TD>
            <TD>0.865799</TD>
          </TR>
          <TR>
            <TD>15542.000</TD>
            <TD>0.867096</TD>
          </TR>
          <TR>
            <TD>15547.000</TD>
            <TD>0.867889</TD>
          </TR>
          <TR>
            <TD>15552.000</TD>
            <TD>0.869003</TD>
          </TR>
          <TR>
            <TD>15557.000</TD>
            <TD>0.870666</TD>
          </TR>
          <TR>
            <TD>15562.000</TD>
            <TD>0.871887</TD>
          </TR>
          <TR>
            <TD>15567.000</TD>
            <TD>0.873093</TD>
          </TR>
          <TR>
            <TD>15572.000</TD>
            <TD>0.874969</TD>
          </TR>
          <TR>
            <TD>15577.000</TD>
            <TD>0.876297</TD>
          </TR>
          <TR>
            <TD>15582.000</TD>
            <TD>0.87735</TD>
          </TR>
          <TR>
            <TD>15587.000</TD>
            <TD>0.878723</TD>
          </TR>
          <TR>
            <TD>15592.000</TD>
            <TD>0.879791</TD>
          </TR>
          <TR>
            <TD>15597.000</TD>
            <TD>0.880783</TD>
          </TR>
          <TR>
            <TD>15602.000</TD>
            <TD>0.881989</TD>
          </TR>
          <TR>
            <TD>15607.000</TD>
            <TD>0.883224</TD>
          </TR>
          <TR>
            <TD>15612.000</TD>
            <TD>0.883606</TD>
          </TR>
          <TR>
            <TD>15617.000</TD>
            <TD>0.884186</TD>
          </TR>
          <TR>
            <TD>15622.000</TD>
            <TD>0.885391</TD>
          </TR>
          <TR>
            <TD>15627.000</TD>
            <TD>0.886673</TD>
          </TR>
          <TR>
            <TD>15632.000</TD>
            <TD>0.888931</TD>
          </TR>
          <TR>
            <TD>15637.000</TD>
            <TD>0.891022</TD>
          </TR>
          <TR>
            <TD>15642.000</TD>
            <TD>0.892502</TD>
          </TR>
          <TR>
            <TD>15647.000</TD>
            <TD>0.893158</TD>
          </TR>
          <TR>
            <TD>15652.000</TD>
            <TD>0.893829</TD>
          </TR>
          <TR>
            <TD>15657.000</TD>
            <TD>0.894394</TD>
          </TR>
          <TR>
            <TD>15662.000</TD>
            <TD>0.895172</TD>
          </TR>
          <TR>
            <TD>15667.000</TD>
            <TD>0.896545</TD>
          </TR>
          <TR>
            <TD>15672.000</TD>
            <TD>0.897186</TD>
          </TR>
          <TR>
            <TD>15677.000</TD>
            <TD>0.898331</TD>
          </TR>
          <TR>
            <TD>15682.000</TD>
            <TD>0.899445</TD>
          </TR>
          <TR>
            <TD>15687.000</TD>
            <TD>0.900269</TD>
          </TR>
          <TR>
            <TD>15692.000</TD>
            <TD>0.901016</TD>
          </TR>
          <TR>
            <TD>15697.000</TD>
            <TD>0.901062</TD>
          </TR>
          <TR>
            <TD>15702.000</TD>
            <TD>0.900589</TD>
          </TR>
          <TR>
            <TD>15707.000</TD>
            <TD>0.90004</TD>
          </TR>
          <TR>
            <TD>15712.000</TD>
            <TD>0.89917</TD>
          </TR>
          <TR>
            <TD>15717.000</TD>
            <TD>0.898605</TD>
          </TR>
          <TR>
            <TD>15722.000</TD>
            <TD>0.898086</TD>
          </TR>
          <TR>
            <TD>15727.000</TD>
            <TD>0.8974</TD>
          </TR>
          <TR>
            <TD>15732.000</TD>
            <TD>0.8974</TD>
          </TR>
          <TR>
            <TD>15737.000</TD>
            <TD>0.897278</TD>
          </TR>
          <TR>
            <TD>15742.000</TD>
            <TD>0.896133</TD>
          </TR>
          <TR>
            <TD>15747.000</TD>
            <TD>0.896042</TD>
          </TR>
          <TR>
            <TD>15752.000</TD>
            <TD>0.895416</TD>
          </TR>
          <TR>
            <TD>15757.000</TD>
            <TD>0.894195</TD>
          </TR>
          <TR>
            <TD>15762.000</TD>
            <TD>0.894073</TD>
          </TR>
          <TR>
            <TD>15767.000</TD>
            <TD>0.893082</TD>
          </TR>
          <TR>
            <TD>15772.000</TD>
            <TD>0.891785</TD>
          </TR>
          <TR>
            <TD>15777.000</TD>
            <TD>0.891434</TD>
          </TR>
          <TR>
            <TD>15782.000</TD>
            <TD>0.890533</TD>
          </TR>
          <TR>
            <TD>15787.000</TD>
            <TD>0.889511</TD>
          </TR>
          <TR>
            <TD>15792.000</TD>
            <TD>0.888641</TD>
          </TR>
          <TR>
            <TD>15797.000</TD>
            <TD>0.887192</TD>
          </TR>
          <TR>
            <TD>15802.000</TD>
            <TD>0.886139</TD>
          </TR>
          <TR>
            <TD>15806.000</TD>
            <TD>0.884613</TD>
          </TR>
          <TR>
            <TD>15811.000</TD>
            <TD>0.883896</TD>
          </TR>
          <TR>
            <TD>15816.000</TD>
            <TD>0.882996</TD>
          </TR>
          <TR>
            <TD>15821.000</TD>
            <TD>0.88208</TD>
          </TR>
          <TR>
            <TD>15826.000</TD>
            <TD>0.881302</TD>
          </TR>
          <TR>
            <TD>15831.000</TD>
            <TD>0.880798</TD>
          </TR>
          <TR>
            <TD>15836.000</TD>
            <TD>0.880188</TD>
          </TR>
          <TR>
            <TD>15841.000</TD>
            <TD>0.879379</TD>
          </TR>
          <TR>
            <TD>15846.000</TD>
            <TD>0.879242</TD>
          </TR>
          <TR>
            <TD>15851.000</TD>
            <TD>0.878128</TD>
          </TR>
          <TR>
            <TD>15856.000</TD>
            <TD>0.87764</TD>
          </TR>
          <TR>
            <TD>15861.000</TD>
            <TD>0.877136</TD>
          </TR>
          <TR>
            <TD>15866.000</TD>
            <TD>0.876999</TD>
          </TR>
          <TR>
            <TD>15871.000</TD>
            <TD>0.876633</TD>
          </TR>
          <TR>
            <TD>15876.000</TD>
            <TD>0.876846</TD>
          </TR>
          <TR>
            <TD>15881.000</TD>
            <TD>0.876846</TD>
          </TR>
          <TR>
            <TD>15886.000</TD>
            <TD>0.875748</TD>
          </TR>
          <TR>
            <TD>15891.000</TD>
            <TD>0.875442</TD>
          </TR>
          <TR>
            <TD>15896.000</TD>
            <TD>0.874313</TD>
          </TR>
          <TR>
            <TD>15901.000</TD>
            <TD>0.873413</TD>
          </TR>
          <TR>
            <TD>15906.000</TD>
            <TD>0.873474</TD>
          </TR>
          <TR>
            <TD>15911.000</TD>
            <TD>0.873444</TD>
          </TR>
          <TR>
            <TD>15916.000</TD>
            <TD>0.87384</TD>
          </TR>
          <TR>
            <TD>15921.000</TD>
            <TD>0.8741</TD>
          </TR>
          <TR>
            <TD>15926.000</TD>
            <TD>0.874618</TD>
          </TR>
          <TR>
            <TD>15931.000</TD>
            <TD>0.874908</TD>
          </TR>
          <TR>
            <TD>15936.000</TD>
            <TD>0.875046</TD>
          </TR>
          <TR>
            <TD>15941.000</TD>
            <TD>0.8759</TD>
          </TR>
          <TR>
            <TD>15946.000</TD>
            <TD>0.876373</TD>
          </TR>
          <TR>
            <TD>15951.000</TD>
            <TD>0.877182</TD>
          </TR>
          <TR>
            <TD>15956.000</TD>
            <TD>0.878098</TD>
          </TR>
          <TR>
            <TD>15961.000</TD>
            <TD>0.878281</TD>
          </TR>
          <TR>
            <TD>15966.000</TD>
            <TD>0.878799</TD>
          </TR>
          <TR>
            <TD>15971.000</TD>
            <TD>0.878998</TD>
          </TR>
          <TR>
            <TD>15976.000</TD>
            <TD>0.878769</TD>
          </TR>
          <TR>
            <TD>15981.000</TD>
            <TD>0.8797</TD>
          </TR>
          <TR>
            <TD>15986.000</TD>
            <TD>0.880341</TD>
          </TR>
          <TR>
            <TD>15991.000</TD>
            <TD>0.8815</TD>
          </TR>
          <TR>
            <TD>15996.000</TD>
            <TD>0.88327</TD>
          </TR>
          <TR>
            <TD>16001.000</TD>
            <TD>0.884293</TD>
          </TR>
          <TR>
            <TD>16006.000</TD>
            <TD>0.885483</TD>
          </TR>
          <TR>
            <TD>16011.000</TD>
            <TD>0.885925</TD>
          </TR>
          <TR>
            <TD>16016.000</TD>
            <TD>0.886658</TD>
          </TR>
          <TR>
            <TD>16021.000</TD>
            <TD>0.887772</TD>
          </TR>
          <TR>
            <TD>16026.000</TD>
            <TD>0.888687</TD>
          </TR>
          <TR>
            <TD>16031.000</TD>
            <TD>0.889954</TD>
          </TR>
          <TR>
            <TD>16036.000</TD>
            <TD>0.890945</TD>
          </TR>
          <TR>
            <TD>16041.000</TD>
            <TD>0.891754</TD>
          </TR>
          <TR>
            <TD>16046.000</TD>
            <TD>0.892654</TD>
          </TR>
          <TR>
            <TD>16051.000</TD>
            <TD>0.893784</TD>
          </TR>
          <TR>
            <TD>16056.000</TD>
            <TD>0.895264</TD>
          </TR>
          <TR>
            <TD>16061.000</TD>
            <TD>0.896103</TD>
          </TR>
          <TR>
            <TD>16066.000</TD>
            <TD>0.897324</TD>
          </TR>
          <TR>
            <TD>16071.000</TD>
            <TD>0.898621</TD>
          </TR>
          <TR>
            <TD>16076.000</TD>
            <TD>0.898727</TD>
          </TR>
          <TR>
            <TD>16081.000</TD>
            <TD>0.899612</TD>
          </TR>
          <TR>
            <TD>16086.000</TD>
            <TD>0.900101</TD>
          </TR>
          <TR>
            <TD>16091.000</TD>
            <TD>0.899582</TD>
          </TR>
          <TR>
            <TD>16096.000</TD>
            <TD>0.900589</TD>
          </TR>
          <TR>
            <TD>16101.000</TD>
            <TD>0.901016</TD>
          </TR>
          <TR>
            <TD>16106.000</TD>
            <TD>0.901092</TD>
          </TR>
          <TR>
            <TD>16111.000</TD>
            <TD>0.901779</TD>
          </TR>
          <TR>
            <TD>16116.000</TD>
            <TD>0.901276</TD>
          </TR>
          <TR>
            <TD>16121.000</TD>
            <TD>0.90097</TD>
          </TR>
          <TR>
            <TD>16126.000</TD>
            <TD>0.900589</TD>
          </TR>
          <TR>
            <TD>16131.000</TD>
            <TD>0.899841</TD>
          </TR>
          <TR>
            <TD>16136.000</TD>
            <TD>0.899704</TD>
          </TR>
          <TR>
            <TD>16141.000</TD>
            <TD>0.899292</TD>
          </TR>
          <TR>
            <TD>16146.000</TD>
            <TD>0.89946</TD>
          </TR>
          <TR>
            <TD>16151.000</TD>
            <TD>0.899887</TD>
          </TR>
          <TR>
            <TD>16156.000</TD>
            <TD>0.899246</TD>
          </TR>
          <TR>
            <TD>16161.000</TD>
            <TD>0.898849</TD>
          </TR>
          <TR>
            <TD>16166.000</TD>
            <TD>0.89772</TD>
          </TR>
          <TR>
            <TD>16171.000</TD>
            <TD>0.897125</TD>
          </TR>
          <TR>
            <TD>16176.000</TD>
            <TD>0.89624</TD>
          </TR>
          <TR>
            <TD>16181.000</TD>
            <TD>0.896133</TD>
          </TR>
          <TR>
            <TD>16186.000</TD>
            <TD>0.89566</TD>
          </TR>
          <TR>
            <TD>16191.000</TD>
            <TD>0.893921</TD>
          </TR>
          <TR>
            <TD>16196.000</TD>
            <TD>0.893097</TD>
          </TR>
          <TR>
            <TD>16201.000</TD>
            <TD>0.891067</TD>
          </TR>
          <TR>
            <TD>16206.000</TD>
            <TD>0.88913</TD>
          </TR>
          <TR>
            <TD>16211.000</TD>
            <TD>0.887436</TD>
          </TR>
          <TR>
            <TD>16216.000</TD>
            <TD>0.886093</TD>
          </TR>
          <TR>
            <TD>16221.000</TD>
            <TD>0.883987</TD>
          </TR>
          <TR>
            <TD>16226.000</TD>
            <TD>0.882172</TD>
          </TR>
          <TR>
            <TD>16231.000</TD>
            <TD>0.881042</TD>
          </TR>
          <TR>
            <TD>16236.000</TD>
            <TD>0.878906</TD>
          </TR>
          <TR>
            <TD>16241.000</TD>
            <TD>0.877884</TD>
          </TR>
          <TR>
            <TD>16246.000</TD>
            <TD>0.876739</TD>
          </TR>
          <TR>
            <TD>16251.000</TD>
            <TD>0.87471</TD>
          </TR>
          <TR>
            <TD>16256.000</TD>
            <TD>0.872207</TD>
          </TR>
          <TR>
            <TD>16261.000</TD>
            <TD>0.870178</TD>
          </TR>
          <TR>
            <TD>16266.000</TD>
            <TD>0.868057</TD>
          </TR>
          <TR>
            <TD>16271.000</TD>
            <TD>0.866333</TD>
          </TR>
          <TR>
            <TD>16276.000</TD>
            <TD>0.865249</TD>
          </TR>
          <TR>
            <TD>16281.000</TD>
            <TD>0.862655</TD>
          </TR>
          <TR>
            <TD>16286.000</TD>
            <TD>0.859878</TD>
          </TR>
          <TR>
            <TD>16291.000</TD>
            <TD>0.857788</TD>
          </TR>
          <TR>
            <TD>16296.000</TD>
            <TD>0.855484</TD>
          </TR>
          <TR>
            <TD>16301.000</TD>
            <TD>0.854065</TD>
          </TR>
          <TR>
            <TD>16306.000</TD>
            <TD>0.852722</TD>
          </TR>
          <TR>
            <TD>16311.000</TD>
            <TD>0.850616</TD>
          </TR>
          <TR>
            <TD>16316.000</TD>
            <TD>0.848755</TD>
          </TR>
          <TR>
            <TD>16321.000</TD>
            <TD>0.84674</TD>
          </TR>
          <TR>
            <TD>16326.000</TD>
            <TD>0.844772</TD>
          </TR>
          <TR>
            <TD>16331.000</TD>
            <TD>0.842728</TD>
          </TR>
          <TR>
            <TD>16336.000</TD>
            <TD>0.840469</TD>
          </TR>
          <TR>
            <TD>16341.000</TD>
            <TD>0.838821</TD>
          </TR>
          <TR>
            <TD>16346.000</TD>
            <TD>0.837127</TD>
          </TR>
          <TR>
            <TD>16351.000</TD>
            <TD>0.836029</TD>
          </TR>
          <TR>
            <TD>16356.000</TD>
            <TD>0.835144</TD>
          </TR>
          <TR>
            <TD>16360.000</TD>
            <TD>0.834122</TD>
          </TR>
          <TR>
            <TD>16365.000</TD>
            <TD>0.833038</TD>
          </TR>
          <TR>
            <TD>16370.000</TD>
            <TD>0.831573</TD>
          </TR>
          <TR>
            <TD>16375.000</TD>
            <TD>0.830246</TD>
          </TR>
          <TR>
            <TD>16380.000</TD>
            <TD>0.828277</TD>
          </TR>
          <TR>
            <TD>16385.000</TD>
            <TD>0.827164</TD>
          </TR>
          <TR>
            <TD>16390.000</TD>
            <TD>0.82579</TD>
          </TR>
          <TR>
            <TD>16395.000</TD>
            <TD>0.824554</TD>
          </TR>
          <TR>
            <TD>16400.000</TD>
            <TD>0.823654</TD>
          </TR>
          <TR>
            <TD>16405.000</TD>
            <TD>0.822327</TD>
          </TR>
          <TR>
            <TD>16410.000</TD>
            <TD>0.820953</TD>
          </TR>
          <TR>
            <TD>16415.000</TD>
            <TD>0.820358</TD>
          </TR>
          <TR>
            <TD>16420.000</TD>
            <TD>0.819824</TD>
          </TR>
          <TR>
            <TD>16425.000</TD>
            <TD>0.819672</TD>
          </TR>
          <TR>
            <TD>16430.000</TD>
            <TD>0.819748</TD>
          </TR>
          <TR>
            <TD>16435.000</TD>
            <TD>0.819489</TD>
          </TR>
          <TR>
            <TD>16440.000</TD>
            <TD>0.818893</TD>
          </TR>
          <TR>
            <TD>16445.000</TD>
            <TD>0.818436</TD>
          </TR>
          <TR>
            <TD>16450.000</TD>
            <TD>0.818055</TD>
          </TR>
          <TR>
            <TD>16455.000</TD>
            <TD>0.818299</TD>
          </TR>
          <TR>
            <TD>16460.000</TD>
            <TD>0.818741</TD>
          </TR>
          <TR>
            <TD>16465.000</TD>
            <TD>0.819214</TD>
          </TR>
          <TR>
            <TD>16470.000</TD>
            <TD>0.820176</TD>
          </TR>
          <TR>
            <TD>16475.000</TD>
            <TD>0.819916</TD>
          </TR>
          <TR>
            <TD>16480.000</TD>
            <TD>0.820435</TD>
          </TR>
          <TR>
            <TD>16485.000</TD>
            <TD>0.821</TD>
          </TR>
          <TR>
            <TD>16490.000</TD>
            <TD>0.821198</TD>
          </TR>
          <TR>
            <TD>16495.000</TD>
            <TD>0.821869</TD>
          </TR>
          <TR>
            <TD>16500.000</TD>
            <TD>0.82222</TD>
          </TR>
          <TR>
            <TD>16505.000</TD>
            <TD>0.822632</TD>
          </TR>
          <TR>
            <TD>16510.000</TD>
            <TD>0.823532</TD>
          </TR>
          <TR>
            <TD>16515.000</TD>
            <TD>0.824692</TD>
          </TR>
          <TR>
            <TD>16520.000</TD>
            <TD>0.826111</TD>
          </TR>
          <TR>
            <TD>16525.000</TD>
            <TD>0.827118</TD>
          </TR>
          <TR>
            <TD>16530.000</TD>
            <TD>0.828537</TD>
          </TR>
          <TR>
            <TD>16535.000</TD>
            <TD>0.830246</TD>
          </TR>
          <TR>
            <TD>16540.000</TD>
            <TD>0.832016</TD>
          </TR>
          <TR>
            <TD>16545.000</TD>
            <TD>0.83432</TD>
          </TR>
          <TR>
            <TD>16550.000</TD>
            <TD>0.836304</TD>
          </TR>
          <TR>
            <TD>16555.000</TD>
            <TD>0.837311</TD>
          </TR>
          <TR>
            <TD>16560.000</TD>
            <TD>0.838074</TD>
          </TR>
          <TR>
            <TD>16565.000</TD>
            <TD>0.839279</TD>
          </TR>
          <TR>
            <TD>16570.000</TD>
            <TD>0.839767</TD>
          </TR>
          <TR>
            <TD>16575.000</TD>
            <TD>0.840836</TD>
          </TR>
          <TR>
            <TD>16580.000</TD>
            <TD>0.842438</TD>
          </TR>
          <TR>
            <TD>16585.000</TD>
            <TD>0.843582</TD>
          </TR>
          <TR>
            <TD>16590.000</TD>
            <TD>0.84584</TD>
          </TR>
          <TR>
            <TD>16595.000</TD>
            <TD>0.847977</TD>
          </TR>
          <TR>
            <TD>16600.000</TD>
            <TD>0.849747</TD>
          </TR>
          <TR>
            <TD>16605.000</TD>
            <TD>0.851456</TD>
          </TR>
          <TR>
            <TD>16610.000</TD>
            <TD>0.853103</TD>
          </TR>
          <TR>
            <TD>16615.000</TD>
            <TD>0.85469</TD>
          </TR>
          <TR>
            <TD>16620.000</TD>
            <TD>0.855789</TD>
          </TR>
          <TR>
            <TD>16625.000</TD>
            <TD>0.857269</TD>
          </TR>
          <TR>
            <TD>16630.000</TD>
            <TD>0.858063</TD>
          </TR>
          <TR>
            <TD>16635.000</TD>
            <TD>0.859314</TD>
          </TR>
          <TR>
            <TD>16640.000</TD>
            <TD>0.861114</TD>
          </TR>
          <TR>
            <TD>16645.000</TD>
            <TD>0.862167</TD>
          </TR>
          <TR>
            <TD>16650.000</TD>
            <TD>0.863342</TD>
          </TR>
          <TR>
            <TD>16655.000</TD>
            <TD>0.864044</TD>
          </TR>
          <TR>
            <TD>16660.000</TD>
            <TD>0.865112</TD>
          </TR>
          <TR>
            <TD>16665.000</TD>
            <TD>0.866318</TD>
          </TR>
          <TR>
            <TD>16670.000</TD>
            <TD>0.867691</TD>
          </TR>
          <TR>
            <TD>16675.000</TD>
            <TD>0.86908</TD>
          </TR>
          <TR>
            <TD>16680.000</TD>
            <TD>0.870132</TD>
          </TR>
          <TR>
            <TD>16685.000</TD>
            <TD>0.870316</TD>
          </TR>
          <TR>
            <TD>16690.000</TD>
            <TD>0.871368</TD>
          </TR>
          <TR>
            <TD>16695.000</TD>
            <TD>0.872757</TD>
          </TR>
          <TR>
            <TD>16700.000</TD>
            <TD>0.87352</TD>
          </TR>
          <TR>
            <TD>16705.000</TD>
            <TD>0.875092</TD>
          </TR>
          <TR>
            <TD>16710.000</TD>
            <TD>0.875824</TD>
          </TR>
          <TR>
            <TD>16715.000</TD>
            <TD>0.875534</TD>
          </TR>
          <TR>
            <TD>16720.000</TD>
            <TD>0.876282</TD>
          </TR>
          <TR>
            <TD>16725.000</TD>
            <TD>0.876755</TD>
          </TR>
          <TR>
            <TD>16730.000</TD>
            <TD>0.87677</TD>
          </TR>
          <TR>
            <TD>16735.000</TD>
            <TD>0.878204</TD>
          </TR>
          <TR>
            <TD>16740.000</TD>
            <TD>0.878326</TD>
          </TR>
          <TR>
            <TD>16745.000</TD>
            <TD>0.878677</TD>
          </TR>
          <TR>
            <TD>16750.000</TD>
            <TD>0.879059</TD>
          </TR>
          <TR>
            <TD>16755.000</TD>
            <TD>0.878571</TD>
          </TR>
          <TR>
            <TD>16760.000</TD>
            <TD>0.879105</TD>
          </TR>
          <TR>
            <TD>16765.000</TD>
            <TD>0.878601</TD>
          </TR>
          <TR>
            <TD>16770.000</TD>
            <TD>0.878189</TD>
          </TR>
          <TR>
            <TD>16775.000</TD>
            <TD>0.877975</TD>
          </TR>
          <TR>
            <TD>16780.000</TD>
            <TD>0.876831</TD>
          </TR>
          <TR>
            <TD>16785.000</TD>
            <TD>0.876831</TD>
          </TR>
          <TR>
            <TD>16790.000</TD>
            <TD>0.876755</TD>
          </TR>
          <TR>
            <TD>16795.000</TD>
            <TD>0.87616</TD>
          </TR>
          <TR>
            <TD>16800.000</TD>
            <TD>0.875946</TD>
          </TR>
          <TR>
            <TD>16805.000</TD>
            <TD>0.875946</TD>
          </TR>
          <TR>
            <TD>16810.000</TD>
            <TD>0.875641</TD>
          </TR>
          <TR>
            <TD>16815.000</TD>
            <TD>0.875427</TD>
          </TR>
          <TR>
            <TD>16820.000</TD>
            <TD>0.875122</TD>
          </TR>
          <TR>
            <TD>16825.000</TD>
            <TD>0.874084</TD>
          </TR>
          <TR>
            <TD>16830.000</TD>
            <TD>0.872909</TD>
          </TR>
          <TR>
            <TD>16835.000</TD>
            <TD>0.872223</TD>
          </TR>
          <TR>
            <TD>16840.000</TD>
            <TD>0.871399</TD>
          </TR>
          <TR>
            <TD>16845.000</TD>
            <TD>0.870636</TD>
          </TR>
          <TR>
            <TD>16850.000</TD>
            <TD>0.870819</TD>
          </TR>
          <TR>
            <TD>16855.000</TD>
            <TD>0.87056</TD>
          </TR>
          <TR>
            <TD>16860.000</TD>
            <TD>0.8703</TD>
          </TR>
          <TR>
            <TD>16865.000</TD>
            <TD>0.870026</TD>
          </TR>
          <TR>
            <TD>16870.000</TD>
            <TD>0.869492</TD>
          </TR>
          <TR>
            <TD>16875.000</TD>
            <TD>0.8685</TD>
          </TR>
          <TR>
            <TD>16880.000</TD>
            <TD>0.867676</TD>
          </TR>
          <TR>
            <TD>16885.000</TD>
            <TD>0.867233</TD>
          </TR>
          <TR>
            <TD>16890.000</TD>
            <TD>0.866333</TD>
          </TR>
          <TR>
            <TD>16895.000</TD>
            <TD>0.865601</TD>
          </TR>
          <TR>
            <TD>16900.000</TD>
            <TD>0.865402</TD>
          </TR>
          <TR>
            <TD>16905.000</TD>
            <TD>0.865265</TD>
          </TR>
          <TR>
            <TD>16910.000</TD>
            <TD>0.865311</TD>
          </TR>
          <TR>
            <TD>16914.000</TD>
            <TD>0.866348</TD>
          </TR>
          <TR>
            <TD>16919.000</TD>
            <TD>0.866135</TD>
          </TR>
          <TR>
            <TD>16924.000</TD>
            <TD>0.866241</TD>
          </TR>
          <TR>
            <TD>16929.000</TD>
            <TD>0.86644</TD>
          </TR>
          <TR>
            <TD>16934.000</TD>
            <TD>0.865585</TD>
          </TR>
          <TR>
            <TD>16939.000</TD>
            <TD>0.865494</TD>
          </TR>
          <TR>
            <TD>16944.000</TD>
            <TD>0.864639</TD>
          </TR>
          <TR>
            <TD>16949.000</TD>
            <TD>0.863602</TD>
          </TR>
          <TR>
            <TD>16954.000</TD>
            <TD>0.863022</TD>
          </TR>
          <TR>
            <TD>16959.000</TD>
            <TD>0.863098</TD>
          </TR>
          <TR>
            <TD>16964.000</TD>
            <TD>0.863419</TD>
          </TR>
          <TR>
            <TD>16969.000</TD>
            <TD>0.863968</TD>
          </TR>
          <TR>
            <TD>16974.000</TD>
            <TD>0.86438</TD>
          </TR>
          <TR>
            <TD>16979.000</TD>
            <TD>0.864456</TD>
          </TR>
          <TR>
            <TD>16984.000</TD>
            <TD>0.86438</TD>
          </TR>
          <TR>
            <TD>16989.000</TD>
            <TD>0.864746</TD>
          </TR>
          <TR>
            <TD>16994.000</TD>
            <TD>0.865326</TD>
          </TR>
          <TR>
            <TD>16999.000</TD>
            <TD>0.866089</TD>
          </TR>
          <TR>
            <TD>17004.000</TD>
            <TD>0.866638</TD>
          </TR>
          <TR>
            <TD>17009.000</TD>
            <TD>0.867386</TD>
          </TR>
          <TR>
            <TD>17014.000</TD>
            <TD>0.86763</TD>
          </TR>
          <TR>
            <TD>17019.000</TD>
            <TD>0.867447</TD>
          </TR>
          <TR>
            <TD>17024.000</TD>
            <TD>0.868179</TD>
          </TR>
          <TR>
            <TD>17029.000</TD>
            <TD>0.868668</TD>
          </TR>
          <TR>
            <TD>17034.000</TD>
            <TD>0.868835</TD>
          </TR>
          <TR>
            <TD>17039.000</TD>
            <TD>0.869461</TD>
          </TR>
          <TR>
            <TD>17044.000</TD>
            <TD>0.869613</TD>
          </TR>
          <TR>
            <TD>17049.000</TD>
            <TD>0.869263</TD>
          </TR>
          <TR>
            <TD>17054.000</TD>
            <TD>0.869766</TD>
          </TR>
          <TR>
            <TD>17059.000</TD>
            <TD>0.869949</TD>
          </TR>
          <TR>
            <TD>17064.000</TD>
            <TD>0.869217</TD>
          </TR>
          <TR>
            <TD>17069.000</TD>
            <TD>0.86853</TD>
          </TR>
          <TR>
            <TD>17074.000</TD>
            <TD>0.868133</TD>
          </TR>
          <TR>
            <TD>17079.000</TD>
            <TD>0.867996</TD>
          </TR>
          <TR>
            <TD>17084.000</TD>
            <TD>0.868805</TD>
          </TR>
          <TR>
            <TD>17089.000</TD>
            <TD>0.869736</TD>
          </TR>
          <TR>
            <TD>17094.000</TD>
            <TD>0.870682</TD>
          </TR>
          <TR>
            <TD>17099.000</TD>
            <TD>0.870972</TD>
          </TR>
          <TR>
            <TD>17104.000</TD>
            <TD>0.870514</TD>
          </TR>
          <TR>
            <TD>17109.000</TD>
            <TD>0.870224</TD>
          </TR>
          <TR>
            <TD>17114.000</TD>
            <TD>0.868851</TD>
          </TR>
          <TR>
            <TD>17119.000</TD>
            <TD>0.867248</TD>
          </TR>
          <TR>
            <TD>17124.000</TD>
            <TD>0.866775</TD>
          </TR>
          <TR>
            <TD>17129.000</TD>
            <TD>0.865372</TD>
          </TR>
          <TR>
            <TD>17134.000</TD>
            <TD>0.864258</TD>
          </TR>
          <TR>
            <TD>17139.000</TD>
            <TD>0.863571</TD>
          </TR>
          <TR>
            <TD>17144.000</TD>
            <TD>0.862137</TD>
          </TR>
          <TR>
            <TD>17149.000</TD>
            <TD>0.861313</TD>
          </TR>
          <TR>
            <TD>17154.000</TD>
            <TD>0.861038</TD>
          </TR>
          <TR>
            <TD>17159.000</TD>
            <TD>0.860367</TD>
          </TR>
          <TR>
            <TD>17164.000</TD>
            <TD>0.85965</TD>
          </TR>
          <TR>
            <TD>17169.000</TD>
            <TD>0.858673</TD>
          </TR>
          <TR>
            <TD>17174.000</TD>
            <TD>0.85788</TD>
          </TR>
          <TR>
            <TD>17179.000</TD>
            <TD>0.856537</TD>
          </TR>
          <TR>
            <TD>17184.000</TD>
            <TD>0.855148</TD>
          </TR>
          <TR>
            <TD>17189.000</TD>
            <TD>0.853866</TD>
          </TR>
          <TR>
            <TD>17194.000</TD>
            <TD>0.851425</TD>
          </TR>
          <TR>
            <TD>17199.000</TD>
            <TD>0.849975</TD>
          </TR>
          <TR>
            <TD>17204.000</TD>
            <TD>0.848251</TD>
          </TR>
          <TR>
            <TD>17209.000</TD>
            <TD>0.846435</TD>
          </TR>
          <TR>
            <TD>17214.000</TD>
            <TD>0.844925</TD>
          </TR>
          <TR>
            <TD>17219.000</TD>
            <TD>0.84317</TD>
          </TR>
          <TR>
            <TD>17224.000</TD>
            <TD>0.841217</TD>
          </TR>
          <TR>
            <TD>17229.000</TD>
            <TD>0.838516</TD>
          </TR>
          <TR>
            <TD>17234.000</TD>
            <TD>0.835831</TD>
          </TR>
          <TR>
            <TD>17239.000</TD>
            <TD>0.832855</TD>
          </TR>
          <TR>
            <TD>17244.000</TD>
            <TD>0.829986</TD>
          </TR>
          <TR>
            <TD>17249.000</TD>
            <TD>0.828461</TD>
          </TR>
          <TR>
            <TD>17254.000</TD>
            <TD>0.826309</TD>
          </TR>
          <TR>
            <TD>17259.000</TD>
            <TD>0.824051</TD>
          </TR>
          <TR>
            <TD>17264.000</TD>
            <TD>0.822876</TD>
          </TR>
          <TR>
            <TD>17269.000</TD>
            <TD>0.820373</TD>
          </TR>
          <TR>
            <TD>17274.000</TD>
            <TD>0.818893</TD>
          </TR>
          <TR>
            <TD>17279.000</TD>
            <TD>0.81752</TD>
          </TR>
          <TR>
            <TD>17284.000</TD>
            <TD>0.815079</TD>
          </TR>
          <TR>
            <TD>17289.000</TD>
            <TD>0.813309</TD>
          </TR>
          <TR>
            <TD>17294.000</TD>
            <TD>0.810898</TD>
          </TR>
          <TR>
            <TD>17299.000</TD>
            <TD>0.809097</TD>
          </TR>
          <TR>
            <TD>17304.000</TD>
            <TD>0.80751</TD>
          </TR>
          <TR>
            <TD>17309.000</TD>
            <TD>0.80571</TD>
          </TR>
          <TR>
            <TD>17314.000</TD>
            <TD>0.804626</TD>
          </TR>
          <TR>
            <TD>17319.000</TD>
            <TD>0.803222</TD>
          </TR>
          <TR>
            <TD>17324.000</TD>
            <TD>0.801926</TD>
          </TR>
          <TR>
            <TD>17329.000</TD>
            <TD>0.801117</TD>
          </TR>
          <TR>
            <TD>17334.000</TD>
            <TD>0.799911</TD>
          </TR>
          <TR>
            <TD>17339.000</TD>
            <TD>0.797989</TD>
          </TR>
          <TR>
            <TD>17344.000</TD>
            <TD>0.79631</TD>
          </TR>
          <TR>
            <TD>17349.000</TD>
            <TD>0.794815</TD>
          </TR>
          <TR>
            <TD>17354.000</TD>
            <TD>0.79306</TD>
          </TR>
          <TR>
            <TD>17359.000</TD>
            <TD>0.792282</TD>
          </TR>
          <TR>
            <TD>17364.000</TD>
            <TD>0.792435</TD>
          </TR>
          <TR>
            <TD>17369.000</TD>
            <TD>0.791855</TD>
          </TR>
          <TR>
            <TD>17374.000</TD>
            <TD>0.792236</TD>
          </TR>
          <TR>
            <TD>17379.000</TD>
            <TD>0.792465</TD>
          </TR>
          <TR>
            <TD>17384.000</TD>
            <TD>0.791245</TD>
          </TR>
          <TR>
            <TD>17389.000</TD>
            <TD>0.791184</TD>
          </TR>
          <TR>
            <TD>17394.000</TD>
            <TD>0.791031</TD>
          </TR>
          <TR>
            <TD>17399.000</TD>
            <TD>0.791031</TD>
          </TR>
          <TR>
            <TD>17404.000</TD>
            <TD>0.79158</TD>
          </TR>
          <TR>
            <TD>17409.000</TD>
            <TD>0.791352</TD>
          </TR>
          <TR>
            <TD>17414.000</TD>
            <TD>0.791352</TD>
          </TR>
          <TR>
            <TD>17419.000</TD>
            <TD>0.791077</TD>
          </TR>
          <TR>
            <TD>17424.000</TD>
            <TD>0.791382</TD>
          </TR>
          <TR>
            <TD>17429.000</TD>
            <TD>0.792557</TD>
          </TR>
          <TR>
            <TD>17434.000</TD>
            <TD>0.79332</TD>
          </TR>
          <TR>
            <TD>17439.000</TD>
            <TD>0.794495</TD>
          </TR>
          <TR>
            <TD>17444.000</TD>
            <TD>0.796097</TD>
          </TR>
          <TR>
            <TD>17449.000</TD>
            <TD>0.796631</TD>
          </TR>
          <TR>
            <TD>17454.000</TD>
            <TD>0.798431</TD>
          </TR>
          <TR>
            <TD>17459.000</TD>
            <TD>0.800537</TD>
          </TR>
          <TR>
            <TD>17464.000</TD>
            <TD>0.801376</TD>
          </TR>
          <TR>
            <TD>17469.000</TD>
            <TD>0.802826</TD>
          </TR>
          <TR>
            <TD>17473.000</TD>
            <TD>0.803727</TD>
          </TR>
          <TR>
            <TD>17478.000</TD>
            <TD>0.804123</TD>
          </TR>
          <TR>
            <TD>17483.000</TD>
            <TD>0.804779</TD>
          </TR>
          <TR>
            <TD>17488.000</TD>
            <TD>0.806</TD>
          </TR>
          <TR>
            <TD>17493.000</TD>
            <TD>0.807129</TD>
          </TR>
          <TR>
            <TD>17498.000</TD>
            <TD>0.808365</TD>
          </TR>
          <TR>
            <TD>17503.000</TD>
            <TD>0.810242</TD>
          </TR>
          <TR>
            <TD>17508.000</TD>
            <TD>0.811722</TD>
          </TR>
          <TR>
            <TD>17513.000</TD>
            <TD>0.812836</TD>
          </TR>
          <TR>
            <TD>17518.000</TD>
            <TD>0.814484</TD>
          </TR>
          <TR>
            <TD>17523.000</TD>
            <TD>0.816025</TD>
          </TR>
          <TR>
            <TD>17528.000</TD>
            <TD>0.817185</TD>
          </TR>
          <TR>
            <TD>17533.000</TD>
            <TD>0.818176</TD>
          </TR>
          <TR>
            <TD>17538.000</TD>
            <TD>0.818863</TD>
          </TR>
          <TR>
            <TD>17543.000</TD>
            <TD>0.818695</TD>
          </TR>
          <TR>
            <TD>17548.000</TD>
            <TD>0.818802</TD>
          </TR>
          <TR>
            <TD>17553.000</TD>
            <TD>0.819031</TD>
          </TR>
          <TR>
            <TD>17558.000</TD>
            <TD>0.819229</TD>
          </TR>
          <TR>
            <TD>17563.000</TD>
            <TD>0.819748</TD>
          </TR>
          <TR>
            <TD>17568.000</TD>
            <TD>0.820404</TD>
          </TR>
          <TR>
            <TD>17573.000</TD>
            <TD>0.820785</TD>
          </TR>
          <TR>
            <TD>17578.000</TD>
            <TD>0.820648</TD>
          </TR>
          <TR>
            <TD>17583.000</TD>
            <TD>0.820709</TD>
          </TR>
          <TR>
            <TD>17588.000</TD>
            <TD>0.819977</TD>
          </TR>
          <TR>
            <TD>17593.000</TD>
            <TD>0.818847</TD>
          </TR>
          <TR>
            <TD>17598.000</TD>
            <TD>0.817749</TD>
          </TR>
          <TR>
            <TD>17603.000</TD>
            <TD>0.816254</TD>
          </TR>
          <TR>
            <TD>17608.000</TD>
            <TD>0.81488</TD>
          </TR>
          <TR>
            <TD>17613.000</TD>
            <TD>0.813797</TD>
          </TR>
          <TR>
            <TD>17618.000</TD>
            <TD>0.812408</TD>
          </TR>
          <TR>
            <TD>17623.000</TD>
            <TD>0.810653</TD>
          </TR>
          <TR>
            <TD>17628.000</TD>
            <TD>0.808471</TD>
          </TR>
          <TR>
            <TD>17633.000</TD>
            <TD>0.805588</TD>
          </TR>
          <TR>
            <TD>17638.000</TD>
            <TD>0.802887</TD>
          </TR>
          <TR>
            <TD>17643.000</TD>
            <TD>0.798981</TD>
          </TR>
          <TR>
            <TD>17648.000</TD>
            <TD>0.794784</TD>
          </TR>
          <TR>
            <TD>17653.000</TD>
            <TD>0.789978</TD>
          </TR>
          <TR>
            <TD>17658.000</TD>
            <TD>0.783707</TD>
          </TR>
          <TR>
            <TD>17663.000</TD>
            <TD>0.778274</TD>
          </TR>
          <TR>
            <TD>17668.000</TD>
            <TD>0.772278</TD>
          </TR>
          <TR>
            <TD>17673.000</TD>
            <TD>0.765259</TD>
          </TR>
          <TR>
            <TD>17678.000</TD>
            <TD>0.75943</TD>
          </TR>
          <TR>
            <TD>17683.000</TD>
            <TD>0.752518</TD>
          </TR>
          <TR>
            <TD>17688.000</TD>
            <TD>0.745102</TD>
          </TR>
          <TR>
            <TD>17693.000</TD>
            <TD>0.742355</TD>
          </TR>
          <TR>
            <TD>17698.000</TD>
            <TD>0.73703</TD>
          </TR>
          <TR>
            <TD>17703.000</TD>
            <TD>0.732208</TD>
          </TR>
          <TR>
            <TD>17708.000</TD>
            <TD>0.725861</TD>
          </TR>
          <TR>
            <TD>17713.000</TD>
            <TD>0.715118</TD>
          </TR>
          <TR>
            <TD>17718.000</TD>
            <TD>0.705154</TD>
          </TR>
          <TR>
            <TD>17723.000</TD>
            <TD>0.693283</TD>
          </TR>
          <TR>
            <TD>17728.000</TD>
            <TD>0.681686</TD>
          </TR>
          <TR>
            <TD>17733.000</TD>
            <TD>0.668655</TD>
          </TR>
          <TR>
            <TD>17738.000</TD>
            <TD>0.653717</TD>
          </TR>
          <TR>
            <TD>17743.000</TD>
            <TD>0.640243</TD>
          </TR>
          <TR>
            <TD>17748.000</TD>
            <TD>0.624588</TD>
          </TR>
          <TR>
            <TD>17753.000</TD>
            <TD>0.608932</TD>
          </TR>
          <TR>
            <TD>17758.000</TD>
            <TD>0.59317</TD>
          </TR>
          <TR>
            <TD>17763.000</TD>
            <TD>0.574661</TD>
          </TR>
          <TR>
            <TD>17768.000</TD>
            <TD>0.556839</TD>
          </TR>
          <TR>
            <TD>17773.000</TD>
            <TD>0.538925</TD>
          </TR>
          <TR>
            <TD>17778.000</TD>
            <TD>0.51947</TD>
          </TR>
          <TR>
            <TD>17783.000</TD>
            <TD>0.501144</TD>
          </TR>
          <TR>
            <TD>17788.000</TD>
            <TD>0.482712</TD>
          </TR>
          <TR>
            <TD>17793.000</TD>
            <TD>0.463943</TD>
          </TR>
          <TR>
            <TD>17798.000</TD>
            <TD>0.445129</TD>
          </TR>
          <TR>
            <TD>17803.000</TD>
            <TD>0.42575</TD>
          </TR>
          <TR>
            <TD>17808.000</TD>
            <TD>0.40538</TD>
          </TR>
          <TR>
            <TD>17813.000</TD>
            <TD>0.385147</TD>
          </TR>
          <TR>
            <TD>17818.000</TD>
            <TD>0.365371</TD>
          </TR>
          <TR>
            <TD>17823.000</TD>
            <TD>0.346115</TD>
          </TR>
          <TR>
            <TD>17828.000</TD>
            <TD>0.326904</TD>
          </TR>
          <TR>
            <TD>17833.000</TD>
            <TD>0.308395</TD>
          </TR>
          <TR>
            <TD>17838.000</TD>
            <TD>0.29097</TD>
          </TR>
          <TR>
            <TD>17843.000</TD>
            <TD>0.274032</TD>
          </TR>
          <TR>
            <TD>17848.000</TD>
            <TD>0.258316</TD>
          </TR>
          <TR>
            <TD>17853.000</TD>
            <TD>0.242553</TD>
          </TR>
          <TR>
            <TD>17858.000</TD>
            <TD>0.226898</TD>
          </TR>
          <TR>
            <TD>17863.000</TD>
            <TD>0.211852</TD>
          </TR>
          <TR>
            <TD>17868.000</TD>
            <TD>0.197631</TD>
          </TR>
          <TR>
            <TD>17873.000</TD>
            <TD>0.184326</TD>
          </TR>
          <TR>
            <TD>17878.000</TD>
            <TD>0.172195</TD>
          </TR>
          <TR>
            <TD>17883.000</TD>
            <TD>0.160415</TD>
          </TR>
          <TR>
            <TD>17888.000</TD>
            <TD>0.150879</TD>
          </TR>
          <TR>
            <TD>17893.000</TD>
            <TD>0.140533</TD>
          </TR>
          <TR>
            <TD>17898.000</TD>
            <TD>0.131729</TD>
          </TR>
          <TR>
            <TD>17903.000</TD>
            <TD>0.123016</TD>
          </TR>
          <TR>
            <TD>17908.000</TD>
            <TD>0.113678</TD>
          </TR>
          <TR>
            <TD>17913.000</TD>
            <TD>0.106125</TD>
          </TR>
          <TR>
            <TD>17918.000</TD>
            <TD>0.0985711</TD>
          </TR>
          <TR>
            <TD>17923.000</TD>
            <TD>0.0912012</TD>
          </TR>
          <TR>
            <TD>17928.000</TD>
            <TD>0.0850672</TD>
          </TR>
          <TR>
            <TD>17933.000</TD>
            <TD>0.0788111</TD>
          </TR>
          <TR>
            <TD>17938.000</TD>
            <TD>0.073318</TD>
          </TR>
          <TR>
            <TD>17943.000</TD>
            <TD>0.0684658</TD>
          </TR>
          <TR>
            <TD>17948.000</TD>
            <TD>0.0637356</TD>
          </TR>
          <TR>
            <TD>17953.000</TD>
            <TD>0.0593259</TD>
          </TR>
          <TR>
            <TD>17958.000</TD>
            <TD>0.0551756</TD>
          </TR>
          <TR>
            <TD>17963.000</TD>
            <TD>0.0512999</TD>
          </TR>
          <TR>
            <TD>17968.000</TD>
            <TD>0.0476989</TD>
          </TR>
          <TR>
            <TD>17973.000</TD>
            <TD>0.0444641</TD>
          </TR>
          <TR>
            <TD>17978.000</TD>
            <TD>0.0412903</TD>
          </TR>
          <TR>
            <TD>17983.000</TD>
            <TD>0.0385582</TD>
          </TR>
          <TR>
            <TD>17988.000</TD>
            <TD>0.0357964</TD>
          </TR>
          <TR>
            <TD>17993.000</TD>
            <TD>0.0334466</TD>
          </TR>
          <TR>
            <TD>17998.000</TD>
            <TD>0.0311273</TD>
          </TR>
          <TR>
            <TD>18003.000</TD>
            <TD>0.0289606</TD>
          </TR>
          <TR>
            <TD>18008.000</TD>
            <TD>0.0271143</TD>
          </TR>
          <TR>
            <TD>18013.000</TD>
            <TD>0.0252375</TD>
          </TR>
          <TR>
            <TD>18018.000</TD>
            <TD>0.0236354</TD>
          </TR>
          <TR>
            <TD>18023.000</TD>
            <TD>0.0221401</TD>
          </TR>
          <TR>
            <TD>18027.000</TD>
            <TD>0.020538</TD>
          </TR>
          <TR>
            <TD>18032.000</TD>
            <TD>0.0191648</TD>
          </TR>
          <TR>
            <TD>18037.000</TD>
            <TD>0.0178984</TD>
          </TR>
          <TR>
            <TD>18042.000</TD>
            <TD>0.0167693</TD>
          </TR>
          <TR>
            <TD>18047.000</TD>
            <TD>0.0157616</TD>
          </TR>
          <TR>
            <TD>18052.000</TD>
            <TD>0.0148309</TD>
          </TR>
          <TR>
            <TD>18057.000</TD>
            <TD>0.0139307</TD>
          </TR>
          <TR>
            <TD>18062.000</TD>
            <TD>0.0130152</TD>
          </TR>
          <TR>
            <TD>18067.000</TD>
            <TD>0.0122828</TD>
          </TR>
          <TR>
            <TD>18072.000</TD>
            <TD>0.0114436</TD>
          </TR>
          <TR>
            <TD>18077.000</TD>
            <TD>0.010696</TD>
          </TR>
          <TR>
            <TD>18082.000</TD>
            <TD>0.0101162</TD>
          </TR>
          <TR>
            <TD>18087.000</TD>
            <TD>0.0094754</TD>
          </TR>
          <TR>
            <TD>18092.000</TD>
            <TD>0.0089109</TD>
          </TR>
          <TR>
            <TD>18097.000</TD>
            <TD>0.0084684</TD>
          </TR>
          <TR>
            <TD>18102.000</TD>
            <TD>0.0079039</TD>
          </TR>
          <TR>
            <TD>18107.000</TD>
            <TD>0.0074767</TD>
          </TR>
          <TR>
            <TD>18112.000</TD>
            <TD>0.0071563</TD>
          </TR>
          <TR>
            <TD>18117.000</TD>
            <TD>0.0066375</TD>
          </TR>
          <TR>
            <TD>18122.000</TD>
            <TD>0.0062408</TD>
          </TR>
          <TR>
            <TD>18127.000</TD>
            <TD>0.0058129</TD>
          </TR>
          <TR>
            <TD>18132.000</TD>
            <TD>0.0054773</TD>
          </TR>
          <TR>
            <TD>18137.000</TD>
            <TD>0.0051569</TD>
          </TR>
          <TR>
            <TD>18142.000</TD>
            <TD>0.0049891</TD>
          </TR>
          <TR>
            <TD>18147.000</TD>
            <TD>0.0047145</TD>
          </TR>
          <TR>
            <TD>18152.000</TD>
            <TD>0.0044551</TD>
          </TR>
          <TR>
            <TD>18157.000</TD>
            <TD>0.0043178</TD>
          </TR>
          <TR>
            <TD>18162.000</TD>
            <TD>0.0040432</TD>
          </TR>
          <TR>
            <TD>18167.000</TD>
            <TD>0.0038601</TD>
          </TR>
          <TR>
            <TD>18172.000</TD>
            <TD>0.0036313</TD>
          </TR>
          <TR>
            <TD>18177.000</TD>
            <TD>0.0033872</TD>
          </TR>
          <TR>
            <TD>18182.000</TD>
            <TD>0.0032499</TD>
          </TR>
          <TR>
            <TD>18187.000</TD>
            <TD>0.0031279</TD>
          </TR>
          <TR>
            <TD>18192.000</TD>
            <TD>0.0030211</TD>
          </TR>
          <TR>
            <TD>18197.000</TD>
            <TD>0.0029906</TD>
          </TR>
          <TR>
            <TD>18202.000</TD>
            <TD>0.0029296</TD>
          </TR>
          <TR>
            <TD>18207.000</TD>
            <TD>0.0027618</TD>
          </TR>
          <TR>
            <TD>18212.000</TD>
            <TD>0.0026087</TD>
          </TR>
          <TR>
            <TD>18217.000</TD>
            <TD>0.0023799</TD>
          </TR>
          <TR>
            <TD>18222.000</TD>
            <TD>0.0022121</TD>
          </TR>
          <TR>
            <TD>18227.000</TD>
            <TD>0.0020748</TD>
          </TR>
          <TR>
            <TD>18232.000</TD>
            <TD>0.0020138</TD>
          </TR>
          <TR>
            <TD>18237.000</TD>
            <TD>0.0018765</TD>
          </TR>
          <TR>
            <TD>18242.000</TD>
            <TD>0.0017392</TD>
          </TR>
          <TR>
            <TD>18247.000</TD>
            <TD>0.0016019</TD>
          </TR>
          <TR>
            <TD>18252.000</TD>
            <TD>0.0015409</TD>
          </TR>
          <TR>
            <TD>18257.000</TD>
            <TD>0.0015409</TD>
          </TR>
          <TR>
            <TD>18262.000</TD>
            <TD>0.0014189</TD>
          </TR>
          <TR>
            <TD>18267.000</TD>
            <TD>0.0013579</TD>
          </TR>
          <TR>
            <TD>18272.000</TD>
            <TD>0.0012817</TD>
          </TR>
          <TR>
            <TD>18277.000</TD>
            <TD>0.0012054</TD>
          </TR>
          <TR>
            <TD>18282.000</TD>
            <TD>0.0012511</TD>
          </TR>
          <TR>
            <TD>18287.000</TD>
            <TD>0.0012511</TD>
          </TR>
          <TR>
            <TD>18292.000</TD>
            <TD>0.0011901</TD>
          </TR>
          <TR>
            <TD>18297.000</TD>
            <TD>0.0011291</TD>
          </TR>
          <TR>
            <TD>18302.000</TD>
            <TD>0.0010071</TD>
          </TR>
          <TR>
            <TD>18307.000</TD>
            <TD>0.0009614</TD>
          </TR>
          <TR>
            <TD>18312.000</TD>
            <TD>0.0009919</TD>
          </TR>
          <TR>
            <TD>18317.000</TD>
            <TD>0.0010071</TD>
          </TR>
          <TR>
            <TD>18322.000</TD>
            <TD>0.0010223</TD>
          </TR>
          <TR>
            <TD>18327.000</TD>
            <TD>0.0010223</TD>
          </TR>
          <TR>
            <TD>18332.000</TD>
            <TD>0.0008698</TD>
          </TR>
          <TR>
            <TD>18337.000</TD>
            <TD>0.0008698</TD>
          </TR>
          <TR>
            <TD>18342.000</TD>
            <TD>0.0007783</TD>
          </TR>
          <TR>
            <TD>18347.000</TD>
            <TD>0.000702</TD>
          </TR>
          <TR>
            <TD>18352.000</TD>
            <TD>0.000702</TD>
          </TR>
          <TR>
            <TD>18357.000</TD>
            <TD>0.0005647</TD>
          </TR>
          <TR>
            <TD>18362.000</TD>
            <TD>0.0004884</TD>
          </TR>
          <TR>
            <TD>18367.000</TD>
            <TD>0.0004884</TD>
          </TR>
          <TR>
            <TD>18372.000</TD>
            <TD>0.0004884</TD>
          </TR>
          <TR>
            <TD>18377.000</TD>
            <TD>0.0004884</TD>
          </TR>
          <TR>
            <TD>18382.000</TD>
            <TD>0.0005494</TD>
          </TR>
          <TR>
            <TD>18387.000</TD>
            <TD>0.0006104</TD>
          </TR>
          <TR>
            <TD>18392.000</TD>
            <TD>0.0005952</TD>
          </TR>
          <TR>
            <TD>18397.000</TD>
            <TD>0.00058</TD>
          </TR>
          <TR>
            <TD>18402.000</TD>
            <TD>0.00058</TD>
          </TR>
          <TR>
            <TD>18407.000</TD>
            <TD>0.0004427</TD>
          </TR>
          <TR>
            <TD>18412.000</TD>
            <TD>0.0003817</TD>
          </TR>
          <TR>
            <TD>18417.000</TD>
            <TD>0.0003969</TD>
          </TR>
          <TR>
            <TD>18422.000</TD>
            <TD>0.0004274</TD>
          </TR>
          <TR>
            <TD>18427.000</TD>
            <TD>0.0005036</TD>
          </TR>
          <TR>
            <TD>18432.000</TD>
            <TD>0.0005951</TD>
          </TR>
          <TR>
            <TD>18437.000</TD>
            <TD>0.0005189</TD>
          </TR>
          <TR>
            <TD>18442.000</TD>
            <TD>0.0004426</TD>
          </TR>
          <TR>
            <TD>18447.000</TD>
            <TD>0.0003511</TD>
          </TR>
          <TR>
            <TD>18452.000</TD>
            <TD>0.0003968</TD>
          </TR>
          <TR>
            <TD>18457.000</TD>
            <TD>0.0005341</TD>
          </TR>
          <TR>
            <TD>18462.000</TD>
            <TD>0.0004578</TD>
          </TR>
          <TR>
            <TD>18467.000</TD>
            <TD>0.000534</TD>
          </TR>
          <TR>
            <TD>18472.000</TD>
            <TD>0.0003967</TD>
          </TR>
          <TR>
            <TD>18477.000</TD>
            <TD>0.0003357</TD>
          </TR>
          <TR>
            <TD>18482.000</TD>
            <TD>0.0003967</TD>
          </TR>
          <TR>
            <TD>18487.000</TD>
            <TD>0.0003357</TD>
          </TR>
          <TR>
            <TD>18492.000</TD>
            <TD>0.0002747</TD>
          </TR>
          <TR>
            <TD>18497.000</TD>
            <TD>0.0002747</TD>
          </TR>
          <TR>
            <TD>18502.000</TD>
            <TD>0.0002747</TD>
          </TR>
          <TR>
            <TD>18507.000</TD>
            <TD>0.0002747</TD>
          </TR>
          <TR>
            <TD>18512.000</TD>
            <TD>0.0003357</TD>
          </TR>
          <TR>
            <TD>18517.000</TD>
            <TD>0.0003357</TD>
          </TR>
          <TR>
            <TD>18522.000</TD>
            <TD>0.0003205</TD>
          </TR>
          <TR>
            <TD>18527.000</TD>
            <TD>0.0003357</TD>
          </TR>
          <TR>
            <TD>18532.000</TD>
            <TD>0.0003357</TD>
          </TR>
          <TR>
            <TD>18537.000</TD>
            <TD>0.0001984</TD>
          </TR>
          <TR>
            <TD>18542.000</TD>
            <TD>0.0001984</TD>
          </TR>
          <TR>
            <TD>18547.000</TD>
            <TD>0.0001374</TD>
          </TR>
          <TR>
            <TD>18552.000</TD>
            <TD>6.12e-05</TD>
          </TR>
          <TR>
            <TD>18557.000</TD>
            <TD>0.0001374</TD>
          </TR>
          <TR>
            <TD>18562.000</TD>
            <TD>0.0001222</TD>
          </TR>
          <TR>
            <TD>18567.000</TD>
            <TD>0.0001984</TD>
          </TR>
          <TR>
            <TD>18572.000</TD>
            <TD>0.0001984</TD>
          </TR>
          <TR>
            <TD>18577.000</TD>
            <TD>0.0002594</TD>
          </TR>
          <TR>
            <TD>18581.000</TD>
            <TD>0.0002594</TD>
          </TR>
          <TR>
            <TD>18586.000</TD>
            <TD>0.0002594</TD>
          </TR>
          <TR>
            <TD>18591.000</TD>
            <TD>0.0003204</TD>
          </TR>
          <TR>
            <TD>18596.000</TD>
            <TD>0.0002594</TD>
          </TR>
          <TR>
            <TD>18601.000</TD>
            <TD>0.0002594</TD>
          </TR>
          <TR>
            <TD>18606.000</TD>
            <TD>0.0003204</TD>
          </TR>
          <TR>
            <TD>18611.000</TD>
            <TD>0.0003966</TD>
          </TR>
          <TR>
            <TD>18616.000</TD>
            <TD>0.0003966</TD>
          </TR>
          <TR>
            <TD>18621.000</TD>
            <TD>0.0004118</TD>
          </TR>
          <TR>
            <TD>18626.000</TD>
            <TD>0.0002745</TD>
          </TR>
          <TR>
            <TD>18631.000</TD>
            <TD>0.0002897</TD>
          </TR>
          <TR>
            <TD>18636.000</TD>
            <TD>0.0002897</TD>
          </TR>
          <TR>
            <TD>18641.000</TD>
            <TD>0.0002287</TD>
          </TR>
          <TR>
            <TD>18646.000</TD>
            <TD>0.0002287</TD>
          </TR>
          <TR>
            <TD>18651.000</TD>
            <TD>7.62e-05</TD>
          </TR>
          <TR>
            <TD>18656.000</TD>
            <TD>0</TD>
          </TR>
        </TABLEDATA>
      </DATA>
    </TABLE>
  </RESOURCE>
</VOTABLE>
