# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tracktrace', 'tracktrace.ocean', 'tracktrace.rail']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4>=4.9.3,<5.0.0',
 'bs4>=0.0.1,<0.0.2',
 'feedparser>=6.0.2,<7.0.0',
 'html5lib>=1.1,<2.0',
 'lxml>=4.6.1,<5.0.0',
 'pandas>=1.1.4,<2.0.0',
 'pendulum>=2.1.2,<3.0.0',
 'requests>=2.24.0,<3.0.0']

setup_kwargs = {
    'name': 'tracktrace',
    'version': '0.0.6',
    'description': 'Track and trace shipping containers across all major steamship lines',
    'long_description': '# tracktrace\n\nTrack shipping containers across all major shipping lines as well as [Class 1 North American railways](https://en.wikipedia.org/wiki/Railroad_classes#Class_I).\n\n:heavy_check_mark: - Supported\n\n:white_check_mark: - Not supported yet\n\n\n### Ocean\n\n\n| Steamship Line   |SCAC | Supported     | Container Tracking Website | iOS App | Android App |\n| -------------    | :---------: | :-------------: | :---------------: | :----: | :---------: |\n| Alianca          | ANRM | :heavy_check_mark: | [Link](https://www.alianca.com.br/alianca/en/alianca/ecommerce_alianca/track_trace_alianca/index.html)  | No | No |\n| APL              | APLU | :heavy_check_mark: | [Link](https://www.apl.com/ebusiness/tracking)  | [Yes](https://apps.apple.com/us/app/apl-shipping/id1316352566?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.apl.mobile)\n| Arkas Container Transport |ARKU | :white_check_mark: | [Link](https://webtracking.arkasline.com.tr/shipmenttracking) | No | No |\n| CMA CGM          | CMDU | :heavy_check_mark: | [Link](https://www.cma-cgm.com/ebusiness/tracking)  | [Yes](https://apps.apple.com/us/app/cma-cgm/id976582997?ign-mpt=uo%3D4) | No | \n| Cosco            | COSU | :white_check_mark: | [Link](https://elines.coscoshipping.com/ebusiness/cargoTracking)  | [Yes](https://apps.apple.com/us/app/cosco-shipping-lines/id998446230?ign-mpt=uo%3D4) | No |\n| Emirates Shipping Line | ESPU |:white_check_mark: | [Link](https://www.emiratesline.com/cargo-tracking/) | [Yes](https://apps.apple.com/us/app/esl-mobile/id1106834658?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.emiratesline.android) |\n| Evergreen        | EGLV |:white_check_mark: | [Link](https://www.shipmentlink.com/servlet/TDB1_CargoTracking.do)  | No | [Yes](https://play.google.com/store/apps/details?id=com.shipmentlink.mobile) |\n| Hamburg SUD      | SUDU | :heavy_check_mark: | [Link](https://www.hamburgsud-line.com/liner/en/liner_services/ecommerce/track_trace/index.html) | No | No |\n| Hapag Lloyd      | HLCU | :heavy_check_mark: | [Link](https://www.hapag-lloyd.com/en/online-business/tracing/tracing-by-container.html)  | [Yes](https://apps.apple.com/us/app/hapag-lloyd/id935668102?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.hlag.fit) |\n| Hyundai Merchant Marine (HMM) |HDMU | :white_check_mark:| [Link](https://www.hmm21.com/cms/business/ebiz/trackTrace/trackTrace/index.jsp) | [Yes](https://apps.apple.com/us/app/hmm-shiptrack/id590402800?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.hmm.mobileapp) |\n| Maersk           | MAEU |:white_check_mark:| [Link](https://www.maersk.com/tracking/)  | [Yes](https://apps.apple.com/us/app/maersk-shipment/id1163233195?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.maersk.trackandtrace.maerskline) | \n| Matson           | MATS   |:white_check_mark:| [Link](https://www.matson.com/shipment-tracking.html) | [Yes](https://apps.apple.com/us/app/track-my-container/id1299640687?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.matson.containertrack) | \n| Mediterranean Shipping Company (MSC) |MSCU |:heavy_check_mark:| [Link](https://www.msc.com/track-a-shipment?agencyPath=mwi) | [Yes](https://apps.apple.com/us/app/mymsc/id1454791941?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.MSC.myMSCApp) |\n| ONE Line         | ONEY |:heavy_check_mark:| [Link](https://ecomm.one-line.com/ecom/CUP_HOM_3301.do)  | No | No |\n| Orient Overseas Container Line (OOCL) | OOLU |:white_check_mark:| [Link](https://www.oocl.com/eng/ourservices/eservices/cargotracking/Pages/cargotracking.aspx) | [Yes](https://apps.apple.com/us/app/oocl-lite/id420862192?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.oocl.oocllite)\n| Pacific International Lines (PIL) | PCIU |:white_check_mark:| [Link](https://www.pilship.com/en--/120.html)| No | No | \n| Wan Hai Lines | WHLC |:white_check_mark:| [Link](https://www.wanhai.com/views/cargoTrack/CargoTrack.xhtml) | [Yes](https://apps.apple.com/us/app/%E8%90%AC%E6%B5%B7%E8%88%AA%E9%81%8B-wan-hai-lines-ltd/id858445572?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.sdt.wanhai) |\n| Yang Ming        |YMLU |:white_check_mark:| [Link](https://www.yangming.com/e-service/Track_Trace/track_trace_cargo_tracking.aspx) | [Yes](https://apps.apple.com/us/app/yang-ming/id573468171?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=tw.com.mobimedia.yangming) |\n| Zim Integrated Shipping Services (ZIM) |ZIMU |:white_check_mark:| [Link](https://www.zim.com/tools/track-a-shipment)| [Yes](https://apps.apple.com/us/app/zim-shipping/id1084970104?ign-mpt=uo%3D4) | [Yes](https://play.google.com/store/apps/details?id=com.zim) |\n\n\n### Rail\n\nRailroads often require an account to track containers. At certain railroads, you also need to be a Notify Party to access tracking information. \n\nFor example, BNSF doesn\'t show any tracking information if your company is not a Notify Party. UP, on the other hand, shows partial tracking information. \n\n\n| Railroad | Supported | Need Account | Need to be a Notify Party |\n| ---- | :--: | :-------: | :---------: |\n| BNSF Railway (BNSF) | :white_check_mark:| Yes | Yes |\n| Canadian National Railway (CN) | :white_check_mark: | Yes | Yes | \n| Canadian Pacific Railway (CPR) | :white_check_mark:| Yes | Yes |\n| CSX Transportation (CSX) | :white_check_mark: | No | No |\n| Ferromex | :white_check_mark: | Yes | Don\'t know |\n| Kansas City Southern Railway (KCS)| :white_check_mark: | Yes | Yes |\n| Norfolk Southern Railway (NS) | :white_check_mark: | Yes | No |\n| Union Pacific Railway (UP) | :white_check_mark: | Yes | No |\n\n\n\n## Installation\n\n\n```sh\npip install tracktrace \n```\n\n## Usage example\n\n\n```python\n>>> from tracktrace import ocean\n>>>\n>>> container = "MEDU3288655"\n>>> scac = "MSCU"\n>>> \n>>> shipment = ocean.container.create(scac=scac, container=container)\n>>>\n>>> shipment.updates\n\n[{\'location\': \'USSTL\',\n  \'vessel\': \'TRUCK\',\n  \'voyage\': \'\',\n  \'movement\': \'Empty container returned\',\n  \'mode\': \'TR\',\n  \'date\': DateTime(2020, 12, 11, 15, 44, 0, tzinfo=Timezone(\'UTC\'))},\n {\'location\': \'USESL\',\n  \'vessel\': \'CSX TRANSPORTATION\',\n  \'voyage\': \'\',\n  \'movement\': \'Rail last free day\',\n  \'mode\': \'\',\n  \'date\': DateTime(2020, 12, 8, 23, 59, 0, tzinfo=Timezone(\'UTC\'))},\n {\'location\': \'USSTL\',\n  \'vessel\': \'TRUCK\',\n  \'voyage\': \'\',\n  \'movement\': \'Full import container out gated\',\n  \'mode\': \'TR\',\n  \'date\': DateTime(2020, 12, 8, 19, 27, 0, tzinfo=Timezone(\'UTC\'))},\n {\'location\': \'USESL\',\n  \'vessel\': \'CSX TRANSPORTATION\',\n  \'voyage\': \'\',\n  \'movement\': \'Notified\',\n  \'mode\': \'\',\n  ...\n  ...\n  ...\n  ...\n\n```\n\n\n## Release History\n\n* 0.0.5\n    * Work in progress\n\n## Meta\n\nDhruv Kar – [dhruvkar](https://twitter.com/dhruvkar) – dhruv@wints.org\n\nDistributed under the MIT license. See ``LICENSE`` for more information.\n\n[https://github.com/dhruvkar/](https://github.com/dhruvkar/)\n\n## Contributing\n\n1. Fork it (<https://github.com/dhruvkar/tracktrace/fork>)\n2. Create your feature branch (`git checkout -b feature/fooBar`)\n3. Commit your changes (`git commit -am \'Add some fooBar\'`)\n4. Push to the branch (`git push origin feature/fooBar`)\n5. Create a new Pull Request\n\n',
    'author': 'Dhruv Kar',
    'author_email': 'dhruv@wints.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dhruvkar/tracktrace',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
