"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RollbackEvent = exports.EcsDeploymentGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_codedeploy_1 = require("@aws-cdk/aws-codedeploy");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const ecs_deployment_config_1 = require("./ecs-deployment-config");
class EcsDeploymentGroup extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.tags = new core_1.TagManager(core_1.TagType.KEY_VALUE, 'TagManager');
        const { applicationName, deploymentGroupName, deploymentConfig, ecsServices, targetGroups, prodTrafficListener, testTrafficListener, terminationWaitTime = core_1.Duration.minutes(60), autoRollbackOnEvents, } = props;
        if (terminationWaitTime.toMinutes() > 2880) {
            throw new Error('Invalid TerminationWaitTimeInMinutes: The maximum setting is 2880 minutes (2 days).');
        }
        const codeDeployEcsRole = new aws_iam_1.Role(this, 'Role', {
            assumedBy: new aws_iam_1.ServicePrincipal('codedeploy.amazonaws.com'),
            managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AWSCodeDeployRoleForECS')],
        });
        this.application = new aws_codedeploy_1.EcsApplication(this, 'EcsApplication', {
            applicationName,
        });
        const serviceToken = new aws_lambda_1.Function(this, 'Function', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'ecs-deployment-group')),
            handler: 'index.handler',
            timeout: core_1.Duration.minutes(15),
        });
        serviceToken.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: [
                'codeDeploy:CreateDeploymentGroup',
                'codeDeploy:UpdateDeploymentGroup',
                'codeDeploy:DeleteDeploymentGroup',
                'codeDeploy:TagResource',
                'codeDeploy:UntagResource',
            ],
            resources: ['*'],
        }));
        serviceToken.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['iam:PassRole'],
            resources: [codeDeployEcsRole.roleArn],
        }));
        this.deploymentConfig = deploymentConfig || ecs_deployment_config_1.EcsDeploymentConfig.ALL_AT_ONCE;
        if (core_1.Construct.isConstruct(props.deploymentConfig)) {
            this.node.addDependency(props.deploymentConfig);
        }
        this.node.addDependency(...ecsServices);
        const ecsDeploymentGroup = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: serviceToken.functionArn,
            resourceType: 'Custom::EcsDeploymentGroup',
            properties: {
                ApplicationName: this.application.applicationName,
                DeploymentGroupName: deploymentGroupName,
                ServiceRoleArn: codeDeployEcsRole.roleArn,
                TargetGroupNames: targetGroups.map((tg) => tg.targetGroupName),
                EcsServices: ecsServices.map((service) => ({
                    ClusterName: service.clusterName,
                    ServiceName: service.serviceName,
                })),
                ProdTrafficListenerArn: prodTrafficListener.listenerArn,
                TestTrafficListenerArn: testTrafficListener.listenerArn,
                TerminationWaitTimeInMinutes: terminationWaitTime.toMinutes(),
                AutoRollbackOnEvents: autoRollbackOnEvents,
                DeploymentConfigName: this.deploymentConfig.deploymentConfigName,
                Tags: core_1.Lazy.any({ produce: () => this.tags.renderTags() }),
            },
        });
        this.deploymentGroupName = ecsDeploymentGroup.ref;
        this.deploymentGroupArn = ecsDeploymentGroup.getAttString('Arn');
    }
}
exports.EcsDeploymentGroup = EcsDeploymentGroup;
_a = JSII_RTTI_SYMBOL_1;
EcsDeploymentGroup[_a] = { fqn: "@cloudcomponents/cdk-blue-green-container-deployment.EcsDeploymentGroup", version: "1.51.0" };
var RollbackEvent;
(function (RollbackEvent) {
    RollbackEvent["DEPLOYMENT_FAILURE"] = "DEPLOYMENT_FAILURE";
    RollbackEvent["DEPLOYMENT_STOP_ON_ALARM"] = "DEPLOYMENT_STOP_ON_ALARM";
    RollbackEvent["DEPLOYMENT_STOP_ON_REQUEST"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(RollbackEvent = exports.RollbackEvent || (exports.RollbackEvent = {}));
//# sourceMappingURL=data:application/json;base64,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